<?php
/**
 * ShipFromVendorInfo
 *
 * PHP version 5
 *
 * @category Class
 * @package  UPS\Shipping
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Ship
 *
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * 
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 3.0.50
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace UPS\Shipping\Shipping;

use \ArrayAccess;
use \UPS\Shipping\ObjectSerializer;

/**
 * ShipFromVendorInfo Class Doc Comment
 *
 * @category Class
 * @description Vendor Information Container
 * @package  UPS\Shipping
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class ShipFromVendorInfo implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'ShipFrom_VendorInfo';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'vendor_collect_id_type_code' => 'string',
        'vendor_collect_id_number' => 'string',
        'consignee_type' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'vendor_collect_id_type_code' => null,
        'vendor_collect_id_number' => null,
        'consignee_type' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'vendor_collect_id_type_code' => 'VendorCollectIDTypeCode',
        'vendor_collect_id_number' => 'VendorCollectIDNumber',
        'consignee_type' => 'ConsigneeType'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'vendor_collect_id_type_code' => 'setVendorCollectIdTypeCode',
        'vendor_collect_id_number' => 'setVendorCollectIdNumber',
        'consignee_type' => 'setConsigneeType'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'vendor_collect_id_type_code' => 'getVendorCollectIdTypeCode',
        'vendor_collect_id_number' => 'getVendorCollectIdNumber',
        'consignee_type' => 'getConsigneeType'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }



    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['vendor_collect_id_type_code'] = isset($data['vendor_collect_id_type_code']) ? $data['vendor_collect_id_type_code'] : null;
        $this->container['vendor_collect_id_number'] = isset($data['vendor_collect_id_number']) ? $data['vendor_collect_id_number'] : null;
        $this->container['consignee_type'] = isset($data['consignee_type']) ? $data['consignee_type'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['vendor_collect_id_type_code'] === null) {
            $invalidProperties[] = "'vendor_collect_id_type_code' can't be null";
        }
        if ($this->container['vendor_collect_id_number'] === null) {
            $invalidProperties[] = "'vendor_collect_id_number' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets vendor_collect_id_type_code
     *
     * @return string
     */
    public function getVendorCollectIdTypeCode()
    {
        return $this->container['vendor_collect_id_type_code'];
    }

    /**
     * Sets vendor_collect_id_type_code
     *
     * @param string $vendor_collect_id_type_code Code that identifies the type of Vendor Collect ID Number. Valid Values - 0356 = IOSS - 0357 = VOEC - 0358 = HMRC  Vendor Collect ID Number type code will be printed on commercial invoice if present.
     *
     * @return $this
     */
    public function setVendorCollectIdTypeCode($vendor_collect_id_type_code)
    {
        $this->container['vendor_collect_id_type_code'] = $vendor_collect_id_type_code;

        return $this;
    }

    /**
     * Gets vendor_collect_id_number
     *
     * @return string
     */
    public function getVendorCollectIdNumber()
    {
        return $this->container['vendor_collect_id_number'];
    }

    /**
     * Sets vendor_collect_id_number
     *
     * @param string $vendor_collect_id_number Shipper's VAT Tax collection registration number to be entered by Shipper at time of shipment creation. Presence of this number as part of the shipment information implies the shipper has collected/paid the required VAT tax (outside of UPS/UPS systems). Vendor Colect ID Number will be printed on commercial invoice if present.  Sample Values:   'IMDEU1234567' (IOSS #),  'VOEC1234567' (VOEC #),  'GB1234567' (HMRC #)  Required if the shipment is subject to Vendor Collect ID collection
     *
     * @return $this
     */
    public function setVendorCollectIdNumber($vendor_collect_id_number)
    {
        $this->container['vendor_collect_id_number'] = $vendor_collect_id_number;

        return $this;
    }

    /**
     * Gets consignee_type
     *
     * @return string
     */
    public function getConsigneeType()
    {
        return $this->container['consignee_type'];
    }

    /**
     * Sets consignee_type
     *
     * @param string $consignee_type Consignee Type. 01 = Business  02 = Consumer NA = Not Applicable
     *
     * @return $this
     */
    public function setConsigneeType($consignee_type)
    {
        $this->container['consignee_type'] = $consignee_type;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}
