<?php
/**
 * DeliveryLocationAddressArtifactFormat
 *
 * PHP version 5
 *
 * @category Class
 * @package  UPS\QuantumView
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Quantum View
 *
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * 
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 3.0.50
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace UPS\QuantumView\QuantumView;

use \ArrayAccess;
use \UPS\QuantumView\ObjectSerializer;

/**
 * DeliveryLocationAddressArtifactFormat Class Doc Comment
 *
 * @category Class
 * @description Information that specifies a physical location where package is delivered.
 * @package  UPS\QuantumView
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class DeliveryLocationAddressArtifactFormat implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'DeliveryLocation_AddressArtifactFormat';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'consignee_name' => 'string',
        'street_number_low' => 'string',
        'street_prefix' => 'string',
        'street_name' => 'string',
        'street_type' => 'string',
        'street_suffix' => 'string',
        'building_name' => 'string',
        'address_extended_information' => '\UPS\QuantumView\QuantumView\AddressArtifactFormatAddressExtendedInformation[]',
        'political_division3' => 'string',
        'political_division2' => 'string',
        'political_division1' => 'string',
        'country_code' => 'string',
        'postcode_primary_low' => 'string',
        'postcode_extended_low' => 'string',
        'residential_address_indicator' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'consignee_name' => null,
        'street_number_low' => null,
        'street_prefix' => null,
        'street_name' => null,
        'street_type' => null,
        'street_suffix' => null,
        'building_name' => null,
        'address_extended_information' => null,
        'political_division3' => null,
        'political_division2' => null,
        'political_division1' => null,
        'country_code' => null,
        'postcode_primary_low' => null,
        'postcode_extended_low' => null,
        'residential_address_indicator' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'consignee_name' => 'ConsigneeName',
        'street_number_low' => 'StreetNumberLow',
        'street_prefix' => 'StreetPrefix',
        'street_name' => 'StreetName',
        'street_type' => 'StreetType',
        'street_suffix' => 'StreetSuffix',
        'building_name' => 'BuildingName',
        'address_extended_information' => 'AddressExtendedInformation',
        'political_division3' => 'PoliticalDivision3',
        'political_division2' => 'PoliticalDivision2',
        'political_division1' => 'PoliticalDivision1',
        'country_code' => 'CountryCode',
        'postcode_primary_low' => 'PostcodePrimaryLow',
        'postcode_extended_low' => 'PostcodeExtendedLow',
        'residential_address_indicator' => 'ResidentialAddressIndicator'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'consignee_name' => 'setConsigneeName',
        'street_number_low' => 'setStreetNumberLow',
        'street_prefix' => 'setStreetPrefix',
        'street_name' => 'setStreetName',
        'street_type' => 'setStreetType',
        'street_suffix' => 'setStreetSuffix',
        'building_name' => 'setBuildingName',
        'address_extended_information' => 'setAddressExtendedInformation',
        'political_division3' => 'setPoliticalDivision3',
        'political_division2' => 'setPoliticalDivision2',
        'political_division1' => 'setPoliticalDivision1',
        'country_code' => 'setCountryCode',
        'postcode_primary_low' => 'setPostcodePrimaryLow',
        'postcode_extended_low' => 'setPostcodeExtendedLow',
        'residential_address_indicator' => 'setResidentialAddressIndicator'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'consignee_name' => 'getConsigneeName',
        'street_number_low' => 'getStreetNumberLow',
        'street_prefix' => 'getStreetPrefix',
        'street_name' => 'getStreetName',
        'street_type' => 'getStreetType',
        'street_suffix' => 'getStreetSuffix',
        'building_name' => 'getBuildingName',
        'address_extended_information' => 'getAddressExtendedInformation',
        'political_division3' => 'getPoliticalDivision3',
        'political_division2' => 'getPoliticalDivision2',
        'political_division1' => 'getPoliticalDivision1',
        'country_code' => 'getCountryCode',
        'postcode_primary_low' => 'getPostcodePrimaryLow',
        'postcode_extended_low' => 'getPostcodeExtendedLow',
        'residential_address_indicator' => 'getResidentialAddressIndicator'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }



    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['consignee_name'] = isset($data['consignee_name']) ? $data['consignee_name'] : null;
        $this->container['street_number_low'] = isset($data['street_number_low']) ? $data['street_number_low'] : null;
        $this->container['street_prefix'] = isset($data['street_prefix']) ? $data['street_prefix'] : null;
        $this->container['street_name'] = isset($data['street_name']) ? $data['street_name'] : null;
        $this->container['street_type'] = isset($data['street_type']) ? $data['street_type'] : null;
        $this->container['street_suffix'] = isset($data['street_suffix']) ? $data['street_suffix'] : null;
        $this->container['building_name'] = isset($data['building_name']) ? $data['building_name'] : null;
        $this->container['address_extended_information'] = isset($data['address_extended_information']) ? $data['address_extended_information'] : null;
        $this->container['political_division3'] = isset($data['political_division3']) ? $data['political_division3'] : null;
        $this->container['political_division2'] = isset($data['political_division2']) ? $data['political_division2'] : null;
        $this->container['political_division1'] = isset($data['political_division1']) ? $data['political_division1'] : null;
        $this->container['country_code'] = isset($data['country_code']) ? $data['country_code'] : null;
        $this->container['postcode_primary_low'] = isset($data['postcode_primary_low']) ? $data['postcode_primary_low'] : null;
        $this->container['postcode_extended_low'] = isset($data['postcode_extended_low']) ? $data['postcode_extended_low'] : null;
        $this->container['residential_address_indicator'] = isset($data['residential_address_indicator']) ? $data['residential_address_indicator'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['residential_address_indicator'] === null) {
            $invalidProperties[] = "'residential_address_indicator' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets consignee_name
     *
     * @return string
     */
    public function getConsigneeName()
    {
        return $this->container['consignee_name'];
    }

    /**
     * Sets consignee_name
     *
     * @param string $consignee_name Consignee's name at the location where package is delivered.
     *
     * @return $this
     */
    public function setConsigneeName($consignee_name)
    {
        $this->container['consignee_name'] = $consignee_name;

        return $this;
    }

    /**
     * Gets street_number_low
     *
     * @return string
     */
    public function getStreetNumberLow()
    {
        return $this->container['street_number_low'];
    }

    /**
     * Sets street_number_low
     *
     * @param string $street_number_low Street number where package is delivered.
     *
     * @return $this
     */
    public function setStreetNumberLow($street_number_low)
    {
        $this->container['street_number_low'] = $street_number_low;

        return $this;
    }

    /**
     * Gets street_prefix
     *
     * @return string
     */
    public function getStreetPrefix()
    {
        return $this->container['street_prefix'];
    }

    /**
     * Sets street_prefix
     *
     * @param string $street_prefix Street prefix where package is delivered, e.g. N, SE.
     *
     * @return $this
     */
    public function setStreetPrefix($street_prefix)
    {
        $this->container['street_prefix'] = $street_prefix;

        return $this;
    }

    /**
     * Gets street_name
     *
     * @return string
     */
    public function getStreetName()
    {
        return $this->container['street_name'];
    }

    /**
     * Sets street_name
     *
     * @param string $street_name Street name where package is delivered.
     *
     * @return $this
     */
    public function setStreetName($street_name)
    {
        $this->container['street_name'] = $street_name;

        return $this;
    }

    /**
     * Gets street_type
     *
     * @return string
     */
    public function getStreetType()
    {
        return $this->container['street_type'];
    }

    /**
     * Sets street_type
     *
     * @param string $street_type Street type where package is delivered.
     *
     * @return $this
     */
    public function setStreetType($street_type)
    {
        $this->container['street_type'] = $street_type;

        return $this;
    }

    /**
     * Gets street_suffix
     *
     * @return string
     */
    public function getStreetSuffix()
    {
        return $this->container['street_suffix'];
    }

    /**
     * Sets street_suffix
     *
     * @param string $street_suffix Street suffix where package is delivered, e.g. N, SE.
     *
     * @return $this
     */
    public function setStreetSuffix($street_suffix)
    {
        $this->container['street_suffix'] = $street_suffix;

        return $this;
    }

    /**
     * Gets building_name
     *
     * @return string
     */
    public function getBuildingName()
    {
        return $this->container['building_name'];
    }

    /**
     * Sets building_name
     *
     * @param string $building_name Building name where package is delivered.
     *
     * @return $this
     */
    public function setBuildingName($building_name)
    {
        $this->container['building_name'] = $building_name;

        return $this;
    }

    /**
     * Gets address_extended_information
     *
     * @return \UPS\QuantumView\QuantumView\AddressArtifactFormatAddressExtendedInformation[]
     */
    public function getAddressExtendedInformation()
    {
        return $this->container['address_extended_information'];
    }

    /**
     * Sets address_extended_information
     *
     * @param \UPS\QuantumView\QuantumView\AddressArtifactFormatAddressExtendedInformation[] $address_extended_information Container tag for additional address information where package is delivered.  **NOTE:** For versions >= v2, this element will always be returned as an array. For requests using version = v1, this element will be returned as an array if there is more than one object and a single object if there is only 1.
     *
     * @return $this
     */
    public function setAddressExtendedInformation($address_extended_information)
    {
        $this->container['address_extended_information'] = $address_extended_information;

        return $this;
    }

    /**
     * Gets political_division3
     *
     * @return string
     */
    public function getPoliticalDivision3()
    {
        return $this->container['political_division3'];
    }

    /**
     * Sets political_division3
     *
     * @param string $political_division3 The neighborhood, town, barrio etc.
     *
     * @return $this
     */
    public function setPoliticalDivision3($political_division3)
    {
        $this->container['political_division3'] = $political_division3;

        return $this;
    }

    /**
     * Gets political_division2
     *
     * @return string
     */
    public function getPoliticalDivision2()
    {
        return $this->container['political_division2'];
    }

    /**
     * Sets political_division2
     *
     * @param string $political_division2 City name where package is delivered.
     *
     * @return $this
     */
    public function setPoliticalDivision2($political_division2)
    {
        $this->container['political_division2'] = $political_division2;

        return $this;
    }

    /**
     * Gets political_division1
     *
     * @return string
     */
    public function getPoliticalDivision1()
    {
        return $this->container['political_division1'];
    }

    /**
     * Sets political_division1
     *
     * @param string $political_division1 Abbreviated state or province name where package is delivered.
     *
     * @return $this
     */
    public function setPoliticalDivision1($political_division1)
    {
        $this->container['political_division1'] = $political_division1;

        return $this;
    }

    /**
     * Gets country_code
     *
     * @return string
     */
    public function getCountryCode()
    {
        return $this->container['country_code'];
    }

    /**
     * Sets country_code
     *
     * @param string $country_code Abbreviated country or territory name where package is delivered.
     *
     * @return $this
     */
    public function setCountryCode($country_code)
    {
        $this->container['country_code'] = $country_code;

        return $this;
    }

    /**
     * Gets postcode_primary_low
     *
     * @return string
     */
    public function getPostcodePrimaryLow()
    {
        return $this->container['postcode_primary_low'];
    }

    /**
     * Sets postcode_primary_low
     *
     * @param string $postcode_primary_low Postal Code where package is delivered. Required if the user does not submit the City, Alphanumeric State/Province address combination.
     *
     * @return $this
     */
    public function setPostcodePrimaryLow($postcode_primary_low)
    {
        $this->container['postcode_primary_low'] = $postcode_primary_low;

        return $this;
    }

    /**
     * Gets postcode_extended_low
     *
     * @return string
     */
    public function getPostcodeExtendedLow()
    {
        return $this->container['postcode_extended_low'];
    }

    /**
     * Sets postcode_extended_low
     *
     * @param string $postcode_extended_low 4 Digit postal code extension where package is delivered. Valid for US only.
     *
     * @return $this
     */
    public function setPostcodeExtendedLow($postcode_extended_low)
    {
        $this->container['postcode_extended_low'] = $postcode_extended_low;

        return $this;
    }

    /**
     * Gets residential_address_indicator
     *
     * @return string
     */
    public function getResidentialAddressIndicator()
    {
        return $this->container['residential_address_indicator'];
    }

    /**
     * Sets residential_address_indicator
     *
     * @param string $residential_address_indicator Residential address indicator for the location where package is delivered. The presence indicates residential address, the absence indicates a business address.
     *
     * @return $this
     */
    public function setResidentialAddressIndicator($residential_address_indicator)
    {
        $this->container['residential_address_indicator'] = $residential_address_indicator;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}
