<?php
/**
 * ShipmentPackage
 *
 * PHP version 5
 *
 * @category Class
 * @package  UPS\DangerousGoods
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Dangerous Goods Utility
 *
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * 
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 3.0.50
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace UPS\DangerousGoods\DangerousGoods;

use \ArrayAccess;
use \UPS\DangerousGoods\ObjectSerializer;

/**
 * ShipmentPackage Class Doc Comment
 *
 * @category Class
 * @description Package Information container.
 * @package  UPS\DangerousGoods
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class ShipmentPackage implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'Shipment_Package';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'package_identifier' => 'string',
        'package_weight' => '\UPS\DangerousGoods\DangerousGoods\PackagePackageWeight',
        'q_value' => 'string',
        'over_packed_indicator' => 'string',
        'transportation_mode' => 'string',
        'emergency_phone' => 'string',
        'emergency_contact' => 'string',
        'chemical_record' => '\UPS\DangerousGoods\DangerousGoods\PackageChemicalRecord[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'package_identifier' => null,
        'package_weight' => null,
        'q_value' => null,
        'over_packed_indicator' => null,
        'transportation_mode' => null,
        'emergency_phone' => null,
        'emergency_contact' => null,
        'chemical_record' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'package_identifier' => 'PackageIdentifier',
        'package_weight' => 'PackageWeight',
        'q_value' => 'QValue',
        'over_packed_indicator' => 'OverPackedIndicator',
        'transportation_mode' => 'TransportationMode',
        'emergency_phone' => 'EmergencyPhone',
        'emergency_contact' => 'EmergencyContact',
        'chemical_record' => 'ChemicalRecord'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'package_identifier' => 'setPackageIdentifier',
        'package_weight' => 'setPackageWeight',
        'q_value' => 'setQValue',
        'over_packed_indicator' => 'setOverPackedIndicator',
        'transportation_mode' => 'setTransportationMode',
        'emergency_phone' => 'setEmergencyPhone',
        'emergency_contact' => 'setEmergencyContact',
        'chemical_record' => 'setChemicalRecord'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'package_identifier' => 'getPackageIdentifier',
        'package_weight' => 'getPackageWeight',
        'q_value' => 'getQValue',
        'over_packed_indicator' => 'getOverPackedIndicator',
        'transportation_mode' => 'getTransportationMode',
        'emergency_phone' => 'getEmergencyPhone',
        'emergency_contact' => 'getEmergencyContact',
        'chemical_record' => 'getChemicalRecord'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }



    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['package_identifier'] = isset($data['package_identifier']) ? $data['package_identifier'] : null;
        $this->container['package_weight'] = isset($data['package_weight']) ? $data['package_weight'] : null;
        $this->container['q_value'] = isset($data['q_value']) ? $data['q_value'] : null;
        $this->container['over_packed_indicator'] = isset($data['over_packed_indicator']) ? $data['over_packed_indicator'] : null;
        $this->container['transportation_mode'] = isset($data['transportation_mode']) ? $data['transportation_mode'] : null;
        $this->container['emergency_phone'] = isset($data['emergency_phone']) ? $data['emergency_phone'] : null;
        $this->container['emergency_contact'] = isset($data['emergency_contact']) ? $data['emergency_contact'] : null;
        $this->container['chemical_record'] = isset($data['chemical_record']) ? $data['chemical_record'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['package_identifier'] === null) {
            $invalidProperties[] = "'package_identifier' can't be null";
        }
        if ($this->container['package_weight'] === null) {
            $invalidProperties[] = "'package_weight' can't be null";
        }
        if ($this->container['chemical_record'] === null) {
            $invalidProperties[] = "'chemical_record' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets package_identifier
     *
     * @return string
     */
    public function getPackageIdentifier()
    {
        return $this->container['package_identifier'];
    }

    /**
     * Sets package_identifier
     *
     * @param string $package_identifier Identifies the package containing Dangerous Goods.
     *
     * @return $this
     */
    public function setPackageIdentifier($package_identifier)
    {
        $this->container['package_identifier'] = $package_identifier;

        return $this;
    }

    /**
     * Gets package_weight
     *
     * @return \UPS\DangerousGoods\DangerousGoods\PackagePackageWeight
     */
    public function getPackageWeight()
    {
        return $this->container['package_weight'];
    }

    /**
     * Sets package_weight
     *
     * @param \UPS\DangerousGoods\DangerousGoods\PackagePackageWeight $package_weight package_weight
     *
     * @return $this
     */
    public function setPackageWeight($package_weight)
    {
        $this->container['package_weight'] = $package_weight;

        return $this;
    }

    /**
     * Gets q_value
     *
     * @return string
     */
    public function getQValue()
    {
        return $this->container['q_value'];
    }

    /**
     * Sets q_value
     *
     * @param string $q_value This is required when a HazMat shipment specifies AllPackedInOneIndicator and the regulation set for that shipment is IATA.   Valid values: 0.1; 0.2; 0.3; 0.4; 0.5; 0.6; 0.7; 0.8; 0.9; 1.0
     *
     * @return $this
     */
    public function setQValue($q_value)
    {
        $this->container['q_value'] = $q_value;

        return $this;
    }

    /**
     * Gets over_packed_indicator
     *
     * @return string
     */
    public function getOverPackedIndicator()
    {
        return $this->container['over_packed_indicator'];
    }

    /**
     * Sets over_packed_indicator
     *
     * @param string $over_packed_indicator Presence/Absence Indicator. Any value is ignored. Presence indicates that shipment is over pack.
     *
     * @return $this
     */
    public function setOverPackedIndicator($over_packed_indicator)
    {
        $this->container['over_packed_indicator'] = $over_packed_indicator;

        return $this;
    }

    /**
     * Gets transportation_mode
     *
     * @return string
     */
    public function getTransportationMode()
    {
        return $this->container['transportation_mode'];
    }

    /**
     * Sets transportation_mode
     *
     * @param string $transportation_mode The method of transport by which a shipment is approved to move and the regulations associated with that method.    Only required when the CommodityRegulatedLevelCode is FR or LQ.  Valid entries include: GND, CAO, and PAX.
     *
     * @return $this
     */
    public function setTransportationMode($transportation_mode)
    {
        $this->container['transportation_mode'] = $transportation_mode;

        return $this;
    }

    /**
     * Gets emergency_phone
     *
     * @return string
     */
    public function getEmergencyPhone()
    {
        return $this->container['emergency_phone'];
    }

    /**
     * Sets emergency_phone
     *
     * @param string $emergency_phone 24 Hour Emergency Phone Number of the shipper.  Valid values for this field are (0) through (9) with trailing blanks.  For numbers within the U.S., the layout is 1, area code, 7-digit number. For all other countries or territories the layout is country or territory code, area code, number.  The Emergency Phone Number can only include the following allowable characters “period “.”, dash “-“, plus sign “+” and conventional parentheses “(“ and “)”, “EXT or OPT”  Required when (TDG regulation set and CommodityRegulatedLevelCode = FR)
     *
     * @return $this
     */
    public function setEmergencyPhone($emergency_phone)
    {
        $this->container['emergency_phone'] = $emergency_phone;

        return $this;
    }

    /**
     * Gets emergency_contact
     *
     * @return string
     */
    public function getEmergencyContact()
    {
        return $this->container['emergency_contact'];
    }

    /**
     * Sets emergency_contact
     *
     * @param string $emergency_contact The emergency information, contact name and/or contract number, required to be communicated when a call is placed to the EmergencyPhone.  The information is required if there is a value in the EmergencyPhone field above and the shipment is with a US50 or PR origin and/or destination and the RegulationSet is IATA.
     *
     * @return $this
     */
    public function setEmergencyContact($emergency_contact)
    {
        $this->container['emergency_contact'] = $emergency_contact;

        return $this;
    }

    /**
     * Gets chemical_record
     *
     * @return \UPS\DangerousGoods\DangerousGoods\PackageChemicalRecord[]
     */
    public function getChemicalRecord()
    {
        return $this->container['chemical_record'];
    }

    /**
     * Sets chemical_record
     *
     * @param \UPS\DangerousGoods\DangerousGoods\PackageChemicalRecord[] $chemical_record chemical_record
     *
     * @return $this
     */
    public function setChemicalRecord($chemical_record)
    {
        $this->container['chemical_record'] = $chemical_record;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}
