<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2022 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

class ModelExtensionInfoBanner extends Model {

    /**
     * @param $customer_group_id
     * @return mixed
     */
    public function getInfoBannerSettings($layout_id) {
        $store_id = $this->getStoreId();
        if (is_object($this->customer) && $this->customer->isLogged()) {
            $customer_group_id = (int)$this->customer->getCustomerGroupId();
        } else {
            $customer_group_id = (int)$this->config->get('config_customer_group_id');
        }
        $language_id = $this->language->getContentLanguageID() ?? $this->language->getLanguageID();
        $sql = "SELECT * FROM ".$this->db->table("info_banner")." info 
                LEFT JOIN ".$this->db->table("info_banner_description")." info_description ON info_description.info_banner_id = info.info_banner_id
                LEFT JOIN ".$this->db->table("info_banner_to_layouts")." info_layouts ON info_layouts.info_banner_id = info.info_banner_id
                LEFT JOIN ".$this->db->table("info_banner_to_customer_groups")." info_customer_group ON info_customer_group.info_banner_id = info.info_banner_id
                WHERE info_layouts.layout=".(int)$layout_id." AND info.store_id=".$store_id." AND info_description.language_id=".$language_id." AND info_customer_group.customer_group_id=".$customer_group_id." AND info.status ='1'
                AND (NOW() BETWEEN CASE WHEN info.start_date IS NULL THEN NOW() ELSE info.start_date END
                        AND
                        CASE WHEN info.end_date IS NULL THEN  NOW() + INTERVAL 1 MONTH ELSE info.end_date END)
                ORDER BY info.sort_order ASC";
        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getStoreId() {
        $store_id = (int)$this->config->get('config_store_id');
        if (has_value($this->request->get_or_post('store_id'))) {
            $store_id = (int)$this->request->get_or_post('store_id');
        } else {
            if ($this->session->data['current_store_id']) {
                $store_id = (int)$this->session->data['current_store_id'];
            }
        }
        return $store_id;
    }

}