<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2022 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/
if (!defined('DIR_CORE') || !IS_ADMIN) {
    header('Location: static_pages/');
}

require_once DIR_SYSTEM . "lib/vendor/autoload.php";
require_once DIR_SYSTEM . "lib/license.php";

/**
 * Class ControllerResponsesListingGridInfoBanner
 * @property ModelExtensionInfoBanner $model_extension_info_banner
 * @property ModelExtensionInfoBannerLicenseInfo $model_extension_info_banner_license_info
 */
class ControllerResponsesListingGridInfoBanner extends AController {
    public $data = [];

    public function verify() {
        $this->load->model('extension/info_banner_license_info');
        $license_key = $this->config->get('info_banner_license_code');
        if ($license_key) {
            $exist = $this->db->query("SHOW TABLES LIKE '" . $this->db->table('info_banner_license_info') . "'");
            if ($exist->num_rows === 1) {
                $store_id = $this->model_extension_info_banner_license_info->getStoreId();
                $license_key = $this->model_extension_info_banner_license_info->getLicenseCode($store_id);
                $license_info = $this->model_extension_info_banner_license_info->getLicenseData($store_id);
                $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                $license = new License($path_to_phpseclib);
                $license_manager = $license->getManager();
                $license_manager->setKeys($license_key, $license_info['public_key'], 'info_banner');
                $ttl = 1209600;
                $validate = $license_manager->validate($license_info['license_data'], $ttl);
                $store_status = $this->model_extension_info_banner_license_info->getLicensedStoreStatus();
                if ($validate['status'] === 'valid' && $store_status == 1) {
                    return true;
                } else {
                    return false;
                }
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    public function main() {
	    //init controller data
	    $this->extensions->hk_InitData( $this, __FUNCTION__ );
        if ($this->verify()) {
		    $this->loadLanguage( 'info_banner/info_banner' );
		    $this->loadLanguage( 'catalog/product' );
		    $this->loadModel( 'catalog/product' );
		    $this->loadModel( 'tool/image' );
		    $this->loadModel( 'extension/info_banner' );

		    //Prepare filter config
		    $filter_params      = [ 'id','title','status' ];
		    $grid_filter_params = [ 'id','title','status' ];

		    $filter_form = new AFilter( [ 'method' => 'get', 'filter_params' => $filter_params ] );
		    $filter_grid = new AFilter( [ 'method' => 'post', 'grid_filter_params' => $grid_filter_params ] );
		    $data        = array_merge( $filter_form->getFilterData(), $filter_grid->getFilterData() );
		    $total                       = $this->model_extension_info_banner->getTotalInfoBanner( $data );
		    $response                    = new stdClass();
		    $response->page              = $filter_grid->getParam( 'page' );
		    $response->total             = $filter_grid->calcTotalPages( $total );
		    $response->records           = $total;
		    $response->userdata          = new stdClass();
		    $response->userdata->classes = [];
		    $results                     = $this->model_extension_info_banner->getAllInfoBanner( $data );

            $i          = 0;
		    foreach ( $results as $result ) {
                $layout_name = $this->model_extension_info_banner->getLayoutName($result['info_banner_id']);
                $customer_groups = $this->model_extension_info_banner->getCustomerGroups($result['info_banner_id']);
			    $response->rows[ $i ]['id'] = $result['info_banner_id'];
			    $response->rows[ $i ]['cell'] = [
                    $result['info_banner_id'],
                    $result['title'],
                    $result['status']==='1' ? $this->language->get('text_on') : $this->language->get('text_off'),
                    $result['sort_order'],
                    html_entity_decode($layout_name),
                    html_entity_decode($customer_groups)
		        ];
			    $i ++;
		    }
		    $this->data['response'] = $response;
		    //update controller data
		    $this->extensions->hk_UpdateData( $this, __FUNCTION__ );
		    $this->load->library( 'json' );
		    $this->response->setOutput( AJson::encode( $this->data['response'] ) );
	    }
    }

    public function update_field() {
        //init controller data
        $this->extensions->hk_InitData($this, __FUNCTION__);

        /** @var ModelDesignEmailTemplate $mdl */
        $mdl = $this->loadModel('extension/info_banner');

        if ($this->request->is_POST()) {
            $post = $this->request->post;
            foreach ((array) $post as $key => $value) {
                $mdl->update($key,  $value);
            }
        }

        //update controller data
        $this->extensions->hk_UpdateData($this, __FUNCTION__);
    }

    public function update() {
        //init controller data
        $this->extensions->hk_InitData($this, __FUNCTION__);

        /** @var ModelDesignEmailTemplate $mdl */
        $mdl = $this->loadModel('extension/info_banner');

        if ($this->request->is_POST()) {
            $post = $this->request->post;

            if ($post['oper'] === 'del' && isset($post['id'])) {
                $ids = array_unique(explode(',', $post['id']));
                foreach ($ids as $id) {
                    $mdl->deleteInfoBanner($id);
                }
            }
        }

        //update controller data
        $this->extensions->hk_UpdateData($this, __FUNCTION__);
    }

}