<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com
  Copyright (c) 2014-2021 We Hear You 2, Inc.  (WHY2)
------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

require_once DIR_EXT. "telephone_option" . DIR_EXT_CORE ."helpers.php";
require_once DIR_EXT. "telephone_option" . DIR_EXT_CORE ."updater.php";

/**
 * Class ExtensionTelephoneOption
 * @property AController baseObject
 * @property ModelAccountTelephone $model_account_telephone
 */
class ExtensionTelephoneOption extends Extension {
    public $data = [];
    public $errors = [];
    private $error=[];
    protected $registry;
    public $zeroDates = [
        '0000-00-00 00:00:00',
        '1970-01-01 00:00:00',
    ];

    private $address_fields = [
        'firstname' => [
            'type' => 'input',
            'required' => true
        ],
        'lastname' => [
            'type' => 'input',
            'required' => true
        ],
        'company' => [
            'type' => 'input',
            'required' => false
        ],
        'address_1' => [
            'type' => 'input',
            'required' => true
        ],
        'address_2' => [
            'type' => 'input',
            'required' => false
        ],
        'city' => [
            'type' => 'input',
            'required' => true
        ],
        'postcode' => [
            'type' => 'input',
            'required' => false
        ],
        //note! this field is pair of country_id and zone_id
        'country_id' => [
            'type' => 'zones',
            'required' => true]
    ];

    public function  __construct() {
        $this->registry = Registry::getInstance();
    }

    private function _is_enabled() {
        return $this->baseObject->config->get('telephone_option_status') ? $this->verify() : false;
    }

	public function verify() {
		$that =& $this->baseObject;
		$exist = $that->db->query("SHOW TABLES LIKE '".$that->db->table('telephone_license')."'");
		if ($exist->num_rows === 1) {
			$validation = telephoneVerifyLicense();
			if ( $validation['notification_case'] === 'notification_license_ok' ) {
				return true;
			} elseif ( $validation['notification_case'] === 'notification_license_corrupted' ) {
				return false;
			}
		} else {
			return false;
		}
	}

    public function verifyUpsPlus() {
        $that =& $this->baseObject;
        if ( $that->config->get( 'ups_integration_plus_status' ) === '1' ) {
            $exist = $that->db->query( "SHOW TABLES LIKE '" . $that->db->table( 'ups_integration_plus_license' ) . "'" );
            if ( $exist->num_rows === 1 ) {
                $validation = upsIntegrationPlusVerifyLicense();
                if ( $validation['notification_case'] === 'notification_license_ok' ) {
                    return true;
                } elseif ( $validation['notification_case'] === 'notification_license_corrupted' ) {
                    return false;
                }
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    public function verifyOptionPriceLink() {
        $that =& $this->baseObject;
        if ( $that->config->get( 'option_price_link_pro_status' ) === '1' ) {
            $exist = $that->db->query("SHOW TABLES LIKE '" . $that->db->table('option_link_license') . "'");
            if ($exist->num_rows === 1) {
                $validation = optionLinkVerifyLicense();
                if ($validation['notification_case'] === 'notification_license_ok') {
                    return true;
                } elseif ($validation['notification_case'] === 'notification_license_corrupted') {
                    return false;
                }
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    public function verifyAdvancedReports() {
        $that =& $this->baseObject;
        if ( $that->config->get( 'advanced_reports_status' ) === '1' ) {
            $exist = $that->db->query("SHOW TABLES LIKE '".$that->db->table('advanced_reports_license')."'");
            if ($exist->num_rows === 1) {
                $validation = advancedReportsVerifyLicense();
                if ( $validation['notification_case'] === 'notification_license_ok' ) {
                    return true;
                } elseif ( $validation['notification_case'] === 'notification_license_corrupted' ) {
                    return false;
                }
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

	public function onControllerPagesExtensionExtensions_InitData() {
		$that =& $this->baseObject;
		if ($this->baseObject_method === 'edit') {
			$extension=$that->request->get['extension'];
			if ($extension==='telephone_option') {
				if ($that->request->is_POST() ) {
					$exist = $that->db->query("SHOW TABLES LIKE '".$that->db->table('telephone_license')."'");
					if ($exist->num_rows === 1) {
						if ($this->verify()===true) {
							telephoneUninstallLicense();
						} else {
							$that->db->query("DROP TABLE IF EXISTS ".$that->db->table('telephone_license'));
						}
						telephoneInstallLicense( $that->request->post['telephone_option_license_code'] );
					} else {
						$license = telephoneInstallLicense( $that->request->post['telephone_option_license_code'] );
						if ( $license['notification_case'] !== 'notification_license_ok' ) {
							$that->session->data['error'] = $license['notification_text'];
						} else {
							$that->session->data['success'] = "The license key is valid";
						}
					}
				}
			}
		}
	}

	public function onControllerResponsesListingGridExtension_UpdateData() {
		$that =& $this->baseObject;
		if ($this->baseObject_method==='update') {
			if ($that->request->post['telephone_option_license_code']) {
				$exist = $that->db->query("SHOW TABLES LIKE '".$that->db->table('telephone_license')."'");
				if ($exist->num_rows === 1) {
					if ($this->verify()===true) {
						telephoneUninstallLicense();
					} else {
						$that->db->query("DROP TABLE IF EXISTS ".$that->db->table('telephone_license'));
					}
					telephoneInstallLicense( $that->request->post['telephone_option_license_code'] );
				} else {
					$license = telephoneInstallLicense( $that->request->post['telephone_option_license_code'] );
					if ( $license['notification_case'] !== 'notification_license_ok' ) {
						$that->session->data['error'] = $license['notification_text'];
					} else {
						$that->session->data['success'] = "The license key is valid";
					}
				}
			}
		}
	}

    //Hook Guest Step 1 Validation
    public function onControllerPagesCheckoutGuestStep1_ValidateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        $that->loadLanguage('checkout/guest_step_1');
        $that->loadLanguage('account/telephone');
        $telephone = $that->request->post['telephone'];
        $fax = $that->request->post['fax'];
        $company = $that->request->post['company'];
        $shipping_company = $that->request->post['shipping_company'];
        $default_local_delivery_status = $that->config->get('default_local_delivery_status');
        if ($that->config->get('telephone_option_mandatory_status')) {
            $pattern = $that->config->get('config_phone_validation_pattern') ?: '/^[0-9]{3,32}$/';
            if ($telephone === ''
                && (mb_strlen($telephone) < 3
                    || mb_strlen($telephone) > 32
                    || !preg_match($pattern, $telephone))
            ) {
                 $that->error['telephone'] = $that->language->get('telephone_error');
            }
        } elseif ($default_local_delivery_status) {
            $telephone_error = $that->error['telephone'];
            $that->error['telephone'] = $telephone_error;
        }
        if ($that->config->get('fax_option_mandatory_status')
            && $that->config->get('fax_option_show')) {
            if (empty($fax) || ((mb_strlen($fax) < 3 || mb_strlen($fax) > 32) && strtolower($fax) != 'na' && strtolower($fax) != 'none')) {
                $that->error['fax'] = $that->language->get('fax_error');
            }
        }
        if ($that->config->get('company_option_mandatory_status')) {
            if ($company == '') {
                $that->error['company'] = $that->language->get('company_error');
            }
            if ($that->request->post['shipping_indicator']) {
                if ($shipping_company == '') {
                    $that->error['shipping_company'] = $that->language->get('company_error');
                }
            }
        }
        if (count($that->error)) {
            $that->view->assign('error_warning', $that->language->get('gen_data_entry_error'));
        }
    }

    public function onControllerPagesCheckoutGuestStep1_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
	    $that =& $this->baseObject;
	        $form = new AForm();
		    $form->setForm( ['form_name' => 'guestFrm' ] );
		    $that->loadLanguage( 'account/telephone' );
		    $field_errors = $that->error;

		    if ( $field_errors ) {
			    foreach ( $field_errors as $key => $field_error ) {
				    $that->view->assign( 'error_' . $key, $field_error );
			    }
		    }

        $form=$that->view->getData('form');

        if (isset($that->request->post['telephone'])) {
            $telephone = $that->request->post['telephone'];
        } elseif (isset($that->session->data['guest']['telephone'])) {
            $telephone = $that->session->data['guest']['telephone'];
        } else {
            $telephone = '';
        }
        $default_local_delivery_status = $that->config->get('default_local_delivery_status');

        $form['fields']['general']['telephone'] = $that->html->buildInput(
            [
                'name' => 'telephone',
                'value' => $telephone,
                'required' => $that->config->get('telephone_option_mandatory_status') || $default_local_delivery_status
            ]);

        $show_fax = $that->config->get('fax_option_show');
        if ($show_fax === '1') {
            if (isset($that->request->post['fax'])) {
                $fax = $that->request->post['fax'];
            } elseif (isset($that->session->data['guest']['fax'])) {
                $fax = $that->session->data['guest']['fax'];
            } else {
                $fax = '';
            }

            $form['fields']['general']['fax'] = $that->html->buildInput(
                [
                    'name' => 'fax',
                    'value' => $fax,
                    'placeholder' => $that->config->get('fax_option_placeholder'),
                    'required' => $that->config->get('fax_option_mandatory_status')
                ]);
        }
        if (isset($that->request->post['company'])) {
            $company = $that->request->post['company'];
        } elseif (isset($that->session->data['guest']['company'])) {
            $company = $that->session->data['guest']['company'];
        } else {
            $company = '';
        }

        $form['fields']['address']['company'] = $that->html->buildInput(
            [
                'name' => 'company',
                'value' => $company,
                'required' => false,
                'placeholder' => $that->config->get('company_option_placeholder'),
                'required' => $that->config->get('company_option_mandatory_status')
            ]);

        if (isset($that->request->post['shipping_company'])) {
            $shipping_company = $that->request->post['shipping_company'];
        } elseif (isset($that->session->data['guest']['shipping']['company'])) {
            $shipping_company = $that->session->data['guest']['shipping']['company'];
        } else {
            $shipping_company = '';
        }
        $form['fields']['shipping']['shipping_company'] = $that->html->buildInput(
            [
                'name' => 'shipping_company',
                'value' => $shipping_company,
                'placeholder' => $that->config->get('company_option_placeholder'),
                'required' => ($that->config->get('company_option_mandatory_status') == '1') ? true : false
            ]);
        $that->view->assign('form',$form);
    }

    public function onControllerPagesCheckoutConfirm_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
	    $that =& $this->baseObject;
        if ($this->baseObject_method === 'main') {

            $payment_address = $that->model_account_address->getAddress($that->session->data['payment_address_id']);
            $shipping_address = $that->model_account_address->getAddress($that->session->data['shipping_address_id']);
            if ($payment_address['company'] !== '' && strtolower($payment_address['company']) !== 'na' && strtolower($payment_address['company'] !== 'none')) {
                $that->view->addHookVar('checkout_confirm_payment_info_pre_2', $payment_address['company'].'<br>');
            }
            if ($shipping_address['company'] !== '' && strtolower($shipping_address['company']) !== 'na' && strtolower($shipping_address['company'] !== 'none')) {
                $that->view->addHookVar('checkout_confirm_shipping_info_pre_2', $shipping_address['company'].'<br>');
            }
            $fax = $that->customer->getFax();
            if ($fax!=='' && strtolower($fax)!=='na' && strtolower($fax)!=='none') {
                if ($that->customer->getTelephone()) {
                    $that->view->assign('telephone',$that->data['telephone'].'<br>'.$fax);
                } else {
                    $that->view->assign('telephone',$fax);
                }
            }
        }
    }

    public function onControllerPagesCheckoutGuestStep3_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'main') {
            $payment_address = $that->session->data['guest'];
            $shipping_address = $that->session->data['guest']['shipping'];
            if ($payment_address['company'] !== '' && strtolower($payment_address['company']) !== 'na' && strtolower($payment_address['company'] !== 'none')) {
                $that->view->addHookVar('checkout_confirm_payment_info_pre_2', $payment_address['company'].'<br>');
            }
            if ($shipping_address && $shipping_address['company'] !== '' && strtolower($shipping_address['company']) !== 'na' && strtolower($shipping_address['company'] !== 'none')) {
                $that->view->addHookVar('checkout_confirm_shipping_info_pre_2', $shipping_address['company'] . '<br>');
            }
            $phone = $that->session->data['guest']['telephone'];
            $fax = $that->session->data['guest']['fax'];
            if ($fax!=='' && strtolower($fax)!=='na' && strtolower($fax)!=='none') {
                if ($phone!=='') {
                    $that->view->assign('telephone',$that->data['telephone'].'<br>'.$fax);
                } else {
                    $that->view->assign('telephone',$fax);
                }
            }
        }
    }

    //Hook Create new shipping address, new payment address,create new address, edit address validation
    public function onModelAccountAddress_ValidateData(){
        if (!$this->_is_enabled()) {
            return null;
        }
	    $that =& $this->baseObject;
        $that->load->language('account/address');
        $that->load->language('account/telephone');
        $that->load->language('checkout/guest_step_1');
        if ($that->config->get('company_option_mandatory_status') === '1') {
            if ((mb_strlen($that->request->post['company']) === 0)) {
                $that->error['company'] = $that->language->get('company_error');
            }
        }
        if (count($that->error)) {
            $that->error('error_warning', $that->language->get('gen_data_entry_error'));
        }
    }

    public function onControllerPagesCheckoutAddress_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method == 'shipping') {
            $form = $that->view->getData('form');
            $that->view->assign('error_company',$that->error['company']);
            $form['company'] = $that->html->buildInput(
                [
                    'name' => 'company',
                    'value' => $that->request->post['company'],
                    'placeholder' => $that->config->get('company_option_placeholder'),
                    'required' => ($that->config->get('company_option_mandatory_status') == '1') ? true : false
                ]);
            $that->view->assign('form', $form);
        } elseif ($this->baseObject_method == 'payment') {
            $form = $that->view->getData('form');
            $that->view->assign('error_company',$that->error['company']);
            $form['company'] = $that->html->buildInput(
                [
                    'name' => 'company',
                    'value' => $that->request->post['company'],
                    'placeholder' => $that->config->get('company_option_placeholder'),
                    'required' => ($that->config->get('company_option_mandatory_status') == '1') ? true : false
                ]);
            $that->view->assign('form', $form);
        }
    }

    //Hook Create new account,edit account validation
    public function onModelAccountCustomer_ValidateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        $telephone = $that->request->post['telephone'];
        $fax = $that->request->post['fax'];
        $company = $that->request->post['company'];
        $that->load->language('account/create');
        $that->load->language('checkout/guest_step_1');
        $that->load->language('account/telephone');
        $rt = $that->request->get['rt'];
        if ($rt === 'account/create') {
            if ($that->config->get('telephone_option_mandatory_status') === '1') {
                if (empty($telephone) || (mb_strlen($telephone) < 3) || (mb_strlen($telephone) > 32)) {
                    $that->error['telephone'] = $that->language->get('telephone_error');
                }
            }
            if ($that->config->get('fax_option_mandatory_status') === '1'
                && $that->config->get('fax_option_show') === '1') {
                if (empty($fax) || ((mb_strlen($fax) < 3 || mb_strlen($fax) > 32) && strtolower($fax) != 'na' && strtolower($fax) != 'none')) {
                    $that->error['fax'] = $that->language->get('fax_error');
                }
            }
            if ($that->config->get('company_option_mandatory_status') === '1') {
                if (empty($company) && strtolower($company) !== 'na' && strtolower($company) !== 'none') {
                    $that->error['company'] = $that->language->get('company_error');
                }
            }
        } elseif ($rt === 'account/edit') {
            if ($that->config->get('telephone_option_mandatory_status') === '1') {
                if (empty($telephone) || (mb_strlen($telephone) < 3) || (mb_strlen($telephone) > 32)) {
                    $that->error['telephone'] = $that->language->get('telephone_error');
                }
            }
            if ($that->config->get('fax_option_mandatory_status') === '1'
                && $that->config->get('fax_option_show') === '1') {
                if (empty($fax) || ((mb_strlen($fax) < 3 || mb_strlen($fax) > 32) && strtolower($fax) != 'na' && strtolower($fax) != 'none')) {
                    $that->error['fax'] = $that->language->get('fax_error');
                }
            }
            if (count($that->error)) {
                $that->error['warning'] = $that->language->get('gen_data_entry_error');
            }
        }
    }

    public function onControllerPagesAccountCreate_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
	    $that =& $this->baseObject;
        if ($this->baseObject_method === 'main') {
            $data = [];
            $that->loadModel('account/telephone');
            $that->load->language('account/telephone');
            $form = $that->view->getData('form');
            $that->view->assign('error_telephone', $that->errors['telephone']);
            $that->view->assign('error_fax', $that->errors['fax']);
            $that->view->assign('error_company', $that->errors['company']);

            $form['fields']['general']['telephone'] = $that->html->buildInput(
                [
                    'name' => 'telephone',
                    'value' => $that->request->post['telephone'],
                    'required' => ($that->config->get('telephone_option_mandatory_status') == '1') ? true : false
                ]);
            $show_fax = $that->config->get('fax_option_show');
            if ($show_fax === '1') {
                $form['fields']['general']['fax'] = $that->html->buildInput(
                    [
                        'name' => 'fax',
                        'value' => $that->request->post['fax'],
                        'placeholder' => $that->config->get('fax_option_placeholder'),
                        'required' => ($that->config->get('fax_option_mandatory_status') == '1') ? true : false
                    ]);
            } else {
                unset($form['fields']['general']['fax']);
            }

            $form['fields']['address']['company'] = $that->html->buildInput(
                [
                    'name' => 'company',
                    'value' => $that->request->post['company'],
                    'placeholder' => $that->config->get('company_option_placeholder'),
                    'required' => ($that->config->get('company_option_mandatory_status') == '1') ? true : false
                ]);
            $that->view->assign('form', $form);
        }
    }

    public function onControllerPagesAccountEdit_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
	    $that =& $this->baseObject;
	        if ( $this->baseObject_method === 'main' ) {
			    $that->loadModel( 'account/telephone' );
			    $that->loadLanguage( 'account/telephone' );

			    $that->view->assign('error_telephone',  $that->error['telephone']);
			    $that->view->assign('error_fax',        $that->error['fax']);

			    if ( $that->request->is_GET() ) {
				    $customer_info                    = $that->model_account_customer->getCustomer( $that->customer->getId() );
				    $that->session->data['loginname'] = $customer_info['loginname'];
			    }

			    $request_data = $that->request->post;

                $form=$that->view->getData('form');

			    if ( isset( $request_data['telephone'] ) ) {
				    $telephone = $request_data['telephone'];
			    } elseif ( isset( $customer_info ) ) {
				    $telephone = $customer_info['telephone'];
			    } elseif ( $request_data['telephone'] == '' ) {
				    $telephone = '';
			    }

                $form['fields']['telephone'] = $that->html->buildInput(
				    [
					    'name'     => 'telephone',
					    'value'    => $telephone,
					    'required' => ( $that->config->get( 'telephone_option_mandatory_status' ) == '1' ) ? true : false
				    ] );

			    $show_fax = $that->config->get( 'fax_option_show' );
			    if ( $show_fax === '1' ) {
				    if ( isset( $request_data['fax'] ) ) {
					    $fax = $request_data['fax'];
				    } elseif ( isset( $customer_info ) ) {
					    $fax = $customer_info['fax'];
				    } elseif ( $request_data['fax'] == '' ) {
					    $fax = '';
				    }

                    $form['fields']['fax'] = $that->html->buildInput(
					    [
						    'name'        => 'fax',
						    'value'       => $fax,
						    'placeholder' => $that->config->get( 'fax_option_placeholder' ),
						    'required'    => ( $that->config->get( 'fax_option_mandatory_status' ) == '1' ) ? true : false
					    ] );
			    } else {
                    unset( $form['fields']['fax']);
                }
                $that->view->assign('form', $form);
		    }
    }

    public function onControllerPagesAccountAddress_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'main') {
            $this->getList();
        } elseif ($this->baseObject_method === 'insert') {
            if (isset($that->request->get['address_id']) && $that->request->is_GET()) {
                $address_info = $that->model_account_address->getAddress($that->request->get['address_id']);
            }
            if (isset($that->request->post['company'])) {
                $company = $that->request->post['company'];
            } elseif (isset($address_info)) {
                $company = $address_info['company'];
            } else {
                $company = '';
            }
            $that->view->assign('error_company', $that->error['company']);
            $form = $that->view->getData('form');
            $form['fields']['company'] = $that->html->buildInput(
                [
                    'name' => 'company',
                    'value' => $company,
                    'placeholder' => $that->config->get('company_option_placeholder'),
                    'required' => ($that->config->get('company_option_mandatory_status') == '1') ? true : false
                ]);
            $that->view->assign('form', $form);
        } elseif ($this->baseObject_method === 'update') {
            if (isset($that->request->get['address_id']) && $that->request->is_GET()) {
                $address_info = $that->model_account_address->getAddress($that->request->get['address_id']);
            }
            if (isset($that->request->post['company'])) {
                $company = $that->request->post['company'];
            } elseif (isset($address_info)) {
                $company = $address_info['company'];
            } else {
                $company = '';
            }
            $that->view->assign('error_company', $that->error['company']);
            $form = $that->view->getData('form');
            $form['fields']['company'] = $that->html->buildInput(
                [
                    'name' => 'company',
                    'value' => $company,
                    'placeholder' => $that->config->get('company_option_placeholder'),
                    'required' => ($that->config->get('company_option_mandatory_status') == '1') ? true : false
                ]);
            $that->view->assign('form', $form);
        }
    }

    public function onControllerResponsesCommonViewPort_InitData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'modal') {
            $page_rt = $that->request->get['viewport_rt'];
            if ($page_rt) {
                $that->session->data['viewport_mode']='modal';
            }
        }
    }

    //Hook Sale Customer Validation
    public function onControllerPagesSaleCustomer_ValidateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
	    $that =& $this->baseObject;
	        $rt   = $that->request->get['rt'];
		    $that->loadLanguage( 'telephone_option/telephone_option' );
		    $telephone = $that->request->post['telephone'];
		    $fax       = $that->request->post['fax'];
		    $company   = $that->request->post['company'];
		    if ( $rt === 'sale/customer/insert_address' || $rt === 'sale/customer/update_address' ) {
			    if ( $that->config->get( 'company_option_mandatory_status' ) == '1' ) {
				    if ( $company == '' ) {
					    $that->error['company'] = $that->language->get( 'company_error' );
				    }
			    }
		    } else {
			    if ( $that->config->get( 'telephone_option_mandatory_status' ) == '1' ) {
				    if ( empty( $telephone ) || mb_strlen( $telephone ) < 3 || mb_strlen( $telephone ) > 32 ) {
					    $that->error['telephone'] = $that->language->get( 'telephone_error' );
				    }
			    }

			    if ( $that->config->get( 'fax_option_mandatory_status' ) == '1' ) {
				    if ( empty( $fax ) || ( ( mb_strlen( $fax ) < 3 || mb_strlen( $fax ) > 32 ) && strtolower( $fax ) != 'na' && strtolower( $fax ) != 'none' ) ) {
					    $that->error['fax'] = $that->language->get( 'fax_error' );
				    }
			    }
		    }
    }

    public function onControllerPagesSaleCustomer_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
	    $that =& $this->baseObject;
        if ($this->baseObject_method === 'insert') {
            $form = $that->view->getData('form');
            $that->view->assign('error', $that->error);
            $form['fields']['details']['telephone'] = $that->html->buildInput(
                [
                    'name' => 'telephone',
                    'value' => $that->request->post['telephone'],
                    'required' => $that->config->get('telephone_option_mandatory_status') === '1' ? true : false
                ]);
            $form['fields']['details']['fax'] = $that->html->buildInput(
                [
                    'name' => 'fax',
                    'value' => $that->request->post['fax'],
                    'required' => $that->config->get('fax_option_mandatory_status') === '1' ? true : false
                ]);
            $that->view->assign('form', $form);
        } elseif ($this->baseObject_method === 'update') {
            $customer_id = $that->request->get['customer_id'];
            if (has_value($customer_id)) {
                $customer_info = $that->model_sale_customer->getCustomer($customer_id);
            }
            $form = $that->view->getData('form');
            $that->view->assign('error', $that->error);
            $form['fields']['details']['telephone'] = $that->html->buildInput(
                [
                    'name' => 'telephone',
                    'value' => $customer_info['telephone'],
                    'required' => $that->config->get('telephone_option_mandatory_status') === '1' ? true : false
                ]);
            $form['fields']['details']['fax'] = $that->html->buildInput(
                [
                    'name' => 'fax',
                    'value' => $customer_info['fax'],
                    'required' => $that->config->get('fax_option_mandatory_status') === '1' ? true : false
                ]);
            $that->view->assign('form', $form);
        } elseif ($this->baseObject_method === 'insert_address') {
            $current_address = [];
            $current_address = $that->request->post;
            foreach ($current_address as $name => $value) {
                $this->data['address'][$name] = $value;
            }
            $form = $that->view->getData('form');
            $form['fields']['address']['company'] = $that->html->buildInput(
                [
                    'name' => 'company',
                    'value' => $this->data['address']['company'],
                    'placeholder' => $that->config->get('company_option_placeholder'),
                    'required' => ($that->config->get('company_option_mandatory_status') == '1') ? true : false
                ]);
            $that->view->assign('form', $form);
        } elseif ($this->baseObject_method === 'update_address') {
            $address_id = $that->request->get['address_id'];
            $customer_id = $that->request->get['customer_id'];
            if (has_value($customer_id)) {
                $customer_info = $that->model_sale_customer->getCustomer($customer_id);
                $this->data['addresses'] = $that->model_sale_customer->getAddressesByCustomerId($customer_id);
                $current_address = [];
                if ($this->data['addresses']) {
                    foreach ($this->data['addresses'] as &$a) {
                        $a['href'] = $that->html->getSecureURL('sale/customer/update_address', '&customer_id=' . $customer_id . '&address_id=' . $a['address_id']);
                        $a['title'] = $a['address_1'] . ' ' . $a['address_2'];
                        //mark default address
                        if ($customer_info['address_id'] === $a['address_id']) {
                            $a['default'] = 1;
                        }
                        if ($address_id === $a['address_id']) {
                            $current_address = $a;
                            $this->data['current_address'] = $a['title'];
                        }
                    }
                }
                foreach ($current_address as $name => $value) {
                    $this->data['address'][$name] = $value;
                }
                $form = $that->view->getData('form');
                $form['fields']['address']['company'] = $that->html->buildInput(
                    [
                        'name' => 'company',
                        'value' => $this->data['address']['company'],
                        'placeholder' => $that->config->get('company_option_placeholder'),
                        'required' => ($that->config->get('company_option_mandatory_status') == '1') ? true : false
                    ]);
                $that->view->assign('form',$form);

            }
        }
    }

    public function onControllerPagesAccountInvoice_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'main') {
            if (isset($that->request->get['order_id'])) {
                $order_id = (int)$that->request->get['order_id'];
            } else {
                $order_id = 0;
            }
            $that->loadModel('account/customer');
            $that->load->model('account/order');
            $enc = new AEncryption($that->config->get('encryption_key'));
            $guest = false;

            $ups_plus_status = $this->verifyUpsPlus();
            if ($ups_plus_status === '1') {
                $that->load->model('extension/ups_integration_plus_order');
            }

            if (isset($that->request->get['ot']) && $that->config->get('config_guest_checkout')) {
                //try to decrypt order token
                $order_token = $that->request->get['ot'];
                if ($order_token) {
                    list($order_id, $email) = $that->model_account_customer->parseOrderToken($order_token);
                    if ($order_id && $email) {
                        $guest = true;
                        if ($ups_plus_status === '1') {
                            $order_info = $that->model_extension_ups_integration_plus_order->getOrder($order_id);
                        } else {
                            $order_info = $that->model_account_order->getOrder($order_id, '', 'view');
                        }
                    }
                }
            }

            if ($that->request->is_POST() && $this->_validate()) {
                $guest = true;

                $order_id = $that->request->post['order_id'];
                $email = $that->request->post['email'];
                $order_token = $enc->encrypt($order_id . '::' . $email);
                if ($ups_plus_status === '1') {
                    $order_info = $that->model_extension_ups_integration_plus_order->getOrder($order_id);
                } else {
                    $order_info = $that->model_account_order->getOrder($order_id, '', 'view');
                }

                //compare emails
                if ($order_info['email'] != $email) {
                    unset($order_info, $order_id, $email);
                }
            }

            if (!$order_id && $that->customer->isLogged()) {
                redirect($that->html->getSecureURL('account/history'));
            }

            //get info for registered customers
            if (!$order_info) {
                if ($ups_plus_status === '1') {
                    $order_info = $that->model_extension_ups_integration_plus_order->getOrder($order_id);
                } else {
                    $order_info = $that->model_account_order->getOrder($order_id, '', 'view');
                }
            }

            if ($order_info) {
                $fax = $order_info['fax'];
                if ($fax!=='' && strtolower($fax)!=='na' && strtolower($fax)!=='none') {
                    $that->view->assign('fax', $fax);
                } else {
                    $that->view->assign('fax', '');
                }

                if ($ups_plus_status === '1') {
                    $shipping_data = [
                        'firstname' => $order_info['shipping_firstname'],
                        'lastname' => $order_info['shipping_lastname'],
                        'company' => $order_info['shipping_company'],
                        'address_1' => $order_info['shipping_address_1'],
                        'address_2' => $order_info['shipping_address_2'],
                        'city' => $order_info['shipping_city'],
                        'postcode' => $order_info['shipping_postcode'],
                        'zone' => $order_info['shipping_zone'],
                        'zone_code' => $order_info['shipping_zone_code'],
                        'country' => $order_info['shipping_country'],
                        'location_phone' => $order_info['location_phone']
                    ];
                } else {
                    $shipping_data = [
                        'firstname' => $order_info['shipping_firstname'],
                        'lastname' => $order_info['shipping_lastname'],
                        'company' => $order_info['shipping_company'],
                        'address_1' => $order_info['shipping_address_1'],
                        'address_2' => $order_info['shipping_address_2'],
                        'city' => $order_info['shipping_city'],
                        'postcode' => $order_info['shipping_postcode'],
                        'zone' => $order_info['shipping_zone'],
                        'zone_code' => $order_info['shipping_zone_code'],
                        'country' => $order_info['shipping_country']
                    ];
                }

                $that->view->assign('shipping_address', $this->getFormattedAddress($shipping_data));

                $payment_data = [
                    'firstname' => $order_info['payment_firstname'],
                    'lastname' => $order_info['payment_lastname'],
                    'company' => $order_info['payment_company'],
                    'address_1' => $order_info['payment_address_1'],
                    'address_2' => $order_info['payment_address_2'],
                    'city' => $order_info['payment_city'],
                    'postcode' => $order_info['payment_postcode'],
                    'zone' => $order_info['payment_zone'],
                    'zone_code' => $order_info['payment_zone_code'],
                    'country' => $order_info['payment_country']
                ];

                $that->view->assign('payment_address', $this->getFormattedAddress($payment_data));
            }
        }
    }

    public function onControllerPagesCheckoutShipping_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'main') {
            $address_rt = 'checkout/address/shipping';
            $that->loadModel('account/address');
            $shipping_address = $that->model_account_address->getAddress($that->session->data['shipping_address_id']);

            //something wrong with shipping address go to address selection page
            if (!$shipping_address) {
                redirect($that->html->getSecureURL($address_rt));
            }

            $that->view->assign('address', $this->getFormattedAddress($shipping_address));
        }
    }

    public function onControllerPagesCheckoutPayment_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'main') {
            $address_rt = 'checkout/address/payment';
            $that->loadModel('account/address');
            $payment_address = $that->model_account_address->getAddress($that->session->data['payment_address_id']);
            if (!$payment_address) {
                redirect($that->html->getSecureURL($address_rt));
            }
            $that->view->assign('address', $this->getFormattedAddress($payment_address));
        }
    }

    /**
     * Used By Fast Checkout
     */
    public function onControllerPagesAccountOrderDetails_UpdateData() {
        $that =& $this->baseObject;
        if ($this->baseObject_method==='main') {
            $fax=$that->data['fax'];
            if (strtolower($fax)==='na' || strtolower($fax)==='none') {
                $that->view->assign('fax','');
            }
            $shipping_address=$that->data['shipping_address'];
            $find_shipping_address=["na<br />","none<br />","NA<br />","None<br />","NONE<br />"];
            $replace_shipping_address=["","","","",""];
            $that->view->assign('shipping_address',str_replace($find_shipping_address,$replace_shipping_address,$shipping_address));

            $payment_address=$that->data['payment_address'];
            $find_shipping_address=["na<br />","none<br />","NA<br />","None<br />","NONE<br />"];
            $replace_payment_address=["","","","",""];
            $that->view->assign('payment_address',str_replace($find_shipping_address,$replace_payment_address,$payment_address));
        }
    }


    public function onControllerResponsesCheckoutPay_InitData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'address') {
            if (!$that->customer->isLogged() && $that->request->is_POST()) {
                $that->session->data['fc']['fax'] = $that->request->post['fax'];
                $that->session->data['fc']['company'] = $that->request->post['company'];
            }
        }
    }

    public function onControllerResponsesCheckoutPay_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'main') {
            $additional = ['fax','company'];
            $that->loadLanguage('account/telephone');
            $that->load->model('account/address');
            $fields = [];

            if (!$that->customer->isLogged()) {
                $that->session->data['guest']['fax'] = $that->session->data['fc']['fax'];
                $that->session->data['guest']['company'] = $that->session->data['fc']['company'];
                $that->session->data['fc']['guest']['fax'] = $that->session->data['fc']['fax'];
                $that->session->data['fc']['guest']['company'] = $that->session->data['fc']['company'];
            }

            foreach ($additional as $v) {
                if ($that->config->get($v.'_option_mandatory_status')
                    || ($that->config->get($v.'_option_show') === '1')) {
                    array_push($fields, $v);
                }
            }

            if ($that->customer->isLogged()) {
                $info['fax'] = $that->customer->getFax();
                $payment_address = $that->model_account_address->getAddress($that->session->data['fc']['payment_address_id']);
                $info['company'] = $payment_address['company'];
            } else {
                $info = $that->session->data['fc'];
            }
            foreach ($fields as $v) {
                $data['additional'][$v] = $v;
                $data[$v.'_data'] = $info[$v];
                $data[$v.'_placeholder'] = $that->language->get('fc_'.$v.'_placeholder').': '.$that->config->get($v.'_option_placeholder');
            }
            $view = new AView($this->registry, 0);
            $view->batchAssign($data);
            $that->view->addHookVar('customer_additional_attributes', $view->fetch('pages/account/fc_payment_fields.tpl'));
        } elseif ($this->baseObject_method === '_addressForm') {
            $that->loadLanguage('account/telephone');
            $fields = [];
            $additional = ['fax','company'];
            foreach ($additional as $v) {
                if ($that->config->get($v.'_option_mandatory_status')
                    || ($that->config->get($v.'_option_show') === '1')) {
                    array_push($fields, $v);
                }
            }
            foreach ($fields as $v) {
                $data['additional'][$v] = $v;
                $data[$v.'_data'] = $that->session->data['fc'][$v];
                $data[$v.'_placeholder'] = $that->language->get('fc_'.$v.'_placeholder').': '.$that->config->get($v.'_option_placeholder');
            }
            $view = new AView($this->registry, 0);
            $view->batchAssign($data);
            $that->view->addHookVar('address_attributes', $view->fetch('pages/account/fc_guest_fields.tpl'));
        }
    }

    public function onModelCheckoutOrder_ProcessData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method==='sf_order_confirm_mail') {
            $ups_plus_status = $this->verifyUpsPlus();
            $order_id=$that->data['mail_template_data']['order_id'];
            if ( $ups_plus_status === true ) {
                $order_query = $that->db->query( "SELECT o.*,
												l.filename AS filename,
												l.directory AS directory,
												ap.location_phone
										 FROM `" . $that->db->table( "orders" ) . "` o
										 LEFT JOIN " . $that->db->table( "languages" ) . " l ON (o.language_id = l.language_id)
										 LEFT JOIN " . $that->db->table( "ap_address_phone" ) . " ap ON ap.order_id=o.order_id
										 WHERE o.order_id = " . (int)$order_id);
            } else {
                $order_query = $that->db->query( "SELECT *,
												l.filename AS filename,
												l.directory AS directory
										 FROM `" . $that->db->table( "orders" ) . "` o
										 LEFT JOIN " . $that->db->table( "languages" ) . " l ON (o.language_id = l.language_id)
										 WHERE o.order_id = " . (int)$order_id);
            }

            if ( ! $order_query->num_rows ) {
                return false;
            }
            $order_row = $that->dcrypt->decrypt_data( $order_query->row, 'orders' );
            $that->load->model('localisation/zone');
            $shipping_zone_row = $that->model_localisation_zone->getZone($order_row['shipping_zone_id']);
            if ($shipping_zone_row) {
                $shipping_zone_code = $shipping_zone_row['code'];
            } else {
                $shipping_zone_code = '';
            }
            $shipping_data = [
                'firstname' => $order_row['shipping_firstname'],
                'lastname'  => $order_row['shipping_lastname'],
                'company'   => strtolower($order_row['shipping_company'])==='na' || strtolower($order_row['shipping_company'])==='none' ? "" : $order_row['shipping_company'],
                'address_1' => $order_row['shipping_address_1'],
                'address_2' => $order_row['shipping_address_2'],
                'city'      => $order_row['shipping_city'],
                'postcode'  => $order_row['shipping_postcode'],
                'zone'      => $order_row['shipping_zone'],
                'zone_code' => $shipping_zone_code,
                'country'   => $order_row['shipping_country'],
            ];

            $that->data['mail_template_data']['shipping_data'] = $shipping_data;
            $that->data['mail_template_data']['shipping_address'] = $this->getFormattedAddress( $shipping_data );

            $payment_zone_row = $that->model_localisation_zone->getZone($order_row['payment_zone_id']);
            if ($payment_zone_row) {
                $payment_zone_code = $payment_zone_row['code'];
            } else {
                $payment_zone_code = '';
            }

            $payment_data = [
                'firstname' => $order_row['payment_firstname'],
                'lastname' => $order_row['payment_lastname'],
                'company' => strtolower($order_row['payment_company']) === 'na' || strtolower($order_row['payment_company']) === 'none' ? "" : $order_row['payment_company'],
                'address_1' => $order_row['payment_address_1'],
                'address_2' => $order_row['payment_address_2'],
                'city' => $order_row['payment_city'],
                'postcode' => $order_row['payment_postcode'],
                'zone' => $order_row['payment_zone'],
                'zone_code' => $payment_zone_code,
                'country' => $order_row['payment_country'],
            ];

            if ( $that->config->get( 'taxid_show_seller_info' ) === '1' ) {
                $that->data['mail_template_data']['seller_info']  = html_entity_decode( nl2br( $that->config->get( 'taxid_seller_info' ) ) );
            } else {
                $that->data['mail_template_data']['seller_info']  = "";
            }
            $that->data['mail_template_data']['customer_fax'] = strtolower($order_row['fax'])==='na' || strtolower($order_row['fax'])==='none' ? '' : $order_row['fax'];
            $that->data['mail_template_data']['payment_data'] = $payment_data;
            $that->data['mail_template_data']['payment_address'] = $this->getFormattedAddress( $payment_data );
        }
    }

    /**
     * @param $data_array
     * @param string $type
     * @param array $locate
     * @return mixed
     */
    private function getFormattedAddress($data_array) {
        $that =& $this->baseObject;
        $format = '';
        $data_array = (array)$data_array;
        $ups_plus_status=$this->verifyUpsPlus();
        if ($ups_plus_status==='1') {
            $that->load->language('ups_integration_plus/ups_integration_plus');
        }
        $company = '';
        if (strtolower($data_array['company']) !== 'none' && strtolower($data_array['company']) !== 'na' && $data_array['company'] !== '') {
            $company = ' {company} '. "\n";
        }
        // Set default format
        if ($data_array['location_phone'] !== '' && !empty($data_array['location_phone'])) {
            $format = '{firstname} {lastname}' . "\n" . $company . '{address_1}' . "\n" . '{address_2}' . "\n" . '{city} {postcode}' . "\n" . '{zone}' . "\n" . '{country}' . "\n" .$that->language->get('text_ups_plus_telephone') . ' {location_phone}';
        } else {
            $format = '{firstname} {lastname}' . "\n" . $company . '{address_1}' . "\n" . '{address_2}' . "\n" . '{city} {postcode}' . "\n" . '{zone}' . "\n" . '{country}';
        }
        //Set default variable to be set for address based on the data
        $locate = [];
        foreach ($data_array as $key => $value) {
            $locate[] = "{" . $key . "}";
        }

        return str_replace(["\r\n", "\r", "\n"], '<br />',preg_replace(["/\s\s+/", "/\r\r+/", "/\n\n+/"],  '<br />', trim(str_replace($locate, $data_array, $format))));
    }

    private function _validate(){
        $that =& $this->baseObject;
        if (!(int)$that->request->post['order_id']){
            $this->error['order_id'] = $that->language->get('error_order_id');
        }

        if (mb_strlen($that->request->post['email']) > 96 || !preg_match(EMAIL_REGEX_PATTERN, $that->request->post['email'])){
            $this->error['email'] = $that->language->get('error_email');
        }

        $that->extensions->hk_ValidateData($this);

        return !$this->error ? true : false;

    }

    private function getList() {
        $that =& $this->baseObject;
        $that->document->addBreadcrumb([
            'href' => $that->html->getURL('index/home'),
            'text' => $that->language->get('text_home'),
            'separator' => FALSE
        ]);

        $that->document->addBreadcrumb([
            'href' => $that->html->getURL('account/account'),
            'text' => $that->language->get('text_account'),
            'separator' => $that->language->get('text_separator')
        ]);

        $that->document->addBreadcrumb([
            'href' => $that->html->getURL('account/address'),
            'text' => $that->language->get('heading_title'),
            'separator' => $that->language->get('text_separator')
        ]);

        $that->view->assign('error_warning', $this->error['warning']);
        $that->view->assign('success', $that->session->data['success']);

        $addresses = [];

        $results = $that->model_account_address->getAddresses();

        foreach ($results as $result) {
            $formated_address = $this->getFormattedAddress($result);

            $edit = HtmlElementFactory::create([
                'type' => 'button',
                'text' => $that->language->get('button_edit'),
                'style' => 'button btn-primary',
                'icon' => 'fa-edit fa',
                'attr' => 'onclick="location = \'' . $that->html->getSecureURL('account/address/update', '&address_id=' . $result['address_id']) . '\'" ']);
            $delete = HtmlElementFactory::create([
                'type' => 'button',
                'text' => $that->language->get('button_delete'),
                'style' => '',
                'icon' => 'fa fa-remove',
                'attr' => 'onclick="location = \'' . $that->html->getSecureURL('account/address/delete', '&address_id=' . $result['address_id']) . '\'" ']);

            $addresses[] = [
                'address_id' => $result['address_id'],
                'address' => $formated_address,
                'button_edit' => $edit,
                'button_delete' => $delete,
                'default' => $that->customer->getAddressId() == $result['address_id'] ? true : false,
            ];
        }

        $that->view->assign('addresses', $addresses);

        $that->view->assign('insert', $that->html->getSecureURL('account/address/insert'));

        $insert = HtmlElementFactory::create([
            'type' => 'button',
            'name' => 'insert',
            'text' => $that->language->get('button_new_address'),
            'icon' => 'fa fa-plus',
            'style' => 'button']);
        $that->view->assign('button_insert', $insert);

        $back = HtmlElementFactory::create([
            'type' => 'button',
            'name' => 'back',
            'text' => $that->language->get('button_back'),
            'icon' => 'fa fa-arrow-left',
            'style' => 'button']);
        $that->view->assign('button_back', $back);
        $that->view->assign('back', $that->html->getSecureURL('account/account'));

        $that->processTemplate('pages/account/addresses.tpl');
    }
    
    public function onControllerCommonHead_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'main') {
            if (IS_ADMIN) {
                $support = telephoneVerifySupport();
                if ($support['notification_case'] === 'notification_license_ok') {
                    $that->load->language('telephone_option/telephone_option');
                    $getVersions = telephoneUpdaterGetAllVersions();
                    $that->load->model('extension/telephone_option_updater');
                    $current_version = $that->model_extension_telephone_option_updater->getCurrentVersion();
                    if ($getVersions['notification_case'] !== 'notification_product_no_versions') {
                        $versions = $getVersions['notification_data']['product_versions'];
                        $total = $that->model_extension_telephone_option_updater->getTotalMsgIds();
                        if ($total > '0') {
                            $msg_ids = $that->model_extension_telephone_option_updater->getMsgIdsByCartVersions();
                            foreach ($msg_ids as $msg_id) {
                                $that->messages->deleteMessage($msg_id['msg_id']);
                                $that->model_extension_telephone_option_updater->deleteMsgID($msg_id['msg_id']);
                            }
                        }
                        if ($versions) {
                            $latestVersions = [];
                            foreach ($versions as $version) {
                                if (strpos($version['version_number'], VERSION) !== false) {
                                    $latestVersions[] = $version['version_number'];
                                }
                            }
                            usort($latestVersions, 'version_compare');
                            $latestVersion = end($latestVersions);
                            if (version_compare($current_version, $latestVersion, '<') === true) {
                                $msg_ids = $that->model_extension_telephone_option_updater->getMsgIdsByCurrentCartVersion();
                                foreach ($msg_ids as $msg_id) {
                                    $that->messages->deleteMessage($msg_id['msg_id']);
                                    $that->model_extension_telephone_option_updater->deleteMsgID($msg_id['msg_id']);
                                }
                                $msg_title = str_replace('[new_version]', $latestVersion, $that->language->get('text_new_telephone_option_version_title'));
                                $msg = str_replace('[version_number]', str_replace('.', '-', $latestVersion), $that->language->get('text_new_telephone_option_version_description'));
                                $that->messages->saveNotice($msg_title, $msg);
                                $msg_info = $that->messages->getLikeMessage($msg_title);
                                $that->model_extension_telephone_option_updater->saveMessageId($msg_info['msg_id'], $latestVersion);
                            }
                        }
                    }
                }
            }
        }
    }
}