<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2022 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

require_once DIR_EXT. "enhanced_flat_rate_shipping" . DIR_EXT_CORE ."helpers.php";
require_once DIR_EXT. "enhanced_flat_rate_shipping" . DIR_EXT_CORE ."updater.php";

Class ExtensionEnhancedFlatRateShipping extends Extension {

    public $data=[];

    public function __construct() {
        $this->registry = Registry::getInstance();
    }

    private function _is_enabled() {
        return $this->baseObject->config->get('enhanced_flat_rate_shipping_status') ? $this->verify() : false;
    }

	public function verify() {
    	$that =& $this->baseObject;
		$exist = $that->db->query("SHOW TABLES LIKE '".$that->db->table('enhanced_flat_rate_shipping_license')."'");
		if ($exist->num_rows === 1) {
			$validation = enhFlatRateVerifyLicense();
			if ( $validation['notification_case'] === 'notification_license_ok' ) {
				return true;
			} elseif ( $validation['notification_case'] === 'notification_license_corrupted' ) {
				return false;
			}
		} else {
			return false;
		}
	}

	public function onControllerPagesExtensionExtensions_InitData() {
		$that =& $this->baseObject;
		if ($this->baseObject_method === 'edit') {
			$extension=$that->request->get['extension'];
			if ($extension==='enhanced_flat_rate_shipping') {
				if ($that->request->is_POST() ) {
					$exist = $that->db->query("SHOW TABLES LIKE '".$that->db->table('enhanced_flat_rate_shipping_license')."'");
					if ($exist->num_rows === 1) {
						if ($this->verify()===true) {
							enhFlatRateUninstallLicense();
						} else {
							$that->db->query("DROP TABLE IF EXISTS ".$that->db->table('enhanced_flat_rate_shipping_license'));
						}
						enhFlatRateInstallLicense( $that->request->post['enhanced_flat_rate_shipping_license_code'] );
					} else {
						$license = enhFlatRateInstallLicense( $that->request->post['enhanced_flat_rate_shipping_license_code'] );
						if ( $license['notification_case'] !== 'notification_license_ok' ) {
							$that->session->data['error'] = $license['notification_text'];
						} else {
							$that->session->data['success'] = "The license key is valid";
						}
					}
				}
			}
		}
	}

	public function onControllerResponsesListingGridExtension_UpdateData() {
		$that =& $this->baseObject;
		if ($this->baseObject_method==='update') {
			if ($that->request->post['enhanced_flat_rate_shipping_license_code']) {
				$exist = $that->db->query("SHOW TABLES LIKE '".$that->db->table('enhanced_flat_rate_shipping_license')."'");
				if ($exist->num_rows === 1) {
					if ($this->verify()===true) {
						enhFlatRateUninstallLicense();
					} else {
						$that->db->query("DROP TABLE IF EXISTS ".$that->db->table('enhanced_flat_rate_shipping_license'));
					}
					enhFlatRateInstallLicense( $that->request->post['enhanced_flat_rate_shipping_license_code'] );
				} else {
					$license = enhFlatRateInstallLicense( $that->request->post['enhanced_flat_rate_shipping_license_code'] );
					if ( $license['notification_case'] !== 'notification_license_ok' ) {
						$that->session->data['error'] = $license['notification_text'];
					} else {
						$that->session->data['success'] = "The license key is valid";
					}
				}
			}
		}
	}

	public function onControllerCommonHead_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'main') {
            if (IS_ADMIN) {
                $support = enhFlatRateVerifySupport();
                if ($support['notification_case'] === 'notification_license_ok') {
                    $that->load->language('enhanced_flat_rate_shipping/enhanced_flat_rate_shipping');
                    $getVersions = enhFlatRateUpdaterGetAllVersions();
                    $that->load->model('extension/enhanced_flat_rate_shipping_updater');
                    $current_version = $that->model_extension_enhanced_flat_rate_shipping_updater->getCurrentVersion();
                    if ($getVersions['notification_case'] !== 'notification_product_no_versions') {
                        $versions = $getVersions['notification_data']['product_versions'];
                        $total = $that->model_extension_enhanced_flat_rate_shipping_updater->getTotalMsgIds();
                        if ($total > '0') {
                            $msg_ids = $that->model_extension_enhanced_flat_rate_shipping_updater->getMsgIdsByCartVersions();
                            foreach ($msg_ids as $msg_id) {
                                $that->messages->deleteMessage($msg_id['msg_id']);
                                $that->model_extension_enhanced_flat_rate_shipping_updater->deleteMsgID($msg_id['msg_id']);
                            }
                        }
                        if ($versions) {
                            $latestVersions=[];
                            foreach ($versions as $version) {
                                if (strpos($version['version_number'],VERSION)!==false) {
                                    $latestVersions[]=$version['version_number'];
                                }
                            }
                            usort($latestVersions,'version_compare');
                            $latestVersion=end($latestVersions);
                            if (version_compare($current_version, $latestVersion, '<') === true) {
                                $msg_ids = $that->model_extension_enhanced_flat_rate_shipping_updater->getMsgIdsByCurrentCartVersion();
                                foreach ($msg_ids as $msg_id) {
                                    $that->messages->deleteMessage($msg_id['msg_id']);
                                    $that->model_extension_enhanced_flat_rate_shipping_updater->deleteMsgID($msg_id['msg_id']);
                                }
                                $msg_title = str_replace('[new_version]', $latestVersion, $that->language->get('text_new_enhanced_flat_rate_shipping_version_title'));
                                $msg=str_replace('[version_number]',str_replace('.','-',$latestVersion),$that->language->get('text_new_enhanced_flat_rate_shipping_version_description'));
                                $that->messages->saveNotice($msg_title, $msg);
                                $msg_info = $that->messages->getLikeMessage($msg_title);
                                $that->model_extension_enhanced_flat_rate_shipping_updater->saveMessageId($msg_info['msg_id'],$latestVersion);
                            }
                        }
                    }
                }
            }
        }
    }
	
}