<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2021 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/
if ( ! defined( 'DIR_CORE' ) ) {
	header( 'Location: static_pages/' );
}

require_once DIR_EXT . "editor" . DIR_EXT_CORE . "helpers.php";
require_once DIR_EXT . "editor" . DIR_EXT_CORE . "updater.php";

class ExtensionEditor extends Extension {
	private $error = [];
	public $data = [];

	public function __construct() {
		$this->registry = Registry::getInstance();
	}

	private function _is_enabled() {
		return $this->baseObject->config->get( 'editor_status' ) ? true : false;
	}

	public function verify() {
	    $that =& $this->baseObject;
		$exist = $that->db->query("SHOW TABLES LIKE '".$that->db->table('editor_license')."'");
		if ($exist->num_rows === 1) {
			$validation = editorVerifyLicense();
			if ( $validation['notification_case'] === 'notification_license_ok' ) {
				return true;
			} elseif ( $validation['notification_case'] === 'notification_license_corrupted' ) {
				return false;
			}
		} else {
			return false;
		}
	}

    public function verifyProductPricingPlus() {
        $that =& $this->baseObject;
        if ( $that->config->get( 'product_pricing_plus_status' ) === '1' ) {
            return true;
            $exist = $that->db->query( "SHOW TABLES LIKE '" . $that->db->table( 'area_calculator_license' ) . "'" );
            if ( $exist->num_rows === 1 ) {
                $validation = areaCalculatorVerifyLicense();
                if ( $validation['notification_case'] === 'notification_license_ok' ) {
                    return true;
                } elseif ( $validation['notification_case'] === 'notification_license_corrupted' ) {
                    return false;
                }
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    public function verifyAreaCalc() {
        $that =& $this->baseObject;
        if ( $that->config->get( 'area_calculator_status' ) === '1' ) {
            $exist = $that->db->query( "SHOW TABLES LIKE '" . $that->db->table( 'area_calculator_license' ) . "'" );
            if ( $exist->num_rows === 1 ) {
                $validation = areaCalculatorVerifyLicense();
                if ( $validation['notification_case'] === 'notification_license_ok' ) {
                    return true;
                } elseif ( $validation['notification_case'] === 'notification_license_corrupted' ) {
                    return false;
                }
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    public function verifyVolumeCalc() {
        $that =& $this->baseObject;
        if ( $that->config->get( 'volume_calculator_status' ) === '1' ) {
            $exist = $that->db->query( "SHOW TABLES LIKE '" . $that->db->table( 'volume_calculator_license' ) . "'" );
            if ( $exist->num_rows === 1 ) {
                $validation = volumeCalculatorVerifyLicense();
                if ( $validation['notification_case'] === 'notification_license_ok' ) {
                    return true;
                } elseif ( $validation['notification_case'] === 'notification_license_corrupted' ) {
                    return false;
                }
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    public function verifyLengthCalc() {
        $that =& $this->baseObject;
        if ($that->config->get('length_calculator_status')==='1') {
            $exist = $that->db->query( "SHOW TABLES LIKE '" . $that->db->table( 'length_calculator_license' ) . "'" );
            if ( $exist->num_rows === 1 ) {
                $validation = lengthCalculatorVerifyLicense();
                if ( $validation['notification_case'] === 'notification_license_ok' ) {
                    return true;
                } elseif ( $validation['notification_case'] === 'notification_license_corrupted' ) {
                    return false;
                }
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    public function verifyLiquidsCalc() {
        $that =& $this->baseObject;
        if ($that->config->get('liquids_calculator_status')==='1') {
            $exist = $that->db->query( "SHOW TABLES LIKE '" . $that->db->table( 'liquids_calculator_license' ) . "'" );
            if ( $exist->num_rows === 1 ) {
                $validation = liquidsCalculatorVerifyLicense();
                if ( $validation['notification_case'] === 'notification_license_ok' ) {
                    return true;
                } elseif ( $validation['notification_case'] === 'notification_license_corrupted' ) {
                    return false;
                }
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    public function verifyWeightCalc() {
        $that =& $this->baseObject;
        if ( $that->config->get( 'weight_calculator_status' ) === '1' ) {
            $exist = $that->db->query( "SHOW TABLES LIKE '" . $that->db->table( 'weight_calculator_license' ) . "'" );
            if ( $exist->num_rows === 1 ) {
                $validation = weightCalculatorVerifyLicense();
                if ( $validation['notification_case'] === 'notification_license_ok' ) {
                    return true;
                } elseif ( $validation['notification_case'] === 'notification_license_corrupted' ) {
                    return false;
                }
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

	public function onControllerPagesExtensionExtensions_InitData() {
		$that =& $this->baseObject;
		if ( $this->baseObject_method === 'edit' ) {
			$extension = $that->request->get['extension'];
			if ( $extension === 'editor' ) {
				if ( $that->request->is_POST() ) {
					$exist = $that->db->query( "SHOW TABLES LIKE '" . $that->db->table( 'editor_license' ) . "'" );
					if ( $exist->num_rows === 1 ) {
					    if ($this->verify()===true) {
							editorUninstallLicense();
						} else {
							$that->db->query("DROP TABLE IF EXISTS ".$that->db->table('editor_license'));
						}
						editorInstallLicense( $that->request->post['editor_license_code'] );
					} else {
						$license = editorInstallLicense( $that->request->post['editor_license_code'] );
						if ( $license['notification_case'] !== 'notification_license_ok' ) {
							$that->session->data['error'] = $license['notification_text'];
						} else {
							$that->session->data['success'] = "The license key is valid";
						}
					}
				}
			}
		}
	}

	public function onControllerResponsesListingGridExtension_UpdateData() {
		$that =& $this->baseObject;
		if ($this->baseObject_method==='update') {
			if ($that->request->post['editor_license_code']) {
				$exist = $that->db->query("SHOW TABLES LIKE '".$that->db->table('editor_license')."'");
				if ($exist->num_rows === 1) {
					if ($this->verify()===true) {
						editorUninstallLicense();
					} else {
						$that->db->query("DROP TABLE IF EXISTS ".$that->db->table('editor_license'));
					}
					editorInstallLicense( $that->request->post['editor_license_code'] );
				} else {
					$license = editorInstallLicense( $that->request->post['editor_license_code'] );
					if ( $license['notification_case'] !== 'notification_license_ok' ) {
						$that->session->data['error'] = $license['notification_text'];
					} else {
						$that->session->data['success'] = "The license key is valid";
					}
				}
			}
		}
	}

	public function onControllerCommonHead_InitData() {
		if ( ! $this->_is_enabled() ) {
			return null;
		}
		$that =& $this->baseObject;
		if ( IS_ADMIN || ( IS_ADMIN && $that->config->get( 'enhanced_admin_status' ) == '1' ) ) {
			$editor = $that->config->get( 'editor_status' );
			$rt=$that->request->get['rt'];
			$that->view->assign( 'rt', $rt );
			$that->view->assign( 'editor', $editor );
			$that->view->assign( 'url', $that->html->getSecureURL( 'r/extension/filemanager', '&type=Images' ) );
		}
	}

	public function onControllerPagesProductProduct_UpdateData() {
		if (!$this->_is_enabled()) {
			return null;
		}
		$that =& $this->baseObject;
		if ($this->baseObject_method==='main') {
			$this->data['product_info']['blurb'] = html_entity_decode($that->data['product_info']['blurb']);
			$that->view->batchAssign($this->data);
			$that->processTemplate();
		}
	}

	public function onControllerResponsesEmbedJS_UpdateData() {
		if (!$this->_is_enabled()) {
			return null;
		}
		$that =& $this->baseObject;
		if ($this->baseObject_method==='product') {
			$this->data['product']=$that->data['product'];
			$this->data['product']['blurb'] = html_entity_decode($that->data['product']['blurb']);
			$that->view->batchAssign($this->data);
			$that->processTemplate();
		}
	}

	public function onControllerBlocksBestSeller_UpdateData() {
		if (!$this->_is_enabled()) {
			return null;
		}
		$that =& $this->baseObject;
		if ($this->baseObject_method === 'main' ) {
			$this->data['products'] = [];
			$products = $that->data['products'];
			if ($products) {
				foreach ( $products as $product ) {
                    if  ($this->verifyAreaCalc() || $this->verifyVolumeCalc() || $this->verifyLiquidsCalc() || $this->verifyLengthCalc() || $this->verifyWeightCalc()) {
                        $query = $that->db->query("SELECT unit_text FROM ".$that->db->table("calculator_text"). " WHERE product_id=".(int)$product['product_id']);
                        $unitText=$query->row['unit_text'];
                        if (stripos($product['price'],"/")===false && !empty($unitText)) {
                            if ($unitText === 'm2') {
                                $txt = str_replace('2', '<sup>2</sup>', $unitText);
                            } elseif ($unitText === 'm3') {
                                $txt = str_replace('3', '<sup>3</sup>', $unitText);
                            } else {
                                $txt = $unitText;
                            }
                            $product['price'] .= '/' . $txt;
                            if (!empty($product['special'])) {
                                $product['special'].= '/' . $txt;
                            }
                        }
                    }
                    if ($this->verifyProductPricingPlus()) {
                        $that->load->model('extension/product_pricing_plus');
                        $product_id = $product['product_id'];
                        $settings=$that->model_extension_product_pricing_plus->getSettings($product_id);
                        if ($settings['show_product_listing']==='1') {
                            $price = html_entity_decode($settings['content']);
                            if ($product['special']) {
                                $special= $price.' '.$product['special'];
                                $price= $product['price'];
                            } else {
                                if ($product['price']!=='$0.00') {
                                    $price .= ' ' . $product['price'];
                                }
                                $special= $product['special'];
                            }
                        } else {
                            $price = $product['price'];
                            $special = $product['special'];
                        }
                    } else {
                        $price = $product['price'];
                        $special = $product['special'];
                    }
					$this->data['products'][] = [
						'product_id'     => $product['product_id'],
						'name'           => $product['name'],
						'blurb'          => html_entity_decode( $product['blurb'] ),
						'model'          => $product['model'],
						'rating'         => $product['rating'],
						'stars'          => $product['stars'],
						'price'          => $price,
						'call_to_order'  => $product['call_to_order'],
						'options'        => $product['options'],
						'special'        => $special,
						'thumb'          => $product['thumb'],
						'href'           => $product['href'],
						'add'            => $product['add'],
						'track_stock'    => $product['track_stock'],
						'in_stock'       => $product['in_stock'],
						'no_stock_text'  => $product['no_stock_text'],
						'total_quantity' => $product['total_quantity'],
						'tax_class_id'   => $product['tax_class_id'],
					];
				}
				$that->view->assign('products',$this->data['products']);
			}
		}
	}

	public function onControllerBlocksSpecial_UpdateData() {
		if (!$this->_is_enabled()) {
			return null;
		}
		$that =& $this->baseObject;
		if ( $this->baseObject_method === 'main' ) {
			$this->data['products'] = [];
			$products = $that->data['products'];
			if($products) {
				foreach ( $products as $product ) {
                    if  ($this->verifyAreaCalc() || $this->verifyVolumeCalc() || $this->verifyLiquidsCalc() || $this->verifyLengthCalc() || $this->verifyWeightCalc()) {
                        $query = $that->db->query("SELECT unit_text FROM ".$that->db->table("calculator_text"). " WHERE product_id=".(int)$product['product_id']);
                        $unitText=$query->row['unit_text'];
                        if (stripos($product['price'],"/")===false && !empty($unitText)) {
                            if ($unitText === 'm2') {
                                $txt = str_replace('2', '<sup>2</sup>', $unitText);
                            } elseif ($unitText === 'm3') {
                                $txt = str_replace('3', '<sup>3</sup>', $unitText);
                            } else {
                                $txt = $unitText;
                            }
                            $product['price'] .= '/' . $txt;
                            if (!empty($product['special'])) {
                                $product['special'].= '/' . $txt;
                            }
                        }
                    }
                    if ($this->verifyProductPricingPlus()) {
                        $that->load->model('extension/product_pricing_plus');
                        $product_id = $product['product_id'];
                        $settings=$that->model_extension_product_pricing_plus->getSettings($product_id);
                        if ($settings['show_product_listing']==='1') {
                            $price = html_entity_decode($settings['content']);
                            if ($product['special']) {
                                $special= $price.' '.$product['special'];
                                $price= $product['price'];
                            } else {
                                if ($product['price']!=='$0.00') {
                                    $price .= ' ' . $product['price'];
                                }
                                $special= $product['special'];
                            }
                        } else {
                            $price = $product['price'];
                            $special = $product['special'];
                        }
                    } else {
                        $price = $product['price'];
                        $special = $product['special'];
                    }
                    $this->data['products'][] = [
						'product_id'     => $product['product_id'],
						'name'           => $product['name'],
						'blurb'          => html_entity_decode( $product['blurb'] ),
						'model'          => $product['model'],
						'rating'         => $product['rating'],
						'stars'          => sprintf( $that->language->get( 'text_stars' ), $product['rating'] ),
						'price'          => $price,
						'call_to_order'  => $product['call_to_order'],
						'options'        => $product['options'],
						'special'        => $special,
						'thumb'          => $product['thumb'],
						'href'           => $product['href'],
						'add'            => $product['add'],
						'track_stock'    => $product['track_stock'],
						'in_stock'       => $product['in_stock'],
						'no_stock_text'  => $product['no_stock_text'],
						'total_quantity' => $product['total_quantity'],
						'tax_class_id'   => $product['tax_class_id'],
					];
				}
				$that->view->assign('products',$this->data['products']);
			}
		}
	}

	public function onControllerBlocksfeatured_UpdateData() {
		if (!$this->_is_enabled()) {
			return null;
		}

		$that =& $this->baseObject;
		if ($this->baseObject_method === 'main' ) {
			$that->load->model( 'catalog/product' );
			$this->data['products'] = [];
			$products = $that->data['products'];
			if ($products) {
				foreach ( $products as $product ) {
                    if  ($this->verifyAreaCalc() || $this->verifyVolumeCalc() || $this->verifyLiquidsCalc() || $this->verifyLengthCalc() || $this->verifyWeightCalc()) {
                        $query = $that->db->query("SELECT unit_text FROM ".$that->db->table("calculator_text"). " WHERE product_id=".(int)$product['product_id']);
                        $unitText=$query->row['unit_text'];
                        if (stripos($product['price'],"/")===false && !empty($unitText)) {
                            if ($unitText === 'm2') {
                                $txt = str_replace('2', '<sup>2</sup>', $unitText);
                            } elseif ($unitText === 'm3') {
                                $txt = str_replace('3', '<sup>3</sup>', $unitText);
                            } else {
                                $txt = $unitText;
                            }
                            $product['price'] .= '/' . $txt;
                            if (!empty($product['special'])) {
                                $product['special'].= '/' . $txt;
                            }
                        }
                    }
                    if ($this->verifyProductPricingPlus()) {
                        $that->load->model('extension/product_pricing_plus');
                        $product_id = $product['product_id'];
                        $settings=$that->model_extension_product_pricing_plus->getSettings($product_id);
                        if ($settings['show_product_listing']==='1') {
                            $price = html_entity_decode($settings['content']);
                            if ($product['special']) {
                                $special= $price.' '.$product['special'];
                                $price= $product['price'];
                            } else {
                                if ($product['price']!=='$0.00') {
                                    $price .= ' ' . $product['price'];
                                }
                                $special= $product['special'];
                            }
                        } else {
                            $price = $product['price'];
                            $special = $product['special'];
                        }
                    } else {
                        $price = $product['price'];
                        $special = $product['special'];
                    }
                    $this->data['products'][] = [
						'product_id'     => $product['product_id'],
						'name'           => $product['name'],
						'blurb'          => html_entity_decode( $product['blurb'] ),
						'model'          => $product['model'],
						'rating'         => $product['rating'],
						'stars'          => $product['stars'],
						'price'          => $price,
						'call_to_order'  => $product['call_to_order'],
						'options'        => $product['options'],
						'special'        => $special,
						'thumb'          => $product['thumb'],
						'href'           => $product['href'],
						'add'            => $product['add'],
						'track_stock'    => $product['track_stock'],
						'in_stock'       => $product['in_stock'],
						'no_stock_text'  => $product['no_stock_text'],
						'total_quantity' => $product['total_quantity'],
						'tax_class_id'   => $product['tax_class_id'],
						'date_added'     => $product['date_added'],
					];
				}
				$that->view->assign('products',$this->data['products']);
			}
		}
	}

	public function onControllerBlocksLatest_UpdateData() {
		if (!$this->_is_enabled()) {
			return null;
		}
		$that =& $this->baseObject;
		if ($this->baseObject_method === 'main' ) {
			$this->data['products'] = [];
			$products = $that->data['products'];
			if ($products) {
				foreach ( $products as $product ) {
				    if  ($this->verifyAreaCalc() || $this->verifyVolumeCalc() || $this->verifyLiquidsCalc() || $this->verifyLengthCalc() || $this->verifyWeightCalc()) {
                        $query = $that->db->query("SELECT unit_text FROM ".$that->db->table("calculator_text"). " WHERE product_id=".(int)$product['product_id']);
                        $unitText=$query->row['unit_text'];
                        if (stripos($product['price'],"/")===false && !empty($unitText)) {
                            if ($unitText === 'm2') {
                                $txt = str_replace('2', '<sup>2</sup>', $unitText);
                            } elseif ($unitText === 'm3') {
                                $txt = str_replace('3', '<sup>3</sup>', $unitText);
                            } else {
                                $txt = $unitText;
                            }
                            $product['price'] .= '/' . $txt;
                            if (!empty($product['special'])) {
                                $product['special'].= '/' . $txt;
                            }
                        }
                    }
                    if ($this->verifyProductPricingPlus()) {
                        $that->load->model('extension/product_pricing_plus');
                        $product_id = $product['product_id'];
                        $settings=$that->model_extension_product_pricing_plus->getSettings($product_id);
                        if ($settings['show_product_listing']==='1') {
                            $price = html_entity_decode($settings['content']);
                            if ($product['special']) {
                                $special= $price.' '.$product['special'];
                                $price= $product['price'];
                            } else {
                                if ($product['price']!=='$0.00') {
                                    $price .= ' ' . $product['price'];
                                }
                                $special= $product['special'];
                            }
                        } else {
                            $price = $product['price'];
                            $special = $product['special'];
                        }
                    } else {
                        $price = $product['price'];
                        $special = $product['special'];
                    }

                    $this->data['products'][] = [
						'product_id'     => $product['product_id'],
						'name'           => $product['name'],
						'blurb'          => html_entity_decode( $product['blurb'] ),
						'model'          => $product['model'],
						'rating'         => $product['rating'],
						'stars'          => $product['stars'],
						'price'          => $price,
						'call_to_order'  => $product['call_to_order'],
						'options'        => $product['options'],
						'special'        => $special,
						'thumb'          => $product['thumb'],
						'href'           => $product['href'],
						'add'            => $product['add'],
						'track_stock'    => $product['track_stock'],
						'in_stock'       => $product['in_stock'],
						'no_stock_text'  => $product['no_stock_text'],
						'total_quantity' => $product['total_quantity'],
						'tax_class_id'   => $product['tax_class_id'],
						'date_added'     => $product['date_added'],
					];
				}
				$that->view->assign('products',$this->data['products']);
			}
		}
	}

	public function onControllerPagesProductSpecial_UpdateData() {
		if (!$this->_is_enabled()) {
			return null;
		}
		$that =& $this->baseObject;
		if ( $this->baseObject_method === 'main' ) {
			$this->data['products'] = [];
			$products = $that->data['products'];
			if ($products) {
				foreach ( $products as $product ) {
                    if  ($this->verifyAreaCalc() || $this->verifyVolumeCalc() || $this->verifyLiquidsCalc() || $this->verifyLengthCalc() || $this->verifyWeightCalc()) {
                        $query = $that->db->query("SELECT unit_text FROM ".$that->db->table("calculator_text"). " WHERE product_id=".(int)$product['product_id']);
                        $unitText=$query->row['unit_text'];
                        if (stripos($product['price'],"/")===false && !empty($unitText)) {
                            if ($unitText === 'm2') {
                                $txt = str_replace('2', '<sup>2</sup>', $unitText);
                            } elseif ($unitText === 'm3') {
                                $txt = str_replace('3', '<sup>3</sup>', $unitText);
                            } else {
                                $txt = $unitText;
                            }
                            $product['price'] .= '/' . $txt;
                            if (!empty($product['special'])) {
                                $product['special'].= '/' . $txt;
                            }
                        }
                    }
                    if ($this->verifyProductPricingPlus()) {
                        $that->load->model('extension/product_pricing_plus');
                        $product_id = $product['product_id'];
                        $settings=$that->model_extension_product_pricing_plus->getSettings($product_id);
                        if ($settings['show_product_listing']==='1') {
                            $price = html_entity_decode($settings['content']);
                            if ($product['special']) {
                                $special= $price.' '.$product['special'];
                                $price= $product['price'];
                            } else {
                                if ($product['price']!=='$0.00') {
                                    $price .= ' ' . $product['price'];
                                }
                                $special= $product['special'];
                            }
                        } else {
                            $price = $product['price'];
                            $special = $product['special'];
                        }
                    } else {
                        $price = $product['price'];
                        $special = $product['special'];
                    }
                    $this->data['products'][] = [
						'product_id'     => $product['product_id'],
						'name'           => $product['name'],
						'description'    => $product['description'],
						'blurb'          => html_entity_decode( $product['blurb'] ),
						'model'          => $product['model'],
						'rating'         => $product['rating'],
						'stars'          => $product['stars'],
						'price'          => $price,
						'call_to_order'  => $product['call_to_order'],
						'options'        => $product['options'],
						'special'        => $special,
						'thumb'          => $product['thumb'],
						'href'           => $product['href'],
						'add'            => $product['add'],
						'track_stock'    => $product['track_stock'],
						'in_stock'       => $product['in_stock'],
						'no_stock_text'  => $product['no_stock_text'],
						'total_quantity' => $product['total_quantity'],
						'tax_class_id'   => $product['tax_class_id'],
					];
				}
				$that->view->assign( 'products', $this->data['products'] );
			}
		}
	}

	public function onControllerPagesProductCategory_UpdateData() {
		if (!$this->_is_enabled()) {
			return null;
		}
		$that =& $this->baseObject;
		if ( $this->baseObject_method === 'main' ) {
			$this->data['products'] = [];
			$products               = $that->data['products'];
			if ($products) {
				foreach ( $products as $product ) {
                    if  ($this->verifyAreaCalc() || $this->verifyVolumeCalc() || $this->verifyLiquidsCalc() || $this->verifyLengthCalc() || $this->verifyWeightCalc()) {
                        $query = $that->db->query("SELECT unit_text FROM ".$that->db->table("calculator_text"). " WHERE product_id=".(int)$product['product_id']);
                        $unitText=$query->row['unit_text'];
                        if (stripos($product['price'],"/")===false && !empty($unitText)) {
                            if ($unitText === 'm2') {
                                $txt = str_replace('2', '<sup>2</sup>', $unitText);
                            } elseif ($unitText === 'm3') {
                                $txt = str_replace('3', '<sup>3</sup>', $unitText);
                            } else {
                                $txt = $unitText;
                            }
                            $product['price'] .= '/' . $txt;
                            if (!empty($product['special'])) {
                                $product['special'].= '/' . $txt;
                            }
                        }
                    }
                    if ($this->verifyProductPricingPlus()) {
                        $that->load->model('extension/product_pricing_plus');
                        $product_id = $product['product_id'];
                        $settings=$that->model_extension_product_pricing_plus->getSettings($product_id);
                        if ($settings['show_product_listing']==='1') {
                            $price = html_entity_decode($settings['content']);
                            if ($product['special']) {
                                $special= $price.' '.$product['special'];
                                $price= $product['price'];
                            } else {
                                if ($product['price']!=='$0.00') {
                                    $price .= ' ' . $product['price'];
                                }
                                $special= $product['special'];
                            }
                        } else {
                            $price = $product['price'];
                            $special = $product['special'];
                        }
                    } else {
                        $price = $product['price'];
                        $special = $product['special'];
                    }
                    $this->data['products'][] = [
						'product_id'     => $product['product_id'],
						'name'           => $product['name'],
						'description'    => $product['description'],
						'blurb'          => html_entity_decode( $product['blurb'] ),
						'model'          => $product['model'],
						'rating'         => $product['rating'],
						'stars'          => $product['stars'],
						'price'          => $price,
						'call_to_order'  => $product['call_to_order'],
						'options'        => $product['options'],
						'special'        => $special,
						'thumb'          => $product['thumb'],
						'href'           => $product['href'],
						'add'            => $product['add'],
						'track_stock'    => $product['track_stock'],
						'in_stock'       => $product['in_stock'],
						'no_stock_text'  => $product['no_stock_text'],
						'total_quantity' => $product['total_quantity'],
						'tax_class_id'   => $product['tax_class_id'],
					];
				}
				$that->view->assign( 'products', $this->data['products'] );
			}
		}
	}

	public function onControllerPagesProductManufacturer_UpdateData() {
		if (!$this->_is_enabled()) {
			return null;
		}
		$that =& $this->baseObject;
		if ($this->baseObject_method === 'main' ) {
			$this->data['products'] = [];
			$products               = $that->data['products'];
			if ($products) {
				foreach ( $products as $product ) {
                    if  ($this->verifyAreaCalc() || $this->verifyVolumeCalc() || $this->verifyLiquidsCalc() || $this->verifyLengthCalc() || $this->verifyWeightCalc()) {
                        $query = $that->db->query("SELECT unit_text FROM ".$that->db->table("calculator_text"). " WHERE product_id=".(int)$product['product_id']);
                        $unitText=$query->row['unit_text'];
                        if (stripos($product['price'],"/")===false && !empty($unitText)) {
                            if ($unitText === 'm2') {
                                $txt = str_replace('2', '<sup>2</sup>', $unitText);
                            } elseif ($unitText === 'm3') {
                                $txt = str_replace('3', '<sup>3</sup>', $unitText);
                            } else {
                                $txt = $unitText;
                            }
                            $product['price'] .= '/' . $txt;
                            if (!empty($product['special'])) {
                                $product['special'].= '/' . $txt;
                            }
                        }
                    }
                    if ($this->verifyProductPricingPlus()) {
                        $that->load->model('extension/product_pricing_plus');
                        $product_id = $product['product_id'];
                        $settings=$that->model_extension_product_pricing_plus->getSettings($product_id);
                        if ($settings['show_product_listing']==='1') {
                            $price = html_entity_decode($settings['content']);
                            if ($product['special']) {
                                $special= $price.' '.$product['special'];
                                $price= $product['price'];
                            } else {
                                if ($product['price']!=='$0.00') {
                                    $price .= ' ' . $product['price'];
                                }
                                $special= $product['special'];
                            }
                        } else {
                            $price = $product['price'];
                            $special = $product['special'];
                        }
                    } else {
                        $price = $product['price'];
                        $special = $product['special'];
                    }
                    $this->data['products'][] = [
						'product_id'     => $product['product_id'],
						'name'           => $product['name'],
						'description'    => $product['description'],
						'blurb'          => html_entity_decode( $product['blurb'] ),
						'model'          => $product['model'],
						'rating'         => $product['rating'],
						'stars'          => $product['stars'],
						'price'          => $price,
						'call_to_order'  => $product['call_to_order'],
						'options'        => $product['options'],
						'special'        => $special,
						'thumb'          => $product['thumb'],
						'href'           => $product['href'],
						'add'            => $product['add'],
						'track_stock'    => $product['track_stock'],
						'in_stock'       => $product['in_stock'],
						'no_stock_text'  => $product['no_stock_text'],
						'total_quantity' => $product['total_quantity'],
						'tax_class_id'   => $product['tax_class_id'],
					];
				}
				$that->view->assign( 'products', $this->data['products'] );
			}
		}
	}

	public function onControllerPagesProductSearch_UpdateData() {
		if (!$this->_is_enabled()) {
			return null;
		}
		if ($this->baseObject_method == 'main') {
			$that =& $this->baseObject;

			$this->data['products'] = [];
			$products               = $that->data['products'];
			if ($products) {
				foreach ( $products as $product ) {
                    if  ($this->verifyAreaCalc() || $this->verifyVolumeCalc() || $this->verifyLiquidsCalc() || $this->verifyLengthCalc() || $this->verifyWeightCalc()) {
                        $query = $that->db->query("SELECT unit_text FROM ".$that->db->table("calculator_text"). " WHERE product_id=".(int)$product['product_id']);
                        $unitText=$query->row['unit_text'];
                        if (stripos($product['price'],"/")===false && !empty($unitText)) {
                            if ($unitText === 'm2') {
                                $txt = str_replace('2', '<sup>2</sup>', $unitText);
                            } elseif ($unitText === 'm3') {
                                $txt = str_replace('3', '<sup>3</sup>', $unitText);
                            } else {
                                $txt = $unitText;
                            }
                            $product['price'] .= '/' . $txt;
                            if (!empty($product['special'])) {
                                $product['special'].= '/' . $txt;
                            }
                        }
                    }
                    if ($this->verifyProductPricingPlus()) {
                        $that->load->model('extension/product_pricing_plus');
                        $product_id = $product['product_id'];
                        $settings=$that->model_extension_product_pricing_plus->getSettings($product_id);
                        if ($settings['show_product_listing']==='1') {
                            $price = html_entity_decode($settings['content']);
                            if ($product['special']) {
                                $special= $price.' '.$product['special'];
                                $price= $product['price'];
                            } else {
                                if ($product['price']!=='$0.00') {
                                    $price .= ' ' . $product['price'];
                                }
                                $special= $product['special'];
                            }
                        } else {
                            $price = $product['price'];
                            $special = $product['special'];
                        }
                    } else {
                        $price = $product['price'];
                        $special = $product['special'];
                    }
					$this->data['products'][] = [
						'product_id'     => $product['product_id'],
						'name'           => $product['name'],
						'description'    => $product['description'],
						'blurb'          => html_entity_decode( $product['blurb'] ),
						'model'          => $product['model'],
						'rating'         => $product['rating'],
						'stars'          => $product['stars'],
						'price'          => $price,
						'call_to_order'  => $product['call_to_order'],
						'options'        => $product['options'],
						'special'        => $special,
						'thumb'          => $product['thumb'],
						'href'           => $product['href'],
						'add'            => $product['add'],
						'track_stock'    => $product['track_stock'],
						'in_stock'       => $product['in_stock'],
						'no_stock_text'  => $product['no_stock_text'],
						'total_quantity' => $product['total_quantity'],
						'tax_class_id'   => $product['tax_class_id'],
					];
				}
				$that->view->assign( 'products', $this->data['products'] );
			}
		}
	}

    public function onControllerCommonHead_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'main') {
            if (IS_ADMIN) {
                $support = editorVerifySupport();
                if ($support['notification_case'] === 'notification_license_ok') {
                    $that->load->language('editor/editor');
                    $getVersions = editorUpdaterGetAllVersions();
                    $that->load->model('extension/editor_updater');
                    $current_version = $that->model_extension_editor_updater->getCurrentVersion();
                    if ($getVersions['notification_case'] !== 'notification_product_no_versions') {
                        $versions = $getVersions['notification_data']['product_versions'];
                        $total = $that->model_extension_editor_updater->getTotalMsgIds();
                        if ($total > '0') {
                            $msg_ids = $that->model_extension_editor_updater->getMsgIdsByCartVersions();
                            foreach ($msg_ids as $msg_id) {
                                $that->messages->deleteMessage($msg_id['msg_id']);
                                $that->model_extension_editor_updater->deleteMsgID($msg_id['msg_id']);
                            }
                        }
                        if ($versions) {
                            $latestVersions=[];
                            foreach ($versions as $version) {
                                if (strpos($version['version_number'],VERSION)!==false) {
                                    $latestVersions[]=$version['version_number'];
                                }
                            }
                            usort($latestVersions,'version_compare');
                            $latestVersion=end($latestVersions);
                            if (version_compare($current_version, $latestVersion, '<') === true) {
                                $msg_ids = $that->model_extension_editor_updater->getMsgIdsByCurrentCartVersion();
                                foreach ($msg_ids as $msg_id) {
                                    $that->messages->deleteMessage($msg_id['msg_id']);
                                    $that->model_extension_editor_updater->deleteMsgID($msg_id['msg_id']);
                                }
                                $msg_title = str_replace('[new_version]', $latestVersion, $that->language->get('text_new_editor_version_title'));
                                $msg=str_replace('[version_number]',str_replace('.','-',$latestVersion),$that->language->get('text_new_editor_version_description'));
                                $that->messages->saveNotice($msg_title, $msg);
                                $msg_info = $that->messages->getLikeMessage($msg_title);
                                $that->model_extension_editor_updater->saveMessageId($msg_info['msg_id'],$latestVersion);
                            }
                        }
                    }
                }
            }
        }
    }
}