<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2022 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE') || !IS_ADMIN) {
    header('Location: static_pages/');
}

class ControllerResponsesListingGridTelephone extends AController {
	public $error = '';

	/**
	 * update only one field
	 *
	 * @return null
	 */
	public function update_field() {

		//init controller data
		$this->extensions->hk_InitData($this, __FUNCTION__);

		$this->loadLanguage('sale/customer');
		$this->loadModel('sale/customer');

		if (!$this->user->canModify('listing_grid/customer')) {
			$error = new AError('');
			return $error->toJSONResponse('NO_PERMISSIONS_402',
											['error_text' => sprintf($this->language->get('error_permission_modify'), 'listing_grid/customer'),
												   'reset_value' => true
											]);
		
		}
		$customer_id = $this->request->get['id'];
		$address_id = $this->request->get['address_id'];
		$post_data = $this->request->post;
        if (isset($customer_id)) {
			if ( $post_data['password'] || $post_data['password_confirm']  ) {
				$error = new AError('');
		    	if (mb_strlen($post_data['password']) < 4) {
					return $error->toJSONResponse('VALIDATION_ERROR_406',
														['error_text' => $this->language->get('error_password'),
															'reset_value' => true
														]);
		    	}
		    	if ($post_data['password'] != $post_data['password_confirm']) {
					return $error->toJSONResponse('VALIDATION_ERROR_406',
														['error_text' => $this->language->get('error_confirm'),
															'reset_value' => true
														]);
		    	}			
		    	//paswords do match, save 
		    	$this->model_sale_customer->editCustomerField($customer_id, 'password', $post_data['password']);
			} else {
				foreach ($post_data as $field => $value) {
					$err = $this->_validateForm($field, $value, $customer_id);
					if (!$err) {
						if($field == 'approved') {
							$this->_sendMail($customer_id, $value);
						}
						if($field == 'default' && $address_id) {
							$this->model_sale_customer->setDefaultAddress($customer_id, $address_id);
						}
						else if( has_value($address_id) ){
							$this->model_sale_customer->editAddressField($address_id, $field, $value);
						}else{
							$this->model_sale_customer->editCustomerField($customer_id, $field, $value);
						}
					} else {
						$error = new AError('');
						return $error->toJSONResponse('VALIDATION_ERROR_406',
														['error_text' => $err,
															'reset_value' => false
														]);
	
					}
				}			
			}
			//update controller data
			$this->extensions->hk_UpdateData($this, __FUNCTION__);
			return null;
		}

		//request sent from jGrid. ID is key of array
		foreach ($this->request->post as $field => $value) {
			foreach ($value as $k => $v) {
				$err = $this->_validateForm($field, $v);
				if (!$err) {
					if ($field == 'approved') {
						$this->_sendMail(key($value), current($value));
					}
					$this->model_sale_customer->editCustomerField($k, $field, $v);
				} else {
					$error = new AError('');
					return $error->toJSONResponse('VALIDATION_ERROR_406',
																		['error_text' => $err,
																			'reset_value' => false
																		]);
				}
			}
		}

		//update controller data
		$this->extensions->hk_UpdateData($this, __FUNCTION__);
	}

	private function _validateForm($field, $value, $customer_id = '') {
        $this->load->language('telephone_option/telephone_option');
		switch ($field) {
			case 'loginname' :
				$login_name_pattern = '/^[\w._-]+$/i';
				$value = preg_replace('/\s+/', '', $value);
   		 		if ( mb_strlen($value) < 5 || mb_strlen($value) > 64
   		 			|| (!preg_match($login_name_pattern, $value) && $this->config->get('prevent_email_as_login')) ) {	
   		   			$this->error = $this->language->get('error_loginname');
   				//check uniqunes of loginname
   		 		} else if ( !$this->model_sale_customer->is_unique_loginname($value, $customer_id) ) {
   		   			$this->error = $this->language->get('error_loginname_notunique');
   		 		}			
				break;
			case 'firstname' :
				if (mb_strlen($value) < 1 || mb_strlen($value) > 32 ) {
					$this->error = $this->language->get('error_firstname');
				}
				break;
			case 'lastname':
				if ( mb_strlen($value) < 1 || mb_strlen($value) > 32 ) {
					$this->error = $this->language->get('error_lastname');
				}
				break;
			case 'email':
				if ( mb_strlen($value) > 96 || !preg_match(EMAIL_REGEX_PATTERN, $value) ) {
					$this->error = $this->language->get('error_email');
				}
				break;
            case 'telephone':
                if ($this->config->get('telephone_option_mandatory_status')) {
                    if (empty($value) || (mb_strlen($value) < 3) || (mb_strlen($value) > 32)) {
                        $this->error = $this->language->get('telephone_error');
                    }
                }
                break;
            case 'fax':
                if ($this->config->get('fax_option_mandatory_status')) {
                    if (empty($value) || ((mb_strlen($value) > 32) && strtolower($value) != 'na' && strtolower($value) != 'none')) {
                        $this->error = $this->language->get('fax_error');
			}
           	     }
                break;
            case 'company':
                if ($this->config->get('company_option_mandatory_status')) {
                    if (empty($value)) {
                        $this->error = $this->language->get('company_error');
                    }
                }
                break;
			case 'address_1':
				if ( mb_strlen($value) < 1 ) {
					$this->error = $this->language->get('error_address_1');
				}
				break;
			case 'city':
				if ( mb_strlen($value) < 1 ) {
					$this->error = $this->language->get('error_city');
				}
				break;
			case 'country_id':
				if ( empty($value) || $value=='FALSE' ) {
					$this->error = $this->language->get('error_country');
				}
				break;
			case 'zone_id':
				if ( empty($value) || $value=='FALSE' ) {
					$this->error = $this->language->get('error_zone');
				}
				break;
		}

		$this->extensions->hk_ValidateData($this);

		return $this->error;
	}

	private function _sendMail($id, $approved) {

		// send email to customer
		$customer_info = $this->model_sale_customer->getCustomer($id);
		if ($customer_info && !$customer_info[ 'approved' ] && $approved) {

			$this->loadLanguage('mail/customer');
			$this->loadModel('setting/store');

			$store_info = $this->model_setting_store->getStore($customer_info[ 'store_id' ]);

			if ($store_info) {
				$store_name = $store_info[ 'store_name' ];
				$store_url = $store_info[ 'config_url' ] . 'index.php?rt=account/login';
				$store_logo_file = DIR_RESOURCE . $store_info['config_logo'];
				$store_logo = md5(pathinfo($store_info['config_logo'], PATHINFO_FILENAME)) . '.' . pathinfo($store_info['config_logo'], PATHINFO_EXTENSION);
			} else {
				$store_name = $this->config->get('store_name');
				$store_url = $this->config->get('config_url') . 'index.php?rt=account/login';
				$store_logo = md5(pathinfo($this->config->get('config_logo'), PATHINFO_FILENAME)) . '.' . pathinfo($this->config->get('config_logo'), PATHINFO_EXTENSION);
				$store_logo_file = DIR_RESOURCE . $this->config->get('config_logo');
			}

			$plain_text = sprintf($this->language->get('text_welcome'), $store_name) . "\n\n";

			$plain_text .= $this->language->get('text_login') . "\n";
			$plain_text .= $store_url . "\n\n";
			$plain_text .= $this->language->get('text_services') . "\n\n";
			$plain_text .= $this->language->get('text_thanks') . "\n";
			$plain_text .= $store_name;


			//build HTML message with the template
			$template = new ATemplate();
			$template->data['text_welcome'] = sprintf($this->language->get('text_welcome'), $store_name) . "\n\n";

			$template->data['text_login'] = $this->language->get('text_login');
			$template->data['text_login_later'] = '<a href="' . $store_url . '">' . $store_url . '</a>';
			$template->data['text_services'] = $this->language->get('text_services');


			$template->data['logo'] = 'cid:' . $store_logo;
			$template->data['store_name'] = $store_name;
			$template->data['store_url'] = $store_url;
			$template->data['text_thanks'] = $this->language->get('text_thanks');

			$template->data['text_project_label'] = project_base();
			$html_body = $template->fetch('mail/account_create.tpl');

			$mail = new AMail($this->config);
			$mail->setTo($customer_info[ 'email' ]);
			$mail->setFrom($this->config->get('store_main_email'));
			$mail->setSender($store_name);
			$mail->setSubject(sprintf($this->language->get('text_subject'), $store_name));
			$mail->setText(html_entity_decode($plain_text, ENT_QUOTES, 'UTF-8'));
			$mail->setHtml($html_body);
			$mail->addAttachment($store_logo_file, $store_logo);
			$mail->send();
		}
	}

}