<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2021 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

require_once DIR_EXT. "quick_grid_export" . DIR_EXT_CORE ."helpers.php";
require_once DIR_EXT. "quick_grid_export" . DIR_EXT_CORE ."updater.php";

class ExtensionQuickGridExport extends Extension {

    public function __construct(){
        $this->registry = Registry::getInstance();
    }

    private function _is_enabled() {
        return $this->baseObject->config->get('quick_grid_export_status') ? $this->verify() : false;
    }

    public function verify() {
        $that  =& $this->baseObject;
        $exist = $that->db->query( "SHOW TABLES LIKE '" . $that->db->table( 'quick_grid_export_license' ) . "'" );
        if ( $exist->num_rows === 1 ) {
            $validation = quickGridExportVerifyLicense();
            if ( $validation['notification_case'] === 'notification_license_ok' ) {
                return true;
            } elseif ( $validation['notification_case'] === 'notification_license_corrupted' ) {
                return false;
            }
        } else {
            return false;
        }
    }

    public function onControllerPagesExtensionExtensions_InitData() {
        $that =& $this->baseObject;
        if ( $this->baseObject_method === 'edit' ) {
            $extension = $that->request->get['extension'];
            if ( $extension === 'quick_grid_export' ) {
                if ( $that->request->is_POST() ) {
                    $exist = $that->db->query( "SHOW TABLES LIKE '" . $that->db->table( 'quick_grid_export_license' ) . "'" );
                    if ( $exist->num_rows === 1 ) {
                        if ($this->verify()===true) {
                            quickGridExportUninstallLicense();
                        } else {
                            $that->db->query("DROP TABLE IF EXISTS ".$that->db->table('quick_grid_export_license'));
                        }
                        quickGridExportInstallLicense( $that->request->post['quick_grid_export_license_code'] );
                    } else {
                        $license = quickGridExportInstallLicense( $that->request->post['quick_grid_export_license_code'] );
                        if ( $license['notification_case'] !== 'notification_license_ok' ) {
                            $that->session->data['error'] = $license['notification_text'];
                        } else {
                            $that->session->data['success'] = "The license key is valid";
                        }
                    }
                }
            }
        }
    }

    public function onControllerResponsesListingGridExtension_UpdateData() {
        $that =& $this->baseObject;
        if ($this->baseObject_method==='update') {
            if ($that->request->post['quick_grid_export_license_code']) {
                $exist = $that->db->query("SHOW TABLES LIKE '".$that->db->table('quick_grid_export_license')."'");
                if ($exist->num_rows === 1) {
                    if ($this->verify()===true) {
                        quickGridExportUninstallLicense();
                    } else {
                        $that->db->query("DROP TABLE IF EXISTS ".$that->db->table('quick_grid_export_license'));
                    }
                    quickGridExportInstallLicense( $that->request->post['quick_grid_export_license_code'] );
                } else {
                    $license = quickGridExportInstallLicense( $that->request->post['quick_grid_export_license_code'] );
                    if ( $license['notification_case'] !== 'notification_license_ok' ) {
                        $that->session->data['error'] = $license['notification_text'];
                    } else {
                        $that->session->data['success'] = "The license key is valid";
                    }
                }
            }
        }
    }

	public function onControllerCommonListingGrid_InitData() {
        if (!$this->_is_enabled()) {
            return null;
        }
		$that =& $this->baseObject;

		$that->loadLanguage('quick_grid_export/quick_grid_export');
		// we need to know where jgrid looking for table data
		$response_url = parse_url($that->data['url'],PHP_URL_QUERY);
		$response_url = explode("&",$response_url);
		foreach($response_url as $value){
			$value = explode("=",$value);
			if($value[0]=='rt'){
				$route = $value[1];
				break;
			}
		}

		if ($this->getRoute($route)==true) {
            $that->session->data['quick_grid_export_settings'] = $that->data;
            $that->data['export_url'] = $that->html->getSecureURL('extension/quick_grid_export', '&controller=' . $route);
            $that->data['custom_buttons'][0] = [
                "id" => 'export',
                "title" => 'export',
                "caption" => $that->language->get('quick_grid_export_button_text'),
                "onClickButton" => 'function(){ do_export();}'];
            $that->data['quick_grid_export_format'] = $that->language->get('quick_grid_export_format');
            $that->data['text_xls'] = $that->language->get('text_xls');
            $that->data['text_xlsx'] = $that->language->get('text_xlsx');
        }
	}

    public function onControllerCommonCostPlusListingGrid_InitData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method==='main') {
            $that->loadLanguage('quick_grid_export/quick_grid_export');
            // we need to know where jgrid looking for table data
            $response_url = parse_url($that->data['url'], PHP_URL_QUERY);
            $response_url = explode("&", $response_url);
            foreach ($response_url as $value) {
                $value = explode("=", $value);
                if ($value[0] == 'rt') {
                    $route = $value[1];
                    break;
                }
            }
            if ($this->getRoute($route) == true) {
                $that->session->data['quick_grid_export_settings'] = $that->data;
                $that->data['export_url'] = $that->html->getSecureURL('extension/quick_grid_export', '&controller=' . $route);
                $that->data['custom_buttons'][0] = [
                    "id" => 'export',
                    "title" => 'export',
                    "caption" => $that->language->get('quick_grid_export_button_text'),
                    "onClickButton" => 'function(){ do_export();}'];
                $that->data['quick_grid_export_format'] = $that->language->get('quick_grid_export_format');
                $that->data['text_xls'] = $that->language->get('text_xls');
                $that->data['text_xlsx'] = $that->language->get('text_xlsx');
            }
        }
    }

    public function onControllerCommonMultipleDiscountManagerListingGrid_InitData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method==='main') {
            $that->loadLanguage('quick_grid_export/quick_grid_export');
            // we need to know where jgrid looking for table data
            $response_url = parse_url($that->data['url'], PHP_URL_QUERY);
            $response_url = explode("&", $response_url);
            foreach ($response_url as $value) {
                $value = explode("=", $value);
                if ($value[0] == 'rt') {
                    $route = $value[1];
                    break;
                }
            }
            if ($this->getRoute($route) == true) {
                $that->session->data['quick_grid_export_settings'] = $that->data;
                $that->data['export_url'] = $that->html->getSecureURL('extension/quick_grid_export', '&controller=' . $route);
                $that->data['custom_buttons'][0] = [
                    "id" => 'export',
                    "title" => 'export',
                    "caption" => $that->language->get('quick_grid_export_button_text'),
                    "onClickButton" => 'function(){ do_export();}'];
                $that->data['quick_grid_export_format'] = $that->language->get('quick_grid_export_format');
                $that->data['text_xls'] = $that->language->get('text_xls');
                $that->data['text_xlsx'] = $that->language->get('text_xlsx');
            }
        }
    }

    public function onControllerCommonMultiplePriceListingGrid_InitData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method==='main') {
            $that->loadLanguage('quick_grid_export/quick_grid_export');
            // we need to know where jgrid looking for table data
            $response_url = parse_url($that->data['url'], PHP_URL_QUERY);
            $response_url = explode("&", $response_url);
            foreach ($response_url as $value) {
                $value = explode("=", $value);
                if ($value[0] == 'rt') {
                    $route = $value[1];
                    break;
                }
            }
            if ($this->getRoute($route) == true) {
                $that->session->data['quick_grid_export_settings'] = $that->data;
                $that->data['export_url'] = $that->html->getSecureURL('extension/quick_grid_export', '&controller=' . $route);
                $that->data['custom_buttons'][0] = [
                    "id" => 'export',
                    "title" => 'export',
                    "caption" => $that->language->get('quick_grid_export_button_text'),
                    "onClickButton" => 'function(){ do_export();}'];
                $that->data['quick_grid_export_format'] = $that->language->get('quick_grid_export_format');
                $that->data['text_xls'] = $that->language->get('text_xls');
                $that->data['text_xlsx'] = $that->language->get('text_xlsx');
            }
        }
    }

	private function getRoute($route) {
	    $enable_export = false;
	    switch ($route) {
            case 'listing_grid/report_purchased':
            case 'listing_grid/report_sale':
            case 'listing_grid/report_sale/taxes':
            case 'listing_grid/report_sale/shipping':
            case 'listing_grid/report_sale/coupons':
            case 'listing_grid/report_customer/online':
            case 'listing_grid/report_customer/orders':
            case 'listing_grid/report_customer/transactions':
            case 'listing_grid/report_viewed':
            case 'listing_grid/banner_manager_stat':
                $enable_export=false;
                break;
            default :
                $enable_export=true;
                break;
        }

        return $enable_export;
    }

    public function onControllerCommonHead_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'main') {
            if (IS_ADMIN) {
                $support = quickGridExportVerifySupport();
                if ($support['notification_case'] === 'notification_license_ok') {
                    $that->load->language('quick_grid_export/quick_grid_export');
                    $getVersions = quickGridExportUpdaterGetAllVersions();
                    $that->load->model('extension/quick_grid_export_updater');
                    $current_version = $that->model_extension_quick_grid_export_updater->getCurrentVersion();
                    if ($getVersions['notification_case'] !== 'notification_product_no_versions') {
                        $versions = $getVersions['notification_data']['product_versions'];
                        $total = $that->model_extension_quick_grid_export_updater->getTotalMsgIds();
                        if ($total > '0') {
                            $msg_ids = $that->model_extension_quick_grid_export_updater->getMsgIdsByCartVersions();
                            foreach ($msg_ids as $msg_id) {
                                $that->messages->deleteMessage($msg_id['msg_id']);
                                $that->model_extension_quick_grid_export_updater->deleteMsgID($msg_id['msg_id']);
                            }
                        }
                        if ($versions) {
                            $latestVersions = [];
                            foreach ($versions as $version) {
                                if (strpos($version['version_number'], VERSION) !== false) {
                                    $latestVersions[] = $version['version_number'];
                                }
                            }
                            usort($latestVersions, 'version_compare');
                            $latestVersion = end($latestVersions);
                            if (version_compare($current_version, $latestVersion, '<') === true) {
                                $msg_ids = $that->model_extension_quick_grid_export_updater->getMsgIdsByCurrentCartVersion();
                                foreach ($msg_ids as $msg_id) {
                                    $that->messages->deleteMessage($msg_id['msg_id']);
                                    $that->model_extension_quick_grid_export_updater->deleteMsgID($msg_id['msg_id']);
                                }
                                $msg_title = str_replace('[new_version]', $latestVersion, $that->language->get('text_new_quick_grid_export_version_title'));
                                $msg = str_replace('[version_number]', str_replace('.', '-', $latestVersion), $that->language->get('text_new_quick_grid_export_version_description'));
                                $that->messages->saveNotice($msg_title, $msg);
                                $msg_info = $that->messages->getLikeMessage($msg_title);
                                $that->model_extension_quick_grid_export_updater->saveMessageId($msg_info['msg_id'], $latestVersion);
                            }
                        }
                    }
                }
            }
        }
    }

}