<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2021 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

class ModelExtensionQuickGridExport extends Model {

    /**
     * @param array $data
     *
     * @return array
     */
    public function getProductPurchasedReport($data = []) {
       $start = (int)$data['start'];
        if ($start < 0) {
            $start = 0;
        }
        $limit = (int)$data['limit'];
        if ($limit < 1) {
            $limit = 20;
        }
        $implode = ["o.order_status_id > '0'"];
        if (!empty($data['filter']['date_start'])) {
            $date_start = dateDisplay2ISO($data['filter']['date_start'], $this->language->get('date_format_short'));
            $implode[] = " DATE_FORMAT(o.date_added,'%Y-%m-%d') >= DATE_FORMAT('".$this->db->escape($date_start)."','%Y-%m-%d') ";
        }
        if (!empty($data['filter']['date_end'])) {
            $date_end = dateDisplay2ISO($data['filter']['date_end'], $this->language->get('date_format_short'));
            $implode[] = " DATE_FORMAT(o.date_added,'%Y-%m-%d') <= DATE_FORMAT('".$this->db->escape($date_end)."','%Y-%m-%d') ";
        }

        if (!empty($data['filter']['price_filter'])) {
            if ($data['filter']['price_filter'] == 'only_free') {
                $implode[] = " op.price = 0 ";
            } elseif ($data['filter']['price_filter'] == 'not_free') {
                $implode[] = " op.price > 0 ";
            }
        }

        if ($data['subsql_filter']) {
            $implode[] = $data['subsql_filter'];
        }

        if (!isset($data['sort']) || !$data['sort']) {
            $data['sort'] = 'quantity';
        }
        if (!isset($data['order']) || !$data['order']) {
            $data['order'] = 'DESC';
        }
        $sql = "SELECT op.product_id, op.name, op.model, SUM(op.quantity) AS quantity, SUM(op.total + op.tax) AS total
				FROM `".$this->db->table("orders")."` o
				LEFT JOIN ".$this->db->table("order_products")." op 
					ON (op.order_id = o.order_id)
				WHERE ".implode(' AND ', $implode)."
				GROUP BY op.product_id, op.name, op.model
				ORDER BY ".$data['sort']." ".$data['order'].", op.model DESC
				LIMIT ".(int)$start.",".(int)$limit;
        $query = $this->db->query($sql);
        return $query->rows;
    }

}