<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2021 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}
/**
 * Class ControllerResponsesListingGridEmailSignaturesList
 * @property ModelExtensionEmailSignatures $model_extension_email_signatures
 */

class ControllerResponsesListingGridEmailSignaturesList extends AController {
    public $error = [];
    public $data = [];

    public function main() {
        //init controller data
        $this->extensions->hk_InitData($this, __FUNCTION__);

        $this->loadLanguage('email_editor/email_editor');
        $this->loadModel('extension/email_signatures');

        //Prepare filter config
        $filter_params = ['section'];
        $filter_grid = new AFilter(['method' => 'post',
            'grid_filter_params' => $filter_params,
            'additional_filter_string' => '']);


        $total = $this->model_extension_email_signatures->getAllSignatures($filter_grid->getFilterData(),'total_only');
        $response = new stdClass();
        $response->page = $filter_grid->getParam('page');
        $response->total = $filter_grid->calcTotalPages($total);
        $response->records = $total;
        $response->userdata = new stdClass();
        $response->userdata->classes = [];
        $results = $this->model_extension_email_signatures->getAllSignatures($filter_grid->getFilterData());

        $i = 0;
        foreach ($results as $result) {
            $response->rows[$i]['id'] = $result['email_signature_id'];
            $response->rows[$i]['cell'] = [
                $result['email_signature_id'],
                $result['title'],
            ];
            $i++;
        }

        $this->data['response'] = $response;
        //update controller data
        $this->extensions->hk_UpdateData($this, __FUNCTION__);
        $this->load->library('json');
        $this->response->setOutput(AJson::encode($this->data['response']));
    }

    public function edit() {
        //init controller data
        $this->extensions->hk_InitData($this, __FUNCTION__);

        if (!$this->user->canModify('listing_grid/email_signatures')) {
            $error = new AError('');
            return $error->toJSONResponse('NO_PERMISSIONS_402',
                ['error_text' => sprintf($this->language->get('error_permission_modify'), 'listing_grid/email_signatures'),
                    'reset_value' => true
                ]);
        }

        $this->loadModel('extension/email_signatures');
        $this->loadLanguage('email_editor/email_editor');

        switch ($this->request->post[ 'oper' ]) {
            case 'del':
                $ids = explode(',', $this->request->post[ 'id' ]);
                if (!empty($ids))
                    foreach ($ids as $id) {
                        $this->model_extension_email_signatures->deleteSignature($id);
                    }
                break;
            default:
                //print_r($this->request->post);
        }

        //update controller data
        $this->extensions->hk_UpdateData($this, __FUNCTION__);
    }

    /**
     * update only one field
     *
     * @return void
     */
    public function update_field() {
        //init controller data
        $this->extensions->hk_InitData($this, __FUNCTION__);

        if (!$this->user->canModify('listing_grid/email_signatures_list')) {
            $error = new AError('');
            return $error->toJSONResponse('NO_PERMISSIONS_402',
                ['error_text' => sprintf($this->language->get('error_permission_modify'), 'listing_grid/email_signatures_list'),
                    'reset_value' => true
                ]);
        }

        $this->loadLanguage('email_editor/email_editor');
        if ($this->request->is_POST()) {
            $this->loadModel('extension/email_signatures');
            foreach ($this->request->post as $field => $value) {
                $err = $this->_validateField($field, $value);
                if (!empty($err)) {
                    $error = new AError('');
                    return $error->toJSONResponse('VALIDATION_ERROR_406', ['error_text' => $err]);
                }
                if (is_array($value)) {
                    foreach ($value as $id => $val) {
                        $tmp[$field] = (int)$val;
                        $this->model_extension_email_signatures->updateSignature($id, $tmp);
                    }
                } else {
                    if ((int)$this->request->get['id']) {
                        $this->model_extension_email_signatures->updateSignature($this->request->get['id'], [$field => $value]);
                    }
                }
            }
        }

        //update controller data
        $this->extensions->hk_UpdateData($this, __FUNCTION__);
    }

    private function _validateField($field, $value) {
        $this->data['error'] = '';
        switch ($field) {
            case 'title' :
                if (empty($value)) {
                    $this->data['error'] = $this->language->get('error_title');
                }
                break;
            case 'content' :
                if (empty($value)) {
                    $this->data['error'] = $this->language->get('error_content');
                }
                break;
        }
        $this->extensions->hk_ValidateData($this, [__FUNCTION__, $field, $value]);
        return $this->data['error'];
    }
}