<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2024 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/
if ( !defined ( 'DIR_CORE' )) {
    header ( 'Location: static_pages/' );
}

require_once DIR_SYSTEM . "lib/vendor/autoload.php";

/**
 * ModelExtensionUpsIntegration
 * @property ModelExtensionUpsVerify $model_extension_ups_verify
 */

class ModelExtensionUpsIntegration extends Model {

    /**
     * @param $address
     * @return array
     * @throws AException
     */
    function getQuote($address) {
        $this->load->model('extension/ups_verify');
        $verify = $this->model_extension_ups_verify->verify();
        if ($verify===true) {
    	    $cart = $this->cart;
            $store_id = $this->getStoreId();
            $settings = $this->getSetting('ups_integration', $store_id);
		    $this->extensions->hk_InitData($this, __FUNCTION__);
		    $this->load->language( 'ups_integration/ups_integration' );
            if ( $settings['ups_integration_status']) {
			    $this->load->model( 'localisation/country' );
			    if ( ! $this->settings['ups_integration_location_id']) {
				    $status = true;
			    } else {
				    $query = $this->db->query( "SELECT *
											FROM " . $this->db->table( 'zones_to_locations' ) . "
											WHERE location_id = '" . (int) $settings['ups_integration_location_id'] . "'
												AND country_id = '" . (int) $address['country_id'] . "'
												AND (zone_id = '" . (int) $address['zone_id'] . "' OR zone_id = '0')" );
				    if ( $query->num_rows ) {
					    $status = true;
				    } else {
					    $status = false;
				    }
			    }
			    $countries = $this->model_localisation_country->getCountries();
			    foreach ( $countries as $item ) {
				    $country[ $item['iso_code_2'] ] = $item['name'];
			    }

			    if ( $status && ! has_value( $country[ $address['iso_code_2'] ] ) ) {
				    $status = false;
			    }

		    } else {
			    $status = false;
		    }

		    $method_data = [];
            if ( ! $status ) {
			    return $method_data;
		    }
		    $id                  = 'ups_integration.ups_integration';
		    $quote_data          = [];
		    $generic_product_ids = $free_shipping_ids = $shipping_price_ids = []; // ids of products without special shipping cost
		    $shipping_price_cost = 0; // total shipping cost of product with fixed shipping price
		    $cart_products       = $cart->getProducts();
		    foreach ( $cart_products as $product ) {
			    //(exclude free shipping products)
			    if ( $product['free_shipping'] || $product['download'] ) {
				    $free_shipping_ids[] = $product['product_id'];
				    continue;
			    }
			    if ( $product['shipping_price'] > 0 ) {
				    $shipping_price_ids[] = $product['product_id'];
				    $shipping_price_cost  += $product['shipping_price'] * $product['quantity'];
			    }
			    $generic_product_ids[] = $product['product_id'];
		    }
		    //convert fixed prices to USD
		    $shipping_price_cost = $this->currency->convert( $shipping_price_cost, $this->config->get( 'config_currency' ), $this->currency->getCode() );

		    if ( $generic_product_ids ) {
			    $api_weight_product_ids = array_diff( $generic_product_ids, $shipping_price_ids );
			    //WHEN ONLY PRODUCTS WITH FIXED SHIPPING PRICES ARE IN BASKET
			    if ( ! $api_weight_product_ids ) {
				    $cost       = $shipping_price_cost;
				    $quote_data = [
					    'ups_integration_plus' => [
						    'id'           => $id,
						    'title'        => $this->language->get( 'text_title' ),
						    'cost'         => $this->currency->convert( $cost, $this->config->get( 'config_currency' ), $this->config->get( 'config_currency' ) ),
						    'tax_class_id' => $settings['ups_integration_tax_class_id'],
						    'text'         => $this->currency->format($this->tax->calculate( $this->currency->convert($cost,
                                $this->config->get( 'config_currency' ),
                                $this->currency->getCode()),
                                $settings['ups_integration_tax_class_id'],
                                $this->config->get('config_tax')),
                                $this->currency->getCode(),
                                1.0000000)
                        ]
				    ];

				    $method_data = [
					    'id'         => 'ups_integration',
					    'title'      => $this->language->get( 'text_title' ),
					    'quote'      => $quote_data,
					    'sort_order' => $settings[ 'ups_integration_sort_order' ],
					    'error'      => ''
				    ];

				    return $method_data;
			    }
		    } else {
			    $api_weight_product_ids = $shipping_price_ids;
		    }
		    $basic_products          = $cart->basicShippingProducts();
		    $basic_products_subtotal = 0;
		    foreach ( $basic_products as $product ) {
			    $product_ids[]           = $product['product_id'];
			    $basic_products_subtotal += $product['total'];
		    }
            if ($basic_products) {
                $weight = $this->weight->convert($cart->getWeight($product_ids), $this->config->get('config_weight_class'), $this->config->get('config_weight_class')) + number_format((float)$settings['ups_integration_additional_weight'], 2, '.', '');
            } else {
                $weight = 0;
            }
            $weight    = ( $weight < 0.1 ? 0.1 : $weight );
            $euCountries = [
                'BE',
		        'BG',
                'CZ',
                'DK',
                'DE',
                'EE',
                'IE',
                'EL',
                'ES',
                'FR',
                'HR',
                'IT',
                'CY',
                'LV',
                'LT',
                'LU',
                'HU',
                'MT',
                'NL',
                'AT',
                'PT',
                'RO',
                'SI',
                'SK',
                'FI',
                'SE',
            ];
            if ( ! $api_weight_product_ids && $free_shipping_ids ) {
                $cost = 0.0;
                if ( $settings['ups_integration_origin']==='US') {
                    if ($address['iso_code_2'] === $settings['ups_integration_country'] && $settings[ 'ups_integration_free_us_method'] !== 'NONE') {
                        $quote_data = [
                            'ups_integration' => [
                                'id' => $id,
                                'title' => $this->language->get('text_us_origin_' . $settings['ups_integration_free_us_method']),
                                'cost' => $this->currency->convert($cost, $this->config->get('config_currency'), $this->config->get('config_currency')),
                                'tax_class_id' => $settings['ups_integration_tax_class_id'],
                                'text' => $this->currency->format(
                                    $this->tax->calculate($this->currency->convert($cost,
                                        $this->config->get('config_currency'),
                                        $this->currency->getCode()),
                                        $settings['ups_integration_tax_class_id'],
                                        $this->config->get('config_tax')),
                                    $this->currency->getCode(),
                                    1.0000000)
                            ]
                        ];
                    } elseif ($address['iso_code_2'] !== $settings['ups_integration_country'] && $settings[ 'ups_integration_free_us_international_method'] !== 'NONE') {
                        $quote_data = [
                            'ups_integration' => [
                                'id' => $id,
                                'title' => $this->language->get('text_us_origin_' . $settings['ups_integration_free_us_international_method']),
                                'cost' => $this->currency->convert($cost, $this->config->get('config_currency'), $this->config->get('config_currency')),
                                'tax_class_id' => $settings['ups_integration_tax_class_id'],
                                'text' => $this->currency->format(
                                    $this->tax->calculate($this->currency->convert($cost,
                                        $this->config->get('config_currency'),
                                        $this->currency->getCode()),
                                        $settings['ups_integration_tax_class_id'],
                                        $this->config->get('config_tax')),
                                    $this->currency->getCode(),
                                    1.0000000)
                            ]
                        ];
                    }
			    } elseif ($settings['ups_integration_origin']==='PR') {
                    if ( $address['iso_code_2'] === $settings['ups_integration_country'] && $settings[ 'ups_integration_free_pr_method'] !== 'NONE' ) {
                        $quote_data = [
                            'ups_integration' => [
                                'id' => $id,
                                'title' => $this->language->get('text_pr_origin_' . $settings['ups_integration_free_pr_method']),
                                'cost' => $this->currency->convert($cost, $this->config->get('config_currency'), $this->config->get('config_currency')),
                                'tax_class_id' => $settings['ups_integration_tax_class_id'],
                                'text' => $this->currency->format($this->tax->calculate($this->currency->convert($cost,
                                    $this->config->get('config_currency'),
                                    $this->currency->getCode()),
                                    $settings['ups_integration_tax_class_id'],
                                    $this->config->get('config_tax')),
                                    $this->currency->getCode(),
                                    1.0000000)
                            ]
                        ];
                    } elseif ( $address['iso_code_2'] !== $settings['ups_integration_country'] && $settings[ 'ups_integration_free_pr_international_method'] !== 'NONE' ) {
                        $quote_data = [
                            'ups_integration' => [
                                'id' => $id,
                                'title' => $this->language->get('text_pr_origin_' . $settings['ups_integration_free_pr_international_method']),
                                'cost' => $this->currency->convert($cost, $this->config->get('config_currency'), $this->config->get('config_currency')),
                                'tax_class_id' => $settings['ups_integration_tax_class_id'],
                                'text' => $this->currency->format($this->tax->calculate($this->currency->convert($cost,
                                    $this->config->get('config_currency'),
                                    $this->currency->getCode()),
                                    $settings['ups_integration_tax_class_id'],
                                    $this->config->get('config_tax')),
                                    $this->currency->getCode(),
                                    1.0000000)
                            ]
                        ];
                    }
                } elseif ($settings['ups_integration_origin']==='MX') {
                    if ( $address['iso_code_2'] === $settings['ups_integration_country'] && $settings[ 'ups_integration_free_mx_method' ] !== 'NONE' ) {
                        $quote_data = [
                            'ups_integration' => [
                                'id' => $id,
                                'title' => $this->language->get('text_mx_origin_' . $settings['ups_integration_free_mx_method']),
                                'cost' => $this->currency->convert($cost, $this->config->get('config_currency'), $this->config->get('config_currency')),
                                'tax_class_id' => $settings['ups_integration_tax_class_id'],
                                'text' => $this->currency->format($this->tax->calculate($this->currency->convert($cost,
                                    $this->config->get('config_currency'),
                                    $this->currency->getCode()),
                                    $settings['ups_integration_tax_class_id'],
                                    $this->config->get('config_tax')),
                                    $this->currency->getCode(),
                                    1.0000000)
                            ]
                        ];
                    } elseif ( $address['iso_code_2'] !== $settings['ups_integration_country'] && $settings[ 'ups_integration_free_mx_international_method' ] !== 'NONE' ) {
                        $quote_data = [
                            'ups_integration' => [
                                'id' => $id,
                                'title' => $this->language->get('text_mx_origin_' . $settings['ups_integration_free_mx_international_method']),
                                'cost' => $this->currency->convert($cost, $this->config->get('config_currency'), $this->config->get('config_currency')),
                                'tax_class_id' => $settings['ups_integration_tax_class_id'],
                                'text' => $this->currency->format($this->tax->calculate($this->currency->convert($cost,
                                    $this->config->get('config_currency'),
                                    $this->currency->getCode()),
                                    $settings['ups_integration_tax_class_id'],
                                    $this->config->get('config_tax')),
                                    $this->currency->getCode(),
                                    1.0000000)
                            ]
                        ];
                    }
			    } elseif ($settings['ups_integration_origin']==='CA') {
                    if ( $address['iso_code_2'] === $settings['ups_integration_country'] && $settings[ 'ups_integration_free_ca_method' ] !== 'NONE' ) {
                        $quote_data = [
                            'ups_integration' => [
                                'id' => $id,
                                'title' => $this->language->get('text_ca_origin_' . $settings['ups_integration_free_ca_method']),
                                'cost' => $this->currency->convert($cost, $this->config->get('config_currency'), $this->config->get('config_currency')),
                                'tax_class_id' => $settings['ups_integration_tax_class_id'],
                                'text' => $this->currency->format($this->tax->calculate($this->currency->convert($cost,
                                    $this->config->get('config_currency'),
                                    $this->currency->getCode()),
                                    $settings['ups_integration_tax_class_id'],
                                    $this->config->get('config_tax')),
                                    $this->currency->getCode(),
                                    1.0000000)
                            ]
                        ];
                    } elseif ( $address['iso_code_2'] !== $settings['ups_integration_country'] && $settings[ 'ups_integration_free_ca_international_method' ] !== 'NONE' ) {
                        $quote_data = [
                            'ups_integration' => [
                                'id' => $id,
                                'title' => $this->language->get('text_ca_origin_' . $settings['ups_integration_free_ca_international_method']),
                                'cost' => $this->currency->convert($cost, $this->config->get('config_currency'), $this->config->get('config_currency')),
                                'tax_class_id' => $settings['ups_integration_tax_class_id'],
                                'text' => $this->currency->format($this->tax->calculate($this->currency->convert($cost,
                                    $this->config->get('config_currency'),
                                    $this->currency->getCode()),
                                    $settings['ups_integration_tax_class_id'],
                                    $this->config->get('config_tax')),
                                    $this->currency->getCode(),
                                    1.0000000)
                            ]
                        ];
                    }
			    } elseif ($settings['ups_integration_origin']==='EU') {
                    if ( in_array($address['iso_code_2'],$euCountries) && $settings['ups_integration_free_eu_method'] !== 'NONE' ) {
                        $quote_data = [
                            'ups_integration' => [
                                'id' => $id,
                                'title' => $this->language->get('text_eu_origin_' . $settings['ups_integration_free_eu_method']),
                                'cost' => $this->currency->convert($cost, $this->config->get('config_currency'), $this->config->get('config_currency')),
                                'tax_class_id' => $settings['ups_integration_tax_class_id'],
                                'text' => $this->currency->format($this->tax->calculate($this->currency->convert($cost,
                                    $this->config->get('config_currency'),
                                    $this->currency->getCode()),
                                    $settings['ups_integration_tax_class_id'],
                                    $this->config->get('config_tax')),
                                    $this->currency->getCode(),
                                    1.0000000)
                            ]
                        ];
                    } elseif ( $address['iso_code_2'] !== $settings['ups_integration_country'] && $settings['ups_integration_free_eu_international_method'] !== 'NONE' ) {
                        $quote_data = [
                            'ups_integration' => [
                                'id' => $id,
                                'title' => $this->language->get('text_eu_origin_' . $settings['ups_integration_free_eu_international_method']),
                                'cost' => $this->currency->convert($cost, $this->config->get('config_currency'), $this->config->get('config_currency')),
                                'tax_class_id' => $settings['ups_integration_tax_class_id'],
                                'text' => $this->currency->format($this->tax->calculate($this->currency->convert($cost,
                                    $this->config->get('config_currency'),
                                    $this->currency->getCode()),
                                    $settings['ups_integration_tax_class_id'],
                                    $this->config->get('config_tax')),
                                    $this->currency->getCode(),
                                    1.0000000)
                            ]
                        ];
                    }
			    } elseif ($settings['ups_integration_origin']==='PL') {
                    if ( $address['iso_code_2'] === $settings['ups_integration_country'] && $settings['ups_integration_free_pl_method'] !== 'NONE' ) {
                        $quote_data = [
                            'ups_integration' => [
                                'id' => $id,
                                'title' => $this->language->get('text_pl_origin_' . $settings['ups_integration_free_pl_method']),
                                'cost' => $this->currency->convert($cost, $this->config->get('config_currency'), $this->config->get('config_currency')),
                                'tax_class_id' => $settings['ups_integration_tax_class_id'],
                                'text' => $this->currency->format($this->tax->calculate($this->currency->convert($cost,
                                    $this->config->get('config_currency'),
                                    $this->currency->getCode()),
                                    $settings['ups_integration_tax_class_id'],
                                    $this->config->get('config_tax')),
                                    $this->currency->getCode(),
                                    1.0000000)
                            ]
                        ];
                    }  elseif ( $address['iso_code_2'] !== $settings['ups_integration_country'] && $settings['ups_integration_free_pl_international_method']!== 'NONE' ) {
                        $quote_data = [
                            'ups_integration' => [
                                'id' => $id,
                                'title' => $this->language->get('text_pl_origin_' . $settings['ups_integration_free_pl_international_method']),
                                'cost' => $this->currency->convert($cost, $this->config->get('config_currency'), $this->config->get('config_currency')),
                                'tax_class_id' => $settings['ups_integration_tax_class_id'],
                                'text' => $this->currency->format($this->tax->calculate($this->currency->convert($cost,
                                    $this->config->get('config_currency'),
                                    $this->currency->getCode()),
                                    $settings['ups_integration_tax_class_id'],
                                    $this->config->get('config_tax')),
                                    $this->currency->getCode(),
                                    1.0000000)
                            ]
                        ];
                    }
			    } elseif ($settings['ups_integration_origin']==='other') {
                    if ( $address['iso_code_2'] === $settings['ups_integration_country'] && $settings['ups_integration_free_other_method'] !== 'NONE' ) {
                        $quote_data = [
                            'ups_integration' => [
                                'id' => $id,
                                'title' => $this->language->get('text_other_origin_' . $settings['ups_integration_free_other_method']),
                                'cost' => $this->currency->convert($cost, $this->config->get('config_currency'), $this->config->get('config_currency')),
                                'tax_class_id' => $settings['ups_integration_tax_class_id'],
                                'text' => $this->currency->format($this->tax->calculate($this->currency->convert($cost,
                                    $this->config->get('config_currency'),
                                    $this->currency->getCode()),
                                    $settings['ups_integration_tax_class_id'],
                                    $this->config->get('config_tax')),
                                    $this->currency->getCode(),
                                    1.0000000)
                            ]
                        ];
                    } elseif ($address['iso_code_2'] !== $settings['ups_integration_country'] && $settings['ups_integration_free_other_international_method'] !== 'NONE') {
                        $quote_data = [
                            'ups_integration' => [
                                'id' => $id,
                                'title' => $this->language->get('text_other_origin_' . $settings['ups_integration_free_other_international_method']),
                                'cost' => $this->currency->convert($cost, $this->config->get('config_currency'), $this->config->get('config_currency')),
                                'tax_class_id' => $settings['ups_integration_tax_class_id'],
                                'text' => $this->currency->format($this->tax->calculate($this->currency->convert($cost,
                                    $this->config->get('config_currency'),
                                    $this->currency->getCode()),
                                    $settings['ups_integration_tax_class_id'],
                                    $this->config->get('config_tax')),
                                    $this->currency->getCode(),
                                    1.0000000)
                            ]
                        ];
                    }
                }

			    $method_data = [
				    'id'         => 'ups_integration',
				    'title'      => $this->language->get( 'text_title' ),
				    'quote'      => $quote_data,
				    'sort_order' => $settings['ups_integration_sort_order'],
				    'error'      => ''
			    ];

			    return $method_data;
		    }

		    ( ( $settings['ups_integration_length'] == "" ) ? $defaultLength = "5" : $defaultLength = $settings['ups_integration_length']);
		    ( ( $settings['ups_integration_width'] == "" ) ? $defaultWidth = "5" : $defaultWidth = $settings['ups_integration_width']);
		    ( ( $settings['ups_integration_height'] == "" ) ? $defaultHeight = "5" : $defaultHeight = $settings['ups_integration_height']);

		    $length         = $this->length->convert( $defaultLength, $this->config->get( 'config_length_class' ), $settings['config_length_class']);
		    $width          = $this->length->convert( $defaultWidth, $this->config->get( 'config_length_class' ), $settings['config_length_class']);
		    $height         = $this->length->convert( $defaultHeight, $this->config->get( 'config_length_class' ), $settings['config_length_class']);
		    $avg_weight     = $settings['ups_integration_weight'];
		    $avg            = $wt = $top = 0;
		    $avg_quote_data = $new_quote_data = [];
		    $origin_country = $settings['ups_integration_country'];
		    if ( $basic_products ) {
		        if ( $avg_weight !== '' && $weight > $avg_weight ) {
				    $avg = floor( $weight / (int) $avg_weight );
				    $wt  = fmod( $weight, $avg_weight );
			    }
			    if ( $avg !== 0 ) {
				    if ( $wt !== 0 ) {
                        $loop = $avg + 1;
					    $top  = $avg + 1;
				    } else {
					    $loop = $avg;
				    }
				    $j = 1;
				    for ( $i = 1; $i <= $loop; $i ++ ) {
					    if ( $j == $top ) {
						    $result = $this->_fetchRate( $address, $wt, $length, $width, $height, $basic_products_subtotal );
					    } else {
						    $result = $this->_fetchRate( $address, $avg_weight, $length, $width, $height, $basic_products_subtotal );
					    }

					    if ( $result ) {
						    $avg_quote_data = $this->_processRate( $origin_country, $address, $result, '');
						    $error_msg      = $avg_quote_data['error_msg'];
						    $avg_quote_data = $avg_quote_data['quote_data'];
					    }
					    if ( $quote_data ) {
						    foreach ( $quote_data as $key => $value ) {
							    $quote_data[ $key ]['cost'] = $quote_data[ $key ]['cost'] + $avg_quote_data[ $key ]['cost'];
							    $quote_data[ $key ]['text'] = $this->currency->format(
                                    $this->tax->calculate( $this->currency->convert( $quote_data[ $key ]['cost'],
                                        $this->config->get( 'config_currency' ),
                                        $this->currency->getCode() ),
                                       $settings['ups_integration_tax_class_id'],
                                        $this->config->get( 'config_tax' ) ),
                                    $this->currency->getCode(),
                                    1.0000000 );
						    }
					    } else if ( $avg_quote_data ) {
						    $quote_data = $avg_quote_data;
					    }
					    $j ++;
				    }
			    } else {
				    $result     = $this->_fetchRate( $address, $weight, $length, $width, $height, $basic_products_subtotal );
                    $quote_data = $this->_processRate( $origin_country, $address, $result, '' );
				    $error_msg  = $quote_data['error_msg'];
				    $quote_data = $quote_data['quote_data'];
			    }
		    }

		    foreach ( $cart_products as $product ) {
			    if ( $product['ship_individually'] && $product['shipping_price'] == '0.00' ) {
				    $individualWeight = $this->weight->convert( $this->getIndividualWeight( [ $product['product_id'] ]), $product['weight_class'], $this->config->get( 'config_weight_class' ) ) + number_format( (float) $settings['ups_integration_additional_weight'], 2, '.', '' );
				    $individualWeight = ( $individualWeight < 0.1 ? 0.1 : $individualWeight );
				    $use_width        = ( ( $product['width'] != '0.00' ) ? $this->length->convert( $product['width'], $product['length_class'], $this->config->get( 'config_length_class' ) ) : $this->length->convert( '5', $product['length_class'], $this->config->get( 'config_length_class' ) ) );
				    $use_length       = ( ( $product['length'] != '0.00' ) ? $this->length->convert( $product['length'], $product['length_class'], $this->config->get( 'config_length_class' ) ) : $this->length->convert( '5', $product['length_class'], $this->config->get( 'config_length_class' ) ) );
				    $use_height       = ( ( $product['height'] != '0.00' ) ? $this->length->convert( $product['height'], $product['length_class'], $this->config->get( 'config_length_class' ) ) : $this->length->convert( '5', $product['length_class'], $this->config->get( 'config_length_class' ) ) );
				    $qty              = $product['quantity'];

				    $result = $this->_fetchRate( $address, $individualWeight, $use_length, $use_width, $use_height, $product['price'] );
				    if ( $result ) {
					    $new_quote_data = $this->_processRate( $origin_country, $address, $result, $qty);
					    $error_msg      = $new_quote_data['error_msg'];
					    $new_quote_data = $new_quote_data['quote_data'];
				    }
				    if ( $quote_data ) {
					    foreach ( $quote_data as $key => $value ) {
						    $quote_data[ $key ]['cost'] = $quote_data[ $key ]['cost'] + $new_quote_data[ $key ]['cost'];
						    $quote_data[ $key ]['text'] = $this->currency->format(
                                $this->tax->calculate( $this->currency->convert( $quote_data[ $key ]['cost'],
                                    $this->config->get( 'config_currency' ),
                                    $this->currency->getCode() ),
                                   $settings['ups_integration_tax_class_id'],
                                    $this->config->get( 'config_tax' ) ),
                                $this->currency->getCode(),
                                1.0000000 );
					    }
				    } else if ( $new_quote_data ) {
					    $quote_data = $new_quote_data;
				    }
			    }
		    }
		    //merge data and accumulate shipping cost
		    if ( $quote_data ) {
			    foreach ( $quote_data as $key => $value ) {
				    $quote_data[ $key ]['cost'] = $quote_data[ $key ]['cost'] + $shipping_price_cost;
				    $quote_data[ $key ]['text'] = $this->currency->format(
                        $this->tax->calculate( $this->currency->convert( $quote_data[ $key ]['cost'],
                            $this->config->get( 'config_currency' ),
                            $this->currency->getCode() ),
                           $settings['ups_integration_tax_class_id'],
                            $this->config->get( 'config_tax' ) ),
                        $this->currency->getCode(),
                        1.0000000 );
			    }
		    }

		    $title = $this->language->get( 'text_title', 'ups_integration/ups_integration' );

		    $method_data = [
			    'id'         => 'ups_integration',
			    'title'      => $title,
			    'quote'      => $quote_data,
			    'sort_order' => $settings['ups_integration_sort_order'],
			    'error'      => $error_msg
		    ];

		    return $method_data;
	    }
    }

    public function getLocalDelivery($address) {
        $store_id = $this->getStoreId();
        $settings = $this->getSetting('ups_integration',$store_id);
        $this->load->model('extension/ups_verify');
        $verify = $this->model_extension_ups_verify->verify();
		if ($verify === true) {
		    $postcode         = str_replace( ' ', '', $address['postcode'] );
		    $exclude_zipcodes = $settings['ups_integration_local_zipcodes'];
		    $fee              = $settings['ups_integration_local_delivery_fee'];
		    $valid            = '';
		    if ( $fee ) {
			    $cost  = $fee;
			    $title = $this->language->get( 'text_local_delivery_fee' );
		    } else {
			    $cost  = 0;
			    $title = $this->language->get( 'text_free_local_delivery' );
		    }

		    $zipcodes_list = explode( ',', $exclude_zipcodes );
		    if ( $zipcodes_list ) {
			    foreach ( $zipcodes_list as $zipcodes ) {
				    if ( fnmatch( $zipcodes, $postcode ) ) {
					    $valid = '1';
					    break;
				    }
			    }
		    } else {
			    if ( fnmatch( $exclude_zipcodes, $postcode ) ) {
				    $valid = '1';
			    }
		    }
		    if ( $exclude_zipcodes && $valid ) {
			    $local_delivery = [
				    'ups_integration_local' => [
					    'id'           => 'ups_integration_local.ups_integration_local',
					    'title'        => $title,
					    'cost'         => $this->currency->convert( $cost, $this->config->get( 'config_currency' ), $this->config->get( 'config_currency' )),
					    'tax_class_id' => $settings['ups_integration_tax_class_id'],
					    'text'         => $this->currency->format(
						    $this->tax->calculate( $this->currency->convert( $cost,
							    $this->config->get( 'config_currency' ),
							    $this->currency->getCode() ),
							   $settings['ups_integration_tax_class_id'],
							    $this->config->get( 'config_tax' ) ),
						    $this->currency->getCode(),
						    1.0000000 )
				    ]
			    ];
		    }

		    if ( $local_delivery ) {
			    $quote_data = $local_delivery;
		    }
		    if ( $quote_data ) {
			    foreach ( $quote_data as $key => $value ) {
				    $quote_data[ $key ]['cost'] = $quote_data[ $key ]['cost'];
				    $quote_data[ $key ]['text'] = $this->currency->format(
                        $this->tax->calculate( $this->currency->convert( $quote_data[ $key ]['cost'],
                            $this->config->get( 'config_currency' ),
                            $this->currency->getCode() ),
                           $settings['ups_integration_tax_class_id'],
                            $this->config->get( 'config_tax' ) ),
                        $this->currency->getCode(),
                        1.0000000 );
			    }
		    }

		    $title = $this->language->get( 'text_ups_local_delivery', 'ups_integration/ups_integration' );

		    $method_data = [
			    'id'         => 'ups_integration_local',
			    'title'      => $title,
			    'quote'      => $quote_data,
			    'sort_order' => $settings['ups_integration_sort_order'],
		    ];

		    return $method_data;
	    }
    }

    /**
     * @param $address
     * @param $weight
     * @param $length
     * @param $width
     * @param $height
     * @param $subtotal
     * @return array
     * @throws AException
     */
    private function _fetchRate($address, $weight, $length, $width, $height,$subtotal) {
        $this->load->model('localisation/zone');
        $store_id = $this->getStoreId();
        $settings = $this->getSetting('ups_integration',$store_id);

        $endpoint_url = $settings['ups_integration_test'] ? 'https://wwwcie.ups.com/' : 'https://onlinetools.ups.com/' ;
        $token = $this->getAccessToken();

        if (isset($token['response']['errors'])) {
            $error_msg = $token['response']['errors'][0]['message'];
            if ($settings['ups_integration_debug']) {
                $this->log->write('UPS Integration Obtain Access Token Debug: '.html_entity_decode($error_msg));
            }
            return null;
        }

        $access_token = $token['access_token'];

        $ups_account = $settings['ups_integration_account'];
        $ups_classification = $settings['ups_integration_classification'];
        $ups_packaging = $settings['ups_integration_packaging'];
        $ups_pickup = $settings['ups_integration_pickup'];
        $ups_city = $settings['ups_integration_city'];
        $ups_state = $settings['ups_integration_state'];
        $ups_postcode = $settings['ups_integration_postcode'];
        $ups_origin = $settings['ups_integration_country'];

        if ($this->config->get('config_weight_class') == 'lb') {
            $weightUnit = 'lbs';
        } elseif ($this->config->get('config_weight_class') == 'kg') {
            $weightUnit = 'kgs';
        }

        $weightDesc = $this->getVolumeDescription($this->config->get('config_weight_class'));

        $lengthUnit = $this->config->get('config_length_class');
        $lengthDesc= $this->getDimDescription($lengthUnit);

        $customer_name = '';
        if (!IS_ADMIN) {
            if ($this->customer->isLogged()) {
                $customer_name = $this->customer->getFirstName() . ' ' . $this->customer->getLastName();
            } elseif ($this->session->data['guest']) {
                $customer_name = $this->session->data['guest']['firstname'] . ' ' . $this->session->data['guest']['lastname'];
            }
        }

        //Recepient Info

        $request = [
            'RateRequest' => [
                'Request' => [
                    'TransactionReference' => [
                        'CustomerContext' => 'CustomerContext'
                    ]
                ],
                'PickupType' => [
                    'Code' => $ups_pickup
                ],
                'CustomerClassification' => [
                    'Code' => $ups_classification
                ],
                'Shipment' => [
                    'Shipper' => [
                        'Name' => $this->config->get('store_name'),
                        'ShipperNumber' => $ups_account,
                        'Address' => [
                            'City' => $ups_city,
                            'StateProvinceCode' => $ups_state,
                            'PostalCode' => $ups_postcode,
                            'CountryCode' => $ups_origin
                        ]
                    ],
                    'ShipTo' => [
                        'Name' => $customer_name,
                        'Address' => [
                            'City'   => $address['city'],
                            'StateProvinceCode' => $address['zone_code'],
                            'PostalCode' => $address['postcode'],
                            'CountryCode' => $address['iso_code_2']
                        ]
                    ],
                    'ShipFrom' => [
                        'Name' => $this->config->get('store_name'),
                        'Address' => [
                            'City' => $ups_city,
                            'StateProvinceCode' => $ups_state,
                            'PostalCode' => $ups_postcode,
                            'CountryCode' => $ups_origin
                        ]
                    ],
                    'PaymentDetails' => [
                        'ShipmentCharge' => [
                            'Type' => '01',
                            'BillShipper' => [
                                'AccountNumber' => $ups_account
                            ]
                        ],
                    ],
                    'Package' => [
                        'PackagingType' => [
                            'Code' => $ups_packaging
                        ],
                        'Dimensions' => [
                            'UnitOfMeasurement' => [
                                'Code' => $lengthUnit,
                                'Description' => $lengthDesc
                            ],
                            'Length' => (string)$length,
                            'Width' => (string)$width,
                            'Height' => (string)$height
                        ],
                        'PackageWeight' => [
                            'UnitOfMeasurement' => [
                                'Code' => $weightUnit,
                                'Description' => $weightDesc
                            ],
                            'Weight' => (string)$weight
                        ]
                    ],
                    'TaxInformationIndicator' => '1'
                ]
            ]
        ];

        if ($address['city']) {
            $request['RateRequest']['Shipment']['ShipTo']['Address']['City'] = $address['city'];
        }

        if ($address['address_1'] == '') {
            if ($settings['ups_integration_residential'] === '1') {
                $request['RateRequest']['Shipment']['ShipTo']['Address']['ResidentialAddressIndicator'] = 'Y';
            } else {
                $request['RateRequest']['Shipment']['ShipTo']['Address']['ResidentialAddressIndicator'] = 'N';
            }
        } else {
            $validate = $this->validateAddress($address);
            if ($validate['response']['errors']) {
                if ($settings['ups_integration_residential'] === '1') {
                    $request['RateRequest']['Shipment']['ShipTo']['Address']['ResidentialAddressIndicator'] = 'Y';
                } else {
                    $request['RateRequest']['Shipment']['ShipTo']['Address']['ResidentialAddressIndicator'] = 'N';
                }
            } else {
                if ($validate['XAVResponse']['AddressClassification']['Code']==='2') {
                    $request['RateRequest']['Shipment']['ShipTo']['Address']['ResidentialAddressIndicator'] = 'Y';
                } else {
                    $request['RateRequest']['Shipment']['ShipTo']['Address']['ResidentialAddressIndicator'] = 'N';
                }
            }
        }

        if ($settings['ups_integration_negotiated_rates'] == '1') {
            $request['RateRequest']['Shipment']['ShipmentRatingOptions'] = [
                'NegotiatedRatesIndicator' => 'Y'
            ];
        }

        if ($settings['ups_integration_declared_value_nominal'] != '') {
            $decVal = $settings['ups_integration_declared_value_nominal'];
        } else {
            $decVal = 100;
        }

        if ($settings['ups_integration_declared_value'] == '1' && $subtotal >= $decVal) {
            $request['RateRequest']['Shipment']['Package']['PackageServiceOptions']['DeclaredValue']['CurrencyCode'] = $this->config->get('config_currency');
            $request['RateRequest']['Shipment']['Package']['PackageServiceOptions']['DeclaredValue']['MonetaryValue'] = $this->currency->format($subtotal, false, false, false);
        }

        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => $endpoint_url.'api/rating/v1/shop',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => json_encode($request),
            CURLOPT_HTTPHEADER => array(
                'Content-Type: text/plain',
                'Authorization: Bearer '.$access_token
            ),
        ));

        $response = json_decode(curl_exec($curl),true);

        curl_close($curl);

        if ($settings['ups_integration_debug']) {
            $this->log->write('UPS Integration Request: '.html_entity_decode(var_export($request,true)));
            $this->log->write('UPS Integration Response Debug: '.html_entity_decode(var_export($response,true)));
        }
        if ($response['RateResponse']['Response']['ResponseStatus']['Code']==='1'){
            return $response['RateResponse']['RatedShipment'];
        }
    }

    /**
     * @param $origin
     * @param $address
     * @param string $result
     * @param string $qty
     * @return array
     * @throws AException
     */
    private function _processRate($origin, $address, $result = '', $qty = '') {
        $cart = $this->cart;
        $store_id = $this->getStoreId();
        $settings = $this->getSetting('ups_integration',$store_id);
	    $this->extensions->hk_InitData($this, __FUNCTION__);
        $service_code = [
            // US Origin
            'US' => [
                '01' => $this->language->get('text_us_origin_01'),
                '02' => $this->language->get('text_us_origin_02'),
                '03' => $this->language->get('text_us_origin_03'),
                '07' => $this->language->get('text_us_origin_07'),
                '08' => $this->language->get('text_us_origin_08'),
                '11' => $this->language->get('text_us_origin_11'),
                '12' => $this->language->get('text_us_origin_12'),
                '13' => $this->language->get('text_us_origin_13'),
                '14' => $this->language->get('text_us_origin_14'),
                '54' => $this->language->get('text_us_origin_54'),
                '59' => $this->language->get('text_us_origin_59'),
                '65' => $this->language->get('text_us_origin_65')
            ],
            // Canada Origin
            'CA' => [
                '01' => $this->language->get('text_ca_origin_01'),
                '02' => $this->language->get('text_ca_origin_02'),
                '07' => $this->language->get('text_ca_origin_07'),
                '08' => $this->language->get('text_ca_origin_08'),
                'intl_08' => $this->language->get('text_ca_origin_intl_08'),
                '11' => $this->language->get('text_ca_origin_11'),
                '12' => $this->language->get('text_ca_origin_12'),
                '13' => $this->language->get('text_ca_origin_13'),
                '14' => $this->language->get('text_ca_origin_14'),
                '54' => $this->language->get('text_ca_origin_54'),
                '65' => $this->language->get('text_ca_origin_65')
            ],
            // European Union Origin
            'EU' => [
                '07' => $this->language->get('text_eu_origin_07'),
                '08' => $this->language->get('text_eu_origin_08'),
                '11' => $this->language->get('text_eu_origin_11'),
                '54' => $this->language->get('text_eu_origin_54'),
                '65' => $this->language->get('text_eu_origin_65')
            ],
            // Poland Origin
            'PL' => [
                '07' => $this->language->get('text_pl_origin_07'),
                '08' => $this->language->get('text_pl_origin_08'),
                '11' => $this->language->get('text_pl_origin_11'),
                '54' => $this->language->get('text_pl_origin_54'),
                '65' => $this->language->get('text_pl_origin_65'),
                '82' => $this->language->get('text_pl_origin_82'),
                '83' => $this->language->get('text_pl_origin_83'),
                '84' => $this->language->get('text_pl_origin_84'),
                '85' => $this->language->get('text_pl_origin_85'),
                '86' => $this->language->get('text_pl_origin_86')
                ],
            // Puerto Rico Origin
            'PR' => [
                '01' => $this->language->get('text_pr_origin_01'),
                '02' => $this->language->get('text_pr_origin_02'),
                '03' => $this->language->get('text_pr_origin_03'),
                '07' => $this->language->get('text_pr_origin_07'),
                '08' => $this->language->get('text_pr_origin_08'),
                '14' => $this->language->get('text_pr_origin_14'),
                '54' => $this->language->get('text_pr_origin_54'),
                '65' => $this->language->get('text_pr_origin_65')
            ],
            // Mexico Origin
            'MX' => [
                '07' => $this->language->get('text_mx_origin_07'),
                '08' => $this->language->get('text_mx_origin_08'),
                '11' => $this->language->get('text_mx_origin_11'),
                '54' => $this->language->get('text_mx_origin_54'),
                '65' => $this->language->get('text_mx_origin_65')
            ],
            // All other origins
            'other' => [
                // service code 7 seems to be gone after January 2, 2007
                '07' => $this->language->get('text_other_origin_07'),
                '08' => $this->language->get('text_other_origin_08'),
                '11' => $this->language->get('text_other_origin_11'),
                '54' => $this->language->get('text_other_origin_54'),
                '65' => $this->language->get('text_other_origin_65')
            ]
        ];
        $quote_data = [];
		$taxIndicator = $settings['ups_integration_tax_indicator'] ? $settings['ups_integration_tax_indicator'] : '1';
        if ($result) {
            foreach ($result as $res) {
                if ($res['error'] != '') {
                    $error_msg = $res['error'];
                } else {
                    if (isset($res['Service']['Code'])) {
                        if ($origin === 'CA' && $res['Service']['Code'] === '08') {
                            if ($address['iso_code_2'] === 'CA' || $address['iso_code_2'] === 'US' || $address['iso_code_2'] === 'MX') {
                                $code = $res['Service']['Code'];
                            } else {
                                $code = 'intl_' . $res['Service']['Code'];
                            }
                        } else {
                            $code = $res['Service']['Code'];
                        }

                        if ($taxIndicator === '1' && isset($res['TotalChargesWithTaxes']) && $settings['ups_integration_account'] === '') {
                            $rate = $res['TotalChargesWithTaxes']['MonetaryValue'];
                        } elseif (isset($res['NegotiatedRateCharges'])) {
                            $rate = $res['NegotiatedRateCharges']['TotalCharge']['MonetaryValue'];
                        } else {
                            $rate = $res['TotalCharges']['MonetaryValue'];
                        }
                        $type = $settings['ups_integration_type'];
                        $fee_rate = (float)$settings['ups_integration_additional_fee'];
                        if ($type == 'percent' && $fee_rate != '0') {
                            $fee = number_format($rate * ($fee_rate / 100), 2, '.', '');
                        } elseif ($type == 'fixed' && $fee_rate != '0') {
                            $fee = number_format($fee_rate, 2, '.', '');
                        }
                        if ($settings['ups_integration_display_weight'] == '1') {
                            $titleWeight = $service_code[$settings['ups_integration_origin']][$code] . ' (' . $this->language->get('text_weight') . ' ' . $this->weight->format($cart->getWeight(), $this->config->get('config_weight_class')) . ')';
                        } else {
                            $titleWeight = $service_code[$settings['ups_integration_origin']][$code];
                        }
                        if ($qty == '') {
                            $cost = $rate + $fee;
                        } else {
                            $cost = ($rate + $fee) * $qty;
                        }

                        if ($settings['ups_integration_' . strtolower($settings['ups_integration_origin']) . '_' . $code]) {
                            $quote_data[$code] = [
                                'id' => 'ups_integration.' . $code,
                                'title' => $titleWeight,
                                'cost' => $this->currency->convert($cost, $this->config->get('config_currency'), $this->config->get('config_currency')),
                                'tax_class_id' => $settings['ups_integration_tax_class_id'],
                                'text' => $this->currency->format(
                                    $this->tax->calculate($this->currency->convert($cost,
                                        $this->config->get('config_currency'),
                                        $this->currency->getCode()),
                                        $settings['ups_integration_tax_class_id'],
                                        $this->config->get('config_tax')),
                                    $this->currency->getCode(),
                                    1.0000000)
                            ];
                        }
                    } else {
                        foreach ($result as $k => $v) {
                            if ($origin === 'CA' && $v['Service']['Code'] === '08') {
                                if ($address['iso_code_2'] === 'CA' || $address['iso_code_2'] === 'US' || $address['iso_code_2'] === 'MX') {
                                    $code = $v['Service']['Code'];
                                } else {
                                    $code = 'intl_' . $v['Service']['Code'];
                                }
                            } else {
                                $code = $v['Service']['Code'];
                            }

                            if ($taxIndicator === '1' && isset($v['TotalChargesWithTaxes']) && $settings['ups_integration_account'] === '') {
                                $rate = $v['TotalChargesWithTaxes']['MonetaryValue'];
                            } elseif (isset($v['NegotiatedRateCharges'])) {
                                $rate = $v['NegotiatedRateCharges']['NegotiatedRateCharges']['MonetaryValue'];
                            } else {
                                $rate = $v['TotalCharges']['MonetaryValue'];
                            }
                            $type = $settings['ups_integration_type'];
                            $fee_rate = (float)$settings['ups_integration_additional_fee'];
                            if ($type == 'percent' && $fee_rate != '0') {
                                $fee = number_format($rate * ($fee_rate / 100), 2, '.', '');
                            } elseif ($type == 'fixed' && $fee_rate != '0') {
                                $fee = number_format($fee_rate, 2, '.', '');
                            }
                            if ($settings['ups_integration_display_weight'] == '1') {
                                $titleWeight = $service_code[$settings['ups_integration_origin']][$code] . ' (' . $this->language->get('text_weight') . ' ' . $this->weight->format($cart->getWeight(), $this->config->get('config_weight_class')) . ')';
                            } else {
                                $titleWeight = $service_code[$settings['ups_integration_origin']][$code];
                            }
                            if ($qty == '') {
                                $cost = $rate + $fee;
                            } else {
                                $cost = ($rate + $fee) * $qty;
                            }

                            if (!($code && $cost)) {
                                continue;
                            }
                            if ($settings['ups_integration_' . strtolower($settings['ups_integration_origin']) . '_' . $code]) {
                                $quote_data[$code] = [
                                    'id' => 'ups_integration.' . $code,
                                    'title' => $titleWeight,
                                    'cost' => $this->currency->convert($cost, $this->config->get('config_currency'), $this->config->get('config_currency')),
                                    'tax_class_id' => $settings['ups_integration_tax_class_id'],
                                    'text' => $this->currency->format(
                                        $this->tax->calculate($this->currency->convert($cost,
                                            $this->config->get('config_currency'),
                                            $this->currency->getCode()),
                                            $settings['ups_integration_tax_class_id'],
                                            $this->config->get('config_tax')),
                                        $this->currency->getCode(),
                                        1.0000000)
                                ];
                            }
                        }
                    }
                }
            }
        }

        return ['quote_data' => $quote_data, 'error_msg' => $error_msg];
    }

    private function validateAddress($address) {
        $store_id = $this->getStoreId();
        $settings = $this->getSetting('ups_integration',$store_id);

        $endpoint_url = $settings['ups_integration_test'] ? 'https://wwwcie.ups.com/' : 'https://onlinetools.ups.com/' ;
        $token = $this->getAccessToken();

        if ($token['response']['errors']) {
            $error_msg = $token['response']['errors'][0]['message'];
            return null;
        }

        $access_token = $token['access_token'];

        $body = [
            'XAVRequest'=> [
                'AddressKeyFormat'=> [
                    [
                        'AddressLine'=> [
                            $address['address_1']
                        ],
                        'PoliticalDivision2'=> $address['city'],
                        'PoliticalDivision1'=> $address['zone_code'],
                        'PostcodePrimaryLow'=> $address['postcode'],
                        'CountryCode'=> $address['iso_code_2']
                    ]
                ]
            ]
        ];

        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => $endpoint_url.'api/addressvalidation/v1/2',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => json_encode($body),
            CURLOPT_HTTPHEADER => array(
                'Content-Type: text/plain',
                'Authorization: Bearer '.$access_token
            ),
        ));

        $response = curl_exec($curl);
        $response = json_decode($response,true);
        curl_close($curl);

        $error_msg = $token['response']['errors'][0]['message'];
        if ($settings['ups_integration_debug']) {
            if ($error_msg) {
                $this->log->write('UPS Integration Validate Address Debug:' . html_entity_decode($error_msg));
            } else {
                $this->log->write('UPS Integration Validate Address Debug:' . var_export($response,true));
            }
        }

        return $response;
    }

    /**
     * @param array $product_ids
     * @return float|int
     */
    private function getIndividualWeight($product_ids = []) {
        $weight = 0;
        $cart = $this->cart;

	    foreach ($cart->getProducts() as $product) {
            if (sizeof($product_ids) > 0 && !in_array((string)$product['product_id'], $product_ids)) {
                continue;
            }

            if ($product['shipping']) {
                $product_weight = $product['weight'];
                // if product_option has weight value
                if ($product['option']) {
                    $hard = false;
                    foreach ($product['option'] as $option) {
                        if ($option['weight'] == 0) continue; // if weight not set - skip
                        if ($option['weight_type'] != '%') {
                            //If weight was set by option hard and other option sets another weight hard - ignore it
                            //skip negative weight. Negative allowed only for % based weight
                            if ($hard || $option['weight'] < 0) {
                                continue;
                            }
                            //$hard = true;
                            $product_weight = $cart->weight->convert($option['weight'], $option['weight_type'], $product['weight_class']);
                        } else {
                            //We need product base weight for % calculation
                            $temp = ($option['weight'] * $product['weight'] / 100) + $product['weight'];
                            $product_weight = $cart->weight->convert($temp, $option['weight_type'], $this->config->get('config_weight_class'));
                        }
                    }
                }
                $weight = $cart->weight->convert($product_weight, $product['weight_class'], $this->config->get('config_weight_class'));
            }
        }
        return $weight;
    }

    public function getStoreId() {
        $store_id = (int) $this->config->get('config_store_id');
        if (has_value($this->request->get_or_post('store_id'))) {
            $store_id = (int) $this->request->get_or_post('store_id');
        } else {
            if ($this->session->data['current_store_id']) {
                $store_id = (int) $this->session->data['current_store_id'];
            }
        }
        return $store_id;
    }
    
    /**
     * @param string $group
     * @param int    $store_id
     *
     * @return array
     */
    public function getSetting($group, $store_id = 0) {
        $data = [];

        $query = $this->db->query(
            "SELECT *
            FROM ".$this->db->table("settings")." 
            WHERE `group` = '".$this->db->escape($group)."'
                AND store_id = '".(int)$store_id."'"
        );

        foreach ($query->rows as $result) {
            $value = $result['value'];
            if (is_serialized($value)) {
                $value = unserialize($value);
            }
            $data[$result['key']] = $value;
        }
        return $data;
    }

    public function getAccessToken() {
        $endpoint_url = $this->config->get('ups_integration_test') ? 'https://wwwcie.ups.com/' : 'https://onlinetools.ups.com/' ;
        $client_id = $this->config->get('ups_integration_client_id');
        $client_secret = $this->config->get('ups_integration_client_secret');

        $curl = curl_init();

        $auth = base64_encode($client_id.":".$client_secret);

        curl_setopt_array($curl, array(
            CURLOPT_URL => $endpoint_url.'security/v1/oauth/token',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => 'grant_type=client_credentials',
            CURLOPT_HTTPHEADER => array(
                'Content-Type: application/x-www-form-urlencoded',
                'Authorization: Basic '.$auth,
            ),
        ));

        $response = curl_exec($curl);
        $curl_error = curl_error($curl);

        if ($this->config->get('ups_integration_debug')) {
            $this->log->write('UPS Integration Obtain Access Token Debug: '.var_export(json_decode($response,true),true));
        }

        curl_close($curl);
        return json_decode($response,true);
    }

    /**
     * @param $unit_code
     * @return mixed
     * @throws AException
     */
    public function getDimDescription($unit_code) {
        $langId = $this->language->getLanguageID();
        $sql = "SELECT `title` FROM ".$this->db->table("length_class_descriptions")." WHERE `unit`='".$unit_code."' AND `language_id`='".$langId."'";
        $query = $this->db->query($sql);
        return $query->row['title'];
    }

    /**
     * @param $weight_code
     * @return mixed
     * @throws AException
     */
    public function getVolumeDescription($weight_code) {
        $langId = $this->language->getLanguageID();
        $sql = "SELECT `title` FROM ".$this->db->table("weight_class_descriptions")." WHERE `unit`='".$weight_code."' AND `language_id`='".$langId."'";
        $query = $this->db->query($sql);
        return $query->row['title'];
    }

}