<?php
/**
 * EmsResponse
 *
 * PHP version 5
 *
 * @category Class
 * @package  UPS\TimeInTransit
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Time In Transit
 *
 * The Time In Transit API provides estimated delivery times for various UPS shipping services, between specified locations.  Key Business Values: - **Enhanced Customer Experience**: Allows businesses provide accurate delivery estimates to their customers, enhancing customer service. - **Operational Efficiency**: Helps in logistics planning by providing transit times for different UPS services.
 *
 * 
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 3.0.50
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace UPS\TimeInTransit\TimeInTransit;

use \ArrayAccess;
use \UPS\TimeInTransit\ObjectSerializer;

/**
 * EmsResponse Class Doc Comment
 *
 * @category Class
 * @package  UPS\TimeInTransit
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class EmsResponse implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'emsResponse';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'ship_date' => 'string',
        'ship_time' => 'string',
        'service_level' => 'string',
        'bill_type' => 'string',
        'duty_type' => 'string',
        'residential_indicator' => 'string',
        'destination_country_name' => 'string',
        'destination_country_code' => 'string',
        'destination_postal_code' => 'string',
        'destination_postal_code_low' => 'string',
        'destination_postal_code_high' => 'string',
        'destination_state_province' => 'string',
        'destination_city_name' => 'string',
        'origin_country_name' => 'string',
        'origin_country_code' => 'string',
        'origin_postal_code' => 'string',
        'origin_postal_code_low' => 'string',
        'origin_postal_code_high' => 'string',
        'origin_state_province' => 'string',
        'origin_city_name' => 'string',
        'weight' => 'string',
        'weight_unit_of_measure' => 'string',
        'shipment_contents_value' => 'string',
        'shipment_contents_currency_code' => 'string',
        'guarantee_suspended' => 'bool',
        'number_of_services' => 'int',
        'services' => '\UPS\TimeInTransit\TimeInTransit\Services[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'ship_date' => null,
        'ship_time' => null,
        'service_level' => null,
        'bill_type' => null,
        'duty_type' => null,
        'residential_indicator' => null,
        'destination_country_name' => null,
        'destination_country_code' => null,
        'destination_postal_code' => null,
        'destination_postal_code_low' => null,
        'destination_postal_code_high' => null,
        'destination_state_province' => null,
        'destination_city_name' => null,
        'origin_country_name' => null,
        'origin_country_code' => null,
        'origin_postal_code' => null,
        'origin_postal_code_low' => null,
        'origin_postal_code_high' => null,
        'origin_state_province' => null,
        'origin_city_name' => null,
        'weight' => null,
        'weight_unit_of_measure' => null,
        'shipment_contents_value' => null,
        'shipment_contents_currency_code' => null,
        'guarantee_suspended' => null,
        'number_of_services' => null,
        'services' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'ship_date' => 'shipDate',
        'ship_time' => 'shipTime',
        'service_level' => 'serviceLevel',
        'bill_type' => 'billType',
        'duty_type' => 'dutyType',
        'residential_indicator' => 'residentialIndicator',
        'destination_country_name' => 'destinationCountryName',
        'destination_country_code' => 'destinationCountryCode',
        'destination_postal_code' => 'destinationPostalCode',
        'destination_postal_code_low' => 'destinationPostalCodeLow',
        'destination_postal_code_high' => 'destinationPostalCodeHigh',
        'destination_state_province' => 'destinationStateProvince',
        'destination_city_name' => 'destinationCityName',
        'origin_country_name' => 'originCountryName',
        'origin_country_code' => 'originCountryCode',
        'origin_postal_code' => 'originPostalCode',
        'origin_postal_code_low' => 'originPostalCodeLow',
        'origin_postal_code_high' => 'originPostalCodeHigh',
        'origin_state_province' => 'originStateProvince',
        'origin_city_name' => 'originCityName',
        'weight' => 'weight',
        'weight_unit_of_measure' => 'weightUnitOfMeasure',
        'shipment_contents_value' => 'shipmentContentsValue',
        'shipment_contents_currency_code' => 'shipmentContentsCurrencyCode',
        'guarantee_suspended' => 'guaranteeSuspended',
        'number_of_services' => 'numberOfServices',
        'services' => 'services'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'ship_date' => 'setShipDate',
        'ship_time' => 'setShipTime',
        'service_level' => 'setServiceLevel',
        'bill_type' => 'setBillType',
        'duty_type' => 'setDutyType',
        'residential_indicator' => 'setResidentialIndicator',
        'destination_country_name' => 'setDestinationCountryName',
        'destination_country_code' => 'setDestinationCountryCode',
        'destination_postal_code' => 'setDestinationPostalCode',
        'destination_postal_code_low' => 'setDestinationPostalCodeLow',
        'destination_postal_code_high' => 'setDestinationPostalCodeHigh',
        'destination_state_province' => 'setDestinationStateProvince',
        'destination_city_name' => 'setDestinationCityName',
        'origin_country_name' => 'setOriginCountryName',
        'origin_country_code' => 'setOriginCountryCode',
        'origin_postal_code' => 'setOriginPostalCode',
        'origin_postal_code_low' => 'setOriginPostalCodeLow',
        'origin_postal_code_high' => 'setOriginPostalCodeHigh',
        'origin_state_province' => 'setOriginStateProvince',
        'origin_city_name' => 'setOriginCityName',
        'weight' => 'setWeight',
        'weight_unit_of_measure' => 'setWeightUnitOfMeasure',
        'shipment_contents_value' => 'setShipmentContentsValue',
        'shipment_contents_currency_code' => 'setShipmentContentsCurrencyCode',
        'guarantee_suspended' => 'setGuaranteeSuspended',
        'number_of_services' => 'setNumberOfServices',
        'services' => 'setServices'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'ship_date' => 'getShipDate',
        'ship_time' => 'getShipTime',
        'service_level' => 'getServiceLevel',
        'bill_type' => 'getBillType',
        'duty_type' => 'getDutyType',
        'residential_indicator' => 'getResidentialIndicator',
        'destination_country_name' => 'getDestinationCountryName',
        'destination_country_code' => 'getDestinationCountryCode',
        'destination_postal_code' => 'getDestinationPostalCode',
        'destination_postal_code_low' => 'getDestinationPostalCodeLow',
        'destination_postal_code_high' => 'getDestinationPostalCodeHigh',
        'destination_state_province' => 'getDestinationStateProvince',
        'destination_city_name' => 'getDestinationCityName',
        'origin_country_name' => 'getOriginCountryName',
        'origin_country_code' => 'getOriginCountryCode',
        'origin_postal_code' => 'getOriginPostalCode',
        'origin_postal_code_low' => 'getOriginPostalCodeLow',
        'origin_postal_code_high' => 'getOriginPostalCodeHigh',
        'origin_state_province' => 'getOriginStateProvince',
        'origin_city_name' => 'getOriginCityName',
        'weight' => 'getWeight',
        'weight_unit_of_measure' => 'getWeightUnitOfMeasure',
        'shipment_contents_value' => 'getShipmentContentsValue',
        'shipment_contents_currency_code' => 'getShipmentContentsCurrencyCode',
        'guarantee_suspended' => 'getGuaranteeSuspended',
        'number_of_services' => 'getNumberOfServices',
        'services' => 'getServices'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }



    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['ship_date'] = isset($data['ship_date']) ? $data['ship_date'] : null;
        $this->container['ship_time'] = isset($data['ship_time']) ? $data['ship_time'] : null;
        $this->container['service_level'] = isset($data['service_level']) ? $data['service_level'] : null;
        $this->container['bill_type'] = isset($data['bill_type']) ? $data['bill_type'] : null;
        $this->container['duty_type'] = isset($data['duty_type']) ? $data['duty_type'] : null;
        $this->container['residential_indicator'] = isset($data['residential_indicator']) ? $data['residential_indicator'] : null;
        $this->container['destination_country_name'] = isset($data['destination_country_name']) ? $data['destination_country_name'] : null;
        $this->container['destination_country_code'] = isset($data['destination_country_code']) ? $data['destination_country_code'] : null;
        $this->container['destination_postal_code'] = isset($data['destination_postal_code']) ? $data['destination_postal_code'] : null;
        $this->container['destination_postal_code_low'] = isset($data['destination_postal_code_low']) ? $data['destination_postal_code_low'] : null;
        $this->container['destination_postal_code_high'] = isset($data['destination_postal_code_high']) ? $data['destination_postal_code_high'] : null;
        $this->container['destination_state_province'] = isset($data['destination_state_province']) ? $data['destination_state_province'] : null;
        $this->container['destination_city_name'] = isset($data['destination_city_name']) ? $data['destination_city_name'] : null;
        $this->container['origin_country_name'] = isset($data['origin_country_name']) ? $data['origin_country_name'] : null;
        $this->container['origin_country_code'] = isset($data['origin_country_code']) ? $data['origin_country_code'] : null;
        $this->container['origin_postal_code'] = isset($data['origin_postal_code']) ? $data['origin_postal_code'] : null;
        $this->container['origin_postal_code_low'] = isset($data['origin_postal_code_low']) ? $data['origin_postal_code_low'] : null;
        $this->container['origin_postal_code_high'] = isset($data['origin_postal_code_high']) ? $data['origin_postal_code_high'] : null;
        $this->container['origin_state_province'] = isset($data['origin_state_province']) ? $data['origin_state_province'] : null;
        $this->container['origin_city_name'] = isset($data['origin_city_name']) ? $data['origin_city_name'] : null;
        $this->container['weight'] = isset($data['weight']) ? $data['weight'] : null;
        $this->container['weight_unit_of_measure'] = isset($data['weight_unit_of_measure']) ? $data['weight_unit_of_measure'] : null;
        $this->container['shipment_contents_value'] = isset($data['shipment_contents_value']) ? $data['shipment_contents_value'] : null;
        $this->container['shipment_contents_currency_code'] = isset($data['shipment_contents_currency_code']) ? $data['shipment_contents_currency_code'] : null;
        $this->container['guarantee_suspended'] = isset($data['guarantee_suspended']) ? $data['guarantee_suspended'] : null;
        $this->container['number_of_services'] = isset($data['number_of_services']) ? $data['number_of_services'] : null;
        $this->container['services'] = isset($data['services']) ? $data['services'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['ship_date'] === null) {
            $invalidProperties[] = "'ship_date' can't be null";
        }
        if ($this->container['ship_time'] === null) {
            $invalidProperties[] = "'ship_time' can't be null";
        }
        if ($this->container['service_level'] === null) {
            $invalidProperties[] = "'service_level' can't be null";
        }
        if ($this->container['bill_type'] === null) {
            $invalidProperties[] = "'bill_type' can't be null";
        }
        if ($this->container['residential_indicator'] === null) {
            $invalidProperties[] = "'residential_indicator' can't be null";
        }
        if ($this->container['destination_country_name'] === null) {
            $invalidProperties[] = "'destination_country_name' can't be null";
        }
        if ($this->container['destination_country_code'] === null) {
            $invalidProperties[] = "'destination_country_code' can't be null";
        }
        if ($this->container['origin_country_name'] === null) {
            $invalidProperties[] = "'origin_country_name' can't be null";
        }
        if ($this->container['origin_country_code'] === null) {
            $invalidProperties[] = "'origin_country_code' can't be null";
        }
        if ($this->container['guarantee_suspended'] === null) {
            $invalidProperties[] = "'guarantee_suspended' can't be null";
        }
        if ($this->container['number_of_services'] === null) {
            $invalidProperties[] = "'number_of_services' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets ship_date
     *
     * @return string
     */
    public function getShipDate()
    {
        return $this->container['ship_date'];
    }

    /**
     * Sets ship_date
     *
     * @param string $ship_date The date the shipment is tendered to UPS for shipping (can be dropped off at UPS or picked up by UPS).  This date may or may not be the UPS business date.     Valid Format: YYYY-MM-DD
     *
     * @return $this
     */
    public function setShipDate($ship_date)
    {
        $this->container['ship_date'] = $ship_date;

        return $this;
    }

    /**
     * Gets ship_time
     *
     * @return string
     */
    public function getShipTime()
    {
        return $this->container['ship_time'];
    }

    /**
     * Sets ship_time
     *
     * @param string $ship_time The time the shipment is tendered to UPS for shipping (can be dropped off at UPS or picked up by UPS).      Valid Format: HH:MM:SS
     *
     * @return $this
     */
    public function setShipTime($ship_time)
    {
        $this->container['ship_time'] = $ship_time;

        return $this;
    }

    /**
     * Gets service_level
     *
     * @return string
     */
    public function getServiceLevel()
    {
        return $this->container['service_level'];
    }

    /**
     * Sets service_level
     *
     * @param string $service_level Service Levels being returned.     A = all service levels.     Blank is the default for all Service Level values.
     *
     * @return $this
     */
    public function setServiceLevel($service_level)
    {
        $this->container['service_level'] = $service_level;

        return $this;
    }

    /**
     * Gets bill_type
     *
     * @return string
     */
    public function getBillType()
    {
        return $this->container['bill_type'];
    }

    /**
     * Sets bill_type
     *
     * @param string $bill_type Represents the shipment type.     Valid values: \"02\",\"03\",\"04\",\"07\"   02 - Document   03 - Non-Document   04 - WWEF   07 - Pallet
     *
     * @return $this
     */
    public function setBillType($bill_type)
    {
        $this->container['bill_type'] = $bill_type;

        return $this;
    }

    /**
     * Gets duty_type
     *
     * @return string
     */
    public function getDutyType()
    {
        return $this->container['duty_type'];
    }

    /**
     * Sets duty_type
     *
     * @param string $duty_type Populated with valid duty types for international transactions only.      Valid Duty Types: \"01\",\"02\",\"03\",\"04\",\"05\",\"06\",\"07\",\"08\",\"09\"   01 - Dutiable   02 - Non Dutiable   03 - Low Value   04 - Courier Remission   05 - Gift   06 - Military   07 - Exception   08 - Line Release   09 - Low Value
     *
     * @return $this
     */
    public function setDutyType($duty_type)
    {
        $this->container['duty_type'] = $duty_type;

        return $this;
    }

    /**
     * Gets residential_indicator
     *
     * @return string
     */
    public function getResidentialIndicator()
    {
        return $this->container['residential_indicator'];
    }

    /**
     * Sets residential_indicator
     *
     * @param string $residential_indicator residential Indicator that was sent in on the request.     Valid values: \"01\",\"02\"     01 - Residential   02 - Commercial
     *
     * @return $this
     */
    public function setResidentialIndicator($residential_indicator)
    {
        $this->container['residential_indicator'] = $residential_indicator;

        return $this;
    }

    /**
     * Gets destination_country_name
     *
     * @return string
     */
    public function getDestinationCountryName()
    {
        return $this->container['destination_country_name'];
    }

    /**
     * Sets destination_country_name
     *
     * @param string $destination_country_name Destination country name value
     *
     * @return $this
     */
    public function setDestinationCountryName($destination_country_name)
    {
        $this->container['destination_country_name'] = $destination_country_name;

        return $this;
    }

    /**
     * Gets destination_country_code
     *
     * @return string
     */
    public function getDestinationCountryCode()
    {
        return $this->container['destination_country_code'];
    }

    /**
     * Sets destination_country_code
     *
     * @param string $destination_country_code Destination country code, conforms to ISO-defined country codes.
     *
     * @return $this
     */
    public function setDestinationCountryCode($destination_country_code)
    {
        $this->container['destination_country_code'] = $destination_country_code;

        return $this;
    }

    /**
     * Gets destination_postal_code
     *
     * @return string
     */
    public function getDestinationPostalCode()
    {
        return $this->container['destination_postal_code'];
    }

    /**
     * Sets destination_postal_code
     *
     * @param string $destination_postal_code The shipment destination postal code.  Required for US domestic requests.     Either 5, or 9-digit US zip codes must be used for U.S. addresses.  For non-US addresses, this is recommended for all countries that utilize postal codes.
     *
     * @return $this
     */
    public function setDestinationPostalCode($destination_postal_code)
    {
        $this->container['destination_postal_code'] = $destination_postal_code;

        return $this;
    }

    /**
     * Gets destination_postal_code_low
     *
     * @return string
     */
    public function getDestinationPostalCodeLow()
    {
        return $this->container['destination_postal_code_low'];
    }

    /**
     * Sets destination_postal_code_low
     *
     * @param string $destination_postal_code_low The shipment destination postal code low range.  Value may or may not differ from destinationPostalCode.      Either 5, or 9-digit US zip codes must be used for U.S. addresses.  For non-US addresses, this is recommended for all countries that utilize postal codes.
     *
     * @return $this
     */
    public function setDestinationPostalCodeLow($destination_postal_code_low)
    {
        $this->container['destination_postal_code_low'] = $destination_postal_code_low;

        return $this;
    }

    /**
     * Gets destination_postal_code_high
     *
     * @return string
     */
    public function getDestinationPostalCodeHigh()
    {
        return $this->container['destination_postal_code_high'];
    }

    /**
     * Sets destination_postal_code_high
     *
     * @param string $destination_postal_code_high The shipment destination postal code high range.  Value may or may not differ from destinationPostalCode.      Either 5, or 9-digit US zip codes must be used for U.S. addresses.  For non-US addresses, this is recommended for all countries that utilize postal codes.
     *
     * @return $this
     */
    public function setDestinationPostalCodeHigh($destination_postal_code_high)
    {
        $this->container['destination_postal_code_high'] = $destination_postal_code_high;

        return $this;
    }

    /**
     * Gets destination_state_province
     *
     * @return string
     */
    public function getDestinationStateProvince()
    {
        return $this->container['destination_state_province'];
    }

    /**
     * Sets destination_state_province
     *
     * @param string $destination_state_province The shipment destination state or province.     For U.S. addresses, the value will be a valid 2-Character value (per U.S. Mail Standards).     For non-U.S. addresses the full State or Province name will be returned.
     *
     * @return $this
     */
    public function setDestinationStateProvince($destination_state_province)
    {
        $this->container['destination_state_province'] = $destination_state_province;

        return $this;
    }

    /**
     * Gets destination_city_name
     *
     * @return string
     */
    public function getDestinationCityName()
    {
        return $this->container['destination_city_name'];
    }

    /**
     * Sets destination_city_name
     *
     * @param string $destination_city_name The shipment destination city.     Required for International requests for those countries that do not utilize postal codes.
     *
     * @return $this
     */
    public function setDestinationCityName($destination_city_name)
    {
        $this->container['destination_city_name'] = $destination_city_name;

        return $this;
    }

    /**
     * Gets origin_country_name
     *
     * @return string
     */
    public function getOriginCountryName()
    {
        return $this->container['origin_country_name'];
    }

    /**
     * Sets origin_country_name
     *
     * @param string $origin_country_name Origin country name value
     *
     * @return $this
     */
    public function setOriginCountryName($origin_country_name)
    {
        $this->container['origin_country_name'] = $origin_country_name;

        return $this;
    }

    /**
     * Gets origin_country_code
     *
     * @return string
     */
    public function getOriginCountryCode()
    {
        return $this->container['origin_country_code'];
    }

    /**
     * Sets origin_country_code
     *
     * @param string $origin_country_code Origin country code, conforms to ISO-defined country codes.
     *
     * @return $this
     */
    public function setOriginCountryCode($origin_country_code)
    {
        $this->container['origin_country_code'] = $origin_country_code;

        return $this;
    }

    /**
     * Gets origin_postal_code
     *
     * @return string
     */
    public function getOriginPostalCode()
    {
        return $this->container['origin_postal_code'];
    }

    /**
     * Sets origin_postal_code
     *
     * @param string $origin_postal_code The shipment origin postal code.  Required for US domestic requests.     Either 5, or 9-digit US zip codes must be used for U.S. addresses.  For non-US addresses, this is recommended for all countries that utilize postal codes.
     *
     * @return $this
     */
    public function setOriginPostalCode($origin_postal_code)
    {
        $this->container['origin_postal_code'] = $origin_postal_code;

        return $this;
    }

    /**
     * Gets origin_postal_code_low
     *
     * @return string
     */
    public function getOriginPostalCodeLow()
    {
        return $this->container['origin_postal_code_low'];
    }

    /**
     * Sets origin_postal_code_low
     *
     * @param string $origin_postal_code_low The shipment origin postal code low range.  Value may or may not differ from destinationPostalCode.      Either 5, or 9-digit US zip codes must be used for U.S. addresses.  For non-US addresses, this is recommended for all countries that utilize postal codes.
     *
     * @return $this
     */
    public function setOriginPostalCodeLow($origin_postal_code_low)
    {
        $this->container['origin_postal_code_low'] = $origin_postal_code_low;

        return $this;
    }

    /**
     * Gets origin_postal_code_high
     *
     * @return string
     */
    public function getOriginPostalCodeHigh()
    {
        return $this->container['origin_postal_code_high'];
    }

    /**
     * Sets origin_postal_code_high
     *
     * @param string $origin_postal_code_high The shipment origin postal code high range.  Value may or may not differ from destinationPostalCode.      Either 5, or 9-digit US zip codes must be used for U.S. addresses.  For non-US addresses, this is recommended for all countries that utilize postal codes.
     *
     * @return $this
     */
    public function setOriginPostalCodeHigh($origin_postal_code_high)
    {
        $this->container['origin_postal_code_high'] = $origin_postal_code_high;

        return $this;
    }

    /**
     * Gets origin_state_province
     *
     * @return string
     */
    public function getOriginStateProvince()
    {
        return $this->container['origin_state_province'];
    }

    /**
     * Sets origin_state_province
     *
     * @param string $origin_state_province The shipment origin state or province.     For U.S. addresses, the value will be a valid 2-Character value (per U.S. Mail Standards).     For non-U.S. addresses the full State or Province name will be returned.
     *
     * @return $this
     */
    public function setOriginStateProvince($origin_state_province)
    {
        $this->container['origin_state_province'] = $origin_state_province;

        return $this;
    }

    /**
     * Gets origin_city_name
     *
     * @return string
     */
    public function getOriginCityName()
    {
        return $this->container['origin_city_name'];
    }

    /**
     * Sets origin_city_name
     *
     * @param string $origin_city_name The shipment origin city.     Required for International requests for those countries that do not utilize postal codes.
     *
     * @return $this
     */
    public function setOriginCityName($origin_city_name)
    {
        $this->container['origin_city_name'] = $origin_city_name;

        return $this;
    }

    /**
     * Gets weight
     *
     * @return string
     */
    public function getWeight()
    {
        return $this->container['weight'];
    }

    /**
     * Sets weight
     *
     * @param string $weight Shipment weight.  Value is only required for international shipment.      Defaults to 0.0
     *
     * @return $this
     */
    public function setWeight($weight)
    {
        $this->container['weight'] = $weight;

        return $this;
    }

    /**
     * Gets weight_unit_of_measure
     *
     * @return string
     */
    public function getWeightUnitOfMeasure()
    {
        return $this->container['weight_unit_of_measure'];
    }

    /**
     * Sets weight_unit_of_measure
     *
     * @param string $weight_unit_of_measure Returned on response when weight was present on the request.
     *
     * @return $this
     */
    public function setWeightUnitOfMeasure($weight_unit_of_measure)
    {
        $this->container['weight_unit_of_measure'] = $weight_unit_of_measure;

        return $this;
    }

    /**
     * Gets shipment_contents_value
     *
     * @return string
     */
    public function getShipmentContentsValue()
    {
        return $this->container['shipment_contents_value'];
    }

    /**
     * Sets shipment_contents_value
     *
     * @param string $shipment_contents_value Shipment contents value. Value is only required for international shipment.     Defaults to 0.0
     *
     * @return $this
     */
    public function setShipmentContentsValue($shipment_contents_value)
    {
        $this->container['shipment_contents_value'] = $shipment_contents_value;

        return $this;
    }

    /**
     * Gets shipment_contents_currency_code
     *
     * @return string
     */
    public function getShipmentContentsCurrencyCode()
    {
        return $this->container['shipment_contents_currency_code'];
    }

    /**
     * Sets shipment_contents_currency_code
     *
     * @param string $shipment_contents_currency_code Returned on response when shipmentContentsValue was present on the request.
     *
     * @return $this
     */
    public function setShipmentContentsCurrencyCode($shipment_contents_currency_code)
    {
        $this->container['shipment_contents_currency_code'] = $shipment_contents_currency_code;

        return $this;
    }

    /**
     * Gets guarantee_suspended
     *
     * @return bool
     */
    public function getGuaranteeSuspended()
    {
        return $this->container['guarantee_suspended'];
    }

    /**
     * Sets guarantee_suspended
     *
     * @param bool $guarantee_suspended Returns TRUE if the shipment dates fall within a defined peak date range. When the guarantee is suspended, it is suspended for all services in the response.      The logic for determining if guarantees are suspended applies per origin country.     The following will be used to determine if a shipment falls within a defined peak date range: shipDate (from the response), deliveryDate (from the response), server Date.     Defined peak date range (range for when guarantees are suspended) is inclusive of start and end dates.
     *
     * @return $this
     */
    public function setGuaranteeSuspended($guarantee_suspended)
    {
        $this->container['guarantee_suspended'] = $guarantee_suspended;

        return $this;
    }

    /**
     * Gets number_of_services
     *
     * @return int
     */
    public function getNumberOfServices()
    {
        return $this->container['number_of_services'];
    }

    /**
     * Sets number_of_services
     *
     * @param int $number_of_services Number of services being returned in the services array.
     *
     * @return $this
     */
    public function setNumberOfServices($number_of_services)
    {
        $this->container['number_of_services'] = $number_of_services;

        return $this;
    }

    /**
     * Gets services
     *
     * @return \UPS\TimeInTransit\TimeInTransit\Services[]
     */
    public function getServices()
    {
        return $this->container['services'];
    }

    /**
     * Sets services
     *
     * @param \UPS\TimeInTransit\TimeInTransit\Services[] $services services
     *
     * @return $this
     */
    public function setServices($services)
    {
        $this->container['services'] = $services;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}
