<?php
/**
 * PreNotificationRequestShipment
 *
 * PHP version 5
 *
 * @category Class
 * @package  UPS\PreNotification
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PreNotification
 *
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * 
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 3.0.50
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace UPS\PreNotification\PreNotification;

use \ArrayAccess;
use \UPS\PreNotification\ObjectSerializer;

/**
 * PreNotificationRequestShipment Class Doc Comment
 *
 * @category Class
 * @description Shipment Container
 * @package  UPS\PreNotification
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class PreNotificationRequestShipment implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'PreNotificationRequest_Shipment';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'shipper_number' => 'string',
        'shipment_identification_number' => 'string',
        'ship_to_address' => '\UPS\PreNotification\PreNotification\ShipmentShipToAddress',
        'ship_from_address' => '\UPS\PreNotification\PreNotification\ShipmentShipFromAddress',
        'pickup_date' => 'string',
        'service' => '\UPS\PreNotification\PreNotification\ShipmentService',
        'regulation_set' => 'string',
        'package' => '\UPS\PreNotification\PreNotification\ShipmentPackage[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'shipper_number' => null,
        'shipment_identification_number' => null,
        'ship_to_address' => null,
        'ship_from_address' => null,
        'pickup_date' => null,
        'service' => null,
        'regulation_set' => null,
        'package' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'shipper_number' => 'ShipperNumber',
        'shipment_identification_number' => 'ShipmentIdentificationNumber',
        'ship_to_address' => 'ShipToAddress',
        'ship_from_address' => 'ShipFromAddress',
        'pickup_date' => 'PickupDate',
        'service' => 'Service',
        'regulation_set' => 'RegulationSet',
        'package' => 'Package'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'shipper_number' => 'setShipperNumber',
        'shipment_identification_number' => 'setShipmentIdentificationNumber',
        'ship_to_address' => 'setShipToAddress',
        'ship_from_address' => 'setShipFromAddress',
        'pickup_date' => 'setPickupDate',
        'service' => 'setService',
        'regulation_set' => 'setRegulationSet',
        'package' => 'setPackage'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'shipper_number' => 'getShipperNumber',
        'shipment_identification_number' => 'getShipmentIdentificationNumber',
        'ship_to_address' => 'getShipToAddress',
        'ship_from_address' => 'getShipFromAddress',
        'pickup_date' => 'getPickupDate',
        'service' => 'getService',
        'regulation_set' => 'getRegulationSet',
        'package' => 'getPackage'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }



    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['shipper_number'] = isset($data['shipper_number']) ? $data['shipper_number'] : null;
        $this->container['shipment_identification_number'] = isset($data['shipment_identification_number']) ? $data['shipment_identification_number'] : null;
        $this->container['ship_to_address'] = isset($data['ship_to_address']) ? $data['ship_to_address'] : null;
        $this->container['ship_from_address'] = isset($data['ship_from_address']) ? $data['ship_from_address'] : null;
        $this->container['pickup_date'] = isset($data['pickup_date']) ? $data['pickup_date'] : null;
        $this->container['service'] = isset($data['service']) ? $data['service'] : null;
        $this->container['regulation_set'] = isset($data['regulation_set']) ? $data['regulation_set'] : null;
        $this->container['package'] = isset($data['package']) ? $data['package'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['shipper_number'] === null) {
            $invalidProperties[] = "'shipper_number' can't be null";
        }
        if ($this->container['shipment_identification_number'] === null) {
            $invalidProperties[] = "'shipment_identification_number' can't be null";
        }
        if ($this->container['ship_to_address'] === null) {
            $invalidProperties[] = "'ship_to_address' can't be null";
        }
        if ($this->container['ship_from_address'] === null) {
            $invalidProperties[] = "'ship_from_address' can't be null";
        }
        if ($this->container['pickup_date'] === null) {
            $invalidProperties[] = "'pickup_date' can't be null";
        }
        if ($this->container['service'] === null) {
            $invalidProperties[] = "'service' can't be null";
        }
        if ($this->container['regulation_set'] === null) {
            $invalidProperties[] = "'regulation_set' can't be null";
        }
        if ($this->container['package'] === null) {
            $invalidProperties[] = "'package' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets shipper_number
     *
     * @return string
     */
    public function getShipperNumber()
    {
        return $this->container['shipper_number'];
    }

    /**
     * Sets shipper_number
     *
     * @param string $shipper_number Shipper's six digit account number.
     *
     * @return $this
     */
    public function setShipperNumber($shipper_number)
    {
        $this->container['shipper_number'] = $shipper_number;

        return $this;
    }

    /**
     * Gets shipment_identification_number
     *
     * @return string
     */
    public function getShipmentIdentificationNumber()
    {
        return $this->container['shipment_identification_number'];
    }

    /**
     * Sets shipment_identification_number
     *
     * @param string $shipment_identification_number 1Z Number of the first package in the shipment.
     *
     * @return $this
     */
    public function setShipmentIdentificationNumber($shipment_identification_number)
    {
        $this->container['shipment_identification_number'] = $shipment_identification_number;

        return $this;
    }

    /**
     * Gets ship_to_address
     *
     * @return \UPS\PreNotification\PreNotification\ShipmentShipToAddress
     */
    public function getShipToAddress()
    {
        return $this->container['ship_to_address'];
    }

    /**
     * Sets ship_to_address
     *
     * @param \UPS\PreNotification\PreNotification\ShipmentShipToAddress $ship_to_address ship_to_address
     *
     * @return $this
     */
    public function setShipToAddress($ship_to_address)
    {
        $this->container['ship_to_address'] = $ship_to_address;

        return $this;
    }

    /**
     * Gets ship_from_address
     *
     * @return \UPS\PreNotification\PreNotification\ShipmentShipFromAddress
     */
    public function getShipFromAddress()
    {
        return $this->container['ship_from_address'];
    }

    /**
     * Sets ship_from_address
     *
     * @param \UPS\PreNotification\PreNotification\ShipmentShipFromAddress $ship_from_address ship_from_address
     *
     * @return $this
     */
    public function setShipFromAddress($ship_from_address)
    {
        $this->container['ship_from_address'] = $ship_from_address;

        return $this;
    }

    /**
     * Gets pickup_date
     *
     * @return string
     */
    public function getPickupDate()
    {
        return $this->container['pickup_date'];
    }

    /**
     * Sets pickup_date
     *
     * @param string $pickup_date Date of the On Call Air Pickup. Format is YYYYMMDD
     *
     * @return $this
     */
    public function setPickupDate($pickup_date)
    {
        $this->container['pickup_date'] = $pickup_date;

        return $this;
    }

    /**
     * Gets service
     *
     * @return \UPS\PreNotification\PreNotification\ShipmentService
     */
    public function getService()
    {
        return $this->container['service'];
    }

    /**
     * Sets service
     *
     * @param \UPS\PreNotification\PreNotification\ShipmentService $service service
     *
     * @return $this
     */
    public function setService($service)
    {
        $this->container['service'] = $service;

        return $this;
    }

    /**
     * Gets regulation_set
     *
     * @return string
     */
    public function getRegulationSet()
    {
        return $this->container['regulation_set'];
    }

    /**
     * Sets regulation_set
     *
     * @param string $regulation_set The Regulatory set associated with every regulated shipment. It must be same across the shipment. Valid values are: - ADR – European Agreement concerning the International Carriage of Dangerous Goods by Road. - 49CFR – Title 49 of the United States Code of Federal Regulations. - IATA – International Air Transport Association (IATA) Dangerous Goods Regulations.
     *
     * @return $this
     */
    public function setRegulationSet($regulation_set)
    {
        $this->container['regulation_set'] = $regulation_set;

        return $this;
    }

    /**
     * Gets package
     *
     * @return \UPS\PreNotification\PreNotification\ShipmentPackage[]
     */
    public function getPackage()
    {
        return $this->container['package'];
    }

    /**
     * Sets package
     *
     * @param \UPS\PreNotification\PreNotification\ShipmentPackage[] $package package
     *
     * @return $this
     */
    public function setPackage($package)
    {
        $this->container['package'] = $package;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}
