<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2024 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

/**
 * Class ControllerResponsesCheckoutTelephoneOption
 * @property ModelExtensionFastCheckout $model_extension_fast_checkout
 * @property ModelExtensionTelephone $model_extension_telephone
 */

class ControllerResponsesCheckoutTelephoneOption extends AController {
    public $data=[];
    public $error = [];

    public function updateOrderData() {
        //init controller data
        $this->extensions->hk_InitData($this, __FUNCTION__);

        $in_data = array_merge(
            (array)$this->session->data,
            $this->session->data['fc'][$this->session->data['cart_key']]
        );
        $request = array_merge($this->request->get, $this->request->post);
         $this->updateOrCreateOrder($in_data, $request);

        //update controller data
        $this->extensions->hk_UpdateData($this, __FUNCTION__);
        return null;
    }

    protected function updateOrCreateOrder($in_data, $request) {
        if (!$this->session->data['order_id']) {
            //create order and save details
            $order = new AOrder($this->registry);
        } else {
            $order = new AOrder($this->registry, $this->session->data['order_id']);
        }

        $order->buildOrderData($in_data);
        $order_id = $order->saveOrder();

        $this->loadModel('extension/telephone','storefront');
        if ($order_id) {
            if ($request['fax']) {
                $fax = $request['fax'];
                $this->model_extension_telephone->updateOrderDetails(
                    $order_id,
                    [
                        'fax' => $fax,
                    ]
                );
                if( !$this->customer->isLogged() ){
                    $this->session->data['guest']['fax'] = $fax;
                }
            }

            if ($request['cc_telephone'] || $request['telephone']) {
                $telephone = $request['cc_telephone'] ? $request['cc_telephone'] : $request['telephone'];
                $this->model_extension_telephone->updateOrderDetails(
                    $order_id,
                    [
                        'telephone' => $telephone,
                    ]
                );
                if( !$this->customer->isLogged() ){
                    $this->session->data['guest']['telephone'] = $telephone;
                }
            }

            $this->session->data['order_id'] = $order_id;
        } else {
            $this->_to_log(sprintf($this->language->get('fast_checkout_error_unexpected_log'), var_export($in_data, true)));
            $this->error['message'] = $this->language->get('fast_checkout_error_unexpected');
            unset($this->session->data['order_id']);
        }
    }

    protected function _to_log($message) {
        if (!$message) {
            return false;
        }
        $message = 'FastCheckout Error: '.$message;
        $error = new AError($message);
        $error->toLog()->toDebug();
        unset($error);
        return true;
    }
}