<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2024 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (! defined ( 'DIR_CORE' )) {
    header ( 'Location: static_pages/' );
}

/**
 * Class ControllerPagesCatalogProductTotalSavings
 * @property ModelCatalogProductTotalSavings $model_catalog_product_total_savings
 */

class ControllerPagesCatalogProductTotalSavings extends AController {
    private $error = [];
    public $data = [];
    private $fields=[
        'show_product_total_savings' ,
        'show_other_page_product_total_savings'
    ];

    public function main() {

        //init controller data
        $this->extensions->hk_InitData($this,__FUNCTION__);

        $this->loadLanguage('option_price_pro_with_discount/option_price_pro_with_discount');
        $this->loadLanguage('catalog/product');
        $this->loadModel('catalog/product_total_savings');
        $this->loadModel('catalog/product');

        if ($this->request->is_POST() && $this->_validateForm()) {
            $data=$this->request->post;
            $data['product_id'] = $this->request->get['product_id'];
            $this->model_catalog_product_total_savings->addProductSavings($data);
            $this->session->data['success'] = $this->language->get('text_success_product_total_savings');
            redirect(
                $this->html->getSecureURL(
                    'catalog/product_total_savings',
                    '&product_id='.$this->request->get['product_id']
                )
            );
        }

        $this->document->setTitle($this->language->get('heading_title_product_total_savings'));

        $this->data['heading_title'] = $this->language->get('heading_title_product_total_savings');

        $this->view->assign('error', $this->error);
        $this->view->assign('success', $this->session->data['success']);
        if (isset($this->session->data['success'])) {
            unset($this->session->data['success']);
        }

        $this->document->initBreadcrumb([
            'href'      => $this->html->getSecureURL('index/home'),
            'text'      => $this->language->get('text_home'),
            'separator' => false,
        ]);
        $this->document->addBreadcrumb([
            'href'      => $this->html->getSecureURL('catalog/product'),
            'text'      => $this->language->get('heading_title'),
            'separator' => ' :: ',
        ]);
        $this->document->addBreadcrumb([
            'href'      => $this->html->getSecureURL('catalog/product/update',
                '&product_id='.$this->request->get['product_id']),
            'text'      => $this->language->get('text_edit')
                .'&nbsp;'
                .$this->language->get('text_product')
                .' - '
                .$this->data['product_description'][$this->session->data['content_language_id']]['name'],
            'separator' => ' :: ',
        ]);
        $this->document->addBreadcrumb([
            'href'      => $this->html->getSecureURL(
                'catalog/product_total_savings',
                '&product_id='.$this->request->get['product_id']
            ),
            'text'      => $this->language->get('heading_title_product_total_savings'),
            'separator' => ' :: ',
            'current'   => true,
        ]);

        $this->data['language_id'] = $this->session->data['content_language_id'];

        //load tabs controller
        $this->data['active'] = 'product_total_savings';
        $tabs_obj = $this->dispatch('pages/catalog/product_tabs', [$this->data]);
        $this->data['product_tabs'] = $tabs_obj->dispatchGetOutput();
        unset($tabs_obj);

        $datas = $this->model_catalog_product_total_savings->getProductSavings($this->request->get['product_id']);
        foreach ($this->fields as $field) {
            $this->data[$field] = $datas[$field];
        }

        $this->data['action'] =
            $this->html->getSecureURL('catalog/product_total_savings', '&product_id='.$this->request->get['product_id']);
        $this->data['form_title'] = $this->language->get('text_edit').'&nbsp;'.$this->language->get('text_product');
        $this->data['update'] = '';
        $form = new AForm('HT');

        $form->setForm([
            'form_name' => 'product_total_savings_form',
            'update'    => $this->data['update'],
        ]);

        $this->data['form']['id'] = 'area_calculator_form';
        $this->data['form']['form_open'] = $form->getFieldHtml([
            'type'   => 'form',
            'name'   => 'product_total_savings_form',
            'action' => $this->data['action'],
            'attr'   => 'data-confirm-exit="true" class="aform form-horizontal"',
        ]);

        $this->data['form']['fields']['show_product_total_savings'] = $form->getFieldHtml([
            'type' => 'checkbox',
            'name' => 'show_product_total_savings',
            'value' => $this->data['show_product_total_savings'],
            'style' => 'btn_switch',
        ]);

        $this->data['form']['fields']['show_other_page_product_total_savings'] = $form->getFieldHtml([
            'type' => 'checkbox',
            'name' => 'show_other_page_product_total_savings',
            'value' => $this->data['show_other_page_product_total_savings'],
            'style' => 'btn_switch',
        ]);


        $this->data['form']['submit'] = $form->getFieldHtml([
            'type'  => 'button',
            'name'  => 'submit',
            'text'  => $this->language->get('button_save'),
            'style' => 'button1',
        ]);

        $this->data['form']['cancel'] = $form->getFieldHtml([
            'type'  => 'button',
            'name'  => 'cancel',
            'text'  => $this->language->get('button_cancel'),
            'style' => 'button2',
        ]);

        $this->addChild('pages/catalog/product_summary', 'summary_form', 'pages/catalog/product_summary.tpl');
        $this->view->batchAssign($this->data);
        $this->view->batchAssign($this->language->getASet());
        $this->processTemplate('pages/catalog/product_total_savings.tpl');

        //update controller data
        $this->extensions->hk_UpdateData($this,__FUNCTION__);
    }

    private function _validateForm() {
        $this->load->language('option_price_pro_with_discount/option_price_pro_with_discount');
        if (!$this->user->canModify('catalog/product_total_savings')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        if ($this->request->post['unit_text']==='') {
            $this->error['unit_text'] = $this->language->get('error_unit_text');
        }

        if (!$this->error) {
            return TRUE;
        } else {
            return FALSE;
        }
    }

}