<?php
 /*------------------------------------------------------------------------------

   For Abante Cart, E-commerce Solution
   http://www.AbanteCart.com

   Copyright (c) 2014-2024 We Hear You 2, Inc.  (WHY2)

 ------------------------------------------------------------------------------*/

 if (!defined('DIR_CORE')) {
     header('Location: static_pages/');
 }

class ModelExtensionTracking extends Model {

	/**
	 * @param $order_id
	 *
	 * @return array
	 */
    public function getTrack($order_id)  {
        $query = $this->db->query(
            "SELECT *
      		        FROM " . $this->db->table("order_data") . " a
                  LEFT JOIN " . $this->db->table("order_data_types") . " b
                  ON a.type_id = b.type_id
      		        WHERE a.order_id = '" . (int)$order_id . "' AND b.name = 'tracking'
                   "
        );
        $order_query = $query->row;
        $result = [
            'order_id' => $order_query['order_id'],
            'type_id' => $order_query['type_id'],
            'data' => $order_query['data'],
            'date_added' => $order_query['date_added'],
            'date_modified' => $order_query['date_modified'],
        ];
        return $result;
    }

	/**
	 * @param $order_id
	 * @param $trackdata
	 */
    public function processUpdateOrderData($order_id, $trackdata) {
        $sqlex = $this->db->query(
            "SELECT *
      		        FROM " . $this->db->table("order_data") . " a
                  LEFT JOIN " . $this->db->table("order_data_types") . " b
                  ON a.type_id = b.type_id
      		        WHERE a.order_id = '" . (int)$order_id . "' AND b.name = 'tracking'
                   "
        );
        $data_type_idsql = $this->db->query(
            "SELECT `type_id`
      		        FROM " . $this->db->table("order_data_types") . "
      		        WHERE name = 'tracking'
                   "
        );

        if ($data_type_idsql->num_rows) {
            foreach ($data_type_idsql->rows as $row) {
                $data_type_id = $row['type_id'];
            }
            if ($data_type_id > 0) {
                if (empty($sqlex->num_rows)) {
                    $sql = "INSERT INTO " . $this->db->table('order_data') . " (`order_id`,`type_id`,`data`)
                        VALUES ('" . (int)$order_id . "', '" . (int)$data_type_id . "', '" . $trackdata . "')

                        ";
                    $this->db->query($sql);
                } else {
                $sqlup = "UPDATE " . $this->db->table('order_data') . "
                            SET `data` = '" . $trackdata . "' WHERE `order_id` = " . (int)$order_id . " AND `type_id` = '" . (int)$data_type_id . "' LIMIT 1;";
                    $this->db->query($sqlup);
                }
            }
        }
    }

	/**
	 * @return mixed
	 */
    public function getCommentTemplate() {
    	$query = $this->db->query("SELECT `content`,`allowed_placeholders` FROM ".$this->db->table('email_editor_templates')." WHERE section='shipping_info'");
    	return $query->row;
    }

    /**
     * @param $shipper
     * @return mixed
     * @throws AException
     */
    public function getSpecificTemplate($shipper) {
        $shipper_name = strtolower($this->renameShipper($shipper));
        $query = $this->db->query("SELECT `content`,`allowed_placeholders` FROM ".$this->db->table('email_editor_templates')." WHERE section='".$shipper_name."_shipping_info'");
        return $query->row;
    }


    /**
	 * @return string
	 */
    public function getLocalCommentTemplate() {
	    $query = $this->db->query("SELECT `content`,`allowed_placeholders` FROM ".$this->db->table('email_editor_templates')." WHERE section='local_shipping_info'");
	    return $query->row;
    }

	/**
	 * @return string
	 */
	public function getStorePickupTemplate() {
		$query = $this->db->query("SELECT `content`,`allowed_placeholders` FROM ".$this->db->table('email_editor_templates')." WHERE section='store_pickup_info'");
		return $query->row;
	}

	/**
	 * @return mixed
	 */
    public function getShippers() {
    	$query = $this->db->query("SELECT shipper_tracking_url_id as id, shipper_name as shipper FROM ".
	                                $this->db->table('shipper_tracking_url'));
    	return $query->rows;
    }

	/**
	 * @param $id
	 *
	 * @return mixed
	 */
    public function getShipperNameById($id) {
	    $query = $this->db->query("SELECT shipper_name FROM ".$this->db->table('shipper_tracking_url'). " WHERE shipper_tracking_url_id=".$id);
	    return $query->row['shipper_name'];
    }

	/**
	 * @param $id
	 *
	 * @return mixed
	 */
    public function getTrackingUrlById($id) {
	    $query = $this->db->query("SELECT tracking_url FROM ".$this->db->table('shipper_tracking_url'). " WHERE shipper_tracking_url_id=".$id);
	    return $query->row['tracking_url'];
    }

    /**
     * @param $shipper
     * @return string
     */
    public function renameShipper($shipper) {
        $name='';
        switch ($shipper) {
            case 'Australia Post':
                $name = 'auspost';
                break;
            case 'Canada Post':
                $name = 'canpost';
                break;
            case 'Parcel Force':
                $name = 'parcelforce';
                break;
            case 'Royal Mail':
                $name = 'royalmail';
                break;
            case 'R L Carriers';
                $name = 'rl';
                break;
            default:
                $name = $shipper;
                break;
        }
        return $name;
    }
}
