<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2024 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

/**
 * Class ControllerResponsesExtensionEmailEditor
 * @property ModelExtensionEmailSignatures $model_extension_email_signatures
 * @property ModelExtensionEmailTemplates $model_extension_email_templates
 */
class ControllerResponsesExtensionEmailEditor extends AController {
    public $data=[];

    /**
     * @throws AException
     */
    public function getSignatureById() {
        $id=$this->request->post['id'];
        $this->load->model('extension/email_signatures');
        $signatures=$this->model_extension_email_signatures->getSignature($id);
        $this->response->setOutput(html_entity_decode($signatures['content']));
    }

    /**
     * @throws AException
     */
    public function sendEmail() {
        $id=$this->request->post['id'];
        $content=$this->request->post['content'];
        $this->load->model('extension/email_signatures');
        $signatures=$this->model_extension_email_signatures->getSignature($id);
    }

    /**
     * @throws AException
     */
    public function getEmailContentBySection() {
        $this->load->model('extension/email_templates');
        $section = $this->request->post['section'];
        $email_template_id = $this->model_extension_email_templates->getEmailTemplateId($section);
        $template=$this->model_extension_email_templates->getTemplate($email_template_id['email_template_id']);
        $this->response->setOutput(html_entity_decode($template['content']));
    }

    /**
     * @throws AException
     */
    public function getSignatureBySection() {
        $this->load->model('extension/email_templates');
        $this->load->model('extension/email_signatures');
        $section = $this->request->post['section'];
        $email_signature_id = $this->model_extension_email_templates->getEmailTemplateId($section);
        $signatures=$this->model_extension_email_signatures->getSignature($email_signature_id['email_signature_id']);
        $this->response->setOutput(html_entity_decode($signatures['content']));
    }

    /**
     * @throws AException
     */
    public function getEmailTemplateIdBySection() {
        $this->load->model('extension/email_templates');
        $section = $this->request->post['section'];
        $email_template_id = $this->model_extension_email_templates->getEmailTemplateId($section);
        $this->response->setOutput($email_template_id['email_template_id']);
    }

}