<?php
/*
 *   $Id$
 *
 *   AbanteCart, Ideal OpenSource Ecommerce Solution
 *   http://www.AbanteCart.com
 *
 *   Copyright © 2011-2024 Belavier Commerce LLC
 *
 *   This source file is subject to Open Software License (OSL 3.0)
 *   License details is bundled with this package in the file LICENSE.txt.
 *   It is also available at this URL:
 *   <http://www.opensource.org/licenses/OSL-3.0>
 *
 *  UPGRADE NOTE:
 *    Do not edit or add to this file if you wish to upgrade AbanteCart to newer
 *    versions in the future. If you wish to customize AbanteCart for your
 *    needs please refer to http://www.AbanteCart.com for more information.
 */

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

//before install validate it is unique
$lng_code = 'es';
$lng_name = 'Español';
$lng_directory = 'spanish';
$lng_locale = 'es_ES.UTF-8,es_ES,spanish';
$lng_flag_path = 'extensions/default_spanish/storefront/language/spanish/flag.png';
$lng_sort = 2; // sorting order with other langauges
$lng_status = 0; // Status on installation of extension

$query = $this->db->query("SELECT language_id FROM " . $this->db->table('languages') . " WHERE code='" . $lng_code . "'");
if ($query->row['language_id']) {
    $this->session->data['error'] = "Error: Language with " . $lng_code . " code is already installed! Can not install duplicate languages! Uninstall this extension before attempting again.";
    $error = new AError ($this->session->data['error']);
    $error->toLog()->toDebug();
    return false;
}

$this->db->query("INSERT INTO " . $this->db->table('languages') . " (`name`,`code`,`locale`,`image`,`directory`,`filename`,`sort_order`, `status`)
				  VALUES ('" . $lng_name . "', '" . $lng_code . "', '" . $lng_locale . "', '" . $lng_flag_path . "','" . $lng_directory . "','" . $lng_directory . "','" . $lng_sort . "'," . $lng_status . ");");

$new_language_id = $this->db->getLastId();
$xml = simplexml_load_file(DIR_EXT . 'default_spanish/menu.xml');

$routes = [
    'text_index_home_menu'        => 'index/home',
    'text_product_special_menu'   => 'product/special',
    'text_account_login_menu'     => 'account/login',
    'text_account_logout_menu'    => 'account/logout',
    'text_account_account_menu'   => 'account/account',
    'text_account_history_menu'   => 'account/history',
    'text_checkout_cart_menu'     => 'checkout/cart',
    'text_checkout_shipping_menu' => 'checkout/fast_checkout',
];

if ($xml) {
    foreach ($xml->definition as $item) {
        $translates[$routes[(string)$item->key]] = (string)$item->value;
    }

    $storefront_menu = new AMenu_Storefront();
    $storefront_menu->addLanguage($new_language_id, $translates);
}

//Load core content

$this->db->query("INSERT INTO " . $this->db->table('country_descriptions') . "
(`country_id`,`language_id`, `name`) VALUES
(1, " . $new_language_id . ",'Afganistán'),
(2, " . $new_language_id . ",'Albania'),
(3, " . $new_language_id . ",'Argelia'),
(4, " . $new_language_id . ",'Samoa Americana'),
(5, " . $new_language_id . ",'Andorra'),
(6, " . $new_language_id . ",'Angola'),
(7, " . $new_language_id . ",'Anguilla'),
(8, " . $new_language_id . ",'Antártida'),
(9, " . $new_language_id . ",'Antigua y Barbuda'),
(10, " . $new_language_id . ",'Argentina'),
(11, " . $new_language_id . ",'Armenia'),
(12, " . $new_language_id . ",'Aruba'),
(13, " . $new_language_id . ",'Australia'),
(14, " . $new_language_id . ",'Austria'),
(15, " . $new_language_id . ",'Azerbaiyán'),
(16, " . $new_language_id . ",'Bahamas'),
(17, " . $new_language_id . ",'Bahrein'),
(18, " . $new_language_id . ",'Bangladesh'),
(19, " . $new_language_id . ",'Barbados'),
(20, " . $new_language_id . ",'Bielorrusia'),
(21, " . $new_language_id . ",'Bélgica'),
(22, " . $new_language_id . ",'Belice'),
(23, " . $new_language_id . ",'Benin'),
(24, " . $new_language_id . ",'Bermuda'),
(25, " . $new_language_id . ",'Bhutan'),
(26, " . $new_language_id . ",'Bolivia'),
(27, " . $new_language_id . ",'Bosnia y Herzegovina'),
(28, " . $new_language_id . ",'Botswana'),
(29, " . $new_language_id . ",'Bouvet Island'),
(30, " . $new_language_id . ",'Brasil'),
(31, " . $new_language_id . ",'Territorio Británico del Océano Índico'),
(32, " . $new_language_id . ",'Brunei Darussalam'),
(33, " . $new_language_id . ",'Bulgaria'),
(34, " . $new_language_id . ",'Burkina Faso'),
(35, " . $new_language_id . ",'Burundi'),
(36, " . $new_language_id . ",'Camboya'),
(37, " . $new_language_id . ",'Camerún'),
(38, " . $new_language_id . ",'Canadá'),
(39, " . $new_language_id . ",'Cabo Verde'),
(40, " . $new_language_id . ",'Islas Caimán'),
(41, " . $new_language_id . ",'República Centroafricana'),
(42, " . $new_language_id . ",'Chad'),
(43, " . $new_language_id . ",'Chile'),
(44, " . $new_language_id . ",'China'),
(45, " . $new_language_id . ",'Isla de Navidad'),
(46, " . $new_language_id . ",'Islas Cocos (Keeling)'),
(47, " . $new_language_id . ",'Colombia'),
(48, " . $new_language_id . ",'Comoras'),
(49, " . $new_language_id . ",'Congo'),
(50, " . $new_language_id . ",'Islas Cook'),
(51, " . $new_language_id . ",'Costa Rica'),
(52, " . $new_language_id . ",'Cote D&#39;Ivoire'),
(53, " . $new_language_id . ",'Croacia'),
(54, " . $new_language_id . ",'Cuba'),
(55, " . $new_language_id . ",'Chipre'),
(56, " . $new_language_id . ",'República Checa'),
(57, " . $new_language_id . ",'Dinamarca'),
(58, " . $new_language_id . ",'Djibouti'),
(59, " . $new_language_id . ",'Dominica'),
(60, " . $new_language_id . ",'República Dominicana'),
(61, " . $new_language_id . ",'Timor del Este'),
(62, " . $new_language_id . ",'Ecuador'),
(63, " . $new_language_id . ",'Egipto'),
(64, " . $new_language_id . ",'El Salvador'),
(65, " . $new_language_id . ",'Guinea Ecuatorial'),
(66, " . $new_language_id . ",'Eritrea'),
(67, " . $new_language_id . ",'Estonia'),
(68, " . $new_language_id . ",'Etiopía'),
(69, " . $new_language_id . ",'Islas Malvinas (Falkland)'),
(70, " . $new_language_id . ",'Islas Feroe'),
(71, " . $new_language_id . ",'Fiji'),
(72, " . $new_language_id . ",'Finlandia'),
(73, " . $new_language_id . ",'Francia'),
(74, " . $new_language_id . ",'France, Metropolitan'),
(75, " . $new_language_id . ",'Guiana francés'),
(76, " . $new_language_id . ",'Polinesia francés'),
(77, " . $new_language_id . ",'Territorios Australes Franceses'),
(78, " . $new_language_id . ",'Gabón'),
(79, " . $new_language_id . ",'Gambia'),
(80, " . $new_language_id . ",'Georgia'),
(81, " . $new_language_id . ",'Alemania'),
(82, " . $new_language_id . ",'Ghana'),
(83, " . $new_language_id . ",'Gibraltar'),
(84, " . $new_language_id . ",'Grecia'),
(85, " . $new_language_id . ",'Groenlandia'),
(86, " . $new_language_id . ",'Granada'),
(87, " . $new_language_id . ",'Guadalupe'),
(88, " . $new_language_id . ",'Guam'),
(89, " . $new_language_id . ",'Guatemala'),
(90, " . $new_language_id . ",'Guinea'),
(91, " . $new_language_id . ",'Guinea-Bissau'),
(92, " . $new_language_id . ",'Guayana'),
(93, " . $new_language_id . ",'Haití'),
(94, " . $new_language_id . ",'Heard y Mc Donald Islas'),
(95, " . $new_language_id . ",'Honduras'),
(96, " . $new_language_id . ",'Hong Kong'),
(97, " . $new_language_id . ",'Hungría'),
(98, " . $new_language_id . ",'Islandia'),
(99, " . $new_language_id . ",'India'),
(100, " . $new_language_id . ",'Indonesia'),
(101, " . $new_language_id . ",'Irán (República Islámica del)'),
(102, " . $new_language_id . ",'Irak'),
(103, " . $new_language_id . ",'Irlanda'),
(104, " . $new_language_id . ",'Israel'),
(105, " . $new_language_id . ",'Italia'),
(106, " . $new_language_id . ",'Jamaica'),
(107, " . $new_language_id . ",'Japón'),
(108, " . $new_language_id . ",'Jordania'),
(109, " . $new_language_id . ",'Kazajstán'),
(110, " . $new_language_id . ",'Kenia'),
(111, " . $new_language_id . ",'Kiribati'),
(112, " . $new_language_id . ",'Corea del Norte'),
(113, " . $new_language_id . ",'Corea, República de'),
(114, " . $new_language_id . ",'Kuwait'),
(115, " . $new_language_id . ",'Kirguistán'),
(116, " . $new_language_id . ",'República Democrática Popular Lao'),
(117, " . $new_language_id . ",'Letonia'),
(118, " . $new_language_id . ",'Líbano'),
(119, " . $new_language_id . ",'Lesoto'),
(120, " . $new_language_id . ",'Liberia'),
(121, " . $new_language_id . ",'Jamahiriya Árabe Libia'),
(122, " . $new_language_id . ",'Liechtenstein'),
(123, " . $new_language_id . ",'Lituania'),
(124, " . $new_language_id . ",'Luxemburgo'),
(125, " . $new_language_id . ",'Macau'),
(126, " . $new_language_id . ",'Macedonia'),
(127, " . $new_language_id . ",'Madagascar'),
(128, " . $new_language_id . ",'Malawi'),
(129, " . $new_language_id . ",'Malasia'),
(130, " . $new_language_id . ",'Maldivas'),
(131, " . $new_language_id . ",'Malí'),
(132, " . $new_language_id . ",'Malta'),
(133, " . $new_language_id . ",'Islas Marshall'),
(134, " . $new_language_id . ",'Martinica'),
(135, " . $new_language_id . ",'Mauritania'),
(136, " . $new_language_id . ",'Mauricio'),
(137, " . $new_language_id . ",'Mayotte'),
(138, " . $new_language_id . ",'México'),
(139, " . $new_language_id . ",'Micronesia, Estados Federados de'),
(140, " . $new_language_id . ",'Moldova, República de'),
(141, " . $new_language_id . ",'Mónaco'),
(142, " . $new_language_id . ",'Mongolia'),
(143, " . $new_language_id . ",'Montserrat'),
(144, " . $new_language_id . ",'Marruecos'),
(145, " . $new_language_id . ",'Mozambique'),
(146, " . $new_language_id . ",'Myanmar'),
(147, " . $new_language_id . ",'Namibia'),
(148, " . $new_language_id . ",'Nauru'),
(149, " . $new_language_id . ",'Nepal'),
(150, " . $new_language_id . ",'Países Bajos'),
(151, " . $new_language_id . ",'Antillas Holandesas'),
(152, " . $new_language_id . ",'Nueva Caledonia'),
(153, " . $new_language_id . ",'Nueva Zelandia'),
(154, " . $new_language_id . ",'Nicaragua'),
(155, " . $new_language_id . ",'Níger'),
(156, " . $new_language_id . ",'Nigeria'),
(157, " . $new_language_id . ",'Niue'),
(158, " . $new_language_id . ",'Isla Norfolk'),
(159, " . $new_language_id . ",'Islas Marianas del Norte'),
(160, " . $new_language_id . ",'Noruega'),
(161, " . $new_language_id . ",'Omán'),
(162, " . $new_language_id . ",'Pakistán'),
(163, " . $new_language_id . ",'Palau'),
(164, " . $new_language_id . ",'Panamá'),
(165, " . $new_language_id . ",'Papua Nueva Guinea'),
(166, " . $new_language_id . ",'Paraguay'),
(167, " . $new_language_id . ",'Perú'),
(168, " . $new_language_id . ",'Filipinas'),
(169, " . $new_language_id . ",'Pitcairn'),
(170, " . $new_language_id . ",'Polonia'),
(171, " . $new_language_id . ",'Portugal'),
(172, " . $new_language_id . ",'Puerto Rico'),
(173, " . $new_language_id . ",'Katar'),
(174, " . $new_language_id . ",'Reunión'),
(175, " . $new_language_id . ",'Rumania'),
(176, " . $new_language_id . ",'Rusia'),
(177, " . $new_language_id . ",'Ruanda'),
(178, " . $new_language_id . ",'Saint Kitts y Nevis'),
(179, " . $new_language_id . ",'Santa Lucía'),
(180, " . $new_language_id . ",'San Vicente y las Granadinas'),
(181, " . $new_language_id . ",'Samoa'),
(182, " . $new_language_id . ",'San Marino'),
(183, " . $new_language_id . ",'Santo Tomé y Príncipe'),
(184, " . $new_language_id . ",'Arabia Saudita'),
(185, " . $new_language_id . ",'Senegal'),
(186, " . $new_language_id . ",'Seychelles'),
(187, " . $new_language_id . ",'Sierra Leona'),
(188, " . $new_language_id . ",'Singapur'),
(189, " . $new_language_id . ",'República Eslovaca'),
(190, " . $new_language_id . ",'Eslovenia'),
(191, " . $new_language_id . ",'Islas Salomón'),
(192, " . $new_language_id . ",'Somalia'),
(193, " . $new_language_id . ",'Sudáfrica'),
(194, " . $new_language_id . ",'Georgia del Sur y Sandwich del Sur Islas'),
(195, " . $new_language_id . ",'España'),
(196, " . $new_language_id . ",'Sri Lanka'),
(197, " . $new_language_id . ",'St. Helena'),
(198, " . $new_language_id . ",'San Pedro y Miquelón'),
(199, " . $new_language_id . ",'Sudán'),
(200, " . $new_language_id . ",'Suriname'),
(201, " . $new_language_id . ",'Svalbard y Jan Mayen'),
(202, " . $new_language_id . ",'Swazilandia'),
(203, " . $new_language_id . ",'Suecia'),
(204, " . $new_language_id . ",'Suiza'),
(205, " . $new_language_id . ",'República Árabe Siria'),
(206, " . $new_language_id . ",'Taiwan'),
(207, " . $new_language_id . ",'Tayikistán'),
(208, " . $new_language_id . ",'Tanzania, República Unida de'),
(209, " . $new_language_id . ",'Tailandia'),
(210, " . $new_language_id . ",'Togo'),
(211, " . $new_language_id . ",'Tokelau'),
(212, " . $new_language_id . ",'Tonga'),
(213, " . $new_language_id . ",'Trinidad y Tobago'),
(214, " . $new_language_id . ",'Túnez'),
(215, " . $new_language_id . ",'Turquía'),
(216, " . $new_language_id . ",'Turkmenistán'),
(217, " . $new_language_id . ",'Turcas y Caicos'),
(218, " . $new_language_id . ",'Tuvalu'),
(219, " . $new_language_id . ",'Uganda'),
(220, " . $new_language_id . ",'Ucrania'),
(221, " . $new_language_id . ",'Emiratos Árabes Unidos'),
(222, " . $new_language_id . ",'Reino Unido'),
(223, " . $new_language_id . ",'Estados Unidos'),
(224, " . $new_language_id . ",'Estados Unidos Islas menores alejadas de los'),
(225, " . $new_language_id . ",'Uruguay'),
(226, " . $new_language_id . ",'Uzbekistán'),
(227, " . $new_language_id . ",'Vanuatu'),
(228, " . $new_language_id . ",'Ciudad del Vaticano (Santa Sede)'),
(229, " . $new_language_id . ",'Venezuela'),
(230, " . $new_language_id . ",'Viet Nam'),
(231, " . $new_language_id . ",'Islas Vírgenes (Británicas)'),
(232, " . $new_language_id . ",'Islas Vírgenes (EE.UU.)'),
(233, " . $new_language_id . ",'Islas Wallis y Futuna'),
(234, " . $new_language_id . ",'Sáhara Occidental'),
(235, " . $new_language_id . ",'Yemen'),
(236, " . $new_language_id . ",'Yugoslavia'),
(237, " . $new_language_id . ",'Zaire'),
(238, " . $new_language_id . ",'Zambia'),
(239, " . $new_language_id . ",'Zimbabue'),
(240, " . $new_language_id . ",'Irlanda del Norte');
");

$this->db->query("INSERT INTO " . $this->db->table('zone_descriptions') . "
(`zone_id`,`language_id`, `name`) VALUES
(1, " . $new_language_id . ",'Badakhshan'),
(2, " . $new_language_id . ",'Badghis'),
(3, " . $new_language_id . ",'Baghlan'),
(4, " . $new_language_id . ",'Balkh'),
(5, " . $new_language_id . ",'Bamian'),
(6, " . $new_language_id . ",'Farah'),
(7, " . $new_language_id . ",'Faryab'),
(8, " . $new_language_id . ",'Ghazni'),
(9, " . $new_language_id . ",'Ghowr'),
(10, " . $new_language_id . ",'Helmand'),
(11, " . $new_language_id . ",'Herat'),
(12, " . $new_language_id . ",'Jowzjan'),
(13, " . $new_language_id . ",'Kabul'),
(14, " . $new_language_id . ",'Kandahar'),
(15, " . $new_language_id . ",'Kapisa'),
(16, " . $new_language_id . ",'Khost'),
(17, " . $new_language_id . ",'Konar'),
(18, " . $new_language_id . ",'Kondoz'),
(19, " . $new_language_id . ",'Laghman'),
(20, " . $new_language_id . ",'Lowgar'),
(21, " . $new_language_id . ",'Nangrahar'),
(22, " . $new_language_id . ",'Nimruz'),
(23, " . $new_language_id . ",'Nurestan'),
(24, " . $new_language_id . ",'Oruzgan'),
(25, " . $new_language_id . ",'Paktia'),
(26, " . $new_language_id . ",'Paktika'),
(27, " . $new_language_id . ",'Parwan'),
(28, " . $new_language_id . ",'Samangan'),
(29, " . $new_language_id . ",'Sar-e Pol'),
(30, " . $new_language_id . ",'Takhar'),
(31, " . $new_language_id . ",'Wardak'),
(32, " . $new_language_id . ",'Zabol'),
(33, " . $new_language_id . ",'Berat'),
(34, " . $new_language_id . ",'Bulqize'),
(35, " . $new_language_id . ",'Delvine'),
(36, " . $new_language_id . ",'Devoll'),
(37, " . $new_language_id . ",'Diber'),
(38, " . $new_language_id . ",'Durres'),
(39, " . $new_language_id . ",'Elbasan'),
(40, " . $new_language_id . ",'Kolonje'),
(41, " . $new_language_id . ",'Fier'),
(42, " . $new_language_id . ",'Gjirokaster'),
(43, " . $new_language_id . ",'Gramsh'),
(44, " . $new_language_id . ",'Tiene'),
(45, " . $new_language_id . ",'Kavaje'),
(46, " . $new_language_id . ",'Kurbin'),
(47, " . $new_language_id . ",'Kucove'),
(48, " . $new_language_id . ",'Korce'),
(49, " . $new_language_id . ",'Kruje'),
(50, " . $new_language_id . ",'Kukes'),
(51, " . $new_language_id . ",'Librazhd'),
(52, " . $new_language_id . ",'Lezhe'),
(53, " . $new_language_id . ",'Lushnje'),
(54, " . $new_language_id . ",'Malesi e Madhe'),
(55, " . $new_language_id . ",'Mallakaster'),
(56, " . $new_language_id . ",'Estera'),
(57, " . $new_language_id . ",'Mirdite'),
(58, " . $new_language_id . ",'Peqin'),
(59, " . $new_language_id . ",'Permet'),
(60, " . $new_language_id . ",'Pogradec'),
(61, " . $new_language_id . ",'Vómito'),
(62, " . $new_language_id . ",'Shkoder'),
(63, " . $new_language_id . ",'Skrapar'),
(64, " . $new_language_id . ",'Sarande'),
(65, " . $new_language_id . ",'Tepelene'),
(66, " . $new_language_id . ",'Tropoje'),
(67, " . $new_language_id . ",'Tirane'),
(68, " . $new_language_id . ",'Vlore'),
(69, " . $new_language_id . ",'Adrar'),
(70, " . $new_language_id . ",'Ain Defla'),
(71, " . $new_language_id . ",'Ain Témouchent'),
(72, " . $new_language_id . ",'Alger'),
(73, " . $new_language_id . ",'Annaba'),
(74, " . $new_language_id . ",'Batna'),
(75, " . $new_language_id . ",'Bechar'),
(76, " . $new_language_id . ",'Bugía'),
(77, " . $new_language_id . ",'Biskra'),
(78, " . $new_language_id . ",'Blida'),
(79, " . $new_language_id . ",'Bordj Bou Arreridj'),
(80, " . $new_language_id . ",'Bouira'),
(81, " . $new_language_id . ",'Boumerdes'),
(82, " . $new_language_id . ",'Chlef'),
(83, " . $new_language_id . ",'Constantino'),
(84, " . $new_language_id . ",'Djelfa'),
(85, " . $new_language_id . ",'El Bayadh'),
(86, " . $new_language_id . ",'El Oued'),
(87, " . $new_language_id . ",'El Tarf'),
(88, " . $new_language_id . ",'Ghardaia'),
(89, " . $new_language_id . ",'Guelma'),
(90, " . $new_language_id . ",'Illizi'),
(91, " . $new_language_id . ",'Jijel'),
(92, " . $new_language_id . ",'Khenchela'),
(93, " . $new_language_id . ",'Laghouat'),
(94, " . $new_language_id . ",'Muaskar'),
(95, " . $new_language_id . ",'Medea'),
(96, " . $new_language_id . ",'Mila'),
(97, " . $new_language_id . ",'Mostaganem'),
(98, " . $new_language_id . ",'M&#39;Sila'),
(99, " . $new_language_id . ",'Naama'),
(100, " . $new_language_id . ",'Oran'),
(101, " . $new_language_id . ",'Ouargla'),
(102, " . $new_language_id . ",'Oum el-Bouaghi'),
(103, " . $new_language_id . ",'Relizane'),
(104, " . $new_language_id . ",'Saida'),
(105, " . $new_language_id . ",'Setif'),
(106, " . $new_language_id . ",'Sidi Bel Abbes'),
(107, " . $new_language_id . ",'Skikda'),
(108, " . $new_language_id . ",'Souk Ahras'),
(109, " . $new_language_id . ",'Tamanghasset'),
(110, " . $new_language_id . ",'Tebessa'),
(111, " . $new_language_id . ",'Tiaret'),
(112, " . $new_language_id . ",'Tindouf'),
(113, " . $new_language_id . ",'Tipaza'),
(114, " . $new_language_id . ",'Tissemsilt'),
(115, " . $new_language_id . ",'Tizi Ouzou'),
(116, " . $new_language_id . ",'Tlemcen'),
(117, " . $new_language_id . ",'Oriental'),
(118, " . $new_language_id . ",'Manu&#39;a'),
(119, " . $new_language_id . ",'Isla de las Rosas'),
(120, " . $new_language_id . ",'Isla de los zagales'),
(121, " . $new_language_id . ",'Occidental'),
(122, " . $new_language_id . ",'Andorra la Vella'),
(123, " . $new_language_id . ",'Canillo'),
(124, " . $new_language_id . ",'Acamparse'),
(125, " . $new_language_id . ",'Escaldes-Engordany'),
(126, " . $new_language_id . ",'La Massana'),
(127, " . $new_language_id . ",'Ordino'),
(128, " . $new_language_id . ",'Sant Julia de Loria'),
(129, " . $new_language_id . ",'Bengo'),
(130, " . $new_language_id . ",'Benguela'),
(131, " . $new_language_id . ",'Bie'),
(132, " . $new_language_id . ",'Cabinda'),
(133, " . $new_language_id . ",'Cuando-Cubango'),
(134, " . $new_language_id . ",'Cuanza Norte'),
(135, " . $new_language_id . ",'Cuanza Sul'),
(136, " . $new_language_id . ",'Cunene'),
(137, " . $new_language_id . ",'Huambo'),
(138, " . $new_language_id . ",'Huila'),
(139, " . $new_language_id . ",'Luanda'),
(140, " . $new_language_id . ",'Lunda Norte'),
(141, " . $new_language_id . ",'Lunda Sul'),
(142, " . $new_language_id . ",'Malange'),
(143, " . $new_language_id . ",'Moxico'),
(144, " . $new_language_id . ",'Namibe'),
(145, " . $new_language_id . ",'Uige'),
(146, " . $new_language_id . ",'Zaire'),
(147, " . $new_language_id . ",'San Jorge'),
(148, " . $new_language_id . ",'San Juan'),
(149, " . $new_language_id . ",'Santa María'),
(150, " . $new_language_id . ",'San Pablo'),
(151, " . $new_language_id . ",'San Pedro'),
(152, " . $new_language_id . ",'San Felipe'),
(153, " . $new_language_id . ",'Barbuda'),
(154, " . $new_language_id . ",'Redonda'),
(155, " . $new_language_id . ",'Antartida e Islas del Atlantico'),
(156, " . $new_language_id . ",'Buenos Aires'),
(157, " . $new_language_id . ",'Catamarca'),
(158, " . $new_language_id . ",'Chaco'),
(159, " . $new_language_id . ",'Chubut'),
(160, " . $new_language_id . ",'Córdoba'),
(161, " . $new_language_id . ",'Corrientes'),
(162, " . $new_language_id . ",'Distrito Federal'),
(163, " . $new_language_id . ",'Entre Ríos'),
(164, " . $new_language_id . ",'Formosa'),
(165, " . $new_language_id . ",'Jujuy'),
(166, " . $new_language_id . ",'La Pampa'),
(167, " . $new_language_id . ",'La Rioja'),
(168, " . $new_language_id . ",'Mendoza'),
(169, " . $new_language_id . ",'Misiones'),
(170, " . $new_language_id . ",'Neuquen'),
(171, " . $new_language_id . ",'Río Negro'),
(172, " . $new_language_id . ",'Salta'),
(173, " . $new_language_id . ",'San Juan'),
(174, " . $new_language_id . ",'San Luis'),
(175, " . $new_language_id . ",'Santa Cruz'),
(176, " . $new_language_id . ",'Santa Fe'),
(177, " . $new_language_id . ",'Santiago del Estero'),
(178, " . $new_language_id . ",'Tierra del Fuego'),
(179, " . $new_language_id . ",'Tucuman'),
(180, " . $new_language_id . ",'Aragatsotn'),
(181, " . $new_language_id . ",'Ararat'),
(182, " . $new_language_id . ",'Armavir'),
(183, " . $new_language_id . ",'Geghark&#39;unik &#39;'),
(184, " . $new_language_id . ",'Kotayk &#39;'),
(185, " . $new_language_id . ",'Lorri'),
(186, " . $new_language_id . ",'Shirak'),
(187, " . $new_language_id . ",'Syunik &#39;'),
(188, " . $new_language_id . ",'Tavush'),
(189, " . $new_language_id . ",'Vayots &#39;Dzor'),
(190, " . $new_language_id . ",'Yerevan'),
(191, " . $new_language_id . ",'Territorio de la Capital Australiana'),
(192, " . $new_language_id . ",'Nueva Gales del Sur'),
(193, " . $new_language_id . ",'Territorio del Norte'),
(194, " . $new_language_id . ",'Queensland'),
(195, " . $new_language_id . ",'Australia del Sur'),
(196, " . $new_language_id . ",'Tasmania'),
(197, " . $new_language_id . ",'Victoria'),
(198, " . $new_language_id . ",'Australia Occidental'),
(199, " . $new_language_id . ",'Burgenland'),
(200, " . $new_language_id . ",'Kärnten'),
(201, " . $new_language_id . ",'Niederösterreich'),
(202, " . $new_language_id . ",'Oberösterreich'),
(203, " . $new_language_id . ",'Salzburgo'),
(204, " . $new_language_id . ",'Steiermark'),
(205, " . $new_language_id . ",'Tirol'),
(206, " . $new_language_id . ",'Vorarlberg'),
(207, " . $new_language_id . ",'Wien'),
(208, " . $new_language_id . ",'Ali Bayramli'),
(209, " . $new_language_id . ",'Abseron'),
(210, " . $new_language_id . ",'Agcabadi'),
(211, " . $new_language_id . ",'Agdam'),
(212, " . $new_language_id . ",'Agdas'),
(213, " . $new_language_id . ",'Agstafa'),
(214, " . $new_language_id . ",'Agsu'),
(215, " . $new_language_id . ",'Astara'),
(216, " . $new_language_id . ",'Baki'),
(217, " . $new_language_id . ",'Babak'),
(218, " . $new_language_id . ",'Balakan'),
(219, " . $new_language_id . ",'Barda'),
(220, " . $new_language_id . ",'Beylaqan'),
(221, " . $new_language_id . ",'Bilasuvar'),
(222, " . $new_language_id . ",'Cabrayil'),
(223, " . $new_language_id . ",'Calilabab'),
(224, " . $new_language_id . ",'Culfa'),
(225, " . $new_language_id . ",'Daskasan'),
(226, " . $new_language_id . ",'Davaci'),
(227, " . $new_language_id . ",'Fuzuli'),
(228, " . $new_language_id . ",'Ganca'),
(229, " . $new_language_id . ",'Gadabay'),
(230, " . $new_language_id . ",'Goranboy'),
(231, " . $new_language_id . ",'Goycay'),
(232, " . $new_language_id . ",'Haciqabul'),
(233, " . $new_language_id . ",'Imisli'),
(234, " . $new_language_id . ",'Ismayilli'),
(235, " . $new_language_id . ",'Kalbacar'),
(236, " . $new_language_id . ",'Kurdamir'),
(237, " . $new_language_id . ",'Lankaran'),
(238, " . $new_language_id . ",'Lacin'),
(239, " . $new_language_id . ",'Lankaran'),
(240, " . $new_language_id . ",'Lerik'),
(241, " . $new_language_id . ",'Masalli'),
(242, " . $new_language_id . ",'Mingacevir'),
(243, " . $new_language_id . ",'Naftalan'),
(244, " . $new_language_id . ",'Neftcala'),
(245, " . $new_language_id . ",'Oguz'),
(246, " . $new_language_id . ",'Ordubad'),
(247, " . $new_language_id . ",'Qabala'),
(248, " . $new_language_id . ",'Qax'),
(249, " . $new_language_id . ",'Qazax'),
(250, " . $new_language_id . ",'Qobustan'),
(251, " . $new_language_id . ",'Quba'),
(252, " . $new_language_id . ",'Qubadli'),
(253, " . $new_language_id . ",'Qusar'),
(254, " . $new_language_id . ",'Saki'),
(255, " . $new_language_id . ",'Saatli'),
(256, " . $new_language_id . ",'Sabirabad'),
(257, " . $new_language_id . ",'Sadarak'),
(258, " . $new_language_id . ",'Sahbuz'),
(259, " . $new_language_id . ",'Saki'),
(260, " . $new_language_id . ",'Salyan'),
(261, " . $new_language_id . ",'Sumqayit'),
(262, " . $new_language_id . ",'Samaxi'),
(263, " . $new_language_id . ",'Samkir'),
(264, " . $new_language_id . ",'Samux'),
(265, " . $new_language_id . ",'Sarur'),
(266, " . $new_language_id . ",'Siyazan'),
(267, " . $new_language_id . ",'Susa'),
(268, " . $new_language_id . ",'Susa'),
(269, " . $new_language_id . ",'Sarro'),
(270, " . $new_language_id . ",'Tovuz'),
(271, " . $new_language_id . ",'Ucar'),
(272, " . $new_language_id . ",'Xankandi'),
(273, " . $new_language_id . ",'Xacmaz'),
(274, " . $new_language_id . ",'Xanlar'),
(275, " . $new_language_id . ",'Xizi'),
(276, " . $new_language_id . ",'Xocalı'),
(277, " . $new_language_id . ",'Xocavand'),
(278, " . $new_language_id . ",'Yardimli'),
(279, " . $new_language_id . ",'Yevlax'),
(280, " . $new_language_id . ",'Zangilan'),
(281, " . $new_language_id . ",'Zaqatala'),
(282, " . $new_language_id . ",'Zardab'),
(283, " . $new_language_id . ",'Naxcivan'),
(284, " . $new_language_id . ",'Acklins'),
(285, " . $new_language_id . ",'Berry Islands'),
(286, " . $new_language_id . ",'Bimini'),
(287, " . $new_language_id . ",'Punto negro'),
(288, " . $new_language_id . ",'Cat Island'),
(289, " . $new_language_id . ",'Central Abaco'),
(290, " . $new_language_id . ",'Andros central'),
(291, " . $new_language_id . ",'Central Eleuthera'),
(292, " . $new_language_id . ",'Ciudad de Freeport'),
(293, " . $new_language_id . ",'Crooked Island'),
(294, " . $new_language_id . ",'East Grand Bahama'),
(295, " . $new_language_id . ",'Exuma'),
(296, " . $new_language_id . ",'Gran Cay'),
(297, " . $new_language_id . ",'Harbour Island'),
(298, " . $new_language_id . ",'Hope Town'),
(299, " . $new_language_id . ",'Inagua'),
(300, " . $new_language_id . ",'Long Island'),
(301, " . $new_language_id . ",'Mangrove Cay'),
(302, " . $new_language_id . ",'Mayaguana'),
(303, " . $new_language_id . ",'Isla de Moore'),
(304, " . $new_language_id . ",'Abaco Norte'),
(305, " . $new_language_id . ",'Norte Andros'),
(306, " . $new_language_id . ",'North Eleuthera'),
(307, " . $new_language_id . ",'La isla Ragged'),
(308, " . $new_language_id . ",'Rum Cay'),
(309, " . $new_language_id . ",'San Salvador'),
(310, " . $new_language_id . ",'Sur Abaco'),
(311, " . $new_language_id . ",'South Andros'),
(312, " . $new_language_id . ",'Sur Eleuthera'),
(313, " . $new_language_id . ",'Wells español'),
(314, " . $new_language_id . ",'West Grand Bahama'),
(315, " . $new_language_id . ",'Capital'),
(316, " . $new_language_id . ",'Central'),
(317, " . $new_language_id . ",'Muharraq'),
(318, " . $new_language_id . ",'Del norte'),
(319, " . $new_language_id . ",'Meridional'),
(320, " . $new_language_id . ",'Barisal'),
(321, " . $new_language_id . ",'Chittagong'),
(322, " . $new_language_id . ",'Dhaka'),
(323, " . $new_language_id . ",'Khulna'),
(324, " . $new_language_id . ",'Rajshahi'),
(325, " . $new_language_id . ",'Sylhet'),
(326, " . $new_language_id . ",'Christ Church'),
(327, " . $new_language_id . ",'San Andrés'),
(328, " . $new_language_id . ",'San Jorge'),
(329, " . $new_language_id . ",'Santiago'),
(330, " . $new_language_id . ",'San Juan'),
(331, " . $new_language_id . ",'Saint Joseph'),
(332, " . $new_language_id . ",'Santa Lucía'),
(333, " . $new_language_id . ",'San Miguel'),
(334, " . $new_language_id . ",'San Pedro'),
(335, " . $new_language_id . ",'San Felipe'),
(336, " . $new_language_id . ",'Santo Tomás'),
(337, " . $new_language_id . ",'Brestskaya (Brest)'),
(338, " . $new_language_id . ",'Homyel&#39;skaya (Homyel &#39;)'),
(339, " . $new_language_id . ",'Horad Minsk'),
(340, " . $new_language_id . ",'Hrodzyenskaya (Grodno)'),
(341, " . $new_language_id . ",'Mahilyowskaya (Mahilyow)'),
(342, " . $new_language_id . ",'Minskaya'),
(343, " . $new_language_id . ",'Vitsyebskaya (Vitsyebsk)'),
(344, " . $new_language_id . ",'Antwerpen'),
(345, " . $new_language_id . ",'Brabant Wallon'),
(346, " . $new_language_id . ",'Hainaut'),
(347, " . $new_language_id . ",'Feudal'),
(348, " . $new_language_id . ",'Limburg'),
(349, " . $new_language_id . ",'Luxemburgo'),
(350, " . $new_language_id . ",'Namur'),
(351, " . $new_language_id . ",'Oost-Vlaanderen'),
(352, " . $new_language_id . ",'Vlaams Brabant'),
(353, " . $new_language_id . ",'West-Vlaanderen'),
(354, " . $new_language_id . ",'Belice'),
(355, " . $new_language_id . ",'Cayo'),
(356, " . $new_language_id . ",'Corozal'),
(357, " . $new_language_id . ",'Orange Walk'),
(358, " . $new_language_id . ",'Stann Creek'),
(359, " . $new_language_id . ",'Toledo'),
(360, " . $new_language_id . ",'Alibori'),
(361, " . $new_language_id . ",'Atakora'),
(362, " . $new_language_id . ",'Atlantique'),
(363, " . $new_language_id . ",'Borgou'),
(364, " . $new_language_id . ",'Collines'),
(365, " . $new_language_id . ",'Donga'),
(366, " . $new_language_id . ",'Kouffo'),
(367, " . $new_language_id . ",'Litoral'),
(368, " . $new_language_id . ",'Mono'),
(369, " . $new_language_id . ",'Oueme'),
(370, " . $new_language_id . ",'Meseta'),
(371, " . $new_language_id . ",'Zou'),
(372, " . $new_language_id . ",'Devonshire'),
(373, " . $new_language_id . ",'Hamilton City'),
(374, " . $new_language_id . ",'Hamilton'),
(375, " . $new_language_id . ",'Paget'),
(376, " . $new_language_id . ",'Pembroke'),
(377, " . $new_language_id . ",'San Jorge Ciudad'),
(378, " . $new_language_id . ",'San Jorge'),
(379, " . $new_language_id . ",'Sandys'),
(380, " . $new_language_id . ",'De Smith'),
(381, " . $new_language_id . ",'Southampton'),
(382, " . $new_language_id . ",'Warwick'),
(383, " . $new_language_id . ",'Bumthang'),
(384, " . $new_language_id . ",'Chukha'),
(385, " . $new_language_id . ",'Dagana'),
(386, " . $new_language_id . ",'Gasa'),
(387, " . $new_language_id . ",'Haa'),
(388, " . $new_language_id . ",'Lhuntse'),
(389, " . $new_language_id . ",'Mongar'),
(390, " . $new_language_id . ",'Paro'),
(391, " . $new_language_id . ",'Pemagatshel'),
(392, " . $new_language_id . ",'Punakha'),
(393, " . $new_language_id . ",'Samdrup Jongkhar'),
(394, " . $new_language_id . ",'Samtse'),
(395, " . $new_language_id . ",'Sarpang'),
(396, " . $new_language_id . ",'Thimphu'),
(397, " . $new_language_id . ",'Trashigang'),
(398, " . $new_language_id . ",'Trashiyangste'),
(399, " . $new_language_id . ",'Trongsa'),
(400, " . $new_language_id . ",'Tsirang'),
(401, " . $new_language_id . ",'Wangdue Phodrang'),
(402, " . $new_language_id . ",'Zhemgang'),
(403, " . $new_language_id . ",'Beni'),
(404, " . $new_language_id . ",'Chuquisaca'),
(405, " . $new_language_id . ",'Cochabamba'),
(406, " . $new_language_id . ",'La Paz'),
(407, " . $new_language_id . ",'Oruro'),
(408, " . $new_language_id . ",'Pando'),
(409, " . $new_language_id . ",'Potosí'),
(410, " . $new_language_id . ",'Santa Cruz'),
(411, " . $new_language_id . ",'Tarija'),
(412, " . $new_language_id . ",'Distrito de Brcko'),
(413, " . $new_language_id . ",'Unsko-Sanski Kanton'),
(414, " . $new_language_id . ",'Posavski Kanton'),
(415, " . $new_language_id . ",'Tuzlanski Kanton'),
(416, " . $new_language_id . ",'Zeničko-dobojski Kanton'),
(417, " . $new_language_id . ",'Bosanskopodrinjski Kanton'),
(418, " . $new_language_id . ",'Srednjebosanski Kanton'),
(419, " . $new_language_id . ",'Hercegovacko-neretvanski Kanton'),
(420, " . $new_language_id . ",'Zapadnohercegovacka Zupanija'),
(421, " . $new_language_id . ",'Kanton Sarajevo'),
(422, " . $new_language_id . ",'Zapadnobosanska'),
(423, " . $new_language_id . ",'Banja Luka'),
(424, " . $new_language_id . ",'Doboj'),
(425, " . $new_language_id . ",'Bijeljina'),
(426, " . $new_language_id . ",'Vlasenica'),
(427, " . $new_language_id . ",'Sarajevo-Romanija o Sokolac'),
(428, " . $new_language_id . ",'Foca'),
(429, " . $new_language_id . ",'Trebinje'),
(430, " . $new_language_id . ",'Central'),
(431, " . $new_language_id . ",'Ghanzi'),
(432, " . $new_language_id . ",'Kgalagadi'),
(433, " . $new_language_id . ",'Kgatleng'),
(434, " . $new_language_id . ",'Kweneng'),
(435, " . $new_language_id . ",'Ngamiland'),
(436, " . $new_language_id . ",'Noreste'),
(437, " . $new_language_id . ",'Noroeste'),
(438, " . $new_language_id . ",'Sur Oriental'),
(439, " . $new_language_id . ",'Meridional'),
(440, " . $new_language_id . ",'Acre'),
(441, " . $new_language_id . ",'Alagoas'),
(442, " . $new_language_id . ",'Amapa'),
(443, " . $new_language_id . ",'Amazonas'),
(444, " . $new_language_id . ",'Bahia'),
(445, " . $new_language_id . ",'Ceará'),
(446, " . $new_language_id . ",'Distrito Federal'),
(447, " . $new_language_id . ",'Espirito Santo'),
(448, " . $new_language_id . ",'Goias'),
(449, " . $new_language_id . ",'Maranhao'),
(450, " . $new_language_id . ",'Mato Grosso'),
(451, " . $new_language_id . ",'Mato Grosso do Sul'),
(452, " . $new_language_id . ",'Minas Gerais'),
(453, " . $new_language_id . ",'Para'),
(454, " . $new_language_id . ",'Paraiba'),
(455, " . $new_language_id . ",'Parana'),
(456, " . $new_language_id . ",'Pernambuco'),
(457, " . $new_language_id . ",'Piaui'),
(458, " . $new_language_id . ",'Río de Janeiro'),
(459, " . $new_language_id . ",'Rio Grande do Norte'),
(460, " . $new_language_id . ",'Rio Grande do Sul'),
(461, " . $new_language_id . ",'Rondonia'),
(462, " . $new_language_id . ",'Roraima'),
(463, " . $new_language_id . ",'Santa Catarina'),
(464, " . $new_language_id . ",'Sao Paulo'),
(465, " . $new_language_id . ",'Sergipe'),
(466, " . $new_language_id . ",'Tocantins'),
(467, " . $new_language_id . ",'Peros Banhos'),
(468, " . $new_language_id . ",'Islas Salomon'),
(469, " . $new_language_id . ",'Nelsons Island'),
(470, " . $new_language_id . ",'Tres Hermanos'),
(471, " . $new_language_id . ",'Islas del águila'),
(472, " . $new_language_id . ",'Danger Island'),
(473, " . $new_language_id . ",'Islas Egmont'),
(474, " . $new_language_id . ",'Diego García'),
(475, " . $new_language_id . ",'Belait'),
(476, " . $new_language_id . ",'Brunei y Muara'),
(477, " . $new_language_id . ",'Temburong'),
(478, " . $new_language_id . ",'Tutong'),
(479, " . $new_language_id . ",'Blagoevgrad'),
(480, " . $new_language_id . ",'Burgas'),
(481, " . $new_language_id . ",'Dobrich'),
(482, " . $new_language_id . ",'Gabrovo'),
(483, " . $new_language_id . ",'Haskovo'),
(484, " . $new_language_id . ",'Kardjali'),
(485, " . $new_language_id . ",'Kyustendil'),
(486, " . $new_language_id . ",'Lovech'),
(487, " . $new_language_id . ",'Montana'),
(488, " . $new_language_id . ",'Pazardjik'),
(489, " . $new_language_id . ",'Pernik'),
(490, " . $new_language_id . ",'Pleven'),
(491, " . $new_language_id . ",'Plovdiv'),
(492, " . $new_language_id . ",'Razgrad'),
(493, " . $new_language_id . ",'Shumen'),
(494, " . $new_language_id . ",'Silistra'),
(495, " . $new_language_id . ",'Sliven'),
(496, " . $new_language_id . ",'Smolyan'),
(497, " . $new_language_id . ",'Sofía'),
(498, " . $new_language_id . ",'Sofía - ciudad'),
(499, " . $new_language_id . ",'Stara Zagora'),
(500, " . $new_language_id . ",'Targovishte'),
(501, " . $new_language_id . ",'Varna'),
(502, " . $new_language_id . ",'Veliko Tarnovo'),
(503, " . $new_language_id . ",'Vidin'),
(504, " . $new_language_id . ",'Vratza'),
(505, " . $new_language_id . ",'Yambol'),
(506, " . $new_language_id . ",'Paca'),
(507, " . $new_language_id . ",'Bam'),
(508, " . $new_language_id . ",'Banwa'),
(509, " . $new_language_id . ",'Bazega'),
(510, " . $new_language_id . ",'Bougouriba'),
(511, " . $new_language_id . ",'Boulgou'),
(512, " . $new_language_id . ",'Boulkiemdé'),
(513, " . $new_language_id . ",'Comoe'),
(514, " . $new_language_id . ",'Ganzourgou'),
(515, " . $new_language_id . ",'Gnagna'),
(516, " . $new_language_id . ",'Gourma'),
(517, " . $new_language_id . ",'Houet'),
(518, " . $new_language_id . ",'Ioba'),
(519, " . $new_language_id . ",'Kadiogo'),
(520, " . $new_language_id . ",'Kénédougou'),
(521, " . $new_language_id . ",'Komondjari'),
(522, " . $new_language_id . ",'Kompienga'),
(523, " . $new_language_id . ",'Kossi'),
(524, " . $new_language_id . ",'Koulpélogo'),
(525, " . $new_language_id . ",'Kouritenga'),
(526, " . $new_language_id . ",'Kourwéogo'),
(527, " . $new_language_id . ",'Leraba'),
(528, " . $new_language_id . ",'Loroum'),
(529, " . $new_language_id . ",'Mouhoun'),
(530, " . $new_language_id . ",'Nahouri'),
(531, " . $new_language_id . ",'Namentenga'),
(532, " . $new_language_id . ",'Nayala'),
(533, " . $new_language_id . ",'Noumbiel'),
(534, " . $new_language_id . ",'Oubritenga'),
(535, " . $new_language_id . ",'Oudalan'),
(536, " . $new_language_id . ",'Pasore'),
(537, " . $new_language_id . ",'Poni'),
(538, " . $new_language_id . ",'Sanguie'),
(539, " . $new_language_id . ",'Sanmatenga'),
(540, " . $new_language_id . ",'Seno'),
(541, " . $new_language_id . ",'Sissili'),
(542, " . $new_language_id . ",'Soum'),
(543, " . $new_language_id . ",'Sourou'),
(544, " . $new_language_id . ",'Tapoa'),
(545, " . $new_language_id . ",'Tuy'),
(546, " . $new_language_id . ",'Yagha'),
(547, " . $new_language_id . ",'Yatenga'),
(548, " . $new_language_id . ",'Ziro'),
(549, " . $new_language_id . ",'Zondoma'),
(550, " . $new_language_id . ",'Zoundweogo'),
(551, " . $new_language_id . ",'Bubanza'),
(552, " . $new_language_id . ",'Bujumbura'),
(553, " . $new_language_id . ",'Bururi'),
(554, " . $new_language_id . ",'Cankuzo'),
(555, " . $new_language_id . ",'Cibitoke'),
(556, " . $new_language_id . ",'Gitega'),
(557, " . $new_language_id . ",'Karuzi'),
(558, " . $new_language_id . ",'Kayanza'),
(559, " . $new_language_id . ",'Kirundo'),
(560, " . $new_language_id . ",'Makamba'),
(561, " . $new_language_id . ",'Muramvya'),
(562, " . $new_language_id . ",'Muyinga'),
(563, " . $new_language_id . ",'Mwaro'),
(564, " . $new_language_id . ",'Ngozi'),
(565, " . $new_language_id . ",'Rutana'),
(566, " . $new_language_id . ",'Ruyigi'),
(567, " . $new_language_id . ",'Phnom Penh'),
(568, " . $new_language_id . ",'Preah Seihanu (Kompong Som o Sihanoukville)'),
(569, " . $new_language_id . ",'Pailin'),
(570, " . $new_language_id . ",'Keb'),
(571, " . $new_language_id . ",'Banteay Meanchey'),
(572, " . $new_language_id . ",'Battambang'),
(573, " . $new_language_id . ",'Kampong Cham'),
(574, " . $new_language_id . ",'Kampong Chhnang'),
(575, " . $new_language_id . ",'Kampong Speu'),
(576, " . $new_language_id . ",'Kampong Som'),
(577, " . $new_language_id . ",'Kampong Thom'),
(578, " . $new_language_id . ",'Kampot'),
(579, " . $new_language_id . ",'Kandal'),
(580, " . $new_language_id . ",'Kaoh Kong'),
(581, " . $new_language_id . ",'Kratie'),
(582, " . $new_language_id . ",'Mondul Kiri'),
(583, " . $new_language_id . ",'Oddar Meancheay'),
(584, " . $new_language_id . ",'Pursat'),
(585, " . $new_language_id . ",'Preah Vihear'),
(586, " . $new_language_id . ",'Prey Veng'),
(587, " . $new_language_id . ",'Ratanak Kiri'),
(588, " . $new_language_id . ",'Siemreap'),
(589, " . $new_language_id . ",'Stung Treng'),
(590, " . $new_language_id . ",'Svay Rieng'),
(591, " . $new_language_id . ",'Takeo'),
(592, " . $new_language_id . ",'Adamawa (Adamaoua)'),
(593, " . $new_language_id . ",'Centro'),
(594, " . $new_language_id . ",'Este (Est)'),
(595, " . $new_language_id . ",'Extreme Norte (Extreme-Nord)'),
(596, " . $new_language_id . ",'Litoral'),
(597, " . $new_language_id . ",'Norte (Nord)'),
(598, " . $new_language_id . ",'Noroeste (Nord-Ouest)'),
(599, " . $new_language_id . ",'West (Ouest)'),
(600, " . $new_language_id . ",'Sur (Sud)'),
(601, " . $new_language_id . ",'Southwest (Sud-Ouest).'),
(602, " . $new_language_id . ",'Alberta'),
(603, " . $new_language_id . ",'Colombia Británica'),
(604, " . $new_language_id . ",'Manitoba'),
(605, " . $new_language_id . ",'Nuevo Brunswick'),
(606, " . $new_language_id . ",'Terranova y Labrador'),
(607, " . $new_language_id . ",'Territorios del Noroeste'),
(608, " . $new_language_id . ",'Nueva Escocia'),
(609, " . $new_language_id . ",'Nunavut'),
(610, " . $new_language_id . ",'Ontario'),
(611, " . $new_language_id . ",'Isla del Príncipe Eduardo'),
(612, " . $new_language_id . ",'Québec'),
(613, " . $new_language_id . ",'Saskatchewan'),
(614, " . $new_language_id . ",'Territorio del Yukón'),
(615, " . $new_language_id . ",'Boa Vista'),
(616, " . $new_language_id . ",'Brava'),
(617, " . $new_language_id . ",'Calheta de Sao Miguel'),
(618, " . $new_language_id . ",'Maio'),
(619, " . $new_language_id . ",'Mosteiros'),
(620, " . $new_language_id . ",'Paul'),
(621, " . $new_language_id . ",'Porto Novo'),
(622, " . $new_language_id . ",'Praia'),
(623, " . $new_language_id . ",'Ribeira Grande'),
(624, " . $new_language_id . ",'Sal'),
(625, " . $new_language_id . ",'Santa Catarina'),
(626, " . $new_language_id . ",'Santa Cruz'),
(627, " . $new_language_id . ",'Sao Domingos'),
(628, " . $new_language_id . ",'Sao Filipe'),
(629, " . $new_language_id . ",'Sao Nicolau'),
(630, " . $new_language_id . ",'Sao Vicente'),
(631, " . $new_language_id . ",'Tarrafal'),
(632, " . $new_language_id . ",'Arroyo'),
(633, " . $new_language_id . ",'Oriental'),
(634, " . $new_language_id . ",'Midland'),
(635, " . $new_language_id . ",'South Town'),
(636, " . $new_language_id . ",'Spot Bay'),
(637, " . $new_language_id . ",'Stake Bay'),
(638, " . $new_language_id . ",'West End'),
(639, " . $new_language_id . ",'Occidental'),
(640, " . $new_language_id . ",'Bamingui-Bangoran'),
(641, " . $new_language_id . ",'Basse-Kotto'),
(642, " . $new_language_id . ",'Haute-Kotto'),
(643, " . $new_language_id . ",'Haut-Mbomou'),
(644, " . $new_language_id . ",'Kemo'),
(645, " . $new_language_id . ",'Lobaye'),
(646, " . $new_language_id . ",'Mambéré-KadeÔ'),
(647, " . $new_language_id . ",'Mbomou'),
(648, " . $new_language_id . ",'Nana-Mambéré'),
(649, " . $new_language_id . ",'Ombella-M&#39;Poko'),
(650, " . $new_language_id . ",'Ouaka'),
(651, " . $new_language_id . ",'Ouham'),
(652, " . $new_language_id . ",'Ouham-Pende'),
(653, " . $new_language_id . ",'Vakaga'),
(654, " . $new_language_id . ",'Nana-Grebizi'),
(655, " . $new_language_id . ",'Sangha-Mbaéré'),
(656, " . $new_language_id . ",'Bangui'),
(657, " . $new_language_id . ",'Batha'),
(658, " . $new_language_id . ",'Biltine'),
(659, " . $new_language_id . ",'Borkou-Ennedi-Tibesti'),
(660, " . $new_language_id . ",'Chari-Baguirmi'),
(661, " . $new_language_id . ",'Guera'),
(662, " . $new_language_id . ",'Kanem'),
(663, " . $new_language_id . ",'Laca'),
(664, " . $new_language_id . ",'Logone Occidental'),
(665, " . $new_language_id . ",'Logone Oriental'),
(666, " . $new_language_id . ",'Mayo-Kebbi'),
(667, " . $new_language_id . ",'Moyen-Chari'),
(668, " . $new_language_id . ",'Ouaddai'),
(669, " . $new_language_id . ",'Salamat'),
(670, " . $new_language_id . ",'Tandjile'),
(671, " . $new_language_id . ",'Aisén del General Carlos Ibáñez'),
(672, " . $new_language_id . ",'Antofagasta'),
(673, " . $new_language_id . ",'Araucanía'),
(674, " . $new_language_id . ",'Atacama'),
(675, " . $new_language_id . ",'Bio-Bio'),
(676, " . $new_language_id . ",'Coquimbo'),
(677, " . $new_language_id . ",'Libertador General Bernardo O&#39;Hi'),
(678, " . $new_language_id . ",'Los Lagos'),
(679, " . $new_language_id . ",'Magallanes y de la Antártica Chi'),
(680, " . $new_language_id . ",'Maule'),
(681, " . $new_language_id . ",'Región Metropolitana'),
(682, " . $new_language_id . ",'Tarapaca'),
(683, " . $new_language_id . ",'Valparaíso'),
(684, " . $new_language_id . ",'Anhui'),
(685, " . $new_language_id . ",'Beijing'),
(686, " . $new_language_id . ",'Chongqing'),
(687, " . $new_language_id . ",'Fujian'),
(688, " . $new_language_id . ",'Gansu'),
(689, " . $new_language_id . ",'Guangdong'),
(690, " . $new_language_id . ",'Guangxi'),
(691, " . $new_language_id . ",'Guizhou'),
(692, " . $new_language_id . ",'Hainan'),
(693, " . $new_language_id . ",'Hebei'),
(694, " . $new_language_id . ",'Heilongjiang'),
(695, " . $new_language_id . ",'Henan'),
(696, " . $new_language_id . ",'Hong Kong'),
(697, " . $new_language_id . ",'Hubei'),
(698, " . $new_language_id . ",'Hunan'),
(699, " . $new_language_id . ",'Mongolia Interior'),
(700, " . $new_language_id . ",'Jiangsu'),
(701, " . $new_language_id . ",'Jiangxi'),
(702, " . $new_language_id . ",'Jilin'),
(703, " . $new_language_id . ",'Liaoning'),
(704, " . $new_language_id . ",'Macau'),
(705, " . $new_language_id . ",'Ningxia'),
(706, " . $new_language_id . ",'Shaanxi'),
(707, " . $new_language_id . ",'Shandong'),
(708, " . $new_language_id . ",'Shanghai'),
(709, " . $new_language_id . ",'Shanxi'),
(710, " . $new_language_id . ",'Sichuan'),
(711, " . $new_language_id . ",'Tianjin'),
(712, " . $new_language_id . ",'Xinjiang'),
(713, " . $new_language_id . ",'Yunnan'),
(714, " . $new_language_id . ",'Zhejiang'),
(715, " . $new_language_id . ",'Island Dirección'),
(716, " . $new_language_id . ",'Home Island'),
(717, " . $new_language_id . ",'Horsburgh Island'),
(718, " . $new_language_id . ",'Isla del Sur'),
(719, " . $new_language_id . ",'West Island'),
(720, " . $new_language_id . ",'Amazonas'),
(721, " . $new_language_id . ",'Antioquia'),
(722, " . $new_language_id . ",'Arauca'),
(723, " . $new_language_id . ",'Atlantico'),
(724, " . $new_language_id . ",'Bogotá DC'),
(725, " . $new_language_id . ",'Bolívar'),
(726, " . $new_language_id . ",'Boyacá'),
(727, " . $new_language_id . ",'Caldas'),
(728, " . $new_language_id . ",'Caquetá'),
(729, " . $new_language_id . ",'Casanare'),
(730, " . $new_language_id . ",'Cauca'),
(731, " . $new_language_id . ",'Cesar'),
(732, " . $new_language_id . ",'Choco'),
(733, " . $new_language_id . ",'Córdoba'),
(734, " . $new_language_id . ",'Cundinamarca'),
(735, " . $new_language_id . ",'Guainía'),
(736, " . $new_language_id . ",'Guajira'),
(737, " . $new_language_id . ",'Guaviare'),
(738, " . $new_language_id . ",'Huila'),
(739, " . $new_language_id . ",'Magdalena'),
(740, " . $new_language_id . ",'Meta'),
(741, " . $new_language_id . ",'Nariño'),
(742, " . $new_language_id . ",'Norte de Santander'),
(743, " . $new_language_id . ",'Putumayo'),
(744, " . $new_language_id . ",'Quindio'),
(745, " . $new_language_id . ",'Risaralda'),
(746, " . $new_language_id . ",'San Andres y Providencia'),
(747, " . $new_language_id . ",'Santander'),
(748, " . $new_language_id . ",'Sucre'),
(749, " . $new_language_id . ",'Tolima'),
(750, " . $new_language_id . ",'Valle del Cauca'),
(751, " . $new_language_id . ",'Vaupés'),
(752, " . $new_language_id . ",'Vichada'),
(753, " . $new_language_id . ",'Grande Comore'),
(754, " . $new_language_id . ",'Anjouan'),
(755, " . $new_language_id . ",'Moheli'),
(756, " . $new_language_id . ",'Bouenza'),
(757, " . $new_language_id . ",'Brazzaville'),
(758, " . $new_language_id . ",'Cubeta'),
(759, " . $new_language_id . ",'Cubeta-Ouest'),
(760, " . $new_language_id . ",'Kouilou'),
(761, " . $new_language_id . ",'Lekoumou'),
(762, " . $new_language_id . ",'Likouala'),
(763, " . $new_language_id . ",'Niari'),
(764, " . $new_language_id . ",'Mesetas'),
(765, " . $new_language_id . ",'Piscina'),
(766, " . $new_language_id . ",'Sangha'),
(767, " . $new_language_id . ",'Pukapuka'),
(768, " . $new_language_id . ",'Rakahanga'),
(769, " . $new_language_id . ",'Manihiki'),
(770, " . $new_language_id . ",'Penrhyn'),
(771, " . $new_language_id . ",'Nassau Isla'),
(772, " . $new_language_id . ",'Surwarrow'),
(773, " . $new_language_id . ",'Palmerston'),
(774, " . $new_language_id . ",'Aitutaki'),
(775, " . $new_language_id . ",'Manuae'),
(776, " . $new_language_id . ",'Takutea'),
(777, " . $new_language_id . ",'Mitiaro'),
(778, " . $new_language_id . ",'Atiu'),
(779, " . $new_language_id . ",'Mauke'),
(780, " . $new_language_id . ",'Rarotonga'),
(781, " . $new_language_id . ",'Mangaia'),
(782, " . $new_language_id . ",'Alajuela'),
(783, " . $new_language_id . ",'Cartago'),
(784, " . $new_language_id . ",'Guanacaste'),
(785, " . $new_language_id . ",'Heredia'),
(786, " . $new_language_id . ",'Limón'),
(787, " . $new_language_id . ",'Puntarenas'),
(788, " . $new_language_id . ",'San José'),
(789, " . $new_language_id . ",'Abengourou'),
(790, " . $new_language_id . ",'Abidjan'),
(791, " . $new_language_id . ",'Aboisso'),
(792, " . $new_language_id . ",'Adiake'),
(793, " . $new_language_id . ",'Adzope'),
(794, " . $new_language_id . ",'Agboville'),
(795, " . $new_language_id . ",'Agnibilekrou'),
(796, " . $new_language_id . ",'Alepe'),
(797, " . $new_language_id . ",'Bocanda'),
(798, " . $new_language_id . ",'Bangolo'),
(799, " . $new_language_id . ",'Béoumi'),
(800, " . $new_language_id . ",'Biankouma'),
(801, " . $new_language_id . ",'Bondoukou'),
(802, " . $new_language_id . ",'Bongouanou'),
(803, " . $new_language_id . ",'Bouafle'),
(804, " . $new_language_id . ",'Bouaké'),
(805, " . $new_language_id . ",'Bouna'),
(806, " . $new_language_id . ",'Boundiali'),
(807, " . $new_language_id . ",'Dabakala'),
(808, " . $new_language_id . ",'Dabou'),
(809, " . $new_language_id . ",'Daloa'),
(810, " . $new_language_id . ",'Danane'),
(811, " . $new_language_id . ",'Daoukro'),
(812, " . $new_language_id . ",'Dimbokro'),
(813, " . $new_language_id . ",'Divo'),
(814, " . $new_language_id . ",'Duékoué'),
(815, " . $new_language_id . ",'Ferkessédougou'),
(816, " . $new_language_id . ",'Gagnoa'),
(817, " . $new_language_id . ",'Grand-Bassam'),
(818, " . $new_language_id . ",'Grand-Lahou'),
(819, " . $new_language_id . ",'Guiglo'),
(820, " . $new_language_id . ",'Issia'),
(821, " . $new_language_id . ",'Jacqueville'),
(822, " . $new_language_id . ",'Katiola'),
(823, " . $new_language_id . ",'Korhogo'),
(824, " . $new_language_id . ",'Lakota'),
(825, " . $new_language_id . ",'Hombre'),
(826, " . $new_language_id . ",'Mankono'),
(827, " . $new_language_id . ",'Mbahiakro'),
(828, " . $new_language_id . ",'Odienne'),
(829, " . $new_language_id . ",'Oume'),
(830, " . $new_language_id . ",'Sakassou'),
(831, " . $new_language_id . ",'San-Pedro'),
(832, " . $new_language_id . ",'Sassandra'),
(833, " . $new_language_id . ",'Seguela'),
(834, " . $new_language_id . ",'Sinfra'),
(835, " . $new_language_id . ",'Soubre'),
(836, " . $new_language_id . ",'Tabou'),
(837, " . $new_language_id . ",'Tanda'),
(838, " . $new_language_id . ",'Tiébissou'),
(839, " . $new_language_id . ",'Tingrela'),
(840, " . $new_language_id . ",'Tiassalé'),
(841, " . $new_language_id . ",'Touba'),
(842, " . $new_language_id . ",'Tulepleu'),
(843, " . $new_language_id . ",'Toumodi'),
(844, " . $new_language_id . ",'Vavoua'),
(845, " . $new_language_id . ",'Yamoussoukro'),
(846, " . $new_language_id . ",'Zuenoula'),
(847, " . $new_language_id . ",'Bjelovar-Bilogora'),
(848, " . $new_language_id . ",'Ciudad de Zagreb'),
(849, " . $new_language_id . ",'Dubrovnik-Neretva'),
(850, " . $new_language_id . ",'Istra'),
(851, " . $new_language_id . ",'Karlovac'),
(852, " . $new_language_id . ",'Koprivnica-Krizevci'),
(853, " . $new_language_id . ",'Krapina-Zagorje'),
(854, " . $new_language_id . ",'Lika-Senj'),
(855, " . $new_language_id . ",'Medimurje'),
(856, " . $new_language_id . ",'Osijek-Baranja'),
(857, " . $new_language_id . ",'Pozega-Slavonia'),
(858, " . $new_language_id . ",'Primorje-Gorski Kotar'),
(859, " . $new_language_id . ",'Sibenik'),
(860, " . $new_language_id . ",'Sisak-Moslavina'),
(861, " . $new_language_id . ",'Slavonski Brod-Posavina'),
(862, " . $new_language_id . ",'Split-Dalmacia'),
(863, " . $new_language_id . ",'Varazdin'),
(864, " . $new_language_id . ",'Virovitica-Podravina'),
(865, " . $new_language_id . ",'Vukovar-Srijem'),
(866, " . $new_language_id . ",'Zadar-Knin'),
(867, " . $new_language_id . ",'Zagreb'),
(868, " . $new_language_id . ",'Camaguey'),
(869, " . $new_language_id . ",'Ciego de Avila'),
(870, " . $new_language_id . ",'Cienfuegos'),
(871, " . $new_language_id . ",'Ciudad de La Habana'),
(872, " . $new_language_id . ",'Granma'),
(873, " . $new_language_id . ",'Guantánamo'),
(874, " . $new_language_id . ",'Holguin'),
(875, " . $new_language_id . ",'Isla de la Juventud'),
(876, " . $new_language_id . ",'La Habana'),
(877, " . $new_language_id . ",'Las Tunas'),
(878, " . $new_language_id . ",'Matanzas'),
(879, " . $new_language_id . ",'Pinar del Rio'),
(880, " . $new_language_id . ",'Sancti Spiritus'),
(881, " . $new_language_id . ",'Santiago de Cuba'),
(882, " . $new_language_id . ",'Villa Clara'),
(883, " . $new_language_id . ",'Famagusta'),
(884, " . $new_language_id . ",'Kyrenia'),
(885, " . $new_language_id . ",'Larnaca'),
(886, " . $new_language_id . ",'Limassol'),
(887, " . $new_language_id . ",'Nicosia'),
(888, " . $new_language_id . ",'Paphos'),
(889, " . $new_language_id . ",'Ustecký'),
(890, " . $new_language_id . ",'Jihocesky'),
(891, " . $new_language_id . ",'Jihomoravsky'),
(892, " . $new_language_id . ",'Karlovarský'),
(893, " . $new_language_id . ",'Kralovéhradecký'),
(894, " . $new_language_id . ",'Liberecký'),
(895, " . $new_language_id . ",'Moravskoslezský'),
(896, " . $new_language_id . ",'Olomoucký'),
(897, " . $new_language_id . ",'Pardubický'),
(898, " . $new_language_id . ",'Plzenský'),
(899, " . $new_language_id . ",'Praha'),
(900, " . $new_language_id . ",'Stredocesky'),
(901, " . $new_language_id . ",'Vysocina'),
(902, " . $new_language_id . ",'Zlínský'),
(903, " . $new_language_id . ",'Arhus'),
(904, " . $new_language_id . ",'Bornholm'),
(905, " . $new_language_id . ",'Copenhague'),
(906, " . $new_language_id . ",'Islas Feroe'),
(907, " . $new_language_id . ",'Frederiksborg'),
(908, " . $new_language_id . ",'Fyn'),
(909, " . $new_language_id . ",'Kobenhavn'),
(910, " . $new_language_id . ",'Nordjylland'),
(911, " . $new_language_id . ",'Ribe'),
(912, " . $new_language_id . ",'Ringkobing'),
(913, " . $new_language_id . ",'Roskilde'),
(914, " . $new_language_id . ",'Sonderjylland'),
(915, " . $new_language_id . ",'Storstrom'),
(916, " . $new_language_id . ",'Vejle'),
(917, " . $new_language_id . ",'Vestjælland'),
(918, " . $new_language_id . ",'Viborg'),
(919, " . $new_language_id . ",'&#39;Ali Sabih'),
(920, " . $new_language_id . ",'Dikhil'),
(921, " . $new_language_id . ",'Djibouti'),
(922, " . $new_language_id . ",'Obock'),
(923, " . $new_language_id . ",'Tadjoura'),
(924, " . $new_language_id . ",'San Andrés Parroquia'),
(925, " . $new_language_id . ",'Saint David Parish'),
(926, " . $new_language_id . ",'Parroquia de Saint George'),
(927, " . $new_language_id . ",'Parroquia de Saint John'),
(928, " . $new_language_id . ",'Parroquia de San José'),
(929, " . $new_language_id . ",'Parroquia de San Lucas'),
(930, " . $new_language_id . ",'Parroquia de San Marcos'),
(931, " . $new_language_id . ",'Parroquia de San Patricio'),
(932, " . $new_language_id . ",'Parroquia de Saint Paul'),
(933, " . $new_language_id . ",'San Pedro Parroquia'),
(934, " . $new_language_id . ",'Distrito Nacional'),
(935, " . $new_language_id . ",'Azua'),
(936, " . $new_language_id . ",'Baoruco'),
(937, " . $new_language_id . ",'Barahona'),
(938, " . $new_language_id . ",'Dajabon'),
(939, " . $new_language_id . ",'Duarte'),
(940, " . $new_language_id . ",'Elias Pina'),
(941, " . $new_language_id . ",'El Seybo'),
(942, " . $new_language_id . ",'Espaillat'),
(943, " . $new_language_id . ",'Hato Mayor'),
(944, " . $new_language_id . ",'Independencia'),
(945, " . $new_language_id . ",'La Altagracia'),
(946, " . $new_language_id . ",'La Romana'),
(947, " . $new_language_id . ",'La Vega'),
(948, " . $new_language_id . ",'Maria Trinidad Sanchez'),
(949, " . $new_language_id . ",'Monseñor Nouel'),
(950, " . $new_language_id . ",'Monte Cristi'),
(951, " . $new_language_id . ",'Monte Plata'),
(952, " . $new_language_id . ",'Pedernales'),
(953, " . $new_language_id . ",'Peravia (Baní)'),
(954, " . $new_language_id . ",'Puerto Plata'),
(955, " . $new_language_id . ",'Salcedo'),
(956, " . $new_language_id . ",'Samana'),
(957, " . $new_language_id . ",'Sánchez Ramírez'),
(958, " . $new_language_id . ",'San Cristobal'),
(959, " . $new_language_id . ",'San José de Ocoa'),
(960, " . $new_language_id . ",'San Juan'),
(961, " . $new_language_id . ",'San Pedro de Macoris'),
(962, " . $new_language_id . ",'Santiago'),
(963, " . $new_language_id . ",'Santiago Rodriguez'),
(964, " . $new_language_id . ",'Santo Domingo'),
(965, " . $new_language_id . ",'Valverde'),
(966, " . $new_language_id . ",'Aileu'),
(967, " . $new_language_id . ",'Ainaro'),
(968, " . $new_language_id . ",'Baucau'),
(969, " . $new_language_id . ",'Bobonaro'),
(970, " . $new_language_id . ",'Cova Lima'),
(971, " . $new_language_id . ",'Dili'),
(972, " . $new_language_id . ",'Ermera'),
(973, " . $new_language_id . ",'Lautem'),
(974, " . $new_language_id . ",'Liquica'),
(975, " . $new_language_id . ",'Manatuto'),
(976, " . $new_language_id . ",'Manufahi'),
(977, " . $new_language_id . ",'Oecussi'),
(978, " . $new_language_id . ",'Viqueque'),
(979, " . $new_language_id . ",'Azuay'),
(980, " . $new_language_id . ",'Bolívar'),
(981, " . $new_language_id . ",'Cañar'),
(982, " . $new_language_id . ",'Carchi'),
(983, " . $new_language_id . ",'Chimborazo'),
(984, " . $new_language_id . ",'Cotopaxi'),
(985, " . $new_language_id . ",'El Oro'),
(986, " . $new_language_id . ",'Esmeraldas'),
(987, " . $new_language_id . ",'Galápagos'),
(988, " . $new_language_id . ",'Guayas'),
(989, " . $new_language_id . ",'Imbabura'),
(990, " . $new_language_id . ",'Loja'),
(991, " . $new_language_id . ",'Los Ríos'),
(992, " . $new_language_id . ",'Manabí'),
(993, " . $new_language_id . ",'Morona Santiago'),
(994, " . $new_language_id . ",'Napo'),
(995, " . $new_language_id . ",'Orellana'),
(996, " . $new_language_id . ",'Pastaza'),
(997, " . $new_language_id . ",'Pichincha'),
(998, " . $new_language_id . ",'Sucumbíos'),
(999, " . $new_language_id . ",'Tungurahua'),
(1000, " . $new_language_id . ",'Zamora Chinchipe'),
(1001, " . $new_language_id . ",'Anuncio Daqahliyah'),
(1002, " . $new_language_id . ",'Al Bahr al Ahmar'),
(1003, " . $new_language_id . ",'Al BUHAYRAH'),
(1004, " . $new_language_id . ",'Al Fayyum'),
(1005, " . $new_language_id . ",'Al Gharbiyah'),
(1006, " . $new_language_id . ",'Al Iskandariyah'),
(1007, " . $new_language_id . ",'Al Isma&#39;iliyah'),
(1008, " . $new_language_id . ",'Al Jizah'),
(1009, " . $new_language_id . ",'Al Minufiyah'),
(1010, " . $new_language_id . ",'Al Minya'),
(1011, " . $new_language_id . ",'Al Qahirah'),
(1012, " . $new_language_id . ",'Al Qalyubiyah'),
(1013, " . $new_language_id . ",'Al Wadi al Jadid'),
(1014, " . $new_language_id . ",'Ash Sharqiyah'),
(1015, " . $new_language_id . ",'As Suways'),
(1016, " . $new_language_id . ",'Asuán'),
(1017, " . $new_language_id . ",'Asiut'),
(1018, " . $new_language_id . ",'Bani Suwayf'),
(1019, " . $new_language_id . ",'Bur Sa&#39;id'),
(1020, " . $new_language_id . ",'Dumyat'),
(1021, " . $new_language_id . ",'Janub Sina &#39;'),
(1022, " . $new_language_id . ",'Kafr ash Shaykh'),
(1023, " . $new_language_id . ",'Matruh'),
(1024, " . $new_language_id . ",'Qina'),
(1025, " . $new_language_id . ",'Shamal Sina &#39;'),
(1026, " . $new_language_id . ",'Suhaj'),
(1027, " . $new_language_id . ",'Ahuachapan'),
(1028, " . $new_language_id . ",'Cabanas'),
(1029, " . $new_language_id . ",'Chalatenango'),
(1030, " . $new_language_id . ",'Cuscatlán'),
(1031, " . $new_language_id . ",'La Libertad'),
(1032, " . $new_language_id . ",'La Paz'),
(1033, " . $new_language_id . ",'La Unión'),
(1034, " . $new_language_id . ",'Morazan'),
(1035, " . $new_language_id . ",'San Miguel'),
(1036, " . $new_language_id . ",'San Salvador'),
(1037, " . $new_language_id . ",'San Vicente'),
(1038, " . $new_language_id . ",'Santa Ana'),
(1039, " . $new_language_id . ",'Sonsonate'),
(1040, " . $new_language_id . ",'Usulutan'),
(1041, " . $new_language_id . ",'Provincia de Annobón'),
(1042, " . $new_language_id . ",'Provincia Bioko Norte'),
(1043, " . $new_language_id . ",'Provincia de Bioko Sur'),
(1044, " . $new_language_id . ",'Provincia Centro Sur'),
(1045, " . $new_language_id . ",'Provincia Kie-Ntem'),
(1046, " . $new_language_id . ",'Provincia Litoral'),
(1047, " . $new_language_id . ",'Provincia Wele-Nzas'),
(1048, " . $new_language_id . ",'Central (Maekel)'),
(1049, " . $new_language_id . ",'Anseba (Keren)'),
(1050, " . $new_language_id . ",'Sur del Mar Rojo (Debub-Keih-Bahri)'),
(1051, " . $new_language_id . ",'Norte del Mar Rojo (Semien-Keih-Bahri)'),
(1052, " . $new_language_id . ",'Sur (Debub)'),
(1053, " . $new_language_id . ",'Gash Barka (Barentu)'),
(1054, " . $new_language_id . ",'Harjumaa (Tallinn)'),
(1055, " . $new_language_id . ",'Hiiumaa (Kardla)'),
(1056, " . $new_language_id . ",'Ida-Viru (Johvi)'),
(1057, " . $new_language_id . ",'Jarvamaa (Paide)'),
(1058, " . $new_language_id . ",'Jogevamaa (Jogeva)'),
(1059, " . $new_language_id . ",'Laane-Viru (Rakvere)'),
(1060, " . $new_language_id . ",'Laanemaa (Haapsalu)'),
(1061, " . $new_language_id . ",'Parnumaa (Parnu)'),
(1062, " . $new_language_id . ",'Polvamaa (Polva)'),
(1063, " . $new_language_id . ",'Raplamaa (Rapla)'),
(1064, " . $new_language_id . ",'Saaremaa (Kuessaare)'),
(1065, " . $new_language_id . ",'Tartu (Tartu)'),
(1066, " . $new_language_id . ",'Valga (Valga)'),
(1067, " . $new_language_id . ",'Viljandimaa (Viljandi)'),
(1068, " . $new_language_id . ",'Vorumaa (Voru)'),
(1069, " . $new_language_id . ",'Lejos'),
(1070, " . $new_language_id . ",'Amhara'),
(1071, " . $new_language_id . ",'Benishangul-Gumaz'),
(1072, " . $new_language_id . ",'Gambela'),
(1073, " . $new_language_id . ",'Hariai'),
(1074, " . $new_language_id . ",'Oromia'),
(1075, " . $new_language_id . ",'Somalí'),
(1076, " . $new_language_id . ",'Naciones del Sur - Región de las Nacionalidades y Pueblos'),
(1077, " . $new_language_id . ",'Tigray'),
(1078, " . $new_language_id . ",'Addis Ababa'),
(1079, " . $new_language_id . ",'Dire Dawa'),
(1080, " . $new_language_id . ",'División Central'),
(1081, " . $new_language_id . ",'División del Norte'),
(1082, " . $new_language_id . ",'División Este'),
(1083, " . $new_language_id . ",'División Occidental'),
(1084, " . $new_language_id . ",'Rotuma'),
(1085, " . $new_language_id . ",'Ahvenanmaan Laani'),
(1086, " . $new_language_id . ",'Etela-Suomen Laani'),
(1087, " . $new_language_id . ",'Ita-Suomen Laani'),
(1088, " . $new_language_id . ",'Lansi-Suomen Laani'),
(1089, " . $new_language_id . ",'Lapin Lanani'),
(1090, " . $new_language_id . ",'Oulun Laani'),
(1091, " . $new_language_id . ",'Alsacia'),
(1092, " . $new_language_id . ",'Aquitania'),
(1093, " . $new_language_id . ",'Auvergne'),
(1094, " . $new_language_id . ",'Bretaña'),
(1095, " . $new_language_id . ",'Borgoña'),
(1096, " . $new_language_id . ",'Centro Valle del Loira'),
(1097, " . $new_language_id . ",'Champán'),
(1098, " . $new_language_id . ",'Corse'),
(1099, " . $new_language_id . ",'Francia Comte'),
(1100, " . $new_language_id . ",'Languedoc Roussillon'),
(1101, " . $new_language_id . ",'Limousin'),
(1102, " . $new_language_id . ",'Lorraine'),
(1103, " . $new_language_id . ",'Midi Pirineos'),
(1104, " . $new_language_id . ",'Norte-Paso de Calais'),
(1105, " . $new_language_id . ",'Normandía'),
(1106, " . $new_language_id . ",'Paris / Ill de France'),
(1107, " . $new_language_id . ",'Picardie'),
(1108, " . $new_language_id . ",'Poitou Charente'),
(1109, " . $new_language_id . ",'Provence'),
(1110, " . $new_language_id . ",'Ródano-Alpes'),
(1111, " . $new_language_id . ",'Riviera'),
(1112, " . $new_language_id . ",'Valle del Loira'),
(1113, " . $new_language_id . ",'Etranger'),
(1114, " . $new_language_id . ",'Ain'),
(1115, " . $new_language_id . ",'Aisne'),
(1116, " . $new_language_id . ",'Allier'),
(1117, " . $new_language_id . ",'Alpes de Alta Provenza'),
(1118, " . $new_language_id . ",'Hautes-Alpes'),
(1119, " . $new_language_id . ",'Alpes Marítimos'),
(1120, " . $new_language_id . ",'Ardèche'),
(1121, " . $new_language_id . ",'Ardenas'),
(1122, " . $new_language_id . ",'Ariège'),
(1123, " . $new_language_id . ",'Aube'),
(1124, " . $new_language_id . ",'Aude'),
(1125, " . $new_language_id . ",'Aveyron'),
(1126, " . $new_language_id . ",'Bouches du Rhône'),
(1127, " . $new_language_id . ",'Calvados'),
(1128, " . $new_language_id . ",'Cantal'),
(1129, " . $new_language_id . ",'Charente'),
(1130, " . $new_language_id . ",'Charente Marítimo'),
(1131, " . $new_language_id . ",'Cher'),
(1132, " . $new_language_id . ",'Corrèze'),
(1133, " . $new_language_id . ",'Corse du Sud'),
(1134, " . $new_language_id . ",'Haute Corse'),
(1135, " . $new_language_id . ",'Côte d&#39;or'),
(1136, " . $new_language_id . ",'Côtes d&#39;Armor'),
(1137, " . $new_language_id . ",'Creuse'),
(1138, " . $new_language_id . ",'Dordogne'),
(1139, " . $new_language_id . ",'Doubs'),
(1140, " . $new_language_id . ",'Drôme'),
(1141, " . $new_language_id . ",'Eure'),
(1142, " . $new_language_id . ",'Eure et Loir'),
(1143, " . $new_language_id . ",'Finisterre'),
(1144, " . $new_language_id . ",'Gard'),
(1145, " . $new_language_id . ",'Haute Garonne'),
(1146, " . $new_language_id . ",'Gers'),
(1147, " . $new_language_id . ",'Gironde'),
(1148, " . $new_language_id . ",'Hérault'),
(1149, " . $new_language_id . ",'Ille et Vilaine'),
(1150, " . $new_language_id . ",'Indre'),
(1151, " . $new_language_id . ",'Indre y Loira'),
(1152, " . $new_language_id . ",'Isére'),
(1153, " . $new_language_id . ",'Jura'),
(1154, " . $new_language_id . ",'Landes'),
(1155, " . $new_language_id . ",'Loir y Cher'),
(1156, " . $new_language_id . ",'Loire'),
(1157, " . $new_language_id . ",'Haute Loire'),
(1158, " . $new_language_id . ",'Loire Atlantique'),
(1159, " . $new_language_id . ",'Loiret'),
(1160, " . $new_language_id . ",'Mucho'),
(1161, " . $new_language_id . ",'Lot et Garonne'),
(1162, " . $new_language_id . ",'Lozère'),
(1163, " . $new_language_id . ",'Maine y Loira'),
(1164, " . $new_language_id . ",'Manche'),
(1165, " . $new_language_id . ",'Marne'),
(1166, " . $new_language_id . ",'Haute Marne'),
(1167, " . $new_language_id . ",'Mayenne'),
(1168, " . $new_language_id . ",'Meurthe et Moselle'),
(1169, " . $new_language_id . ",'Mosa'),
(1170, " . $new_language_id . ",'Morbihan'),
(1171, " . $new_language_id . ",'Mosela'),
(1172, " . $new_language_id . ",'Nièvre'),
(1173, " . $new_language_id . ",'Nord'),
(1174, " . $new_language_id . ",'Oise'),
(1175, " . $new_language_id . ",'Orne'),
(1176, " . $new_language_id . ",'Pas de Calais'),
(1177, " . $new_language_id . ",'Puy-de-Dôme'),
(1178, " . $new_language_id . ",'Pyrénées Atlantiques'),
(1179, " . $new_language_id . ",'Hautes Pyrénées'),
(1180, " . $new_language_id . ",'Pirineos Orientales'),
(1181, " . $new_language_id . ",'Bajo Rin'),
(1182, " . $new_language_id . ",'Haut Rhin'),
(1183, " . $new_language_id . ",'Ródano'),
(1184, " . $new_language_id . ",'Haute Saône'),
(1185, " . $new_language_id . ",'Saona y Loira'),
(1186, " . $new_language_id . ",'Sarthe'),
(1187, " . $new_language_id . ",'Savoie'),
(1188, " . $new_language_id . ",'Haute Savoie'),
(1189, " . $new_language_id . ",'París'),
(1190, " . $new_language_id . ",'Sena Marítimo'),
(1191, " . $new_language_id . ",'Seine et Marne'),
(1192, " . $new_language_id . ",'Yvelines'),
(1193, " . $new_language_id . ",'Deux Sèvres'),
(1194, " . $new_language_id . ",'Somme'),
(1195, " . $new_language_id . ",'Tarn'),
(1196, " . $new_language_id . ",'Tarn et Garonne'),
(1197, " . $new_language_id . ",'Var'),
(1198, " . $new_language_id . ",'Vaucluse'),
(1199, " . $new_language_id . ",'Vendée'),
(1200, " . $new_language_id . ",'Vienne'),
(1201, " . $new_language_id . ",'Haute Vienne'),
(1202, " . $new_language_id . ",'Vosges'),
(1203, " . $new_language_id . ",'Yonne'),
(1204, " . $new_language_id . ",'Territorio de Belfort'),
(1205, " . $new_language_id . ",'Essonne'),
(1206, " . $new_language_id . ",'Hauts de Seine'),
(1207, " . $new_language_id . ",'Seine St-Denis'),
(1208, " . $new_language_id . ",'Val de Marne'),
(1209, " . $new_language_id . ",'Val d&#39;Oise'),
(1210, " . $new_language_id . ",'Archipel des Marqueses'),
(1211, " . $new_language_id . ",'Archipiélago de Tuamotu'),
(1212, " . $new_language_id . ",'Archipel des Tubuai'),
(1213, " . $new_language_id . ",'Iles du Vent'),
(1214, " . $new_language_id . ",'Iles Sous-le-Vent'),
(1215, " . $new_language_id . ",'Islas Crozet'),
(1216, " . $new_language_id . ",'Iles Kerguelen'),
(1217, " . $new_language_id . ",'Ile Amsterdam'),
(1218, " . $new_language_id . ",'Ile Saint-Paul'),
(1219, " . $new_language_id . ",'Tierra de Adelie'),
(1220, " . $new_language_id . ",'Estuaire'),
(1221, " . $new_language_id . ",'Haut-Ogooué'),
(1222, " . $new_language_id . ",'Moyen-Ogooué'),
(1223, " . $new_language_id . ",'Ngounie'),
(1224, " . $new_language_id . ",'Nyanga'),
(1225, " . $new_language_id . ",'Ogooué-Ivindo'),
(1226, " . $new_language_id . ",'Ogooué-Lolo'),
(1227, " . $new_language_id . ",'Ogooué-Maritime'),
(1228, " . $new_language_id . ",'Woleu-Ntem'),
(1229, " . $new_language_id . ",'Banjul'),
(1230, " . $new_language_id . ",'Baja'),
(1231, " . $new_language_id . ",'Brikama'),
(1232, " . $new_language_id . ",'Janjangbure'),
(1233, " . $new_language_id . ",'Kanifeng'),
(1234, " . $new_language_id . ",'Kerewan'),
(1235, " . $new_language_id . ",'Kuntaur'),
(1236, " . $new_language_id . ",'Mansakonko'),
(1237, " . $new_language_id . ",'Bajo Río'),
(1238, " . $new_language_id . ",'Central River'),
(1239, " . $new_language_id . ",'Banco del Norte'),
(1240, " . $new_language_id . ",'Alta del Río'),
(1241, " . $new_language_id . ",'Occidental'),
(1242, " . $new_language_id . ",'Abjasia'),
(1243, " . $new_language_id . ",'Ajaria'),
(1244, " . $new_language_id . ",'Tbilisi'),
(1245, " . $new_language_id . ",'Guria'),
(1246, " . $new_language_id . ",'Imereti'),
(1247, " . $new_language_id . ",'Kakheti'),
(1248, " . $new_language_id . ",'Kvemo Kartli'),
(1249, " . $new_language_id . ",'Mtskheta-Mtianeti'),
(1250, " . $new_language_id . ",'Racha Lechkhumi y Kvemo Svanet'),
(1251, " . $new_language_id . ",'Samegrelo-Zemo Svaneti'),
(1252, " . $new_language_id . ",'Samtskhe-Javakheti'),
(1253, " . $new_language_id . ",'Shida Kartli'),
(1254, " . $new_language_id . ",'Baden-Württemberg'),
(1255, " . $new_language_id . ",'Bayern'),
(1256, " . $new_language_id . ",'Berlín'),
(1257, " . $new_language_id . ",'Brandenburg'),
(1258, " . $new_language_id . ",'Bremen'),
(1259, " . $new_language_id . ",'Hamburgo'),
(1260, " . $new_language_id . ",'Hessen'),
(1261, " . $new_language_id . ",'Mecklemburgo-Pomerania Occidental'),
(1262, " . $new_language_id . ",'Niedersachsen'),
(1263, " . $new_language_id . ",'Nordrhein-Westfalen'),
(1264, " . $new_language_id . ",'Rheinland-Pfalz'),
(1265, " . $new_language_id . ",'Saarland'),
(1266, " . $new_language_id . ",'Sachsen'),
(1267, " . $new_language_id . ",'Sachsen-Anhalt'),
(1268, " . $new_language_id . ",'Schleswig-Holstein'),
(1269, " . $new_language_id . ",'Thüringen'),
(1270, " . $new_language_id . ",'Ashanti Region'),
(1271, " . $new_language_id . ",'Brong-Ahafo Region'),
(1272, " . $new_language_id . ",'Región Centro'),
(1273, " . $new_language_id . ",'Región Oriental'),
(1274, " . $new_language_id . ",'Greater Accra Region'),
(1275, " . $new_language_id . ",'Región Norte'),
(1276, " . $new_language_id . ",'Upper East Región'),
(1277, " . $new_language_id . ",'Upper West Región'),
(1278, " . $new_language_id . ",'Volta Region'),
(1279, " . $new_language_id . ",'Región Occidental'),
(1280, " . $new_language_id . ",'Ática'),
(1281, " . $new_language_id . ",'Grecia central'),
(1282, " . $new_language_id . ",'Central Macedonia'),
(1283, " . $new_language_id . ",'Creta'),
(1284, " . $new_language_id . ",'Macedonia Oriental y Tracia'),
(1285, " . $new_language_id . ",'Epiro'),
(1286, " . $new_language_id . ",'Islas Jónicas'),
(1287, " . $new_language_id . ",'Egeo Norte'),
(1288, " . $new_language_id . ",'Peloponnesos'),
(1289, " . $new_language_id . ",'South Aegean'),
(1290, " . $new_language_id . ",'Tesalia'),
(1291, " . $new_language_id . ",'West Greece'),
(1292, " . $new_language_id . ",'West Macedonia'),
(1293, " . $new_language_id . ",'Avannaa'),
(1294, " . $new_language_id . ",'Tunu'),
(1295, " . $new_language_id . ",'Kitaa'),
(1296, " . $new_language_id . ",'San Andrés'),
(1297, " . $new_language_id . ",'Saint David'),
(1298, " . $new_language_id . ",'San Jorge'),
(1299, " . $new_language_id . ",'San Juan'),
(1300, " . $new_language_id . ",'San Marcos'),
(1301, " . $new_language_id . ",'San Patricio'),
(1302, " . $new_language_id . ",'Carriacou'),
(1303, " . $new_language_id . ",'Petit Martinique'),
(1304, " . $new_language_id . ",'Alta Verapaz'),
(1305, " . $new_language_id . ",'Baja Verapaz'),
(1306, " . $new_language_id . ",'Chimaltenango'),
(1307, " . $new_language_id . ",'Chiquimula'),
(1308, " . $new_language_id . ",'El Peten'),
(1309, " . $new_language_id . ",'El Progreso'),
(1310, " . $new_language_id . ",'El Quiche'),
(1311, " . $new_language_id . ",'Escuintla'),
(1312, " . $new_language_id . ",'Guatemala'),
(1313, " . $new_language_id . ",'Huehuetenango'),
(1314, " . $new_language_id . ",'Izabal'),
(1315, " . $new_language_id . ",'Jalapa'),
(1316, " . $new_language_id . ",'Jutiapa'),
(1317, " . $new_language_id . ",'Quetzaltenango'),
(1318, " . $new_language_id . ",'Retalhuleu'),
(1319, " . $new_language_id . ",'Sacatepequez'),
(1320, " . $new_language_id . ",'San Marcos'),
(1321, " . $new_language_id . ",'Santa Rosa'),
(1322, " . $new_language_id . ",'Solola'),
(1323, " . $new_language_id . ",'Suchitepequez'),
(1324, " . $new_language_id . ",'Totonicapán'),
(1325, " . $new_language_id . ",'Zacapa'),
(1326, " . $new_language_id . ",'Conakry'),
(1327, " . $new_language_id . ",'Beyla'),
(1328, " . $new_language_id . ",'Boffa'),
(1329, " . $new_language_id . ",'Boke'),
(1330, " . $new_language_id . ",'Coyah'),
(1331, " . $new_language_id . ",'Dabola'),
(1332, " . $new_language_id . ",'Dalaba'),
(1333, " . $new_language_id . ",'Dinguiraye'),
(1334, " . $new_language_id . ",'Dubreka'),
(1335, " . $new_language_id . ",'Faranah'),
(1336, " . $new_language_id . ",'Forecariah'),
(1337, " . $new_language_id . ",'Fria'),
(1338, " . $new_language_id . ",'Gaoual'),
(1339, " . $new_language_id . ",'Gueckedou'),
(1340, " . $new_language_id . ",'Kankan'),
(1341, " . $new_language_id . ",'Kerouane'),
(1342, " . $new_language_id . ",'Kindia'),
(1343, " . $new_language_id . ",'Kissidougou'),
(1344, " . $new_language_id . ",'Koubia'),
(1345, " . $new_language_id . ",'Koundara'),
(1346, " . $new_language_id . ",'Kouroussa'),
(1347, " . $new_language_id . ",'Labe'),
(1348, " . $new_language_id . ",'Lelouma'),
(1349, " . $new_language_id . ",'Lola'),
(1350, " . $new_language_id . ",'Macenta'),
(1351, " . $new_language_id . ",'Malí'),
(1352, " . $new_language_id . ",'Mamou'),
(1353, " . $new_language_id . ",'Mandiana'),
(1354, " . $new_language_id . ",'Nzerekore'),
(1355, " . $new_language_id . ",'Pita'),
(1356, " . $new_language_id . ",'Siguiri'),
(1357, " . $new_language_id . ",'Telimele'),
(1358, " . $new_language_id . ",'Tougue'),
(1359, " . $new_language_id . ",'Yomou'),
(1360, " . $new_language_id . ",'Bafatá Región'),
(1361, " . $new_language_id . ",'Biombo Región'),
(1362, " . $new_language_id . ",'Bissau Región'),
(1363, " . $new_language_id . ",'Bolama Región'),
(1364, " . $new_language_id . ",'Cacheu'),
(1365, " . $new_language_id . ",'Gabu Región'),
(1366, " . $new_language_id . ",'Oio Región'),
(1367, " . $new_language_id . ",'Quinara Región'),
(1368, " . $new_language_id . ",'Tombali Región'),
(1369, " . $new_language_id . ",'Barima-Waini'),
(1370, " . $new_language_id . ",'Cuyuni-Mazaruni'),
(1371, " . $new_language_id . ",'Demerara-Mahaica'),
(1372, " . $new_language_id . ",'East Berbice-Corentyne'),
(1373, " . $new_language_id . ",'Essequibo Islands-West Demerara'),
(1374, " . $new_language_id . ",'Mahaica-Berbice'),
(1375, " . $new_language_id . ",'Pomeroon-Supenaam'),
(1376, " . $new_language_id . ",'Potaro-Siparuni'),
(1377, " . $new_language_id . ",'Upper Demerara-Berbice'),
(1378, " . $new_language_id . ",'Upper Takutu-Upper Essequibo'),
(1379, " . $new_language_id . ",'Artibonite'),
(1380, " . $new_language_id . ",'Centro'),
(1381, " . $new_language_id . ",'Grand&#39;Anse'),
(1382, " . $new_language_id . ",'Nord'),
(1383, " . $new_language_id . ",'Nord-Est'),
(1384, " . $new_language_id . ",'Nord-Ouest'),
(1385, " . $new_language_id . ",'Ouest'),
(1386, " . $new_language_id . ",'Sud'),
(1387, " . $new_language_id . ",'Sud-Est'),
(1388, " . $new_language_id . ",'Isla Plana'),
(1389, " . $new_language_id . ",'McDonald Island'),
(1390, " . $new_language_id . ",'Shag Island'),
(1391, " . $new_language_id . ",'Isla Heard'),
(1392, " . $new_language_id . ",'Atlantida'),
(1393, " . $new_language_id . ",'Choluteca'),
(1394, " . $new_language_id . ",'Colon'),
(1395, " . $new_language_id . ",'Comayagua'),
(1396, " . $new_language_id . ",'Copan'),
(1397, " . $new_language_id . ",'Cortes'),
(1398, " . $new_language_id . ",'El Paraiso'),
(1399, " . $new_language_id . ",'Francisco Morazán'),
(1400, " . $new_language_id . ",'Gracias a Dios'),
(1401, " . $new_language_id . ",'Intibuca'),
(1402, " . $new_language_id . ",'Islas de la Bahía (Bay Islands)'),
(1403, " . $new_language_id . ",'La Paz'),
(1404, " . $new_language_id . ",'Lempira'),
(1405, " . $new_language_id . ",'Ocotepeque'),
(1406, " . $new_language_id . ",'Olancho'),
(1407, " . $new_language_id . ",'Santa Bárbara'),
(1408, " . $new_language_id . ",'Valle'),
(1409, " . $new_language_id . ",'Yoro'),
(1410, " . $new_language_id . ",'Central y occidental de Hong Kong Island'),
(1411, " . $new_language_id . ",'Oriental Hong Kong Island'),
(1412, " . $new_language_id . ",'Sur de la isla de Hong Kong'),
(1413, " . $new_language_id . ",'Wan Chai de Hong Kong Island'),
(1414, " . $new_language_id . ",'Kowloon City Kowloon'),
(1415, " . $new_language_id . ",'Kwun Tong Kowloon'),
(1416, " . $new_language_id . ",'Sham Shui Po Kowloon'),
(1417, " . $new_language_id . ",'Wong Tai Sin Kowloon'),
(1418, " . $new_language_id . ",'Yau Tsim Mong Kowloon'),
(1419, " . $new_language_id . ",'Islas Nuevos Territorios'),
(1420, " . $new_language_id . ",'Kwai Tsing Nuevos Territorios'),
(1421, " . $new_language_id . ",'Norte Nuevos Territorios'),
(1422, " . $new_language_id . ",'Sai Kung Nuevos Territorios'),
(1423, " . $new_language_id . ",'Sha Tin Nuevos Territorios'),
(1424, " . $new_language_id . ",'Tai Po Nuevos Territorios'),
(1425, " . $new_language_id . ",'Tsuen Wan Nuevos Territorios'),
(1426, " . $new_language_id . ",'Tuen Mun Nuevos Territorios'),
(1427, " . $new_language_id . ",'Yuen Long Nuevos Territorios'),
(1428, " . $new_language_id . ",'Bacs-Kiskun'),
(1429, " . $new_language_id . ",'Baranya'),
(1430, " . $new_language_id . ",'Bekes'),
(1431, " . $new_language_id . ",'Bekescsaba'),
(1432, " . $new_language_id . ",'Borsod-Abauj-Zemplen'),
(1433, " . $new_language_id . ",'Budapest'),
(1434, " . $new_language_id . ",'Csongrad'),
(1435, " . $new_language_id . ",'Debrecen'),
(1436, " . $new_language_id . ",'Dunaujvaros'),
(1437, " . $new_language_id . ",'Eger'),
(1438, " . $new_language_id . ",'Fejer'),
(1439, " . $new_language_id . ",'Gyor'),
(1440, " . $new_language_id . ",'Gyor-Moson-Sopron'),
(1441, " . $new_language_id . ",'Hajdu-Bihar'),
(1442, " . $new_language_id . ",'Heves'),
(1443, " . $new_language_id . ",'Hodmezovasarhely'),
(1444, " . $new_language_id . ",'Jasz-Nagykun-Szolnok'),
(1445, " . $new_language_id . ",'Kaposvar'),
(1446, " . $new_language_id . ",'Kecskemet'),
(1447, " . $new_language_id . ",'Komarom-Esztergom'),
(1448, " . $new_language_id . ",'Miskolc'),
(1449, " . $new_language_id . ",'Nagykanizsa'),
(1450, " . $new_language_id . ",'Nograd'),
(1451, " . $new_language_id . ",'Nyiregyhaza'),
(1452, " . $new_language_id . ",'Pecs'),
(1453, " . $new_language_id . ",'Parásito'),
(1454, " . $new_language_id . ",'Somogy'),
(1455, " . $new_language_id . ",'Sopron'),
(1456, " . $new_language_id . ",'Szabolcs-Szatmar-Bereg'),
(1457, " . $new_language_id . ",'Szeged'),
(1458, " . $new_language_id . ",'Szekesfehervar'),
(1459, " . $new_language_id . ",'Szolnok'),
(1460, " . $new_language_id . ",'Szombathely'),
(1461, " . $new_language_id . ",'Tatabanya'),
(1462, " . $new_language_id . ",'Tolna'),
(1463, " . $new_language_id . ",'Vas'),
(1464, " . $new_language_id . ",'Veszprem'),
(1465, " . $new_language_id . ",'Zala'),
(1466, " . $new_language_id . ",'Zalaegerszeg'),
(1467, " . $new_language_id . ",'Austurland'),
(1468, " . $new_language_id . ",'Hofuoborgarsvaeoi'),
(1469, " . $new_language_id . ",'Eystra Norourland'),
(1470, " . $new_language_id . ",'Norourland vestra'),
(1471, " . $new_language_id . ",'Suourland'),
(1472, " . $new_language_id . ",'Suournes'),
(1473, " . $new_language_id . ",'Vestfiroir'),
(1474, " . $new_language_id . ",'Vesturland'),
(1475, " . $new_language_id . ",'Andaman y Nicobar'),
(1476, " . $new_language_id . ",'Andhra Pradesh'),
(1477, " . $new_language_id . ",'Arunachal Pradesh'),
(1478, " . $new_language_id . ",'Assam'),
(1479, " . $new_language_id . ",'Bihar'),
(1480, " . $new_language_id . ",'Chandigarh'),
(1481, " . $new_language_id . ",'Dadra y Nagar Haveli'),
(1482, " . $new_language_id . ",'Daman y Diu'),
(1483, " . $new_language_id . ",'Delhi'),
(1484, " . $new_language_id . ",'Goa'),
(1485, " . $new_language_id . ",'Gujarat'),
(1486, " . $new_language_id . ",'Haryana'),
(1487, " . $new_language_id . ",'Himachal Pradesh'),
(1488, " . $new_language_id . ",'Jammu y Cachemira'),
(1489, " . $new_language_id . ",'Karnataka'),
(1490, " . $new_language_id . ",'Kerala'),
(1491, " . $new_language_id . ",'Islas Lakshadweep'),
(1492, " . $new_language_id . ",'Madhya Pradesh'),
(1493, " . $new_language_id . ",'Maharashtra'),
(1494, " . $new_language_id . ",'Manipur'),
(1495, " . $new_language_id . ",'Meghalaya'),
(1496, " . $new_language_id . ",'Mizoram'),
(1497, " . $new_language_id . ",'Nagaland'),
(1498, " . $new_language_id . ",'Orissa'),
(1499, " . $new_language_id . ",'Pondicherry'),
(1500, " . $new_language_id . ",'Punjab'),
(1501, " . $new_language_id . ",'Rajasthan'),
(1502, " . $new_language_id . ",'Sikkim'),
(1503, " . $new_language_id . ",'Tamil Nadu'),
(1504, " . $new_language_id . ",'Tripura'),
(1505, " . $new_language_id . ",'Uttar Pradesh'),
(1506, " . $new_language_id . ",'Bengala Occidental'),
(1507, " . $new_language_id . ",'Aceh'),
(1508, " . $new_language_id . ",'Bali'),
(1509, " . $new_language_id . ",'Banten'),
(1510, " . $new_language_id . ",'Bengkulu'),
(1511, " . $new_language_id . ",'BoDeTaBek'),
(1512, " . $new_language_id . ",'Gorontalo'),
(1513, " . $new_language_id . ",'Jakarta Raya'),
(1514, " . $new_language_id . ",'Jambi'),
(1515, " . $new_language_id . ",'Jawa Barat'),
(1516, " . $new_language_id . ",'Jawa Tengah'),
(1517, " . $new_language_id . ",'Jawa Timur'),
(1518, " . $new_language_id . ",'Kalimantan Barat'),
(1519, " . $new_language_id . ",'Kalimantan Selatan'),
(1520, " . $new_language_id . ",'Kalimantan Tengah'),
(1521, " . $new_language_id . ",'Kalimantan Timur'),
(1522, " . $new_language_id . ",'Kepulauan Bangka Belitung'),
(1523, " . $new_language_id . ",'Lampung'),
(1524, " . $new_language_id . ",'Maluku'),
(1525, " . $new_language_id . ",'Maluku Utara'),
(1526, " . $new_language_id . ",'Nusa Tenggara Barat'),
(1527, " . $new_language_id . ",'Nusa Tenggara Timur'),
(1528, " . $new_language_id . ",'Papuasia'),
(1529, " . $new_language_id . ",'Riau'),
(1530, " . $new_language_id . ",'Sulawesi Selatan'),
(1531, " . $new_language_id . ",'Sulawesi Tengah'),
(1532, " . $new_language_id . ",'Sulawesi Tenggara'),
(1533, " . $new_language_id . ",'Sulawesi Utara'),
(1534, " . $new_language_id . ",'Sumatera Barat'),
(1535, " . $new_language_id . ",'Sumatera Selatan'),
(1536, " . $new_language_id . ",'Sumatera Utara'),
(1537, " . $new_language_id . ",'Yogyakarta'),
(1538, " . $new_language_id . ",'Teherán'),
(1539, " . $new_language_id . ",'Qom'),
(1540, " . $new_language_id . ",'Markazi'),
(1541, " . $new_language_id . ",'Qazvin'),
(1542, " . $new_language_id . ",'Gilan'),
(1543, " . $new_language_id . ",'Ardabil'),
(1544, " . $new_language_id . ",'Zanjan'),
(1545, " . $new_language_id . ",'East Azarbaijan'),
(1546, " . $new_language_id . ",'Azerbaiyán Occidental'),
(1547, " . $new_language_id . ",'Kurdistán'),
(1548, " . $new_language_id . ",'Hamadan'),
(1549, " . $new_language_id . ",'Kermanshah'),
(1550, " . $new_language_id . ",'Ilam'),
(1551, " . $new_language_id . ",'Lorestan'),
(1552, " . $new_language_id . ",'Khuzestan'),
(1553, " . $new_language_id . ",'Chahar Mahaal y Bakhtiari'),
(1554, " . $new_language_id . ",'Kohkiluyeh y Buyer Ahmad'),
(1555, " . $new_language_id . ",'Bushehr'),
(1556, " . $new_language_id . ",'Fars'),
(1557, " . $new_language_id . ",'Hormozgan'),
(1558, " . $new_language_id . ",'Sistán y Baluchistán'),
(1559, " . $new_language_id . ",'Kerman'),
(1560, " . $new_language_id . ",'Yazd'),
(1561, " . $new_language_id . ",'Esfahan'),
(1562, " . $new_language_id . ",'Semnan'),
(1563, " . $new_language_id . ",'Mazandaran'),
(1564, " . $new_language_id . ",'Golestan'),
(1565, " . $new_language_id . ",'Norte Jorasán'),
(1566, " . $new_language_id . ",'Razavi Khorasan'),
(1567, " . $new_language_id . ",'Sur Jorasán'),
(1568, " . $new_language_id . ",'Bagdad'),
(1569, " . $new_language_id . ",'Salah ad Din'),
(1570, " . $new_language_id . ",'Diyala'),
(1571, " . $new_language_id . ",'Wasit'),
(1572, " . $new_language_id . ",'Maysan'),
(1573, " . $new_language_id . ",'Al Basrah'),
(1574, " . $new_language_id . ",'Dhi Qar'),
(1575, " . $new_language_id . ",'Al Muthanna'),
(1576, " . $new_language_id . ",'Al Qadisyah'),
(1577, " . $new_language_id . ",'Babil'),
(1578, " . $new_language_id . ",'Al Karbala'),
(1579, " . $new_language_id . ",'An Najaf'),
(1580, " . $new_language_id . ",'Al Anbar'),
(1581, " . $new_language_id . ",'Ninawa'),
(1582, " . $new_language_id . ",'Dahuk'),
(1583, " . $new_language_id . ",'Arbil'),
(1584, " . $new_language_id . ",'En Ta&#39;mim'),
(1585, " . $new_language_id . ",'As Sulaymaniyah'),
(1586, " . $new_language_id . ",'Carlow'),
(1587, " . $new_language_id . ",'Cavan'),
(1588, " . $new_language_id . ",'Clare'),
(1589, " . $new_language_id . ",'Corcho'),
(1590, " . $new_language_id . ",'Donegal'),
(1591, " . $new_language_id . ",'Dublín'),
(1592, " . $new_language_id . ",'Galway'),
(1593, " . $new_language_id . ",'Kerry'),
(1594, " . $new_language_id . ",'Kildare'),
(1595, " . $new_language_id . ",'Kilkenny'),
(1596, " . $new_language_id . ",'Laois'),
(1597, " . $new_language_id . ",'Leitrim'),
(1598, " . $new_language_id . ",'Limerick'),
(1599, " . $new_language_id . ",'Longford'),
(1600, " . $new_language_id . ",'Louth'),
(1601, " . $new_language_id . ",'Mayonesa'),
(1602, " . $new_language_id . ",'Meath'),
(1603, " . $new_language_id . ",'Monaghan'),
(1604, " . $new_language_id . ",'Offaly'),
(1605, " . $new_language_id . ",'Roscommon'),
(1606, " . $new_language_id . ",'Sligo'),
(1607, " . $new_language_id . ",'Tipperary'),
(1608, " . $new_language_id . ",'Waterford'),
(1609, " . $new_language_id . ",'Westmeath'),
(1610, " . $new_language_id . ",'Wexford'),
(1611, " . $new_language_id . ",'Wicklow'),
(1612, " . $new_language_id . ",'Beer Sheva'),
(1613, " . $new_language_id . ",'Bika&#39;at Hayarden'),
(1614, " . $new_language_id . ",'Eilat y Arava'),
(1615, " . $new_language_id . ",'Galil'),
(1616, " . $new_language_id . ",'Haifa'),
(1617, " . $new_language_id . ",'Montañas Jehuda'),
(1618, " . $new_language_id . ",'Jerusalén'),
(1619, " . $new_language_id . ",'Negev'),
(1620, " . $new_language_id . ",'Semaria'),
(1621, " . $new_language_id . ",'Sharon'),
(1622, " . $new_language_id . ",'Tel Aviv (Gosh Dan)'),
(1643, " . $new_language_id . ",'Clarendon Parish'),
(1644, " . $new_language_id . ",'Hanover Parish'),
(1645, " . $new_language_id . ",'Kingston Parish'),
(1646, " . $new_language_id . ",'Manchester Parish'),
(1647, " . $new_language_id . ",'Portland Parish'),
(1648, " . $new_language_id . ",'San Andrés Parroquia'),
(1649, " . $new_language_id . ",'Saint Ann Parish'),
(1650, " . $new_language_id . ",'Parroquia de Santa Catalina'),
(1651, " . $new_language_id . ",'Parroquia Santa Isabel'),
(1652, " . $new_language_id . ",'San James Parish'),
(1653, " . $new_language_id . ",'Parroquia de Saint Mary'),
(1654, " . $new_language_id . ",'Parroquia Santo Tomás'),
(1655, " . $new_language_id . ",'Trelawny Parish'),
(1656, " . $new_language_id . ",'Westmoreland Parroquia'),
(1657, " . $new_language_id . ",'Aichi'),
(1658, " . $new_language_id . ",'Akita'),
(1659, " . $new_language_id . ",'Aomori'),
(1660, " . $new_language_id . ",'Chiba'),
(1661, " . $new_language_id . ",'Ehime'),
(1662, " . $new_language_id . ",'Fukui'),
(1663, " . $new_language_id . ",'Fukuoka'),
(1664, " . $new_language_id . ",'Fukushima'),
(1665, " . $new_language_id . ",'Gifu'),
(1666, " . $new_language_id . ",'Gumma'),
(1667, " . $new_language_id . ",'Hiroshima'),
(1668, " . $new_language_id . ",'Hokkaido'),
(1669, " . $new_language_id . ",'Hyogo'),
(1670, " . $new_language_id . ",'Ibaraki'),
(1671, " . $new_language_id . ",'Ishikawa'),
(1672, " . $new_language_id . ",'Iwate'),
(1673, " . $new_language_id . ",'Kagawa'),
(1674, " . $new_language_id . ",'Kagoshima'),
(1675, " . $new_language_id . ",'Kanagawa'),
(1676, " . $new_language_id . ",'Kochi'),
(1677, " . $new_language_id . ",'Kumamoto'),
(1678, " . $new_language_id . ",'Kyoto'),
(1679, " . $new_language_id . ",'Mie'),
(1680, " . $new_language_id . ",'Miyagi'),
(1681, " . $new_language_id . ",'Miyazaki'),
(1682, " . $new_language_id . ",'Nagano'),
(1683, " . $new_language_id . ",'Nagasaki'),
(1684, " . $new_language_id . ",'Nara'),
(1685, " . $new_language_id . ",'Niigata'),
(1686, " . $new_language_id . ",'Oita'),
(1687, " . $new_language_id . ",'Okayama'),
(1688, " . $new_language_id . ",'Okinawa'),
(1689, " . $new_language_id . ",'Osaka'),
(1690, " . $new_language_id . ",'Saga'),
(1691, " . $new_language_id . ",'Saitama'),
(1692, " . $new_language_id . ",'Shiga'),
(1693, " . $new_language_id . ",'Shimane'),
(1694, " . $new_language_id . ",'Shizuoka'),
(1695, " . $new_language_id . ",'Tochigi'),
(1696, " . $new_language_id . ",'Tokushima'),
(1697, " . $new_language_id . ",'Tokio'),
(1698, " . $new_language_id . ",'Tottori'),
(1699, " . $new_language_id . ",'Toyama'),
(1700, " . $new_language_id . ",'Wakayama'),
(1701, " . $new_language_id . ",'Yamagata'),
(1702, " . $new_language_id . ",'Yamaguchi'),
(1703, " . $new_language_id . ",'Yamanashi'),
(1704, " . $new_language_id . ",'&#39;Amman'),
(1705, " . $new_language_id . ",'Ajlun'),
(1706, " . $new_language_id . ",'Al &#39;Aqabah'),
(1707, " . $new_language_id . ",'Al Balqa &#39;'),
(1708, " . $new_language_id . ",'Al Karak'),
(1709, " . $new_language_id . ",'Al Mafraq'),
(1710, " . $new_language_id . ",'En Tafilah'),
(1711, " . $new_language_id . ",'Az Zarqa &#39;'),
(1712, " . $new_language_id . ",'Irbid'),
(1713, " . $new_language_id . ",'Jarash'),
(1714, " . $new_language_id . ",'Ma&#39;an'),
(1715, " . $new_language_id . ",'Madaba'),
(1716, " . $new_language_id . ",'Almaty'),
(1717, " . $new_language_id . ",'Almaty City'),
(1718, " . $new_language_id . ",'Aqmola'),
(1719, " . $new_language_id . ",'Aqtobe'),
(1720, " . $new_language_id . ",'Astana City'),
(1721, " . $new_language_id . ",'Atyrau'),
(1722, " . $new_language_id . ",'Batys Qazaqstan'),
(1723, " . $new_language_id . ",'Bayqongyr City'),
(1724, " . $new_language_id . ",'Mangghystau'),
(1725, " . $new_language_id . ",'Ongtustik Qazaqstan'),
(1726, " . $new_language_id . ",'Pavlodar'),
(1727, " . $new_language_id . ",'Qaraghandy'),
(1728, " . $new_language_id . ",'Qostanay'),
(1729, " . $new_language_id . ",'Qyzylorda'),
(1730, " . $new_language_id . ",'Shyghys Qazaqstan'),
(1731, " . $new_language_id . ",'Soltustik Qazaqstan'),
(1732, " . $new_language_id . ",'Zhambyl'),
(1733, " . $new_language_id . ",'Central'),
(1734, " . $new_language_id . ",'Costa'),
(1735, " . $new_language_id . ",'Oriental'),
(1736, " . $new_language_id . ",'Montevideo'),
(1737, " . $new_language_id . ",'Nororiental'),
(1738, " . $new_language_id . ",'Nyanza'),
(1739, " . $new_language_id . ",'Rift Valley'),
(1740, " . $new_language_id . ",'Occidental'),
(1741, " . $new_language_id . ",'Abaiang'),
(1742, " . $new_language_id . ",'Abemama'),
(1743, " . $new_language_id . ",'Aranuka'),
(1744, " . $new_language_id . ",'Arorae'),
(1745, " . $new_language_id . ",'Banaba'),
(1746, " . $new_language_id . ",'Beru'),
(1747, " . $new_language_id . ",'Butaritari'),
(1748, " . $new_language_id . ",'Kanton'),
(1749, " . $new_language_id . ",'Kiritimati'),
(1750, " . $new_language_id . ",'Kuria'),
(1751, " . $new_language_id . ",'Maiana'),
(1752, " . $new_language_id . ",'Makin'),
(1753, " . $new_language_id . ",'Marakei'),
(1754, " . $new_language_id . ",'Nikunau'),
(1755, " . $new_language_id . ",'Nonouti'),
(1756, " . $new_language_id . ",'Onotoa'),
(1757, " . $new_language_id . ",'Tabiteuea'),
(1758, " . $new_language_id . ",'Tabuaeran'),
(1759, " . $new_language_id . ",'Tamana'),
(1760, " . $new_language_id . ",'Tarawa'),
(1761, " . $new_language_id . ",'Teraina'),
(1762, " . $new_language_id . ",'Chagang-do'),
(1763, " . $new_language_id . ",'Hamgyong-bukto'),
(1764, " . $new_language_id . ",'Hamgyong-namdo'),
(1765, " . $new_language_id . ",'Hwanghae-bukto'),
(1766, " . $new_language_id . ",'Hwanghae-namdo'),
(1767, " . $new_language_id . ",'Kangwon-do'),
(1768, " . $new_language_id . ",'P&#39;yongan-bukto'),
(1769, " . $new_language_id . ",'P&#39;yongan-namdo'),
(1770, " . $new_language_id . ",'Ryanggang-do (Yanggang-do)'),
(1771, " . $new_language_id . ",'Ciudad de Rason regula directamente'),
(1772, " . $new_language_id . ",'P&#39;yongyang Special City'),
(1773, " . $new_language_id . ",'Ch&#39;ungch&#39;ong-bukto'),
(1774, " . $new_language_id . ",'Ch&#39;ungch&#39;ong-namdo'),
(1775, " . $new_language_id . ",'Cheju-do'),
(1776, " . $new_language_id . ",'Cholla-bukto'),
(1777, " . $new_language_id . ",'Cholla-namdo'),
(1778, " . $new_language_id . ",'Inch&#39;on-gwangyoksi'),
(1779, " . $new_language_id . ",'Kangwon-do'),
(1780, " . $new_language_id . ",'Kwangju-gwangyoksi'),
(1781, " . $new_language_id . ",'Kyonggi-do'),
(1782, " . $new_language_id . ",'Kyongsang-bukto'),
(1783, " . $new_language_id . ",'Kyongsang-namdo'),
(1784, " . $new_language_id . ",'Pusan-gwangyoksi'),
(1785, " . $new_language_id . ",'Soul-t&#39;ukpyolsi'),
(1786, " . $new_language_id . ",'Taegu-gwangyoksi'),
(1787, " . $new_language_id . ",'Taejon-gwangyoksi'),
(1788, " . $new_language_id . ",'Al &#39;Asimah'),
(1789, " . $new_language_id . ",'Al Ahmadi'),
(1790, " . $new_language_id . ",'Al Farwaniyah'),
(1791, " . $new_language_id . ",'Al Jahra &#39;'),
(1792, " . $new_language_id . ",'Hawalli'),
(1793, " . $new_language_id . ",'Bishkek'),
(1794, " . $new_language_id . ",'Batken'),
(1795, " . $new_language_id . ",'Chu'),
(1796, " . $new_language_id . ",'Jalal-Abad'),
(1797, " . $new_language_id . ",'Naryn'),
(1798, " . $new_language_id . ",'Osh'),
(1799, " . $new_language_id . ",'Talas'),
(1800, " . $new_language_id . ",'Ysyk-Kol'),
(1801, " . $new_language_id . ",'Vientiane'),
(1802, " . $new_language_id . ",'Attapu'),
(1803, " . $new_language_id . ",'Bokeo'),
(1804, " . $new_language_id . ",'Bolikhamxai'),
(1805, " . $new_language_id . ",'Champasak'),
(1806, " . $new_language_id . ",'Houaphan'),
(1807, " . $new_language_id . ",'Khammouan'),
(1808, " . $new_language_id . ",'Louang Namtha'),
(1809, " . $new_language_id . ",'Louangphabang'),
(1810, " . $new_language_id . ",'Oudomxai'),
(1811, " . $new_language_id . ",'Phongsali'),
(1812, " . $new_language_id . ",'Salavan'),
(1813, " . $new_language_id . ",'Savannakhet'),
(1814, " . $new_language_id . ",'Vientiane'),
(1815, " . $new_language_id . ",'Xaignabouli'),
(1816, " . $new_language_id . ",'Xekong'),
(1817, " . $new_language_id . ",'Xiangkhoang'),
(1818, " . $new_language_id . ",'Xaisomboun'),
(1819, " . $new_language_id . ",'Aizkraukles Rajons'),
(1820, " . $new_language_id . ",'Aluksnes Rajons'),
(1821, " . $new_language_id . ",'Balvu Rajons'),
(1822, " . $new_language_id . ",'Bauskas Rajons'),
(1823, " . $new_language_id . ",'Cesu Rajons'),
(1824, " . $new_language_id . ",'Daugavpils Rajons'),
(1825, " . $new_language_id . ",'Dobeles Rajons'),
(1826, " . $new_language_id . ",'Gulbenes Rajons'),
(1827, " . $new_language_id . ",'Jekabpils Rajons'),
(1828, " . $new_language_id . ",'Jelgavas Rajons'),
(1829, " . $new_language_id . ",'Kraslavas Rajons'),
(1830, " . $new_language_id . ",'Kuldigas Rajons'),
(1831, " . $new_language_id . ",'Liepajas Rajons'),
(1832, " . $new_language_id . ",'Limbazu Rajons'),
(1833, " . $new_language_id . ",'Ludzas Rajons'),
(1834, " . $new_language_id . ",'Madonas Rajons'),
(1835, " . $new_language_id . ",'Ogros Rajons'),
(1836, " . $new_language_id . ",'Preilu Rajons'),
(1837, " . $new_language_id . ",'Rezeknes Rajons'),
(1838, " . $new_language_id . ",'Rigas Rajons'),
(1839, " . $new_language_id . ",'Saldus Rajons'),
(1840, " . $new_language_id . ",'Talsu Rajons'),
(1841, " . $new_language_id . ",'Tukuma Rajons'),
(1842, " . $new_language_id . ",'Valkas Rajons'),
(1843, " . $new_language_id . ",'Valmieras Rajons'),
(1844, " . $new_language_id . ",'Ventspils Rajons'),
(1845, " . $new_language_id . ",'Daugavpils'),
(1846, " . $new_language_id . ",'Jelgava'),
(1847, " . $new_language_id . ",'Jurmala'),
(1848, " . $new_language_id . ",'Liepaja'),
(1849, " . $new_language_id . ",'Rezekne'),
(1850, " . $new_language_id . ",'Riga'),
(1851, " . $new_language_id . ",'Ventspils'),
(1852, " . $new_language_id . ",'Berea'),
(1853, " . $new_language_id . ",'Butha-Buthe'),
(1854, " . $new_language_id . ",'Leribe'),
(1855, " . $new_language_id . ",'Mafeteng'),
(1856, " . $new_language_id . ",'Maseru'),
(1857, " . $new_language_id . ",'Hoek Mohale'),
(1858, " . $new_language_id . ",'Mokhotlong'),
(1859, " . $new_language_id . ",'Nek Nek de'),
(1860, " . $new_language_id . ",'Quthing'),
(1861, " . $new_language_id . ",'Thaba-Tseka'),
(1862, " . $new_language_id . ",'Bomi'),
(1863, " . $new_language_id . ",'Bong'),
(1864, " . $new_language_id . ",'Grand Bassa'),
(1865, " . $new_language_id . ",'Grand Cape Mount'),
(1866, " . $new_language_id . ",'Grand Gedeh'),
(1867, " . $new_language_id . ",'Grand Kru'),
(1868, " . $new_language_id . ",'Lofa'),
(1869, " . $new_language_id . ",'Margibi'),
(1870, " . $new_language_id . ",'Maryland'),
(1871, " . $new_language_id . ",'Montserrado'),
(1872, " . $new_language_id . ",'Nimba'),
(1873, " . $new_language_id . ",'River Cess'),
(1874, " . $new_language_id . ",'Sinoe'),
(1875, " . $new_language_id . ",'Ajdabiya'),
(1876, " . $new_language_id . ",'Al &#39;Aziziyah'),
(1877, " . $new_language_id . ",'Al Fatih'),
(1878, " . $new_language_id . ",'Al Jabal al Akhdar'),
(1879, " . $new_language_id . ",'Al Jufrah'),
(1880, " . $new_language_id . ",'Al Khums'),
(1881, " . $new_language_id . ",'Al Kufrah'),
(1882, " . $new_language_id . ",'Un Nuqat al Khams'),
(1883, " . $new_language_id . ",'Ash Shati &#39;'),
(1884, " . $new_language_id . ",'Awbari'),
(1885, " . $new_language_id . ",'Az Zawiyah'),
(1886, " . $new_language_id . ",'Benghazi'),
(1887, " . $new_language_id . ",'Darnah'),
(1888, " . $new_language_id . ",'Ghadamis'),
(1889, " . $new_language_id . ",'Gharyan'),
(1890, " . $new_language_id . ",'Misratah'),
(1891, " . $new_language_id . ",'Murzuq'),
(1892, " . $new_language_id . ",'Sabha'),
(1893, " . $new_language_id . ",'Sawfajjin'),
(1894, " . $new_language_id . ",'Surt'),
(1895, " . $new_language_id . ",'Tarabulus (Trípoli)'),
(1896, " . $new_language_id . ",'Tarhunah'),
(1897, " . $new_language_id . ",'Tubruq'),
(1898, " . $new_language_id . ",'Yafran'),
(1899, " . $new_language_id . ",'Zlitan'),
(1900, " . $new_language_id . ",'Vaduz'),
(1901, " . $new_language_id . ",'Schaan'),
(1902, " . $new_language_id . ",'Balzers'),
(1903, " . $new_language_id . ",'Triesen'),
(1904, " . $new_language_id . ",'Eschen'),
(1905, " . $new_language_id . ",'Mauren'),
(1906, " . $new_language_id . ",'Triesenberg'),
(1907, " . $new_language_id . ",'Ruggell'),
(1908, " . $new_language_id . ",'Gamprin'),
(1909, " . $new_language_id . ",'Schellenberg'),
(1910, " . $new_language_id . ",'Planken'),
(1911, " . $new_language_id . ",'Alytus'),
(1912, " . $new_language_id . ",'Kaunas'),
(1913, " . $new_language_id . ",'Klaipeda'),
(1914, " . $new_language_id . ",'Marijampole'),
(1915, " . $new_language_id . ",'Panevezys'),
(1916, " . $new_language_id . ",'Siauliai'),
(1917, " . $new_language_id . ",'Taurage'),
(1918, " . $new_language_id . ",'Telsiai'),
(1919, " . $new_language_id . ",'Utena'),
(1920, " . $new_language_id . ",'Vilnius'),
(1921, " . $new_language_id . ",'Diekirch'),
(1922, " . $new_language_id . ",'Clervaux'),
(1923, " . $new_language_id . ",'Redange'),
(1924, " . $new_language_id . ",'Vianden'),
(1925, " . $new_language_id . ",'Wiltz'),
(1926, " . $new_language_id . ",'Grevenmacher'),
(1927, " . $new_language_id . ",'Echternach'),
(1928, " . $new_language_id . ",'Remich'),
(1929, " . $new_language_id . ",'Luxemburgo'),
(1930, " . $new_language_id . ",'Capellen'),
(1931, " . $new_language_id . ",'Esch-sur-Alzette'),
(1932, " . $new_language_id . ",'Mersch'),
(1933, " . $new_language_id . ",'Nuestra Señora de Fátima Parroquia'),
(1934, " . $new_language_id . ",'Parroquia de San Antonio'),
(1935, " . $new_language_id . ",'Parroquia de San Lázaro'),
(1936, " . $new_language_id . ",'Parroquia de la Catedral'),
(1937, " . $new_language_id . ",'St. Lawrence Parish'),
(1938, " . $new_language_id . ",'Antananarivo'),
(1939, " . $new_language_id . ",'Antsiranana'),
(1940, " . $new_language_id . ",'Fianarantsoa'),
(1941, " . $new_language_id . ",'Mahajanga'),
(1942, " . $new_language_id . ",'Toamasina'),
(1943, " . $new_language_id . ",'Toliara'),
(1944, " . $new_language_id . ",'Balaka'),
(1945, " . $new_language_id . ",'Blantyre'),
(1946, " . $new_language_id . ",'Chikwawa'),
(1947, " . $new_language_id . ",'Chiradzulu'),
(1948, " . $new_language_id . ",'Chitipa'),
(1949, " . $new_language_id . ",'Dedza'),
(1950, " . $new_language_id . ",'Dowa'),
(1951, " . $new_language_id . ",'Karonga'),
(1952, " . $new_language_id . ",'Kasungu'),
(1953, " . $new_language_id . ",'Likoma'),
(1954, " . $new_language_id . ",'Lilongwe'),
(1955, " . $new_language_id . ",'Machinga'),
(1956, " . $new_language_id . ",'Mangochi'),
(1957, " . $new_language_id . ",'Mchinji'),
(1958, " . $new_language_id . ",'Mulanje'),
(1959, " . $new_language_id . ",'Mwanza'),
(1960, " . $new_language_id . ",'Mzimba'),
(1961, " . $new_language_id . ",'Ntcheu'),
(1962, " . $new_language_id . ",'Nkhata Bay'),
(1963, " . $new_language_id . ",'Nkhotakota'),
(1964, " . $new_language_id . ",'Nsanje'),
(1965, " . $new_language_id . ",'Ntchisi'),
(1966, " . $new_language_id . ",'Phalombe'),
(1967, " . $new_language_id . ",'Rumphi'),
(1968, " . $new_language_id . ",'Salima'),
(1969, " . $new_language_id . ",'Thyolo'),
(1970, " . $new_language_id . ",'Zomba'),
(1971, " . $new_language_id . ",'Johor'),
(1972, " . $new_language_id . ",'Kedah'),
(1973, " . $new_language_id . ",'Kelantan'),
(1974, " . $new_language_id . ",'Labuan'),
(1975, " . $new_language_id . ",'Melaka'),
(1976, " . $new_language_id . ",'Negeri Sembilan'),
(1977, " . $new_language_id . ",'Pahang'),
(1978, " . $new_language_id . ",'Perak'),
(1979, " . $new_language_id . ",'Perlis'),
(1980, " . $new_language_id . ",'Pulau Pinang'),
(1981, " . $new_language_id . ",'Sabah'),
(1982, " . $new_language_id . ",'Sarawak'),
(1983, " . $new_language_id . ",'Selangor'),
(1984, " . $new_language_id . ",'Terengganu'),
(1985, " . $new_language_id . ",'Wilayah Persekutuan'),
(1986, " . $new_language_id . ",'Thiladhunmathi Uthuru'),
(1987, " . $new_language_id . ",'Thiladhunmathi Dhekunu'),
(1988, " . $new_language_id . ",'Miladhunmadulu Uthuru'),
(1989, " . $new_language_id . ",'Miladhunmadulu Dhekunu'),
(1990, " . $new_language_id . ",'Maalhosmadulu Uthuru'),
(1991, " . $new_language_id . ",'Maalhosmadulu Dhekunu'),
(1992, " . $new_language_id . ",'Faadhippolhu'),
(1993, " . $new_language_id . ",'Atolón Male'),
(1994, " . $new_language_id . ",'Ari Atoll Uthuru'),
(1995, " . $new_language_id . ",'Ari Atoll Dheknu'),
(1996, " . $new_language_id . ",'Felidhe Atoll'),
(1997, " . $new_language_id . ",'Mulaku Atoll'),
(1998, " . $new_language_id . ",'Nilandhe Atoll Uthuru'),
(1999, " . $new_language_id . ",'Nilandhe Atoll Dhekunu'),
(2000, " . $new_language_id . ",'Kolhumadulu'),
(2001, " . $new_language_id . ",'Hadhdhunmathi'),
(2002, " . $new_language_id . ",'Huvadhu Atoll Uthuru'),
(2003, " . $new_language_id . ",'Huvadhu Atoll Dhekunu'),
(2004, " . $new_language_id . ",'Fua Mulaku'),
(2005, " . $new_language_id . ",'Addu'),
(2006, " . $new_language_id . ",'Gao'),
(2007, " . $new_language_id . ",'Kayes'),
(2008, " . $new_language_id . ",'Kidal'),
(2009, " . $new_language_id . ",'Koulikoro'),
(2010, " . $new_language_id . ",'Mopti'),
(2011, " . $new_language_id . ",'Segou'),
(2012, " . $new_language_id . ",'Sikasso'),
(2013, " . $new_language_id . ",'Tombouctou'),
(2014, " . $new_language_id . ",'Bamako Distrito Capital'),
(2015, " . $new_language_id . ",'Attard'),
(2016, " . $new_language_id . ",'Balzan'),
(2017, " . $new_language_id . ",'Birgu'),
(2018, " . $new_language_id . ",'Birkirkara'),
(2019, " . $new_language_id . ",'Birzebbuga'),
(2020, " . $new_language_id . ",'Bormla'),
(2021, " . $new_language_id . ",'Dingli'),
(2022, " . $new_language_id . ",'Fgura'),
(2023, " . $new_language_id . ",'Floriana'),
(2024, " . $new_language_id . ",'Gudja'),
(2025, " . $new_language_id . ",'Gzira'),
(2026, " . $new_language_id . ",'Gargur'),
(2027, " . $new_language_id . ",'Gaxaq'),
(2028, " . $new_language_id . ",'Hamrun'),
(2029, " . $new_language_id . ",'Iklin'),
(2030, " . $new_language_id . ",'Isla'),
(2031, " . $new_language_id . ",'Kalkara'),
(2032, " . $new_language_id . ",'Kirkop'),
(2033, " . $new_language_id . ",'Lija'),
(2034, " . $new_language_id . ",'Luqa'),
(2035, " . $new_language_id . ",'Marsa'),
(2036, " . $new_language_id . ",'Marsaskala'),
(2037, " . $new_language_id . ",'Marsaxlokk'),
(2038, " . $new_language_id . ",'Mdina'),
(2039, " . $new_language_id . ",'Mellieħa'),
(2040, " . $new_language_id . ",'Mgarr'),
(2041, " . $new_language_id . ",'Mosta'),
(2042, " . $new_language_id . ",'Mqabba'),
(2043, " . $new_language_id . ",'Msida'),
(2044, " . $new_language_id . ",'Mtarfa'),
(2045, " . $new_language_id . ",'Naxxar'),
(2046, " . $new_language_id . ",'Paola'),
(2047, " . $new_language_id . ",'Pembroke'),
(2048, " . $new_language_id . ",'Piedad'),
(2049, " . $new_language_id . ",'Qormi'),
(2050, " . $new_language_id . ",'Qrendi'),
(2051, " . $new_language_id . ",'Rabat'),
(2052, " . $new_language_id . ",'Safi'),
(2053, " . $new_language_id . ",'San Giljan'),
(2054, " . $new_language_id . ",'De Santa Lucija'),
(2055, " . $new_language_id . ",'San Pawl il-Bahar'),
(2056, " . $new_language_id . ",'San Gwann'),
(2057, " . $new_language_id . ",'Santa Venera'),
(2058, " . $new_language_id . ",'Siggiewi'),
(2059, " . $new_language_id . ",'Sliema'),
(2060, " . $new_language_id . ",'Swieqi'),
(2061, " . $new_language_id . ",'Ta Xbiex'),
(2062, " . $new_language_id . ",'Tarxien'),
(2063, " . $new_language_id . ",'Valletta'),
(2064, " . $new_language_id . ",'Xgajra'),
(2065, " . $new_language_id . ",'Zabbar'),
(2066, " . $new_language_id . ",'Zebbug'),
(2067, " . $new_language_id . ",'Zejtun'),
(2068, " . $new_language_id . ",'Zurrieq'),
(2069, " . $new_language_id . ",'Fontana'),
(2070, " . $new_language_id . ",'Ghajnsielem'),
(2071, " . $new_language_id . ",'Gharb'),
(2072, " . $new_language_id . ",'Ghasri'),
(2073, " . $new_language_id . ",'Kercem'),
(2074, " . $new_language_id . ",'Munxar'),
(2075, " . $new_language_id . ",'Nadur'),
(2076, " . $new_language_id . ",'Qala'),
(2077, " . $new_language_id . ",'Victoria'),
(2078, " . $new_language_id . ",'San Lawrenz'),
(2079, " . $new_language_id . ",'Sannat'),
(2080, " . $new_language_id . ",'Xagra'),
(2081, " . $new_language_id . ",'Xewkija'),
(2082, " . $new_language_id . ",'Zebbug'),
(2083, " . $new_language_id . ",'Ailinginae'),
(2084, " . $new_language_id . ",'Ailinglaplap'),
(2085, " . $new_language_id . ",'Ailuk'),
(2086, " . $new_language_id . ",'Arno'),
(2087, " . $new_language_id . ",'Aur'),
(2088, " . $new_language_id . ",'Bikar'),
(2089, " . $new_language_id . ",'Bikini'),
(2090, " . $new_language_id . ",'Bokak'),
(2091, " . $new_language_id . ",'De ébano'),
(2092, " . $new_language_id . ",'Enewetak'),
(2093, " . $new_language_id . ",'Erikub'),
(2094, " . $new_language_id . ",'Jabat'),
(2095, " . $new_language_id . ",'Jaluit'),
(2096, " . $new_language_id . ",'Jemo'),
(2097, " . $new_language_id . ",'Kili'),
(2098, " . $new_language_id . ",'Kwajalein'),
(2099, " . $new_language_id . ",'Lae'),
(2100, " . $new_language_id . ",'Lib'),
(2101, " . $new_language_id . ",'Likiep'),
(2102, " . $new_language_id . ",'Majuro'),
(2103, " . $new_language_id . ",'Maloelap'),
(2104, " . $new_language_id . ",'Mejit'),
(2105, " . $new_language_id . ",'Mili'),
(2106, " . $new_language_id . ",'Namorik'),
(2107, " . $new_language_id . ",'Namu'),
(2108, " . $new_language_id . ",'Rongelap'),
(2109, " . $new_language_id . ",'Rongrik'),
(2110, " . $new_language_id . ",'Toke'),
(2111, " . $new_language_id . ",'Ujae'),
(2112, " . $new_language_id . ",'Ujelang'),
(2113, " . $new_language_id . ",'Utirik'),
(2114, " . $new_language_id . ",'Wotho'),
(2115, " . $new_language_id . ",'Wotje'),
(2116, " . $new_language_id . ",'Adrar'),
(2117, " . $new_language_id . ",'Assaba'),
(2118, " . $new_language_id . ",'Brakna'),
(2119, " . $new_language_id . ",'Dakhlet Nouadhibou'),
(2120, " . $new_language_id . ",'Gorgol'),
(2121, " . $new_language_id . ",'Guidimaka'),
(2122, " . $new_language_id . ",'Hodh Ech Chargui'),
(2123, " . $new_language_id . ",'Hodh El Gharbi'),
(2124, " . $new_language_id . ",'Inchiri'),
(2125, " . $new_language_id . ",'Tagant'),
(2126, " . $new_language_id . ",'Tiris Zemmour'),
(2127, " . $new_language_id . ",'Trarza'),
(2128, " . $new_language_id . ",'Nouakchott'),
(2129, " . $new_language_id . ",'Beau Bassin-Rose Hill'),
(2130, " . $new_language_id . ",'Curepipe'),
(2131, " . $new_language_id . ",'Port Louis'),
(2132, " . $new_language_id . ",'Quatre Bornes'),
(2133, " . $new_language_id . ",'Vacoas-Phoenix'),
(2134, " . $new_language_id . ",'Islas Agalega'),
(2135, " . $new_language_id . ",'Cargados Carajos Shoals (islas San Brandon)'),
(2136, " . $new_language_id . ",'Rodrigues'),
(2137, " . $new_language_id . ",'Río Negro'),
(2138, " . $new_language_id . ",'Flacq'),
(2139, " . $new_language_id . ",'Grand Port'),
(2140, " . $new_language_id . ",'Moka'),
(2141, " . $new_language_id . ",'Pamplemousses'),
(2142, " . $new_language_id . ",'Plaines Wilhems'),
(2143, " . $new_language_id . ",'Port Louis'),
(2144, " . $new_language_id . ",'Riviere du Rempart'),
(2145, " . $new_language_id . ",'Savanne'),
(2146, " . $new_language_id . ",'Baja California Norte'),
(2147, " . $new_language_id . ",'Baja California Sur'),
(2148, " . $new_language_id . ",'Campeche'),
(2149, " . $new_language_id . ",'Chiapas'),
(2150, " . $new_language_id . ",'Chihuahua'),
(2151, " . $new_language_id . ",'Coahuila de Zaragoza'),
(2152, " . $new_language_id . ",'Colima'),
(2153, " . $new_language_id . ",'Distrito Federal'),
(2154, " . $new_language_id . ",'Durango'),
(2155, " . $new_language_id . ",'Guanajuato'),
(2156, " . $new_language_id . ",'Guerrero'),
(2157, " . $new_language_id . ",'Hidalgo'),
(2158, " . $new_language_id . ",'Jalisco'),
(2159, " . $new_language_id . ",'México'),
(2160, " . $new_language_id . ",'Michoacán de Ocampo'),
(2161, " . $new_language_id . ",'Morelos'),
(2162, " . $new_language_id . ",'Nayarit'),
(2163, " . $new_language_id . ",'Nuevo León'),
(2164, " . $new_language_id . ",'Oaxaca'),
(2165, " . $new_language_id . ",'Puebla'),
(2166, " . $new_language_id . ",'Querétaro de Arteaga'),
(2167, " . $new_language_id . ",'Quintana Roo'),
(2168, " . $new_language_id . ",'San Luis Potosí'),
(2169, " . $new_language_id . ",'Sinaloa'),
(2170, " . $new_language_id . ",'Sonora'),
(2171, " . $new_language_id . ",'Tabasco'),
(2172, " . $new_language_id . ",'Tamaulipas'),
(2173, " . $new_language_id . ",'Tlaxcala'),
(2174, " . $new_language_id . ",'Veracruz-Llave'),
(2175, " . $new_language_id . ",'Yucatán'),
(2176, " . $new_language_id . ",'Zacatecas'),
(2177, " . $new_language_id . ",'Chuuk'),
(2178, " . $new_language_id . ",'Kosrae'),
(2179, " . $new_language_id . ",'Pohnpei'),
(2180, " . $new_language_id . ",'Ladrido'),
(2181, " . $new_language_id . ",'Gagauzia'),
(2182, " . $new_language_id . ",'Chisinau'),
(2183, " . $new_language_id . ",'Balti'),
(2184, " . $new_language_id . ",'Cahul'),
(2185, " . $new_language_id . ",'Edinet'),
(2186, " . $new_language_id . ",'Lapusna'),
(2187, " . $new_language_id . ",'Orhei'),
(2188, " . $new_language_id . ",'Soroca'),
(2189, " . $new_language_id . ",'Tighina'),
(2190, " . $new_language_id . ",'Ungheni'),
(2191, " . $new_language_id . ",'St, nga Nistrului'),
(2192, " . $new_language_id . ",'Fontvieille'),
(2193, " . $new_language_id . ",'La Condamine'),
(2194, " . $new_language_id . ",'Monaco-Ville'),
(2195, " . $new_language_id . ",'Monte-Carlo'),
(2196, " . $new_language_id . ",'Ulanbaatar'),
(2197, " . $new_language_id . ",'Orhon'),
(2198, " . $new_language_id . ",'Darhan Uul'),
(2199, " . $new_language_id . ",'Hentiy'),
(2200, " . $new_language_id . ",'Hovsgol'),
(2201, " . $new_language_id . ",'Hovd'),
(2202, " . $new_language_id . ",'Uvs'),
(2203, " . $new_language_id . ",'Tov'),
(2204, " . $new_language_id . ",'Selenge'),
(2205, " . $new_language_id . ",'Suhbaatar'),
(2206, " . $new_language_id . ",'Omnogovi'),
(2207, " . $new_language_id . ",'Ovorhangay'),
(2208, " . $new_language_id . ",'Dzavhan'),
(2209, " . $new_language_id . ",'DundgovL'),
(2210, " . $new_language_id . ",'Dornod'),
(2211, " . $new_language_id . ",'Dornogov'),
(2212, " . $new_language_id . ",'Govi-Sumber'),
(2213, " . $new_language_id . ",'Govi-Altay'),
(2214, " . $new_language_id . ",'Bulgan'),
(2215, " . $new_language_id . ",'Bayanhongor'),
(2216, " . $new_language_id . ",'Bayan-Olgiy'),
(2217, " . $new_language_id . ",'Arhangay'),
(2218, " . $new_language_id . ",'San Antonio'),
(2219, " . $new_language_id . ",'Saint Georges'),
(2220, " . $new_language_id . ",'San Pedro'),
(2221, " . $new_language_id . ",'Agadir'),
(2222, " . $new_language_id . ",'Al Hoceima'),
(2223, " . $new_language_id . ",'Azilal'),
(2224, " . $new_language_id . ",'Beni Mellal'),
(2225, " . $new_language_id . ",'Ben Slimane'),
(2226, " . $new_language_id . ",'Boulemane'),
(2227, " . $new_language_id . ",'Casablanca'),
(2228, " . $new_language_id . ",'Chaouen'),
(2229, " . $new_language_id . ",'El Jadida'),
(2230, " . $new_language_id . ",'El Kelaa des Sraghna'),
(2231, " . $new_language_id . ",'Er Rachidia'),
(2232, " . $new_language_id . ",'Essaouira'),
(2233, " . $new_language_id . ",'Fes'),
(2234, " . $new_language_id . ",'Figuig'),
(2235, " . $new_language_id . ",'Guelmim'),
(2236, " . $new_language_id . ",'Ifrane'),
(2237, " . $new_language_id . ",'Kenitra'),
(2238, " . $new_language_id . ",'Khemisset'),
(2239, " . $new_language_id . ",'Khenifra'),
(2240, " . $new_language_id . ",'Khouribga'),
(2241, " . $new_language_id . ",'Laayoune'),
(2242, " . $new_language_id . ",'Larache'),
(2243, " . $new_language_id . ",'Marrakech'),
(2244, " . $new_language_id . ",'Meknes'),
(2245, " . $new_language_id . ",'Nador'),
(2246, " . $new_language_id . ",'Ouarzazate'),
(2247, " . $new_language_id . ",'Oujda'),
(2248, " . $new_language_id . ",'Rabat-Salé'),
(2249, " . $new_language_id . ",'Safi'),
(2250, " . $new_language_id . ",'Settat'),
(2251, " . $new_language_id . ",'Sidi Kacem'),
(2252, " . $new_language_id . ",'Tánger'),
(2253, " . $new_language_id . ",'Tan-Tan'),
(2254, " . $new_language_id . ",'Taounate'),
(2255, " . $new_language_id . ",'Taroudannt'),
(2256, " . $new_language_id . ",'Tata'),
(2257, " . $new_language_id . ",'Taza'),
(2258, " . $new_language_id . ",'Tetuán'),
(2259, " . $new_language_id . ",'Tiznit'),
(2260, " . $new_language_id . ",'Ad Dakhla'),
(2261, " . $new_language_id . ",'Bojador'),
(2262, " . $new_language_id . ",'Es Smara'),
(2263, " . $new_language_id . ",'Cabo Delgado'),
(2264, " . $new_language_id . ",'Gaza'),
(2265, " . $new_language_id . ",'Inhambane'),
(2266, " . $new_language_id . ",'Manica'),
(2267, " . $new_language_id . ",'Maputo (ciudad)'),
(2268, " . $new_language_id . ",'Maputo'),
(2269, " . $new_language_id . ",'Nampula'),
(2270, " . $new_language_id . ",'Niassa'),
(2271, " . $new_language_id . ",'Sofala'),
(2272, " . $new_language_id . ",'Tete'),
(2273, " . $new_language_id . ",'Zambezia'),
(2274, " . $new_language_id . ",'Ayeyarwady'),
(2275, " . $new_language_id . ",'Bago'),
(2276, " . $new_language_id . ",'Magway'),
(2277, " . $new_language_id . ",'Mandalay'),
(2278, " . $new_language_id . ",'Sagaing'),
(2279, " . $new_language_id . ",'Tanintharyi'),
(2280, " . $new_language_id . ",'Yangon'),
(2281, " . $new_language_id . ",'El estado de Chin'),
(2282, " . $new_language_id . ",'Estado de Kachin'),
(2283, " . $new_language_id . ",'Kayah'),
(2284, " . $new_language_id . ",'Estado de Kayin'),
(2285, " . $new_language_id . ",'El estado de Mon'),
(2286, " . $new_language_id . ",'Estado de Rakhine'),
(2287, " . $new_language_id . ",'Shan State'),
(2288, " . $new_language_id . ",'Caprivi'),
(2289, " . $new_language_id . ",'Erongo'),
(2290, " . $new_language_id . ",'Hardap'),
(2291, " . $new_language_id . ",'Karas'),
(2292, " . $new_language_id . ",'Kavango'),
(2293, " . $new_language_id . ",'Khomas'),
(2294, " . $new_language_id . ",'Kunene'),
(2295, " . $new_language_id . ",'Ohangwena'),
(2296, " . $new_language_id . ",'Omaheke'),
(2297, " . $new_language_id . ",'Omusati'),
(2298, " . $new_language_id . ",'Oshana'),
(2299, " . $new_language_id . ",'Oshikoto'),
(2300, " . $new_language_id . ",'Otjozondjupa'),
(2301, " . $new_language_id . ",'Aiwo'),
(2302, " . $new_language_id . ",'Anabar'),
(2303, " . $new_language_id . ",'Anetan'),
(2304, " . $new_language_id . ",'Anibare'),
(2305, " . $new_language_id . ",'Baiti'),
(2306, " . $new_language_id . ",'Boe'),
(2307, " . $new_language_id . ",'Buada'),
(2308, " . $new_language_id . ",'Denigomodu'),
(2309, " . $new_language_id . ",'Ewa'),
(2310, " . $new_language_id . ",'Ijuw'),
(2311, " . $new_language_id . ",'Meneng'),
(2312, " . $new_language_id . ",'Nibok'),
(2313, " . $new_language_id . ",'Uaboe'),
(2314, " . $new_language_id . ",'Yaren'),
(2315, " . $new_language_id . ",'Bagmati'),
(2316, " . $new_language_id . ",'Bheri'),
(2317, " . $new_language_id . ",'Dhawalagiri'),
(2318, " . $new_language_id . ",'Gandaki'),
(2319, " . $new_language_id . ",'Janakpur'),
(2320, " . $new_language_id . ",'Karnali'),
(2321, " . $new_language_id . ",'Kosi'),
(2322, " . $new_language_id . ",'Lumbini'),
(2323, " . $new_language_id . ",'Mahakali'),
(2324, " . $new_language_id . ",'Mechi'),
(2325, " . $new_language_id . ",'Narayani'),
(2326, " . $new_language_id . ",'Rapti'),
(2327, " . $new_language_id . ",'Sagarmatha'),
(2328, " . $new_language_id . ",'Seti'),
(2329, " . $new_language_id . ",'Drenthe'),
(2330, " . $new_language_id . ",'Flevoland'),
(2331, " . $new_language_id . ",'Friesland'),
(2332, " . $new_language_id . ",'Gelderland'),
(2333, " . $new_language_id . ",'Groningen'),
(2334, " . $new_language_id . ",'Limburg'),
(2335, " . $new_language_id . ",'Noord Brabant'),
(2336, " . $new_language_id . ",'Noord Holland'),
(2337, " . $new_language_id . ",'Overijssel'),
(2338, " . $new_language_id . ",'Utrecht'),
(2339, " . $new_language_id . ",'Zeeland'),
(2340, " . $new_language_id . ",'Zuid Holland'),
(2341, " . $new_language_id . ",'Iles Loyaute'),
(2342, " . $new_language_id . ",'Nord'),
(2343, " . $new_language_id . ",'Sud'),
(2344, " . $new_language_id . ",'Auckland'),
(2345, " . $new_language_id . ",'Bay of Plenty'),
(2346, " . $new_language_id . ",'Canterbury'),
(2347, " . $new_language_id . ",'Coromandel'),
(2348, " . $new_language_id . ",'Gisborne'),
(2349, " . $new_language_id . ",'Fiordland'),
(2350, " . $new_language_id . ",'Bahía de Hawke'),
(2351, " . $new_language_id . ",'Marlborough'),
(2352, " . $new_language_id . ",'Manawatu-Wanganui'),
(2353, " . $new_language_id . ",'Mt Cook-Mackenzie'),
(2354, " . $new_language_id . ",'Nelson'),
(2355, " . $new_language_id . ",'Región septentrional'),
(2356, " . $new_language_id . ",'Otago'),
(2357, " . $new_language_id . ",'Southland'),
(2358, " . $new_language_id . ",'Taranaki'),
(2359, " . $new_language_id . ",'Wellington'),
(2360, " . $new_language_id . ",'Waikato'),
(2361, " . $new_language_id . ",'Wairprarapa'),
(2362, " . $new_language_id . ",'Costa Oeste'),
(2363, " . $new_language_id . ",'Atlantico Norte'),
(2364, " . $new_language_id . ",'Atlantico Sur'),
(2365, " . $new_language_id . ",'Boaco'),
(2366, " . $new_language_id . ",'Carazo'),
(2367, " . $new_language_id . ",'Chinandega'),
(2368, " . $new_language_id . ",'Chontales'),
(2369, " . $new_language_id . ",'Esteli'),
(2370, " . $new_language_id . ",'Granada'),
(2371, " . $new_language_id . ",'Jinotega'),
(2372, " . $new_language_id . ",'León'),
(2373, " . $new_language_id . ",'Madriz'),
(2374, " . $new_language_id . ",'Managua'),
(2375, " . $new_language_id . ",'Masaya'),
(2376, " . $new_language_id . ",'Matagalpa'),
(2377, " . $new_language_id . ",'Nuevo Segovia'),
(2378, " . $new_language_id . ",'Rio San Juan'),
(2379, " . $new_language_id . ",'Rivas'),
(2380, " . $new_language_id . ",'Agadez'),
(2381, " . $new_language_id . ",'Diffa'),
(2382, " . $new_language_id . ",'Dosso'),
(2383, " . $new_language_id . ",'Maradi'),
(2384, " . $new_language_id . ",'Niamey'),
(2385, " . $new_language_id . ",'Tahoua'),
(2386, " . $new_language_id . ",'Tillabéri'),
(2387, " . $new_language_id . ",'Zinder'),
(2388, " . $new_language_id . ",'Abia'),
(2389, " . $new_language_id . ",'Abuja Federal Capital Territory'),
(2390, " . $new_language_id . ",'Adamawa'),
(2391, " . $new_language_id . ",'Akwa Ibom'),
(2392, " . $new_language_id . ",'Anambra'),
(2393, " . $new_language_id . ",'Bauchi'),
(2394, " . $new_language_id . ",'Bayelsa'),
(2395, " . $new_language_id . ",'Benue'),
(2396, " . $new_language_id . ",'Borno'),
(2397, " . $new_language_id . ",'Cross River'),
(2398, " . $new_language_id . ",'Delta'),
(2399, " . $new_language_id . ",'Ebonyi'),
(2400, " . $new_language_id . ",'Edo'),
(2401, " . $new_language_id . ",'Ekiti'),
(2402, " . $new_language_id . ",'Enugu'),
(2403, " . $new_language_id . ",'Gombe'),
(2404, " . $new_language_id . ",'Imo'),
(2405, " . $new_language_id . ",'Jigawa'),
(2406, " . $new_language_id . ",'Kaduna'),
(2407, " . $new_language_id . ",'Kano'),
(2408, " . $new_language_id . ",'Katsina'),
(2409, " . $new_language_id . ",'Kebbi'),
(2410, " . $new_language_id . ",'Kogi'),
(2411, " . $new_language_id . ",'Kwara'),
(2412, " . $new_language_id . ",'Lagos'),
(2413, " . $new_language_id . ",'Nassarawa'),
(2414, " . $new_language_id . ",'Níger'),
(2415, " . $new_language_id . ",'Ogun'),
(2416, " . $new_language_id . ",'Ondo'),
(2417, " . $new_language_id . ",'Osun'),
(2418, " . $new_language_id . ",'Oyo'),
(2419, " . $new_language_id . ",'Meseta'),
(2420, " . $new_language_id . ",'Ríos'),
(2421, " . $new_language_id . ",'Sokoto'),
(2422, " . $new_language_id . ",'Taraba'),
(2423, " . $new_language_id . ",'Yobe'),
(2424, " . $new_language_id . ",'Zamfara'),
(2425, " . $new_language_id . ",'Islas del Norte'),
(2426, " . $new_language_id . ",'Nómina'),
(2427, " . $new_language_id . ",'Saipan'),
(2428, " . $new_language_id . ",'Tinian'),
(2429, " . $new_language_id . ",'Akershus'),
(2430, " . $new_language_id . ",'Aust-Agder'),
(2431, " . $new_language_id . ",'Buskerud'),
(2432, " . $new_language_id . ",'Finnmark'),
(2433, " . $new_language_id . ",'Hedmark'),
(2434, " . $new_language_id . ",'Hordaland'),
(2435, " . $new_language_id . ",'Más og Romdal'),
(2436, " . $new_language_id . ",'Nord-Trondelag'),
(2437, " . $new_language_id . ",'Nordland'),
(2438, " . $new_language_id . ",'Ostfold'),
(2439, " . $new_language_id . ",'Oppland'),
(2440, " . $new_language_id . ",'Oslo'),
(2441, " . $new_language_id . ",'Rogaland'),
(2442, " . $new_language_id . ",'Sor-Trondelag'),
(2443, " . $new_language_id . ",'Sogn og Fjordane'),
(2444, " . $new_language_id . ",'Svalbard'),
(2445, " . $new_language_id . ",'Telemark'),
(2446, " . $new_language_id . ",'Troms'),
(2447, " . $new_language_id . ",'Vest-Agder'),
(2448, " . $new_language_id . ",'Vestfold'),
(2449, " . $new_language_id . ",'Dakhiliyah'),
(2450, " . $new_language_id . ",'Al Batinah'),
(2451, " . $new_language_id . ",'Al Wusta'),
(2452, " . $new_language_id . ",'Ash Sharqiyah'),
(2453, " . $new_language_id . ",'Az Zahirah'),
(2454, " . $new_language_id . ",'Masqat'),
(2455, " . $new_language_id . ",'Musandam'),
(2456, " . $new_language_id . ",'Zufar'),
(2457, " . $new_language_id . ",'Baluchistán'),
(2458, " . $new_language_id . ",'Áreas Tribales bajo Administración Federal'),
(2459, " . $new_language_id . ",'Territorio Capital de Islamabad'),
(2460, " . $new_language_id . ",'North-West Frontier'),
(2461, " . $new_language_id . ",'Punjab'),
(2462, " . $new_language_id . ",'Sindh'),
(2463, " . $new_language_id . ",'Aimeliik'),
(2464, " . $new_language_id . ",'Airai'),
(2465, " . $new_language_id . ",'Angaur'),
(2466, " . $new_language_id . ",'Hatohobei'),
(2467, " . $new_language_id . ",'Kayangel'),
(2468, " . $new_language_id . ",'Koror'),
(2469, " . $new_language_id . ",'Melekeok'),
(2470, " . $new_language_id . ",'Ngaraard'),
(2471, " . $new_language_id . ",'Ngarchelong'),
(2472, " . $new_language_id . ",'Ngardmau'),
(2473, " . $new_language_id . ",'Ngatpang'),
(2474, " . $new_language_id . ",'Ngchesar'),
(2475, " . $new_language_id . ",'Ngeremlengui'),
(2476, " . $new_language_id . ",'Ngiwal'),
(2477, " . $new_language_id . ",'Peleliu'),
(2478, " . $new_language_id . ",'Sonsorol'),
(2479, " . $new_language_id . ",'Bocas del Toro'),
(2480, " . $new_language_id . ",'Chiriqui'),
(2481, " . $new_language_id . ",'Coclé'),
(2482, " . $new_language_id . ",'Colon'),
(2483, " . $new_language_id . ",'Darien'),
(2484, " . $new_language_id . ",'Herrera'),
(2485, " . $new_language_id . ",'Los Santos'),
(2486, " . $new_language_id . ",'Panamá'),
(2487, " . $new_language_id . ",'San Blas'),
(2488, " . $new_language_id . ",'Veraguas'),
(2489, " . $new_language_id . ",'Bougainville'),
(2490, " . $new_language_id . ",'Central'),
(2491, " . $new_language_id . ",'Chimbu'),
(2492, " . $new_language_id . ",'Montañas del este'),
(2493, " . $new_language_id . ",'Nueva Bretaña del Este'),
(2494, " . $new_language_id . ",'East Sepik'),
(2495, " . $new_language_id . ",'Enga'),
(2496, " . $new_language_id . ",'Golfo'),
(2497, " . $new_language_id . ",'Madang'),
(2498, " . $new_language_id . ",'Manus'),
(2499, " . $new_language_id . ",'Milne Bay'),
(2500, " . $new_language_id . ",'Morobe'),
(2501, " . $new_language_id . ",'Capital Nacional'),
(2502, " . $new_language_id . ",'Nueva Irlanda'),
(2503, " . $new_language_id . ",'Del norte'),
(2504, " . $new_language_id . ",'Sandaun'),
(2505, " . $new_language_id . ",'Sierra Sur'),
(2506, " . $new_language_id . ",'Occidental'),
(2507, " . $new_language_id . ",'Western Highlands'),
(2508, " . $new_language_id . ",'West New Britain'),
(2509, " . $new_language_id . ",'Alto Paraguay'),
(2510, " . $new_language_id . ",'Alto Paraná'),
(2511, " . $new_language_id . ",'Amambay'),
(2512, " . $new_language_id . ",'Asunción'),
(2513, " . $new_language_id . ",'Boquerón'),
(2514, " . $new_language_id . ",'Caaguazu'),
(2515, " . $new_language_id . ",'Caazapá'),
(2516, " . $new_language_id . ",'Canindeyú'),
(2517, " . $new_language_id . ",'Central'),
(2518, " . $new_language_id . ",'Concepcion'),
(2519, " . $new_language_id . ",'Cordillera'),
(2520, " . $new_language_id . ",'Guaira'),
(2521, " . $new_language_id . ",'Itapua'),
(2522, " . $new_language_id . ",'Misiones'),
(2523, " . $new_language_id . ",'Ñeembucú'),
(2524, " . $new_language_id . ",'Paraguari'),
(2525, " . $new_language_id . ",'Presidente Hayes'),
(2526, " . $new_language_id . ",'San Pedro'),
(2527, " . $new_language_id . ",'Amazonas'),
(2528, " . $new_language_id . ",'Ancash'),
(2529, " . $new_language_id . ",'Apurimac'),
(2530, " . $new_language_id . ",'Arequipa'),
(2531, " . $new_language_id . ",'Ayacucho'),
(2532, " . $new_language_id . ",'Cajamarca'),
(2533, " . $new_language_id . ",'Callao'),
(2534, " . $new_language_id . ",'Cusco'),
(2535, " . $new_language_id . ",'Huancavelica'),
(2536, " . $new_language_id . ",'Huanuco'),
(2537, " . $new_language_id . ",'Ica'),
(2538, " . $new_language_id . ",'Junin'),
(2539, " . $new_language_id . ",'La Libertad'),
(2540, " . $new_language_id . ",'Lambayeque'),
(2541, " . $new_language_id . ",'Lima'),
(2542, " . $new_language_id . ",'Loreto'),
(2543, " . $new_language_id . ",'Madre de Dios'),
(2544, " . $new_language_id . ",'Moquegua'),
(2545, " . $new_language_id . ",'Pasco'),
(2546, " . $new_language_id . ",'Piura'),
(2547, " . $new_language_id . ",'Puno'),
(2548, " . $new_language_id . ",'San Martin'),
(2549, " . $new_language_id . ",'Tacna'),
(2550, " . $new_language_id . ",'Tumbes'),
(2551, " . $new_language_id . ",'Ucayali'),
(2552, " . $new_language_id . ",'Abra'),
(2553, " . $new_language_id . ",'Agusan del Norte'),
(2554, " . $new_language_id . ",'Agusan del Sur'),
(2555, " . $new_language_id . ",'Aklan'),
(2556, " . $new_language_id . ",'Albay'),
(2557, " . $new_language_id . ",'Antiguo'),
(2558, " . $new_language_id . ",'Apayao'),
(2559, " . $new_language_id . ",'Aurora'),
(2560, " . $new_language_id . ",'Basilan'),
(2561, " . $new_language_id . ",'Bataan'),
(2562, " . $new_language_id . ",'Batanes'),
(2563, " . $new_language_id . ",'Batangas'),
(2564, " . $new_language_id . ",'Biliran'),
(2565, " . $new_language_id . ",'Benguet'),
(2566, " . $new_language_id . ",'Bohol'),
(2567, " . $new_language_id . ",'Bukidnon'),
(2568, " . $new_language_id . ",'Bulacan'),
(2569, " . $new_language_id . ",'Cagayan'),
(2570, " . $new_language_id . ",'Camarines Norte'),
(2571, " . $new_language_id . ",'Camarines Sur'),
(2572, " . $new_language_id . ",'Camiguin'),
(2573, " . $new_language_id . ",'Capiz'),
(2574, " . $new_language_id . ",'Catanduanes'),
(2575, " . $new_language_id . ",'Cavite'),
(2576, " . $new_language_id . ",'Cebu'),
(2577, " . $new_language_id . ",'Compostela'),
(2578, " . $new_language_id . ",'Davao del Norte'),
(2579, " . $new_language_id . ",'Davao del Sur'),
(2580, " . $new_language_id . ",'Davao Oriental'),
(2581, " . $new_language_id . ",'Eastern Samar'),
(2582, " . $new_language_id . ",'Guimaras'),
(2583, " . $new_language_id . ",'Ifugao'),
(2584, " . $new_language_id . ",'Ilocos Norte'),
(2585, " . $new_language_id . ",'Ilocos Sur'),
(2586, " . $new_language_id . ",'Iloilo'),
(2587, " . $new_language_id . ",'Isabela'),
(2588, " . $new_language_id . ",'Kalinga'),
(2589, " . $new_language_id . ",'Laguna'),
(2590, " . $new_language_id . ",'Lanao del Norte'),
(2591, " . $new_language_id . ",'Lanao del Sur'),
(2592, " . $new_language_id . ",'La Unión'),
(2593, " . $new_language_id . ",'Leyte'),
(2594, " . $new_language_id . ",'Maguindanao'),
(2595, " . $new_language_id . ",'Marinduque'),
(2596, " . $new_language_id . ",'Masbate'),
(2597, " . $new_language_id . ",'Mindoro Occidental'),
(2598, " . $new_language_id . ",'Mindoro Oriental'),
(2599, " . $new_language_id . ",'Misamis Occidental'),
(2600, " . $new_language_id . ",'Misamis Oriental'),
(2601, " . $new_language_id . ",'Montaña'),
(2602, " . $new_language_id . ",'Negros Occidental'),
(2603, " . $new_language_id . ",'Negros Oriental'),
(2604, " . $new_language_id . ",'Cotabato del Norte'),
(2605, " . $new_language_id . ",'Northern Samar'),
(2606, " . $new_language_id . ",'Nueva Ecija'),
(2607, " . $new_language_id . ",'Nueva Vizcaya'),
(2608, " . $new_language_id . ",'Palawan'),
(2609, " . $new_language_id . ",'Pampanga'),
(2610, " . $new_language_id . ",'Pangasinan'),
(2611, " . $new_language_id . ",'Quezon'),
(2612, " . $new_language_id . ",'Quirino'),
(2613, " . $new_language_id . ",'Rizal'),
(2614, " . $new_language_id . ",'Romblon'),
(2615, " . $new_language_id . ",'Samar'),
(2616, " . $new_language_id . ",'Sarangani'),
(2617, " . $new_language_id . ",'Siquijor'),
(2618, " . $new_language_id . ",'Sorsogon'),
(2619, " . $new_language_id . ",'South Cotabato'),
(2620, " . $new_language_id . ",'Southern Leyte'),
(2621, " . $new_language_id . ",'Sultan Kudarat'),
(2622, " . $new_language_id . ",'Sulu'),
(2623, " . $new_language_id . ",'Surigao del Norte'),
(2624, " . $new_language_id . ",'Surigao del Sur'),
(2625, " . $new_language_id . ",'Tarlac'),
(2626, " . $new_language_id . ",'Tawi-Tawi'),
(2627, " . $new_language_id . ",'Zambales'),
(2628, " . $new_language_id . ",'Zamboanga del Norte'),
(2629, " . $new_language_id . ",'Zamboanga del Sur'),
(2630, " . $new_language_id . ",'Zamboanga Sibugay'),
(2631, " . $new_language_id . ",'Dolnoslaskie'),
(2632, " . $new_language_id . ",'Kujawsko-Pomorskie'),
(2633, " . $new_language_id . ",'Lodzkie'),
(2634, " . $new_language_id . ",'Lubelskie'),
(2635, " . $new_language_id . ",'Lubuskie'),
(2636, " . $new_language_id . ",'Malopolskie'),
(2637, " . $new_language_id . ",'Mazowieckie'),
(2638, " . $new_language_id . ",'Opolskie'),
(2639, " . $new_language_id . ",'Podkarpackie'),
(2640, " . $new_language_id . ",'Podlaskie'),
(2641, " . $new_language_id . ",'Pomorskie'),
(2642, " . $new_language_id . ",'Slaskie'),
(2643, " . $new_language_id . ",'Swietokrzyskie'),
(2644, " . $new_language_id . ",'Warminsko-Mazurskie'),
(2645, " . $new_language_id . ",'Wielkopolskie'),
(2646, " . $new_language_id . ",'Zachodniopomorskie'),
(2647, " . $new_language_id . ",'Saint-Pierre'),
(2648, " . $new_language_id . ",'Miguelón'),
(2649, " . $new_language_id . ",'Açores'),
(2650, " . $new_language_id . ",'Aveiro'),
(2651, " . $new_language_id . ",'Beja'),
(2652, " . $new_language_id . ",'Braga'),
(2653, " . $new_language_id . ",'Bragança'),
(2654, " . $new_language_id . ",'Castelo Branco'),
(2655, " . $new_language_id . ",'Coimbra'),
(2656, " . $new_language_id . ",'Évora'),
(2657, " . $new_language_id . ",'Faraón'),
(2658, " . $new_language_id . ",'Guarda'),
(2659, " . $new_language_id . ",'Leiria'),
(2660, " . $new_language_id . ",'Lisboa'),
(2661, " . $new_language_id . ",'Madeira'),
(2662, " . $new_language_id . ",'Portalegre'),
(2663, " . $new_language_id . ",'Porto'),
(2664, " . $new_language_id . ",'Santarém'),
(2665, " . $new_language_id . ",'Setúbal'),
(2666, " . $new_language_id . ",'Viana do Castelo'),
(2667, " . $new_language_id . ",'Vila Real'),
(2668, " . $new_language_id . ",'Viseu'),
(2669, " . $new_language_id . ",'Ad Dawhah'),
(2670, " . $new_language_id . ",'Al Ghuwayriyah'),
(2671, " . $new_language_id . ",'Al Jumayliyah'),
(2672, " . $new_language_id . ",'Al Khawr'),
(2673, " . $new_language_id . ",'Al Wakrah'),
(2674, " . $new_language_id . ",'Ar Rayyan'),
(2675, " . $new_language_id . ",'Jarayan al Batinah'),
(2676, " . $new_language_id . ",'Madinat ash Shamal'),
(2677, " . $new_language_id . ",'Umm Sa&#39;id'),
(2678, " . $new_language_id . ",'Umm Salal'),
(2679, " . $new_language_id . ",'Alba'),
(2680, " . $new_language_id . ",'Arad'),
(2681, " . $new_language_id . ",'Arges'),
(2682, " . $new_language_id . ",'Bacau'),
(2683, " . $new_language_id . ",'Bihor'),
(2684, " . $new_language_id . ",'Bistrita-Nasaud'),
(2685, " . $new_language_id . ",'Botosani'),
(2686, " . $new_language_id . ",'Brasov'),
(2687, " . $new_language_id . ",'Braila'),
(2688, " . $new_language_id . ",'Bucuresti'),
(2689, " . $new_language_id . ",'Buzau'),
(2690, " . $new_language_id . ",'Caras-Severin'),
(2691, " . $new_language_id . ",'Calarasi'),
(2692, " . $new_language_id . ",'Cluj'),
(2693, " . $new_language_id . ",'Constanta'),
(2694, " . $new_language_id . ",'Covasna'),
(2695, " . $new_language_id . ",'Dimbovita'),
(2696, " . $new_language_id . ",'Dolj'),
(2697, " . $new_language_id . ",'Galati'),
(2698, " . $new_language_id . ",'Giurgiu'),
(2699, " . $new_language_id . ",'Gorj'),
(2700, " . $new_language_id . ",'Harghita'),
(2701, " . $new_language_id . ",'Hunedoara'),
(2702, " . $new_language_id . ",'Ialomita'),
(2703, " . $new_language_id . ",'Iasi'),
(2704, " . $new_language_id . ",'Ilfov'),
(2705, " . $new_language_id . ",'Maramures'),
(2706, " . $new_language_id . ",'Mehedinti'),
(2707, " . $new_language_id . ",'Mures'),
(2708, " . $new_language_id . ",'Neamt'),
(2709, " . $new_language_id . ",'Olt'),
(2710, " . $new_language_id . ",'Prahova'),
(2711, " . $new_language_id . ",'Satu Mare'),
(2712, " . $new_language_id . ",'Salaj'),
(2713, " . $new_language_id . ",'Sibiu'),
(2714, " . $new_language_id . ",'Suceava'),
(2715, " . $new_language_id . ",'Teleorman'),
(2716, " . $new_language_id . ",'Timis'),
(2717, " . $new_language_id . ",'Tulcea'),
(2718, " . $new_language_id . ",'Vaslui'),
(2719, " . $new_language_id . ",'Valcea'),
(2720, " . $new_language_id . ",'Vrancea'),
(2721, " . $new_language_id . ",'Republic of Khakassia'),
(2722, " . $new_language_id . ",'Aginsky Buryatsky AO'),
(2723, " . $new_language_id . ",'Chukotka Autonomous Okrug'),
(2724, " . $new_language_id . ",'Arkhangelsk Region'),
(2725, " . $new_language_id . ",'Astrakhan Oblast'),
(2726, " . $new_language_id . ",'Altai Krai'),
(2727, " . $new_language_id . ",'Belgorod Oblast'),
(2728, " . $new_language_id . ",'Jewish Autonomous Oblast'),
(2729, " . $new_language_id . ",'Amur Region'),
(2730, " . $new_language_id . ",'Bryansk Oblast'),
(2731, " . $new_language_id . ",'Chuvash Republic'),
(2732, " . $new_language_id . ",'Chelyabinsk Region'),
(2733, " . $new_language_id . ",'Karachay-Cherkess Republic'),
(2734, " . $new_language_id . ",'Zabaykalsky Krai'),
(2735, " . $new_language_id . ",'Taymyr Dolgano-Nenets Autonomous Okrug'),
(2736, " . $new_language_id . ",'Republic of Kalmykia'),
(2737, " . $new_language_id . ",'Moscow Oblast'),
(2738, " . $new_language_id . ",'Altai Republic'),
(2739, " . $new_language_id . ",'Chechen Republic'),
(2740, " . $new_language_id . ",'Irkutsk Oblast'),
(2741, " . $new_language_id . ",'Ivanovo Oblast'),
(2742, " . $new_language_id . ",'Udmurtia'),
(2743, " . $new_language_id . ",'Kaliningrad Oblast'),
(2744, " . $new_language_id . ",'Kaluzhskaya oblast'),
(2745, " . $new_language_id . ",'Kirov Oblast'),
(2746, " . $new_language_id . ",'Republic of Tatarstan'),
(2747, " . $new_language_id . ",'Kemerovo region'),
(2748, " . $new_language_id . ",'Khabarovsk Krai'),
(2749, " . $new_language_id . ",'Khanty–Mansi Autonomous Okrug – Yugra'),
(2750, " . $new_language_id . ",'Kostroma Oblast'),
(2751, " . $new_language_id . ",'Krasnodar Krai'),
(2752, " . $new_language_id . ",'Krasnoyarsk Krai'),
(2753, " . $new_language_id . ",'Komi-Permyatsky AO'),
(2754, " . $new_language_id . ",'Kurgan Oblast'),
(2755, " . $new_language_id . ",'Kursk Region'),
(2756, " . $new_language_id . ",'Respublika Tyva'),
(2757, " . $new_language_id . ",'Lipetsk Region'),
(2758, " . $new_language_id . ",'Magadan Oblast'),
(2759, " . $new_language_id . ",'Republic of Dagestan'),
(2760, " . $new_language_id . ",'Republic of Adygea'),
(2761, " . $new_language_id . ",'Moscú'),
(2762, " . $new_language_id . ",'Murmansk Oblast'),
(2763, " . $new_language_id . ",'Kabardino-Balkar Republic'),
(2764, " . $new_language_id . ",'Nenets Autonomous Okrug'),
(2765, " . $new_language_id . ",'Republic of Ingushetia'),
(2766, " . $new_language_id . ",'Nizhegorodskaya oblast'),
(2767, " . $new_language_id . ",'Novgorod Oblast'),
(2768, " . $new_language_id . ",'Novosibirsk Oblast'),
(2769, " . $new_language_id . ",'Omsk Oblast'),
(2770, " . $new_language_id . ",'Oryol Oblast'),
(2771, " . $new_language_id . ",'Orenburg Oblast'),
(2772, " . $new_language_id . ",'Leningrad Oblast'),
(2773, " . $new_language_id . ",'Penza Oblast'),
(2774, " . $new_language_id . ",'Perm Krai'),
(2775, " . $new_language_id . ",'Kamchatka Krai'),
(2776, " . $new_language_id . ",'Republic of Karelia'),
(2777, " . $new_language_id . ",'Pskov Oblast'),
(2778, " . $new_language_id . ",'Rostov Region'),
(2779, " . $new_language_id . ",'Ryazan Oblast'),
(2780, " . $new_language_id . ",'Yamalo-Nenets Autonomous Okrug'),
(2781, " . $new_language_id . ",'Samara Region'),
(2782, " . $new_language_id . ",'Republic of Mordovia'),
(2783, " . $new_language_id . ",'Saratov Region'),
(2784, " . $new_language_id . ",'Smolensk Oblast'),
(2785, " . $new_language_id . ",'San Petersburgo'),
(2786, " . $new_language_id . ",'Stavropol Krai'),
(2787, " . $new_language_id . ",'Komi Republic'),
(2788, " . $new_language_id . ",'Tambov Region'),
(2789, " . $new_language_id . ",'Tomsk Oblast'),
(2790, " . $new_language_id . ",'Tula Region'),
(2791, " . $new_language_id . ",'Evenkysky AO'),
(2792, " . $new_language_id . ",'Tver Oblast'),
(2793, " . $new_language_id . ",'Tyumen Oblast'),
(2794, " . $new_language_id . ",'Republic of Bashkortostan'),
(2795, " . $new_language_id . ",'Ulyanovsk Oblast'),
(2796, " . $new_language_id . ",'Republic of Buryatia'),
(2797, " . $new_language_id . ",'Ust-Orda Buryat Okrug'),
(2798, " . $new_language_id . ",'North Ossetia-Alania'),
(2799, " . $new_language_id . ",'Vladimir Oblast'),
(2800, " . $new_language_id . ",'Primorsky Krai'),
(2801, " . $new_language_id . ",'Volgograd Oblast'),
(2802, " . $new_language_id . ",'Vologda Oblast'),
(2803, " . $new_language_id . ",'Voronezh Oblast'),
(2804, " . $new_language_id . ",'Sakhalin Oblast'),
(2805, " . $new_language_id . ",'Sakha Republic'),
(2806, " . $new_language_id . ",'Yaroslavl Oblast'),
(2807, " . $new_language_id . ",'Sverdlovsk Oblast'),
(2808, " . $new_language_id . ",'Mari El Republic'),
(2809, " . $new_language_id . ",'Butare'),
(2810, " . $new_language_id . ",'Byumba'),
(2811, " . $new_language_id . ",'Cyangugu'),
(2812, " . $new_language_id . ",'Gikongoro'),
(2813, " . $new_language_id . ",'Gisenyi'),
(2814, " . $new_language_id . ",'Gitarama'),
(2815, " . $new_language_id . ",'Kibungo'),
(2816, " . $new_language_id . ",'Kibuye'),
(2817, " . $new_language_id . ",'Kigali Rurale'),
(2818, " . $new_language_id . ",'Kigali-ville'),
(2819, " . $new_language_id . ",'Ruhengeri'),
(2820, " . $new_language_id . ",'Umutara'),
(2821, " . $new_language_id . ",'Christ Church Nichola Town'),
(2822, " . $new_language_id . ",'Santa Ana Sandy Point'),
(2823, " . $new_language_id . ",'San Jorge Basseterre'),
(2824, " . $new_language_id . ",'San Jorge Gingerland'),
(2825, " . $new_language_id . ",'Santiago de Barlovento'),
(2826, " . $new_language_id . ",'Saint John Capesterre'),
(2827, " . $new_language_id . ",'Saint John Figtree'),
(2828, " . $new_language_id . ",'Saint Mary Cayon'),
(2829, " . $new_language_id . ",'Saint Paul Capesterre'),
(2830, " . $new_language_id . ",'Saint Paul Charlestown'),
(2831, " . $new_language_id . ",'San Pedro Basseterre'),
(2832, " . $new_language_id . ",'Santo Tomás de Tierras Bajas'),
(2833, " . $new_language_id . ",'Santo Tomás de Middle Island'),
(2834, " . $new_language_id . ",'Trinidad Palmetto Point'),
(2835, " . $new_language_id . ",'Anse-la-Raye'),
(2836, " . $new_language_id . ",'Castries'),
(2837, " . $new_language_id . ",'Choiseul'),
(2838, " . $new_language_id . ",'Delfín'),
(2839, " . $new_language_id . ",'Dennery'),
(2840, " . $new_language_id . ",'Gros-Islet'),
(2841, " . $new_language_id . ",'Laborie'),
(2842, " . $new_language_id . ",'Micoud'),
(2843, " . $new_language_id . ",'Praslin'),
(2844, " . $new_language_id . ",'Soufriere'),
(2845, " . $new_language_id . ",'Vieux-Fort'),
(2846, " . $new_language_id . ",'Charlotte'),
(2847, " . $new_language_id . ",'Granadinas'),
(2848, " . $new_language_id . ",'San Andrés'),
(2849, " . $new_language_id . ",'Saint David'),
(2850, " . $new_language_id . ",'San Jorge'),
(2851, " . $new_language_id . ",'San Patricio'),
(2852, " . $new_language_id . ",'A&#39;ana'),
(2853, " . $new_language_id . ",'Aiga-i-le-Tai'),
(2854, " . $new_language_id . ",'Atua'),
(2855, " . $new_language_id . ",'Fa&#39;asaleleaga'),
(2856, " . $new_language_id . ",'Gaga&#39;emauga'),
(2857, " . $new_language_id . ",'Gagaifomauga'),
(2858, " . $new_language_id . ",'Palauli'),
(2859, " . $new_language_id . ",'Satupa&#39;itea'),
(2860, " . $new_language_id . ",'Tuamasaga'),
(2861, " . $new_language_id . ",'Va&#39;a-o-Fonoti'),
(2862, " . $new_language_id . ",'Vaisigano'),
(2863, " . $new_language_id . ",'Acquaviva'),
(2864, " . $new_language_id . ",'Borgo Maggiore'),
(2865, " . $new_language_id . ",'Chiesanuova'),
(2866, " . $new_language_id . ",'Domagnano'),
(2867, " . $new_language_id . ",'Faetano'),
(2868, " . $new_language_id . ",'Fiorentino'),
(2869, " . $new_language_id . ",'Montegiardino'),
(2870, " . $new_language_id . ",'Citta di San Marino'),
(2871, " . $new_language_id . ",'Serravalle'),
(2872, " . $new_language_id . ",'Santo Tomé'),
(2873, " . $new_language_id . ",'Principe'),
(2874, " . $new_language_id . ",'El Baha'),
(2875, " . $new_language_id . ",'Al Hudud ash Shamaliyah'),
(2876, " . $new_language_id . ",'Al Jawf'),
(2877, " . $new_language_id . ",'Al Madinah'),
(2878, " . $new_language_id . ",'Al Qasim'),
(2879, " . $new_language_id . ",'Ar Riyad'),
(2880, " . $new_language_id . ",'Ash Sharqiyah (Eastern)'),
(2881, " . $new_language_id . ",'Asir'),
(2882, " . $new_language_id . ",'Ha&#39;il'),
(2883, " . $new_language_id . ",'Jizan'),
(2884, " . $new_language_id . ",'Makkah'),
(2885, " . $new_language_id . ",'Najran'),
(2886, " . $new_language_id . ",'Tabuk'),
(2887, " . $new_language_id . ",'Dakar'),
(2888, " . $new_language_id . ",'Diourbel'),
(2889, " . $new_language_id . ",'Fatick'),
(2890, " . $new_language_id . ",'Kaolack'),
(2891, " . $new_language_id . ",'Kolda'),
(2892, " . $new_language_id . ",'Louga'),
(2893, " . $new_language_id . ",'Matam'),
(2894, " . $new_language_id . ",'Saint-Louis'),
(2895, " . $new_language_id . ",'Tambacounda'),
(2896, " . $new_language_id . ",'Thies'),
(2897, " . $new_language_id . ",'Ziguinchor'),
(2898, " . $new_language_id . ",'Anse aux Pins'),
(2899, " . $new_language_id . ",'Anse Boileau'),
(2900, " . $new_language_id . ",'Anse Etoile'),
(2901, " . $new_language_id . ",'Anse Louis'),
(2902, " . $new_language_id . ",'Anse Royale'),
(2903, " . $new_language_id . ",'Baie Lazare'),
(2904, " . $new_language_id . ",'Baie Sainte Anne'),
(2905, " . $new_language_id . ",'Beau Vallon'),
(2906, " . $new_language_id . ",'Bel Air'),
(2907, " . $new_language_id . ",'Bel Ombre'),
(2908, " . $new_language_id . ",'Cascada'),
(2909, " . $new_language_id . ",'Glacis'),
(2910, " . $new_language_id . ",'Grand &#39;Anse (Mahe)'),
(2911, " . $new_language_id . ",'Grand &#39;Anse (en Praslin)'),
(2912, " . $new_language_id . ",'La Digue'),
(2913, " . $new_language_id . ",'La Riviere Anglaise'),
(2914, " . $new_language_id . ",'Mont Buxton'),
(2915, " . $new_language_id . ",'Mont Fleuri'),
(2916, " . $new_language_id . ",'Plaisance'),
(2917, " . $new_language_id . ",'Pointe La Rue'),
(2918, " . $new_language_id . ",'Port Glaud'),
(2919, " . $new_language_id . ",'Saint Louis'),
(2920, " . $new_language_id . ",'Takamaka'),
(2921, " . $new_language_id . ",'Oriental'),
(2922, " . $new_language_id . ",'Del norte'),
(2923, " . $new_language_id . ",'Meridional'),
(2924, " . $new_language_id . ",'Occidental'),
(2925, " . $new_language_id . ",'Banskobystrický'),
(2926, " . $new_language_id . ",'Bratislavský'),
(2927, " . $new_language_id . ",'Košický'),
(2928, " . $new_language_id . ",'Nitriansky'),
(2929, " . $new_language_id . ",'Prešovský'),
(2930, " . $new_language_id . ",'Trenčiansky'),
(2931, " . $new_language_id . ",'Trnavský'),
(2932, " . $new_language_id . ",'Žilinský'),
(2933, " . $new_language_id . ",'Central'),
(2934, " . $new_language_id . ",'Choiseul'),
(2935, " . $new_language_id . ",'Guadalcanal'),
(2936, " . $new_language_id . ",'Honiara'),
(2937, " . $new_language_id . ",'Isabel'),
(2938, " . $new_language_id . ",'Makira'),
(2939, " . $new_language_id . ",'Malaita'),
(2940, " . $new_language_id . ",'Rennell y Bellona'),
(2941, " . $new_language_id . ",'Temotu'),
(2942, " . $new_language_id . ",'Occidental'),
(2943, " . $new_language_id . ",'Awdal'),
(2944, " . $new_language_id . ",'Bakool'),
(2945, " . $new_language_id . ",'Banaadir'),
(2946, " . $new_language_id . ",'Bari'),
(2947, " . $new_language_id . ",'Bahía'),
(2948, " . $new_language_id . ",'Galguduud'),
(2949, " . $new_language_id . ",'Gedo'),
(2950, " . $new_language_id . ",'Hiiraan'),
(2951, " . $new_language_id . ",'Jubbada Dhexe'),
(2952, " . $new_language_id . ",'Jubbada Hoose'),
(2953, " . $new_language_id . ",'Mudug'),
(2954, " . $new_language_id . ",'Nugaal'),
(2955, " . $new_language_id . ",'Sanaag'),
(2956, " . $new_language_id . ",'Shabeellaha Dhexe'),
(2957, " . $new_language_id . ",'Shabeellaha Hoose'),
(2958, " . $new_language_id . ",'Sool'),
(2959, " . $new_language_id . ",'Togdheer'),
(2960, " . $new_language_id . ",'Woqooyi Galbeed'),
(2961, " . $new_language_id . ",'Cabo del Este'),
(2962, " . $new_language_id . ",'Estado Libre'),
(2963, " . $new_language_id . ",'Gauteng'),
(2964, " . $new_language_id . ",'KwaZulu-Natal'),
(2965, " . $new_language_id . ",'Limpopo'),
(2966, " . $new_language_id . ",'Mpumalanga'),
(2967, " . $new_language_id . ",'Noroeste'),
(2968, " . $new_language_id . ",'Northern Cape'),
(2969, " . $new_language_id . ",'Provincia Occidental del Cabo'),
(2970, " . $new_language_id . ",'La Coruña'),
(2971, " . $new_language_id . ",'Álava'),
(2972, " . $new_language_id . ",'Albacete'),
(2973, " . $new_language_id . ",'Alicante'),
(2974, " . $new_language_id . ",'Almería'),
(2975, " . $new_language_id . ",'Asturias'),
(2976, " . $new_language_id . ",'Ávila'),
(2977, " . $new_language_id . ",'Badajoz'),
(2978, " . $new_language_id . ",'Baleares'),
(2979, " . $new_language_id . ",'Barcelona'),
(2980, " . $new_language_id . ",'Burgos'),
(2981, " . $new_language_id . ",'Cáceres'),
(2982, " . $new_language_id . ",'Cádiz'),
(2983, " . $new_language_id . ",'Cantabria'),
(2984, " . $new_language_id . ",'Castellón'),
(2985, " . $new_language_id . ",'Ceuta'),
(2986, " . $new_language_id . ",'Ciudad Real'),
(2987, " . $new_language_id . ",'Córdoba'),
(2988, " . $new_language_id . ",'Cuenca'),
(2989, " . $new_language_id . ",'Girona'),
(2990, " . $new_language_id . ",'Granada'),
(2991, " . $new_language_id . ",'Guadalajara'),
(2992, " . $new_language_id . ",'Guipúzcoa'),
(2993, " . $new_language_id . ",'Huelva'),
(2994, " . $new_language_id . ",'Huesca'),
(2995, " . $new_language_id . ",'Jaén'),
(2996, " . $new_language_id . ",'La Rioja'),
(2997, " . $new_language_id . ",'Las Palmas'),
(2998, " . $new_language_id . ",'León'),
(2999, " . $new_language_id . ",'Lleida'),
(3000, " . $new_language_id . ",'Lugo'),
(3001, " . $new_language_id . ",'Madrid'),
(3002, " . $new_language_id . ",'Málaga'),
(3003, " . $new_language_id . ",'Melilla'),
(3004, " . $new_language_id . ",'Murcia'),
(3005, " . $new_language_id . ",'Navarra'),
(3006, " . $new_language_id . ",'Ourense'),
(3007, " . $new_language_id . ",'Palencia'),
(3008, " . $new_language_id . ",'Pontevedra'),
(3009, " . $new_language_id . ",'Salamanca'),
(3010, " . $new_language_id . ",'Santa Cruz de Tenerife'),
(3011, " . $new_language_id . ",'Segovia'),
(3012, " . $new_language_id . ",'Sevilla'),
(3013, " . $new_language_id . ",'Soria'),
(3014, " . $new_language_id . ",'Tarragona'),
(3015, " . $new_language_id . ",'Teruel'),
(3016, " . $new_language_id . ",'Toledo'),
(3017, " . $new_language_id . ",'Valencia'),
(3018, " . $new_language_id . ",'Valladolid'),
(3019, " . $new_language_id . ",'Vizcaya'),
(3020, " . $new_language_id . ",'Zamora'),
(3021, " . $new_language_id . ",'Zaragoza'),
(3022, " . $new_language_id . ",'Central'),
(3023, " . $new_language_id . ",'Oriental'),
(3024, " . $new_language_id . ",'North Central'),
(3025, " . $new_language_id . ",'Del norte'),
(3026, " . $new_language_id . ",'North Western'),
(3027, " . $new_language_id . ",'Sabaragamuwa'),
(3028, " . $new_language_id . ",'Meridional'),
(3029, " . $new_language_id . ",'Uva'),
(3030, " . $new_language_id . ",'Occidental'),
(3031, " . $new_language_id . ",'Ascensión'),
(3032, " . $new_language_id . ",'Santa Elena'),
(3033, " . $new_language_id . ",'Tristan da Cunha'),
(3034, " . $new_language_id . ",'A&#39;ali An Nil'),
(3035, " . $new_language_id . ",'Al Bahr al Ahmar'),
(3036, " . $new_language_id . ",'Al Buhayrat'),
(3037, " . $new_language_id . ",'Al Jazirah'),
(3038, " . $new_language_id . ",'Al Khartum'),
(3039, " . $new_language_id . ",'Al Qadarif'),
(3040, " . $new_language_id . ",'Al Wahdah'),
(3041, " . $new_language_id . ",'An Nil al Abyad'),
(3042, " . $new_language_id . ",'An Nil al Azraq'),
(3043, " . $new_language_id . ",'Ceniza Shamaliyah'),
(3044, " . $new_language_id . ",'Bahr al Jabal'),
(3045, " . $new_language_id . ",'Gharb al Istiwa&#39;iyah'),
(3046, " . $new_language_id . ",'Gharb Bahr al Ghazal'),
(3047, " . $new_language_id . ",'Gharb Darfur'),
(3048, " . $new_language_id . ",'Gharb Kurdufan'),
(3049, " . $new_language_id . ",'Janub Darfur'),
(3050, " . $new_language_id . ",'Janub Kurdufan'),
(3051, " . $new_language_id . ",'Junqali'),
(3052, " . $new_language_id . ",'Kassala'),
(3053, " . $new_language_id . ",'Nahr An Nil'),
(3054, " . $new_language_id . ",'Shamal Bahr al Ghazal'),
(3055, " . $new_language_id . ",'Shamal Darfur'),
(3056, " . $new_language_id . ",'Shamal Kurdufan'),
(3057, " . $new_language_id . ",'Sharq al Istiwa&#39;iyah'),
(3058, " . $new_language_id . ",'Sinnar'),
(3059, " . $new_language_id . ",'Warab'),
(3060, " . $new_language_id . ",'Brokopondo'),
(3061, " . $new_language_id . ",'Commewijne'),
(3062, " . $new_language_id . ",'Coronie'),
(3063, " . $new_language_id . ",'Marowijne'),
(3064, " . $new_language_id . ",'Nickerie'),
(3065, " . $new_language_id . ",'Para'),
(3066, " . $new_language_id . ",'Paramaribo'),
(3067, " . $new_language_id . ",'Saramacca'),
(3068, " . $new_language_id . ",'Sipaliwini'),
(3069, " . $new_language_id . ",'Wanica'),
(3070, " . $new_language_id . ",'Hhohho'),
(3071, " . $new_language_id . ",'Lubombo'),
(3072, " . $new_language_id . ",'Manzini'),
(3073, " . $new_language_id . ",'Shishelweni'),
(3074, " . $new_language_id . ",'Blekinge'),
(3075, " . $new_language_id . ",'Dalama'),
(3076, " . $new_language_id . ",'Gävleborg'),
(3077, " . $new_language_id . ",'Gotland'),
(3078, " . $new_language_id . ",'Halland'),
(3079, " . $new_language_id . ",'Jämtland'),
(3080, " . $new_language_id . ",'Jönköping'),
(3081, " . $new_language_id . ",'Kalmar'),
(3082, " . $new_language_id . ",'Kronoberg'),
(3083, " . $new_language_id . ",'Norrbotten'),
(3084, " . $new_language_id . ",'Örebro'),
(3085, " . $new_language_id . ",'Östergötland'),
(3086, " . $new_language_id . ",'Skåne'),
(3087, " . $new_language_id . ",'Södermanland'),
(3088, " . $new_language_id . ",'Estocolmo'),
(3089, " . $new_language_id . ",'Uppsala'),
(3090, " . $new_language_id . ",'Värmland'),
(3091, " . $new_language_id . ",'Västerbotten'),
(3092, " . $new_language_id . ",'Västernorrland'),
(3093, " . $new_language_id . ",'Västmanland'),
(3094, " . $new_language_id . ",'Västra Götaland'),
(3095, " . $new_language_id . ",'Aargau'),
(3096, " . $new_language_id . ",'Appenzell Rodas Exteriores'),
(3097, " . $new_language_id . ",'Appenzell Rodas Interiores'),
(3098, " . $new_language_id . ",'Basel-Stadt'),
(3099, " . $new_language_id . ",'Basilea-Campiña'),
(3100, " . $new_language_id . ",'Bern'),
(3101, " . $new_language_id . ",'Fribourg'),
(3102, " . $new_language_id . ",'Genève'),
(3103, " . $new_language_id . ",'Glarus'),
(3104, " . $new_language_id . ",'Cantón de los Grisones'),
(3105, " . $new_language_id . ",'Jura'),
(3106, " . $new_language_id . ",'Luzern'),
(3107, " . $new_language_id . ",'Neuchâtel'),
(3108, " . $new_language_id . ",'Nidwalden'),
(3109, " . $new_language_id . ",'Obwalden'),
(3110, " . $new_language_id . ",'St. Gallen'),
(3111, " . $new_language_id . ",'Schaffhausen'),
(3112, " . $new_language_id . ",'Schwyz'),
(3113, " . $new_language_id . ",'Solothurn'),
(3114, " . $new_language_id . ",'Thurgau'),
(3115, " . $new_language_id . ",'Ticino'),
(3116, " . $new_language_id . ",'Uri'),
(3117, " . $new_language_id . ",'Valais'),
(3118, " . $new_language_id . ",'Vaud'),
(3119, " . $new_language_id . ",'Zug'),
(3120, " . $new_language_id . ",'Zürich'),
(3121, " . $new_language_id . ",'Al Hasakah'),
(3122, " . $new_language_id . ",'Al Ladhiqiyah'),
(3123, " . $new_language_id . ",'Al Qunaytirah'),
(3124, " . $new_language_id . ",'Ar Raqqah'),
(3125, " . $new_language_id . ",'As Suwayda'),
(3126, " . $new_language_id . ",'Dara'),
(3127, " . $new_language_id . ",'Dayr az Zawr'),
(3128, " . $new_language_id . ",'Dimashq'),
(3129, " . $new_language_id . ",'Halab'),
(3130, " . $new_language_id . ",'Hamah'),
(3131, " . $new_language_id . ",'Homs'),
(3132, " . $new_language_id . ",'Idlib'),
(3133, " . $new_language_id . ",'Rif Dimashq'),
(3134, " . $new_language_id . ",'Tartus'),
(3135, " . $new_language_id . ",'Chang-hua'),
(3136, " . $new_language_id . ",'Chia-i'),
(3137, " . $new_language_id . ",'Hsin-chu'),
(3138, " . $new_language_id . ",'Hua-lien'),
(3139, " . $new_language_id . ",'I-lan'),
(3140, " . $new_language_id . ",'Condado Kao-hsiung'),
(3141, " . $new_language_id . ",'Kin-men'),
(3142, " . $new_language_id . ",'Lien-chiang'),
(3143, " . $new_language_id . ",'Miao-li'),
(3144, " . $new_language_id . ",'Nan-t&#39;ou'),
(3145, " . $new_language_id . ",'P&#39;eng-hu'),
(3146, " . $new_language_id . ",'P&#39;ing-tung'),
(3147, " . $new_language_id . ",'T&#39;ai-chung'),
(3148, " . $new_language_id . ",'T&#39;ai-nan'),
(3149, " . $new_language_id . ",'Condado T&#39;ai-pei'),
(3150, " . $new_language_id . ",'T&#39;ai-tung'),
(3151, " . $new_language_id . ",'T&#39;ao-yuan'),
(3152, " . $new_language_id . ",'Yun-lin'),
(3153, " . $new_language_id . ",'Ciudad Chia-i'),
(3154, " . $new_language_id . ",'Chi-pulmón'),
(3155, " . $new_language_id . ",'Hsin-chu'),
(3156, " . $new_language_id . ",'T&#39;ai-chung'),
(3157, " . $new_language_id . ",'T&#39;ai-nan'),
(3158, " . $new_language_id . ",'Ciudad Kao-hsiung'),
(3159, " . $new_language_id . ",'Ciudad T&#39;ai-pei'),
(3160, " . $new_language_id . ",'Gorno-Badakhstan'),
(3161, " . $new_language_id . ",'Khatlon'),
(3162, " . $new_language_id . ",'Sughd'),
(3163, " . $new_language_id . ",'Arusha'),
(3164, " . $new_language_id . ",'Dar es Salaam'),
(3165, " . $new_language_id . ",'Dodoma'),
(3166, " . $new_language_id . ",'Iringa'),
(3167, " . $new_language_id . ",'Kagera'),
(3168, " . $new_language_id . ",'Kigoma'),
(3169, " . $new_language_id . ",'Kilimanjaro'),
(3170, " . $new_language_id . ",'Lindi'),
(3171, " . $new_language_id . ",'Manyara'),
(3172, " . $new_language_id . ",'Mara'),
(3173, " . $new_language_id . ",'Mbeya'),
(3174, " . $new_language_id . ",'Morogoro'),
(3175, " . $new_language_id . ",'Mtwara'),
(3176, " . $new_language_id . ",'Mwanza'),
(3177, " . $new_language_id . ",'Pemba Norte'),
(3178, " . $new_language_id . ",'Pemba Sur'),
(3179, " . $new_language_id . ",'Pwani'),
(3180, " . $new_language_id . ",'Rukwa'),
(3181, " . $new_language_id . ",'Ruvuma'),
(3182, " . $new_language_id . ",'Shinyanga'),
(3183, " . $new_language_id . ",'Singida'),
(3184, " . $new_language_id . ",'Tabora'),
(3185, " . $new_language_id . ",'Tanga'),
(3186, " . $new_language_id . ",'Zanzibar Central / South'),
(3187, " . $new_language_id . ",'Zanzibar North'),
(3188, " . $new_language_id . ",'Zanzibar Urban / West'),
(3189, " . $new_language_id . ",'Amnat Charoen'),
(3190, " . $new_language_id . ",'Ang Thong'),
(3191, " . $new_language_id . ",'Ayutthaya'),
(3192, " . $new_language_id . ",'Bangkok'),
(3193, " . $new_language_id . ",'Buriram'),
(3194, " . $new_language_id . ",'Chachoengsao'),
(3195, " . $new_language_id . ",'Chai Nat'),
(3196, " . $new_language_id . ",'Chaiyaphum'),
(3197, " . $new_language_id . ",'Chanthaburi'),
(3198, " . $new_language_id . ",'Chiang Mai'),
(3199, " . $new_language_id . ",'Chiang Rai'),
(3200, " . $new_language_id . ",'Chon Buri'),
(3201, " . $new_language_id . ",'Chumphon'),
(3202, " . $new_language_id . ",'Kalasin'),
(3203, " . $new_language_id . ",'Kamphaeng Phet'),
(3204, " . $new_language_id . ",'Kanchanaburi'),
(3205, " . $new_language_id . ",'Khon Kaen'),
(3206, " . $new_language_id . ",'Krabi'),
(3207, " . $new_language_id . ",'Lampang'),
(3208, " . $new_language_id . ",'Lamphun'),
(3209, " . $new_language_id . ",'Loei'),
(3210, " . $new_language_id . ",'Lop Buri'),
(3211, " . $new_language_id . ",'Mae Hong Son'),
(3212, " . $new_language_id . ",'Maha Sarakham'),
(3213, " . $new_language_id . ",'Mukdahan'),
(3214, " . $new_language_id . ",'Nakhon Nayok'),
(3215, " . $new_language_id . ",'Nakhon Pathom'),
(3216, " . $new_language_id . ",'Nakhon Phanom'),
(3217, " . $new_language_id . ",'Nakhon Ratchasima'),
(3218, " . $new_language_id . ",'Nakhon Sawan'),
(3219, " . $new_language_id . ",'Nakhon Si Thammarat'),
(3220, " . $new_language_id . ",'Nan'),
(3221, " . $new_language_id . ",'Narathiwat'),
(3222, " . $new_language_id . ",'Nong Bua Lamphu'),
(3223, " . $new_language_id . ",'Nong Khai'),
(3224, " . $new_language_id . ",'Nonthaburi'),
(3225, " . $new_language_id . ",'Pathum Thani'),
(3226, " . $new_language_id . ",'Pattani'),
(3227, " . $new_language_id . ",'Phangnga'),
(3228, " . $new_language_id . ",'Phatthalung'),
(3229, " . $new_language_id . ",'Phayao'),
(3230, " . $new_language_id . ",'Phetchabun'),
(3231, " . $new_language_id . ",'Phetchaburi'),
(3232, " . $new_language_id . ",'Phichit'),
(3233, " . $new_language_id . ",'Phitsanulok'),
(3234, " . $new_language_id . ",'Phrae'),
(3235, " . $new_language_id . ",'Phuket'),
(3236, " . $new_language_id . ",'Prachin Buri'),
(3237, " . $new_language_id . ",'Prachuap Khiri Khan'),
(3238, " . $new_language_id . ",'Ranong'),
(3239, " . $new_language_id . ",'Ratchaburi'),
(3240, " . $new_language_id . ",'Rayong'),
(3241, " . $new_language_id . ",'Roi Et'),
(3242, " . $new_language_id . ",'Sa Kaeo'),
(3243, " . $new_language_id . ",'Sakon Nakhon'),
(3244, " . $new_language_id . ",'Samut Prakan'),
(3245, " . $new_language_id . ",'Samut Sakhon'),
(3246, " . $new_language_id . ",'Samut Songkhram'),
(3247, " . $new_language_id . ",'Sara Buri'),
(3248, " . $new_language_id . ",'Satun'),
(3249, " . $new_language_id . ",'Sing Buri'),
(3250, " . $new_language_id . ",'Sisaket'),
(3251, " . $new_language_id . ",'Songkhla'),
(3252, " . $new_language_id . ",'Sukhothai'),
(3253, " . $new_language_id . ",'Suphan Buri'),
(3254, " . $new_language_id . ",'Surat Thani'),
(3255, " . $new_language_id . ",'Surin'),
(3256, " . $new_language_id . ",'Tak'),
(3257, " . $new_language_id . ",'Trang'),
(3258, " . $new_language_id . ",'Trat'),
(3259, " . $new_language_id . ",'Ubon Ratchathani'),
(3260, " . $new_language_id . ",'Udon Thani'),
(3261, " . $new_language_id . ",'Uthai Thani'),
(3262, " . $new_language_id . ",'Uttaradit'),
(3263, " . $new_language_id . ",'Yala'),
(3264, " . $new_language_id . ",'Yasothon'),
(3265, " . $new_language_id . ",'Kara'),
(3266, " . $new_language_id . ",'Mesetas'),
(3267, " . $new_language_id . ",'Savanes'),
(3268, " . $new_language_id . ",'Centrale'),
(3269, " . $new_language_id . ",'Marítimo'),
(3270, " . $new_language_id . ",'Atafu'),
(3271, " . $new_language_id . ",'Fakaofo'),
(3272, " . $new_language_id . ",'Nukunonu'),
(3273, " . $new_language_id . ",'Ha&#39;apai'),
(3274, " . $new_language_id . ",'Tongatapu'),
(3275, " . $new_language_id . ",'Vava&#39;u'),
(3276, " . $new_language_id . ",'Couva / Tabaquite / Talparo'),
(3277, " . $new_language_id . ",'Diego Martin'),
(3278, " . $new_language_id . ",'Mayaro / Rio Claro'),
(3279, " . $new_language_id . ",'Penal / Debe'),
(3280, " . $new_language_id . ",'Town Princes'),
(3281, " . $new_language_id . ",'Sangre Grande'),
(3282, " . $new_language_id . ",'San Juan / Laventille'),
(3283, " . $new_language_id . ",'Siparia'),
(3284, " . $new_language_id . ",'Tunapuna / Piarco'),
(3285, " . $new_language_id . ",'Puerto de España'),
(3286, " . $new_language_id . ",'San Fernando'),
(3287, " . $new_language_id . ",'Arima'),
(3288, " . $new_language_id . ",'Point Fortin'),
(3289, " . $new_language_id . ",'Chaguanas'),
(3290, " . $new_language_id . ",'Tobago'),
(3291, " . $new_language_id . ",'Ariana'),
(3292, " . $new_language_id . ",'Beja'),
(3293, " . $new_language_id . ",'Ben Arous'),
(3294, " . $new_language_id . ",'Bizerta'),
(3295, " . $new_language_id . ",'Gabes'),
(3296, " . $new_language_id . ",'Gafsa'),
(3297, " . $new_language_id . ",'Jendouba'),
(3298, " . $new_language_id . ",'Kairouan'),
(3299, " . $new_language_id . ",'Kasserine'),
(3300, " . $new_language_id . ",'Kebili'),
(3301, " . $new_language_id . ",'Kef'),
(3302, " . $new_language_id . ",'Mahdia'),
(3303, " . $new_language_id . ",'Manouba'),
(3304, " . $new_language_id . ",'Medenine'),
(3305, " . $new_language_id . ",'Monastir'),
(3306, " . $new_language_id . ",'Nabeul'),
(3307, " . $new_language_id . ",'Sfax'),
(3308, " . $new_language_id . ",'Sidi'),
(3309, " . $new_language_id . ",'Siliana'),
(3310, " . $new_language_id . ",'Sousse'),
(3311, " . $new_language_id . ",'Tataouine'),
(3312, " . $new_language_id . ",'Tozeur'),
(3313, " . $new_language_id . ",'Tunis'),
(3314, " . $new_language_id . ",'Zaghouan'),
(3315, " . $new_language_id . ",'Adana'),
(3316, " . $new_language_id . ",'Adiyaman'),
(3317, " . $new_language_id . ",'Afyonkarahisar'),
(3318, " . $new_language_id . ",'Agri'),
(3319, " . $new_language_id . ",'Aksaray'),
(3320, " . $new_language_id . ",'Amasya'),
(3321, " . $new_language_id . ",'Ankara'),
(3322, " . $new_language_id . ",'Antalya'),
(3323, " . $new_language_id . ",'Ardahan'),
(3324, " . $new_language_id . ",'Artvin'),
(3325, " . $new_language_id . ",'Aydin'),
(3326, " . $new_language_id . ",'Balikesir'),
(3327, " . $new_language_id . ",'Bartin'),
(3328, " . $new_language_id . ",'Ordenanza'),
(3329, " . $new_language_id . ",'Bayburt'),
(3330, " . $new_language_id . ",'Bilecik'),
(3331, " . $new_language_id . ",'Bingol'),
(3332, " . $new_language_id . ",'Bitlis'),
(3333, " . $new_language_id . ",'Bolu'),
(3334, " . $new_language_id . ",'Burdur'),
(3335, " . $new_language_id . ",'Bolsa'),
(3336, " . $new_language_id . ",'Canakkale'),
(3337, " . $new_language_id . ",'Cankiri'),
(3338, " . $new_language_id . ",'Corum'),
(3339, " . $new_language_id . ",'Denizli'),
(3340, " . $new_language_id . ",'Diyarbakir'),
(3341, " . $new_language_id . ",'Duzce'),
(3342, " . $new_language_id . ",'Edirne'),
(3343, " . $new_language_id . ",'Elazig'),
(3344, " . $new_language_id . ",'Erzincan'),
(3345, " . $new_language_id . ",'Erzurum'),
(3346, " . $new_language_id . ",'Eskisehir'),
(3347, " . $new_language_id . ",'Gaziantep'),
(3348, " . $new_language_id . ",'Giresun'),
(3349, " . $new_language_id . ",'Gumushane'),
(3350, " . $new_language_id . ",'Hakkari'),
(3351, " . $new_language_id . ",'Hatay'),
(3352, " . $new_language_id . ",'Igdir'),
(3353, " . $new_language_id . ",'Isparta'),
(3354, " . $new_language_id . ",'Estanbul'),
(3355, " . $new_language_id . ",'Izmir'),
(3356, " . $new_language_id . ",'Kahramanmaras'),
(3357, " . $new_language_id . ",'Karabuk'),
(3358, " . $new_language_id . ",'Karaman'),
(3359, " . $new_language_id . ",'Kars'),
(3360, " . $new_language_id . ",'Kastamonu'),
(3361, " . $new_language_id . ",'Kayseri'),
(3362, " . $new_language_id . ",'Kilis'),
(3363, " . $new_language_id . ",'Kirikkale'),
(3364, " . $new_language_id . ",'Kirklareli'),
(3365, " . $new_language_id . ",'Kirsehir'),
(3366, " . $new_language_id . ",'Kocaeli'),
(3367, " . $new_language_id . ",'Konya'),
(3368, " . $new_language_id . ",'Kutahya'),
(3369, " . $new_language_id . ",'Malatya'),
(3370, " . $new_language_id . ",'Manisa'),
(3371, " . $new_language_id . ",'Mardin'),
(3372, " . $new_language_id . ",'Mersin'),
(3373, " . $new_language_id . ",'Mugla'),
(3374, " . $new_language_id . ",'Mus'),
(3375, " . $new_language_id . ",'Nevsehir'),
(3376, " . $new_language_id . ",'Nigde'),
(3377, " . $new_language_id . ",'Ordu'),
(3378, " . $new_language_id . ",'Osmaniye'),
(3379, " . $new_language_id . ",'Rize'),
(3380, " . $new_language_id . ",'Sakarya'),
(3381, " . $new_language_id . ",'Samsun'),
(3382, " . $new_language_id . ",'Sanliurfa'),
(3383, " . $new_language_id . ",'Siirt'),
(3384, " . $new_language_id . ",'Sinop'),
(3385, " . $new_language_id . ",'Sirnak'),
(3386, " . $new_language_id . ",'Sivas'),
(3387, " . $new_language_id . ",'Tekirdag'),
(3388, " . $new_language_id . ",'Tokat'),
(3389, " . $new_language_id . ",'Trabzon'),
(3390, " . $new_language_id . ",'Tunceli'),
(3391, " . $new_language_id . ",'Usak'),
(3392, " . $new_language_id . ",'Furgoneta'),
(3393, " . $new_language_id . ",'Yalova'),
(3394, " . $new_language_id . ",'Yozgat'),
(3395, " . $new_language_id . ",'Zonguldak'),
(3396, " . $new_language_id . ",'Ahal Welayaty'),
(3397, " . $new_language_id . ",'Balkan Welayaty'),
(3398, " . $new_language_id . ",'Dashhowuz Welayaty'),
(3399, " . $new_language_id . ",'Lebap Welayaty'),
(3400, " . $new_language_id . ",'María Welayaty'),
(3401, " . $new_language_id . ",'Ambergris Cayos'),
(3402, " . $new_language_id . ",'Dellis Cay'),
(3403, " . $new_language_id . ",'Francés Cay'),
(3404, " . $new_language_id . ",'Poco Water Cay'),
(3405, " . $new_language_id . ",'Parrot Cay'),
(3406, " . $new_language_id . ",'Pine Cay'),
(3407, " . $new_language_id . ",'Salt Cay'),
(3408, " . $new_language_id . ",'Grand Turk'),
(3409, " . $new_language_id . ",'South Caicos'),
(3410, " . $new_language_id . ",'Caicos del Este'),
(3411, " . $new_language_id . ",'Middle Caicos'),
(3412, " . $new_language_id . ",'North Caicos'),
(3413, " . $new_language_id . ",'Providenciales'),
(3414, " . $new_language_id . ",'West Caicos'),
(3415, " . $new_language_id . ",'Nanumanga'),
(3416, " . $new_language_id . ",'Niulakita'),
(3417, " . $new_language_id . ",'Niutao'),
(3418, " . $new_language_id . ",'Funafuti'),
(3419, " . $new_language_id . ",'Nanumea'),
(3420, " . $new_language_id . ",'Nui'),
(3421, " . $new_language_id . ",'Nukufetau'),
(3422, " . $new_language_id . ",'Nukulaelae'),
(3423, " . $new_language_id . ",'Vaitupu'),
(3424, " . $new_language_id . ",'Kalangala'),
(3425, " . $new_language_id . ",'Kampala'),
(3426, " . $new_language_id . ",'Kayunga'),
(3427, " . $new_language_id . ",'Kiboga'),
(3428, " . $new_language_id . ",'Luwero'),
(3429, " . $new_language_id . ",'Masaka'),
(3430, " . $new_language_id . ",'Mpigi'),
(3431, " . $new_language_id . ",'Mubende'),
(3432, " . $new_language_id . ",'Mukono'),
(3433, " . $new_language_id . ",'Nakasongola'),
(3434, " . $new_language_id . ",'Rakai'),
(3435, " . $new_language_id . ",'Sembabule'),
(3436, " . $new_language_id . ",'Wakiso'),
(3437, " . $new_language_id . ",'Bugiri'),
(3438, " . $new_language_id . ",'Busia'),
(3439, " . $new_language_id . ",'Iganga'),
(3440, " . $new_language_id . ",'Jinja'),
(3441, " . $new_language_id . ",'Kaberamaido'),
(3442, " . $new_language_id . ",'Kamuli'),
(3443, " . $new_language_id . ",'Kapchorwa'),
(3444, " . $new_language_id . ",'Katakwi'),
(3445, " . $new_language_id . ",'Kumi'),
(3446, " . $new_language_id . ",'Mayuge'),
(3447, " . $new_language_id . ",'Mbale'),
(3448, " . $new_language_id . ",'Pallisa'),
(3449, " . $new_language_id . ",'Sironko'),
(3450, " . $new_language_id . ",'Soroti'),
(3451, " . $new_language_id . ",'Tororo'),
(3452, " . $new_language_id . ",'Adjumani'),
(3453, " . $new_language_id . ",'Apac'),
(3454, " . $new_language_id . ",'Arua'),
(3455, " . $new_language_id . ",'Gulu'),
(3456, " . $new_language_id . ",'Kitgum'),
(3457, " . $new_language_id . ",'Kotido'),
(3458, " . $new_language_id . ",'Lira'),
(3459, " . $new_language_id . ",'Moroto'),
(3460, " . $new_language_id . ",'Moyo'),
(3461, " . $new_language_id . ",'Nakapiripirit'),
(3462, " . $new_language_id . ",'Nebbi'),
(3463, " . $new_language_id . ",'Pader'),
(3464, " . $new_language_id . ",'Yumbe'),
(3465, " . $new_language_id . ",'Bundibugyo'),
(3466, " . $new_language_id . ",'Bushenyi'),
(3467, " . $new_language_id . ",'Hoima'),
(3468, " . $new_language_id . ",'Kabale'),
(3469, " . $new_language_id . ",'Kabarole'),
(3470, " . $new_language_id . ",'Kamwenge'),
(3471, " . $new_language_id . ",'Kanungu'),
(3472, " . $new_language_id . ",'Kasese'),
(3473, " . $new_language_id . ",'Kibaale'),
(3474, " . $new_language_id . ",'Kisoro'),
(3475, " . $new_language_id . ",'Kyenjojo'),
(3476, " . $new_language_id . ",'Masindi'),
(3477, " . $new_language_id . ",'Mbarara'),
(3478, " . $new_language_id . ",'Ntungamo'),
(3479, " . $new_language_id . ",'Rukungiri'),
(3480, " . $new_language_id . ",'Cherkasy'),
(3481, " . $new_language_id . ",'Chernihiv'),
(3482, " . $new_language_id . ",'Chernivtsi'),
(3483, " . $new_language_id . ",'Crimea'),
(3484, " . $new_language_id . ",'Dnipro'),
(3485, " . $new_language_id . ",'Donets&#39;k'),
(3486, " . $new_language_id . ",'Ivano-Frankovsk'),
(3487, " . $new_language_id . ",'Kharkiv'),
(3488, " . $new_language_id . ",'Khmel&#39;nyts&#39;kyy'),
(3489, " . $new_language_id . ",'Kirovohrad'),
(3490, " . $new_language_id . ",'Kyiv'),
(3491, " . $new_language_id . ",'Kherson'),
(3492, " . $new_language_id . ",'Luhans&#39;k'),
(3493, " . $new_language_id . ",'L&#39;viv'),
(3494, " . $new_language_id . ",'Mykolaiv'),
(3495, " . $new_language_id . ",'Odesa'),
(3496, " . $new_language_id . ",'Poltava'),
(3497, " . $new_language_id . ",'Rivne'),
(3498, " . $new_language_id . ",'Sevastopol'),
(3499, " . $new_language_id . ",'Sumy'),
(3500, " . $new_language_id . ",'Ternopil &#39;'),
(3501, " . $new_language_id . ",'Vinnytsya'),
(3502, " . $new_language_id . ",'Volyn &#39;'),
(3503, " . $new_language_id . ",'Zakarpattya'),
(3504, " . $new_language_id . ",'Zaporizhzhya'),
(3505, " . $new_language_id . ",'Zhytomyr'),
(3506, " . $new_language_id . ",'Abu Zaby'),
(3507, " . $new_language_id . ",'&#39;Ajman'),
(3508, " . $new_language_id . ",'Fujairah'),
(3509, " . $new_language_id . ",'Ash Shariqah'),
(3510, " . $new_language_id . ",'Dubayy'),
(3511, " . $new_language_id . ",'R&#39;as al Khaymah'),
(3512, " . $new_language_id . ",'Umm al Qaywayn'),
(3513, " . $new_language_id . ",'Aberdeen'),
(3514, " . $new_language_id . ",'Aberdeenshire'),
(3515, " . $new_language_id . ",'Anglesey'),
(3516, " . $new_language_id . ",'Angus'),
(3517, " . $new_language_id . ",'Argyll and Bute'),
(3518, " . $new_language_id . ",'Bedfordshire'),
(3519, " . $new_language_id . ",'Berkshire'),
(3520, " . $new_language_id . ",'Blaenau Gwent'),
(3521, " . $new_language_id . ",'Bridgend'),
(3522, " . $new_language_id . ",'Bristol'),
(3523, " . $new_language_id . ",'Buckinghamshire'),
(3524, " . $new_language_id . ",'Caerphilly'),
(3525, " . $new_language_id . ",'Cambridgeshire'),
(3526, " . $new_language_id . ",'Cardiff'),
(3527, " . $new_language_id . ",'Carmarthenshire'),
(3528, " . $new_language_id . ",'Ceredigion'),
(3529, " . $new_language_id . ",'Cheshire'),
(3530, " . $new_language_id . ",'Clackmannanshire'),
(3531, " . $new_language_id . ",'Conwy'),
(3532, " . $new_language_id . ",'Cornualles'),
(3533, " . $new_language_id . ",'Denbighshire'),
(3534, " . $new_language_id . ",'Derbyshire'),
(3535, " . $new_language_id . ",'Devon'),
(3536, " . $new_language_id . ",'Dorset'),
(3537, " . $new_language_id . ",'Dumfries y Galloway'),
(3538, " . $new_language_id . ",'Dundee'),
(3539, " . $new_language_id . ",'Durham'),
(3540, " . $new_language_id . ",'East Ayrshire'),
(3541, " . $new_language_id . ",'East Dunbartonshire'),
(3542, " . $new_language_id . ",'East Lothian'),
(3543, " . $new_language_id . ",'East Renfrewshire'),
(3544, " . $new_language_id . ",'East Riding of Yorkshire'),
(3545, " . $new_language_id . ",'East Sussex'),
(3546, " . $new_language_id . ",'Edimburgo'),
(3547, " . $new_language_id . ",'Essex'),
(3548, " . $new_language_id . ",'Falkirk'),
(3549, " . $new_language_id . ",'Pífano'),
(3550, " . $new_language_id . ",'Flintshire'),
(3551, " . $new_language_id . ",'Glasgow'),
(3552, " . $new_language_id . ",'Gloucestershire'),
(3553, " . $new_language_id . ",'Gran Londres'),
(3554, " . $new_language_id . ",'Greater Manchester'),
(3555, " . $new_language_id . ",'Gwynedd'),
(3556, " . $new_language_id . ",'Hampshire'),
(3557, " . $new_language_id . ",'Herefordshire'),
(3558, " . $new_language_id . ",'Hertfordshire'),
(3559, " . $new_language_id . ",'Tierras altas'),
(3560, " . $new_language_id . ",'Inverclyde'),
(3561, " . $new_language_id . ",'Isle of Wight'),
(3562, " . $new_language_id . ",'Kent'),
(3563, " . $new_language_id . ",'Lancashire'),
(3564, " . $new_language_id . ",'Leicestershire'),
(3565, " . $new_language_id . ",'Lincolnshire'),
(3566, " . $new_language_id . ",'Merseyside'),
(3567, " . $new_language_id . ",'Merthyr Tydfil'),
(3568, " . $new_language_id . ",'Midlothian'),
(3569, " . $new_language_id . ",'Monmouthshire'),
(3570, " . $new_language_id . ",'Moray'),
(3571, " . $new_language_id . ",'Neath Port Talbot'),
(3572, " . $new_language_id . ",'Newport'),
(3573, " . $new_language_id . ",'Norfolk'),
(3574, " . $new_language_id . ",'North Ayrshire'),
(3575, " . $new_language_id . ",'North Lanarkshire'),
(3576, " . $new_language_id . ",'North Yorkshire'),
(3577, " . $new_language_id . ",'Northamptonshire'),
(3578, " . $new_language_id . ",'Northumberland'),
(3579, " . $new_language_id . ",'Nottinghamshire'),
(3580, " . $new_language_id . ",'Islas Orcadas'),
(3581, " . $new_language_id . ",'Oxfordshire'),
(3582, " . $new_language_id . ",'Pembrokeshire'),
(3583, " . $new_language_id . ",'Perth and Kinross'),
(3584, " . $new_language_id . ",'Powys'),
(3585, " . $new_language_id . ",'Renfrewshire'),
(3586, " . $new_language_id . ",'Rhondda Cynon Taff'),
(3587, " . $new_language_id . ",'Rutland'),
(3588, " . $new_language_id . ",'Scottish Borders'),
(3589, " . $new_language_id . ",'Islas Shetland'),
(3590, " . $new_language_id . ",'Shropshire'),
(3591, " . $new_language_id . ",'Somerset'),
(3592, " . $new_language_id . ",'South Ayrshire'),
(3593, " . $new_language_id . ",'South Lanarkshire'),
(3594, " . $new_language_id . ",'South Yorkshire'),
(3595, " . $new_language_id . ",'Staffordshire'),
(3596, " . $new_language_id . ",'Stirling'),
(3597, " . $new_language_id . ",'Suffolk'),
(3598, " . $new_language_id . ",'Surrey'),
(3599, " . $new_language_id . ",'Swansea'),
(3600, " . $new_language_id . ",'Torfaen'),
(3601, " . $new_language_id . ",'Tyne and Wear'),
(3602, " . $new_language_id . ",'Vale of Glamorgan'),
(3603, " . $new_language_id . ",'Warwickshire'),
(3604, " . $new_language_id . ",'West Dunbartonshire'),
(3605, " . $new_language_id . ",'West Lothian'),
(3606, " . $new_language_id . ",'West Midlands'),
(3607, " . $new_language_id . ",'West Sussex'),
(3608, " . $new_language_id . ",'West Yorkshire'),
(3609, " . $new_language_id . ",'Western Isles'),
(3610, " . $new_language_id . ",'Wiltshire'),
(3611, " . $new_language_id . ",'Worcestershire'),
(3612, " . $new_language_id . ",'Wrexham'),
(3613, " . $new_language_id . ",'Alabama'),
(3614, " . $new_language_id . ",'Alaska'),
(3615, " . $new_language_id . ",'Samoa Americana'),
(3616, " . $new_language_id . ",'Arizona'),
(3617, " . $new_language_id . ",'Arkansas'),
(3618, " . $new_language_id . ",'Fuerzas Armadas de África'),
(3619, " . $new_language_id . ",'Fuerzas Armadas de América'),
(3620, " . $new_language_id . ",'Fuerzas Armadas de Canadá'),
(3621, " . $new_language_id . ",'Fuerzas Armadas de Europa'),
(3622, " . $new_language_id . ",'Fuerzas Armadas Oriente Medio'),
(3623, " . $new_language_id . ",'Fuerzas Armadas del Pacífico'),
(3624, " . $new_language_id . ",'California'),
(3625, " . $new_language_id . ",'Colorado'),
(3626, " . $new_language_id . ",'Connecticut'),
(3627, " . $new_language_id . ",'Delaware'),
(3628, " . $new_language_id . ",'Distrito de Columbia'),
(3629, " . $new_language_id . ",'Estados Federados de Micronesia'),
(3630, " . $new_language_id . ",'Florida'),
(3631, " . $new_language_id . ",'Georgia'),
(3632, " . $new_language_id . ",'Guam'),
(3633, " . $new_language_id . ",'Hawai'),
(3634, " . $new_language_id . ",'Idaho'),
(3635, " . $new_language_id . ",'Illinois'),
(3636, " . $new_language_id . ",'Indiana'),
(3637, " . $new_language_id . ",'Iowa'),
(3638, " . $new_language_id . ",'Kansas'),
(3639, " . $new_language_id . ",'Kentucky'),
(3640, " . $new_language_id . ",'Luisiana'),
(3641, " . $new_language_id . ",'Maine'),
(3642, " . $new_language_id . ",'Islas Marshall'),
(3643, " . $new_language_id . ",'Maryland'),
(3644, " . $new_language_id . ",'Massachusetts'),
(3645, " . $new_language_id . ",'Michigan'),
(3646, " . $new_language_id . ",'Minnesota'),
(3647, " . $new_language_id . ",'Misisipí'),
(3648, " . $new_language_id . ",'Misuri'),
(3649, " . $new_language_id . ",'Montana'),
(3650, " . $new_language_id . ",'Nebraska'),
(3651, " . $new_language_id . ",'Nevada'),
(3652, " . $new_language_id . ",'New Hampshire'),
(3653, " . $new_language_id . ",'Nueva Jersey'),
(3654, " . $new_language_id . ",'Nuevo Mexico'),
(3655, " . $new_language_id . ",'Nueva York'),
(3656, " . $new_language_id . ",'Carolina del Norte'),
(3657, " . $new_language_id . ",'Dakota del Norte'),
(3658, " . $new_language_id . ",'Islas Marianas del Norte'),
(3659, " . $new_language_id . ",'Ohio'),
(3660, " . $new_language_id . ",'Oklahoma'),
(3661, " . $new_language_id . ",'Oregón'),
(3662, " . $new_language_id . ",'Palau'),
(3663, " . $new_language_id . ",'Pensilvania'),
(3664, " . $new_language_id . ",'Puerto Rico'),
(3665, " . $new_language_id . ",'Rhode Island'),
(3666, " . $new_language_id . ",'Carolina del Sur'),
(3667, " . $new_language_id . ",'Dakota del Sur'),
(3668, " . $new_language_id . ",'Tennesse'),
(3669, " . $new_language_id . ",'Texas'),
(3670, " . $new_language_id . ",'Utah'),
(3671, " . $new_language_id . ",'Vermont'),
(3672, " . $new_language_id . ",'Islas Vírgenes'),
(3673, " . $new_language_id . ",'Virginia'),
(3674, " . $new_language_id . ",'Washington'),
(3675, " . $new_language_id . ",'Virginia Occidental'),
(3676, " . $new_language_id . ",'Wisconsin'),
(3677, " . $new_language_id . ",'Wyoming'),
(3678, " . $new_language_id . ",'Baker Island'),
(3679, " . $new_language_id . ",'Howland Island'),
(3680, " . $new_language_id . ",'Jarvis Island'),
(3681, " . $new_language_id . ",'Johnston Atoll'),
(3682, " . $new_language_id . ",'Kingman Reef'),
(3683, " . $new_language_id . ",'Midway Atoll'),
(3684, " . $new_language_id . ",'Navassa Island'),
(3685, " . $new_language_id . ",'Palmyra Atoll'),
(3686, " . $new_language_id . ",'Wake Island'),
(3687, " . $new_language_id . ",'Artigas'),
(3688, " . $new_language_id . ",'Canelones'),
(3689, " . $new_language_id . ",'Cerro Largo'),
(3690, " . $new_language_id . ",'Colonia'),
(3691, " . $new_language_id . ",'Durazno'),
(3692, " . $new_language_id . ",'Flores'),
(3693, " . $new_language_id . ",'Florida'),
(3694, " . $new_language_id . ",'Lavalleja'),
(3695, " . $new_language_id . ",'Maldonado'),
(3696, " . $new_language_id . ",'Montevideo'),
(3697, " . $new_language_id . ",'Paysandu'),
(3698, " . $new_language_id . ",'Río Negro'),
(3699, " . $new_language_id . ",'Rivera'),
(3700, " . $new_language_id . ",'Rocha'),
(3701, " . $new_language_id . ",'Salto'),
(3702, " . $new_language_id . ",'San José'),
(3703, " . $new_language_id . ",'Soriano'),
(3704, " . $new_language_id . ",'Tacuarembo'),
(3705, " . $new_language_id . ",'Treinta y Tres'),
(3706, " . $new_language_id . ",'Andijon'),
(3707, " . $new_language_id . ",'Buxoro'),
(3708, " . $new_language_id . ",'Farg&#39;ona'),
(3709, " . $new_language_id . ",'Jizzax'),
(3710, " . $new_language_id . ",'Namangan'),
(3711, " . $new_language_id . ",'Navoiy'),
(3712, " . $new_language_id . ",'Qashqadaryo'),
(3713, " . $new_language_id . ",'Qoraqalpog&#39;iston Republikasi'),
(3714, " . $new_language_id . ",'Samarcanda'),
(3715, " . $new_language_id . ",'Sirdaryo'),
(3716, " . $new_language_id . ",'Surxondaryo'),
(3717, " . $new_language_id . ",'Toshkent City'),
(3718, " . $new_language_id . ",'Tashkent Región'),
(3719, " . $new_language_id . ",'Xorazm'),
(3720, " . $new_language_id . ",'Malampa'),
(3721, " . $new_language_id . ",'Penama'),
(3722, " . $new_language_id . ",'Sanma'),
(3723, " . $new_language_id . ",'Shefa'),
(3724, " . $new_language_id . ",'Tafea'),
(3725, " . $new_language_id . ",'Torba'),
(3726, " . $new_language_id . ",'Amazonas'),
(3727, " . $new_language_id . ",'Anzoategui'),
(3728, " . $new_language_id . ",'Apure'),
(3729, " . $new_language_id . ",'Aragua'),
(3730, " . $new_language_id . ",'Barinas'),
(3731, " . $new_language_id . ",'Bolívar'),
(3732, " . $new_language_id . ",'Carabobo'),
(3733, " . $new_language_id . ",'Cojedes'),
(3734, " . $new_language_id . ",'Delta Amacuro'),
(3735, " . $new_language_id . ",'Dependencias Federales'),
(3736, " . $new_language_id . ",'Distrito Federal'),
(3737, " . $new_language_id . ",'Halcón'),
(3738, " . $new_language_id . ",'Guárico'),
(3739, " . $new_language_id . ",'Lara'),
(3740, " . $new_language_id . ",'Mérida'),
(3741, " . $new_language_id . ",'Miranda'),
(3742, " . $new_language_id . ",'Monagas'),
(3743, " . $new_language_id . ",'Nueva Esparta'),
(3744, " . $new_language_id . ",'Portuguesa'),
(3745, " . $new_language_id . ",'Sucre'),
(3746, " . $new_language_id . ",'Táchira'),
(3747, " . $new_language_id . ",'Trujillo'),
(3748, " . $new_language_id . ",'Vargas'),
(3749, " . $new_language_id . ",'Yaracuy'),
(3750, " . $new_language_id . ",'Zulia'),
(3751, " . $new_language_id . ",'An Giang'),
(3752, " . $new_language_id . ",'Bac Giang'),
(3753, " . $new_language_id . ",'Bac Kan'),
(3754, " . $new_language_id . ",'Bac Lieu'),
(3755, " . $new_language_id . ",'Bac Ninh'),
(3756, " . $new_language_id . ",'Ba Ria-Vung Tau'),
(3757, " . $new_language_id . ",'Ben Tre'),
(3758, " . $new_language_id . ",'Binh Dinh'),
(3759, " . $new_language_id . ",'Binh Duong'),
(3760, " . $new_language_id . ",'Binh Phuoc'),
(3761, " . $new_language_id . ",'Binh Thuan'),
(3762, " . $new_language_id . ",'Ca Mau'),
(3763, " . $new_language_id . ",'Can Tho'),
(3764, " . $new_language_id . ",'Cao Bang'),
(3765, " . $new_language_id . ",'Dak Lak'),
(3766, " . $new_language_id . ",'Dak Nong'),
(3767, " . $new_language_id . ",'Da Nang'),
(3768, " . $new_language_id . ",'Dien Bien'),
(3769, " . $new_language_id . ",'Dong Nai'),
(3770, " . $new_language_id . ",'Dong Thap'),
(3771, " . $new_language_id . ",'Gia Lai'),
(3772, " . $new_language_id . ",'Ha Giang'),
(3773, " . $new_language_id . ",'Hai Duong'),
(3774, " . $new_language_id . ",'Hai Phong'),
(3775, " . $new_language_id . ",'Ha Nam'),
(3776, " . $new_language_id . ",'Ha Noi'),
(3777, " . $new_language_id . ",'Ha Tay'),
(3778, " . $new_language_id . ",'Ha Tinh'),
(3779, " . $new_language_id . ",'Hoa Binh'),
(3780, " . $new_language_id . ",'Ho Chi Minh City'),
(3781, " . $new_language_id . ",'Hau Giang'),
(3782, " . $new_language_id . ",'Hung Yen'),
(3783, " . $new_language_id . ",'Saint Croix'),
(3784, " . $new_language_id . ",'San Juan'),
(3785, " . $new_language_id . ",'Santo Tomás'),
(3786, " . $new_language_id . ",'Alo'),
(3787, " . $new_language_id . ",'Sigave'),
(3788, " . $new_language_id . ",'Wallis'),
(3789, " . $new_language_id . ",'Abyan'),
(3790, " . $new_language_id . ",'Adan'),
(3791, " . $new_language_id . ",'Amran'),
(3792, " . $new_language_id . ",'Al Bayda'),
(3793, " . $new_language_id . ",'Ad Dali'),
(3794, " . $new_language_id . ",'Dhamar'),
(3795, " . $new_language_id . ",'Hadramawt'),
(3796, " . $new_language_id . ",'Hajjah'),
(3797, " . $new_language_id . ",'Al Hudaydah'),
(3798, " . $new_language_id . ",'Ibb'),
(3799, " . $new_language_id . ",'Al Jawf'),
(3800, " . $new_language_id . ",'Lahij'),
(3801, " . $new_language_id . ",'Ma&#39;rib'),
(3802, " . $new_language_id . ",'Al Mahrah'),
(3803, " . $new_language_id . ",'Al Mahwit'),
(3804, " . $new_language_id . ",'Sa&#39;dah'),
(3805, " . $new_language_id . ",'Sana'),
(3806, " . $new_language_id . ",'Shabwah'),
(3807, " . $new_language_id . ",'Ta&#39;izz'),
(3808, " . $new_language_id . ",'Kosovo'),
(3809, " . $new_language_id . ",'Montenegro'),
(3810, " . $new_language_id . ",'Serbia'),
(3811, " . $new_language_id . ",'Vojvodina'),
(3812, " . $new_language_id . ",'Bas-Congo'),
(3813, " . $new_language_id . ",'Bandundu'),
(3814, " . $new_language_id . ",'Ecuador'),
(3815, " . $new_language_id . ",'Katanga'),
(3816, " . $new_language_id . ",'Kasai-Oriental'),
(3817, " . $new_language_id . ",'Kinshasa'),
(3818, " . $new_language_id . ",'Kasai-Occidental'),
(3819, " . $new_language_id . ",'Maniema'),
(3820, " . $new_language_id . ",'Nord-Kivu'),
(3821, " . $new_language_id . ",'Orientale'),
(3822, " . $new_language_id . ",'Sud-Kivu'),
(3823, " . $new_language_id . ",'Central'),
(3824, " . $new_language_id . ",'Copperbelt'),
(3825, " . $new_language_id . ",'Oriental'),
(3826, " . $new_language_id . ",'Luapula'),
(3827, " . $new_language_id . ",'Lusaka'),
(3828, " . $new_language_id . ",'Del norte'),
(3829, " . $new_language_id . ",'Noroccidental'),
(3830, " . $new_language_id . ",'Meridional'),
(3831, " . $new_language_id . ",'Occidental'),
(3832, " . $new_language_id . ",'Bulawayo'),
(3833, " . $new_language_id . ",'Harare'),
(3834, " . $new_language_id . ",'Manicaland'),
(3835, " . $new_language_id . ",'Mashonaland central'),
(3836, " . $new_language_id . ",'Mashonaland Oriental'),
(3837, " . $new_language_id . ",'Mashonaland West'),
(3838, " . $new_language_id . ",'Masvingo'),
(3839, " . $new_language_id . ",'Matabeleland Norte'),
(3840, " . $new_language_id . ",'Matabeleland Sur'),
(3841, " . $new_language_id . ",'Midlands'),
(3842, " . $new_language_id . ",'Agrigento'),
(3843, " . $new_language_id . ",'Alessandria'),
(3844, " . $new_language_id . ",'Ancona'),
(3845, " . $new_language_id . ",'Aosta'),
(3846, " . $new_language_id . ",'Arezzo'),
(3847, " . $new_language_id . ",'Ascoli Piceno'),
(3848, " . $new_language_id . ",'Asti'),
(3849, " . $new_language_id . ",'Avellino'),
(3850, " . $new_language_id . ",'Bari'),
(3851, " . $new_language_id . ",'Belluno'),
(3852, " . $new_language_id . ",'Benevento'),
(3853, " . $new_language_id . ",'Bergamo'),
(3854, " . $new_language_id . ",'Biella'),
(3855, " . $new_language_id . ",'Bologna'),
(3856, " . $new_language_id . ",'Bolzano'),
(3857, " . $new_language_id . ",'Brescia'),
(3858, " . $new_language_id . ",'Brindisi'),
(3859, " . $new_language_id . ",'Cagliari'),
(3860, " . $new_language_id . ",'Caltanissetta'),
(3861, " . $new_language_id . ",'Campobasso'),
(3862, " . $new_language_id . ",'Carbonia-Iglesias'),
(3863, " . $new_language_id . ",'Caserta'),
(3864, " . $new_language_id . ",'Catania'),
(3865, " . $new_language_id . ",'Catanzaro'),
(3866, " . $new_language_id . ",'Chieti'),
(3867, " . $new_language_id . ",'Como'),
(3868, " . $new_language_id . ",'Cosenza'),
(3869, " . $new_language_id . ",'Cremona'),
(3870, " . $new_language_id . ",'Crotone'),
(3871, " . $new_language_id . ",'Cuneo'),
(3872, " . $new_language_id . ",'Enna'),
(3873, " . $new_language_id . ",'Ferrara'),
(3874, " . $new_language_id . ",'Firenze'),
(3875, " . $new_language_id . ",'Foggia'),
(3876, " . $new_language_id . ",'Forli-Cesena'),
(3877, " . $new_language_id . ",'Frosinone'),
(3878, " . $new_language_id . ",'Genova'),
(3879, " . $new_language_id . ",'Gorizia'),
(3880, " . $new_language_id . ",'Grosseto'),
(3881, " . $new_language_id . ",'Imperia'),
(3882, " . $new_language_id . ",'Isernia'),
(3883, " . $new_language_id . ",'L&#39;Aquila'),
(3884, " . $new_language_id . ",'La Spezia'),
(3885, " . $new_language_id . ",'Latina'),
(3886, " . $new_language_id . ",'Lecce'),
(3887, " . $new_language_id . ",'Lecco'),
(3888, " . $new_language_id . ",'Livorno'),
(3889, " . $new_language_id . ",'Lodi'),
(3890, " . $new_language_id . ",'Lucca'),
(3891, " . $new_language_id . ",'Macerata'),
(3892, " . $new_language_id . ",'Mantova'),
(3893, " . $new_language_id . ",'Massa-Carrara'),
(3894, " . $new_language_id . ",'Matera'),
(3895, " . $new_language_id . ",'Medio Campidano'),
(3896, " . $new_language_id . ",'Messina'),
(3897, " . $new_language_id . ",'Milano'),
(3898, " . $new_language_id . ",'Modena'),
(3899, " . $new_language_id . ",'Napoli'),
(3900, " . $new_language_id . ",'Novara'),
(3901, " . $new_language_id . ",'Nuoro'),
(3902, " . $new_language_id . ",'Ogliastra'),
(3903, " . $new_language_id . ",'Olbia-Tempio'),
(3904, " . $new_language_id . ",'Oristano'),
(3905, " . $new_language_id . ",'Padova'),
(3906, " . $new_language_id . ",'Palermo'),
(3907, " . $new_language_id . ",'Parma'),
(3908, " . $new_language_id . ",'Pavia'),
(3909, " . $new_language_id . ",'Perugia'),
(3910, " . $new_language_id . ",'Pesaro y Urbino'),
(3911, " . $new_language_id . ",'Pescara'),
(3912, " . $new_language_id . ",'Piacenza'),
(3913, " . $new_language_id . ",'Pisa'),
(3914, " . $new_language_id . ",'Pistoia'),
(3915, " . $new_language_id . ",'Pordenone'),
(3916, " . $new_language_id . ",'Potenza'),
(3917, " . $new_language_id . ",'Prato'),
(3918, " . $new_language_id . ",'Ragusa'),
(3919, " . $new_language_id . ",'Ravenna'),
(3920, " . $new_language_id . ",'Reggio Calabria'),
(3921, " . $new_language_id . ",'Reggio Emilia'),
(3922, " . $new_language_id . ",'Rieti'),
(3923, " . $new_language_id . ",'Rimini'),
(3924, " . $new_language_id . ",'Roma'),
(3925, " . $new_language_id . ",'Rovigo'),
(3926, " . $new_language_id . ",'Salerno'),
(3927, " . $new_language_id . ",'Sassari'),
(3928, " . $new_language_id . ",'Savona'),
(3929, " . $new_language_id . ",'Siena'),
(3930, " . $new_language_id . ",'Siracusa'),
(3931, " . $new_language_id . ",'Sondrio'),
(3932, " . $new_language_id . ",'Taranto'),
(3933, " . $new_language_id . ",'Teramo'),
(3934, " . $new_language_id . ",'Terni'),
(3935, " . $new_language_id . ",'Torino'),
(3936, " . $new_language_id . ",'Trapani'),
(3937, " . $new_language_id . ",'Trento'),
(3938, " . $new_language_id . ",'Treviso'),
(3939, " . $new_language_id . ",'Trieste'),
(3940, " . $new_language_id . ",'Udine'),
(3941, " . $new_language_id . ",'Varese'),
(3942, " . $new_language_id . ",'Venezia'),
(3943, " . $new_language_id . ",'Verbano-Cusio-Ossola'),
(3944, " . $new_language_id . ",'Vercelli'),
(3945, " . $new_language_id . ",'Verona'),
(3946, " . $new_language_id . ",'Vibo Valentia'),
(3947, " . $new_language_id . ",'Vicenza'),
(3948, " . $new_language_id . ",'Viterbo'),
(3949, " . $new_language_id . ",'Antrim'),
(3950, " . $new_language_id . ",'Armagh'),
(3951, " . $new_language_id . ",'Abajo'),
(3952, " . $new_language_id . ",'Fermanagh'),
(3953, " . $new_language_id . ",'Derry'),
(3954, " . $new_language_id . ",'Tyrone');
");

$this->db->query("INSERT INTO " . $this->db->table('stock_statuses') . "
(`stock_status_id`,`language_id`, `name`) VALUES
(1, " . $new_language_id . ", 'En stock'),
(2, " . $new_language_id . ", 'Agotado'),
(3, " . $new_language_id . ", 'Pre-Orden');
");

$this->db->query("INSERT INTO " . $this->db->table('length_class_descriptions') . "
(`length_class_id`, `language_id`, `title`, `unit`) VALUES
(1, " . $new_language_id . ", 'Centímetro', 'cm'),
(2, " . $new_language_id . ", 'Milímetro', 'mm'),
(3, " . $new_language_id . ", 'Pulgada', 'in');
");

$this->db->query("INSERT INTO " . $this->db->table('weight_class_descriptions') . "
(`weight_class_id`, `language_id`, `title`, `unit`) VALUES
(1, " . $new_language_id . ", 'Kilogramo', 'kg'),
(2, " . $new_language_id . ", 'Gramo', 'g'),
(5, " . $new_language_id . ", 'Libra ', 'lb'),
(6, " . $new_language_id . ", 'Onza', 'oz');
");

$this->db->query("INSERT INTO " . $this->db->table('order_statuses') . "
(`order_status_id`, `language_id`, `name`) VALUES
(0, " . $new_language_id . ", 'Incompleto'),
(1, " . $new_language_id . ", 'Pendiente'),
(2, " . $new_language_id . ", 'Tratamiento'),
(3, " . $new_language_id . ", 'Enviado'),
(7, " . $new_language_id . ", 'Cancelado'),
(5, " . $new_language_id . ", 'Completo'),
(8, " . $new_language_id . ", 'Denegado'),
(9, " . $new_language_id . ", 'Reversión cancelado'),
(10, " . $new_language_id . ", 'Fracasado'),
(11, " . $new_language_id . ", 'Devuelto'),
(12, " . $new_language_id . ", 'Invertido'),
(13, " . $new_language_id . ", 'Devolución de cargo');
");

$this->db->query("INSERT INTO " . $this->db->table('page_descriptions') . "
(`page_id`, `language_id`, `name`, `title`, `seo_url`, `keywords`, `description`, `content`, `date_added`) VALUES
(1, " . $new_language_id . ", 'Las demás páginas', '', '', '', '', '', now() ),
(2, " . $new_language_id . ", 'Página de inicio', '', '', '', '', '', now() ),
(3, " . $new_language_id . ", 'Pedido Páginas', '', '', '', '', '', now() ),
(4, " . $new_language_id . ", 'La página de acceso', '', '', '', '', '', now() ),
(5, " . $new_language_id . ", 'Por defecto la Hoja de Producto', '', '', '', '', '', now() ),
(10, " . $new_language_id . ", 'Mantenimiento de la página.', '', '', '', '', '', now() ),
(11, " . $new_language_id . ", 'Cuenta Cliente Páginas', '', '', '', '', '', now() );
");

$this->db->query("INSERT INTO " . $this->db->table('global_attributes_type_descriptions') . "
(`attribute_type_id`, `language_id`, `type_name`, `date_added`) VALUES
(1, " . $new_language_id . ", 'Opción del Producto', NOW()),
(2, " . $new_language_id . ", 'Descargar Atributo', NOW());
");

$this->db->query("INSERT INTO " . $this->db->table('form_descriptions') . "
(`form_id`, `language_id`, `description`) VALUES
(2, " . $new_language_id . ",'Formulario de Contacto');
");

$this->db->query("INSERT INTO " . $this->db->table('field_descriptions') . "
(`field_id`, `name`, `error_text`, `language_id`) VALUES
(14,'Introduzca el código en el cuadro a continuación:','El código de verificación no coincide con la imagen!', " . $new_language_id . "),
(13,'Consulta:','La petición debe ser superior de 10 caracteres y menos de 1000!', " . $new_language_id . "),
(12,'Email:','El Correo electrónico no parece válido!', " . $new_language_id . "),
(11,'Nombre de pila:','El nombre debe tener entre 3 y 32 caractéres!', " . $new_language_id . ");
");

$this->cache->remove('localization');
