<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2023 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (! defined ( 'DIR_CORE' )) {
    header ( 'Location: static_pages/' );
}

require_once DIR_EXT.'constantcontact_integration'.DIR_EXT_CORE.'lib/ctct/vendor/autoload.php';

/**
 * Class ControllerPagesExtensionConstantContactIntegration
 * @property ModelExtensionConstantContactIntegration $model_extension_constantcontact_integration
 */

class ControllerResponsesExtensionConstantContactIntegration extends AController {
    public $data=[];
    private $end_time;

    public function main(){}

    public function addTop() {
        $this->loadModel('extension/constantcontact_integration');
        $contents=$this->_prepareData();
        $this->data['result']=$this->model_extension_constantcontact_integration->updateContent('top',$contents);
        $this->load->library('json');
        $this->response->setOutput(AJson::encode($this->data));

    }

    public function addBottom() {
        $this->loadModel('extension/constantcontact_integration');
        $contents=$this->_prepareData();
        $this->data['result']=$this->model_extension_constantcontact_integration->updateContent('bottom',$contents);
        $this->load->library('json');
        $this->response->setOutput(AJson::encode($this->data));
    }

    public function _prepareData() {
        if (isset($this->request->post['data'])) {
            $this->load->library('json');
            $obj = AJson::decode(html_entity_decode($this->request->post['data']));
            $data['content']=$obj->content;
            return $data;
        }
    }

    public function refreshToken() {
        $store_id = $this->getStoreId();
        $settings = $this->getSetting('constantcontact_integration', $store_id);
        if ($settings['client_id']) {
            $client = new \PHPFUI\ConstantContact\Client($settings['client_id'], $settings['client_secret'], HTTPS_SERVER);
            $token_info = $this->getInfo();
            if ($token_info) {
                // Set access and refresh tokens on client
                $client->accessToken = $token_info['access_token'];
                $client->refreshToken = $token_info['refresh_token'];
                // Refresh the tokens.  This should be done on a regular (daily) basis so the token does not expire.
                $token = $client->refreshToken();
                $data['access_token'] = $client->accessToken;
                $data['refresh_token'] = $client->refreshToken;
                $this->updateInfo($data);

                $message = 'access token: '.$client->accessToken."\n";
                $message.= 'refresh token: '.$client->refreshToken."\n";
                $message.= 'last error: '.$client->getLastError();

                /**$mail = new AMail($this->config);
                $mail->setTo($this->config->get('store_main_email'));
                $mail->setFrom($this->config->get('store_main_email'));
                $mail->setSender($this->config->get('store_name'));
                $subject=realpath(DIR_EXT.'constantcontact_integration/cron_task.php');
                $mail->setSubject($subject);

                $mail->setHtml($message);
                $mail->send(); **/

                echo $message;
            }
        }
    }

    /**
     * @return mixed
     * @throws AException
     */
    public function getInfo() {
        $sql = "SELECT * FROM ".$this->db->table("constantcontact_integration_token");
        $query = $this->db->query($sql);
        return $query->row;
    }
    
    /**
     * @param $data
     * @return void
     */
    public function updateInfo($data) {
        $sql = "UPDATE ".$this->db->table("constantcontact_integration_token")." SET `access_token`='".$data['access_token']."',`refresh_token`='".$data['refresh_token']."' WHERE `store_id`='".$data['store_id']."'";
        $this->db->query($sql);
    }

    /**
     * @param string $group
     * @param int    $store_id
     *
     * @return array
     */
    public function getSetting($group, $store_id = 0) {
        $data = [];

        $query = $this->db->query(
            "SELECT *
            FROM ".$this->db->table("settings")." 
            WHERE `group` = '".$this->db->escape($group)."'
                AND store_id = '".(int)$store_id."'"
        );
        foreach ($query->rows as $result) {
            $value = $result['value'];
            if (is_serialized($value)) {
                $value = unserialize($value);
            }
            $data[$result['key']] = $value;
        }
        return $data;
    }
    
    public function getList() {
        //$cc = new ConstantContact($this->api);
        //$token=$this->request->get['access_token'];
        //$obj=$cc->getLists($token);
        //$lists=[];
        //foreach ($obj as $key){
        //    $lists[]=['id'=>$key->id,'name'=>$key->name];
        //}
        //array_unshift($lists,['id'=>'NONE','name'=>'NONE']);
        //$this->data['lists']=$lists;
        //$store_id = $this->getStoreId();
        //$this->load->model('setting/setting');
        //$settings = $this->model_setting_setting->getSetting('constantcontact_integration', $store_id);
        //$this->data['selectedList' ] = $settings['constantcontact_integration_list'];
        //$this->view->batchAssign($this->data);
        //$this->processTemplate('responses/extension/ctct_list.tpl');
    }

    public function getStoreId() {
        $store_id = (int) $this->config->get('config_store_id');
        if (has_value($this->request->get_or_post('store_id'))) {
            $store_id = (int) $this->request->get_or_post('store_id');
        } else {
            if ($this->session->data['current_store_id']) {
                $store_id = (int) $this->session->data['current_store_id'];
            }
        }
        return $store_id;
    }
}