<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2023 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (! defined ( 'DIR_CORE' )) {
    header ( 'Location: static_pages/' );
}

require_once DIR_EXT.'constantcontact_integration'.DIR_EXT_CORE.'lib/ctct/vendor/autoload.php';

require_once DIR_SYSTEM . "lib/vendor/autoload.php";
require_once DIR_SYSTEM . "lib/license.php";

/**
 * Class ControllerPagesExtensionConstantContactIntegration
 * @property ModelExtensionConstantContactIntegration $model_extension_constantcontact_integration
 */

class ControllerPagesExtensionConstantContactIntegrationSettings extends AController {

    public $data=[];

    public function verify() {
        $this->load->model('extension/constantcontact_integration_license_info');
        $license_key = $this->config->get('constantcontact_integration_license_code');
        if ($license_key) {
            $exist = $this->db->query("SHOW TABLES LIKE '" . $this->db->table('constantcontact_integration_license_info') . "'");
            if ($exist->num_rows === 1) {
                $store_id = $this->model_extension_constantcontact_integration_license_info->getStoreId();
                $license_key = $this->model_extension_constantcontact_integration_license_info->getLicenseCode($store_id);
                $license_info = $this->model_extension_constantcontact_integration_license_info->getLicenseData($store_id);
                $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                $license = new License($path_to_phpseclib);
                $license_manager = $license->getManager();
                $license_manager->setKeys($license_key, $license_info['public_key'], 'constantcontact_integration');
                $ttl = 1209600;
                $validate = $license_manager->validate($license_info['license_data'], $ttl);
                $store_status = $this->model_extension_constantcontact_integration_license_info->getLicensedStoreStatus();
                if ($validate['status'] === 'valid' && $store_status == 1) {
                    return true;
                } else {
                    return false;
                }
            }
        } else {
            return false;
        }
    }

    public function verifyEditor() {
        if ( $this->config->get( 'editor_status' ) === '1' ) {
            $this->load->model('extension/editor_license_info');
            $license_key = $this->config->get('editor_license_code');
            if ($license_key) {
                $exist = $this->db->query("SHOW TABLES LIKE '" . $this->db->table('editor_license_info') . "'");
                if ($exist->num_rows === 1) {
                    $store_id = $this->model_extension_editor_license_info->getStoreId();
                    $license_key = $this->model_extension_editor_license_info->getLicenseCode($store_id);
                    $license_info = $this->model_extension_editor_license_info->getLicenseData($store_id);
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    $license_manager->setKeys($license_key, $license_info['public_key'], 'editor');
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_info['license_data'], $ttl);
                    $store_status = $this->model_extension_editor_license_info->getLicensedStoreStatus();
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                }
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    public function main() {
        $this->loadLanguage('constantcontact_integration/constantcontact_integration');
        $this->loadLanguage('extension/extensions');

        $this->load->model('extension/constantcontact_integration');
        $exist = $this->model_extension_constantcontact_integration->getInfo();

        if ($this->request->is_POST()) {
            if ($exist) {
                $store_id = $this->getStoreId();
                $this->load->model('setting/setting');
                $this->model_setting_setting->editSetting('constantcontact_integration', $this->request->post, $store_id);
                $this->session->data['success'] = $this->language->get('text_settings_success');
            } else {
                $this->load->model('setting/setting');
                $this->load->model('extension/constantcontact_integration');
                $store_id = $this->getStoreId();
                $this->model_setting_setting->editSetting('constantcontact_integration', $this->request->post, $store_id);
                $redirectURI = HTTPS_SERVER;
                $url = $this->html->getSecureURL('extension/constantcontact_integration_settings', '&extension=constantcontact_integration');
                $this->model_extension_constantcontact_integration->setRedirect($url);
                $client = new \PHPFUI\ConstantContact\Client($this->request->post['client_id'], $this->request->post['client_secret'], $redirectURI);
                header('location: ' . $client->getAuthorizationURL());
            }
        }

        if (isset($this->request->get['action']) && $this->request->get['action'] === 'logout') {
            $this->model_extension_constantcontact_integration->resetInfo();
            redirect($this->html->getSecureURL('extension/constantcontact_integration_settings', '&extension=constantcontact_integration'));
        }

        if ($exist) {
            $this->view->assign('heading_title', $this->language->get('settings_heading_title'));
            $store_id = $this->getStoreId();
            $this->load->model('setting/setting');
            $settings = $this->model_setting_setting->getSetting('constantcontact_integration', $store_id);

            $this->data ['action'] = $this->html->getSecureURL('extension/constantcontact_integration_settings');
            $this->data ['heading_title'] = $this->language->get('text_settings');
            $this->data ['form_title'] = $this->language->get('settings_heading_title');

            $form = new AForm ('HS');

            $form->setForm([
                    'form_name' => 'settingsFrm',
                    'update' => '']
            );

            $this->data['form']['form_open'] = $form->getFieldHtml([
                    'type' => 'form',
                    'name' => 'settingsFrm',
                    'action' => $this->data ['action'],
                    'attr' => 'data-confirm-exit="true" class="aform form-horizontal"'
                ]
            );

            // Create a client
            $client = new \PHPFUI\ConstantContact\Client($settings['client_id'], $settings['client_secret'], HTTPS_SERVER);
            $token_info = $this->model_extension_constantcontact_integration->getInfo();
            // Set access and refresh tokens on client
            $client->accessToken = $token_info['access_token'];
            $client->refreshToken = $token_info['refresh_token'];
            $last_error = $client->getLastError();
            if ($last_error!=='') {
                if (stripos($last_error,'401 Unauthorized')!==false) {
                    $this->refreshToken();
                    $client->accessToken = $token_info['access_token'];
                    $client->refreshToken = $token_info['refresh_token'];
                } else {
                    $this->log->write($last_error);
                }
            }
            // $client is now ready to use
            $listEndPoint = new \PHPFUI\ConstantContact\V3\ContactLists($client);
            $listsResponse = $listEndPoint->get();
            $lists = $listsResponse['lists'];

            foreach ($lists as $list) {
                $listItems[$list['list_id']] = $list['name'];
            }

            $this->data['form']['fields']['constantcontact_integration_list'] = $form->getFieldHtml([
                    'type' => 'selectbox',
                    'name' => 'constantcontact_integration_list',
                    'options' => $listItems,
                    'value' => $settings['constantcontact_integration_list'],
                    'style' => 'small-field',
                ]
            );

            $this->data['form']['fields']['constantcontact_integration_popup_list'] = $form->getFieldHtml([
                    'type' => 'selectbox',
                    'name' => 'constantcontact_integration_popup_list',
                    'options' => $listItems,
                    'value' => $settings['constantcontact_integration_popup_list'],
                    'style' => 'small-field',
                ]
            );

            $this->data['form']['fields']['constantcontact_integration_admin_email'] = $form->getFieldHtml([
                    'type' => 'input',
                    'name' => 'constantcontact_integration_admin_email',
                    'value' => $settings['constantcontact_integration_admin_email'],
                    'style' => 'small-field',
                ]
            );

            $this->data['form']['fields']['constantcontact_integration_universal_code'] = $form->getFieldHtml([
                    'type' => 'textarea',
                    'name' => 'constantcontact_integration_universal_code',
                    'value' => $settings['constantcontact_integration_universal_code'],
                    'style' => 'large-field',
                ]
            );

            $this->data['form']['fields']['constantcontact_integration_inline_code'] = $form->getFieldHtml([
                    'type' => 'textarea',
                    'name' => 'constantcontact_integration_inline_code',
                    'value' => $settings['constantcontact_integration_inline_code'],
                    'style' => 'large-field',
                ]
            );

            $options = [
                '0' => $this->language->get('text_no'),
                '1' => $this->language->get('text_yes')
            ];

            $this->data['form']['fields']['constantcontact_integration_firstname'] = $form->getFieldHtml([
                    'type' => 'selectbox',
                    'name' => 'constantcontact_integration_firstname',
                    'options' => $options,
                    'value' => $settings['constantcontact_integration_firstname'],
                    'style' => 'small-field',
                ]
            );

            $this->data['form']['fields']['constantcontact_integration_lastname'] = $form->getFieldHtml([
                    'type' => 'selectbox',
                    'name' => 'constantcontact_integration_lastname',
                    'options' => $options,
                    'value' => $settings['constantcontact_integration_lastname'],
                    'style' => 'small-field',
                ]
            );

            $this->data['logout_url'] = $this->html->getSecureURL('extension/constantcontact_integration_settings', '&action=logout');
            $this->data['button_logout'] = $this->language->get('button_logout');

            $template = 'pages/extension/constantcontact_integration_setting.tpl';
        } else {
            if ($this->request->is_GET() && isset($this->request->get['code'])) {
                $this->load->model('setting/setting');
                $this->load->model('extension/constantcontact_integration');
                $this->model_extension_constantcontact_integration->resetRedirect();
                $redirectURI = HTTPS_SERVER;
                $store_id = $this->getStoreId();
                $settings = $this->model_setting_setting->getSetting('constantcontact_integration', $store_id);
                $client = new \PHPFUI\ConstantContact\Client($settings['client_id'], $settings['client_secret'], $redirectURI);
                $client->acquireAccessToken($_GET);
                $data['store_id'] = $this->getStoreId();
                $data['code'] = $this->request->get['code'];
                $data['state'] = $this->request->get['state'];
                $data['access_token'] = $client->accessToken;
                $data['refresh_token'] = $client->refreshToken;
                $this->model_extension_constantcontact_integration->saveInfo($data);
                redirect($this->html->getSecureURL('extension/constantcontact_integration_settings', '&extension=constantcontact_integration'));
            }
            $this->document->setTitle($this->language->get('login_heading_title'));

            $this->data ['action'] = $this->html->getSecureURL ( 'extension/constantcontact_integration_settings' );
            $this->data ['heading_title'] = $this->language->get ( 'text_login' ) ;
            $this->data ['form_title'] = $this->language->get ( 'login_heading_title' );

            $form = new AForm ( 'HS' );
            $form->setForm ( array (
                'form_name' => 'loginFrm',
                'update' => '') );

            $this->data['text_login'] = $this->language->get('text_login');

            $this->data['form']['form_open'] = $form->getFieldHtml([
                'type' => 'form',
                'name' => 'loginFrm',
                'action' => $this->data ['action'],
                'attr' => 'data-confirm-exit="true" class="aform form-horizontal"'
            ]);
            $this->data['form']['fields']['client_id'] = $form->getFieldHtml([
                    'type' => 'input',
                    'name' => 'client_id',
                    'value' => $this->data['client_id'],
                    'required' => true,
                    'style' => 'medium-field',
                ]
            );
            $this->data['form']['fields']['client_secret'] = $form->getFieldHtml([
                'type' => 'input',
                'name' => 'client_secret',
                'value' => $this->data['client_secret'],
                'required' => true,
                'style' => 'medium-field',
            ]);
            $this->data['form']['submit'] = $form->getFieldHtml([
                    'type' => 'button',
                    'name' => 'submit',
                    'text' => $this->language->get('button_obtain')
                ]
            );
            $template = 'pages/extension/constantcontact_integration_login.tpl';
        }

        $this->document->setTitle($this->language->get('settings_heading_title'));

        $this->document->initBreadcrumb([
            'href' => $this->html->getSecureURL('index/home'),
            'text' => $this->language->get('text_home'),
            'separator' => FALSE
        ]);

        $this->document->addBreadcrumb( [
            'href'      => $this->html->getSecureURL('extension/extensions/extensions'),
            'text'      => $this->language->get('text_extensions'),
            'separator' => ' :: '
        ]);

        $this->document->addBreadcrumb([
            'href' => $this->html->getSecureURL('extension/constantcontact_integration_settings'),
            'text' => $this->language->get('settings_heading_title'),
            'separator' => ' :: '
        ]);

        $this->view->assign('error_warning', $this->session->data[ 'warning' ]);
        $this->view->assign('success', $this->session->data[ 'success' ]);
        if (isset($this->session->data[ 'success' ])) {
            unset($this->session->data[ 'success' ]);
        }
        if (isset($this->session->data[ 'warning' ])) {
            unset($this->session->data[ 'warning' ]);
        }

        $this->data['cancel']         = $this->html->getSecureURL( 'extension/extensions' );
        $this->data['license_status'] = $this->verify();
        $this->data['text_unauthorized'] = $this->language->get( 'text_ctct_unauthorized' );
        $this->data['ext_man'] =  'https://why2central.net/v1/ctct-134';
        $this->data['settings_note'] =  $this->language->get('constantcontact_integration_settings_note');
        $this->view->batchAssign($this->data);
        $this->processTemplate($template);
    }

    public function refreshToken() {
        $store_id = $this->getStoreId();
        $settings = $this->getSetting('constantcontact_integration', $store_id);
        if ($settings['client_id']) {
            $client = new \PHPFUI\ConstantContact\Client($settings['client_id'], $settings['client_secret'], HTTPS_SERVER);
            $token_info = $this->getInfo();
            if ($token_info) {
                // Set access and refresh tokens on client
                $client->accessToken = $token_info['access_token'];
                $client->refreshToken = $token_info['refresh_token'];
                // Refresh the tokens.  This should be done on a regular (daily) basis so the token does not expire.
                $token = $client->refreshToken();
                $data['access_token'] = $client->accessToken;
                $data['refresh_token'] = $client->refreshToken;
                $this->updateInfo($data);
            }
        }
    }

    /**
     * @return mixed
     * @throws AException
     */
    public function getInfo() {
        $sql = "SELECT * FROM ".$this->db->table("constantcontact_integration_token");
        $query = $this->db->query($sql);
        return $query->row;
    }

    /**
     * @param $data
     * @return void
     */
    public function updateInfo($data) {
        $sql = "UPDATE ".$this->db->table("constantcontact_integration_token")." SET `access_token`='".$data['access_token']."',`refresh_token`='".$data['refresh_token']."' WHERE `store_id`='".$data['store_id']."'";
        $this->db->query($sql);
    }

    /**
     * @param string $group
     * @param int    $store_id
     *
     * @return array
     */
    public function getSetting($group, $store_id = 0) {
        $data = [];

        $query = $this->db->query(
            "SELECT *
            FROM ".$this->db->table("settings")." 
            WHERE `group` = '".$this->db->escape($group)."'
                AND store_id = '".(int)$store_id."'"
        );
        foreach ($query->rows as $result) {
            $value = $result['value'];
            if (is_serialized($value)) {
                $value = unserialize($value);
            }
            $data[$result['key']] = $value;
        }
        return $data;
    }

    public function getStoreId() {
        $store_id = (int) $this->config->get('config_store_id');
        if (has_value($this->request->get_or_post('store_id'))) {
            $store_id = (int) $this->request->get_or_post('store_id');
        } else {
            if ($this->session->data['current_store_id']) {
                $store_id = (int) $this->session->data['current_store_id'];
            }
        }
        return $store_id;
    }
}