<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2025 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

/**
 * Class ModelExtensionBannerManager
 */

/** @noinspection PhpUndefinedClassInspection */
class ModelExtensionBannerStatisticManager extends Model {

    /**
     * @param $data
     *
     * @return int
     */
    public function add($data){
        $this->deleteChart($data['banner_id']);
        $sql="INSERT INTO ".$this->db->table("banner_statistic_manager_chart")."
				( `banner_id`, `value`) VALUES
				('" . $data[ 'banner_id' ] . "', '" . $data[ 'chart' ] . "')";
        $this->db->query($sql);
        $chart_id = $this->db->getLastId();
        return $chart_id;
    }

    /**
     * @param $banner_id
     */
    public function deleteChart($banner_id) {
        $sql="DELETE FROM ".$this->db->table("banner_statistic_manager_chart")." WHERE `banner_id` = '" . $banner_id . "'";
        $this->db->query($sql);
    }

    /**
     * @param $banner_id
     *
     * @return mixed
     */
    public function getChart($banner_id) {
        $sql="SELECT  `value` FROM ".$this->db->table("banner_statistic_manager_chart")." WHERE `banner_id` = '" . $banner_id . "'";
        $query = $this->db->query($sql);
        return $query->row['value'];
    }

    /**
     * @return array
     */
    public function getBanners() {
        if (!empty($data['content_language_id'])) {
            $language_id = (int)$data['content_language_id'];
        } else {
            $language_id = (int)$this->language->getContentLanguageID();
        }
        $sql = "SELECT bd.*, b.*
                    FROM ".$this->db->table("banners")." b
                    LEFT JOIN ".$this->db->table("banner_descriptions")." bd 
                        ON (b.banner_id = bd.banner_id AND bd.language_id = '".$language_id."')
                        ORDER BY bd.name ASC";
        $result = $this->db->query($sql);
        return $result->rows;
    }

    /**
     * @param array  $filter
     * @param string $mode
     *
     * @return int|array
     */
    public function getBannersStat($filter, $mode = '')  {
        if (!empty($data['content_language_id'])) {
            $language_id = ( int )$this->language->getContentLanguageID();
        } else {
            $language_id = (int)$this->config->get('storefront_language_id');
        }

        $stats = [];

        $period=$filter['filter']['period'];
        switch ($period) {
            case 'today':
                $filter_start_date = date("Y-m-d");
                $filter_end_date = date("Y-m-d");
                break;
            case 'yesterday':
                $filter_start_date = date('Y-m-d', strtotime("-1 days"));
                $filter_end_date = date('Y-m-d', strtotime("-1 days"));
                break;
            case 'last_seven_days' :
                $filter_start_date = date('Y-m-d', strtotime("-7 days"));
                $filter_end_date = date('Y-m-d',strtotime("-1 days"));
                break;
            case 'last_week' :
                $previous_week = strtotime("-1 week +1 day");
                $start_last_week = strtotime("last sunday midnight",$previous_week);
                $end_last_week = strtotime("next saturday",$start_last_week);
                $filter_start_date = date('Y-m-d', $start_last_week);
                $filter_end_date = date('Y-m-d', $end_last_week);
                break;
            case 'last_business_week' :
                $previous_week = strtotime("-1 week +1 day");
                $start_last_week = strtotime("last monday midnight",$previous_week);
                $end_last_week = strtotime("next friday midnight",$start_last_week);
                $filter_start_date = date('Y-m-d',$start_last_week);
                $filter_end_date = date('Y-m-d',$end_last_week);
                break;
            case 'this_month' :
                $filter_start_date = date("Y-m-d", strtotime(date('m').'/01/'.date('Y').' 00:00:00'));
                $filter_end_date =date("Y-m-d", strtotime(date('m').'/'.date('t').'/'.date('Y')));
                break;
            case 'last_month' :
                $last_month_start = strtotime('first day of last month');
                $filter_start_date = date("Y-m-d", $last_month_start);
                $last_month_end = strtotime('last day of last month');
                $filter_end_date = date("Y-m-d", $last_month_end);
                break;
            case 'custom_range' :
                $filter_start_date = $filter['filter']['filter_date_start'];
                $filter_end_date = $filter['filter']['filter_date_end'];
                break;
        }

        if ($mode === 'total_only') {
            $sql = "SELECT COUNT(*) as total
                    FROM ".$this->db->table("banner_stat") ." bt
                    LEFT JOIN ".$this->db->table("banner_descriptions")." bd
                    ON (bd.banner_id = bt.banner_id AND bd.language_id = '".$language_id."')";

            $sql.= ' WHERE 1';

            if (!empty($filter['filter']['banner_id'])) {
                $sql .= " AND bt.banner_id=".$filter['filter']['banner_id'];
            }

            if (!empty($filter['subsql_filter'])) {
                $sql .= " AND ".$filter['subsql_filter'];
            }

            if ($filter['filter']['period']) {
                if ($filter['filter']['period']==='all') {
                    $sql .='';
                } elseif ($filter['filter']['period']==='today' || $filter['filter']['period']==='yesterday') {
                    $sql .= " AND DATE(`time`) ='" . $filter_start_date . "'";
                } else {
                    $sql .= " AND DATE(`time`) >= '" . $filter_start_date . "'";
                    $sql .= " AND DATE(`time`) <= '" . $filter_end_date . "'";
                }
            }
            $result = $this->db->query($sql);
            $output = (int)$result->row['total'];
        } else {
            $sql = "SELECT *
                    FROM ".$this->db->table("banner_stat")." bt
                    LEFT JOIN ".$this->db->table("banners")." b ON b.banner_id = bt.banner_id
                    LEFT JOIN ".$this->db->table("banner_descriptions")." bd 
                    ON (bd.banner_id = b.banner_id AND bd.language_id = '".$language_id."')";

            $sql.= ' WHERE 1';

            if (!empty($filter['filter']['banner_id'])) {
                $sql .= " AND bt.banner_id=".$filter['filter']['banner_id'];
            }

            if (!empty($filter['subsql_filter'])) {
                $sql .= " AND ".$filter['subsql_filter'];
            }

            if ($filter['filter']['period']) {
                if ($filter['filter']['period']==='all') {
                    $sql .='';
                } elseif ($filter['filter']['period']==='today' || $filter['filter']['period']==='yesterday') {
                    $sql .= " AND DATE(`time`) = '" . $filter_start_date . "'";
                } else {
                    $sql .= " AND DATE(`time`) >= '" . $filter_start_date . "'";
                    $sql .= " AND DATE(`time`) <= '" . $filter_end_date . "'";
                }
            }
            $sort_data = [
                'time'         =>  'bt.time',
            ];

            if (isset($filter['sort']) && array_key_exists($filter['sort'], $sort_data)) {
                $sql .= " ORDER BY ".$sort_data[$filter['sort']];
            } else {
                //for faster SQL default to ID based order
                $sql .= " ORDER BY bt.time";
            }

            if (isset($filter['order']) && ($filter['order'] == 'DESC')) {
                $sql .= " DESC";
            } else {
                $sql .= " ASC";
            }

            if (isset($filter['start']) || isset($filter['limit'])) {
                if ($filter['start'] < 0) {
                    $filter['start'] = 0;
                }

                if ($filter['limit'] < 1) {
                    $filter['limit'] = 20;
                }
                $sql .= " LIMIT ".(int)$filter['start'].",".(int)$filter['limit'];
            }

            $result = $this->db->query($sql);
            foreach ($result->rows as $row) {
                $output[]=[
                    'id' => $row['rowid'],
                    'name' => $row['name'],
                    'time' => $row['time'],
                    'viewed' => $row['type']==='1' ? 'Yes' : 'No',
                    'clicked' => $row['type']!=='1' ? 'Yes' : 'No',
                ];
            }
        }
        return $output;
    }

    /**
     * @param int   $banner_id
     * @param array $data
     *
     * @return bool
     */
    public function deleteStatistic($banner_stat_id = 0)    {
        $sql = "DELETE FROM ".$this->db->table("banner_stat")." WHERE rowid=".$banner_stat_id;
        $this->db->query($sql);
        return true;
    }

    /**
     * @param $param
     */
    public function renderStatistics($param) {
        $period = $param['period'];
        $banner_id = $param['banner_id'];
        $from = $param['from'];
        $to = $param['to'];
        $this->loadLanguage('banner_statistic_manager/banner_statistic_manager');

        $data = [];

        switch ($period) {
            case 'all' :
                $months = ['1','2','3','4','5','6','7','8','9','10','11','12'];
                $count = "SELECT COUNT(*) as total FROM ".$this->db->table("banner_stat")." WHERE banner_id =".$banner_id;
                $totals = $this->db->query($count);
                $total = $totals->row['total'];
                if ($total > 0) {
                    $min_year       = "SELECT MIN(YEAR(`time`)) as min_year FROM " . $this->db->table( "banner_stat" ) . " WHERE banner_id =" . $banner_id;
                    $min_month      = "SELECT MIN(MONTH(`time`)) as min_month FROM " . $this->db->table( "banner_stat" ) . " WHERE banner_id =" . $banner_id;
                    $max_year       = "SELECT MAX(YEAR(`time`)) as max_year FROM " . $this->db->table( "banner_stat" ) . " WHERE banner_id =" . $banner_id;
                    $min            = $this->db->query( $min_year );
                    $minMonth       = $this->db->query( $min_month );
                    $max            = $this->db->query( $max_year );
                    $starting_year  = $min->row['min_year'];
                    $starting_month = $minMonth->row['min_month'];
                    $ending_year    = $max->row['max_year'];

                    $j = 0;
                    $count=[];
                    for ( $i = $starting_year; $i <= $ending_year; $i ++ ) {
                        foreach ( $months as $month ) {
                            if ( $month < $starting_month ) {
                                continue;
                            }
                            $sql   = "SELECT MONTH(`time`) as month, YEAR(`time`) as year,`type`, COUNT(`type`) AS cnt
							FROM " . $this->db->table( "banner_stat" ) . " 
							WHERE banner_id =" . $banner_id . " AND MONTH(`time`)='" . $month . "' AND YEAR(`time`)='" . $i . "'
							GROUP BY `type`, MONTH(`time`)
							ORDER BY `time` ASC";
                            $query = $this->db->query( $sql );
                            if ( $query->num_rows ) {
                                foreach ( $query->rows as $row ) {
                                    $type           = $row['type'] === '1' ? 'viewed' : 'clicked';
                                    $count[$month.'/'.$i][$type] = $row['cnt'];
                                }
                                $data[]         = [
                                    $month . '/' . $i,
                                    ! empty( $count[$month.'/'.$i]['viewed'] ) !== '' ? (int) $count[$month.'/'.$i]['viewed'] : 0,
                                    ! empty( $count[$month.'/'.$i]['clicked'] ) !== '' ? (int) $count[$month.'/'.$i]['clicked'] : 0
                                ];
                            } else {
                                $data[] = [
                                    $month . '/' . $i,
                                    0,
                                    0
                                ];
                            }
                        }
                    }
                }
                break;
            case 'custom_range':
                $j   = 0;
                $sqlTime = "SELECT DATE(`time`) as time
							FROM " . $this->db->table( "banner_stat" ) . " 
							WHERE banner_id =" . $banner_id . " AND DATE(`time`) >='" . $from . "' AND DATE(`time`) <='" . $to . "'
								AND banner_id = '" . $banner_id . "' 
								GROUP BY DATE(`time`)
							ORDER BY `time` ASC";
                $queryTime = $this->db->query($sqlTime);
                $results = $queryTime->rows;
                foreach ($results as $result) {
                    $sql = "SELECT DATE(`time`) as time, `type`, COUNT(`type`) AS cnt
							FROM " . $this->db->table( "banner_stat" ) . " 
							WHERE banner_id =" . $banner_id . " AND DATE(`time`) ='" . $result['time'] . "'
								AND banner_id = '" . $banner_id . "' 
								GROUP BY `type`, DATE(`time`)
							ORDER BY `time` ASC";

                    $query = $this->db->query( $sql );
                    if ( $query->num_rows ) {
                        foreach ( $query->rows as $row ) {
                            $type                           = $row['type'] == '1' ? 'viewed' : 'clicked';
                            $count[ $result['time'] ][ $type ] = $row['cnt'];
                        }
                        $data[]                         = [
                            $row['time'],
                            ! empty( $count[ $result['time'] ]['viewed'] ) !== '' ? (int) $count[ $result['time'] ]['viewed'] : 0,
                            ! empty( $count[ $result['time'] ]['clicked'] ) !== '' ? (int) $count[ $result['time'] ]['clicked'] : 0
                        ];
                    }
                }
                break;
            case 'today':
                $today = Date('Y-m-d');
                for ($i = 0; $i < 24; $i++) {
                    $time = date( 'H', mktime( $i, 0, 0, date( 'n' ), date( 'j' ), date( 'Y' ) ) );
                    $sql = "SELECT `type`, COUNT(`type`) AS cnt
							FROM ".$this->db->table("banner_stat")." 
							WHERE (DATE(`time`) LIKE '%".$today."%' AND HOUR(`time`) = '".(int)$i."')
								AND banner_id = '".$banner_id."'
							GROUP BY `type`, HOUR(`time`)
							ORDER BY `time` ASC";
                    $query = $this->db->query($sql);
                    if ($query->num_rows) {
                        foreach ( $query->rows as $row ) {
                            $type                    = $row['type'] == '1' ? 'viewed' : 'clicked';
                            $count[ $time ][ $type ] = $row['cnt'];
                        }
                        $data[] = [
                            $time,
                            ! empty( $count[ $time ]['viewed'] ) !== '' ? (int) $count[ $time ]['viewed'] : 0,
                            ! empty( $count[ $time ]['clicked'] ) !== '' ? (int) $count[ $time ]['clicked'] : 0
                        ];
                    } else {
                        $data[] =[
                            $time,
                            0,
                            0
                        ];
                    }
                }
                break;
            case 'yesterday' :
                $yesterday = DATE('Y-m-d',strtotime('yesterday'));
                for ($i = 0; $i < 24; $i++) {
                    $time = date( 'H', mktime( $i, 0, 0, date( 'n' ), date( 'j' ), date( 'Y' ) ) );
                    $sql = "SELECT `type`, COUNT(`type`) AS cnt
							FROM ".$this->db->table("banner_stat")." 
							WHERE (DATE(`time`) LIKE '%".$yesterday."%' AND HOUR(`time`) = '".(int)$i."')
								AND banner_id = '".$banner_id."'
							GROUP BY `type`, HOUR(`time`)
							ORDER BY `time` ASC";
                    $query = $this->db->query($sql);
                    if ($query->num_rows) {
                        foreach ( $query->rows as $row ) {
                            $type                    = $row['type'] == '1' ? 'viewed' : 'clicked';
                            $count[ $time ][ $type ] = $row['cnt'];
                        }
                        $data[] = [
                            $time,
                            ! empty( $count[ $time ]['viewed'] ) !== '' ? (int) $count[ $time ]['viewed'] : 0,
                            ! empty( $count[ $time ]['clicked'] ) !== '' ? (int) $count[ $time ]['clicked'] : 0
                        ];
                    } else {
                        $data[] =[
                            $time,
                            0,
                            0
                        ];
                    }
                }
                break;
            case 'last_seven_days':
                $date_start = strtotime("-7 days");

                for ($i = 0; $i < 7; $i++) {
                    $date = date('Y-m-d', $date_start + ($i * 86400));

                    $sql = "SELECT `type`, COUNT(`type`) AS cnt
							FROM ".$this->db->table("banner_stat")." 
							WHERE DATE(`time`) = '".$this->db->escape($date)."'
								AND banner_id = '".$banner_id."'
							GROUP BY `type`, DATE(`time`)
							ORDER BY `time` ASC";

                    $query = $this->db->query($sql);
                    if ($query->num_rows) {
                        foreach ( $query->rows as $row ) {
                            $type                    = $row['type'] == '1' ? 'viewed' : 'clicked';
                            $count[ $date ][ $type ] = $row['cnt'];
                        }
                        $data[] = [
                            date( 'D / Y-m-d', strtotime( $date ) ),
                            ! empty( $count[ $date ]['viewed'] ) !== '' ? (int) $count[ $date ]['viewed'] : 0,
                            ! empty( $count[ $date ]['clicked'] ) !== '' ? (int) $count[ $date ]['clicked'] : 0
                        ];
                    } else {
                        $data[]=[
                            date('D / Y-m-d', strtotime($date)),
                            0,
                            0
                        ];
                    }
                }
                break;
            case 'last_week':
                $previous_week = strtotime("-1 week +1 day");
                $date_start = strtotime("last sunday midnight",$previous_week);
                for ($i = 0; $i < 7; $i++) {
                    $date = date('Y-m-d', $date_start + ($i * 86400));
                    $sql = "SELECT `type`, COUNT(`type`) AS cnt
							FROM ".$this->db->table("banner_stat")." 
							WHERE DATE(`time`) = '".$this->db->escape($date)."'
								AND banner_id = '".$banner_id."'
							GROUP BY `type`, DATE(`time`)
							ORDER BY `time` ASC";
                    $query = $this->db->query($sql);

                    if ($query->num_rows) {
                        foreach ( $query->rows as $row ) {
                            $type                    = $row['type'] == '1' ? 'viewed' : 'clicked';
                            $count[ $date ][ $type ] = $row['cnt'];
                        }
                        $data[] = [
                            date( 'D / Y-m-d', strtotime( $date ) ),
                            ! empty( $count[ $date ]['viewed'] ) !== '' ? (int) $count[ $date ]['viewed'] : 0,
                            ! empty( $count[ $date ]['clicked'] ) !== '' ? (int) $count[ $date ]['clicked'] : 0
                        ];
                    } else {
                        $data[]=[
                            date('D / Y-m-d', strtotime($date)),
                            0,
                            0
                        ];
                    }
                }
                break;
            case 'last_business_week':
                $previous_week = strtotime("-1 week +1 day");
                $date_start = strtotime("last monday midnight",$previous_week);
                for ($i = 0; $i < 5; $i++) {
                    $date = date('Y-m-d', $date_start + ($i * 86400));

                    $sql = "SELECT `type`, COUNT(`type`) AS cnt
							FROM ".$this->db->table("banner_stat")." 
							WHERE DATE(`time`) = '".$this->db->escape($date)."'
								AND banner_id = '".$banner_id."'
							GROUP BY `type`, DATE(`time`)
							ORDER BY `time` ASC";
                    $query = $this->db->query($sql);
                    if ($query->num_rows) {
                        foreach ( $query->rows as $row ) {
                            $type                    = $row['type'] == '1' ? 'viewed' : 'clicked';
                            $count[ $date ][ $type ] = $row['cnt'];
                        }
                        $data[] = [
                            date( 'D / Y-m-d', strtotime( $date ) ),
                            ! empty( $count[ $date ]['viewed'] ) !== '' ? (int) $count[ $date ]['viewed'] : 0,
                            ! empty( $count[ $date ]['clicked'] ) !== '' ? (int) $count[ $date ]['clicked'] : 0
                        ];
                    } else {
                        $data[]=[
                            date('D / Y-m-d', strtotime($date)),
                            0,
                            0
                        ];
                    }
                }
                break;
            case 'this_month':
                $last_day_this_month= date('t');
                for ($i = 1; $i <= $last_day_this_month; $i++) {
                    $date = date('Y').'-'.date('m').'-'.$i;
                    $sql = "SELECT `type`, COUNT(`type`) AS cnt
							FROM ".$this->db->table("banner_stat")." 
							WHERE DATE(`time`) = '".$this->db->escape($date)."'
								AND banner_id = '".$banner_id."'
							GROUP BY `type`, DATE(`time`)
							ORDER BY `time` ASC";
                    $query = $this->db->query($sql);
                    if ($query->num_rows) {
                        foreach ( $query->rows as $row ) {
                            $type           = $row['type'] == '1' ? 'viewed' : 'clicked';
                            $count[$date][ $type ] = $row['cnt'];
                        }
                        $data[]         = [
                            date( 'j', strtotime( $date ) ),
                            ! empty( $count[$date]['viewed'] ) !== '' ? (int) $count[$date]['viewed'] : 0,
                            ! empty( $count[$date]['clicked'] ) !== '' ? (int) $count[$date]['clicked'] : 0
                        ];

                    } else {
                        $data[]=[
                            date('j', strtotime($date)),
                            0,
                            0
                        ];
                    }
                }
                break;
            case 'last_month':
                $last_day_prev_month= date('t',strtotime('last day of previous month'));
                for ($i = 1; $i <= $last_day_prev_month; $i++) {
                    $date = date('Y').'-'.date('m',strtotime('previous month')).'-'.$i;
                    $sql = "SELECT `type`, COUNT(`type`) AS cnt
							FROM ".$this->db->table("banner_stat")." 
							WHERE DATE(`time`) = '".$this->db->escape($date)."'
								AND banner_id = '".$banner_id."'
							GROUP BY `type`, DATE(`time`)
							ORDER BY `time` ASC";
                    $query = $this->db->query($sql);
                    if ($query->num_rows) {
                        foreach ( $query->rows as $row ) {
                            $type                    = $row['type'] == '1' ? 'viewed' : 'clicked';
                            $count[ $date ][ $type ] = $row['cnt'];
                        }
                        $data[] = [
                            date( 'j', strtotime( $date ) ),
                            ! empty( $count[ $date ]['viewed'] ) !== '' ? (int) $count[ $date ]['viewed'] : 0,
                            ! empty( $count[ $date ]['clicked'] ) !== '' ? (int) $count[ $date ]['clicked'] : 0
                        ];
                    } else {
                        $data[]=[
                            date('j', strtotime($date)),
                            0,
                            0
                        ];
                    }
                }
                break;
        }
        return $data;
    }
}