<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2025 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

require DIR_EXT.'banner_statistic_manager'.DIR_EXT_CORE.'lib/exports/vendor/autoload.php';
/**
 * Class ControllerResponsesExtensionBannerStatisticManagerChart
 * @property ModelExtensionBannerStatisticManager $model_extension_banner_statistic_manager
 */

class ControllerResponsesExtensionBannerStatisticManagerChart extends AController {
	public $data =[];

    public function main() {

        //init controller data
        $this->extensions->hk_InitData($this, __FUNCTION__);
        $this->loadLanguage('banner_statistic_manager/banner_statistic_manager');

        if (isset($this->request->get['period'])) {
            $period = $this->request->get['period'];
        } else {
            $period = 'month';
        }

        if (isset($this->request->get['from'])) {
        	$from = $this->request->get['from'];
        } else {
	        $from = '';
        }

	    if (isset($this->request->get['to'])) {
		    $to = $this->request->get['to'];
	    } else {
		    $to = '';
	    }

        $banner_id = (int)$this->request->get['banner_id'];
        if (!$banner_id) {
            return null;
        }

        $param['period'] = $period;
        $param['banner_id'] = $banner_id;
        $param['from'] = $from;
        $param['to'] = $to;
        $this->load->model('extension/banner_statistic_manager');
		$result = $this->model_extension_banner_statistic_manager->renderStatistics($param);
		//update controller data
        $this->extensions->hk_UpdateData($this, __FUNCTION__);

        $this->load->library('json');
	    $this->response->setOutput(AJson::encode($result));
    }

    public function saveChart() {
    	$post=$this->request->post['data'];
    	$this->load->model('extension/banner_statistic_manager');
        $obj = json_decode(html_entity_decode($post));
        $data['banner_id'] = $obj->banner_id;
        $data['chart'] = $obj->chart;
        $this->model_extension_banner_statistic_manager->add($data);
    }

}
