<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2017 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

/**
 * Class ExtensionAdmin
 * @property ModelExtensionEnhancedAdmin $model_extension_enhanced_admin
 */
class ExtensionEnhancedAdmin extends Extension {
    public $data = array();

    public function  __construct() {
        $this->registry = Registry::getInstance();
    }

    private function _is_enabled() {
        $that =& $this->baseObject;
        return $that->config->get('enhanced_admin_status') ? true : false;
    }

    public function onControllerCommonHeader_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        $dir = HTTPS === true ? HTTPS_DIR_RESOURCE : HTTP_DIR_RESOURCE;
        $config = $this->registry->get('config');
        $logo = $config->get('enhanced_admin_admin_logo');
        if (IS_ADMIN && $logo) {
            if (preg_match('/(http:\/\/|https:\/\/)/', $logo)) {
                $img_src = $logo;
            } else {
                $img_src = $dir . $config->get('enhanced_admin_admin_logo');
            }
            $logo = '<img src="' . $img_src . '" title="new logo"/>';
            $that->view->addHookVar('logoimage_hookvar', $logo);
            if ($config->get('enhanced_admin_feed_url')) {
                $this->_insertRss($config->get('enhanced_admin_feed_url'));
            }
        } elseif (IS_ADMIN && $config->get('enhanced_admin_status') === '1') {
            if ($config->get('enhanced_admin_feed_url')) {
                $this->_insertRss($config->get('enhanced_admin_feed_url'));
            }
        }
    }

    public function onControllerCommonHead_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if (IS_ADMIN && $that->user->isLogged()) {
            $that->loadLanguage('enhanced_admin/enhanced_admin');
            $this->data['text_read_all_feed'] = $that->language->get('text_read_all_feed');
            $this->data['feed_viewer_url'] = $that->html->getSecureURL('extension/feed_viewer');
            $this->data['feed_updater_url'] = $that->html->getSecureURL('listing_grid/enhanced_admin/getnotifies');
            $that->view->batchAssign($this->data);
        } else {
            $that->document->addStyle(
                array(
                    'href' => $that->view->templateResource('/stylesheet/enhanced_admin.css'),
                    'rel' => 'stylesheet'
                )
            );
        }
    }



    private function _insertRss($url) {

        $rss = simplexml_load_file($url);
        $get = "SELECT * FROM ".$this->registry->get('db')->table("rss_feed")." ORDER BY id ASC";
        $avail = $this->registry->get('db')->query($get);
        $avails = $avail->rows;
        $guid = array();
        $dbGuid = array();
        if ($rss->channel->item) {
            foreach ($rss->channel->item as $item) {
                $guid[] = $item->guid;
                $select = "SELECT title FROM ".$this->registry->get('db')->table("rss_feed")." WHERE title = '" . $item->title . "'";
                $res = $this->registry->get('db')->query($select);
                $exist = $res->row;
                if (!$exist) {
                    $sql = "INSERT INTO ".$this->registry->get('db')->table("rss_feed")."
				(`title`,`link`,`guid`,`description`,`date_created`,`viewed`)
				VALUES ('" . $item->title . "',
				        '" . $item->link . "',
				        '" . $item->guid . "',
				        '" . $item->description . "',
				        '" . date('Y-m-d g:i:s', strtotime($item->pubDate)) . "',
				         0 )";
                    $this->registry->get('db')->query($sql);
                }
            }
            foreach ($avails as $al) {
                $dbGuid[] = $al['guid'];
            }
            $result = array_diff($dbGuid, $guid);
            if ($result) {
                foreach ($result as $coba => $key) {
                    $this->registry->get('db')->query("DELETE FROM " . $this->registry->get('db')->table("rss_feed") . " WHERE `guid` = '" . $key . "'");
                }
            }
        } else {
            $this->registry->get('db')->query("DELETE FROM " . $this->registry->get('db')->table("rss_feed"));
        }
    }


    public function onControllerCommonFooter_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $config = $this->registry->get('config');
        $that =& $this->baseObject;
        if (IS_ADMIN && $config->get('enhanced_admin_status')) {
	        $menu = new AMenu('admin', 'menu');
	        $documentation = $menu->getMenuItem('core_docs');
	        $that->view->assign('doc_menu', $documentation);
	        $that->view->assign('doc_menu_text', $that->language->get($documentation['item_text']));
	        $that->loadLanguage('enhanced_admin/enhanced_admin');
            $that->view->assign('status', $config->get('enhanced_admin_status'));
            $that->view->assign('text_project', $that->language->get('text_project'));
            $that->view->assign('project_url', 'https://abantecartplus.com');
            $that->view->assign('text_docs', $that->language->get('text_docs'));
            $that->view->assign('docs_url', 'https://why2central.net/v1/');
            $that->view->assign('text_abc_support', $that->language->get('text_abc_support','enhanced_admin_enhanced_admin'));
            $that->view->assign('support_url', 'https://abantecartplus.com/clientarea/client');
            $that->view->assign('enhanced_text_footer', $that->language->get('text_powered_by_abcplus'));
            $that->processTemplate('common/footer.tpl');
        } else {
        	$that->load->language('enhanced_admin/enhanced_admin');
            $that->view->assign('text_project_label', html_entity_decode($config->get('enhanced_admin_bottom_sf'), ENT_COMPAT, 'UTF-8'));
            $sy=$that->config->get('enhanced_admin_copyright_year');
            $cy=date('Y', time());
            if ($sy!=''){
                if ($sy==$cy) {
                    $link=" &copy;". $cy . " " .$that->config->get('store_name');
                }
                else {
                    $link=" &copy; ". $sy . " - " . $cy  . " " .$that->config->get('store_name');
                }
            } else {
                $link=" &copy; ". $cy . " " .$that->config->get('store_name');
            }
            $link.="<br>".$that->language->get('text_powered_by');
	        $that->view->assign('text_copy',$link);
        }
    }

    public function onModelCheckoutOrder_ProcessData() {
        $that =& $this->baseObject;
        if ($this->baseObject_method==='sf_order_confirm_mail') {
        	$that->load->language('mail/order_confirm');
        	$that->data['mail_template_data']['text_project_label'] = $that->language->get('text_powered_by').' '.'<a href="https://abantecartplus.com" target="_blank">AbanteCartPlus</a>';
        }

    }
}