<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2022 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}
class ModelExtensionEmailTemplates extends Model {

    public function getTemplates() {
        $sql = "SELECT * FROM " . $this->db->table('email_editor_templates');
        $result = $this->db->query($sql);
        return $result->rows;
    }

    /**
     * @param $filter
     * @param string $mode
     * @return array
     */
    public function getAllTemplates($filter, $mode = '') {
        if ($mode == 'total_only') {
            $sql = "SELECT COUNT(*) as total FROM " . $this->db->table('email_editor_templates');
        } else {
            $sql = "SELECT * FROM " . $this->db->table('email_editor_templates'). " ORDER BY email_template_id ASC";
        }

        if (isset($filter['start']) || isset($filter['limit'])) {
            if ($filter['start'] < 0) {
                $filter['start'] = 0;
            }
            if ($filter['limit'] < 1) {
                $filter['limit'] = 20;
            }
            $sql .= $mode != 'total_only' ? " LIMIT " . (int)$filter['start'] . "," . (int)$filter['limit'] : '';
        }
        $result = $this->db->query($sql);
        $output = [];
        if ($mode == 'total_only') {
            $output = $result->row['total'];
        } else {
            foreach ($result->rows as $row) {
                if ($row['section']) {
                    $output[] = $row;
                } else {
                    $output[] = $this->getTemplate($row['email_template_id']);
                }
            }
        }
        return $output;
    }

    /**
     * @param $template_id
     * @param null $reset
     * @return mixed
     */
    public function getTemplate($template_id,$reset=Null) {
        $template_id = (int)$template_id;

        if ($reset===true) {
            $reset="UPDATE " . $this->db->table('email_editor_templates') . " SET subject=default_subject,content=default_content WHERE email_template_id=" . (int)$template_id;
            $this->db->query($reset);
        }

        $sql = "SELECT * FROM " . $this->db->table('email_editor_templates'). " WHERE email_template_id=" . (int)$template_id;
        $result = $this->db->query($sql);
        return $result->row;
    }

    public function updateTemplate($template_id,$data) {
        $fields=[
            'sender_name',
            'sender_email',
            'subject',
            'content',
            'email_signature_id',
            'notify_admin'
        ];

        $update=[];
        foreach ($fields as $f) {
            if (isset($data['email_signature']) && $f==='email_signature_id') {
                $update[] = "$f = '" . $this->db->escape($data['email_signature']) . "'";
            } elseif (isset($data[$f])) {
                $update[] = "$f = '" . $this->db->escape($data[$f]) . "'";
            }
        }

        if (!empty($update)) {
            return $this->db->query("UPDATE " . $this->db->table('email_editor_templates') . " SET " . implode(',', $update) . " WHERE email_template_id = '" . (int)$template_id . "'");
        }
    }

    public function getEmailTemplateId($section) {
        $query = $this->db->query("SELECT `email_template_id`,`email_signature_id` FROM ".$this->db->table('email_editor_templates')." WHERE `section`='".$section."'");
        return $query->row;
    }

    public function updateEmailTemplateSection($data) {
        $query_existing_section_name = $this->db->query("SELECT `section_name` FROM ".$this->db->table('email_editor_customer_group')." WHERE `customer_group_id`=".$data['customer_group_id']);
        $existing_section_name = $query_existing_section_name->row['section_name'];
        $this->db->query("UPDATE ".$this->db->table('email_editor_templates')." SET `section`=REPLACE(`section`,'".$existing_section_name."','".$data['section_name']."')");
        $this->db->query("UPDATE ".$this->db->table('email_editor_customer_group')." SET `section_name`='".$data['section_name']."' WHERE `customer_group_id`=".$data['customer_group_id']);
    }

    public function createEmailTemplate($data) {
        $search = [" ","'",];
        $replace = "_";
        $section = str_replace($search,$replace,strtolower($data['name']));

        $account_activated_exist = $this->db->query("SELECT COUNT(*) as total FROM ".$this->db->table('email_editor_templates')." WHERE `section`='".$section."_account_create'");
        if ($account_activated_exist->row['total']==='0') {
            $account_activated = $this->db->query("SELECT * FROM ".$this->db->table('email_editor_templates')." WHERE `section`='account_create'");
            $account_activated_info = $account_activated->row;
            $this->db->query('INSERT INTO ' . $this->db->table('email_editor_templates') . "  
                          SET `section` = '".$section."_account_create', 
                          `sender_name`='".$account_activated_info['sender_name']."',`sender_email`='".$account_activated_info['sender_email']."',`subject`='".$account_activated_info['subject']."', 
                          `default_subject`='".$account_activated_info['default_subject']."',
                          `content` = '".$account_activated_info['content']."', 
                          `default_content` = '".$account_activated_info['default_content']."',`email_signature_id` = '".$account_activated_info['email_signature_id']."',
                          `notify_admin`='".$account_activated_info['notify_admin']."'
                          ON DUPLICATE KEY UPDATE  
                          `section`=VALUES(`section`),`default_subject`=VALUES(`default_subject`),`default_content`=VALUES(`default_content`)");
            $email_id = $this->db->getLastId();
            $this->db->query('INSERT INTO ' . $this->db->table('email_editor_customer_group') . "  
                          SET `email_template_id`=".$email_id.",`customer_group_id`=".$data['customer_group_id'].",`section_name`='".$section."'");
        }

        $account_approval_exist = $this->db->query("SELECT COUNT(*) as total FROM ".$this->db->table('email_editor_templates')." WHERE `section`='".$section."_account_approval'");
        if ($account_approval_exist->row['total']==='0') {
            $account_approval = $this->db->query("SELECT * FROM ".$this->db->table('email_editor_templates')." WHERE `section`='account_approval'");
            $account_approval_info = $account_approval->row;
            $this->db->query('INSERT INTO ' . $this->db->table('email_editor_templates') . "  
                          SET `section` = '".$section."_account_approval', 
                          `sender_name`='".$account_approval_info['sender_name']."',`sender_email`='".$account_approval_info['sender_email']."',`subject`='".$account_approval_info['subject']."', 
                          `default_subject`='".$account_approval_info['default_subject']."',
                          `content` = '".$account_approval_info['content']."', 
                          `default_content` = '".$account_approval_info['default_content']."',`email_signature_id` = '".$account_approval_info['email_signature_id']."',
                          `notify_admin`='".$account_approval_info['notify_admin']."'
                          ON DUPLICATE KEY UPDATE  
                          `section`=VALUES(`section`),`default_subject`=VALUES(`default_subject`),`default_content`=VALUES(`default_content`)");
            $email_id = $this->db->getLastId();

            $this->db->query('INSERT INTO ' . $this->db->table('email_editor_customer_group') . "  
                          SET `email_template_id`=".$email_id.",`customer_group_id`=".$data['customer_group_id'].",`section_name`='".$section."'");
        }
        $account_activation_exist = $this->db->query("SELECT COUNT(*) as total FROM ".$this->db->table('email_editor_templates')." WHERE `section`='".$section."_account_activation'");
        if ($account_activation_exist->row['total']==='0') {

            $account_activation = $this->db->query("SELECT * FROM ".$this->db->table('email_editor_templates')." WHERE `section`='account_activation'");
            $account_activation_info = $account_activation->row;
            $this->db->query('INSERT INTO ' . $this->db->table('email_editor_templates') . "  
                          SET `section` = '".$section."_account_activation', 
                          `sender_name`='".$account_activation_info['sender_name']."',`sender_email`='".$account_activation_info['sender_email']."',`subject`='".$account_activation_info['subject']."', 
                          `default_subject`='".$account_activation_info['default_subject']."',
                          `content` = '".$account_activation_info['content']."', 
                          `default_content` = '".$account_activation_info['default_content']."',`email_signature_id` = '".$account_activation_info['email_signature_id']."',
                          `notify_admin`='".$account_activation_info['notify_admin']."'
                          ON DUPLICATE KEY UPDATE  
                          `section`=VALUES(`section`),`default_subject`=VALUES(`default_subject`),`default_content`=VALUES(`default_content`)");
            $email_id = $this->db->getLastId();

            $this->db->query('INSERT INTO ' . $this->db->table('email_editor_customer_group') . "  
                          SET `email_template_id`=".$email_id.",`customer_group_id`=".$data['customer_group_id'].",`section_name`='".$section."'");
        }
    }
}