<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2017 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

class ControllerResponsesExtensionEnhancedAdminSave extends AController {

    public function update() {
        //init controller data
        $this->extensions->hk_InitData($this,__FUNCTION__);
        $this->loadLanguage('extension/extensions');

        $this->load->model('setting/setting');
        $this->loadModel('extension/enhanced_admin');

        if (!$this->user->canModify('extension/extensions')) {
            $this->response->setOutput( sprintf($this->language->get('error_permission_modify'), 'extension/extensions') );
            return null;
        }

        $store_id = isset($this->request->post['store_id']) ? (int)$this->request->post['store_id'] : $this->request->get['store_id'];
        $store_id = is_null($store_id) ? $this->config->get('config_store_id') : $store_id;


        if ($this->request->post['enhanced_admin_project_url'] !='') {
            $rm = new AResourceManager();
            $rm->setType('image');
            $language_id = $this->language->getContentLanguageID();
            $data = [];
            $data['resource_code'] = '<i class="fa fa-home"></i>&nbsp;';
            $data['name'] = [$language_id => 'Menu Icon Project Home'];
            $data['title'] = [$language_id => ''];
            $data['description'] = [$language_id => ''];
            $resource_id = $rm->addResource($data);
            $this->model_extension_enhanced_admin->addRmProject($resource_id,'project');
            $menu = new AMenu ( "admin" );
            $url="window.open('".$this->request->post['enhanced_admin_project_url']."');";
            $menu->insertMenuItem ( [ "item_id" => "project_url",
                    "parent_id"=>"help",
                    "item_text" => "Project Homepage",
                    "item_url" => $url,
                    "item_type"=>"core",
                    "item_icon_rl_id" => $resource_id,
                    "sort_order"=>"5"]
            );
        } elseif ($this->request->post['enhanced_admin_project_url'] =='') {
            $project_sql="SELECT id from `".DB_PREFIX."enhanced_admin_tmp` WHERE title='project';";
            $project_result=$this->db->query($project_sql);
            $project_res=$project_result->row;
            if ($project_res['id']!='')
            {
                $project_menu = new AMenu ( "admin" );
                $project_menu->deleteMenuItem ("project_url");
                $project_rm = new AResourceManager();
                $project_rm->setType('image');
                $project_rm->deleteResource($project_res['id']);
            }
        }

        if ($this->request->post['enhanced_admin_doc_url'] !='') {
            $rm = new AResourceManager();
            $rm->setType('image');
            $language_id = $this->language->getContentLanguageID();
            $data = [];
            $data['resource_code'] = '<i class="fa fa-external-link"></i>&nbsp;';
            $data['name'] = [$language_id => 'Menu Icon Project Docs'];
            $data['title'] = [$language_id => ''];
            $data['description'] = [$language_id => ''];
            $resource_id = $rm->addResource($data);
            $this->model_extension_enhanced_admin->addRmProject($resource_id,'docs');
            $menu = new AMenu ( "admin" );
            $url="window.open('".$this->request->post['enhanced_admin_doc_url']."');";
            $menu->insertMenuItem ( [  "item_id" => "project_docs",
                    "parent_id"=>"help",
                    "item_text" => "Project Docs",
                    "item_url" => $url,
                    "item_type"=>"core",
                    "item_icon_rl_id" => $resource_id,
                    "sort_order"=>"6"]
            );
        } elseif ($this->request->post['enhanced_admin_doc_url'] =='') {
            $docs_sql="SELECT id from `".DB_PREFIX."enhanced_admin_tmp` WHERE title='docs';";
            $docs_result=$this->db->query($docs_sql);
            $docs_res=$docs_result->row;
            if ($docs_res['id']!='')
            {
                $docs_menu = new AMenu ( "admin" );
                $docs_menu->deleteMenuItem ("project_docs");
                $docs_rm = new AResourceManager();
                $docs_rm->setType('image');
                $docs_rm->deleteResource($docs_res['id']);
            }
        }

        if ($this->request->post['enhanced_admin_support_url'] !='') {
            $rm = new AResourceManager();
            $rm->setType('image');
            $language_id = $this->language->getContentLanguageID();
            $data = [];
            $data['resource_code'] = '<i class="fa fa-forward"></i>&nbsp;';
            $data['name'] = [$language_id => 'Menu Icon Project Support'];
            $data['title'] = [$language_id => ''];
            $data['description'] = [$language_id => ''];
            $resource_id = $rm->addResource($data);
            $this->model_extension_enhanced_admin->addRmProject($resource_id,'support');
            $menu = new AMenu ( "admin" );
            $url="window.open('".$this->request->post['enhanced_admin_support_url']."');";
            $menu->insertMenuItem ( [ "item_id" => "project_support",
                    "parent_id"=>"help",
                    "item_text" => "Project Support",
                    "item_url" => $url,
                    "item_type"=>"core",
                    "item_icon_rl_id" => $resource_id,
                    "sort_order"=>"7"]
            );
        } elseif ($this->request->post['enhanced_admin_support_url'] =='') {
            $support_sql="SELECT id from `".DB_PREFIX."enhanced_admin_tmp` WHERE title='support';";
            $support_result=$this->db->query($support_sql);
            $support_res=$support_result->row;
            if ($support_res['id']!='')
            {
                $support_menu = new AMenu ( "admin" );
                $support_menu->deleteMenuItem ("project_support");
                $support_rm = new AResourceManager();
                $support_rm->setType('image');
                $support_rm->deleteResource($support_res['id']);
            }
        }

        $this->request->post['store_id'] = $store_id;
        $this->extension_manager->editSetting('enhanced_admin', $this->request->post);
        //update controller data
        $this->extensions->hk_UpdateData($this,__FUNCTION__);
    }
}