<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2021 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

class ModelSalesStateReportSale extends Model {

    public $data = array ();
    private $error = array ();

    /**
     * This is for Sales By State Report
     * @param array $data
     * @return array|false|mixed|null
     */
    public function getSaleByState( $data = array()) {

        $where = "";
        $base_where = "";

        $sql1 = "SELECT o.order_id, COUNT(o.order_id) `number_orders`, o.date_added,o.shipping_zone as `zone_name`, TRIM(o.shipping_zone_id) as `zone_id`
            FROM " . $this->db->table("orders") . " o ";

        if ($data['filter_order_status_id'] != '') {
            $where .= " WHERE o.order_status_id IN (" . $data['filter_order_status_id'] . ")";
            $base_where .= " AND o.order_status_id IN (" . $data['filter_order_status_id'] . ")";
        } else {
            $where .= " WHERE o.order_status_id >= '0'";
            $base_where .= " AND o.order_status_id >= '0'";
        }

        $where .= " AND o.store_id = '0'";
        $base_where .= " AND o.store_id = '0'";

        if (!empty($data['filter_date_start'])) {
            $where .= " AND DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'";
            $base_where .= " AND DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'";
        }

        if (!empty($data['filter_date_end'])) {
            $where .= " AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'";
            $base_where .= " AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'";
        }

        $sql1 .= $where;

        $sql1 .= " GROUP BY `zone_id` ORDER BY `zone_name`";

        $query = $this->db->query($sql1);

        if ($query->num_rows > 0) {
            /*query get order info*/
            $orders = $query->rows;
            foreach ($orders as $key => $row) {
                $rows['zone_id'] = trim($row['zone_id']);
                if (!$row['zone_id']) {
                    continue;
                }
                $rows['zone_name'] = $row['zone_name'];
                $rows['number_orders'] = $row['number_orders'];

                /*Get number products*/
                $query_products = $this->db->query("SELECT SUM(op.quantity) as `items_ordered`
					 FROM " . $this->db->table("order_products") . " op
					 LEFT JOIN " . $this->db->table("orders") . " o ON o.order_id = op.order_id
					 WHERE TRIM(o.shipping_zone_id) = '" . $row['zone_id'] . "'" . $base_where);

                if ($query_products->num_rows > 0) {
                    $rows['items_ordered'] = $query_products->row['items_ordered'];
                }

                /*Get subtotal*/
                $query_subtotal = $this->db->query("SELECT SUM(ROUND(ot.value,2)) as `subtotal` FROM " . $this->db->table("order_totals") . " ot
						LEFT JOIN " . $this->db->table("orders") . " o ON o.order_id = ot.order_id
					 WHERE TRIM(o.shipping_zone_id) = '" . $row['zone_id'] . "' AND ot.type = 'subtotal'" . $base_where);
                if ($query_subtotal->num_rows > 0) {
                    $rows['subtotal'] = $query_subtotal->row['subtotal'];
                }

                /*Get total tax*/
                if ($this->validateTaxjar()) {
                    $query_tax = $this->db->query("SELECT SUM(ROUND(ot.value,2)) as `tax` FROM " . $this->db->table("order_totals") . " ot
						LEFT JOIN " . $this->db->table("orders") . " o ON o.order_id = ot.order_id
					    WHERE (TRIM(o.shipping_zone_id) = '" . $row['zone_id'] . "' AND ot.type = 'taxjar_integration') OR (TRIM(o.payment_zone_id) = '" . $row['zone_id'] . "' AND ot.type='tax')" . $base_where);
                } elseif ($this->config->get('avatax_integration_status') === '1') {
                    $query_tax = $this->db->query("SELECT SUM(ROUND(ot.value,2)) as `tax` FROM " . $this->db->table("order_totals") . " ot
						LEFT JOIN " . $this->db->table("orders") . " o ON o.order_id = ot.order_id
					    WHERE (TRIM(o.shipping_zone_id) = '" . $row['zone_id'] . "' AND ot.type = 'avatax_integration') OR (TRIM(o.payment_zone_id) = '" . $row['zone_id'] . "' AND ot.type='tax')" . $base_where);
                } else {
                    $query_tax = $this->db->query("SELECT SUM(ROUND(ot.value,2)) as `tax` FROM " . $this->db->table("order_totals") . " ot
						LEFT JOIN " . $this->db->table("orders") . " o ON o.order_id = ot.order_id
					    WHERE TRIM(o.shipping_zone_id) = '" . $row['zone_id'] . "' AND ot.type = 'tax'" . $base_where);
                }

                if ($query_tax->num_rows > 0) {
                    $rows['tax'] = $query_tax->row['tax'];
                }

                /*Get total shipping*/
                $query_shipping = $this->db->query("SELECT SUM(ot.value) as `shipping` FROM " . $this->db->table("order_totals") . " ot
					 LEFT JOIN " . $this->db->table("orders") . " o ON o.order_id = ot.order_id
					 WHERE TRIM(o.shipping_zone_id) = '" . $row['zone_id'] . "' AND ot.type = 'shipping'" . $base_where);
                if ($query_shipping->num_rows > 0) {
                    $rows['shipping'] = $query_shipping->row['shipping'];
                }

                /*Get total discount*/
                $query_discount = $this->db->query("SELECT SUM(ROUND(ot.value,2)) as `discount` FROM " . $this->db->table("order_totals") . " ot  
                    LEFT JOIN " . $this->db->table("orders") . " o ON o.order_id = ot.order_id
					 WHERE TRIM(o.shipping_zone_id) = '" . $row['zone_id'] . "'  AND ot.type = 'discount'" . $base_where);
                if ($query_discount->num_rows > 0) {
                    $rows['discount'] = $query_discount->row['discount'];
                }

                /*Get total*/
                $query_total = $this->db->query("SELECT SUM(ROUND(ot.value,2)) as `total` FROM " . $this->db->table("order_totals") . " ot  
                    LEFT JOIN " . $this->db->table("orders") . " o ON o.order_id = ot.order_id
					 WHERE TRIM(o.shipping_zone_id) = '" . $row['zone_id'] . "'  AND ot.type = 'total'" . $base_where);
                if ($query_total->num_rows > 0) {
                    $rows['total'] = $query_total->row['total'];
                }

                $rows['order_id'] = $row['order_id'];
                $rows['zone_id'] = $row['zone_id'];
                $rows['date_added'] = $row['date_added'];
                $reports[$rows['zone_id']] = $rows;
            }
        }
        return $reports;
    }

    /**
     * This is for Sales By State Code Total Order
     * @param array $data
     * @return int
     */
    public function getTotalSaleState( $data = array() ) {
        $sql1 = "SELECT COUNT(o.order_id) AS `total` FROM ".$this->db->table("orders")." o ";

        if ($data['filter_order_status_id']!='') {
            $sql1 .= " WHERE o.order_status_id IN (" . $data['filter_order_status_id'] . ")";
        } else {
            $sql1 .= " WHERE o.order_status_id >= '0'";
        }

        $sql1 .= " AND o.store_id = '0'";

        if (!empty($data['filter_date_start'])) {
            $sql1 .= " AND DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'";
        }

        if (!empty($data['filter_date_end'])) {
            $sql1 .= " AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'";
        }

        $query = $this->db->query($sql1);

        return isset($query->row['total'])?$query->row['total']:0;
    }

	private function validateTaxjar() {
		if ($this->config->get('taxjar_integration_status')==='1') {
			$exist = $this->db->query( "SHOW TABLES LIKE '" . $this->db->table( 'taxjar_integration_license' ) . "'" );
			if ( $exist->num_rows === 1 ) {
				$validation = taxjarIntegrationVerifyLicense();
				if ( $validation['notification_case'] === 'notification_license_ok' ) {
					return true;
				} elseif ( $validation['notification_case'] === 'notification_license_corrupted' ) {
					return false;
				}
			} else {
				return false;
			}
		} else {
			return false;
		}
	}
}