<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2021 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

class ModelExtensionSalesStateReportUpdater extends Model {

    /**
     * @return mixed
     */
    public function getCurrentVersion() {
        $query = $this->db->query("SELECT version FROM ".$this->db->table("extensions")." WHERE `key`='sales_state_report'");
        return $query->row['version'];
    }

    /**
     * @param $version
     * @return int
     */
    public function updateVersion($version) {
        $this->db->query("UPDATE ".$this->db->table("extensions")." SET `version`='".$version."' WHERE `key`='sales_state_report'");
        return $this->db->getLastId();
    }

    /**
     * @param $msg_id
     * @param $extension_version
     * @return int
     */
    public function saveMessageId($msg_id,$extension_version) {
        $exist = $this->getMsgId($msg_id);
        if ($exist === '0') {
            $this->db->query("INSERT INTO " . $this->db->table("sales_state_report_updater_notification") . " SET `msg_id`=" . (int)$msg_id . ",`cart_version`='" . VERSION . "', `extension_version`='" . $extension_version . "'");
            return $this->db->getLastId();
        }
    }

    public function getMsgId($msg_id) {
        $query=$this->db->query("SELECT COUNT(*) as total FROM ".$this->db->table("sales_state_report_updater_notification")." WHERE msg_id=".(int)$msg_id);
        return $query->row['total'];
    }

    /**
     * @param $extension_version
     * @return mixed
     */
    public function getMsgIdByExtVersion($extension_version) {
        $query=$this->db->query("SELECT msg_id FROM ".$this->db->table("sales_state_report_updater_notification")." WHERE `extension_version` = '".$extension_version."'");
        return $query->row['msg_id'];
    }

    /**
     * @return mixed
     */
    public function getTotalMsgIds() {
        $query=$this->db->query("SELECT COUNT(*) as total FROM ".$this->db->table("sales_state_report_updater_notification")." WHERE `cart_version` <> '".VERSION."'");
        return $query->row['total'];
    }

    /**
     * @return mixed
     */
    public function getMsgIdsByCartVersions() {
        $query=$this->db->query("SELECT msg_id FROM ".$this->db->table("sales_state_report_updater_notification")." WHERE `cart_version` <> '".VERSION."'");
        return $query->rows;
    }

    /**
     * @param $msg_id
     */
    public function deleteMsgID($msg_id) {
        $this->db->query("DELETE FROM ".$this->db->table("sales_state_report_updater_notification")." WHERE `msg_id` = ".(int)$msg_id);
    }
}