<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2021 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
header('Location: static_pages/');
}

abstract class Report_Abstract extends AController {

	public $data = array ();
	private $error = array ();

    protected $_model = null;
    protected $_reports = null;
    protected $_export_content_html = null;

    public function getBaseUrl() {
        if (isset($this->request->server['HTTPS']) && (($this->request->server['HTTPS'] == 'on') || ($this->request->server['HTTPS'] == '1'))) {
            $base = HTTPS_SERVER;
        } else {
            $base = HTTP_SERVER;
        }
        return $base;
    }

    public function getReportData() {
        return $this->_reports;
    }

    public function setModel($_model = null) {
        $this->_model = $_model;
    }

    public function getModel() {
        return $this->_model;
    }

    public function exportReport( $report = array(), $requests = array(), $type = "csv") {
        $method = "export".ucfirst($type);
        if( method_exists( $this, $method ) ){
            return $this->{$method}( $report, $requests );
        }
    }

    public function exportCsv( $report = array(), $requests = array() ) {
        require_once DIR_EXT."sales_state_report".DIR_EXT_CORE."lib/exports/csv_export.php";
        $requests['content_html'] = $this->_export_content_html;
        CsvExport::display( $report, $requests );
    }

    public function exportXml( $report = array(), $requests = array() ) {
        require_once DIR_EXT."sales_state_report".DIR_EXT_CORE."lib/exports/xml_export.php";
        XmlExport::display( $report, $requests );
    }

    public function exportPdf( $report = array(), $requests = array() ) {
        $orientation = $this->config->get('sales_state_report_export_pdf_orientation');
        $paper=$this->config->get('sales_state_report_export_pdf_paper');
        if ($report['paper']!='')
        {
            $report['paper']=$report['paper'];
        }
        else {
            $report['paper'] = isset($paper) ? $paper : 'letter';
        }
        if ($report['orientation']!='')
        {
            $report['orientation']=$report['orientation'];
        }
        else {
            $report['orientation'] = isset($orientation)?$orientation:'portrait';/*p:portrait, l: landscape*/
        }
        $requests['memory_limit'] = isset($setting['memory_limit'])?$setting['memory_limit']:'64';
        $requests['content_html'] = $this->_export_content_html;
        require_once(DIR_EXT."sales_state_report".DIR_EXT_CORE."lib/exports/pdf_export.php");
        PdfExport::display( $report, $requests );
    }

    public function exportHtml( $report = array(), $requests = array() ) {
        require_once(DIR_EXT."sales_state_report".DIR_EXT_CORE."lib/exports/html_export.php");
        $requests['content_html'] = $this->_export_content_html;
        HtmlExport::display( $report, $requests );
    }

    public function exportXLS($report = array(), $requests = array()){
        require_once(DIR_EXT."sales_state_report".DIR_EXT_CORE."lib/exports/excel_export.php");
        $requests['version'] = 'xls';
        ExcelExport::display( $report, $requests );
    }

    public function exportXLSX($report = array(), $requests = array()){
        require_once(DIR_EXT."sales_state_report".DIR_EXT_CORE."lib/exports/excel_export.php");
        $requests['version'] = 'xlsx';
        ExcelExport::display( $report, $requests );
    }

    protected function load() {
    }

    protected function queryReports( $data ){
        return $this->getModel()->getReport($data);
    }

    protected function getReports2($data = array(), $report_period = "month") {
        $results = array();
        switch ($report_period) {
            case 'day':
                $data['filter_date_start'] = isset($data['filter_date_start'])?$data['filter_date_start']:date('Y-01-01');
                $data['filter_date_end'] = isset($data['filter_date_end'])?$data['filter_date_end']:date('Y-12-31');

                $days = $this->get_day_in_range($data['filter_date_start'], $data['filter_date_end']);

                $reports = $this->queryReports($data);

                foreach($days as $key=>$val) {
                    $data['filter_date_start'] = $val['start'];
                    $data['filter_date_end'] = $val['end'];
                    $results[$key] = array();
                }

                if($reports) {
                    foreach($reports as $key=>$val) {
                        if(isset($val['datefield'])) {
                            $date_time = strtotime($val['datefield']);
                            $tmp_day = date('M d, Y', $date_time);

                            if(isset($results[$tmp_day])) {
                                $results[$tmp_day] = $val;
                            }
                        }

                    }
                }

                break;
            case 'month':
                $data['filter_date_start'] = isset($data['filter_date_start'])?$data['filter_date_start']:date('Y-01-01');
                $data['filter_date_end'] = isset($data['filter_date_end'])?$data['filter_date_end']:date('Y-12-31');

                $months = $this->get_months_in_range($data['filter_date_start'], $data['filter_date_end']);

                $reports = $this->queryReports($data);

                foreach($months as $key=>$val) {
                    $data['filter_date_start'] = $val['start'];
                    $data['filter_date_end'] = $val['end'];
                    $results[$key] = array();
                }

                if($reports) {
                    foreach($reports as $key=>$val) {

                        if(isset($results[$val['datefield']])) {
                            $results[$val['datefield']] = $val;
                        } else if (isset($results["0".$val['datefield']])) {
                            $results["0".$val['datefield']] = $val;
                        }

                    }
                }
                break;
            case 'week':
                $data['filter_date_start'] = isset($data['filter_date_start'])?$data['filter_date_start']:date('Y-01-01');
                $data['filter_date_end'] = isset($data['filter_date_end'])?$data['filter_date_end']:date('Y-12-31');

                $weeks = $this->get_week_in_range($data['filter_date_start'], $data['filter_date_end']);

                $reports = $this->queryReports($data);

                foreach($weeks as $key=>$val) {
                    $tmp_k = date('M d, Y', strtotime($val['start'])) ." - ".date('M d, Y', strtotime($val['end']));
                    $results[$tmp_k] = array();
                }

                if($reports) {
                    foreach($reports as $key=>$val) {
                        $val['datefield'] = (int)$val['datefield']+1;
                        $date_range = $this->getWeekRange( $val['datefield'] );
                        if(sizeof($date_range) == 2) {
                            if (strtotime($date_range[0]) < strtotime($data['filter_date_start'])) {
                                $date_range[0] = date("Y-m-d", strtotime($data['filter_date_start']));
                            }

                            if (strtotime($date_range[1]) > strtotime($data['filter_date_end'])) {
                                $date_range[1] = date("Y-m-d", strtotime($data['filter_date_end']));
                            }

                            $tmp_k = date('M d, Y', strtotime($date_range[0])) . " - " . date('M d, Y', strtotime($date_range[1]));
                            if(isset($results[$tmp_k])) {
                                $results[$tmp_k] = $val;
                            }
                        }
                    }
                }

                break;
            case 'quarter':
                $data['filter_date_start'] = isset($data['filter_date_start'])?$data['filter_date_start']:date('Y-01-01');
                $data['filter_date_end'] = isset($data['filter_date_end'])?$data['filter_date_end']:date('Y-12-31');

                $months = $this->get_quarter_in_range($data['filter_date_start'], $data['filter_date_end']);

                $reports = $this->queryReports($data);

                foreach($months as $key=>$val) {
                    $data['filter_date_start'] = $val['start'];
                    $data['filter_date_end'] = $val['end'];
                    $results[$key] = array();
                }

                if($reports) {
                    foreach($reports as $key=>$val) {
                        if(isset($results["Q".$val['datefield']])) {
                            $results["Q".$val['datefield']] = $val;
                        }

                    }
                }

                break;
            case 'year':
                $data['filter_date_start'] = isset($data['filter_date_start'])?$data['filter_date_start']:date('Y-01-01');
                $data['filter_date_end'] = isset($data['filter_date_end'])?$data['filter_date_end']:date('Y-12-31');

                $months = $this->get_year_in_range($data['filter_date_start'], $data['filter_date_end']);

                $reports = $this->queryReports($data);

                foreach($months as $key=>$val) {
                    $data['filter_date_start'] = $val['start'];
                    $data['filter_date_end'] = $val['end'];
                    $results[$key] = array();
                }

                if($reports) {
                    foreach($reports as $key=>$val) {
                        if(isset($results[$val['datefield']])) {
                            $results[$val['datefield']] = $val;
                        }
                    }
                }
                break;
        }
        return $results;
    }

    protected function getWeekRange($week, $dateFormat= "Y-m-d")
    {
        if (strlen($week)> 6 && strlen($week)<=7){
            $year = substr($week,0,4);
            $week = substr($week,5,2);
        }
        else {
            $year = substr($week,0,4);
            $week = substr($week,4,2);
        }
        if((int)$week < 10) {
            $week = "0".(int)$week;
        }
        if($week == "01") {
            $previous_year = (int)$year - 1;

        }
        $from = date($dateFormat, strtotime("{$year}-W{$week}-0")); //Returns the date of monday in week
        $to = date($dateFormat, strtotime("{$year}-W{$week}-6"));   //Returns the date of sunday in week
        return array($from, $to);
    }

    protected function get_months_in_range($start, $end) {
        $start = $month = strtotime($start);
        $end = strtotime($end);
        $result = array();
        while($month <= $end)
        {
            $tmp = array();
            $tmp_date = date('m/Y', $month);
            $tmp_date_array = explode("/", $tmp_date);
            $tmp["start"] = date('Y-m-d', mktime(0, 0, 0, $tmp_date_array[0], 1, $tmp_date_array[1]));
            $tmp["end"] = date('Y-m-t', mktime(0, 0, 0, $tmp_date_array[0], 1, $tmp_date_array[1]));

            $end_time = strtotime($tmp['end']);

            if($end_time > $end) {
                $tmp["end"] = date('Y-m-d', $end);
            }
            $result[ $tmp_date ] = $tmp;
            $month = strtotime("+1 month", $month);
        }

        return $result;
    }

    protected function get_week_in_range($start, $end) {
        $start_year = date("Y", strtotime($start));
        $end_year = date("Y", strtotime($end));

        $start_week_number = date("W", strtotime($start));
        $end_week_number = date("W", strtotime($end));
        $start_week_number = $start_week_number;
        $end_week_number = $end_week_number;

        $result = array();

        $tmp = array();
        $first_week = $this->getWeekRange($start_year.$start_week_number);

        $tmp['start'] = date('Y-m-d', strtotime( $start ) );
        $tmp['end'] = date('Y-m-d', strtotime($first_week[1]) );

        if (strtotime($first_week[1]) > strtotime( $start )) {
            $result[ $tmp["start"]." - ".$tmp["end"] ] = $tmp ;
        }

        if((int)$end_year > (int)$start_year) {
            for($k = (int)$start_year; $k <= (int)$end_year; $k++) {

                if($k == (int)$end_year) {
                    $tmp_week_number = (int)$end_week_number;
                } else {
                    $tmp_week_number = date("W", mktime(0,0,0,12,28,$k));
                }
                if($start_week_number == 53 ) {
                    $start_week_number = 1;
                } elseif( $start_week_number == 52 && $tmp_week_number < 52) {
                    $start_week_number = 1;
                    $first_week = $this->getWeekRange($k.$start_week_number);
                    $tmp = array();
                    $tmp['start'] = date('Y-m-d', strtotime($first_week[0]) );
                    $tmp['end'] = date('Y-m-d', strtotime($first_week[1]) );
                    $result[ $tmp["start"]." - ".$tmp["end"] ] = $tmp ;
                }

                for($j = $start_week_number + 1; $j <= (int)$tmp_week_number; $j ++) {
                    $tmp = array();
                    $first_week = $this->getWeekRange($k.$j);
                    $tmp['start'] = date('Y-m-d', strtotime($first_week[0]) );
                    $tmp['end'] = date('Y-m-d', strtotime($first_week[1]) );

                    $result[ $tmp["start"]." - ".$tmp["end"] ] = $tmp ;
                }

                $start_week_number = date("W", mktime(0,0,0,12,29,$k));
            }
        } else {
            for($i = (int)$start_week_number + 1; $i <= (int)$end_week_number ; $i++ ) {

                $first_week = $this->getWeekRange($end_year.$i);
                $tmp['start'] = date('Y-m-d', strtotime($first_week[0]) );

                if($i == $end_week_number) {
                    if(strtotime($end) > strtotime($first_week[1])) {
                        $tmp['end'] = date('Y-m-d', strtotime($first_week[1]) );
                    } else {
                        $tmp['end'] = date('Y-m-d', strtotime($end) );
                    }
                } else {
                    $tmp['end'] = date('Y-m-d', strtotime($first_week[1]) );
                }
                $result[ $tmp["start"]." - ".$tmp["end"] ] = $tmp ;
            }
        }

        $tmp = array();
        $end_week_number = (int)$end_week_number + 1;
        $end_week = $this->getWeekRange($end_year.$end_week_number);

        if(strtotime($end_week[0]) <= strtotime($end)) {
            $tmp['start'] = date('Y-m-d', strtotime($end_week[0]) );
            $tmp['end'] = date('Y-m-d', strtotime($end) );
            $result[ $tmp["start"]." - ".$tmp["end"] ] = $tmp ;
        }

        return $result;
    }

    protected function get_quarter_in_range($start, $end) {
        $start = $month = strtotime($start);
        $end = strtotime($end);

        $result = array();

        while($month <= $end)
        {
            $tmp = array();
            $tmp_month = date('n', $month);
            $tmp_year = date('Y', $month);

            $quarter = $this->date_quarter( $tmp_month );

            switch ($quarter) {
                case '1':
                    $tmp["start"] = date('Y-m-d', mktime(0, 0, 0, 1, 1, $tmp_year));
                    $tmp["end"] = date('Y-m-t', mktime(0, 0, 0, 3, 1, $tmp_year));
                    break;

                case '2':
                    $tmp["start"] = date('Y-m-d', mktime(0, 0, 0, 4, 1, $tmp_year));
                    $tmp["end"] = date('Y-m-t', mktime(0, 0, 0, 6, 1, $tmp_year));
                    break;
                case '3':
                    $tmp["start"] = date('Y-m-d', mktime(0, 0, 0, 7, 1, $tmp_year));
                    $tmp["end"] = date('Y-m-t', mktime(0, 0, 0, 9, 1, $tmp_year));
                    break;
                case '4':
                    $tmp["start"] = date('Y-m-d', mktime(0, 0, 0, 10, 1, $tmp_year));
                    $tmp["end"] = date('Y-m-t', mktime(0, 0, 0, 12, 1, $tmp_year));
                    break;
            }

            $end_time = strtotime($tmp['end']);
            $start_time = strtotime($tmp['start']);

            if($start_time < $start) {
                $tmp["start"] = date('Y-m-d', $start);
            }

            if($end_time > $end) {
                $tmp["end"] = date('Y-m-d', $end);
            }

            $text_key_name = $this->language->get("text_quarter_name");
            $text_key_name = sprintf($text_key_name, $quarter)."/".$tmp_year;
            $result[ $text_key_name ] = $tmp;

            $month = strtotime("+1 month", $month);
        }

        return $result;
    }

    protected function get_export_types(){

        return array(
            "csv" => $this->language->get('text_csv'),
            "html" => $this->language->get('text_html'),
            "pdf" => $this->language->get('text_pdf'),
            "xls"=>$this->language->get('text_excel2003'),
            "xlsx"=>$this->language->get('text_excel2007')
        );

    }

    protected function get_day_in_range($start, $end) {
        $start = $day = strtotime($start);
        $end = strtotime($end);
        $result = array();
        while($day <= $end)
        {
            $tmp = array();
            $tmp['start'] = date('Y-m-d', $day )." 00:00:00";
            $tmp['end'] = date('Y-m-d', $day )." 23:59:59";

            $end_time = strtotime($tmp['end']);
            $start_time = strtotime($tmp['start']);

            if($start_time < $start) {
                $tmp["start"] = date('Y-m-d H:i:s', $start);
            }

            if($end_time > $end) {
                $tmp["end"] = date('Y-m-d H:i:s', $end);
            }
            $key = date('M d, Y', $day);

            $result[ $key ] = $tmp;
            $day = strtotime("+1 day", $day);
        }

        return $result;
    }

    protected function get_year_in_range($start, $end) {
        $start = $day = strtotime($start);
        $end = strtotime($end);
        $result = array();
        $year1 = date('Y', $start);
        $year2 = date('Y', $end);
        $years = range($year1, $year2);
        foreach($years as $year)
        {
            $tmp = array();
            $tmp['start'] = date('Y-m-d', mktime(0,0,0,1,1,$year) );
            $tmp['end'] = date('Y-m-d', mktime(0,0,0,1,0,$year+1) );

            $end_time = strtotime($tmp['end']);
            $start_time = strtotime($tmp['start']);

            if($start_time < $start) {
                $tmp["start"] = date('Y-m-d', $start);
            }

            if($end_time > $end) {
                $tmp["end"] = date('Y-m-d', $end);
            }

            $result[ $year ] = $tmp;
        }


        return $result;
    }

    protected function date_quarter( $month )
    {
        if ($month <= 3) return 1;
        if ($month <= 6) return 2;
        if ($month <= 9) return 3;

        return 4;
    }

    protected function encodeURI($url) {
        // http://php.net/manual/en/function.rawurlencode.php
        // https://developer.mozilla.org/en/JavaScript/Reference/Global_Objects/encodeURI
        $unescaped = array(
            '%2D'=>'-','%5F'=>'_','%2E'=>'.','%21'=>'!', '%7E'=>'~',
            '%2A'=>'*', '%27'=>"'", '%28'=>'(', '%29'=>')'
        );
        $reserved = array(
            '%3B'=>';','%2C'=>',','%2F'=>'/','%3F'=>'?','%3A'=>':',
            '%40'=>'@','%26'=>'&','%3D'=>'=','%2B'=>'+','%24'=>'$'
        );
        $score = array(
            '%23'=>'#'
        );
        return strtr(rawurlencode($url), array_merge($reserved,$unescaped,$score));

    }

 }
