<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2022 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
header('Location: static_pages/');
}

require DIR_EXT.'sales_state_report/admin/controller/pages/sales_state_report/abstract.php';
require_once DIR_SYSTEM . "lib/vendor/autoload.php";
require_once DIR_SYSTEM . "lib/license.php";

/**
 * Class ControllerPagesSalesStateReportSaleState
 * @property ModelSalesStateReportSale $model_sales_state_report_sale
 */

class ControllerPagesSalesStateReportSaleState extends Report_Abstract {

    public $data = [];
    private $headers = [];
    private $totals = [];

    public function verify() {
        $this->load->model('extension/sales_state_report_license_info');
        $license_key = $this->config->get('sales_state_report_license_code');
        if ($license_key) {
            $exist = $this->db->query("SHOW TABLES LIKE '" . $this->db->table('sales_state_report_license_info') . "'");
            if ($exist->num_rows === 1) {
                $store_id = $this->model_extension_sales_state_report_license_info->getStoreId();
                $license_key = $this->model_extension_sales_state_report_license_info->getLicenseCode($store_id);
                $license_info = $this->model_extension_sales_state_report_license_info->getLicenseData($store_id);
                $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                $license = new License($path_to_phpseclib);
                $license_manager = $license->getManager();
                $license_manager->setKeys($license_key, $license_info['public_key'], 'sales_state_report');
                $ttl = 1209600;
                $validate = $license_manager->validate($license_info['license_data'], $ttl);
                $store_status = $this->model_extension_sales_state_report_license_info->getLicensedStoreStatus();
                if ($validate['status'] === 'valid' && $store_status == 1) {
                    return true;
                } else {
                    return false;
                }
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    public function main() {
        $this->load();
        $this->processTemplate('pages/sales_state_report/sale_state.tpl');
    }

    public function load() {
        $this->language->load('common/header');
        $this->language->load('sale/customer');
        $this->language->load('sales_state_report/sales_state_report');

        $this->load->model('sales_state_report/sale');

        $this->setModel( $this->model_sales_state_report_sale );

        $this->document->setTitle($this->language->get('heading_title_sales_state'));

        $this->document->addStyle(
            [
                'href' => $this->view->templateResource('/stylesheet/multiple-select.css'),
                'rel' => 'stylesheet',
            ]
        );

        $this->document->addStyle(
            [
                'href' => $this->view->templateResource('/stylesheet/styles.css'),
                'rel' => 'stylesheet',
            ]
        );

        $this->document->addScript($this->view->templateResource('/javascript/multipleselect/jquery.multiple.select.js'));
        $this->document->addScript($this->view->templateResource('/javascript/jquery.floatThead.min.js'));

        if (isset($this->request->get['filter_order_status_id'])) {
            $filter_order_status_id = $this->request->get['filter_order_status_id'];
        } else {
            $filter_order_status_id = '';
        }

        if (isset($this->request->get['filter_date_start'])) {
            $filter_date_start = $this->request->get['filter_date_start'];
        } else {
            $filter_date_start = date("Y-m-d", strtotime(date('m').'/01/'.date('Y').' 00:00:00'));
        }

        if (isset($this->request->get['filter_date_end'])) {
            $filter_date_end = $this->request->get['filter_date_end'];
        } else {
            $filter_date_end = date("Y-m-d");
        }

        if (isset($this->request->get['range_date'])) {
            $range_date = $this->request->get['range_date'];
        } else {
            $range_date = "this_month";
        }

        $this->document->initBreadcrumb( array (
            'href'      => $this->html->getSecureURL('index/home'),
            'text'      => $this->language->get('text_home'),
            'separator' => FALSE
        ));
        $this->document->addBreadcrumb( array (
            'href'      => $this->html->getSecureURL('extension/extensions/extensions'),
            'text'      => $this->language->get('text_extensions'),
            'separator' => ' :: '
        ));
        $this->document->addBreadcrumb( array (
            'href'      => $this->html->getSecureURL('sales_state_report/sale_state'),
            'text'      => $this->language->get('heading_title_sales_state'),
            'separator' => ' :: ',
            'current' => true
        ));

        $this->data['reports'] = [];

        $data = [
            'filter_order_status_id' => $filter_order_status_id,
            'filter_date_start'	     => $filter_date_start,
            'filter_date_end'	     => $filter_date_end
        ];

        $report_total = $this->getModel()->getTotalSaleState($data);
        $this->view->assign('base', (HTTPS_SERVER) ? HTTPS_SERVER : HTTP_SERVER);
        $results = $this->queryReports( $data );

        $sum_orders = 0;
        $sum_items_ordered = 0;
        $sum_subtotal = 0.00;
        $sum_tax = 0.00;
        $sum_shipping = 0.00;
        $sum_discount = 0.00;
        $sum_total = 0.00;

        if($results) {
            foreach($results as $key => $result) {
                if($result) {
                    $tmp_subtotal = round(isset($result['subtotal'])?$result['subtotal']:0,2);
                    $tmp_shipping = round(isset($result['shipping'])?$result['shipping']:0,2);
                    $tmp_discount = round(isset($result['discount'])?abs($result['discount']):0,2);
                    $tmp_tax = round((isset($result['tax']) && $result['tax'])?$result['tax']:0,2);
                    $tmp_total = round(isset($result['total'])?$result['total']:0,2);
                    $sum_orders += (int)$result['number_orders'];
                    $sum_items_ordered += (int)$result['items_ordered'];
                    $sum_subtotal += $tmp_subtotal;
                    $sum_shipping += $tmp_shipping;
                    $sum_discount += $tmp_discount;
                    $sum_tax += $tmp_tax;
                    $sum_total += $tmp_total;

                    $results[$key]['subtotal'] = $tmp_subtotal;
                    $results[$key]['shipping'] = $tmp_shipping;
                    $results[$key]['discount'] = $tmp_discount;
                    $results[$key]['tax'] = $tmp_tax;
                    $results[$key]['total'] = $tmp_total;

                    $results[$key]['subtotal2'] = $this->currency->format($tmp_subtotal, $this->config->get('config_currency'));
                    $results[$key]['shipping2'] = $this->currency->format($tmp_shipping, $this->config->get('config_currency'));
                    $results[$key]['discount2'] = $this->currency->format($tmp_discount, $this->config->get('config_currency'));
                    $results[$key]['tax2'] = $this->currency->format($tmp_tax, $this->config->get('config_currency'));
                    $results[$key]['total2'] = $this->currency->format($tmp_total, $this->config->get('config_currency'));
                }
            }
        }

        $this->_reports = $results;

        $this->data['reports'] = $results;
        $this->data['sum_items_ordered'] = $sum_items_ordered;
        $this->data['sum_orders'] = $sum_orders;
        $this->data['sum_shipping'] = $sum_shipping;
        $this->data['sum_subtotal'] = $sum_subtotal;
        $this->data['sum_discount'] = $sum_discount;
        $this->data['sum_tax'] = $sum_tax;
        $this->data['sum_total'] = $sum_total;
        $this->data['sum_subtotal_with_currency'] = $this->currency->format($sum_subtotal, $this->config->get('config_currency'));
        $this->data['sum_shipping_with_currency'] = $this->currency->format($sum_shipping, $this->config->get('config_currency'));
        $this->data['sum_discount_with_currency'] = $this->currency->format($sum_discount, $this->config->get('config_currency'));
        $this->data['sum_tax_with_currency'] = $this->currency->format($sum_tax, $this->config->get('config_currency'));
        $this->data['sum_total_with_currency'] = $this->currency->format($sum_total, $this->config->get('config_currency'));

        $this->data['heading_title'] = $this->language->get('heading_title_sales_state');

        $this->data['text_no_results'] = $this->language->get('text_no_results');
        $this->data['text_default'] = $this->language->get('text_default');
        $this->data['text_range'] = $this->language->get('text_range');
        $this->data['text_export_to'] = $this->language->get('text_export_to');
        $this->data['text_show_report_for'] = $this->language->get('text_show_report_for');
        $this->data['text_select_one'] = $this->language->get('text_select_one');
        $this->data['text_order_total'] = $this->language->get('text_order_total');
        $this->data['text_order_qty'] = $this->language->get('text_order_qty');
        $this->data['text_total'] = $this->language->get('text_total');
        $this->data['text_quantity'] = $this->language->get('text_quantity');
        $this->data['text_no_found_on_period'] = $this->language->get('text_no_found_on_period');

        $this->data['column_state'] = $this->language->get('column_state');
        $this->data['column_number_orders'] = $this->language->get('column_number_orders');
        $this->data['column_items_ordered'] = $this->language->get('column_items_ordered');
        $this->data['column_subtotal'] = $this->language->get('column_subtotal');
        $this->data['column_shipping'] = $this->language->get('column_shipping');
        $this->data['column_discounts'] = $this->language->get('column_discounts');
        $this->data['column_tax'] = $this->language->get('column_tax');
        $this->data['column_order_total'] = $this->language->get('column_order_total');

        $this->headers=[
            'A'=>$this->data['column_state'],
            'B'=>$this->data['column_number_orders'],
            'C'=>$this->data['column_items_ordered'],
            'D'=>$this->data['column_subtotal'],
            'E'=>$this->data['column_shipping'],
            'F'=>$this->data['column_discounts'],
            'G'=>$this->data['column_tax'],
            'H'=>$this->data['column_order_total']
        ];

        $this->totals=[
            'A'=>'Total',
            'B'=>(int) $sum_orders,
            'C'=>(int) $sum_items_ordered,
            'D'=>(float) $sum_subtotal,
            'E'=>(float) $sum_shipping,
            'F'=>(float) $sum_discount,
            'G'=>(float) $sum_tax,
            'H'=>(float) $sum_total
        ];

        $this->data['entry_order_status'] = $this->language->get('entry_order_status');
        $this->data['entry_date_start'] = $this->language->get('entry_date_start');
        $this->data['entry_date_end'] = $this->language->get('entry_date_end');
        $this->data['entry_range'] = $this->language->get('entry_range');
        $this->data['entry_show_by'] = $this->language->get('entry_show_by');
        $this->data['detail_key'] = $this->language->get('detail_key');

        $this->data['button_filter'] = $this->language->get('button_filter');
        $this->data['button_export'] = $this->language->get('button_export');

        $this->data['token'] = $this->session->data['token'];

        $this->data['key_list'] = ["total" => $this->language->get('column_order_total'),
            "subtotal" => $this->language->get('column_subtotal'),
            "qty" => $this->language->get('column_number_orders'),
            "qty_item" => $this->language->get('column_items_ordered')];

        $this->data['detail_key_list'] = ["0" => $this->language->get('text_grouped'),
            "1" => $this->language->get('text_detailed')];

        $this->data['period_list'] = ["day" => $this->language->get('text_day'),
            "week" => $this->language->get('text_week'),
            "month" => $this->language->get('text_month'),
            "quarter" => $this->language->get('text_quarter'),
            "year" => $this->language->get('text_year')];

        $this->data['export_types'] = $this->get_export_types();

        $this->data['range_list'] = [
            "today" => $this->language->get('text_today'),
            "yesterday" => $this->language->get('text_yesterday'),
            "last_7_days" => $this->language->get('text_last_seven_days'),
            "last_week" => $this->language->get('text_last_week'),
            "last_business_week" => $this->language->get('text_last_business_week'),
            "last_year" => $this->language->get('text_last_year'),
            "this_month" => $this->language->get('text_this_month'),
            "last_month" => $this->language->get('text_last_month'),
            "custom" => $this->language->get('text_custom_range')
        ];

        $this->data['range_date'] = $range_date;

        $this->load->model('localisation/order_status');

        $this->data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();

        $this->data['filter_order_status_id'] = $filter_order_status_id;
        $this->data['filter_date_start'] = $filter_date_start;
        $this->data['filter_date_end'] = $filter_date_end;
        $this->data['export_url']=$this->html->getSecureURL('sales_state_report/sale_state/export');
        $this->data['filter_url']=$this->html->getSecureURL('sales_state_report/sale_state');

	    $this->data['license_status'] = $this->verify();
	    $this->data['text_unauthorized'] = $this->language->get( 'text_sale_state_report_unauthorized' );

	    $this->view->batchAssign($this->data);
    }

    public function export() {

        $this->load();

        //if (isset($this->request->get['page'])) {
        //    $page = $this->request->get['page'];
        //} else {
        //    $page = 1;
        //}

        $export_type = $this->request->get["export_type"];
        if($export_type == "pdf" || $export_type == "html") {
            /*Get page html content*/
            $this->view->assign('base', (HTTPS_SERVER) ? HTTPS_SERVER : HTTP_SERVER);
            $this->data['export'] = 'html';
            $this->view->batchAssign($this->data);
            $this->processTemplate('pages/sales_state_report/sale_state.tpl');
            $this->_export_content_html = $this->view->getOutput();
            /*get page html content*/
        }
        $reports = [];
        $reports['name'] = 'Sales By State Report';
        $reports['data'] = [];
        $reports['data'] = [];
        $reports['data'] = $this->getReportData();
        $reports['headers']=$this->headers;
        $reports['totals']=$this->totals;
        $paper=$this->config->get('sales_state_report_export_pdf_paper');
        $orientation=$this->config->get('sales_state_report_export_pdf_orientation');
        $reports['paper']=$paper !== '' ? $paper : 'A4';
        $reports['orientation']=$orientation!=='' ? $orientation : 'landscape';

        if (isset($this->request->get['report_period'])) {
            $report_period = $this->request->get['report_period'];
        } else {
            $report_period = "item_";
        }

        if($reports['data']) {
            $tmp = [];
            $i = 1;
            foreach($reports['data'] as $key=>$val) {
                $tmp1 = [];
                $tmp1['zone_name'] = $val['zone_name'];
                $tmp1['number_orders'] = (int) $val['number_orders'];
                $tmp1['items_ordered'] = (int) $val['items_ordered'];
                $tmp1['subtotal'] = round((float) $val['subtotal'],2);
                $tmp1['shipping'] = round((float) $val['shipping'],2);
                $tmp1['discount'] = round((float) $val['discount'],2);
                $tmp1['tax'] = round((float) $val['tax'],2);
                $tmp1['total'] = round((float) $val['total'],2);
                $tmp[$report_period.$i] = $tmp1;
                $i++;
            }
            $reports['data'] = [];
            $reports['data'] = $tmp;
        }
        $this->exportReport( $reports, [], $export_type );
    }

    protected function queryReports( $data ){

        return $this->getModel()->getSaleByState($data);
    }
 }