<?php
/*------------------------------------------------------------------------------
  
  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2021 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (! defined ( 'DIR_CORE' )) {
header ( 'Location: static_pages/' );
}
/**
 * Class ControllerPagesExtensionConstantContactIntegration
 * @property ModelExtensionCtct $model_extension_ctct
 */

class ControllerBlocksConstantContactIntegration extends AController {
		public $data = array ();

    public function main() {
        $this->loadModel('account/customer');
        $this->loadModel('extension/ctct');
        $this->loadLanguage('account/create');
        $this->loadLanguage('account/newsletter');
        $this->loadLanguage('blocks/newsletter_signup');
        $this->loadLanguage('blocks/constantcontact_integration');
        $this->view->assign('text_subscribe',$this->language->get('text_subscribe'));
        $this->view->assign('submit',$this->language->get('newsletter_subscribe'));
        $this->view->assign('process',$this->language->get('newsletter_submit'));
        $this->view->assign('success',$this->language->get('newsletter_success'));
        $this->view->assign('error_firstname',$this->language->get('error_firstname'));
        $this->view->assign('error_email',$this->language->get('error_email'));
        $this->view->assign('entry_name',$this->language->get('entry_name'));
        $this->view->assign('entry_email',$this->language->get('entry_email'));
        $this->view->assign('url',$this->html->getURL('r/blocks/ctct/addContact'));
        $this->view->assign('first_name',$this->config->get('constantcontact_integration_firstname'));
        $this->view->assign('last_name',$this->config->get('constantcontact_integration_lastname'));
        $this->view->assign('head_text',$this->config->get('constantcontact_integration_head'));
        $this->view->assign('foot_text',$this->config->get('constantcontact_integration_footer'));
        $this->view->assign('universal_code',html_entity_decode($this->config->get('constantcontact_integration_universal_code')));
        $this->view->assign('inline_code',html_entity_decode($this->config->get('constantcontact_integration_inline_code')));
        $topContent=$this->model_extension_ctct->getContent('top');
        $bottomContent=$this->model_extension_ctct->getContent('bottom');
        $this->view->assign('topContent',$topContent['content']);
        $this->view->assign('bottomContent',$bottomContent['content']);
        $this->document->addStyle(
            array(
                'href' => $this->view->templateResource('/stylesheet/styles.css'),
                'rel' => 'stylesheet',
            )
        );
        $this->document->addScript($this->view->templateResource('/javascript/jquery.validate.min.js'));
            $this->processTemplate();
    }
 }