<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2022 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

/**
 * Class ControllerResponsesListingGridBannerStatisticManager
 * @property ModelExtensionBannerStatisticManager $model_extension_banner_statistic_manager
 */
class ControllerResponsesListingGridBannerStatisticManager extends AController {
    public $error = [];
    public $data = [];

    public function main() {
        //init controller data
        $this->extensions->hk_InitData($this, __FUNCTION__);

        $this->loadLanguage('banner_statistic_manager/banner_statistic_manager');
        $this->loadModel('extension/banner_statistic_manager');

	    //Prepare filter config
	    $filter_params = ['banner_id','period', 'filter_date_start', 'filter_date_end'];
	    $grid_filter_params = ['name','period'];

	    $filter_form = new AFilter(['method' => 'get', 'filter_params' => $filter_params]);
	    $filter_grid = new AFilter(['method' => 'post', 'grid_filter_params' => $grid_filter_params]);

	    $data = array_merge($filter_form->getFilterData(), $filter_grid->getFilterData());

	    if (!isset($this->request->get['banner_id'])) {
		    $this->load->model('extension/banner_statistic_manager');
		    $allBanners = $this->model_extension_banner_statistic_manager->getBanners();
		    $data['filter']['banner_id']=$allBanners[0]['banner_id'];
		    $data['filter']['period'] = 'all';
		}

		$total = $this->model_extension_banner_statistic_manager->getBannersStat($data,'total_only');
        $response = new stdClass();
        $response->page = $filter_grid->getParam('page');
        $response->total = $filter_grid->calcTotalPages($total);
        $response->records = $total;
        $response->userdata = new stdClass();
        $response->userdata->classes = [];
        $results = $this->model_extension_banner_statistic_manager->getBannersStat($data);

        $i = 0;
        if ($results) {
	        foreach ( $results as $result ) {
		        $response->rows[ $i ]['id']   = $result['id'];
		        $response->rows[ $i ]['cell'] = [
			        $result['name'],
			        $result['time'],
			        $result['viewed'],
			        $result['clicked']
		        ];
		        $i ++;
	        }
        }

        $this->data['response'] = $response;
        //update controller data
        $this->extensions->hk_UpdateData($this, __FUNCTION__);
        $this->load->library('json');
        $this->response->setOutput(AJson::encode($this->data['response']));
    }

    public function update() {
        //init controller data
        $this->extensions->hk_InitData($this, __FUNCTION__);

        if (!$this->user->canModify('listing_grid/banner_statistic_manager')) {
            $error = new AError('');

            $error = new AError('');
            $error->toJSONResponse(
                'NO_PERMISSIONS_402',
                [
                    'error_text'  => sprintf(
                        $this->language->get('error_permission_modify'),
                        'listing_grid/banner_statistic_manager'
                    ),
                    'reset_value' => true,
                ]
            );
            return;
        }

        $this->loadModel('extension/banner_statistic_manager');
        $this->loadLanguage('banner_statistic_manager/banner_statistic_manager');

        switch ($this->request->post[ 'oper' ]) {
            case 'del':
                $ids = explode(',', $this->request->post[ 'id' ]);
                if (!empty($ids))
                    foreach ($ids as $id) {
                    	$this->model_extension_banner_statistic_manager->deleteStatistic($id);
                    }
                break;
            default:
                //print_r($this->request->post);
        }
		//update controller data
        $this->extensions->hk_UpdateData($this, __FUNCTION__);
    }


}