<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2020 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/
if ( !defined ( 'DIR_CORE' )) {
    header ( 'Location: static_pages/' );
}

include_once DIR_EXT.'ups_integration'.DIR_EXT_CORE.'lib/autoload.php';
require_once DIR_EXT . "ups_integration" . DIR_EXT_CORE . "helpers.php";

class ModelExtensionUpsIntegration extends Model {

	public $data=array();

	/**
	 * @return bool
	 */
	public function verify() {
			$exist = $this->db->query("SHOW TABLES LIKE '".$this->db->table('ups_integration_license')."'");
			if ($exist->num_rows === 1) {
				$validation = upsIntegrationVerifyLicense();
				if ( $validation['notification_case'] === 'notification_license_ok' ) {
					return true;
				} elseif ( $validation['notification_case'] === 'notification_license_corrupted' ) {
					return false;
				}
			} else {
				return false;
			}
	}

	public function verifyPricingCalc() {
		if ( $this->config->get( 'pricing_calculator_status' ) === '1' ) {
			$exist = $this->db->query( "SHOW TABLES LIKE '" . $this->db->table( 'pricing_calculator_license' ) . "'" );
			if ( $exist->num_rows === 1 ) {
				$validation = pricingCalculatorVerifyLicense();
				if ( $validation['notification_case'] === 'notification_license_ok' ) {
					return true;
				} elseif ( $validation['notification_case'] === 'notification_license_corrupted' ) {
					return false;
				}
			} else {
				return false;
			}
		} else {
			return false;
		}
	}

	public function verifyAreaCalc() {
		if ( $this->config->get( 'area_calculator_status' ) === '1' ) {
			$exist = $this->db->query( "SHOW TABLES LIKE '" . $this->db->table( 'area_calculator_license' ) . "'" );
			if ( $exist->num_rows === 1 ) {
				$validation = areaCalculatorVerifyLicense();
				if ( $validation['notification_case'] === 'notification_license_ok' ) {
					return true;
				} elseif ( $validation['notification_case'] === 'notification_license_corrupted' ) {
					return false;
				}
			} else {
				return false;
			}
		} else {
			return false;
		}
	}

	public function verifyLengthCalc() {
		if ($this->config->get('length_calculator_status')==='1') {
			$exist = $this->db->query( "SHOW TABLES LIKE '" . $this->db->table( 'length_calculator_license' ) . "'" );
			if ( $exist->num_rows === 1 ) {
				$validation = lengthCalculatorVerifyLicense();
				if ( $validation['notification_case'] === 'notification_license_ok' ) {
					return true;
				} elseif ( $validation['notification_case'] === 'notification_license_corrupted' ) {
					return false;
				}
			} else {
				return false;
			}
		} else {
			return false;
		}
	}

	public function verifyLiquidsCalc() {
		if ($this->config->get('liquids_calculator_status')==='1') {
			$exist = $this->db->query( "SHOW TABLES LIKE '" . $this->db->table( 'liquids_calculator_license' ) . "'" );
			if ( $exist->num_rows === 1 ) {
				$validation = liquidsCalculatorVerifyLicense();
				if ( $validation['notification_case'] === 'notification_license_ok' ) {
					return true;
				} elseif ( $validation['notification_case'] === 'notification_license_corrupted' ) {
					return false;
				}
			} else {
				return false;
			}
		} else {
			return false;
		}
	}

	public function verifyWeightCalc() {
		if ( $this->config->get( 'weight_calculator_status' ) === '1' ) {
			$exist = $this->db->query( "SHOW TABLES LIKE '" . $this->db->table( 'weight_calculator_license' ) . "'" );
			if ( $exist->num_rows === 1 ) {
				$validation = weightCalculatorVerifyLicense();
				if ( $validation['notification_case'] === 'notification_license_ok' ) {
					return true;
				} elseif ( $validation['notification_case'] === 'notification_license_corrupted' ) {
					return false;
				}
			} else {
				return false;
			}
		} else {
			return false;
		}
	}

	public function verifyVolumeCalc() {
		if ($this->config->get('volume_calculator_status')==='1') {
			$exist = $this->db->query( "SHOW TABLES LIKE '" . $this->db->table( 'volume_calculator_license' ) . "'" );
			if ( $exist->num_rows === 1 ) {
				$validation = volumeCalculatorVerifyLicense();
				if ( $validation['notification_case'] === 'notification_license_ok' ) {
					return true;
				} elseif ( $validation['notification_case'] === 'notification_license_corrupted' ) {
					return false;
				}
			} else {
				return false;
			}
		} else {
			return false;
		}
	}

	public function verifyBuildAGift() {
		if ($this->config->get('build_a_gift_status')==='1') {
			$exist = $this->db->query( "SHOW TABLES LIKE '" . $this->db->table( 'build_a_gift_license' ) . "'" );
			if ( $exist->num_rows === 1 ) {
				$validation = buildAGiftVerifyLicense();
				if ( $validation['notification_case'] === 'notification_license_ok' ) {
					return true;
				} elseif ( $validation['notification_case'] === 'notification_license_corrupted' ) {
					return false;
				}
			} else {
				return false;
			}
		} else {
			return false;
		}
	}

    /**
     * @param $address
     * @param string $admin
     * @return array
     * @throws AException
     */
    function getQuote($address,$admin="") {
    	if ($this->verify()===true) {
    	    if ($admin) {
                $cart = $this->cart;
            } else {
                if ($this->verifyPricingCalc() === true) {
                    include_once DIR_EXT . 'pricing_calculator' . DIR_EXT_CORE . 'lib/cart.php';
                    $cart = new APricingCart($this->registry);
                } elseif ($this->verifyAreaCalc() === true) {
                    include_once DIR_EXT . 'area_calculator' . DIR_EXT_CORE . 'lib/cart.php';
                    $cart = new AAreaCart($this->registry);
                } elseif ($this->verifyLengthCalc() === true) {
                    include_once DIR_EXT . 'length_calculator' . DIR_EXT_CORE . 'lib/cart.php';
                    $cart = new ALengthCart($this->registry);
                } elseif ($this->verifyLiquidsCalc() === true) {
                    include_once DIR_EXT . 'liquids_calculator' . DIR_EXT_CORE . 'lib/cart.php';
                    $cart = new ALiquidsCart($this->registry);
                } elseif ($this->verifyWeightCalc() === true) {
                    include_once DIR_EXT . 'weight_calculator' . DIR_EXT_CORE . 'lib/cart.php';
                    $cart = new AWeightCart($this->registry);
                } elseif ($this->verifyVolumeCalc() === true) {
                    include_once DIR_EXT . 'volume_calculator' . DIR_EXT_CORE . 'lib/cart.php';
                    $cart = new AVolumeCart($this->registry);
                } elseif ($this->verifyBuildAGift() === true) {
                    include_once DIR_EXT . 'build_a_gift' . DIR_EXT_CORE . 'lib/cart.php';
                    $cart = new ABagCart($this->registry);
                } else {
                    $cart = $this->cart;
                }
            }

		    $this->extensions->hk_InitData($this, __FUNCTION__);
		    $this->load->language( 'ups_integration/ups_integration' );

		    if ( $this->config->get( 'ups_integration_status' ) ) {
			    $this->load->model( 'localisation/country' );
			    if ( ! $this->config->get( 'ups_integration_location_id' ) ) {
				    $status = true;
			    } else {
				    $query = $this->db->query( "SELECT *
											FROM " . $this->db->table( 'zones_to_locations' ) . "
											WHERE location_id = '" . (int) $this->config->get( 'ups_integration_location_id' ) . "'
												AND country_id = '" . (int) $address['country_id'] . "'
												AND (zone_id = '" . (int) $address['zone_id'] . "' OR zone_id = '0')" );
				    if ( $query->num_rows ) {
					    $status = true;
				    } else {
					    $status = false;
				    }
			    }
			    $countries = $this->model_localisation_country->getCountries();
			    foreach ( $countries as $item ) {
				    $country[ $item['iso_code_2'] ] = $item['name'];
			    }

			    if ( $status && ! has_value( $country[ $address['iso_code_2'] ] ) ) {
				    $status = false;
			    }

		    } else {
			    $status = false;
		    }

		    $method_data = array();

		    if ( ! $status ) {
			    return $method_data;
		    }
		    $id                  = 'ups_integration.ups_integration';
		    $quote_data          = array();
		    $generic_product_ids = $free_shipping_ids = $shipping_price_ids = array(); // ids of products without special shipping cost
		    $shipping_price_cost = 0; // total shipping cost of product with fixed shipping price
		    $cart_products       = $cart->getProducts();
		    foreach ( $cart_products as $product ) {
			    //(exclude free shipping products)
			    if ( $product['free_shipping'] || $product['download'] ) {
				    $free_shipping_ids[] = $product['product_id'];
				    continue;
			    }
			    if ( $product['shipping_price'] > 0 ) {
				    $shipping_price_ids[] = $product['product_id'];
				    $shipping_price_cost  += $product['shipping_price'] * $product['quantity'];
			    }
			    $generic_product_ids[] = $product['product_id'];
		    }
		    //convert fixed prices to USD
		    $shipping_price_cost = $this->currency->convert( $shipping_price_cost, $this->config->get( 'config_currency' ), $this->currency->getCode() );

		    if ( $generic_product_ids ) {
			    $api_weight_product_ids = array_diff( $generic_product_ids, $shipping_price_ids );
			    //WHEN ONLY PRODUCTS WITH FIXED SHIPPING PRICES ARE IN BASKET
			    if ( ! $api_weight_product_ids ) {
				    $cost       = $shipping_price_cost;
				    $quote_data = array(
					    'ups_integration_plus' => array(
						    'id'           => $id,
						    'title'        => $this->language->get( 'text_title' ),
						    'cost'         => $this->currency->convert( $cost, $this->config->get( 'config_currency' ), $this->config->get( 'config_currency' ) ),
						    'tax_class_id' => $this->config->get( 'ups_integration_tax_class_id' ),
						    'text'         => $this->currency->format($this->tax->calculate( $this->currency->convert($cost,
                                $this->config->get( 'config_currency' ),
                                $this->currency->getCode()),
                                $this->config->get('ups_integration_tax_class_id'),
                                $this->config->get('config_tax')),
                                $this->currency->getCode(),
                                1.0000000)
                        )
				    );

				    $method_data = array(
					    'id'         => 'ups_integration',
					    'title'      => $this->language->get( 'text_title' ),
					    'quote'      => $quote_data,
					    'sort_order' => $this->config->get( 'ups_integration_sort_order' ),
					    'error'      => ''
				    );

				    return $method_data;
			    }
		    } else {
			    $api_weight_product_ids = $shipping_price_ids;
		    }
		    $basic_products          = $cart->basicShippingProducts();
		    $basic_products_subtotal = 0;
		    foreach ( $basic_products as $product ) {
			    $product_ids[]           = $product['product_id'];
			    $basic_products_subtotal += $product['total'];
		    }

		    $weight    = $this->weight->convert( $cart->getWeight( $product_ids ), $this->config->get( 'config_weight_class' ), $this->config->get( 'config_weight_class' ) ) + number_format( (float) $this->config->get( 'ups_integration_additional_weight' ), 2, '.', '' );
		    $weight    = ( $weight < 0.1 ? 0.1 : $weight );
		    $countries = array(
			    'AT',
			    'BE',
			    'BG',
			    'HR',
			    'CY',
			    'CZ',
			    'DK',
			    'EE',
			    'FI',
			    'FR',
			    'DE',
			    'GR',
			    'HU',
			    'IE',
			    'IT',
			    'LV',
			    'LT',
			    'LU',
			    'MT',
			    'NL',
			    'PT',
			    'RO',
			    'SK',
			    'SI',
			    'ES',
			    'SE',
			    'GB'
		    );
		    if ( ! $api_weight_product_ids && $free_shipping_ids ) {
			    $cost = 0.0;
			    if ( $address['iso_code_2'] == 'US' && $this->config->get( 'ups_integration_free_us_method' ) != 'NONE' ) {
				    $quote_data = array(
					    'ups_integration' => array(
						    'id'           => $id,
						    'title'        => $this->language->get( 'text_' . $this->config->get( 'ups_integration_free_us_method' ) ),
						    'cost'         => $this->currency->convert( $cost, $this->config->get( 'config_currency' ), $this->config->get( 'config_currency' )),
						    'tax_class_id' => $this->config->get( 'ups_integration_tax_class_id' ),
						    'text'         => $this->currency->format(
							    $this->tax->calculate( $this->currency->convert( $cost,
								    $this->config->get( 'config_currency' ),
								    $this->currency->getCode() ),
								    $this->config->get( 'ups_integration_tax_class_id' ),
								    $this->config->get( 'config_tax' ) ),
							    $this->currency->getCode(),
							    1.0000000 )
					    )
				    );
			    } elseif ( $address['iso_code_2'] == 'PR' && $this->config->get( 'ups_integration_free_pr_method' ) != 'NONE' ) {
				    $quote_data = array(
					    'ups_integration' => array(
						    'id'           => $id,
						    'title'        => $this->language->get( 'text_' . $this->config->get( 'ups_integration_free_pr_method' ) ),
						    'cost'         => $this->currency->convert( $cost, $this->config->get( 'config_currency' ), $this->config->get( 'config_currency' ) ),
						    'tax_class_id' => $this->config->get( 'ups_integration_tax_class_id' ),
						    'text'         => $this->currency->format($this->tax->calculate( $this->currency->convert($cost,
                                $this->config->get( 'config_currency' ),
                                $this->currency->getCode()),
                                $this->config->get('ups_integration_tax_class_id'),
                                $this->config->get('config_tax')),
                                $this->currency->getCode(),
                                1.0000000)
                        )
				    );
			    } elseif ( $address['iso_code_2'] == 'MX' && $this->config->get( 'ups_integration_free_mx_method' ) != 'NONE' ) {
				    $quote_data = array(
					    'ups_integration' => array(
						    'id'           => $id,
						    'title'        => $this->language->get( 'text_' . $this->config->get( 'ups_integration_free_mx_method' ) ),
						    'cost'         => $this->currency->convert( $cost, $this->config->get( 'config_currency' ), $this->config->get( 'config_currency' ) ),
						    'tax_class_id' => $this->config->get( 'ups_integration_tax_class_id' ),
						    'text'         => $this->currency->format($this->tax->calculate( $this->currency->convert($cost,
                                $this->config->get( 'config_currency' ),
                                $this->currency->getCode()),
                                $this->config->get('ups_integration_tax_class_id'),
                                $this->config->get('config_tax')),
                                $this->currency->getCode(),
                                1.0000000)
                        )
				    );
			    } elseif ( $address['iso_code_2'] == 'CA' && $this->config->get( 'ups_integration_free_ca_method' ) != 'NONE' ) {
				    $quote_data = array(
					    'ups_integration' => array(
						    'id'           => $id,
						    'title'        => $this->language->get( 'text_' . $this->config->get( 'ups_integration_free_ca_method' ) ),
						    'cost'         => $this->currency->convert( $cost, $this->config->get( 'config_currency' ), $this->config->get( 'config_currency' ) ),
						    'tax_class_id' => $this->config->get( 'ups_integration_tax_class_id' ),
						    'text'         => $this->currency->format($this->tax->calculate( $this->currency->convert($cost,
                                $this->config->get( 'config_currency' ),
                                $this->currency->getCode()),
                                $this->config->get('ups_integration_tax_class_id'),
                                $this->config->get('config_tax')),
                                $this->currency->getCode(),
                                1.0000000)
                        )
				    );
			    } elseif ( in_array( $address['iso_code_2'], $countries ) && $this->config->get( 'ups_integration_free_eu_method' ) != 'NONE' ) {
				    $quote_data = array(
					    'ups_integration' => array(
						    'id'           => $id,
						    'title'        => $this->language->get( 'text_' . $this->config->get( 'ups_integration_free_eu_method' ) ),
						    'cost'         => $this->currency->convert( $cost, $this->config->get( 'config_currency' ), $this->config->get( 'config_currency' ) ),
						    'tax_class_id' => $this->config->get( 'ups_integration_tax_class_id' ),
						    'text'         => $this->currency->format($this->tax->calculate( $this->currency->convert($cost,
                                $this->config->get( 'config_currency' ),
                                $this->currency->getCode()),
                                $this->config->get('ups_integration_tax_class_id'),
                                $this->config->get('config_tax')),
                                $this->currency->getCode(),
                                1.0000000)
                        )
				    );
			    } elseif ( $address['iso_code_2'] == 'PL' && $this->config->get( 'ups_integration_free_pl_method' ) != 'NONE' ) {
				    $quote_data = array(
					    'ups_integration' => array(
						    'id'           => $id,
						    'title'        => $this->language->get( 'text_' . $this->config->get( 'ups_integration_free_pl_method' ) ),
						    'cost'         => $this->currency->convert( $cost, $this->config->get( 'config_currency' ), $this->config->get( 'config_currency' )),
						    'tax_class_id' => $this->config->get( 'ups_integration_tax_class_id' ),
						    'text'         => $this->currency->format($this->tax->calculate( $this->currency->convert($cost,
                                $this->config->get( 'config_currency' ),
                                $this->currency->getCode()),
                                $this->config->get('ups_integration_tax_class_id'),
                                $this->config->get('config_tax')),
                                $this->currency->getCode(),
                                1.0000000)
                        )
				    );
			    } elseif ( $address['iso_code_2'] != 'US' && $this->config->get( 'ups_integration_free_other_method' ) != 'NONE' ||
			               $address['iso_code_2'] != 'PR' && $this->config->get( 'ups_integration_free_other_method' ) != 'NONE' ||
			               $address['iso_code_2'] != 'MX' && $this->config->get( 'ups_integration_free_other_method' ) != 'NONE' ||
			               $address['iso_code_2'] != 'CA' && $this->config->get( 'ups_integration_free_other_method' ) != 'NONE' ||
			               $address['iso_code_2'] != 'EU' && $this->config->get( 'ups_integration_free_other_method' ) != 'NONE' ||
			               $this->config->get( 'ups_integration_free_other_method' ) != 'NONE' ) {
				    $quote_data = array(
					    'ups_integration' => array(
						    'id'           => $id,
						    'title'        => $this->language->get( 'text_' . $this->config->get( 'ups_integration_free_other_method' ) ),
						    'cost'         => $this->currency->convert( $cost, $this->config->get( 'config_currency' ), $this->config->get( 'config_currency' ) ),
						    'tax_class_id' => $this->config->get( 'ups_integration_tax_class_id' ),
						    'text'         => $this->currency->format($this->tax->calculate( $this->currency->convert($cost,
                                $this->config->get( 'config_currency' ),
                                $this->currency->getCode()),
                                $this->config->get('ups_integration_tax_class_id'),
                                $this->config->get('config_tax')),
                                $this->currency->getCode(),
                                1.0000000)
                        )
				    );
			    }

			    $method_data = array(
				    'id'         => 'ups_integration',
				    'title'      => $this->language->get( 'text_title' ),
				    'quote'      => $quote_data,
				    'sort_order' => $this->config->get( 'ups_integration_sort_order' ),
				    'error'      => ''
			    );

			    return $method_data;
		    }

		    ( ( $this->config->get( 'ups_integration_length' ) == "" ) ? $defaultLength = "5" : $defaultLength = $this->config->get( 'ups_integration_length' ) );
		    ( ( $this->config->get( 'ups_integration_width' ) == "" ) ? $defaultWidth = "5" : $defaultWidth = $this->config->get( 'ups_integration_width' ) );
		    ( ( $this->config->get( 'ups_integration_height' ) == "" ) ? $defaultHeight = "5" : $defaultHeight = $this->config->get( 'ups_integration_height' ) );

		    $length         = $this->length->convert( $defaultLength, $this->config->get( 'config_length_class' ), $this->config->get( 'config_length_class' ) );
		    $width          = $this->length->convert( $defaultWidth, $this->config->get( 'config_length_class' ), $this->config->get( 'config_length_class' ) );
		    $height         = $this->length->convert( $defaultHeight, $this->config->get( 'config_length_class' ), $this->config->get( 'config_length_class' ) );
		    $avg_weight     = $this->config->get( 'ups_integration_weight' );
		    $avg            = $wt = $top = '';
		    $avg_quote_data = $new_quote_data = array();
		    $origin_country = $this->config->get( 'ups_integration_country' );
		    if ( $basic_products ) {
			    if ( $avg_weight != '' && $weight > $avg_weight ) {
				    $avg = floor( $weight / (int) $avg_weight );
				    $wt  = fmod( $weight, $avg_weight );
			    }
			    if ( $avg != 0 ) {
				    if ( $wt != 0 ) {
					    $loop = $avg + 1;
					    $top  = $avg + 1;
				    } else {
					    $loop = $avg;
				    }
				    $j = 1;
				    for ( $i = 1; $i <= $loop; $i ++ ) {
					    if ( $j == $top ) {
						    $result = $this->_fetchRate( $address, $wt, $length, $width, $height, $basic_products_subtotal );
					    } else {
						    $result = $this->_fetchRate( $address, $avg_weight, $length, $width, $height, $basic_products_subtotal );
					    }

					    if ( $result ) {
						    $avg_quote_data = $this->_processRate( $origin_country, $address, $result, '',$admin );
						    $error_msg      = $avg_quote_data['error_msg'];
						    $avg_quote_data = $avg_quote_data['quote_data'];
					    }
					    if ( $quote_data ) {
						    foreach ( $quote_data as $key => $value ) {
							    $quote_data[ $key ]['cost'] = $quote_data[ $key ]['cost'] + $avg_quote_data[ $key ]['cost'];
							    $quote_data[ $key ]['text'] = $this->currency->format(
                                    $this->tax->calculate( $this->currency->convert( $quote_data[ $key ]['cost'],
                                        $this->config->get( 'config_currency' ),
                                        $this->currency->getCode() ),
                                        $this->config->get( 'ups_integration_tax_class_id' ),
                                        $this->config->get( 'config_tax' ) ),
                                    $this->currency->getCode(),
                                    1.0000000 );
						    }
					    } else if ( $avg_quote_data ) {
						    $quote_data = $avg_quote_data;
					    }
					    $j ++;
				    }
			    } else {
				    $result     = $this->_fetchRate( $address, $weight, $length, $width, $height, $basic_products_subtotal );
				    $quote_data = $this->_processRate( $origin_country, $address, $result, '',$admin );
				    $error_msg  = $quote_data['error_msg'];
				    $quote_data = $quote_data['quote_data'];
			    }
		    }

		    foreach ( $cart_products as $product ) {
			    if ( $product['ship_individually'] && $product['shipping_price'] == '0.00' ) {
				    $individualWeight = $this->weight->convert( $this->getIndividualWeight( array( $product['product_id'] ),$admin ), $product['weight_class'], $this->config->get( 'config_weight_class' ) ) + number_format( (float) $this->config->get( 'ups_integration_additional_weight' ), 2, '.', '' );
				    $individualWeight = ( $individualWeight < 0.1 ? 0.1 : $individualWeight );
				    $use_width        = ( ( $product['width'] != '0.00' ) ? $this->length->convert( $product['width'], $product['length_class'], $this->config->get( 'config_length_class' ) ) : $this->length->convert( '5', $product['length_class'], $this->config->get( 'config_length_class' ) ) );
				    $use_length       = ( ( $product['length'] != '0.00' ) ? $this->length->convert( $product['length'], $product['length_class'], $this->config->get( 'config_length_class' ) ) : $this->length->convert( '5', $product['length_class'], $this->config->get( 'config_length_class' ) ) );
				    $use_height       = ( ( $product['height'] != '0.00' ) ? $this->length->convert( $product['height'], $product['length_class'], $this->config->get( 'config_length_class' ) ) : $this->length->convert( '5', $product['length_class'], $this->config->get( 'config_length_class' ) ) );
				    $qty              = $product['quantity'];

				    $result = $this->_fetchRate( $address, $individualWeight, $use_length, $use_width, $use_height, $product['price'] );
				    if ( $result ) {
					    $new_quote_data = $this->_processRate( $origin_country, $address, $result, $qty,$admin );
					    $error_msg      = $new_quote_data['error_msg'];
					    $new_quote_data = $new_quote_data['quote_data'];
				    }
				    if ( $quote_data ) {
					    foreach ( $quote_data as $key => $value ) {
						    $quote_data[ $key ]['cost'] = $quote_data[ $key ]['cost'] + $new_quote_data[ $key ]['cost'];
						    $quote_data[ $key ]['text'] = $this->currency->format(
                                $this->tax->calculate( $this->currency->convert( $quote_data[ $key ]['cost'],
                                    $this->config->get( 'config_currency' ),
                                    $this->currency->getCode() ),
                                    $this->config->get( 'ups_integration_tax_class_id' ),
                                    $this->config->get( 'config_tax' ) ),
                                $this->currency->getCode(),
                                1.0000000 );
					    }
				    } else if ( $new_quote_data ) {
					    $quote_data = $new_quote_data;
				    }
			    }
		    }
		    //merge data and accumulate shipping cost
		    if ( $quote_data ) {
			    foreach ( $quote_data as $key => $value ) {
				    $quote_data[ $key ]['cost'] = $quote_data[ $key ]['cost'] + $shipping_price_cost;
				    $quote_data[ $key ]['text'] = $this->currency->format(
                        $this->tax->calculate( $this->currency->convert( $quote_data[ $key ]['cost'],
                            $this->config->get( 'config_currency' ),
                            $this->currency->getCode() ),
                            $this->config->get( 'ups_integration_tax_class_id' ),
                            $this->config->get( 'config_tax' ) ),
                        $this->currency->getCode(),
                        1.0000000 );
			    }
		    }

		    $title = $this->language->get( 'text_title', 'ups_integration/ups_integration' );

		    $method_data = array(
			    'id'         => 'ups_integration',
			    'title'      => $title,
			    'quote'      => $quote_data,
			    'sort_order' => $this->config->get( 'ups_integration_sort_order' ),
			    'error'      => $error_msg
		    );

		    return $method_data;
	    }
    }

    public function getLocalDelivery($address) {
    	if ($this->verify()===true) {
		    $postcode         = str_replace( ' ', '', $address['postcode'] );
		    $exclude_zipcodes = $this->config->get( 'ups_integration_local_zipcodes' );
		    $fee              = $this->config->get( 'ups_integration_local_delivery_fee' );
		    $valid            = '';
		    if ( $fee ) {
			    $cost  = $fee;
			    $title = $this->language->get( 'text_local_delivery_fee' );
		    } else {
			    $cost  = 0;
			    $title = $this->language->get( 'text_free_local_delivery' );
		    }

		    $zipcodes_list = explode( ',', $exclude_zipcodes );
		    if ( $zipcodes_list ) {
			    foreach ( $zipcodes_list as $zipcodes ) {
				    if ( fnmatch( $zipcodes, $postcode ) ) {
					    $valid = '1';
					    break;
				    }
			    }
		    } else {
			    if ( fnmatch( $exclude_zipcodes, $postcode ) ) {
				    $valid = '1';
			    }
		    }
		    if ( $exclude_zipcodes && $valid ) {
			    $local_delivery = array(
				    'ups_integration_local' => array(
					    'id'           => 'ups_integration_local.ups_integration_local',
					    'title'        => $title,
					    'cost'         => $this->currency->convert( $cost, $this->config->get( 'config_currency' ), $this->config->get( 'config_currency' )),
					    'tax_class_id' => $this->config->get( 'ups_integration_tax_class_id' ),
					    'text'         => $this->currency->format(
						    $this->tax->calculate( $this->currency->convert( $cost,
							    $this->config->get( 'config_currency' ),
							    $this->currency->getCode() ),
							    $this->config->get( 'ups_integration_tax_class_id' ),
							    $this->config->get( 'config_tax' ) ),
						    $this->currency->getCode(),
						    1.0000000 )
				    )
			    );
		    }

		    if ( $local_delivery ) {
			    $quote_data = $local_delivery;
		    }
		    if ( $quote_data ) {
			    foreach ( $quote_data as $key => $value ) {
				    $quote_data[ $key ]['cost'] = $quote_data[ $key ]['cost'];
				    $quote_data[ $key ]['text'] = $this->currency->format(
                        $this->tax->calculate( $this->currency->convert( $quote_data[ $key ]['cost'],
                            $this->config->get( 'config_currency' ),
                            $this->currency->getCode() ),
                            $this->config->get( 'ups_integration_tax_class_id' ),
                            $this->config->get( 'config_tax' ) ),
                        $this->currency->getCode(),
                        1.0000000 );
			    }
		    }

		    $title = $this->language->get( 'text_ups_local_delivery', 'ups_integration/ups_integration' );

		    $method_data = array(
			    'id'         => 'ups_integration_local',
			    'title'      => $title,
			    'quote'      => $quote_data,
			    'sort_order' => $this->config->get( 'ups_integration_sort_order' ),
		    );

		    return $method_data;
	    }
    }

    /**
     * @param $address
     * @param $weight
     * @param $length
     * @param $width
     * @param $height
     * @param $subtotal
     * @return array
     * @throws AException
     */
    private function _fetchRate($address, $weight, $length, $width, $height,$subtotal) {
        $this->load->model('localisation/zone');
        $f = new \RocketShipItUps\Rate('ups');
        if ($this->config->get('ups_integration_test') == '1') {
            $f->setParameter('debugMode', 1);
        } else {
            $f->setParameter('debugMode', 0);
        }
        $f->setParameter('username', $this->config->get('ups_integration_username'));
        $f->setParameter('password', $this->config->get('ups_integration_password'));
        $f->setParameter('license', $this->config->get('ups_integration_key'));
        $f->setParameter('accountNumber', $this->config->get('ups_integration_account'));
        $f->setParameter('PickupType', $this->config->get('ups_integration_pickup'));
        $f->setParameter( 'customerClassification', $this->config->get( 'ups_integration_classification' ) );
        $f->setParameter('shipCity', $this->config->get('ups_integration_city'));
        $f->setParameter('shipCode', $this->config->get('ups_integration_postcode'));
        $f->setParameter('shipState', $this->config->get('ups_integration_state'));
        $f->setParameter('shipCountry', $this->config->get('ups_integration_country'));
        $f->setParameter('fromCity', $this->config->get('ups_integration_city'));
        $f->setParameter('fromCode', $this->config->get('ups_integration_postcode'));
        $f->setParameter('fromState', $this->config->get('ups_integration_state'));
        $f->setParameter('fromCountry', $this->config->get('ups_integration_country'));
        $f->setParameter('toCity', $address['city']);
        $f->setParameter('toCode', $address['postcode']);
        $f->setParameter('toState', $address['zone_code']);
        $f->setParameter('toCountry', $address['iso_code_2']);
        if ($this->config->get('ups_integration_negotiated_rates') == '1') {
            $f->setParameter('negotiatedRates', '1');
        }
        if ($address['address_1'] == '') {
            if ($this->config->get('ups_integration_residential') == '1') {
                $f->setParameter('residentialAddressIndicator', '1');
            } else {
                $f->setParameter('residentialAddressIndicator', '0');
            }
        } else {
            $validate = $this->validateAddress($address);
            if ($validate == 'Residential' || $validate == 'Unknown' || $validate == '') {
                $f->setParameter('residentialAddressIndicator', '1');
            } elseif ($validate == 'Commercial') {
                $f->setParameter('residentialAddressIndicator', '0');
            }
        }
        $f->setParameter('packagingType', $this->config->get('ups_integration_packaging'));
        $f->setParameter('lengthUnit', $this->config->get('config_length_class'));
        $f->setparameter('length', $length);
        $f->setparameter('width', $width);
        $f->setparameter('height', $height);
		if ($this->config->get('config_weight_class') === 'lb') {
            $weightUnit = 'lbs';
        } elseif ($this->config->get('config_weight_class') === 'kg') {
            $weightUnit = 'kgs';
        }
        $f->setParameter('weightUnit', $weightUnit);
        $f->setParameter('weight', $weight);

        if ($this->config->get('ups_integration_declared_value_nominal') != '') {
            $decVal = $this->config->get('ups_integration_declared_value_nominal');
        } else {
            $decVal = 100;
        }

        $f->setParameter('taxIndicator','1');
        if ($this->config->get('ups_integration_declared_value') == '1' && $subtotal >= $decVal) {
            $f->setParameter('insuredCurrency', $this->config->get('config_currency'));
            $f->setParameter('insuredValue', $this->currency->format($subtotal, false, false, false));
        }

        $response=$f->getAllRates();
        if ($this->config->get('ups_integration_debug')) {
            $this->log->write('UPS Integration Debug: '.html_entity_decode(var_export($f->debug(),true)));
        }
	    if ($response['RatingServiceSelectionResponse']['Response']['ResponseStatusCode']==='1'){
		    return $response['RatingServiceSelectionResponse']['RatedShipment'];
	    }
    }

    /**
     * @param $origin
     * @param $address
     * @param string $result
     * @param string $qty
     * @param string $admin
     * @return array
     */
    private function _processRate($origin, $address, $result = '', $qty = '',$admin="") {
        if ($admin) {
            $cart = $this->cart;
        } else {
            if ($this->verifyPricingCalc() === true) {
                include_once DIR_EXT . 'pricing_calculator' . DIR_EXT_CORE . 'lib/cart.php';
                $cart = new APricingCart($this->registry);
            } elseif ($this->verifyAreaCalc() === true) {
                include_once DIR_EXT . 'area_calculator' . DIR_EXT_CORE . 'lib/cart.php';
                $cart = new AAreaCart($this->registry);
            } elseif ($this->verifyLengthCalc() === true) {
                include_once DIR_EXT . 'length_calculator' . DIR_EXT_CORE . 'lib/cart.php';
                $cart = new ALengthCart($this->registry);
            } elseif ($this->verifyLiquidsCalc() === true) {
                include_once DIR_EXT . 'liquids_calculator' . DIR_EXT_CORE . 'lib/cart.php';
                $cart = new ALiquidsCart($this->registry);
            } elseif ($this->verifyWeightCalc() === true) {
                include_once DIR_EXT . 'weight_calculator' . DIR_EXT_CORE . 'lib/cart.php';
                $cart = new AWeightCart($this->registry);
            } elseif ($this->verifyVolumeCalc() === true) {
                include_once DIR_EXT . 'volume_calculator' . DIR_EXT_CORE . 'lib/cart.php';
                $cart = new AVolumeCart($this->registry);
            } elseif ($this->verifyBuildAGift() === true) {
                include_once DIR_EXT . 'build_a_gift' . DIR_EXT_CORE . 'lib/cart.php';
                $cart = new ABagCart($this->registry);
            } else {
                $cart = $this->cart;
            }
        }

	    $this->extensions->hk_InitData($this, __FUNCTION__);
        $service_code = array(
            // US Origin
            'US' => array(
                '01' => $this->language->get('text_us_origin_01'),
                '02' => $this->language->get('text_us_origin_02'),
                '03' => $this->language->get('text_us_origin_03'),
                '07' => $this->language->get('text_us_origin_07'),
                '08' => $this->language->get('text_us_origin_08'),
                '11' => $this->language->get('text_us_origin_11'),
                '12' => $this->language->get('text_us_origin_12'),
                '13' => $this->language->get('text_us_origin_13'),
                '14' => $this->language->get('text_us_origin_14'),
                '54' => $this->language->get('text_us_origin_54'),
                '59' => $this->language->get('text_us_origin_59'),
                '65' => $this->language->get('text_us_origin_65')
            ),
            // Canada Origin
            'CA' => array(
                '01' => $this->language->get('text_ca_origin_01'),
                '02' => $this->language->get('text_ca_origin_02'),
                '07' => $this->language->get('text_ca_origin_07'),
                '08' => $this->language->get('text_ca_origin_08'),
                'intl_08' => $this->language->get('text_ca_origin_intl_08'),
                '11' => $this->language->get('text_ca_origin_11'),
                '12' => $this->language->get('text_ca_origin_12'),
                '13' => $this->language->get('text_ca_origin_13'),
                '14' => $this->language->get('text_ca_origin_14'),
                '54' => $this->language->get('text_ca_origin_54'),
                '65' => $this->language->get('text_ca_origin_65')
            ),
            // European Union Origin
            'EU' => array(
                '07' => $this->language->get('text_eu_origin_07'),
                '08' => $this->language->get('text_eu_origin_08'),
                '11' => $this->language->get('text_eu_origin_11'),
                '54' => $this->language->get('text_eu_origin_54'),
                '65' => $this->language->get('text_eu_origin_65')
            ),
            // Poland Origin
            'PL' => array(
                '07' => $this->language->get('text_pl_origin_07'),
                '08' => $this->language->get('text_pl_origin_08'),
                '11' => $this->language->get('text_pl_origin_11'),
                '54' => $this->language->get('text_pl_origin_54'),
                '65' => $this->language->get('text_pl_origin_65'),
                '82' => $this->language->get('text_pl_origin_82'),
                '83' => $this->language->get('text_pl_origin_83'),
                '84' => $this->language->get('text_pl_origin_84'),
                '85' => $this->language->get('text_pl_origin_85'),
                '86' => $this->language->get('text_pl_origin_86')
                ),
            // Puerto Rico Origin
            'PR' => array(
                '01' => $this->language->get('text_eu_origin_01'),
                '02' => $this->language->get('text_eu_origin_02'),
                '03' => $this->language->get('text_eu_origin_03'),
                '07' => $this->language->get('text_ca_origin_07'),
                '08' => $this->language->get('text_ca_origin_08'),
                '14' => $this->language->get('text_eu_origin_14'),
                '54' => $this->language->get('text_other_origin_54'),
                '65' => $this->language->get('text_other_origin_65')
            ),
            // Mexico Origin
            'MX' => array(
                '07' => $this->language->get('text_mx_origin_07'),
                '08' => $this->language->get('text_mx_origin_08'),
                '11' => $this->language->get('text_mx_origin_11'),
                '54' => $this->language->get('text_mx_origin_54'),
                '65' => $this->language->get('text_mx_origin_65')
            ),
            // All other origins
            'other' => array(
                // service code 7 seems to be gone after January 2, 2007
                '07' => $this->language->get('text_other_origin_07'),
                '08' => $this->language->get('text_other_origin_08'),
                '11' => $this->language->get('text_other_origin_11'),
                '54' => $this->language->get('text_other_origin_54'),
                '65' => $this->language->get('text_other_origin_65')
            )
        );

        $quote_data = array();
		$taxIndicator =$this->config->get('ups_integration_tax_indicator') ? $this->config->get('ups_integration_tax_indicator') : '1';
        if ($result) {
            if ($result['error'] != '') {
                $error_msg = $result['error'];
            } else {
                foreach ($result as $k => $v) {
                	 if ($origin==='CA' && $v['Service']['Code']==='08') {
                        if ($address['iso_code_2']==='CA' || $address['iso_code_2']==='US' || $address['iso_code_2']==='MX') {
                            $code = $v['Service']['Code'];
                        } else {
                            $code = 'intl_'.$v['Service']['Code'];
                        }
                    } else {
                        $code = $v['Service']['Code'];
                    }

                    if ($taxIndicator==='1' && isset($v['TotalChargesWithTaxes']) && $this->config->get('ups_integration_account')==='') {
                    	$rate=$v['TotalChargesWithTaxes']['MonetaryValue'];
                    } elseif (isset($v['NegotiatedRates']['NetSummaryCharges'])) {
                        $rate = $v['NegotiatedRates']['NetSummaryCharges']['GrandTotal']['MonetaryValue'];
                    } else {
                        $rate = $v['TotalCharges']['MonetaryValue'];
                    }
                    $type = $this->config->get('ups_integration_type');
                    $fee_rate = (float)$this->config->get('ups_integration_additional_fee');
                    if ($type == 'percent' && $fee_rate != '0') {
                        $fee = number_format($rate * ($fee_rate / 100), 2, '.', '');
                    } elseif ($type == 'fixed' && $fee_rate != '0') {
                        $fee = number_format($fee_rate, 2, '.', '');
                    }
                    if ($this->config->get('ups_integration_display_weight') == '1') {
                        $titleWeight = $service_code[$this->config->get('ups_integration_origin')][$code] . ' (' . $this->language->get('text_weight') . ' ' . $this->weight->format($cart->getWeight(), $this->config->get('config_weight_class')) . ')';
                    } else {
                        $titleWeight = $service_code[$this->config->get('ups_integration_origin')][$code];
                    }
                    if ($qty == '') {
                        $cost = $rate + $fee;
                    } else {
                        $cost = ($rate + $fee) * $qty;
                    }
                    if (!($code && $cost)) {
                        continue;
                    }
                    if ($this->config->get('ups_integration_' . strtolower($this->config->get('ups_integration_origin')) . '_' . $code)) {
                        $quote_data[$code] = array(
                            'id' => 'ups_integration.' . $code,
                            'title' => $titleWeight,
                            'cost' => $this->currency->convert($cost, $this->config->get('config_currency'), $this->config->get( 'config_currency' )),
                            'tax_class_id' => $this->config->get('ups_integration_tax_class_id'),
                            'text' => $this->currency->format(
                                $this->tax->calculate( $this->currency->convert( $cost,
                                    $this->config->get( 'config_currency' ),
                                    $this->currency->getCode() ),
                                    $this->config->get( 'ups_integration_tax_class_id' ),
                                    $this->config->get( 'config_tax' ) ),
                                $this->currency->getCode(),
                                1.0000000 )
                        );
                    }
                }
            }
        }

        return array('quote_data' => $quote_data, 'error_msg' => $error_msg);
    }

    private function validateAddress($address) {
        $v = new \RocketShipItUps\AddressValidate('UPS');
        $v->setParameter('username', $this->config->get('ups_integration_username'));
        $v->setParameter('password', $this->config->get('ups_integration_password'));
        $v->setParameter('license', $this->config->get('ups_integration_key'));
        $v->setParameter('toName', $address['firstname'] . ' ' . $address['lastname']);
        $v->setParameter('toState', $address['zone_code']);
        $v->setParameter('toAddr1', $address['address_1']);
        $v->setParameter('toCity', $address['city']);
        $v->setParameter('toCode', $address['postcode']);
        $v->setParameter('toCountry', $address['iso_code_2']);
        $response = $v->validateStreetLevel();
        return $response['AddressValidationResponse']['AddressClassification']['Description'];
    }

    /**
     * @param array $product_ids
     * @param string $admin
     * @return float|int
     */
    private function getIndividualWeight($product_ids = array(),$admin="") {
        $weight = 0;
        if ($admin) {
            $cart = $this->cart;
        } else {
            if ($this->verifyPricingCalc() === true) {
                include_once DIR_EXT . 'pricing_calculator' . DIR_EXT_CORE . 'lib/cart.php';
                $cart = new APricingCart($this->registry);
            } elseif ($this->verifyAreaCalc() === true) {
                include_once DIR_EXT . 'area_calculator' . DIR_EXT_CORE . 'lib/cart.php';
                $cart = new AAreaCart($this->registry);
            } elseif ($this->verifyLengthCalc() === true) {
                include_once DIR_EXT . 'length_calculator' . DIR_EXT_CORE . 'lib/cart.php';
                $cart = new ALengthCart($this->registry);
            } elseif ($this->verifyLiquidsCalc() === true) {
                include_once DIR_EXT . 'liquids_calculator' . DIR_EXT_CORE . 'lib/cart.php';
                $cart = new ALiquidsCart($this->registry);
            } elseif ($this->verifyWeightCalc() === true) {
                include_once DIR_EXT . 'weight_calculator' . DIR_EXT_CORE . 'lib/cart.php';
                $cart = new AWeightCart($this->registry);
            } elseif ($this->verifyVolumeCalc() === true) {
                include_once DIR_EXT . 'volume_calculator' . DIR_EXT_CORE . 'lib/cart.php';
                $cart = new AVolumeCart($this->registry);
            } elseif ($this->verifyBuildAGift() === true) {
                include_once DIR_EXT . 'build_a_gift' . DIR_EXT_CORE . 'lib/cart.php';
                $cart = new ABagCart($this->registry);
            } else {
                $cart = $this->cart;
            }
        }

	    foreach ($cart->getProducts() as $product) {
            if (count($product_ids) > 0 && !in_array((string)$product['product_id'], $product_ids)) {
                continue;
            }

            if ($product['shipping']) {
                $product_weight = $product['weight'];
                // if product_option has weight value
                if ($product['option']) {
                    $hard = false;
                    foreach ($product['option'] as $option) {
                        if ($option['weight'] == 0) continue; // if weight not set - skip
                        if ($option['weight_type'] != '%') {
                            //If weight was set by option hard and other option sets another weight hard - ignore it
                            //skip negative weight. Negative allowed only for % based weight
                            if ($hard || $option['weight'] < 0) {
                                continue;
                            }
                            //$hard = true;
                            $product_weight = $cart->weight->convert($option['weight'], $option['weight_type'], $product['weight_class']);
                        } else {
                            //We need product base weight for % calculation
                            $temp = ($option['weight'] * $product['weight'] / 100) + $product['weight'];
                            $product_weight = $cart->weight->convert($temp, $option['weight_type'], $this->config->get('config_weight_class'));
                        }
                    }
                }
                $weight = $cart->weight->convert($product_weight, $product['weight_class'], $this->config->get('config_weight_class'));
            }
        }
        return $weight;
    }
}