<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2020 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if ( ! defined( 'DIR_CORE' ) ) {
	header( 'Location: static_pages/' );
}
/**
 * Class ControllerPagesExtensionUpsIntegration
 * @property ModelExtensionUpsIntegration $model_extension_ups_integration
 */

require_once DIR_EXT . "ups_integration" . DIR_EXT_CORE . "helpers.php";

class ControllerPagesExtensionUpsIntegration extends AController {
	private $error = array();
	public $data = array();
	private $errors = array( 'key', 'username', 'password', 'country', 'postcode' );
	private $fields = array(
        'ups_integration_debug',
		'ups_integration_license_code',
		'ups_integration_key',
		'ups_integration_username',
		'ups_integration_password',
		'ups_integration_account',
		'ups_integration_pickup',
		'ups_integration_packaging',
		'ups_integration_classification',
		'ups_integration_origin',
		'ups_integration_city',
		'ups_integration_state',
		'ups_integration_country',
		'ups_integration_postcode',
		'ups_integration_test',
		'ups_integration_quote_type',
		'ups_integration_residential',
		'ups_integration_negotiated_rates',
		'ups_integration_us_01',
		'ups_integration_us_02',
		'ups_integration_us_03',
		'ups_integration_us_07',
		'ups_integration_us_08',
		'ups_integration_us_11',
		'ups_integration_us_12',
		'ups_integration_us_13',
		'ups_integration_us_14',
		'ups_integration_us_54',
		'ups_integration_us_59',
		'ups_integration_us_65',
		'ups_integration_free_us_method',
		'ups_integration_pr_01',
		'ups_integration_pr_02',
		'ups_integration_pr_03',
		'ups_integration_pr_07',
		'ups_integration_pr_08',
		'ups_integration_pr_14',
		'ups_integration_pr_54',
		'ups_integration_pr_65',
		'ups_integration_free_pr_method',
		'ups_integration_ca_01',
		'ups_integration_ca_02',
		'ups_integration_ca_07',
		'ups_integration_ca_08',
		'ups_integration_ca_intl_08',
		'ups_integration_ca_11',
		'ups_integration_ca_12',
		'ups_integration_ca_13',
		'ups_integration_ca_14',
		'ups_integration_ca_54',
		'ups_integration_ca_65',
		'ups_integration_free_ca_method',
		'ups_integration_mx_07',
		'ups_integration_mx_08',
		'ups_integration_mx_11',
		'ups_integration_mx_54',
		'ups_integration_mx_65',
		'ups_integration_free_mx_method',
		'ups_integration_eu_07',
		'ups_integration_eu_08',
		'ups_integration_eu_11',
		'ups_integration_eu_54',
		'ups_integration_eu_65',
		'ups_integration_free_eu_method',
		'ups_integration_pl_07',
		'ups_integration_pl_08',
		'ups_integration_pl_11',
		'ups_integration_pl_54',
		'ups_integration_pl_65',
		'ups_integration_pl_82',
		'ups_integration_pl_83',
		'ups_integration_pl_84',
		'ups_integration_pl_85',
		'ups_integration_pl_86',
		'ups_integration_free_pl_method',
		'ups_integration_other_07',
		'ups_integration_other_08',
		'ups_integration_other_11',
		'ups_integration_other_54',
		'ups_integration_other_65',
		'ups_integration_free_other_method',
		'ups_integration_local_zipcodes',
		'ups_integration_local_delivery_fee',
		'ups_integration_local_delivery_only',
		'ups_integration_local_delivery_message',
		'ups_integration_display_weight',
		'ups_integration_weight_code',
		'ups_integration_weight_class',
		'ups_integration_length_class',
		'ups_integration_length',
		'ups_integration_height',
		'ups_integration_width',
		'ups_integration_weight',
		'ups_integration_tax_class_id',
		'ups_integration_location_id',
		'ups_integration_status',
		'ups_integration_sort_order',
		'ups_integration_type',
		'ups_integration_additional_fee',
		'ups_integration_additional_weight',
		'ups_integration_declared_value',
		'ups_integration_declared_value_nominal',
		'ups_integration_estimate_message',
	);
	private $cfg = array();

	public function verify() {
		return true;
		if ($this->config->get('ups_integration_status')==='1') {
			$exist = $this->db->query("SHOW TABLES LIKE '".$this->db->table('ups_integration_license')."'");
			if ($exist->num_rows === 1) {
				$validation = upsIntegrationVerifyLicense();
				if ( $validation['notification_case'] === 'notification_license_ok' ) {
					return true;
				} elseif ( $validation['notification_case'] === 'notification_license_corrupted' ) {
					return false;
				}
			} else {
				return false;
			}
		} else {
			return false;
		}
	}

	public function verifyEditor() {
		return false;
		if ( $this->config->get( 'editor_status' ) === '1' ) {
			$exist = $this->db->query("SHOW TABLES LIKE '".$this->db->table('editor_license')."'");
			if ($exist->num_rows === 1) {
				$validation = editorVerifyLicense();
				if ( $validation['notification_case'] === 'notification_license_ok' ) {
					return true;
				} elseif ( $validation['notification_case'] === 'notification_license_corrupted' ) {
					return false;
				}
			} else {
				return false;
			}
		} else {
			return false;
		}
	}

	public function main() {
		$this->request->get['extension'] = 'ups_integration';
		$this->loadLanguage( 'ups_integration/ups_integration' );
		$this->document->setTitle( $this->language->get( 'text_additional_settings' ) );
		$this->load->model( 'setting/setting' );

		if ( $this->request->is_POST() && $this->_validate() ) {
			$this->model_setting_setting->editSetting( 'ups_integration', $this->request->post );
			$this->session->data['success'] = $this->language->get( 'text_success' );
			$this->loadModel( 'localisation/country' );
			$mode    = (int) $this->request->post['ups_integration_test'];
			$content = "<?php\n";
			$content .= "return array(\n";
			$content .= "'generic' => array(\n";
			$content .= "'timezone' => '" . date_default_timezone_get() . "',\n";
            $content .= "'shipper' => '" . addslashes($this->config->get( 'store_name' )) . "',\n";
			$content .= "'shipContact' => '" . $this->config->get( 'config_owner' ) . "',\n";
			$content .= "'currency' => '" . $this->config->get( 'config_currency' ) . "',\n";
			$content .= "),\n";
			$content .= ");";
			$file    = fopen( DIR_EXT . 'ups_integration' . DIR_EXT_CORE . 'lib/config.php', 'w' );
			fwrite( $file, $content );
			fclose( $file );
			$this->redirect( $this->html->getSecureURL( 'extension/ups_integration' ) );
		}

		if ( isset( $this->error['warning'] ) ) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}
		$this->data['success'] = $this->session->data['success'];
		if ( isset( $this->session->data['success'] ) ) {
			unset( $this->session->data['success'] );
		}

		if ( isset( $this->error['key'] ) ) {
			$this->data['error_key'] = $this->error['key'];
		} else {
			$this->data['error_key'] = '';
		}

		$this->data['error'] = array();
		foreach ( $this->errors as $f ) {
			if ( isset ( $this->error[ $f ] ) ) {
				$this->data['error'][ $f ] = $this->error[ $f ];
			}
		}

		$this->document->initBreadcrumb( array(
			'href'      => $this->html->getSecureURL( 'index/home' ),
			'text'      => $this->language->get( 'text_home' ),
			'separator' => false
		) );
		$this->document->addBreadcrumb( array(
			'href'      => $this->html->getSecureURL( 'extension/extensions/shipping' ),
			'text'      => $this->language->get( 'text_shipping' ),
			'separator' => ' :: '
		) );
		$this->document->addBreadcrumb( array(
			'href'      => $this->html->getSecureURL( 'shipping/ups_integration' ),
			'text'      => $this->language->get( 'ups_integration_name' ),
			'separator' => ' :: ',
			'current'   => true
		) );

		$pickups = array(
			'01' => $this->language->get( 'text_daily_pickup' ),
			'03' => $this->language->get( 'text_customer_counter' ),
			'06' => $this->language->get( 'text_one_time_pickup' ),
			'19' => $this->language->get( 'text_letter_center' ),
			'20' => $this->language->get( 'text_air_service_center' ),
		);

		$packages = array(
			'02' => $this->language->get( 'text_package' ),
			'01' => $this->language->get( 'text_ups_integration_letter' ),
			'03' => $this->language->get( 'text_ups_integration_tube' ),
			'04' => $this->language->get( 'text_ups_integration_pak' ),
			'21' => $this->language->get( 'text_ups_integration_express_box' ),
			'24' => $this->language->get( 'text_ups_integration_25kg_box' ),
			'25' => $this->language->get( 'text_ups_integration_10kg_box' ),
		);

		$classifications = array(
			'00' => '00',
			'01' => '01',
			'04' => '04',
			'06' => '06',
			'53' => '53',
		);

		$origins = array(
			'US'    => $this->language->get( 'text_us' ),
			'CA'    => $this->language->get( 'text_ca' ),
			'EU'    => $this->language->get( 'text_eu' ),
			'PL'    => $this->language->get( 'text_pl' ),
			'PR'    => $this->language->get( 'text_pr' ),
			'MX'    => $this->language->get( 'text_mx' ),
			'other' => $this->language->get( 'text_other' ),
		);

		$this->view->assign( 'addition_note', $this->language->get( 'ups_integration_addition_note' ) );
		$this->view->assign( 'ext_text', $this->language->get( 'ups_integration_ext_man' ) );
		$this->view->assign( 'ext_man', 'https://why2central.net/v1/ups' );

		$this->load->model( 'localisation/weight_class' );

		$this->load->model( 'localisation/tax_class' );
		$results     = $this->model_localisation_tax_class->getTaxClasses();
		$tax_classes = array( 0 => $this->language->get( 'text_none' ) );
		foreach ( $results as $k => $v ) {
			$tax_classes[ $v['tax_class_id'] ] = $v['title'];
		}

		$this->load->model( 'localisation/location' );
		$results   = $this->model_localisation_location->getLocations();
		$locations = array( 0 => $this->language->get( 'text_all_zones' ) );
		foreach ( $results as $k => $v ) {
			$locations[ $v['location_id'] ] = $v['name'];
		}

		foreach ( $this->fields as $f ) {
			if ( isset ( $this->request->post [ $f ] ) ) {
				$this->data [ $f ] = $this->request->post [ $f ];
			} else {
				$this->data [ $f ] = $this->config->get( $f );
			}
		}

		$this->data ['action']        = $this->html->getSecureURL( 'extension/ups_integration', '&extension=ups_integration' );
		$this->data['cancel']         = $this->html->getSecureURL( 'extension/extensions/shipping' );
		$this->data ['heading_title'] = $this->language->get( 'text_edit' ) . $this->language->get( 'text_shipping' );
		$this->data ['form_title']    = $this->language->get( 'heading_title' );
		$this->data ['update']        = $this->html->getSecureURL( 'r/extension/ups_integration_save/update' );

		$form = new AForm ( 'HS' );
		$form->setForm( array(
			'form_name' => 'editFrm',
			'update'    => $this->data ['update']
		) );

		$this->data['form']['form_open']                  = $form->getFieldHtml( array(
			'type'   => 'form',
			'name'   => 'editFrm',
			'action' => $this->data ['action'],
			'attr'   => 'data-confirm-exit="true" class="aform form-horizontal"'
		) );
		$this->data['form']['submit']                     = $form->getFieldHtml( array(
			'type' => 'button',
			'name' => 'submit',
			'text' => $this->language->get( 'button_save' )
		) );
		$this->data['form']['cancel']                     = $form->getFieldHtml( array(
			'type' => 'button',
			'name' => 'cancel',
			'text' => $this->language->get( 'button_cancel' )
		) );
        $this->data['form']['fields']['debug'] = $form->getFieldHtml(array(
            'type' => 'checkbox',
            'name' => 'ups_integration_debug',
            'value' => $this->data['ups_integration_debug'],
            'style'  => 'btn_switch',
        ));
		$this->data['form']['fields']['test']             = $form->getFieldHtml( array(
			'type'  => 'checkbox',
			'name'  => 'ups_integration_test',
			'value' => $this->data['ups_integration_test'],
			'style' => 'btn_switch',
		) );
		$this->data['form']['fields']['key']              = $form->getFieldHtml( array(
			'type'     => 'input',
			'name'     => 'ups_integration_key',
			'value'    => $this->data['ups_integration_key'],
			'required' => true,
			'style'    => 'small-field',
		) );
		$this->data['form']['fields']['username']         = $form->getFieldHtml( array(
			'type'     => 'input',
			'name'     => 'ups_integration_username',
			'value'    => $this->data['ups_integration_username'],
			'required' => true,
			'style'    => 'small-field',
		) );
		$this->data['form']['fields']['password']         = $form->getFieldHtml( array(
			'type'     => 'input',
			'name'     => 'ups_integration_password',
			'value'    => $this->data['ups_integration_password'],
			'required' => true,
			'style'    => 'small-field',
		) );
		$this->data['form']['fields']['account']          = $form->getFieldHtml( array(
			'type'  => 'input',
			'name'  => 'ups_integration_account',
			'value' => $this->data['ups_integration_account'],
			'style' => 'small-field',
		) );
		$this->data['form']['fields']['pickup']           = $form->getFieldHtml( array(
			'type'    => 'selectbox',
			'name'    => 'ups_integration_pickup',
			'options' => $pickups,
			'value'   => $this->data['ups_integration_pickup'],
			'style'   => 'small-field',
		) );
		$this->data['form']['fields']['packaging']        = $form->getFieldHtml( array(
			'type'    => 'selectbox',
			'name'    => 'ups_integration_packaging',
			'options' => $packages,
			'value'   => $this->data['ups_integration_packaging'],
			'style'   => 'small-field',
		) );
		$this->data['form']['fields']['classification']   = $form->getFieldHtml( array(
			'type'    => 'selectbox',
			'name'    => 'ups_integration_classification',
			'options' => $classifications,
			'value'   => $this->data['ups_integration_classification'],
			'style'   => 'small-field',
		) );
		$this->data['form']['fields']['residential']      = $form->getFieldHtml( array(
			'type'  => 'checkbox',
			'name'  => 'ups_integration_residential',
			'value' => $this->data['ups_integration_residential'],
			'style' => 'btn_switch',
		) );
		$this->data['form']['fields']['negotiated_rates'] = $form->getFieldHtml( array(
			'type'  => 'checkbox',
			'name'  => 'ups_integration_negotiated_rates',
			'value' => $this->data['ups_integration_negotiated_rates'],
			'style' => 'btn_switch',
		) );
		$this->data['form']['fields']['origin']           = $form->getFieldHtml( array(
			'type'    => 'selectbox',
			'name'    => 'ups_integration_origin',
			'options' => $origins,
			'value'   => $this->data['ups_integration_origin'],
			'style'   => 'small-field',
		) );
		$this->data['form']['fields']['city']             = $form->getFieldHtml( array(
			'type'  => 'input',
			'name'  => 'ups_integration_city',
			'value' => $this->data['ups_integration_city'],
			'style' => 'small-field',
		) );

		$this->data['form']['fields']['postcode']        = $form->getFieldHtml( array(
			'type'  => 'input',
			'name'  => 'ups_integration_postcode',
			'value' => $this->data['ups_integration_postcode'],
			'style' => 'small-field',
		) );
		$this->data['form']['fields']['state']           = $form->getFieldHtml( array(
			'type'  => 'input',
			'name'  => 'ups_integration_state',
			'value' => $this->data['ups_integration_state'],
			'style' => 'small-field',
		) );
		$this->data['form']['fields']['country']         = $form->getFieldHtml( array(
			'type'     => 'input',
			'name'     => 'ups_integration_country',
			'value'    => $this->data['ups_integration_country'],
			'required' => true,
			'style'    => 'small-field',
		) );
		$this->data['form']['fields']['test_connection'] = $form->getFieldHtml( array(
			'type'     => 'button',
			'name'     => 'test_connection',
			'title'    => $this->language->get( 'entry_test_connect' ),
			'text'     => $this->language->get( 'entry_test_connect' ),
			'required' => true,
			'style'    => 'btn btn-info lock-on-click',
		) );
		$this->data['test']                              = $this->language->get( ( 'entry_test' ) );
		$this->data['test_url']                          = $this->html->getSecureURL( 'r/extension/ups_test/test' );
		$this->data['form']['fields']['service']         = array( 'checkboxes' => true );
		//US
		$this->data['form']['fields']['service']['US']['next_day_air']           = $form->getFieldHtml( array(
			'type'  => 'checkbox',
			'name'  => 'ups_integration_us_01',
			'value' => $this->data['ups_integration_us_01'],
		) );
		$this->data['form']['fields']['service']['US']['2nd_day_air']            = $form->getFieldHtml( array(
			'type'  => 'checkbox',
			'name'  => 'ups_integration_us_02',
			'value' => $this->data['ups_integration_us_02'],
		) );
		$this->data['form']['fields']['service']['US']['ground']                 = $form->getFieldHtml( array(
			'type'  => 'checkbox',
			'name'  => 'ups_integration_us_03',
			'value' => $this->data['ups_integration_us_03'],
		) );
		$this->data['form']['fields']['service']['US']['standard']               = $form->getFieldHtml( array(
			'type'  => 'checkbox',
			'name'  => 'ups_integration_us_11',
			'value' => $this->data['ups_integration_us_11'],
		) );
		$this->data['form']['fields']['service']['US']['3_day_select']           = $form->getFieldHtml( array(
			'type'  => 'checkbox',
			'name'  => 'ups_integration_us_12',
			'value' => $this->data['ups_integration_us_12'],
		) );
		$this->data['form']['fields']['service']['US']['next_day_air_saver']     = $form->getFieldHtml( array(
			'type'  => 'checkbox',
			'name'  => 'ups_integration_us_13',
			'value' => $this->data['ups_integration_us_13'],
		) );
		$this->data['form']['fields']['service']['US']['next_day_air_early_am']  = $form->getFieldHtml( array(
			'type'  => 'checkbox',
			'name'  => 'ups_integration_us_14',
			'value' => $this->data['ups_integration_us_14'],
		) );
		$this->data['form']['fields']['service']['US']['2nd_day_air_am']         = $form->getFieldHtml( array(
			'type'  => 'checkbox',
			'name'  => 'ups_integration_us_59',
			'value' => $this->data['ups_integration_us_59'],
		) );
		$this->data['form']['fields']['service']['US']['worldwide_express']      = $form->getFieldHtml( array(
			'type'  => 'checkbox',
			'name'  => 'ups_integration_us_07',
			'value' => $this->data['ups_integration_us_07'],
		) );
		$this->data['form']['fields']['service']['US']['worldwide_expedited']    = $form->getFieldHtml( array(
			'type'  => 'checkbox',
			'name'  => 'ups_integration_us_08',
			'value' => $this->data['ups_integration_us_08'],
		) );
		$this->data['form']['fields']['service']['US']['worldwide_express_plus'] = $form->getFieldHtml( array(
			'type'  => 'checkbox',
			'name'  => 'ups_integration_us_54',
			'value' => $this->data['ups_integration_us_54'],
		) );
		$this->data['form']['fields']['service']['US']['worldwide_saver']        = $form->getFieldHtml( array(
			'type'  => 'checkbox',
			'name'  => 'ups_integration_us_65',
			'value' => $this->data['ups_integration_us_65'],
		) );

		$this->data['form']['fields']['service']['PR']['next_day_air']           = $form->getFieldHtml( array(
			'type'  => 'checkbox',
			'name'  => 'ups_integration_pr_01',
			'value' => $this->data['ups_integration_pr_01'],
		) );
		$this->data['form']['fields']['service']['PR']['2nd_day_air']            = $form->getFieldHtml( array(
			'type'  => 'checkbox',
			'name'  => 'ups_integration_pr_02',
			'value' => $this->data['ups_integration_pr_02'],
		) );
		$this->data['form']['fields']['service']['PR']['ground']                 = $form->getFieldHtml( array(
			'type'  => 'checkbox',
			'name'  => 'ups_integration_pr_03',
			'value' => $this->data['ups_integration_pr_03'],
		) );
		$this->data['form']['fields']['service']['PR']['worldwide_express']      = $form->getFieldHtml( array(
			'type'  => 'checkbox',
			'name'  => 'ups_integration_pr_07',
			'value' => $this->data['ups_integration_pr_07'],
		) );
		$this->data['form']['fields']['service']['PR']['worldwide_expedited']    = $form->getFieldHtml( array(
			'type'  => 'checkbox',
			'name'  => 'ups_integration_pr_08',
			'value' => $this->data['ups_integration_pr_08'],
		) );
		$this->data['form']['fields']['service']['PR']['next_day_air_early_am']  = $form->getFieldHtml( array(
			'type'  => 'checkbox',
			'name'  => 'ups_integration_pr_14',
			'value' => $this->data['ups_integration_pr_14'],
		) );
		$this->data['form']['fields']['service']['PR']['worldwide_express_plus'] = $form->getFieldHtml( array(
			'type'  => 'checkbox',
			'name'  => 'ups_integration_pr_54',
			'value' => $this->data['ups_integration_pr_54'],
		) );
		$this->data['form']['fields']['service']['PR']['saver']                  = $form->getFieldHtml( array(
			'type'  => 'checkbox',
			'name'  => 'ups_integration_pr_65',
			'value' => $this->data['ups_integration_pr_65'],
		) );

		$this->data['form']['fields']['service']['CA']['express']                = $form->getFieldHtml( array(
			'type'  => 'checkbox',
			'name'  => 'ups_integration_ca_01',
			'value' => $this->data['ups_integration_ca_01'],
		) );
		$this->data['form']['fields']['service']['CA']['expedited']              = $form->getFieldHtml( array(
			'type'  => 'checkbox',
			'name'  => 'ups_integration_ca_02',
			'value' => $this->data['ups_integration_ca_02'],
		) );
		$this->data['form']['fields']['service']['CA']['worldwide_express']      = $form->getFieldHtml( array(
			'type'  => 'checkbox',
			'name'  => 'ups_integration_ca_07',
			'value' => $this->data['ups_integration_ca_07'],
		) );
		$this->data['form']['fields']['service']['CA']['expedited']              = $form->getFieldHtml( array(
			'type'  => 'checkbox',
			'name'  => 'ups_integration_ca_08',
			'value' => $this->data['ups_integration_ca_08'],
		) );
		$this->data['form']['fields']['service']['CA']['worldwide_expedited']    = $form->getFieldHtml( array(
			'type'  => 'checkbox',
			'name'  => 'ups_integration_ca_intl_08',
			'value' => $this->data['ups_integration_ca_intl_08'],
		) );
		$this->data['form']['fields']['service']['CA']['standard']               = $form->getFieldHtml( array(
			'type'  => 'checkbox',
			'name'  => 'ups_integration_ca_11',
			'value' => $this->data['ups_integration_ca_11'],
		) );
		$this->data['form']['fields']['service']['CA']['3_day_select']           = $form->getFieldHtml( array(
			'type'  => 'checkbox',
			'name'  => 'ups_integration_ca_12',
			'value' => $this->data['ups_integration_ca_12'],
		) );
		$this->data['form']['fields']['service']['CA']['next_day_air_saver']     = $form->getFieldHtml( array(
			'type'  => 'checkbox',
			'name'  => 'ups_integration_ca_13',
			'value' => $this->data['ups_integration_ca_13'],
		) );
		$this->data['form']['fields']['service']['CA']['express_early_am']       = $form->getFieldHtml( array(
			'type'  => 'checkbox',
			'name'  => 'ups_integration_ca_14',
			'value' => $this->data['ups_integration_ca_14'],
		) );
		$this->data['form']['fields']['service']['CA']['worldwide_express_plus'] = $form->getFieldHtml( array(
			'type'  => 'checkbox',
			'name'  => 'ups_integration_ca_54',
			'value' => $this->data['ups_integration_ca_54'],
		) );
		$this->data['form']['fields']['service']['CA']['express_saver']          = $form->getFieldHtml( array(
			'type'  => 'checkbox',
			'name'  => 'ups_integration_ca_65',
			'value' => $this->data['ups_integration_ca_65'],
		) );


		$this->data['form']['fields']['service']['MX']['express']                = $form->getFieldHtml( array(
			'type'  => 'checkbox',
			'name'  => 'ups_integration_mx_07',
			'value' => $this->data['ups_integration_mx_07'],
		) );
		$this->data['form']['fields']['service']['MX']['expedited']              = $form->getFieldHtml( array(
			'type'  => 'checkbox',
			'name'  => 'ups_integration_mx_08',
			'value' => $this->data['ups_integration_mx_08'],
		) );
		$this->data['form']['fields']['service']['MX']['standard']               = $form->getFieldHtml( array(
			'type'  => 'checkbox',
			'name'  => 'ups_integration_mx_11',
			'value' => $this->data['ups_integration_mx_11'],
		) );
		$this->data['form']['fields']['service']['MX']['worldwide_express_plus'] = $form->getFieldHtml( array(
			'type'  => 'checkbox',
			'name'  => 'ups_integration_mx_54',
			'value' => $this->data['ups_integration_mx_54'],
		) );
		$this->data['form']['fields']['service']['MX']['saver']                  = $form->getFieldHtml( array(
			'type'  => 'checkbox',
			'name'  => 'ups_integration_mx_65',
			'value' => $this->data['ups_integration_mx_65'],
		) );

		$this->data['form']['fields']['service']['EU']['express']      = $form->getFieldHtml( array(
			'type'  => 'checkbox',
			'name'  => 'ups_integration_eu_07',
			'value' => $this->data['ups_integration_eu_07'],
		) );
		$this->data['form']['fields']['service']['EU']['expedited']    = $form->getFieldHtml( array(
			'type'  => 'checkbox',
			'name'  => 'ups_integration_eu_08',
			'value' => $this->data['ups_integration_eu_08'],
		) );
		$this->data['form']['fields']['service']['EU']['standard']     = $form->getFieldHtml( array(
			'type'  => 'checkbox',
			'name'  => 'ups_integration_eu_11',
			'value' => $this->data['ups_integration_eu_11'],
		) );
		$this->data['form']['fields']['service']['EU']['express_plus'] = $form->getFieldHtml( array(
			'type'  => 'checkbox',
			'name'  => 'ups_integration_eu_54',
			'value' => $this->data['ups_integration_eu_54'],
		) );
		$this->data['form']['fields']['service']['EU']['saver']        = $form->getFieldHtml( array(
			'type'  => 'checkbox',
			'name'  => 'ups_integration_eu_65',
			'value' => $this->data['ups_integration_eu_65'],
		) );

		$this->data['form']['fields']['service']['PL']['express']                 = $form->getFieldHtml( array(
			'type'  => 'checkbox',
			'name'  => 'ups_integration_pl_07',
			'value' => $this->data['ups_integration_pl_07'],
		) );
		$this->data['form']['fields']['service']['PL']['expedited']               = $form->getFieldHtml( array(
			'type'  => 'checkbox',
			'name'  => 'ups_integration_pl_08',
			'value' => $this->data['ups_integration_pl_08'],
		) );
		$this->data['form']['fields']['service']['PL']['standard']                = $form->getFieldHtml( array(
			'type'  => 'checkbox',
			'name'  => 'ups_integration_pl_11',
			'value' => $this->data['ups_integration_pl_11'],
		) );
		$this->data['form']['fields']['service']['PL']['express_plus']            = $form->getFieldHtml( array(
			'type'  => 'checkbox',
			'name'  => 'ups_integration_pl_54',
			'value' => $this->data['ups_integration_pl_54'],
		) );
		$this->data['form']['fields']['service']['PL']['express_saver']           = $form->getFieldHtml( array(
			'type'  => 'checkbox',
			'name'  => 'ups_integration_pl_65',
			'value' => $this->data['ups_integration_pl_65'],
		) );
		$this->data['form']['fields']['service']['PL']['today_standard']          = $form->getFieldHtml( array(
			'type'  => 'checkbox',
			'name'  => 'ups_integration_pl_82',
			'value' => $this->data['ups_integration_pl_82'],
		) );
		$this->data['form']['fields']['service']['PL']['today_dedicated_courier'] = $form->getFieldHtml( array(
			'type'  => 'checkbox',
			'name'  => 'ups_integration_pl_83',
			'value' => $this->data['ups_integration_pl_83'],
		) );
		$this->data['form']['fields']['service']['PL']['today_express']           = $form->getFieldHtml( array(
			'type'  => 'checkbox',
			'name'  => 'ups_integration_pl_85',
			'value' => $this->data['ups_integration_pl_85'],
		) );
		$this->data['form']['fields']['service']['PL']['today_express_saver']     = $form->getFieldHtml( array(
			'type'  => 'checkbox',
			'name'  => 'ups_integration_pl_86',
			'value' => $this->data['ups_integration_pl_86'],
		) );

		$this->data['form']['fields']['service']['other']['express']                = $form->getFieldHtml( array(
			'type'  => 'checkbox',
			'name'  => 'ups_integration_other_07',
			'value' => $this->data['ups_integration_other_07'],
		) );
		$this->data['form']['fields']['service']['other']['expedited']              = $form->getFieldHtml( array(
			'type'  => 'checkbox',
			'name'  => 'ups_integration_other_08',
			'value' => $this->data['ups_integration_other_08'],
		) );
		$this->data['form']['fields']['service']['other']['standard']               = $form->getFieldHtml( array(
			'type'  => 'checkbox',
			'name'  => 'ups_integration_other_11',
			'value' => $this->data['ups_integration_other_11'],
		) );
		$this->data['form']['fields']['service']['other']['worldwide_express_plus'] = $form->getFieldHtml( array(
			'type'  => 'checkbox',
			'name'  => 'ups_integration_other_54',
			'value' => $this->data['ups_integration_other_54'],
		) );
		$this->data['form']['fields']['service']['other']['saver']                  = $form->getFieldHtml( array(
			'type'  => 'checkbox',
			'name'  => 'ups_integration_other_65',
			'value' => $this->data['ups_integration_other_65'],
		) );

		$this->data['form']['fields']['local_zipcodes'] = $form->getFieldHtml( array(
			'type'  => 'textarea',
			'name'  => 'ups_integration_local_zipcodes',
			'value' => $this->data['ups_integration_local_zipcodes'],
		) );

		$this->data['form']['fields']['local_delivery_fee'] = $form->getFieldHtml( array(
			'type'     => 'input',
			'name'     => 'ups_integration_local_delivery_fee',
			'value'    => $this->data['ups_integration_local_delivery_fee'],
			'required' => true,
			'style'    => 'small-field',
		) );

		$this->data['form']['fields']['local_delivery_only'] = $form->getFieldHtml( array(
			'type'  => 'checkbox',
			'name'  => 'ups_integration_local_delivery_only',
			'value' => $this->data['ups_integration_local_delivery_only'],
			'style' => 'btn_switch',
		) );

		if ( VERSION === '1.2.0' || VERSION === '1.2.1' || VERSION === '1.2.2' || VERSION === '1.2.3'
		     || VERSION === '1.2.4' || VERSION === '1.2.5' ) {
			$this->data['form']['fields']['local_delivery_message'] = $form->getFieldHtml( array(
				'type'  => 'textarea',
				'name'  => 'ups_integration_local_delivery_message',
				'value' => $this->config->get( 'ups_integration_local_delivery_message' ),
			) );
		} else {
			$this->data['form']['fields']['local_delivery_message'] = $form->getFieldHtml( array(
				'type'  => 'texteditor',
				'name'  => 'ups_integration_local_delivery_message',
				'value' => $this->config->get( 'ups_integration_local_delivery_message' ),
				'style' => 'xl-field',
			) );
		}

		$us                = array(
			'next_day_air',
			'2nd_day_air',
			'ground',
			'standard',
			'3_day_select',
			'next_day_air_saver',
			'next_day_air_early_am',
			'2nd_day_air_am',
			'worldwide_express_plus',
			'worldwide_express',
			'worldwide_expedited',
			'worldwide_saver'
		);
		$optionsUS         = array();
		$optionsUS['NONE'] = 'NONE';
		foreach ( $us as $u ) {
			$title               = $u;
			$optionsUS[ $title ] = $this->language->get( 'text_' . $u );
		}

		$this->data['form']['fields']['free_us_method'] = $form->getFieldHtml( array(
			'type'    => 'selectbox',
			'name'    => 'ups_integration_free_us_method',
			'options' => $optionsUS,
			'value'   => $this->data['ups_integration_free_us_method'],
		) );

		//PR
		$pr                = array(
			'next_day_air',
			'2nd_day_air',
			'ground',
			'worldwide_express',
			'worldwide_expedited',
			'next_day_air_early_am',
			'worldwide_express_plus',
			'saver'
		);
		$optionsPR         = array();
		$optionsPR['NONE'] = 'NONE';
		foreach ( $pr as $p ) {
			$title               = $p;
			$optionsPR[ $title ] = $this->language->get( 'text_' . $p );
		}
		$this->data['form']['fields']['free_pr_method'] = $form->getFieldHtml( array(
			'type'    => 'selectbox',
			'name'    => 'ups_integration_free_pr_method',
			'options' => $optionsPR,
			'value'   => $this->data['ups_integration_free_pr_method'],
			'style'   => 'small-field',
		) );
		//CA
		$ca                = array(
			'express',
			'expedited',
			'worldwide_express',
			'worldwide_expedited',
			'standard',
			'3_day_select',
			'next_day_air_saver',
			'express_early_am',
			'worldwide_express_plus',
			'express_saver'
		);
		$optionsCA         = array();
		$optionsCA['NONE'] = 'NONE';
		foreach ( $ca as $c ) {
			$title               = $c;
			$optionsCA[ $title ] = $this->language->get( 'text_' . $c );
		}
		$this->data['form']['fields']['free_ca_method'] = $form->getFieldHtml( array(
			'type'    => 'selectbox',
			'name'    => 'ups_integration_free_ca_method',
			'options' => $optionsCA,
			'value'   => $this->data['ups_integration_free_ca_method'],
			'style'   => 'small-field',
		) );
		//MX
		$mx                = array( 'express', 'expedited', 'standard', 'worldwide_express_plus', 'saver' );
		$optionsMX         = array();
		$optionsMX['NONE'] = 'NONE';
		foreach ( $mx as $m ) {
			$title               = $m;
			$optionsMX[ $title ] = $this->language->get( 'text_' . $m );
		}
		$this->data['form']['fields']['free_mx_method'] = $form->getFieldHtml( array(
			'type'    => 'selectbox',
			'name'    => 'ups_integration_free_mx_method',
			'options' => $optionsMX,
			'value'   => $this->data['ups_integration_free_mx_method'],
			'style'   => 'small-field',
		) );
		//EU
		$eu                = array( 'express', 'expedited', 'standard', 'express_plus', 'saver' );
		$optionsEU         = array();
		$optionsEU['NONE'] = 'NONE';
		foreach ( $eu as $e ) {
			$title               = $e;
			$optionsEU[ $title ] = $this->language->get( 'text_' . $e );
		}
		$this->data['form']['fields']['free_eu_method'] = $form->getFieldHtml( array(
			'type'    => 'selectbox',
			'name'    => 'ups_integration_free_eu_method',
			'options' => $optionsEU,
			'value'   => $this->data['ups_integration_free_eu_method'],
			'style'   => 'small-field',
		) );
		//Poland
		$pl                = array(
			'express',
			'expedited',
			'standard',
			'express_plus',
			'express_saver',
			'today_standard',
			'today_dedicated_courier',
			'today_express',
			'today_express_saver'
		);
		$optionsPL         = array();
		$optionsPL['NONE'] = 'NONE';
		foreach ( $pl as $p ) {
			$title               = $p;
			$optionsPL[ $title ] = $this->language->get( 'text_' . $p );
		}
		$this->data['form']['fields']['free_pl_method'] = $form->getFieldHtml( array(
			'type'    => 'selectbox',
			'name'    => 'ups_integration_free_pl_method',
			'options' => $optionsPL,
			'value'   => $this->data['ups_integration_free_pl_method'],
			'style'   => 'small-field',
		) );
		//other
		$other                = array( 'express', 'expedited', 'standard', 'worldwide_express_plus', 'saver' );
		$optionsOther         = array();
		$optionsOther['NONE'] = 'NONE';
		foreach ( $other as $ot ) {
			$title                  = $ot;
			$optionsOther[ $title ] = $this->language->get( 'text_' . $ot );
		}
		$this->data['form']['fields']['free_other_method'] = $form->getFieldHtml( array(
			'type'    => 'selectbox',
			'name'    => 'ups_integration_free_other_method',
			'options' => $optionsOther,
			'value'   => $this->data['ups_integration_free_other_method'],
		) );

		$this->data['form']['fields']['display_weight'] = $form->getFieldHtml( array(
			'type'    => 'selectbox',
			'name'    => 'ups_integration_display_weight',
			'value'   => $this->data['ups_integration_display_weight'],
			'options' => array(
				1 => $this->language->get( 'text_yes' ),
				0 => $this->language->get( 'text_no' ),
			),
			'style'   => 'small-field',
		) );

		$this->data['form']['fields']['length']     = $form->getFieldHtml( array(
			'type'  => 'input',
			'name'  => 'ups_integration_length',
			'value' => $this->data['ups_integration_length'],
			'style' => 'small-field',
		) );
		$this->data['form']['fields']['width']      = $form->getFieldHtml( array(
			'type'  => 'input',
			'name'  => 'ups_integration_width',
			'value' => $this->data['ups_integration_width'],
			'style' => 'small-field',
		) );
		$this->data['form']['fields']['height']     = $form->getFieldHtml( array(
			'type'  => 'input',
			'name'  => 'ups_integration_height',
			'value' => $this->data['ups_integration_height'],
			'style' => 'small-field',
		) );
		$this->data['form']['fields']['ups_weight'] = $form->getFieldHtml( array(
			'type'  => 'input',
			'name'  => 'ups_integration_weight',
			'value' => $this->data['ups_integration_weight'],
			'style' => 'small-field',
		) );
		$this->data['form']['fields']['ups_tax']    = $form->getFieldHtml( array(
			'type'    => 'selectbox',
			'name'    => 'ups_integration_tax_class_id',
			'options' => $tax_classes,
			'value'   => $this->data['ups_integration_tax_class_id'],
			'style'   => 'small-field',
		) );
		$this->data['form']['fields']['location']   = $form->getFieldHtml( array(
			'type'    => 'selectbox',
			'name'    => 'ups_integration_location_id',
			'options' => $locations,
			'value'   => $this->data['ups_integration_location_id'],
			'style'   => 'small-field',
		) );

		$optType = array();
		$opt     = array( 'fixed', 'percent' );
		foreach ( $opt as $ot ) {
			$title             = $ot;
			$optType[ $title ] = $this->language->get( 'text_' . $ot );
		}
		$this->data['form']['fields']['type'] = $form->getFieldHtml( array(
			'type'    => 'selectbox',
			'name'    => 'ups_integration_type',
			'options' => $optType,
			'value'   => $this->data['ups_integration_type'],
			'style'   => 'small-field',
		) );

		$this->data['form']['fields']['additional_fee'] = $form->getFieldHtml( array(
			'type'  => 'input',
			'name'  => 'ups_integration_additional_fee',
			'value' => moneyDisplayFormat( $this->config->get( 'ups_integration_additional_fee' ) ),
			'style' => 'small-field',
		) );

		$this->data['form']['fields']['additional_weight'] = $form->getFieldHtml( array(
			'type'  => 'input',
			'name'  => 'ups_integration_additional_weight',
			'value' => preformatFloat( $this->data['ups_integration_additional_weight'], $this->language->get( 'decimal_point' ) ),
			'style' => 'small-field',
		) );

		$this->data['form']['fields']['declared_value']         = $form->getFieldHtml( array(
			'type'  => 'checkbox',
			'name'  => 'ups_integration_declared_value',
			'value' => $this->data['ups_integration_declared_value'],
			'style' => 'btn_switch',
		) );
		$this->data['form']['fields']['declared_value_nominal'] = $form->getFieldHtml( array(
			'type'  => 'input',
			'name'  => 'ups_integration_declared_value_nominal',
			'value' => $this->data['ups_integration_declared_value_nominal'],
			'style' => 'small-field',
		) );

		if ( VERSION === '1.2.0' || VERSION === '1.2.1' || VERSION === '1.2.2' || VERSION === '1.2.3'
		     || VERSION === '1.2.4' || VERSION === '1.2.5' ) {
			$this->data['form']['fields']['estimate_message'] = $form->getFieldHtml( array(
				'type'  => 'textarea',
				'name'  => 'ups_integration_estimate_message',
				'value' => $this->config->get( 'ups_integration_estimate_message' ),
			) );
		} else {
			$this->data['form']['fields']['estimate_message'] = $form->getFieldHtml( array(
				'type'  => 'texteditor',
				'name'  => 'ups_integration_estimate_message',
				'value' => $this->config->get( 'ups_integration_estimate_message' ),
				'style' => 'xl-field',
			) );
		}

		$this->view->batchAssign( $this->language->getASet() );
		$this->addChild( 'responses/common/resource_library/get_resources_html', 'resources_html', 'responses/common/resource_library_scripts.tpl' );
		$resources_scripts               = $this->dispatch(
			'responses/common/resource_library/get_resources_scripts',
			array(
				'object_name' => '',
				'object_id'   => '',
				'types'       => array( 'image' ),
			)
		);
		$this->data['resources_scripts'] = $resources_scripts->dispatchGetOutput();
		//load tabs controller
		$this->data['editorLicense']            = $this->verifyEditor();
		$this->data['editor']                   = $this->config->get( 'editor_status' );
		$this->data['license_status']           = $this->verify();
		$this->data['text_unauthorized']        = $this->language->get( 'text_ups_integration_unauthorized' );
		$this->data['groups'][]                 = 'additional_settings';
		$this->data['link_additional_settings'] = $this->data['add_sett']->href;
		$this->data['active_group']             = 'additional_settings';

		$tabs_obj           = $this->dispatch( 'pages/extension/extension_tabs', array( $this->data ) );
		$this->data['tabs'] = $tabs_obj->dispatchGetOutput();
		unset( $tabs_obj );

		$obj                             = $this->dispatch( 'pages/extension/extension_summary', array( $this->data ) );
		$this->data['extension_summary'] = $obj->dispatchGetOutput();
		unset( $obj );
		$this->view->batchAssign( $this->data );

		$this->processTemplate( 'pages/extension/ups_integration.tpl' );
	}

	private function _validate() {
		$this->language->load( 'ups_integration/ups_integration' );
		if ( ! $this->user->canModify( 'shipping/ups' ) ) {
			$this->error['warning'] = $this->language->get( 'error_permission' );
		}

		if ( ! $this->request->post['ups_integration_key'] ) {
			$this->error['key'] = $this->language->get( 'error_key' );
		}

		if ( ! $this->request->post['ups_integration_username'] ) {
			$this->error['username'] = $this->language->get( 'error_username' );
		}

		if ( ! $this->request->post['ups_integration_password'] ) {
			$this->error['password'] = $this->language->get( 'error_password' );
		}

		if ( ! $this->request->post['ups_integration_country'] ) {
			$this->error['country'] = $this->language->get( 'error_country' );
		}

		if ( ! $this->error ) {
			return true;
		} else {
			return false;
		}
	}
}