<?php
/*
 *   $Id$
 *
 *   AbanteCart, Ideal OpenSource Ecommerce Solution
 *   http://www.AbanteCart.com
 *
 *   Copyright © 2011-2024 Belavier Commerce LLC
 *
 *   This source file is subject to Open Software License (OSL 3.0)
 *   License details is bundled with this package in the file LICENSE.txt.
 *   It is also available at this URL:
 *   <http://www.opensource.org/licenses/OSL-3.0>
 *
 *  UPGRADE NOTE:
 *    Do not edit or add to this file if you wish to upgrade AbanteCart to newer
 *    versions in the future. If you wish to customize AbanteCart for your
 *    needs please refer to http://www.AbanteCart.com for more information.
 */
/**
 * @var $this AController
 */
if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

//before install validate it is unique
$lng_code = 'ru';
$lng_name = 'Русский';
$lng_directory = 'russian';
$lng_locale = 'ru_RU.UTF-8,ru_RU,russian';
$lng_flag_path = 'extensions/default_russian/storefront/language/russian/flag.png';
$lng_sort = 2; // sorting order with other langauges
$lng_status = 0; // Status on installation of extension

$query = $this->db->query("SELECT language_id
							FROM ".$this->db->table('languages')."
							WHERE code='".$lng_code."'");
if ($query->row['language_id']) {
    $this->session->data['error'] = "Error: Language with $lng_code code is already installed! Can not install duplicate languages! Uninstall this extension before attempting again.";
    $error = new AError ($this->session->data['error']);
    $error->toLog()->toDebug();
    return false;
}

$this->db->query("INSERT INTO ".$this->db->table('languages')." (`name`,`code`,`locale`,`image`,`directory`,`filename`,`sort_order`, `status`)
				  VALUES ('".$lng_name."', '".$lng_code."', '".$lng_locale."', '".$lng_flag_path."','".$lng_directory."','".$lng_directory."','".$lng_sort."',".$lng_status.");");
$new_language_id = $this->db->getLastId();

//Load language specific data
$xml = simplexml_load_file(DIR_EXT.'default_russian/menu.xml');
$routes = [
    'text_index_home_menu'        => 'index/home',
    'text_product_special_menu'   => 'product/special',
    'text_account_login_menu'     => 'account/login',
    'text_account_logout_menu'    => 'account/logout',
    'text_account_account_menu'   => 'account/account',
    'text_account_history_menu'   => 'account/history',
    'text_checkout_cart_menu'     => 'checkout/cart',
    'text_checkout_shipping_menu' => 'checkout/fast_checkout',
];

if ($xml) {
    foreach ($xml->definition as $item) {
        $translates[$routes[(string)$item->key]] = (string)$item->value;
    }

    $storefront_menu = new AMenu_Storefront();
    $storefront_menu->addLanguage($new_language_id, $translates);
}

$this->db->query("INSERT INTO ".$this->db->table('country_descriptions')." (`country_id`,`language_id`, `name`) VALUES
(1, ".$new_language_id.",'Афганистан'),
(2, ".$new_language_id.",'Албания'),
(3, ".$new_language_id.",'Алжир'),
(4, ".$new_language_id.",'Американское Самоа'),
(5, ".$new_language_id.",'Андорра'),
(6, ".$new_language_id.",'Ангола'),
(7, ".$new_language_id.",'Ангилья'),
(8, ".$new_language_id.",'Антарктида'),
(9, ".$new_language_id.",'Антигуа и Барбуда'),
(10, ".$new_language_id.",'Аргентина'),
(11, ".$new_language_id.",'Армения'),
(12, ".$new_language_id.",'Аруба'),
(13, ".$new_language_id.",'Австралия'),
(14, ".$new_language_id.",'Австрия'),
(15, ".$new_language_id.",'Азербайджан'),
(16, ".$new_language_id.",'Багамские острова'),
(17, ".$new_language_id.",'Бахрейн'),
(18, ".$new_language_id.",'Бангладеш'),
(19, ".$new_language_id.",'Барбадос'),
(20, ".$new_language_id.",'Беларусь'),
(21, ".$new_language_id.",'Бельгия'),
(22, ".$new_language_id.",'Белиз'),
(23, ".$new_language_id.",'Бенин'),
(24, ".$new_language_id.",'Бермудские острова'),
(25, ".$new_language_id.",'Бутан'),
(26, ".$new_language_id.",'Боливия'),
(27, ".$new_language_id.",'Босния и Герцеговина'),
(28, ".$new_language_id.",'Ботсвана'),
(29, ".$new_language_id.",'Остров Буве'),
(30, ".$new_language_id.",'Бразилия'),
(31, ".$new_language_id.",'Британская территория Индийского океана'),
(32, ".$new_language_id.",'Бруней-Даруссалам'),
(33, ".$new_language_id.",'Болгария'),
(34, ".$new_language_id.",'Буркина-Фасо'),
(35, ".$new_language_id.",'Бурунди'),
(36, ".$new_language_id.",'Камбоджа'),
(37, ".$new_language_id.",'Камерун'),
(38, ".$new_language_id.",'Канада'),
(39, ".$new_language_id.",'Кабо-Верде'),
(40, ".$new_language_id.",'Каймановы острова'),
(41, ".$new_language_id.",'Центрально-Африканская Республика'),
(42, ".$new_language_id.",'Чад'),
(43, ".$new_language_id.",'Чили'),
(44, ".$new_language_id.",'Китай'),
(45, ".$new_language_id.",'Остров Рождества'),
(46, ".$new_language_id.",'Кокосовые (Килинг) острова'),
(47, ".$new_language_id.",'Колумбия'),
(48, ".$new_language_id.",'Коморские острова'),
(49, ".$new_language_id.",'Конго'),
(50, ".$new_language_id.",'Острова Кука'),
(51, ".$new_language_id.",'Коста-Рика'),
(52, ".$new_language_id.",'Берег Слоновой Кости'),
(53, ".$new_language_id.",'Хорватия'),
(54, ".$new_language_id.",'Куба'),
(55, ".$new_language_id.",'Кипр'),
(56, ".$new_language_id.",'Чешская республика'),
(57, ".$new_language_id.",'Дания'),
(58, ".$new_language_id.",'Джибути'),
(59, ".$new_language_id.",'Доминика'),
(60, ".$new_language_id.",'Доминиканская Республика'),
(61, ".$new_language_id.",'Восточный Тимор'),
(62, ".$new_language_id.",'Эквадор'),
(63, ".$new_language_id.",'Египет'),
(64, ".$new_language_id.",'Сальвадор'),
(65, ".$new_language_id.",'Экваториальная Гвинея'),
(66, ".$new_language_id.",'Эритрея'),
(67, ".$new_language_id.",'Эстония'),
(68, ".$new_language_id.",'Эфиопия'),
(69, ".$new_language_id.",'Фолклендские (Мальвинские) острова'),
(70, ".$new_language_id.",'Фарерские острова'),
(71, ".$new_language_id.",'Фиджи'),
(72, ".$new_language_id.",'Финляндия'),
(73, ".$new_language_id.",'Франция'),
(74, ".$new_language_id.",'Франция, митрополит'),
(75, ".$new_language_id.",'Французская Гвиана'),
(76, ".$new_language_id.",'Французская Полинезия'),
(77, ".$new_language_id.",'Французские южные территории'),
(78, ".$new_language_id.",'Габон'),
(79, ".$new_language_id.",'Гамбия'),
(80, ".$new_language_id.",'Грузия'),
(81, ".$new_language_id.",'Германия'),
(82, ".$new_language_id.",'Гана'),
(83, ".$new_language_id.",'Гибралтар'),
(84, ".$new_language_id.",'Греция'),
(85, ".$new_language_id.",'Гренландия'),
(86, ".$new_language_id.",'Гренада'),
(87, ".$new_language_id.",'Гваделупа'),
(88, ".$new_language_id.",'Гуам'),
(89, ".$new_language_id.",'Гватемала'),
(90, ".$new_language_id.",'Гвинея'),
(91, ".$new_language_id.",'Гвинея-Бисау'),
(92, ".$new_language_id.",'Гайана'),
(93, ".$new_language_id.",'Гаити'),
(94, ".$new_language_id.",'Херд и МакДональд острова'),
(95, ".$new_language_id.",'Гондурас'),
(96, ".$new_language_id.",'Гонконг'),
(97, ".$new_language_id.",'Венгрия'),
(98, ".$new_language_id.",'Исландия'),
(99, ".$new_language_id.",'Индия'),
(100, ".$new_language_id.",'Индонезия'),
(101, ".$new_language_id.",'Иран (Исламская Республика)'),
(102, ".$new_language_id.",'Ирак'),
(103, ".$new_language_id.",'Ирландия'),
(104, ".$new_language_id.",'Израиль'),
(105, ".$new_language_id.",'Италия'),
(106, ".$new_language_id.",'Ямайка'),
(107, ".$new_language_id.",'Япония'),
(108, ".$new_language_id.",'Иордания'),
(109, ".$new_language_id.",'Казахстан'),
(110, ".$new_language_id.",'Кения'),
(111, ".$new_language_id.",'Кирибати'),
(112, ".$new_language_id.",'Северная Корея'),
(113, ".$new_language_id.",'Республика Корея'),
(114, ".$new_language_id.",'Кувейт'),
(115, ".$new_language_id.",'Киргизия'),
(116, ".$new_language_id.",'Лаосская Народно-Демократическая Республика'),
(117, ".$new_language_id.",'Латвия'),
(118, ".$new_language_id.",'Ливан'),
(119, ".$new_language_id.",'Лесото'),
(120, ".$new_language_id.",'Либерия'),
(121, ".$new_language_id.",'Ливийская Арабская Джамахирия'),
(122, ".$new_language_id.",'Лихтенштейн'),
(123, ".$new_language_id.",'Литва'),
(124, ".$new_language_id.",'Люксембург'),
(125, ".$new_language_id.",'Макао'),
(126, ".$new_language_id.",'Македония'),
(127, ".$new_language_id.",'Мадагаскар'),
(128, ".$new_language_id.",'Малави'),
(129, ".$new_language_id.",'Малайзия'),
(130, ".$new_language_id.",'Мальдивы'),
(131, ".$new_language_id.",'Мали'),
(132, ".$new_language_id.",'Мальта'),
(133, ".$new_language_id.",'Маршалловы острова'),
(134, ".$new_language_id.",'Мартиника'),
(135, ".$new_language_id.",'Мавритания'),
(136, ".$new_language_id.",'Маврикий'),
(137, ".$new_language_id.",'Майотта'),
(138, ".$new_language_id.",'Мексика'),
(139, ".$new_language_id.",'Микронезия, Федеративные Штаты'),
(140, ".$new_language_id.",'Молдова'),
(141, ".$new_language_id.",'Монако'),
(142, ".$new_language_id.",'Монголия'),
(143, ".$new_language_id.",'Монтсеррат'),
(144, ".$new_language_id.",'Марокко'),
(145, ".$new_language_id.",'Мозамбик'),
(146, ".$new_language_id.",'Мьянма'),
(147, ".$new_language_id.",'Намибия'),
(148, ".$new_language_id.",'Науру'),
(149, ".$new_language_id.",'Непал'),
(150, ".$new_language_id.",'Нидерланды'),
(151, ".$new_language_id.",'Нидерландские Антильские острова'),
(152, ".$new_language_id.",'Новая Каледония'),
(153, ".$new_language_id.",'Новая Зеландия'),
(154, ".$new_language_id.",'Никарагуа'),
(155, ".$new_language_id.",'Нигер'),
(156, ".$new_language_id.",'Нигерия'),
(157, ".$new_language_id.",'Ниуэ'),
(158, ".$new_language_id.",'Остров Норфолк'),
(159, ".$new_language_id.",'Северные Марианские острова'),
(160, ".$new_language_id.",'Норвегия'),
(161, ".$new_language_id.",'Оман'),
(162, ".$new_language_id.",'Пакистан'),
(163, ".$new_language_id.",'Палау'),
(164, ".$new_language_id.",'Панама'),
(165, ".$new_language_id.",'Папуа-Новая Гвинея'),
(166, ".$new_language_id.",'Парагвай'),
(167, ".$new_language_id.",'Перу'),
(168, ".$new_language_id.",'Филиппины'),
(169, ".$new_language_id.",'Питкэрн'),
(170, ".$new_language_id.",'Польша'),
(171, ".$new_language_id.",'Португалия'),
(172, ".$new_language_id.",'Пуэрто-Рико'),
(173, ".$new_language_id.",'Катар'),
(174, ".$new_language_id.",'Воссоединение'),
(175, ".$new_language_id.",'Румыния'),
(176, ".$new_language_id.",'Россия'),
(177, ".$new_language_id.",'Руанда'),
(178, ".$new_language_id.",'Сент-Китс и Невис'),
(179, ".$new_language_id.",'Сент-Люсия'),
(180, ".$new_language_id.",'Сент-Винсент и Гренадины'),
(181, ".$new_language_id.",'Самоа'),
(182, ".$new_language_id.",'Сан - Марино'),
(183, ".$new_language_id.",'Сан-Томе и Принсипи'),
(184, ".$new_language_id.",'Саудовская Аравия'),
(185, ".$new_language_id.",'Сенегал'),
(186, ".$new_language_id.",'Сейшельские острова'),
(187, ".$new_language_id.",'Сьерра-Леоне'),
(188, ".$new_language_id.",'Сингапур'),
(189, ".$new_language_id.",'Словацкая Республика'),
(190, ".$new_language_id.",'Словения'),
(191, ".$new_language_id.",'Соломоновы Острова'),
(192, ".$new_language_id.",'Сомали'),
(193, ".$new_language_id.",'ЮАР'),
(194, ".$new_language_id.",'Южная Джорджия и Южные Сандвичевы острова'),
(195, ".$new_language_id.",'Испания'),
(196, ".$new_language_id.",'Шри Ланка'),
(197, ".$new_language_id.",'Остров Святой Елены'),
(198, ".$new_language_id.",'Сен-Пьер и Микелон'),
(199, ".$new_language_id.",'Судан'),
(200, ".$new_language_id.",'Суринам'),
(201, ".$new_language_id.",'Шпицберген и Ян-Майен'),
(202, ".$new_language_id.",'Свазиленд'),
(203, ".$new_language_id.",'Швеция'),
(204, ".$new_language_id.",'Швейцария'),
(205, ".$new_language_id.",'Сирийская Арабская Республика'),
(206, ".$new_language_id.",'Тайвань'),
(207, ".$new_language_id.",'Таджикистан'),
(208, ".$new_language_id.",'Танзания, Объединенная Республика'),
(209, ".$new_language_id.",'Таиланд'),
(210, ".$new_language_id.",'Того'),
(211, ".$new_language_id.",'Токелау'),
(212, ".$new_language_id.",'Тонга'),
(213, ".$new_language_id.",'Тринидад и Тобаго'),
(214, ".$new_language_id.",'Тунис'),
(215, ".$new_language_id.",'Турция'),
(216, ".$new_language_id.",'Туркменистан'),
(217, ".$new_language_id.",'Острова Теркс и Кайкос'),
(218, ".$new_language_id.",'Тувалу'),
(219, ".$new_language_id.",'Уганда'),
(220, ".$new_language_id.",'Украина'),
(221, ".$new_language_id.",'Объединенные Арабские Эмираты'),
(222, ".$new_language_id.",'Великобритания'),
(223, ".$new_language_id.",'США'),
(224, ".$new_language_id.",'Соединенные Штаты Америки Внешние малые острова'),
(225, ".$new_language_id.",'Уругвай'),
(226, ".$new_language_id.",'Узбекистан'),
(227, ".$new_language_id.",'Вануату'),
(228, ".$new_language_id.",'Город-государство Ватикан (Святейший Престол)'),
(229, ".$new_language_id.",'Венесуэла'),
(230, ".$new_language_id.",'Вьетнам'),
(231, ".$new_language_id.",'Виргинские острова (Британские)'),
(232, ".$new_language_id.",'Виргинские острова (США)'),
(233, ".$new_language_id.",'Острова Уоллис и Футуна'),
(234, ".$new_language_id.",'Западная Сахара'),
(235, ".$new_language_id.",'Йемен'),
(236, ".$new_language_id.",'Югославия'),
(237, ".$new_language_id.",'Заир'),
(238, ".$new_language_id.",'Замбия'),
(239, ".$new_language_id.",'Зимбабве'),
(240, ".$new_language_id.",'Северная Ирландия');
");

$this->db->query("INSERT INTO ".$this->db->table('zone_descriptions')."
(`zone_id`,`language_id`, `name`) VALUES
(1, ".$new_language_id.",'Бадахшанской'),
(2, ".$new_language_id.",'Бадгис'),
(3, ".$new_language_id.",'Баглан'),
(4, ".$new_language_id.",'Балх'),
(5, ".$new_language_id.",'Бамиан'),
(6, ".$new_language_id.",'Фарах'),
(7, ".$new_language_id.",'Фарьяб'),
(8, ".$new_language_id.",'Газни'),
(9, ".$new_language_id.",'Ghowr'),
(10, ".$new_language_id.",'Гильменд'),
(11, ".$new_language_id.",'Герат'),
(12, ".$new_language_id.",'Джаузджан'),
(13, ".$new_language_id.",'Кабул'),
(14, ".$new_language_id.",'Кандагар'),
(15, ".$new_language_id.",'Каписа'),
(16, ".$new_language_id.",'Хост'),
(17, ".$new_language_id.",'Конар'),
(18, ".$new_language_id.",'Kondoz'),
(19, ".$new_language_id.",'Лагман'),
(20, ".$new_language_id.",'Логар'),
(21, ".$new_language_id.",'Nangrahar'),
(22, ".$new_language_id.",'Нимруз'),
(23, ".$new_language_id.",'Нуристан'),
(24, ".$new_language_id.",'Oruzgan'),
(25, ".$new_language_id.",'Пактия'),
(26, ".$new_language_id.",'Пактика'),
(27, ".$new_language_id.",'Парван'),
(28, ".$new_language_id.",'Саманган'),
(29, ".$new_language_id.",'Сари-Пуль'),
(30, ".$new_language_id.",'Тахар'),
(31, ".$new_language_id.",'Вардак'),
(32, ".$new_language_id.",'Zabol'),
(33, ".$new_language_id.",'Берат'),
(34, ".$new_language_id.",'Bulqizë'),
(35, ".$new_language_id.",'Delvine'),
(36, ".$new_language_id.",'Девол'),
(37, ".$new_language_id.",'Дибра'),
(38, ".$new_language_id.",'Дуррес'),
(39, ".$new_language_id.",'Эльбасан'),
(40, ".$new_language_id.",'Kolonje'),
(41, ".$new_language_id.",'Фиер'),
(42, ".$new_language_id.",'Gjirokaster'),
(43, ".$new_language_id.",'Gramsh'),
(44, ".$new_language_id.",'Имеет'),
(45, ".$new_language_id.",'Kavaje'),
(46, ".$new_language_id.",'Kurbin'),
(47, ".$new_language_id.",'Кучова'),
(48, ".$new_language_id.",'Корча'),
(49, ".$new_language_id.",'Kruje'),
(50, ".$new_language_id.",'Кукес'),
(51, ".$new_language_id.",'Librazhd'),
(52, ".$new_language_id.",'Лежа'),
(53, ".$new_language_id.",'Люшня'),
(54, ".$new_language_id.",'У самцов е Madhe'),
(55, ".$new_language_id.",'Mallakaster'),
(56, ".$new_language_id.",'Коврик'),
(57, ".$new_language_id.",'Мирдита'),
(58, ".$new_language_id.",'Peqin'),
(59, ".$new_language_id.",'Permet'),
(60, ".$new_language_id.",'Поградец'),
(61, ".$new_language_id.",'Рвать'),
(62, ".$new_language_id.",'Шкодер'),
(63, ".$new_language_id.",'Skrapar'),
(64, ".$new_language_id.",'Саранда'),
(65, ".$new_language_id.",'Tepelenë'),
(66, ".$new_language_id.",'Тропое'),
(67, ".$new_language_id.",'Тирана'),
(68, ".$new_language_id.",'Влера'),
(69, ".$new_language_id.",'Адрар'),
(70, ".$new_language_id.",'Аян-Дафлах'),
(71, ".$new_language_id.",'Тамушанат'),
(72, ".$new_language_id.",'Алжир'),
(73, ".$new_language_id.",'Аннаба'),
(74, ".$new_language_id.",'Батна'),
(75, ".$new_language_id.",'Бешар'),
(76, ".$new_language_id.",'Беджаия'),
(77, ".$new_language_id.",'Бискра'),
(78, ".$new_language_id.",'Блида'),
(79, ".$new_language_id.",'Бордж Боу Арреридж'),
(80, ".$new_language_id.",'Bouira'),
(81, ".$new_language_id.",'Бумердес'),
(82, ".$new_language_id.",'Шлеф'),
(83, ".$new_language_id.",'Константин'),
(84, ".$new_language_id.",'Джельфа'),
(85, ".$new_language_id.",'El Bayadh'),
(86, ".$new_language_id.",'Эль-Уэд'),
(87, ".$new_language_id.",'Эль-Тарф'),
(88, ".$new_language_id.",'Ghardaia'),
(89, ".$new_language_id.",'Гельма'),
(90, ".$new_language_id.",'Иллизи'),
(91, ".$new_language_id.",'Джиджель'),
(92, ".$new_language_id.",'Khenchela'),
(93, ".$new_language_id.",'Лагуат'),
(94, ".$new_language_id.",'Muaskar'),
(95, ".$new_language_id.",'Медея'),
(96, ".$new_language_id.",'Мила'),
(97, ".$new_language_id.",'Мостаганем'),
(98, ".$new_language_id.",'Мсила'),
(99, ".$new_language_id.",'Наама'),
(100, ".$new_language_id.",'Оран'),
(101, ".$new_language_id.",'Уаргла'),
(102, ".$new_language_id.",'Ум-Эль-Буахи'),
(103, ".$new_language_id.",'Релизан'),
(104, ".$new_language_id.",'Саида'),
(105, ".$new_language_id.",'Сетиф'),
(106, ".$new_language_id.",'Сиди-Бель-Аббес'),
(107, ".$new_language_id.",'Скикда'),
(108, ".$new_language_id.",'Сук Ахраш'),
(109, ".$new_language_id.",'Таманрассет'),
(110, ".$new_language_id.",'Тибесса'),
(111, ".$new_language_id.",'Тиарет'),
(112, ".$new_language_id.",'Tindouf'),
(113, ".$new_language_id.",'Tipaza'),
(114, ".$new_language_id.",'Тисамсил'),
(115, ".$new_language_id.",'Тизи-Узу'),
(116, ".$new_language_id.",'Тлемсен'),
(117, ".$new_language_id.",'Восточный'),
(118, ".$new_language_id.",'Manu&#39;a'),
(119, ".$new_language_id.",'Роуз-Айленд'),
(120, ".$new_language_id.",'Остров Суэйнс'),
(121, ".$new_language_id.",'Западный'),
(122, ".$new_language_id.",'Андорра-ла-Велья'),
(123, ".$new_language_id.",'Канильо'),
(124, ".$new_language_id.",'Располагаться'),
(125, ".$new_language_id.",'Лес Эскальдес'),
(126, ".$new_language_id.",'Ла-Массана'),
(127, ".$new_language_id.",'Ордино'),
(128, ".$new_language_id.",'Сант-Жулия-де-Лория'),
(129, ".$new_language_id.",'Бенго'),
(130, ".$new_language_id.",'Бенгела'),
(131, ".$new_language_id.",'Бие'),
(132, ".$new_language_id.",'Кабинда'),
(133, ".$new_language_id.",'Квандо-Кубанго'),
(134, ".$new_language_id.",'Северная Кванза'),
(135, ".$new_language_id.",'Южная Кванза'),
(136, ".$new_language_id.",'Кунене'),
(137, ".$new_language_id.",'Уамбо'),
(138, ".$new_language_id.",'Уила'),
(139, ".$new_language_id.",'Луанда'),
(140, ".$new_language_id.",'Северная Лунда'),
(141, ".$new_language_id.",'Южная Лунда'),
(142, ".$new_language_id.",'Malange'),
(143, ".$new_language_id.",'Мошико'),
(144, ".$new_language_id.",'Намиб'),
(145, ".$new_language_id.",'Uige'),
(146, ".$new_language_id.",'Заир'),
(147, ".$new_language_id.",'Святой Георгий'),
(148, ".$new_language_id.",'Святой Иоанн'),
(149, ".$new_language_id.",'Святой Марии'),
(150, ".$new_language_id.",'Сент-Пол'),
(151, ".$new_language_id.",'Святой Петр'),
(152, ".$new_language_id.",'Святой Филипп'),
(153, ".$new_language_id.",'Барбуда'),
(154, ".$new_language_id.",'Редонда'),
(155, ".$new_language_id.",'Antartida е Ислас-дель-Atlantico'),
(156, ".$new_language_id.",'Буэнос-Айрес'),
(157, ".$new_language_id.",'Катамарка'),
(158, ".$new_language_id.",'Чако'),
(159, ".$new_language_id.",'Чубут'),
(160, ".$new_language_id.",'Кордова'),
(161, ".$new_language_id.",'Корриентес'),
(162, ".$new_language_id.",'Федеральный округ'),
(163, ".$new_language_id.",'Междуречье'),
(164, ".$new_language_id.",'Тайвань'),
(165, ".$new_language_id.",'Жужуй'),
(166, ".$new_language_id.",'Ла-Пампа'),
(167, ".$new_language_id.",'Ла-Риоха'),
(168, ".$new_language_id.",'Мендоса'),
(169, ".$new_language_id.",'Мисьонес'),
(170, ".$new_language_id.",'Неукен'),
(171, ".$new_language_id.",'Рио-Негро'),
(172, ".$new_language_id.",'Сальта'),
(173, ".$new_language_id.",'Сан - Хуан'),
(174, ".$new_language_id.",'Сан - Луис'),
(175, ".$new_language_id.",'Санта-Крус-'),
(176, ".$new_language_id.",'Санта-Фе'),
(177, ".$new_language_id.",'Сантьяго-дель-Эстеро'),
(178, ".$new_language_id.",'Огненная Земля'),
(179, ".$new_language_id.",'Тукуман'),
(180, ".$new_language_id.",'Арагацотн'),
(181, ".$new_language_id.",'Арарат'),
(182, ".$new_language_id.",'Армавир'),
(183, ".$new_language_id.",'Geghark&#39;unik &#39;'),
(184, ".$new_language_id.",'Котайк &quot;'),
(185, ".$new_language_id.",'Лорри'),
(186, ".$new_language_id.",'Ширак'),
(187, ".$new_language_id.",'Сюник &#39;'),
(188, ".$new_language_id.",'Тавуш'),
(189, ".$new_language_id.",'Vayots &#39;Дзор'),
(190, ".$new_language_id.",'Ереван'),
(191, ".$new_language_id.",'Австралийская столичная территория'),
(192, ".$new_language_id.",'Новый Южный Уэльс'),
(193, ".$new_language_id.",'Северная территория'),
(194, ".$new_language_id.",'Квинсленд'),
(195, ".$new_language_id.",'Южная Австралия'),
(196, ".$new_language_id.",'Тасмания'),
(197, ".$new_language_id.",'Виктория'),
(198, ".$new_language_id.",'Западная Австралия'),
(199, ".$new_language_id.",'Бургенланд'),
(200, ".$new_language_id.",'Кернтен'),
(201, ".$new_language_id.",'Niederösterreich'),
(202, ".$new_language_id.",'Oberösterreich'),
(203, ".$new_language_id.",'Зальцбург'),
(204, ".$new_language_id.",'Штирия'),
(205, ".$new_language_id.",'Тироль'),
(206, ".$new_language_id.",'Форарльберг'),
(207, ".$new_language_id.",'Вена'),
(208, ".$new_language_id.",'Али-Байрамлы'),
(209, ".$new_language_id.",'Abseron'),
(210, ".$new_language_id.",'Агджабеди'),
(211, ".$new_language_id.",'Агдам'),
(212, ".$new_language_id.",'Agdas'),
(213, ".$new_language_id.",'Агстафа'),
(214, ".$new_language_id.",'Агсу'),
(215, ".$new_language_id.",'Астара'),
(216, ".$new_language_id.",'Baki'),
(217, ".$new_language_id.",'Бабак'),
(218, ".$new_language_id.",'Балакен'),
(219, ".$new_language_id.",'Барда'),
(220, ".$new_language_id.",'Beylaqan'),
(221, ".$new_language_id.",'Билясувар'),
(222, ".$new_language_id.",'Джабраил'),
(223, ".$new_language_id.",'Calilabab'),
(224, ".$new_language_id.",'Culfa'),
(225, ".$new_language_id.",'Daskasan'),
(226, ".$new_language_id.",'Davaci'),
(227, ".$new_language_id.",'Физули'),
(228, ".$new_language_id.",'Гянджа'),
(229, ".$new_language_id.",'Gadabay'),
(230, ".$new_language_id.",'Геранбойского'),
(231, ".$new_language_id.",'Goycay'),
(232, ".$new_language_id.",'Haciqabul'),
(233, ".$new_language_id.",'Imisli'),
(234, ".$new_language_id.",'Исмаиллы'),
(235, ".$new_language_id.",'Кяльбаджара'),
(236, ".$new_language_id.",'Кюрдамир'),
(237, ".$new_language_id.",'Ленкорань'),
(238, ".$new_language_id.",'Lacin'),
(239, ".$new_language_id.",'Ленкорань'),
(240, ".$new_language_id.",'Лерик'),
(241, ".$new_language_id.",'Масаллы'),
(242, ".$new_language_id.",'Мингячевире'),
(243, ".$new_language_id.",'Нафталан'),
(244, ".$new_language_id.",'Neftcala'),
(245, ".$new_language_id.",'Огуз'),
(246, ".$new_language_id.",'Ордубад'),
(247, ".$new_language_id.",'Габала'),
(248, ".$new_language_id.",'Qax'),
(249, ".$new_language_id.",'Казах'),
(250, ".$new_language_id.",'Гобустан'),
(251, ".$new_language_id.",'Губа'),
(252, ".$new_language_id.",'Губадлы'),
(253, ".$new_language_id.",'Гусар'),
(254, ".$new_language_id.",'Саки'),
(255, ".$new_language_id.",'Саатлы'),
(256, ".$new_language_id.",'Сабирабад'),
(257, ".$new_language_id.",'Садарак'),
(258, ".$new_language_id.",'Sahbuz'),
(259, ".$new_language_id.",'Саки'),
(260, ".$new_language_id.",'Сальян'),
(261, ".$new_language_id.",'Сумгаит'),
(262, ".$new_language_id.",'Şamaxı'),
(263, ".$new_language_id.",'Шамкирском'),
(264, ".$new_language_id.",'Samux'),
(265, ".$new_language_id.",'Сарур'),
(266, ".$new_language_id.",'Сиазань'),
(267, ".$new_language_id.",'Суза'),
(268, ".$new_language_id.",'Суза'),
(269, ".$new_language_id.",'Татарский'),
(270, ".$new_language_id.",'Товуз'),
(271, ".$new_language_id.",'Ucar'),
(272, ".$new_language_id.",'Ханкенди'),
(273, ".$new_language_id.",'Хачмаз'),
(274, ".$new_language_id.",'Ханлар'),
(275, ".$new_language_id.",'Хызы'),
(276, ".$new_language_id.",'Ходжалы'),
(277, ".$new_language_id.",'Xocavand'),
(278, ".$new_language_id.",'Ярдымлы'),
(279, ".$new_language_id.",'Евлах'),
(280, ".$new_language_id.",'Зангиланский'),
(281, ".$new_language_id.",'Загатала'),
(282, ".$new_language_id.",'Зардабский'),
(283, ".$new_language_id.",'Нахчыван'),
(284, ".$new_language_id.",'Acklins'),
(285, ".$new_language_id.",'Острова Берри'),
(286, ".$new_language_id.",'Бимини'),
(287, ".$new_language_id.",'Black Point'),
(288, ".$new_language_id.",'Остров Кэт'),
(289, ".$new_language_id.",'Центральный Абако'),
(290, ".$new_language_id.",'Центральный Андрос'),
(291, ".$new_language_id.",'Центральный Эльютера'),
(292, ".$new_language_id.",'Город Фрипорт'),
(293, ".$new_language_id.",'Кривой Остров'),
(294, ".$new_language_id.",'Ист-Гранд-Багама'),
(295, ".$new_language_id.",'Эксума'),
(296, ".$new_language_id.",'Гранд-Кей'),
(297, ".$new_language_id.",'Харбор-Айленд'),
(298, ".$new_language_id.",'Надеюсь, город'),
(299, ".$new_language_id.",'Инагуа'),
(300, ".$new_language_id.",'Лонг-Айленд'),
(301, ".$new_language_id.",'Mangrove Cay'),
(302, ".$new_language_id.",'Mayaguana'),
(303, ".$new_language_id.",'Остров Мура'),
(304, ".$new_language_id.",'Северный Абако'),
(305, ".$new_language_id.",'Северная Андрос'),
(306, ".$new_language_id.",'Северная Эльютера'),
(307, ".$new_language_id.",'Рваные Остров'),
(308, ".$new_language_id.",'Рам-Ки'),
(309, ".$new_language_id.",'Сан - Сальвадор'),
(310, ".$new_language_id.",'Южная Абако'),
(311, ".$new_language_id.",'Южная Андрос'),
(312, ".$new_language_id.",'Южная Эльютера'),
(313, ".$new_language_id.",'Испанский Уэллс'),
(314, ".$new_language_id.",'Запад Гранд Багама'),
(315, ".$new_language_id.",'Капитал'),
(316, ".$new_language_id.",'Центральный'),
(317, ".$new_language_id.",'Мухаррак'),
(318, ".$new_language_id.",'Северный'),
(319, ".$new_language_id.",'Южный'),
(320, ".$new_language_id.",'Barisal'),
(321, ".$new_language_id.",'Читтагонг'),
(322, ".$new_language_id.",'Дакка'),
(323, ".$new_language_id.",'Кхулна'),
(324, ".$new_language_id.",'Раджшахи'),
(325, ".$new_language_id.",'Силхет'),
(326, ".$new_language_id.",'Церковь Христа'),
(327, ".$new_language_id.",'Святой Андрей'),
(328, ".$new_language_id.",'Святой Георгий'),
(329, ".$new_language_id.",'Сент-Джеймс'),
(330, ".$new_language_id.",'Святой Иоанн'),
(331, ".$new_language_id.",'Сент-Джозеф'),
(332, ".$new_language_id.",'Saint Lucy'),
(333, ".$new_language_id.",'Святой Михаил'),
(334, ".$new_language_id.",'Святой Петр'),
(335, ".$new_language_id.",'Святой Филипп'),
(336, ".$new_language_id.",'Сент-Томас'),
(337, ".$new_language_id.",'Брестская (Брест)'),
(338, ".$new_language_id.",'Homyel&#39;skaya (Гомель)'),
(339, ".$new_language_id.",'Горад Минск'),
(340, ".$new_language_id.",'Hrodzyenskaya (Гродно)'),
(341, ".$new_language_id.",'Могилевская (Могилев)'),
(342, ".$new_language_id.",'Минская'),
(343, ".$new_language_id.",'Vitsyebskaya (Витебск)'),
(344, ".$new_language_id.",'Антверпен'),
(345, ".$new_language_id.",'Валлонский Брабант'),
(346, ".$new_language_id.",'Эно'),
(347, ".$new_language_id.",'Сеньор'),
(348, ".$new_language_id.",'Лимбург'),
(349, ".$new_language_id.",'Люксембург'),
(350, ".$new_language_id.",'Намюр'),
(351, ".$new_language_id.",'Восточная Фландрия'),
(352, ".$new_language_id.",'Фламандский Брабант'),
(353, ".$new_language_id.",'West-Vlaanderen'),
(354, ".$new_language_id.",'Белиз'),
(355, ".$new_language_id.",'Кайо'),
(356, ".$new_language_id.",'Коросаль'),
(357, ".$new_language_id.",'Orange Walk'),
(358, ".$new_language_id.",'Крик'),
(359, ".$new_language_id.",'Толедо'),
(360, ".$new_language_id.",'Алибори'),
(361, ".$new_language_id.",'Атакора'),
(362, ".$new_language_id.",'Атлантическая'),
(363, ".$new_language_id.",'Боргу'),
(364, ".$new_language_id.",'Коллинз'),
(365, ".$new_language_id.",'Ущелье'),
(366, ".$new_language_id.",'Куффо'),
(367, ".$new_language_id.",'Побережье'),
(368, ".$new_language_id.",'Моно'),
(369, ".$new_language_id.",'Квем'),
(370, ".$new_language_id.",'Плато'),
(371, ".$new_language_id.",'Цзоу'),
(372, ".$new_language_id.",'Девоншир'),
(373, ".$new_language_id.",'Гамильтон Город'),
(374, ".$new_language_id.",'Гамильтон'),
(375, ".$new_language_id.",'Педжет'),
(376, ".$new_language_id.",'Пембрук'),
(377, ".$new_language_id.",'Святой Георгий Город'),
(378, ".$new_language_id.",'Сент-Джорджес'),
(379, ".$new_language_id.",'Сэндис'),
(380, ".$new_language_id.",'Смит'),
(381, ".$new_language_id.",'Саутгемптон'),
(382, ".$new_language_id.",'Warwick'),
(383, ".$new_language_id.",'Бумтанг'),
(384, ".$new_language_id.",'Chukha'),
(385, ".$new_language_id.",'Дагана'),
(386, ".$new_language_id.",'Gasa'),
(387, ".$new_language_id.",'Хаа'),
(388, ".$new_language_id.",'Lhuntse'),
(389, ".$new_language_id.",'Монгар'),
(390, ".$new_language_id.",'Паро'),
(391, ".$new_language_id.",'Pemagatshel'),
(392, ".$new_language_id.",'Пунакха'),
(393, ".$new_language_id.",'Самдруп Jongkhar'),
(394, ".$new_language_id.",'Самце'),
(395, ".$new_language_id.",'Сарпанг'),
(396, ".$new_language_id.",'Тхимпху'),
(397, ".$new_language_id.",'Trashigang'),
(398, ".$new_language_id.",'Trashiyangste'),
(399, ".$new_language_id.",'Тронгса'),
(400, ".$new_language_id.",'Циранг'),
(401, ".$new_language_id.",'Wangdue Пходранг'),
(402, ".$new_language_id.",'Zhemgang'),
(403, ".$new_language_id.",'Бени'),
(404, ".$new_language_id.",'Чукисака'),
(405, ".$new_language_id.",'Кочабамба'),
(406, ".$new_language_id.",'Ла-Пас'),
(407, ".$new_language_id.",'Оруро'),
(408, ".$new_language_id.",'Пандо'),
(409, ".$new_language_id.",'Потоси'),
(410, ".$new_language_id.",'Санта-Крус-'),
(411, ".$new_language_id.",'Тариха'),
(412, ".$new_language_id.",'Брчко'),
(413, ".$new_language_id.",'Unsko-Санский Кантон'),
(414, ".$new_language_id.",'Posavski Кантон'),
(415, ".$new_language_id.",'Tuzlanski Кантон'),
(416, ".$new_language_id.",'Zeničko-Dobojski Кантон'),
(417, ".$new_language_id.",'Bosanskopodrinjski Кантон'),
(418, ".$new_language_id.",'Srednjebosanski Кантон'),
(419, ".$new_language_id.",'Hercegovacko-neretvanski Кантон'),
(420, ".$new_language_id.",'Zapadnohercegovacka Županija'),
(421, ".$new_language_id.",'Кантон Сараево'),
(422, ".$new_language_id.",'Zapadnobosanska'),
(423, ".$new_language_id.",'Баня-Лука'),
(424, ".$new_language_id.",'Добое'),
(425, ".$new_language_id.",'Bijeljina'),
(426, ".$new_language_id.",'Власеница'),
(427, ".$new_language_id.",'Сараево-Romanija или Соколац'),
(428, ".$new_language_id.",'Фока'),
(429, ".$new_language_id.",'Требине'),
(430, ".$new_language_id.",'Центральный'),
(431, ".$new_language_id.",'Ghanzi'),
(432, ".$new_language_id.",'Кгалагади'),
(433, ".$new_language_id.",'Кгатленг'),
(434, ".$new_language_id.",'Kweneng'),
(435, ".$new_language_id.",'Ngamiland'),
(436, ".$new_language_id.",'Северо-восток'),
(437, ".$new_language_id.",'Северо-Запад'),
(438, ".$new_language_id.",'Юго-Восточная'),
(439, ".$new_language_id.",'Южный'),
(440, ".$new_language_id.",'Акр'),
(441, ".$new_language_id.",'Алагоас'),
(442, ".$new_language_id.",'Amapa'),
(443, ".$new_language_id.",'Amazonas'),
(444, ".$new_language_id.",'Bahia'),
(445, ".$new_language_id.",'Сеара'),
(446, ".$new_language_id.",'Федеральный округ'),
(447, ".$new_language_id.",'Эспириту-Санту'),
(448, ".$new_language_id.",'Гояс'),
(449, ".$new_language_id.",'Мараньян'),
(450, ".$new_language_id.",'Мату-Гросу'),
(451, ".$new_language_id.",'Мату-Гросу-ду-Сул'),
(452, ".$new_language_id.",'Минас-Жерайс'),
(453, ".$new_language_id.",'Para'),
(454, ".$new_language_id.",'Параиба'),
(455, ".$new_language_id.",'Парана'),
(456, ".$new_language_id.",'Пернамбуку'),
(457, ".$new_language_id.",'Пиауи'),
(458, ".$new_language_id.",'Рио-де-Жанейро'),
(459, ".$new_language_id.",'Рио-Гранде-ду-Норти'),
(460, ".$new_language_id.",'Рио-Гранде-ду-Сул'),
(461, ".$new_language_id.",'Rondonia'),
(462, ".$new_language_id.",'Рорайма'),
(463, ".$new_language_id.",'Санта-Катарина'),
(464, ".$new_language_id.",'Сан-Паулу'),
(465, ".$new_language_id.",'Сержипи'),
(466, ".$new_language_id.",'Токантинс'),
(467, ".$new_language_id.",'Перос Banhos'),
(468, ".$new_language_id.",'Salomon острова'),
(469, ".$new_language_id.",'Нельсон Остров'),
(470, ".$new_language_id.",'Три брата'),
(471, ".$new_language_id.",'Eagle острова'),
(472, ".$new_language_id.",'Опасность Остров'),
(473, ".$new_language_id.",'Эгмонт острова'),
(474, ".$new_language_id.",'Диего-Гарсия'),
(475, ".$new_language_id.",'Белайт'),
(476, ".$new_language_id.",'Бруней и Muara'),
(477, ".$new_language_id.",'Temburong'),
(478, ".$new_language_id.",'Тутонг'),
(479, ".$new_language_id.",'Благоевград'),
(480, ".$new_language_id.",'Бургас'),
(481, ".$new_language_id.",'Добрич'),
(482, ".$new_language_id.",'Габрово'),
(483, ".$new_language_id.",'Хасково'),
(484, ".$new_language_id.",'Кырджали'),
(485, ".$new_language_id.",'Кюстендил'),
(486, ".$new_language_id.",'Ловеч'),
(487, ".$new_language_id.",'Монтана'),
(488, ".$new_language_id.",'Пазарджик'),
(489, ".$new_language_id.",'Перник'),
(490, ".$new_language_id.",'Плевен'),
(491, ".$new_language_id.",'Пловдив'),
(492, ".$new_language_id.",'Разград'),
(493, ".$new_language_id.",'Шумен'),
(494, ".$new_language_id.",'Силистра'),
(495, ".$new_language_id.",'Сливен'),
(496, ".$new_language_id.",'Смолян'),
(497, ".$new_language_id.",'София'),
(498, ".$new_language_id.",'София - город'),
(499, ".$new_language_id.",'Стара Загора'),
(500, ".$new_language_id.",'Тырговиште'),
(501, ".$new_language_id.",'Варна'),
(502, ".$new_language_id.",'Велико Тырново'),
(503, ".$new_language_id.",'Видин'),
(504, ".$new_language_id.",'Враца'),
(505, ".$new_language_id.",'Ямбол'),
(506, ".$new_language_id.",'Тюк'),
(507, ".$new_language_id.",'Бам'),
(508, ".$new_language_id.",'Banwa'),
(509, ".$new_language_id.",'Bazega'),
(510, ".$new_language_id.",'Bougouriba'),
(511, ".$new_language_id.",'Boulgou'),
(512, ".$new_language_id.",'Boulkiemde'),
(513, ".$new_language_id.",'Comoe'),
(514, ".$new_language_id.",'Ganzourgou'),
(515, ".$new_language_id.",'Gnagna'),
(516, ".$new_language_id.",'Гурма'),
(517, ".$new_language_id.",'Houet'),
(518, ".$new_language_id.",'Йоба'),
(519, ".$new_language_id.",'Kadiogo'),
(520, ".$new_language_id.",'Kenedougou'),
(521, ".$new_language_id.",'Komondjari'),
(522, ".$new_language_id.",'Kompienga'),
(523, ".$new_language_id.",'Kossi'),
(524, ".$new_language_id.",'Koulpelogo'),
(525, ".$new_language_id.",'Kouritenga'),
(526, ".$new_language_id.",'Kourweogo'),
(527, ".$new_language_id.",'Leraba'),
(528, ".$new_language_id.",'Loroum'),
(529, ".$new_language_id.",'Мухун'),
(530, ".$new_language_id.",'Nahouri'),
(531, ".$new_language_id.",'Namentenga'),
(532, ".$new_language_id.",'Nayala'),
(533, ".$new_language_id.",'Noumbiel'),
(534, ".$new_language_id.",'Убритенга'),
(535, ".$new_language_id.",'Oudalan'),
(536, ".$new_language_id.",'Passore'),
(537, ".$new_language_id.",'Пони'),
(538, ".$new_language_id.",'Sanguie'),
(539, ".$new_language_id.",'Sanmatenga'),
(540, ".$new_language_id.",'Сено'),
(541, ".$new_language_id.",'Сиссили'),
(542, ".$new_language_id.",'Сум'),
(543, ".$new_language_id.",'Sourou'),
(544, ".$new_language_id.",'Тапоа'),
(545, ".$new_language_id.",'Туй'),
(546, ".$new_language_id.",'Yagha'),
(547, ".$new_language_id.",'Ятенга'),
(548, ".$new_language_id.",'Зиро'),
(549, ".$new_language_id.",'Zondoma'),
(550, ".$new_language_id.",'Zoundweogo'),
(551, ".$new_language_id.",'Бубанза'),
(552, ".$new_language_id.",'Бужумбура'),
(553, ".$new_language_id.",'Бурури'),
(554, ".$new_language_id.",'Канкузо'),
(555, ".$new_language_id.",'Кибитоке'),
(556, ".$new_language_id.",'Гитеге'),
(557, ".$new_language_id.",'Карузи'),
(558, ".$new_language_id.",'Каянза'),
(559, ".$new_language_id.",'Кирундо'),
(560, ".$new_language_id.",'Макамба'),
(561, ".$new_language_id.",'Мурамвья'),
(562, ".$new_language_id.",'Муйинга'),
(563, ".$new_language_id.",'Мваро'),
(564, ".$new_language_id.",'Нгози'),
(565, ".$new_language_id.",'Рутана'),
(566, ".$new_language_id.",'Руйиги'),
(567, ".$new_language_id.",'Пномпень'),
(568, ".$new_language_id.",'Преах Seihanu (Кампонгсаом или Сиануквиль)'),
(569, ".$new_language_id.",'Пайлин'),
(570, ".$new_language_id.",'Keb'),
(571, ".$new_language_id.",'Бантеаймеанчей'),
(572, ".$new_language_id.",'Баттамбанг'),
(573, ".$new_language_id.",'Кампонгтям'),
(574, ".$new_language_id.",'Кампонгчнанг'),
(575, ".$new_language_id.",'Кампонгспы'),
(576, ".$new_language_id.",'Кампонг Сом'),
(577, ".$new_language_id.",'Кампонгтхом'),
(578, ".$new_language_id.",'Кампот'),
(579, ".$new_language_id.",'Кандаль'),
(580, ".$new_language_id.",'Kaoh Kong'),
(581, ".$new_language_id.",'Кратьэх'),
(582, ".$new_language_id.",'Mondul Кири'),
(583, ".$new_language_id.",'Оддар Meancheay'),
(584, ".$new_language_id.",'Поусат'),
(585, ".$new_language_id.",'Прэахвихеа'),
(586, ".$new_language_id.",'Прейвэнг'),
(587, ".$new_language_id.",'Ratanak Кири'),
(588, ".$new_language_id.",'Siemreap'),
(589, ".$new_language_id.",'Стынгтраенг'),
(590, ".$new_language_id.",'Свайриенг'),
(591, ".$new_language_id.",'Такео'),
(592, ".$new_language_id.",'Адамава (Адамава)'),
(593, ".$new_language_id.",'Центр'),
(594, ".$new_language_id.",'Восток (Est)'),
(595, ".$new_language_id.",'Крайний Север (Крайний Север)'),
(596, ".$new_language_id.",'Побережье'),
(597, ".$new_language_id.",'Север (Nord)'),
(598, ".$new_language_id.",'Северо-Западный (Nord-Ouest)'),
(599, ".$new_language_id.",'Запад (Ouest)'),
(600, ".$new_language_id.",'Южная (Sud)'),
(601, ".$new_language_id.",'Юго-запад (Юго-Западная).'),
(602, ".$new_language_id.",'Альберта'),
(603, ".$new_language_id.",'Британская Колумбия'),
(604, ".$new_language_id.",'Манитоба'),
(605, ".$new_language_id.",'Нью-Брансуик'),
(606, ".$new_language_id.",'Ньюфаундленд и Лабрадор'),
(607, ".$new_language_id.",'Северо-западные территории'),
(608, ".$new_language_id.",'Новая Шотландия'),
(609, ".$new_language_id.",'Нунавут'),
(610, ".$new_language_id.",'Онтарио'),
(611, ".$new_language_id.",'Остров Принца Эдуарда'),
(612, ".$new_language_id.",'Квебек'),
(613, ".$new_language_id.",'Саскачеван'),
(614, ".$new_language_id.",'Юкон'),
(615, ".$new_language_id.",'Боа-Виста'),
(616, ".$new_language_id.",'Брава'),
(617, ".$new_language_id.",'Кальета-де-Сан-Мигель'),
(618, ".$new_language_id.",'Майо'),
(619, ".$new_language_id.",'Mosteiros'),
(620, ".$new_language_id.",'Пол'),
(621, ".$new_language_id.",'Порто-Ново'),
(622, ".$new_language_id.",'Praia'),
(623, ".$new_language_id.",'Рибейра-Гранде'),
(624, ".$new_language_id.",'Сэл'),
(625, ".$new_language_id.",'Санта-Катарина'),
(626, ".$new_language_id.",'Санта-Крус-'),
(627, ".$new_language_id.",'Сан-Домингуш'),
(628, ".$new_language_id.",'Сан-Филипе'),
(629, ".$new_language_id.",'Сан-Николау'),
(630, ".$new_language_id.",'Сан-Висенте'),
(631, ".$new_language_id.",'Таррафал'),
(632, ".$new_language_id.",'Ручей'),
(633, ".$new_language_id.",'Восточный'),
(634, ".$new_language_id.",'Удаленный от моря'),
(635, ".$new_language_id.",'Южная Город'),
(636, ".$new_language_id.",'Спот-Бей'),
(637, ".$new_language_id.",'Ставка Bay'),
(638, ".$new_language_id.",'Уэст-Энд'),
(639, ".$new_language_id.",'Западный'),
(640, ".$new_language_id.",'Bamingui-Бангоран'),
(641, ".$new_language_id.",'Бас-Котто'),
(642, ".$new_language_id.",'Верхнее Котто'),
(643, ".$new_language_id.",'Haut-Mbomou'),
(644, ".$new_language_id.",'Kemo'),
(645, ".$new_language_id.",'Lobaye'),
(646, ".$new_language_id.",'Мамбере-KadeÔ'),
(647, ".$new_language_id.",'Mbomou'),
(648, ".$new_language_id.",'Нана-Мамбере'),
(649, ".$new_language_id.",'Омбелла-Мпоко'),
(650, ".$new_language_id.",'Ouaka'),
(651, ".$new_language_id.",'Уам'),
(652, ".$new_language_id.",'Уам-Пенде'),
(653, ".$new_language_id.",'Вакага'),
(654, ".$new_language_id.",'Нана-Гребизи'),
(655, ".$new_language_id.",'Сангха-Mbaere'),
(656, ".$new_language_id.",'Банги'),
(657, ".$new_language_id.",'Бата'),
(658, ".$new_language_id.",'Biltine'),
(659, ".$new_language_id.",'Борку-Эннеди-Тибести'),
(660, ".$new_language_id.",'Шари-Багирми'),
(661, ".$new_language_id.",'Гера'),
(662, ".$new_language_id.",'Канем'),
(663, ".$new_language_id.",'Природный лак'),
(664, ".$new_language_id.",'Logone Occidental'),
(665, ".$new_language_id.",'Логоне Восточный'),
(666, ".$new_language_id.",'Майо-Кебби'),
(667, ".$new_language_id.",'Мойен-Шари'),
(668, ".$new_language_id.",'Ouaddai'),
(669, ".$new_language_id.",'Саламат'),
(670, ".$new_language_id.",'Tandjile'),
(671, ".$new_language_id.",'Айсен дель Генеральный Карлос Ибаньес'),
(672, ".$new_language_id.",'Антофагаста'),
(673, ".$new_language_id.",'Араукания'),
(674, ".$new_language_id.",'Атакама'),
(675, ".$new_language_id.",'Bio-Bio'),
(676, ".$new_language_id.",'Кокимбо'),
(677, ".$new_language_id.",'Libertador General Bernardo O&#39;Hi'),
(678, ".$new_language_id.",'Лос-Лагос'),
(679, ".$new_language_id.",'Магальянес у де-ла-Антарктида Чи'),
(680, ".$new_language_id.",'Мол'),
(681, ".$new_language_id.",'Столичная область'),
(682, ".$new_language_id.",'Тарапака'),
(683, ".$new_language_id.",'Вальпараисо'),
(684, ".$new_language_id.",'Аньхой'),
(685, ".$new_language_id.",'Пекин'),
(686, ".$new_language_id.",'Чунцин'),
(687, ".$new_language_id.",'Фуцзянь'),
(688, ".$new_language_id.",'Ганьсу'),
(689, ".$new_language_id.",'Гуандун'),
(690, ".$new_language_id.",'Гуанси'),
(691, ".$new_language_id.",'Гуйчжоу'),
(692, ".$new_language_id.",'Хайнань'),
(693, ".$new_language_id.",'Хэбэй'),
(694, ".$new_language_id.",'Хэйлунцзян'),
(695, ".$new_language_id.",'Хэнань'),
(696, ".$new_language_id.",'Гонконг'),
(697, ".$new_language_id.",'Хубэй'),
(698, ".$new_language_id.",'Хунань'),
(699, ".$new_language_id.",'Внутренняя Монголия'),
(700, ".$new_language_id.",'Цзянсу'),
(701, ".$new_language_id.",'Цзянси'),
(702, ".$new_language_id.",'Цзилинь'),
(703, ".$new_language_id.",'Ляонин'),
(704, ".$new_language_id.",'Макао'),
(705, ".$new_language_id.",'Нинся'),
(706, ".$new_language_id.",'Шэньси'),
(707, ".$new_language_id.",'Шаньдун'),
(708, ".$new_language_id.",'Шанхай'),
(709, ".$new_language_id.",'Шаньси'),
(710, ".$new_language_id.",'Сычуань'),
(711, ".$new_language_id.",'Тяньцзинь'),
(712, ".$new_language_id.",'Синьцзян'),
(713, ".$new_language_id.",'Юньнань'),
(714, ".$new_language_id.",'Чжэцзян'),
(715, ".$new_language_id.",'Направление Остров'),
(716, ".$new_language_id.",'Главная Остров'),
(717, ".$new_language_id.",'Horsburgh Остров'),
(718, ".$new_language_id.",'Южный остров'),
(719, ".$new_language_id.",'Сидаоский'),
(720, ".$new_language_id.",'Amazonas'),
(721, ".$new_language_id.",'Антиокия'),
(722, ".$new_language_id.",'Араука'),
(723, ".$new_language_id.",'Atlantico'),
(724, ".$new_language_id.",'Богота DC'),
(725, ".$new_language_id.",'Боливар'),
(726, ".$new_language_id.",'Бояка'),
(727, ".$new_language_id.",'Кальдас'),
(728, ".$new_language_id.",'Caqueta'),
(729, ".$new_language_id.",'Casanare'),
(730, ".$new_language_id.",'Каука'),
(731, ".$new_language_id.",'Сезар'),
(732, ".$new_language_id.",'Choco'),
(733, ".$new_language_id.",'Кордова'),
(734, ".$new_language_id.",'Кундинамарка'),
(735, ".$new_language_id.",'Guainia'),
(736, ".$new_language_id.",'Гуахира'),
(737, ".$new_language_id.",'Гуавьяре'),
(738, ".$new_language_id.",'Уила'),
(739, ".$new_language_id.",'Магдалена'),
(740, ".$new_language_id.",'Мета'),
(741, ".$new_language_id.",'Нариньо'),
(742, ".$new_language_id.",'Норте-де-Сантандер'),
(743, ".$new_language_id.",'Путумайо'),
(744, ".$new_language_id.",'Quindio'),
(745, ".$new_language_id.",'Risaralda'),
(746, ".$new_language_id.",'Сан - Андрес у Провиденсия'),
(747, ".$new_language_id.",'Сантандер'),
(748, ".$new_language_id.",'Сукре'),
(749, ".$new_language_id.",'Толима'),
(750, ".$new_language_id.",'Валье-дель-Каука'),
(751, ".$new_language_id.",'Ваупес'),
(752, ".$new_language_id.",'Vichada'),
(753, ".$new_language_id.",'Гранд-Комор'),
(754, ".$new_language_id.",'Анжуан'),
(755, ".$new_language_id.",'Мохели'),
(756, ".$new_language_id.",'Bouenza'),
(757, ".$new_language_id.",'Браззавиль'),
(758, ".$new_language_id.",'Кювета'),
(759, ".$new_language_id.",'Кювет-Ouest'),
(760, ".$new_language_id.",'Kouilou'),
(761, ".$new_language_id.",'Lekoumou'),
(762, ".$new_language_id.",'Ликуала'),
(763, ".$new_language_id.",'Ниари'),
(764, ".$new_language_id.",'Плато'),
(765, ".$new_language_id.",'Бассейн'),
(766, ".$new_language_id.",'Сангха'),
(767, ".$new_language_id.",'Пукапука'),
(768, ".$new_language_id.",'Ракаханга'),
(769, ".$new_language_id.",'Манихики'),
(770, ".$new_language_id.",'Пенрин'),
(771, ".$new_language_id.",'Нассау Остров'),
(772, ".$new_language_id.",'Surwarrow'),
(773, ".$new_language_id.",'Пальмерстон'),
(774, ".$new_language_id.",'Аитутаки'),
(775, ".$new_language_id.",'Manuae'),
(776, ".$new_language_id.",'Такутеа'),
(777, ".$new_language_id.",'Митиаро'),
(778, ".$new_language_id.",'Atiu'),
(779, ".$new_language_id.",'Мауке'),
(780, ".$new_language_id.",'Раротонга'),
(781, ".$new_language_id.",'Мангаиа'),
(782, ".$new_language_id.",'Алахуэла'),
(783, ".$new_language_id.",'Картаго'),
(784, ".$new_language_id.",'Гуанакасте'),
(785, ".$new_language_id.",'Эредиа'),
(786, ".$new_language_id.",'Лимон'),
(787, ".$new_language_id.",'Пунтаренас'),
(788, ".$new_language_id.",'Сан - Хосе'),
(789, ".$new_language_id.",'Abengourou'),
(790, ".$new_language_id.",'Абиджан'),
(791, ".$new_language_id.",'Абуассо'),
(792, ".$new_language_id.",'Адиаке'),
(793, ".$new_language_id.",'Adzope'),
(794, ".$new_language_id.",'Agboville'),
(795, ".$new_language_id.",'Agnibilekrou'),
(796, ".$new_language_id.",'Alepe'),
(797, ".$new_language_id.",'Bocanda'),
(798, ".$new_language_id.",'Банголо'),
(799, ".$new_language_id.",'Beoumi'),
(800, ".$new_language_id.",'Biankouma'),
(801, ".$new_language_id.",'Бондуку'),
(802, ".$new_language_id.",'Bongouanou'),
(803, ".$new_language_id.",'Bouafle'),
(804, ".$new_language_id.",'Буаки'),
(805, ".$new_language_id.",'Буна'),
(806, ".$new_language_id.",'Бундиали'),
(807, ".$new_language_id.",'Dabakala'),
(808, ".$new_language_id.",'Dabou'),
(809, ".$new_language_id.",'Далоа'),
(810, ".$new_language_id.",'Данане'),
(811, ".$new_language_id.",'Даукро'),
(812, ".$new_language_id.",'Димбокро'),
(813, ".$new_language_id.",'Диво'),
(814, ".$new_language_id.",'Дюэкуэ'),
(815, ".$new_language_id.",'Феркеседугу'),
(816, ".$new_language_id.",'Gagnoa'),
(817, ".$new_language_id.",'Гранд-Бассам'),
(818, ".$new_language_id.",'Гранд-Lahou'),
(819, ".$new_language_id.",'Гигло'),
(820, ".$new_language_id.",'Issia'),
(821, ".$new_language_id.",'Jacqueville'),
(822, ".$new_language_id.",'Katiola'),
(823, ".$new_language_id.",'Корого'),
(824, ".$new_language_id.",'Лакота'),
(825, ".$new_language_id.",'Человек'),
(826, ".$new_language_id.",'Mankono'),
(827, ".$new_language_id.",'Mbahiakro'),
(828, ".$new_language_id.",'Одиенне'),
(829, ".$new_language_id.",'Oume'),
(830, ".$new_language_id.",'Sakassou'),
(831, ".$new_language_id.",'Сан - Педро-'),
(832, ".$new_language_id.",'Сассандра'),
(833, ".$new_language_id.",'Séguéla'),
(834, ".$new_language_id.",'Sinfra'),
(835, ".$new_language_id.",'Soubre'),
(836, ".$new_language_id.",'Табу'),
(837, ".$new_language_id.",'Танда'),
(838, ".$new_language_id.",'Tiebissou'),
(839, ".$new_language_id.",'Tingrela'),
(840, ".$new_language_id.",'Tiassale'),
(841, ".$new_language_id.",'Touba'),
(842, ".$new_language_id.",'Тулепле'),
(843, ".$new_language_id.",'Toumodi'),
(844, ".$new_language_id.",'Вавуа'),
(845, ".$new_language_id.",'Ямусукро'),
(846, ".$new_language_id.",'Zuenoula'),
(847, ".$new_language_id.",'Беловарско-Bilogora'),
(848, ".$new_language_id.",'Город Загреб'),
(849, ".$new_language_id.",'Дубровник-Неретва'),
(850, ".$new_language_id.",'Истра'),
(851, ".$new_language_id.",'Карловац'),
(852, ".$new_language_id.",'Копривницко-Крижевацкая'),
(853, ".$new_language_id.",'Крапина-Загорье'),
(854, ".$new_language_id.",'Лика-Сень'),
(855, ".$new_language_id.",'Medimurje'),
(856, ".$new_language_id.",'Осиек-Баранья'),
(857, ".$new_language_id.",'Пожега-Славонии'),
(858, ".$new_language_id.",'Приморье-Горски Котар'),
(859, ".$new_language_id.",'Шибеник'),
(860, ".$new_language_id.",'Сисак-Moslavina'),
(861, ".$new_language_id.",'Slavonski Brod-Посавина'),
(862, ".$new_language_id.",'Сплит-Далмация'),
(863, ".$new_language_id.",'Вараждин'),
(864, ".$new_language_id.",'Virovitica-Подравская'),
(865, ".$new_language_id.",'Вуковар-Srijem'),
(866, ".$new_language_id.",'Задар-Книн'),
(867, ".$new_language_id.",'Загреб'),
(868, ".$new_language_id.",'Камагуэй'),
(869, ".$new_language_id.",'Сьего-де-Авила'),
(870, ".$new_language_id.",'Сьенфуэгос'),
(871, ".$new_language_id.",'Гавана'),
(872, ".$new_language_id.",'Гранма'),
(873, ".$new_language_id.",'Гуантанамо'),
(874, ".$new_language_id.",'Ольгин'),
(875, ".$new_language_id.",'Хувентуд'),
(876, ".$new_language_id.",'La Habana'),
(877, ".$new_language_id.",'Лас-Тунас'),
(878, ".$new_language_id.",'Матансас'),
(879, ".$new_language_id.",'Пинар-дель-Рио'),
(880, ".$new_language_id.",'Санкти Спиритус'),
(881, ".$new_language_id.",'Сантьяго-де-Куба'),
(882, ".$new_language_id.",'Вилья-Клара'),
(883, ".$new_language_id.",'Фамагуста'),
(884, ".$new_language_id.",'Кирения'),
(885, ".$new_language_id.",'Ларнака'),
(886, ".$new_language_id.",'Лимассол'),
(887, ".$new_language_id.",'Никосия'),
(888, ".$new_language_id.",'Пафос'),
(889, ".$new_language_id.",'Усти'),
(890, ".$new_language_id.",'Южночешский'),
(891, ".$new_language_id.",'Южная Моравия'),
(892, ".$new_language_id.",'Карловарский'),
(893, ".$new_language_id.",'Градец Кралове'),
(894, ".$new_language_id.",'Либерец'),
(895, ".$new_language_id.",'Moravskoslezsky'),
(896, ".$new_language_id.",'Оломоуц'),
(897, ".$new_language_id.",'Пардубице'),
(898, ".$new_language_id.",'Пльзень'),
(899, ".$new_language_id.",'Прага'),
(900, ".$new_language_id.",'Центральная Богемия'),
(901, ".$new_language_id.",'Высочина'),
(902, ".$new_language_id.",'Злинский'),
(903, ".$new_language_id.",'Орхус'),
(904, ".$new_language_id.",'Борнхольмский'),
(905, ".$new_language_id.",'Копенгаген'),
(906, ".$new_language_id.",'Фарерские острова'),
(907, ".$new_language_id.",'Фредериксборг'),
(908, ".$new_language_id.",'Фюн'),
(909, ".$new_language_id.",'Копенгаген'),
(910, ".$new_language_id.",'Северная Ютландия'),
(911, ".$new_language_id.",'Рибе'),
(912, ".$new_language_id.",'Ringkobing'),
(913, ".$new_language_id.",'Роскилле'),
(914, ".$new_language_id.",'Sonderjylland'),
(915, ".$new_language_id.",'Storstrom'),
(916, ".$new_language_id.",'Вайле'),
(917, ".$new_language_id.",'Vestjælland'),
(918, ".$new_language_id.",'Выборг'),
(919, ".$new_language_id.",'Али Сабих'),
(920, ".$new_language_id.",'Диккиль'),
(921, ".$new_language_id.",'Джибути'),
(922, ".$new_language_id.",'Обок'),
(923, ".$new_language_id.",'Таджура'),
(924, ".$new_language_id.",'Святой Андрей Приход'),
(925, ".$new_language_id.",'Saint David Приход'),
(926, ".$new_language_id.",'Святой Георгий Приход'),
(927, ".$new_language_id.",'Святой Иоанн Приход'),
(928, ".$new_language_id.",'Святой Иосиф Приход'),
(929, ".$new_language_id.",'Святой Лука Приход'),
(930, ".$new_language_id.",'Сан-Марко Приход'),
(931, ".$new_language_id.",'Святой Патрик Приход'),
(932, ".$new_language_id.",'Сент-Пол Приход'),
(933, ".$new_language_id.",'Святой Петр Приход'),
(934, ".$new_language_id.",'Национальный округ'),
(935, ".$new_language_id.",'Azua'),
(936, ".$new_language_id.",'Baoruco'),
(937, ".$new_language_id.",'Бараона'),
(938, ".$new_language_id.",'Дахабон'),
(939, ".$new_language_id.",'Дуарте'),
(940, ".$new_language_id.",'Элиас Пина'),
(941, ".$new_language_id.",'Эль Seybo'),
(942, ".$new_language_id.",'Espaillat'),
(943, ".$new_language_id.",'Хато-Майор'),
(944, ".$new_language_id.",'Независимость'),
(945, ".$new_language_id.",'La Altagracia'),
(946, ".$new_language_id.",'Ла-Романа'),
(947, ".$new_language_id.",'La Vega'),
(948, ".$new_language_id.",'Maria Trinidad Sanchez'),
(949, ".$new_language_id.",'Монсеньор Нуэль'),
(950, ".$new_language_id.",'Монте-Кристи'),
(951, ".$new_language_id.",'Монте-Плата'),
(952, ".$new_language_id.",'Педерналес'),
(953, ".$new_language_id.",'Peravia (Бани)'),
(954, ".$new_language_id.",'Пуэрто-Плата'),
(955, ".$new_language_id.",'Сальседо'),
(956, ".$new_language_id.",'Самана'),
(957, ".$new_language_id.",'Санчес Рамирес'),
(958, ".$new_language_id.",'Сан - Кристобаль'),
(959, ".$new_language_id.",'Сан - Хосе де Ocoa'),
(960, ".$new_language_id.",'Сан - Хуан'),
(961, ".$new_language_id.",'Сан - Педро де Макорис'),
(962, ".$new_language_id.",'Сантьяго'),
(963, ".$new_language_id.",'Сантьяго Родригес'),
(964, ".$new_language_id.",'Санто-Доминго'),
(965, ".$new_language_id.",'Вальверде'),
(966, ".$new_language_id.",'Айлеу'),
(967, ".$new_language_id.",'Айнару'),
(968, ".$new_language_id.",'Baucau'),
(969, ".$new_language_id.",'Бобонару'),
(970, ".$new_language_id.",'Кова Лима'),
(971, ".$new_language_id.",'Дили'),
(972, ".$new_language_id.",'Эрмера'),
(973, ".$new_language_id.",'Лаутем'),
(974, ".$new_language_id.",'Ликика'),
(975, ".$new_language_id.",'Манатуто'),
(976, ".$new_language_id.",'Мануфахи'),
(977, ".$new_language_id.",'Окуси'),
(978, ".$new_language_id.",'Викеке'),
(979, ".$new_language_id.",'Azuay'),
(980, ".$new_language_id.",'Боливар'),
(981, ".$new_language_id.",'Каньяр'),
(982, ".$new_language_id.",'Carchi'),
(983, ".$new_language_id.",'Чимборасо'),
(984, ".$new_language_id.",'Котопакси'),
(985, ".$new_language_id.",'Эль-Оро'),
(986, ".$new_language_id.",'Эсмеральдас'),
(987, ".$new_language_id.",'Галапагосские'),
(988, ".$new_language_id.",'Гуаяс'),
(989, ".$new_language_id.",'Imbabura'),
(990, ".$new_language_id.",'Лоха'),
(991, ".$new_language_id.",'Лос-Риос'),
(992, ".$new_language_id.",'Манаби'),
(993, ".$new_language_id.",'Морона Сантьяго'),
(994, ".$new_language_id.",'Напо'),
(995, ".$new_language_id.",'Орельяна'),
(996, ".$new_language_id.",'Pastaza'),
(997, ".$new_language_id.",'Пичинча'),
(998, ".$new_language_id.",'Сукумбиос'),
(999, ".$new_language_id.",'Тунгурауа'),
(1000, ".$new_language_id.",'Замора Чинчипе'),
(1001, ".$new_language_id.",'Объявление Daqahliyah'),
(1002, ".$new_language_id.",'Эль-Бахр-эль-Ахмар'),
(1003, ".$new_language_id.",'Аль Buhayrah'),
(1004, ".$new_language_id.",'Аль-Фаюм'),
(1005, ".$new_language_id.",'Аль Гарбии'),
(1006, ".$new_language_id.",'Аль Iskandariyah'),
(1007, ".$new_language_id.",'Аль Isma&#39;iliyah'),
(1008, ".$new_language_id.",'Аль Jizah'),
(1009, ".$new_language_id.",'Аль Minufiyah'),
(1010, ".$new_language_id.",'Аль-Минья'),
(1011, ".$new_language_id.",'Москва и Московская область'),
(1012, ".$new_language_id.",'Аль Qalyubiyah'),
(1013, ".$new_language_id.",'Аль Вади-эль Jadid'),
(1014, ".$new_language_id.",'Эш-Шаркия'),
(1015, ".$new_language_id.",'Как Suways'),
(1016, ".$new_language_id.",'Асуан'),
(1017, ".$new_language_id.",'Асьют'),
(1018, ".$new_language_id.",'Бани Suwayf'),
(1019, ".$new_language_id.",'Бур Саид'),
(1020, ".$new_language_id.",'Dumyat'),
(1021, ".$new_language_id.",'Южный Синай &quot;'),
(1022, ".$new_language_id.",'Кафр золы Шейх'),
(1023, ".$new_language_id.",'Матрух'),
(1024, ".$new_language_id.",'Кина'),
(1025, ".$new_language_id.",'Shamal Sina &#39;'),
(1026, ".$new_language_id.",'Suhaj'),
(1027, ".$new_language_id.",'Ahuachapan'),
(1028, ".$new_language_id.",'Домики'),
(1029, ".$new_language_id.",'Чалатенанго'),
(1030, ".$new_language_id.",'Кускатлан'),
(1031, ".$new_language_id.",'Ла-Либертад'),
(1032, ".$new_language_id.",'Ла-Пас'),
(1033, ".$new_language_id.",'La Union'),
(1034, ".$new_language_id.",'Morazan'),
(1035, ".$new_language_id.",'Сан - Мигель'),
(1036, ".$new_language_id.",'Сан - Сальвадор'),
(1037, ".$new_language_id.",'Сан - Висенте'),
(1038, ".$new_language_id.",'Санта-Ана'),
(1039, ".$new_language_id.",'Sonsonate'),
(1040, ".$new_language_id.",'Усулутан'),
(1041, ".$new_language_id.",'Провинция Аннобон'),
(1042, ".$new_language_id.",'Провинция Bioko Норте'),
(1043, ".$new_language_id.",'Провинция Bioko Sur'),
(1044, ".$new_language_id.",'Провинция Центро-Сур'),
(1045, ".$new_language_id.",'Провинция Кие-Нтем'),
(1046, ".$new_language_id.",'Провинция Литораль'),
(1047, ".$new_language_id.",'Провинция Wele-Nzas'),
(1048, ".$new_language_id.",'Центральный (Maekel)'),
(1049, ".$new_language_id.",'Ансэба (Керен)'),
(1050, ".$new_language_id.",'Южный Красное море (Дебуб-Keih-Бахри)'),
(1051, ".$new_language_id.",'Северная Красное море (Semien-Keih-Бахри)'),
(1052, ".$new_language_id.",'Южный (Дебуб)'),
(1053, ".$new_language_id.",'Гаш-Барка (Баренту)'),
(1054, ".$new_language_id.",'Харьюмаа (Таллин)'),
(1055, ".$new_language_id.",'Хийумаа (Кярдла)'),
(1056, ".$new_language_id.",'Ида-Вирумаа (Йыхви)'),
(1057, ".$new_language_id.",'Ярвамаа (Пайде)'),
(1058, ".$new_language_id.",'Йыгевамаа (Йыгева)'),
(1059, ".$new_language_id.",'Ляэне-Вирумаа (Раквере)'),
(1060, ".$new_language_id.",'Ляэнемаа (Хаапсалу)'),
(1061, ".$new_language_id.",'Пярнумаа (Пярну)'),
(1062, ".$new_language_id.",'Пылвамаа (Пылва)'),
(1063, ".$new_language_id.",'Raplamaa (Рапла)'),
(1064, ".$new_language_id.",'Сааремаа (Kuessaare)'),
(1065, ".$new_language_id.",'Тартумаа (Тарту)'),
(1066, ".$new_language_id.",'Валгамаа (Валга)'),
(1067, ".$new_language_id.",'Вильяндимаа (Вильянди)'),
(1068, ".$new_language_id.",'Вырумаа (Выру)'),
(1069, ".$new_language_id.",'Издалека'),
(1070, ".$new_language_id.",'Amhara'),
(1071, ".$new_language_id.",'Бенишангул-Gumaz'),
(1072, ".$new_language_id.",'Gambela'),
(1073, ".$new_language_id.",'Hariai'),
(1074, ".$new_language_id.",'Оромии'),
(1075, ".$new_language_id.",'Сомалийский'),
(1076, ".$new_language_id.",'Южные Наций - и народностей региона'),
(1077, ".$new_language_id.",'Тыграй'),
(1078, ".$new_language_id.",'Аддис-Абеба'),
(1079, ".$new_language_id.",'Дыре-Дауа'),
(1080, ".$new_language_id.",'Центральный отдел'),
(1081, ".$new_language_id.",'Северный округ'),
(1082, ".$new_language_id.",'Восточного отдела'),
(1083, ".$new_language_id.",'Западный округ'),
(1084, ".$new_language_id.",'Ротума'),
(1085, ".$new_language_id.",'Ahvenanmaan Laani'),
(1086, ".$new_language_id.",'Этела-Suomen Laani'),
(1087, ".$new_language_id.",'Ита-Суомен Laani'),
(1088, ".$new_language_id.",'Lansi-Suomen Laani'),
(1089, ".$new_language_id.",'Лапин Lanani'),
(1090, ".$new_language_id.",'Оулун Laani'),
(1091, ".$new_language_id.",'Эльзас'),
(1092, ".$new_language_id.",'Аквитания'),
(1093, ".$new_language_id.",'Овернь'),
(1094, ".$new_language_id.",'Бретань'),
(1095, ".$new_language_id.",'Бургундия'),
(1096, ".$new_language_id.",'Центр Долина Луары'),
(1097, ".$new_language_id.",'Шампанское'),
(1098, ".$new_language_id.",'Труп'),
(1099, ".$new_language_id.",'Франция Конт'),
(1100, ".$new_language_id.",'Лангедок-Руссильон'),
(1101, ".$new_language_id.",'Лимузен'),
(1102, ".$new_language_id.",'Лотарингия'),
(1103, ".$new_language_id.",'Пиренеи'),
(1104, ".$new_language_id.",'Нор-Па-де-Кале'),
(1105, ".$new_language_id.",'Нормандия'),
(1106, ".$new_language_id.",'Париж / Жестокое де Франс'),
(1107, ".$new_language_id.",'Пикардия'),
(1108, ".$new_language_id.",'Пуату Шарант'),
(1109, ".$new_language_id.",'Прованс'),
(1110, ".$new_language_id.",'Рона-Альпы'),
(1111, ".$new_language_id.",'Ривьера'),
(1112, ".$new_language_id.",'Западная Долина Луары'),
(1113, ".$new_language_id.",'Etranger'),
(1114, ".$new_language_id.",'Айн'),
(1115, ".$new_language_id.",'Эна'),
(1116, ".$new_language_id.",'Алье'),
(1117, ".$new_language_id.",'Альпы Верхнего Прованса'),
(1118, ".$new_language_id.",'Верхние Альпы'),
(1119, ".$new_language_id.",'Приморские Альпы'),
(1120, ".$new_language_id.",'Ардеш'),
(1121, ".$new_language_id.",'Арденны'),
(1122, ".$new_language_id.",'Арьеж'),
(1123, ".$new_language_id.",'Aube'),
(1124, ".$new_language_id.",'Од'),
(1125, ".$new_language_id.",'Аверон'),
(1126, ".$new_language_id.",'Буш-дю-Рона'),
(1127, ".$new_language_id.",'Кальвадос'),
(1128, ".$new_language_id.",'Канталь'),
(1129, ".$new_language_id.",'Шарента'),
(1130, ".$new_language_id.",'Приморская Шаранта'),
(1131, ".$new_language_id.",'Шер'),
(1132, ".$new_language_id.",'Коррез'),
(1133, ".$new_language_id.",'Corse-дю-Сюд'),
(1134, ".$new_language_id.",'Верхняя Корсика'),
(1135, ".$new_language_id.",'Кот или'),
(1136, ".$new_language_id.",'Кот д&#39;Армор'),
(1137, ".$new_language_id.",'Крез'),
(1138, ".$new_language_id.",'Дордонь'),
(1139, ".$new_language_id.",'Ду'),
(1140, ".$new_language_id.",'Дром'),
(1141, ".$new_language_id.",'Эр'),
(1142, ".$new_language_id.",'Эр и Луар'),
(1143, ".$new_language_id.",'Финистер'),
(1144, ".$new_language_id.",'Gard'),
(1145, ".$new_language_id.",'Верхняя Гаронна'),
(1146, ".$new_language_id.",'Жер'),
(1147, ".$new_language_id.",'Жиронда'),
(1148, ".$new_language_id.",'Эро'),
(1149, ".$new_language_id.",'Иль и Вилен'),
(1150, ".$new_language_id.",'Эндр'),
(1151, ".$new_language_id.",'Эндр и Луара'),
(1152, ".$new_language_id.",'Изер'),
(1153, ".$new_language_id.",'Юра'),
(1154, ".$new_language_id.",'Ланды'),
(1155, ".$new_language_id.",'Луар и Шер'),
(1156, ".$new_language_id.",'Луара'),
(1157, ".$new_language_id.",'Верхняя Луара'),
(1158, ".$new_language_id.",'Луара Атлантическая'),
(1159, ".$new_language_id.",'Луаре'),
(1160, ".$new_language_id.",'Много'),
(1161, ".$new_language_id.",'Ло и Гаронна'),
(1162, ".$new_language_id.",'Lozère'),
(1163, ".$new_language_id.",'Мэн и Луара'),
(1164, ".$new_language_id.",'Манш'),
(1165, ".$new_language_id.",'Марн'),
(1166, ".$new_language_id.",'Верхняя Марна'),
(1167, ".$new_language_id.",'Mayenne'),
(1168, ".$new_language_id.",'Мерт и Мозель'),
(1169, ".$new_language_id.",'Мез'),
(1170, ".$new_language_id.",'Морбиан'),
(1171, ".$new_language_id.",'Мозельвейн'),
(1172, ".$new_language_id.",'Ньевр'),
(1173, ".$new_language_id.",'Nord'),
(1174, ".$new_language_id.",'Уаз'),
(1175, ".$new_language_id.",'Орн'),
(1176, ".$new_language_id.",'Па-де-Кале'),
(1177, ".$new_language_id.",'Пюи де Дом'),
(1178, ".$new_language_id.",'Пиренеи Атлантические'),
(1179, ".$new_language_id.",'Верхние Пиренеи'),
(1180, ".$new_language_id.",'Пиренеи Восточные'),
(1181, ".$new_language_id.",'Нижний Рейн'),
(1182, ".$new_language_id.",'Haut Rhin'),
(1183, ".$new_language_id.",'Рона'),
(1184, ".$new_language_id.",'Верхняя Сона'),
(1185, ".$new_language_id.",'Сона и Луара'),
(1186, ".$new_language_id.",'Сарт'),
(1187, ".$new_language_id.",'Савойя'),
(1188, ".$new_language_id.",'Верхняя Савойя'),
(1189, ".$new_language_id.",'Париж'),
(1190, ".$new_language_id.",'Сена Приморская'),
(1191, ".$new_language_id.",'Сена и др. Марн'),
(1192, ".$new_language_id.",'Ивелин'),
(1193, ".$new_language_id.",'Де Севр'),
(1194, ".$new_language_id.",'Сомма'),
(1195, ".$new_language_id.",'Каровое озеро'),
(1196, ".$new_language_id.",'Тарн и Гаронна'),
(1197, ".$new_language_id.",'Var'),
(1198, ".$new_language_id.",'Воклюз'),
(1199, ".$new_language_id.",'Вандея'),
(1200, ".$new_language_id.",'Вьенна'),
(1201, ".$new_language_id.",'Верхняя Вьенна'),
(1202, ".$new_language_id.",'Вогезы'),
(1203, ".$new_language_id.",'Йонна'),
(1204, ".$new_language_id.",'Территория Бельфор'),
(1205, ".$new_language_id.",'Эссонна'),
(1206, ".$new_language_id.",'О-де-Сена'),
(1207, ".$new_language_id.",'Сена Сен-Дени'),
(1208, ".$new_language_id.",'Валь-де-Марн'),
(1209, ".$new_language_id.",'Валь-д&#39;Уаз'),
(1210, ".$new_language_id.",'Archipel де Маркизы'),
(1211, ".$new_language_id.",'Archipel де Туамоту'),
(1212, ".$new_language_id.",'Archipel де Tubuai'),
(1213, ".$new_language_id.",'Иль-дю-Vent'),
(1214, ".$new_language_id.",'Иль Sous-ле-Vent'),
(1215, ".$new_language_id.",'Иль Крозе'),
(1216, ".$new_language_id.",'Иль Кергелен'),
(1217, ".$new_language_id.",'Иль Амстердам'),
(1218, ".$new_language_id.",'Иль Сен-Поль'),
(1219, ".$new_language_id.",'Земли Адели'),
(1220, ".$new_language_id.",'Estuaire'),
(1221, ".$new_language_id.",'Haut-Огове'),
(1222, ".$new_language_id.",'Среднее Огове'),
(1223, ".$new_language_id.",'Нгуни'),
(1224, ".$new_language_id.",'Nyanga'),
(1225, ".$new_language_id.",'Огове-Ивиндо'),
(1226, ".$new_language_id.",'Огове-Лоло'),
(1227, ".$new_language_id.",'Огове-Маритим'),
(1228, ".$new_language_id.",'Волю-Нтем'),
(1229, ".$new_language_id.",'Банжул'),
(1230, ".$new_language_id.",'Бас'),
(1231, ".$new_language_id.",'Brikama'),
(1232, ".$new_language_id.",'Janjangbure'),
(1233, ".$new_language_id.",'Kanifeng'),
(1234, ".$new_language_id.",'Кереван'),
(1235, ".$new_language_id.",'Kuntaur'),
(1236, ".$new_language_id.",'Mansakonko'),
(1237, ".$new_language_id.",'Нижняя Река'),
(1238, ".$new_language_id.",'Центральный реки'),
(1239, ".$new_language_id.",'Северная банк'),
(1240, ".$new_language_id.",'Верхняя Река'),
(1241, ".$new_language_id.",'Западный'),
(1242, ".$new_language_id.",'Абхазия'),
(1243, ".$new_language_id.",'Аджария'),
(1244, ".$new_language_id.",'Тбилиси'),
(1245, ".$new_language_id.",'Гурия'),
(1246, ".$new_language_id.",'Имерети'),
(1247, ".$new_language_id.",'Кахети'),
(1248, ".$new_language_id.",'Квемо Картли'),
(1249, ".$new_language_id.",'Мцхета-Мтианети'),
(1250, ".$new_language_id.",'Рача Лечхуми и Квемо Svanet'),
(1251, ".$new_language_id.",'Самегрело-Земо Сванети'),
(1252, ".$new_language_id.",'Самцхе-Джавахети'),
(1253, ".$new_language_id.",'Шида Картли'),
(1254, ".$new_language_id.",'Баден-Вюртемберг'),
(1255, ".$new_language_id.",'Бавария'),
(1256, ".$new_language_id.",'Берлин'),
(1257, ".$new_language_id.",'Бранденбург'),
(1258, ".$new_language_id.",'Бремен'),
(1259, ".$new_language_id.",'Гамбург'),
(1260, ".$new_language_id.",'Гессен'),
(1261, ".$new_language_id.",'Мекленбург-Передняя Померания'),
(1262, ".$new_language_id.",'Нижняя Саксония'),
(1263, ".$new_language_id.",'Северный Рейн-Вестфалия'),
(1264, ".$new_language_id.",'Рейнланд-Пфальц'),
(1265, ".$new_language_id.",'Саар'),
(1266, ".$new_language_id.",'Sachsen'),
(1267, ".$new_language_id.",'Саксония-Анхальт'),
(1268, ".$new_language_id.",'Шлезвиг-Гольштейн'),
(1269, ".$new_language_id.",'Thüringen'),
(1270, ".$new_language_id.",'Регион Ашанти'),
(1271, ".$new_language_id.",'Бронг-Ahafo Регион'),
(1272, ".$new_language_id.",'Центральный регион'),
(1273, ".$new_language_id.",'Восточный регион'),
(1274, ".$new_language_id.",'Большая Аккра область'),
(1275, ".$new_language_id.",'Северный регион'),
(1276, ".$new_language_id.",'Верхняя Восточная область'),
(1277, ".$new_language_id.",'Верхний Западный регион'),
(1278, ".$new_language_id.",'Вольта Регион'),
(1279, ".$new_language_id.",'Западный регион'),
(1280, ".$new_language_id.",'Аттика'),
(1281, ".$new_language_id.",'Центральная Греция'),
(1282, ".$new_language_id.",'Центральная Македония'),
(1283, ".$new_language_id.",'Крит'),
(1284, ".$new_language_id.",'Восточная Македония и Фракия'),
(1285, ".$new_language_id.",'Эпир'),
(1286, ".$new_language_id.",'Ионические острова'),
(1287, ".$new_language_id.",'Северные Эгейские острова'),
(1288, ".$new_language_id.",'Пелопоннес'),
(1289, ".$new_language_id.",'Южные Эгейские острова'),
(1290, ".$new_language_id.",'Фессалия'),
(1291, ".$new_language_id.",'Западная Греция'),
(1292, ".$new_language_id.",'Западная Македония'),
(1293, ".$new_language_id.",'Avannaa'),
(1294, ".$new_language_id.",'Tunu'),
(1295, ".$new_language_id.",'Kitaa'),
(1296, ".$new_language_id.",'Святой Андрей'),
(1297, ".$new_language_id.",'Сент-Дэвид'),
(1298, ".$new_language_id.",'Святой Георгий'),
(1299, ".$new_language_id.",'Святой Иоанн'),
(1300, ".$new_language_id.",'Сан-Марко'),
(1301, ".$new_language_id.",'Святой Патрик'),
(1302, ".$new_language_id.",'Карриаку'),
(1303, ".$new_language_id.",'Пети Мартиника'),
(1304, ".$new_language_id.",'Альта-Верапас'),
(1305, ".$new_language_id.",'Баха-Верапас'),
(1306, ".$new_language_id.",'Чимальтенанго'),
(1307, ".$new_language_id.",'Chiquimula'),
(1308, ".$new_language_id.",'Эль-Петен'),
(1309, ".$new_language_id.",'Эль Прогресо'),
(1310, ".$new_language_id.",'Эль Киш'),
(1311, ".$new_language_id.",'Эскуинтла'),
(1312, ".$new_language_id.",'Гватемала'),
(1313, ".$new_language_id.",'Уэуэтенанго'),
(1314, ".$new_language_id.",'Izabal'),
(1315, ".$new_language_id.",'Джалапа'),
(1316, ".$new_language_id.",'Хутьяпа'),
(1317, ".$new_language_id.",'Кесальтенанго'),
(1318, ".$new_language_id.",'Реталулеу'),
(1319, ".$new_language_id.",'Sacatepequez'),
(1320, ".$new_language_id.",'Сан - Маркос'),
(1321, ".$new_language_id.",'Santa Rosa'),
(1322, ".$new_language_id.",'Solola'),
(1323, ".$new_language_id.",'Suchitepequez'),
(1324, ".$new_language_id.",'Тотоникапан'),
(1325, ".$new_language_id.",'Zacapa'),
(1326, ".$new_language_id.",'Конакри'),
(1327, ".$new_language_id.",'Бейла'),
(1328, ".$new_language_id.",'Boffa'),
(1329, ".$new_language_id.",'Боке'),
(1330, ".$new_language_id.",'Coyah'),
(1331, ".$new_language_id.",'Dabola'),
(1332, ".$new_language_id.",'Dalaba'),
(1333, ".$new_language_id.",'Dinguiraye'),
(1334, ".$new_language_id.",'Dubreka'),
(1335, ".$new_language_id.",'Фаранах'),
(1336, ".$new_language_id.",'Forecariah'),
(1337, ".$new_language_id.",'Fria'),
(1338, ".$new_language_id.",'Gaoual'),
(1339, ".$new_language_id.",'Guéckédou'),
(1340, ".$new_language_id.",'Канкан'),
(1341, ".$new_language_id.",'Kerouane'),
(1342, ".$new_language_id.",'Киндиа'),
(1343, ".$new_language_id.",'Kissidougou'),
(1344, ".$new_language_id.",'Koubia'),
(1345, ".$new_language_id.",'Кундара'),
(1346, ".$new_language_id.",'Kouroussa'),
(1347, ".$new_language_id.",'Лабе'),
(1348, ".$new_language_id.",'Lelouma'),
(1349, ".$new_language_id.",'Лола'),
(1350, ".$new_language_id.",'Масента'),
(1351, ".$new_language_id.",'Мали'),
(1352, ".$new_language_id.",'Маму'),
(1353, ".$new_language_id.",'Mandiana'),
(1354, ".$new_language_id.",'Nzerekore'),
(1355, ".$new_language_id.",'Лаваш'),
(1356, ".$new_language_id.",'Siguiri'),
(1357, ".$new_language_id.",'Telimele'),
(1358, ".$new_language_id.",'Туге'),
(1359, ".$new_language_id.",'Yomou'),
(1360, ".$new_language_id.",'Бафата'),
(1361, ".$new_language_id.",'Биомбо'),
(1362, ".$new_language_id.",'Бисау'),
(1363, ".$new_language_id.",'Болама Регион'),
(1364, ".$new_language_id.",'Cacheu Регион'),
(1365, ".$new_language_id.",'Gabu Регион'),
(1366, ".$new_language_id.",'Оио Регион'),
(1367, ".$new_language_id.",'Quinara Регион'),
(1368, ".$new_language_id.",'Томбали Регион'),
(1369, ".$new_language_id.",'Barima-Waini'),
(1370, ".$new_language_id.",'Cuyuni-Мазаруни'),
(1371, ".$new_language_id.",'Демерара-Mahaica'),
(1372, ".$new_language_id.",'East Berbice-Corentyne'),
(1373, ".$new_language_id.",'Эссекибо острова-Запад Демерара'),
(1374, ".$new_language_id.",'Mahaica-Berbice'),
(1375, ".$new_language_id.",'Pomeroon-Supenaam'),
(1376, ".$new_language_id.",'Потаро-Siparuni'),
(1377, ".$new_language_id.",'Верхняя Демерара-Бербис'),
(1378, ".$new_language_id.",'Верхний Takutu-Верхний Эссекибо'),
(1379, ".$new_language_id.",'Артибонит'),
(1380, ".$new_language_id.",'Центр'),
(1381, ".$new_language_id.",'Grand&#39;Anse'),
(1382, ".$new_language_id.",'Nord'),
(1383, ".$new_language_id.",'Nord-Est'),
(1384, ".$new_language_id.",'Nord-Ouest'),
(1385, ".$new_language_id.",'Ouest'),
(1386, ".$new_language_id.",'Sud'),
(1387, ".$new_language_id.",'Sud-Est'),
(1388, ".$new_language_id.",'Квартира Остров'),
(1389, ".$new_language_id.",'McDonald Остров'),
(1390, ".$new_language_id.",'Шаг Остров'),
(1391, ".$new_language_id.",'Остров Херд'),
(1392, ".$new_language_id.",'Атлантида'),
(1393, ".$new_language_id.",'Choluteca'),
(1394, ".$new_language_id.",'Двоеточие'),
(1395, ".$new_language_id.",'Комаягуа'),
(1396, ".$new_language_id.",'Копан'),
(1397, ".$new_language_id.",'Кортесы'),
(1398, ".$new_language_id.",'El Paraiso'),
(1399, ".$new_language_id.",'Франсиско Морасан'),
(1400, ".$new_language_id.",'Gracias Dios'),
(1401, ".$new_language_id.",'Интибука'),
(1402, ".$new_language_id.",'Ислас-де-ла-Баия (Bay Islands)'),
(1403, ".$new_language_id.",'Ла-Пас'),
(1404, ".$new_language_id.",'Лемпира'),
(1405, ".$new_language_id.",'Окатепеке'),
(1406, ".$new_language_id.",'Оланчо'),
(1407, ".$new_language_id.",'Санта-Барбара'),
(1408, ".$new_language_id.",'Валье'),
(1409, ".$new_language_id.",'Йоро'),
(1410, ".$new_language_id.",'Центральная и Западная Остров Гонконг'),
(1411, ".$new_language_id.",'Восточная Остров Гонконг'),
(1412, ".$new_language_id.",'Южный Остров Гонконг'),
(1413, ".$new_language_id.",'Wan Chai Гонконг Остров'),
(1414, ".$new_language_id.",'Коулун Сити Коулун'),
(1415, ".$new_language_id.",'Куан Тонг Коулун'),
(1416, ".$new_language_id.",'Шам Шуй По Коулун'),
(1417, ".$new_language_id.",'Вонг Тай Син Коулун'),
(1418, ".$new_language_id.",'Яу Цим Монг Коулун'),
(1419, ".$new_language_id.",'Острова Новые территории'),
(1420, ".$new_language_id.",'Квай Tsing Новые территории'),
(1421, ".$new_language_id.",'Северная Новые территории'),
(1422, ".$new_language_id.",'Sai Kung Новые территории'),
(1423, ".$new_language_id.",'Sha Tin Новые территории'),
(1424, ".$new_language_id.",'Tai Po Новые территории'),
(1425, ".$new_language_id.",'Tsuen Wan Новые территории'),
(1426, ".$new_language_id.",'Tuen Мун Новые территории'),
(1427, ".$new_language_id.",'Yuen Long Новые территории'),
(1428, ".$new_language_id.",'Бач-Кишкун'),
(1429, ".$new_language_id.",'Баранья'),
(1430, ".$new_language_id.",'Бекеш'),
(1431, ".$new_language_id.",'Bekescsaba'),
(1432, ".$new_language_id.",'Боршод-Абауй-Земплен'),
(1433, ".$new_language_id.",'Будапешт'),
(1434, ".$new_language_id.",'Csongrad'),
(1435, ".$new_language_id.",'Дебрецен'),
(1436, ".$new_language_id.",'Dunaujvaros'),
(1437, ".$new_language_id.",'Эгер'),
(1438, ".$new_language_id.",'Фейер'),
(1439, ".$new_language_id.",'Дьер'),
(1440, ".$new_language_id.",'Дьер-Мошон-Шопрон'),
(1441, ".$new_language_id.",'Хайду-Бихар'),
(1442, ".$new_language_id.",'Heves'),
(1443, ".$new_language_id.",'Hodmezovasarhely'),
(1444, ".$new_language_id.",'Яс-Надькун-Сольнок'),
(1445, ".$new_language_id.",'Капошвар'),
(1446, ".$new_language_id.",'Кечкемет'),
(1447, ".$new_language_id.",'Комаром-Эстергом'),
(1448, ".$new_language_id.",'Мишкольц'),
(1449, ".$new_language_id.",'Nagykanizsa'),
(1450, ".$new_language_id.",'Nograd'),
(1451, ".$new_language_id.",'Ньиредьхаза'),
(1452, ".$new_language_id.",'Печ'),
(1453, ".$new_language_id.",'Вредитель'),
(1454, ".$new_language_id.",'Шомодь'),
(1455, ".$new_language_id.",'Шопрон'),
(1456, ".$new_language_id.",'Сабольч-Сатмар-Берег'),
(1457, ".$new_language_id.",'Сегед'),
(1458, ".$new_language_id.",'Секешфехервар'),
(1459, ".$new_language_id.",'Сольнок'),
(1460, ".$new_language_id.",'Сомбатхей'),
(1461, ".$new_language_id.",'Tatabanya'),
(1462, ".$new_language_id.",'Тольна'),
(1463, ".$new_language_id.",'Vas'),
(1464, ".$new_language_id.",'Веспрем'),
(1465, ".$new_language_id.",'Zala'),
(1466, ".$new_language_id.",'Залаэгерсег'),
(1467, ".$new_language_id.",'Austurland'),
(1468, ".$new_language_id.",'Hofuoborgarsvaeoi'),
(1469, ".$new_language_id.",'Norourland Эйстра'),
(1470, ".$new_language_id.",'Norourland Вестра'),
(1471, ".$new_language_id.",'Suourland'),
(1472, ".$new_language_id.",'Suournes'),
(1473, ".$new_language_id.",'Vestfiroir'),
(1474, ".$new_language_id.",'Vesturland'),
(1475, ".$new_language_id.",'Андаманские и Никобарские острова'),
(1476, ".$new_language_id.",'Андхра-Прадеш'),
(1477, ".$new_language_id.",'Аруначал-Прадеш'),
(1478, ".$new_language_id.",'Ассам'),
(1479, ".$new_language_id.",'Бихар'),
(1480, ".$new_language_id.",'Чандигарх'),
(1481, ".$new_language_id.",'Дадра и Нагархавели'),
(1482, ".$new_language_id.",'Даман и Диу'),
(1483, ".$new_language_id.",'Дели'),
(1484, ".$new_language_id.",'Гоа'),
(1485, ".$new_language_id.",'Гуджарат'),
(1486, ".$new_language_id.",'Харьяна'),
(1487, ".$new_language_id.",'Химачал-Прадеш'),
(1488, ".$new_language_id.",'Джамму и Кашмир'),
(1489, ".$new_language_id.",'Карнатака'),
(1490, ".$new_language_id.",'Керала'),
(1491, ".$new_language_id.",'Лакшадвип'),
(1492, ".$new_language_id.",'Мадхья-Прадеш'),
(1493, ".$new_language_id.",'Махараштра'),
(1494, ".$new_language_id.",'Манипур'),
(1495, ".$new_language_id.",'Мегхалая'),
(1496, ".$new_language_id.",'Мизорам'),
(1497, ".$new_language_id.",'Нагаленд'),
(1498, ".$new_language_id.",'Орисса'),
(1499, ".$new_language_id.",'Пондичерри'),
(1500, ".$new_language_id.",'Пенджаб'),
(1501, ".$new_language_id.",'Раджастан'),
(1502, ".$new_language_id.",'Сикким'),
(1503, ".$new_language_id.",'Тамил Наду'),
(1504, ".$new_language_id.",'Трипура'),
(1505, ".$new_language_id.",'Уттар-Прадеш'),
(1506, ".$new_language_id.",'Западная Бенгалия'),
(1507, ".$new_language_id.",'Ачех'),
(1508, ".$new_language_id.",'Бали'),
(1509, ".$new_language_id.",'Бантен'),
(1510, ".$new_language_id.",'Бенгкулу'),
(1511, ".$new_language_id.",'BoDeTaBek'),
(1512, ".$new_language_id.",'Горонтало'),
(1513, ".$new_language_id.",'Jakarta Raya'),
(1514, ".$new_language_id.",'Джамби'),
(1515, ".$new_language_id.",'Jawa Барат'),
(1516, ".$new_language_id.",'Jawa Tengah'),
(1517, ".$new_language_id.",'Ява Восточная'),
(1518, ".$new_language_id.",'Калимантан Барат'),
(1519, ".$new_language_id.",'Калимантан Selatan'),
(1520, ".$new_language_id.",'Калимантан Тенгах'),
(1521, ".$new_language_id.",'Калимантан Тимур'),
(1522, ".$new_language_id.",'Kepulauan Bangka Белитунг'),
(1523, ".$new_language_id.",'Lampung'),
(1524, ".$new_language_id.",'Малуку'),
(1525, ".$new_language_id.",'Малуку Utara'),
(1526, ".$new_language_id.",'Малые Зондские Барат'),
(1527, ".$new_language_id.",'Малые Зондские Тимур'),
(1528, ".$new_language_id.",'Папуа'),
(1529, ".$new_language_id.",'Риау'),
(1530, ".$new_language_id.",'Сулавеси Selatan'),
(1531, ".$new_language_id.",'Сулавеси Тенгах'),
(1532, ".$new_language_id.",'Сулавеси Тенгара'),
(1533, ".$new_language_id.",'Сулавеси Утара'),
(1534, ".$new_language_id.",'Суматра Барат'),
(1535, ".$new_language_id.",'Суматра Selatan'),
(1536, ".$new_language_id.",'Северная Суматра'),
(1537, ".$new_language_id.",'Джокьякарта'),
(1538, ".$new_language_id.",'Тегеран'),
(1539, ".$new_language_id.",'Кум'),
(1540, ".$new_language_id.",'Markazi'),
(1541, ".$new_language_id.",'Казвин'),
(1542, ".$new_language_id.",'Гилан'),
(1543, ".$new_language_id.",'Ардебиль'),
(1544, ".$new_language_id.",'Zanjan'),
(1545, ".$new_language_id.",'Восток Азербайджаном'),
(1546, ".$new_language_id.",'Запад Азербайджаном'),
(1547, ".$new_language_id.",'Курдистан'),
(1548, ".$new_language_id.",'Хамадан'),
(1549, ".$new_language_id.",'Керманшах'),
(1550, ".$new_language_id.",'Илам'),
(1551, ".$new_language_id.",'Lorestan'),
(1552, ".$new_language_id.",'Хузестан'),
(1553, ".$new_language_id.",'Чахар Mahaal и Bakhtiari'),
(1554, ".$new_language_id.",'Kohkiluyeh и Покупатель Ахмад'),
(1555, ".$new_language_id.",'Бушер'),
(1556, ".$new_language_id.",'Фарс'),
(1557, ".$new_language_id.",'Hormozgan'),
(1558, ".$new_language_id.",'Систан и Белуджистан'),
(1559, ".$new_language_id.",'Керман'),
(1560, ".$new_language_id.",'Йезд'),
(1561, ".$new_language_id.",'Исфахан'),
(1562, ".$new_language_id.",'Semnan'),
(1563, ".$new_language_id.",'Мазандаран'),
(1564, ".$new_language_id.",'Гулистан'),
(1565, ".$new_language_id.",'Северная Хорасан'),
(1566, ".$new_language_id.",'Разави Хорасан'),
(1567, ".$new_language_id.",'Южная Хорасан'),
(1568, ".$new_language_id.",'Багдад'),
(1569, ".$new_language_id.",'Салах ад-Дина'),
(1570, ".$new_language_id.",'Дияла'),
(1571, ".$new_language_id.",'Васит'),
(1572, ".$new_language_id.",'Майсан'),
(1573, ".$new_language_id.",'Аль Басра'),
(1574, ".$new_language_id.",'Ди-Кар'),
(1575, ".$new_language_id.",'Мутанна'),
(1576, ".$new_language_id.",'Аль Qadisyah'),
(1577, ".$new_language_id.",'Бабиль'),
(1578, ".$new_language_id.",'Аль Кербела'),
(1579, ".$new_language_id.",'Наджаф'),
(1580, ".$new_language_id.",'Аль Анбар'),
(1581, ".$new_language_id.",'Найнава'),
(1582, ".$new_language_id.",'Дахук'),
(1583, ".$new_language_id.",'Эрбиль'),
(1584, ".$new_language_id.",'В Ta&#39;mim'),
(1585, ".$new_language_id.",'Как Сулеймания'),
(1586, ".$new_language_id.",'Карлоу'),
(1587, ".$new_language_id.",'Каван'),
(1588, ".$new_language_id.",'Клэр'),
(1589, ".$new_language_id.",'Пробка'),
(1590, ".$new_language_id.",'Донегал'),
(1591, ".$new_language_id.",'Дублин'),
(1592, ".$new_language_id.",'Голуэй'),
(1593, ".$new_language_id.",'Керри'),
(1594, ".$new_language_id.",'Килдэр'),
(1595, ".$new_language_id.",'Килкенни'),
(1596, ".$new_language_id.",'Лиишь'),
(1597, ".$new_language_id.",'Литрим'),
(1598, ".$new_language_id.",'Лимерик'),
(1599, ".$new_language_id.",'Лонгфорд'),
(1600, ".$new_language_id.",'Лаут'),
(1601, ".$new_language_id.",'Майонез'),
(1602, ".$new_language_id.",'Мит'),
(1603, ".$new_language_id.",'Монаган'),
(1604, ".$new_language_id.",'Оффали'),
(1605, ".$new_language_id.",'Роскоммон'),
(1606, ".$new_language_id.",'Слайго'),
(1607, ".$new_language_id.",'Типперэри'),
(1608, ".$new_language_id.",'Уотерфорд'),
(1609, ".$new_language_id.",'Уэстмит'),
(1610, ".$new_language_id.",'Вексфорд'),
(1611, ".$new_language_id.",'Уиклоу'),
(1612, ".$new_language_id.",'Беэр-Шева'),
(1613, ".$new_language_id.",'Bika&#39;at Hayarden'),
(1614, ".$new_language_id.",'Эйлат и Арава'),
(1615, ".$new_language_id.",'Галиль'),
(1616, ".$new_language_id.",'Хайфа'),
(1617, ".$new_language_id.",'Иегуда Горы'),
(1618, ".$new_language_id.",'Иерусалим'),
(1619, ".$new_language_id.",'Негев'),
(1620, ".$new_language_id.",'Semaria'),
(1621, ".$new_language_id.",'Шарон'),
(1622, ".$new_language_id.",'Тель-Авив (Гоша Дан)'),
(1643, ".$new_language_id.",'Кларендон Приход'),
(1644, ".$new_language_id.",'Ганновер Приход'),
(1645, ".$new_language_id.",'Кингстон Приход'),
(1646, ".$new_language_id.",'Манчестер Приход'),
(1647, ".$new_language_id.",'Портленд Приход'),
(1648, ".$new_language_id.",'Святой Андрей Приход'),
(1649, ".$new_language_id.",'Сент-Энн волости'),
(1650, ".$new_language_id.",'Святой Екатерины Приход'),
(1651, ".$new_language_id.",'Святой Елизаветы волости'),
(1652, ".$new_language_id.",'Сент-Джеймс Приходская'),
(1653, ".$new_language_id.",'Святой Марии Приход'),
(1654, ".$new_language_id.",'Сент-Томас Приход'),
(1655, ".$new_language_id.",'Трелони Приход'),
(1656, ".$new_language_id.",'Уэстморленд Приход'),
(1657, ".$new_language_id.",'Aichi'),
(1658, ".$new_language_id.",'Акита'),
(1659, ".$new_language_id.",'Аомори'),
(1660, ".$new_language_id.",'Чиба'),
(1661, ".$new_language_id.",'Эхимэ'),
(1662, ".$new_language_id.",'Фукуи'),
(1663, ".$new_language_id.",'Фукуока'),
(1664, ".$new_language_id.",'Фукусима'),
(1665, ".$new_language_id.",'Гифу'),
(1666, ".$new_language_id.",'Гумма'),
(1667, ".$new_language_id.",'Хиросима'),
(1668, ".$new_language_id.",'Хоккайдо'),
(1669, ".$new_language_id.",'Хего'),
(1670, ".$new_language_id.",'Ибараки'),
(1671, ".$new_language_id.",'Исикава'),
(1672, ".$new_language_id.",'Иватэ'),
(1673, ".$new_language_id.",'Кагава'),
(1674, ".$new_language_id.",'Кагосима'),
(1675, ".$new_language_id.",'Канагава'),
(1676, ".$new_language_id.",'Кочи'),
(1677, ".$new_language_id.",'Кумамото'),
(1678, ".$new_language_id.",'Киото'),
(1679, ".$new_language_id.",'Мие'),
(1680, ".$new_language_id.",'Мияги'),
(1681, ".$new_language_id.",'Миядзаки'),
(1682, ".$new_language_id.",'Нагано'),
(1683, ".$new_language_id.",'Нагасаки'),
(1684, ".$new_language_id.",'Нара'),
(1685, ".$new_language_id.",'Ниигата'),
(1686, ".$new_language_id.",'Оита'),
(1687, ".$new_language_id.",'Окаяма'),
(1688, ".$new_language_id.",'Окинава'),
(1689, ".$new_language_id.",'Осака'),
(1690, ".$new_language_id.",'Сага'),
(1691, ".$new_language_id.",'Сайтама'),
(1692, ".$new_language_id.",'Сига'),
(1693, ".$new_language_id.",'Симанэ'),
(1694, ".$new_language_id.",'Сидзуока'),
(1695, ".$new_language_id.",'Точиги'),
(1696, ".$new_language_id.",'Токусима'),
(1697, ".$new_language_id.",'Токио'),
(1698, ".$new_language_id.",'Тоттори'),
(1699, ".$new_language_id.",'Тояма'),
(1700, ".$new_language_id.",'Вакаяма'),
(1701, ".$new_language_id.",'Ямагата'),
(1702, ".$new_language_id.",'Ямагучи'),
(1703, ".$new_language_id.",'Яманаси'),
(1704, ".$new_language_id.",'&quot;Амман'),
(1705, ".$new_language_id.",'Аджлун'),
(1706, ".$new_language_id.",'Аль &#39;Aqabah'),
(1707, ".$new_language_id.",'Аль Балка &#39;'),
(1708, ".$new_language_id.",'Эль-Карак'),
(1709, ".$new_language_id.",'Аль Mafraq'),
(1710, ".$new_language_id.",'В Ţafīlah'),
(1711, ".$new_language_id.",'Аз-Зарка &quot;'),
(1712, ".$new_language_id.",'Ирбид'),
(1713, ".$new_language_id.",'Jarash'),
(1714, ".$new_language_id.",'Маан'),
(1715, ".$new_language_id.",'Мадаба'),
(1716, ".$new_language_id.",'Алматы'),
(1717, ".$new_language_id.",'Г. Алматы'),
(1718, ".$new_language_id.",'Акмолинская'),
(1719, ".$new_language_id.",'Актюбинская'),
(1720, ".$new_language_id.",'Астана'),
(1721, ".$new_language_id.",'Атырау'),
(1722, ".$new_language_id.",'Батыс Qazaqstan'),
(1723, ".$new_language_id.",'Bayqongyr Город'),
(1724, ".$new_language_id.",'Мангистауская обл'),
(1725, ".$new_language_id.",'Ongtustik Qazaqstan'),
(1726, ".$new_language_id.",'Павлодар'),
(1727, ".$new_language_id.",'Караганда'),
(1728, ".$new_language_id.",'Костанай'),
(1729, ".$new_language_id.",'Кызылординская'),
(1730, ".$new_language_id.",'Shyghys Qazaqstan'),
(1731, ".$new_language_id.",'Soltustik Qazaqstan'),
(1732, ".$new_language_id.",'Жамбылская'),
(1733, ".$new_language_id.",'Центральный'),
(1734, ".$new_language_id.",'Побережье'),
(1735, ".$new_language_id.",'Восточный'),
(1736, ".$new_language_id.",'Найроби Площадь'),
(1737, ".$new_language_id.",'Северо-Восточная'),
(1738, ".$new_language_id.",'Nyanza'),
(1739, ".$new_language_id.",'Рифтовая долина'),
(1740, ".$new_language_id.",'Западный'),
(1741, ".$new_language_id.",'Abaiang'),
(1742, ".$new_language_id.",'Абемама'),
(1743, ".$new_language_id.",'Aranuka'),
(1744, ".$new_language_id.",'Arorae'),
(1745, ".$new_language_id.",'Банаба'),
(1746, ".$new_language_id.",'Беру'),
(1747, ".$new_language_id.",'Бутаритари'),
(1748, ".$new_language_id.",'Кантон'),
(1749, ".$new_language_id.",'Kiritimati'),
(1750, ".$new_language_id.",'Курия'),
(1751, ".$new_language_id.",'Maiana'),
(1752, ".$new_language_id.",'Макин'),
(1753, ".$new_language_id.",'Marakei'),
(1754, ".$new_language_id.",'Nikunau'),
(1755, ".$new_language_id.",'Nonouti'),
(1756, ".$new_language_id.",'Onotoa'),
(1757, ".$new_language_id.",'Tabiteuea'),
(1758, ".$new_language_id.",'Tabuaeran'),
(1759, ".$new_language_id.",'Tamana'),
(1760, ".$new_language_id.",'Тарава'),
(1761, ".$new_language_id.",'Teraina'),
(1762, ".$new_language_id.",'Чагандо'),
(1763, ".$new_language_id.",'Хамген-bukto'),
(1764, ".$new_language_id.",'Хамген-Намдо'),
(1765, ".$new_language_id.",'Хванхэ-bukto'),
(1766, ".$new_language_id.",'Хванхэ-Намдо'),
(1767, ".$new_language_id.",'Кангвон-ду'),
(1768, ".$new_language_id.",'Пхеньян bukto'),
(1769, ".$new_language_id.",'Пхеньян Намдо'),
(1770, ".$new_language_id.",'Ryanggang-до (Yanggang-до)'),
(1771, ".$new_language_id.",'Расон Непосредственно Руководствуясь Город'),
(1772, ".$new_language_id.",'Пхеньян Город особого'),
(1773, ".$new_language_id.",'Ch&#39;ungch&#39;ong-bukto'),
(1774, ".$new_language_id.",'Ch&#39;ungch&#39;ong-Намдо'),
(1775, ".$new_language_id.",'Чеджу-до'),
(1776, ".$new_language_id.",'Чолла-bukto'),
(1777, ".$new_language_id.",'Чолла-Намдо'),
(1778, ".$new_language_id.",'Чемульпо-gwangyoksi'),
(1779, ".$new_language_id.",'Кангвон-ду'),
(1780, ".$new_language_id.",'Кванджу-gwangyoksi'),
(1781, ".$new_language_id.",'Kyonggi-до'),
(1782, ".$new_language_id.",'Кенсан-bukto'),
(1783, ".$new_language_id.",'Кенсан-Намдо'),
(1784, ".$new_language_id.",'Пусан-gwangyoksi'),
(1785, ".$new_language_id.",'Soul-t&#39;ukpyolsi'),
(1786, ".$new_language_id.",'Тэгу-gwangyoksi'),
(1787, ".$new_language_id.",'Тэджон-gwangyoksi'),
(1788, ".$new_language_id.",'Al &#39;Asimah'),
(1789, ".$new_language_id.",'Эль-Ахмади'),
(1790, ".$new_language_id.",'Эль-Фарвания'),
(1791, ".$new_language_id.",'Эль-Джахра »'),
(1792, ".$new_language_id.",'Хавалли'),
(1793, ".$new_language_id.",'Бишкек'),
(1794, ".$new_language_id.",'Баткен'),
(1795, ".$new_language_id.",'Чу'),
(1796, ".$new_language_id.",'Джалал-Абад'),
(1797, ".$new_language_id.",'Нарын'),
(1798, ".$new_language_id.",'Ош'),
(1799, ".$new_language_id.",'Талас'),
(1800, ".$new_language_id.",'Ысык-Кол'),
(1801, ".$new_language_id.",'Вьентьян'),
(1802, ".$new_language_id.",'Attapu'),
(1803, ".$new_language_id.",'Бокео'),
(1804, ".$new_language_id.",'Bolikhamxai'),
(1805, ".$new_language_id.",'Champasak'),
(1806, ".$new_language_id.",'Хуапхан'),
(1807, ".$new_language_id.",'Khammouan'),
(1808, ".$new_language_id.",'Louang Namtha'),
(1809, ".$new_language_id.",'Луангпхабанг'),
(1810, ".$new_language_id.",'Oudomxai'),
(1811, ".$new_language_id.",'Phongsali'),
(1812, ".$new_language_id.",'Салаван'),
(1813, ".$new_language_id.",'Саваннакхет'),
(1814, ".$new_language_id.",'Вьентьян'),
(1815, ".$new_language_id.",'Xaignabouli'),
(1816, ".$new_language_id.",'Xekong'),
(1817, ".$new_language_id.",'Xiangkhoang'),
(1818, ".$new_language_id.",'Xaisomboun'),
(1819, ".$new_language_id.",'Aizkraukles Rajons'),
(1820, ".$new_language_id.",'Aluksnes Rajons'),
(1821, ".$new_language_id.",'Balvu Rajons'),
(1822, ".$new_language_id.",'Bauskas Rajons'),
(1823, ".$new_language_id.",'Cesu Rajons'),
(1824, ".$new_language_id.",'Даугавпилс Rajons'),
(1825, ".$new_language_id.",'Dobeles Rajons'),
(1826, ".$new_language_id.",'Gulbenes Rajons'),
(1827, ".$new_language_id.",'Екабпилс Rajons'),
(1828, ".$new_language_id.",'Jelgavas Rajons'),
(1829, ".$new_language_id.",'Krāslavas Rajons'),
(1830, ".$new_language_id.",'Kuldigas Rajons'),
(1831, ".$new_language_id.",'Лиепаяс Rajons'),
(1832, ".$new_language_id.",'LIMBAŽU Rajons'),
(1833, ".$new_language_id.",'Ludzas Rajons'),
(1834, ".$new_language_id.",'Madonas Rajons'),
(1835, ".$new_language_id.",'Ogres Rajons'),
(1836, ".$new_language_id.",'Preilu Rajons'),
(1837, ".$new_language_id.",'Rezeknes Rajons'),
(1838, ".$new_language_id.",'Рижский Rajons'),
(1839, ".$new_language_id.",'Салдус Rajons'),
(1840, ".$new_language_id.",'Talsu Rajons'),
(1841, ".$new_language_id.",'Tukuma Rajons'),
(1842, ".$new_language_id.",'Valkas Rajons'),
(1843, ".$new_language_id.",'Valmieras Rajons'),
(1844, ".$new_language_id.",'Вентспилс Rajons'),
(1845, ".$new_language_id.",'Даугавпилс'),
(1846, ".$new_language_id.",'Елгава'),
(1847, ".$new_language_id.",'Юрмала'),
(1848, ".$new_language_id.",'Лиепая'),
(1849, ".$new_language_id.",'Резекне'),
(1850, ".$new_language_id.",'Рига'),
(1851, ".$new_language_id.",'Вентспилс'),
(1852, ".$new_language_id.",'Береа'),
(1853, ".$new_language_id.",'Бута-Буте'),
(1854, ".$new_language_id.",'Лерибе'),
(1855, ".$new_language_id.",'Мафетенг'),
(1856, ".$new_language_id.",'Масеру'),
(1857, ".$new_language_id.",'Хук Mohale в'),
(1858, ".$new_language_id.",'Мокхотлонг'),
(1859, ".$new_language_id.",'Нек Qacha в'),
(1860, ".$new_language_id.",'Цгутинг'),
(1861, ".$new_language_id.",'Thaba-Tseka'),
(1862, ".$new_language_id.",'Боми'),
(1863, ".$new_language_id.",'Бонг'),
(1864, ".$new_language_id.",'Гранд Басса'),
(1865, ".$new_language_id.",'Гранд-Кейп-Маунт'),
(1866, ".$new_language_id.",'Гранд-Геде'),
(1867, ".$new_language_id.",'Гранд-Кру'),
(1868, ".$new_language_id.",'Лофа'),
(1869, ".$new_language_id.",'Маргиби'),
(1870, ".$new_language_id.",'Мэриленд'),
(1871, ".$new_language_id.",'Montserrado'),
(1872, ".$new_language_id.",'Nimba'),
(1873, ".$new_language_id.",'Ривер-Сесс'),
(1874, ".$new_language_id.",'Сино'),
(1875, ".$new_language_id.",'Адждабия'),
(1876, ".$new_language_id.",'Al &#39;Азизия'),
(1877, ".$new_language_id.",'Аль Фатих'),
(1878, ".$new_language_id.",'Эль-Джебель-аль Ахдар'),
(1879, ".$new_language_id.",'Аль Jufrah'),
(1880, ".$new_language_id.",'Аль Khums'),
(1881, ".$new_language_id.",'Аль Kufrah'),
(1882, ".$new_language_id.",'Nuqat др. Кам'),
(1883, ".$new_language_id.",'Эш Шати'),
(1884, ".$new_language_id.",'Awbari'),
(1885, ".$new_language_id.",'Аз Завия'),
(1886, ".$new_language_id.",'Banghazi'),
(1887, ".$new_language_id.",'Дерна'),
(1888, ".$new_language_id.",'Ghadamis'),
(1889, ".$new_language_id.",'Гариан'),
(1890, ".$new_language_id.",'Misratah'),
(1891, ".$new_language_id.",'Murzuq'),
(1892, ".$new_language_id.",'Сабха'),
(1893, ".$new_language_id.",'Sawfajjin'),
(1894, ".$new_language_id.",'Сурт'),
(1895, ".$new_language_id.",'Tarabulus (Триполи)'),
(1896, ".$new_language_id.",'Тархуна'),
(1897, ".$new_language_id.",'Тобрук'),
(1898, ".$new_language_id.",'Yafran'),
(1899, ".$new_language_id.",'Zlitan'),
(1900, ".$new_language_id.",'Вадуц'),
(1901, ".$new_language_id.",'Шаан'),
(1902, ".$new_language_id.",'Бальцерс'),
(1903, ".$new_language_id.",'Тризен'),
(1904, ".$new_language_id.",'Эшен'),
(1905, ".$new_language_id.",'Маурен'),
(1906, ".$new_language_id.",'Тризенберг'),
(1907, ".$new_language_id.",'Ruggell'),
(1908, ".$new_language_id.",'Gamprin'),
(1909, ".$new_language_id.",'Шелленберг'),
(1910, ".$new_language_id.",'Planken'),
(1911, ".$new_language_id.",'Алитус'),
(1912, ".$new_language_id.",'Каунас'),
(1913, ".$new_language_id.",'Клайпеда'),
(1914, ".$new_language_id.",'Мариямполе'),
(1915, ".$new_language_id.",'Паневежис'),
(1916, ".$new_language_id.",'Шяуляй'),
(1917, ".$new_language_id.",'Таураге'),
(1918, ".$new_language_id.",'Тельшяй'),
(1919, ".$new_language_id.",'Утена'),
(1920, ".$new_language_id.",'Вильнюс'),
(1921, ".$new_language_id.",'Дикирх'),
(1922, ".$new_language_id.",'Клерво'),
(1923, ".$new_language_id.",'Redange'),
(1924, ".$new_language_id.",'Вианден'),
(1925, ".$new_language_id.",'Wiltz'),
(1926, ".$new_language_id.",'Гревенмахер'),
(1927, ".$new_language_id.",'Эхтернах'),
(1928, ".$new_language_id.",'Ремич'),
(1929, ".$new_language_id.",'Люксембург'),
(1930, ".$new_language_id.",'Capellen'),
(1931, ".$new_language_id.",'Эш-сюр-Alzette'),
(1932, ".$new_language_id.",'Мерш'),
(1933, ".$new_language_id.",'Богоматерь Фатимы Приход'),
(1934, ".$new_language_id.",'Святой Антоний Приход'),
(1935, ".$new_language_id.",'Св. Лазаря Приход'),
(1936, ".$new_language_id.",'Собор Приход'),
(1937, ".$new_language_id.",'Св. Лаврентия Приход'),
(1938, ".$new_language_id.",'Антананариву'),
(1939, ".$new_language_id.",'Анциранана'),
(1940, ".$new_language_id.",'Fianarantsoa'),
(1941, ".$new_language_id.",'Махадзанга'),
(1942, ".$new_language_id.",'Toamasina'),
(1943, ".$new_language_id.",'Toliara'),
(1944, ".$new_language_id.",'Balaka'),
(1945, ".$new_language_id.",'Блантайр'),
(1946, ".$new_language_id.",'Чикуава'),
(1947, ".$new_language_id.",'Чирадзулу'),
(1948, ".$new_language_id.",'Читипа'),
(1949, ".$new_language_id.",'Дедза'),
(1950, ".$new_language_id.",'Доуа'),
(1951, ".$new_language_id.",'Каронга'),
(1952, ".$new_language_id.",'Касунгу'),
(1953, ".$new_language_id.",'Likoma'),
(1954, ".$new_language_id.",'Лилонгве'),
(1955, ".$new_language_id.",'Мачинга'),
(1956, ".$new_language_id.",'Мангочи'),
(1957, ".$new_language_id.",'Мчинджи'),
(1958, ".$new_language_id.",'Муланже'),
(1959, ".$new_language_id.",'Мванза'),
(1960, ".$new_language_id.",'Мзимба'),
(1961, ".$new_language_id.",'Нитчеу'),
(1962, ".$new_language_id.",'Нкхата Бай'),
(1963, ".$new_language_id.",'Нхотакота'),
(1964, ".$new_language_id.",'Нсанье'),
(1965, ".$new_language_id.",'Нтчиси'),
(1966, ".$new_language_id.",'Фаломбе'),
(1967, ".$new_language_id.",'Rumphi'),
(1968, ".$new_language_id.",'Салима'),
(1969, ".$new_language_id.",'Тиоло'),
(1970, ".$new_language_id.",'Зомба'),
(1971, ".$new_language_id.",'Джохор'),
(1972, ".$new_language_id.",'Кедах'),
(1973, ".$new_language_id.",'Келантан'),
(1974, ".$new_language_id.",'Лабуан'),
(1975, ".$new_language_id.",'Малакка'),
(1976, ".$new_language_id.",'Негери Сембилан'),
(1977, ".$new_language_id.",'Паханг'),
(1978, ".$new_language_id.",'Перак'),
(1979, ".$new_language_id.",'Перлис'),
(1980, ".$new_language_id.",'Пулау Пинанг'),
(1981, ".$new_language_id.",'Сабах'),
(1982, ".$new_language_id.",'Саравак'),
(1983, ".$new_language_id.",'Селангор'),
(1984, ".$new_language_id.",'Тренгану'),
(1985, ".$new_language_id.",'Вилайят Персекутуан'),
(1986, ".$new_language_id.",'Thiladhunmathi Uthuru'),
(1987, ".$new_language_id.",'Thiladhunmathi Dhekunu'),
(1988, ".$new_language_id.",'Miladhunmadulu Uthuru'),
(1989, ".$new_language_id.",'Miladhunmadulu Dhekunu'),
(1990, ".$new_language_id.",'Maalhosmadulu Uthuru'),
(1991, ".$new_language_id.",'Maalhosmadulu Dhekunu'),
(1992, ".$new_language_id.",'Faadhippolhu'),
(1993, ".$new_language_id.",'Мале Атолл'),
(1994, ".$new_language_id.",'Ари Атолл Uthuru'),
(1995, ".$new_language_id.",'Ари Атолл Dheknu'),
(1996, ".$new_language_id.",'Felidhe Атолл'),
(1997, ".$new_language_id.",'Мулаку Атолл'),
(1998, ".$new_language_id.",'Nilandhe Атолл Uthuru'),
(1999, ".$new_language_id.",'Nilandhe Атолл Dhekunu'),
(2000, ".$new_language_id.",'Kolhumadulu'),
(2001, ".$new_language_id.",'Hadhdhunmathi'),
(2002, ".$new_language_id.",'Huvadhu Атолл Uthuru'),
(2003, ".$new_language_id.",'Huvadhu Атолл Dhekunu'),
(2004, ".$new_language_id.",'Фуа Мулаку'),
(2005, ".$new_language_id.",'Адду'),
(2006, ".$new_language_id.",'Гао'),
(2007, ".$new_language_id.",'Кайс'),
(2008, ".$new_language_id.",'Кидал'),
(2009, ".$new_language_id.",'Куликоро'),
(2010, ".$new_language_id.",'Мопти'),
(2011, ".$new_language_id.",'Сегу'),
(2012, ".$new_language_id.",'Сикасо'),
(2013, ".$new_language_id.",'Томбукту'),
(2014, ".$new_language_id.",'Бамако столица Буэнос-Айрес'),
(2015, ".$new_language_id.",'Аттард'),
(2016, ".$new_language_id.",'Бальзан'),
(2017, ".$new_language_id.",'Биргу'),
(2018, ".$new_language_id.",'Биркиркара'),
(2019, ".$new_language_id.",'Birzebbuga'),
(2020, ".$new_language_id.",'Bormla'),
(2021, ".$new_language_id.",'Дингли'),
(2022, ".$new_language_id.",'Fgura'),
(2023, ".$new_language_id.",'Флориана'),
(2024, ".$new_language_id.",'Gudja'),
(2025, ".$new_language_id.",'Гзира'),
(2026, ".$new_language_id.",'Gargur'),
(2027, ".$new_language_id.",'Gaxaq'),
(2028, ".$new_language_id.",'Hamrun'),
(2029, ".$new_language_id.",'Iklin'),
(2030, ".$new_language_id.",'Исла'),
(2031, ".$new_language_id.",'Kalkara'),
(2032, ".$new_language_id.",'Киркоп'),
(2033, ".$new_language_id.",'Лия'),
(2034, ".$new_language_id.",'Лука'),
(2035, ".$new_language_id.",'Марса'),
(2036, ".$new_language_id.",'Marsaskala'),
(2037, ".$new_language_id.",'Марсакслокк'),
(2038, ".$new_language_id.",'Мдина'),
(2039, ".$new_language_id.",'Melliea'),
(2040, ".$new_language_id.",'Мгарр'),
(2041, ".$new_language_id.",'Моста'),
(2042, ".$new_language_id.",'Mqabba'),
(2043, ".$new_language_id.",'Мсида'),
(2044, ".$new_language_id.",'Mtarfa'),
(2045, ".$new_language_id.",'Нашшар'),
(2046, ".$new_language_id.",'Паола'),
(2047, ".$new_language_id.",'Пембрук'),
(2048, ".$new_language_id.",'Пиета'),
(2049, ".$new_language_id.",'Корми'),
(2050, ".$new_language_id.",'Qrendi'),
(2051, ".$new_language_id.",'Рабат'),
(2052, ".$new_language_id.",'Сафи'),
(2053, ".$new_language_id.",'Сан - Giljan'),
(2054, ".$new_language_id.",'Санта Луция'),
(2055, ".$new_language_id.",'Сан - Собачка иль-Бахар'),
(2056, ".$new_language_id.",'Сан - Gwann'),
(2057, ".$new_language_id.",'Санта Венера'),
(2058, ".$new_language_id.",'Сидживи'),
(2059, ".$new_language_id.",'Слима'),
(2060, ".$new_language_id.",'Свийи'),
(2061, ".$new_language_id.",'Та Xbiex'),
(2062, ".$new_language_id.",'Тарксьен'),
(2063, ".$new_language_id.",'Валлетта'),
(2064, ".$new_language_id.",'Xgajra'),
(2065, ".$new_language_id.",'Zabbar'),
(2066, ".$new_language_id.",'Зеббудж'),
(2067, ".$new_language_id.",'Зейтун'),
(2068, ".$new_language_id.",'Zurrieq'),
(2069, ".$new_language_id.",'Фонтана'),
(2070, ".$new_language_id.",'Ghajnsielem'),
(2071, ".$new_language_id.",'Гарб'),
(2072, ".$new_language_id.",'Ghasri'),
(2073, ".$new_language_id.",'Kercem'),
(2074, ".$new_language_id.",'Munxar'),
(2075, ".$new_language_id.",'Надур'),
(2076, ".$new_language_id.",'Кала'),
(2077, ".$new_language_id.",'Виктория'),
(2078, ".$new_language_id.",'Сан - Лоренц'),
(2079, ".$new_language_id.",'Sannat'),
(2080, ".$new_language_id.",'Xagra'),
(2081, ".$new_language_id.",'Шеукия'),
(2082, ".$new_language_id.",'Зеббудж'),
(2083, ".$new_language_id.",'Ailinginae'),
(2084, ".$new_language_id.",'Ailinglaplap'),
(2085, ".$new_language_id.",'Ailuk'),
(2086, ".$new_language_id.",'Арно'),
(2087, ".$new_language_id.",'Aur'),
(2088, ".$new_language_id.",'Bikar'),
(2089, ".$new_language_id.",'Бикини'),
(2090, ".$new_language_id.",'Bokak'),
(2091, ".$new_language_id.",'Эбеновый'),
(2092, ".$new_language_id.",'Эниветок'),
(2093, ".$new_language_id.",'Erikub'),
(2094, ".$new_language_id.",'Jabat'),
(2095, ".$new_language_id.",'Джалуит'),
(2096, ".$new_language_id.",'Jemo'),
(2097, ".$new_language_id.",'Кили'),
(2098, ".$new_language_id.",'Кваджалейн'),
(2099, ".$new_language_id.",'Лаэ'),
(2100, ".$new_language_id.",'Lib'),
(2101, ".$new_language_id.",'Likiep'),
(2102, ".$new_language_id.",'Маджуро'),
(2103, ".$new_language_id.",'Maloelap'),
(2104, ".$new_language_id.",'Меджит'),
(2105, ".$new_language_id.",'Мили'),
(2106, ".$new_language_id.",'Namorik'),
(2107, ".$new_language_id.",'Namu'),
(2108, ".$new_language_id.",'Ронгелап'),
(2109, ".$new_language_id.",'Rongrik'),
(2110, ".$new_language_id.",'Затяжка'),
(2111, ".$new_language_id.",'Ujae'),
(2112, ".$new_language_id.",'Уджеланг'),
(2113, ".$new_language_id.",'Utirik'),
(2114, ".$new_language_id.",'Wotho'),
(2115, ".$new_language_id.",'Wotje'),
(2116, ".$new_language_id.",'Адрар'),
(2117, ".$new_language_id.",'Ассаба'),
(2118, ".$new_language_id.",'Бракна'),
(2119, ".$new_language_id.",'Дахлет Нуадибу'),
(2120, ".$new_language_id.",'Горголь'),
(2121, ".$new_language_id.",'Guidimaka'),
(2122, ".$new_language_id.",'Ход-эш-Шарки'),
(2123, ".$new_language_id.",'Ход-эль-Гарби'),
(2124, ".$new_language_id.",'Инчири'),
(2125, ".$new_language_id.",'Тагант'),
(2126, ".$new_language_id.",'Тирис Заммур'),
(2127, ".$new_language_id.",'Трарза'),
(2128, ".$new_language_id.",'Нуакшот'),
(2129, ".$new_language_id.",'Бо Басин-Rose Hill'),
(2130, ".$new_language_id.",'Кюрпип'),
(2131, ".$new_language_id.",'Порт-Луи'),
(2132, ".$new_language_id.",'Quatre Bornes'),
(2133, ".$new_language_id.",'Vacoas-Феникс'),
(2134, ".$new_language_id.",'Агалега острова'),
(2135, ".$new_language_id.",'Каргадос Карахос Косяки (Saint Brandon острова)'),
(2136, ".$new_language_id.",'Родригес'),
(2137, ".$new_language_id.",'Черная речка'),
(2138, ".$new_language_id.",'Флак'),
(2139, ".$new_language_id.",'Гран-Порт'),
(2140, ".$new_language_id.",'Мока'),
(2141, ".$new_language_id.",'Pamplemousses'),
(2142, ".$new_language_id.",'Плен-Вилем'),
(2143, ".$new_language_id.",'Порт-Луи'),
(2144, ".$new_language_id.",'Ривьер-дю-Рампар'),
(2145, ".$new_language_id.",'Savanne'),
(2146, ".$new_language_id.",'Нижняя Калифорния Северная'),
(2147, ".$new_language_id.",'Baja California Sur'),
(2148, ".$new_language_id.",'Кампече'),
(2149, ".$new_language_id.",'Чьяпас'),
(2150, ".$new_language_id.",'Чихуахуа'),
(2151, ".$new_language_id.",'Коауила-де-Сарагоса'),
(2152, ".$new_language_id.",'Колима'),
(2153, ".$new_language_id.",'Федеральный округ'),
(2154, ".$new_language_id.",'Дуранго'),
(2155, ".$new_language_id.",'Гуанахуато'),
(2156, ".$new_language_id.",'Герреро'),
(2157, ".$new_language_id.",'Идальго'),
(2158, ".$new_language_id.",'Халиско'),
(2159, ".$new_language_id.",'Мексика'),
(2160, ".$new_language_id.",'Мичоакан-де-Окампо'),
(2161, ".$new_language_id.",'Морелос'),
(2162, ".$new_language_id.",'Наярит'),
(2163, ".$new_language_id.",'Нуэво-Леон'),
(2164, ".$new_language_id.",'Оахака'),
(2165, ".$new_language_id.",'Пуэбла'),
(2166, ".$new_language_id.",'Керетаро де-Артеага'),
(2167, ".$new_language_id.",'Кинтана-Роо'),
(2168, ".$new_language_id.",'Сан - Луис-Потоси'),
(2169, ".$new_language_id.",'Синалоа'),
(2170, ".$new_language_id.",'Сонора'),
(2171, ".$new_language_id.",'Табаско'),
(2172, ".$new_language_id.",'Тамаулипас'),
(2173, ".$new_language_id.",'Тлакскала'),
(2174, ".$new_language_id.",'Veracruz-Llave'),
(2175, ".$new_language_id.",'Юкатан'),
(2176, ".$new_language_id.",'Сакатекас'),
(2177, ".$new_language_id.",'Чуук'),
(2178, ".$new_language_id.",'Косрае'),
(2179, ".$new_language_id.",'Понпеи'),
(2180, ".$new_language_id.",'Хайло'),
(2181, ".$new_language_id.",'Гагаузия'),
(2182, ".$new_language_id.",'Кишинев'),
(2183, ".$new_language_id.",'Бельцы'),
(2184, ".$new_language_id.",'Кагул'),
(2185, ".$new_language_id.",'Единец'),
(2186, ".$new_language_id.",'Лапушна'),
(2187, ".$new_language_id.",'Оргеев'),
(2188, ".$new_language_id.",'Сорока'),
(2189, ".$new_language_id.",'Тигина'),
(2190, ".$new_language_id.",'Унгень'),
(2191, ".$new_language_id.",'St, нга Nistrului'),
(2192, ".$new_language_id.",'Фонвьей'),
(2193, ".$new_language_id.",'Кондамин'),
(2194, ".$new_language_id.",'Monaco-Ville'),
(2195, ".$new_language_id.",'Монте-Карло'),
(2196, ".$new_language_id.",'Улан-Баторе'),
(2197, ".$new_language_id.",'Орхон'),
(2198, ".$new_language_id.",'Дархан уул'),
(2199, ".$new_language_id.",'Hentiy'),
(2200, ".$new_language_id.",'Хубсугул'),
(2201, ".$new_language_id.",'Ховд'),
(2202, ".$new_language_id.",'Увс'),
(2203, ".$new_language_id.",'Тов'),
(2204, ".$new_language_id.",'Селенга'),
(2205, ".$new_language_id.",'Suhbaatar'),
(2206, ".$new_language_id.",'Omnogovi'),
(2207, ".$new_language_id.",'Ovorhangay'),
(2208, ".$new_language_id.",'Дзабханская'),
(2209, ".$new_language_id.",'DundgovL'),
(2210, ".$new_language_id.",'Дорнод'),
(2211, ".$new_language_id.",'Dornogov'),
(2212, ".$new_language_id.",'Гоби-Sumber'),
(2213, ".$new_language_id.",'Гоби-Алтай'),
(2214, ".$new_language_id.",'Булган'),
(2215, ".$new_language_id.",'Bayanhongor'),
(2216, ".$new_language_id.",'Баян-Олгий'),
(2217, ".$new_language_id.",'Arhangay'),
(2218, ".$new_language_id.",'Святой Антоний'),
(2219, ".$new_language_id.",'Saint Georges'),
(2220, ".$new_language_id.",'Святой Петр'),
(2221, ".$new_language_id.",'Агадир'),
(2222, ".$new_language_id.",'Эль-Хосейма'),
(2223, ".$new_language_id.",'Азилаль'),
(2224, ".$new_language_id.",'Бени-Меллаль'),
(2225, ".$new_language_id.",'Бен Слиман'),
(2226, ".$new_language_id.",'Boulemane'),
(2227, ".$new_language_id.",'Касабланка'),
(2228, ".$new_language_id.",'Chaouen'),
(2229, ".$new_language_id.",'Эль-Джадида'),
(2230, ".$new_language_id.",'Эль Келаа де-Срагне'),
(2231, ".$new_language_id.",'Эррачидиа'),
(2232, ".$new_language_id.",'Эс-Сувейра'),
(2233, ".$new_language_id.",'Фес'),
(2234, ".$new_language_id.",'Figuig'),
(2235, ".$new_language_id.",'Guelmim'),
(2236, ".$new_language_id.",'Ifrane'),
(2237, ".$new_language_id.",'Кенитра'),
(2238, ".$new_language_id.",'Хемиссет'),
(2239, ".$new_language_id.",'Khenifra'),
(2240, ".$new_language_id.",'Khouribga'),
(2241, ".$new_language_id.",'Эль-Аюн'),
(2242, ".$new_language_id.",'Лараша'),
(2243, ".$new_language_id.",'Марракеш'),
(2244, ".$new_language_id.",'Мекнес'),
(2245, ".$new_language_id.",'Надор'),
(2246, ".$new_language_id.",'Уарзазат'),
(2247, ".$new_language_id.",'Ужда'),
(2248, ".$new_language_id.",'Рабат-Сале'),
(2249, ".$new_language_id.",'Сафи'),
(2250, ".$new_language_id.",'Сеттат'),
(2251, ".$new_language_id.",'Сиди Касем'),
(2252, ".$new_language_id.",'Танжер'),
(2253, ".$new_language_id.",'Тан-Тан'),
(2254, ".$new_language_id.",'Таунат'),
(2255, ".$new_language_id.",'Taroudannt'),
(2256, ".$new_language_id.",'Tata'),
(2257, ".$new_language_id.",'Таза'),
(2258, ".$new_language_id.",'Tetouan'),
(2259, ".$new_language_id.",'Tiznit'),
(2260, ".$new_language_id.",'Ad Dakhla'),
(2261, ".$new_language_id.",'Буждур'),
(2262, ".$new_language_id.",'Es Смара'),
(2263, ".$new_language_id.",'Кабо Дельгадо'),
(2264, ".$new_language_id.",'Сектор Газа'),
(2265, ".$new_language_id.",'Иньямбане'),
(2266, ".$new_language_id.",'Manica'),
(2267, ".$new_language_id.",'Мапуту (город)'),
(2268, ".$new_language_id.",'Мапуту'),
(2269, ".$new_language_id.",'Нампула'),
(2270, ".$new_language_id.",'Ньяса'),
(2271, ".$new_language_id.",'Софала'),
(2272, ".$new_language_id.",'Тете'),
(2273, ".$new_language_id.",'Замбезия'),
(2274, ".$new_language_id.",'Иравади'),
(2275, ".$new_language_id.",'Пегу'),
(2276, ".$new_language_id.",'Magway'),
(2277, ".$new_language_id.",'Мандалай'),
(2278, ".$new_language_id.",'Сагайн'),
(2279, ".$new_language_id.",'Tanintharyi'),
(2280, ".$new_language_id.",'Янгон'),
(2281, ".$new_language_id.",'Чин государственный'),
(2282, ".$new_language_id.",'Качин'),
(2283, ".$new_language_id.",'Кая государственный'),
(2284, ".$new_language_id.",'Кая,'),
(2285, ".$new_language_id.",'Государственный Пн'),
(2286, ".$new_language_id.",'Ракхайн'),
(2287, ".$new_language_id.",'Шан'),
(2288, ".$new_language_id.",'Каприви'),
(2289, ".$new_language_id.",'Эронго'),
(2290, ".$new_language_id.",'Hardap'),
(2291, ".$new_language_id.",'Карась'),
(2292, ".$new_language_id.",'Каванго'),
(2293, ".$new_language_id.",'Кхомас'),
(2294, ".$new_language_id.",'Kunene'),
(2295, ".$new_language_id.",'Охангвена'),
(2296, ".$new_language_id.",'Омахеке'),
(2297, ".$new_language_id.",'Омусати'),
(2298, ".$new_language_id.",'Ошана'),
(2299, ".$new_language_id.",'Ошикото'),
(2300, ".$new_language_id.",'Очосондьюпа'),
(2301, ".$new_language_id.",'Aiwo'),
(2302, ".$new_language_id.",'Анабаро'),
(2303, ".$new_language_id.",'Anetan'),
(2304, ".$new_language_id.",'Анибаре'),
(2305, ".$new_language_id.",'Baiti'),
(2306, ".$new_language_id.",'Бо'),
(2307, ".$new_language_id.",'Buada'),
(2308, ".$new_language_id.",'Denigomodu'),
(2309, ".$new_language_id.",'Эва'),
(2310, ".$new_language_id.",'Ijuw'),
(2311, ".$new_language_id.",'Meneng'),
(2312, ".$new_language_id.",'Nibok'),
(2313, ".$new_language_id.",'Uaboe'),
(2314, ".$new_language_id.",'Ярен'),
(2315, ".$new_language_id.",'Bagmati'),
(2316, ".$new_language_id.",'Бхери'),
(2317, ".$new_language_id.",'Dhawalagiri'),
(2318, ".$new_language_id.",'Гандаки'),
(2319, ".$new_language_id.",'Джанакпур'),
(2320, ".$new_language_id.",'Karnali'),
(2321, ".$new_language_id.",'Коси'),
(2322, ".$new_language_id.",'Лумбини'),
(2323, ".$new_language_id.",'Махакали'),
(2324, ".$new_language_id.",'Мечи'),
(2325, ".$new_language_id.",'Нараяни'),
(2326, ".$new_language_id.",'Rapti'),
(2327, ".$new_language_id.",'Сагарматха'),
(2328, ".$new_language_id.",'Сети'),
(2329, ".$new_language_id.",'Дренте'),
(2330, ".$new_language_id.",'Флеволанд'),
(2331, ".$new_language_id.",'Фрисландия'),
(2332, ".$new_language_id.",'Гелдерланд'),
(2333, ".$new_language_id.",'Гронинген'),
(2334, ".$new_language_id.",'Лимбург'),
(2335, ".$new_language_id.",'Северный Брабант'),
(2336, ".$new_language_id.",'Северная Голландия'),
(2337, ".$new_language_id.",'Оверэйсел'),
(2338, ".$new_language_id.",'Утрехт'),
(2339, ".$new_language_id.",'Зеландия'),
(2340, ".$new_language_id.",'Южная Голландия'),
(2341, ".$new_language_id.",'Иль Loyaute'),
(2342, ".$new_language_id.",'Nord'),
(2343, ".$new_language_id.",'Sud'),
(2344, ".$new_language_id.",'Окленд'),
(2345, ".$new_language_id.",'Бухта Изобилия'),
(2346, ".$new_language_id.",'Кентербери'),
(2347, ".$new_language_id.",'Коромандел'),
(2348, ".$new_language_id.",'Гисборн'),
(2349, ".$new_language_id.",'Фьордленд'),
(2350, ".$new_language_id.",'Хокс-Бей'),
(2351, ".$new_language_id.",'Мальборо'),
(2352, ".$new_language_id.",'Манавату-Уангануи'),
(2353, ".$new_language_id.",'Mt Cook-Маккензи'),
(2354, ".$new_language_id.",'Нельсон'),
(2355, ".$new_language_id.",'Север'),
(2356, ".$new_language_id.",'Отаго'),
(2357, ".$new_language_id.",'Область на юге'),
(2358, ".$new_language_id.",'Таранаки'),
(2359, ".$new_language_id.",'Веллингтон'),
(2360, ".$new_language_id.",'Вайкато'),
(2361, ".$new_language_id.",'Wairprarapa'),
(2362, ".$new_language_id.",'Западное побережье'),
(2363, ".$new_language_id.",'Atlantico Norte'),
(2364, ".$new_language_id.",'Atlantico Sur'),
(2365, ".$new_language_id.",'Боако'),
(2366, ".$new_language_id.",'Carazo'),
(2367, ".$new_language_id.",'Chinandega'),
(2368, ".$new_language_id.",'Чонталес'),
(2369, ".$new_language_id.",'Esteli'),
(2370, ".$new_language_id.",'Гранада'),
(2371, ".$new_language_id.",'Хинотега'),
(2372, ".$new_language_id.",'Леон'),
(2373, ".$new_language_id.",'Мадрис'),
(2374, ".$new_language_id.",'Манагуа'),
(2375, ".$new_language_id.",'Масая'),
(2376, ".$new_language_id.",'Matagalpa'),
(2377, ".$new_language_id.",'Нуэво Сеговия'),
(2378, ".$new_language_id.",'Рио-Сан-Хуан'),
(2379, ".$new_language_id.",'Ривас'),
(2380, ".$new_language_id.",'Agadez'),
(2381, ".$new_language_id.",'Диффа'),
(2382, ".$new_language_id.",'Доссо'),
(2383, ".$new_language_id.",'Маради'),
(2384, ".$new_language_id.",'Ниамей'),
(2385, ".$new_language_id.",'Тахуа'),
(2386, ".$new_language_id.",'Тиллабери'),
(2387, ".$new_language_id.",'Зиндер'),
(2388, ".$new_language_id.",'Авия'),
(2389, ".$new_language_id.",'Абуджа Федеральный столичный округ'),
(2390, ".$new_language_id.",'Адамава'),
(2391, ".$new_language_id.",'Аква-Ибом'),
(2392, ".$new_language_id.",'Анамбра'),
(2393, ".$new_language_id.",'Баучи'),
(2394, ".$new_language_id.",'Bayelsa'),
(2395, ".$new_language_id.",'Бенуэ'),
(2396, ".$new_language_id.",'Борно'),
(2397, ".$new_language_id.",'Кросс-Ривер'),
(2398, ".$new_language_id.",'Дельта'),
(2399, ".$new_language_id.",'Эбоний'),
(2400, ".$new_language_id.",'Эдо'),
(2401, ".$new_language_id.",'Экити'),
(2402, ".$new_language_id.",'Энугу'),
(2403, ".$new_language_id.",'Гомбе'),
(2404, ".$new_language_id.",'Имо'),
(2405, ".$new_language_id.",'Джигава'),
(2406, ".$new_language_id.",'Кадуна'),
(2407, ".$new_language_id.",'Кано'),
(2408, ".$new_language_id.",'Кацина'),
(2409, ".$new_language_id.",'Kebbi'),
(2410, ".$new_language_id.",'Коги'),
(2411, ".$new_language_id.",'Kwara'),
(2412, ".$new_language_id.",'Лагос'),
(2413, ".$new_language_id.",'Nassarawa'),
(2414, ".$new_language_id.",'Нигер'),
(2415, ".$new_language_id.",'Огун'),
(2416, ".$new_language_id.",'Ондо'),
(2417, ".$new_language_id.",'Osun'),
(2418, ".$new_language_id.",'Ойо'),
(2419, ".$new_language_id.",'Плато'),
(2420, ".$new_language_id.",'Реки'),
(2421, ".$new_language_id.",'Сокото'),
(2422, ".$new_language_id.",'Taraba'),
(2423, ".$new_language_id.",'Yobe'),
(2424, ".$new_language_id.",'Zamfara'),
(2425, ".$new_language_id.",'Northern Islands'),
(2426, ".$new_language_id.",'Расписание дежурств'),
(2427, ".$new_language_id.",'Сайпан'),
(2428, ".$new_language_id.",'Тиниан'),
(2429, ".$new_language_id.",'Акерсхус'),
(2430, ".$new_language_id.",'Aust-Agder'),
(2431, ".$new_language_id.",'Бускеруд'),
(2432, ".$new_language_id.",'Финнмарк'),
(2433, ".$new_language_id.",'Хедмарк'),
(2434, ".$new_language_id.",'Хордаланн'),
(2435, ".$new_language_id.",'Мере-ог-Romdal'),
(2436, ".$new_language_id.",'Нур-Тренделаг'),
(2437, ".$new_language_id.",'Nordland'),
(2438, ".$new_language_id.",'Эстфолл'),
(2439, ".$new_language_id.",'Оппланд'),
(2440, ".$new_language_id.",'Осло'),
(2441, ".$new_language_id.",'Рогаланд'),
(2442, ".$new_language_id.",'Сер-Тренделаг'),
(2443, ".$new_language_id.",'Согн-ог-Фьюране'),
(2444, ".$new_language_id.",'Шпицберген'),
(2445, ".$new_language_id.",'Телемарк'),
(2446, ".$new_language_id.",'Тромс'),
(2447, ".$new_language_id.",'Вест-Агдер'),
(2448, ".$new_language_id.",'Вестфолл'),
(2449, ".$new_language_id.",'Эд-Дахилия'),
(2450, ".$new_language_id.",'Эль-Батина'),
(2451, ".$new_language_id.",'Эль-Вуста'),
(2452, ".$new_language_id.",'Эш-Шаркия'),
(2453, ".$new_language_id.",'Аз Zahirah'),
(2454, ".$new_language_id.",'Маскат'),
(2455, ".$new_language_id.",'Мусандам'),
(2456, ".$new_language_id.",'Зуфар'),
(2457, ".$new_language_id.",'Белуджистан'),
(2458, ".$new_language_id.",'Федерально управляемой территории племен'),
(2459, ".$new_language_id.",'Исламабад столичная территория'),
(2460, ".$new_language_id.",'Северо-Западной пограничной'),
(2461, ".$new_language_id.",'Пенджаб'),
(2462, ".$new_language_id.",'Синд'),
(2463, ".$new_language_id.",'Aimeliik'),
(2464, ".$new_language_id.",'Airai'),
(2465, ".$new_language_id.",'Ангуар'),
(2466, ".$new_language_id.",'Hatohobei'),
(2467, ".$new_language_id.",'Kayangel'),
(2468, ".$new_language_id.",'Корор'),
(2469, ".$new_language_id.",'Мелекеок'),
(2470, ".$new_language_id.",'Ngaraard'),
(2471, ".$new_language_id.",'Ngarchelong'),
(2472, ".$new_language_id.",'Ngardmau'),
(2473, ".$new_language_id.",'Ngatpang'),
(2474, ".$new_language_id.",'Ngchesar'),
(2475, ".$new_language_id.",'Ngeremlengui'),
(2476, ".$new_language_id.",'Ngiwal'),
(2477, ".$new_language_id.",'Peleliu'),
(2478, ".$new_language_id.",'Sonsorol'),
(2479, ".$new_language_id.",'Бокас-дель-Торо'),
(2480, ".$new_language_id.",'Чирики'),
(2481, ".$new_language_id.",'Cocle'),
(2482, ".$new_language_id.",'Двоеточие'),
(2483, ".$new_language_id.",'Дарьен'),
(2484, ".$new_language_id.",'Эррера'),
(2485, ".$new_language_id.",'Лос-Сантос'),
(2486, ".$new_language_id.",'Панама'),
(2487, ".$new_language_id.",'Сан - Блас'),
(2488, ".$new_language_id.",'Veraguas'),
(2489, ".$new_language_id.",'Бугенвиль'),
(2490, ".$new_language_id.",'Центральный'),
(2491, ".$new_language_id.",'Chimbu'),
(2492, ".$new_language_id.",'Восточное нагорье'),
(2493, ".$new_language_id.",'Восточная Новая Британия'),
(2494, ".$new_language_id.",'Восток Сепик'),
(2495, ".$new_language_id.",'Энга'),
(2496, ".$new_language_id.",'Пропасть'),
(2497, ".$new_language_id.",'Маданг'),
(2498, ".$new_language_id.",'Манус'),
(2499, ".$new_language_id.",'Милн-Бэй'),
(2500, ".$new_language_id.",'Morobe'),
(2501, ".$new_language_id.",'Национальный столичный'),
(2502, ".$new_language_id.",'Новая Ирландия'),
(2503, ".$new_language_id.",'Северный'),
(2504, ".$new_language_id.",'Sandaun'),
(2505, ".$new_language_id.",'Southern Highlands'),
(2506, ".$new_language_id.",'Западный'),
(2507, ".$new_language_id.",'Western Highlands'),
(2508, ".$new_language_id.",'Западная Новая Британия'),
(2509, ".$new_language_id.",'Альто Парагвай'),
(2510, ".$new_language_id.",'Альто Парана'),
(2511, ".$new_language_id.",'Амамбай'),
(2512, ".$new_language_id.",'Асунсьон'),
(2513, ".$new_language_id.",'Boqueron'),
(2514, ".$new_language_id.",'Caaguazu'),
(2515, ".$new_language_id.",'Caazapa'),
(2516, ".$new_language_id.",'Canindeyú'),
(2517, ".$new_language_id.",'Центральный'),
(2518, ".$new_language_id.",'Консепсьон'),
(2519, ".$new_language_id.",'Подводная горная система'),
(2520, ".$new_language_id.",'Гуайра'),
(2521, ".$new_language_id.",'Itapua'),
(2522, ".$new_language_id.",'Мисьонес'),
(2523, ".$new_language_id.",'Ñeembucú'),
(2524, ".$new_language_id.",'Парагуари'),
(2525, ".$new_language_id.",'Presidente Hayes'),
(2526, ".$new_language_id.",'Сан - Педро'),
(2527, ".$new_language_id.",'Amazonas'),
(2528, ".$new_language_id.",'Ancash'),
(2529, ".$new_language_id.",'Апуримак'),
(2530, ".$new_language_id.",'Арекипа'),
(2531, ".$new_language_id.",'Аякучо'),
(2532, ".$new_language_id.",'Кахамарка'),
(2533, ".$new_language_id.",'Кальяо'),
(2534, ".$new_language_id.",'Куско'),
(2535, ".$new_language_id.",'Уанкавелика'),
(2536, ".$new_language_id.",'Уануко'),
(2537, ".$new_language_id.",'Ика'),
(2538, ".$new_language_id.",'Хунин'),
(2539, ".$new_language_id.",'Ла-Либертад'),
(2540, ".$new_language_id.",'Lambayeque'),
(2541, ".$new_language_id.",'Лима'),
(2542, ".$new_language_id.",'Лорето'),
(2543, ".$new_language_id.",'Мадре-де-Диос'),
(2544, ".$new_language_id.",'Мокегуа'),
(2545, ".$new_language_id.",'Паско'),
(2546, ".$new_language_id.",'Piura'),
(2547, ".$new_language_id.",'Пуно'),
(2548, ".$new_language_id.",'Сан - Мартин'),
(2549, ".$new_language_id.",'Такна'),
(2550, ".$new_language_id.",'Tumbes'),
(2551, ".$new_language_id.",'Укаяли'),
(2552, ".$new_language_id.",'Абра'),
(2553, ".$new_language_id.",'Агусан-дель-Норте'),
(2554, ".$new_language_id.",'Агусан-дель-Сур'),
(2555, ".$new_language_id.",'Аклан'),
(2556, ".$new_language_id.",'Албай'),
(2557, ".$new_language_id.",'Античный'),
(2558, ".$new_language_id.",'Apayao'),
(2559, ".$new_language_id.",'Аврора'),
(2560, ".$new_language_id.",'Basilan'),
(2561, ".$new_language_id.",'Bataan'),
(2562, ".$new_language_id.",'Batanes'),
(2563, ".$new_language_id.",'Батангас'),
(2564, ".$new_language_id.",'Biliran'),
(2565, ".$new_language_id.",'Benguet'),
(2566, ".$new_language_id.",'Бохол'),
(2567, ".$new_language_id.",'Bukidnon'),
(2568, ".$new_language_id.",'Bulacan'),
(2569, ".$new_language_id.",'Кагаян'),
(2570, ".$new_language_id.",'Камаринес Норте'),
(2571, ".$new_language_id.",'Камаринес Сур'),
(2572, ".$new_language_id.",'Камигуин'),
(2573, ".$new_language_id.",'Capiz'),
(2574, ".$new_language_id.",'Catanduanes'),
(2575, ".$new_language_id.",'Кавите'),
(2576, ".$new_language_id.",'Себу'),
(2577, ".$new_language_id.",'Компостела'),
(2578, ".$new_language_id.",'Давао-дель-Норте'),
(2579, ".$new_language_id.",'Давао-дель-Сур'),
(2580, ".$new_language_id.",'Давао Восточный'),
(2581, ".$new_language_id.",'Eastern Samar'),
(2582, ".$new_language_id.",'Guimaras'),
(2583, ".$new_language_id.",'Ifugao'),
(2584, ".$new_language_id.",'Северный Илокос'),
(2585, ".$new_language_id.",'Ilocos Sur'),
(2586, ".$new_language_id.",'Илоило'),
(2587, ".$new_language_id.",'Изабела'),
(2588, ".$new_language_id.",'Калинги'),
(2589, ".$new_language_id.",'Пруд'),
(2590, ".$new_language_id.",'Lanao-дель-Норте'),
(2591, ".$new_language_id.",'Lanao-дель-Сур'),
(2592, ".$new_language_id.",'La Union'),
(2593, ".$new_language_id.",'Лейте'),
(2594, ".$new_language_id.",'Магинданао'),
(2595, ".$new_language_id.",'Marinduque'),
(2596, ".$new_language_id.",'Масбате'),
(2597, ".$new_language_id.",'Миндоро Occidental'),
(2598, ".$new_language_id.",'Миндоро Восточный'),
(2599, ".$new_language_id.",'Misamis Occidental'),
(2600, ".$new_language_id.",'Misamis Восточный'),
(2601, ".$new_language_id.",'Гора'),
(2602, ".$new_language_id.",'Западный Негрос'),
(2603, ".$new_language_id.",'Восточный Негрос'),
(2604, ".$new_language_id.",'Северная Котабато'),
(2605, ".$new_language_id.",'Northern Samar'),
(2606, ".$new_language_id.",'Nueva Ecija'),
(2607, ".$new_language_id.",'Нуэва Бискайя'),
(2608, ".$new_language_id.",'Палаван'),
(2609, ".$new_language_id.",'Пампанга'),
(2610, ".$new_language_id.",'Пангасинан'),
(2611, ".$new_language_id.",'Кесон'),
(2612, ".$new_language_id.",'Кирино'),
(2613, ".$new_language_id.",'Ризал'),
(2614, ".$new_language_id.",'Ромблон'),
(2615, ".$new_language_id.",'Самар'),
(2616, ".$new_language_id.",'Сарангани'),
(2617, ".$new_language_id.",'Сикихор'),
(2618, ".$new_language_id.",'Сорсогон'),
(2619, ".$new_language_id.",'Южная Котабато'),
(2620, ".$new_language_id.",'Южный Лейте'),
(2621, ".$new_language_id.",'Султан Kudarat'),
(2622, ".$new_language_id.",'Сулу'),
(2623, ".$new_language_id.",'Суригао-дель-Норте'),
(2624, ".$new_language_id.",'Суригао-дель-Сур'),
(2625, ".$new_language_id.",'Тарлач'),
(2626, ".$new_language_id.",'Тави-Тави'),
(2627, ".$new_language_id.",'Замбалес'),
(2628, ".$new_language_id.",'Замбоанга дель Норте'),
(2629, ".$new_language_id.",'Замбоанга дель Сур'),
(2630, ".$new_language_id.",'Замбоанга Sibugay'),
(2631, ".$new_language_id.",'Нижнесилезское'),
(2632, ".$new_language_id.",'Куявско-Поморское'),
(2633, ".$new_language_id.",'Лодзинское воеводство'),
(2634, ".$new_language_id.",'Люблинское'),
(2635, ".$new_language_id.",'Любушское'),
(2636, ".$new_language_id.",'Малопольское'),
(2637, ".$new_language_id.",'Мазовецкое'),
(2638, ".$new_language_id.",'Опольское'),
(2639, ".$new_language_id.",'Подкарпатское'),
(2640, ".$new_language_id.",'Подляское'),
(2641, ".$new_language_id.",'Поморское'),
(2642, ".$new_language_id.",'Силезское'),
(2643, ".$new_language_id.",'Свентокшишское'),
(2644, ".$new_language_id.",'Варминско-Мазурское'),
(2645, ".$new_language_id.",'Великопольское'),
(2646, ".$new_language_id.",'Западно-Поморское'),
(2647, ".$new_language_id.",'Сен-Пьер'),
(2648, ".$new_language_id.",'Микелон'),
(2649, ".$new_language_id.",'Açores'),
(2650, ".$new_language_id.",'Авейру'),
(2651, ".$new_language_id.",'Беджа'),
(2652, ".$new_language_id.",'Брага'),
(2653, ".$new_language_id.",'Браганса'),
(2654, ".$new_language_id.",'Каштелу-Бранку'),
(2655, ".$new_language_id.",'Коимбра'),
(2656, ".$new_language_id.",'Эвора'),
(2657, ".$new_language_id.",'Фараон'),
(2658, ".$new_language_id.",'Guarda'),
(2659, ".$new_language_id.",'Лейрия'),
(2660, ".$new_language_id.",'Lisboa'),
(2661, ".$new_language_id.",'Мадера'),
(2662, ".$new_language_id.",'Порталегре'),
(2663, ".$new_language_id.",'Порту'),
(2664, ".$new_language_id.",'Santarém'),
(2665, ".$new_language_id.",'Сетубал'),
(2666, ".$new_language_id.",'Виана-ду-Каштелу'),
(2667, ".$new_language_id.",'Вила-Реал'),
(2668, ".$new_language_id.",'Визеу'),
(2669, ".$new_language_id.",'Ad Dawhah'),
(2670, ".$new_language_id.",'Аль Ghuwayriyah'),
(2671, ".$new_language_id.",'Аль Jumayliyah'),
(2672, ".$new_language_id.",'Аль-Хор'),
(2673, ".$new_language_id.",'Аль-Вакрах'),
(2674, ".$new_language_id.",'Ar-Райян'),
(2675, ".$new_language_id.",'Jarayan Эль-Батина'),
(2676, ".$new_language_id.",'Мадинат пепел Shamal'),
(2677, ".$new_language_id.",'Умм Саид'),
(2678, ".$new_language_id.",'Умм Салал'),
(2679, ".$new_language_id.",'Альба'),
(2680, ".$new_language_id.",'Арад'),
(2681, ".$new_language_id.",'Арджеш'),
(2682, ".$new_language_id.",'Бакэу'),
(2683, ".$new_language_id.",'Бихор'),
(2684, ".$new_language_id.",'Бистрица-Нэсэуд'),
(2685, ".$new_language_id.",'Ботошани'),
(2686, ".$new_language_id.",'Брашов'),
(2687, ".$new_language_id.",'Браила'),
(2688, ".$new_language_id.",'Бухарест'),
(2689, ".$new_language_id.",'Бузэу'),
(2690, ".$new_language_id.",'Карас-Северин'),
(2691, ".$new_language_id.",'Калараш'),
(2692, ".$new_language_id.",'Клуж'),
(2693, ".$new_language_id.",'Констанца'),
(2694, ".$new_language_id.",'Ковасна'),
(2695, ".$new_language_id.",'Dimbovita'),
(2696, ".$new_language_id.",'Dolj'),
(2697, ".$new_language_id.",'Галац'),
(2698, ".$new_language_id.",'Джурджу'),
(2699, ".$new_language_id.",'Горж'),
(2700, ".$new_language_id.",'Харгита'),
(2701, ".$new_language_id.",'Хунедоара'),
(2702, ".$new_language_id.",'Ialomita'),
(2703, ".$new_language_id.",'Яссы'),
(2704, ".$new_language_id.",'Илфов'),
(2705, ".$new_language_id.",'Марамуреш'),
(2706, ".$new_language_id.",'Mehedinti'),
(2707, ".$new_language_id.",'Муреш'),
(2708, ".$new_language_id.",'Нямц'),
(2709, ".$new_language_id.",'Олт'),
(2710, ".$new_language_id.",'Прахова'),
(2711, ".$new_language_id.",'Сату-Маре'),
(2712, ".$new_language_id.",'Salaj'),
(2713, ".$new_language_id.",'Сибиу'),
(2714, ".$new_language_id.",'Сучава'),
(2715, ".$new_language_id.",'Teleorman'),
(2716, ".$new_language_id.",'Timis'),
(2717, ".$new_language_id.",'Тулча'),
(2718, ".$new_language_id.",'Васлуй'),
(2719, ".$new_language_id.",'Вылча'),
(2720, ".$new_language_id.",'Вранча'),
(2721, ".$new_language_id.",'Республика Хакасия'),
(2722, ".$new_language_id.",'Агинский Бурятский AO'),
(2723, ".$new_language_id.",'Чукотский АО'),
(2724, ".$new_language_id.",'Архангельская область'),
(2725, ".$new_language_id.",'Астраханская область'),
(2726, ".$new_language_id.",'Алтайский край'),
(2727, ".$new_language_id.",'Белгородская область'),
(2728, ".$new_language_id.",'Еврейская АО'),
(2729, ".$new_language_id.",'Амурская область'),
(2730, ".$new_language_id.",'Брянская область'),
(2731, ".$new_language_id.",'Брянская область'),
(2732, ".$new_language_id.",'Челябинская область'),
(2733, ".$new_language_id.",'Карачаево-Черкеcсия'),
(2734, ".$new_language_id.",'Забайкальский край'),
(2735, ".$new_language_id.",'Таймырский (Долгано-Ненецкий) АО'),
(2736, ".$new_language_id.",'Республика Калмыкия'),
(2737, ".$new_language_id.",'Московская область'),
(2738, ".$new_language_id.",'Республика Алтай'),
(2739, ".$new_language_id.",'Чеченская Республика'),
(2740, ".$new_language_id.",'Иркутская область'),
(2741, ".$new_language_id.",'Ивановская область'),
(2742, ".$new_language_id.",'Удмуртская Республика'),
(2743, ".$new_language_id.",'Калининградская область'),
(2744, ".$new_language_id.",'Калужская область'),
(2745, ".$new_language_id.",'Кировская область'),
(2746, ".$new_language_id.",'Республика Татарстан'),
(2747, ".$new_language_id.",'Кемеровская область'),
(2748, ".$new_language_id.",'Хабаровский край'),
(2749, ".$new_language_id.",'Ханты-Мансийский АО - Югра'),
(2750, ".$new_language_id.",'Костромская область'),
(2751, ".$new_language_id.",'Краснодарский край'),
(2752, ".$new_language_id.",'Красноярский край'),
(2753, ".$new_language_id.",'Коми-Пермяцкий АО'),
(2754, ".$new_language_id.",'Курганская область'),
(2755, ".$new_language_id.",'Курская область'),
(2756, ".$new_language_id.",'Республика Тыва'),
(2757, ".$new_language_id.",'Липецкая область'),
(2758, ".$new_language_id.",'Магаданская область'),
(2759, ".$new_language_id.",'Республика Дагестан'),
(2760, ".$new_language_id.",'Республика Адыгея'),
(2761, ".$new_language_id.",'Москва'),
(2762, ".$new_language_id.",'Мурманская область'),
(2763, ".$new_language_id.",'Республика Кабардино-Балкария'),
(2764, ".$new_language_id.",'Ненецкий АО'),
(2765, ".$new_language_id.",'Республика Ингушетия'),
(2766, ".$new_language_id.",'Нижегородская область'),
(2767, ".$new_language_id.",'Новгородская область'),
(2768, ".$new_language_id.",'Новосибирская область'),
(2769, ".$new_language_id.",'Омская область'),
(2770, ".$new_language_id.",'Орловская область'),
(2771, ".$new_language_id.",'Оренбургская область'),
(2772, ".$new_language_id.",'Ленинградская область'),
(2773, ".$new_language_id.",'Пензенская область'),
(2774, ".$new_language_id.",'Пермский край'),
(2775, ".$new_language_id.",'Камчатский край'),
(2776, ".$new_language_id.",'Республика Карелия'),
(2777, ".$new_language_id.",'Псковская область'),
(2778, ".$new_language_id.",'Ростовская область'),
(2779, ".$new_language_id.",'Рязанская область'),
(2780, ".$new_language_id.",'Ямало-Ненецкий АО'),
(2781, ".$new_language_id.",'Самарская область'),
(2782, ".$new_language_id.",'Республика Мордовия'),
(2783, ".$new_language_id.",'Саратовская область'),
(2784, ".$new_language_id.",'Смоленская область'),
(2785, ".$new_language_id.",'Санкт-Петербург'),
(2786, ".$new_language_id.",'Ставропольский край'),
(2787, ".$new_language_id.",'Республика Коми'),
(2788, ".$new_language_id.",'Тамбовская область'),
(2789, ".$new_language_id.",'Томская область'),
(2790, ".$new_language_id.",'Тульская область'),
(2791, ".$new_language_id.",'Эвенкийский АО'),
(2792, ".$new_language_id.",'Тверская область'),
(2793, ".$new_language_id.",'Тюменская область'),
(2794, ".$new_language_id.",'Республика Башкортостан'),
(2795, ".$new_language_id.",'Ульяновская область'),
(2796, ".$new_language_id.",'Республика Бурятия'),
(2797, ".$new_language_id.",'Усть-Ордынский Бурятский округ'),
(2798, ".$new_language_id.",'Республика Северная Осетия'),
(2799, ".$new_language_id.",'Владимирская область'),
(2800, ".$new_language_id.",'Приморский край'),
(2801, ".$new_language_id.",'Волгоградская область'),
(2802, ".$new_language_id.",'Вологодская область'),
(2803, ".$new_language_id.",'Воронежская область'),
(2804, ".$new_language_id.",'Сахалинская область'),
(2805, ".$new_language_id.",'Республика Саха'),
(2806, ".$new_language_id.",'Ярославская область'),
(2807, ".$new_language_id.",'Свердловская область'),
(2808, ".$new_language_id.",'Республика Марий Эл'),
(2809, ".$new_language_id.",'Бутаре'),
(2810, ".$new_language_id.",'Бьюмба'),
(2811, ".$new_language_id.",'Сиангугу'),
(2812, ".$new_language_id.",'Гиконгоро'),
(2813, ".$new_language_id.",'Гисеньи'),
(2814, ".$new_language_id.",'Гитарама'),
(2815, ".$new_language_id.",'Кибунго'),
(2816, ".$new_language_id.",'Кибуе'),
(2817, ".$new_language_id.",'Кигали Rurale'),
(2818, ".$new_language_id.",'Кигали-Виль'),
(2819, ".$new_language_id.",'Рухенгери'),
(2820, ".$new_language_id.",'Umutara'),
(2821, ".$new_language_id.",'Церковь Христа Никола Город'),
(2822, ".$new_language_id.",'Святой Анны Сэнди-Пойнт'),
(2823, ".$new_language_id.",'Святой Георгий Бастер'),
(2824, ".$new_language_id.",'Святой Георгий Джинджерланд'),
(2825, ".$new_language_id.",'Сент-Джеймс Наветренных'),
(2826, ".$new_language_id.",'Святой Иоанн Capesterre'),
(2827, ".$new_language_id.",'Святой Иоанн Figtree'),
(2828, ".$new_language_id.",'Saint Mary Cayon'),
(2829, ".$new_language_id.",'Сент-Пол Capesterre'),
(2830, ".$new_language_id.",'Сент-Пол Charlestown'),
(2831, ".$new_language_id.",'Святой Петр Бастер'),
(2832, ".$new_language_id.",'Сент-Томас низменность'),
(2833, ".$new_language_id.",'Сент-Томас Middle Island'),
(2834, ".$new_language_id.",'Тринити-Палметто-Пойнт'),
(2835, ".$new_language_id.",'Анс-ла-Рей'),
(2836, ".$new_language_id.",'Кастри'),
(2837, ".$new_language_id.",'Шуазель'),
(2838, ".$new_language_id.",'Дофин'),
(2839, ".$new_language_id.",'Dennery'),
(2840, ".$new_language_id.",'Грос-Иле'),
(2841, ".$new_language_id.",'Laborie'),
(2842, ".$new_language_id.",'Мику'),
(2843, ".$new_language_id.",'Праслин'),
(2844, ".$new_language_id.",'Суфриер'),
(2845, ".$new_language_id.",'Vieux-Fort'),
(2846, ".$new_language_id.",'Шарлотта'),
(2847, ".$new_language_id.",'Гренадины'),
(2848, ".$new_language_id.",'Святой Андрей'),
(2849, ".$new_language_id.",'Сент-Дэвид'),
(2850, ".$new_language_id.",'Святой Георгий'),
(2851, ".$new_language_id.",'Святой Патрик'),
(2852, ".$new_language_id.",'A&#39;ana'),
(2853, ".$new_language_id.",'Аига--ле-Тай'),
(2854, ".$new_language_id.",'Атуа'),
(2855, ".$new_language_id.",'Fa&#39;asaleleaga'),
(2856, ".$new_language_id.",'Gaga&#39;emauga'),
(2857, ".$new_language_id.",'Gagaifomauga'),
(2858, ".$new_language_id.",'Palauli'),
(2859, ".$new_language_id.",'Satupa&#39;itea'),
(2860, ".$new_language_id.",'Туамасага'),
(2861, ".$new_language_id.",'Va&#39;a-о-Fonoti'),
(2862, ".$new_language_id.",'Vaisigano'),
(2863, ".$new_language_id.",'Acquaviva'),
(2864, ".$new_language_id.",'Борго-Маджоре'),
(2865, ".$new_language_id.",'Chiesanuova'),
(2866, ".$new_language_id.",'Доманьяно'),
(2867, ".$new_language_id.",'Фаетано'),
(2868, ".$new_language_id.",'Фиорентино'),
(2869, ".$new_language_id.",'Монтеджардино'),
(2870, ".$new_language_id.",'Читта-ди-Сан-Марино'),
(2871, ".$new_language_id.",'Серравалле'),
(2872, ".$new_language_id.",'Сан-Томе'),
(2873, ".$new_language_id.",'Принсипи'),
(2874, ".$new_language_id.",'Эль-Баха'),
(2875, ".$new_language_id.",'Аль Худуд пепел Shamaliyah'),
(2876, ".$new_language_id.",'Эль-Джауф'),
(2877, ".$new_language_id.",'Эль-Мадина'),
(2878, ".$new_language_id.",'Эль-Касим'),
(2879, ".$new_language_id.",'Эр-Рияд'),
(2880, ".$new_language_id.",'Эш-Шаркия (Восточная)'),
(2881, ".$new_language_id.",'&#39;Асир'),
(2882, ".$new_language_id.",'Ha&#39;il'),
(2883, ".$new_language_id.",'Jizan'),
(2884, ".$new_language_id.",'Мекка'),
(2885, ".$new_language_id.",'Наджран'),
(2886, ".$new_language_id.",'Табук'),
(2887, ".$new_language_id.",'Дакар'),
(2888, ".$new_language_id.",'Диурбель'),
(2889, ".$new_language_id.",'Фатик'),
(2890, ".$new_language_id.",'Kaolack'),
(2891, ".$new_language_id.",'Колда'),
(2892, ".$new_language_id.",'Луга'),
(2893, ".$new_language_id.",'Matam'),
(2894, ".$new_language_id.",'Сен-Луи'),
(2895, ".$new_language_id.",'Tambacounda'),
(2896, ".$new_language_id.",'Тиз'),
(2897, ".$new_language_id.",'Зигиншор'),
(2898, ".$new_language_id.",'Анс Окс Пен'),
(2899, ".$new_language_id.",'Анс Буало'),
(2900, ".$new_language_id.",'Анс Этуаль'),
(2901, ".$new_language_id.",'Anse Louis'),
(2902, ".$new_language_id.",'Anse Royale'),
(2903, ".$new_language_id.",'Бэ Лазар'),
(2904, ".$new_language_id.",'Бе-Сент-Энн'),
(2905, ".$new_language_id.",'Бо-Валлон'),
(2906, ".$new_language_id.",'Bel Air'),
(2907, ".$new_language_id.",'Bel Ombre'),
(2908, ".$new_language_id.",'Каскад'),
(2909, ".$new_language_id.",'Гласис'),
(2910, ".$new_language_id.",'Анс Grand &#39;(на Маэ)'),
(2911, ".$new_language_id.",'Анс Grand &#39;(на Праслин)'),
(2912, ".$new_language_id.",'Ла-Диг'),
(2913, ".$new_language_id.",'Ла Ривьер Anglaise'),
(2914, ".$new_language_id.",'Мон Бакстон'),
(2915, ".$new_language_id.",'Мон Флери'),
(2916, ".$new_language_id.",'Plaisance'),
(2917, ".$new_language_id.",'Пуэнт Ла Рю'),
(2918, ".$new_language_id.",'Port Glaud'),
(2919, ".$new_language_id.",'Сент-Луис'),
(2920, ".$new_language_id.",'Такамака'),
(2921, ".$new_language_id.",'Восточный'),
(2922, ".$new_language_id.",'Северный'),
(2923, ".$new_language_id.",'Южный'),
(2924, ".$new_language_id.",'Западный'),
(2925, ".$new_language_id.",'Banskobystrický'),
(2926, ".$new_language_id.",'Bratislavský'),
(2927, ".$new_language_id.",'Košický'),
(2928, ".$new_language_id.",'Nitriansky'),
(2929, ".$new_language_id.",'Prešovský'),
(2930, ".$new_language_id.",'Trenčiansky'),
(2931, ".$new_language_id.",'Trnavský'),
(2932, ".$new_language_id.",'Žilinský'),
(2933, ".$new_language_id.",'Центральный'),
(2934, ".$new_language_id.",'Шуазель'),
(2935, ".$new_language_id.",'Гуадалканал'),
(2936, ".$new_language_id.",'Хониара'),
(2937, ".$new_language_id.",'Изабелла'),
(2938, ".$new_language_id.",'Makira'),
(2939, ".$new_language_id.",'Малаита'),
(2940, ".$new_language_id.",'Rennell и Беллона'),
(2941, ".$new_language_id.",'Темоту'),
(2942, ".$new_language_id.",'Западный'),
(2943, ".$new_language_id.",'Авдал'),
(2944, ".$new_language_id.",'Бакол'),
(2945, ".$new_language_id.",'Banaadir'),
(2946, ".$new_language_id.",'Бари'),
(2947, ".$new_language_id.",'Залив'),
(2948, ".$new_language_id.",'Galguduud'),
(2949, ".$new_language_id.",'Гедо'),
(2950, ".$new_language_id.",'Hiiraan'),
(2951, ".$new_language_id.",'Jubbada Dhexe'),
(2952, ".$new_language_id.",'Jubbada Hoose'),
(2953, ".$new_language_id.",'Мудуг'),
(2954, ".$new_language_id.",'Nugaal'),
(2955, ".$new_language_id.",'Санааг'),
(2956, ".$new_language_id.",'Шебели Dhexe'),
(2957, ".$new_language_id.",'Шебели Hoose'),
(2958, ".$new_language_id.",'Сул'),
(2959, ".$new_language_id.",'Togdheer'),
(2960, ".$new_language_id.",'Woqooyi Galbeed'),
(2961, ".$new_language_id.",'Восточный Кейп'),
(2962, ".$new_language_id.",'Свободное государство'),
(2963, ".$new_language_id.",'Гаутенг'),
(2964, ".$new_language_id.",'Квазулу-Наталь'),
(2965, ".$new_language_id.",'Лимпопо'),
(2966, ".$new_language_id.",'Мпумаланга'),
(2967, ".$new_language_id.",'Северо-Запад'),
(2968, ".$new_language_id.",'Северный Кейп'),
(2969, ".$new_language_id.",'Западный Кейп'),
(2970, ".$new_language_id.",'Ла-Корунья'),
(2971, ".$new_language_id.",'Алава'),
(2972, ".$new_language_id.",'Альбасете'),
(2973, ".$new_language_id.",'Аликанте'),
(2974, ".$new_language_id.",'Альмерия'),
(2975, ".$new_language_id.",'Астурия'),
(2976, ".$new_language_id.",'Авила'),
(2977, ".$new_language_id.",'Бадахос'),
(2978, ".$new_language_id.",'Балеарские острова'),
(2979, ".$new_language_id.",'Барселона'),
(2980, ".$new_language_id.",'Бургос'),
(2981, ".$new_language_id.",'Касерес'),
(2982, ".$new_language_id.",'Кадис'),
(2983, ".$new_language_id.",'Кантабрия'),
(2984, ".$new_language_id.",'Кастельон'),
(2985, ".$new_language_id.",'Сеута'),
(2986, ".$new_language_id.",'Сьюдад-Реаль'),
(2987, ".$new_language_id.",'Кордова'),
(2988, ".$new_language_id.",'Куэнка'),
(2989, ".$new_language_id.",'Жирона'),
(2990, ".$new_language_id.",'Гранада'),
(2991, ".$new_language_id.",'Гвадалахара'),
(2992, ".$new_language_id.",'Гипускоа'),
(2993, ".$new_language_id.",'Уэльва'),
(2994, ".$new_language_id.",'Уэска'),
(2995, ".$new_language_id.",'Хаэн'),
(2996, ".$new_language_id.",'Ла-Риоха'),
(2997, ".$new_language_id.",'Лас-Пальмас'),
(2998, ".$new_language_id.",'Леон'),
(2999, ".$new_language_id.",'Лерида'),
(3000, ".$new_language_id.",'Луго'),
(3001, ".$new_language_id.",'Мадрид'),
(3002, ".$new_language_id.",'Малага'),
(3003, ".$new_language_id.",'Мелилья'),
(3004, ".$new_language_id.",'Мурсия'),
(3005, ".$new_language_id.",'Наварра'),
(3006, ".$new_language_id.",'Оуренсе'),
(3007, ".$new_language_id.",'Паленсия'),
(3008, ".$new_language_id.",'Понтеведра'),
(3009, ".$new_language_id.",'Саламанка'),
(3010, ".$new_language_id.",'Санта-Крус-де-Тенерифе'),
(3011, ".$new_language_id.",'Сеговия'),
(3012, ".$new_language_id.",'Севилья'),
(3013, ".$new_language_id.",'Сория'),
(3014, ".$new_language_id.",'Таррагона'),
(3015, ".$new_language_id.",'Теруэль'),
(3016, ".$new_language_id.",'Толедо'),
(3017, ".$new_language_id.",'Валенсия'),
(3018, ".$new_language_id.",'Вальядолид'),
(3019, ".$new_language_id.",'Бискайя'),
(3020, ".$new_language_id.",'Замора'),
(3021, ".$new_language_id.",'Сарагоса'),
(3022, ".$new_language_id.",'Центральный'),
(3023, ".$new_language_id.",'Восточный'),
(3024, ".$new_language_id.",'Северная Центральная'),
(3025, ".$new_language_id.",'Северный'),
(3026, ".$new_language_id.",'Северо-Западный'),
(3027, ".$new_language_id.",'Сабарагамува'),
(3028, ".$new_language_id.",'Южный'),
(3029, ".$new_language_id.",'Ува'),
(3030, ".$new_language_id.",'Западный'),
(3031, ".$new_language_id.",'Восхождение'),
(3032, ".$new_language_id.",'Остров Святой Елены'),
(3033, ".$new_language_id.",'Тристан-да-Кунья'),
(3034, ".$new_language_id.",'A&#39;ali Нил'),
(3035, ".$new_language_id.",'Эль-Бахр-эль-Ахмар'),
(3036, ".$new_language_id.",'Аль Buhayrat'),
(3037, ".$new_language_id.",'Аль Джазира'),
(3038, ".$new_language_id.",'Аль Khartum'),
(3039, ".$new_language_id.",'Аль Кадариф'),
(3040, ".$new_language_id.",'Аль Wahdah'),
(3041, ".$new_language_id.",'Нил др. Abyad'),
(3042, ".$new_language_id.",'Нил др. Azraq'),
(3043, ".$new_language_id.",'Эш Shamaliyah'),
(3044, ".$new_language_id.",'Бахр-эль-Джебель'),
(3045, ".$new_language_id.",'Гарб Аль Istiwa&#39;iyah'),
(3046, ".$new_language_id.",'Гарб Бахр-эль-Газаль'),
(3047, ".$new_language_id.",'Гарб Дарфур'),
(3048, ".$new_language_id.",'Гарб Кордофан'),
(3049, ".$new_language_id.",'Janub Дарфур'),
(3050, ".$new_language_id.",'Janub Кордофан'),
(3051, ".$new_language_id.",'Junqali'),
(3052, ".$new_language_id.",'Kassala'),
(3053, ".$new_language_id.",'Нахр Нил'),
(3054, ".$new_language_id.",'Shamal Бахр-эль-Газаль'),
(3055, ".$new_language_id.",'Shamal Дарфур'),
(3056, ".$new_language_id.",'Shamal Кордофан'),
(3057, ".$new_language_id.",'Шарк аль Istiwa&#39;iyah'),
(3058, ".$new_language_id.",'Синнар'),
(3059, ".$new_language_id.",'Вараб'),
(3060, ".$new_language_id.",'Брокопондо'),
(3061, ".$new_language_id.",'Commewijne'),
(3062, ".$new_language_id.",'Coronie'),
(3063, ".$new_language_id.",'Маровейне'),
(3064, ".$new_language_id.",'Nickerie'),
(3065, ".$new_language_id.",'Para'),
(3066, ".$new_language_id.",'Парамарибо'),
(3067, ".$new_language_id.",'Сарамакка'),
(3068, ".$new_language_id.",'Сипаливини'),
(3069, ".$new_language_id.",'Ваника'),
(3070, ".$new_language_id.",'Hhohho'),
(3071, ".$new_language_id.",'Лубомбо'),
(3072, ".$new_language_id.",'Манзини'),
(3073, ".$new_language_id.",'Shishelweni'),
(3074, ".$new_language_id.",'Блекинге'),
(3075, ".$new_language_id.",'Dalama'),
(3076, ".$new_language_id.",'Gävleborg'),
(3077, ".$new_language_id.",'Готланд'),
(3078, ".$new_language_id.",'Халланд'),
(3079, ".$new_language_id.",'Jämtland'),
(3080, ".$new_language_id.",'Йенчепинг'),
(3081, ".$new_language_id.",'Кальмар'),
(3082, ".$new_language_id.",'Kronoberg'),
(3083, ".$new_language_id.",'Норрботтен'),
(3084, ".$new_language_id.",'Эребру'),
(3085, ".$new_language_id.",'Östergötland'),
(3086, ".$new_language_id.",'Сконе'),
(3087, ".$new_language_id.",'Södermanland'),
(3088, ".$new_language_id.",'Стокгольм'),
(3089, ".$new_language_id.",'Упсала'),
(3090, ".$new_language_id.",'Вермланд'),
(3091, ".$new_language_id.",'Вестерботтен'),
(3092, ".$new_language_id.",'Västernorrland'),
(3093, ".$new_language_id.",'Västmanland'),
(3094, ".$new_language_id.",'Вестра-Геталанд'),
(3095, ".$new_language_id.",'Ааргау'),
(3096, ".$new_language_id.",'Аппенцелль-Ауссерроден'),
(3097, ".$new_language_id.",'Аппенцелль Иннерроден'),
(3098, ".$new_language_id.",'Базель-Штадт'),
(3099, ".$new_language_id.",'Базель-Ланд'),
(3100, ".$new_language_id.",'Берн'),
(3101, ".$new_language_id.",'Фрибург'),
(3102, ".$new_language_id.",'Genève'),
(3103, ".$new_language_id.",'Гларус'),
(3104, ".$new_language_id.",'Граубюнден'),
(3105, ".$new_language_id.",'Юра'),
(3106, ".$new_language_id.",'Люцерн'),
(3107, ".$new_language_id.",'Невшатель'),
(3108, ".$new_language_id.",'Nidwald'),
(3109, ".$new_language_id.",'Обвальден'),
(3110, ".$new_language_id.",'Санкт-Галлен'),
(3111, ".$new_language_id.",'Шаффхаузен'),
(3112, ".$new_language_id.",'Швиц'),
(3113, ".$new_language_id.",'Золотурн'),
(3114, ".$new_language_id.",'Тургау'),
(3115, ".$new_language_id.",'Тичино'),
(3116, ".$new_language_id.",'Ури'),
(3117, ".$new_language_id.",'Вале'),
(3118, ".$new_language_id.",'Во'),
(3119, ".$new_language_id.",'Цуг'),
(3120, ".$new_language_id.",'Цюрих'),
(3121, ".$new_language_id.",'Аль Хасеке'),
(3122, ".$new_language_id.",'Аль Ladhiqiyah'),
(3123, ".$new_language_id.",'Аль Qunaytirah'),
(3124, ".$new_language_id.",'Эр-Ракка'),
(3125, ".$new_language_id.",'Как Suwayda'),
(3126, ".$new_language_id.",'Дара'),
(3127, ".$new_language_id.",'Дейр аз Zawr'),
(3128, ".$new_language_id.",'Дамаск'),
(3129, ".$new_language_id.",'Халеб'),
(3130, ".$new_language_id.",'Хама'),
(3131, ".$new_language_id.",'Хомс'),
(3132, ".$new_language_id.",'Идлиб'),
(3133, ".$new_language_id.",'Риф Дамаск'),
(3134, ".$new_language_id.",'Тартус'),
(3135, ".$new_language_id.",'Чанг-хуа'),
(3136, ".$new_language_id.",'Чиа-я'),
(3137, ".$new_language_id.",'Синь-чу'),
(3138, ".$new_language_id.",'Хуа-залог'),
(3139, ".$new_language_id.",'Я-лань'),
(3140, ".$new_language_id.",'Као-сюн уезд'),
(3141, ".$new_language_id.",'Кин-мужчин'),
(3142, ".$new_language_id.",'Лянь-Чан'),
(3143, ".$new_language_id.",'Мяо-ли'),
(3144, ".$new_language_id.",'Нан-тоу'),
(3145, ".$new_language_id.",'Пэн-ху'),
(3146, ".$new_language_id.",'Пин-дун'),
(3147, ".$new_language_id.",'Тай-чжун'),
(3148, ".$new_language_id.",'Тай-нан'),
(3149, ".$new_language_id.",'Тай-пей уезд'),
(3150, ".$new_language_id.",'Тай-дун'),
(3151, ".$new_language_id.",'T&#39;ao-юань'),
(3152, ".$new_language_id.",'Юн-лин'),
(3153, ".$new_language_id.",'Чиа-я город'),
(3154, ".$new_language_id.",'Чи-легких'),
(3155, ".$new_language_id.",'Синь-чу'),
(3156, ".$new_language_id.",'Тай-чжун'),
(3157, ".$new_language_id.",'Тай-нан'),
(3158, ".$new_language_id.",'Город Као-сюн'),
(3159, ".$new_language_id.",'Город Тай-пей'),
(3160, ".$new_language_id.",'Горно-Badakhstan'),
(3161, ".$new_language_id.",'Хатлонской'),
(3162, ".$new_language_id.",'Согдийская'),
(3163, ".$new_language_id.",'Аруша'),
(3164, ".$new_language_id.",'Дар-эс-Салам'),
(3165, ".$new_language_id.",'Додома'),
(3166, ".$new_language_id.",'Иринга'),
(3167, ".$new_language_id.",'Кагера'),
(3168, ".$new_language_id.",'Кигома'),
(3169, ".$new_language_id.",'Килиманджаро'),
(3170, ".$new_language_id.",'Линди'),
(3171, ".$new_language_id.",'Маньяра'),
(3172, ".$new_language_id.",'Мара'),
(3173, ".$new_language_id.",'Мбея'),
(3174, ".$new_language_id.",'Морогоро'),
(3175, ".$new_language_id.",'Мтвара'),
(3176, ".$new_language_id.",'Мванза'),
(3177, ".$new_language_id.",'Пемба Северная'),
(3178, ".$new_language_id.",'Пемба Южная'),
(3179, ".$new_language_id.",'Pwani'),
(3180, ".$new_language_id.",'Руква'),
(3181, ".$new_language_id.",'Рувума'),
(3182, ".$new_language_id.",'Шиньянга'),
(3183, ".$new_language_id.",'Сингида'),
(3184, ".$new_language_id.",'Табора'),
(3185, ".$new_language_id.",'Танга'),
(3186, ".$new_language_id.",'Занзибар Центральная / Южная'),
(3187, ".$new_language_id.",'Занзибар Северный'),
(3188, ".$new_language_id.",'Занзибар Урбан / Запад'),
(3189, ".$new_language_id.",'Amnat Charoen'),
(3190, ".$new_language_id.",'Анг-стринги'),
(3191, ".$new_language_id.",'Аюттхая'),
(3192, ".$new_language_id.",'Бангкок'),
(3193, ".$new_language_id.",'Бурирам'),
(3194, ".$new_language_id.",'Чаченгсау'),
(3195, ".$new_language_id.",'Чайнат'),
(3196, ".$new_language_id.",'Чайяпхум'),
(3197, ".$new_language_id.",'Chanthaburi'),
(3198, ".$new_language_id.",'Чиангмай'),
(3199, ".$new_language_id.",'Чианг Рай'),
(3200, ".$new_language_id.",'Чонбури'),
(3201, ".$new_language_id.",'Чумпхон'),
(3202, ".$new_language_id.",'Kalasin'),
(3203, ".$new_language_id.",'Кампхэнгпхет'),
(3204, ".$new_language_id.",'Канчанабури'),
(3205, ".$new_language_id.",'Кхонкэн'),
(3206, ".$new_language_id.",'Краби'),
(3207, ".$new_language_id.",'Лампанг'),
(3208, ".$new_language_id.",'Лампхун'),
(3209, ".$new_language_id.",'Лей'),
(3210, ".$new_language_id.",'Лопбури'),
(3211, ".$new_language_id.",'Мае Хонг Сон'),
(3212, ".$new_language_id.",'Махасаракхам'),
(3213, ".$new_language_id.",'Мукдахан'),
(3214, ".$new_language_id.",'Накхоннайок'),
(3215, ".$new_language_id.",'Накхонпатхом'),
(3216, ".$new_language_id.",'Накхон Пханом'),
(3217, ".$new_language_id.",'Накхонратчасима'),
(3218, ".$new_language_id.",'Накхонсаван'),
(3219, ".$new_language_id.",'Накхонситхаммарат'),
(3220, ".$new_language_id.",'Бабушка'),
(3221, ".$new_language_id.",'Наратхиват'),
(3222, ".$new_language_id.",'Нонгбуалампху'),
(3223, ".$new_language_id.",'Нонгкай'),
(3224, ".$new_language_id.",'Нонтхабури'),
(3225, ".$new_language_id.",'Патхумтхани'),
(3226, ".$new_language_id.",'Паттани'),
(3227, ".$new_language_id.",'Пхангнга'),
(3228, ".$new_language_id.",'Phatthalung'),
(3229, ".$new_language_id.",'Phayao'),
(3230, ".$new_language_id.",'Пхетчабун'),
(3231, ".$new_language_id.",'Пхетчабури'),
(3232, ".$new_language_id.",'Пхичит'),
(3233, ".$new_language_id.",'Пхитсанулок'),
(3234, ".$new_language_id.",'Phrae'),
(3235, ".$new_language_id.",'Пхукет'),
(3236, ".$new_language_id.",'Прачинбури'),
(3237, ".$new_language_id.",'Прачуапкхирикхан'),
(3238, ".$new_language_id.",'Ранонг'),
(3239, ".$new_language_id.",'Ратчабури'),
(3240, ".$new_language_id.",'Районг'),
(3241, ".$new_language_id.",'Ройет'),
(3242, ".$new_language_id.",'Сакэу'),
(3243, ".$new_language_id.",'Сакон Накхон'),
(3244, ".$new_language_id.",'Самутпракан'),
(3245, ".$new_language_id.",'Самут Sakhon'),
(3246, ".$new_language_id.",'Самут Сонгкрам'),
(3247, ".$new_language_id.",'Сара Бури'),
(3248, ".$new_language_id.",'Сатун'),
(3249, ".$new_language_id.",'Sing Buri'),
(3250, ".$new_language_id.",'Sisaket'),
(3251, ".$new_language_id.",'Сонгкхла'),
(3252, ".$new_language_id.",'Sukhothai'),
(3253, ".$new_language_id.",'Супханбури'),
(3254, ".$new_language_id.",'Сурат Тани'),
(3255, ".$new_language_id.",'Сурин'),
(3256, ".$new_language_id.",'Так'),
(3257, ".$new_language_id.",'Транг'),
(3258, ".$new_language_id.",'Трат'),
(3259, ".$new_language_id.",'Убонратчатхани'),
(3260, ".$new_language_id.",'Удон-Тхани'),
(3261, ".$new_language_id.",'Утхайтхани'),
(3262, ".$new_language_id.",'Уттарадит'),
(3263, ".$new_language_id.",'Яла'),
(3264, ".$new_language_id.",'Yasothon'),
(3265, ".$new_language_id.",'Кара'),
(3266, ".$new_language_id.",'Плато'),
(3267, ".$new_language_id.",'Саваны'),
(3268, ".$new_language_id.",'Центральный'),
(3269, ".$new_language_id.",'Морской'),
(3270, ".$new_language_id.",'Atafu'),
(3271, ".$new_language_id.",'Факаофо'),
(3272, ".$new_language_id.",'Нукунону'),
(3273, ".$new_language_id.",'Хаапай'),
(3274, ".$new_language_id.",'Тонгатапу'),
(3275, ".$new_language_id.",'Vava&#39;u'),
(3276, ".$new_language_id.",'Couva / Tabaquite / Talparo'),
(3277, ".$new_language_id.",'Диего Мартин'),
(3278, ".$new_language_id.",'Mayaro / Риу-Клару'),
(3279, ".$new_language_id.",'Уголовный / Дебе'),
(3280, ".$new_language_id.",'Князья Город'),
(3281, ".$new_language_id.",'Sangre Grande'),
(3282, ".$new_language_id.",'Сан - Хуан / Laventille'),
(3283, ".$new_language_id.",'Siparia'),
(3284, ".$new_language_id.",'Tunapuna / Пиарко'),
(3285, ".$new_language_id.",'Порт-оф-Спейн'),
(3286, ".$new_language_id.",'Сан - Фернандо'),
(3287, ".$new_language_id.",'Арима'),
(3288, ".$new_language_id.",'Точка Фортин'),
(3289, ".$new_language_id.",'Чагуанас'),
(3290, ".$new_language_id.",'Тобаго'),
(3291, ".$new_language_id.",'Ариана'),
(3292, ".$new_language_id.",'Беджа'),
(3293, ".$new_language_id.",'Бен Арус'),
(3294, ".$new_language_id.",'Бизерта'),
(3295, ".$new_language_id.",'Габес'),
(3296, ".$new_language_id.",'Гафса'),
(3297, ".$new_language_id.",'Джендуба'),
(3298, ".$new_language_id.",'Кайруан'),
(3299, ".$new_language_id.",'Kasserine'),
(3300, ".$new_language_id.",'Кебили'),
(3301, ".$new_language_id.",'Состояние опьянения'),
(3302, ".$new_language_id.",'Махдия'),
(3303, ".$new_language_id.",'Мануба'),
(3304, ".$new_language_id.",'Меденин'),
(3305, ".$new_language_id.",'Монастир'),
(3306, ".$new_language_id.",'Набель'),
(3307, ".$new_language_id.",'Сфакс'),
(3308, ".$new_language_id.",'Сиди'),
(3309, ".$new_language_id.",'Силиана'),
(3310, ".$new_language_id.",'Сус'),
(3311, ".$new_language_id.",'Татуин'),
(3312, ".$new_language_id.",'Тозер'),
(3313, ".$new_language_id.",'Тунис'),
(3314, ".$new_language_id.",'Загван'),
(3315, ".$new_language_id.",'Адана'),
(3316, ".$new_language_id.",'Adiyaman'),
(3317, ".$new_language_id.",'Afyonkarahisar'),
(3318, ".$new_language_id.",'Agri'),
(3319, ".$new_language_id.",'Аксарай'),
(3320, ".$new_language_id.",'Амасья'),
(3321, ".$new_language_id.",'Анкара'),
(3322, ".$new_language_id.",'Анталия'),
(3323, ".$new_language_id.",'Ардахан'),
(3324, ".$new_language_id.",'Артвин'),
(3325, ".$new_language_id.",'Айдын'),
(3326, ".$new_language_id.",'Балыкесир'),
(3327, ".$new_language_id.",'Bartin'),
(3328, ".$new_language_id.",'Денщик'),
(3329, ".$new_language_id.",'Байбурт'),
(3330, ".$new_language_id.",'Биледжик'),
(3331, ".$new_language_id.",'Бингель'),
(3332, ".$new_language_id.",'Битлис'),
(3333, ".$new_language_id.",'Болу'),
(3334, ".$new_language_id.",'Бурдур'),
(3335, ".$new_language_id.",'Сумка'),
(3336, ".$new_language_id.",'Чанаккале'),
(3337, ".$new_language_id.",'Cankiri'),
(3338, ".$new_language_id.",'Corum'),
(3339, ".$new_language_id.",'Денизли'),
(3340, ".$new_language_id.",'Диярбакыр'),
(3341, ".$new_language_id.",'Duzce'),
(3342, ".$new_language_id.",'Эдирне'),
(3343, ".$new_language_id.",'Элязыг'),
(3344, ".$new_language_id.",'Эрзинджан'),
(3345, ".$new_language_id.",'Эрзурум'),
(3346, ".$new_language_id.",'Эскишехир'),
(3347, ".$new_language_id.",'Газиантеп'),
(3348, ".$new_language_id.",'Гиресун'),
(3349, ".$new_language_id.",'Гюмюшане'),
(3350, ".$new_language_id.",'Хаккяри'),
(3351, ".$new_language_id.",'Хатай'),
(3352, ".$new_language_id.",'Игдыр'),
(3353, ".$new_language_id.",'Испарта'),
(3354, ".$new_language_id.",'Стамбул'),
(3355, ".$new_language_id.",'Измир'),
(3356, ".$new_language_id.",'Кахраманмараш'),
(3357, ".$new_language_id.",'Карабюк'),
(3358, ".$new_language_id.",'Караман'),
(3359, ".$new_language_id.",'Карс'),
(3360, ".$new_language_id.",'Кастамону'),
(3361, ".$new_language_id.",'Кайсери'),
(3362, ".$new_language_id.",'Килис'),
(3363, ".$new_language_id.",'Кырыккале'),
(3364, ".$new_language_id.",'Кыркларели'),
(3365, ".$new_language_id.",'Kirsehir'),
(3366, ".$new_language_id.",'Коджаэли'),
(3367, ".$new_language_id.",'Конья'),
(3368, ".$new_language_id.",'Кютахья'),
(3369, ".$new_language_id.",'Малатья'),
(3370, ".$new_language_id.",'Маниса'),
(3371, ".$new_language_id.",'Мардин'),
(3372, ".$new_language_id.",'Мерсин'),
(3373, ".$new_language_id.",'Мугла'),
(3374, ".$new_language_id.",'Mus'),
(3375, ".$new_language_id.",'Невшехир'),
(3376, ".$new_language_id.",'Нигде'),
(3377, ".$new_language_id.",'Орду'),
(3378, ".$new_language_id.",'Османие'),
(3379, ".$new_language_id.",'Ризе'),
(3380, ".$new_language_id.",'Сакарья'),
(3381, ".$new_language_id.",'Самсун'),
(3382, ".$new_language_id.",'Шанлыурфа'),
(3383, ".$new_language_id.",'Сиирт'),
(3384, ".$new_language_id.",'Синоп'),
(3385, ".$new_language_id.",'Sirnak'),
(3386, ".$new_language_id.",'Сивас'),
(3387, ".$new_language_id.",'Текирдаг'),
(3388, ".$new_language_id.",'Токат'),
(3389, ".$new_language_id.",'Трабзон'),
(3390, ".$new_language_id.",'Тунджели'),
(3391, ".$new_language_id.",'Ушак'),
(3392, ".$new_language_id.",'Фургон'),
(3393, ".$new_language_id.",'Ялова'),
(3394, ".$new_language_id.",'Yozgat'),
(3395, ".$new_language_id.",'Зонгулдак'),
(3396, ".$new_language_id.",'Ахал Welayaty'),
(3397, ".$new_language_id.",'Балканский Welayaty'),
(3398, ".$new_language_id.",'Dashhowuz Welayaty'),
(3399, ".$new_language_id.",'Лебапский Welayaty'),
(3400, ".$new_language_id.",'Мария Welayaty'),
(3401, ".$new_language_id.",'Ambergris Cays'),
(3402, ".$new_language_id.",'Dellis Кей'),
(3403, ".$new_language_id.",'Французский Кей'),
(3404, ".$new_language_id.",'Маленькая Вода Кей'),
(3405, ".$new_language_id.",'Parrot Cay'),
(3406, ".$new_language_id.",'Пайн-Кей'),
(3407, ".$new_language_id.",'Солт-Кей'),
(3408, ".$new_language_id.",'Гранд-Терк'),
(3409, ".$new_language_id.",'Южный Кайкос'),
(3410, ".$new_language_id.",'Восток Кайкос'),
(3411, ".$new_language_id.",'Мидл-Кайкос'),
(3412, ".$new_language_id.",'Норт-Кайкос'),
(3413, ".$new_language_id.",'Провиденсиалес'),
(3414, ".$new_language_id.",'Западный Кайкос'),
(3415, ".$new_language_id.",'Нануманга'),
(3416, ".$new_language_id.",'Ниулакита'),
(3417, ".$new_language_id.",'Niutao'),
(3418, ".$new_language_id.",'Фунафути'),
(3419, ".$new_language_id.",'Нанумеа'),
(3420, ".$new_language_id.",'Нуи'),
(3421, ".$new_language_id.",'Nukufetau'),
(3422, ".$new_language_id.",'Nukulaelae'),
(3423, ".$new_language_id.",'Ваитупу'),
(3424, ".$new_language_id.",'Kalangala'),
(3425, ".$new_language_id.",'Кампала'),
(3426, ".$new_language_id.",'Kayunga'),
(3427, ".$new_language_id.",'Kiboga'),
(3428, ".$new_language_id.",'Luwero'),
(3429, ".$new_language_id.",'Масака'),
(3430, ".$new_language_id.",'Mpigi'),
(3431, ".$new_language_id.",'Mubende'),
(3432, ".$new_language_id.",'Mukono'),
(3433, ".$new_language_id.",'Накасонгола'),
(3434, ".$new_language_id.",'Ракаи'),
(3435, ".$new_language_id.",'Sembabule'),
(3436, ".$new_language_id.",'Wakiso'),
(3437, ".$new_language_id.",'Bugiri'),
(3438, ".$new_language_id.",'Буся'),
(3439, ".$new_language_id.",'Iganga'),
(3440, ".$new_language_id.",'Jinja'),
(3441, ".$new_language_id.",'Kaberamaido'),
(3442, ".$new_language_id.",'Kamuli'),
(3443, ".$new_language_id.",'Kapchorwa'),
(3444, ".$new_language_id.",'Katakwi'),
(3445, ".$new_language_id.",'Куми'),
(3446, ".$new_language_id.",'Mayuge'),
(3447, ".$new_language_id.",'Mbale'),
(3448, ".$new_language_id.",'Pallisa'),
(3449, ".$new_language_id.",'Sironko'),
(3450, ".$new_language_id.",'Сороти'),
(3451, ".$new_language_id.",'Тороро'),
(3452, ".$new_language_id.",'Аджумани'),
(3453, ".$new_language_id.",'Apac'),
(3454, ".$new_language_id.",'Arua'),
(3455, ".$new_language_id.",'Гулу'),
(3456, ".$new_language_id.",'Китгум'),
(3457, ".$new_language_id.",'Kotido'),
(3458, ".$new_language_id.",'Лира'),
(3459, ".$new_language_id.",'Морото'),
(3460, ".$new_language_id.",'Мойо'),
(3461, ".$new_language_id.",'Nakapiripirit'),
(3462, ".$new_language_id.",'Nebbi'),
(3463, ".$new_language_id.",'Pader'),
(3464, ".$new_language_id.",'Yumbe'),
(3465, ".$new_language_id.",'Бундибуджио'),
(3466, ".$new_language_id.",'Бушеньи'),
(3467, ".$new_language_id.",'Hoima'),
(3468, ".$new_language_id.",'Кабалье'),
(3469, ".$new_language_id.",'Кабароле'),
(3470, ".$new_language_id.",'Камвенге'),
(3471, ".$new_language_id.",'Kanungu'),
(3472, ".$new_language_id.",'Kasese'),
(3473, ".$new_language_id.",'Kibaale'),
(3474, ".$new_language_id.",'Кисоро'),
(3475, ".$new_language_id.",'Kyenjojo'),
(3476, ".$new_language_id.",'Masindi'),
(3477, ".$new_language_id.",'Мбарара'),
(3478, ".$new_language_id.",'Ntungamo'),
(3479, ".$new_language_id.",'Rukungiri'),
(3480, ".$new_language_id.",'Черкассы'),
(3481, ".$new_language_id.",'Чернигов'),
(3482, ".$new_language_id.",'Черновцы'),
(3483, ".$new_language_id.",'Крым'),
(3484, ".$new_language_id.",'Днепр'),
(3485, ".$new_language_id.",'Донецк'),
(3486, ".$new_language_id.",'Ивано-Франковск'),
(3487, ".$new_language_id.",'Харьков'),
(3488, ".$new_language_id.",'Хмельницкий'),
(3489, ".$new_language_id.",'Кировоград'),
(3490, ".$new_language_id.",'Киев'),
(3491, ".$new_language_id.",'Херсон'),
(3492, ".$new_language_id.",'Луганск'),
(3493, ".$new_language_id.",'Львов'),
(3494, ".$new_language_id.",'Николаев'),
(3495, ".$new_language_id.",'Одесса'),
(3496, ".$new_language_id.",'Полтава'),
(3497, ".$new_language_id.",'Ровно'),
(3498, ".$new_language_id.",'Севастополь'),
(3499, ".$new_language_id.",'Сумы'),
(3500, ".$new_language_id.",'Тернополь'),
(3501, ".$new_language_id.",'Винница'),
(3502, ".$new_language_id.",'Волынь'),
(3503, ".$new_language_id.",'Закарпатье'),
(3504, ".$new_language_id.",'Запорожье'),
(3505, ".$new_language_id.",'Житомир'),
(3506, ".$new_language_id.",'Abu Zaby'),
(3507, ".$new_language_id.",'&#39;Аджман'),
(3508, ".$new_language_id.",'Аль-Фуджейра'),
(3509, ".$new_language_id.",'Эш Shariqah'),
(3510, ".$new_language_id.",'Dubayy'),
(3511, ".$new_language_id.",'R&#39;as аль Хайма'),
(3512, ".$new_language_id.",'Умм аль Кувейн'),
(3513, ".$new_language_id.",'Абердин'),
(3514, ".$new_language_id.",'Абердиншир'),
(3515, ".$new_language_id.",'Англси'),
(3516, ".$new_language_id.",'Ангус'),
(3517, ".$new_language_id.",'Аргайл и Бьют'),
(3518, ".$new_language_id.",'Бедфордшир'),
(3519, ".$new_language_id.",'Berkshire'),
(3520, ".$new_language_id.",'Blaenau Gwent'),
(3521, ".$new_language_id.",'Бридженд'),
(3522, ".$new_language_id.",'Бристоль'),
(3523, ".$new_language_id.",'Бакингэмшир'),
(3524, ".$new_language_id.",'Кайрфилли'),
(3525, ".$new_language_id.",'Кембриджшир'),
(3526, ".$new_language_id.",'Кардифф'),
(3527, ".$new_language_id.",'Кармартеншир'),
(3528, ".$new_language_id.",'Кередигион'),
(3529, ".$new_language_id.",'Чешир'),
(3530, ".$new_language_id.",'Clackmannanshire'),
(3531, ".$new_language_id.",'Конви'),
(3532, ".$new_language_id.",'Корнуолл'),
(3533, ".$new_language_id.",'Denbighshire'),
(3534, ".$new_language_id.",'Дербишир'),
(3535, ".$new_language_id.",'Девон'),
(3536, ".$new_language_id.",'Дорсет'),
(3537, ".$new_language_id.",'Дамфрис и Галлоуэй'),
(3538, ".$new_language_id.",'Данди'),
(3539, ".$new_language_id.",'Дарем'),
(3540, ".$new_language_id.",'Восточный Эйршир'),
(3541, ".$new_language_id.",'East Dunbartonshire'),
(3542, ".$new_language_id.",'Восточный Лотиан'),
(3543, ".$new_language_id.",'Восточный Ренфрушир'),
(3544, ".$new_language_id.",'Восточный райдинг Йоркшира'),
(3545, ".$new_language_id.",'Восточный Суссекс'),
(3546, ".$new_language_id.",'Эдинбург'),
(3547, ".$new_language_id.",'Эссекс'),
(3548, ".$new_language_id.",'Фалкирк'),
(3549, ".$new_language_id.",'Дудка'),
(3550, ".$new_language_id.",'Флинтшир'),
(3551, ".$new_language_id.",'Глазго'),
(3552, ".$new_language_id.",'Глостершир'),
(3553, ".$new_language_id.",'Большой Лондон'),
(3554, ".$new_language_id.",'Большой Манчестер'),
(3555, ".$new_language_id.",'Gwynedd'),
(3556, ".$new_language_id.",'Хэмпшир'),
(3557, ".$new_language_id.",'Херефордшир'),
(3558, ".$new_language_id.",'Хартфордшир'),
(3559, ".$new_language_id.",'Горная местность'),
(3560, ".$new_language_id.",'Inverclyde'),
(3561, ".$new_language_id.",'Остров Уайт'),
(3562, ".$new_language_id.",'Кент'),
(3563, ".$new_language_id.",'Ланкашир'),
(3564, ".$new_language_id.",'Лестершир'),
(3565, ".$new_language_id.",'Линкольншир'),
(3566, ".$new_language_id.",'Мерсисайд'),
(3567, ".$new_language_id.",'Мертир-Тидвил'),
(3568, ".$new_language_id.",'Мидлотиан'),
(3569, ".$new_language_id.",'Монмутшир'),
(3570, ".$new_language_id.",'Морей'),
(3571, ".$new_language_id.",'Нит-Порт-Толбот'),
(3572, ".$new_language_id.",'Ньюпорт'),
(3573, ".$new_language_id.",'Норфолк'),
(3574, ".$new_language_id.",'Северный Эйршир'),
(3575, ".$new_language_id.",'North Lanarkshire'),
(3576, ".$new_language_id.",'Северный Йоркшир'),
(3577, ".$new_language_id.",'Нортгемптоншир'),
(3578, ".$new_language_id.",'Нортумберленд'),
(3579, ".$new_language_id.",'Ноттингемшир'),
(3580, ".$new_language_id.",'Оркнейские острова'),
(3581, ".$new_language_id.",'Оксфордшир'),
(3582, ".$new_language_id.",'Пембрукшир'),
(3583, ".$new_language_id.",'Перт и Кинросс'),
(3584, ".$new_language_id.",'Повис'),
(3585, ".$new_language_id.",'Ренфрушир'),
(3586, ".$new_language_id.",'Rhondda Cynon Taff'),
(3587, ".$new_language_id.",'Ратленд'),
(3588, ".$new_language_id.",'Шотландские границы'),
(3589, ".$new_language_id.",'Шетландские острова'),
(3590, ".$new_language_id.",'Шропшир'),
(3591, ".$new_language_id.",'Прыжок кувырком'),
(3592, ".$new_language_id.",'Южный Эйршир'),
(3593, ".$new_language_id.",'South Lanarkshire'),
(3594, ".$new_language_id.",'Южный Йоркшир'),
(3595, ".$new_language_id.",'Стаффордширский'),
(3596, ".$new_language_id.",'Стирлинг'),
(3597, ".$new_language_id.",'Суффолк'),
(3598, ".$new_language_id.",'Легкий двухместный экипаж'),
(3599, ".$new_language_id.",'Суонси'),
(3600, ".$new_language_id.",'Torfaen'),
(3601, ".$new_language_id.",'Тайн и Уир'),
(3602, ".$new_language_id.",'Долина Гламорган'),
(3603, ".$new_language_id.",'Уорикшир'),
(3604, ".$new_language_id.",'West Dunbartonshire'),
(3605, ".$new_language_id.",'Западный Лотиан'),
(3606, ".$new_language_id.",'Уэст-Мидлендс'),
(3607, ".$new_language_id.",'Западный Суссекс'),
(3608, ".$new_language_id.",'Западный Йоркшир'),
(3609, ".$new_language_id.",'Western Isles'),
(3610, ".$new_language_id.",'Уилтшир'),
(3611, ".$new_language_id.",'Вустершир'),
(3612, ".$new_language_id.",'Рексхэм'),
(3613, ".$new_language_id.",'Алабама'),
(3614, ".$new_language_id.",'Аляска'),
(3615, ".$new_language_id.",'Американское Самоа'),
(3616, ".$new_language_id.",'Аризона'),
(3617, ".$new_language_id.",'Арканзас'),
(3618, ".$new_language_id.",'Вооруженные силы Африка'),
(3619, ".$new_language_id.",'Вооруженные силы Америки'),
(3620, ".$new_language_id.",'Вооруженные силы Канады'),
(3621, ".$new_language_id.",'Вооруженные силы Европы'),
(3622, ".$new_language_id.",'Вооруженные силы Ближний Восток'),
(3623, ".$new_language_id.",'Вооруженные Силы Тихоокеанского'),
(3624, ".$new_language_id.",'Калифорния'),
(3625, ".$new_language_id.",'Колорадо'),
(3626, ".$new_language_id.",'Коннектикут'),
(3627, ".$new_language_id.",'Делавэр'),
(3628, ".$new_language_id.",'Федеральный округ Колумбия'),
(3629, ".$new_language_id.",'Федеративные Штаты Микронезии'),
(3630, ".$new_language_id.",'Флорида'),
(3631, ".$new_language_id.",'Грузия'),
(3632, ".$new_language_id.",'Гуам'),
(3633, ".$new_language_id.",'Гавайи'),
(3634, ".$new_language_id.",'Айдахо'),
(3635, ".$new_language_id.",'Иллинойс'),
(3636, ".$new_language_id.",'Индиана'),
(3637, ".$new_language_id.",'Айова'),
(3638, ".$new_language_id.",'Канзас'),
(3639, ".$new_language_id.",'Кентукки'),
(3640, ".$new_language_id.",'Луизиана'),
(3641, ".$new_language_id.",'Мэн'),
(3642, ".$new_language_id.",'Маршалловы острова'),
(3643, ".$new_language_id.",'Мэриленд'),
(3644, ".$new_language_id.",'Массачусетс'),
(3645, ".$new_language_id.",'Мичиган'),
(3646, ".$new_language_id.",'Миннесота'),
(3647, ".$new_language_id.",'Миссисипи'),
(3648, ".$new_language_id.",'Миссури'),
(3649, ".$new_language_id.",'Монтана'),
(3650, ".$new_language_id.",'Небраска'),
(3651, ".$new_language_id.",'Невада'),
(3652, ".$new_language_id.",'Нью-Гемпшир'),
(3653, ".$new_language_id.",'Нью-Джерси'),
(3654, ".$new_language_id.",'Нью-Мексико'),
(3655, ".$new_language_id.",'Нью-Йорк'),
(3656, ".$new_language_id.",'Северная Каролина'),
(3657, ".$new_language_id.",'Северная Дакота'),
(3658, ".$new_language_id.",'Северные Марианские острова'),
(3659, ".$new_language_id.",'Огайо'),
(3660, ".$new_language_id.",'Оклахома'),
(3661, ".$new_language_id.",'Орегон'),
(3662, ".$new_language_id.",'Палау'),
(3663, ".$new_language_id.",'Пенсильвания'),
(3664, ".$new_language_id.",'Пуэрто-Рико'),
(3665, ".$new_language_id.",'Род-Айленд'),
(3666, ".$new_language_id.",'Южная Каролина'),
(3667, ".$new_language_id.",'Южная Дакота'),
(3668, ".$new_language_id.",'Теннесси'),
(3669, ".$new_language_id.",'Техас'),
(3670, ".$new_language_id.",'Юта'),
(3671, ".$new_language_id.",'Вермонт'),
(3672, ".$new_language_id.",'Виргинские острова'),
(3673, ".$new_language_id.",'Виргиния'),
(3674, ".$new_language_id.",'Вашингтон'),
(3675, ".$new_language_id.",'Западная Виргиния'),
(3676, ".$new_language_id.",'Висконсин'),
(3677, ".$new_language_id.",'Вайоминг'),
(3678, ".$new_language_id.",'Остров Бейкер'),
(3679, ".$new_language_id.",'Хауленд'),
(3680, ".$new_language_id.",'Остров Джарвис'),
(3681, ".$new_language_id.",'Джонстон'),
(3682, ".$new_language_id.",'Риф Кингмен'),
(3683, ".$new_language_id.",'Мидуэй'),
(3684, ".$new_language_id.",'Навасса'),
(3685, ".$new_language_id.",'Пальмира Атолл'),
(3686, ".$new_language_id.",'Уэйк'),
(3687, ".$new_language_id.",'Артигас'),
(3688, ".$new_language_id.",'Канелонес'),
(3689, ".$new_language_id.",'Серро Ларго'),
(3690, ".$new_language_id.",'Колония'),
(3691, ".$new_language_id.",'Durazno'),
(3692, ".$new_language_id.",'Флорес'),
(3693, ".$new_language_id.",'Флорида'),
(3694, ".$new_language_id.",'Lavalleja'),
(3695, ".$new_language_id.",'Мальдонадо'),
(3696, ".$new_language_id.",'Монтевидео'),
(3697, ".$new_language_id.",'Пайсанду'),
(3698, ".$new_language_id.",'Рио-Негро'),
(3699, ".$new_language_id.",'Ривера'),
(3700, ".$new_language_id.",'Роча'),
(3701, ".$new_language_id.",'Сальто'),
(3702, ".$new_language_id.",'Сан - Хосе'),
(3703, ".$new_language_id.",'Сориано'),
(3704, ".$new_language_id.",'Tacuarembo'),
(3705, ".$new_language_id.",'Treinta у Tres'),
(3706, ".$new_language_id.",'Андижанская'),
(3707, ".$new_language_id.",'Бухара'),
(3708, ".$new_language_id.",'Ферганская'),
(3709, ".$new_language_id.",'Джизак'),
(3710, ".$new_language_id.",'Наманган'),
(3711, ".$new_language_id.",'Навои'),
(3712, ".$new_language_id.",'Кашкадарьинская'),
(3713, ".$new_language_id.",'Qoraqalpog&#39;iston Republikasi'),
(3714, ".$new_language_id.",'Самарканд'),
(3715, ".$new_language_id.",'Сырдарьинская'),
(3716, ".$new_language_id.",'Сурхандарьинская'),
(3717, ".$new_language_id.",'Ташкент Город'),
(3718, ".$new_language_id.",'Ташкент Регион'),
(3719, ".$new_language_id.",'Хорезмская область'),
(3720, ".$new_language_id.",'Malampa'),
(3721, ".$new_language_id.",'Penama'),
(3722, ".$new_language_id.",'Sanma'),
(3723, ".$new_language_id.",'Шефа'),
(3724, ".$new_language_id.",'Тафеа'),
(3725, ".$new_language_id.",'Торба'),
(3726, ".$new_language_id.",'Amazonas'),
(3727, ".$new_language_id.",'Ансоатеги'),
(3728, ".$new_language_id.",'Апуре'),
(3729, ".$new_language_id.",'Арагуа'),
(3730, ".$new_language_id.",'Баринас'),
(3731, ".$new_language_id.",'Боливар'),
(3732, ".$new_language_id.",'Карабобо'),
(3733, ".$new_language_id.",'Cojedes'),
(3734, ".$new_language_id.",'Дельта-Амакуро'),
(3735, ".$new_language_id.",'Dependencias Federales'),
(3736, ".$new_language_id.",'Федеральный округ'),
(3737, ".$new_language_id.",'Сокол'),
(3738, ".$new_language_id.",'Гуарико'),
(3739, ".$new_language_id.",'Лара'),
(3740, ".$new_language_id.",'Мерида'),
(3741, ".$new_language_id.",'Миранда'),
(3742, ".$new_language_id.",'Monagas'),
(3743, ".$new_language_id.",'Нуэва Эспарта'),
(3744, ".$new_language_id.",'Португеза'),
(3745, ".$new_language_id.",'Сукре'),
(3746, ".$new_language_id.",'Тачира'),
(3747, ".$new_language_id.",'Трухильо'),
(3748, ".$new_language_id.",'Варгас'),
(3749, ".$new_language_id.",'Yaracuy'),
(3750, ".$new_language_id.",'Сулия'),
(3751, ".$new_language_id.",'Жанг'),
(3752, ".$new_language_id.",'Бак Жанг'),
(3753, ".$new_language_id.",'Бак Кан'),
(3754, ".$new_language_id.",'Бак Лью'),
(3755, ".$new_language_id.",'Бак Нинь'),
(3756, ".$new_language_id.",'Ba Ria-Вунгтау'),
(3757, ".$new_language_id.",'Бен Тре'),
(3758, ".$new_language_id.",'Бинь Динь'),
(3759, ".$new_language_id.",'Бинь Дуонг'),
(3760, ".$new_language_id.",'Бинь Phuoc'),
(3761, ".$new_language_id.",'Бинь Туан'),
(3762, ".$new_language_id.",'Камау'),
(3763, ".$new_language_id.",'Кантхо'),
(3764, ".$new_language_id.",'Каобанг'),
(3765, ".$new_language_id.",'Дак Лак'),
(3766, ".$new_language_id.",'Дак Нонг'),
(3767, ".$new_language_id.",'Дананг'),
(3768, ".$new_language_id.",'Дьен-Бьен-'),
(3769, ".$new_language_id.",'Донг Най'),
(3770, ".$new_language_id.",'Донгтхап'),
(3771, ".$new_language_id.",'Гия Лай'),
(3772, ".$new_language_id.",'Ха Жанг'),
(3773, ".$new_language_id.",'Хайзыонг'),
(3774, ".$new_language_id.",'Хайфон'),
(3775, ".$new_language_id.",'Ха Нам'),
(3776, ".$new_language_id.",'Ханой'),
(3777, ".$new_language_id.",'Хатэй'),
(3778, ".$new_language_id.",'Ха Тинь'),
(3779, ".$new_language_id.",'Хоа Бинь'),
(3780, ".$new_language_id.",'Хошимин'),
(3781, ".$new_language_id.",'Хау Джианг'),
(3782, ".$new_language_id.",'Хунг Йен'),
(3783, ".$new_language_id.",'Сент-Круа'),
(3784, ".$new_language_id.",'Святой Иоанн'),
(3785, ".$new_language_id.",'Сент-Томас'),
(3786, ".$new_language_id.",'Ало'),
(3787, ".$new_language_id.",'Sigave'),
(3788, ".$new_language_id.",'Уоллис'),
(3789, ".$new_language_id.",'Абьян'),
(3790, ".$new_language_id.",'Адан'),
(3791, ".$new_language_id.",'Амран'),
(3792, ".$new_language_id.",'Аль Байда'),
(3793, ".$new_language_id.",'Эль-Дали'),
(3794, ".$new_language_id.",'Dhamar'),
(3795, ".$new_language_id.",'Хадрамаут'),
(3796, ".$new_language_id.",'Хадджа'),
(3797, ".$new_language_id.",'Ходейда'),
(3798, ".$new_language_id.",'Ибб'),
(3799, ".$new_language_id.",'Эль-Джауф'),
(3800, ".$new_language_id.",'Лагич'),
(3801, ".$new_language_id.",'Ma&#39;rib'),
(3802, ".$new_language_id.",'Аль Mahrah'),
(3803, ".$new_language_id.",'Аль Mahwit'),
(3804, ".$new_language_id.",'Сааде'),
(3805, ".$new_language_id.",'Сана'),
(3806, ".$new_language_id.",'Shabwah'),
(3807, ".$new_language_id.",'Таиз'),
(3808, ".$new_language_id.",'Косово'),
(3809, ".$new_language_id.",'Черногория'),
(3810, ".$new_language_id.",'Сербия'),
(3811, ".$new_language_id.",'Воеводина'),
(3812, ".$new_language_id.",'Нижнее Конго'),
(3813, ".$new_language_id.",'Бандунду'),
(3814, ".$new_language_id.",'Экваториальная'),
(3815, ".$new_language_id.",'Катанга'),
(3816, ".$new_language_id.",'Восточное Касаи'),
(3817, ".$new_language_id.",'Киншаса'),
(3818, ".$new_language_id.",'Касаи-Оксидентал'),
(3819, ".$new_language_id.",'Маниема'),
(3820, ".$new_language_id.",'Северное Киву'),
(3821, ".$new_language_id.",'Восточная'),
(3822, ".$new_language_id.",'Южное Киву'),
(3823, ".$new_language_id.",'Центральный'),
(3824, ".$new_language_id.",'Коппербелт'),
(3825, ".$new_language_id.",'Восточный'),
(3826, ".$new_language_id.",'Луапула'),
(3827, ".$new_language_id.",'Лусака'),
(3828, ".$new_language_id.",'Северный'),
(3829, ".$new_language_id.",'Северо-Западный'),
(3830, ".$new_language_id.",'Южный'),
(3831, ".$new_language_id.",'Западный'),
(3832, ".$new_language_id.",'Булавайо'),
(3833, ".$new_language_id.",'Хараре'),
(3834, ".$new_language_id.",'Маникаленд'),
(3835, ".$new_language_id.",'Центральный Машоналенд'),
(3836, ".$new_language_id.",'Mashonaland Восток'),
(3837, ".$new_language_id.",'Западный Машоналенд'),
(3838, ".$new_language_id.",'Масвинго'),
(3839, ".$new_language_id.",'Северный Матабелеленд'),
(3840, ".$new_language_id.",'Южный Матабелеленд'),
(3841, ".$new_language_id.",'Мидлендс'),
(3842, ".$new_language_id.",'Агридженто'),
(3843, ".$new_language_id.",'Алессандрия'),
(3844, ".$new_language_id.",'Анкона'),
(3845, ".$new_language_id.",'Аоста'),
(3846, ".$new_language_id.",'Ареццо'),
(3847, ".$new_language_id.",'Асколи-Пичено'),
(3848, ".$new_language_id.",'Асти'),
(3849, ".$new_language_id.",'Авеллино'),
(3850, ".$new_language_id.",'Бари'),
(3851, ".$new_language_id.",'Беллуно'),
(3852, ".$new_language_id.",'Беневенто'),
(3853, ".$new_language_id.",'Бергамо'),
(3854, ".$new_language_id.",'Биелла'),
(3855, ".$new_language_id.",'Болонья'),
(3856, ".$new_language_id.",'Больцано'),
(3857, ".$new_language_id.",'Брешиа'),
(3858, ".$new_language_id.",'Бриндизи'),
(3859, ".$new_language_id.",'Кальяри'),
(3860, ".$new_language_id.",'Кальтаниссетта'),
(3861, ".$new_language_id.",'Кампобассо'),
(3862, ".$new_language_id.",'Carbonia-Иглесиас'),
(3863, ".$new_language_id.",'Казерта'),
(3864, ".$new_language_id.",'Катания'),
(3865, ".$new_language_id.",'Катандзаро'),
(3866, ".$new_language_id.",'Кьети'),
(3867, ".$new_language_id.",'Комо'),
(3868, ".$new_language_id.",'Козенца'),
(3869, ".$new_language_id.",'Кремона'),
(3870, ".$new_language_id.",'Кротоне'),
(3871, ".$new_language_id.",'Кунео'),
(3872, ".$new_language_id.",'Энна'),
(3873, ".$new_language_id.",'Феррара'),
(3874, ".$new_language_id.",'Firenze'),
(3875, ".$new_language_id.",'Фоджа'),
(3876, ".$new_language_id.",'Форли-Чезена'),
(3877, ".$new_language_id.",'Фрозиноне'),
(3878, ".$new_language_id.",'Genova'),
(3879, ".$new_language_id.",'Гориция'),
(3880, ".$new_language_id.",'Гроссето'),
(3881, ".$new_language_id.",'Imperia'),
(3882, ".$new_language_id.",'Изерния'),
(3883, ".$new_language_id.",'L&#39;Aquila'),
(3884, ".$new_language_id.",'Специя'),
(3885, ".$new_language_id.",'Латина'),
(3886, ".$new_language_id.",'Лечче'),
(3887, ".$new_language_id.",'Лекко'),
(3888, ".$new_language_id.",'Ливорно'),
(3889, ".$new_language_id.",'Лоди'),
(3890, ".$new_language_id.",'Лукка'),
(3891, ".$new_language_id.",'Мачерата'),
(3892, ".$new_language_id.",'Мантуя'),
(3893, ".$new_language_id.",'Масса-Каррара'),
(3894, ".$new_language_id.",'Матера'),
(3895, ".$new_language_id.",'Медио Кампидано'),
(3896, ".$new_language_id.",'Мессина'),
(3897, ".$new_language_id.",'Milano'),
(3898, ".$new_language_id.",'Модена'),
(3899, ".$new_language_id.",'Наполи'),
(3900, ".$new_language_id.",'Новара'),
(3901, ".$new_language_id.",'Нуоро'),
(3902, ".$new_language_id.",'Ogliastra'),
(3903, ".$new_language_id.",'Ольвия-Темпио'),
(3904, ".$new_language_id.",'Ористано'),
(3905, ".$new_language_id.",'Падуя'),
(3906, ".$new_language_id.",'Палермо'),
(3907, ".$new_language_id.",'Парма'),
(3908, ".$new_language_id.",'Павия'),
(3909, ".$new_language_id.",'Перуджа'),
(3910, ".$new_language_id.",'Пезаро э Урбино'),
(3911, ".$new_language_id.",'Пескара'),
(3912, ".$new_language_id.",'Пьяченца'),
(3913, ".$new_language_id.",'Пиза'),
(3914, ".$new_language_id.",'Пистойя'),
(3915, ".$new_language_id.",'Порденоне'),
(3916, ".$new_language_id.",'Potenza'),
(3917, ".$new_language_id.",'Прато'),
(3918, ".$new_language_id.",'Рагуза'),
(3919, ".$new_language_id.",'Равенна'),
(3920, ".$new_language_id.",'Реджо-ди-Калабрия'),
(3921, ".$new_language_id.",'Реджо-Эмилия'),
(3922, ".$new_language_id.",'Риети'),
(3923, ".$new_language_id.",'Римини'),
(3924, ".$new_language_id.",'Цыган'),
(3925, ".$new_language_id.",'Ровиго'),
(3926, ".$new_language_id.",'Салерно'),
(3927, ".$new_language_id.",'Сассари'),
(3928, ".$new_language_id.",'Савона'),
(3929, ".$new_language_id.",'Сиена'),
(3930, ".$new_language_id.",'Сиракузы'),
(3931, ".$new_language_id.",'Сондрио'),
(3932, ".$new_language_id.",'Таранто'),
(3933, ".$new_language_id.",'Терамо'),
(3934, ".$new_language_id.",'Терни'),
(3935, ".$new_language_id.",'Турин'),
(3936, ".$new_language_id.",'Трапани'),
(3937, ".$new_language_id.",'Тренто'),
(3938, ".$new_language_id.",'Тревизо'),
(3939, ".$new_language_id.",'Триест'),
(3940, ".$new_language_id.",'Удине'),
(3941, ".$new_language_id.",'Варезе'),
(3942, ".$new_language_id.",'Венеция'),
(3943, ".$new_language_id.",'Вербано-Кузьо-Оссола'),
(3944, ".$new_language_id.",'Верчелли'),
(3945, ".$new_language_id.",'Верона'),
(3946, ".$new_language_id.",'Вибо-Валентия'),
(3947, ".$new_language_id.",'Виченца'),
(3948, ".$new_language_id.",'Витербо'),
(3949, ".$new_language_id.",'Антрим'),
(3950, ".$new_language_id.",'Арма'),
(3951, ".$new_language_id.",'Вниз'),
(3952, ".$new_language_id.",'Фермана'),
(3953, ".$new_language_id.",'Дерри'),
(3954, ".$new_language_id.",'Тайрон');
");

$this->db->query("INSERT INTO ".$this->db->table('stock_statuses')."
(`stock_status_id`,`language_id`, `name`) VALUES
(1, ".$new_language_id.",'На складе'),
(2, ".$new_language_id.",'Распродано'),
(3, ".$new_language_id.",'Предварительный заказ');
");

$this->db->query("INSERT INTO ".$this->db->table('length_class_descriptions')."
(`length_class_id`, `language_id`, `title`, `unit`) VALUES
(1, ".$new_language_id.",'Сантиметр','см'),
(2, ".$new_language_id.",'Миллиметр','мм'),
(3, ".$new_language_id.",'Дюйм','дм');
");

$this->db->query("INSERT INTO ".$this->db->table('weight_class_descriptions')."
(`weight_class_id`, `language_id`, `title`, `unit`) VALUES
(1, ".$new_language_id.",'Килограмм','кг'),
(2, ".$new_language_id.",'Грамм','г'),
(5, ".$new_language_id.",'Фунт','фт'),
(6, ".$new_language_id.",'Унция','ун');
");

$this->db->query("INSERT INTO ".$this->db->table('order_statuses')."
(`order_status_id`, `language_id`, `name`) VALUES
(10, ".$new_language_id.", 'Не удалось'),
(9, ".$new_language_id.", 'Отменен'),
(8, ".$new_language_id.", 'Отказано'),
(7, ".$new_language_id.", 'Отменен'),
(5, ".$new_language_id.", 'Завершен'),
(3, ".$new_language_id.", 'Поставляется'),
(2, ".$new_language_id.", 'В обработке'),
(1, ".$new_language_id.", 'В ожидании'),
(0, ".$new_language_id.", 'Не завершен'),
(11, ".$new_language_id.", 'Возмещенный'),
(12, ".$new_language_id.", 'Обратный'),
(13, ".$new_language_id.", 'Chargeback');
");

$this->db->query("INSERT INTO ".$this->db->table('page_descriptions')."
(`page_id`, `language_id`, `name`, `title`, `seo_url`, `keywords`, `description`, `content`, `date_added`) VALUES
(1, ".$new_language_id.", 'Все другие страницы','','','','','',now() ),
(2, ".$new_language_id.", 'Главная страница','','','','','',now() ),
(3, ".$new_language_id.", 'Страницы Оформления заказа','','','','','',now()),
(4, ".$new_language_id.", 'Страницы входа клиентов','','','','','',now()),
(5, ".$new_language_id.", 'Продукты по умолчанию','','','','','',now()),
(10, ".$new_language_id.", 'Страница режима обслуживание','','','','','',now()),
(11, ".$new_language_id.", 'Страницы личного кабинета','','','','','',now());
");

$this->db->query("INSERT INTO ".$this->db->table('global_attributes_type_descriptions')."
(`attribute_type_id`, `language_id`, `type_name`, `date_added`) VALUES
(1, ".$new_language_id.", 'Атрибуты Продуктов', NOW()),
(2, ".$new_language_id.", 'Атрибуты Файлов', NOW());
");

$this->db->query("INSERT INTO ".$this->db->table('form_descriptions')."
(`form_id`, `language_id`, `description`) VALUES
(2, ".$new_language_id.",'Свяжитесь с Нами');
");

$this->db->query("INSERT INTO ".$this->db->table('field_descriptions')."
(`field_id`, `name`, `error_text`, `language_id`) VALUES
(11,'Имя:','Имя должно быть от 3 до 32 символов!',".$new_language_id."),
(12,'E-mail:','E-Mail, кажется, не действует!',".$new_language_id."),
(13,'Запрос:','Запрос должен быть между 10 и 3000 символов!',".$new_language_id."),
(14,'Введите код, указанный на картинке:','Проверка код не совпадает с изображением!',".$new_language_id.");");

// part of content probably no need to load ???
/*
$this->db->query("INSERT INTO ".DB_PREFIX."tax_rate_descriptions
(`tax_rate_id`,`language_id`, `description`)
VALUES
(1, ".$new_language_id.",'Розничная 8,5%');
");

$this->db->query("INSERT INTO ".DB_PREFIX."tax_class_descriptions
(`tax_class_id`,`language_id`, `title`, `description`)
VALUES
(1, ".$new_language_id.",'Налогооблагаемые Товары','Облагаемые налогом товары');
");
*/

$this->cache->remove('localization');
