SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";

--
-- DDL for table `address`
--
-- NOTE: If update table keep in mind ac_addresses_enc
--
DROP TABLE IF EXISTS `ac_addresses`;
CREATE TABLE `ac_addresses` (
  `address_id` int(11) NOT NULL AUTO_INCREMENT,
  `customer_id` int(11) NOT NULL,
  `company` varchar(32) COLLATE utf8_general_ci NOT NULL,
  `firstname` varchar(32) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `lastname` varchar(32) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `address_1` varchar(128) COLLATE utf8_general_ci NOT NULL,
  `address_2` varchar(128) COLLATE utf8_general_ci NOT NULL,
  `postcode` varchar(10) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `city` varchar(128) COLLATE utf8_general_ci NOT NULL,
  `country_id` int(11) NOT NULL DEFAULT '0',
  `zone_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`address_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci AUTO_INCREMENT=1;
CREATE INDEX `ac_addresses_idx` ON `ac_addresses` ( `customer_id`, `country_id`, `zone_id`  );

--
-- DDL for table `categories`
--
DROP TABLE IF EXISTS `ac_categories`;
CREATE TABLE `ac_categories` (
  `category_id` int(11) NOT NULL AUTO_INCREMENT,
  `parent_id` int(11) NOT NULL DEFAULT '0',
  `sort_order` int(3) NOT NULL DEFAULT '0',
  `status` int(1) NOT NULL DEFAULT '1',
  `date_added` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`category_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci AUTO_INCREMENT=1;
CREATE INDEX `ac_categories_idx` ON `ac_categories` ( `category_id`, `parent_id`, `status`  );

--
-- DDL for table `category_descriptions`
--
DROP TABLE IF EXISTS `ac_category_descriptions`;
CREATE TABLE `ac_category_descriptions` (
  `category_id` int(11) NOT NULL,
  `language_id` int(11) NOT NULL,
  `name` varchar(255) COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT 'translatable',
  `meta_keywords` varchar(255) COLLATE utf8_general_ci NOT NULL COMMENT 'translatable',
  `meta_description` varchar(255) COLLATE utf8_general_ci NOT NULL COMMENT 'translatable',
  `description` text COLLATE utf8_general_ci NOT NULL COMMENT 'translatable',
  PRIMARY KEY (`category_id`,`language_id`),
  KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;


--
-- DDL for table `categories_to_stores`
--
DROP TABLE IF EXISTS `ac_categories_to_stores`;
CREATE TABLE `ac_categories_to_stores` (
  `category_id` int(11) NOT NULL,
  `store_id` int(11) NOT NULL,
  PRIMARY KEY (`category_id`,`store_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

--
-- DDL for table `countries`
--
DROP TABLE IF EXISTS `ac_countries`;
CREATE TABLE `ac_countries` (
  `country_id` int(11) NOT NULL AUTO_INCREMENT,
  `iso_code_2` varchar(2) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `iso_code_3` varchar(3) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `address_format` text COLLATE utf8_general_ci NOT NULL,
  `status` int(1) NOT NULL DEFAULT '1',
  `sort_order` int(3) NOT NULL DEFAULT '0',
  PRIMARY KEY (`country_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci AUTO_INCREMENT=1;
CREATE INDEX `ac_countries_idx` ON `ac_countries` ( `iso_code_2`, `iso_code_3`, `status`  );

--
-- Dumping data for table `countries`
--
INSERT INTO `ac_countries` (`country_id`, `iso_code_2`, `iso_code_3`, `address_format`, `status`, `sort_order`)
VALUES
(1,'AF','AFG','',1,0),
(2,'AL','ALB','',1,0),
(3,'DZ','DZA','',1,0),
(4,'AS','ASM','',1,0),
(5,'AD','AND','',1,0),
(6,'AO','AGO','',1,0),
(7,'AI','AIA','',1,0),
(8,'AQ','ATA','',1,0),
(9,'AG','ATG','',1,0),
(10,'AR','ARG','',1,0),
(11,'AM','ARM','',1,0),
(12,'AW','ABW','',1,0),
(13,'AU','AUS','',1,0),
(14,'AT','AUT','',1,0),
(15,'AZ','AZE','',1,0),
(16,'BS','BHS','',1,0),
(17,'BH','BHR','',1,0),
(18,'BD','BGD','',1,0),
(19,'BB','BRB','',1,0),
(20,'BY','BLR','',1,0),
(21,'BE','BEL','',1,0),
(22,'BZ','BLZ','',1,0),
(23,'BJ','BEN','',1,0),
(24,'BM','BMU','',1,0),
(25,'BT','BTN','',1,0),
(26,'BO','BOL','',1,0),
(27,'BA','BIH','',1,0),
(28,'BW','BWA','',1,0),
(29,'BV','BVT','',1,0),
(30,'BR','BRA','',1,0),
(31,'IO','IOT','',1,0),
(32,'BN','BRN','',1,0),
(33,'BG','BGR','',1,0),
(34,'BF','BFA','',1,0),
(35,'BI','BDI','',1,0),
(36,'KH','KHM','',1,0),
(37,'CM','CMR','',1,0),
(38,'CA','CAN','',1,0),
(39,'CV','CPV','',1,0),
(40,'KY','CYM','',1,0),
(41,'CF','CAF','',1,0),
(42,'TD','TCD','',1,0),
(43,'CL','CHL','',1,0),
(44,'CN','CHN','',1,0),
(45,'CX','CXR','',1,0),
(46,'CC','CCK','',1,0),
(47,'CO','COL','',1,0),
(48,'KM','COM','',1,0),
(49,'CG','COG','',1,0),
(50,'CK','COK','',1,0),
(51,'CR','CRI','',1,0),
(52,'CI','CIV','',1,0),
(53,'HR','HRV','',1,0),
(54,'CU','CUB','',1,0),
(55,'CY','CYP','',1,0),
(56,'CZ','CZE','',1,0),
(57,'DK','DNK','',1,0),
(58,'DJ','DJI','',1,0),
(59,'DM','DMA','',1,0),
(60,'DO','DOM','',1,0),
(61,'TL','TLS','',1,0),
(62,'EC','ECU','',1,0),
(63,'EG','EGY','',1,0),
(64,'SV','SLV','',1,0),
(65,'GQ','GNQ','',1,0),
(66,'ER','ERI','',1,0),
(67,'EE','EST','',1,0),
(68,'ET','ETH','',1,0),
(69,'FK','FLK','',1,0),
(70,'FO','FRO','',1,0),
(71,'FJ','FJI','',1,0),
(72,'FI','FIN','',1,0),
(73,'FR','FRA','',1,0),
(74,'FX','FXX','',1,0),
(75,'GF','GUF','',1,0),
(76,'PF','PYF','',1,0),
(77,'TF','ATF','',1,0),
(78,'GA','GAB','',1,0),
(79,'GM','GMB','',1,0),
(80,'GE','GEO','',1,0),
(81,'DE','DEU','',1,0),
(82,'GH','GHA','',1,0),
(83,'GI','GIB','',1,0),
(84,'GR','GRC','',1,0),
(85,'GL','GRL','',1,0),
(86,'GD','GRD','',1,0),
(87,'GP','GLP','',1,0),
(88,'GU','GUM','',1,0),
(89,'GT','GTM','',1,0),
(90,'GN','GIN','',1,0),
(91,'GW','GNB','',1,0),
(92,'GY','GUY','',1,0),
(93,'HT','HTI','',1,0),
(94,'HM','HMD','',1,0),
(95,'HN','HND','',1,0),
(96,'HK','HKG','',1,0),
(97,'HU','HUN','',1,0),
(98,'IS','ISL','',1,0),
(99,'IN','IND','',1,0),
(100,'ID','IDN','',1,0),
(101,'IR','IRN','',1,0),
(102,'IQ','IRQ','',1,0),
(103,'IE','IRL','',1,0),
(104,'IL','ISR','',1,0),
(105,'IT','ITA','',1,0),
(106,'JM','JAM','',1,0),
(107,'JP','JPN','',1,0),
(108,'JO','JOR','',1,0),
(109,'KZ','KAZ','',1,0),
(110,'KE','KEN','',1,0),
(111,'KI','KIR','',1,0),
(112,'KP','PRK','',1,0),
(113,'KR','KOR','',1,0),
(114,'KW','KWT','',1,0),
(115,'KG','KGZ','',1,0),
(116,'LA','LAO','',1,0),
(117,'LV','LVA','',1,0),
(118,'LB','LBN','',1,0),
(119,'LS','LSO','',1,0),
(120,'LR','LBR','',1,0),
(121,'LY','LBY','',1,0),
(122,'LI','LIE','',1,0),
(123,'LT','LTU','',1,0),
(124,'LU','LUX','',1,0),
(125,'MO','MAC','',1,0),
(126,'MK','MKD','',1,0),
(127,'MG','MDG','',1,0),
(128,'MW','MWI','',1,0),
(129,'MY','MYS','',1,0),
(130,'MV','MDV','',1,0),
(131,'ML','MLI','',1,0),
(132,'MT','MLT','',1,0),
(133,'MH','MHL','',1,0),
(134,'MQ','MTQ','',1,0),
(135,'MR','MRT','',1,0),
(136,'MU','MUS','',1,0),
(137,'YT','MYT','',1,0),
(138,'MX','MEX','',1,0),
(139,'FM','FSM','',1,0),
(140,'MD','MDA','',1,0),
(141,'MC','MCO','',1,0),
(142,'MN','MNG','',1,0),
(143,'MS','MSR','',1,0),
(144,'MA','MAR','',1,0),
(145,'MZ','MOZ','',1,0),
(146,'MM','MMR','',1,0),
(147,'NA','NAM','',1,0),
(148,'NR','NRU','',1,0),
(149,'NP','NPL','',1,0),
(150,'NL','NLD','',1,0),
(151,'AN','ANT','',1,0),
(152,'NC','NCL','',1,0),
(153,'NZ','NZL','',1,0),
(154,'NI','NIC','',1,0),
(155,'NE','NER','',1,0),
(156,'NG','NGA','',1,0),
(157,'NU','NIU','',1,0),
(158,'NF','NFK','',1,0),
(159,'MP','MNP','',1,0),
(160,'NO','NOR','',1,0),
(161,'OM','OMN','',1,0),
(162,'PK','PAK','',1,0),
(163,'PW','PLW','',1,0),
(164,'PA','PAN','',1,0),
(165,'PG','PNG','',1,0),
(166,'PY','PRY','',1,0),
(167,'PE','PER','',1,0),
(168,'PH','PHL','',1,0),
(169,'PN','PCN','',1,0),
(170,'PL','POL','',1,0),
(171,'PT','PRT','',1,0),
(172,'PR','PRI','',1,0),
(173,'QA','QAT','',1,0),
(174,'RE','REU','',1,0),
(175,'RO','ROM','',1,0),
(176,'RU','RUS','',1,0),
(177,'RW','RWA','',1,0),
(178,'KN','KNA','',1,0),
(179,'LC','LCA','',1,0),
(180,'VC','VCT','',1,0),
(181,'WS','WSM','',1,0),
(182,'SM','SMR','',1,0),
(183,'ST','STP','',1,0),
(184,'SA','SAU','',1,0),
(185,'SN','SEN','',1,0),
(186,'SC','SYC','',1,0),
(187,'SL','SLE','',1,0),
(188,'SG','SGP','',1,0),
(189,'SK','SVK','',1,0),
(190,'SI','SVN','',1,0),
(191,'SB','SLB','',1,0),
(192,'SO','SOM','',1,0),
(193,'ZA','ZAF','',1,0),
(194,'GS','SGS','',1,0),
(195,'ES','ESP','',1,0),
(196,'LK','LKA','',1,0),
(197,'SH','SHN','',1,0),
(198,'PM','SPM','',1,0),
(199,'SD','SDN','',1,0),
(200,'SR','SUR','',1,0),
(201,'SJ','SJM','',1,0),
(202,'SZ','SWZ','',1,0),
(203,'SE','SWE','',1,0),
(204,'CH','CHE','',1,0),
(205,'SY','SYR','',1,0),
(206,'TW','TWN','',1,0),
(207,'TJ','TJK','',1,0),
(208,'TZ','TZA','',1,0),
(209,'TH','THA','',1,0),
(210,'TG','TGO','',1,0),
(211,'TK','TKL','',1,0),
(212,'TO','TON','',1,0),
(213,'TT','TTO','',1,0),
(214,'TN','TUN','',1,0),
(215,'TR','TUR','',1,0),
(216,'TM','TKM','',1,0),
(217,'TC','TCA','',1,0),
(218,'TV','TUV','',1,0),
(219,'UG','UGA','',1,0),
(220,'UA','UKR','',1,0),
(221,'AE','ARE','',1,0),
(222,'GB','GBR','',1,0),
(223,'US','USA','{firstname} {lastname}\r\n{company}\r\n{address_1}\r\n{address_2}\r\n{city}, {zone} {postcode}\r\n{country}',1,0),
(224,'UM','UMI','',1,0),
(225,'UY','URY','',1,0),
(226,'UZ','UZB','',1,0),
(227,'VU','VUT','',1,0),
(228,'VA','VAT','',1,0),
(229,'VE','VEN','',1,0),
(230,'VN','VNM','',1,0),
(231,'VG','VGB','',1,0),
(232,'VI','VIR','',1,0),
(233,'WF','WLF','',1,0),
(234,'EH','ESH','',1,0),
(235,'YE','YEM','',1,0),
(236,'ME','MNE','',1,0),
(237,'CW','CUW','',1,0),
(238,'ZM','ZMB','',1,0),
(239,'ZW','ZWE','',1,0),
(240,'GB','NIR','',1,0),
(241,'RS','SRB','',1,0),
(242,'XK','XXK','',1,0),
(243,'SS','RSS','',1,0);

--
-- DDL for table `ac_country_descriptions`
--
DROP TABLE IF EXISTS `ac_country_descriptions`;
CREATE TABLE `ac_country_descriptions` (
  `country_id` int(11) NOT NULL,
  `language_id` int(11) NOT NULL,
  `name` varchar(128) COLLATE utf8_general_ci NOT NULL COMMENT 'translatable',
  PRIMARY KEY (`country_id`,`language_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `ac_country_descriptions` (`country_id`, `language_id`, `name`)
VALUES
(1,1,'Afghanistan'),
(2,1,'Albania'),
(3,1,'Algeria'),
(4,1,'American Samoa'),
(5,1,'Andorra'),
(6,1,'Angola'),
(7,1,'Anguilla'),
(8,1,'Antarctica'),
(9,1,'Antigua and Barbuda'),
(10,1,'Argentina'),
(11,1,'Armenia'),
(12,1,'Aruba'),
(13,1,'Australia'),
(14,1,'Austria'),
(15,1,'Azerbaijan'),
(16,1,'Bahamas'),
(17,1,'Bahrain'),
(18,1,'Bangladesh'),
(19,1,'Barbados'),
(20,1,'Belarus'),
(21,1,'Belgium'),
(22,1,'Belize'),
(23,1,'Benin'),
(24,1,'Bermuda'),
(25,1,'Bhutan'),
(26,1,'Bolivia'),
(27,1,'Bosnia and Herzegowina'),
(28,1,'Botswana'),
(29,1,'Bouvet Island'),
(30,1,'Brazil'),
(31,1,'British Indian Ocean Territory'),
(32,1,'Brunei Darussalam'),
(33,1,'Bulgaria'),
(34,1,'Burkina Faso'),
(35,1,'Burundi'),
(36,1,'Cambodia'),
(37,1,'Cameroon'),
(38,1,'Canada'),
(39,1,'Cabo Verde'),
(40,1,'Cayman Islands'),
(41,1,'Central African Republic'),
(42,1,'Chad'),
(43,1,'Chile'),
(44,1,'China'),
(45,1,'Christmas Island'),
(46,1,'Cocos (Keeling) Islands'),
(47,1,'Colombia'),
(48,1,'Comoros'),
(49,1,'Congo'),
(50,1,'Cook Islands'),
(51,1,'Costa Rica'),
(52,1,'Côte d\'Ivoire'),
(53,1,'Croatia'),
(54,1,'Cuba'),
(55,1,'Cyprus'),
(56,1,'Czech Republic'),
(57,1,'Denmark'),
(58,1,'Djibouti'),
(59,1,'Dominica'),
(60,1,'Dominican Republic'),
(61,1,'Timor-Leste'),
(62,1,'Ecuador'),
(63,1,'Egypt'),
(64,1,'El Salvador'),
(65,1,'Equatorial Guinea'),
(66,1,'Eritrea'),
(67,1,'Estonia'),
(68,1,'Ethiopia'),
(69,1,'Falkland Islands (Malvinas)'),
(70,1,'Faroe Islands'),
(71,1,'Fiji'),
(72,1,'Finland'),
(73,1,'France'),
(74,1,'France, Metropolitan'),
(75,1,'French Guiana'),
(76,1,'French Polynesia'),
(77,1,'French Southern Territories'),
(78,1,'Gabon'),
(79,1,'Gambia'),
(80,1,'Georgia'),
(81,1,'Germany'),
(82,1,'Ghana'),
(83,1,'Gibraltar'),
(84,1,'Greece'),
(85,1,'Greenland'),
(86,1,'Grenada'),
(87,1,'Guadeloupe'),
(88,1,'Guam'),
(89,1,'Guatemala'),
(90,1,'Guinea'),
(91,1,'Guinea-bissau'),
(92,1,'Guyana'),
(93,1,'Haiti'),
(94,1,'Heard and Mc Donald Islands'),
(95,1,'Honduras'),
(96,1,'Hong Kong'),
(97,1,'Hungary'),
(98,1,'Iceland'),
(99,1,'India'),
(100,1,'Indonesia'),
(101,1,'Iran (Islamic Republic of)'),
(102,1,'Iraq'),
(103,1,'Ireland'),
(104,1,'Israel'),
(105,1,'Italy'),
(106,1,'Jamaica'),
(107,1,'Japan'),
(108,1,'Jordan'),
(109,1,'Kazakhstan'),
(110,1,'Kenya'),
(111,1,'Kiribati'),
(112,1,'North Korea'),
(113,1,'Korea, Republic of'),
(114,1,'Kuwait'),
(115,1,'Kyrgyzstan'),
(116,1,'Lao People\'s Democratic Republic'),
(117,1,'Latvia'),
(118,1,'Lebanon'),
(119,1,'Lesotho'),
(120,1,'Liberia'),
(121,1,'Libyan Arab Jamahiriya'),
(122,1,'Liechtenstein'),
(123,1,'Lithuania'),
(124,1,'Luxembourg'),
(125,1,'Macau'),
(126,1,'North Macedonia'),
(127,1,'Madagascar'),
(128,1,'Malawi'),
(129,1,'Malaysia'),
(130,1,'Maldives'),
(131,1,'Mali'),
(132,1,'Malta'),
(133,1,'Marshall Islands'),
(134,1,'Martinique'),
(135,1,'Mauritania'),
(136,1,'Mauritius'),
(137,1,'Mayotte'),
(138,1,'Mexico'),
(139,1,'Micronesia, Federated States of'),
(140,1,'Moldova, Republic of'),
(141,1,'Monaco'),
(142,1,'Mongolia'),
(143,1,'Montserrat'),
(144,1,'Morocco'),
(145,1,'Mozambique'),
(146,1,'Myanmar'),
(147,1,'Namibia'),
(148,1,'Nauru'),
(149,1,'Nepal'),
(150,1,'Netherlands'),
(151,1,'Netherlands Antilles'),
(152,1,'New Caledonia'),
(153,1,'New Zealand'),
(154,1,'Nicaragua'),
(155,1,'Niger'),
(156,1,'Nigeria'),
(157,1,'Niue'),
(158,1,'Norfolk Island'),
(159,1,'Northern Mariana Islands'),
(160,1,'Norway'),
(161,1,'Oman'),
(162,1,'Pakistan'),
(163,1,'Palau'),
(164,1,'Panama'),
(165,1,'Papua New Guinea'),
(166,1,'Paraguay'),
(167,1,'Peru'),
(168,1,'Philippines'),
(169,1,'Pitcairn'),
(170,1,'Poland'),
(171,1,'Portugal'),
(172,1,'Puerto Rico'),
(173,1,'Qatar'),
(174,1,'Reunion'),
(175,1,'Romania'),
(176,1,'Russia'),
(177,1,'Rwanda'),
(178,1,'Saint Kitts and Nevis'),
(179,1,'Saint Lucia'),
(180,1,'Saint Vincent and the Grenadines'),
(181,1,'Samoa'),
(182,1,'San Marino'),
(183,1,'Sao Tome and Principe'),
(184,1,'Saudi Arabia'),
(185,1,'Senegal'),
(186,1,'Seychelles'),
(187,1,'Sierra Leone'),
(188,1,'Singapore'),
(189,1,'Slovak Republic'),
(190,1,'Slovenia'),
(191,1,'Solomon Islands'),
(192,1,'Somalia'),
(193,1,'South Africa'),
(194,1,'South Georgia &amp; South Sandwich Islands'),
(195,1,'Spain'),
(196,1,'Sri Lanka'),
(197,1,'St. Helena'),
(198,1,'St. Pierre and Miquelon'),
(199,1,'Sudan'),
(200,1,'Suriname'),
(201,1,'Svalbard and Jan Mayen Islands'),
(202,1,'Eswatini'),
(203,1,'Sweden'),
(204,1,'Switzerland'),
(205,1,'Syrian Arab Republic'),
(206,1,'Taiwan'),
(207,1,'Tajikistan'),
(208,1,'Tanzania, United Republic of'),
(209,1,'Thailand'),
(210,1,'Togo'),
(211,1,'Tokelau'),
(212,1,'Tonga'),
(213,1,'Trinidad and Tobago'),
(214,1,'Tunisia'),
(215,1,'Turkey'),
(216,1,'Turkmenistan'),
(217,1,'Turks and Caicos Islands'),
(218,1,'Tuvalu'),
(219,1,'Uganda'),
(220,1,'Ukraine'),
(221,1,'United Arab Emirates'),
(222,1,'United Kingdom'),
(223,1,'United States'),
(224,1,'United States Minor Outlying Islands'),
(225,1,'Uruguay'),
(226,1,'Uzbekistan'),
(227,1,'Vanuatu'),
(228,1,'Vatican City State (Holy See)'),
(229,1,'Venezuela'),
(230,1,'Viet Nam'),
(231,1,'Virgin Islands (British)'),
(232,1,'Virgin Islands (U.S.)'),
(233,1,'Wallis and Futuna Islands'),
(234,1,'Western Sahara'),
(235,1,'Yemen'),
(236,1,'Montenegro'),
(237,1,'Curaçao'),
(238,1,'Zambia'),
(239,1,'Zimbabwe'),
(240,1,'Northern Ireland'),
(241,1,'Serbia'),
(242,1,'Kosovo'),
(243,1,'South Sudan');


--
-- DDL for table `coupons`
--
DROP TABLE IF EXISTS `ac_coupons`;
CREATE TABLE `ac_coupons` (
  `coupon_id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(10) COLLATE utf8_general_ci NOT NULL,
  `type` char(1) COLLATE utf8_general_ci NOT NULL,
  `discount` decimal(15,4) NOT NULL,
  `logged` int(1) NOT NULL,
  `shipping` int(1) NOT NULL,
  `total` decimal(15,4) NOT NULL,
  `date_start` date NULL,
  `date_end` date NULL,
  `uses_total` int(11) NOT NULL,
  `uses_customer` varchar(11) COLLATE utf8_general_ci NOT NULL,
  `status` int(1) NOT NULL,
  `condition_rule` ENUM('OR', 'AND') NOT NULL DEFAULT 'OR',
  `date_added` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`coupon_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci AUTO_INCREMENT=1;


--
-- DDL for table `coupon_descriptions`
--
DROP TABLE IF EXISTS `ac_coupon_descriptions`;
CREATE TABLE `ac_coupon_descriptions` (
  `coupon_id` int(11) NOT NULL,
  `language_id` int(11) NOT NULL,
  `name` varchar(128) COLLATE utf8_general_ci NOT NULL COMMENT 'translatable',
  `description` text COLLATE utf8_general_ci NOT NULL COMMENT 'translatable',
  PRIMARY KEY (`coupon_id`,`language_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;


--
-- DDL for table `coupon_products`
--
DROP TABLE IF EXISTS `ac_coupons_products`;
CREATE TABLE `ac_coupons_products` (
  `coupon_product_id` int(11) NOT NULL AUTO_INCREMENT,
  `coupon_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  PRIMARY KEY (`coupon_product_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci AUTO_INCREMENT=1;

CREATE INDEX `ac_coupons_products_idx` ON `ac_coupons_products` ( `coupon_id`, `product_id`  );
--
-- DDL for table `coupon_categories`
--
DROP TABLE IF EXISTS `ac_coupons_categories`;
CREATE TABLE `ac_coupons_categories` (
  `coupon_category_id` int(11) NOT NULL AUTO_INCREMENT,
  `coupon_id` int(11) NOT NULL,
  `category_id` int(11) NOT NULL,
  PRIMARY KEY (`coupon_category_id`)
) ENGINE=MyISAM AUTO_INCREMENT=1;

CREATE INDEX `ac_coupons_categories_idx` ON `ac_coupons_categories` ( `coupon_id`, `category_id`  );


--
-- DDL for table `currencies`
--
DROP TABLE IF EXISTS `ac_currencies`;
CREATE TABLE `ac_currencies` (
  `currency_id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(32) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `code` varchar(3) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `symbol_left` varchar(12) COLLATE utf8_general_ci NOT NULL,
  `symbol_right` varchar(12) COLLATE utf8_general_ci NOT NULL,
  `decimal_place` char(1) COLLATE utf8_general_ci NOT NULL,
  `value` decimal(15,8) NOT NULL,
  `status` int(1) NOT NULL,
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`currency_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci AUTO_INCREMENT=1;

--
-- Dumping data for table `currency`
--

INSERT INTO `ac_currencies` (`currency_id`, `title`, `code`, `symbol_left`, `symbol_right`, `decimal_place`, `value`, `status`, `date_modified`) VALUES
(1, 'US Dollar', 'USD', '$', '', '2', 1.00, 1, '2011-06-20 21:00:00'),
(2, 'Euro', 'EUR', '', '€', '2', 0.93850000 , 1, '2011-06-20 21:00:00'),
(3, 'Pound Sterling', 'GBP', '£', '', '2', 0.79330000, 1, '2011-06-20 21:00:00');

--
-- DDL for table `customers`
--
-- NOTE: If update table keep in mind ac_customers_enc
--

DROP TABLE IF EXISTS `ac_customers`;
CREATE TABLE `ac_customers` (
  `customer_id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) NOT NULL DEFAULT '0',
  `firstname` varchar(32) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `lastname` varchar(32) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `loginname` varchar(96) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `email` varchar(96) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `telephone` varchar(32) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `fax` varchar(32) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `sms` varchar(32) COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT 'mobile phone number',
  `salt` varchar(8) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `password` varchar(40) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `cart` LONGTEXT COLLATE utf8_general_ci,
  `wishlist` LONGTEXT COLLATE utf8_general_ci,
  `newsletter` int(1) NOT NULL DEFAULT '0',
  `address_id` int(11) NOT NULL DEFAULT '0',
  `status` int(1) NOT NULL,
  `approved` int(1) NOT NULL DEFAULT '0',
  `customer_group_id` int(11) NOT NULL,
  `ip` varchar(50) COLLATE utf8_general_ci NOT NULL DEFAULT '0',
  `data` text DEFAULT null,
  `date_added` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `last_login` timestamp NULL,
  PRIMARY KEY (`customer_id`),
  UNIQUE KEY `customers_loginname` (`loginname`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci AUTO_INCREMENT=1;

CREATE INDEX `ac_customers_idx` ON `ac_customers` ( `store_id`, `address_id`, `customer_group_id` );
CREATE FULLTEXT INDEX `ac_customers_name_idx` ON `ac_customers` (`firstname`, `lastname`);
--
-- DDL for table `customer_groups`
--
DROP TABLE IF EXISTS `ac_customer_groups`;
CREATE TABLE `ac_customer_groups` (
  `customer_group_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(32) COLLATE utf8_general_ci NOT NULL,
  `tax_exempt` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`customer_group_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci AUTO_INCREMENT=1;

--
-- Dumping data for table `customer_groups`
--

INSERT INTO `ac_customer_groups` ( `name`, `tax_exempt`) VALUES
('Default', '0'),
('Wholesalers', '1'),
('Newsletter Subscribers', '0');

--
-- DDL for table table `ac_customer_transactions`
--
DROP TABLE IF EXISTS `ac_customer_transactions`;
CREATE TABLE `ac_customer_transactions` (
  `customer_transaction_id` int(11) NOT NULL AUTO_INCREMENT,
  `customer_id` int(11) NOT NULL DEFAULT '0',
  `order_id` int(11) NOT NULL DEFAULT '0',
  `created_by` int(11) NOT NULL  COMMENT 'user_id for admin, customer_id for storefront section',
  `section` smallint(1) NOT NULL DEFAULT '0' COMMENT '1 - admin, 0 - customer',
  `credit` DECIMAL(15,4) DEFAULT '0',
  `debit` DECIMAL(15,4) DEFAULT '0',
  `transaction_type` varchar(255) NOT NULL DEFAULT '' COMMENT 'text type of transaction',
  `comment` text COMMENT 'comment for internal use',
  `description` text COMMENT 'text for customer',
  `date_added` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`customer_transaction_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci AUTO_INCREMENT=1;
CREATE INDEX `ac_customer_transactions_idx` ON `ac_customer_transactions` ( `customer_id`, `order_id` );

--
-- DDL for table `ac_online_customers`
--

DROP TABLE IF EXISTS `ac_online_customers`;
CREATE TABLE `ac_online_customers` (
  `customer_id` int(11) NOT NULL,
  `ip` varchar(50) NOT NULL,
  `url` text NOT NULL,
  `referer` text NOT NULL,
  `date_added` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`ip`),
  KEY `ac_online_customers_idx` (`date_added`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

--
-- DDL for table `download`
--
DROP TABLE IF EXISTS `ac_downloads`;
CREATE TABLE `ac_downloads` (
  `download_id` int(11) NOT NULL AUTO_INCREMENT,
  `filename` varchar(128) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `mask` varchar(128) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `max_downloads` int(11) DEFAULT NULL, -- remaining, NULL -> No limit
  `expire_days` int(11) DEFAULT NULL,  -- default to NULL -> No expiration
  `sort_order` int(11) NOT NULL,
  `activate` varchar(64) NOT NULL,
  `activate_order_status_id` varchar(256) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `shared` int(1) NOT NULL DEFAULT '0', -- if used by other products set to 1
  `status` int(1) NOT NULL DEFAULT '0', -- in migration set to 1
  `date_added` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY (`download_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci AUTO_INCREMENT=1;
CREATE INDEX `ac_downloads_idx` ON `ac_downloads` ( `activate_order_status_id`, `shared` );
--
-- DDL for table `download_descriptions`
--
DROP TABLE IF EXISTS `ac_download_descriptions`;
CREATE TABLE `ac_download_descriptions` (
  `download_id` int(11) NOT NULL,
  `language_id` int(11) NOT NULL,
  `name` varchar(64) COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT 'translatable',
  PRIMARY KEY (`download_id`,`language_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;


-- All data is taken from global attribute
DROP TABLE IF EXISTS `ac_download_attribute_values`;
CREATE TABLE `ac_download_attribute_values` (
  `download_attribute_id` int(11) NOT NULL AUTO_INCREMENT,
  `attribute_id` int(11) NOT NULL,
  `download_id` int(11) NOT NULL,
  `attribute_value_ids` text COLLATE utf8_general_ci  DEFAULT NULL,  -- serialized array with value IDs
  PRIMARY KEY (`download_attribute_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci AUTO_INCREMENT=1;

CREATE INDEX `ac_download_attribute_values_idx` ON `ac_download_attribute_values` ( `attribute_id`, `download_id` );

--
-- DDL for table `extensions`
--
DROP TABLE IF EXISTS `ac_extensions`;
CREATE TABLE `ac_extensions` (
  `extension_id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(32) COLLATE utf8_general_ci NOT NULL,
  `key` varchar(32) COLLATE utf8_general_ci NOT NULL,
  `category` varchar(32) COLLATE utf8_general_ci NOT NULL,
  `status` smallint(1) NOT NULL,
  `priority` smallint(1) NOT NULL DEFAULT 0,
  `version` varchar(32),
  `license_key` varchar(32),
  `date_installed` timestamp NULL,
  `support_expiration` DATETIME NULL,
  `mp_product_url` VARCHAR(255) NULL DEFAULT '',
  `date_added` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`extension_id`),
  UNIQUE KEY `extension_key` (`key`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci AUTO_INCREMENT=1;

--
-- Dumping data for table `extension`
--

INSERT INTO `ac_extensions`
    (`type`, `key`, `category`, `status`, `priority`, `version`, `license_key`, `date_installed`, `date_modified`, `date_added`)

VALUES
('total', 'coupon', '', 1, 1, '', null, now(), now(), now() ),
('total', 'shipping', 'shipping', 1, 1, '', null, now(), now(), now() ),
('total', 'low_order_fee', '', 0, 1, '', null, now(), now(), now() ),
('total', 'handling', '', 0, 1, '', null, now(), now(), now() ),
('total', 'sub_total', '', 1, 1, '', null, now(), now(), now() ),
('total', 'tax', '', 1, 1, '', null, now(), now(), now() ),
('total', 'total', '', 1, 1, '', null, now(), now(), now() ),
('total', 'balance', '', 1, 1, '', null, now(), now(), now() ),

('block', 'cart', '', 1, 1, '', null, now(), now(), now() ),
('block', 'category', '', 1, 1, '', null, now(), now(), now() ),
('block', 'content', '', 1, 1, '', null, now(), now(), now() ),
('block', 'manufacturer', '', 1, 1, '', null, now(), now(), now() ),
('block', 'bestseller', '', 1, 1, '', null, now(), now(), now() ),
('block', 'latest', '', 1, 1, '', null, now(), now(), now() ),
('block', 'featured', '', 1, 1, '', null, now(), now(), now() ),

('extensions', 'banner_manager', 'extensions', 1, 1, '1.1.0', null, now(), now(), now() ),
('extensions', 'forms_manager', 'extensions', 1, 1, '1.1.0', null, now(), now(), now() ),
('template', 'novator', 'template', 0, 1, '1.0.0', null, NOW(), now() + INTERVAL 4 MINUTE , now() )
;

--
-- DDL for tables of banner manager
--
DROP TABLE IF EXISTS `ac_banners`;
CREATE TABLE `ac_banners` (
	`banner_id` int(11) NOT NULL AUTO_INCREMENT,
	`status` int(1) NOT NULL DEFAULT '0',
	`banner_type` int(11) NOT NULL DEFAULT '1',
	`banner_group_name` varchar(255) NOT NULL DEFAULT '',
	`start_date` timestamp NULL DEFAULT NULL,
	`end_date` timestamp NULL DEFAULT NULL,
	`blank` tinyint(1) NOT NULL DEFAULT '0',
	`target_url` text COLLATE utf8_general_ci DEFAULT '',
	`sort_order` int(11) NOT NULL,
	`date_added` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
	`date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
	PRIMARY KEY (`banner_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

DROP TABLE IF EXISTS `ac_banner_descriptions`;
CREATE TABLE `ac_banner_descriptions` (
  `banner_id` int(11) NOT NULL,
  `language_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL COMMENT 'translatable',
  `description` LONGTEXT COLLATE utf8_general_ci NOT NULL COMMENT 'translatable',
  `meta` text(1500) DEFAULT '' COMMENT 'translatable',
  `date_added` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`banner_id`,`language_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

DROP TABLE IF EXISTS `ac_banner_stat`;
CREATE TABLE `ac_banner_stat` (
	`rowid` INT NOT NULL AUTO_INCREMENT,
  `banner_id` int(11) NOT NULL,
  `type` int(11) NOT NULL, -- 1 = view, 2 = click
  `time` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `store_id` int(11) NOT NULL,
  `user_info` text(1500) DEFAULT '',
PRIMARY KEY (`rowid`),
INDEX `ac_banner_stat_idx` (`banner_id`, `type`, `time`, `store_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci AUTO_INCREMENT=1;

--
-- DDL for table `locations`
--
DROP TABLE IF EXISTS `ac_locations`;
CREATE TABLE `ac_locations` (
  `location_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(32) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `description` varchar(255) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `date_added` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`location_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci AUTO_INCREMENT=1;

--
-- Dumping data for table `ac_locations`
--

INSERT INTO `ac_locations` (`location_id`, `name`, `description`, `date_added`) VALUES
(1, 'USA', 'All States', NOW()),
(2, 'Canada','All provinces', NOW());

--
-- DDL for table `languages`
--
DROP TABLE IF EXISTS `ac_languages`;
CREATE TABLE `ac_languages` (
  `language_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(32) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `code` varchar(5) COLLATE utf8_general_ci NOT NULL,
  `locale` varchar(255) COLLATE utf8_general_ci NOT NULL,
  `image` varchar(255) COLLATE utf8_general_ci NOT NULL,
  `directory` varchar(32) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `filename` varchar(64) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `sort_order` int(3) NOT NULL DEFAULT '0',
  `status` int(1) NOT NULL,
  PRIMARY KEY (`language_id`),
  KEY `name` (`name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci AUTO_INCREMENT=1;
CREATE UNIQUE INDEX `ac_languages_idx`
ON `ac_languages` ( `language_id`,`code` );
--
-- Dumping data for table `languages`
--

INSERT INTO `ac_languages` (`language_id`, `name`, `code`, `locale`, `image`, `directory`, `filename`, `sort_order`, `status`) VALUES
(1, 'English', 'en', 'en_US.UTF-8,en_US,en-gb,english', '', 'english', 'english', 1, 1);

--
-- DDL for table `language_definitions`
--
DROP TABLE IF EXISTS `ac_language_definitions`;
CREATE TABLE `ac_language_definitions` (
  `language_definition_id` int(11) NOT NULL auto_increment,
  `language_id` int(11) NOT NULL,
  `section` tinyint(1) NOT NULL default '0' COMMENT '0-SF, 1-ADMIN',
  `block` varchar(160) NOT NULL,
  `language_key` varchar(170) NOT NULL,
  `language_value` text NOT NULL COMMENT 'translatable',
  `date_added` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY  (`language_definition_id`, `language_id`, `section`, `block`, `language_key`),
	INDEX `ac_lang_definition_idx` (`language_value`(500) ASC)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci AUTO_INCREMENT=1;

--
-- DDL for table `length_class`
--
DROP TABLE IF EXISTS `ac_length_classes`;
CREATE TABLE `ac_length_classes` (
  `length_class_id` int(11) NOT NULL AUTO_INCREMENT,
  `value` decimal(15,8) NOT NULL,
  `iso_code` VARCHAR(5) NOT NULL,
  `date_added` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`length_class_id`,`iso_code`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci AUTO_INCREMENT=1;

--
-- Dumping data for table `length_class`
--
INSERT INTO `ac_length_classes` (`length_class_id`, `value`, `iso_code`) VALUES
(1, '1.00000000', 'CMET'),
(2, '10.00000000', 'MMET'),
(3, '0.39370000', 'INCH');

--
-- DDL for table `length_class_descriptions`
--
DROP TABLE IF EXISTS `ac_length_class_descriptions`;
CREATE TABLE `ac_length_class_descriptions` (
  `length_class_id` int(11) NOT NULL,
  `language_id` int(11) NOT NULL,
  `title` varchar(32) COLLATE utf8_general_ci NOT NULL COMMENT 'translatable',
  `unit` varchar(4) COLLATE utf8_general_ci NOT NULL COMMENT 'translatable',
  PRIMARY KEY (`length_class_id`,`language_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

--
-- Dumping data for table `length_class_descriptions`
--

INSERT INTO `ac_length_class_descriptions` (`length_class_id`, `language_id`, `title`, `unit`) VALUES
(1, 1, 'Centimeter', 'cm'),
(2, 1, 'Millimeter', 'mm'),
(3, 1, 'Inch', 'in');

--
-- DDL for table `manufacturers`
--
DROP TABLE IF EXISTS `ac_manufacturers`;
CREATE TABLE `ac_manufacturers` (
  `manufacturer_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(64) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `sort_order` int(3) NOT NULL,
  PRIMARY KEY (`manufacturer_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci AUTO_INCREMENT=1;


--
-- DDL for table `manufacturers_to_store`
--
DROP TABLE IF EXISTS `ac_manufacturers_to_stores`;
CREATE TABLE `ac_manufacturers_to_stores` (
  `manufacturer_id` int(11) NOT NULL,
  `store_id` int(11) NOT NULL,
  PRIMARY KEY (`manufacturer_id`,`store_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;


--
-- DDL for table `orders`
--
-- NOTE: If update table keep in mind ac_orders_enc
--
DROP TABLE IF EXISTS `ac_orders`;
CREATE TABLE `ac_orders` (
  `order_id` int(11) NOT NULL AUTO_INCREMENT,
  `invoice_id` int(11) NOT NULL DEFAULT '0',
  `invoice_prefix` varchar(10) NOT NULL DEFAULT '',
  `store_id` int(11) NOT NULL DEFAULT '0',
  `store_name` varchar(64) NOT NULL,
  `store_url` varchar(255) NOT NULL,
  `customer_id` int(11) NOT NULL DEFAULT '0',
  `customer_group_id` int(11) NOT NULL DEFAULT '0',
  `firstname` varchar(32) NOT NULL DEFAULT '',
  `lastname` varchar(32) NOT NULL,
  `telephone` varchar(32) NOT NULL DEFAULT '',
  `fax` varchar(32) NOT NULL DEFAULT '',
  `email` varchar(96) NOT NULL DEFAULT '',
  `shipping_firstname` varchar(32) NOT NULL,
  `shipping_lastname` varchar(32) NOT NULL DEFAULT '',
  `shipping_company` varchar(32) NOT NULL,
  `shipping_address_1` varchar(128) NOT NULL,
  `shipping_address_2` varchar(128) NOT NULL,
  `shipping_city` varchar(128) NOT NULL,
  `shipping_postcode` varchar(10) NOT NULL DEFAULT '',
  `shipping_zone` varchar(128) NOT NULL,
  `shipping_zone_id` int(11) NOT NULL,
  `shipping_country` varchar(128) NOT NULL,
  `shipping_country_id` int(11) NOT NULL,
  `shipping_address_format` text NOT NULL,
  `shipping_method` varchar(128) NOT NULL DEFAULT '',
  `shipping_method_key` varchar(128) NOT NULL DEFAULT '',
  `payment_firstname` varchar(32) NOT NULL DEFAULT '',
  `payment_lastname` varchar(32) NOT NULL DEFAULT '',
  `payment_company` varchar(32) NOT NULL,
  `payment_address_1` varchar(128) NOT NULL,
  `payment_address_2` varchar(128) NOT NULL,
  `payment_city` varchar(128) NOT NULL,
  `payment_postcode` varchar(10) NOT NULL DEFAULT '',
  `payment_zone` varchar(128) NOT NULL,
  `payment_zone_id` int(11) NOT NULL,
  `payment_country` varchar(128) NOT NULL,
  `payment_country_id` int(11) NOT NULL,
  `payment_address_format` text NOT NULL,
  `payment_method` varchar(128) NOT NULL DEFAULT '',
  `payment_method_key` varchar(128) NOT NULL DEFAULT '',
  `comment` text NOT NULL,
  `total` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `order_status_id` int(11) NOT NULL DEFAULT '0',
  `language_id` int(11) NOT NULL,
  `currency_id` int(11) NOT NULL,
  `currency` varchar(3) NOT NULL,
  `value` decimal(15,8) NOT NULL,
  `coupon_id` int(11) NOT NULL,
  `date_added` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `ip` varchar(50) NOT NULL DEFAULT '',
  `payment_method_data` text NOT NULL DEFAULT '',
  PRIMARY KEY (`order_id`, `customer_id`, `order_status_id`)

) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci AUTO_INCREMENT=1;

CREATE INDEX `ac_orders_idx`
ON `ac_orders` (`invoice_id`,
								`store_id`,
								`customer_group_id`,
								`shipping_zone_id`,
								`shipping_country_id`,
								`payment_zone_id`,
								`payment_country_id`,
								`language_id`,
								`currency_id`,
								`coupon_id`);
--
-- DDL for table `order_downloads`
--
DROP TABLE IF EXISTS `ac_order_downloads`;
CREATE TABLE `ac_order_downloads` (
  `order_download_id` int(11) NOT NULL AUTO_INCREMENT,
  `order_id` int(11) NOT NULL,
  `order_product_id` int(11) NOT NULL,
  `name` varchar(64) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `filename` varchar(128) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `mask` varchar(128) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `download_id` int(11) NOT NULL,
  `status` int(1) NOT NULL DEFAULT '0',
  `remaining_count` int(11) DEFAULT NULL,
  `percentage` int(11) DEFAULT '0',
  `expire_date` datetime NULL,
  `sort_order` int(11) NOT NULL,
  `activate` VARCHAR(64) NOT NULL,
  `activate_order_status_id` VARCHAR(256) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `attributes_data` longtext COLLATE utf8_general_ci  DEFAULT NULL,  -- serialized values
  `date_added` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY (`order_download_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci AUTO_INCREMENT=1;

CREATE INDEX `ac_order_downloads_idx`
ON `ac_order_downloads` (`order_id`, `order_product_id`, `download_id`, `status`, `activate_order_status_id`);
--
-- DDL for table `order_downloads`
--
DROP TABLE IF EXISTS `ac_order_downloads_history`;
CREATE TABLE `ac_order_downloads_history` (
  `order_download_history_id` int(11) NOT NULL AUTO_INCREMENT,
  `order_download_id` int(11) NOT NULL,
  `order_id` int(11) NOT NULL,
  `order_product_id` int(11) NOT NULL,
  `filename` varchar(128) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `mask` varchar(128) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `download_id` int(11) NOT NULL,
  `download_percent` int(11) DEFAULT '0',
  `time` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY (`order_download_history_id`,`order_download_id`, `order_id`,`order_product_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci AUTO_INCREMENT=1;

CREATE INDEX `ac_order_downloads_history_idx`
ON `ac_order_downloads_history` (`download_id`);

--
-- DDL for table `ac_order_data`
-- Table to keep other order details (future dev)
--
DROP TABLE IF EXISTS `ac_order_data`;
CREATE TABLE `ac_order_data` (
  `order_id` int(11) NOT NULL,
  `type_id` int(11) NOT NULL,
  `data` text COLLATE utf8_general_ci DEFAULT NULL,  -- serialized values
  `date_added` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY (`order_id`, `type_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

DROP TABLE IF EXISTS `ac_order_data_types`;
CREATE TABLE `ac_order_data_types` (
  `type_id` int(11) NOT NULL AUTO_INCREMENT,
  `language_id` int(11) NOT NULL,
  `name` varchar(64) COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT 'translatable',
  `date_added` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY (`type_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci AUTO_INCREMENT=1;

-- write pre-installed IM protocols for guest checkout orders
INSERT INTO `ac_order_data_types` (`language_id`, `name`, `date_added`) VALUES
(1, 'email', NOW()),
(1, 'sms', NOW()),
-- fastCheckout data
(1, 'guest_token', NOW());


--
-- DDL for table `order_history`
--
DROP TABLE IF EXISTS `ac_order_history`;
CREATE TABLE `ac_order_history` (
  `order_history_id` int(11) NOT NULL AUTO_INCREMENT,
  `order_id` int(11) NOT NULL,
  `order_status_id` int(5) NOT NULL,
  `notify` int(1) NOT NULL DEFAULT '0',
  `comment` text COLLATE utf8_general_ci NOT NULL,
  `date_added` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`order_history_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci AUTO_INCREMENT=1;

CREATE INDEX `ac_order_history_idx`
ON `ac_order_history` (`order_id`, `order_status_id`, `notify`);

--
-- DDL for table `order_options`
--
DROP TABLE IF EXISTS `ac_order_options`;
CREATE TABLE `ac_order_options` (
  `order_option_id` int(11) NOT NULL AUTO_INCREMENT,
  `order_id` int(11) NOT NULL,
  `order_product_id` int(11) NOT NULL,
  `product_option_value_id` int(11) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL,
  `sku` varchar(64) NOT NULL DEFAULT '',
  `value` text NOT NULL,
  `price` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `cost` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `prefix` char(1) NOT NULL DEFAULT '',
  `settings` longtext,
  PRIMARY KEY (`order_option_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci AUTO_INCREMENT=1;

CREATE INDEX `ac_order_options_idx`
ON `ac_order_options` (`order_id`, `order_product_id`, `product_option_value_id`);


--
-- DDL for table `order_products`
--
DROP TABLE IF EXISTS `ac_order_products`;
CREATE TABLE `ac_order_products` (
  `order_product_id` int(11) NOT NULL AUTO_INCREMENT,
  `order_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL DEFAULT '',
  `model` varchar(24) NOT NULL DEFAULT '',
  `sku` varchar(64) NOT NULL DEFAULT '',
  `price` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `cost` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `weight` DECIMAL(15,4) NOT NULL DEFAULT 0.0,
  `weight_iso_code` VARCHAR(5) NOT NULL DEFAULT '',
  `width` DECIMAL(15,4) NOT NULL DEFAULT 0,
  `length` DECIMAL(15,4) NOT NULL DEFAULT 0,
  `height` DECIMAL(15,4) NOT NULL DEFAULT 0,
  `length_iso_code` VARCHAR(5) NOT NULL DEFAULT '',
  `total` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `tax` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `quantity` int(4) NOT NULL DEFAULT '0',
  `subtract` int(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_product_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci AUTO_INCREMENT=1;

CREATE INDEX `ac_order_products_idx` ON `ac_order_products` (`order_id`,  `product_id`);

--
-- DDL for table `order_statuses`
--
DROP TABLE IF EXISTS `ac_order_statuses`;
CREATE TABLE `ac_order_statuses` (
  `order_status_id` int(11) NOT NULL,
  `language_id` int(11) NOT NULL,
  `name` varchar(32) COLLATE utf8_general_ci NOT NULL COMMENT 'translatable',
  PRIMARY KEY (`order_status_id`,`language_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

--
-- Dumping data for table `order_statuses`
--

INSERT INTO `ac_order_statuses` (`order_status_id`, `language_id`, `name`) VALUES
(0, 1, 'Incomplete'),
(1, 1, 'Pending'),
(2, 1, 'Processing'),
(3, 1, 'Shipped'),
(7, 1, 'Canceled'),
(5, 1, 'Completed'),
(8, 1, 'Denied'),
(9, 1, 'Canceled Reversal'),
(10, 1, 'Failed'),
(11, 1, 'Refunded'),
(12, 1, 'Reversed'),
(13, 1, 'Chargeback'),
(14, 1, 'Canceled by Customer');

--
-- DDL for table `order_status_ids`
--
DROP TABLE IF EXISTS `ac_order_status_ids`;
CREATE TABLE `ac_order_status_ids` (
  `order_status_id` int(11) NOT NULL,
  `status_text_id` varchar(64) NOT NULL,
  PRIMARY KEY (`order_status_id`,`status_text_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
CREATE UNIQUE INDEX `ac_order_status_ids_idx`
ON `ac_order_status_ids` ( `status_text_id`);

INSERT INTO `ac_order_status_ids` (`order_status_id`, `status_text_id`) VALUES
(0, 'incomplete'),
(1, 'pending'),
(2, 'processing'),
(3, 'shipped'),
(7, 'canceled'),
(5, 'completed'),
(8, 'denied'),
(9, 'canceled_reversal'),
(10, 'failed'),
(11, 'refunded'),
(12, 'reversed'),
(13, 'chargeback'),
(14, 'canceled_by_customer');

--
-- DDL for table `order_totals`
--
DROP TABLE IF EXISTS `ac_order_totals`;
CREATE TABLE `ac_order_totals` (
  `order_total_id` int(10) NOT NULL AUTO_INCREMENT,
  `order_id` int(11) NOT NULL,
  `title` varchar(255) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `text` varchar(255) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `value` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `sort_order` int(3) NOT NULL,
  `type` varchar(255) COLLATE utf8_general_ci NOT NULL DEFAULT '',
   `key` varchar(128) NOT NULL DEFAULT '',
 PRIMARY KEY (`order_total_id`),
  KEY `idx_orders_total_orders_id` (`order_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci AUTO_INCREMENT=1;


--
-- DDL for table `products`
--
DROP TABLE IF EXISTS `ac_products`;
CREATE TABLE `ac_products` (
  `product_id` int(11) NOT NULL AUTO_INCREMENT,
  `model` varchar(64) COLLATE utf8_general_ci NOT NULL,
  `sku` varchar(64) COLLATE utf8_general_ci NOT NULL,
  `location` varchar(128) COLLATE utf8_general_ci NOT NULL,
  `quantity` int(4) NOT NULL DEFAULT '0',
  `stock_checkout` CHAR(1) NULL DEFAULT '',
  `stock_status_id` int(11) NOT NULL,
  `manufacturer_id` int(11) NOT NULL,
  `shipping` int(1) NOT NULL DEFAULT '1',
  `ship_individually` int(1) NOT NULL DEFAULT '0',
  `free_shipping` int(1) NOT NULL DEFAULT '0',
  `shipping_price` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `price` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `tax_class_id` int(11) NOT NULL,
  `date_available` date NOT NULL,
  `weight` decimal(5,2) NOT NULL DEFAULT '0.00',
  `weight_class_id` int(11) NOT NULL DEFAULT '0',
  `length` decimal(5,2) NOT NULL DEFAULT '0.00',
  `width` decimal(5,2) NOT NULL DEFAULT '0.00',
  `height` decimal(5,2) NOT NULL DEFAULT '0.00',
  `length_class_id` int(11) NOT NULL DEFAULT '0',
  `status` int(1) NOT NULL DEFAULT '0',
  `viewed` int(5) NOT NULL DEFAULT '0',
  `sort_order` int(11) NOT NULL DEFAULT '0',
  `subtract` int(1) NOT NULL DEFAULT '1',
  `minimum` int(11) NOT NULL DEFAULT '1',
  `maximum` int(11) NOT NULL DEFAULT '0',
  `cost` DECIMAL(15,4) NOT NULL DEFAULT '0.0000',
  `call_to_order` smallint NOT NULL default '0',
  `settings` LONGTEXT COLLATE utf8_general_ci,
  `date_added` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`product_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci AUTO_INCREMENT=1;

CREATE INDEX `ac_products_idx` ON `ac_products` (`stock_status_id`,  `manufacturer_id`, `weight_class_id`, `length_class_id`);
CREATE INDEX `ac_products_status_idx` ON `ac_products` (`product_id`, `status`, `date_available`);


--
-- DDL for table `product_descriptions`
--
DROP TABLE IF EXISTS `ac_product_descriptions`;
CREATE TABLE `ac_product_descriptions` (
  `product_id` int(11) NOT NULL,
  `language_id` int(11) NOT NULL,
  `name` varchar(255) COLLATE utf8_general_ci NOT NULL COMMENT 'translatable',
  `meta_keywords` varchar(255) COLLATE utf8_general_ci NOT NULL COMMENT 'translatable',
  `meta_description` varchar(255) COLLATE utf8_general_ci NOT NULL COMMENT 'translatable',
  `description` longtext COLLATE utf8_general_ci NOT NULL COMMENT 'translatable',
  `blurb` text COLLATE utf8_general_ci NOT NULL COMMENT 'translatable',
  PRIMARY KEY (`product_id`,`language_id`),
  KEY `name` (`name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE INDEX `ac_product_descriptions_name_idx` ON `ac_product_descriptions` (`product_id`, `name`);

--
-- DDL for table `product_discounts`
--
DROP TABLE IF EXISTS `ac_product_discounts`;
CREATE TABLE `ac_product_discounts` (
  `product_discount_id` int(11) NOT NULL AUTO_INCREMENT,
  `product_id` int(11) NOT NULL,
  `customer_group_id` int(11) NOT NULL,
  `quantity` int(4) NOT NULL DEFAULT '0',
  `priority` int(5) NOT NULL DEFAULT '1',
  `price_prefix` CHAR(1) NOT NULL DEFAULT '',
  `price` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `date_start` date NULL,
  `date_end` date NULL,
  `date_added` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`product_discount_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci AUTO_INCREMENT=1;

CREATE INDEX `ac_product_discounts_idx` ON `ac_product_discounts` (`product_id`, `customer_group_id`);


--
-- DDL for table `product_featured`
--
DROP TABLE IF EXISTS `ac_products_featured`;
CREATE TABLE `ac_products_featured` (
  `product_id` int(11) NOT NULL DEFAULT '0',
	PRIMARY KEY (`product_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;


--
-- DDL for table `product_options`
--
DROP TABLE IF EXISTS `ac_product_options`;
CREATE TABLE `ac_product_options` (
  `product_option_id` int(11) NOT NULL AUTO_INCREMENT,
  `attribute_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `group_id` int(11) NOT NULL DEFAULT '0',
  `sort_order` int(3) NOT NULL DEFAULT '0',
  `status` int(1) NOT NULL DEFAULT '1',
  `element_type` char(1) NOT NULL DEFAULT 'I',
  `required` smallint(1) NOT NULL default '0',
  `regexp_pattern` varchar(255) NOT NULL default '',
  `settings` text COLLATE utf8_general_ci,
  PRIMARY KEY (`product_option_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci AUTO_INCREMENT=1;

CREATE INDEX `ac_product_options_idx` ON `ac_product_options` (`attribute_id`, `product_id`, `group_id` );

--
-- DDL for table `product_option_descriptions`
--
DROP TABLE IF EXISTS `ac_product_option_descriptions`;
CREATE TABLE `ac_product_option_descriptions` (
  `product_option_id` int(11) NOT NULL,
  `language_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `name` varchar(255) COLLATE utf8_general_ci NOT NULL COMMENT 'translatable',
  `option_placeholder` varchar(255) COLLATE utf8_general_ci DEFAULT '' COMMENT 'translatable',
  `error_text` 	varchar(255) COLLATE utf8_general_ci NOT NULL COMMENT 'translatable',
  PRIMARY KEY (`product_option_id`,`language_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
CREATE INDEX `ac_product_option_descriptions_idx` ON `ac_product_option_descriptions` ( `product_id` );
--
-- DDL for table `product_option_values`
--
DROP TABLE IF EXISTS `ac_product_option_values`;
CREATE TABLE `ac_product_option_values` (
  `product_option_value_id` int(11) NOT NULL AUTO_INCREMENT,
  `product_option_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `group_id` int(11) NOT NULL DEFAULT '0',
  `txt_id` varchar(255) NULL,
  `sku` varchar(255) DEFAULT NULL,
  `quantity` int(4) NOT NULL DEFAULT '0',
  `subtract` int(1) NOT NULL DEFAULT '0',
  `price` decimal(15,4) NOT NULL,
  `cost` decimal(15,4) NOT NULL,
  `prefix` char(1) COLLATE utf8_general_ci NOT NULL, -- % or $
  `weight` decimal(15,8) NOT NULL,
  `weight_type` varchar(3) COLLATE utf8_general_ci NOT NULL, -- lbs or %
  `attribute_value_id` int(11),
  `grouped_attribute_data` text DEFAULT NULL,
  `sort_order` int(3) NOT NULL,
  `default` smallint DEFAULT 0,
  PRIMARY KEY (`product_option_value_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci AUTO_INCREMENT=1;

CREATE INDEX `ac_product_option_values_idx` ON `ac_product_option_values` ( `product_option_id`, `product_id`, `group_id`, `attribute_value_id` );


--
-- DDL for table `product_option_value_descriptions`
--
DROP TABLE IF EXISTS `ac_product_option_value_descriptions`;
CREATE TABLE `ac_product_option_value_descriptions` (
  `product_option_value_id` int(11) NOT NULL,
  `language_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `name` text COLLATE utf8_general_ci DEFAULT NULL COMMENT 'translatable',
  `grouped_attribute_names` text COLLATE utf8_general_ci DEFAULT NULL,
  PRIMARY KEY (`product_option_value_id`,`language_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
CREATE INDEX `ac_product_option_value_descriptions_idx` ON `ac_product_option_value_descriptions` ( `product_id` );

--
-- DDL for table `product_related`
--
DROP TABLE IF EXISTS `ac_products_related`;
CREATE TABLE `ac_products_related` (
  `product_id` int(11) NOT NULL,
  `related_id` int(11) NOT NULL,
  PRIMARY KEY (`product_id`,`related_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;


--
-- DDL for table `product_specials`
--
DROP TABLE IF EXISTS `ac_product_specials`;
CREATE TABLE `ac_product_specials` (
  `product_special_id` int(11) NOT NULL AUTO_INCREMENT,
  `product_id` int(11) NOT NULL,
  `customer_group_id` int(11) NOT NULL,
  `priority` int(5) NOT NULL DEFAULT '1',
  `price_prefix` CHAR(1) NOT NULL DEFAULT '',
  `price` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `date_start` date NULL,
  `date_end` date NULL,
  `date_added` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`product_special_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci AUTO_INCREMENT=1;

CREATE INDEX `ac_product_specials_idx` ON `ac_product_specials` ( `product_id`, `customer_group_id` );

--
-- DDL for table `product_tags`
--
DROP TABLE IF EXISTS `ac_product_tags`;
CREATE TABLE `ac_product_tags` (
  `product_id` int(11) NOT NULL,
  `tag` varchar(32) COLLATE utf8_general_ci NOT NULL COMMENT 'translatable',
  `language_id` int(11) NOT NULL,
  PRIMARY KEY  (`product_id`,`tag`,`language_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;


--
-- DDL for table `product_to_categories`
--
DROP TABLE IF EXISTS `ac_products_to_categories`;
CREATE TABLE `ac_products_to_categories` (
  `product_id` int(11) NOT NULL,
  `category_id` int(11) NOT NULL,
  PRIMARY KEY (`product_id`,`category_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;


--
-- DDL for table `product_to_downloads`
--
DROP TABLE IF EXISTS `ac_products_to_downloads`;
CREATE TABLE `ac_products_to_downloads` (
  `product_id` int(11) NOT NULL,
  `download_id` int(11) NOT NULL,
  PRIMARY KEY (`product_id`,`download_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;


--
-- DDL for table `product_to_stores`
--
DROP TABLE IF EXISTS `ac_products_to_stores`;
CREATE TABLE `ac_products_to_stores` (
  `product_id` int(11) NOT NULL,
  `store_id` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`product_id`,`store_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;


--
-- DDL for table `reviews`
--
DROP TABLE IF EXISTS `ac_reviews`;
CREATE TABLE `ac_reviews` (
  `review_id` int(11) NOT NULL AUTO_INCREMENT,
  `product_id` int(11) NOT NULL,
  `customer_id` int(11) NOT NULL,
  `author` varchar(64) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `text` longtext COLLATE utf8_general_ci NOT NULL,
  `rating` int(1) NOT NULL,
  `verified_purchase` TINYINT NOT NULL DEFAULT 0,
  `status` int(1) NOT NULL DEFAULT '0',
  `date_added` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`review_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci AUTO_INCREMENT=1;

CREATE INDEX `ac_reviews_idx` ON `ac_reviews` ( `product_id`, `customer_id` );


--
-- DDL for table `settings`
--
DROP TABLE IF EXISTS `ac_settings`;
CREATE TABLE `ac_settings` (
  `setting_id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) NOT NULL DEFAULT 0,
  `group` varchar(32) COLLATE utf8_general_ci NOT NULL,
  `key` varchar(64) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `value` text COLLATE utf8_general_ci NOT NULL,
  `date_added` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
 PRIMARY KEY (`setting_id`, `store_id`, `group`, `key`),
 INDEX `ac_settings_idx` (`value`(500))
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci AUTO_INCREMENT=1;

--
-- Dumping data for table `settings`
--

INSERT INTO `ac_settings` (`group`, `key`, `value`) VALUES

-- store details
('details','store_name','Web Store Name'),
('details','config_url',''),
('details','config_ssl',0),
('details','config_ssl_url',''),
('details','config_owner','Your Name'),
('details','config_address','Address 1'),
('details','store_main_email','admin@abantecart.com'),
('details','config_telephone',123456789),
('details','config_fax',''),
('details','config_title_1','Your Store'),
('details','config_meta_description_1','Web Store Meta Description'),
('details','config_meta_keywords_1','keyword1,keyword2,keyword3'),
('details','config_description_1','Welcome to web store!'),
('details','config_country_id',223),
('details','config_zone_id',3655),
('details','config_storefront_language','en'),
('details','admin_language','en'),
('details','config_currency','USD'),
('details','config_currency_auto',0),
('details','config_length_class','in'),
('details','config_weight_class','lb'),
('details','auto_translate_status',1),
('details','translate_src_lang_code','en'),
('details','translate_override_existing',0),
('details','warn_lang_text_missing',0),
('details','config_duplicate_contact_us_to_message',1),
('details','config_opening_sunday_opens',''),
('details','config_opening_sunday_closes',''),
('details','config_opening_monday_opens','9:00'),
('details','config_opening_monday_closes','18:00'),
('details','config_opening_tuesday_opens','9:00'),
('details','config_opening_tuesday_closes','18:00'),
('details','config_opening_wednesday_opens','9:00'),
('details','config_opening_wednesday_closes','18:00'),
('details','config_opening_thursday_opens','9:00'),
('details','config_opening_thursday_closes','21:00'),
('details','config_opening_friday_opens','9:00'),
('details','config_opening_friday_closes','16:00'),
('details','config_opening_saturday_opens',''),
('details','config_opening_saturday_closes',''),
('details','config_postcode','07601'),
('details','protocol_url','https'),
('details','protocol_ssl_url','https'),
('details','config_city','New Jersey'),
('details','config_latitude','40.887187'),
('details','config_longitude','-74.037592'),
('details','translate_method','copy_source_text'),
('details','config_tax_class_id','1'),

-- general
('general','config_admin_limit',20),
('general','config_stock_display',1),
('general','config_nostock_autodisable',0),
('general','config_stock_status_id',0),
('general','enable_reviews',1),
('general','display_reviews',1),
('general','config_download',1),
('general','config_help_links',1),
('general','config_show_tree_data',1),
('general','config_embed_status',1),
('general','config_embed_click_action', 'modal'),
('general','config_product_default_sort_order','date_modified-DESC'),
('general','config_account_create_captcha','0'),
('general','config_recaptcha_site_key',''),
('general','config_recaptcha_secret_key',''),
('general','config_google_analytics_code',''),

-- Checkout
('checkout','starting_invoice_id',001),
('checkout','invoice_prefix','IN#'),
('checkout','config_cart_weight',0),
('checkout','config_shipping_session',0),
('checkout','config_tax', 0),
('checkout','config_tax_store',1),
('checkout','config_tax_customer',0),
('checkout','config_customer_price',1),
('checkout','config_customer_group_id',1),
('checkout','config_customer_approval',0),
('checkout','config_customer_email_activation',0),
('checkout','prevent_email_as_login',1),
('checkout','config_guest_checkout',1),
('checkout','config_account_id',2),
('checkout','config_checkout_id',3),
('checkout','config_stock_checkout',0),
('checkout','config_order_status_id',1),
('checkout','config_stock_subtract',0),
('checkout','config_cart_ajax',1),
('checkout','total_order_maximum',0),
('checkout','total_order_minimum',0),
('checkout','config_shipping_tax_estimate',1),
('checkout','config_coupon_on_cart_page',1),
('checkout','config_expire_order_days',30),
('checkout','config_customer_cancelation_order_status_id',''),
('checkout','config_zero_customer_balance','0'),
('checkout','config_phone_validation_pattern','/^[0-9\\+\\(\\)\\.\\s\\-,]+$/'),
('checkout','config_start_order_id',''),
('checkout','fast_checkout_allow_coupon',1),
('checkout','fast_checkout_show_order_comment_field',1),
('checkout','fast_checkout_buy_now_status',1),
('checkout','fast_checkout_create_account',1),

-- Appearance

('appearance','storefront_width','100%'),
('appearance','config_logo',281),
('appearance','config_mail_logo','7'),
('appearance','config_icon','8'),

('appearance','config_catalog_limit',18),
('appearance','config_bestseller_limit',3),
('appearance','config_featured_limit',3),
('appearance','config_latest_limit',3),
('appearance','config_special_limit',3),
('appearance','viewed_products_limit',3),

('appearance','config_image_thumb_width',380),
('appearance','config_image_thumb_height',380),
('appearance','config_image_popup_width',500),
('appearance','config_image_popup_height',500),
('appearance','config_image_product_width',250),
('appearance','config_image_product_height',250),
('appearance','config_image_additional_width',45),
('appearance','config_image_additional_height',45),
('appearance','config_image_related_width',120),
('appearance','config_image_related_height',120),
('appearance','config_image_cart_width',75),
('appearance','config_image_cart_height',75),
('appearance','config_image_grid_width',57),
('appearance','config_image_grid_height',57),
('appearance','config_image_category_height',120),
('appearance','config_image_category_width',120),
('appearance','config_image_manufacturer_height',56),
('appearance','config_image_manufacturer_width',130),
('appearance','admin_template','default'),
('appearance','admin_width','100%'),
('appearance','config_storefront_template','default'),
('appearance','config_image_resize_fill_color', '#ffffff'),
('appearance','viewed_products_image_height',250),
('appearance','viewed_products_image_width',250),


-- mail
('mail', 'config_mail_protocol', 'mail'),
('mail', 'config_mail_parameter', ''),
('mail', 'config_smtp_host', ''),
('mail', 'config_smtp_username', ''),
('mail', 'config_smtp_password', ''),
('mail', 'config_smtp_port', '25'),
('mail', 'config_smtp_timeout', '10'),
('mail', 'config_alert_mail', '0'),


-- im
('im', 'config_storefront_email_status', '1'),
('im', 'config_admin_email_status', '1'),
('im', 'config_im_guest_email_status', '1'),
('im', 'config_im_guest_sms_status', '1'),

-- system
('system','config_session_ttl',120),
('system','config_maintenance',0),
('system','encryption_key',12345),
('system','enable_seo_url',0),
('system','config_retina_enable',0),
('system','config_image_quality',95),
('system','config_compression',0),
('system','config_cache_enable',1),
('system','config_error_display',1),
('system','config_error_log',1),
('system','config_debug',0),
('system','config_debug_level',0),
('system','storefront_template_debug',0),
('system','config_error_filename','error.txt'),
('system','config_upload_max_size',16000),
('system','config_voicecontrol', 1),
('system','config_system_check', 3),

-- API
('api','config_storefront_api_status', '0'),
('api','config_storefront_api_key',''),
('api','config_storefront_api_stock_check',0),
('api','config_admin_api_status',0),
('api','config_admin_api_key',''),
('api','config_admin_access_ip_list',''),
('api','task_api_key',''),

-- EXTENSIONS
('sub_total', 'sub_total_sort_order', '1'),
('sub_total', 'sub_total_calculation_order', '1'),
('sub_total', 'sub_total_status', '1'),
('sub_total', 'sub_total_total_type', 'subtotal'),

('shipping', 'shipping_sort_order', '3'),
('shipping', 'shipping_calculation_order', '3'),
('shipping', 'shipping_status', '1'),
('shipping', 'shipping_total_type', 'shipping'),


('coupon','coupon_status',1),
('coupon','coupon_sort_order',4),
('coupon','coupon_calculation_order',4),
('coupon','coupon_total_type','discount'),

('tax', 'tax_status', 1),
('tax', 'tax_sort_order', 5),
('tax', 'tax_calculation_order', 2),
('tax', 'tax_total_type', 'tax'),

('balance', 'balance_status', 1),
('balance', 'balance_sort_order', 999),
('balance', 'balance_calculation_order', 999),
('balance', 'balance_total_type', 'balance'),

('total', 'total_sort_order', 1000),
('total', 'total_calculation_order', 1000),
('total', 'total_status', 1),
('total', 'total_total_type', 'total'),

('handling', 'handling_calculation_order', 2),
('handling', 'handling_status', 0),
('handling', 'handling_fee_total_type', 'fee'),

('banner_manager','banner_manager_layout',''),
('banner_manager','banner_manager_priority',10),
('banner_manager','banner_manager_date_installed', NOW()),
('banner_manager','store_id',0),
('banner_manager','banner_manager_status',1),

('forms_manager','forms_manager_priority',10),
('forms_manager','forms_manager_date_installed', NOW()),
('forms_manager','store_id',0),
('forms_manager','forms_manager_status',1),
('forms_manager','forms_manager_default_sender_name', ''),
('forms_manager','forms_manager_default_sender_email', ''),
('forms_manager','forms_manager_sort_order', '');

--
-- DDL for table `stock_statuses`
--
DROP TABLE IF EXISTS `ac_stock_statuses`;
CREATE TABLE `ac_stock_statuses` (
  `stock_status_id` int(11) NOT NULL,
  `language_id` int(11) NOT NULL,
  `name` varchar(32) COLLATE utf8_general_ci NOT NULL COMMENT 'translatable',
  PRIMARY KEY (`stock_status_id`,`language_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

--
-- Dumping data for table `stock_status`
--

INSERT INTO `ac_stock_statuses` (`stock_status_id`, `language_id`, `name`) VALUES
(1, 1, 'Pre-Order');

--
-- DDL for table `stores`
--
DROP TABLE IF EXISTS `ac_stores`;
CREATE TABLE `ac_stores` (
  `store_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(64) COLLATE utf8_general_ci NOT NULL,
  `alias` varchar(15) COLLATE utf8_general_ci NOT NULL,
  `status` int(1) NOT NULL,
   PRIMARY KEY (`store_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci AUTO_INCREMENT=0;

INSERT INTO `ac_stores` VALUES	(0,'default','default',1);

--
-- DDL for table `store_descriptions`
--
DROP TABLE IF EXISTS `ac_store_descriptions`;
CREATE TABLE `ac_store_descriptions` (
  `store_id` int(11) NOT NULL,
  `language_id` int(11) NOT NULL,
  `description` longtext NULL DEFAULT '' COMMENT 'translatable',
  `title` longtext NULL DEFAULT '' COMMENT 'translatable',
  `meta_description` longtext NULL DEFAULT '' COMMENT 'translatable',
  `meta_keywords` longtext NULL DEFAULT '' COMMENT 'translatable',
  PRIMARY KEY (`store_id`,`language_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;


--
-- DDL for table `tax_classes`
--
DROP TABLE IF EXISTS `ac_tax_classes`;
CREATE TABLE `ac_tax_classes` (
  `tax_class_id` int(11) NOT NULL AUTO_INCREMENT,
  `date_added` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tax_class_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci AUTO_INCREMENT=1;

--
-- Dumping data for table `tax_class`
--

INSERT INTO `ac_tax_classes` (`tax_class_id`, `date_added`) VALUES (1, now());

--
-- DDL for table `tax_class_descriptions`
--
DROP TABLE IF EXISTS `ac_tax_class_descriptions`;
CREATE TABLE `ac_tax_class_descriptions` (
  `tax_class_id` int(11) NOT NULL,
  `language_id` int(11) NOT NULL,
  `title` varchar(128) COLLATE utf8_general_ci NOT NULL COMMENT 'translatable',
  `description` varchar(255) COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT 'translatable',
  PRIMARY KEY (`tax_class_id`,`language_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `ac_tax_class_descriptions` (`tax_class_id`, `language_id`, `title`, `description`) VALUES (1, 1, 'Taxable Goods', 'Taxed Products');

--
-- DDL for table `tax_rates`
--
DROP TABLE IF EXISTS `ac_tax_rates`;
CREATE TABLE `ac_tax_rates` (
  `tax_rate_id` int(11) NOT NULL AUTO_INCREMENT,
  `location_id` int(11) NOT NULL DEFAULT '0',
  `zone_id` int(11) DEFAULT '0',
  `tax_class_id` int(11) NOT NULL,
  `priority` int(5) NOT NULL DEFAULT '1',
  `rate` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `rate_prefix` char(1) COLLATE utf8_general_ci NOT NULL DEFAULT '%', -- % or $
  `threshold_condition` char(2) COLLATE utf8_general_ci NOT NULL, -- '<=', '>=', '==' or '<'
  `threshold` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `tax_exempt_groups` text DEFAULT NULL,
  `date_added` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tax_rate_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci AUTO_INCREMENT=1;

CREATE INDEX `ac_tax_rates_idx` ON `ac_tax_rates` ( `location_id`, `zone_id`, `tax_class_id` );
--
-- Dumping data for table `tax_rate`
--
INSERT INTO `ac_tax_rates` VALUES (1,1,0,1,1,8.5000,'%','',0.0000,'a:1:{i:0;s:1:\"0\";}',NOW(),NOW());

--
-- DDL for table `tax_rate_descriptions`
--

DROP TABLE IF EXISTS `ac_tax_rate_descriptions`;
CREATE TABLE `ac_tax_rate_descriptions` (
  `tax_rate_id` int(11) NOT NULL,
  `language_id` int(11) NOT NULL,
  `description` varchar(255) COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT 'translatable',
  PRIMARY KEY (`tax_rate_id`,`language_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

--
-- Dumping data for table `tax_rate_descriptions`
--

INSERT INTO `ac_tax_rate_descriptions` (`tax_rate_id`, `language_id`, `description`) VALUES (1, 1, 'Retail 8.5%');

--
-- DDL for table `url_alias`
--
DROP TABLE IF EXISTS `ac_url_aliases`;
CREATE TABLE `ac_url_aliases` (
  `url_alias_id` int(11) NOT NULL AUTO_INCREMENT,
  `query` varchar(255) COLLATE utf8_general_ci NOT NULL,
  `keyword` varchar(255) COLLATE utf8_general_ci NOT NULL COMMENT 'translatable',
  `language_id` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`url_alias_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci AUTO_INCREMENT=1;
CREATE UNIQUE INDEX `ac_url_aliases_idx`
ON `ac_url_aliases` ( `keyword`, `language_id`);
CREATE UNIQUE INDEX `ac_url_aliases_idx2`
ON `ac_url_aliases` ( `query`, `language_id` );


--
-- DDL for table `user`
--
DROP TABLE IF EXISTS `ac_users`;
CREATE TABLE `ac_users` (
  `user_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_group_id` int(11) NOT NULL,
  `username` varchar(20) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `salt` varchar(8) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `password` varchar(40) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `firstname` varchar(32) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `lastname` varchar(32) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `email` varchar(96) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `status` int(1) NOT NULL,
  `ip` varchar(50) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `last_login` datetime NULL,
  `date_added` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`user_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci AUTO_INCREMENT=2;



--
-- DDL for table `user_group`
--
DROP TABLE IF EXISTS `ac_user_groups`;
CREATE TABLE `ac_user_groups` (
  `user_group_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(64) COLLATE utf8_general_ci NOT NULL,
  `permission` longtext COLLATE utf8_general_ci NOT NULL,
  `date_added` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`user_group_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci AUTO_INCREMENT=1;

--
-- Dumping data for table `user_group`
--

INSERT INTO `ac_user_groups` (`user_group_id`, `name`, `permission`) VALUES
(1, 'Top Administrator', ''),
(10, 'Demonstration', '');


DROP TABLE IF EXISTS `ac_user_notifications`;
CREATE TABLE `ac_user_notifications` (
  `user_id` int(11) NOT NULL,
  `store_id` int(11) NOT NULL,
  `section` tinyint(1) NOT NULL COMMENT '1 - admin, 0 - storefront',
  `sendpoint` varchar(255) NOT NULL,
  `protocol` varchar(30) NOT NULL,
  `uri` text NOT NULL,
  `date_added` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`user_id`,`store_id`,`section`,`sendpoint`,`protocol`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `ac_customer_notifications`;
CREATE TABLE `ac_customer_notifications` (
  `customer_id` int(11) NOT NULL,
  `sendpoint` varchar(255) NOT NULL,
  `protocol` varchar(30) NOT NULL,
  `status` int(1) NOT NULL DEFAULT '0',
  `date_added` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`customer_id`,`sendpoint`,`protocol`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- DDL for table `weight_class`
--
DROP TABLE IF EXISTS `ac_weight_classes`;
CREATE TABLE `ac_weight_classes` (
  `weight_class_id` int(11) NOT NULL AUTO_INCREMENT,
  `value` decimal(15,8) NOT NULL DEFAULT '0.00000000',
  `iso_code` VARCHAR(5) NOT NULL,
  `date_added` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`weight_class_id`,`iso_code`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci AUTO_INCREMENT=1;

--
-- Dumping data for table `weight_class`
--

INSERT INTO `ac_weight_classes` (`weight_class_id`, `value`, `iso_code`) VALUES
(1, '1.00000000', 'KILO'),
(2, '1000.00000000', 'GRAM'),
(5, '2.20460000', 'PUND'),
(6, '35.27400000', 'USOU');


--
-- DDL for table `weight_class_description`
--
DROP TABLE IF EXISTS `ac_weight_class_descriptions`;
CREATE TABLE `ac_weight_class_descriptions` (
  `weight_class_id` int(11) NOT NULL,
  `language_id` int(11) NOT NULL,
  `title` varchar(32) COLLATE utf8_general_ci NOT NULL COMMENT 'translatable',
  `unit` varchar(4) COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT 'translatable',
  PRIMARY KEY (`weight_class_id`,`language_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

--
-- Dumping data for table `weight_class_description`
--

INSERT INTO `ac_weight_class_descriptions` (`weight_class_id`, `language_id`, `title`, `unit`) VALUES
(1, 1, 'Kilogram', 'kg'),
(2, 1, 'Gram', 'g'),
(5, 1, 'Pound', 'lb'),
(6, 1, 'Ounce', 'oz');

--
-- DDL for table `zone`
--
DROP TABLE IF EXISTS `ac_zones`;
CREATE TABLE `ac_zones` (
  `zone_id` int(11) NOT NULL AUTO_INCREMENT,
  `country_id` int(11) NOT NULL,
  `code` varchar(32) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `status` int(1) NOT NULL DEFAULT '1',
  `sort_order` int(3) NOT NULL DEFAULT '0',
  PRIMARY KEY (`zone_id`, `country_id` )
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci AUTO_INCREMENT=1;

--
-- Dumping data for table `zone`
--

INSERT INTO `ac_zones`
VALUES
(1,1,'BDS',1,0),
(2,1,'BDG',1,0),
(3,1,'BGL',1,0),
(4,1,'BAL',1,0),
(5,1,'BAM',1,0),
(6,1,'FRA',1,0),
(7,1,'FYB',1,0),
(8,1,'GHA',1,0),
(9,1,'GHO',1,0),
(10,1,'HEL',1,0),
(11,1,'HER',1,0),
(12,1,'JOW',1,0),
(13,1,'KAB',1,0),
(14,1,'KAN',1,0),
(15,1,'KAP',1,0),
(16,1,'KHO',1,0),
(17,1,'KNR',1,0),
(18,1,'KDZ',1,0),
(19,1,'LAG',1,0),
(20,1,'LOW',1,0),
(21,1,'NAN',1,0),
(22,1,'NIM',1,0),
(23,1,'NUR',1,0),
(24,1,'ORU',1,0),
(25,1,'PIA',1,0),
(26,1,'PKA',1,0),
(27,1,'PAR',1,0),
(28,1,'SAM',1,0),
(29,1,'SAR',1,0),
(30,1,'TAK',1,0),
(31,1,'WAR',1,0),
(32,1,'ZAB',1,0),
(33,2,'BR',1,0),
(34,2,'BU',1,0),
(35,2,'DL',1,0),
(36,2,'DV',1,0),
(37,2,'DI',1,0),
(38,2,'DR',1,0),
(39,2,'EL',1,0),
(40,2,'ER',1,0),
(41,2,'FR',1,0),
(42,2,'GJ',1,0),
(43,2,'GR',1,0),
(44,2,'HA',1,0),
(45,2,'KA',1,0),
(46,2,'KB',1,0),
(47,2,'KC',1,0),
(48,2,'KO',1,0),
(49,2,'KR',1,0),
(50,2,'KU',1,0),
(51,2,'LB',1,0),
(52,2,'LE',1,0),
(53,2,'LU',1,0),
(54,2,'MM',1,0),
(55,2,'MK',1,0),
(56,2,'MT',1,0),
(57,2,'MR',1,0),
(58,2,'PQ',1,0),
(59,2,'PR',1,0),
(60,2,'PG',1,0),
(61,2,'PU',1,0),
(62,2,'SH',1,0),
(63,2,'SK',1,0),
(64,2,'SR',1,0),
(65,2,'TE',1,0),
(66,2,'TP',1,0),
(67,2,'TR',1,0),
(68,2,'VL',1,0),
(69,3,'ADR',1,0),
(70,3,'ADE',1,0),
(71,3,'ATE',1,0),
(72,3,'ALG',1,0),
(73,3,'ANN',1,0),
(74,3,'BAT',1,0),
(75,3,'BEC',1,0),
(76,3,'BEJ',1,0),
(77,3,'BIS',1,0),
(78,3,'BLI',1,0),
(79,3,'BBA',1,0),
(80,3,'BOA',1,0),
(81,3,'BMD',1,0),
(82,3,'CHL',1,0),
(83,3,'CON',1,0),
(84,3,'DJE',1,0),
(85,3,'EBA',1,0),
(86,3,'EOU',1,0),
(87,3,'ETA',1,0),
(88,3,'GHA',1,0),
(89,3,'GUE',1,0),
(90,3,'ILL',1,0),
(91,3,'JIJ',1,0),
(92,3,'KHE',1,0),
(93,3,'LAG',1,0),
(94,3,'MUA',1,0),
(95,3,'MED',1,0),
(96,3,'MIL',1,0),
(97,3,'MOS',1,0),
(98,3,'MSI',1,0),
(99,3,'NAA',1,0),
(100,3,'ORA',1,0),
(101,3,'OUA',1,0),
(102,3,'OEB',1,0),
(103,3,'REL',1,0),
(104,3,'SAI',1,0),
(105,3,'SET',1,0),
(106,3,'SBA',1,0),
(107,3,'SKI',1,0),
(108,3,'SAH',1,0),
(109,3,'TAM',1,0),
(110,3,'TEB',1,0),
(111,3,'TIA',1,0),
(112,3,'TIN',1,0),
(113,3,'TIP',1,0),
(114,3,'TIS',1,0),
(115,3,'TOU',1,0),
(116,3,'TLE',1,0),
(117,4,'E',1,0),
(118,4,'M',1,0),
(119,4,'R',1,0),
(120,4,'S',1,0),
(121,4,'W',1,0),
(122,5,'ALV',1,0),
(123,5,'CAN',1,0),
(124,5,'ENC',1,0),
(125,5,'ESE',1,0),
(126,5,'LMA',1,0),
(127,5,'ORD',1,0),
(128,5,'SJL',1,0),
(129,6,'BGO',1,0),
(130,6,'BGU',1,0),
(131,6,'BIE',1,0),
(132,6,'CAB',1,0),
(133,6,'CCU',1,0),
(134,6,'CNO',1,0),
(135,6,'CUS',1,0),
(136,6,'CNN',1,0),
(137,6,'HUA',1,0),
(138,6,'HUI',1,0),
(139,6,'LUA',1,0),
(140,6,'LNO',1,0),
(141,6,'LSU',1,0),
(142,6,'MAL',1,0),
(143,6,'MOX',1,0),
(144,6,'NAM',1,0),
(145,6,'UIG',1,0),
(146,6,'ZAI',1,0),
(147,9,'ASG',1,0),
(148,9,'ASJ',1,0),
(149,9,'ASM',1,0),
(150,9,'ASL',1,0),
(151,9,'ASR',1,0),
(152,9,'ASH',1,0),
(153,9,'BAR',1,0),
(154,9,'RED',1,0),
(155,10,'AN',1,0),
(156,10,'BA',1,0),
(157,10,'CA',1,0),
(158,10,'CH',1,0),
(159,10,'CU',1,0),
(160,10,'CO',1,0),
(161,10,'CR',1,0),
(162,10,'DF',1,0),
(163,10,'ER',1,0),
(164,10,'FO',1,0),
(165,10,'JU',1,0),
(166,10,'LP',1,0),
(167,10,'LR',1,0),
(168,10,'ME',1,0),
(169,10,'MI',1,0),
(170,10,'NE',1,0),
(171,10,'RN',1,0),
(172,10,'SA',1,0),
(173,10,'SJ',1,0),
(174,10,'SL',1,0),
(175,10,'SC',1,0),
(176,10,'SF',1,0),
(177,10,'SD',1,0),
(178,10,'TF',1,0),
(179,10,'TU',1,0),
(180,11,'AGT',1,0),
(181,11,'ARR',1,0),
(182,11,'ARM',1,0),
(183,11,'GEG',1,0),
(184,11,'KOT',1,0),
(185,11,'LOR',1,0),
(186,11,'SHI',1,0),
(187,11,'SYU',1,0),
(188,11,'TAV',1,0),
(189,11,'VAY',1,0),
(190,11,'YER',1,0),
(191,13,'ACT',1,0),
(192,13,'NSW',1,0),
(193,13,'NT',1,0),
(194,13,'QLD',1,0),
(195,13,'SA',1,0),
(196,13,'TAS',1,0),
(197,13,'VIC',1,0),
(198,13,'WA',1,0),
(199,14,'BUR',1,0),
(200,14,'KAR',1,0),
(201,14,'NOS',1,0),
(202,14,'OOS',1,0),
(203,14,'SAL',1,0),
(204,14,'STE',1,0),
(205,14,'TIR',1,0),
(206,14,'VOR',1,0),
(207,14,'WIE',1,0),
(208,15,'AB',1,0),
(209,15,'ABS',1,0),
(210,15,'AGC',1,0),
(211,15,'AGM',1,0),
(212,15,'AGS',1,0),
(213,15,'AGA',1,0),
(214,15,'AGU',1,0),
(215,15,'AST',1,0),
(216,15,'BA',1,0),
(217,15,'BAB',1,0),
(218,15,'BAL',1,0),
(219,15,'BAR',1,0),
(220,15,'BEY',1,0),
(221,15,'BIL',1,0),
(222,15,'CAB',1,0),
(223,15,'CAL',1,0),
(224,15,'CUL',1,0),
(225,15,'DAS',1,0),
(226,15,'DAV',1,0),
(227,15,'FUZ',1,0),
(228,15,'GA',1,0),
(229,15,'GAD',1,0),
(230,15,'GOR',1,0),
(231,15,'GOY',1,0),
(232,15,'HAC',1,0),
(233,15,'IMI',1,0),
(234,15,'ISM',1,0),
(235,15,'KAL',1,0),
(236,15,'KUR',1,0),
(237,15,'LA',1,0),
(238,15,'LAC',1,0),
(239,15,'LAN',1,0),
(240,15,'LER',1,0),
(241,15,'MAS',1,0),
(242,15,'MI',1,0),
(243,15,'NA',1,0),
(244,15,'NEF',1,0),
(245,15,'OGU',1,0),
(246,15,'ORD',1,0),
(247,15,'QAB',1,0),
(248,15,'QAX',1,0),
(249,15,'QAZ',1,0),
(250,15,'QOB',1,0),
(251,15,'QBA',1,0),
(252,15,'QBI',1,0),
(253,15,'QUS',1,0),
(254,15,'SA',1,0),
(255,15,'SAT',1,0),
(256,15,'SAB',1,0),
(257,15,'SAD',1,0),
(258,15,'SAH',1,0),
(259,15,'SAK',1,0),
(260,15,'SAL',1,0),
(261,15,'SM',1,0),
(262,15,'SMI',1,0),
(263,15,'SKR',1,0),
(264,15,'SMX',1,0),
(265,15,'SAR',1,0),
(266,15,'SIY',1,0),
(267,15,'SS',1,0),
(268,15,'SUS',1,0),
(269,15,'TAR',1,0),
(270,15,'TOV',1,0),
(271,15,'UCA',1,0),
(272,15,'XA',1,0),
(273,15,'XAC',1,0),
(274,15,'XAN',1,0),
(275,15,'XIZ',1,0),
(276,15,'XCI',1,0),
(277,15,'XVD',1,0),
(278,15,'YAR',1,0),
(279,15,'YEV',1,0),
(280,15,'ZAN',1,0),
(281,15,'ZAQ',1,0),
(282,15,'ZAR',1,0),
(283,15,'NX',1,0),
(284,16,'ACK',1,0),
(285,16,'BER',1,0),
(286,16,'BIM',1,0),
(287,16,'BLK',1,0),
(288,16,'CAT',1,0),
(289,16,'CAB',1,0),
(290,16,'CAN',1,0),
(291,16,'CEL',1,0),
(292,16,'FRE',1,0),
(293,16,'CRO',1,0),
(294,16,'EGB',1,0),
(295,16,'EXU',1,0),
(296,16,'GRD',1,0),
(297,16,'HAR',1,0),
(298,16,'HOP',1,0),
(299,16,'INA',1,0),
(300,16,'LNG',1,0),
(301,16,'MAN',1,0),
(302,16,'MAY',1,0),
(303,16,'MOO',1,0),
(304,16,'NAB',1,0),
(305,16,'NAN',1,0),
(306,16,'NEL',1,0),
(307,16,'RAG',1,0),
(308,16,'RUM',1,0),
(309,16,'SAL',1,0),
(310,16,'SAB',1,0),
(311,16,'SAN',1,0),
(312,16,'SEL',1,0),
(313,16,'SWE',1,0),
(314,16,'WGB',1,0),
(315,17,'CAP',1,0),
(316,17,'CEN',1,0),
(317,17,'MUH',1,0),
(318,17,'NOR',1,0),
(319,17,'SOU',1,0),
(320,18,'BAR',1,0),
(321,18,'CHI',1,0),
(322,18,'DHA',1,0),
(323,18,'KHU',1,0),
(324,18,'RAJ',1,0),
(325,18,'SYL',1,0),
(326,19,'CC',1,0),
(327,19,'AND',1,0),
(328,19,'GEO',1,0),
(329,19,'JAM',1,0),
(330,19,'JOH',1,0),
(331,19,'JOS',1,0),
(332,19,'LUC',1,0),
(333,19,'MIC',1,0),
(334,19,'PET',1,0),
(335,19,'PHI',1,0),
(336,19,'THO',1,0),
(337,20,'BR',1,0),
(338,20,'HO',1,0),
(339,20,'HM',1,0),
(340,20,'HR',1,0),
(341,20,'MA',1,0),
(342,20,'MI',1,0),
(343,20,'VI',1,0),
(344,21,'VAN',1,0),
(345,21,'WBR',1,0),
(346,21,'WHT',1,0),
(347,21,'WLG',1,0),
(348,21,'VLI',1,0),
(349,21,'WLX',1,0),
(350,21,'WNA',1,0),
(351,21,'VOV',1,0),
(352,21,'VBR',1,0),
(353,21,'VWV',1,0),
(354,22,'BZ',1,0),
(355,22,'CY',1,0),
(356,22,'CR',1,0),
(357,22,'OW',1,0),
(358,22,'SC',1,0),
(359,22,'TO',1,0),
(360,23,'AL',1,0),
(361,23,'AK',1,0),
(362,23,'AQ',1,0),
(363,23,'BO',1,0),
(364,23,'CO',1,0),
(365,23,'DO',1,0),
(366,23,'KO',1,0),
(367,23,'LI',1,0),
(368,23,'MO',1,0),
(369,23,'OU',1,0),
(370,23,'PL',1,0),
(371,23,'ZO',1,0),
(372,24,'DS',1,0),
(373,24,'HC',1,0),
(374,24,'HA',1,0),
(375,24,'PG',1,0),
(376,24,'PB',1,0),
(377,24,'GC',1,0),
(378,24,'SG',1,0),
(379,24,'SA',1,0),
(380,24,'SM',1,0),
(381,24,'SH',1,0),
(382,24,'WA',1,0),
(383,25,'BUM',1,0),
(384,25,'CHU',1,0),
(385,25,'DAG',1,0),
(386,25,'GAS',1,0),
(387,25,'HAA',1,0),
(388,25,'LHU',1,0),
(389,25,'MON',1,0),
(390,25,'PAR',1,0),
(391,25,'PEM',1,0),
(392,25,'PUN',1,0),
(393,25,'SJO',1,0),
(394,25,'SAT',1,0),
(395,25,'SAR',1,0),
(396,25,'THI',1,0),
(397,25,'TRG',1,0),
(398,25,'TRY',1,0),
(399,25,'TRO',1,0),
(400,25,'TSI',1,0),
(401,25,'WPH',1,0),
(402,25,'ZHE',1,0),
(403,26,'BEN',1,0),
(404,26,'CHU',1,0),
(405,26,'COC',1,0),
(406,26,'LPZ',1,0),
(407,26,'ORU',1,0),
(408,26,'PAN',1,0),
(409,26,'POT',1,0),
(410,26,'SCZ',1,0),
(411,26,'TAR',1,0),
(412,27,'BRO',1,0),
(413,27,'FUS',1,0),
(414,27,'FPO',1,0),
(415,27,'FTU',1,0),
(416,27,'FZE',1,0),
(417,27,'FBP',1,0),
(418,27,'FSB',1,0),
(419,27,'FHN',1,0),
(420,27,'FZH',1,0),
(421,27,'FSA',1,0),
(422,27,'FZA',1,0),
(423,27,'SBL',1,0),
(424,27,'SDO',1,0),
(425,27,'SBI',1,0),
(426,27,'SVL',1,0),
(427,27,'SSR',1,0),
(428,27,'SFO',1,0),
(429,27,'STR',1,0),
(430,28,'CE',1,0),
(431,28,'GH',1,0),
(432,28,'KD',1,0),
(433,28,'KT',1,0),
(434,28,'KW',1,0),
(435,28,'NG',1,0),
(436,28,'NE',1,0),
(437,28,'NW',1,0),
(438,28,'SE',1,0),
(439,28,'SO',1,0),
(440,30,'AC',1,0),
(441,30,'AL',1,0),
(442,30,'AP',1,0),
(443,30,'AM',1,0),
(444,30,'BA',1,0),
(445,30,'CE',1,0),
(446,30,'DF',1,0),
(447,30,'ES',1,0),
(448,30,'GO',1,0),
(449,30,'MA',1,0),
(450,30,'MT',1,0),
(451,30,'MS',1,0),
(452,30,'MG',1,0),
(453,30,'PA',1,0),
(454,30,'PB',1,0),
(455,30,'PR',1,0),
(456,30,'PE',1,0),
(457,30,'PI',1,0),
(458,30,'RJ',1,0),
(459,30,'RN',1,0),
(460,30,'RS',1,0),
(461,30,'RO',1,0),
(462,30,'RR',1,0),
(463,30,'SC',1,0),
(464,30,'SP',1,0),
(465,30,'SE',1,0),
(466,30,'TO',1,0),
(467,31,'PB',1,0),
(468,31,'SI',1,0),
(469,31,'NI',1,0),
(470,31,'TB',1,0),
(471,31,'EA',1,0),
(472,31,'DI',1,0),
(473,31,'EG',1,0),
(474,31,'DG',1,0),
(475,32,'BEL',1,0),
(476,32,'BRM',1,0),
(477,32,'TEM',1,0),
(478,32,'TUT',1,0),
(479,33,'',1,0),
(480,33,'',1,0),
(481,33,'',1,0),
(482,33,'',1,0),
(483,33,'',1,0),
(484,33,'',1,0),
(485,33,'',1,0),
(486,33,'',1,0),
(487,33,'',1,0),
(488,33,'',1,0),
(489,33,'',1,0),
(490,33,'',1,0),
(491,33,'',1,0),
(492,33,'',1,0),
(493,33,'',1,0),
(494,33,'',1,0),
(495,33,'',1,0),
(496,33,'',1,0),
(497,33,'',1,0),
(498,33,'',1,0),
(499,33,'',1,0),
(500,33,'',1,0),
(501,33,'',1,0),
(502,33,'',1,0),
(503,33,'',1,0),
(504,33,'',1,0),
(505,33,'',1,0),
(506,34,'BAL',1,0),
(507,34,'BAM',1,0),
(508,34,'BAN',1,0),
(509,34,'BAZ',1,0),
(510,34,'BOR',1,0),
(511,34,'BLG',1,0),
(512,34,'BOK',1,0),
(513,34,'COM',1,0),
(514,34,'GAN',1,0),
(515,34,'GNA',1,0),
(516,34,'GOU',1,0),
(517,34,'HOU',1,0),
(518,34,'IOA',1,0),
(519,34,'KAD',1,0),
(520,34,'KEN',1,0),
(521,34,'KOD',1,0),
(522,34,'KOP',1,0),
(523,34,'KOS',1,0),
(524,34,'KOL',1,0),
(525,34,'KOT',1,0),
(526,34,'KOW',1,0),
(527,34,'LER',1,0),
(528,34,'LOR',1,0),
(529,34,'MOU',1,0),
(530,34,'NAH',1,0),
(531,34,'NAM',1,0),
(532,34,'NAY',1,0),
(533,34,'NOU',1,0),
(534,34,'OUB',1,0),
(535,34,'OUD',1,0),
(536,34,'PAS',1,0),
(537,34,'PON',1,0),
(538,34,'SAG',1,0),
(539,34,'SAM',1,0),
(540,34,'SEN',1,0),
(541,34,'SIS',1,0),
(542,34,'SOM',1,0),
(543,34,'SOR',1,0),
(544,34,'TAP',1,0),
(545,34,'TUY',1,0),
(546,34,'YAG',1,0),
(547,34,'YAT',1,0),
(548,34,'ZIR',1,0),
(549,34,'ZOD',1,0),
(550,34,'ZOW',1,0),
(551,35,'BB',1,0),
(552,35,'BJ',1,0),
(553,35,'BR',1,0),
(554,35,'CA',1,0),
(555,35,'CI',1,0),
(556,35,'GI',1,0),
(557,35,'KR',1,0),
(558,35,'KY',1,0),
(559,35,'KI',1,0),
(560,35,'MA',1,0),
(561,35,'MU',1,0),
(562,35,'MY',1,0),
(563,35,'MW',1,0),
(564,35,'NG',1,0),
(565,35,'RT',1,0),
(566,35,'RY',1,0),
(567,36,'PP',1,0),
(568,36,'PS',1,0),
(569,36,'PA',1,0),
(570,36,'KB',1,0),
(571,36,'BM',1,0),
(572,36,'BA',1,0),
(573,36,'KM',1,0),
(574,36,'KN',1,0),
(575,36,'KU',1,0),
(576,36,'KO',1,0),
(577,36,'KT',1,0),
(578,36,'KP',1,0),
(579,36,'KL',1,0),
(580,36,'KK',1,0),
(581,36,'KR',1,0),
(582,36,'MK',1,0),
(583,36,'OM',1,0),
(584,36,'PU',1,0),
(585,36,'PR',1,0),
(586,36,'PG',1,0),
(587,36,'RK',1,0),
(588,36,'SI',1,0),
(589,36,'ST',1,0),
(590,36,'SR',1,0),
(591,36,'TK',1,0),
(592,37,'ADA',1,0),
(593,37,'CEN',1,0),
(594,37,'EST',1,0),
(595,37,'EXN',1,0),
(596,37,'LIT',1,0),
(597,37,'NOR',1,0),
(598,37,'NOT',1,0),
(599,37,'OUE',1,0),
(600,37,'SUD',1,0),
(601,37,'SOU',1,0),
(602,38,'AB',1,0),
(603,38,'BC',1,0),
(604,38,'MB',1,0),
(605,38,'NB',1,0),
(606,38,'NL',1,0),
(607,38,'NT',1,0),
(608,38,'NS',1,0),
(609,38,'NU',1,0),
(610,38,'ON',1,0),
(611,38,'PE',1,0),
(612,38,'QC',1,0),
(613,38,'SK',1,0),
(614,38,'YT',1,0),
(615,39,'BV',1,0),
(616,39,'BR',1,0),
(617,39,'CS',1,0),
(618,39,'MA',1,0),
(619,39,'MO',1,0),
(620,39,'PA',1,0),
(621,39,'PN',1,0),
(622,39,'PR',1,0),
(623,39,'RG',1,0),
(624,39,'SL',1,0),
(625,39,'CA',1,0),
(626,39,'CR',1,0),
(627,39,'SD',1,0),
(628,39,'SF',1,0),
(629,39,'SN',1,0),
(630,39,'SV',1,0),
(631,39,'TA',1,0),
(632,40,'CR',1,0),
(633,40,'EA',1,0),
(634,40,'ML',1,0),
(635,40,'ST',1,0),
(636,40,'SP',1,0),
(637,40,'SK',1,0),
(638,40,'WD',1,0),
(639,40,'WN',1,0),
(640,41,'BBA',1,0),
(641,41,'BKO',1,0),
(642,41,'HKO',1,0),
(643,41,'HMB',1,0),
(644,41,'KEM',1,0),
(645,41,'LOB',1,0),
(646,41,'MKD',1,0),
(647,41,'MBO',1,0),
(648,41,'NMM',1,0),
(649,41,'OMP',1,0),
(650,41,'OUK',1,0),
(651,41,'OUH',1,0),
(652,41,'OPE',1,0),
(653,41,'VAK',1,0),
(654,41,'NGR',1,0),
(655,41,'SMB',1,0),
(656,41,'BAN',1,0),
(657,42,'BA',1,0),
(658,42,'BI',1,0),
(659,42,'BE',1,0),
(660,42,'CB',1,0),
(661,42,'GU',1,0),
(662,42,'KA',1,0),
(663,42,'LA',1,0),
(664,42,'LC',1,0),
(665,42,'LR',1,0),
(666,42,'MK',1,0),
(667,42,'MC',1,0),
(668,42,'OU',1,0),
(669,42,'SA',1,0),
(670,42,'TA',1,0),
(671,43,'AI',1,0),
(672,43,'AN',1,0),
(673,43,'AR',1,0),
(674,43,'AT',1,0),
(675,43,'BI',1,0),
(676,43,'CO',1,0),
(677,43,'LI',1,0),
(678,43,'LL',1,0),
(679,43,'MA',1,0),
(680,43,'ML',1,0),
(681,43,'RM',1,0),
(682,43,'TA',1,0),
(683,43,'VS',1,0),
(684,44,'AN',1,0),
(685,44,'BE',1,0),
(686,44,'CH',1,0),
(687,44,'FU',1,0),
(688,44,'GA',1,0),
(689,44,'GU',1,0),
(690,44,'GX',1,0),
(691,44,'GZ',1,0),
(692,44,'HA',1,0),
(693,44,'HB',1,0),
(694,44,'HL',1,0),
(695,44,'HE',1,0),
(696,44,'HK',1,0),
(697,44,'HU',1,0),
(698,44,'HN',1,0),
(699,44,'IM',1,0),
(700,44,'JI',1,0),
(701,44,'JX',1,0),
(702,44,'JL',1,0),
(703,44,'LI',1,0),
(704,44,'MA',1,0),
(705,44,'NI',1,0),
(706,44,'SH',1,0),
(707,44,'SA',1,0),
(708,44,'SG',1,0),
(709,44,'SX',1,0),
(710,44,'SI',1,0),
(711,44,'TI',1,0),
(712,44,'XI',1,0),
(713,44,'YU',1,0),
(714,44,'ZH',1,0),
(715,46,'D',1,0),
(716,46,'H',1,0),
(717,46,'O',1,0),
(718,46,'S',1,0),
(719,46,'W',1,0),
(720,47,'AMZ',1,0),
(721,47,'ANT',1,0),
(722,47,'ARA',1,0),
(723,47,'ATL',1,0),
(724,47,'BDC',1,0),
(725,47,'BOL',1,0),
(726,47,'BOY',1,0),
(727,47,'CAL',1,0),
(728,47,'CAQ',1,0),
(729,47,'CAS',1,0),
(730,47,'CAU',1,0),
(731,47,'CES',1,0),
(732,47,'CHO',1,0),
(733,47,'COR',1,0),
(734,47,'CAM',1,0),
(735,47,'GNA',1,0),
(736,47,'GJR',1,0),
(737,47,'GVR',1,0),
(738,47,'HUI',1,0),
(739,47,'MAG',1,0),
(740,47,'MET',1,0),
(741,47,'NAR',1,0),
(742,47,'NDS',1,0),
(743,47,'PUT',1,0),
(744,47,'QUI',1,0),
(745,47,'RIS',1,0),
(746,47,'SAP',1,0),
(747,47,'SAN',1,0),
(748,47,'SUC',1,0),
(749,47,'TOL',1,0),
(750,47,'VDC',1,0),
(751,47,'VAU',1,0),
(752,47,'VIC',1,0),
(753,48,'G',1,0),
(754,48,'A',1,0),
(755,48,'M',1,0),
(756,49,'BO',1,0),
(757,49,'BR',1,0),
(758,49,'CU',1,0),
(759,49,'CO',1,0),
(760,49,'KO',1,0),
(761,49,'LE',1,0),
(762,49,'LI',1,0),
(763,49,'NI',1,0),
(764,49,'PL',1,0),
(765,49,'PO',1,0),
(766,49,'SA',1,0),
(767,50,'PU',1,0),
(768,50,'RK',1,0),
(769,50,'MK',1,0),
(770,50,'PE',1,0),
(771,50,'NI',1,0),
(772,50,'SU',1,0),
(773,50,'PA',1,0),
(774,50,'AI',1,0),
(775,50,'MA',1,0),
(776,50,'TA',1,0),
(777,50,'MT',1,0),
(778,50,'AT',1,0),
(779,50,'MU',1,0),
(780,50,'RR',1,0),
(781,50,'MG',1,0),
(782,51,'AL',1,0),
(783,51,'CA',1,0),
(784,51,'GU',1,0),
(785,51,'HE',1,0),
(786,51,'LI',1,0),
(787,51,'PU',1,0),
(788,51,'SJ',1,0),
(789,52,'ABE',1,0),
(790,52,'ABI',1,0),
(791,52,'ABO',1,0),
(792,52,'ADI',1,0),
(793,52,'ADZ',1,0),
(794,52,'AGB',1,0),
(795,52,'AGN',1,0),
(796,52,'ALE',1,0),
(797,52,'BOC',1,0),
(798,52,'BAN',1,0),
(799,52,'BEO',1,0),
(800,52,'BIA',1,0),
(801,52,'BDK',1,0),
(802,52,'BGN',1,0),
(803,52,'BFL',1,0),
(804,52,'BKE',1,0),
(805,52,'BNA',1,0),
(806,52,'BDL',1,0),
(807,52,'DKL',1,0),
(808,52,'DBU',1,0),
(809,52,'DAL',1,0),
(810,52,'DAN',1,0),
(811,52,'DAO',1,0),
(812,52,'DIM',1,0),
(813,52,'DIV',1,0),
(814,52,'DUE',1,0),
(815,52,'FER',1,0),
(816,52,'GAG',1,0),
(817,52,'GBA',1,0),
(818,52,'GLA',1,0),
(819,52,'GUI',1,0),
(820,52,'ISS',1,0),
(821,52,'JAC',1,0),
(822,52,'KAT',1,0),
(823,52,'KOR',1,0),
(824,52,'LAK',1,0),
(825,52,'MAN',1,0),
(826,52,'MKN',1,0),
(827,52,'MBA',1,0),
(828,52,'ODI',1,0),
(829,52,'OUM',1,0),
(830,52,'SAK',1,0),
(831,52,'SPE',1,0),
(832,52,'SAS',1,0),
(833,52,'SEG',1,0),
(834,52,'SIN',1,0),
(835,52,'SOU',1,0),
(836,52,'TAB',1,0),
(837,52,'TAN',1,0),
(838,52,'TIE',1,0),
(839,52,'TIN',1,0),
(840,52,'TIA',1,0),
(841,52,'TBA',1,0),
(842,52,'TLP',1,0),
(843,52,'TMD',1,0),
(844,52,'VAV',1,0),
(845,52,'YAM',1,0),
(846,52,'ZUE',1,0),
(847,53,'BB',1,0),
(848,53,'CZ',1,0),
(849,53,'DN',1,0),
(850,53,'IS',1,0),
(851,53,'KA',1,0),
(852,53,'KK',1,0),
(853,53,'KZ',1,0),
(854,53,'LS',1,0),
(855,53,'ME',1,0),
(856,53,'OB',1,0),
(857,53,'PS',1,0),
(858,53,'PG',1,0),
(859,53,'SI',1,0),
(860,53,'SM',1,0),
(861,53,'SB',1,0),
(862,53,'SD',1,0),
(863,53,'VA',1,0),
(864,53,'VP',1,0),
(865,53,'VS',1,0),
(866,53,'ZK',1,0),
(867,53,'ZA',1,0),
(868,54,'CA',1,0),
(869,54,'CD',1,0),
(870,54,'CI',1,0),
(871,54,'CH',1,0),
(872,54,'GR',1,0),
(873,54,'GU',1,0),
(874,54,'HO',1,0),
(875,54,'IJ',1,0),
(876,54,'LH',1,0),
(877,54,'LT',1,0),
(878,54,'MA',1,0),
(879,54,'PR',1,0),
(880,54,'SS',1,0),
(881,54,'SC',1,0),
(882,54,'VC',1,0),
(883,55,'F',1,0),
(884,55,'K',1,0),
(885,55,'A',1,0),
(886,55,'I',1,0),
(887,55,'N',1,0),
(888,55,'P',1,0),
(889,56,'U',1,0),
(890,56,'C',1,0),
(891,56,'B',1,0),
(892,56,'K',1,0),
(893,56,'H',1,0),
(894,56,'L',1,0),
(895,56,'T',1,0),
(896,56,'M',1,0),
(897,56,'E',1,0),
(898,56,'P',1,0),
(899,56,'A',1,0),
(900,56,'S',1,0),
(901,56,'J',1,0),
(902,56,'Z',1,0),
(903,57,'AR',1,0),
(904,57,'BH',1,0),
(905,57,'CO',1,0),
(906,57,'FO',1,0),
(907,57,'FR',1,0),
(908,57,'FY',1,0),
(909,57,'KO',1,0),
(910,57,'NO',1,0),
(911,57,'RI',1,0),
(912,57,'RK',1,0),
(913,57,'RO',1,0),
(914,57,'SO',1,0),
(915,57,'ST',1,0),
(916,57,'VK',1,0),
(917,57,'VJ',1,0),
(918,57,'VB',1,0),
(919,58,'S',1,0),
(920,58,'K',1,0),
(921,58,'J',1,0),
(922,58,'O',1,0),
(923,58,'T',1,0),
(924,59,'AND',1,0),
(925,59,'DAV',1,0),
(926,59,'GEO',1,0),
(927,59,'JOH',1,0),
(928,59,'JOS',1,0),
(929,59,'LUK',1,0),
(930,59,'MAR',1,0),
(931,59,'PAT',1,0),
(932,59,'PAU',1,0),
(933,59,'PET',1,0),
(934,60,'DN',1,0),
(935,60,'AZ',1,0),
(936,60,'BC',1,0),
(937,60,'BH',1,0),
(938,60,'DJ',1,0),
(939,60,'DU',1,0),
(940,60,'EL',1,0),
(941,60,'SY',1,0),
(942,60,'ET',1,0),
(943,60,'HM',1,0),
(944,60,'IN',1,0),
(945,60,'AL',1,0),
(946,60,'RO',1,0),
(947,60,'VE',1,0),
(948,60,'MT',1,0),
(949,60,'MN',1,0),
(950,60,'MC',1,0),
(951,60,'MP',1,0),
(952,60,'PD',1,0),
(953,60,'PR',1,0),
(954,60,'PP',1,0),
(955,60,'SL',1,0),
(956,60,'SM',1,0),
(957,60,'SH',1,0),
(958,60,'SC',1,0),
(959,60,'JO',1,0),
(960,60,'SJ',1,0),
(961,60,'PM',1,0),
(962,60,'SA',1,0),
(963,60,'ST',1,0),
(964,60,'SD',1,0),
(965,60,'VA',1,0),
(966,61,'AL',1,0),
(967,61,'AN',1,0),
(968,61,'BA',1,0),
(969,61,'BO',1,0),
(970,61,'CO',1,0),
(971,61,'DI',1,0),
(972,61,'ER',1,0),
(973,61,'LA',1,0),
(974,61,'LI',1,0),
(975,61,'MT',1,0),
(976,61,'MF',1,0),
(977,61,'OE',1,0),
(978,61,'VI',1,0),
(979,62,'AZU',1,0),
(980,62,'BOL',1,0),
(981,62,'CAN',1,0),
(982,62,'CAR',1,0),
(983,62,'CHI',1,0),
(984,62,'COT',1,0),
(985,62,'EOR',1,0),
(986,62,'ESM',1,0),
(987,62,'GPS',1,0),
(988,62,'GUA',1,0),
(989,62,'IMB',1,0),
(990,62,'LOJ',1,0),
(991,62,'LRO',1,0),
(992,62,'MAN',1,0),
(993,62,'MSA',1,0),
(994,62,'NAP',1,0),
(995,62,'ORE',1,0),
(996,62,'PAS',1,0),
(997,62,'PIC',1,0),
(998,62,'SUC',1,0),
(999,62,'TUN',1,0),
(1000,62,'ZCH',1,0),
(1001,63,'DHY',1,0),
(1002,63,'BAM',1,0),
(1003,63,'BHY',1,0),
(1004,63,'FYM',1,0),
(1005,63,'GBY',1,0),
(1006,63,'IDR',1,0),
(1007,63,'IML',1,0),
(1008,63,'JZH',1,0),
(1009,63,'MFY',1,0),
(1010,63,'MNY',1,0),
(1011,63,'QHR',1,0),
(1012,63,'QLY',1,0),
(1013,63,'WJD',1,0),
(1014,63,'SHQ',1,0),
(1015,63,'SWY',1,0),
(1016,63,'ASW',1,0),
(1017,63,'ASY',1,0),
(1018,63,'BSW',1,0),
(1019,63,'BSD',1,0),
(1020,63,'DMY',1,0),
(1021,63,'JNS',1,0),
(1022,63,'KSH',1,0),
(1023,63,'MAT',1,0),
(1024,63,'QIN',1,0),
(1025,63,'SHS',1,0),
(1026,63,'SUH',1,0),
(1027,64,'AH',1,0),
(1028,64,'CA',1,0),
(1029,64,'CH',1,0),
(1030,64,'CU',1,0),
(1031,64,'LB',1,0),
(1032,64,'PZ',1,0),
(1033,64,'UN',1,0),
(1034,64,'MO',1,0),
(1035,64,'SM',1,0),
(1036,64,'SS',1,0),
(1037,64,'SV',1,0),
(1038,64,'SA',1,0),
(1039,64,'SO',1,0),
(1040,64,'US',1,0),
(1041,65,'AN',1,0),
(1042,65,'BN',1,0),
(1043,65,'BS',1,0),
(1044,65,'CS',1,0),
(1045,65,'KN',1,0),
(1046,65,'LI',1,0),
(1047,65,'WN',1,0),
(1048,66,'MA',1,0),
(1049,66,'KE',1,0),
(1050,66,'DK',1,0),
(1051,66,'SK',1,0),
(1052,66,'DE',1,0),
(1053,66,'BR',1,0),
(1054,67,'HA',1,0),
(1055,67,'HI',1,0),
(1056,67,'IV',1,0),
(1057,67,'JA',1,0),
(1058,67,'JO',1,0),
(1059,67,'LV',1,0),
(1060,67,'LA',1,0),
(1061,67,'PA',1,0),
(1062,67,'PO',1,0),
(1063,67,'RA',1,0),
(1064,67,'SA',1,0),
(1065,67,'TA',1,0),
(1066,67,'VA',1,0),
(1067,67,'VI',1,0),
(1068,67,'VO',1,0),
(1069,68,'AF',1,0),
(1070,68,'AH',1,0),
(1071,68,'BG',1,0),
(1072,68,'GB',1,0),
(1073,68,'HR',1,0),
(1074,68,'OR',1,0),
(1075,68,'SM',1,0),
(1076,68,'SN',1,0),
(1077,68,'TG',1,0),
(1078,68,'AA',1,0),
(1079,68,'DD',1,0),
(1080,71,'C',1,0),
(1081,71,'N',1,0),
(1082,71,'E',1,0),
(1083,71,'W',1,0),
(1084,71,'R',1,0),
(1085,72,'AL',1,0),
(1086,72,'ES',1,0),
(1087,72,'IS',1,0),
(1088,72,'LS',1,0),
(1089,72,'LA',1,0),
(1090,72,'OU',1,0),
(1091,73,'AL',1,0),
(1092,73,'AQ',1,0),
(1093,73,'AU',1,0),
(1094,73,'BR',1,0),
(1095,73,'BU',1,0),
(1096,73,'CE',1,0),
(1097,73,'CH',1,0),
(1098,73,'CO',1,0),
(1099,73,'FR',1,0),
(1100,73,'LA',1,0),
(1101,73,'LI',1,0),
(1102,73,'LO',1,0),
(1103,73,'MI',1,0),
(1104,73,'NO',1,0),
(1105,73,'NR',1,0),
(1106,73,'PA',1,0),
(1107,73,'PI',1,0),
(1108,73,'PO',1,0),
(1109,73,'PR',1,0),
(1110,73,'RH',1,0),
(1111,73,'RI',1,0),
(1112,73,'WE',1,0),
(1113,74,'Et',1,0),
(1114,74,'01',1,0),
(1115,74,'02',1,0),
(1116,74,'03',1,0),
(1117,74,'04',1,0),
(1118,74,'05',1,0),
(1119,74,'06',1,0),
(1120,74,'07',1,0),
(1121,74,'08',1,0),
(1122,74,'09',1,0),
(1123,74,'10',1,0),
(1124,74,'11',1,0),
(1125,74,'12',1,0),
(1126,74,'13',1,0),
(1127,74,'14',1,0),
(1128,74,'15',1,0),
(1129,74,'16',1,0),
(1130,74,'17',1,0),
(1131,74,'18',1,0),
(1132,74,'19',1,0),
(1133,74,'2A',1,0),
(1134,74,'2B',1,0),
(1135,74,'21',1,0),
(1136,74,'22',1,0),
(1137,74,'23',1,0),
(1138,74,'24',1,0),
(1139,74,'25',1,0),
(1140,74,'26',1,0),
(1141,74,'27',1,0),
(1142,74,'28',1,0),
(1143,74,'29',1,0),
(1144,74,'30',1,0),
(1145,74,'31',1,0),
(1146,74,'32',1,0),
(1147,74,'33',1,0),
(1148,74,'34',1,0),
(1149,74,'35',1,0),
(1150,74,'36',1,0),
(1151,74,'37',1,0),
(1152,74,'38',1,0),
(1153,74,'39',1,0),
(1154,74,'40',1,0),
(1155,74,'41',1,0),
(1156,74,'42',1,0),
(1157,74,'43',1,0),
(1158,74,'44',1,0),
(1159,74,'45',1,0),
(1160,74,'46',1,0),
(1161,74,'47',1,0),
(1162,74,'48',1,0),
(1163,74,'49',1,0),
(1164,74,'50',1,0),
(1165,74,'51',1,0),
(1166,74,'52',1,0),
(1167,74,'53',1,0),
(1168,74,'54',1,0),
(1169,74,'55',1,0),
(1170,74,'56',1,0),
(1171,74,'57',1,0),
(1172,74,'58',1,0),
(1173,74,'59',1,0),
(1174,74,'60',1,0),
(1175,74,'61',1,0),
(1176,74,'62',1,0),
(1177,74,'63',1,0),
(1178,74,'64',1,0),
(1179,74,'65',1,0),
(1180,74,'66',1,0),
(1181,74,'67',1,0),
(1182,74,'68',1,0),
(1183,74,'69',1,0),
(1184,74,'70',1,0),
(1185,74,'71',1,0),
(1186,74,'72',1,0),
(1187,74,'73',1,0),
(1188,74,'74',1,0),
(1189,74,'75',1,0),
(1190,74,'76',1,0),
(1191,74,'77',1,0),
(1192,74,'78',1,0),
(1193,74,'79',1,0),
(1194,74,'80',1,0),
(1195,74,'81',1,0),
(1196,74,'82',1,0),
(1197,74,'83',1,0),
(1198,74,'84',1,0),
(1199,74,'85',1,0),
(1200,74,'86',1,0),
(1201,74,'87',1,0),
(1202,74,'88',1,0),
(1203,74,'89',1,0),
(1204,74,'90',1,0),
(1205,74,'91',1,0),
(1206,74,'92',1,0),
(1207,74,'93',1,0),
(1208,74,'94',1,0),
(1209,74,'95',1,0),
(1210,76,'M',1,0),
(1211,76,'T',1,0),
(1212,76,'I',1,0),
(1213,76,'V',1,0),
(1214,76,'S',1,0),
(1215,77,'C',1,0),
(1216,77,'K',1,0),
(1217,77,'A',1,0),
(1218,77,'P',1,0),
(1219,77,'D',1,0),
(1220,78,'ES',1,0),
(1221,78,'HO',1,0),
(1222,78,'MO',1,0),
(1223,78,'NG',1,0),
(1224,78,'NY',1,0),
(1225,78,'OI',1,0),
(1226,78,'OL',1,0),
(1227,78,'OM',1,0),
(1228,78,'WN',1,0),
(1229,79,'BJ',1,0),
(1230,79,'BS',1,0),
(1231,79,'BR',1,0),
(1232,79,'JA',1,0),
(1233,79,'KA',1,0),
(1234,79,'KE',1,0),
(1235,79,'KU',1,0),
(1236,79,'MA',1,0),
(1237,79,'LR',1,0),
(1238,79,'CR',1,0),
(1239,79,'NB',1,0),
(1240,79,'UR',1,0),
(1241,79,'WE',1,0),
(1242,80,'AB',1,0),
(1243,80,'AJ',1,0),
(1244,80,'TB',1,0),
(1245,80,'GU',1,0),
(1246,80,'IM',1,0),
(1247,80,'KA',1,0),
(1248,80,'KK',1,0),
(1249,80,'MM',1,0),
(1250,80,'RL',1,0),
(1251,80,'SZ',1,0),
(1252,80,'SJ',1,0),
(1253,80,'SK',1,0),
(1254,81,'BAW',1,0),
(1255,81,'BAY',1,0),
(1256,81,'BER',1,0),
(1257,81,'BRG',1,0),
(1258,81,'BRE',1,0),
(1259,81,'HAM',1,0),
(1260,81,'HES',1,0),
(1261,81,'MEC',1,0),
(1262,81,'NDS',1,0),
(1263,81,'NRW',1,0),
(1264,81,'RHE',1,0),
(1265,81,'SAR',1,0),
(1266,81,'SAS',1,0),
(1267,81,'SAC',1,0),
(1268,81,'SCN',1,0),
(1269,81,'THE',1,0),
(1270,82,'AS',1,0),
(1271,82,'BA',1,0),
(1272,82,'CE',1,0),
(1273,82,'EA',1,0),
(1274,82,'GA',1,0),
(1275,82,'NO',1,0),
(1276,82,'UE',1,0),
(1277,82,'UW',1,0),
(1278,82,'VO',1,0),
(1279,82,'WE',1,0),
(1280,84,'AT',1,0),
(1281,84,'CN',1,0),
(1282,84,'CM',1,0),
(1283,84,'CR',1,0),
(1284,84,'EM',1,0),
(1285,84,'EP',1,0),
(1286,84,'II',1,0),
(1287,84,'NA',1,0),
(1288,84,'PP',1,0),
(1289,84,'SA',1,0),
(1290,84,'TH',1,0),
(1291,84,'WG',1,0),
(1292,84,'WM',1,0),
(1293,85,'A',1,0),
(1294,85,'T',1,0),
(1295,85,'K',1,0),
(1296,86,'A',1,0),
(1297,86,'D',1,0),
(1298,86,'G',1,0),
(1299,86,'J',1,0),
(1300,86,'M',1,0),
(1301,86,'P',1,0),
(1302,86,'C',1,0),
(1303,86,'Q',1,0),
(1304,89,'AV',1,0),
(1305,89,'BV',1,0),
(1306,89,'CM',1,0),
(1307,89,'CQ',1,0),
(1308,89,'PE',1,0),
(1309,89,'PR',1,0),
(1310,89,'QC',1,0),
(1311,89,'ES',1,0),
(1312,89,'GU',1,0),
(1313,89,'HU',1,0),
(1314,89,'IZ',1,0),
(1315,89,'JA',1,0),
(1316,89,'JU',1,0),
(1317,89,'QZ',1,0),
(1318,89,'RE',1,0),
(1319,89,'ST',1,0),
(1320,89,'SM',1,0),
(1321,89,'SR',1,0),
(1322,89,'SO',1,0),
(1323,89,'SU',1,0),
(1324,89,'TO',1,0),
(1325,89,'ZA',1,0),
(1326,90,'CNK',1,0),
(1327,90,'BYL',1,0),
(1328,90,'BFA',1,0),
(1329,90,'BOK',1,0),
(1330,90,'COY',1,0),
(1331,90,'DBL',1,0),
(1332,90,'DLB',1,0),
(1333,90,'DGR',1,0),
(1334,90,'DBR',1,0),
(1335,90,'FRN',1,0),
(1336,90,'FRC',1,0),
(1337,90,'FRI',1,0),
(1338,90,'GAO',1,0),
(1339,90,'GCD',1,0),
(1340,90,'KNK',1,0),
(1341,90,'KRN',1,0),
(1342,90,'KND',1,0),
(1343,90,'KSD',1,0),
(1344,90,'KBA',1,0),
(1345,90,'KDA',1,0),
(1346,90,'KRA',1,0),
(1347,90,'LAB',1,0),
(1348,90,'LLM',1,0),
(1349,90,'LOL',1,0),
(1350,90,'MCT',1,0),
(1351,90,'MAL',1,0),
(1352,90,'MAM',1,0),
(1353,90,'MAN',1,0),
(1354,90,'NZR',1,0),
(1355,90,'PIT',1,0),
(1356,90,'SIG',1,0),
(1357,90,'TLM',1,0),
(1358,90,'TOG',1,0),
(1359,90,'YOM',1,0),
(1360,91,'BF',1,0),
(1361,91,'BB',1,0),
(1362,91,'BS',1,0),
(1363,91,'BL',1,0),
(1364,91,'CA',1,0),
(1365,91,'GA',1,0),
(1366,91,'OI',1,0),
(1367,91,'QU',1,0),
(1368,91,'TO',1,0),
(1369,92,'BW',1,0),
(1370,92,'CM',1,0),
(1371,92,'DM',1,0),
(1372,92,'EC',1,0),
(1373,92,'EW',1,0),
(1374,92,'MB',1,0),
(1375,92,'PM',1,0),
(1376,92,'PI',1,0),
(1377,92,'UD',1,0),
(1378,92,'UT',1,0),
(1379,93,'AR',1,0),
(1380,93,'CE',1,0),
(1381,93,'GA',1,0),
(1382,93,'ND',1,0),
(1383,93,'NE',1,0),
(1384,93,'NO',1,0),
(1385,93,'OU',1,0),
(1386,93,'SD',1,0),
(1387,93,'SE',1,0),
(1388,94,'F',1,0),
(1389,94,'M',1,0),
(1390,94,'S',1,0),
(1391,94,'H',1,0),
(1392,95,'AT',1,0),
(1393,95,'CH',1,0),
(1394,95,'CL',1,0),
(1395,95,'CM',1,0),
(1396,95,'CP',1,0),
(1397,95,'CR',1,0),
(1398,95,'PA',1,0),
(1399,95,'FM',1,0),
(1400,95,'GD',1,0),
(1401,95,'IN',1,0),
(1402,95,'IB',1,0),
(1403,95,'PZ',1,0),
(1404,95,'LE',1,0),
(1405,95,'OC',1,0),
(1406,95,'OL',1,0),
(1407,95,'SB',1,0),
(1408,95,'VA',1,0),
(1409,95,'YO',1,0),
(1410,96,'HCW',1,0),
(1411,96,'HEA',1,0),
(1412,96,'HSO',1,0),
(1413,96,'HWC',1,0),
(1414,96,'KKC',1,0),
(1415,96,'KKT',1,0),
(1416,96,'KSS',1,0),
(1417,96,'KWT',1,0),
(1418,96,'KYT',1,0),
(1419,96,'NIS',1,0),
(1420,96,'NKT',1,0),
(1421,96,'NNO',1,0),
(1422,96,'NSK',1,0),
(1423,96,'NST',1,0),
(1424,96,'NTP',1,0),
(1425,96,'NTW',1,0),
(1426,96,'NTM',1,0),
(1427,96,'NYL',1,0),
(1428,97,'BK',1,0),
(1429,97,'BA',1,0),
(1430,97,'BE',1,0),
(1431,97,'BS',1,0),
(1432,97,'BZ',1,0),
(1433,97,'BU',1,0),
(1434,97,'CS',1,0),
(1435,97,'DE',1,0),
(1436,97,'DU',1,0),
(1437,97,'EG',1,0),
(1438,97,'FE',1,0),
(1439,97,'GY',1,0),
(1440,97,'GM',1,0),
(1441,97,'HB',1,0),
(1442,97,'HE',1,0),
(1443,97,'HO',1,0),
(1444,97,'JN',1,0),
(1445,97,'KA',1,0),
(1446,97,'KE',1,0),
(1447,97,'KO',1,0),
(1448,97,'MI',1,0),
(1449,97,'NA',1,0),
(1450,97,'NO',1,0),
(1451,97,'NY',1,0),
(1452,97,'PE',1,0),
(1453,97,'PS',1,0),
(1454,97,'SO',1,0),
(1455,97,'SP',1,0),
(1456,97,'SS',1,0),
(1457,97,'SZ',1,0),
(1458,97,'SE',1,0),
(1459,97,'SL',1,0),
(1460,97,'SM',1,0),
(1461,97,'TA',1,0),
(1462,97,'TO',1,0),
(1463,97,'VA',1,0),
(1464,97,'VE',1,0),
(1465,97,'ZA',1,0),
(1466,97,'ZZ',1,0),
(1467,98,'AL',1,0),
(1468,98,'HF',1,0),
(1469,98,'NE',1,0),
(1470,98,'NV',1,0),
(1471,98,'SL',1,0),
(1472,98,'SN',1,0),
(1473,98,'VF',1,0),
(1474,98,'VL',1,0),
(1475,99,'AN',1,0),
(1476,99,'AP',1,0),
(1477,99,'AR',1,0),
(1478,99,'AS',1,0),
(1479,99,'BI',1,0),
(1480,99,'CH',1,0),
(1481,99,'DA',1,0),
(1482,99,'DM',1,0),
(1483,99,'DE',1,0),
(1484,99,'GO',1,0),
(1485,99,'GU',1,0),
(1486,99,'HA',1,0),
(1487,99,'HP',1,0),
(1488,99,'JA',1,0),
(1489,99,'KA',1,0),
(1490,99,'KE',1,0),
(1491,99,'LI',1,0),
(1492,99,'MP',1,0),
(1493,99,'MA',1,0),
(1494,99,'MN',1,0),
(1495,99,'ME',1,0),
(1496,99,'MI',1,0),
(1497,99,'NA',1,0),
(1498,99,'OR',1,0),
(1499,99,'PO',1,0),
(1500,99,'PU',1,0),
(1501,99,'RA',1,0),
(1502,99,'SI',1,0),
(1503,99,'TN',1,0),
(1504,99,'TR',1,0),
(1505,99,'UP',1,0),
(1506,99,'WB',1,0),
(1507,100,'AC',1,0),
(1508,100,'BA',1,0),
(1509,100,'BT',1,0),
(1510,100,'BE',1,0),
(1511,100,'BD',1,0),
(1512,100,'GO',1,0),
(1513,100,'JK',1,0),
(1514,100,'JA',1,0),
(1515,100,'JB',1,0),
(1516,100,'JT',1,0),
(1517,100,'JI',1,0),
(1518,100,'KB',1,0),
(1519,100,'KS',1,0),
(1520,100,'KT',1,0),
(1521,100,'KI',1,0),
(1522,100,'BB',1,0),
(1523,100,'LA',1,0),
(1524,100,'MA',1,0),
(1525,100,'MU',1,0),
(1526,100,'NB',1,0),
(1527,100,'NT',1,0),
(1528,100,'PA',1,0),
(1529,100,'RI',1,0),
(1530,100,'SN',1,0),
(1531,100,'ST',1,0),
(1532,100,'SG',1,0),
(1533,100,'SA',1,0),
(1534,100,'SB',1,0),
(1535,100,'SS',1,0),
(1536,100,'SU',1,0),
(1537,100,'YO',1,0),
(1538,101,'TEH',1,0),
(1539,101,'QOM',1,0),
(1540,101,'MKZ',1,0),
(1541,101,'QAZ',1,0),
(1542,101,'GIL',1,0),
(1543,101,'ARD',1,0),
(1544,101,'ZAN',1,0),
(1545,101,'EAZ',1,0),
(1546,101,'WEZ',1,0),
(1547,101,'KRD',1,0),
(1548,101,'HMD',1,0),
(1549,101,'KRM',1,0),
(1550,101,'ILM',1,0),
(1551,101,'LRS',1,0),
(1552,101,'KZT',1,0),
(1553,101,'CMB',1,0),
(1554,101,'KBA',1,0),
(1555,101,'BSH',1,0),
(1556,101,'FAR',1,0),
(1557,101,'HRM',1,0),
(1558,101,'SBL',1,0),
(1559,101,'KRB',1,0),
(1560,101,'YZD',1,0),
(1561,101,'EFH',1,0),
(1562,101,'SMN',1,0),
(1563,101,'MZD',1,0),
(1564,101,'GLS',1,0),
(1565,101,'NKH',1,0),
(1566,101,'RKH',1,0),
(1567,101,'SKH',1,0),
(1568,102,'BD',1,0),
(1569,102,'SD',1,0),
(1570,102,'DY',1,0),
(1571,102,'WS',1,0),
(1572,102,'MY',1,0),
(1573,102,'BA',1,0),
(1574,102,'DQ',1,0),
(1575,102,'MU',1,0),
(1576,102,'QA',1,0),
(1577,102,'BB',1,0),
(1578,102,'KB',1,0),
(1579,102,'NJ',1,0),
(1580,102,'AB',1,0),
(1581,102,'NN',1,0),
(1582,102,'DH',1,0),
(1583,102,'AL',1,0),
(1584,102,'TM',1,0),
(1585,102,'SL',1,0),
(1586,103,'CA',1,0),
(1587,103,'CV',1,0),
(1588,103,'CL',1,0),
(1589,103,'CO',1,0),
(1590,103,'DO',1,0),
(1591,103,'DU',1,0),
(1592,103,'GA',1,0),
(1593,103,'KE',1,0),
(1594,103,'KI',1,0),
(1595,103,'KL',1,0),
(1596,103,'LA',1,0),
(1597,103,'LE',1,0),
(1598,103,'LI',1,0),
(1599,103,'LO',1,0),
(1600,103,'LU',1,0),
(1601,103,'MA',1,0),
(1602,103,'ME',1,0),
(1603,103,'MO',1,0),
(1604,103,'OF',1,0),
(1605,103,'RO',1,0),
(1606,103,'SL',1,0),
(1607,103,'TI',1,0),
(1608,103,'WA',1,0),
(1609,103,'WE',1,0),
(1610,103,'WX',1,0),
(1611,103,'WI',1,0),
(1612,104,'BS',1,0),
(1613,104,'BH',1,0),
(1614,104,'EA',1,0),
(1615,104,'GA',1,0),
(1616,104,'HA',1,0),
(1617,104,'JM',1,0),
(1618,104,'JE',1,0),
(1619,104,'NE',1,0),
(1620,104,'SE',1,0),
(1621,104,'SH',1,0),
(1622,104,'TA',1,0),
(3860,105,'CL',1,0),
(3842,105,'AG',1,0),
(3843,105,'AL',1,0),
(3844,105,'AN',1,0),
(3845,105,'AO',1,0),
(3846,105,'AR',1,0),
(3847,105,'AP',1,0),
(3848,105,'AT',1,0),
(3849,105,'AV',1,0),
(3850,105,'BA',1,0),
(3851,105,'BL',1,0),
(3852,105,'BN',1,0),
(3853,105,'BG',1,0),
(3854,105,'BI',1,0),
(3855,105,'BO',1,0),
(3856,105,'BZ',1,0),
(3857,105,'BS',1,0),
(3858,105,'BR',1,0),
(3859,105,'CA',1,0),
(1643,106,'CLA',1,0),
(1644,106,'HAN',1,0),
(1645,106,'KIN',1,0),
(1646,106,'MAN',1,0),
(1647,106,'POR',1,0),
(1648,106,'AND',1,0),
(1649,106,'ANN',1,0),
(1650,106,'CAT',1,0),
(1651,106,'ELI',1,0),
(1652,106,'JAM',1,0),
(1653,106,'MAR',1,0),
(1654,106,'THO',1,0),
(1655,106,'TRL',1,0),
(1656,106,'WML',1,0),
(1657,107,'AI',1,0),
(1658,107,'AK',1,0),
(1659,107,'AO',1,0),
(1660,107,'CH',1,0),
(1661,107,'EH',1,0),
(1662,107,'FK',1,0),
(1663,107,'FU',1,0),
(1664,107,'FS',1,0),
(1665,107,'GI',1,0),
(1666,107,'GU',1,0),
(1667,107,'HI',1,0),
(1668,107,'HO',1,0),
(1669,107,'HY',1,0),
(1670,107,'IB',1,0),
(1671,107,'IS',1,0),
(1672,107,'IW',1,0),
(1673,107,'KA',1,0),
(1674,107,'KG',1,0),
(1675,107,'KN',1,0),
(1676,107,'KO',1,0),
(1677,107,'KU',1,0),
(1678,107,'KY',1,0),
(1679,107,'MI',1,0),
(1680,107,'MY',1,0),
(1681,107,'MZ',1,0),
(1682,107,'NA',1,0),
(1683,107,'NG',1,0),
(1684,107,'NR',1,0),
(1685,107,'NI',1,0),
(1686,107,'OI',1,0),
(1687,107,'OK',1,0),
(1688,107,'ON',1,0),
(1689,107,'OS',1,0),
(1690,107,'SA',1,0),
(1691,107,'SI',1,0),
(1692,107,'SH',1,0),
(1693,107,'SM',1,0),
(1694,107,'SZ',1,0),
(1695,107,'TO',1,0),
(1696,107,'TS',1,0),
(1697,107,'TK',1,0),
(1698,107,'TT',1,0),
(1699,107,'TY',1,0),
(1700,107,'WA',1,0),
(1701,107,'YA',1,0),
(1702,107,'YM',1,0),
(1703,107,'YN',1,0),
(1704,108,'AM',1,0),
(1705,108,'AJ',1,0),
(1706,108,'AA',1,0),
(1707,108,'AB',1,0),
(1708,108,'AK',1,0),
(1709,108,'AL',1,0),
(1710,108,'AT',1,0),
(1711,108,'AZ',1,0),
(1712,108,'IR',1,0),
(1713,108,'JA',1,0),
(1714,108,'MA',1,0),
(1715,108,'MD',1,0),
(1716,109,'AL',1,0),
(1717,109,'AC',1,0),
(1718,109,'AM',1,0),
(1719,109,'AQ',1,0),
(1720,109,'AS',1,0),
(1721,109,'AT',1,0),
(1722,109,'BA',1,0),
(1723,109,'BY',1,0),
(1724,109,'MA',1,0),
(1725,109,'ON',1,0),
(1726,109,'PA',1,0),
(1727,109,'QA',1,0),
(1728,109,'QO',1,0),
(1729,109,'QY',1,0),
(1730,109,'SH',1,0),
(1731,109,'SO',1,0),
(1732,109,'ZH',1,0),
(1733,110,'CE',1,0),
(1734,110,'CO',1,0),
(1735,110,'EA',1,0),
(1736,110,'NA',1,0),
(1737,110,'NE',1,0),
(1738,110,'NY',1,0),
(1739,110,'RV',1,0),
(1740,110,'WE',1,0),
(1741,111,'AG',1,0),
(1742,111,'AM',1,0),
(1743,111,'AK',1,0),
(1744,111,'AO',1,0),
(1745,111,'BA',1,0),
(1746,111,'BE',1,0),
(1747,111,'bT',1,0),
(1748,111,'KA',1,0),
(1749,111,'KR',1,0),
(1750,111,'KU',1,0),
(1751,111,'MI',1,0),
(1752,111,'MN',1,0),
(1753,111,'ME',1,0),
(1754,111,'NI',1,0),
(1755,111,'NO',1,0),
(1756,111,'ON',1,0),
(1757,111,'TT',1,0),
(1758,111,'TR',1,0),
(1759,111,'TM',1,0),
(1760,111,'TW',1,0),
(1761,111,'TE',1,0),
(1762,112,'CHA',1,0),
(1763,112,'HAB',1,0),
(1764,112,'HAN',1,0),
(1765,112,'HWB',1,0),
(1766,112,'HWN',1,0),
(1767,112,'KAN',1,0),
(1768,112,'PYB',1,0),
(1769,112,'PYN',1,0),
(1770,112,'YAN',1,0),
(1771,112,'NAJ',1,0),
(1772,112,'PYO',1,0),
(1773,113,'CO',1,0),
(1774,113,'CH',1,0),
(1775,113,'CD',1,0),
(1776,113,'CB',1,0),
(1777,113,'CN',1,0),
(1778,113,'IG',1,0),
(1779,113,'KA',1,0),
(1780,113,'KG',1,0),
(1781,113,'KD',1,0),
(1782,113,'KB',1,0),
(1783,113,'KN',1,0),
(1784,113,'PG',1,0),
(1785,113,'SO',1,0),
(1786,113,'TA',1,0),
(1787,113,'TG',1,0),
(1788,114,'AL',1,0),
(1789,114,'AA',1,0),
(1790,114,'AF',1,0),
(1791,114,'AJ',1,0),
(1792,114,'HA',1,0),
(1793,115,'GB',1,0),
(1794,115,'B',1,0),
(1795,115,'C',1,0),
(1796,115,'J',1,0),
(1797,115,'N',1,0),
(1798,115,'O',1,0),
(1799,115,'T',1,0),
(1800,115,'Y',1,0),
(1801,116,'VT',1,0),
(1802,116,'AT',1,0),
(1803,116,'BK',1,0),
(1804,116,'BL',1,0),
(1805,116,'CH',1,0),
(1806,116,'HO',1,0),
(1807,116,'KH',1,0),
(1808,116,'LM',1,0),
(1809,116,'LP',1,0),
(1810,116,'OU',1,0),
(1811,116,'PH',1,0),
(1812,116,'SL',1,0),
(1813,116,'SV',1,0),
(1814,116,'VI',1,0),
(1815,116,'XA',1,0),
(1816,116,'XE',1,0),
(1817,116,'XI',1,0),
(1818,116,'XN',1,0),
(1819,117,'AIZ',1,0),
(1820,117,'ALU',1,0),
(1821,117,'BAL',1,0),
(1822,117,'BAU',1,0),
(1823,117,'CES',1,0),
(1824,117,'DGR',1,0),
(1825,117,'DOB',1,0),
(1826,117,'GUL',1,0),
(1827,117,'JEK',1,0),
(1828,117,'JGR',1,0),
(1829,117,'KRA',1,0),
(1830,117,'KUL',1,0),
(1831,117,'LPR',1,0),
(1832,117,'LIM',1,0),
(1833,117,'LUD',1,0),
(1834,117,'MAD',1,0),
(1835,117,'OGR',1,0),
(1836,117,'PRE',1,0),
(1837,117,'RZR',1,0),
(1838,117,'RGR',1,0),
(1839,117,'SAL',1,0),
(1840,117,'TAL',1,0),
(1841,117,'TUK',1,0),
(1842,117,'VLK',1,0),
(1843,117,'VLM',1,0),
(1844,117,'VSR',1,0),
(1845,117,'DGV',1,0),
(1846,117,'JGV',1,0),
(1847,117,'JUR',1,0),
(1848,117,'LPK',1,0),
(1849,117,'RZK',1,0),
(1850,117,'RGA',1,0),
(1851,117,'VSL',1,0),
(1852,119,'BE',1,0),
(1853,119,'BB',1,0),
(1854,119,'LE',1,0),
(1855,119,'MF',1,0),
(1856,119,'MS',1,0),
(1857,119,'MH',1,0),
(1858,119,'MK',1,0),
(1859,119,'QN',1,0),
(1860,119,'QT',1,0),
(1861,119,'TT',1,0),
(1862,120,'BI',1,0),
(1863,120,'BG',1,0),
(1864,120,'GB',1,0),
(1865,120,'CM',1,0),
(1866,120,'GG',1,0),
(1867,120,'GK',1,0),
(1868,120,'LO',1,0),
(1869,120,'MG',1,0),
(1870,120,'ML',1,0),
(1871,120,'MS',1,0),
(1872,120,'NB',1,0),
(1873,120,'RC',1,0),
(1874,120,'SN',1,0),
(1875,121,'AJ',1,0),
(1876,121,'AZ',1,0),
(1877,121,'FA',1,0),
(1878,121,'JA',1,0),
(1879,121,'JU',1,0),
(1880,121,'KH',1,0),
(1881,121,'KU',1,0),
(1882,121,'NK',1,0),
(1883,121,'AS',1,0),
(1884,121,'AW',1,0),
(1885,121,'ZA',1,0),
(1886,121,'BA',1,0),
(1887,121,'DA',1,0),
(1888,121,'GD',1,0),
(1889,121,'GY',1,0),
(1890,121,'MI',1,0),
(1891,121,'MZ',1,0),
(1892,121,'SB',1,0),
(1893,121,'SW',1,0),
(1894,121,'SU',1,0),
(1895,121,'TL',1,0),
(1896,121,'TH',1,0),
(1897,121,'TU',1,0),
(1898,121,'YA',1,0),
(1899,121,'ZL',1,0),
(1900,122,'V',1,0),
(1901,122,'A',1,0),
(1902,122,'B',1,0),
(1903,122,'N',1,0),
(1904,122,'E',1,0),
(1905,122,'M',1,0),
(1906,122,'T',1,0),
(1907,122,'R',1,0),
(1908,122,'G',1,0),
(1909,122,'L',1,0),
(1910,122,'P',1,0),
(1911,123,'AL',1,0),
(1912,123,'KA',1,0),
(1913,123,'KL',1,0),
(1914,123,'MA',1,0),
(1915,123,'PA',1,0),
(1916,123,'SI',1,0),
(1917,123,'TA',1,0),
(1918,123,'TE',1,0),
(1919,123,'UT',1,0),
(1920,123,'VI',1,0),
(1921,124,'DD',1,0),
(1922,124,'DC',1,0),
(1923,124,'DR',1,0),
(1924,124,'DV',1,0),
(1925,124,'DW',1,0),
(1926,124,'GG',1,0),
(1927,124,'GE',1,0),
(1928,124,'GR',1,0),
(1929,124,'LL',1,0),
(1930,124,'LC',1,0),
(1931,124,'LE',1,0),
(1932,124,'LM',1,0),
(1933,125,'OLF',1,0),
(1934,125,'ANT',1,0),
(1935,125,'LAZ',1,0),
(1936,125,'CAT',1,0),
(1937,125,'LAW',1,0),
(1938,127,'AN',1,0),
(1939,127,'AS',1,0),
(1940,127,'FN',1,0),
(1941,127,'MJ',1,0),
(1942,127,'TM',1,0),
(1943,127,'TL',1,0),
(1944,128,'BLK',1,0),
(1945,128,'BLT',1,0),
(1946,128,'CKW',1,0),
(1947,128,'CRD',1,0),
(1948,128,'CTP',1,0),
(1949,128,'DDZ',1,0),
(1950,128,'DWA',1,0),
(1951,128,'KRG',1,0),
(1952,128,'KSG',1,0),
(1953,128,'LKM',1,0),
(1954,128,'LLG',1,0),
(1955,128,'MCG',1,0),
(1956,128,'MGC',1,0),
(1957,128,'MCH',1,0),
(1958,128,'MLJ',1,0),
(1959,128,'MWZ',1,0),
(1960,128,'MZM',1,0),
(1961,128,'NTU',1,0),
(1962,128,'NKB',1,0),
(1963,128,'NKH',1,0),
(1964,128,'NSJ',1,0),
(1965,128,'NTI',1,0),
(1966,128,'PHL',1,0),
(1967,128,'RMP',1,0),
(1968,128,'SLM',1,0),
(1969,128,'THY',1,0),
(1970,128,'ZBA',1,0),
(1971,129,'JO',1,0),
(1972,129,'KE',1,0),
(1973,129,'KL',1,0),
(1974,129,'LA',1,0),
(1975,129,'ME',1,0),
(1976,129,'NS',1,0),
(1977,129,'PA',1,0),
(1978,129,'PE',1,0),
(1979,129,'PR',1,0),
(1980,129,'PP',1,0),
(1981,129,'SA',1,0),
(1982,129,'SR',1,0),
(1983,129,'SE',1,0),
(1984,129,'TE',1,0),
(1985,129,'WP',1,0),
(1986,130,'THU',1,0),
(1987,130,'THD',1,0),
(1988,130,'MLU',1,0),
(1989,130,'MLD',1,0),
(1990,130,'MAU',1,0),
(1991,130,'MAD',1,0),
(1992,130,'FAA',1,0),
(1993,130,'MAA',1,0),
(1994,130,'AAU',1,0),
(1995,130,'AAD',1,0),
(1996,130,'FEA',1,0),
(1997,130,'MUA',1,0),
(1998,130,'NAU',1,0),
(1999,130,'NAD',1,0),
(2000,130,'KLH',1,0),
(2001,130,'HDH',1,0),
(2002,130,'HAU',1,0),
(2003,130,'HAD',1,0),
(2004,130,'FMU',1,0),
(2005,130,'ADD',1,0),
(2006,131,'GA',1,0),
(2007,131,'KY',1,0),
(2008,131,'KD',1,0),
(2009,131,'KL',1,0),
(2010,131,'MP',1,0),
(2011,131,'SG',1,0),
(2012,131,'SK',1,0),
(2013,131,'TB',1,0),
(2014,131,'CD',1,0),
(2015,132,'ATT',1,0),
(2016,132,'BAL',1,0),
(2017,132,'BGU',1,0),
(2018,132,'BKK',1,0),
(2019,132,'BRZ',1,0),
(2020,132,'BOR',1,0),
(2021,132,'DIN',1,0),
(2022,132,'FGU',1,0),
(2023,132,'FLO',1,0),
(2024,132,'GDJ',1,0),
(2025,132,'GZR',1,0),
(2026,132,'GRG',1,0),
(2027,132,'GXQ',1,0),
(2028,132,'HMR',1,0),
(2029,132,'IKL',1,0),
(2030,132,'ISL',1,0),
(2031,132,'KLK',1,0),
(2032,132,'KRK',1,0),
(2033,132,'LIJ',1,0),
(2034,132,'LUQ',1,0),
(2035,132,'MRS',1,0),
(2036,132,'MKL',1,0),
(2037,132,'MXL',1,0),
(2038,132,'MDN',1,0),
(2039,132,'MEL',1,0),
(2040,132,'MGR',1,0),
(2041,132,'MST',1,0),
(2042,132,'MQA',1,0),
(2043,132,'MSI',1,0),
(2044,132,'MTF',1,0),
(2045,132,'NAX',1,0),
(2046,132,'PAO',1,0),
(2047,132,'PEM',1,0),
(2048,132,'PIE',1,0),
(2049,132,'QOR',1,0),
(2050,132,'QRE',1,0),
(2051,132,'RAB',1,0),
(2052,132,'SAF',1,0),
(2053,132,'SGI',1,0),
(2054,132,'SLU',1,0),
(2055,132,'SPB',1,0),
(2056,132,'SGW',1,0),
(2057,132,'SVE',1,0),
(2058,132,'SIG',1,0),
(2059,132,'SLM',1,0),
(2060,132,'SWQ',1,0),
(2061,132,'TXB',1,0),
(2062,132,'TRX',1,0),
(2063,132,'VLT',1,0),
(2064,132,'XGJ',1,0),
(2065,132,'ZBR',1,0),
(2066,132,'ZBG',1,0),
(2067,132,'ZJT',1,0),
(2068,132,'ZRQ',1,0),
(2069,132,'FNT',1,0),
(2070,132,'GHJ',1,0),
(2071,132,'GHR',1,0),
(2072,132,'GHS',1,0),
(2073,132,'KRC',1,0),
(2074,132,'MUN',1,0),
(2075,132,'NAD',1,0),
(2076,132,'QAL',1,0),
(2077,132,'VIC',1,0),
(2078,132,'SLA',1,0),
(2079,132,'SNT',1,0),
(2080,132,'ZAG',1,0),
(2081,132,'XEW',1,0),
(2082,132,'ZEB',1,0),
(2083,133,'ALG',1,0),
(2084,133,'ALL',1,0),
(2085,133,'ALK',1,0),
(2086,133,'ARN',1,0),
(2087,133,'AUR',1,0),
(2088,133,'BKR',1,0),
(2089,133,'BKN',1,0),
(2090,133,'BKK',1,0),
(2091,133,'EBN',1,0),
(2092,133,'ENT',1,0),
(2093,133,'EKB',1,0),
(2094,133,'JBT',1,0),
(2095,133,'JLT',1,0),
(2096,133,'JEM',1,0),
(2097,133,'KIL',1,0),
(2098,133,'KWJ',1,0),
(2099,133,'LAE',1,0),
(2100,133,'LIB',1,0),
(2101,133,'LKP',1,0),
(2102,133,'MJR',1,0),
(2103,133,'MLP',1,0),
(2104,133,'MJT',1,0),
(2105,133,'MIL',1,0),
(2106,133,'NMK',1,0),
(2107,133,'NAM',1,0),
(2108,133,'RGL',1,0),
(2109,133,'RGK',1,0),
(2110,133,'TOK',1,0),
(2111,133,'UJA',1,0),
(2112,133,'UJL',1,0),
(2113,133,'UTK',1,0),
(2114,133,'WTH',1,0),
(2115,133,'WTJ',1,0),
(2116,135,'AD',1,0),
(2117,135,'AS',1,0),
(2118,135,'BR',1,0),
(2119,135,'DN',1,0),
(2120,135,'GO',1,0),
(2121,135,'GM',1,0),
(2122,135,'HC',1,0),
(2123,135,'HG',1,0),
(2124,135,'IN',1,0),
(2125,135,'TA',1,0),
(2126,135,'TZ',1,0),
(2127,135,'TR',1,0),
(2128,135,'NO',1,0),
(2129,136,'BR',1,0),
(2130,136,'CU',1,0),
(2131,136,'PU',1,0),
(2132,136,'QB',1,0),
(2133,136,'VP',1,0),
(2134,136,'AG',1,0),
(2135,136,'CC',1,0),
(2136,136,'RO',1,0),
(2137,136,'BL',1,0),
(2138,136,'FL',1,0),
(2139,136,'GP',1,0),
(2140,136,'MO',1,0),
(2141,136,'PA',1,0),
(2142,136,'PW',1,0),
(2143,136,'PL',1,0),
(2144,136,'RR',1,0),
(2145,136,'SA',1,0),
(2146,138,'BN',1,0),
(2147,138,'BS',1,0),
(2148,138,'CA',1,0),
(2149,138,'CI',1,0),
(2150,138,'CH',1,0),
(2151,138,'CZ',1,0),
(2152,138,'CL',1,0),
(2153,138,'DF',1,0),
(2154,138,'DU',1,0),
(2155,138,'GA',1,0),
(2156,138,'GE',1,0),
(2157,138,'HI',1,0),
(2158,138,'JA',1,0),
(2159,138,'ME',1,0),
(2160,138,'MI',1,0),
(2161,138,'MO',1,0),
(2162,138,'NA',1,0),
(2163,138,'NL',1,0),
(2164,138,'OA',1,0),
(2165,138,'PU',1,0),
(2166,138,'QA',1,0),
(2167,138,'QR',1,0),
(2168,138,'SA',1,0),
(2169,138,'SI',1,0),
(2170,138,'SO',1,0),
(2171,138,'TB',1,0),
(2172,138,'TM',1,0),
(2173,138,'TL',1,0),
(2174,138,'VE',1,0),
(2175,138,'YU',1,0),
(2176,138,'ZA',1,0),
(2177,139,'C',1,0),
(2178,139,'K',1,0),
(2179,139,'P',1,0),
(2180,139,'Y',1,0),
(2181,140,'GA',1,0),
(2182,140,'CU',1,0),
(2183,140,'BA',1,0),
(2184,140,'CA',1,0),
(2185,140,'ED',1,0),
(2186,140,'LA',1,0),
(2187,140,'OR',1,0),
(2188,140,'SO',1,0),
(2189,140,'TI',1,0),
(2190,140,'UN',1,0),
(2191,140,'SN',1,0),
(2192,141,'FV',1,0),
(2193,141,'LC',1,0),
(2194,141,'MV',1,0),
(2195,141,'MC',1,0),
(2196,142,'1',1,0),
(2197,142,'035',1,0),
(2198,142,'037',1,0),
(2199,142,'039',1,0),
(2200,142,'041',1,0),
(2201,142,'043',1,0),
(2202,142,'046',1,0),
(2203,142,'047',1,0),
(2204,142,'049',1,0),
(2205,142,'051',1,0),
(2206,142,'053',1,0),
(2207,142,'055',1,0),
(2208,142,'057',1,0),
(2209,142,'059',1,0),
(2210,142,'061',1,0),
(2211,142,'063',1,0),
(2212,142,'064',1,0),
(2213,142,'065',1,0),
(2214,142,'067',1,0),
(2215,142,'069',1,0),
(2216,142,'071',1,0),
(2217,142,'073',1,0),
(2218,143,'A',1,0),
(2219,143,'G',1,0),
(2220,143,'P',1,0),
(2221,144,'AGD',1,0),
(2222,144,'HOC',1,0),
(2223,144,'AZI',1,0),
(2224,144,'BME',1,0),
(2225,144,'BSL',1,0),
(2226,144,'BLM',1,0),
(2227,144,'CBL',1,0),
(2228,144,'CHA',1,0),
(2229,144,'EJA',1,0),
(2230,144,'EKS',1,0),
(2231,144,'ERA',1,0),
(2232,144,'ESS',1,0),
(2233,144,'FES',1,0),
(2234,144,'FIG',1,0),
(2235,144,'GLM',1,0),
(2236,144,'IFR',1,0),
(2237,144,'KEN',1,0),
(2238,144,'KHM',1,0),
(2239,144,'KHN',1,0),
(2240,144,'KHO',1,0),
(2241,144,'LYN',1,0),
(2242,144,'LAR',1,0),
(2243,144,'MRK',1,0),
(2244,144,'MKN',1,0),
(2245,144,'NAD',1,0),
(2246,144,'ORZ',1,0),
(2247,144,'OUJ',1,0),
(2248,144,'RSA',1,0),
(2249,144,'SAF',1,0),
(2250,144,'SET',1,0),
(2251,144,'SKA',1,0),
(2252,144,'TGR',1,0),
(2253,144,'TAN',1,0),
(2254,144,'TAO',1,0),
(2255,144,'TRD',1,0),
(2256,144,'TAT',1,0),
(2257,144,'TAZ',1,0),
(2258,144,'TET',1,0),
(2259,144,'TIZ',1,0),
(2260,144,'ADK',1,0),
(2261,144,'BJD',1,0),
(2262,144,'ESM',1,0),
(2263,145,'CD',1,0),
(2264,145,'GZ',1,0),
(2265,145,'IN',1,0),
(2266,145,'MN',1,0),
(2267,145,'MC',1,0),
(2268,145,'MP',1,0),
(2269,145,'NA',1,0),
(2270,145,'NI',1,0),
(2271,145,'SO',1,0),
(2272,145,'TE',1,0),
(2273,145,'ZA',1,0),
(2274,146,'AY',1,0),
(2275,146,'BG',1,0),
(2276,146,'MG',1,0),
(2277,146,'MD',1,0),
(2278,146,'SG',1,0),
(2279,146,'TN',1,0),
(2280,146,'YG',1,0),
(2281,146,'CH',1,0),
(2282,146,'KC',1,0),
(2283,146,'KH',1,0),
(2284,146,'KN',1,0),
(2285,146,'MN',1,0),
(2286,146,'RK',1,0),
(2287,146,'SH',1,0),
(2288,147,'CA',1,0),
(2289,147,'ER',1,0),
(2290,147,'HA',1,0),
(2291,147,'KR',1,0),
(2292,147,'KV',1,0),
(2293,147,'KH',1,0),
(2294,147,'KU',1,0),
(2295,147,'OW',1,0),
(2296,147,'OK',1,0),
(2297,147,'OT',1,0),
(2298,147,'ON',1,0),
(2299,147,'OO',1,0),
(2300,147,'OJ',1,0),
(2301,148,'AO',1,0),
(2302,148,'AA',1,0),
(2303,148,'AT',1,0),
(2304,148,'AI',1,0),
(2305,148,'BA',1,0),
(2306,148,'BO',1,0),
(2307,148,'BU',1,0),
(2308,148,'DE',1,0),
(2309,148,'EW',1,0),
(2310,148,'IJ',1,0),
(2311,148,'ME',1,0),
(2312,148,'NI',1,0),
(2313,148,'UA',1,0),
(2314,148,'YA',1,0),
(2315,149,'BA',1,0),
(2316,149,'BH',1,0),
(2317,149,'DH',1,0),
(2318,149,'GA',1,0),
(2319,149,'JA',1,0),
(2320,149,'KA',1,0),
(2321,149,'KO',1,0),
(2322,149,'LU',1,0),
(2323,149,'MA',1,0),
(2324,149,'ME',1,0),
(2325,149,'NA',1,0),
(2326,149,'RA',1,0),
(2327,149,'SA',1,0),
(2328,149,'SE',1,0),
(2329,150,'DR',1,0),
(2330,150,'FL',1,0),
(2331,150,'FR',1,0),
(2332,150,'GE',1,0),
(2333,150,'GR',1,0),
(2334,150,'LI',1,0),
(2335,150,'NB',1,0),
(2336,150,'NH',1,0),
(2337,150,'OV',1,0),
(2338,150,'UT',1,0),
(2339,150,'ZE',1,0),
(2340,150,'ZH',1,0),
(2341,152,'L',1,0),
(2342,152,'N',1,0),
(2343,152,'S',1,0),
(2344,153,'AUK',1,0),
(2345,153,'BOP',1,0),
(2346,153,'CAN',1,0),
(2347,153,'COR',1,0),
(2348,153,'GIS',1,0),
(2349,153,'FIO',1,0),
(2350,153,'HKB',1,0),
(2351,153,'MBH',1,0),
(2352,153,'MWT',1,0),
(2353,153,'MCM',1,0),
(2354,153,'NSN',1,0),
(2355,153,'NTL',1,0),
(2356,153,'OTA',1,0),
(2357,153,'STL',1,0),
(2358,153,'TKI',1,0),
(2359,153,'WGN',1,0),
(2360,153,'WKO',1,0),
(2361,153,'WAI',1,0),
(2362,153,'WTC',1,0),
(2363,154,'AN',1,0),
(2364,154,'AS',1,0),
(2365,154,'BO',1,0),
(2366,154,'CA',1,0),
(2367,154,'CI',1,0),
(2368,154,'CO',1,0),
(2369,154,'ES',1,0),
(2370,154,'GR',1,0),
(2371,154,'JI',1,0),
(2372,154,'LE',1,0),
(2373,154,'MD',1,0),
(2374,154,'MN',1,0),
(2375,154,'MS',1,0),
(2376,154,'MT',1,0),
(2377,154,'NS',1,0),
(2378,154,'RS',1,0),
(2379,154,'RI',1,0),
(2380,155,'AG',1,0),
(2381,155,'DF',1,0),
(2382,155,'DS',1,0),
(2383,155,'MA',1,0),
(2384,155,'NM',1,0),
(2385,155,'TH',1,0),
(2386,155,'TL',1,0),
(2387,155,'ZD',1,0),
(2388,156,'AB',1,0),
(2389,156,'CT',1,0),
(2390,156,'AD',1,0),
(2391,156,'AK',1,0),
(2392,156,'AN',1,0),
(2393,156,'BC',1,0),
(2394,156,'BY',1,0),
(2395,156,'BN',1,0),
(2396,156,'BO',1,0),
(2397,156,'CR',1,0),
(2398,156,'DE',1,0),
(2399,156,'EB',1,0),
(2400,156,'ED',1,0),
(2401,156,'EK',1,0),
(2402,156,'EN',1,0),
(2403,156,'GO',1,0),
(2404,156,'IM',1,0),
(2405,156,'JI',1,0),
(2406,156,'KD',1,0),
(2407,156,'KN',1,0),
(2408,156,'KT',1,0),
(2409,156,'KE',1,0),
(2410,156,'KO',1,0),
(2411,156,'KW',1,0),
(2412,156,'LA',1,0),
(2413,156,'NA',1,0),
(2414,156,'NI',1,0),
(2415,156,'OG',1,0),
(2416,156,'ONG',1,0),
(2417,156,'OS',1,0),
(2418,156,'OY',1,0),
(2419,156,'PL',1,0),
(2420,156,'RI',1,0),
(2421,156,'SO',1,0),
(2422,156,'TA',1,0),
(2423,156,'YO',1,0),
(2424,156,'ZA',1,0),
(2425,159,'N',1,0),
(2426,159,'R',1,0),
(2427,159,'S',1,0),
(2428,159,'T',1,0),
(2429,160,'AK',1,0),
(2430,160,'AA',1,0),
(2431,160,'BU',1,0),
(2432,160,'FM',1,0),
(2433,160,'HM',1,0),
(2434,160,'HL',1,0),
(2435,160,'MR',1,0),
(2436,160,'NT',1,0),
(2437,160,'NL',1,0),
(2438,160,'OF',1,0),
(2439,160,'OP',1,0),
(2440,160,'OL',1,0),
(2441,160,'RL',1,0),
(2442,160,'ST',1,0),
(2443,160,'SJ',1,0),
(2444,160,'SV',1,0),
(2445,160,'TM',1,0),
(2446,160,'TR',1,0),
(2447,160,'VA',1,0),
(2448,160,'VF',1,0),
(2449,161,'DA',1,0),
(2450,161,'BA',1,0),
(2451,161,'WU',1,0),
(2452,161,'SH',1,0),
(2453,161,'ZA',1,0),
(2454,161,'MA',1,0),
(2455,161,'MU',1,0),
(2456,161,'ZU',1,0),
(2457,162,'B',1,0),
(2458,162,'T',1,0),
(2459,162,'I',1,0),
(2460,162,'N',1,0),
(2461,162,'P',1,0),
(2462,162,'S',1,0),
(2463,163,'AM',1,0),
(2464,163,'AR',1,0),
(2465,163,'AN',1,0),
(2466,163,'HA',1,0),
(2467,163,'KA',1,0),
(2468,163,'KO',1,0),
(2469,163,'ME',1,0),
(2470,163,'NA',1,0),
(2471,163,'NG',1,0),
(2472,163,'ND',1,0),
(2473,163,'NT',1,0),
(2474,163,'NC',1,0),
(2475,163,'NR',1,0),
(2476,163,'NW',1,0),
(2477,163,'PE',1,0),
(2478,163,'SO',1,0),
(2479,164,'BT',1,0),
(2480,164,'CH',1,0),
(2481,164,'CC',1,0),
(2482,164,'CL',1,0),
(2483,164,'DA',1,0),
(2484,164,'HE',1,0),
(2485,164,'LS',1,0),
(2486,164,'PA',1,0),
(2487,164,'SB',1,0),
(2488,164,'VG',1,0),
(2489,165,'BV',1,0),
(2490,165,'CE',1,0),
(2491,165,'CH',1,0),
(2492,165,'EH',1,0),
(2493,165,'EB',1,0),
(2494,165,'ES',1,0),
(2495,165,'EN',1,0),
(2496,165,'GU',1,0),
(2497,165,'MD',1,0),
(2498,165,'MN',1,0),
(2499,165,'MB',1,0),
(2500,165,'MR',1,0),
(2501,165,'NC',1,0),
(2502,165,'NI',1,0),
(2503,165,'NO',1,0),
(2504,165,'SA',1,0),
(2505,165,'SH',1,0),
(2506,165,'WE',1,0),
(2507,165,'WH',1,0),
(2508,165,'WB',1,0),
(2509,166,'AG',1,0),
(2510,166,'AN',1,0),
(2511,166,'AM',1,0),
(2512,166,'AS',1,0),
(2513,166,'BO',1,0),
(2514,166,'CG',1,0),
(2515,166,'CZ',1,0),
(2516,166,'CN',1,0),
(2517,166,'CE',1,0),
(2518,166,'CC',1,0),
(2519,166,'CD',1,0),
(2520,166,'GU',1,0),
(2521,166,'IT',1,0),
(2522,166,'MI',1,0),
(2523,166,'NE',1,0),
(2524,166,'PA',1,0),
(2525,166,'PH',1,0),
(2526,166,'SP',1,0),
(2527,167,'AM',1,0),
(2528,167,'AN',1,0),
(2529,167,'AP',1,0),
(2530,167,'AR',1,0),
(2531,167,'AY',1,0),
(2532,167,'CJ',1,0),
(2533,167,'CL',1,0),
(2534,167,'CU',1,0),
(2535,167,'HV',1,0),
(2536,167,'HO',1,0),
(2537,167,'IC',1,0),
(2538,167,'JU',1,0),
(2539,167,'LD',1,0),
(2540,167,'LY',1,0),
(2541,167,'LI',1,0),
(2542,167,'LO',1,0),
(2543,167,'MD',1,0),
(2544,167,'MO',1,0),
(2545,167,'PA',1,0),
(2546,167,'PI',1,0),
(2547,167,'PU',1,0),
(2548,167,'SM',1,0),
(2549,167,'TA',1,0),
(2550,167,'TU',1,0),
(2551,167,'UC',1,0),
(2552,168,'ABR',1,0),
(2553,168,'ANO',1,0),
(2554,168,'ASU',1,0),
(2555,168,'AKL',1,0),
(2556,168,'ALB',1,0),
(2557,168,'ANT',1,0),
(2558,168,'APY',1,0),
(2559,168,'AUR',1,0),
(2560,168,'BAS',1,0),
(2561,168,'BTA',1,0),
(2562,168,'BTE',1,0),
(2563,168,'BTG',1,0),
(2564,168,'BLR',1,0),
(2565,168,'BEN',1,0),
(2566,168,'BOL',1,0),
(2567,168,'BUK',1,0),
(2568,168,'BUL',1,0),
(2569,168,'CAG',1,0),
(2570,168,'CNO',1,0),
(2571,168,'CSU',1,0),
(2572,168,'CAM',1,0),
(2573,168,'CAP',1,0),
(2574,168,'CAT',1,0),
(2575,168,'CAV',1,0),
(2576,168,'CEB',1,0),
(2577,168,'CMP',1,0),
(2578,168,'DNO',1,0),
(2579,168,'DSU',1,0),
(2580,168,'DOR',1,0),
(2581,168,'ESA',1,0),
(2582,168,'GUI',1,0),
(2583,168,'IFU',1,0),
(2584,168,'INO',1,0),
(2585,168,'ISU',1,0),
(2586,168,'ILO',1,0),
(2587,168,'ISA',1,0),
(2588,168,'KAL',1,0),
(2589,168,'LAG',1,0),
(2590,168,'LNO',1,0),
(2591,168,'LSU',1,0),
(2592,168,'UNI',1,0),
(2593,168,'LEY',1,0),
(2594,168,'MAG',1,0),
(2595,168,'MRN',1,0),
(2596,168,'MSB',1,0),
(2597,168,'MIC',1,0),
(2598,168,'MIR',1,0),
(2599,168,'MSC',1,0),
(2600,168,'MOR',1,0),
(2601,168,'MOP',1,0),
(2602,168,'NOC',1,0),
(2603,168,'NOR',1,0),
(2604,168,'NCT',1,0),
(2605,168,'NSM',1,0),
(2606,168,'NEC',1,0),
(2607,168,'NVZ',1,0),
(2608,168,'PLW',1,0),
(2609,168,'PMP',1,0),
(2610,168,'PNG',1,0),
(2611,168,'QZN',1,0),
(2612,168,'QRN',1,0),
(2613,168,'RIZ',1,0),
(2614,168,'ROM',1,0),
(2615,168,'SMR',1,0),
(2616,168,'SRG',1,0),
(2617,168,'SQJ',1,0),
(2618,168,'SRS',1,0),
(2619,168,'SCO',1,0),
(2620,168,'SLE',1,0),
(2621,168,'SKU',1,0),
(2622,168,'SLU',1,0),
(2623,168,'SNO',1,0),
(2624,168,'SSU',1,0),
(2625,168,'TAR',1,0),
(2626,168,'TAW',1,0),
(2627,168,'ZBL',1,0),
(2628,168,'ZNO',1,0),
(2629,168,'ZSU',1,0),
(2630,168,'ZSI',1,0),
(2631,170,'DO',1,0),
(2632,170,'KP',1,0),
(2633,170,'LO',1,0),
(2634,170,'LL',1,0),
(2635,170,'LU',1,0),
(2636,170,'ML',1,0),
(2637,170,'MZ',1,0),
(2638,170,'OP',1,0),
(2639,170,'PP',1,0),
(2640,170,'PL',1,0),
(2641,170,'PM',1,0),
(2642,170,'SL',1,0),
(2643,170,'SW',1,0),
(2644,170,'WM',1,0),
(2645,170,'WP',1,0),
(2646,170,'ZA',1,0),
(2647,198,'P',1,0),
(2648,198,'M',1,0),
(2649,171,'AC',1,0),
(2650,171,'AV',1,0),
(2651,171,'BE',1,0),
(2652,171,'BR',1,0),
(2653,171,'BA',1,0),
(2654,171,'CB',1,0),
(2655,171,'CO',1,0),
(2656,171,'EV',1,0),
(2657,171,'FA',1,0),
(2658,171,'GU',1,0),
(2659,171,'LE',1,0),
(2660,171,'LI',1,0),
(2661,171,'ME',1,0),
(2662,171,'PO',1,0),
(2663,171,'PR',1,0),
(2664,171,'SA',1,0),
(2665,171,'SE',1,0),
(2666,171,'VC',1,0),
(2667,171,'VR',1,0),
(2668,171,'VI',1,0),
(2669,173,'DW',1,0),
(2670,173,'GW',1,0),
(2671,173,'JM',1,0),
(2672,173,'KR',1,0),
(2673,173,'WK',1,0),
(2674,173,'RN',1,0),
(2675,173,'JB',1,0),
(2676,173,'MS',1,0),
(2677,173,'UD',1,0),
(2678,173,'UL',1,0),
(2679,175,'AB',1,0),
(2680,175,'AR',1,0),
(2681,175,'AG',1,0),
(2682,175,'BC',1,0),
(2683,175,'BH',1,0),
(2684,175,'BN',1,0),
(2685,175,'BT',1,0),
(2686,175,'BV',1,0),
(2687,175,'BR',1,0),
(2688,175,'B',1,0),
(2689,175,'BZ',1,0),
(2690,175,'CS',1,0),
(2691,175,'CL',1,0),
(2692,175,'CJ',1,0),
(2693,175,'CT',1,0),
(2694,175,'CV',1,0),
(2695,175,'DB',1,0),
(2696,175,'DJ',1,0),
(2697,175,'GL',1,0),
(2698,175,'GR',1,0),
(2699,175,'GJ',1,0),
(2700,175,'HR',1,0),
(2701,175,'HD',1,0),
(2702,175,'IL',1,0),
(2703,175,'IS',1,0),
(2704,175,'IF',1,0),
(2705,175,'MM',1,0),
(2706,175,'MH',1,0),
(2707,175,'MS',1,0),
(2708,175,'NT',1,0),
(2709,175,'OT',1,0),
(2710,175,'PH',1,0),
(2711,175,'SM',1,0),
(2712,175,'SJ',1,0),
(2713,175,'SB',1,0),
(2714,175,'SV',1,0),
(2715,175,'TR',1,0),
(2716,175,'TM',1,0),
(2717,175,'TL',1,0),
(2718,175,'VS',1,0),
(2719,175,'VL',1,0),
(2720,175,'VN',1,0),
(2721,176,'KK',1,0),
(2722,176,'AB',1,0),
(2723,176,'CHU',1,0),
(2724,176,'ARK',1,0),
(2725,176,'AST',1,0),
(2726,176,'ALT',1,0),
(2727,176,'BEL',1,0),
(2728,176,'YEV',1,0),
(2729,176,'AMU',1,0),
(2730,176,'BRY',1,0),
(2731,176,'CU',1,0),
(2732,176,'CHE',1,0),
(2733,176,'KC',1,0),
(2734,176,'ZAB',1,0),
(2735,176,'TDN',1,0),
(2736,176,'KL',1,0),
(2737,176,'MOS',1,0),
(2738,176,'AL',1,0),
(2739,176,'CE',1,0),
(2740,176,'IRK',1,0),
(2741,176,'IVA',1,0),
(2742,176,'UD',1,0),
(2743,176,'KGD',1,0),
(2744,176,'KLU',1,0),
(2745,176,'KIR',1,0),
(2746,176,'TA',1,0),
(2747,176,'KEM',1,0),
(2748,176,'KHA',1,0),
(2749,176,'KHM',1,0),
(2750,176,'KOS',1,0),
(2751,176,'KDA',1,0),
(2752,176,'KYA',1,0),
(2753,176,'KPO',1,0),
(2754,176,'KGN',1,0),
(2755,176,'KRS',1,0),
(2756,176,'TY',1,0),
(2757,176,'LIP',1,0),
(2758,176,'MAG',1,0),
(2759,176,'DA',1,0),
(2760,176,'AD',1,0),
(2761,176,'MOW',1,0),
(2762,176,'MUR',1,0),
(2763,176,'KB',1,0),
(2764,176,'NEN',1,0),
(2765,176,'IN',1,0),
(2766,176,'NIZ',1,0),
(2767,176,'NGR',1,0),
(2768,176,'NVS',1,0),
(2769,176,'OMS',1,0),
(2770,176,'ORL',1,0),
(2771,176,'ORE',1,0),
(2772,176,'LEN',1,0),
(2773,176,'PNZ',1,0),
(2774,176,'PER',1,0),
(2775,176,'KAM',1,0),
(2776,176,'KR',1,0),
(2777,176,'PSK',1,0),
(2778,176,'ROS',1,0),
(2779,176,'RYA',1,0),
(2780,176,'YAN',1,0),
(2781,176,'SAM',1,0),
(2782,176,'MO',1,0),
(2783,176,'SAR',1,0),
(2784,176,'SMO',1,0),
(2785,176,'SPE',1,0),
(2786,176,'STA',1,0),
(2787,176,'KO',1,0),
(2788,176,'TAM',1,0),
(2789,176,'TOM',1,0),
(2790,176,'TUL',1,0),
(2791,176,'EO',1,0),
(2792,176,'TVE',1,0),
(2793,176,'TYU',1,0),
(2794,176,'BA',1,0),
(2795,176,'ULY',1,0),
(2796,176,'BU',1,0),
(2797,176,'UOB',1,0),
(2798,176,'SE',1,0),
(2799,176,'VLA',1,0),
(2800,176,'PRI',1,0),
(2801,176,'VGG',1,0),
(2802,176,'VLG',1,0),
(2803,176,'VOR',1,0),
(2804,176,'SAK',1,0),
(2805,176,'SA',1,0),
(2806,176,'YAR',1,0),
(2807,176,'SVE',1,0),
(2808,176,'ME',1,0),
(2809,177,'BU',1,0),
(2810,177,'BY',1,0),
(2811,177,'CY',1,0),
(2812,177,'GK',1,0),
(2813,177,'GS',1,0),
(2814,177,'GT',1,0),
(2815,177,'KG',1,0),
(2816,177,'KY',1,0),
(2817,177,'KR',1,0),
(2818,177,'KV',1,0),
(2819,177,'RU',1,0),
(2820,177,'UM',1,0),
(2821,178,'CCN',1,0),
(2822,178,'SAS',1,0),
(2823,178,'SGB',1,0),
(2824,178,'SGG',1,0),
(2825,178,'SJW',1,0),
(2826,178,'SJC',1,0),
(2827,178,'SJF',1,0),
(2828,178,'SMC',1,0),
(2829,178,'CAP',1,0),
(2830,178,'CHA',1,0),
(2831,178,'SPB',1,0),
(2832,178,'STL',1,0),
(2833,178,'STM',1,0),
(2834,178,'TPP',1,0),
(2835,179,'AR',1,0),
(2836,179,'CA',1,0),
(2837,179,'CH',1,0),
(2838,179,'DA',1,0),
(2839,179,'DE',1,0),
(2840,179,'GI',1,0),
(2841,179,'LA',1,0),
(2842,179,'MI',1,0),
(2843,179,'PR',1,0),
(2844,179,'SO',1,0),
(2845,179,'VF',1,0),
(2846,180,'C',1,0),
(2847,180,'R',1,0),
(2848,180,'A',1,0),
(2849,180,'D',1,0),
(2850,180,'G',1,0),
(2851,180,'P',1,0),
(2852,181,'AN',1,0),
(2853,181,'AI',1,0),
(2854,181,'AT',1,0),
(2855,181,'FA',1,0),
(2856,181,'GE',1,0),
(2857,181,'GF',1,0),
(2858,181,'PA',1,0),
(2859,181,'SA',1,0),
(2860,181,'TU',1,0),
(2861,181,'VF',1,0),
(2862,181,'VS',1,0),
(2863,182,'AC',1,0),
(2864,182,'BM',1,0),
(2865,182,'CH',1,0),
(2866,182,'DO',1,0),
(2867,182,'FA',1,0),
(2868,182,'FI',1,0),
(2869,182,'MO',1,0),
(2870,182,'SM',1,0),
(2871,182,'SE',1,0),
(2872,183,'S',1,0),
(2873,183,'P',1,0),
(2874,184,'BH',1,0),
(2875,184,'HS',1,0),
(2876,184,'JF',1,0),
(2877,184,'MD',1,0),
(2878,184,'QS',1,0),
(2879,184,'RD',1,0),
(2880,184,'AQ',1,0),
(2881,184,'AS',1,0),
(2882,184,'HL',1,0),
(2883,184,'JZ',1,0),
(2884,184,'ML',1,0),
(2885,184,'NR',1,0),
(2886,184,'TB',1,0),
(2887,185,'DA',1,0),
(2888,185,'DI',1,0),
(2889,185,'FA',1,0),
(2890,185,'KA',1,0),
(2891,185,'KO',1,0),
(2892,185,'LO',1,0),
(2893,185,'MA',1,0),
(2894,185,'SL',1,0),
(2895,185,'TA',1,0),
(2896,185,'TH',1,0),
(2897,185,'ZI',1,0),
(2898,186,'AP',1,0),
(2899,186,'AB',1,0),
(2900,186,'AE',1,0),
(2901,186,'AL',1,0),
(2902,186,'AR',1,0),
(2903,186,'BL',1,0),
(2904,186,'BS',1,0),
(2905,186,'BV',1,0),
(2906,186,'BA',1,0),
(2907,186,'BO',1,0),
(2908,186,'CA',1,0),
(2909,186,'GL',1,0),
(2910,186,'GM',1,0),
(2911,186,'GP',1,0),
(2912,186,'DG',1,0),
(2913,186,'RA',1,0),
(2914,186,'MB',1,0),
(2915,186,'MF',1,0),
(2916,186,'PL',1,0),
(2917,186,'PR',1,0),
(2918,186,'PG',1,0),
(2919,186,'SL',1,0),
(2920,186,'TA',1,0),
(2921,187,'E',1,0),
(2922,187,'N',1,0),
(2923,187,'S',1,0),
(2924,187,'W',1,0),
(2925,189,'BA',1,0),
(2926,189,'BR',1,0),
(2927,189,'KO',1,0),
(2928,189,'NI',1,0),
(2929,189,'PR',1,0),
(2930,189,'TC',1,0),
(2931,189,'TV',1,0),
(2932,189,'ZI',1,0),
(2933,191,'CE',1,0),
(2934,191,'CH',1,0),
(2935,191,'GC',1,0),
(2936,191,'HO',1,0),
(2937,191,'IS',1,0),
(2938,191,'MK',1,0),
(2939,191,'ML',1,0),
(2940,191,'RB',1,0),
(2941,191,'TM',1,0),
(2942,191,'WE',1,0),
(2943,192,'AW',1,0),
(2944,192,'BK',1,0),
(2945,192,'BN',1,0),
(2946,192,'BR',1,0),
(2947,192,'BY',1,0),
(2948,192,'GA',1,0),
(2949,192,'GE',1,0),
(2950,192,'HI',1,0),
(2951,192,'JD',1,0),
(2952,192,'JH',1,0),
(2953,192,'MU',1,0),
(2954,192,'NU',1,0),
(2955,192,'SA',1,0),
(2956,192,'SD',1,0),
(2957,192,'SH',1,0),
(2958,192,'SL',1,0),
(2959,192,'TO',1,0),
(2960,192,'WG',1,0),
(2961,193,'EC',1,0),
(2962,193,'FS',1,0),
(2963,193,'GT',1,0),
(2964,193,'KN',1,0),
(2965,193,'LP',1,0),
(2966,193,'MP',1,0),
(2967,193,'NW',1,0),
(2968,193,'NC',1,0),
(2969,193,'WC',1,0),
(2970,195,'CA',1,0),
(2971,195,'AL',1,0),
(2972,195,'AB',1,0),
(2973,195,'AC',1,0),
(2974,195,'AM',1,0),
(2975,195,'AS',1,0),
(2976,195,'AV',1,0),
(2977,195,'BJ',1,0),
(2978,195,'IB',1,0),
(2979,195,'BA',1,0),
(2980,195,'BU',1,0),
(2981,195,'CC',1,0),
(2982,195,'CZ',1,0),
(2983,195,'CT',1,0),
(2984,195,'CL',1,0),
(2985,195,'CE',1,0),
(2986,195,'CR',1,0),
(2987,195,'CD',1,0),
(2988,195,'CU',1,0),
(2989,195,'GI',1,0),
(2990,195,'GD',1,0),
(2991,195,'GJ',1,0),
(2992,195,'GP',1,0),
(2993,195,'HL',1,0),
(2994,195,'HS',1,0),
(2995,195,'JN',1,0),
(2996,195,'RJ',1,0),
(2997,195,'PM',1,0),
(2998,195,'LE',1,0),
(2999,195,'LL',1,0),
(3000,195,'LG',1,0),
(3001,195,'MD',1,0),
(3002,195,'MA',1,0),
(3003,195,'ML',1,0),
(3004,195,'MU',1,0),
(3005,195,'NV',1,0),
(3006,195,'OU',1,0),
(3007,195,'PL',1,0),
(3008,195,'PO',1,0),
(3009,195,'SL',1,0),
(3010,195,'SC',1,0),
(3011,195,'SG',1,0),
(3012,195,'SV',1,0),
(3013,195,'SO',1,0),
(3014,195,'TA',1,0),
(3015,195,'TE',1,0),
(3016,195,'TO',1,0),
(3017,195,'VC',1,0),
(3018,195,'VD',1,0),
(3019,195,'VZ',1,0),
(3020,195,'ZM',1,0),
(3021,195,'ZR',1,0),
(3022,196,'CE',1,0),
(3023,196,'EA',1,0),
(3024,196,'NC',1,0),
(3025,196,'NO',1,0),
(3026,196,'NW',1,0),
(3027,196,'SA',1,0),
(3028,196,'SO',1,0),
(3029,196,'UV',1,0),
(3030,196,'WE',1,0),
(3031,197,'A',1,0),
(3032,197,'S',1,0),
(3033,197,'T',1,0),
(3034,199,'ANL',1,0),
(3035,199,'BAM',1,0),
(3036,199,'BRT',1,0),
(3037,199,'JZR',1,0),
(3038,199,'KRT',1,0),
(3039,199,'QDR',1,0),
(3040,199,'WDH',1,0),
(3041,199,'ANB',1,0),
(3042,199,'ANZ',1,0),
(3043,199,'ASH',1,0),
(3044,199,'BJA',1,0),
(3045,199,'GIS',1,0),
(3046,199,'GBG',1,0),
(3047,199,'GDA',1,0),
(3048,199,'GKU',1,0),
(3049,199,'JDA',1,0),
(3050,199,'JKU',1,0),
(3051,199,'JQL',1,0),
(3052,199,'KSL',1,0),
(3053,199,'NNL',1,0),
(3054,199,'SBG',1,0),
(3055,199,'SDA',1,0),
(3056,199,'SKU',1,0),
(3057,199,'SIS',1,0),
(3058,199,'SNR',1,0),
(3059,199,'WRB',1,0),
(3060,200,'BR',1,0),
(3061,200,'CM',1,0),
(3062,200,'CR',1,0),
(3063,200,'MA',1,0),
(3064,200,'NI',1,0),
(3065,200,'PA',1,0),
(3066,200,'PM',1,0),
(3067,200,'SA',1,0),
(3068,200,'SI',1,0),
(3069,200,'WA',1,0),
(3070,202,'H',1,0),
(3071,202,'L',1,0),
(3072,202,'M',1,0),
(3073,202,'S',1,0),
(3074,203,'K',1,0),
(3075,203,'W',1,0),
(3076,203,'X',1,0),
(3077,203,'I',1,0),
(3078,203,'N',1,0),
(3079,203,'Z',1,0),
(3080,203,'F',1,0),
(3081,203,'H',1,0),
(3082,203,'G',1,0),
(3083,203,'BD',1,0),
(3084,203,'T',1,0),
(3085,203,'E',1,0),
(3086,203,'M',1,0),
(3087,203,'D',1,0),
(3088,203,'AB',1,0),
(3089,203,'C',1,0),
(3090,203,'S',1,0),
(3091,203,'AC',1,0),
(3092,203,'Y',1,0),
(3093,203,'U',1,0),
(3094,203,'O',1,0),
(3095,204,'AG',1,0),
(3096,204,'AR',1,0),
(3097,204,'AI',1,0),
(3098,204,'BS',1,0),
(3099,204,'BL',1,0),
(3100,204,'BE',1,0),
(3101,204,'FR',1,0),
(3102,204,'GE',1,0),
(3103,204,'GL',1,0),
(3104,204,'GR',1,0),
(3105,204,'JU',1,0),
(3106,204,'LU',1,0),
(3107,204,'NE',1,0),
(3108,204,'NW',1,0),
(3109,204,'OW',1,0),
(3110,204,'SG',1,0),
(3111,204,'SH',1,0),
(3112,204,'SZ',1,0),
(3113,204,'SO',1,0),
(3114,204,'TG',1,0),
(3115,204,'TI',1,0),
(3116,204,'UR',1,0),
(3117,204,'VS',1,0),
(3118,204,'VD',1,0),
(3119,204,'ZG',1,0),
(3120,204,'ZH',1,0),
(3121,205,'HA',1,0),
(3122,205,'LA',1,0),
(3123,205,'QU',1,0),
(3124,205,'RQ',1,0),
(3125,205,'SU',1,0),
(3126,205,'DA',1,0),
(3127,205,'DZ',1,0),
(3128,205,'DI',1,0),
(3129,205,'HL',1,0),
(3130,205,'HM',1,0),
(3131,205,'HI',1,0),
(3132,205,'ID',1,0),
(3133,205,'RD',1,0),
(3134,205,'TA',1,0),
(3135,206,'CH',1,0),
(3136,206,'CI',1,0),
(3137,206,'HS',1,0),
(3138,206,'HL',1,0),
(3139,206,'IL',1,0),
(3140,206,'KH',1,0),
(3141,206,'KM',1,0),
(3142,206,'LC',1,0),
(3143,206,'ML',1,0),
(3144,206,'NT',1,0),
(3145,206,'PH',1,0),
(3146,206,'PT',1,0),
(3147,206,'TG',1,0),
(3148,206,'TA',1,0),
(3149,206,'TP',1,0),
(3150,206,'TT',1,0),
(3151,206,'TY',1,0),
(3152,206,'YL',1,0),
(3153,206,'CC',1,0),
(3154,206,'CL',1,0),
(3155,206,'HC',1,0),
(3156,206,'TH',1,0),
(3157,206,'TN',1,0),
(3158,206,'KC',1,0),
(3159,206,'TC',1,0),
(3160,207,'GB',1,0),
(3161,207,'KT',1,0),
(3162,207,'SU',1,0),
(3163,208,'AR',1,0),
(3164,208,'DS',1,0),
(3165,208,'DO',1,0),
(3166,208,'IR',1,0),
(3167,208,'KA',1,0),
(3168,208,'KI',1,0),
(3169,208,'KJ',1,0),
(3170,208,'LN',1,0),
(3171,208,'MY',1,0),
(3172,208,'MR',1,0),
(3173,208,'MB',1,0),
(3174,208,'MO',1,0),
(3175,208,'MT',1,0),
(3176,208,'MW',1,0),
(3177,208,'PN',1,0),
(3178,208,'PS',1,0),
(3179,208,'PW',1,0),
(3180,208,'RK',1,0),
(3181,208,'RV',1,0),
(3182,208,'SH',1,0),
(3183,208,'SI',1,0),
(3184,208,'TB',1,0),
(3185,208,'TN',1,0),
(3186,208,'ZC',1,0),
(3187,208,'ZN',1,0),
(3188,208,'ZU',1,0),
(3189,209,'Amnat Charoen',1,0),
(3190,209,'Ang Thong',1,0),
(3191,209,'Ayutthaya',1,0),
(3192,209,'Bangkok',1,0),
(3193,209,'Buriram',1,0),
(3194,209,'Chachoengsao',1,0),
(3195,209,'Chai Nat',1,0),
(3196,209,'Chaiyaphum',1,0),
(3197,209,'Chanthaburi',1,0),
(3198,209,'Chiang Mai',1,0),
(3199,209,'Chiang Rai',1,0),
(3200,209,'Chon Buri',1,0),
(3201,209,'Chumphon',1,0),
(3202,209,'Kalasin',1,0),
(3203,209,'Kamphaeng Phet',1,0),
(3204,209,'Kanchanaburi',1,0),
(3205,209,'Khon Kaen',1,0),
(3206,209,'Krabi',1,0),
(3207,209,'Lampang',1,0),
(3208,209,'Lamphun',1,0),
(3209,209,'Loei',1,0),
(3210,209,'Lop Buri',1,0),
(3211,209,'Mae Hong Son',1,0),
(3212,209,'Maha Sarakham',1,0),
(3213,209,'Mukdahan',1,0),
(3214,209,'Nakhon Nayok',1,0),
(3215,209,'Nakhon Pathom',1,0),
(3216,209,'Nakhon Phanom',1,0),
(3217,209,'Nakhon Ratchasima',1,0),
(3218,209,'Nakhon Sawan',1,0),
(3219,209,'Nakhon Si Thammarat',1,0),
(3220,209,'Nan',1,0),
(3221,209,'Narathiwat',1,0),
(3222,209,'Nong Bua Lamphu',1,0),
(3223,209,'Nong Khai',1,0),
(3224,209,'Nonthaburi',1,0),
(3225,209,'Pathum Thani',1,0),
(3226,209,'Pattani',1,0),
(3227,209,'Phangnga',1,0),
(3228,209,'Phatthalung',1,0),
(3229,209,'Phayao',1,0),
(3230,209,'Phetchabun',1,0),
(3231,209,'Phetchaburi',1,0),
(3232,209,'Phichit',1,0),
(3233,209,'Phitsanulok',1,0),
(3234,209,'Phrae',1,0),
(3235,209,'Phuket',1,0),
(3236,209,'Prachin Buri',1,0),
(3237,209,'Prachuap Khiri Khan',1,0),
(3238,209,'Ranong',1,0),
(3239,209,'Ratchaburi',1,0),
(3240,209,'Rayong',1,0),
(3241,209,'Roi Et',1,0),
(3242,209,'Sa Kaeo',1,0),
(3243,209,'Sakon Nakhon',1,0),
(3244,209,'Samut Prakan',1,0),
(3245,209,'Samut Sakhon',1,0),
(3246,209,'Samut Songkhram',1,0),
(3247,209,'Sara Buri',1,0),
(3248,209,'Satun',1,0),
(3249,209,'Sing Buri',1,0),
(3250,209,'Sisaket',1,0),
(3251,209,'Songkhla',1,0),
(3252,209,'Sukhothai',1,0),
(3253,209,'Suphan Buri',1,0),
(3254,209,'Surat Thani',1,0),
(3255,209,'Surin',1,0),
(3256,209,'Tak',1,0),
(3257,209,'Trang',1,0),
(3258,209,'Trat',1,0),
(3259,209,'Ubon Ratchathani',1,0),
(3260,209,'Udon Thani',1,0),
(3261,209,'Uthai Thani',1,0),
(3262,209,'Uttaradit',1,0),
(3263,209,'Yala',1,0),
(3264,209,'Yasothon',1,0),
(3265,210,'K',1,0),
(3266,210,'P',1,0),
(3267,210,'S',1,0),
(3268,210,'C',1,0),
(3269,210,'M',1,0),
(3270,211,'A',1,0),
(3271,211,'F',1,0),
(3272,211,'N',1,0),
(3273,212,'H',1,0),
(3274,212,'T',1,0),
(3275,212,'V',1,0),
(3276,213,'CT',1,0),
(3277,213,'DM',1,0),
(3278,213,'MR',1,0),
(3279,213,'PD',1,0),
(3280,213,'PT',1,0),
(3281,213,'SG',1,0),
(3282,213,'SL',1,0),
(3283,213,'SI',1,0),
(3284,213,'TP',1,0),
(3285,213,'PS',1,0),
(3286,213,'SF',1,0),
(3287,213,'AR',1,0),
(3288,213,'PF',1,0),
(3289,213,'CH',1,0),
(3290,213,'TO',1,0),
(3291,214,'AR',1,0),
(3292,214,'BJ',1,0),
(3293,214,'BA',1,0),
(3294,214,'BI',1,0),
(3295,214,'GB',1,0),
(3296,214,'GF',1,0),
(3297,214,'JE',1,0),
(3298,214,'KR',1,0),
(3299,214,'KS',1,0),
(3300,214,'KB',1,0),
(3301,214,'KF',1,0),
(3302,214,'MH',1,0),
(3303,214,'MN',1,0),
(3304,214,'ME',1,0),
(3305,214,'MO',1,0),
(3306,214,'NA',1,0),
(3307,214,'SF',1,0),
(3308,214,'SD',1,0),
(3309,214,'SL',1,0),
(3310,214,'SO',1,0),
(3311,214,'TA',1,0),
(3312,214,'TO',1,0),
(3313,214,'TU',1,0),
(3314,214,'ZA',1,0),
(3315,215,'ADA',1,0),
(3316,215,'ADI',1,0),
(3317,215,'AFY',1,0),
(3318,215,'AGR',1,0),
(3319,215,'AKS',1,0),
(3320,215,'AMA',1,0),
(3321,215,'ANK',1,0),
(3322,215,'ANT',1,0),
(3323,215,'ARD',1,0),
(3324,215,'ART',1,0),
(3325,215,'AYI',1,0),
(3326,215,'BAL',1,0),
(3327,215,'BAR',1,0),
(3328,215,'BAT',1,0),
(3329,215,'BAY',1,0),
(3330,215,'BIL',1,0),
(3331,215,'BIN',1,0),
(3332,215,'BIT',1,0),
(3333,215,'BOL',1,0),
(3334,215,'BRD',1,0),
(3335,215,'BRS',1,0),
(3336,215,'CKL',1,0),
(3337,215,'CKR',1,0),
(3338,215,'COR',1,0),
(3339,215,'DEN',1,0),
(3340,215,'DIY',1,0),
(3341,215,'DUZ',1,0),
(3342,215,'EDI',1,0),
(3343,215,'ELA',1,0),
(3344,215,'EZC',1,0),
(3345,215,'EZR',1,0),
(3346,215,'ESK',1,0),
(3347,215,'GAZ',1,0),
(3348,215,'GIR',1,0),
(3349,215,'GMS',1,0),
(3350,215,'HKR',1,0),
(3351,215,'HTY',1,0),
(3352,215,'IGD',1,0),
(3353,215,'ISP',1,0),
(3354,215,'IST',1,0),
(3355,215,'IZM',1,0),
(3356,215,'KAH',1,0),
(3357,215,'KRB',1,0),
(3358,215,'KRM',1,0),
(3359,215,'KRS',1,0),
(3360,215,'KAS',1,0),
(3361,215,'KAY',1,0),
(3362,215,'KLS',1,0),
(3363,215,'KRK',1,0),
(3364,215,'KLR',1,0),
(3365,215,'KRH',1,0),
(3366,215,'KOC',1,0),
(3367,215,'KON',1,0),
(3368,215,'KUT',1,0),
(3369,215,'MAL',1,0),
(3370,215,'MAN',1,0),
(3371,215,'MAR',1,0),
(3372,215,'MER',1,0),
(3373,215,'MUG',1,0),
(3374,215,'MUS',1,0),
(3375,215,'NEV',1,0),
(3376,215,'NIG',1,0),
(3377,215,'ORD',1,0),
(3378,215,'OSM',1,0),
(3379,215,'RIZ',1,0),
(3380,215,'SAK',1,0),
(3381,215,'SAM',1,0),
(3382,215,'SAN',1,0),
(3383,215,'SII',1,0),
(3384,215,'SIN',1,0),
(3385,215,'SIR',1,0),
(3386,215,'SIV',1,0),
(3387,215,'TEL',1,0),
(3388,215,'TOK',1,0),
(3389,215,'TRA',1,0),
(3390,215,'TUN',1,0),
(3391,215,'USK',1,0),
(3392,215,'VAN',1,0),
(3393,215,'YAL',1,0),
(3394,215,'YOZ',1,0),
(3395,215,'ZON',1,0),
(3396,216,'A',1,0),
(3397,216,'B',1,0),
(3398,216,'D',1,0),
(3399,216,'L',1,0),
(3400,216,'M',1,0),
(3401,217,'AC',1,0),
(3402,217,'DC',1,0),
(3403,217,'FC',1,0),
(3404,217,'LW',1,0),
(3405,217,'RC',1,0),
(3406,217,'PN',1,0),
(3407,217,'SL',1,0),
(3408,217,'GT',1,0),
(3409,217,'SC',1,0),
(3410,217,'EC',1,0),
(3411,217,'MC',1,0),
(3412,217,'NC',1,0),
(3413,217,'PR',1,0),
(3414,217,'WC',1,0),
(3415,218,'NMG',1,0),
(3416,218,'NLK',1,0),
(3417,218,'NTO',1,0),
(3418,218,'FUN',1,0),
(3419,218,'NME',1,0),
(3420,218,'NUI',1,0),
(3421,218,'NFT',1,0),
(3422,218,'NLL',1,0),
(3423,218,'VAI',1,0),
(3424,219,'KAL',1,0),
(3425,219,'KMP',1,0),
(3426,219,'KAY',1,0),
(3427,219,'KIB',1,0),
(3428,219,'LUW',1,0),
(3429,219,'MAS',1,0),
(3430,219,'MPI',1,0),
(3431,219,'MUB',1,0),
(3432,219,'MUK',1,0),
(3433,219,'NKS',1,0),
(3434,219,'RAK',1,0),
(3435,219,'SEM',1,0),
(3436,219,'WAK',1,0),
(3437,219,'BUG',1,0),
(3438,219,'BUS',1,0),
(3439,219,'IGA',1,0),
(3440,219,'JIN',1,0),
(3441,219,'KAB',1,0),
(3442,219,'KML',1,0),
(3443,219,'KPC',1,0),
(3444,219,'KTK',1,0),
(3445,219,'KUM',1,0),
(3446,219,'MAY',1,0),
(3447,219,'MBA',1,0),
(3448,219,'PAL',1,0),
(3449,219,'SIR',1,0),
(3450,219,'SOR',1,0),
(3451,219,'TOR',1,0),
(3452,219,'ADJ',1,0),
(3453,219,'APC',1,0),
(3454,219,'ARU',1,0),
(3455,219,'GUL',1,0),
(3456,219,'KIT',1,0),
(3457,219,'KOT',1,0),
(3458,219,'LIR',1,0),
(3459,219,'MRT',1,0),
(3460,219,'MOY',1,0),
(3461,219,'NAK',1,0),
(3462,219,'NEB',1,0),
(3463,219,'PAD',1,0),
(3464,219,'YUM',1,0),
(3465,219,'BUN',1,0),
(3466,219,'BSH',1,0),
(3467,219,'HOI',1,0),
(3468,219,'KBL',1,0),
(3469,219,'KAR',1,0),
(3470,219,'KAM',1,0),
(3471,219,'KAN',1,0),
(3472,219,'KAS',1,0),
(3473,219,'KBA',1,0),
(3474,219,'KIS',1,0),
(3475,219,'KYE',1,0),
(3476,219,'MSN',1,0),
(3477,219,'MBR',1,0),
(3478,219,'NTU',1,0),
(3479,219,'RUK',1,0),
(3480,220,'CK',1,0),
(3481,220,'CH',1,0),
(3482,220,'CV',1,0),
(3483,220,'CR',1,0),
(3484,220,'DN',1,0),
(3485,220,'DO',1,0),
(3486,220,'IV',1,0),
(3487,220,'KL',1,0),
(3488,220,'KM',1,0),
(3489,220,'KR',1,0),
(3490,220,'KV',1,0),
(3491,220,'KS',1,0),
(3492,220,'LU',1,0),
(3493,220,'LV',1,0),
(3494,220,'MY',1,0),
(3495,220,'OD',1,0),
(3496,220,'PO',1,0),
(3497,220,'RI',1,0),
(3498,220,'SE',1,0),
(3499,220,'SU',1,0),
(3500,220,'TE',1,0),
(3501,220,'VI',1,0),
(3502,220,'VO',1,0),
(3503,220,'ZK',1,0),
(3504,220,'ZA',1,0),
(3505,220,'ZH',1,0),
(3506,221,'AZ',1,0),
(3507,221,'AJ',1,0),
(3508,221,'FU',1,0),
(3509,221,'SH',1,0),
(3510,221,'DU',1,0),
(3511,221,'RK',1,0),
(3512,221,'UQ',1,0),
(3513,222,'ABN',1,0),
(3514,222,'ABNS',1,0),
(3515,222,'ANG',1,0),
(3516,222,'AGS',1,0),
(3517,222,'ARY',1,0),
(3518,222,'BEDS',1,0),
(3519,222,'BERKS',1,0),
(3520,222,'BLA',1,0),
(3521,222,'BRI',1,0),
(3522,222,'BSTL',1,0),
(3523,222,'BUCKS',1,0),
(3524,222,'CAE',1,0),
(3525,222,'CAMBS',1,0),
(3526,222,'CDF',1,0),
(3527,222,'CARM',1,0),
(3528,222,'CDGN',1,0),
(3529,222,'CHES',1,0),
(3530,222,'CLACK',1,0),
(3531,222,'CON',1,0),
(3532,222,'CORN',1,0),
(3533,222,'DNBG',1,0),
(3534,222,'DERBY',1,0),
(3535,222,'DVN',1,0),
(3536,222,'DOR',1,0),
(3537,222,'DGL',1,0),
(3538,222,'DUND',1,0),
(3539,222,'DHM',1,0),
(3540,222,'ARYE',1,0),
(3541,222,'DUNBE',1,0),
(3542,222,'LOTE',1,0),
(3543,222,'RENE',1,0),
(3544,222,'ERYS',1,0),
(3545,222,'SXE',1,0),
(3546,222,'EDIN',1,0),
(3547,222,'ESX',1,0),
(3548,222,'FALK',1,0),
(3549,222,'FFE',1,0),
(3550,222,'FLINT',1,0),
(3551,222,'GLAS',1,0),
(3552,222,'GLOS',1,0),
(3553,222,'LDN',1,0),
(3554,222,'MCH',1,0),
(3555,222,'GDD',1,0),
(3556,222,'HANTS',1,0),
(3557,222,'HWR',1,0),
(3558,222,'HERTS',1,0),
(3559,222,'HLD',1,0),
(3560,222,'IVER',1,0),
(3561,222,'IOW',1,0),
(3562,222,'KNT',1,0),
(3563,222,'LANCS',1,0),
(3564,222,'LEICS',1,0),
(3565,222,'LINCS',1,0),
(3566,222,'MSY',1,0),
(3567,222,'MERT',1,0),
(3568,222,'MLOT',1,0),
(3569,222,'MMOUTH',1,0),
(3570,222,'MORAY',1,0),
(3571,222,'NPRTAL',1,0),
(3572,222,'NEWPT',1,0),
(3573,222,'NOR',1,0),
(3574,222,'ARYN',1,0),
(3575,222,'LANN',1,0),
(3576,222,'YSN',1,0),
(3577,222,'NHM',1,0),
(3578,222,'NLD',1,0),
(3579,222,'NOT',1,0),
(3580,222,'ORK',1,0),
(3581,222,'OFE',1,0),
(3582,222,'PEM',1,0),
(3583,222,'PERTH',1,0),
(3584,222,'PWS',1,0),
(3585,222,'REN',1,0),
(3586,222,'RHON',1,0),
(3587,222,'RUT',1,0),
(3588,222,'BOR',1,0),
(3589,222,'SHET',1,0),
(3590,222,'SPE',1,0),
(3591,222,'SOM',1,0),
(3592,222,'ARYS',1,0),
(3593,222,'LANS',1,0),
(3594,222,'YSS',1,0),
(3595,222,'SFD',1,0),
(3596,222,'STIR',1,0),
(3597,222,'SFK',1,0),
(3598,222,'SRY',1,0),
(3599,222,'SWAN',1,0),
(3600,222,'TORF',1,0),
(3601,222,'TWR',1,0),
(3602,222,'VGLAM',1,0),
(3603,222,'WARKS',1,0),
(3604,222,'WDUN',1,0),
(3605,222,'WLOT',1,0),
(3606,222,'WMD',1,0),
(3607,222,'SXW',1,0),
(3608,222,'YSW',1,0),
(3609,222,'WIL',1,0),
(3610,222,'WLT',1,0),
(3611,222,'WORCS',1,0),
(3612,222,'WRX',1,0),
(3613,223,'AL',1,0),
(3614,223,'AK',1,0),
(3615,223,'AS',1,0),
(3616,223,'AZ',1,0),
(3617,223,'AR',1,0),
(3618,223,'AF',1,0),
(3619,223,'AA',1,0),
(3620,223,'AC',1,0),
(3621,223,'AE',1,0),
(3622,223,'AM',1,0),
(3623,223,'AP',1,0),
(3624,223,'CA',1,0),
(3625,223,'CO',1,0),
(3626,223,'CT',1,0),
(3627,223,'DE',1,0),
(3628,223,'DC',1,0),
(3629,223,'FM',1,0),
(3630,223,'FL',1,0),
(3631,223,'GA',1,0),
(3632,223,'GU',1,0),
(3633,223,'HI',1,0),
(3634,223,'ID',1,0),
(3635,223,'IL',1,0),
(3636,223,'IN',1,0),
(3637,223,'IA',1,0),
(3638,223,'KS',1,0),
(3639,223,'KY',1,0),
(3640,223,'LA',1,0),
(3641,223,'ME',1,0),
(3642,223,'MH',1,0),
(3643,223,'MD',1,0),
(3644,223,'MA',1,0),
(3645,223,'MI',1,0),
(3646,223,'MN',1,0),
(3647,223,'MS',1,0),
(3648,223,'MO',1,0),
(3649,223,'MT',1,0),
(3650,223,'NE',1,0),
(3651,223,'NV',1,0),
(3652,223,'NH',1,0),
(3653,223,'NJ',1,0),
(3654,223,'NM',1,0),
(3655,223,'NY',1,0),
(3656,223,'NC',1,0),
(3657,223,'ND',1,0),
(3658,223,'MP',1,0),
(3659,223,'OH',1,0),
(3660,223,'OK',1,0),
(3661,223,'OR',1,0),
(3662,223,'PW',1,0),
(3663,223,'PA',1,0),
(3664,223,'PR',1,0),
(3665,223,'RI',1,0),
(3666,223,'SC',1,0),
(3667,223,'SD',1,0),
(3668,223,'TN',1,0),
(3669,223,'TX',1,0),
(3670,223,'UT',1,0),
(3671,223,'VT',1,0),
(3672,223,'VI',1,0),
(3673,223,'VA',1,0),
(3674,223,'WA',1,0),
(3675,223,'WV',1,0),
(3676,223,'WI',1,0),
(3677,223,'WY',1,0),
(3678,224,'BI',1,0),
(3679,224,'HI',1,0),
(3680,224,'JI',1,0),
(3681,224,'JA',1,0),
(3682,224,'KR',1,0),
(3683,224,'MA',1,0),
(3684,224,'NI',1,0),
(3685,224,'PA',1,0),
(3686,224,'WI',1,0),
(3687,225,'AR',1,0),
(3688,225,'CA',1,0),
(3689,225,'CL',1,0),
(3690,225,'CO',1,0),
(3691,225,'DU',1,0),
(3692,225,'FS',1,0),
(3693,225,'FA',1,0),
(3694,225,'LA',1,0),
(3695,225,'MA',1,0),
(3696,225,'MO',1,0),
(3697,225,'PA',1,0),
(3698,225,'RN',1,0),
(3699,225,'RV',1,0),
(3700,225,'RO',1,0),
(3701,225,'SL',1,0),
(3702,225,'SJ',1,0),
(3703,225,'SO',1,0),
(3704,225,'TA',1,0),
(3705,225,'TT',1,0),
(3706,226,'AN',1,0),
(3707,226,'BU',1,0),
(3708,226,'FA',1,0),
(3709,226,'JI',1,0),
(3710,226,'NG',1,0),
(3711,226,'NW',1,0),
(3712,226,'QA',1,0),
(3713,226,'QR',1,0),
(3714,226,'SA',1,0),
(3715,226,'SI',1,0),
(3716,226,'SU',1,0),
(3717,226,'TK',1,0),
(3718,226,'TO',1,0),
(3719,226,'XO',1,0),
(3720,227,'MA',1,0),
(3721,227,'PE',1,0),
(3722,227,'SA',1,0),
(3723,227,'SH',1,0),
(3724,227,'TA',1,0),
(3725,227,'TO',1,0),
(3726,229,'AM',1,0),
(3727,229,'AN',1,0),
(3728,229,'AP',1,0),
(3729,229,'AR',1,0),
(3730,229,'BA',1,0),
(3731,229,'BO',1,0),
(3732,229,'CA',1,0),
(3733,229,'CO',1,0),
(3734,229,'DA',1,0),
(3735,229,'DF',1,0),
(3736,229,'DI',1,0),
(3737,229,'FA',1,0),
(3738,229,'GU',1,0),
(3739,229,'LA',1,0),
(3740,229,'ME',1,0),
(3741,229,'MI',1,0),
(3742,229,'MO',1,0),
(3743,229,'NE',1,0),
(3744,229,'PO',1,0),
(3745,229,'SU',1,0),
(3746,229,'TA',1,0),
(3747,229,'TR',1,0),
(3748,229,'VA',1,0),
(3749,229,'YA',1,0),
(3750,229,'ZU',1,0),
(3751,230,'AG',1,0),
(3752,230,'BG',1,0),
(3753,230,'BK',1,0),
(3754,230,'BL',1,0),
(3755,230,'BC',1,0),
(3756,230,'BR',1,0),
(3757,230,'BN',1,0),
(3758,230,'BH',1,0),
(3759,230,'BU',1,0),
(3760,230,'BP',1,0),
(3761,230,'BT',1,0),
(3762,230,'CM',1,0),
(3763,230,'CT',1,0),
(3764,230,'CB',1,0),
(3765,230,'DL',1,0),
(3766,230,'DG',1,0),
(3767,230,'DN',1,0),
(3768,230,'DB',1,0),
(3769,230,'DI',1,0),
(3770,230,'DT',1,0),
(3771,230,'GL',1,0),
(3772,230,'HG',1,0),
(3773,230,'HD',1,0),
(3774,230,'HP',1,0),
(3775,230,'HM',1,0),
(3776,230,'HI',1,0),
(3777,230,'HT',1,0),
(3778,230,'HH',1,0),
(3779,230,'HB',1,0),
(3780,230,'HC',1,0),
(3781,230,'HU',1,0),
(3782,230,'HY',1,0),
(3783,232,'C',1,0),
(3784,232,'J',1,0),
(3785,232,'T',1,0),
(3786,233,'A',1,0),
(3787,233,'S',1,0),
(3788,233,'W',1,0),
(3789,235,'AB',1,0),
(3790,235,'AD',1,0),
(3791,235,'AM',1,0),
(3792,235,'BA',1,0),
(3793,235,'DA',1,0),
(3794,235,'DH',1,0),
(3795,235,'HD',1,0),
(3796,235,'HJ',1,0),
(3797,235,'HU',1,0),
(3798,235,'IB',1,0),
(3799,235,'JA',1,0),
(3800,235,'LA',1,0),
(3801,235,'MA',1,0),
(3802,235,'MR',1,0),
(3803,235,'MW',1,0),
(3804,235,'SD',1,0),
(3805,235,'SN',1,0),
(3806,235,'SH',1,0),
(3807,235,'TA',1,0),
(3808,236,'AND',1,0),
(3809,236,'BAR',1,0),
(3810,236,'BER',1,0),
(3811,236,'BIP',1,0),
(3812,49,'BC',1,0),
(3813,49,'BN',1,0),
(3814,49,'EQ',1,0),
(3815,49,'KA',1,0),
(3816,49,'KE',1,0),
(3817,49,'KN',1,0),
(3818,49,'KW',1,0),
(3819,49,'MA',1,0),
(3820,49,'NK',1,0),
(3821,49,'OR',1,0),
(3822,49,'SK',1,0),
(3823,238,'CE',1,0),
(3824,238,'CB',1,0),
(3825,238,'EA',1,0),
(3826,238,'LP',1,0),
(3827,238,'LK',1,0),
(3828,238,'NO',1,0),
(3829,238,'NW',1,0),
(3830,238,'SO',1,0),
(3831,238,'WE',1,0),
(3832,239,'BU',1,0),
(3833,239,'HA',1,0),
(3834,239,'ML',1,0),
(3835,239,'MC',1,0),
(3836,239,'ME',1,0),
(3837,239,'MW',1,0),
(3838,239,'MV',1,0),
(3839,239,'MN',1,0),
(3840,239,'MS',1,0),
(3841,239,'MD',1,0),
(3861,105,'CB',1,0),
(3862,105,'CI',1,0),
(3863,105,'CE',1,0),
(3864,105,'CT',1,0),
(3865,105,'CZ',1,0),
(3866,105,'CH',1,0),
(3867,105,'CO',1,0),
(3868,105,'CS',1,0),
(3869,105,'CR',1,0),
(3870,105,'KR',1,0),
(3871,105,'CN',1,0),
(3872,105,'EN',1,0),
(3873,105,'FE',1,0),
(3874,105,'FI',1,0),
(3875,105,'FG',1,0),
(3876,105,'FC',1,0),
(3877,105,'FR',1,0),
(3878,105,'GE',1,0),
(3879,105,'GO',1,0),
(3880,105,'GR',1,0),
(3881,105,'IM',1,0),
(3882,105,'IS',1,0),
(3883,105,'AQ',1,0),
(3884,105,'SP',1,0),
(3885,105,'LT',1,0),
(3886,105,'LE',1,0),
(3887,105,'LC',1,0),
(3888,105,'LI',1,0),
(3889,105,'LO',1,0),
(3890,105,'LU',1,0),
(3891,105,'MC',1,0),
(3892,105,'MN',1,0),
(3893,105,'MS',1,0),
(3894,105,'MT',1,0),
(3895,105,'VS',1,0),
(3896,105,'ME',1,0),
(3897,105,'MI',1,0),
(3898,105,'MO',1,0),
(3899,105,'NA',1,0),
(3900,105,'NO',1,0),
(3901,105,'NU',1,0),
(3902,105,'OG',1,0),
(3903,105,'OT',1,0),
(3904,105,'OR',1,0),
(3905,105,'PD',1,0),
(3906,105,'PA',1,0),
(3907,105,'PR',1,0),
(3908,105,'PV',1,0),
(3909,105,'PG',1,0),
(3910,105,'PU',1,0),
(3911,105,'PE',1,0),
(3912,105,'PC',1,0),
(3913,105,'PI',1,0),
(3914,105,'PT',1,0),
(3915,105,'PN',1,0),
(3916,105,'PZ',1,0),
(3917,105,'PO',1,0),
(3918,105,'RG',1,0),
(3919,105,'RA',1,0),
(3920,105,'RC',1,0),
(3921,105,'RE',1,0),
(3922,105,'RI',1,0),
(3923,105,'RN',1,0),
(3924,105,'RM',1,0),
(3925,105,'RO',1,0),
(3926,105,'SA',1,0),
(3927,105,'SS',1,0),
(3928,105,'SV',1,0),
(3929,105,'SI',1,0),
(3930,105,'SR',1,0),
(3931,105,'SO',1,0),
(3932,105,'TA',1,0),
(3933,105,'TE',1,0),
(3934,105,'TR',1,0),
(3935,105,'TO',1,0),
(3936,105,'TP',1,0),
(3937,105,'TN',1,0),
(3938,105,'TV',1,0),
(3939,105,'TS',1,0),
(3940,105,'UD',1,0),
(3941,105,'VA',1,0),
(3942,105,'VE',1,0),
(3943,105,'VB',1,0),
(3944,105,'VC',1,0),
(3945,105,'VR',1,0),
(3946,105,'VV',1,0),
(3947,105,'VI',1,0),
(3948,105,'VT',1,0),
(3949,240,'',1,0),
(3950,240,'',1,0),
(3951,240,'',1,0),
(3952,240,'',1,0),
(3953,240,'',1,0),
(3954,240,'',1,0),
(3955,190,'MR',1,0),
(3956,190,'DR',1,0),
(3957,190,'CR',1,0),
(3958,190,'SV',1,0),
(3959,190,'CV',1,0),
(3960,190,'LS',1,0),
(3961,190,'SS',1,0),
(3962,190,'LC',1,0),
(3963,190,'CS',1,0),
(3964,190,'UC',1,0),
(3965,190,'GZ',1,0),
(3966,190,'CK',1,0),
(3967,188,'SG',1,0),
(3968,168,'MTM',1,0),
(3969,236,'BDV',1,0),
(3970,236,'CET',1,0),
(3971,236,'DNG',1,0),
(3972,236,'GSN',1,0),
(3973,236,'HGN',1,0),
(3974,236,'KLN',1,0),
(3975,236,'KOR',1,0),
(3976,236,'MKC',1,0),
(3977,236,'NKS',1,0),
(3978,236,'PTN',1,0),
(3979,236,'PLV',1,0),
(3980,236,'PVL',1,0),
(3981,236,'PZN',1,0),
(3982,236,'PGC',1,0),
(3983,236,'ROZ',1,0),
(3984,236,'SNK',1,0),
(3985,236,'TVT',1,0),
(3986,236,'TZI',1,0),
(3987,236,'ULN',1,0),
(3988,236,'ZBK',1,0),
(3989,241,'VDN',1,0),
(3990,241,'BGD',1,0),
(3991,241,'SWS',1,0),
(3992,241,'SES',1,0),
(3993,241,'KMT',1,0),
(3994,242,'FRZ',1,0),
(3995,242,'GKV',1,0),
(3996,242,'GLN',1,0),
(3997,242,'MTR',1,0),
(3998,242,'PJA',1,0),
(3999,242,'PRN',1,0),
(4000,242,'PRZ',1,0),
(4001,126,'ESN',1,0),
(4002,126,'NTN',1,0),
(4003,126,'PLG',1,0),
(4004,126,'POL',1,0),
(4005,126,'SKP',1,0),
(4006,126,'SEN',1,0),
(4007,126,'SWN',1,0),
(4008,126,'VDR',1,0);


DROP TABLE IF EXISTS `ac_zone_descriptions`;
CREATE TABLE `ac_zone_descriptions` (
  `zone_id` int(11) NOT NULL,
  `language_id` int(11) NOT NULL,
  `name` varchar(128) COLLATE utf8_general_ci NOT NULL COMMENT 'translatable',
  PRIMARY KEY (`zone_id`,`language_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;


INSERT INTO `ac_zone_descriptions`
VALUES (1,1,'Badakhshan'),
(2,1,'Badghis'),
(3,1,'Baghlan'),
(4,1,'Balkh'),
(5,1,'Bamian'),
(6,1,'Farah'),
(7,1,'Faryab'),
(8,1,'Ghazni'),
(9,1,'Ghowr'),
(10,1,'Helmand'),
(11,1,'Herat'),
(12,1,'Jowzjan'),
(13,1,'Kabul'),
(14,1,'Kandahar'),
(15,1,'Kapisa'),
(16,1,'Khost'),
(17,1,'Konar'),
(18,1,'Kondoz'),
(19,1,'Laghman'),
(20,1,'Lowgar'),
(21,1,'Nangrahar'),
(22,1,'Nimruz'),
(23,1,'Nurestan'),
(24,1,'Oruzgan'),
(25,1,'Paktia'),
(26,1,'Paktika'),
(27,1,'Parwan'),
(28,1,'Samangan'),
(29,1,'Sar-e Pol'),
(30,1,'Takhar'),
(31,1,'Wardak'),
(32,1,'Zabol'),
(33,1,'Berat'),
(34,1,'Bulqize'),
(35,1,'Delvine'),
(36,1,'Devoll'),
(37,1,'Diber'),
(38,1,'Durres'),
(39,1,'Elbasan'),
(40,1,'Kolonje'),
(41,1,'Fier'),
(42,1,'Gjirokaster'),
(43,1,'Gramsh'),
(44,1,'Has'),
(45,1,'Kavaje'),
(46,1,'Kurbin'),
(47,1,'Kucove'),
(48,1,'Korce'),
(49,1,'Kruje'),
(50,1,'Kukes'),
(51,1,'Librazhd'),
(52,1,'Lezhe'),
(53,1,'Lushnje'),
(54,1,'Malesi e Madhe'),
(55,1,'Mallakaster'),
(56,1,'Mat'),
(57,1,'Mirdite'),
(58,1,'Peqin'),
(59,1,'Permet'),
(60,1,'Pogradec'),
(61,1,'Puke'),
(62,1,'Shkoder'),
(63,1,'Skrapar'),
(64,1,'Sarande'),
(65,1,'Tepelene'),
(66,1,'Tropoje'),
(67,1,'Tirane'),
(68,1,'Vlore'),
(69,1,'Adrar'),
(70,1,'Ain Defla'),
(71,1,'Ain Temouchent'),
(72,1,'Alger'),
(73,1,'Annaba'),
(74,1,'Batna'),
(75,1,'Bechar'),
(76,1,'Bejaia'),
(77,1,'Biskra'),
(78,1,'Blida'),
(79,1,'Bordj Bou Arreridj'),
(80,1,'Bouira'),
(81,1,'Boumerdes'),
(82,1,'Chlef'),
(83,1,'Constantine'),
(84,1,'Djelfa'),
(85,1,'El Bayadh'),
(86,1,'El Oued'),
(87,1,'El Tarf'),
(88,1,'Ghardaia'),
(89,1,'Guelma'),
(90,1,'Illizi'),
(91,1,'Jijel'),
(92,1,'Khenchela'),
(93,1,'Laghouat'),
(94,1,'Muaskar'),
(95,1,'Medea'),
(96,1,'Mila'),
(97,1,'Mostaganem'),
(98,1,'M\'Sila'),
(99,1,'Naama'),
(100,1,'Oran'),
(101,1,'Ouargla'),
(102,1,'Oum el-Bouaghi'),
(103,1,'Relizane'),
(104,1,'Saida'),
(105,1,'Setif'),
(106,1,'Sidi Bel Abbes'),
(107,1,'Skikda'),
(108,1,'Souk Ahras'),
(109,1,'Tamanghasset'),
(110,1,'Tebessa'),
(111,1,'Tiaret'),
(112,1,'Tindouf'),
(113,1,'Tipaza'),
(114,1,'Tissemsilt'),
(115,1,'Tizi Ouzou'),
(116,1,'Tlemcen'),
(117,1,'Eastern'),
(118,1,'Manu\'a'),
(119,1,'Rose Island'),
(120,1,'Swains Island'),
(121,1,'Western'),
(122,1,'Andorra la Vella'),
(123,1,'Canillo'),
(124,1,'Encamp'),
(125,1,'Escaldes-Engordany'),
(126,1,'La Massana'),
(127,1,'Ordino'),
(128,1,'Sant Julia de Loria'),
(129,1,'Bengo'),
(130,1,'Benguela'),
(131,1,'Bie'),
(132,1,'Cabinda'),
(133,1,'Cuando-Cubango'),
(134,1,'Cuanza Norte'),
(135,1,'Cuanza Sul'),
(136,1,'Cunene'),
(137,1,'Huambo'),
(138,1,'Huila'),
(139,1,'Luanda'),
(140,1,'Lunda Norte'),
(141,1,'Lunda Sul'),
(142,1,'Malange'),
(143,1,'Moxico'),
(144,1,'Namibe'),
(145,1,'Uige'),
(146,1,'Zaire'),
(147,1,'Saint George'),
(148,1,'Saint John'),
(149,1,'Saint Mary'),
(150,1,'Saint Paul'),
(151,1,'Saint Peter'),
(152,1,'Saint Philip'),
(153,1,'Barbuda'),
(154,1,'Redonda'),
(155,1,'Antartida e Islas del Atlantico'),
(156,1,'Buenos Aires'),
(157,1,'Catamarca'),
(158,1,'Chaco'),
(159,1,'Chubut'),
(160,1,'Cordoba'),
(161,1,'Corrientes'),
(162,1,'Distrito Federal'),
(163,1,'Entre Rios'),
(164,1,'Formosa'),
(165,1,'Jujuy'),
(166,1,'La Pampa'),
(167,1,'La Rioja'),
(168,1,'Mendoza'),
(169,1,'Misiones'),
(170,1,'Neuquen'),
(171,1,'Rio Negro'),
(172,1,'Salta'),
(173,1,'San Juan'),
(174,1,'San Luis'),
(175,1,'Santa Cruz'),
(176,1,'Santa Fe'),
(177,1,'Santiago del Estero'),
(178,1,'Tierra del Fuego'),
(179,1,'Tucuman'),
(180,1,'Aragatsotn'),
(181,1,'Ararat'),
(182,1,'Armavir'),
(183,1,'Geghark\'unik\''),
(184,1,'Kotayk\''),
(185,1,'Lorri'),
(186,1,'Shirak'),
(187,1,'Syunik\''),
(188,1,'Tavush'),
(189,1,'Vayots\' Dzor'),
(190,1,'Yerevan'),
(191,1,'Australian Capital Territory'),
(192,1,'New South Wales'),
(193,1,'Northern Territory'),
(194,1,'Queensland'),
(195,1,'South Australia'),
(196,1,'Tasmania'),
(197,1,'Victoria'),
(198,1,'Western Australia'),
(199,1,'Burgenland'),
(200,1,'Kärnten'),
(201,1,'Nieder&ouml;sterreich'),
(202,1,'Ober&ouml;sterreich'),
(203,1,'Salzburg'),
(204,1,'Steiermark'),
(205,1,'Tirol'),
(206,1,'Vorarlberg'),
(207,1,'Wien'),
(208,1,'Ali Bayramli'),
(209,1,'Abseron'),
(210,1,'AgcabAdi'),
(211,1,'Agdam'),
(212,1,'Agdas'),
(213,1,'Agstafa'),
(214,1,'Agsu'),
(215,1,'Astara'),
(216,1,'Baki'),
(217,1,'BabAk'),
(218,1,'BalakAn'),
(219,1,'BArdA'),
(220,1,'Beylaqan'),
(221,1,'Bilasuvar'),
(222,1,'Cabrayil'),
(223,1,'Calilabab'),
(224,1,'Culfa'),
(225,1,'Daskasan'),
(226,1,'Davaci'),
(227,1,'Fuzuli'),
(228,1,'Ganca'),
(229,1,'Gadabay'),
(230,1,'Goranboy'),
(231,1,'Goycay'),
(232,1,'Haciqabul'),
(233,1,'Imisli'),
(234,1,'Ismayilli'),
(235,1,'Kalbacar'),
(236,1,'Kurdamir'),
(237,1,'Lankaran'),
(238,1,'Lacin'),
(239,1,'Lankaran'),
(240,1,'Lerik'),
(241,1,'Masalli'),
(242,1,'Mingacevir'),
(243,1,'Naftalan'),
(244,1,'Neftcala'),
(245,1,'Oguz'),
(246,1,'Ordubad'),
(247,1,'Qabala'),
(248,1,'Qax'),
(249,1,'Qazax'),
(250,1,'Qobustan'),
(251,1,'Quba'),
(252,1,'Qubadli'),
(253,1,'Qusar'),
(254,1,'Saki'),
(255,1,'Saatli'),
(256,1,'Sabirabad'),
(257,1,'Sadarak'),
(258,1,'Sahbuz'),
(259,1,'Saki'),
(260,1,'Salyan'),
(261,1,'Sumqayit'),
(262,1,'Samaxi'),
(263,1,'Samkir'),
(264,1,'Samux'),
(265,1,'Sarur'),
(266,1,'Siyazan'),
(267,1,'Susa'),
(268,1,'Susa'),
(269,1,'Tartar'),
(270,1,'Tovuz'),
(271,1,'Ucar'),
(272,1,'Xankandi'),
(273,1,'Xacmaz'),
(274,1,'Xanlar'),
(275,1,'Xizi'),
(276,1,'Xocali'),
(277,1,'Xocavand'),
(278,1,'Yardimli'),
(279,1,'Yevlax'),
(280,1,'Zangilan'),
(281,1,'Zaqatala'),
(282,1,'Zardab'),
(283,1,'Naxcivan'),
(284,1,'Acklins'),
(285,1,'Berry Islands'),
(286,1,'Bimini'),
(287,1,'Black Point'),
(288,1,'Cat Island'),
(289,1,'Central Abaco'),
(290,1,'Central Andros'),
(291,1,'Central Eleuthera'),
(292,1,'City of Freeport'),
(293,1,'Crooked Island'),
(294,1,'East Grand Bahama'),
(295,1,'Exuma'),
(296,1,'Grand Cay'),
(297,1,'Harbour Island'),
(298,1,'Hope Town'),
(299,1,'Inagua'),
(300,1,'Long Island'),
(301,1,'Mangrove Cay'),
(302,1,'Mayaguana'),
(303,1,'Moore\'s Island'),
(304,1,'North Abaco'),
(305,1,'North Andros'),
(306,1,'North Eleuthera'),
(307,1,'Ragged Island'),
(308,1,'Rum Cay'),
(309,1,'San Salvador'),
(310,1,'South Abaco'),
(311,1,'South Andros'),
(312,1,'South Eleuthera'),
(313,1,'Spanish Wells'),
(314,1,'West Grand Bahama'),
(315,1,'Capital'),
(316,1,'Central'),
(317,1,'Muharraq'),
(318,1,'Northern'),
(319,1,'Southern'),
(320,1,'Barisal'),
(321,1,'Chittagong'),
(322,1,'Dhaka'),
(323,1,'Khulna'),
(324,1,'Rajshahi'),
(325,1,'Sylhet'),
(326,1,'Christ Church'),
(327,1,'Saint Andrew'),
(328,1,'Saint George'),
(329,1,'Saint James'),
(330,1,'Saint John'),
(331,1,'Saint Joseph'),
(332,1,'Saint Lucy'),
(333,1,'Saint Michael'),
(334,1,'Saint Peter'),
(335,1,'Saint Philip'),
(336,1,'Saint Thomas'),
(337,1,'Brestskaya (Brest)'),
(338,1,'Homyel\'skaya (Homyel\')'),
(339,1,'Horad Minsk'),
(340,1,'Hrodzyenskaya (Hrodna)'),
(341,1,'Mahilyowskaya (Mahilyow)'),
(342,1,'Minskaya'),
(343,1,'Vitsyebskaya (Vitsyebsk)'),
(344,1,'Antwerpen'),
(345,1,'Brabant Wallon'),
(346,1,'Hainaut'),
(347,1,'Liege'),
(348,1,'Limburg'),
(349,1,'Luxembourg'),
(350,1,'Namur'),
(351,1,'Oost-Vlaanderen'),
(352,1,'Vlaams Brabant'),
(353,1,'West-Vlaanderen'),
(354,1,'Belize'),
(355,1,'Cayo'),
(356,1,'Corozal'),
(357,1,'Orange Walk'),
(358,1,'Stann Creek'),
(359,1,'Toledo'),
(360,1,'Alibori'),
(361,1,'Atakora'),
(362,1,'Atlantique'),
(363,1,'Borgou'),
(364,1,'Collines'),
(365,1,'Donga'),
(366,1,'Kouffo'),
(367,1,'Littoral'),
(368,1,'Mono'),
(369,1,'Oueme'),
(370,1,'Plateau'),
(371,1,'Zou'),
(372,1,'Devonshire'),
(373,1,'Hamilton City'),
(374,1,'Hamilton'),
(375,1,'Paget'),
(376,1,'Pembroke'),
(377,1,'Saint George City'),
(378,1,'Saint George\'s'),
(379,1,'Sandys'),
(380,1,'Smith\'s'),
(381,1,'Southampton'),
(382,1,'Warwick'),
(383,1,'Bumthang'),
(384,1,'Chukha'),
(385,1,'Dagana'),
(386,1,'Gasa'),
(387,1,'Haa'),
(388,1,'Lhuntse'),
(389,1,'Mongar'),
(390,1,'Paro'),
(391,1,'Pemagatshel'),
(392,1,'Punakha'),
(393,1,'Samdrup Jongkhar'),
(394,1,'Samtse'),
(395,1,'Sarpang'),
(396,1,'Thimphu'),
(397,1,'Trashigang'),
(398,1,'Trashiyangste'),
(399,1,'Trongsa'),
(400,1,'Tsirang'),
(401,1,'Wangdue Phodrang'),
(402,1,'Zhemgang'),
(403,1,'Beni'),
(404,1,'Chuquisaca'),
(405,1,'Cochabamba'),
(406,1,'La Paz'),
(407,1,'Oruro'),
(408,1,'Pando'),
(409,1,'Potosi'),
(410,1,'Santa Cruz'),
(411,1,'Tarija'),
(412,1,'Brcko district'),
(413,1,'Unsko-Sanski Kanton'),
(414,1,'Posavski Kanton'),
(415,1,'Tuzlanski Kanton'),
(416,1,'Zenicko-Dobojski Kanton'),
(417,1,'Bosanskopodrinjski Kanton'),
(418,1,'Srednjebosanski Kanton'),
(419,1,'Hercegovacko-neretvanski Kanton'),
(420,1,'Zapadnohercegovacka Zupanija'),
(421,1,'Kanton Sarajevo'),
(422,1,'Zapadnobosanska'),
(423,1,'Banja Luka'),
(424,1,'Doboj'),
(425,1,'Bijeljina'),
(426,1,'Vlasenica'),
(427,1,'Sarajevo-Romanija or Sokolac'),
(428,1,'Foca'),
(429,1,'Trebinje'),
(430,1,'Central'),
(431,1,'Ghanzi'),
(432,1,'Kgalagadi'),
(433,1,'Kgatleng'),
(434,1,'Kweneng'),
(435,1,'Ngamiland'),
(436,1,'North East'),
(437,1,'North West'),
(438,1,'South East'),
(439,1,'Southern'),
(440,1,'Acre'),
(441,1,'Alagoas'),
(442,1,'Amapa'),
(443,1,'Amazonas'),
(444,1,'Bahia'),
(445,1,'Ceara'),
(446,1,'Distrito Federal'),
(447,1,'Espirito Santo'),
(448,1,'Goias'),
(449,1,'Maranhao'),
(450,1,'Mato Grosso'),
(451,1,'Mato Grosso do Sul'),
(452,1,'Minas Gerais'),
(453,1,'Para'),
(454,1,'Paraiba'),
(455,1,'Parana'),
(456,1,'Pernambuco'),
(457,1,'Piaui'),
(458,1,'Rio de Janeiro'),
(459,1,'Rio Grande do Norte'),
(460,1,'Rio Grande do Sul'),
(461,1,'Rondonia'),
(462,1,'Roraima'),
(463,1,'Santa Catarina'),
(464,1,'Sao Paulo'),
(465,1,'Sergipe'),
(466,1,'Tocantins'),
(467,1,'Peros Banhos'),
(468,1,'Salomon Islands'),
(469,1,'Nelsons Island'),
(470,1,'Three Brothers'),
(471,1,'Eagle Islands'),
(472,1,'Danger Island'),
(473,1,'Egmont Islands'),
(474,1,'Diego Garcia'),
(475,1,'Belait'),
(476,1,'Brunei and Muara'),
(477,1,'Temburong'),
(478,1,'Tutong'),
(479,1,'Blagoevgrad'),
(480,1,'Burgas'),
(481,1,'Dobrich'),
(482,1,'Gabrovo'),
(483,1,'Haskovo'),
(484,1,'Kardjali'),
(485,1,'Kyustendil'),
(486,1,'Lovech'),
(487,1,'Montana'),
(488,1,'Pazardjik'),
(489,1,'Pernik'),
(490,1,'Pleven'),
(491,1,'Plovdiv'),
(492,1,'Razgrad'),
(493,1,'Shumen'),
(494,1,'Silistra'),
(495,1,'Sliven'),
(496,1,'Smolyan'),
(497,1,'Sofia'),
(498,1,'Sofia - town'),
(499,1,'Stara Zagora'),
(500,1,'Targovishte'),
(501,1,'Varna'),
(502,1,'Veliko Tarnovo'),
(503,1,'Vidin'),
(504,1,'Vratza'),
(505,1,'Yambol'),
(506,1,'Bale'),
(507,1,'Bam'),
(508,1,'Banwa'),
(509,1,'Bazega'),
(510,1,'Bougouriba'),
(511,1,'Boulgou'),
(512,1,'Boulkiemde'),
(513,1,'Comoe'),
(514,1,'Ganzourgou'),
(515,1,'Gnagna'),
(516,1,'Gourma'),
(517,1,'Houet'),
(518,1,'Ioba'),
(519,1,'Kadiogo'),
(520,1,'Kenedougou'),
(521,1,'Komondjari'),
(522,1,'Kompienga'),
(523,1,'Kossi'),
(524,1,'Koulpelogo'),
(525,1,'Kouritenga'),
(526,1,'Kourweogo'),
(527,1,'Leraba'),
(528,1,'Loroum'),
(529,1,'Mouhoun'),
(530,1,'Nahouri'),
(531,1,'Namentenga'),
(532,1,'Nayala'),
(533,1,'Noumbiel'),
(534,1,'Oubritenga'),
(535,1,'Oudalan'),
(536,1,'Passore'),
(537,1,'Poni'),
(538,1,'Sanguie'),
(539,1,'Sanmatenga'),
(540,1,'Seno'),
(541,1,'Sissili'),
(542,1,'Soum'),
(543,1,'Sourou'),
(544,1,'Tapoa'),
(545,1,'Tuy'),
(546,1,'Yagha'),
(547,1,'Yatenga'),
(548,1,'Ziro'),
(549,1,'Zondoma'),
(550,1,'Zoundweogo'),
(551,1,'Bubanza'),
(552,1,'Bujumbura'),
(553,1,'Bururi'),
(554,1,'Cankuzo'),
(555,1,'Cibitoke'),
(556,1,'Gitega'),
(557,1,'Karuzi'),
(558,1,'Kayanza'),
(559,1,'Kirundo'),
(560,1,'Makamba'),
(561,1,'Muramvya'),
(562,1,'Muyinga'),
(563,1,'Mwaro'),
(564,1,'Ngozi'),
(565,1,'Rutana'),
(566,1,'Ruyigi'),
(567,1,'Phnom Penh'),
(568,1,'Preah Seihanu (Kompong Som or Sihanoukville)'),
(569,1,'Pailin'),
(570,1,'Keb'),
(571,1,'Banteay Meanchey'),
(572,1,'Battambang'),
(573,1,'Kampong Cham'),
(574,1,'Kampong Chhnang'),
(575,1,'Kampong Speu'),
(576,1,'Kampong Som'),
(577,1,'Kampong Thom'),
(578,1,'Kampot'),
(579,1,'Kandal'),
(580,1,'Kaoh Kong'),
(581,1,'Kratie'),
(582,1,'Mondul Kiri'),
(583,1,'Oddar Meancheay'),
(584,1,'Pursat'),
(585,1,'Preah Vihear'),
(586,1,'Prey Veng'),
(587,1,'Ratanak Kiri'),
(588,1,'Siemreap'),
(589,1,'Stung Treng'),
(590,1,'Svay Rieng'),
(591,1,'Takeo'),
(592,1,'Adamawa (Adamaoua)'),
(593,1,'Centre'),
(594,1,'East (Est)'),
(595,1,'Extreme North (Extreme-Nord)'),
(596,1,'Littoral'),
(597,1,'North (Nord)'),
(598,1,'Northwest (Nord-Ouest)'),
(599,1,'West (Ouest)'),
(600,1,'South (Sud)'),
(601,1,'Southwest (Sud-Ouest).'),
(602,1,'Alberta'),
(603,1,'British Columbia'),
(604,1,'Manitoba'),
(605,1,'New Brunswick'),
(606,1,'Newfoundland and Labrador'),
(607,1,'Northwest Territories'),
(608,1,'Nova Scotia'),
(609,1,'Nunavut'),
(610,1,'Ontario'),
(611,1,'Prince Edward Island'),
(612,1,'Qu&eacute;bec'),
(613,1,'Saskatchewan'),
(614,1,'Yukon Territory'),
(615,1,'Boa Vista'),
(616,1,'Brava'),
(617,1,'Calheta de Sao Miguel'),
(618,1,'Maio'),
(619,1,'Mosteiros'),
(620,1,'Paul'),
(621,1,'Porto Novo'),
(622,1,'Praia'),
(623,1,'Ribeira Grande'),
(624,1,'Sal'),
(625,1,'Santa Catarina'),
(626,1,'Santa Cruz'),
(627,1,'Sao Domingos'),
(628,1,'Sao Filipe'),
(629,1,'Sao Nicolau'),
(630,1,'Sao Vicente'),
(631,1,'Tarrafal'),
(632,1,'Creek'),
(633,1,'Eastern'),
(634,1,'Midland'),
(635,1,'South Town'),
(636,1,'Spot Bay'),
(637,1,'Stake Bay'),
(638,1,'West End'),
(639,1,'Western'),
(640,1,'Bamingui-Bangoran'),
(641,1,'Basse-Kotto'),
(642,1,'Haute-Kotto'),
(643,1,'Haut-Mbomou'),
(644,1,'Kemo'),
(645,1,'Lobaye'),
(646,1,'Mambere-KadeÔ'),
(647,1,'Mbomou'),
(648,1,'Nana-Mambere'),
(649,1,'Ombella-M\'Poko'),
(650,1,'Ouaka'),
(651,1,'Ouham'),
(652,1,'Ouham-Pende'),
(653,1,'Vakaga'),
(654,1,'Nana-Grebizi'),
(655,1,'Sangha-Mbaere'),
(656,1,'Bangui'),
(657,1,'Batha'),
(658,1,'Biltine'),
(659,1,'Borkou-Ennedi-Tibesti'),
(660,1,'Chari-Baguirmi'),
(661,1,'Guera'),
(662,1,'Kanem'),
(663,1,'Lac'),
(664,1,'Logone Occidental'),
(665,1,'Logone Oriental'),
(666,1,'Mayo-Kebbi'),
(667,1,'Moyen-Chari'),
(668,1,'Ouaddai'),
(669,1,'Salamat'),
(670,1,'Tandjile'),
(671,1,'Aisen del General Carlos Ibanez'),
(672,1,'Antofagasta'),
(673,1,'Araucania'),
(674,1,'Atacama'),
(675,1,'Bio-Bio'),
(676,1,'Coquimbo'),
(677,1,'Libertador General Bernardo O\'Hi'),
(678,1,'Los Lagos'),
(679,1,'Magallanes y de la Antartica Chi'),
(680,1,'Maule'),
(681,1,'Region Metropolitana'),
(682,1,'Tarapaca'),
(683,1,'Valparaiso'),
(684,1,'Anhui'),
(685,1,'Beijing'),
(686,1,'Chongqing'),
(687,1,'Fujian'),
(688,1,'Gansu'),
(689,1,'Guangdong'),
(690,1,'Guangxi'),
(691,1,'Guizhou'),
(692,1,'Hainan'),
(693,1,'Hebei'),
(694,1,'Heilongjiang'),
(695,1,'Henan'),
(696,1,'Hong Kong'),
(697,1,'Hubei'),
(698,1,'Hunan'),
(699,1,'Inner Mongolia'),
(700,1,'Jiangsu'),
(701,1,'Jiangxi'),
(702,1,'Jilin'),
(703,1,'Liaoning'),
(704,1,'Macau'),
(705,1,'Ningxia'),
(706,1,'Shaanxi'),
(707,1,'Shandong'),
(708,1,'Shanghai'),
(709,1,'Shanxi'),
(710,1,'Sichuan'),
(711,1,'Tianjin'),
(712,1,'Xinjiang'),
(713,1,'Yunnan'),
(714,1,'Zhejiang'),
(715,1,'Direction Island'),
(716,1,'Home Island'),
(717,1,'Horsburgh Island'),
(718,1,'South Island'),
(719,1,'West Island'),
(720,1,'Amazonas'),
(721,1,'Antioquia'),
(722,1,'Arauca'),
(723,1,'Atlantico'),
(724,1,'Bogota D.C.'),
(725,1,'Bolivar'),
(726,1,'Boyaca'),
(727,1,'Caldas'),
(728,1,'Caqueta'),
(729,1,'Casanare'),
(730,1,'Cauca'),
(731,1,'Cesar'),
(732,1,'Choco'),
(733,1,'Cordoba'),
(734,1,'Cundinamarca'),
(735,1,'Guainia'),
(736,1,'Guajira'),
(737,1,'Guaviare'),
(738,1,'Huila'),
(739,1,'Magdalena'),
(740,1,'Meta'),
(741,1,'Narino'),
(742,1,'Norte de Santander'),
(743,1,'Putumayo'),
(744,1,'Quindio'),
(745,1,'Risaralda'),
(746,1,'San Andres y Providencia'),
(747,1,'Santander'),
(748,1,'Sucre'),
(749,1,'Tolima'),
(750,1,'Valle del Cauca'),
(751,1,'Vaupes'),
(752,1,'Vichada'),
(753,1,'Grande Comore'),
(754,1,'Anjouan'),
(755,1,'Moheli'),
(756,1,'Bouenza'),
(757,1,'Brazzaville'),
(758,1,'Cuvette'),
(759,1,'Cuvette-Ouest'),
(760,1,'Kouilou'),
(761,1,'Lekoumou'),
(762,1,'Likouala'),
(763,1,'Niari'),
(764,1,'Plateaux'),
(765,1,'Pool'),
(766,1,'Sangha'),
(767,1,'Pukapuka'),
(768,1,'Rakahanga'),
(769,1,'Manihiki'),
(770,1,'Penrhyn'),
(771,1,'Nassau Island'),
(772,1,'Surwarrow'),
(773,1,'Palmerston'),
(774,1,'Aitutaki'),
(775,1,'Manuae'),
(776,1,'Takutea'),
(777,1,'Mitiaro'),
(778,1,'Atiu'),
(779,1,'Mauke'),
(780,1,'Rarotonga'),
(781,1,'Mangaia'),
(782,1,'Alajuela'),
(783,1,'Cartago'),
(784,1,'Guanacaste'),
(785,1,'Heredia'),
(786,1,'Limon'),
(787,1,'Puntarenas'),
(788,1,'San Jose'),
(789,1,'Abengourou'),
(790,1,'Abidjan'),
(791,1,'Aboisso'),
(792,1,'Adiake'),
(793,1,'Adzope'),
(794,1,'Agboville'),
(795,1,'Agnibilekrou'),
(796,1,'Alepe'),
(797,1,'Bocanda'),
(798,1,'Bangolo'),
(799,1,'Beoumi'),
(800,1,'Biankouma'),
(801,1,'Bondoukou'),
(802,1,'Bongouanou'),
(803,1,'Bouafle'),
(804,1,'Bouake'),
(805,1,'Bouna'),
(806,1,'Boundiali'),
(807,1,'Dabakala'),
(808,1,'Dabou'),
(809,1,'Daloa'),
(810,1,'Danane'),
(811,1,'Daoukro'),
(812,1,'Dimbokro'),
(813,1,'Divo'),
(814,1,'Duekoue'),
(815,1,'Ferkessedougou'),
(816,1,'Gagnoa'),
(817,1,'Grand-Bassam'),
(818,1,'Grand-Lahou'),
(819,1,'Guiglo'),
(820,1,'Issia'),
(821,1,'Jacqueville'),
(822,1,'Katiola'),
(823,1,'Korhogo'),
(824,1,'Lakota'),
(825,1,'Man'),
(826,1,'Mankono'),
(827,1,'Mbahiakro'),
(828,1,'Odienne'),
(829,1,'Oume'),
(830,1,'Sakassou'),
(831,1,'San-Pedro'),
(832,1,'Sassandra'),
(833,1,'Seguela'),
(834,1,'Sinfra'),
(835,1,'Soubre'),
(836,1,'Tabou'),
(837,1,'Tanda'),
(838,1,'Tiebissou'),
(839,1,'Tingrela'),
(840,1,'Tiassale'),
(841,1,'Touba'),
(842,1,'Toulepleu'),
(843,1,'Toumodi'),
(844,1,'Vavoua'),
(845,1,'Yamoussoukro'),
(846,1,'Zuenoula'),
(847,1,'Bjelovar-Bilogora'),
(848,1,'City of Zagreb'),
(849,1,'Dubrovnik-Neretva'),
(850,1,'Istra'),
(851,1,'Karlovac'),
(852,1,'Koprivnica-Krizevci'),
(853,1,'Krapina-Zagorje'),
(854,1,'Lika-Senj'),
(855,1,'Medimurje'),
(856,1,'Osijek-Baranja'),
(857,1,'Pozega-Slavonia'),
(858,1,'Primorje-Gorski Kotar'),
(859,1,'Sibenik'),
(860,1,'Sisak-Moslavina'),
(861,1,'Slavonski Brod-Posavina'),
(862,1,'Split-Dalmatia'),
(863,1,'Varazdin'),
(864,1,'Virovitica-Podravina'),
(865,1,'Vukovar-Srijem'),
(866,1,'Zadar-Knin'),
(867,1,'Zagreb'),
(868,1,'Camaguey'),
(869,1,'Ciego de Avila'),
(870,1,'Cienfuegos'),
(871,1,'Ciudad de La Habana'),
(872,1,'Granma'),
(873,1,'Guantanamo'),
(874,1,'Holguin'),
(875,1,'Isla de la Juventud'),
(876,1,'La Habana'),
(877,1,'Las Tunas'),
(878,1,'Matanzas'),
(879,1,'Pinar del Rio'),
(880,1,'Sancti Spiritus'),
(881,1,'Santiago de Cuba'),
(882,1,'Villa Clara'),
(883,1,'Famagusta'),
(884,1,'Kyrenia'),
(885,1,'Larnaca'),
(886,1,'Limassol'),
(887,1,'Nicosia'),
(888,1,'Paphos'),
(889,1,'Ustecky'),
(890,1,'Jihocesky'),
(891,1,'Jihomoravsky'),
(892,1,'Karlovarsky'),
(893,1,'Kralovehradecky'),
(894,1,'Liberecky'),
(895,1,'Moravskoslezsky'),
(896,1,'Olomoucky'),
(897,1,'Pardubicky'),
(898,1,'Plzensky'),
(899,1,'Praha'),
(900,1,'Stredocesky'),
(901,1,'Vysocina'),
(902,1,'Zlinsky'),
(903,1,'Arhus'),
(904,1,'Bornholm'),
(905,1,'Copenhagen'),
(906,1,'Faroe Islands'),
(907,1,'Frederiksborg'),
(908,1,'Fyn'),
(909,1,'Kobenhavn'),
(910,1,'Nordjylland'),
(911,1,'Ribe'),
(912,1,'Ringkobing'),
(913,1,'Roskilde'),
(914,1,'Sonderjylland'),
(915,1,'Storstrom'),
(916,1,'Vejle'),
(917,1,'Vestj&aelig;lland'),
(918,1,'Viborg'),
(919,1,'\'Ali Sabih'),
(920,1,'Dikhil'),
(921,1,'Djibouti'),
(922,1,'Obock'),
(923,1,'Tadjoura'),
(924,1,'Saint Andrew Parish'),
(925,1,'Saint David Parish'),
(926,1,'Saint George Parish'),
(927,1,'Saint John Parish'),
(928,1,'Saint Joseph Parish'),
(929,1,'Saint Luke Parish'),
(930,1,'Saint Mark Parish'),
(931,1,'Saint Patrick Parish'),
(932,1,'Saint Paul Parish'),
(933,1,'Saint Peter Parish'),
(934,1,'Distrito Nacional'),
(935,1,'Azua'),
(936,1,'Baoruco'),
(937,1,'Barahona'),
(938,1,'Dajabon'),
(939,1,'Duarte'),
(940,1,'Elias Pina'),
(941,1,'El Seybo'),
(942,1,'Espaillat'),
(943,1,'Hato Mayor'),
(944,1,'Independencia'),
(945,1,'La Altagracia'),
(946,1,'La Romana'),
(947,1,'La Vega'),
(948,1,'Maria Trinidad Sanchez'),
(949,1,'Monsenor Nouel'),
(950,1,'Monte Cristi'),
(951,1,'Monte Plata'),
(952,1,'Pedernales'),
(953,1,'Peravia (Bani)'),
(954,1,'Puerto Plata'),
(955,1,'Salcedo'),
(956,1,'Samana'),
(957,1,'Sanchez Ramirez'),
(958,1,'San Cristobal'),
(959,1,'San Jose de Ocoa'),
(960,1,'San Juan'),
(961,1,'San Pedro de Macoris'),
(962,1,'Santiago'),
(963,1,'Santiago Rodriguez'),
(964,1,'Santo Domingo'),
(965,1,'Valverde'),
(966,1,'Aileu'),
(967,1,'Ainaro'),
(968,1,'Baucau'),
(969,1,'Bobonaro'),
(970,1,'Cova Lima'),
(971,1,'Dili'),
(972,1,'Ermera'),
(973,1,'Lautem'),
(974,1,'Liquica'),
(975,1,'Manatuto'),
(976,1,'Manufahi'),
(977,1,'Oecussi'),
(978,1,'Viqueque'),
(979,1,'Azuay'),
(980,1,'Bolivar'),
(981,1,'Ca&ntilde;ar'),
(982,1,'Carchi'),
(983,1,'Chimborazo'),
(984,1,'Cotopaxi'),
(985,1,'El Oro'),
(986,1,'Esmeraldas'),
(987,1,'Gal&aacute;pagos'),
(988,1,'Guayas'),
(989,1,'Imbabura'),
(990,1,'Loja'),
(991,1,'Los Rios'),
(992,1,'Manab&iacute;'),
(993,1,'Morona Santiago'),
(994,1,'Napo'),
(995,1,'Orellana'),
(996,1,'Pastaza'),
(997,1,'Pichincha'),
(998,1,'Sucumb&iacute;os'),
(999,1,'Tungurahua'),
(1000,1,'Zamora Chinchipe'),
(1001,1,'Ad Daqahliyah'),
(1002,1,'Al Bahr al Ahmar'),
(1003,1,'Al Buhayrah'),
(1004,1,'Al Fayyum'),
(1005,1,'Al Gharbiyah'),
(1006,1,'Al Iskandariyah'),
(1007,1,'Al Isma\'iliyah'),
(1008,1,'Al Jizah'),
(1009,1,'Al Minufiyah'),
(1010,1,'Al Minya'),
(1011,1,'Al Qahirah'),
(1012,1,'Al Qalyubiyah'),
(1013,1,'Al Wadi al Jadid'),
(1014,1,'Ash Sharqiyah'),
(1015,1,'As Suways'),
(1016,1,'Aswan'),
(1017,1,'Asyut'),
(1018,1,'Bani Suwayf'),
(1019,1,'Bur Sa\'id'),
(1020,1,'Dumyat'),
(1021,1,'Janub Sina\''),
(1022,1,'Kafr ash Shaykh'),
(1023,1,'Matruh'),
(1024,1,'Qina'),
(1025,1,'Shamal Sina\''),
(1026,1,'Suhaj'),
(1027,1,'Ahuachapan'),
(1028,1,'Cabanas'),
(1029,1,'Chalatenango'),
(1030,1,'Cuscatlan'),
(1031,1,'La Libertad'),
(1032,1,'La Paz'),
(1033,1,'La Union'),
(1034,1,'Morazan'),
(1035,1,'San Miguel'),
(1036,1,'San Salvador'),
(1037,1,'San Vicente'),
(1038,1,'Santa Ana'),
(1039,1,'Sonsonate'),
(1040,1,'Usulutan'),
(1041,1,'Provincia Annobon'),
(1042,1,'Provincia Bioko Norte'),
(1043,1,'Provincia Bioko Sur'),
(1044,1,'Provincia Centro Sur'),
(1045,1,'Provincia Kie-Ntem'),
(1046,1,'Provincia Litoral'),
(1047,1,'Provincia Wele-Nzas'),
(1048,1,'Central (Maekel)'),
(1049,1,'Anseba (Keren)'),
(1050,1,'Southern Red Sea (Debub-Keih-Bahri)'),
(1051,1,'Northern Red Sea (Semien-Keih-Bahri)'),
(1052,1,'Southern (Debub)'),
(1053,1,'Gash-Barka (Barentu)'),
(1054,1,'Harjumaa (Tallinn)'),
(1055,1,'Hiiumaa (Kardla)'),
(1056,1,'Ida-Virumaa (Johvi)'),
(1057,1,'Jarvamaa (Paide)'),
(1058,1,'Jogevamaa (Jogeva)'),
(1059,1,'Laane-Virumaa (Rakvere)'),
(1060,1,'Laanemaa (Haapsalu)'),
(1061,1,'Parnumaa (Parnu)'),
(1062,1,'Polvamaa (Polva)'),
(1063,1,'Raplamaa (Rapla)'),
(1064,1,'Saaremaa (Kuessaare)'),
(1065,1,'Tartumaa (Tartu)'),
(1066,1,'Valgamaa (Valga)'),
(1067,1,'Viljandimaa (Viljandi)'),
(1068,1,'Vorumaa (Voru)'),
(1069,1,'Afar'),
(1070,1,'Amhara'),
(1071,1,'Benishangul-Gumaz'),
(1072,1,'Gambela'),
(1073,1,'Hariai'),
(1074,1,'Oromia'),
(1075,1,'Somali'),
(1076,1,'Southern Nations - Nationalities and Peoples Region'),
(1077,1,'Tigray'),
(1078,1,'Addis Ababa'),
(1079,1,'Dire Dawa'),
(1080,1,'Central Division'),
(1081,1,'Northern Division'),
(1082,1,'Eastern Division'),
(1083,1,'Western Division'),
(1084,1,'Rotuma'),
(1085,1,'Ahvenanmaan Laani'),
(1086,1,'Etela-Suomen Laani'),
(1087,1,'Ita-Suomen Laani'),
(1088,1,'Lansi-Suomen Laani'),
(1089,1,'Lapin Lanani'),
(1090,1,'Oulun Laani'),
(1091,1,'Alsace'),
(1092,1,'Aquitaine'),
(1093,1,'Auvergne'),
(1094,1,'Brittany'),
(1095,1,'Burgundy'),
(1096,1,'Center Loire Valley'),
(1097,1,'Champagne'),
(1098,1,'Corse'),
(1099,1,'France Comte'),
(1100,1,'Languedoc Roussillon'),
(1101,1,'Limousin'),
(1102,1,'Lorraine'),
(1103,1,'Midi Pyrenees'),
(1104,1,'Nord Pas de Calais'),
(1105,1,'Normandy'),
(1106,1,'Paris / Ill de France'),
(1107,1,'Picardie'),
(1108,1,'Poitou Charente'),
(1109,1,'Provence'),
(1110,1,'Rhone Alps'),
(1111,1,'Riviera'),
(1112,1,'Western Loire Valley'),
(1113,1,'Etranger'),
(1114,1,'Ain'),
(1115,1,'Aisne'),
(1116,1,'Allier'),
(1117,1,'Alpes de Haute Provence'),
(1118,1,'Hautes-Alpes'),
(1119,1,'Alpes Maritimes'),
(1120,1,'Ard&egrave;che'),
(1121,1,'Ardennes'),
(1122,1,'Ari&egrave;ge'),
(1123,1,'Aube'),
(1124,1,'Aude'),
(1125,1,'Aveyron'),
(1126,1,'Bouches du Rh&ocirc;ne'),
(1127,1,'Calvados'),
(1128,1,'Cantal'),
(1129,1,'Charente'),
(1130,1,'Charente Maritime'),
(1131,1,'Cher'),
(1132,1,'Corr&egrave;ze'),
(1133,1,'Corse du Sud'),
(1134,1,'Haute Corse'),
(1135,1,'C&ocirc;te d&#039;or'),
(1136,1,'C&ocirc;tes d&#039;Armor'),
(1137,1,'Creuse'),
(1138,1,'Dordogne'),
(1139,1,'Doubs'),
(1140,1,'Dr&ocirc;me'),
(1141,1,'Eure'),
(1142,1,'Eure et Loir'),
(1143,1,'Finist&egrave;re'),
(1144,1,'Gard'),
(1145,1,'Haute Garonne'),
(1146,1,'Gers'),
(1147,1,'Gironde'),
(1148,1,'H&eacute;rault'),
(1149,1,'Ille et Vilaine'),
(1150,1,'Indre'),
(1151,1,'Indre et Loire'),
(1152,1,'Is&eacute;re'),
(1153,1,'Jura'),
(1154,1,'Landes'),
(1155,1,'Loir et Cher'),
(1156,1,'Loire'),
(1157,1,'Haute Loire'),
(1158,1,'Loire Atlantique'),
(1159,1,'Loiret'),
(1160,1,'Lot'),
(1161,1,'Lot et Garonne'),
(1162,1,'Loz&egrave;re'),
(1163,1,'Maine et Loire'),
(1164,1,'Manche'),
(1165,1,'Marne'),
(1166,1,'Haute Marne'),
(1167,1,'Mayenne'),
(1168,1,'Meurthe et Moselle'),
(1169,1,'Meuse'),
(1170,1,'Morbihan'),
(1171,1,'Moselle'),
(1172,1,'Ni&egrave;vre'),
(1173,1,'Nord'),
(1174,1,'Oise'),
(1175,1,'Orne'),
(1176,1,'Pas de Calais'),
(1177,1,'Puy de D&ocirc;me'),
(1178,1,'Pyr&eacute;n&eacute;es Atlantiques'),
(1179,1,'Hautes Pyr&eacute;n&eacute;es'),
(1180,1,'Pyr&eacute;n&eacute;es Orientales'),
(1181,1,'Bas Rhin'),
(1182,1,'Haut Rhin'),
(1183,1,'Rh&ocirc;ne'),
(1184,1,'Haute Sa&ocirc;ne'),
(1185,1,'Sa&ocirc;ne et Loire'),
(1186,1,'Sarthe'),
(1187,1,'Savoie'),
(1188,1,'Haute Savoie'),
(1189,1,'Paris'),
(1190,1,'Seine Maritime'),
(1191,1,'Seine et Marne'),
(1192,1,'Yvelines'),
(1193,1,'Deux S&egrave;vres'),
(1194,1,'Somme'),
(1195,1,'Tarn'),
(1196,1,'Tarn et Garonne'),
(1197,1,'Var'),
(1198,1,'Vaucluse'),
(1199,1,'Vend&eacute;e'),
(1200,1,'Vienne'),
(1201,1,'Haute Vienne'),
(1202,1,'Vosges'),
(1203,1,'Yonne'),
(1204,1,'Territoire de Belfort'),
(1205,1,'Essonne'),
(1206,1,'Hauts de Seine'),
(1207,1,'Seine St-Denis'),
(1208,1,'Val de Marne'),
(1209,1,'Val d\'Oise'),
(1210,1,'Archipel des Marquises'),
(1211,1,'Archipel des Tuamotu'),
(1212,1,'Archipel des Tubuai'),
(1213,1,'Iles du Vent'),
(1214,1,'Iles Sous-le-Vent'),
(1215,1,'Iles Crozet'),
(1216,1,'Iles Kerguelen'),
(1217,1,'Ile Amsterdam'),
(1218,1,'Ile Saint-Paul'),
(1219,1,'Adelie Land'),
(1220,1,'Estuaire'),
(1221,1,'Haut-Ogooue'),
(1222,1,'Moyen-Ogooue'),
(1223,1,'Ngounie'),
(1224,1,'Nyanga'),
(1225,1,'Ogooue-Ivindo'),
(1226,1,'Ogooue-Lolo'),
(1227,1,'Ogooue-Maritime'),
(1228,1,'Woleu-Ntem'),
(1229,1,'Banjul'),
(1230,1,'Basse'),
(1231,1,'Brikama'),
(1232,1,'Janjangbure'),
(1233,1,'Kanifeng'),
(1234,1,'Kerewan'),
(1235,1,'Kuntaur'),
(1236,1,'Mansakonko'),
(1237,1,'Lower River'),
(1238,1,'Central River'),
(1239,1,'North Bank'),
(1240,1,'Upper River'),
(1241,1,'Western'),
(1242,1,'Abkhazia'),
(1243,1,'Ajaria'),
(1244,1,'Tbilisi'),
(1245,1,'Guria'),
(1246,1,'Imereti'),
(1247,1,'Kakheti'),
(1248,1,'Kvemo Kartli'),
(1249,1,'Mtskheta-Mtianeti'),
(1250,1,'Racha Lechkhumi and Kvemo Svanet'),
(1251,1,'Samegrelo-Zemo Svaneti'),
(1252,1,'Samtskhe-Javakheti'),
(1253,1,'Shida Kartli'),
(1254,1,'Baden-W&uuml;rttemberg'),
(1255,1,'Bayern'),
(1256,1,'Berlin'),
(1257,1,'Brandenburg'),
(1258,1,'Bremen'),
(1259,1,'Hamburg'),
(1260,1,'Hessen'),
(1261,1,'Mecklenburg-Vorpommern'),
(1262,1,'Niedersachsen'),
(1263,1,'Nordrhein-Westfalen'),
(1264,1,'Rheinland-Pfalz'),
(1265,1,'Saarland'),
(1266,1,'Sachsen'),
(1267,1,'Sachsen-Anhalt'),
(1268,1,'Schleswig-Holstein'),
(1269,1,'Th&uuml;ringen'),
(1270,1,'Ashanti Region'),
(1271,1,'Brong-Ahafo Region'),
(1272,1,'Central Region'),
(1273,1,'Eastern Region'),
(1274,1,'Greater Accra Region'),
(1275,1,'Northern Region'),
(1276,1,'Upper East Region'),
(1277,1,'Upper West Region'),
(1278,1,'Volta Region'),
(1279,1,'Western Region'),
(1280,1,'Attica'),
(1281,1,'Central Greece'),
(1282,1,'Central Macedonia'),
(1283,1,'Crete'),
(1284,1,'East Macedonia and Thrace'),
(1285,1,'Epirus'),
(1286,1,'Ionian Islands'),
(1287,1,'North Aegean'),
(1288,1,'Peloponnesos'),
(1289,1,'South Aegean'),
(1290,1,'Thessaly'),
(1291,1,'West Greece'),
(1292,1,'West Macedonia'),
(1293,1,'Avannaa'),
(1294,1,'Tunu'),
(1295,1,'Kitaa'),
(1296,1,'Saint Andrew'),
(1297,1,'Saint David'),
(1298,1,'Saint George'),
(1299,1,'Saint John'),
(1300,1,'Saint Mark'),
(1301,1,'Saint Patrick'),
(1302,1,'Carriacou'),
(1303,1,'Petit Martinique'),
(1304,1,'Alta Verapaz'),
(1305,1,'Baja Verapaz'),
(1306,1,'Chimaltenango'),
(1307,1,'Chiquimula'),
(1308,1,'El Peten'),
(1309,1,'El Progreso'),
(1310,1,'El Quiche'),
(1311,1,'Escuintla'),
(1312,1,'Guatemala'),
(1313,1,'Huehuetenango'),
(1314,1,'Izabal'),
(1315,1,'Jalapa'),
(1316,1,'Jutiapa'),
(1317,1,'Quetzaltenango'),
(1318,1,'Retalhuleu'),
(1319,1,'Sacatepequez'),
(1320,1,'San Marcos'),
(1321,1,'Santa Rosa'),
(1322,1,'Solola'),
(1323,1,'Suchitepequez'),
(1324,1,'Totonicapan'),
(1325,1,'Zacapa'),
(1326,1,'Conakry'),
(1327,1,'Beyla'),
(1328,1,'Boffa'),
(1329,1,'Boke'),
(1330,1,'Coyah'),
(1331,1,'Dabola'),
(1332,1,'Dalaba'),
(1333,1,'Dinguiraye'),
(1334,1,'Dubreka'),
(1335,1,'Faranah'),
(1336,1,'Forecariah'),
(1337,1,'Fria'),
(1338,1,'Gaoual'),
(1339,1,'Gueckedou'),
(1340,1,'Kankan'),
(1341,1,'Kerouane'),
(1342,1,'Kindia'),
(1343,1,'Kissidougou'),
(1344,1,'Koubia'),
(1345,1,'Koundara'),
(1346,1,'Kouroussa'),
(1347,1,'Labe'),
(1348,1,'Lelouma'),
(1349,1,'Lola'),
(1350,1,'Macenta'),
(1351,1,'Mali'),
(1352,1,'Mamou'),
(1353,1,'Mandiana'),
(1354,1,'Nzerekore'),
(1355,1,'Pita'),
(1356,1,'Siguiri'),
(1357,1,'Telimele'),
(1358,1,'Tougue'),
(1359,1,'Yomou'),
(1360,1,'Bafata Region'),
(1361,1,'Biombo Region'),
(1362,1,'Bissau Region'),
(1363,1,'Bolama Region'),
(1364,1,'Cacheu Region'),
(1365,1,'Gabu Region'),
(1366,1,'Oio Region'),
(1367,1,'Quinara Region'),
(1368,1,'Tombali Region'),
(1369,1,'Barima-Waini'),
(1370,1,'Cuyuni-Mazaruni'),
(1371,1,'Demerara-Mahaica'),
(1372,1,'East Berbice-Corentyne'),
(1373,1,'Essequibo Islands-West Demerara'),
(1374,1,'Mahaica-Berbice'),
(1375,1,'Pomeroon-Supenaam'),
(1376,1,'Potaro-Siparuni'),
(1377,1,'Upper Demerara-Berbice'),
(1378,1,'Upper Takutu-Upper Essequibo'),
(1379,1,'Artibonite'),
(1380,1,'Centre'),
(1381,1,'Grand\'Anse'),
(1382,1,'Nord'),
(1383,1,'Nord-Est'),
(1384,1,'Nord-Ouest'),
(1385,1,'Ouest'),
(1386,1,'Sud'),
(1387,1,'Sud-Est'),
(1388,1,'Flat Island'),
(1389,1,'McDonald Island'),
(1390,1,'Shag Island'),
(1391,1,'Heard Island'),
(1392,1,'Atlantida'),
(1393,1,'Choluteca'),
(1394,1,'Colon'),
(1395,1,'Comayagua'),
(1396,1,'Copan'),
(1397,1,'Cortes'),
(1398,1,'El Paraiso'),
(1399,1,'Francisco Morazan'),
(1400,1,'Gracias a Dios'),
(1401,1,'Intibuca'),
(1402,1,'Islas de la Bahia (Bay Islands)'),
(1403,1,'La Paz'),
(1404,1,'Lempira'),
(1405,1,'Ocotepeque'),
(1406,1,'Olancho'),
(1407,1,'Santa Barbara'),
(1408,1,'Valle'),
(1409,1,'Yoro'),
(1410,1,'Central and Western Hong Kong Island'),
(1411,1,'Eastern Hong Kong Island'),
(1412,1,'Southern Hong Kong Island'),
(1413,1,'Wan Chai Hong Kong Island'),
(1414,1,'Kowloon City Kowloon'),
(1415,1,'Kwun Tong Kowloon'),
(1416,1,'Sham Shui Po Kowloon'),
(1417,1,'Wong Tai Sin Kowloon'),
(1418,1,'Yau Tsim Mong Kowloon'),
(1419,1,'Islands New Territories'),
(1420,1,'Kwai Tsing New Territories'),
(1421,1,'North New Territories'),
(1422,1,'Sai Kung New Territories'),
(1423,1,'Sha Tin New Territories'),
(1424,1,'Tai Po New Territories'),
(1425,1,'Tsuen Wan New Territories'),
(1426,1,'Tuen Mun New Territories'),
(1427,1,'Yuen Long New Territories'),
(1428,1,'Bacs-Kiskun'),
(1429,1,'Baranya'),
(1430,1,'Bekes'),
(1431,1,'Bekescsaba'),
(1432,1,'Borsod-Abauj-Zemplen'),
(1433,1,'Budapest'),
(1434,1,'Csongrad'),
(1435,1,'Debrecen'),
(1436,1,'Dunaujvaros'),
(1437,1,'Eger'),
(1438,1,'Fejer'),
(1439,1,'Gyor'),
(1440,1,'Gyor-Moson-Sopron'),
(1441,1,'Hajdu-Bihar'),
(1442,1,'Heves'),
(1443,1,'Hodmezovasarhely'),
(1444,1,'Jasz-Nagykun-Szolnok'),
(1445,1,'Kaposvar'),
(1446,1,'Kecskemet'),
(1447,1,'Komarom-Esztergom'),
(1448,1,'Miskolc'),
(1449,1,'Nagykanizsa'),
(1450,1,'Nograd'),
(1451,1,'Nyiregyhaza'),
(1452,1,'Pecs'),
(1453,1,'Pest'),
(1454,1,'Somogy'),
(1455,1,'Sopron'),
(1456,1,'Szabolcs-Szatmar-Bereg'),
(1457,1,'Szeged'),
(1458,1,'Szekesfehervar'),
(1459,1,'Szolnok'),
(1460,1,'Szombathely'),
(1461,1,'Tatabanya'),
(1462,1,'Tolna'),
(1463,1,'Vas'),
(1464,1,'Veszprem'),
(1465,1,'Zala'),
(1466,1,'Zalaegerszeg'),
(1467,1,'Austurland'),
(1468,1,'Hofuoborgarsvaeoi'),
(1469,1,'Norourland eystra'),
(1470,1,'Norourland vestra'),
(1471,1,'Suourland'),
(1472,1,'Suournes'),
(1473,1,'Vestfiroir'),
(1474,1,'Vesturland'),
(1475,1,'Andaman and Nicobar Islands'),
(1476,1,'Andhra Pradesh'),
(1477,1,'Arunachal Pradesh'),
(1478,1,'Assam'),
(1479,1,'Bihar'),
(1480,1,'Chandigarh'),
(1481,1,'Dadra and Nagar Haveli'),
(1482,1,'Daman and Diu'),
(1483,1,'Delhi'),
(1484,1,'Goa'),
(1485,1,'Gujarat'),
(1486,1,'Haryana'),
(1487,1,'Himachal Pradesh'),
(1488,1,'Jammu and Kashmir'),
(1489,1,'Karnataka'),
(1490,1,'Kerala'),
(1491,1,'Lakshadweep Islands'),
(1492,1,'Madhya Pradesh'),
(1493,1,'Maharashtra'),
(1494,1,'Manipur'),
(1495,1,'Meghalaya'),
(1496,1,'Mizoram'),
(1497,1,'Nagaland'),
(1498,1,'Orissa'),
(1499,1,'Pondicherry'),
(1500,1,'Punjab'),
(1501,1,'Rajasthan'),
(1502,1,'Sikkim'),
(1503,1,'Tamil Nadu'),
(1504,1,'Tripura'),
(1505,1,'Uttar Pradesh'),
(1506,1,'West Bengal'),
(1507,1,'Aceh'),
(1508,1,'Bali'),
(1509,1,'Banten'),
(1510,1,'Bengkulu'),
(1511,1,'BoDeTaBek'),
(1512,1,'Gorontalo'),
(1513,1,'Jakarta Raya'),
(1514,1,'Jambi'),
(1515,1,'Jawa Barat'),
(1516,1,'Jawa Tengah'),
(1517,1,'Jawa Timur'),
(1518,1,'Kalimantan Barat'),
(1519,1,'Kalimantan Selatan'),
(1520,1,'Kalimantan Tengah'),
(1521,1,'Kalimantan Timur'),
(1522,1,'Kepulauan Bangka Belitung'),
(1523,1,'Lampung'),
(1524,1,'Maluku'),
(1525,1,'Maluku Utara'),
(1526,1,'Nusa Tenggara Barat'),
(1527,1,'Nusa Tenggara Timur'),
(1528,1,'Papua'),
(1529,1,'Riau'),
(1530,1,'Sulawesi Selatan'),
(1531,1,'Sulawesi Tengah'),
(1532,1,'Sulawesi Tenggara'),
(1533,1,'Sulawesi Utara'),
(1534,1,'Sumatera Barat'),
(1535,1,'Sumatera Selatan'),
(1536,1,'Sumatera Utara'),
(1537,1,'Yogyakarta'),
(1538,1,'Tehran'),
(1539,1,'Qom'),
(1540,1,'Markazi'),
(1541,1,'Qazvin'),
(1542,1,'Gilan'),
(1543,1,'Ardabil'),
(1544,1,'Zanjan'),
(1545,1,'East Azarbaijan'),
(1546,1,'West Azarbaijan'),
(1547,1,'Kurdistan'),
(1548,1,'Hamadan'),
(1549,1,'Kermanshah'),
(1550,1,'Ilam'),
(1551,1,'Lorestan'),
(1552,1,'Khuzestan'),
(1553,1,'Chahar Mahaal and Bakhtiari'),
(1554,1,'Kohkiluyeh and Buyer Ahmad'),
(1555,1,'Bushehr'),
(1556,1,'Fars'),
(1557,1,'Hormozgan'),
(1558,1,'Sistan and Baluchistan'),
(1559,1,'Kerman'),
(1560,1,'Yazd'),
(1561,1,'Esfahan'),
(1562,1,'Semnan'),
(1563,1,'Mazandaran'),
(1564,1,'Golestan'),
(1565,1,'North Khorasan'),
(1566,1,'Razavi Khorasan'),
(1567,1,'South Khorasan'),
(1568,1,'Baghdad'),
(1569,1,'Salah ad Din'),
(1570,1,'Diyala'),
(1571,1,'Wasit'),
(1572,1,'Maysan'),
(1573,1,'Al Basrah'),
(1574,1,'Dhi Qar'),
(1575,1,'Al Muthanna'),
(1576,1,'Al Qadisyah'),
(1577,1,'Babil'),
(1578,1,'Al Karbala'),
(1579,1,'An Najaf'),
(1580,1,'Al Anbar'),
(1581,1,'Ninawa'),
(1582,1,'Dahuk'),
(1583,1,'Arbil'),
(1584,1,'At Ta\'mim'),
(1585,1,'As Sulaymaniyah'),
(1586,1,'Carlow'),
(1587,1,'Cavan'),
(1588,1,'Clare'),
(1589,1,'Cork'),
(1590,1,'Donegal'),
(1591,1,'Dublin'),
(1592,1,'Galway'),
(1593,1,'Kerry'),
(1594,1,'Kildare'),
(1595,1,'Kilkenny'),
(1596,1,'Laois'),
(1597,1,'Leitrim'),
(1598,1,'Limerick'),
(1599,1,'Longford'),
(1600,1,'Louth'),
(1601,1,'Mayo'),
(1602,1,'Meath'),
(1603,1,'Monaghan'),
(1604,1,'Offaly'),
(1605,1,'Roscommon'),
(1606,1,'Sligo'),
(1607,1,'Tipperary'),
(1608,1,'Waterford'),
(1609,1,'Westmeath'),
(1610,1,'Wexford'),
(1611,1,'Wicklow'),
(1612,1,'Be\'er Sheva'),
(1613,1,'Bika\'at Hayarden'),
(1614,1,'Eilat and Arava'),
(1615,1,'Galil'),
(1616,1,'Haifa'),
(1617,1,'Jehuda Mountains'),
(1618,1,'Jerusalem'),
(1619,1,'Negev'),
(1620,1,'Semaria'),
(1621,1,'Sharon'),
(1622,1,'Tel Aviv (Gosh Dan)'),
(3860,1,'Caltanissetta'),
(3842,1,'Agrigento'),
(3843,1,'Alessandria'),
(3844,1,'Ancona'),
(3845,1,'Aosta'),
(3846,1,'Arezzo'),
(3847,1,'Ascoli Piceno'),
(3848,1,'Asti'),
(3849,1,'Avellino'),
(3850,1,'Bari'),
(3851,1,'Belluno'),
(3852,1,'Benevento'),
(3853,1,'Bergamo'),
(3854,1,'Biella'),
(3855,1,'Bologna'),
(3856,1,'Bolzano'),
(3857,1,'Brescia'),
(3858,1,'Brindisi'),
(3859,1,'Cagliari'),
(1643,1,'Clarendon Parish'),
(1644,1,'Hanover Parish'),
(1645,1,'Kingston Parish'),
(1646,1,'Manchester Parish'),
(1647,1,'Portland Parish'),
(1648,1,'Saint Andrew Parish'),
(1649,1,'Saint Ann Parish'),
(1650,1,'Saint Catherine Parish'),
(1651,1,'Saint Elizabeth Parish'),
(1652,1,'Saint James Parish'),
(1653,1,'Saint Mary Parish'),
(1654,1,'Saint Thomas Parish'),
(1655,1,'Trelawny Parish'),
(1656,1,'Westmoreland Parish'),
(1657,1,'Aichi'),
(1658,1,'Akita'),
(1659,1,'Aomori'),
(1660,1,'Chiba'),
(1661,1,'Ehime'),
(1662,1,'Fukui'),
(1663,1,'Fukuoka'),
(1664,1,'Fukushima'),
(1665,1,'Gifu'),
(1666,1,'Gumma'),
(1667,1,'Hiroshima'),
(1668,1,'Hokkaido'),
(1669,1,'Hyogo'),
(1670,1,'Ibaraki'),
(1671,1,'Ishikawa'),
(1672,1,'Iwate'),
(1673,1,'Kagawa'),
(1674,1,'Kagoshima'),
(1675,1,'Kanagawa'),
(1676,1,'Kochi'),
(1677,1,'Kumamoto'),
(1678,1,'Kyoto'),
(1679,1,'Mie'),
(1680,1,'Miyagi'),
(1681,1,'Miyazaki'),
(1682,1,'Nagano'),
(1683,1,'Nagasaki'),
(1684,1,'Nara'),
(1685,1,'Niigata'),
(1686,1,'Oita'),
(1687,1,'Okayama'),
(1688,1,'Okinawa'),
(1689,1,'Osaka'),
(1690,1,'Saga'),
(1691,1,'Saitama'),
(1692,1,'Shiga'),
(1693,1,'Shimane'),
(1694,1,'Shizuoka'),
(1695,1,'Tochigi'),
(1696,1,'Tokushima'),
(1697,1,'Tokyo'),
(1698,1,'Tottori'),
(1699,1,'Toyama'),
(1700,1,'Wakayama'),
(1701,1,'Yamagata'),
(1702,1,'Yamaguchi'),
(1703,1,'Yamanashi'),
(1704,1,'\'Amman'),
(1705,1,'Ajlun'),
(1706,1,'Al \'Aqabah'),
(1707,1,'Al Balqa\''),
(1708,1,'Al Karak'),
(1709,1,'Al Mafraq'),
(1710,1,'At Tafilah'),
(1711,1,'Az Zarqa\''),
(1712,1,'Irbid'),
(1713,1,'Jarash'),
(1714,1,'Ma\'an'),
(1715,1,'Madaba'),
(1716,1,'Almaty'),
(1717,1,'Almaty City'),
(1718,1,'Aqmola'),
(1719,1,'Aqtobe'),
(1720,1,'Astana City'),
(1721,1,'Atyrau'),
(1722,1,'Batys Qazaqstan'),
(1723,1,'Bayqongyr City'),
(1724,1,'Mangghystau'),
(1725,1,'Ongtustik Qazaqstan'),
(1726,1,'Pavlodar'),
(1727,1,'Qaraghandy'),
(1728,1,'Qostanay'),
(1729,1,'Qyzylorda'),
(1730,1,'Shyghys Qazaqstan'),
(1731,1,'Soltustik Qazaqstan'),
(1732,1,'Zhambyl'),
(1733,1,'Central'),
(1734,1,'Coast'),
(1735,1,'Eastern'),
(1736,1,'Nairobi Area'),
(1737,1,'North Eastern'),
(1738,1,'Nyanza'),
(1739,1,'Rift Valley'),
(1740,1,'Western'),
(1741,1,'Abaiang'),
(1742,1,'Abemama'),
(1743,1,'Aranuka'),
(1744,1,'Arorae'),
(1745,1,'Banaba'),
(1746,1,'Beru'),
(1747,1,'Butaritari'),
(1748,1,'Kanton'),
(1749,1,'Kiritimati'),
(1750,1,'Kuria'),
(1751,1,'Maiana'),
(1752,1,'Makin'),
(1753,1,'Marakei'),
(1754,1,'Nikunau'),
(1755,1,'Nonouti'),
(1756,1,'Onotoa'),
(1757,1,'Tabiteuea'),
(1758,1,'Tabuaeran'),
(1759,1,'Tamana'),
(1760,1,'Tarawa'),
(1761,1,'Teraina'),
(1762,1,'Chagang-do'),
(1763,1,'Hamgyong-bukto'),
(1764,1,'Hamgyong-namdo'),
(1765,1,'Hwanghae-bukto'),
(1766,1,'Hwanghae-namdo'),
(1767,1,'Kangwon-do'),
(1768,1,'P\'yongan-bukto'),
(1769,1,'P\'yongan-namdo'),
(1770,1,'Ryanggang-do (Yanggang-do)'),
(1771,1,'Rason Directly Governed City'),
(1772,1,'P\'yongyang Special City'),
(1773,1,'Ch\'ungch\'ong-bukto'),
(1774,1,'Ch\'ungch\'ong-namdo'),
(1775,1,'Cheju-do'),
(1776,1,'Cholla-bukto'),
(1777,1,'Cholla-namdo'),
(1778,1,'Inch\'on-gwangyoksi'),
(1779,1,'Kangwon-do'),
(1780,1,'Kwangju-gwangyoksi'),
(1781,1,'Kyonggi-do'),
(1782,1,'Kyongsang-bukto'),
(1783,1,'Kyongsang-namdo'),
(1784,1,'Pusan-gwangyoksi'),
(1785,1,'Soul-t\'ukpyolsi'),
(1786,1,'Taegu-gwangyoksi'),
(1787,1,'Taejon-gwangyoksi'),
(1788,1,'Al \'Asimah'),
(1789,1,'Al Ahmadi'),
(1790,1,'Al Farwaniyah'),
(1791,1,'Al Jahra\''),
(1792,1,'Hawalli'),
(1793,1,'Bishkek'),
(1794,1,'Batken'),
(1795,1,'Chu'),
(1796,1,'Jalal-Abad'),
(1797,1,'Naryn'),
(1798,1,'Osh'),
(1799,1,'Talas'),
(1800,1,'Ysyk-Kol'),
(1801,1,'Vientiane'),
(1802,1,'Attapu'),
(1803,1,'Bokeo'),
(1804,1,'Bolikhamxai'),
(1805,1,'Champasak'),
(1806,1,'Houaphan'),
(1807,1,'Khammouan'),
(1808,1,'Louang Namtha'),
(1809,1,'Louangphabang'),
(1810,1,'Oudomxai'),
(1811,1,'Phongsali'),
(1812,1,'Salavan'),
(1813,1,'Savannakhet'),
(1814,1,'Vientiane'),
(1815,1,'Xaignabouli'),
(1816,1,'Xekong'),
(1817,1,'Xiangkhoang'),
(1818,1,'Xaisomboun'),
(1819,1,'Aizkraukles Rajons'),
(1820,1,'Aluksnes Rajons'),
(1821,1,'Balvu Rajons'),
(1822,1,'Bauskas Rajons'),
(1823,1,'Cesu Rajons'),
(1824,1,'Daugavpils Rajons'),
(1825,1,'Dobeles Rajons'),
(1826,1,'Gulbenes Rajons'),
(1827,1,'Jekabpils Rajons'),
(1828,1,'Jelgavas Rajons'),
(1829,1,'Kraslavas Rajons'),
(1830,1,'Kuldigas Rajons'),
(1831,1,'Liepajas Rajons'),
(1832,1,'Limbazu Rajons'),
(1833,1,'Ludzas Rajons'),
(1834,1,'Madonas Rajons'),
(1835,1,'Ogres Rajons'),
(1836,1,'Preilu Rajons'),
(1837,1,'Rezeknes Rajons'),
(1838,1,'Rigas Rajons'),
(1839,1,'Saldus Rajons'),
(1840,1,'Talsu Rajons'),
(1841,1,'Tukuma Rajons'),
(1842,1,'Valkas Rajons'),
(1843,1,'Valmieras Rajons'),
(1844,1,'Ventspils Rajons'),
(1845,1,'Daugavpils'),
(1846,1,'Jelgava'),
(1847,1,'Jurmala'),
(1848,1,'Liepaja'),
(1849,1,'Rezekne'),
(1850,1,'Riga'),
(1851,1,'Ventspils'),
(1852,1,'Berea'),
(1853,1,'Butha-Buthe'),
(1854,1,'Leribe'),
(1855,1,'Mafeteng'),
(1856,1,'Maseru'),
(1857,1,'Mohale\'s Hoek'),
(1858,1,'Mokhotlong'),
(1859,1,'Qacha\'s Nek'),
(1860,1,'Quthing'),
(1861,1,'Thaba-Tseka'),
(1862,1,'Bomi'),
(1863,1,'Bong'),
(1864,1,'Grand Bassa'),
(1865,1,'Grand Cape Mount'),
(1866,1,'Grand Gedeh'),
(1867,1,'Grand Kru'),
(1868,1,'Lofa'),
(1869,1,'Margibi'),
(1870,1,'Maryland'),
(1871,1,'Montserrado'),
(1872,1,'Nimba'),
(1873,1,'River Cess'),
(1874,1,'Sinoe'),
(1875,1,'Ajdabiya'),
(1876,1,'Al \'Aziziyah'),
(1877,1,'Al Fatih'),
(1878,1,'Al Jabal al Akhdar'),
(1879,1,'Al Jufrah'),
(1880,1,'Al Khums'),
(1881,1,'Al Kufrah'),
(1882,1,'An Nuqat al Khams'),
(1883,1,'Ash Shati\''),
(1884,1,'Awbari'),
(1885,1,'Az Zawiyah'),
(1886,1,'Banghazi'),
(1887,1,'Darnah'),
(1888,1,'Ghadamis'),
(1889,1,'Gharyan'),
(1890,1,'Misratah'),
(1891,1,'Murzuq'),
(1892,1,'Sabha'),
(1893,1,'Sawfajjin'),
(1894,1,'Surt'),
(1895,1,'Tarabulus (Tripoli)'),
(1896,1,'Tarhunah'),
(1897,1,'Tubruq'),
(1898,1,'Yafran'),
(1899,1,'Zlitan'),
(1900,1,'Vaduz'),
(1901,1,'Schaan'),
(1902,1,'Balzers'),
(1903,1,'Triesen'),
(1904,1,'Eschen'),
(1905,1,'Mauren'),
(1906,1,'Triesenberg'),
(1907,1,'Ruggell'),
(1908,1,'Gamprin'),
(1909,1,'Schellenberg'),
(1910,1,'Planken'),
(1911,1,'Alytus'),
(1912,1,'Kaunas'),
(1913,1,'Klaipeda'),
(1914,1,'Marijampole'),
(1915,1,'Panevezys'),
(1916,1,'Siauliai'),
(1917,1,'Taurage'),
(1918,1,'Telsiai'),
(1919,1,'Utena'),
(1920,1,'Vilnius'),
(1921,1,'Diekirch'),
(1922,1,'Clervaux'),
(1923,1,'Redange'),
(1924,1,'Vianden'),
(1925,1,'Wiltz'),
(1926,1,'Grevenmacher'),
(1927,1,'Echternach'),
(1928,1,'Remich'),
(1929,1,'Luxembourg'),
(1930,1,'Capellen'),
(1931,1,'Esch-sur-Alzette'),
(1932,1,'Mersch'),
(1933,1,'Our Lady Fatima Parish'),
(1934,1,'St. Anthony Parish'),
(1935,1,'St. Lazarus Parish'),
(1936,1,'Cathedral Parish'),
(1937,1,'St. Lawrence Parish'),
(1938,1,'Antananarivo'),
(1939,1,'Antsiranana'),
(1940,1,'Fianarantsoa'),
(1941,1,'Mahajanga'),
(1942,1,'Toamasina'),
(1943,1,'Toliara'),
(1944,1,'Balaka'),
(1945,1,'Blantyre'),
(1946,1,'Chikwawa'),
(1947,1,'Chiradzulu'),
(1948,1,'Chitipa'),
(1949,1,'Dedza'),
(1950,1,'Dowa'),
(1951,1,'Karonga'),
(1952,1,'Kasungu'),
(1953,1,'Likoma'),
(1954,1,'Lilongwe'),
(1955,1,'Machinga'),
(1956,1,'Mangochi'),
(1957,1,'Mchinji'),
(1958,1,'Mulanje'),
(1959,1,'Mwanza'),
(1960,1,'Mzimba'),
(1961,1,'Ntcheu'),
(1962,1,'Nkhata Bay'),
(1963,1,'Nkhotakota'),
(1964,1,'Nsanje'),
(1965,1,'Ntchisi'),
(1966,1,'Phalombe'),
(1967,1,'Rumphi'),
(1968,1,'Salima'),
(1969,1,'Thyolo'),
(1970,1,'Zomba'),
(1971,1,'Johor'),
(1972,1,'Kedah'),
(1973,1,'Kelantan'),
(1974,1,'Labuan'),
(1975,1,'Melaka'),
(1976,1,'Negeri Sembilan'),
(1977,1,'Pahang'),
(1978,1,'Perak'),
(1979,1,'Perlis'),
(1980,1,'Pulau Pinang'),
(1981,1,'Sabah'),
(1982,1,'Sarawak'),
(1983,1,'Selangor'),
(1984,1,'Terengganu'),
(1985,1,'Wilayah Persekutuan'),
(1986,1,'Thiladhunmathi Uthuru'),
(1987,1,'Thiladhunmathi Dhekunu'),
(1988,1,'Miladhunmadulu Uthuru'),
(1989,1,'Miladhunmadulu Dhekunu'),
(1990,1,'Maalhosmadulu Uthuru'),
(1991,1,'Maalhosmadulu Dhekunu'),
(1992,1,'Faadhippolhu'),
(1993,1,'Male Atoll'),
(1994,1,'Ari Atoll Uthuru'),
(1995,1,'Ari Atoll Dheknu'),
(1996,1,'Felidhe Atoll'),
(1997,1,'Mulaku Atoll'),
(1998,1,'Nilandhe Atoll Uthuru'),
(1999,1,'Nilandhe Atoll Dhekunu'),
(2000,1,'Kolhumadulu'),
(2001,1,'Hadhdhunmathi'),
(2002,1,'Huvadhu Atoll Uthuru'),
(2003,1,'Huvadhu Atoll Dhekunu'),
(2004,1,'Fua Mulaku'),
(2005,1,'Addu'),
(2006,1,'Gao'),
(2007,1,'Kayes'),
(2008,1,'Kidal'),
(2009,1,'Koulikoro'),
(2010,1,'Mopti'),
(2011,1,'Segou'),
(2012,1,'Sikasso'),
(2013,1,'Tombouctou'),
(2014,1,'Bamako Capital District'),
(2015,1,'Attard'),
(2016,1,'Balzan'),
(2017,1,'Birgu'),
(2018,1,'Birkirkara'),
(2019,1,'Birzebbuga'),
(2020,1,'Bormla'),
(2021,1,'Dingli'),
(2022,1,'Fgura'),
(2023,1,'Floriana'),
(2024,1,'Gudja'),
(2025,1,'Gzira'),
(2026,1,'Gargur'),
(2027,1,'Gaxaq'),
(2028,1,'Hamrun'),
(2029,1,'Iklin'),
(2030,1,'Isla'),
(2031,1,'Kalkara'),
(2032,1,'Kirkop'),
(2033,1,'Lija'),
(2034,1,'Luqa'),
(2035,1,'Marsa'),
(2036,1,'Marsaskala'),
(2037,1,'Marsaxlokk'),
(2038,1,'Mdina'),
(2039,1,'Melliea'),
(2040,1,'Mgarr'),
(2041,1,'Mosta'),
(2042,1,'Mqabba'),
(2043,1,'Msida'),
(2044,1,'Mtarfa'),
(2045,1,'Naxxar'),
(2046,1,'Paola'),
(2047,1,'Pembroke'),
(2048,1,'Pieta'),
(2049,1,'Qormi'),
(2050,1,'Qrendi'),
(2051,1,'Rabat'),
(2052,1,'Safi'),
(2053,1,'San Giljan'),
(2054,1,'Santa Lucija'),
(2055,1,'San Pawl il-Bahar'),
(2056,1,'San Gwann'),
(2057,1,'Santa Venera'),
(2058,1,'Siggiewi'),
(2059,1,'Sliema'),
(2060,1,'Swieqi'),
(2061,1,'Ta Xbiex'),
(2062,1,'Tarxien'),
(2063,1,'Valletta'),
(2064,1,'Xgajra'),
(2065,1,'Zabbar'),
(2066,1,'Zebbug'),
(2067,1,'Zejtun'),
(2068,1,'Zurrieq'),
(2069,1,'Fontana'),
(2070,1,'Ghajnsielem'),
(2071,1,'Gharb'),
(2072,1,'Ghasri'),
(2073,1,'Kercem'),
(2074,1,'Munxar'),
(2075,1,'Nadur'),
(2076,1,'Qala'),
(2077,1,'Victoria'),
(2078,1,'San Lawrenz'),
(2079,1,'Sannat'),
(2080,1,'Xagra'),
(2081,1,'Xewkija'),
(2082,1,'Zebbug'),
(2083,1,'Ailinginae'),
(2084,1,'Ailinglaplap'),
(2085,1,'Ailuk'),
(2086,1,'Arno'),
(2087,1,'Aur'),
(2088,1,'Bikar'),
(2089,1,'Bikini'),
(2090,1,'Bokak'),
(2091,1,'Ebon'),
(2092,1,'Enewetak'),
(2093,1,'Erikub'),
(2094,1,'Jabat'),
(2095,1,'Jaluit'),
(2096,1,'Jemo'),
(2097,1,'Kili'),
(2098,1,'Kwajalein'),
(2099,1,'Lae'),
(2100,1,'Lib'),
(2101,1,'Likiep'),
(2102,1,'Majuro'),
(2103,1,'Maloelap'),
(2104,1,'Mejit'),
(2105,1,'Mili'),
(2106,1,'Namorik'),
(2107,1,'Namu'),
(2108,1,'Rongelap'),
(2109,1,'Rongrik'),
(2110,1,'Toke'),
(2111,1,'Ujae'),
(2112,1,'Ujelang'),
(2113,1,'Utirik'),
(2114,1,'Wotho'),
(2115,1,'Wotje'),
(2116,1,'Adrar'),
(2117,1,'Assaba'),
(2118,1,'Brakna'),
(2119,1,'Dakhlet Nouadhibou'),
(2120,1,'Gorgol'),
(2121,1,'Guidimaka'),
(2122,1,'Hodh Ech Chargui'),
(2123,1,'Hodh El Gharbi'),
(2124,1,'Inchiri'),
(2125,1,'Tagant'),
(2126,1,'Tiris Zemmour'),
(2127,1,'Trarza'),
(2128,1,'Nouakchott'),
(2129,1,'Beau Bassin-Rose Hill'),
(2130,1,'Curepipe'),
(2131,1,'Port Louis'),
(2132,1,'Quatre Bornes'),
(2133,1,'Vacoas-Phoenix'),
(2134,1,'Agalega Islands'),
(2135,1,'Cargados Carajos Shoals (Saint Brandon Islands)'),
(2136,1,'Rodrigues'),
(2137,1,'Black River'),
(2138,1,'Flacq'),
(2139,1,'Grand Port'),
(2140,1,'Moka'),
(2141,1,'Pamplemousses'),
(2142,1,'Plaines Wilhems'),
(2143,1,'Port Louis'),
(2144,1,'Riviere du Rempart'),
(2145,1,'Savanne'),
(2146,1,'Baja California Norte'),
(2147,1,'Baja California Sur'),
(2148,1,'Campeche'),
(2149,1,'Chiapas'),
(2150,1,'Chihuahua'),
(2151,1,'Coahuila de Zaragoza'),
(2152,1,'Colima'),
(2153,1,'Distrito Federal'),
(2154,1,'Durango'),
(2155,1,'Guanajuato'),
(2156,1,'Guerrero'),
(2157,1,'Hidalgo'),
(2158,1,'Jalisco'),
(2159,1,'Mexico'),
(2160,1,'Michoacan de Ocampo'),
(2161,1,'Morelos'),
(2162,1,'Nayarit'),
(2163,1,'Nuevo Leon'),
(2164,1,'Oaxaca'),
(2165,1,'Puebla'),
(2166,1,'Queretaro de Arteaga'),
(2167,1,'Quintana Roo'),
(2168,1,'San Luis Potosi'),
(2169,1,'Sinaloa'),
(2170,1,'Sonora'),
(2171,1,'Tabasco'),
(2172,1,'Tamaulipas'),
(2173,1,'Tlaxcala'),
(2174,1,'Veracruz-Llave'),
(2175,1,'Yucatan'),
(2176,1,'Zacatecas'),
(2177,1,'Chuuk'),
(2178,1,'Kosrae'),
(2179,1,'Pohnpei'),
(2180,1,'Yap'),
(2181,1,'Gagauzia'),
(2182,1,'Chisinau'),
(2183,1,'Balti'),
(2184,1,'Cahul'),
(2185,1,'Edinet'),
(2186,1,'Lapusna'),
(2187,1,'Orhei'),
(2188,1,'Soroca'),
(2189,1,'Tighina'),
(2190,1,'Ungheni'),
(2191,1,'St‚nga Nistrului'),
(2192,1,'Fontvieille'),
(2193,1,'La Condamine'),
(2194,1,'Monaco-Ville'),
(2195,1,'Monte-Carlo'),
(2196,1,'Ulanbaatar'),
(2197,1,'Orhon'),
(2198,1,'Darhan uul'),
(2199,1,'Hentiy'),
(2200,1,'Hovsgol'),
(2201,1,'Hovd'),
(2202,1,'Uvs'),
(2203,1,'Tov'),
(2204,1,'Selenge'),
(2205,1,'Suhbaatar'),
(2206,1,'Omnogovi'),
(2207,1,'Ovorhangay'),
(2208,1,'Dzavhan'),
(2209,1,'DundgovL'),
(2210,1,'Dornod'),
(2211,1,'Dornogov'),
(2212,1,'Govi-Sumber'),
(2213,1,'Govi-Altay'),
(2214,1,'Bulgan'),
(2215,1,'Bayanhongor'),
(2216,1,'Bayan-Olgiy'),
(2217,1,'Arhangay'),
(2218,1,'Saint Anthony'),
(2219,1,'Saint Georges'),
(2220,1,'Saint Peter'),
(2221,1,'Agadir'),
(2222,1,'Al Hoceima'),
(2223,1,'Azilal'),
(2224,1,'Beni Mellal'),
(2225,1,'Ben Slimane'),
(2226,1,'Boulemane'),
(2227,1,'Casablanca'),
(2228,1,'Chaouen'),
(2229,1,'El Jadida'),
(2230,1,'El Kelaa des Sraghna'),
(2231,1,'Er Rachidia'),
(2232,1,'Essaouira'),
(2233,1,'Fes'),
(2234,1,'Figuig'),
(2235,1,'Guelmim'),
(2236,1,'Ifrane'),
(2237,1,'Kenitra'),
(2238,1,'Khemisset'),
(2239,1,'Khenifra'),
(2240,1,'Khouribga'),
(2241,1,'Laayoune'),
(2242,1,'Larache'),
(2243,1,'Marrakech'),
(2244,1,'Meknes'),
(2245,1,'Nador'),
(2246,1,'Ouarzazate'),
(2247,1,'Oujda'),
(2248,1,'Rabat-Sale'),
(2249,1,'Safi'),
(2250,1,'Settat'),
(2251,1,'Sidi Kacem'),
(2252,1,'Tangier'),
(2253,1,'Tan-Tan'),
(2254,1,'Taounate'),
(2255,1,'Taroudannt'),
(2256,1,'Tata'),
(2257,1,'Taza'),
(2258,1,'Tetouan'),
(2259,1,'Tiznit'),
(2260,1,'Ad Dakhla'),
(2261,1,'Boujdour'),
(2262,1,'Es Smara'),
(2263,1,'Cabo Delgado'),
(2264,1,'Gaza'),
(2265,1,'Inhambane'),
(2266,1,'Manica'),
(2267,1,'Maputo (city)'),
(2268,1,'Maputo'),
(2269,1,'Nampula'),
(2270,1,'Niassa'),
(2271,1,'Sofala'),
(2272,1,'Tete'),
(2273,1,'Zambezia'),
(2274,1,'Ayeyarwady'),
(2275,1,'Bago'),
(2276,1,'Magway'),
(2277,1,'Mandalay'),
(2278,1,'Sagaing'),
(2279,1,'Tanintharyi'),
(2280,1,'Yangon'),
(2281,1,'Chin State'),
(2282,1,'Kachin State'),
(2283,1,'Kayah State'),
(2284,1,'Kayin State'),
(2285,1,'Mon State'),
(2286,1,'Rakhine State'),
(2287,1,'Shan State'),
(2288,1,'Caprivi'),
(2289,1,'Erongo'),
(2290,1,'Hardap'),
(2291,1,'Karas'),
(2292,1,'Kavango'),
(2293,1,'Khomas'),
(2294,1,'Kunene'),
(2295,1,'Ohangwena'),
(2296,1,'Omaheke'),
(2297,1,'Omusati'),
(2298,1,'Oshana'),
(2299,1,'Oshikoto'),
(2300,1,'Otjozondjupa'),
(2301,1,'Aiwo'),
(2302,1,'Anabar'),
(2303,1,'Anetan'),
(2304,1,'Anibare'),
(2305,1,'Baiti'),
(2306,1,'Boe'),
(2307,1,'Buada'),
(2308,1,'Denigomodu'),
(2309,1,'Ewa'),
(2310,1,'Ijuw'),
(2311,1,'Meneng'),
(2312,1,'Nibok'),
(2313,1,'Uaboe'),
(2314,1,'Yaren'),
(2315,1,'Bagmati'),
(2316,1,'Bheri'),
(2317,1,'Dhawalagiri'),
(2318,1,'Gandaki'),
(2319,1,'Janakpur'),
(2320,1,'Karnali'),
(2321,1,'Kosi'),
(2322,1,'Lumbini'),
(2323,1,'Mahakali'),
(2324,1,'Mechi'),
(2325,1,'Narayani'),
(2326,1,'Rapti'),
(2327,1,'Sagarmatha'),
(2328,1,'Seti'),
(2329,1,'Drenthe'),
(2330,1,'Flevoland'),
(2331,1,'Friesland'),
(2332,1,'Gelderland'),
(2333,1,'Groningen'),
(2334,1,'Limburg'),
(2335,1,'Noord Brabant'),
(2336,1,'Noord Holland'),
(2337,1,'Overijssel'),
(2338,1,'Utrecht'),
(2339,1,'Zeeland'),
(2340,1,'Zuid Holland'),
(2341,1,'Iles Loyaute'),
(2342,1,'Nord'),
(2343,1,'Sud'),
(2344,1,'Auckland'),
(2345,1,'Bay of Plenty'),
(2346,1,'Canterbury'),
(2347,1,'Coromandel'),
(2348,1,'Gisborne'),
(2349,1,'Fiordland'),
(2350,1,'Hawke\'s Bay'),
(2351,1,'Marlborough'),
(2352,1,'Manawatu-Wanganui'),
(2353,1,'Mt Cook-Mackenzie'),
(2354,1,'Nelson'),
(2355,1,'Northland'),
(2356,1,'Otago'),
(2357,1,'Southland'),
(2358,1,'Taranaki'),
(2359,1,'Wellington'),
(2360,1,'Waikato'),
(2361,1,'Wairprarapa'),
(2362,1,'West Coast'),
(2363,1,'Atlantico Norte'),
(2364,1,'Atlantico Sur'),
(2365,1,'Boaco'),
(2366,1,'Carazo'),
(2367,1,'Chinandega'),
(2368,1,'Chontales'),
(2369,1,'Esteli'),
(2370,1,'Granada'),
(2371,1,'Jinotega'),
(2372,1,'Leon'),
(2373,1,'Madriz'),
(2374,1,'Managua'),
(2375,1,'Masaya'),
(2376,1,'Matagalpa'),
(2377,1,'Nuevo Segovia'),
(2378,1,'Rio San Juan'),
(2379,1,'Rivas'),
(2380,1,'Agadez'),
(2381,1,'Diffa'),
(2382,1,'Dosso'),
(2383,1,'Maradi'),
(2384,1,'Niamey'),
(2385,1,'Tahoua'),
(2386,1,'Tillaberi'),
(2387,1,'Zinder'),
(2388,1,'Abia'),
(2389,1,'Abuja Federal Capital Territory'),
(2390,1,'Adamawa'),
(2391,1,'Akwa Ibom'),
(2392,1,'Anambra'),
(2393,1,'Bauchi'),
(2394,1,'Bayelsa'),
(2395,1,'Benue'),
(2396,1,'Borno'),
(2397,1,'Cross River'),
(2398,1,'Delta'),
(2399,1,'Ebonyi'),
(2400,1,'Edo'),
(2401,1,'Ekiti'),
(2402,1,'Enugu'),
(2403,1,'Gombe'),
(2404,1,'Imo'),
(2405,1,'Jigawa'),
(2406,1,'Kaduna'),
(2407,1,'Kano'),
(2408,1,'Katsina'),
(2409,1,'Kebbi'),
(2410,1,'Kogi'),
(2411,1,'Kwara'),
(2412,1,'Lagos'),
(2413,1,'Nassarawa'),
(2414,1,'Niger'),
(2415,1,'Ogun'),
(2416,1,'Ondo'),
(2417,1,'Osun'),
(2418,1,'Oyo'),
(2419,1,'Plateau'),
(2420,1,'Rivers'),
(2421,1,'Sokoto'),
(2422,1,'Taraba'),
(2423,1,'Yobe'),
(2424,1,'Zamfara'),
(2425,1,'Northern Islands'),
(2426,1,'Rota'),
(2427,1,'Saipan'),
(2428,1,'Tinian'),
(2429,1,'Akershus'),
(2430,1,'Aust-Agder'),
(2431,1,'Buskerud'),
(2432,1,'Finnmark'),
(2433,1,'Hedmark'),
(2434,1,'Hordaland'),
(2435,1,'More og Romdal'),
(2436,1,'Nord-Trondelag'),
(2437,1,'Nordland'),
(2438,1,'Ostfold'),
(2439,1,'Oppland'),
(2440,1,'Oslo'),
(2441,1,'Rogaland'),
(2442,1,'Sor-Trondelag'),
(2443,1,'Sogn og Fjordane'),
(2444,1,'Svalbard'),
(2445,1,'Telemark'),
(2446,1,'Troms'),
(2447,1,'Vest-Agder'),
(2448,1,'Vestfold'),
(2449,1,'Ad Dakhiliyah'),
(2450,1,'Al Batinah'),
(2451,1,'Al Wusta'),
(2452,1,'Ash Sharqiyah'),
(2453,1,'Az Zahirah'),
(2454,1,'Masqat'),
(2455,1,'Musandam'),
(2456,1,'Zufar'),
(2457,1,'Balochistan'),
(2458,1,'Federally Administered Tribal Areas'),
(2459,1,'Islamabad Capital Territory'),
(2460,1,'North-West Frontier'),
(2461,1,'Punjab'),
(2462,1,'Sindh'),
(2463,1,'Aimeliik'),
(2464,1,'Airai'),
(2465,1,'Angaur'),
(2466,1,'Hatohobei'),
(2467,1,'Kayangel'),
(2468,1,'Koror'),
(2469,1,'Melekeok'),
(2470,1,'Ngaraard'),
(2471,1,'Ngarchelong'),
(2472,1,'Ngardmau'),
(2473,1,'Ngatpang'),
(2474,1,'Ngchesar'),
(2475,1,'Ngeremlengui'),
(2476,1,'Ngiwal'),
(2477,1,'Peleliu'),
(2478,1,'Sonsorol'),
(2479,1,'Bocas del Toro'),
(2480,1,'Chiriqui'),
(2481,1,'Cocle'),
(2482,1,'Colon'),
(2483,1,'Darien'),
(2484,1,'Herrera'),
(2485,1,'Los Santos'),
(2486,1,'Panama'),
(2487,1,'San Blas'),
(2488,1,'Veraguas'),
(2489,1,'Bougainville'),
(2490,1,'Central'),
(2491,1,'Chimbu'),
(2492,1,'Eastern Highlands'),
(2493,1,'East New Britain'),
(2494,1,'East Sepik'),
(2495,1,'Enga'),
(2496,1,'Gulf'),
(2497,1,'Madang'),
(2498,1,'Manus'),
(2499,1,'Milne Bay'),
(2500,1,'Morobe'),
(2501,1,'National Capital'),
(2502,1,'New Ireland'),
(2503,1,'Northern'),
(2504,1,'Sandaun'),
(2505,1,'Southern Highlands'),
(2506,1,'Western'),
(2507,1,'Western Highlands'),
(2508,1,'West New Britain'),
(2509,1,'Alto Paraguay'),
(2510,1,'Alto Parana'),
(2511,1,'Amambay'),
(2512,1,'Asuncion'),
(2513,1,'Boqueron'),
(2514,1,'Caaguazu'),
(2515,1,'Caazapa'),
(2516,1,'Canindeyu'),
(2517,1,'Central'),
(2518,1,'Concepcion'),
(2519,1,'Cordillera'),
(2520,1,'Guaira'),
(2521,1,'Itapua'),
(2522,1,'Misiones'),
(2523,1,'Neembucu'),
(2524,1,'Paraguari'),
(2525,1,'Presidente Hayes'),
(2526,1,'San Pedro'),
(2527,1,'Amazonas'),
(2528,1,'Ancash'),
(2529,1,'Apurimac'),
(2530,1,'Arequipa'),
(2531,1,'Ayacucho'),
(2532,1,'Cajamarca'),
(2533,1,'Callao'),
(2534,1,'Cusco'),
(2535,1,'Huancavelica'),
(2536,1,'Huanuco'),
(2537,1,'Ica'),
(2538,1,'Junin'),
(2539,1,'La Libertad'),
(2540,1,'Lambayeque'),
(2541,1,'Lima'),
(2542,1,'Loreto'),
(2543,1,'Madre de Dios'),
(2544,1,'Moquegua'),
(2545,1,'Pasco'),
(2546,1,'Piura'),
(2547,1,'Puno'),
(2548,1,'San Martin'),
(2549,1,'Tacna'),
(2550,1,'Tumbes'),
(2551,1,'Ucayali'),
(2552,1,'Abra'),
(2553,1,'Agusan del Norte'),
(2554,1,'Agusan del Sur'),
(2555,1,'Aklan'),
(2556,1,'Albay'),
(2557,1,'Antique'),
(2558,1,'Apayao'),
(2559,1,'Aurora'),
(2560,1,'Basilan'),
(2561,1,'Bataan'),
(2562,1,'Batanes'),
(2563,1,'Batangas'),
(2564,1,'Biliran'),
(2565,1,'Benguet'),
(2566,1,'Bohol'),
(2567,1,'Bukidnon'),
(2568,1,'Bulacan'),
(2569,1,'Cagayan'),
(2570,1,'Camarines Norte'),
(2571,1,'Camarines Sur'),
(2572,1,'Camiguin'),
(2573,1,'Capiz'),
(2574,1,'Catanduanes'),
(2575,1,'Cavite'),
(2576,1,'Cebu'),
(2577,1,'Compostela'),
(2578,1,'Davao del Norte'),
(2579,1,'Davao del Sur'),
(2580,1,'Davao Oriental'),
(2581,1,'Eastern Samar'),
(2582,1,'Guimaras'),
(2583,1,'Ifugao'),
(2584,1,'Ilocos Norte'),
(2585,1,'Ilocos Sur'),
(2586,1,'Iloilo'),
(2587,1,'Isabela'),
(2588,1,'Kalinga'),
(2589,1,'Laguna'),
(2590,1,'Lanao del Norte'),
(2591,1,'Lanao del Sur'),
(2592,1,'La Union'),
(2593,1,'Leyte'),
(2594,1,'Maguindanao'),
(2595,1,'Marinduque'),
(2596,1,'Masbate'),
(2597,1,'Mindoro Occidental'),
(2598,1,'Mindoro Oriental'),
(2599,1,'Misamis Occidental'),
(2600,1,'Misamis Oriental'),
(2601,1,'Mountain'),
(2602,1,'Negros Occidental'),
(2603,1,'Negros Oriental'),
(2604,1,'North Cotabato'),
(2605,1,'Northern Samar'),
(2606,1,'Nueva Ecija'),
(2607,1,'Nueva Vizcaya'),
(2608,1,'Palawan'),
(2609,1,'Pampanga'),
(2610,1,'Pangasinan'),
(2611,1,'Quezon'),
(2612,1,'Quirino'),
(2613,1,'Rizal'),
(2614,1,'Romblon'),
(2615,1,'Samar'),
(2616,1,'Sarangani'),
(2617,1,'Siquijor'),
(2618,1,'Sorsogon'),
(2619,1,'South Cotabato'),
(2620,1,'Southern Leyte'),
(2621,1,'Sultan Kudarat'),
(2622,1,'Sulu'),
(2623,1,'Surigao del Norte'),
(2624,1,'Surigao del Sur'),
(2625,1,'Tarlac'),
(2626,1,'Tawi-Tawi'),
(2627,1,'Zambales'),
(2628,1,'Zamboanga del Norte'),
(2629,1,'Zamboanga del Sur'),
(2630,1,'Zamboanga Sibugay'),
(2631,1,'Dolnoslaskie'),
(2632,1,'Kujawsko-Pomorskie'),
(2633,1,'Lodzkie'),
(2634,1,'Lubelskie'),
(2635,1,'Lubuskie'),
(2636,1,'Malopolskie'),
(2637,1,'Mazowieckie'),
(2638,1,'Opolskie'),
(2639,1,'Podkarpackie'),
(2640,1,'Podlaskie'),
(2641,1,'Pomorskie'),
(2642,1,'Slaskie'),
(2643,1,'Swietokrzyskie'),
(2644,1,'Warminsko-Mazurskie'),
(2645,1,'Wielkopolskie'),
(2646,1,'Zachodniopomorskie'),
(2647,1,'Saint Pierre'),
(2648,1,'Miquelon'),
(2649,1,'A&ccedil;ores'),
(2650,1,'Aveiro'),
(2651,1,'Beja'),
(2652,1,'Braga'),
(2653,1,'Bragan&ccedil;a'),
(2654,1,'Castelo Branco'),
(2655,1,'Coimbra'),
(2656,1,'&Eacute;vora'),
(2657,1,'Faro'),
(2658,1,'Guarda'),
(2659,1,'Leiria'),
(2660,1,'Lisboa'),
(2661,1,'Madeira'),
(2662,1,'Portalegre'),
(2663,1,'Porto'),
(2664,1,'Santar&eacute;m'),
(2665,1,'Set&uacute;bal'),
(2666,1,'Viana do Castelo'),
(2667,1,'Vila Real'),
(2668,1,'Viseu'),
(2669,1,'Ad Dawhah'),
(2670,1,'Al Ghuwayriyah'),
(2671,1,'Al Jumayliyah'),
(2672,1,'Al Khawr'),
(2673,1,'Al Wakrah'),
(2674,1,'Ar Rayyan'),
(2675,1,'Jarayan al Batinah'),
(2676,1,'Madinat ash Shamal'),
(2677,1,'Umm Sa\'id'),
(2678,1,'Umm Salal'),
(2679,1,'Alba'),
(2680,1,'Arad'),
(2681,1,'Arges'),
(2682,1,'Bacau'),
(2683,1,'Bihor'),
(2684,1,'Bistrita-Nasaud'),
(2685,1,'Botosani'),
(2686,1,'Brasov'),
(2687,1,'Braila'),
(2688,1,'Bucuresti'),
(2689,1,'Buzau'),
(2690,1,'Caras-Severin'),
(2691,1,'Calarasi'),
(2692,1,'Cluj'),
(2693,1,'Constanta'),
(2694,1,'Covasna'),
(2695,1,'Dimbovita'),
(2696,1,'Dolj'),
(2697,1,'Galati'),
(2698,1,'Giurgiu'),
(2699,1,'Gorj'),
(2700,1,'Harghita'),
(2701,1,'Hunedoara'),
(2702,1,'Ialomita'),
(2703,1,'Iasi'),
(2704,1,'Ilfov'),
(2705,1,'Maramures'),
(2706,1,'Mehedinti'),
(2707,1,'Mures'),
(2708,1,'Neamt'),
(2709,1,'Olt'),
(2710,1,'Prahova'),
(2711,1,'Satu-Mare'),
(2712,1,'Salaj'),
(2713,1,'Sibiu'),
(2714,1,'Suceava'),
(2715,1,'Teleorman'),
(2716,1,'Timis'),
(2717,1,'Tulcea'),
(2718,1,'Vaslui'),
(2719,1,'Valcea'),
(2720,1,'Vrancea'),
(2721,1,'Republic of Khakassia'),
(2722,1,'Aginsky Buryatsky AO'),
(2723,1,'Chukotka Autonomous Okrug'),
(2724,1,'Arkhangelsk Region'),
(2725,1,'Astrakhan Oblast'),
(2726,1,'Altai Krai'),
(2727,1,'Belgorod Oblast'),
(2728,1,'Jewish Autonomous Oblast'),
(2729,1,'Amur Region'),
(2730,1,'Bryansk Oblast'),
(2731,1,'Chuvash Republic'),
(2732,1,'Chelyabinsk Region'),
(2733,1,'Karachay-Cherkess Republic'),
(2734,1,'Zabaykalsky Krai'),
(2735,1,'Taymyr Dolgano-Nenets Autonomous Okrug'),
(2736,1,'Republic of Kalmykia'),
(2737,1,'Moscow Oblast'),
(2738,1,'Altai Republic'),
(2739,1,'Chechen Republic'),
(2740,1,'Irkutsk Oblast'),
(2741,1,'Ivanovo Oblast'),
(2742,1,'Udmurtia'),
(2743,1,'Kaliningrad Oblast'),
(2744,1,'Kaluzhskaya oblast'),
(2745,1,'Kirov Oblast'),
(2746,1,'Republic of Tatarstan'),
(2747,1,'Kemerovo region'),
(2748,1,'Khabarovsk Krai'),
(2749,1,'Khanty–Mansi Autonomous Okrug – Yugra'),
(2750,1,'Kostroma Oblast'),
(2751,1,'Krasnodar Krai'),
(2752,1,'Krasnoyarsk Krai'),
(2753,1,'Komi-Permyatsky AO'),
(2754,1,'Kurgan Oblast'),
(2755,1,'Kursk Region'),
(2756,1,'Respublika Tyva'),
(2757,1,'Lipetsk Region'),
(2758,1,'Magadan Oblast'),
(2759,1,'Republic of Dagestan'),
(2760,1,'Republic of Adygea'),
(2761,1,'Moscow'),
(2762,1,'Murmansk Oblast'),
(2763,1,'Kabardino-Balkar Republic'),
(2764,1,'Nenets Autonomous Okrug'),
(2765,1,'Republic of Ingushetia'),
(2766,1,'Nizhegorodskaya oblast'),
(2767,1,'Novgorod Oblast'),
(2768,1,'Novosibirsk Oblast'),
(2769,1,'Omsk Oblast'),
(2770,1,'Oryol Oblast'),
(2771,1,'Orenburg Oblast'),
(2772,1,'Leningrad Oblast'),
(2773,1,'Penza Oblast'),
(2774,1,'Perm Krai'),
(2775,1,'Kamchatka Krai'),
(2776,1,'Republic of Karelia'),
(2777,1,'Pskov Oblast'),
(2778,1,'Rostov Region'),
(2779,1,'Ryazan Oblast'),
(2780,1,'Yamalo-Nenets Autonomous Okrug'),
(2781,1,'Samara Region'),
(2782,1,'Republic of Mordovia'),
(2783,1,'Saratov Region'),
(2784,1,'Smolensk Oblast'),
(2785,1,'Saint Petersburg'),
(2786,1,'Stavropol Krai'),
(2787,1,'Komi Republic'),
(2788,1,'Tambov Region'),
(2789,1,'Tomsk Oblast'),
(2790,1,'Tula Region'),
(2791,1,'Evenkysky AO'),
(2792,1,'Tver Oblast'),
(2793,1,'Tyumen Oblast'),
(2794,1,'Republic of Bashkortostan'),
(2795,1,'Ulyanovsk Oblast'),
(2796,1,'Republic of Buryatia'),
(2797,1,'Ust-Orda Buryat Okrug'),
(2798,1,'North Ossetia-Alania'),
(2799,1,'Vladimir Oblast'),
(2800,1,'Primorsky Krai'),
(2801,1,'Volgograd Oblast'),
(2802,1,'Vologda Oblast'),
(2803,1,'Voronezh Oblast'),
(2804,1,'Sakhalin Oblast'),
(2805,1,'Sakha Republic'),
(2806,1,'Yaroslavl Oblast'),
(2807,1,'Sverdlovsk Oblast'),
(2808,1,'Mari El Republic'),
(2809,1,'Butare'),
(2810,1,'Byumba'),
(2811,1,'Cyangugu'),
(2812,1,'Gikongoro'),
(2813,1,'Gisenyi'),
(2814,1,'Gitarama'),
(2815,1,'Kibungo'),
(2816,1,'Kibuye'),
(2817,1,'Kigali Rurale'),
(2818,1,'Kigali-ville'),
(2819,1,'Ruhengeri'),
(2820,1,'Umutara'),
(2821,1,'Christ Church Nichola Town'),
(2822,1,'Saint Anne Sandy Point'),
(2823,1,'Saint George Basseterre'),
(2824,1,'Saint George Gingerland'),
(2825,1,'Saint James Windward'),
(2826,1,'Saint John Capesterre'),
(2827,1,'Saint John Figtree'),
(2828,1,'Saint Mary Cayon'),
(2829,1,'Saint Paul Capesterre'),
(2830,1,'Saint Paul Charlestown'),
(2831,1,'Saint Peter Basseterre'),
(2832,1,'Saint Thomas Lowland'),
(2833,1,'Saint Thomas Middle Island'),
(2834,1,'Trinity Palmetto Point'),
(2835,1,'Anse-la-Raye'),
(2836,1,'Castries'),
(2837,1,'Choiseul'),
(2838,1,'Dauphin'),
(2839,1,'Dennery'),
(2840,1,'Gros-Islet'),
(2841,1,'Laborie'),
(2842,1,'Micoud'),
(2843,1,'Praslin'),
(2844,1,'Soufriere'),
(2845,1,'Vieux-Fort'),
(2846,1,'Charlotte'),
(2847,1,'Grenadines'),
(2848,1,'Saint Andrew'),
(2849,1,'Saint David'),
(2850,1,'Saint George'),
(2851,1,'Saint Patrick'),
(2852,1,'A\'ana'),
(2853,1,'Aiga-i-le-Tai'),
(2854,1,'Atua'),
(2855,1,'Fa\'asaleleaga'),
(2856,1,'Gaga\'emauga'),
(2857,1,'Gagaifomauga'),
(2858,1,'Palauli'),
(2859,1,'Satupa\'itea'),
(2860,1,'Tuamasaga'),
(2861,1,'Va\'a-o-Fonoti'),
(2862,1,'Vaisigano'),
(2863,1,'Acquaviva'),
(2864,1,'Borgo Maggiore'),
(2865,1,'Chiesanuova'),
(2866,1,'Domagnano'),
(2867,1,'Faetano'),
(2868,1,'Fiorentino'),
(2869,1,'Montegiardino'),
(2870,1,'Citta di San Marino'),
(2871,1,'Serravalle'),
(2872,1,'Sao Tome'),
(2873,1,'Principe'),
(2874,1,'Al Bahah'),
(2875,1,'Al Hudud ash Shamaliyah'),
(2876,1,'Al Jawf'),
(2877,1,'Al Madinah'),
(2878,1,'Al Qasim'),
(2879,1,'Ar Riyad'),
(2880,1,'Ash Sharqiyah (Eastern)'),
(2881,1,'\'Asir'),
(2882,1,'Ha\'il'),
(2883,1,'Jizan'),
(2884,1,'Makkah'),
(2885,1,'Najran'),
(2886,1,'Tabuk'),
(2887,1,'Dakar'),
(2888,1,'Diourbel'),
(2889,1,'Fatick'),
(2890,1,'Kaolack'),
(2891,1,'Kolda'),
(2892,1,'Louga'),
(2893,1,'Matam'),
(2894,1,'Saint-Louis'),
(2895,1,'Tambacounda'),
(2896,1,'Thies'),
(2897,1,'Ziguinchor'),
(2898,1,'Anse aux Pins'),
(2899,1,'Anse Boileau'),
(2900,1,'Anse Etoile'),
(2901,1,'Anse Louis'),
(2902,1,'Anse Royale'),
(2903,1,'Baie Lazare'),
(2904,1,'Baie Sainte Anne'),
(2905,1,'Beau Vallon'),
(2906,1,'Bel Air'),
(2907,1,'Bel Ombre'),
(2908,1,'Cascade'),
(2909,1,'Glacis'),
(2910,1,'Grand\' Anse (on Mahe)'),
(2911,1,'Grand\' Anse (on Praslin)'),
(2912,1,'La Digue'),
(2913,1,'La Riviere Anglaise'),
(2914,1,'Mont Buxton'),
(2915,1,'Mont Fleuri'),
(2916,1,'Plaisance'),
(2917,1,'Pointe La Rue'),
(2918,1,'Port Glaud'),
(2919,1,'Saint Louis'),
(2920,1,'Takamaka'),
(2921,1,'Eastern'),
(2922,1,'Northern'),
(2923,1,'Southern'),
(2924,1,'Western'),
(2925,1,'Banskobystrický'),
(2926,1,'Bratislavský'),
(2927,1,'Košický'),
(2928,1,'Nitriansky'),
(2929,1,'Prešovský'),
(2930,1,'Trenčiansky'),
(2931,1,'Trnavský'),
(2932,1,'Žilinský'),
(2933,1,'Central'),
(2934,1,'Choiseul'),
(2935,1,'Guadalcanal'),
(2936,1,'Honiara'),
(2937,1,'Isabel'),
(2938,1,'Makira'),
(2939,1,'Malaita'),
(2940,1,'Rennell and Bellona'),
(2941,1,'Temotu'),
(2942,1,'Western'),
(2943,1,'Awdal'),
(2944,1,'Bakool'),
(2945,1,'Banaadir'),
(2946,1,'Bari'),
(2947,1,'Bay'),
(2948,1,'Galguduud'),
(2949,1,'Gedo'),
(2950,1,'Hiiraan'),
(2951,1,'Jubbada Dhexe'),
(2952,1,'Jubbada Hoose'),
(2953,1,'Mudug'),
(2954,1,'Nugaal'),
(2955,1,'Sanaag'),
(2956,1,'Shabeellaha Dhexe'),
(2957,1,'Shabeellaha Hoose'),
(2958,1,'Sool'),
(2959,1,'Togdheer'),
(2960,1,'Woqooyi Galbeed'),
(2961,1,'Eastern Cape'),
(2962,1,'Free State'),
(2963,1,'Gauteng'),
(2964,1,'KwaZulu-Natal'),
(2965,1,'Limpopo'),
(2966,1,'Mpumalanga'),
(2967,1,'North West'),
(2968,1,'Northern Cape'),
(2969,1,'Western Cape'),
(2970,1,'La Coru&ntilde;a'),
(2971,1,'&Aacute;lava'),
(2972,1,'Albacete'),
(2973,1,'Alicante'),
(2974,1,'Almeria'),
(2975,1,'Asturias'),
(2976,1,'&Aacute;vila'),
(2977,1,'Badajoz'),
(2978,1,'Baleares'),
(2979,1,'Barcelona'),
(2980,1,'Burgos'),
(2981,1,'C&aacute;ceres'),
(2982,1,'C&aacute;diz'),
(2983,1,'Cantabria'),
(2984,1,'Castell&oacute;n'),
(2985,1,'Ceuta'),
(2986,1,'Ciudad Real'),
(2987,1,'C&oacute;rdoba'),
(2988,1,'Cuenca'),
(2989,1,'Girona'),
(2990,1,'Granada'),
(2991,1,'Guadalajara'),
(2992,1,'Guip&uacute;zcoa'),
(2993,1,'Huelva'),
(2994,1,'Huesca'),
(2995,1,'Ja&eacute;n'),
(2996,1,'La Rioja'),
(2997,1,'Las Palmas'),
(2998,1,'Leon'),
(2999,1,'Lleida'),
(3000,1,'Lugo'),
(3001,1,'Madrid'),
(3002,1,'Malaga'),
(3003,1,'Melilla'),
(3004,1,'Murcia'),
(3005,1,'Navarra'),
(3006,1,'Ourense'),
(3007,1,'Palencia'),
(3008,1,'Pontevedra'),
(3009,1,'Salamanca'),
(3010,1,'Santa Cruz de Tenerife'),
(3011,1,'Segovia'),
(3012,1,'Sevilla'),
(3013,1,'Soria'),
(3014,1,'Tarragona'),
(3015,1,'Teruel'),
(3016,1,'Toledo'),
(3017,1,'Valencia'),
(3018,1,'Valladolid'),
(3019,1,'Vizcaya'),
(3020,1,'Zamora'),
(3021,1,'Zaragoza'),
(3022,1,'Central'),
(3023,1,'Eastern'),
(3024,1,'North Central'),
(3025,1,'Northern'),
(3026,1,'North Western'),
(3027,1,'Sabaragamuwa'),
(3028,1,'Southern'),
(3029,1,'Uva'),
(3030,1,'Western'),
(3031,1,'Ascension'),
(3032,1,'Saint Helena'),
(3033,1,'Tristan da Cunha'),
(3034,1,'A\'ali an Nil'),
(3035,1,'Al Bahr al Ahmar'),
(3036,1,'Al Buhayrat'),
(3037,1,'Al Jazirah'),
(3038,1,'Al Khartum'),
(3039,1,'Al Qadarif'),
(3040,1,'Al Wahdah'),
(3041,1,'An Nil al Abyad'),
(3042,1,'An Nil al Azraq'),
(3043,1,'Ash Shamaliyah'),
(3044,1,'Bahr al Jabal'),
(3045,1,'Gharb al Istiwa\'iyah'),
(3046,1,'Gharb Bahr al Ghazal'),
(3047,1,'Gharb Darfur'),
(3048,1,'Gharb Kurdufan'),
(3049,1,'Janub Darfur'),
(3050,1,'Janub Kurdufan'),
(3051,1,'Junqali'),
(3052,1,'Kassala'),
(3053,1,'Nahr an Nil'),
(3054,1,'Shamal Bahr al Ghazal'),
(3055,1,'Shamal Darfur'),
(3056,1,'Shamal Kurdufan'),
(3057,1,'Sharq al Istiwa\'iyah'),
(3058,1,'Sinnar'),
(3059,1,'Warab'),
(3060,1,'Brokopondo'),
(3061,1,'Commewijne'),
(3062,1,'Coronie'),
(3063,1,'Marowijne'),
(3064,1,'Nickerie'),
(3065,1,'Para'),
(3066,1,'Paramaribo'),
(3067,1,'Saramacca'),
(3068,1,'Sipaliwini'),
(3069,1,'Wanica'),
(3070,1,'Hhohho'),
(3071,1,'Lubombo'),
(3072,1,'Manzini'),
(3073,1,'Shishelweni'),
(3074,1,'Blekinge'),
(3075,1,'Dalama'),
(3076,1,'G&auml;vleborg'),
(3077,1,'Gotland'),
(3078,1,'Halland'),
(3079,1,'J&auml;mtland'),
(3080,1,'J&ouml;nk&ouml;ping'),
(3081,1,'Kalmar'),
(3082,1,'Kronoberg'),
(3083,1,'Norrbotten'),
(3084,1,'&Ouml;rebro'),
(3085,1,'&Ouml;sterg&ouml;tland'),
(3086,1,'Sk&aring;ne'),
(3087,1,'S&ouml;dermanland'),
(3088,1,'Stockholm'),
(3089,1,'Uppsala'),
(3090,1,'V&auml;rmland'),
(3091,1,'V&auml;sterbotten'),
(3092,1,'V&auml;sternorrland'),
(3093,1,'V&auml;stmanland'),
(3094,1,'V&auml;stra G&ouml;taland'),
(3095,1,'Aargau'),
(3096,1,'Appenzell Ausserrhoden'),
(3097,1,'Appenzell Innerrhoden'),
(3098,1,'Basel-Stadt'),
(3099,1,'Basel-Landschaft'),
(3100,1,'Bern'),
(3101,1,'Fribourg'),
(3102,1,'Gen&egrave;ve'),
(3103,1,'Glarus'),
(3104,1,'Graub&uuml;nden'),
(3105,1,'Jura'),
(3106,1,'Luzern'),
(3107,1,'Neuch&acirc;tel'),
(3108,1,'Nidwald'),
(3109,1,'Obwald'),
(3110,1,'St. Gallen'),
(3111,1,'Schaffhausen'),
(3112,1,'Schwyz'),
(3113,1,'Solothurn'),
(3114,1,'Thurgau'),
(3115,1,'Ticino'),
(3116,1,'Uri'),
(3117,1,'Valais'),
(3118,1,'Vaud'),
(3119,1,'Zug'),
(3120,1,'Z&uuml;rich'),
(3121,1,'Al Hasakah'),
(3122,1,'Al Ladhiqiyah'),
(3123,1,'Al Qunaytirah'),
(3124,1,'Ar Raqqah'),
(3125,1,'As Suwayda'),
(3126,1,'Dara'),
(3127,1,'Dayr az Zawr'),
(3128,1,'Dimashq'),
(3129,1,'Halab'),
(3130,1,'Hamah'),
(3131,1,'Hims'),
(3132,1,'Idlib'),
(3133,1,'Rif Dimashq'),
(3134,1,'Tartus'),
(3135,1,'Chang-hua'),
(3136,1,'Chia-i'),
(3137,1,'Hsin-chu'),
(3138,1,'Hua-lien'),
(3139,1,'I-lan'),
(3140,1,'Kao-hsiung county'),
(3141,1,'Kin-men'),
(3142,1,'Lien-chiang'),
(3143,1,'Miao-li'),
(3144,1,'Nan-t\'ou'),
(3145,1,'P\'eng-hu'),
(3146,1,'P\'ing-tung'),
(3147,1,'T\'ai-chung'),
(3148,1,'T\'ai-nan'),
(3149,1,'T\'ai-pei county'),
(3150,1,'T\'ai-tung'),
(3151,1,'T\'ao-yuan'),
(3152,1,'Yun-lin'),
(3153,1,'Chia-i city'),
(3154,1,'Chi-lung'),
(3155,1,'Hsin-chu'),
(3156,1,'T\'ai-chung'),
(3157,1,'T\'ai-nan'),
(3158,1,'Kao-hsiung city'),
(3159,1,'T\'ai-pei city'),
(3160,1,'Gorno-Badakhstan'),
(3161,1,'Khatlon'),
(3162,1,'Sughd'),
(3163,1,'Arusha'),
(3164,1,'Dar es Salaam'),
(3165,1,'Dodoma'),
(3166,1,'Iringa'),
(3167,1,'Kagera'),
(3168,1,'Kigoma'),
(3169,1,'Kilimanjaro'),
(3170,1,'Lindi'),
(3171,1,'Manyara'),
(3172,1,'Mara'),
(3173,1,'Mbeya'),
(3174,1,'Morogoro'),
(3175,1,'Mtwara'),
(3176,1,'Mwanza'),
(3177,1,'Pemba North'),
(3178,1,'Pemba South'),
(3179,1,'Pwani'),
(3180,1,'Rukwa'),
(3181,1,'Ruvuma'),
(3182,1,'Shinyanga'),
(3183,1,'Singida'),
(3184,1,'Tabora'),
(3185,1,'Tanga'),
(3186,1,'Zanzibar Central/South'),
(3187,1,'Zanzibar North'),
(3188,1,'Zanzibar Urban/West'),
(3189,1,'Amnat Charoen'),
(3190,1,'Ang Thong'),
(3191,1,'Ayutthaya'),
(3192,1,'Bangkok'),
(3193,1,'Buriram'),
(3194,1,'Chachoengsao'),
(3195,1,'Chai Nat'),
(3196,1,'Chaiyaphum'),
(3197,1,'Chanthaburi'),
(3198,1,'Chiang Mai'),
(3199,1,'Chiang Rai'),
(3200,1,'Chon Buri'),
(3201,1,'Chumphon'),
(3202,1,'Kalasin'),
(3203,1,'Kamphaeng Phet'),
(3204,1,'Kanchanaburi'),
(3205,1,'Khon Kaen'),
(3206,1,'Krabi'),
(3207,1,'Lampang'),
(3208,1,'Lamphun'),
(3209,1,'Loei'),
(3210,1,'Lop Buri'),
(3211,1,'Mae Hong Son'),
(3212,1,'Maha Sarakham'),
(3213,1,'Mukdahan'),
(3214,1,'Nakhon Nayok'),
(3215,1,'Nakhon Pathom'),
(3216,1,'Nakhon Phanom'),
(3217,1,'Nakhon Ratchasima'),
(3218,1,'Nakhon Sawan'),
(3219,1,'Nakhon Si Thammarat'),
(3220,1,'Nan'),
(3221,1,'Narathiwat'),
(3222,1,'Nong Bua Lamphu'),
(3223,1,'Nong Khai'),
(3224,1,'Nonthaburi'),
(3225,1,'Pathum Thani'),
(3226,1,'Pattani'),
(3227,1,'Phangnga'),
(3228,1,'Phatthalung'),
(3229,1,'Phayao'),
(3230,1,'Phetchabun'),
(3231,1,'Phetchaburi'),
(3232,1,'Phichit'),
(3233,1,'Phitsanulok'),
(3234,1,'Phrae'),
(3235,1,'Phuket'),
(3236,1,'Prachin Buri'),
(3237,1,'Prachuap Khiri Khan'),
(3238,1,'Ranong'),
(3239,1,'Ratchaburi'),
(3240,1,'Rayong'),
(3241,1,'Roi Et'),
(3242,1,'Sa Kaeo'),
(3243,1,'Sakon Nakhon'),
(3244,1,'Samut Prakan'),
(3245,1,'Samut Sakhon'),
(3246,1,'Samut Songkhram'),
(3247,1,'Sara Buri'),
(3248,1,'Satun'),
(3249,1,'Sing Buri'),
(3250,1,'Sisaket'),
(3251,1,'Songkhla'),
(3252,1,'Sukhothai'),
(3253,1,'Suphan Buri'),
(3254,1,'Surat Thani'),
(3255,1,'Surin'),
(3256,1,'Tak'),
(3257,1,'Trang'),
(3258,1,'Trat'),
(3259,1,'Ubon Ratchathani'),
(3260,1,'Udon Thani'),
(3261,1,'Uthai Thani'),
(3262,1,'Uttaradit'),
(3263,1,'Yala'),
(3264,1,'Yasothon'),
(3265,1,'Kara'),
(3266,1,'Plateaux'),
(3267,1,'Savanes'),
(3268,1,'Centrale'),
(3269,1,'Maritime'),
(3270,1,'Atafu'),
(3271,1,'Fakaofo'),
(3272,1,'Nukunonu'),
(3273,1,'Ha\'apai'),
(3274,1,'Tongatapu'),
(3275,1,'Vava\'u'),
(3276,1,'Couva/Tabaquite/Talparo'),
(3277,1,'Diego Martin'),
(3278,1,'Mayaro/Rio Claro'),
(3279,1,'Penal/Debe'),
(3280,1,'Princes Town'),
(3281,1,'Sangre Grande'),
(3282,1,'San Juan/Laventille'),
(3283,1,'Siparia'),
(3284,1,'Tunapuna/Piarco'),
(3285,1,'Port of Spain'),
(3286,1,'San Fernando'),
(3287,1,'Arima'),
(3288,1,'Point Fortin'),
(3289,1,'Chaguanas'),
(3290,1,'Tobago'),
(3291,1,'Ariana'),
(3292,1,'Beja'),
(3293,1,'Ben Arous'),
(3294,1,'Bizerte'),
(3295,1,'Gabes'),
(3296,1,'Gafsa'),
(3297,1,'Jendouba'),
(3298,1,'Kairouan'),
(3299,1,'Kasserine'),
(3300,1,'Kebili'),
(3301,1,'Kef'),
(3302,1,'Mahdia'),
(3303,1,'Manouba'),
(3304,1,'Medenine'),
(3305,1,'Monastir'),
(3306,1,'Nabeul'),
(3307,1,'Sfax'),
(3308,1,'Sidi'),
(3309,1,'Siliana'),
(3310,1,'Sousse'),
(3311,1,'Tataouine'),
(3312,1,'Tozeur'),
(3313,1,'Tunis'),
(3314,1,'Zaghouan'),
(3315,1,'Adana'),
(3316,1,'Adiyaman'),
(3317,1,'Afyonkarahisar'),
(3318,1,'Agri'),
(3319,1,'Aksaray'),
(3320,1,'Amasya'),
(3321,1,'Ankara'),
(3322,1,'Antalya'),
(3323,1,'Ardahan'),
(3324,1,'Artvin'),
(3325,1,'Aydin'),
(3326,1,'Balikesir'),
(3327,1,'Bartin'),
(3328,1,'Batman'),
(3329,1,'Bayburt'),
(3330,1,'Bilecik'),
(3331,1,'Bingol'),
(3332,1,'Bitlis'),
(3333,1,'Bolu'),
(3334,1,'Burdur'),
(3335,1,'Bursa'),
(3336,1,'Canakkale'),
(3337,1,'Cankiri'),
(3338,1,'Corum'),
(3339,1,'Denizli'),
(3340,1,'Diyarbakir'),
(3341,1,'Duzce'),
(3342,1,'Edirne'),
(3343,1,'Elazig'),
(3344,1,'Erzincan'),
(3345,1,'Erzurum'),
(3346,1,'Eskisehir'),
(3347,1,'Gaziantep'),
(3348,1,'Giresun'),
(3349,1,'Gumushane'),
(3350,1,'Hakkari'),
(3351,1,'Hatay'),
(3352,1,'Igdir'),
(3353,1,'Isparta'),
(3354,1,'Istanbul'),
(3355,1,'Izmir'),
(3356,1,'Kahramanmaras'),
(3357,1,'Karabuk'),
(3358,1,'Karaman'),
(3359,1,'Kars'),
(3360,1,'Kastamonu'),
(3361,1,'Kayseri'),
(3362,1,'Kilis'),
(3363,1,'Kirikkale'),
(3364,1,'Kirklareli'),
(3365,1,'Kirsehir'),
(3366,1,'Kocaeli'),
(3367,1,'Konya'),
(3368,1,'Kutahya'),
(3369,1,'Malatya'),
(3370,1,'Manisa'),
(3371,1,'Mardin'),
(3372,1,'Mersin'),
(3373,1,'Mugla'),
(3374,1,'Mus'),
(3375,1,'Nevsehir'),
(3376,1,'Nigde'),
(3377,1,'Ordu'),
(3378,1,'Osmaniye'),
(3379,1,'Rize'),
(3380,1,'Sakarya'),
(3381,1,'Samsun'),
(3382,1,'Sanliurfa'),
(3383,1,'Siirt'),
(3384,1,'Sinop'),
(3385,1,'Sirnak'),
(3386,1,'Sivas'),
(3387,1,'Tekirdag'),
(3388,1,'Tokat'),
(3389,1,'Trabzon'),
(3390,1,'Tunceli'),
(3391,1,'Usak'),
(3392,1,'Van'),
(3393,1,'Yalova'),
(3394,1,'Yozgat'),
(3395,1,'Zonguldak'),
(3396,1,'Ahal Welayaty'),
(3397,1,'Balkan Welayaty'),
(3398,1,'Dashhowuz Welayaty'),
(3399,1,'Lebap Welayaty'),
(3400,1,'Mary Welayaty'),
(3401,1,'Ambergris Cays'),
(3402,1,'Dellis Cay'),
(3403,1,'French Cay'),
(3404,1,'Little Water Cay'),
(3405,1,'Parrot Cay'),
(3406,1,'Pine Cay'),
(3407,1,'Salt Cay'),
(3408,1,'Grand Turk'),
(3409,1,'South Caicos'),
(3410,1,'East Caicos'),
(3411,1,'Middle Caicos'),
(3412,1,'North Caicos'),
(3413,1,'Providenciales'),
(3414,1,'West Caicos'),
(3415,1,'Nanumanga'),
(3416,1,'Niulakita'),
(3417,1,'Niutao'),
(3418,1,'Funafuti'),
(3419,1,'Nanumea'),
(3420,1,'Nui'),
(3421,1,'Nukufetau'),
(3422,1,'Nukulaelae'),
(3423,1,'Vaitupu'),
(3424,1,'Kalangala'),
(3425,1,'Kampala'),
(3426,1,'Kayunga'),
(3427,1,'Kiboga'),
(3428,1,'Luwero'),
(3429,1,'Masaka'),
(3430,1,'Mpigi'),
(3431,1,'Mubende'),
(3432,1,'Mukono'),
(3433,1,'Nakasongola'),
(3434,1,'Rakai'),
(3435,1,'Sembabule'),
(3436,1,'Wakiso'),
(3437,1,'Bugiri'),
(3438,1,'Busia'),
(3439,1,'Iganga'),
(3440,1,'Jinja'),
(3441,1,'Kaberamaido'),
(3442,1,'Kamuli'),
(3443,1,'Kapchorwa'),
(3444,1,'Katakwi'),
(3445,1,'Kumi'),
(3446,1,'Mayuge'),
(3447,1,'Mbale'),
(3448,1,'Pallisa'),
(3449,1,'Sironko'),
(3450,1,'Soroti'),
(3451,1,'Tororo'),
(3452,1,'Adjumani'),
(3453,1,'Apac'),
(3454,1,'Arua'),
(3455,1,'Gulu'),
(3456,1,'Kitgum'),
(3457,1,'Kotido'),
(3458,1,'Lira'),
(3459,1,'Moroto'),
(3460,1,'Moyo'),
(3461,1,'Nakapiripirit'),
(3462,1,'Nebbi'),
(3463,1,'Pader'),
(3464,1,'Yumbe'),
(3465,1,'Bundibugyo'),
(3466,1,'Bushenyi'),
(3467,1,'Hoima'),
(3468,1,'Kabale'),
(3469,1,'Kabarole'),
(3470,1,'Kamwenge'),
(3471,1,'Kanungu'),
(3472,1,'Kasese'),
(3473,1,'Kibaale'),
(3474,1,'Kisoro'),
(3475,1,'Kyenjojo'),
(3476,1,'Masindi'),
(3477,1,'Mbarara'),
(3478,1,'Ntungamo'),
(3479,1,'Rukungiri'),
(3480,1,'Cherkasy'),
(3481,1,'Chernihiv'),
(3482,1,'Chernivtsi'),
(3483,1,'Crimea'),
(3484,1,'Dnipro'),
(3485,1,'Donets\'k'),
(3486,1,'Ivano-Frankivs\'k'),
(3487,1,'Kharkiv'),
(3488,1,'Khmel\'nyts\'kyy'),
(3489,1,'Kirovohrad'),
(3490,1,'Kyiv'),
(3491,1,'Kherson'),
(3492,1,'Luhans\'k'),
(3493,1,'L\'viv'),
(3494,1,'Mykolaiv'),
(3495,1,'Odesa'),
(3496,1,'Poltava'),
(3497,1,'Rivne'),
(3498,1,'Sevastopol'),
(3499,1,'Sumy'),
(3500,1,'Ternopil\''),
(3501,1,'Vinnytsya'),
(3502,1,'Volyn\''),
(3503,1,'Zakarpattya'),
(3504,1,'Zaporizhzhya'),
(3505,1,'Zhytomyr'),
(3506,1,'Abu Zaby'),
(3507,1,'\'Ajman'),
(3508,1,'Al Fujayrah'),
(3509,1,'Ash Shariqah'),
(3510,1,'Dubayy'),
(3511,1,'R\'as al Khaymah'),
(3512,1,'Umm al Qaywayn'),
(3513,1,'Aberdeen'),
(3514,1,'Aberdeenshire'),
(3515,1,'Anglesey'),
(3516,1,'Angus'),
(3517,1,'Argyll and Bute'),
(3518,1,'Bedfordshire'),
(3519,1,'Berkshire'),
(3520,1,'Blaenau Gwent'),
(3521,1,'Bridgend'),
(3522,1,'Bristol'),
(3523,1,'Buckinghamshire'),
(3524,1,'Caerphilly'),
(3525,1,'Cambridgeshire'),
(3526,1,'Cardiff'),
(3527,1,'Carmarthenshire'),
(3528,1,'Ceredigion'),
(3529,1,'Cheshire'),
(3530,1,'Clackmannanshire'),
(3531,1,'Conwy'),
(3532,1,'Cornwall'),
(3533,1,'Denbighshire'),
(3534,1,'Derbyshire'),
(3535,1,'Devon'),
(3536,1,'Dorset'),
(3537,1,'Dumfries and Galloway'),
(3538,1,'Dundee'),
(3539,1,'Durham'),
(3540,1,'East Ayrshire'),
(3541,1,'East Dunbartonshire'),
(3542,1,'East Lothian'),
(3543,1,'East Renfrewshire'),
(3544,1,'East Riding of Yorkshire'),
(3545,1,'East Sussex'),
(3546,1,'Edinburgh'),
(3547,1,'Essex'),
(3548,1,'Falkirk'),
(3549,1,'Fife'),
(3550,1,'Flintshire'),
(3551,1,'Glasgow'),
(3552,1,'Gloucestershire'),
(3553,1,'Greater London'),
(3554,1,'Greater Manchester'),
(3555,1,'Gwynedd'),
(3556,1,'Hampshire'),
(3557,1,'Herefordshire'),
(3558,1,'Hertfordshire'),
(3559,1,'Highlands'),
(3560,1,'Inverclyde'),
(3561,1,'Isle of Wight'),
(3562,1,'Kent'),
(3563,1,'Lancashire'),
(3564,1,'Leicestershire'),
(3565,1,'Lincolnshire'),
(3566,1,'Merseyside'),
(3567,1,'Merthyr Tydfil'),
(3568,1,'Midlothian'),
(3569,1,'Monmouthshire'),
(3570,1,'Moray'),
(3571,1,'Neath Port Talbot'),
(3572,1,'Newport'),
(3573,1,'Norfolk'),
(3574,1,'North Ayrshire'),
(3575,1,'North Lanarkshire'),
(3576,1,'North Yorkshire'),
(3577,1,'Northamptonshire'),
(3578,1,'Northumberland'),
(3579,1,'Nottinghamshire'),
(3580,1,'Orkney Islands'),
(3581,1,'Oxfordshire'),
(3582,1,'Pembrokeshire'),
(3583,1,'Perth and Kinross'),
(3584,1,'Powys'),
(3585,1,'Renfrewshire'),
(3586,1,'Rhondda Cynon Taff'),
(3587,1,'Rutland'),
(3588,1,'Scottish Borders'),
(3589,1,'Shetland Islands'),
(3590,1,'Shropshire'),
(3591,1,'Somerset'),
(3592,1,'South Ayrshire'),
(3593,1,'South Lanarkshire'),
(3594,1,'South Yorkshire'),
(3595,1,'Staffordshire'),
(3596,1,'Stirling'),
(3597,1,'Suffolk'),
(3598,1,'Surrey'),
(3599,1,'Swansea'),
(3600,1,'Torfaen'),
(3601,1,'Tyne and Wear'),
(3602,1,'Vale of Glamorgan'),
(3603,1,'Warwickshire'),
(3604,1,'West Dunbartonshire'),
(3605,1,'West Lothian'),
(3606,1,'West Midlands'),
(3607,1,'West Sussex'),
(3608,1,'West Yorkshire'),
(3609,1,'Western Isles'),
(3610,1,'Wiltshire'),
(3611,1,'Worcestershire'),
(3612,1,'Wrexham'),
(3613,1,'Alabama'),
(3614,1,'Alaska'),
(3615,1,'American Samoa'),
(3616,1,'Arizona'),
(3617,1,'Arkansas'),
(3618,1,'Armed Forces Africa'),
(3619,1,'Armed Forces Americas'),
(3620,1,'Armed Forces Canada'),
(3621,1,'Armed Forces Europe'),
(3622,1,'Armed Forces Middle East'),
(3623,1,'Armed Forces Pacific'),
(3624,1,'California'),
(3625,1,'Colorado'),
(3626,1,'Connecticut'),
(3627,1,'Delaware'),
(3628,1,'District of Columbia'),
(3629,1,'Federated States Of Micronesia'),
(3630,1,'Florida'),
(3631,1,'Georgia'),
(3632,1,'Guam'),
(3633,1,'Hawaii'),
(3634,1,'Idaho'),
(3635,1,'Illinois'),
(3636,1,'Indiana'),
(3637,1,'Iowa'),
(3638,1,'Kansas'),
(3639,1,'Kentucky'),
(3640,1,'Louisiana'),
(3641,1,'Maine'),
(3642,1,'Marshall Islands'),
(3643,1,'Maryland'),
(3644,1,'Massachusetts'),
(3645,1,'Michigan'),
(3646,1,'Minnesota'),
(3647,1,'Mississippi'),
(3648,1,'Missouri'),
(3649,1,'Montana'),
(3650,1,'Nebraska'),
(3651,1,'Nevada'),
(3652,1,'New Hampshire'),
(3653,1,'New Jersey'),
(3654,1,'New Mexico'),
(3655,1,'New York'),
(3656,1,'North Carolina'),
(3657,1,'North Dakota'),
(3658,1,'Northern Mariana Islands'),
(3659,1,'Ohio'),
(3660,1,'Oklahoma'),
(3661,1,'Oregon'),
(3662,1,'Palau'),
(3663,1,'Pennsylvania'),
(3664,1,'Puerto Rico'),
(3665,1,'Rhode Island'),
(3666,1,'South Carolina'),
(3667,1,'South Dakota'),
(3668,1,'Tennessee'),
(3669,1,'Texas'),
(3670,1,'Utah'),
(3671,1,'Vermont'),
(3672,1,'Virgin Islands'),
(3673,1,'Virginia'),
(3674,1,'Washington'),
(3675,1,'West Virginia'),
(3676,1,'Wisconsin'),
(3677,1,'Wyoming'),
(3678,1,'Baker Island'),
(3679,1,'Howland Island'),
(3680,1,'Jarvis Island'),
(3681,1,'Johnston Atoll'),
(3682,1,'Kingman Reef'),
(3683,1,'Midway Atoll'),
(3684,1,'Navassa Island'),
(3685,1,'Palmyra Atoll'),
(3686,1,'Wake Island'),
(3687,1,'Artigas'),
(3688,1,'Canelones'),
(3689,1,'Cerro Largo'),
(3690,1,'Colonia'),
(3691,1,'Durazno'),
(3692,1,'Flores'),
(3693,1,'Florida'),
(3694,1,'Lavalleja'),
(3695,1,'Maldonado'),
(3696,1,'Montevideo'),
(3697,1,'Paysandu'),
(3698,1,'Rio Negro'),
(3699,1,'Rivera'),
(3700,1,'Rocha'),
(3701,1,'Salto'),
(3702,1,'San Jose'),
(3703,1,'Soriano'),
(3704,1,'Tacuarembo'),
(3705,1,'Treinta y Tres'),
(3706,1,'Andijon'),
(3707,1,'Buxoro'),
(3708,1,'Farg\'ona'),
(3709,1,'Jizzax'),
(3710,1,'Namangan'),
(3711,1,'Navoiy'),
(3712,1,'Qashqadaryo'),
(3713,1,'Qoraqalpog\'iston Republikasi'),
(3714,1,'Samarqand'),
(3715,1,'Sirdaryo'),
(3716,1,'Surxondaryo'),
(3717,1,'Toshkent City'),
(3718,1,'Toshkent Region'),
(3719,1,'Xorazm'),
(3720,1,'Malampa'),
(3721,1,'Penama'),
(3722,1,'Sanma'),
(3723,1,'Shefa'),
(3724,1,'Tafea'),
(3725,1,'Torba'),
(3726,1,'Amazonas'),
(3727,1,'Anzoategui'),
(3728,1,'Apure'),
(3729,1,'Aragua'),
(3730,1,'Barinas'),
(3731,1,'Bolivar'),
(3732,1,'Carabobo'),
(3733,1,'Cojedes'),
(3734,1,'Delta Amacuro'),
(3735,1,'Dependencias Federales'),
(3736,1,'Distrito Federal'),
(3737,1,'Falcon'),
(3738,1,'Guarico'),
(3739,1,'Lara'),
(3740,1,'Merida'),
(3741,1,'Miranda'),
(3742,1,'Monagas'),
(3743,1,'Nueva Esparta'),
(3744,1,'Portuguesa'),
(3745,1,'Sucre'),
(3746,1,'Tachira'),
(3747,1,'Trujillo'),
(3748,1,'Vargas'),
(3749,1,'Yaracuy'),
(3750,1,'Zulia'),
(3751,1,'An Giang'),
(3752,1,'Bac Giang'),
(3753,1,'Bac Kan'),
(3754,1,'Bac Lieu'),
(3755,1,'Bac Ninh'),
(3756,1,'Ba Ria-Vung Tau'),
(3757,1,'Ben Tre'),
(3758,1,'Binh Dinh'),
(3759,1,'Binh Duong'),
(3760,1,'Binh Phuoc'),
(3761,1,'Binh Thuan'),
(3762,1,'Ca Mau'),
(3763,1,'Can Tho'),
(3764,1,'Cao Bang'),
(3765,1,'Dak Lak'),
(3766,1,'Dak Nong'),
(3767,1,'Da Nang'),
(3768,1,'Dien Bien'),
(3769,1,'Dong Nai'),
(3770,1,'Dong Thap'),
(3771,1,'Gia Lai'),
(3772,1,'Ha Giang'),
(3773,1,'Hai Duong'),
(3774,1,'Hai Phong'),
(3775,1,'Ha Nam'),
(3776,1,'Ha Noi'),
(3777,1,'Ha Tay'),
(3778,1,'Ha Tinh'),
(3779,1,'Hoa Binh'),
(3780,1,'Ho Chi Minh City'),
(3781,1,'Hau Giang'),
(3782,1,'Hung Yen'),
(3783,1,'Saint Croix'),
(3784,1,'Saint John'),
(3785,1,'Saint Thomas'),
(3786,1,'Alo'),
(3787,1,'Sigave'),
(3788,1,'Wallis'),
(3789,1,'Abyan'),
(3790,1,'Adan'),
(3791,1,'Amran'),
(3792,1,'Al Bayda'),
(3793,1,'Ad Dali'),
(3794,1,'Dhamar'),
(3795,1,'Hadramawt'),
(3796,1,'Hajjah'),
(3797,1,'Al Hudaydah'),
(3798,1,'Ibb'),
(3799,1,'Al Jawf'),
(3800,1,'Lahij'),
(3801,1,'Ma\'rib'),
(3802,1,'Al Mahrah'),
(3803,1,'Al Mahwit'),
(3804,1,'Sa\'dah'),
(3805,1,'San\'a'),
(3806,1,'Shabwah'),
(3807,1,'Ta\'izz'),
(3808,1,'Andrijevica'),
(3809,1,'Bar'),
(3810,1,'Berane'),
(3811,1,'Bijelo Polje'),
(3812,1,'Bas-Congo'),
(3813,1,'Bandundu'),
(3814,1,'Equateur'),
(3815,1,'Katanga'),
(3816,1,'Kasai-Oriental'),
(3817,1,'Kinshasa'),
(3818,1,'Kasai-Occidental'),
(3819,1,'Maniema'),
(3820,1,'Nord-Kivu'),
(3821,1,'Orientale'),
(3822,1,'Sud-Kivu'),
(3823,1,'Central'),
(3824,1,'Copperbelt'),
(3825,1,'Eastern'),
(3826,1,'Luapula'),
(3827,1,'Lusaka'),
(3828,1,'Northern'),
(3829,1,'North-Western'),
(3830,1,'Southern'),
(3831,1,'Western'),
(3832,1,'Bulawayo'),
(3833,1,'Harare'),
(3834,1,'Manicaland'),
(3835,1,'Mashonaland Central'),
(3836,1,'Mashonaland East'),
(3837,1,'Mashonaland West'),
(3838,1,'Masvingo'),
(3839,1,'Matabeleland North'),
(3840,1,'Matabeleland South'),
(3841,1,'Midlands'),
(3861,1,'Campobasso'),
(3862,1,'Carbonia-Iglesias'),
(3863,1,'Caserta'),
(3864,1,'Catania'),
(3865,1,'Catanzaro'),
(3866,1,'Chieti'),
(3867,1,'Como'),
(3868,1,'Cosenza'),
(3869,1,'Cremona'),
(3870,1,'Crotone'),
(3871,1,'Cuneo'),
(3872,1,'Enna'),
(3873,1,'Ferrara'),
(3874,1,'Firenze'),
(3875,1,'Foggia'),
(3876,1,'Forli-Cesena'),
(3877,1,'Frosinone'),
(3878,1,'Genova'),
(3879,1,'Gorizia'),
(3880,1,'Grosseto'),
(3881,1,'Imperia'),
(3882,1,'Isernia'),
(3883,1,'L&#39;Aquila'),
(3884,1,'La Spezia'),
(3885,1,'Latina'),
(3886,1,'Lecce'),
(3887,1,'Lecco'),
(3888,1,'Livorno'),
(3889,1,'Lodi'),
(3890,1,'Lucca'),
(3891,1,'Macerata'),
(3892,1,'Mantova'),
(3893,1,'Massa-Carrara'),
(3894,1,'Matera'),
(3895,1,'Medio Campidano'),
(3896,1,'Messina'),
(3897,1,'Milano'),
(3898,1,'Modena'),
(3899,1,'Napoli'),
(3900,1,'Novara'),
(3901,1,'Nuoro'),
(3902,1,'Ogliastra'),
(3903,1,'Olbia-Tempio'),
(3904,1,'Oristano'),
(3905,1,'Padova'),
(3906,1,'Palermo'),
(3907,1,'Parma'),
(3908,1,'Pavia'),
(3909,1,'Perugia'),
(3910,1,'Pesaro e Urbino'),
(3911,1,'Pescara'),
(3912,1,'Piacenza'),
(3913,1,'Pisa'),
(3914,1,'Pistoia'),
(3915,1,'Pordenone'),
(3916,1,'Potenza'),
(3917,1,'Prato'),
(3918,1,'Ragusa'),
(3919,1,'Ravenna'),
(3920,1,'Reggio Calabria'),
(3921,1,'Reggio Emilia'),
(3922,1,'Rieti'),
(3923,1,'Rimini'),
(3924,1,'Roma'),
(3925,1,'Rovigo'),
(3926,1,'Salerno'),
(3927,1,'Sassari'),
(3928,1,'Savona'),
(3929,1,'Siena'),
(3930,1,'Siracusa'),
(3931,1,'Sondrio'),
(3932,1,'Taranto'),
(3933,1,'Teramo'),
(3934,1,'Terni'),
(3935,1,'Torino'),
(3936,1,'Trapani'),
(3937,1,'Trento'),
(3938,1,'Treviso'),
(3939,1,'Trieste'),
(3940,1,'Udine'),
(3941,1,'Varese'),
(3942,1,'Venezia'),
(3943,1,'Verbano-Cusio-Ossola'),
(3944,1,'Vercelli'),
(3945,1,'Verona'),
(3946,1,'Vibo Valentia'),
(3947,1,'Vicenza'),
(3948,1,'Viterbo'),
(3949,1,'Antrim'),
(3950,1,'Armagh'),
(3951,1,'Down'),
(3952,1,'Fermanagh'),
(3953,1,'Derry'),
(3954,1,'Tyrone'),
(3955,1,'Mura'),
(3956,1,'Drava'),
(3957,1,'Carinthia'),
(3958,1,'Savinja'),
(3959,1,'Central Sava'),
(3960,1,'Lower Sava'),
(3961,1,'Southeast Slovenia'),
(3962,1,'Littoral–Inner Carniola'),
(3963,1,'Central Slovenia'),
(3964,1,'Upper Carniola'),
(3965,1,'Gorizia'),
(3966,1,'Coastal–Karst'),
(3967,1,'Singapore'),
(3968,1,'Metro Manila'),
(3969,1,'Budva'),
(3970,1,'Cetinje'),
(3971,1,'Danilovgrad'),
(3972,1,'Gusinje'),
(3973,1,'Herceg Novi'),
(3974,1,'Kolašin'),
(3975,1,'Kotor'),
(3976,1,'Mojkovac'),
(3977,1,'Nikšić'),
(3978,1,'Petnjica'),
(3979,1,'Plav'),
(3980,1,'Pljevlja'),
(3981,1,'Plužine'),
(3982,1,'Podgorica'),
(3983,1,'Rožaje'),
(3984,1,'Šavnik'),
(3985,1,'Tivat'),
(3986,1,'Tuzi'),
(3987,1,'Ulcinj'),
(3988,1,'Žabljak'),
(3989,1,'Vojvodina'),
(3990,1,'Belgrade'),
(3991,1,'Šumadija and Western Serbia'),
(3992,1,'Southern and Eastern Serbia'),
(3993,1,'Kosovo and Metohija'),
(3994,1,'Ferizaj'),
(3995,1,'Gjakova'),
(3996,1,'Gjilan'),
(3997,1,'Mitrovica'),
(3998,1,'Peja'),
(3999,1,'Pristina'),
(4000,1,'Prizren'),
(4001,1,'Eastern'),
(4002,1,'Northeastern'),
(4003,1,'Pelagonia'),
(4004,1,'Polog'),
(4005,1,'Skopje'),
(4006,1,'Southeastern'),
(4007,1,'Southwestern'),
(4008,1,'Vardar');

--
-- DDL for table `zone_to_locations`
--
DROP TABLE IF EXISTS `ac_zones_to_locations`;
CREATE TABLE `ac_zones_to_locations` (
  `zone_to_location_id` int(11) NOT NULL AUTO_INCREMENT,
  `country_id` int(11) NOT NULL,
  `zone_id` int(11) NOT NULL DEFAULT '0',
  `location_id` int(11) NOT NULL,
  `date_added` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`zone_to_location_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci AUTO_INCREMENT=1;

CREATE INDEX `ac_zones_to_locations_idx` ON `ac_zones_to_locations` ( `country_id`, `zone_id`, `location_id` );

--
-- Dumping data for table `ac_zones_to_locations`
--

INSERT INTO `ac_zones_to_locations`
VALUES
(66,223,3677,1,NOW(),NOW()),
(65,223,3676,1,NOW(),NOW()),
(64,223,3675,1,NOW(),NOW()),
(63,223,3674,1,NOW(),NOW()),
(62,223,3673,1,NOW(),NOW()),
(61,223,3672,1,NOW(),NOW()),
(60,223,3671,1,NOW(),NOW()),
(59,223,3670,1,NOW(),NOW()),
(58,223,3669,1,NOW(),NOW()),
(57,223,3668,1,NOW(),NOW()),
(56,223,3667,1,NOW(),NOW()),
(55,223,3666,1,NOW(),NOW()),
(54,223,3665,1,NOW(),NOW()),
(53,223,3664,1,NOW(),NOW()),
(52,223,3663,1,NOW(),NOW()),
(51,223,3662,1,NOW(),NOW()),
(50,223,3661,1,NOW(),NOW()),
(49,223,3660,1,NOW(),NOW()),
(48,223,3659,1,NOW(),NOW()),
(47,223,3658,1,NOW(),NOW()),
(46,223,3657,1,NOW(),NOW()),
(45,223,3656,1,NOW(),NOW()),
(44,223,3655,1,NOW(),NOW()),
(43,223,3654,1,NOW(),NOW()),
(42,223,3653,1,NOW(),NOW()),
(41,223,3652,1,NOW(),NOW()),
(40,223,3651,1,NOW(),NOW()),
(39,223,3650,1,NOW(),NOW()),
(38,223,3649,1,NOW(),NOW()),
(37,223,3648,1,NOW(),NOW()),
(36,223,3647,1,NOW(),NOW()),
(35,223,3646,1,NOW(),NOW()),
(34,223,3645,1,NOW(),NOW()),
(33,223,3644,1,NOW(),NOW()),
(32,223,3643,1,NOW(),NOW()),
(31,223,3642,1,NOW(),NOW()),
(30,223,3641,1,NOW(),NOW()),
(29,223,3640,1,NOW(),NOW()),
(28,223,3639,1,NOW(),NOW()),
(27,223,3638,1,NOW(),NOW()),
(26,223,3637,1,NOW(),NOW()),
(25,223,3636,1,NOW(),NOW()),
(24,223,3635,1,NOW(),NOW()),
(23,223,3634,1,NOW(),NOW()),
(22,223,3633,1,NOW(),NOW()),
(21,223,3632,1,NOW(),NOW()),
(20,223,3631,1,NOW(),NOW()),
(19,223,3630,1,NOW(),NOW()),
(18,223,3629,1,NOW(),NOW()),
(17,223,3628,1,NOW(),NOW()),
(16,223,3627,1,NOW(),NOW()),
(15,223,3626,1,NOW(),NOW()),
(14,223,3625,1,NOW(),NOW()),
(13,223,3624,1,NOW(),NOW()),
(12,223,3623,1,NOW(),NOW()),
(11,223,3622,1,NOW(),NOW()),
(10,223,3621,1,NOW(),NOW()),
(9,223,3620,1,NOW(),NOW()),
(8,223,3619,1,NOW(),NOW()),
(7,223,3618,1,NOW(),NOW()),
(6,223,3617,1,NOW(),NOW()),
(5,223,3616,1,NOW(),NOW()),
(4,223,3615,1,NOW(),NOW()),
(3,223,3614,1,NOW(),NOW()),
(2,223,3613,1,NOW(),NOW()),
(67,38,602,2,NOW(),NOW()),
(68,38,603,2,NOW(),NOW()),
(69,38,604,2,NOW(),NOW()),
(70,38,605,2,NOW(),NOW()),
(71,38,606,2,NOW(),NOW()),
(72,38,607,2,NOW(),NOW()),
(73,38,608,2,NOW(),NOW()),
(74,38,609,2,NOW(),NOW()),
(75,38,610,2,NOW(),NOW()),
(76,38,611,2,NOW(),NOW()),
(77,38,612,2,NOW(),NOW()),
(78,38,613,2,NOW(),NOW()),
(79,38,614,2,NOW(),NOW());


--
-- DDL for table `pages`
--
DROP TABLE IF EXISTS `ac_pages`;
CREATE TABLE `ac_pages` (
  `page_id` int(10) NOT NULL auto_increment,
  `parent_page_id` int(10) NOT NULL DEFAULT '0',
  `controller` varchar(100) NOT NULL,
  `key_param` varchar(40) NOT NULL default '', -- Example product_id identifies unique product page
  `key_value` varchar(40) NOT NULL default '', -- Example 10 identifies unique product ID
  `date_added` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY  (`page_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
CREATE UNIQUE INDEX `ac_pages_idx`
ON `ac_pages` ( `page_id`, `controller`, `key_param`, `key_value` );

--
-- Dumping data for table `pages`
--

INSERT INTO `ac_pages` (`page_id`, `parent_page_id`, `controller`, `key_param`, `key_value`, `date_added`)
VALUES
(1, 0, 'generic', '', '', now() ),
(2, 0, 'pages/index/home', '', '', now() ),
(4, 0, 'pages/account/login', '', '', now() ),
(5, 0, 'pages/product/product', '', '', now()),
(10, 0, 'pages/index/maintenance', '', '', now() ),
(11, 0, 'pages/account', '', '', now() ),
(12, 0, 'pages/checkout/cart', '', '', now() ),
(13, 0, 'pages/product/category', '', '', now() ),
(14, 0, 'pages/checkout/fast_checkout', '', '', NOW()),
(15, 0, 'pages/checkout/fast_checkout_success', '', '', NOW())
;

--
-- DDL for table `page_descriptions`
--

DROP TABLE IF EXISTS `ac_page_descriptions`;
CREATE TABLE `ac_page_descriptions` (
  `page_id` int(10) NOT NULL DEFAULT '0',
  `language_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL COMMENT 'translatable',
  `title` varchar(255) NOT NULL COMMENT 'translatable',
  `seo_url` varchar(100) NOT NULL DEFAULT '',
  `keywords` varchar(255) NOT NULL DEFAULT '' COMMENT 'translatable',
  `description` varchar(255) NOT NULL DEFAULT '' COMMENT 'translatable',
  `content` text DEFAULT NULL COMMENT 'translatable', -- Contain the page details if custom content
  `date_added` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`page_id`,`language_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `ac_page_descriptions` (`page_id`, `language_id`, `name`, `title`, `seo_url`, `keywords`, `description`, `content`, `date_added`) VALUES
(1, 1, 'All Other Pages', '', '', '', '', '', now() ),
(2, 1, 'Home Page', '', '', '', '', '', now() ),
(4, 1, 'Login Page', '', '', '', '', '', now() ),
(5, 1, 'Default Product Page', '', '', '', '', '', now() ),
(10, 1, 'Maintenance Page', '', '', '', '', '', now() ),
(11, 1, 'Customer Account Pages', '', '', '', '', '', now() ),
(12, 1, 'Cart Page', '', '', '', '', '', now() ),
(14, 1, 'Fast Checkout Page', '', '', '', '', '', NOW()),
(15, 1, 'Fast Checkout Success Page', '', '', '', '', '', NOW())
;

--
-- DDL for table `contents`
--
DROP TABLE IF EXISTS `ac_contents`;
CREATE TABLE `ac_contents` (
    `content_id` int(11) NOT NULL AUTO_INCREMENT,
	`parent_content_id` int(11) NOT NULL DEFAULT 0,
    `sort_order` int(3) NOT NULL DEFAULT '0',
    `status` int(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`content_id`,`parent_content_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci AUTO_INCREMENT=1;

--
-- Dumping data for table `contents`
--

INSERT INTO `ac_contents` (`content_id`, `sort_order`, `status`) VALUES
(1, 1, 1),
(2, 2, 1),
(3, 3, 1),
(4, 4, 1);

--
-- DDL for table `content_descriptions`
--

DROP TABLE IF EXISTS `ac_content_descriptions`;
CREATE TABLE `ac_content_descriptions` (
  `content_id` int(10) NOT NULL DEFAULT '0',
  `language_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL COMMENT 'translatable',
  `title` varchar(255) NOT NULL COMMENT 'translatable',
  `description` varchar(255) NOT NULL DEFAULT '' COMMENT 'translatable',
  `meta_keywords` varchar(255) NOT NULL COMMENT 'translatable',
  `meta_description` varchar(255) NOT NULL COMMENT 'translatable',
  `content` longtext NOT NULL COMMENT 'translatable', -- Contain the page details if custom content
  `date_added` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`content_id`,`language_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `ac_content_descriptions` (`content_id`, `language_id`, `name`, `title`, `description`, `content`, `date_added`)
VALUES
(1, 1, 'About Us', 'About Us', 'some description', 'text about your store', now() ),
(2, 1, 'Privacy Policy', 'Privacy Policy', 'some description', 'some text about privacy policy', now()),
(3, 1, 'Return Policy', 'Return Policy', 'some description', 'some text about return policy', now()),
(4, 1, 'Shipping', 'Shipping', 'some description', 'some text about shipping', now()),

(1, 9, 'Acerca de Nosotros', 'Acerca de Nosotros', 'alguna descripción', 'texto acerca de su tienda', now() ),
(2, 9, 'Política de Privacidad', 'Política de Privacidad', 'alguna descripción', 'un texto sobre la política', now()),
(3, 9, 'Política de devoluciones', 'Política de devoluciones', 'alguna descripción', 'un texto sobre la política de retorno', now()),
(4, 9, 'Entrega', 'Entrega', 'alguna descripción', 'un texto sobre el envío', now());

--
-- DDL for table `content_to_store`
--
DROP TABLE IF EXISTS `ac_contents_to_stores`;
CREATE TABLE `ac_contents_to_stores` (
  `content_id` int(11) NOT NULL,
  `store_id` int(11) NOT NULL,
  PRIMARY KEY (`content_id`,`store_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;


--
-- DDL for table `blocks`
--
DROP TABLE IF EXISTS `ac_blocks`;
CREATE TABLE `ac_blocks` (
  `block_id` int(10) NOT NULL auto_increment,
  `block_txt_id` varchar(255) NOT NULL,
  `controller` varchar(255) NOT NULL,
  `date_added` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY  (`block_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `ac_blocks` (`block_id`, `block_txt_id`, `controller`, `date_added`) VALUES
(1, 'header', 'common/header', now() ),
(2, 'header_bottom', 'common/header_bottom', now() ),
(3, 'column_left', 'common/column_left', now() ),
(4, 'content_top', 'common/content_top', now() ),
(5, 'content_bottom', 'common/content_bottom', now() ),
(6, 'column_right', 'common/column_right', now() ),
(7, 'footer_top', 'common/footer_top', now() ),
(8, 'footer', 'common/footer', now() ),
(9, 'category', 'blocks/category', now() ),
(10, 'manufacturer', 'blocks/manufacturer', now() ),
(11, 'content', 'blocks/content', now() ),
(12, 'latest', 'blocks/latest', now() ),
(13, 'language', 'blocks/language', now() ),
(14, 'currency', 'blocks/currency', now() ),
(15, 'cart', 'blocks/cart', now() ),
(16, 'order_summary', 'blocks/order_summary', now() ),
(17, 'html_block', 'blocks/html_block', now() ),
(18, 'bestsellers', 'blocks/bestseller', now() ),
(19, 'featured', 'blocks/featured', now() ),
(20, 'listing_block', 'blocks/listing_block', now() ),
(21, 'donate', 'blocks/donate', now() ),
(22, 'special', 'blocks/special', now() ),
(23, 'banner_block', 'blocks/banner_block', now() ),
(24, 'credit_cards', 'blocks/credit_cards', now() ),
(25, 'newsletter_signup', 'blocks/newsletter_signup', now() ),
(26, 'search', 'blocks/search', now() ),
(27, 'menu', 'blocks/menu', now() ),
(28, 'breadcrumbs', 'blocks/breadcrumbs', now() ),
(29, 'account', 'blocks/account', now()),
(30, 'custom_form_block', 'blocks/custom_form_block', now() ),
(31, 'customer', 'blocks/customer', now() ),
(32, 'fast_checkout_cart_btn', 'blocks/fast_checkout_cart_btn', NOW()),
(33, 'fast_checkout_summary', 'blocks/fast_checkout_summary', NOW()),
(34, 'viewed_products','blocks/viewed_products',NOW())
;

--
-- DDL for table `ac_custom_blocks`
--

DROP TABLE IF EXISTS `ac_custom_blocks`;
CREATE TABLE `ac_custom_blocks` (
  `custom_block_id` int(10) NOT NULL auto_increment,
  `block_id` int(10) NOT NULL,
  `date_added` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`custom_block_id`, `block_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

--
-- DDL for table `ac_custom_lists`
--

DROP TABLE IF EXISTS `ac_custom_lists`;
CREATE TABLE `ac_custom_lists` (
	`rowid` INT(11) NOT NULL AUTO_INCREMENT,
  `custom_block_id` int(10) NOT NULL,
  `data_type` varchar(70) NOT NULL,
  `id` int(10) NOT NULL,
  `store_id` int(10),
  `sort_order` int(10) NOT NULL DEFAULT 0,
  `date_added` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
	PRIMARY KEY (`rowid`),
	INDEX `ac_custom_block_id_list_idx` (`custom_block_id`, `store_id` )
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

--
-- DDL for table `block_descriptions`
--

DROP TABLE IF EXISTS `ac_block_descriptions`;
CREATE TABLE `ac_block_descriptions` (
  `block_description_id` int(10) NOT NULL auto_increment,
  `custom_block_id` int(10) NOT NULL,
  `language_id` int(10) NOT NULL,
  `block_wrapper` varchar(255) NOT NULL default '0',
  `block_framed` tinyint(1) DEFAULT '0',
  `name` varchar(255) NOT NULL COMMENT 'translatable',
  `title` varchar(255) NOT NULL COMMENT 'translatable',
  `description` varchar(255) NOT NULL DEFAULT '' COMMENT 'translatable',
  `content` longtext NOT NULL DEFAULT '', -- Contain the block details if custom content
  `date_added` timestamp DEFAULT CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`block_description_id`, `custom_block_id`, `language_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

--
-- DDL for table `block_templates`
--

DROP TABLE IF EXISTS `ac_block_templates`;
CREATE TABLE `ac_block_templates` (
  `block_id` int(10) NOT NULL auto_increment,
  `parent_block_id` int(10) NOT NULL DEFAULT 0, -- Placeholder where this block can be placed. 0 - any location
  `template` varchar(255) NOT NULL,
  `date_added` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY  (`block_id`, `parent_block_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `ac_block_templates` (`block_id`, `parent_block_id`, `template`, `date_added`) VALUES
(15, 1, 'blocks/cart_top.tpl', now() ),
(15, 6, 'blocks/cart.tpl', now() ),
(9, 1, 'blocks/category_top.tpl', now()),
(9, 2, 'blocks/category_top.tpl', now()),
(9, 3, 'blocks/category.tpl', now() ),
(9, 6, 'blocks/category.tpl', now() ),
(9, 7, 'blocks/category_bottom.tpl', now() ),
(9, 8, 'blocks/category_bottom.tpl', now() ),
(10, 3, 'blocks/manufacturer.tpl', now() ),
(10, 6, 'blocks/manufacturer.tpl', now() ),
(11, 3, 'blocks/content.tpl', now() ),
(11, 1, 'blocks/content_header.tpl', now() ),
(11, 6, 'blocks/content.tpl', now() ),
(11, 8, 'blocks/content_footer.tpl', now() ),
(12, 3, 'blocks/latest.tpl', now() ),
(12, 6, 'blocks/latest.tpl', now() ),
(12, 5, 'blocks/latest_home.tpl', now() ),
(12, 4, 'blocks/latest_home.tpl', now()),
(13, 1, 'blocks/language.tpl', now() ),
(14, 1, 'blocks/currency.tpl', now() ),
(16, 6, 'blocks/order_summary.tpl', now() ),
(17, 1, 'blocks/html_block_header.tpl', now() ),
(17, 2, 'blocks/html_block_content.tpl', now() ),
(17, 3, 'blocks/html_block.tpl', now() ),
(17, 4, 'blocks/html_block_content.tpl', now() ),
(17, 5, 'blocks/html_block_content.tpl', now() ),
(17, 6, 'blocks/html_block.tpl', now() ),
(17, 7, 'blocks/html_block_content.tpl', now() ),
(17, 8, 'blocks/html_block_footer.tpl', now() ),
(18, 3, 'blocks/bestseller.tpl', now() ),
(18, 6, 'blocks/bestseller.tpl', now() ),
(18, 5, 'blocks/bestseller_home.tpl', now() ),
(19, 3, 'blocks/featured.tpl', now() ),
(19, 6, 'blocks/featured.tpl', now() ),
(19, 5, 'blocks/featured_home.tpl', now() ),
(20, 1, 'blocks/listing_block_header.tpl', now() ),
(20, 2, 'blocks/listing_block_header_bottom.tpl', now() ),
(20, 3, 'blocks/listing_block_column_left.tpl', now() ),
(20, 4, 'blocks/listing_block_content_top.tpl', now() ),
(20, 5, 'blocks/listing_block_content_bottom.tpl', now() ),
(20, 6, 'blocks/listing_block_column_right.tpl', now() ),
(20, 7, 'blocks/listing_block_footer_top.tpl', now() ),
(20, 8, 'blocks/listing_block_footer.tpl', now() ),
(21, 8, 'blocks/donate.tpl', now() ),
(22, 3, 'blocks/special.tpl', now() ),
(22, 5, 'blocks/special_home.tpl', now() ),
(22, 6, 'blocks/special.tpl', now() ),
(23, 1, 'blocks/banner_block_header.tpl', NOW() ),
(23, 2, 'blocks/banner_block_content.tpl', NOW() ),
(23, 3, 'blocks/banner_block.tpl', NOW() ),
(23, 4, 'blocks/banner_block_content.tpl', NOW() ),
(23, 5, 'blocks/banner_block_content.tpl', NOW() ),
(23, 6, 'blocks/banner_block.tpl', NOW() ),
(23, 7, 'blocks/banner_block_content.tpl', NOW() ),
(23, 8, 'blocks/banner_block_header.tpl', NOW() ),
(24, 8, 'blocks/credit_cards.tpl', now() ),
(25, 1, 'blocks/newsletter_signup_header.tpl', now() ),
(25, 2, 'blocks/newsletter_signup_header_bottom.tpl', now() ),
(25, 3, 'blocks/newsletter_signup_column_left.tpl', now() ),
(25, 4, 'blocks/newsletter_signup_content_top.tpl', now() ),
(25, 5, 'blocks/newsletter_signup_content_bottom.tpl', now() ),
(25, 6, 'blocks/newsletter_signup_column_right.tpl', now() ),
(25, 7, 'blocks/newsletter_signup_footer_top.tpl', now() ),
(25, 8, 'blocks/newsletter_signup_footer.tpl', now() ),
(26, 1, 'blocks/search_top.tpl', now() ),
(26, 2, 'blocks/search_top.tpl', now() ),
(26, 3, 'blocks/search.tpl', now() ),
(26, 6, 'blocks/search.tpl', now() ),
(27, 1, 'blocks/menu_top.tpl', now() ),
(27, 2, 'blocks/menu.tpl', now()),
(27, 8, 'blocks/menu_bottom.tpl', now() ),
(27, 3, 'blocks/menu.tpl', now() ),
(27, 6, 'blocks/menu.tpl', now() ),
(28, 2, 'blocks/breadcrumbs.tpl', now() ),
(29, 3, 'blocks/account.tpl', now() ),
(29, 6, 'blocks/account.tpl', now() ),
(30, 1, 'blocks/custom_form_block_header.tpl', NOW() ),
(30, 2, 'blocks/custom_form_block_content.tpl', NOW() ),
(30, 3, 'blocks/custom_form_block.tpl', NOW() ),
(30, 4, 'blocks/custom_form_block_content.tpl', NOW() ),
(30, 5, 'blocks/custom_form_block_content.tpl', NOW() ),
(30, 6, 'blocks/custom_form_block.tpl', NOW() ),
(30, 7, 'blocks/custom_form_block_content.tpl', NOW() ),
(30, 8, 'blocks/custom_form_block_header.tpl', NOW() ),
(31, 1, 'blocks/customer.tpl', now() ),
(32, 1, 'blocks/fast_checkout_cart_btn.tpl', NOW()),
(33, 6, 'blocks/fast_checkout_summary.tpl', NOW()),
(34, 1, 'blocks/viewed_block_column_header.tpl',NOW()),
(34, 2, 'blocks/viewed_block_column_header_bottom.tpl',NOW()),
(34, 4, 'blocks/viewed_block_column_content_top.tpl',NOW()),
(34, 5, 'blocks/viewed_block_column_content_bottom.tpl',NOW()),
(34, 7, 'blocks/viewed_block_column_footer_top.tpl',NOW()),
(34, 8, 'blocks/viewed_block_column_footer.tpl',NOW()),
(34, 6, 'blocks/viewed_block_column_right.tpl',NOW()),
(34, 3, 'blocks/viewed_block_column_left.tpl',NOW())
;

--
-- DDL for table `layouts`
--

DROP TABLE IF EXISTS `ac_layouts`;
CREATE TABLE `ac_layouts` (
  `layout_id` int(10) NOT NULL auto_increment,
  `template_id` varchar(100) NOT NULL,
  `layout_name` varchar(255) NOT NULL default '',
  `layout_type` smallint(1) NOT NULL default '0', -- 0 Default, 1 Active layout, 2 draft layout, 3 template layout
  `date_added` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY  (`layout_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `ac_layouts` (`layout_id`, `template_id`, `layout_type`, `layout_name`, `date_added`) VALUES
(23, 'default',0, 'Default Page Layout',NOW()),
(24, 'default',1, 'Home Page',NOW()),
(25, 'default',1, 'Login Page',NOW()),
(26, 'default',1, 'Default Product Page',NOW()),
(27, 'default',1, 'Product Listing Page',NOW()),
(28, 'default',1, 'Maintenance Page',NOW()),
(29, 'default',1, 'Customer Account Pages',NOW()),
(30, 'default',1, 'Cart Page',NOW()),
(31, 'default',1, 'Fast Checkout Page',NOW()),
(32, 'default',1, 'Fast Checkout Success Page',NOW());

--
-- DDL for table `pages_layouts`
--
DROP TABLE IF EXISTS `ac_pages_layouts`;
CREATE TABLE `ac_pages_layouts` (
  `layout_id` int(10) NOT NULL,
  `page_id` int(10) NOT NULL,
  PRIMARY KEY  (`layout_id`,`page_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `ac_pages_layouts` (`layout_id`, `page_id`) VALUES
( 23,1),
( 24,2),
( 25,4),
( 26,5),
( 27,13),
( 28,10),
( 29,11),
( 30,12),
( 31,14),
( 32,15);

--
-- DDL for table `block_layouts`
--
DROP TABLE IF EXISTS `ac_block_layouts`;
CREATE TABLE `ac_block_layouts` (
  `instance_id` int(10) NOT NULL auto_increment,
  `layout_id` int(10) NOT NULL default '0',
  `block_id` int(10) NOT NULL default '0',
  `custom_block_id` int(10) NOT NULL default '0',
  `parent_instance_id` int(10) NOT NULL default '0', -- 0 for main level block
  `position` smallint(5) NOT NULL default '0',
  `status` smallint(1) NOT NULL default '0',
  `date_added` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `date_modified` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY  (`instance_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
CREATE UNIQUE INDEX `ac_block_layouts_idx`
ON `ac_block_layouts` ( `instance_id`, `layout_id`, `block_id`, `parent_instance_id`,`custom_block_id` );

--
-- DDL for table `forms_pages`
--
DROP TABLE IF EXISTS `ac_pages_forms`;
CREATE TABLE `ac_pages_forms` (
  `page_id` int(10) NOT NULL,
  `form_id` int(10) NOT NULL,
  PRIMARY KEY  (`form_id`,`page_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;


--
-- DDL for table `forms`
--
DROP TABLE IF EXISTS `ac_forms`;
CREATE TABLE `ac_forms` (
  `form_id` int(11) NOT NULL auto_increment,
  `form_name` varchar(40) NOT NULL default '',
  -- used to create css ID and name for form tag
  `controller` varchar(100) NOT NULL default '',
  `success_page` varchar(100) NOT NULL default '',
  `status` smallint(1) NOT NULL default '0',
  PRIMARY KEY  (`form_id`),
  UNIQUE KEY `form_name` (`form_name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci AUTO_INCREMENT=1;

INSERT INTO `ac_forms` VALUES (2,'ContactUsFrm','content/contact','content/contact/success',1);

--
-- DDL for table `form_descriptions`
--
DROP TABLE IF EXISTS `ac_form_descriptions`;
CREATE TABLE `ac_form_descriptions` (
  `form_id` int(11) NOT NULL DEFAULT '0',
  `language_id` int(11) NOT NULL,
  `description` varchar(255) NOT NULL DEFAULT '' COMMENT 'translatable',
  PRIMARY KEY (`form_id`,`language_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `ac_form_descriptions` VALUES (2,1,'Contact Us Form');

--
-- DDL for table `fields`
--
DROP TABLE IF EXISTS `ac_fields`;
CREATE TABLE `ac_fields` (
  `field_id` int(11) NOT NULL auto_increment,
  `form_id` int(11) NOT NULL DEFAULT '0',
  `field_name` varchar(40) NOT NULL,
  -- used to create css ID (form_name + field_name) and name for input tag tag
  `element_type` char(1) NOT NULL DEFAULT 'I',
  -- I - text input, T - Text area, S - Select, M - multivalue select, C - Checkbox, R - radio buttons, U - File upload, H - Hidden, G -Checkbox Group, D - Date, E - time, K - Captcha
  `sort_order` int(3) NOT NULL,
  `attributes` varchar(255) NOT NULL,
  `settings` text COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `required` char(1) NOT NULL DEFAULT 'N',
  -- N - Not required, Y - required
  `status` smallint(1) NOT NULL default '0',
  `regexp_pattern` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`field_id`),
  KEY `field_id` (`field_id`, `form_id`, `status`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `ac_fields`
(field_id, form_id, field_name, element_type, sort_order, attributes,settings, required, regexp_pattern, status)
VALUES
(11,2,'first_name','I',1,'','','Y','/^.{3,100}$/u',1),
(12,2,'email','I',2,'','','Y','/^[A-Z0-9._%-]+@[A-Z0-9.-]{0,61}[A-Z0-9]\.[A-Z]{2,16}$/i',1),
(13,2,'enquiry','T',3,'cols="50" rows="8"','','Y','/^.{3,1000}$/su',1),
(14,2,'captcha','K',4,'','','Y','',1);

--
-- DDL for table `field_descriptions`
--
DROP TABLE IF EXISTS `ac_field_descriptions`;
CREATE TABLE `ac_field_descriptions` (
  `field_id` int(11) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL COMMENT 'translatable',
  `description` varchar(255) NOT NULL DEFAULT '' COMMENT 'translatable',
  `language_id` int(11) NOT NULL,
  `error_text` varchar(255) NOT NULL DEFAULT '' COMMENT 'translatable',
  PRIMARY KEY (`field_id`,`language_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `ac_field_descriptions` (`field_id`, `name`, `error_text`, `language_id`)
VALUES
(11,'First name:','Name must be between 3 and 32 characters!',1),
(12,'Email:','E-Mail Address does not appear to be valid!',1),
(13,'Enquiry:','Enquiry must be between 10 and 3000 characters!',1),
(14,'Enter the code in the box below:','Human verification has failed! Please try agan.',1);

--
-- DDL for table `ac_field_values`
--
DROP TABLE IF EXISTS `ac_field_values`;
CREATE TABLE `ac_field_values` (
  `value_id` int(11) NOT NULL auto_increment,
  `field_id` int(11) NOT NULL DEFAULT '0',
  `value` text COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT 'translatable',
  `language_id` int(11) NOT NULL,
  PRIMARY KEY (`value_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

--
-- DDL for table `fields_groups`
--
DROP TABLE IF EXISTS `ac_form_groups`;
CREATE TABLE `ac_form_groups` (
  `group_id` int(11) NOT NULL AUTO_INCREMENT,
  `group_name` varchar(40) NOT NULL default '',
  `form_id` int(11) NOT NULL DEFAULT '0',
  `sort_order` int(3) NOT NULL,
  `status` smallint(1) NOT NULL default '0',
  PRIMARY KEY (`group_id`),
  KEY `group_id` (`group_id`, `form_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

--
-- DDL for table `fields_groups`
--
DROP TABLE IF EXISTS `ac_fields_groups`;
CREATE TABLE `ac_fields_groups` (
  `field_id` int(11) NOT NULL,
  `group_id` int(11) NOT NULL,
  `sort_order` int(3) NOT NULL,
  PRIMARY KEY (`field_id`),
  KEY `field_id` (`field_id`, `group_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

--
-- DDL for table `fields_group_descriptions`
--
DROP TABLE IF EXISTS `ac_fields_group_descriptions`;
CREATE TABLE `ac_fields_group_descriptions` (
  `group_id` int(11) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL COMMENT 'translatable',
  `description` varchar(255) NOT NULL DEFAULT '' COMMENT 'translatable',
  `language_id` int(11) NOT NULL,
  PRIMARY KEY (`group_id`,`language_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;


--
-- DDL for table `ac_messages`
--
DROP TABLE IF EXISTS `ac_messages`;
CREATE TABLE `ac_messages` (
  `msg_id` int(11) NOT NULL auto_increment,
  `title` varchar(128) NOT NULL default '',
  `message` text NOT NULL,
  `status` char(1) NOT NULL default '',
  `viewed` int(11) NOT NULL default '0',
  `repeated` int(11) NOT NULL default '0',
  `date_added` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY  (`msg_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci AUTO_INCREMENT=1;

--
-- DDL for table `ac_ant_messages`
--
DROP TABLE IF EXISTS `ac_ant_messages`;
CREATE TABLE `ac_ant_messages` (
  `id` varchar(60) NOT NULL,
  `priority` int(11) NOT NULL DEFAULT 0,
  `start_date` timestamp NULL,
  `end_date` timestamp,
  `viewed_date` timestamp,
  `viewed` int(11) NOT NULL default '0',
  `title` varchar(255) DEFAULT NULL,
  `description` text,
  `html` longtext,
  `url` text,
  `language_code` varchar(2) NOT NULL DEFAULT 'en',
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`, `language_code`),
  KEY `daterange_idx` (`start_date`,`end_date`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;


--
-- DDL for table `ac_datasets`
--
DROP TABLE IF EXISTS `ac_datasets`;
CREATE TABLE `ac_datasets` (
  `dataset_id` int(11) NOT NULL AUTO_INCREMENT,
  `dataset_name` varchar(255) CHARACTER SET utf8 NOT NULL,
  `dataset_key` varchar(255) CHARACTER SET utf8 default '',
  PRIMARY KEY (`dataset_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci AUTO_INCREMENT=1;


--
-- DDL for table `ac_dataset_properties`
--
DROP TABLE IF EXISTS `ac_dataset_properties`;
CREATE TABLE `ac_dataset_properties` (
	`rowid` int(11) NOT NULL AUTO_INCREMENT,
  `dataset_id` int(11) NOT NULL,
  `dataset_property_name` varchar(255) NOT NULL,
  `dataset_property_value` varchar(255),
	PRIMARY KEY (`rowid`),
  KEY `dataset_property_idx` (`dataset_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci  AUTO_INCREMENT=1;

--
-- DDL for table `ac_dataset_definition`
--
DROP TABLE IF EXISTS `ac_dataset_definition`;
CREATE TABLE `ac_dataset_definition` (
  `dataset_id` int(11) NOT NULL,
  `dataset_column_id` int(11) NOT NULL AUTO_INCREMENT,
  `dataset_column_name` varchar(255) NOT NULL,
  `dataset_column_type` varchar(100) NOT NULL,
  `dataset_column_sort_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`dataset_column_id`),
  KEY `dataset_definition_idx` (`dataset_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci AUTO_INCREMENT=1;

--
-- DDL for table `ac_dataset_column_properties`
--
DROP TABLE IF EXISTS `ac_dataset_column_properties`;
CREATE TABLE `ac_dataset_column_properties` (
	`rowid` INT(11) NOT NULL AUTO_INCREMENT,
  `dataset_column_id` int(11) NOT NULL,
  `dataset_column_property_name` varchar(255) NOT NULL,
  `dataset_column_property_value` varchar(255) DEFAULT NULL,
	PRIMARY KEY (`rowid`),
  KEY `dataset_column_properties_idx` (`dataset_column_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci  AUTO_INCREMENT=1;

--
-- DDL for table `ac_dataset_values`
--
DROP TABLE IF EXISTS `ac_dataset_values`;
CREATE TABLE `ac_dataset_values` (
  `dataset_column_id` int(11) NOT NULL,
  `value_integer` int(11) DEFAULT NULL,
  `value_float` float DEFAULT NULL,
  `value_varchar` varchar(255) DEFAULT NULL,
  `value_text` text,
  `value_timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `value_boolean` tinyint(1) DEFAULT NULL,
  `value_sort_order` int(11) NOT NULL AUTO_INCREMENT,
  `row_id` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`value_sort_order`),
  KEY `dataset_values_idx` (`value_integer`,`value_float`,`value_varchar`,`value_boolean`,`row_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
--
-- Storefront menu inserts
--
INSERT INTO `ac_datasets` (`dataset_name`,`dataset_key`) VALUES ('menu','storefront');
INSERT INTO `ac_dataset_properties` (`dataset_id`,`dataset_property_name`,`dataset_property_value`) VALUES ('1','controller','design/menu');


INSERT INTO `ac_dataset_definition` (`dataset_id`,`dataset_column_name`,`dataset_column_type`,`dataset_column_sort_order`)
VALUES  (1,'item_id','varchar',1),
        (1,'item_icon','varchar',2),
        (1,'item_url','varchar',3),
        (1,'parent_id','varchar',4),
        (1,'sort_order','integer',5),
        (1,'item_type','varchar',6),
        (1,'item_icon_rl_id','integer',7),
        (1,'settings','text',8);
-- ITEM_ID
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES  (1,'home',1),
        (1,'login',2),
        (1,'logout',3),
        (1,'account',4),
        (1,'cart',5),
        (1,'checkout',6),
        (1,'specials',7),
        (1,'order',8);

-- ITEM_ICON
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES  (2,'',1),
        (2,'',2),
        (2,'',3),
        (2,'',4),
        (2,'',5),
        (2,'',6),
        (2,'',7),
        (2,'',8);
-- ITEM_URL
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES  (3,'index/home',1),
        (3,'account/login',2),
        (3,'account/logout',3),
        (3,'account/account',4),
        (3,'checkout/cart',5),
        (3,'checkout/fast_checkout',6),
        (3,'product/special',7),
        (3,'account/order_details',8);
-- PARENT_ID
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES  (4,'',1),
        (4,'account',2),
        (4,'account',3),
        (4,'',4),
        (4,'',5),
        (4,'',6),
        (4,'',7),
        (4,'account',8);
-- SORT_ORDER
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_integer`,`row_id`)
VALUES  (5,10,1),
        (5,11,2),
        (5,12,3),
        (5,20,4),
        (5,30,5),
        (5,50,6),
        (5,60,7),
        (5,13,8);
-- ITEM_TYPE
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES  (6,'core',1),
        (6,'core',2),
        (6,'core',3),
        (6,'core',4),
        (6,'core',5),
        (6,'core',6),
        (6,'core',7),
        (6,'core',8);
-- item_icon_rl_id
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_integer`,`row_id`)
VALUES  (7,'2',1),
        (7,'4',2),
        (7,'3',3),
        (7,'4',4),
        (7,'250',5),
       	(7,'260',6),
       	(7,'244',7),
       	(7,'266',8);
-- settings
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_text`,`row_id`)
VALUES  (8,'a:3:{s:6:"status";s:1:"1";s:16:"include_children";s:1:"0";s:6:"target";s:5:"_self";}',1),
        (8,'a:3:{s:6:"status";s:1:"1";s:16:"include_children";s:1:"0";s:6:"target";s:5:"_self";}',2),
        (8,'a:3:{s:6:"status";s:1:"1";s:16:"include_children";s:1:"0";s:6:"target";s:5:"_self";}',3),
        (8,'a:3:{s:6:"status";s:1:"1";s:16:"include_children";s:1:"0";s:6:"target";s:5:"_self";}',4),
        (8,'a:3:{s:6:"status";s:1:"1";s:16:"include_children";s:1:"0";s:6:"target";s:5:"_self";}',5),
       	(8,'a:3:{s:6:"status";s:1:"1";s:16:"include_children";s:1:"0";s:6:"target";s:5:"_self";}',6),
       	(8,'a:3:{s:6:"status";s:1:"1";s:16:"include_children";s:1:"0";s:6:"target";s:5:"_self";}',7),
       	(8,'a:3:{s:6:"status";s:1:"1";s:16:"include_children";s:1:"0";s:6:"target";s:5:"_self";}',8);

--
-- ADMIN MENU SECTION
--
INSERT INTO `ac_datasets` (`dataset_name`,`dataset_key`) VALUES ('menu','admin');
INSERT INTO `ac_dataset_definition` (`dataset_id`,`dataset_column_id`,`dataset_column_name`,`dataset_column_type`,`dataset_column_sort_order`)
VALUES  (2,10, 'item_id','varchar',1),
        (2,11, 'item_text','varchar',2),
        (2,12, 'item_url','varchar',3),
        (2,13, 'parent_id','varchar',4),
        (2,14, 'sort_order','integer',5),
        (2,15, 'item_type','varchar',6),
        (2,40, 'item_icon_rl_id','varchar',7);
--
-- MAIN (PARENT) MENU
--
--
-- ITEM_ID
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES  (10,'catalog',1),
        (10,'sale',2),
        (10,'design',3),
        (10,'extension',4),
        (10,'system',5),
        (10,'reports',6),
        (10,'help',7);
-- ITEM_TEXT
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES  (11,'text_catalog',1),
        (11,'text_sale',2),
        (11,'text_design',3),
        (11,'text_extension',4),
        (11,'text_system',5),
        (11,'text_reports',6),
        (11,'text_help',7);
-- ITEM_URL
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES  (12,'catalog/category',1),
        (12,'sale/order',2),
        (12,'extension/extensions/template',3),
        (12,'extension/extensions/extensions',4),
        (12,'setting/setting',5),
        (12,'report/sale/orders',6),
        (12,'',7);
-- PARENT_ID
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES  (13,'',1),
        (13,'',2),
        (13,'',3),
        (13,'',4),
        (13,'',5),
        (13,'',6),
        (13,'',7);
-- SORT_ORDER
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_integer`,`row_id`)
VALUES  (14,1,1),
        (14,2,2),
        (14,3,3),
        (14,4,4),
        (14,5,5),
        (14,6,6),
        (14,7,7);
-- ITEM_TYPE
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES  (15,'core',1),
        (15,'core',2),
        (15,'core',3),
        (15,'core',4),
        (15,'core',5),
        (15,'core',6),
        (15,'core',7);
-- ITEM_RL_ID
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES  (40,'200',1),
        (40,'201',2),
        (40,'202',3),
        (40,'203',4),
        (40,'204',5),
        (40,'205',6),
        (40,'206',7);

--
-- SUBMENU CATALOG
-- ITEM_ID
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES  (10,'category',11),
        (10,'product',12),
        (10,'manufacturer',13),
        (10,'download',14),
        (10,'review',15),
        (10,'attributes',16),
        (10,'collections',17),
        (10,'rl_manager',220);
-- ITEM_TEXT
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES  (11,'text_category',11),
        (11,'text_product',12),
        (11,'text_manufacturer',13),
        (11,'text_download',14),
        (11,'text_review',15),
        (11,'text_attribute',16),
        (11,'text_collection',17),
        (11,'text_rl_manager',220);
-- ITEM_URL
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES  (12,'catalog/category',11),
        (12,'catalog/product',12),
        (12,'catalog/manufacturer',13),
        (12,'catalog/download',14),
        (12,'catalog/review',15),
        (12,'catalog/attribute',16),
        (12,'catalog/collections',17),
        (12,'tool/rl_manager',220);
-- PARENT_ID
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES  (13,'catalog',11),
        (13,'catalog',12),
        (13,'catalog',13),
        (13,'catalog',14),
        (13,'catalog',15),
        (13,'catalog',16),
        (13,'catalog',17),
        (13,'catalog',220);
-- SORT_ORDER
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_integer`,`row_id`)
VALUES  (14,1,11),
        (14,2,12),
        (14,3,13),
        (14,4,14),
        (14,5,15),
        (14,6,16),
        (14,8,17),
        (14,7,220);
-- ITEM_TYPE
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES  (15,'core',11),
        (15,'core',12),
        (15,'core',13),
        (15,'core',14),
        (15,'core',15),
        (15,'core',16),
        (15,'core',17),
        (15,'core',220);
-- ITEM_RL_ID
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES  (40,'207',11),
        (40,'208',12),
        (40,'209',13),
        (40,'210',14),
        (40,'211',15),
        (40,'212',16),
        (40,'279',17),
        (40,'277',220);

--
-- SUBMENU EXTENSION
-- ITEM_ID
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES  (10,'extensions',31),
        (10,'shipping',32),
        (10,'payment',33),
        (10,'templates',34),
        (10,'languages',35),
        (10,'taxes',36),
        (10,'total',37),
        (10,'add_extension',38),
        (10,'extensions_stores',39);
-- ITEM_TEXT
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES  (11,'text_extensions',31),
        (11,'text_shipping',32),
        (11,'text_payment',33),
        (11,'text_templates',34),
        (11,'text_language',35),
        (11,'text_taxes',36),
        (11,'text_total',37),
        (11,'text_add_extension',38),
        (11,'text_extensions_store',39);
-- ITEM_URL
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES  (12,'extension/extensions/extensions',31),
        (12,'extension/extensions/shipping',32),
        (12,'extension/extensions/payment',33),
        (12,'extension/extensions/template',34),
        (12,'extension/extensions/language',35),
        (12,'extension/extensions/tax',36),
        (12,'extension/total',37),
        (12,'tool/package_installer',38),
        (12,'extension/extensions_store',39);
-- PARENT_ID
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES  (13,'extension',31),
        (13,'extension',32),
        (13,'extension',33),
        (13,'extension',34),
        (13,'extension',35),
        (13,'extension',36),
        (13,'extension',37),
        (13,'extension',38),
        (13,'extension',39);
-- SORT_ORDER
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_integer`,`row_id`)
VALUES  (14,1,31),
        (14,2,32),
        (14,3,33),
        (14,4,34),
        (14,5,35),
        (14,6,36),
        (14,7,37),
        (14,8,38),
        (14,9,39);
-- ITEM_TYPE
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES  (15,'core',31),
        (15,'core',32),
        (15,'core',33),
        (15,'core',34),
        (15,'core',35),
        (15,'core',36),
        (15,'core',37);
-- ITEM_RL_ID
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES  (40,'213',31),
        (40,'214',32),
        (40,'260',33),
        (40,'216',34),
        (40,'217',35),
        (40,'215',36),
        (40,'218',37),
        (40,'219',38),
        (40,'220',39);

--
-- SUBMENU SALE
-- ITEM_ID
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES  (10,'order',51),
        (10,'customer',52),
        (10,'customer_group',53),
        (10,'coupon',54),
        (10,'contact',55);
-- ITEM_TEXT
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES  (11,'text_order',51),
        (11,'text_customer',52),
        (11,'text_customer_group',53),
        (11,'text_coupon',54),
        (11,'text_contact',55);
-- ITEM_URL
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES  (12,'sale/order',51),
        (12,'sale/customer',52),
        (12,'sale/customer_group',53),
        (12,'sale/coupon',54),
        (12,'sale/contact',55);
-- PARENT_ID
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES  (13,'sale',51),
        (13,'sale',52),
        (13,'sale',53),
        (13,'sale',54),
        (13,'sale',55);
-- SORT_ORDER
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_integer`,`row_id`)
VALUES  (14,1,51),
        (14,2,52),
        (14,3,53),
        (14,4,54),
        (14,5,55);
-- ITEM_TYPE
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES  (15,'core',51),
        (15,'core',52),
        (15,'core',53),
        (15,'core',54),
        (15,'core',55);
-- ITEM_RL_ID
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES  (40,'221',51),
        (40,'222',52),
        (40,'223',53),
        (40,'224',54),
        (40,'225',55);

--
-- SUBMENU SYSTEM
-- ITEM_ID
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES  (10,'setting',71),
        (10,'users',72),
        (10,'localisation',73),
        (10,'data',74),
        (10,'updater',77),
        (10,'cache',78),
        (10,'messages',79),
        (10,'logs',80);
-- ITEM_TEXT
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES  (11,'text_setting',71),
        (11,'text_users',72),
        (11,'text_localisation',73),
        (11,'text_data',74),
        (11,'text_updater',77),
        (11,'text_cache',78),
        (11,'text_messages',79),
        (11,'text_logs',80);
-- ITEM_URL
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES  (12,'setting/setting',71),
        (12,'',72),
        (12,'',73),
        (12,'',74),
        (12,'tool/updater',77),
        (12,'tool/cache',78),
        (12,'tool/message_manager',79),
        (12,'',80);
-- PARENT_ID
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES  (13,'system',71),
        (13,'system',72),
        (13,'system',73),
        (13,'system',74),
        (13,'system',77),
        (13,'system',78),
        (13,'system',79),
        (13,'system',80);
-- SORT_ORDER
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_integer`,`row_id`)
VALUES  (14,1,71),
        (14,2,72),
        (14,3,73),
        (14,4,74),
        (14,7,77),
        (14,8,78),
        (14,9,79),
        (14,10,80);
-- ITEM_TYPE
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES  (15,'core',71),
        (15,'core',72),
        (15,'core',73),
        (15,'core',74),
        (15,'core',77),
        (15,'core',78),
        (15,'core',79),
        (15,'core',80);
-- ITEM_RL_ID
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES  (40,'226',71),
        (40,'227',72),
        (40,'228',73),
        (40,'229',74),
        (40,'230',77),
        (40,'231',78),
        (40,'232',79),
        (40,'233',80);


--
-- SUBMENU REPORTS
-- ITEM_ID
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES  (10,'report_sale',91),
        (10,'report_customer',92),
        (10,'report_product',93),
        (10,'report_analytics',221),
        (10,'banner_manager_stat',94 );
-- ITEM_TEXT
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES  (11,'text_report_sale',91),
        (11,'text_customer',92),
        (11,'text_product',93),
        (11,'text_analytics',221),
        (11,'banner_manager_name_stat',94);
-- ITEM_URL
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES  (12,'report/sale/orders',91),
        (12,'report/customer/online',92),
        (12,'',93),
        (12,'',221),
        (12,'extension/banner_manager_stat',94);
-- PARENT_ID
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES  (13,'reports',91),
        (13,'reports',92),
        (13,'reports',93),
        (13,'reports',221),
        (13,'reports',94);
-- SORT_ORDER
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_integer`,`row_id`)
VALUES  (14,1,91),
        (14,2,92),
        (14,3,93),
        (14,4,221),
        (14,5,94);
-- ITEM_TYPE
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES  (15,'core',91),
        (15,'core',92),
        (15,'core',93),
        (15,'core',221),
        (15,'extension',94);

-- ITEM_RL_ID
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES  (40,'234',91),
        (40,'222',92),
        (40,'208',93),
        (40,'234',221),
        (40,'237',94);

--
-- SUBMENU HELP
-- ITEM_ID
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES  (10,'abantecart',111),
        (10,'documentation',112),
        (10,'support',113),
        (10,'marketplace',114);
-- ITEM_TEXT
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES  (11,'text_abantecart',111),
        (11,'text_documentation',112),
        (11,'text_support',113),
        (11,'text_extensions_store',114);
-- ITEM_URL
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES  (12,'window.open(\'http://www.abantecart.com\');',111),
        (12,'window.open(\'http://docs.abantecart.com\');',112),
        (12,'window.open(\'http://forum.abantecart.com\');',113),
        (12,'window.open(\'http://marketplace.abantecart.com\');',114);
-- PARENT_ID
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES  (13,'help',111),
        (13,'help',112),
        (13,'help',113),
        (13,'help',114);
-- SORT_ORDER
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_integer`,`row_id`)
VALUES  (14,1,111),
        (14,2,112),
        (14,3,113),
        (14,4,114);
-- ITEM_TYPE
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES  (15,'core',111),
        (15,'core',112),
        (15,'core',113),
        (15,'core',114);
-- ITEM_RL_ID
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES  (40,'238',111),
        (40,'239',112),
        (40,'240',113),
        (40,'203',114);

--
-- SUBMENU DESIGN
-- ITEM_ID
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES  (10,'template',131),
        (10,'layout',132),
        (10,'blocks',133),
        (10,'menu',134),
        (10,'content',135),
        (10,'banner_manager',136),
        (10,'forms_manager',200),
        (10,'email_templates',137);
-- ITEM_TEXT
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES  (11,'text_templates',131),
        (11,'text_layout',132),
        (11,'text_blocks',133),
        (11,'text_menu',134),
        (11,'text_content',135),
        (11,'banner_manager_name',136),
        (11,'forms_manager_name',200),
        (11,'email_templates',137);
-- ITEM_URL
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES  (12,'design/template',131),
        (12,'design/layout',132),
        (12,'design/blocks',133),
        (12,'design/menu',134),
        (12,'design/content',135),
        (12,'extension/banner_manager',136),
        (12,'design/email_templates',137),
        (12,'tool/forms_manager',200);
-- PARENT_ID
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES  (13,'design',131),
        (13,'design',132),
        (13,'design',133),
        (13,'design',134),
        (13,'design',135),
        (13,'design',136),
        (13,'design',137),
        (13,'design',200);
-- SORT_ORDER
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_integer`,`row_id`)
VALUES  (14,1,131),
        (14,2,132),
        (14,3,133),
        (14,4,134),
        (14,5,135),
        (14,6,136),
        (14,8,137),
        (14,7,200);
-- ITEM_TYPE
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES  (15,'core',131),
        (15,'core',132),
        (15,'core',133),
        (15,'core',134),
        (15,'core',135),
        (15,'extension',136),
        (15,'core',137),
        (15,'extension',200);
-- ITEM_RL_ID
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES  (40,'241',131),
        (40,'242',132),
        (40,'243',133),
        (40,'244',134),
        (40,'245',135),
        (40,'246',136),
        (40,'280',137),
        (40,'248',200);

--
-- SUBMENU SYSTEM->SETTINGS
-- ITEM_ID
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES
(10,'all_settings',191),
(10,'settings_details',192),
(10,'settings_general',193),
(10,'settings_checkout',194),
(10,'settings_appearance',195),
(10,'settings_mail',196),
(10,'settings_im',219),
(10,'settings_api',197),
(10,'settings_system',198),
(10,'settings_newstore',199);

-- ITEM_TEXT
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES
(11,'text_all_settings',191),
(11,'text_settings_details',192),
(11,'text_settings_general',193),
(11,'text_settings_checkout',194),
(11,'text_settings_appearance',195),
(11,'text_settings_mail',196),
(11,'text_settings_im',219),
(11,'text_settings_api',197),
(11,'text_settings_system',198),
(11,'text_settings_newstore',199);

-- ITEM_URL
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES
(12,'setting/setting/all',191),
(12,'setting/setting/details',192),
(12,'setting/setting/general',193),
(12,'setting/setting/checkout',194),
(12,'setting/setting/appearance',195),
(12,'setting/setting/mail',196),
(12,'setting/setting/im',219),
(12,'setting/setting/api',197),
(12,'setting/setting/system',198),
(12,'setting/store/insert',199);
-- PARENT_ID
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES
(13,'setting',191),
(13,'setting',192),
(13,'setting',193),
(13,'setting',194),
(13,'setting',195),
(13,'setting',196),
(13,'setting',219),
(13,'setting',197),
(13,'setting',198),
(13,'setting',199);
-- SORT_ORDER
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_integer`,`row_id`)
VALUES
(14,1,191),
(14,2,192),
(14,3,193),
(14,4,194),
(14,5,195),
(14,6,196),
(14,7,219),
(14,8,197),
(14,9,198),
(14,10,199);
-- ITEM_TYPE
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES
(15,'core',191),
(15,'core',192),
(15,'core',193),
(15,'core',194),
(15,'core',195),
(15,'core',196),
(15,'core',219),
(15,'core',197),
(15,'core',198),
(15,'core',199);

-- ITEM_RL_ID
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES  (40,'247',191),
        (40,'248',192),
        (40,'249',193),
        (40,'250',194),
        (40,'251',195),
        (40,'252',196),
        (40,'276',219),
        (40,'253',197),
        (40,'254',198),
        (40,'255',199);


--
-- SUBMENU USERS OF SUBMENU SYSTEM
-- ITEM_ID
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES  (10,'user',151),
		    (10,'permission',152);
-- ITEM_TEXT
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES  (11,'text_user',151),
		    (11,'text_user_group',152);
-- ITEM_URL
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES  (12,'user/user',151),
	    	(12,'user/user_permission',152);
-- PARENT_ID	(submenu SYSTEM)
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES  (13,'users',151),
		    (13,'users',152);
-- SORT_ORDER
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_integer`,`row_id`)
VALUES  (14,1,151),
	    	(14,2,152);
-- ITEM_TYPE
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES  (15,'core',151),
		    (15,'core',152);

-- ITEM_RL_ID
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES  (40,'256',151),
        (40,'257',152);

--
-- SUBMENU SYSTEM->LOCALIZATION
-- ITEM_ID
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES  (10,'language',171),
        (10,'language_definitions',172),
        (10,'currency',173),
        (10,'stockstatus',174),
        (10,'orderstatus',175),
        (10,'country',176),
        (10,'zone',177),
        (10,'location',178),
        (10,'taxclass',179),
        (10,'lengthclass',180),
        (10,'weightclass',181);
-- ITEM_TEXT
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES  (11,'text_language',171),
        (11,'text_language_definitions',172),
        (11,'text_currency',173),
        (11,'text_stock_status',174),
        (11,'text_order_status',175),
        (11,'text_country',176),
        (11,'text_zone',177),
        (11,'text_location',178),
        (11,'text_tax_class',179),
        (11,'text_length_class',180),
        (11,'text_weight_class',181);
-- ITEM_URL
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES  (12,'localisation/language',171),
        (12,'localisation/language_definitions',172),
        (12,'localisation/currency',173),
        (12,'localisation/stock_status',174),
        (12,'localisation/order_status',175),
        (12,'localisation/country',176),
        (12,'localisation/zone',177),
        (12,'localisation/location',178),
        (12,'localisation/tax_class',179),
        (12,'localisation/length_class',180),
        (12,'localisation/weight_class',181);
-- PARENT_ID
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES  (13,'localisation',171),
        (13,'localisation',172),
        (13,'localisation',173),
        (13,'localisation',174),
        (13,'localisation',175),
        (13,'localisation',176),
        (13,'localisation',177),
        (13,'localisation',178),
        (13,'localisation',179),
        (13,'localisation',180),
        (13,'localisation',181);
-- SORT_ORDER
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_integer`,`row_id`)
VALUES  (14,1,171),
        (14,2,172),
        (14,3,173),
        (14,4,174),
        (14,5,175),
        (14,6,176),
        (14,7,177),
        (14,8,178),
        (14,9,179),
        (14,10,180),
        (14,11,181);
-- ITEM_TYPE
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES  (15,'core',171),
        (15,'core',172),
        (15,'core',173),
        (15,'core',174),
        (15,'core',175),
        (15,'core',176),
        (15,'core',177),
        (15,'core',178),
        (15,'core',179),
        (15,'core',180),
        (15,'core',181);

-- ITEM_RL_ID
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES  (40,'258',171),
        (40,'259',172),
        (40,'260',173),
        (40,'261',174),
        (40,'262',175),
        (40,'263',176),
        (40,'264',177),
        (40,'265',178),
        (40,'266',179),
        (40,'267',180),
        (40,'268',181);
--
-- SUBMENU SYSTEM->DATA
-- ITEM_ID
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES  (10,'backup',183),
        (10,'migrate',184),
        (10,'datasets',185),
        (10,'import_export',182),
        (10,'file_uploads',188);
-- ITEM_TEXT
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES  (11,'text_backup',183),
        (11,'text_migrate',184),
        (11,'text_datasets_manager',185),
        (11,'text_import_export',182),
        (11,'text_file_uploads',188);
-- ITEM_URL
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES  (12,'tool/backup',183),
        (12,'tool/migration/step_one',184),
        (12,'tool/datasets_manager',185),
        (12,'tool/import_export',182),
        (12, 'tool/files',188);
-- PARENT_ID
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES  (13,'data',183),
        (13,'data',184),
        (13,'data',185),
        (13,'data',182),
        (13,'data',188);
-- SORT_ORDER
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_integer`,`row_id`)
VALUES  (14,1,183),
        (14,2,184),
        (14,3,185),
        (14,4,182),
        (14,5,188);
-- ITEM_TYPE
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES  (15,'core',183),
        (15,'core',184),
        (15,'core',185),
        (15,'core',182),
        (15,'core',188);

-- ITEM_RL_ID
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES  (40,'269',183),
        (40,'270',184),
        (40,'271',185),
        (40,'272',182),
        (40,'273',188);

--
-- SUBMENU SYSTEM->LOGS
-- ITEM_ID
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES  (10,'installlog',186),
		    (10,'error_log',187),
		    (10,'task',189);
-- ITEM_TEXT
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES  (11,'text_install_upgrade_history',186),
		    (11,'text_error_log',187),
		    (11,'text_tasks',189);
-- ITEM_URL
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES  (12,'tool/install_upgrade_history',186),
		    (12,'tool/error_log',187),
		    (12,'tool/task',189);
-- PARENT_ID
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES  (13,'logs',186),
		    (13,'logs',187),
		    (13,'logs',189);
-- SORT_ORDER
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_integer`,`row_id`)
VALUES  (14,1,186),
	    	(14,2,187),
	    	(14,3,189);
-- ITEM_TYPE
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES  (15,'core',186),
		    (15,'core',187),
		    (15,'core',189);

-- ITEM_RL_ID
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES  (40,'274',186),
        (40,'275',187),
        (40,'254',189);


--
-- SUBMENU REPORTS->SALES
-- ITEM_ID
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES
(10,'report_sale_orders',210),
(10,'report_sale_tax',211),
(10,'report_sale_shipping',212),
(10,'report_sale_coupon',213);
-- ITEM_TEXT
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES
(11,'text_order',210),
(11,'text_tax',211),
(11,'text_shipping',212),
(11,'text_discount',213);
-- ITEM_URL
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES
(12,'report/sale/orders',210),
(12,'report/sale/taxes',211),
(12,'report/sale/shipping',212),
(12,'report/sale/coupons',213);
-- PARENT_ID
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES
(13,'report_sale',210),
(13,'report_sale',211),
(13,'report_sale',212),
(13,'report_sale',213);
-- SORT_ORDER
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_integer`,`row_id`)
VALUES
(14,1,210),
(14,2,211),
(14,3,212),
(14,4,213);
-- ITEM_TYPE
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES
(15,'core',210),
(15,'core',211),
(15,'core',212),
(15,'core',213);
-- ITEM_RL_ID
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES  (40,'221',210),
        (40,'266',211),
        (40,'214',212),
        (40,'224',213);

--
-- SUBMENU REPORTS->CUSTOMERS
-- ITEM_ID
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES
(10,'report_customer_online',214),
(10,'report_customer_order',215),
(10,'report_customer_transactions',216);
-- ITEM_TEXT
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES
(11,'text_online',214),
(11,'text_order',215),
(11,'text_transactions',216);
-- ITEM_URL
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES
(12,'report/customer/online',214),
(12,'report/customer/orders',215),
(12,'report/customer/transactions',216);
-- PARENT_ID
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES
(13,'report_customer',214),
(13,'report_customer',215),
(13,'report_customer',216);
-- SORT_ORDER
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_integer`,`row_id`)
VALUES
(14,1,214),
(14,2,215),
(14,3,216);
-- ITEM_TYPE
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES
(15,'core',214),
(15,'core',215),
(15,'core',216);
-- ITEM_RL_ID
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES  (40,'222',214),
        (40,'221',215),
        (40,'260',216);

--
-- SUBMENU REPORTS->PRODUCTS
-- ITEM_ID
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES
(10,'report_product_viewed',217),
(10,'report_product_purchased',218);
-- ITEM_TEXT
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES
(11,'text_report_viewed',217),
(11,'text_report_purchased',218);
-- ITEM_URL
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES
(12,'report/viewed',217),
(12,'report/purchased',218);
-- PARENT_ID
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES
(13,'report_product',217),
(13,'report_product',218);
-- SORT_ORDER
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_integer`,`row_id`)
VALUES
(14,1,217),
(14,2,218);
-- ITEM_TYPE
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES
(15,'core',217),
(15,'core',218);
-- ITEM_RL_ID
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES  (40,'235',217),
        (40,'236',218);

--
-- Storefront menu names inserts
--
INSERT INTO `ac_datasets` (`dataset_name`,`dataset_key`) VALUES ('menu','storefront_description');
INSERT INTO `ac_dataset_definition` (`dataset_id`,`dataset_column_id`,`dataset_column_name`,`dataset_column_type`,`dataset_column_sort_order`)
VALUES  (3,16, 'item_id','varchar',1),
        (3,17, 'item_text','varchar',2),
        (3,18, 'language_id','integer',3);
-- ITEM_ID
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES  (16,'home',1),
        (16,'login',2),
        (16,'logout',3),
        (16,'account',4),
        (16,'cart',5),
        (16,'checkout',6),
        (16,'specials',14),
        (16,'order',15);
-- ITEM_TEXT
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES  (17,'Home',1),
        (17,'Login',2),
        (17,'Logout',3),
        (17,'Account',4),
        (17,'Cart',5),
        (17,'Checkout',6),
        (17,'Specials',14),
        (17,'Check Your Order',15);
-- LANGUAGE_ID
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_integer`,`row_id`)
VALUES  (18,1,1),
        (18,1,2),
        (18,1,3),
        (18,1,4),
        (18,1,5),
        (18,1,6),
        (18,1,14),
        (18,1,15);
-- spanish
-- ITEM_ID
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES  (16,'home',7),
        (16,'login',8),
        (16,'logout',9),
        (16,'account',10),
        (16,'cart',11),
        (16,'checkout',12),
        (16,'specials',13),
        (16,'order',16);
-- ITEM_TEXT
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES  (17,'Casa',7),
        (17,'Iniciar Sesión',8),
        (17,'Cerrar sesión',9),
        (17,'Cuenta',10),
        (17,'Carro',11),
        (17,'Caja',12),
        (17,'Especiales',13),
        (17,'Comprobar el Orden',16);
-- LANGUAGE_ID
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_integer`,`row_id`)
VALUES  (18,9,7),
        (18,9,8),
        (18,9,9),
        (18,9,10),
        (18,9,11),
        (18,9,12),
        (18,9,13),
        (18,9,16);


-- ## ADD INSTALL/UPGRADE HISTORY DATASET
INSERT INTO `ac_datasets` (`dataset_name`,`dataset_key`) VALUES ('install_upgrade_history','admin');
INSERT INTO `ac_dataset_properties` (`dataset_id`,`dataset_property_name`,`dataset_property_value`) VALUES ('4','controller','tool/install_upgrade_history');

INSERT INTO `ac_dataset_definition` (`dataset_id`,`dataset_column_id`, `dataset_column_name`,`dataset_column_type`,`dataset_column_sort_order`)
VALUES  (4,20,'date_added','timestamp',1),
        (4,21,'name','varchar',2),
        (4,22,'version','varchar',3),
        (4,23,'backup_file','varchar',4),
        (4,24,'backup_date','timestamp',5),
        (4,25,'type','varchar',6),
        (4,26,'user','varchar',7);


-- insert info about initial installation
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_timestamp`,`row_id`)
VALUES  (20, NOW(),'1');
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES  (21,'AbanteCart','1');
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES  (22,'1.4.0','1');
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES  (23,'','1');
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES  (24,'','1');
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES  (25,'install','1');
INSERT INTO `ac_dataset_values` (`dataset_column_id`, `value_varchar`,`row_id`)
VALUES  (26,'admin','1');




-- ## ADD FILE UPLOADS DATASET
INSERT INTO `ac_datasets` (`dataset_id`,`dataset_name`,`dataset_key`) VALUES (5,'file_uploads','admin');
INSERT INTO `ac_dataset_properties` (`dataset_id`,`dataset_property_name`,`dataset_property_value`) VALUES (5,'controller','tool/files');

INSERT INTO `ac_dataset_definition` (`dataset_id`,`dataset_column_id`, `dataset_column_name`,`dataset_column_type`,`dataset_column_sort_order`)
VALUES  (5,30,'date_added','timestamp',1),
        (5,31,'name','varchar',2),
        (5,32,'type','varchar',3),
        (5,33,'section','varchar',4),
        (5,34,'section_id','integer',5),
        (5,35,'path','varchar',6);

--
-- DDL for table `ac_resource_library`
--
DROP TABLE IF EXISTS `ac_resource_library`;
CREATE TABLE `ac_resource_library` (
  `resource_id` int(11) NOT NULL auto_increment,
  `type_id` int(11) NOT NULL,
  `date_added` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`resource_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci AUTO_INCREMENT=100000;

CREATE INDEX `ac_resource_library_idx` ON `ac_resource_library` ( `resource_id`, `type_id`);

--
-- DDL for table `ac_resource_descriptions`
--

DROP TABLE IF EXISTS `ac_resource_descriptions`;
CREATE TABLE `ac_resource_descriptions` (
  `resource_id` int(10) NOT NULL DEFAULT '0',
  `language_id` int(11) NOT NULL, -- use 1 as default
  `name` varchar(255) NOT NULL DEFAULT '' NULL COMMENT 'translatable',
  `title` varchar(255) NOT NULL DEFAULT '' NULL COMMENT 'translatable',
  `description` text DEFAULT NULL NULL COMMENT 'translatable',
  `resource_path` varchar(255) DEFAULT NULL,
  `resource_code` text DEFAULT NULL,
  `date_added` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`resource_id`,`language_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci ;

CREATE INDEX `ac_resource_descriptions_name_idx` ON `ac_resource_descriptions` ( `resource_id`, `name`);
CREATE INDEX `ac_resource_descriptions_title_idx` ON `ac_resource_descriptions` ( `resource_id`, `title`);

#storefront menu icons
INSERT INTO `ac_resource_library` ( `resource_id`, `type_id`, `date_added`)
VALUES
(1,1,NOW()),
(2,1,NOW()),
(3,1,NOW()),
(4,1,NOW()),
(5,1,NOW()),
(6,1,NOW()),
(7,1,NOW()),
(8,1,NOW());

INSERT INTO `ac_resource_descriptions`
(`resource_id`, `language_id`, `name`, `title`, `description`, `resource_path`, `resource_code`, `date_added`)
VALUES
(1,1,'Star Icon','','','','<i class="fa fa-star"></i>&nbsp;&nbsp;',NOW()),
(2,1,'Icon Home','','','','<i class="fa fa-home"></i>&nbsp;',NOW()),
(3,1,'Login Icon','','','','<i class="fa fa-lock"></i>&nbsp;&nbsp;',NOW()),
(4,1,'Account Icon','','','','<i class="fa fa-user"></i>&nbsp;',NOW()),
(5,1,'Cart Icon','','','','<i class="fa fa-shopping-cart"></i>&nbsp;',NOW()),
(6,1,'Checkout Icon','','','','<i class="fa fa-barcode"></i>&nbsp;&nbsp;',NOW()),
(7,1,'store_logo.png','','','18/73/3.png','',NOW()),
(8,1,'favicon.png','','','18/73/4.png','',NOW());

#Admin Menu Icons
INSERT INTO `ac_resource_library` ( `resource_id`, `type_id`, `date_added`)
VALUES
  ( 200, 1, NOW() ),
  ( 201, 1, NOW() ),
  ( 202, 1, NOW() ),
  ( 203, 1, NOW() ),
  ( 204, 1, NOW() ),
  ( 205, 1, NOW() ),
  ( 206, 1, NOW() ),
  ( 207, 1, NOW() ),
  ( 208, 1, NOW() ),
  ( 209, 1, NOW() ),
  ( 210, 1, NOW() ),
  ( 211, 1, NOW() ),
  ( 212, 1, NOW() ),
  ( 213, 1, NOW() ),
  ( 214, 1, NOW() ),
  ( 215, 1, NOW() ),
  ( 216, 1, NOW() ),
  ( 217, 1, NOW() ),
  ( 218, 1, NOW() ),
  ( 219, 1, NOW() ),
  ( 220, 1, NOW() ),
  ( 221, 1, NOW() ),
  ( 222, 1, NOW() ),
  ( 223, 1, NOW() ),
  ( 224, 1, NOW() ),
  ( 225, 1, NOW() ),
  ( 226, 1, NOW() ),
  ( 227, 1, NOW() ),
  ( 228, 1, NOW() ),
  ( 229, 1, NOW() ),
  ( 230, 1, NOW() ),
  ( 231, 1, NOW() ),
  ( 232, 1, NOW() ),
  ( 233, 1, NOW() ),
  ( 234, 1, NOW() ),
  ( 235, 1, NOW() ),
  ( 236, 1, NOW() ),
  ( 237, 1, NOW() ),
  ( 238, 1, NOW() ),
  ( 239, 1, NOW() ),
  ( 240, 1, NOW() ),
  ( 241, 1, NOW() ),
  ( 242, 1, NOW() ),
  ( 243, 1, NOW() ),
  ( 244, 1, NOW() ),
  ( 245, 1, NOW() ),
  ( 246, 1, NOW() ),
  ( 247, 1, NOW() ),
  ( 248, 1, NOW() ),
  ( 249, 1, NOW() ),
  ( 250, 1, NOW() ),
  ( 251, 1, NOW() ),
  ( 252, 1, NOW() ),
  ( 253, 1, NOW() ),
  ( 254, 1, NOW() ),
  ( 255, 1, NOW() ),
  ( 256, 1, NOW() ),
  ( 257, 1, NOW() ),
  ( 258, 1, NOW() ),
  ( 259, 1, NOW() ),
  ( 260, 1, NOW() ),
  ( 261, 1, NOW() ),
  ( 262, 1, NOW() ),
  ( 263, 1, NOW() ),
  ( 264, 1, NOW() ),
  ( 265, 1, NOW() ),
  ( 266, 1, NOW() ),
  ( 267, 1, NOW() ),
  ( 268, 1, NOW() ),
  ( 269, 1, NOW() ),
  ( 270, 1, NOW() ),
  ( 271, 1, NOW() ),
  ( 272, 1, NOW() ),
  ( 273, 1, NOW() ),
  ( 274, 1, NOW() ),
  ( 275, 1, NOW() ),
  ( 276, 1, NOW() ),
  ( 277, 1, NOW() ),
  ( 278, 1, NOW() ),
  ( 279, 1, NOW() ),
  ( 280, 1, NOW() ),
  ( 281, 1, NOW() );

INSERT INTO `ac_resource_descriptions`
(`resource_id`, `language_id`, `name`, `title`, `description`, `resource_path`, `resource_code`, `date_added`)
VALUES
  ( 200,1,'Icon Catalog', '', '', '', '<i class="fa fa-folder-open"></i>&nbsp;', NOW() ),
  ( 201,1,'Icon Sale', '', '', '', '<i class="fa fa-flag-o"></i>&nbsp;', NOW() ),
  ( 202,1,'Icon Design', '', '', '', '<i class="fa fa-file-text"></i>&nbsp;', NOW() ),
  ( 203,1,'Icon Extension', '', '', '', '<i class="fa fa-puzzle-piece"></i>&nbsp;', NOW() ),
  ( 204,1,'Icon System', '', '', '', '<i class="fa fa-wrench"></i>&nbsp;', NOW() ),
  ( 205,1,'Icon Reports', '', '', '', '<i class="fa fa-bar-chart-o"></i>&nbsp;', NOW() ),
  ( 206,1,'Icon Help', '', '', '', '<i class="fa fa-life-ring"></i>&nbsp;', NOW() ),
  ( 207,1,'Icon Category', '', '', '', '<i class="fa fa-folder-open"></i>&nbsp;', NOW() ),
  ( 208,1,'Icon Product', '', '', '', '<i class="fa fa-cubes"></i>&nbsp;', NOW() ),
  ( 209,1,'Icon Manufacturer', '', '', '', '<i class="fa fa-bookmark-o"></i>&nbsp;', NOW() ),
  ( 210,1,'Icon Download', '', '', '', '<i class="fa fa-download"></i>&nbsp;', NOW() ),
  ( 211,1,'Icon Review', '', '', '', '<i class="fa fa-comment-o"></i>&nbsp;', NOW() ),
  ( 212,1,'Icon Attributes', '', '', '', '<i class="fa fa-ticket"></i>&nbsp;', NOW() ),
  ( 213,1,'Icon Extensions', '', '', '', '<i class="fa fa-th"></i>&nbsp;', NOW() ),
  ( 214,1,'Icon Shipping', '', '', '', '<i class="fa fa-truck"></i>&nbsp;', NOW() ),
  ( 215,1,'Icon Building', '', '', '', '<i class="fa fa-university"></i>&nbsp;', NOW() ),
  ( 216,1,'Icon Templates', '', '', '', '<i class="fa fa-outdent"></i>&nbsp;', NOW() ),
  ( 217,1,'Icon Languages', '', '', '', '<i class="fa fa-language"></i>&nbsp;', NOW() ),
  ( 218,1,'Icon Total', '', '', '', '<i class="fa fa-sign-in"></i>&nbsp;', NOW() ),
  ( 219,1,'Icon Add extension', '', '', '', '<i class="fa fa-magic"></i>&nbsp;', NOW() ),
  ( 220,1,'Icon Get Extensions', '', '', '', '<i class="fa fa-cloud-download"></i>&nbsp;', NOW() ),
  ( 221,1,'Icon Order', '', '', '', '<i class="fa fa-flag-checkered"></i>&nbsp;', NOW() ),
  ( 222,1,'Icon Customer', '', '', '', '<i class="fa fa-users"></i>&nbsp;', NOW() ),
  ( 223,1,'Icon Customer group', '', '', '', '<i class="fa fa-book"></i>&nbsp;', NOW() ),
  ( 224,1,'Icon Coupon', '', '', '', '<i class="fa fa-tags"></i>&nbsp;', NOW() ),
  ( 225,1,'Icon Contact', '', '', '', '<i class="fa fa-envelope-o"></i>&nbsp;', NOW() ),
  ( 226,1,'Icon Setting', '', '', '', '<i class="fa fa-cogs"></i>&nbsp;', NOW() ),
  ( 227,1,'Icon Users', '', '', '', '<i class="fa fa-users"></i>&nbsp;', NOW() ),
  ( 228,1,'Icon Localisation', '', '', '', '<i class="fa fa-random"></i>&nbsp;', NOW() ),
  ( 229,1,'Icon Data', '', '', '', '<i class="fa fa-cubes"></i>&nbsp;', NOW() ),
  ( 230,1,'Icon Updater', '', '', '', '<i class="fa fa-refresh"></i>&nbsp;', NOW() ),
  ( 231,1,'Icon Cache', '', '', '', '<i class="fa fa-recycle"></i>&nbsp;', NOW() ),
  ( 232,1,'Icon Messages', '', '', '', '<i class="fa fa-weixin"></i>&nbsp;', NOW() ),
  ( 233,1,'Icon Logs', '', '', '', '<i class="fa fa-floppy-o"></i>&nbsp;', NOW() ),
  ( 234,1,'Icon Report sale', '', '', '', '<i class="fa fa-signal"></i>&nbsp;', NOW() ),
  ( 235,1,'Icon Viewed', '', '', '', '<i class="fa fa-sort-amount-desc"></i>&nbsp;', NOW() ),
  ( 236,1,'Icon Purchased', '', '', '', '<i class="fa fa-file-text-o"></i>&nbsp;', NOW() ),
  ( 237,1,'Icon Banner manager stat', '', '', '', '<i class="fa fa-reply-all"></i>&nbsp;', NOW() ),
  ( 238,1,'Icon Abantecart', '', '', '', '<i class="fa fa-external-link"></i>&nbsp;', NOW() ),
  ( 239,1,'Icon Documentation', '', '', '', '<i class="fa fa-graduation-cap"></i>&nbsp;', NOW() ),
  ( 240,1,'Icon Support', '', '', '', '<i class="fa fa-info"></i>&nbsp;', NOW() ),
  ( 241,1,'Icon Template', '', '', '', '<i class="fa fa-files-o"></i>&nbsp;', NOW() ),
  ( 242,1,'Icon Layout', '', '', '', '<i class="fa fa-bars"></i>&nbsp;', NOW() ),
  ( 243,1,'Icon Blocks', '', '', '', '<i class="fa fa-qrcode"></i>&nbsp;', NOW() ),
  ( 244,1,'Icon Menu', '', '', '', '<i class="fa fa-tag"></i>&nbsp;', NOW() ),
  ( 245,1,'Icon Content', '', '', '', '<i class="fa fa-clipboard"></i>&nbsp;', NOW() ),
  ( 246,1,'Icon Banner manager', '', '', '', '<i class="fa fa-picture-o"></i>&nbsp;', NOW() ),
  ( 247,1,'Icon All settings', '', '', '', '<i class="fa fa-sliders"></i>&nbsp;', NOW() ),
  ( 248,1,'Icon Settings details', '', '', '', '<i class="fa fa-list"></i>&nbsp;', NOW() ),
  ( 249,1,'Icon Settings general', '', '', '', '<i class="fa fa-folder-o"></i>&nbsp;', NOW() ),
  ( 250,1,'Icon Settings checkout', '', '', '', '<i class="fa fa-shopping-cart"></i>&nbsp;', NOW() ),
  ( 251,1,'Icon Settings appearance', '', '', '', '<i class="fa fa-pencil-square-o"></i>&nbsp;', NOW() ),
  ( 252,1,'Icon Settings mail', '', '', '', '<i class="fa fa-envelope-square"></i>&nbsp;', NOW() ),
  ( 253,1,'Icon Settings api', '', '', '', '<i class="fa fa-slack"></i>&nbsp;', NOW() ),
  ( 254,1,'Icon Settings system', '', '', '', '<i class="fa fa-tasks"></i>&nbsp;', NOW() ),
  ( 255,1,'Icon Settings newstore', '', '', '', '<i class="fa fa-sitemap"></i>&nbsp;', NOW() ),
  ( 256,1,'Icon User', '', '', '', '<i class="fa fa-male"></i>&nbsp;', NOW() ),
  ( 257,1,'Icon Permission', '', '', '', '<i class="fa fa-code-fork"></i>&nbsp;', NOW() ),
  ( 258,1,'Icon Language', '', '', '', '<i class="fa fa-language"></i>&nbsp;', NOW() ),
  ( 259,1,'Icon Language definitions', '', '', '', '<i class="fa fa-sort-alpha-asc"></i>&nbsp;', NOW() ),
  ( 260,1,'Icon Currency', '', '', '', '<i class="fa fa-money"></i>&nbsp;', NOW() ),
  ( 261,1,'Icon Stock Status', '', '', '', '<i class="fa fa-list-alt"></i>&nbsp;', NOW() ),
  ( 262,1,'Icon Order Status', '', '', '', '<i class="fa fa-sort-amount-asc"></i>&nbsp;', NOW() ),
  ( 263,1,'Icon Country', '', '', '', '<i class="fa fa-globe"></i>&nbsp;', NOW() ),
  ( 264,1,'Icon Zone', '', '', '', '<i class="fa fa-thumb-tack"></i>&nbsp;', NOW() ),
  ( 265,1,'Icon Location', '', '', '', '<i class="fa fa-flag-checkered"></i>&nbsp;', NOW() ),
  ( 266,1,'Icon Tax class', '', '', '', '<i class="fa fa-briefcase"></i>&nbsp;', NOW() ),
  ( 267,1,'Icon Length class', '', '', '', '<i class="fa fa-arrows-h"></i>&nbsp;', NOW() ),
  ( 268,1,'Icon Weight class', '', '', '', '<i class="fa fa-angle-double-down"></i>&nbsp;', NOW() ),
  ( 269,1,'Icon Backup', '', '', '', '<i class="fa fa-jsfiddle"></i>&nbsp;', NOW() ),
  ( 270,1,'Icon Migrate', '', '', '', '<i class="fa fa-share-alt-square"></i>&nbsp;', NOW() ),
  ( 271,1,'Icon Datasets', '', '', '', '<i class="fa fa-database"></i>&nbsp;', NOW() ),
  ( 272,1,'Icon Import export', '', '', '', '<i class="fa fa-exchange"></i>&nbsp;', NOW() ),
  ( 273,1,'Icon File uploads', '', '', '', '<i class="fa fa-download"></i>&nbsp;', NOW() ),
  ( 274,1,'Icon Install Log', '', '', '', '<i class="fa fa-history"></i>&nbsp;', NOW() ),
  ( 275,1,'Icon Error log', '', '', '', '<i class="fa fa-exclamation-triangle"></i>&nbsp;', NOW() ),
  ( 276,1,'Icon Settings IM', '', '', '', '<i class="fa fa-bullhorn"></i>&nbsp;', NOW() ),
  ( 277,1,'Icon Resource Library', '', '', '', '<i class="fa fa-image"></i>&nbsp;', NOW() ),
  ( 278,1,'Icon Analytics & Insights', '', '', '', '<i class="fa fa-signal"></i>&nbsp;', NOW() ),
  ( 279,1,'Icon Collections', '', '', '', '<i class="fa fa-paste"></i>&nbsp;', NOW() ),
  ( 280,1,'Icon Email Templates', '', '', '', '<i class="fa fa-envelope-open-o"></i>&nbsp;', NOW() ),
  ( 281,1,'abc-logo-white','abc-logo-white','abc-logo-white.png','18/7a/logo.png','', NOW() );

--
-- DDL for table `ac_resource_types`
--
DROP TABLE IF EXISTS `ac_resource_types`;
CREATE TABLE `ac_resource_types` (
  `type_id` int(11) NOT NULL AUTO_INCREMENT,
  `type_name` varchar(40) NOT NULL default '',
  `default_directory` varchar(255) COLLATE utf8_general_ci NOT NULL,
  `default_icon` varchar(255) COLLATE utf8_general_ci DEFAULT NULL,
  `file_types` varchar(255) NOT NULL default '',
  `access_type`tinyint(1) NOT NULL default '0' COMMENT '0-Public, 1-Secured',
  PRIMARY KEY (`type_id`),
  KEY `group_id` (`type_id`, `type_name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci AUTO_INCREMENT=1;

INSERT INTO `ac_resource_types` (`type_id`, `type_name`, `default_icon`, `default_directory`, `file_types`, `access_type`) VALUES
(1, 'image', 'icon_resource_image.png', 'image/', '/.+(jpe?g|gif|png|ico|svg|svgz|webp|avif)$/i', 0),
(2, 'audio', 'icon_resource_audio.png', 'audio/', '/.+(mp3|wav|ogg)$/i', 0),
(3, 'video', 'icon_resource_video.png', 'video/', '/.+(avi|mpg|mpeg|mov|flv|mp4|webm|ogg)$/i', 0),
(4, 'pdf', 'icon_resource_pdf.png', 'pdf_document/', '/.+(pdf)$/i', 0),
(5, 'archive', 'icon_resource_archive.png', 'archive/', '/.+(zip|rar|gz|7z)$/i', 1),
(6, 'download', 'icon_resource_download.png', 'download/', '/.+$/i', 1);

--
-- DDL for table `ac_resource_map`
--
DROP TABLE IF EXISTS `ac_resource_map`;
CREATE TABLE `ac_resource_map` (
  `resource_id` int(11) NOT NULL,
  `object_name` varchar(40) NOT NULl,
  `object_id` int(11) NOT NULL,
  `default`tinyint(1) NOT NULL DEFAULT '0' COMMENT '0-no, 1-Yes',
  `sort_order` int(3) NOT NULL DEFAULT '0',
  `date_added` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
	PRIMARY KEY ( `resource_id`, `object_name`, `object_id` )
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE INDEX `ac_resource_map_sorting_idx` ON `ac_resource_map` ( `resource_id`, `sort_order`);

INSERT INTO `ac_resource_map` ( `resource_id`, `object_name`, `object_id`, `default`, `sort_order`, `date_added`)
VALUES
(1,'storefront_menu_item',0,0,0, now()),
(2,'storefront_menu_item',0,0,0, now()),
(3,'storefront_menu_item',0,0,0, now()),
(4,'storefront_menu_item',0,0,0, now()),
(5,'storefront_menu_item',0,0,0, now()),
(6,'storefront_menu_item',0,0,0, now());


--
-- DDL For Global Attributes
--

DROP TABLE IF EXISTS `ac_global_attributes`;
CREATE TABLE `ac_global_attributes` (
  `attribute_id` 		int(11) NOT NULL AUTO_INCREMENT,
  `attribute_parent_id`	int(11) NOT NULL DEFAULT '0',
  `attribute_group_id` 	int(11),
  `attribute_type_id` 	int(11) NOT NULL,
  `element_type` 		char(1) NOT NULL DEFAULT 'I',
  -- I - text input, T - Text area, S - Select, M - multivalue select, C - Checkbox, R - radio buttons, U - File upload, H - Hidden, G -Checkbox Group, D - Date, E - time, K - Captcha
  `sort_order` 			int(3) NOT NULL DEFAULT '0',
  `required` 			smallint(1) NOT NULL default '0',
  `settings`			text COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `status` 				smallint(1) NOT NULL default '0',
  `regexp_pattern` varchar(255),
  PRIMARY KEY (`attribute_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci AUTO_INCREMENT=1;

CREATE INDEX `ac_global_attributes_idx` ON `ac_global_attributes` ( `attribute_parent_id`, `attribute_group_id`, `attribute_type_id` );


DROP TABLE IF EXISTS `ac_global_attributes_descriptions`;
CREATE TABLE `ac_global_attributes_descriptions` (
  `attribute_id` 		int(11) NOT NULL,
  `language_id` 		int(11) NOT NULL,
  `name` 				varchar(64) COLLATE utf8_general_ci NOT NULL COMMENT 'translatable',
  `placeholder` varchar(255) COLLATE utf8_general_ci DEFAULT '' COMMENT 'translatable',
  `error_text` 	varchar(255) COLLATE utf8_general_ci NOT NULL COMMENT 'translatable',
  PRIMARY KEY (`attribute_id`,`language_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;


DROP TABLE IF EXISTS `ac_global_attributes_values`;
CREATE TABLE `ac_global_attributes_values` (
    `attribute_value_id` int(11) NOT NULL AUTO_INCREMENT,
    `attribute_id` 		 int(11) NOT NULL,
    `price_modifier`     float default 0.0 null,
    `price_prefix`       char(1) null,
    `sort_order` 		 int(3) NOT NULL DEFAULT '0',
    `txt_id` 		     varchar(255) NULL,
  PRIMARY KEY (`attribute_value_id`),
  UNIQUE KEY `ga_value_txt_id_idx` (`txt_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci AUTO_INCREMENT=1;
CREATE INDEX `ac_global_attributes_values_idx` ON `ac_global_attributes_values` ( `attribute_id` );

DROP TABLE IF EXISTS `ac_global_attributes_value_descriptions`;
CREATE TABLE `ac_global_attributes_value_descriptions` (
  `attribute_value_id` int(11) NOT NULL,
  `attribute_id` int(11) NOT NULL,
  `language_id`	int(11) NOT NULL,
  `value` text COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT 'translatable',
  PRIMARY KEY (`attribute_value_id`, `attribute_id`, `language_id` )
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;


DROP TABLE IF EXISTS `ac_global_attributes_groups`;
CREATE TABLE `ac_global_attributes_groups` (
  `attribute_group_id` 	int(11) NOT NULL AUTO_INCREMENT,
  `sort_order` 			int(3) NOT NULL DEFAULT '0',
  `status` 				smallint(1) NOT NULL default '0',
  PRIMARY KEY (`attribute_group_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci AUTO_INCREMENT=1;


DROP TABLE IF EXISTS `ac_global_attributes_groups_descriptions`;
CREATE TABLE `ac_global_attributes_groups_descriptions` (
  `attribute_group_id` 	int(11) NOT NULL,
  `language_id` 		int(11) NOT NULL,
  `name` 				varchar(64) COLLATE utf8_general_ci NOT NULL COMMENT 'translatable',
  PRIMARY KEY (`attribute_group_id`,`language_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;


DROP TABLE IF EXISTS `ac_global_attributes_types`;
CREATE TABLE `ac_global_attributes_types` (
  `attribute_type_id` 	int(11) NOT NULL AUTO_INCREMENT,
  `type_key` 			varchar(64) NOT NULL,
  `controller` 			varchar(100) NOT NULL,
  `sort_order` 			int(3) NOT NULL DEFAULT '0',
  `status` 				smallint(1) NOT NULL default '0',
  PRIMARY KEY (`attribute_type_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci AUTO_INCREMENT=1;

INSERT INTO `ac_global_attributes_types` (`attribute_type_id`, `type_key`, `controller`, `sort_order`, `status`) VALUES
(1, 'product_option', 'responses/catalog/attribute/getProductOptionSubform', 1, 1),
(2, 'download_attribute', 'responses/catalog/attribute/getDownloadAttributeSubform', 2, 1);


DROP TABLE IF EXISTS `ac_global_attributes_type_descriptions`;
CREATE TABLE `ac_global_attributes_type_descriptions` (
  `attribute_type_id` int(11) NOT NULL,
  `language_id` int(11) NOT NULL,
  `type_name` varchar(64) COLLATE utf8_general_ci NOT NULL COMMENT 'translatable',
  `date_added` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`attribute_type_id`,`language_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci COMMENT='utf8_general_ci';

INSERT INTO `ac_global_attributes_type_descriptions` (`attribute_type_id`, `language_id`, `type_name`, `date_added`)
VALUES
(1, 1, 'Product Option', NOW()),
(2, 1, 'Download Attribute', NOW())
;

--
-- Product Features and Filters
--

DROP TABLE IF EXISTS `ac_product_filters`;
CREATE TABLE `ac_product_filters` (
  `filter_id` int(11) NOT NULL AUTO_INCREMENT,
  `filter_type` char(1) NOT NULL DEFAULT '',  -- M - manufacture/brand, C - Category  based, F - Feature based, O - Option based, P - Price based
  `categories_hash` text NOT NULL, -- Hash with selected categories, that are used. Default ALL categories.
  `feature_id` int(11),
  `sort_order` int(3) NOT NULL DEFAULT '0',
  `status` smallint(1) NOT NULL default '0',
  PRIMARY KEY (`filter_id`),
  KEY `feature_id` (`feature_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;


DROP TABLE IF EXISTS `ac_product_filter_descriptions`;
CREATE TABLE `ac_product_filter_descriptions` (
  `filter_id` int(11) NOT NULL,
  `value` varchar(255) NOT NULL DEFAULT '' COMMENT 'translatable',
  `language_id` int(11) NOT NULL,
  PRIMARY KEY (`filter_id`,`language_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;


DROP TABLE IF EXISTS `ac_product_filter_ranges`;
CREATE TABLE `ac_product_filter_ranges` (
  `range_id` int(11) NOT NULL AUTO_INCREMENT,
  `feature_id` int(11),
  `filter_id` int(11) NOT NULL,
  `from` decimal(12,2) NOT NULL DEFAULT '0.00',
  `to` decimal(12,2) NOT NULL DEFAULT '0.00',
  `sort_order` int(3) NOT NULL DEFAULT '0',
  PRIMARY KEY (`range_id`),
  KEY `from` (`from`,`to`),
  KEY `filter_id` (`filter_id`),
  KEY `feature_id` (`feature_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

DROP TABLE IF EXISTS `ac_product_filter_ranges_descriptions`;
CREATE TABLE `ac_product_filter_ranges_descriptions` (
  `range_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT 'translatable',
  `language_id` int(11) NOT NULL,
  PRIMARY KEY (`range_id`,`language_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

DROP TABLE IF EXISTS `ac_extension_dependencies`;
CREATE TABLE `ac_extension_dependencies` (
  `extension_id` int(11) NOT NULL,
  `extension_parent_id` int(11) NOT NULL,
  PRIMARY KEY (`extension_id`,`extension_parent_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

DROP TABLE IF EXISTS `ac_encryption_keys`;
CREATE TABLE `ac_encryption_keys` (
  `key_id` int(3) NOT NULL AUTO_INCREMENT,
  `key_name` varchar(32) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `status` int(1) NOT NULL,
  `comment` text COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`key_id`),
  UNIQUE KEY `encryption_keys_key_name` (`key_name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci AUTO_INCREMENT=1;

DROP TABLE IF EXISTS `ac_tasks`;
CREATE TABLE `ac_tasks` (
  `task_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `starter` int(11) DEFAULT NULL COMMENT '0 - storefront, 1 - admin side, 2 - any',
  `status` int(11) DEFAULT '0' COMMENT '0 - disabled, 1 - ready, 2 - running, 3 - failed, 4 - scheduled, 5 - completed',
  `start_time` datetime DEFAULT NULL,
  `last_time_run` timestamp NULL,
  `progress` int(11) NOT NULL DEFAULT '0' COMMENT 'percentage of progress',
  `last_result` int(11) NOT NULL DEFAULT '0' COMMENT '1 - success, 0 - failed',
  `run_interval` INT(11) NOT NULL DEFAULT '0' COMMENT 'interval in seconds since last run, 0 - without interval',
  `max_execution_time` int(11) DEFAULT '0',
  `date_added` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`task_id`),
  UNIQUE KEY `task_name_idx` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci AUTO_INCREMENT=1;

DROP TABLE IF EXISTS `ac_task_details`;
CREATE TABLE `ac_task_details` (
  `task_id` int(11) NOT NULL AUTO_INCREMENT,
  `created_by` varchar(255) DEFAULT '',
  `settings` LONGTEXT DEFAULT '',
  `date_added` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`task_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci AUTO_INCREMENT=1;

DROP TABLE IF EXISTS `ac_task_steps`;
CREATE TABLE `ac_task_steps` (
  `step_id` int(11) NOT NULL AUTO_INCREMENT,
  `task_id` int(11) NOT NULL,
  `sort_order` int(11) DEFAULT '0',
  `status` int(11) DEFAULT '0' COMMENT '0 - disabled, 1 - ready, 2 - running, 3 - failed, 4 - scheduled, 5 - completed',
  `last_time_run` timestamp NULL,
  `last_result` int(11) NOT NULL DEFAULT '0' COMMENT '1 - success, 0 - failed',
  `max_execution_time` int(11) DEFAULT '0',
  `controller` varchar(255) DEFAULT '',
  `settings` LONGTEXT DEFAULT '',
  `date_added` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`step_id`),
  KEY `task_steps_idx` (`task_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci AUTO_INCREMENT=1;

DROP TABLE IF EXISTS `ac_product_stock_locations`;
CREATE TABLE `ac_product_stock_locations` (
  `product_id` int(11) NOT NULL,
  `product_option_value_id` int(11) DEFAULT NULL,
  `location_id` int(11) NOT NULL,
  `quantity` int(11) NOT NULL DEFAULT '0',
  `sort_order` int(11) NOT NULL DEFAULT '0',
  UNIQUE KEY `ac_product_stock_locations_idx` (`product_id`,`product_option_value_id`,`location_id`),
  KEY `ac_product_stock_locations_idx2` (`product_option_value_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

DROP TABLE IF EXISTS `ac_order_product_stock_locations`;
CREATE TABLE `ac_order_product_stock_locations` (
  `order_product_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `product_option_value_id` int(11) DEFAULT NULL,
  `location_id` int(11) NOT NULL,
  `location_name` varchar(255) NOT NULL,
  `quantity` int(11) NOT NULL DEFAULT '0',
  `sort_order` int(11) DEFAULT '0',
  KEY `ac_product_options_value_idx` (`product_option_value_id`),
  KEY `ac_product_options_value_idx2` (`order_product_id`,`product_id`,`product_option_value_id`,`location_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;


DROP TABLE IF EXISTS `ac_email_templates`;
CREATE TABLE `ac_email_templates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `status` tinyint(1) NOT NULL,
  `text_id` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `language_id` int(11) NOT NULL,
  `headers` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `subject` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `html_body` text COLLATE utf8_unicode_ci NOT NULL,
  `text_body` text COLLATE utf8_unicode_ci NOT NULL,
  `allowed_placeholders` text COLLATE utf8_unicode_ci NOT NULL,
  `date_added` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_deleted` timestamp NULL DEFAULT NULL,
  `store_id` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `email_templates_text_id_idx` (`text_id`,`language_id`, `store_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

--
-- Dumping data for table `ac_email_templates`
--
INSERT INTO `ac_email_templates` (`id`, `status`, `text_id`, `language_id`, `headers`, `subject`, `html_body`, `text_body`, `allowed_placeholders`, `store_id` )
VALUES
(1,1,'storefront_reset_password_link',1,'','{{store_name}} - Password reset','A password reset was requested from {{store_name}}&lt;br /&gt;\r\nTo reset your password click link below:&lt;br /&gt;\r\n&lt;a href="{{ reset_link }}"&gt;{{ reset_link }}&lt;/a &gt;\r\n&lt;br /&gt;&lt;br /&gt;\r\n{{{ text_project_label }}}','A password reset was requested from {{store_name}} \r\nTo reset your password click link below:\r\n{{ reset_link }}\r\n\r\n\r\n{{{ text_project_label }}}','store_name, reset_link, text_project_label',0),
(2,1,'storefront_welcome_email_activated',1,'','Welcome, {{store_name}}','&lt;html&gt;\r\n	&lt;head&gt;\r\n		&lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=utf-8&quot;&gt;\r\n	&lt;/head&gt;\r\n	&lt;body&gt;\r\n		&lt;table style=&quot;font-family: Verdana,sans-serif; font-size: 11px; color: #374953; width: 600px;&quot;&gt;\r\n			&lt;tr&gt;\r\n				&lt;td class=&quot;align_left&quot;&gt;\r\n				&lt;a href=&quot;{{ store_url }}&quot; title=&quot;{{ store_name }}&quot;&gt;\r\n						{{# logo_uri}}\r\n				&lt;img src=&quot;{{ logo_uri }}&quot; alt=&quot;{{store_name}}&quot; style=&quot;border: none;&quot;&gt;\r\n                                                 {{/ logo_uri}}\r\n                                                 {{^ logo_uri}}\r\n                                                       {{# logo_html}}\r\n                                                        {{logo_html}}\r\n                                                       {{/ logo_html}}\r\n                                                 {{/ logo_uri}}\r\n					&lt;/a&gt;\r\n				&lt;/td&gt;\r\n			&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n				&lt;td&gt;&amp;nbsp;&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n		&lt;td&gt;Welcome and thank you for registering at {{ store_name }}&lt;/td&gt;\r\n		&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n				&lt;td&gt;&amp;nbsp;&lt;/td&gt;\r\n		&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n				&lt;td&gt;\r\n                          Your account has now been created and you can log in by using your email address and password by visiting our website or at the following URL:&lt;br/&gt;\r\n&lt;a href=&quot;{{ login_url }}&quot;&gt;{{ login_url }}&lt;/a&gt;&lt;br/&gt;\r\nOnce you logging in, you will be able to access, your wishlist, order history, printing invoices and editing your account information.\r\n	&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n				&lt;td&gt;&amp;nbsp;&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n				&lt;td&gt;\r\n					Thank you.&lt;br/&gt;\r\n                                        {{ store_name }}\r\n&lt;br/&gt;&lt;br/&gt;\r\n{{{ text_project_label }}}\r\n		&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n		&lt;/table&gt;\r\n	&lt;/body&gt;\r\n&lt;/html&gt;','Welcome and thank you for registering at {{ store_name }}\r\n\r\nYour account has now been created and you can log in by using your email address and password by visiting our website or at the following URL:\r\n{{ login_url }}\r\n\r\nOnce you logging in, you will be able to access, your wishlist, order history, printing invoices and editing your account information.\r\n\r\nThank you.\r\n{{ store_name }}\r\n{{{ text_project_label }}}','store_name, login_url, store_url, logo_html, logo_uri, text_project_label',0),
(3,1,'storefront_welcome_email_approval',1,'','Welcome, {{store_name}}','&lt;html&gt;\r\n	&lt;head&gt;\r\n		&lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=utf-8&quot;&gt;\r\n	&lt;/head&gt;\r\n	&lt;body&gt;\r\n		&lt;table style=&quot;font-family: Verdana,sans-serif; font-size: 11px; color: #374953; width: 600px;&quot;&gt;\r\n			&lt;tr&gt;\r\n				&lt;td class=&quot;align_left&quot;&gt;\r\n					&lt;a href=&quot;{{ store_url }}&quot; title=&quot;{{ store_name }}&quot;&gt;\r\n				{{#logo_uri}}\r\n				&lt;img src=&quot;{{ logo_uri }}&quot; alt=&quot;{{store_name}}&quot; style=&quot;border: none;&quot;&gt;\r\n                                                 {{/logo_uri}}\r\n                                                 {{^logo_uri}}\r\n                                                       {{#logo_html}}\r\n                                                        {{logo_html}}\r\n                                                       {{/logo_html}}\r\n                                                 {{/logo_uri}}\r\n					&lt;/a&gt;\r\n				&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n				&lt;td&gt;&amp;nbsp;&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n				&lt;td&gt;Welcome and thank you for registering at {{ store_name }}&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n				&lt;td&gt;&amp;nbsp;&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n				&lt;td&gt;\r\n                          Your account must be approved before you can login. Once approved you can log in by using your email address and password by visiting our website or at the following URL:&lt;br/&gt;\r\n&lt;a href=&quot;{{ login_url }}&quot;&gt;{{ login_url }}&lt;/a&gt;&lt;br/&gt;\r\nOnce you logging in, you will be able to access, your wishlist, order history, printing invoices and editing your account information.\r\n		&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n				&lt;td&gt;&amp;nbsp;&lt;/td&gt;\r\n		&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n				&lt;td&gt;\r\n					Thank you.&lt;br/&gt;\r\n                                        {{ store_name }}\r\n&lt;br/&gt;&lt;br/&gt;\r\n{{{ text_project_label }}}\r\n		&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n		&lt;/table&gt;\r\n	&lt;/body&gt;\r\n&lt;/html&gt;','Welcome and thank you for registering at {{ store_name }}\r\n\r\nYour account must be approved before you can login. Once approved you can log in by using your email address and password by visiting our website or at the following URL:\r\n{{ login_url }}\r\n\r\nOnce you logging in, you will be able to access, your wishlist, order history, printing invoices and editing your account information.\r\n\r\nThank you.\r\n{{ store_name }}\r\n{{{ text_project_label }}}','store_name, login_url, store_url, logo_html, logo_uri, text_project_label',0),
(4,1,'storefront_send_activate_link',1,'','{{store_name}} - Thank you for registering','&lt;html&gt;\r\n	&lt;head&gt;\r\n		&lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=utf-8&quot;&gt;\r\n	&lt;/head&gt;\r\n	&lt;body&gt;\r\n		&lt;table style=&quot;font-family: Verdana,sans-serif; font-size: 11px; color: #374953; width: 600px;&quot;&gt;\r\n			&lt;tr&gt;\r\n				&lt;td class=&quot;align_left&quot;&gt;\r\n					&lt;a href=&quot;{{ store_url }}&quot; title=&quot;{{ store_name }}&quot;&gt;\r\n					{{#logo_uri}}\r\n							&lt;img src=&quot;{{ logo_uri }}&quot; alt=&quot;{{store_name}}&quot; style=&quot;border: none;&quot;&gt;\r\n                                                 {{/logo_uri}}\r\n                                                 {{^logo_uri}}\r\n                                                       {{#logo_html}}\r\n                                                        {{logo_html}}\r\n                                                       {{/logo_html}}\r\n                                                 {{/logo_uri}}\r\n					&lt;/a&gt;\r\n			&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n				&lt;td&gt;&amp;nbsp;&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n		&lt;td&gt;Welcome and thank you for registering at {{ store_name }}&lt;/td&gt;\r\n		&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n				&lt;td&gt;&amp;nbsp;&lt;/td&gt;\r\n		&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n				&lt;td&gt;\r\n                          Before we can activate your account one last step must be taken to complete your registration.&lt;br/&gt;\r\nYou must complete this last step to become a registered member. Please click the following link to activate your account:&lt;br/&gt;\r\n{{{ activate_url }}}&lt;br/&gt;\r\n\r\n				&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n				&lt;td&gt;&amp;nbsp;&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n		&lt;td&gt;\r\n					Thank you.&lt;br/&gt;\r\n                                        {{ store_name }}\r\n&lt;br/&gt;\r\n&lt;br/&gt;\r\n{{{ text_project_label }}}\r\n			 	&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n		&lt;/table&gt;\r\n	&lt;/body&gt;\r\n&lt;/html&gt;','Welcome and thank you for registering at {{ store_name }}!\r\n\r\nBefore we can activate your account one last step must be taken to complete your registration.\r\nYou must complete this last step to become a registered member. Please click the following link to activate your account\r\n{{ activate_url }}\r\n\r\nThank you,\r\n{{ store_name }}\r\n\r\n{{{ text_project_label }}}','store_name, activate_url, logo_uri, logo_html, store_url, text_project_label',0),
(5,1,'storefront_reset_password_notify',1,'','{{store_name}} - Password reset','Your password was successfully reset on {{store_name}}\r\n&lt;br/&gt;\r\n{{{ text_project_label }}}','Your password was successfully reset on {{store_name}}\r\n\r\n{{{ text_project_label }}}','store_name, text_project_label',0),
(6,1,'storefront_send_login_name',1,'','{{store_name}} - Login name reminder','Login name reminder was requested from {{store_name}} &lt;br/&gt;\r\n&lt;br/&gt;\r\nYour login name is: {{ login_name }}\r\n\r\n&lt;br/&gt;\r\n{{store_name}} \r\n&lt;br/&gt;\r\n&lt;br/&gt;\r\n{{{ text_project_label }}}','Login name reminder was requested from {{store_name}} \r\n\r\nYour login name is: {{ login_name }}\r\n\r\n{{store_name}} \r\n\r\n{{{ text_project_label }}}','store_name, login_name, text_project_label',0),
(7,1,'storefront_order_confirm',1,'','{{store_name}} - Order {{ order_id }}','&lt;html&gt;\r\n&lt;head&gt;\r\n	&lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=utf-8&quot;&gt;\r\n	&lt;title&gt; {{store_name}} - Order {{ order_id }} &lt;/title&gt;\r\n&lt;/head&gt;\r\n&lt;body&gt;\r\n&lt;table style=&quot;font-family: Verdana,sans-serif; font-size: 11px; color: #374953; width: 600px;&quot;&gt;\r\n	&lt;tr&gt;\r\n		&lt;td class=&quot;align_left&quot;&gt;\r\n					&lt;a href=&quot;{{ store_url }}&quot; title=&quot;{{ store_name }}&quot;&gt;\r\n						{{# logo_uri}}\r\n			&lt;img src=&quot;{{ logo_uri }}&quot; alt=&quot;{{store_name}}&quot; style=&quot;border: none;&quot;&gt;\r\n                                                 {{/ logo_uri}}\r\n                                                 {{^ logo_uri}}\r\n                                                       {{# logo_html}}\r\n                                                        {{logo_html}}\r\n                                                       {{/ logo_html}}\r\n                                                 {{/ logo_uri}}\r\n					&lt;/a&gt;\r\n				&lt;/td&gt;\r\n	&lt;/tr&gt;\r\n	&lt;tr&gt;\r\n		&lt;td&gt;&amp;nbsp;&lt;/td&gt;\r\n	&lt;/tr&gt;\r\n	&lt;tr&gt;\r\n		&lt;td class=&quot;align_left&quot;&gt;Thank you for your interest in {{store_name}} products. Your order has been received and will be processed after payment is confirmed.&lt;/td&gt;\r\n	&lt;/tr&gt;\r\n	&lt;tr&gt;\r\n		&lt;td&gt;&amp;nbsp;&lt;/td&gt;\r\n	&lt;/tr&gt;\r\n	&lt;tr&gt;\r\n		&lt;td class=&quot;align_left&quot;\r\n		    style=&quot;background-color: #069; color:#FFF; font-size: 12px; font-weight: bold; padding: 0.5em 1em;&quot;&gt;Order Details&lt;/td&gt;\r\n	&lt;/tr&gt;\r\n	&lt;tr&gt;\r\n		&lt;td&gt;&amp;nbsp;&lt;/td&gt;\r\n	&lt;/tr&gt;\r\n	&lt;tr&gt;\r\n		&lt;td class=&quot;align_left&quot;&gt;Order ID: &lt;span\r\n					style=&quot;color: #069; font-weight: bold;&quot;&gt;{{ order_id }}&lt;/span&gt;&lt;br/&gt;\r\n			Date Ordered: {{ date_added }}&lt;br&gt;\r\n			Payment Method: &lt;strong&gt;{{ payment_method }}&lt;/strong&gt;&lt;br/&gt;\r\n			Shipping Method: &lt;strong&gt;{{ shipping_method }}&lt;/strong&gt;&lt;br/&gt;\r\n			&lt;br/&gt;\r\n			Email: &lt;strong&gt;{{ customer_email }}&lt;/strong&gt;&lt;br/&gt;\r\n			Telephone: &lt;strong&gt;{{ customer_telephone }}&lt;/strong&gt;&lt;br/&gt;\r\n                         {{# customer_mobile_phone }}\r\n                            Telephone: &lt;strong&gt;{{ customer_mobile_phone }}&lt;/strong&gt;&lt;br/&gt;\r\n                         {{/ customer_mobile_phone }}\r\n		         {{# customer_fax }}\r\n                            Fax: &lt;strong&gt;{{ customer_fax }}&lt;/strong&gt;&lt;br/&gt;\r\n                         {{/ customer_fax }}\r\n                         IP Address:&lt;strong&gt;{{ customer_ip }}&lt;/strong&gt;\r\n		&lt;/td&gt;\r\n	&lt;/tr&gt;\r\n	&lt;tr&gt;\r\n		&lt;td&gt;&amp;nbsp;&lt;/td&gt;\r\n	&lt;/tr&gt;\r\n	&lt;tr&gt;\r\n		&lt;td&gt;\r\n			&lt;table style=&quot;width: 100%; font-family: Verdana,sans-serif; font-size: 11px; color: #FFFFFF;&quot;&gt;\r\n				&lt;tr style=&quot;background-color: #CCCCCC; text-transform: uppercase;&quot;&gt;\r\n		&lt;th style=&quot;text-align: left; padding: 0.3em;&quot;&gt;Shipping Address&lt;/th&gt;\r\n					&lt;th style=&quot;text-align: left; padding: 0.3em;&quot;&gt;Payment Address&lt;/th&gt;\r\n				&lt;/tr&gt;\r\n				&lt;tr&gt;\r\n					&lt;td style=&quot;padding: 0.3em; background-color: #EEEEEE; color: #000;&quot;&gt;\r\n{{# shipping_data }}\r\n{{ firstname }} {{lastname}} &lt;br/&gt;\r\n{{# company }}\r\n{{{ company }}} &lt;br/&gt; \r\n{{/ company }}\r\n{{# address_1 }}\r\n{{{ address_1 }}} &lt;br/&gt; \r\n{{/ address_1 }}\r\n{{# address_2 }}\r\n{{{ address_2 }}} &lt;br/&gt; \r\n{{/ address_2 }}\r\n{{{ city }}} {{{ postcode }}} &lt;br/&gt; \r\n{{# zone }}\r\n{{{ zone }}} &lt;br/&gt; \r\n{{/ zone }}\r\n{{{ country }}}\r\n{{/ shipping_data }}\r\n&lt;/td&gt;\r\n&lt;td style=&quot;padding: 0.3em; background-color: #EEEEEE; color: #000;&quot;&gt;\r\n{{# payment_data }}\r\n{{ firstname }} {{lastname}} &lt;br/&gt;\r\n{{# company }}\r\n{{{ company }}} &lt;br/&gt; \r\n{{/ company }}\r\n{{# address_1 }}\r\n{{{ address_1 }}} &lt;br/&gt; \r\n{{/ address_1 }}\r\n{{# address_2 }}\r\n{{{ address_2 }}} &lt;br/&gt; \r\n{{/ address_2 }}\r\n{{{ city }}} {{{ postcode }}} &lt;br/&gt; \r\n{{# zone }}\r\n{{{ zone }}} &lt;br/&gt; \r\n{{/ zone }}\r\n{{{ country }}}\r\n{{/ payment_data }}\r\n&lt;/td&gt;\r\n				&lt;/tr&gt;\r\n			&lt;/table&gt;\r\n		&lt;/td&gt;\r\n	&lt;/tr&gt;\r\n	&lt;tr&gt;\r\n		&lt;td&gt;&amp;nbsp;&lt;/td&gt;\r\n	&lt;/tr&gt;\r\n	&lt;tr&gt;\r\n		&lt;td class=&quot;align_left&quot;&gt;\r\n			&lt;table style=&quot;width: 100%; font-family: Verdana,sans-serif; font-size: 11px; color: #000000;&quot;&gt;\r\n				&lt;tr style=&quot;background-color: #CCCCCC;&quot;&gt;\r\n					&lt;th style=&quot;width: 40%; padding: 0.3em; color: #FFFFFF;&quot;&gt;Product&lt;/th&gt;\r\n					&lt;th class=&quot;align_left&quot; style=&quot;color: #FFFFFF;&quot;&gt;Model&lt;/th&gt;\r\n&lt;th class=&quot;align_right&quot;\r\n		    style=&quot;width: 10%; padding: 0.3em; color: #FFFFFF;&quot;&gt;Price&lt;/th&gt;\r\n					&lt;th class=&quot;align_right&quot;\r\n					    style=&quot;width: 15%; padding: 0.3em; color: #FFFFFF;&quot;&gt;Quantity&lt;/th&gt;\r\n					&lt;th class=&quot;align_right&quot;\r\n	    style=&quot;width: 20%; padding: 0.3em; color: #FFFFFF;&quot;&gt;Total&lt;/th&gt;\r\n				&lt;/tr&gt;\r\n				{{# products }}\r\n					&lt;tr style=&quot;background-color: #EEEEEE; text-align: center;&quot;&gt;\r\n						&lt;td class=&quot;align_left&quot; style=&quot;text-align: left;&quot;&gt;{{ name }}\r\n	{{# option }}\r\n								&lt;br/&gt;\r\n								&amp;nbsp;&amp;nbsp;- {{ name}} {{ value }} \r\n	{{/ option }}\r\n						&lt;td class=&quot;align_left&quot;&gt; {{ model }} &lt;/td&gt;\r\n						&lt;td class=&quot;align_right&quot;&gt; {{ price }} &lt;/td&gt;\r\n						&lt;td class=&quot;align_right&quot;&gt; {{ quantity }} &lt;/td&gt;\r\n						&lt;td class=&quot;align_right&quot;&gt; {{ total }}&lt;/td&gt;\r\n					&lt;/tr&gt;\r\n                                {{/ products }}\r\n                                         {{# totals }}\r\n			&lt;tr style=&quot;text-align: right;&quot;&gt;\r\n						&lt;td colspan=&quot;3&quot;&gt;&amp;nbsp;&lt;/td&gt;\r\n						&lt;td style=&quot;background-color: #EEEEEE; font-weight: bold; padding: 0.3em;&quot;&gt;{{ title }} &lt;/td&gt;\r\n						&lt;td style=&quot;background-color: #EEEEEE; padding: 0.3em;&quot;&gt; {{ text }}&lt;/td&gt;\r\n					&lt;/tr&gt;\r\n                                         {{/ totals }}\r\n			&lt;/table&gt;\r\n		&lt;/td&gt;\r\n	&lt;/tr&gt;\r\n	&lt;tr&gt;\r\n		&lt;td&gt;&amp;nbsp;&lt;/td&gt;\r\n	&lt;/tr&gt;\r\n	&lt;tr&gt;\r\n		&lt;td class=&quot;align_left&quot;\r\n		    style=&quot;background-color: #069; color: #FFF; font-size: 12px; font-weight: bold; padding: 0.5em 1em;&quot;&gt;&lt;/td&gt;\r\n	&lt;/tr&gt;\r\n	&lt;tr&gt;\r\n		&lt;td&gt;&amp;nbsp;&lt;/td&gt;\r\n	&lt;/tr&gt;\r\n {{# comment }}\r\n	&lt;tr&gt;\r\n&lt;td class=&quot;align_left&quot;\r\n			    style=&quot;background-color: #069; color: #FFF; font-size: 12px; font-weight: bold; padding: 0.5em 1em;&quot;&gt;The comments for your order are:&lt;/td&gt;\r\n		&lt;/tr&gt;\r\n		&lt;tr&gt;\r\n			&lt;td&gt;&amp;nbsp;&lt;/td&gt;\r\n		&lt;/tr&gt;\r\n		&lt;tr&gt;\r\n			&lt;td class=&quot;align_left&quot;&gt; {{{ comment }}} &lt;/td&gt;\r\n		&lt;/tr&gt;\r\n		&lt;tr&gt;\r\n			&lt;td&gt;&amp;nbsp;&lt;/td&gt;\r\n		&lt;/tr&gt;\r\n {{/ comment }}\r\n {{# invoice }}\r\n		&lt;tr&gt;\r\n			&lt;td class=&quot;align_left&quot;\r\n			    style=&quot;background-color: #069; color: #FFF; font-size: 12px; font-weight: bold; padding: 0.5em 1em;&quot;&gt;To view your order click on the link below:&lt;/td&gt;\r\n		&lt;/tr&gt;\r\n		&lt;tr&gt;\r\n			&lt;td&gt;&amp;nbsp;&lt;/td&gt;\r\n		&lt;/tr&gt;\r\n		&lt;tr&gt;\r\n		&lt;td class=&quot;align_left&quot;&gt;&lt;a href=&quot;{{ invoice }}&quot;&gt; {{ invoice }}&lt;/a&gt;&lt;/td&gt;\r\n		&lt;/tr&gt;\r\n		&lt;tr&gt;\r\n			&lt;td&gt;&amp;nbsp;&lt;/td&gt;\r\n		&lt;/tr&gt;\r\n{{/ invoice }}\r\n	&lt;tr&gt;\r\n		&lt;td class=&quot;align_center&quot;\r\n		    style=&quot;font-size: 10px; border-top: 1px solid #069; text-decoration: none; color: #374953;&quot;&gt;\r\n			&lt;a href=&quot;{{ store_url }}&quot;\r\n			   style=&quot;color: #069; font-weight: bold; text-decoration: none;&quot;&gt;{{ store_name }}&lt;/a&gt;\r\n{{{ text_project_label }}}\r\n		&lt;/td&gt;\r\n	&lt;/tr&gt;\r\n&lt;/table&gt;\r\n&lt;/body&gt;\r\n&lt;/html&gt;\r\n','Thank you for your interest in {{store_name}} products. Your order has been received and will be processed after payment is confirmed.\r\n\r\nOrder Details\r\n\r\nOrder ID: {{ order_id }}\r\nDate Ordered: {{ date_added }}\r\nPayment Method: {{ payment_method }}\r\nShipping Method: {{ shipping_method }}\r\n\r\nEmail: {{ customer_email }}\r\nTelephone: {{ customer_telephone }}\r\n{{# customer_mobile_phone }}\r\nTelephone: {{ customer_mobile_phone }}\r\n{{/ customer_mobile_phone }}\r\n{{# customer_fax }}\r\nFax: {{ customer_fax }}\r\n{{/ customer_fax }}\r\nIP Address: {{ customer_ip }}\r\n\r\n{{# shipping_data }}\r\nShipping Address:\r\n{{{ firstname }}} {{{lastname}}}\r\n{{{ company }}} \r\n{{{ address_1 }}} \r\n{{{ address_2 }}}\r\n{{{ city }}} {{{ postcode }}}\r\n{{{ zone }}}\r\n{{{ country }}}\r\n{{/ shipping_data }}\r\n\r\n{{# payment_data }}\r\nPayment Address:\r\n{{{ firstname }}} {{{lastname}}}\r\n{{{ company }}} \r\n{{{ address_1 }}} \r\n{{{ address_2 }}}\r\n{{{ city }}} {{{ postcode }}}\r\n{{{ zone }}}\r\n{{{ country }}}\r\n{{/ payment_data }}\r\n\r\n\r\nProduct                                                 Model                             Price                  Quantity              Total\r\n{{# products }}\r\n					\r\n{{ name }}                                               {{ model }}                       {{ price }}            {{ quantity }}        {{ total }}\r\n   {{# option }}\r\n    - {{ name}} {{ value }} \r\n   {{/ option }}\r\n\r\n\r\n{{/ products }}\r\n{{# totals }}\r\n  {{ title }}  {{ text }}\r\n{{/ totals }}\r\n\r\n\r\n{{# comment }}\r\n	The comments for your order are:\r\n {{{ comment }}} \r\n{{/ comment }}\r\n\r\n{{# invoice }}\r\nTo view your order click on the link below:\r\n{{ invoice }}\r\n{{/ invoice }}\r\n\r\n{{ store_name }}\r\n{{ text_project_label }}','store_name, order_id, store_url, logo_uri, logo_html, date_added, payment_method, shipping_method, customer_email, customer_telephone, customer_mobile_phone, customer_fax, customer_ip, shipping_data, payment_data, products, totals, comment, invoice,  text_project_label, ',0),
(8,1,'storefront_order_confirm_admin_notify',1,'','{{store_name}} - Order {{ order_id }}','&lt;html&gt;\r\n&lt;head&gt;\r\n	&lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=utf-8&quot;&gt;\r\n	&lt;title&gt; {{store_name}} - Order {{ order_id }} &lt;/title&gt;\r\n&lt;/head&gt;\r\n&lt;body&gt;\r\n&lt;table style=&quot;font-family: Verdana,sans-serif; font-size: 11px; color: #374953; width: 600px;&quot;&gt;\r\n	&lt;tr&gt;\r\n		&lt;td class=&quot;align_left&quot;&gt;\r\n				&lt;a href=&quot;{{ store_url }}&quot; title=&quot;{{ store_name }}&quot;&gt;\r\n						{{# logo_uri}}\r\n				&lt;img src=&quot;{{ logo_uri }}&quot; alt=&quot;{{store_name}}&quot; style=&quot;border: none;&quot;&gt;\r\n                                                 {{/ logo_uri}}\r\n                                                 {{^ logo_uri}}\r\n                                                       {{# logo_html}}\r\n                                                        {{logo_html}}\r\n                                                       {{/ logo_html}}\r\n                                                 {{/ logo_uri}}\r\n					&lt;/a&gt;\r\n				&lt;/td&gt;\r\n	&lt;/tr&gt;\r\n	&lt;tr&gt;\r\n		&lt;td&gt;&amp;nbsp;&lt;/td&gt;\r\n	&lt;/tr&gt;\r\n	&lt;tr&gt;\r\n		&lt;td class=&quot;align_left&quot;&gt;You have received an order.&lt;/td&gt;\r\n	&lt;/tr&gt;\r\n	&lt;tr&gt;\r\n		&lt;td&gt;&amp;nbsp;&lt;/td&gt;\r\n	&lt;/tr&gt;\r\n	&lt;tr&gt;\r\n		&lt;td class=&quot;align_left&quot;\r\n		    style=&quot;background-color: #069; color:#FFF; font-size: 12px; font-weight: bold; padding: 0.5em 1em;&quot;&gt;Order Details&lt;/td&gt;\r\n	&lt;/tr&gt;\r\n	&lt;tr&gt;\r\n		&lt;td&gt;&amp;nbsp;&lt;/td&gt;\r\n	&lt;/tr&gt;\r\n	&lt;tr&gt;\r\n		&lt;td class=&quot;align_left&quot;&gt;Order ID: &lt;span\r\n			style=&quot;color: #069; font-weight: bold;&quot;&gt;{{ order_id }}&lt;/span&gt;&lt;br/&gt;\r\n			Date Ordered: {{ date_added }}&lt;br&gt;\r\n			Payment Method: &lt;strong&gt;{{ payment_method }}&lt;/strong&gt;&lt;br/&gt;\r\n			Shipping Method: &lt;strong&gt;{{ shipping_method }}&lt;/strong&gt;&lt;br/&gt;\r\n			&lt;br/&gt;\r\n			Email: &lt;strong&gt;{{ customer_email }}&lt;/strong&gt;&lt;br/&gt;\r\n			Telephone: &lt;strong&gt;{{ customer_telephone }}&lt;/strong&gt;&lt;br/&gt;\r\n                         {{# customer_mobile_phone }}\r\n                            Telephone: &lt;strong&gt;{{ customer_mobile_phone }}&lt;/strong&gt;&lt;br/&gt;\r\n                         {{/ customer_mobile_phone }}\r\n		         {{# customer_fax }}\r\n                            Fax: &lt;strong&gt;{{ customer_fax }}&lt;/strong&gt;&lt;br/&gt;\r\n                         {{/ customer_fax }}\r\n                         IP Address:&lt;strong&gt;{{ customer_ip }}&lt;/strong&gt;\r\n		&lt;/td&gt;\r\n	&lt;/tr&gt;\r\n	&lt;tr&gt;\r\n		&lt;td&gt;&amp;nbsp;&lt;/td&gt;\r\n	&lt;/tr&gt;\r\n	&lt;tr&gt;\r\n		&lt;td&gt;\r\n			&lt;table style=&quot;width: 100%; font-family: Verdana,sans-serif; font-size: 11px; color: #FFFFFF;&quot;&gt;\r\n		&lt;tr style=&quot;background-color: #CCCCCC; text-transform: uppercase;&quot;&gt;\r\n					&lt;th style=&quot;text-align: left; padding: 0.3em;&quot;&gt;Shipping Address&lt;/th&gt;\r\n		&lt;th style=&quot;text-align: left; padding: 0.3em;&quot;&gt;Payment Address&lt;/th&gt;\r\n				&lt;/tr&gt;\r\n				&lt;tr&gt;\r\n					&lt;td style=&quot;padding: 0.3em; background-color: #EEEEEE; color: #000;&quot;&gt;\r\n{{# shipping_data }}\r\n{{ firstname }} {{lastname}} &lt;br/&gt;\r\n{{# company }}\r\n{{{ company }}} &lt;br/&gt; \r\n{{/ company }}\r\n{{# address_1 }}\r\n{{{ address_1 }}} &lt;br/&gt; \r\n{{/ address_1 }}\r\n{{# address_2 }}\r\n{{{ address_2 }}} &lt;br/&gt; \r\n{{/ address_2 }}\r\n{{{ city }}} {{{ postcode }}} &lt;br/&gt; \r\n{{# zone }}\r\n{{{ zone }}} &lt;br/&gt; \r\n{{/ zone }}\r\n{{{ country }}}\r\n{{/ shipping_data }}\r\n&lt;/td&gt;\r\n					&lt;td style=&quot;padding: 0.3em; background-color: #EEEEEE; color: #000;&quot;&gt;\r\n{{# payment_data }}\r\n{{ firstname }} {{lastname}} &lt;br/&gt;\r\n{{# company }}\r\n{{{ company }}} &lt;br/&gt; \r\n{{/ company }}\r\n{{# address_1 }}\r\n{{{ address_1 }}} &lt;br/&gt; \r\n{{/ address_1 }}\r\n{{# address_2 }}\r\n{{{ address_2 }}} &lt;br/&gt; \r\n{{/ address_2 }}\r\n{{{ city }}} {{{ postcode }}} &lt;br/&gt; \r\n{{# zone }}\r\n{{{ zone }}} &lt;br/&gt; \r\n{{/ zone }}\r\n{{{ country }}}\r\n{{/ payment_data }}\r\n&lt;/td&gt;\r\n				&lt;/tr&gt;\r\n			&lt;/table&gt;\r\n		&lt;/td&gt;\r\n	&lt;/tr&gt;\r\n	&lt;tr&gt;\r\n&lt;td&gt;&amp;nbsp;&lt;/td&gt;\r\n	&lt;/tr&gt;\r\n	&lt;tr&gt;\r\n		&lt;td class=&quot;align_left&quot;&gt;\r\n			&lt;table style=&quot;width: 100%; font-family: Verdana,sans-serif; font-size: 11px; color: #000000;&quot;&gt;\r\n				&lt;tr style=&quot;background-color: #CCCCCC;&quot;&gt;\r\n					&lt;th style=&quot;width: 40%; padding: 0.3em; color: #FFFFFF;&quot;&gt;Product&lt;/th&gt;\r\n					&lt;th class=&quot;align_left&quot; style=&quot;color: #FFFFFF;&quot;&gt;Model&lt;/th&gt;\r\n					&lt;th class=&quot;align_right&quot;\r\n		    style=&quot;width: 10%; padding: 0.3em; color: #FFFFFF;&quot;&gt;Price&lt;/th&gt;\r\n					&lt;th class=&quot;align_right&quot;\r\n					    style=&quot;width: 15%; padding: 0.3em; color: #FFFFFF;&quot;&gt;Quantity&lt;/th&gt;\r\n					&lt;th class=&quot;align_right&quot;\r\n					    style=&quot;width: 20%; padding: 0.3em; color: #FFFFFF;&quot;&gt;Total&lt;/th&gt;\r\n				&lt;/tr&gt;\r\n				{{# products }}\r\n					&lt;tr style=&quot;background-color: #EEEEEE; text-align: center;&quot;&gt;\r\n						&lt;td class=&quot;align_left&quot; style=&quot;text-align: left;&quot;&gt;{{ name }}\r\n					{{# option }}\r\n			&lt;br/&gt;\r\n								&amp;nbsp;&amp;nbsp;- {{ name}} {{ value }} \r\n	{{/ option }}\r\n						&lt;td class=&quot;align_left&quot;&gt; {{ model }} &lt;/td&gt;\r\n						&lt;td class=&quot;align_right&quot;&gt; {{ price }} &lt;/td&gt;\r\n						&lt;td class=&quot;align_right&quot;&gt; {{ quantity }} &lt;/td&gt;\r\n						&lt;td class=&quot;align_right&quot;&gt; {{ total }}&lt;/td&gt;\r\n					&lt;/tr&gt;\r\n                                {{/ products }}\r\n                                         {{# totals }}\r\n			&lt;tr style=&quot;text-align: right;&quot;&gt;\r\n						&lt;td colspan=&quot;3&quot;&gt;&amp;nbsp;&lt;/td&gt;\r\n						&lt;td style=&quot;background-color: #EEEEEE; font-weight: bold; padding: 0.3em;&quot;&gt;{{ title }} &lt;/td&gt;\r\n					&lt;td style=&quot;background-color: #EEEEEE; padding: 0.3em;&quot;&gt; {{ text }}&lt;/td&gt;\r\n					&lt;/tr&gt;\r\n                                         {{/ totals }}\r\n		&lt;/table&gt;\r\n		&lt;/td&gt;\r\n	&lt;/tr&gt;\r\n	&lt;tr&gt;\r\n		&lt;td&gt;&amp;nbsp;&lt;/td&gt;\r\n	&lt;/tr&gt;\r\n	&lt;tr&gt;\r\n		&lt;td class=&quot;align_left&quot;\r\n		    style=&quot;background-color: #069; color: #FFF; font-size: 12px; font-weight: bold; padding: 0.5em 1em;&quot;&gt;&lt;/td&gt;\r\n	&lt;/tr&gt;\r\n	&lt;tr&gt;\r\n		&lt;td&gt;&amp;nbsp;&lt;/td&gt;\r\n	&lt;/tr&gt;\r\n {{# comment }}\r\n	&lt;tr&gt;\r\n			&lt;td class=&quot;align_left&quot;\r\n			    style=&quot;background-color: #069; color: #FFF; font-size: 12px; font-weight: bold; padding: 0.5em 1em;&quot;&gt;The comments for your order are:&lt;/td&gt;\r\n		&lt;/tr&gt;\r\n		&lt;tr&gt;\r\n			&lt;td&gt;&amp;nbsp;&lt;/td&gt;\r\n		&lt;/tr&gt;\r\n		&lt;tr&gt;\r\n			&lt;td class=&quot;align_left&quot;&gt; {{{ comment }}} &lt;/td&gt;\r\n		&lt;/tr&gt;\r\n		&lt;tr&gt;\r\n			&lt;td&gt;&amp;nbsp;&lt;/td&gt;\r\n		&lt;/tr&gt;\r\n {{/ comment }}\r\n {{# invoice }}\r\n		&lt;tr&gt;\r\n			&lt;td class=&quot;align_left&quot;\r\n			    style=&quot;background-color: #069; color: #FFF; font-size: 12px; font-weight: bold; padding: 0.5em 1em;&quot;&gt;To view your order click on the link below:&lt;/td&gt;\r\n		&lt;/tr&gt;\r\n		&lt;tr&gt;\r\n			&lt;td&gt;&amp;nbsp;&lt;/td&gt;\r\n		&lt;/tr&gt;\r\n		&lt;tr&gt;\r\n&lt;td class=&quot;align_left&quot;&gt;&lt;a href=&quot;{{ invoice }}&quot;&gt; {{ invoice }}&lt;/a&gt;&lt;/td&gt;\r\n		&lt;/tr&gt;\r\n		&lt;tr&gt;\r\n			&lt;td&gt;&amp;nbsp;&lt;/td&gt;\r\n		&lt;/tr&gt;\r\n{{/ invoice }}\r\n	&lt;tr&gt;\r\n		&lt;td class=&quot;align_center&quot;\r\n		    style=&quot;font-size: 10px; border-top: 1px solid #069; text-decoration: none; color: #374953;&quot;&gt;\r\n			&lt;a href=&quot;{{ store_url }}&quot;\r\n			   style=&quot;color: #069; font-weight: bold; text-decoration: none;&quot;&gt;{{ store_name }}&lt;/a&gt;\r\n{{{ text_project_label }}}\r\n	&lt;/td&gt;\r\n	&lt;/tr&gt;\r\n&lt;/table&gt;\r\n&lt;/body&gt;\r\n&lt;/html&gt;\r\n','You have received an order.\r\n\r\nOrder Details\r\n\r\nOrder ID: {{ order_id }}\r\nDate Ordered: {{ date_added }}\r\nPayment Method: {{ payment_method }}\r\nShipping Method: {{ shipping_method }}\r\n\r\nEmail: {{ customer_email }}\r\nTelephone: {{ customer_telephone }}\r\n{{# customer_mobile_phone }}\r\nTelephone: {{ customer_mobile_phone }}\r\n{{/ customer_mobile_phone }}\r\n{{# customer_fax }}\r\nFax: {{ customer_fax }}\r\n{{/ customer_fax }}\r\nIP Address: {{ customer_ip }}\r\n\r\n{{# shipping_data }}\r\nShipping Address:\r\n{{{ firstname }}} {{{lastname}}}\r\n{{{ company }}}\r\n{{{ address_1 }}} \r\n{{{ address_2 }}}\r\n{{{ city }}} {{{ postcode }}}\r\n{{{ zone }}}\r\n{{{ country }}}\r\n{{/ shipping_data }}\r\n\r\n{{# payment_data }}\r\nPayment Address:\r\n{{{ firstname }}} {{{lastname}}} \r\n{{{ company }}}\r\n{{{ address_1 }}}\r\n{{{ address_2 }}}\r\n{{{ city }}} {{{ postcode }}}\r\n{{{ zone }}}\r\n{{{ country }}}\r\n{{/ payment_data }}\r\n\r\n\r\nProduct                                                 Model                             Price                  Quantity              Total\r\n{{# products }}\r\n					\r\n{{ name }}                                               {{ model }}                       {{ price }}            {{ quantity }}        {{ total }}\r\n   {{# option }}\r\n    - {{ name}} {{ value }} \r\n   {{/ option }}\r\n\r\n\r\n{{/ products }}\r\n{{# totals }}\r\n  {{ title }}  {{ text }}\r\n{{/ totals }}\r\n\r\n\r\n{{# comment }}\r\n	The comments for your order are:\r\n {{{ comment }}} \r\n{{/ comment }}\r\n\r\n{{# invoice }}\r\nTo view your order click on the link below:\r\n{{ invoice }}\r\n{{/ invoice }}\r\n\r\n{{ store_name }}\r\n{{ text_project_label }}','store_name, order_id, store_url, logo_uri, logo_html, date_added, payment_method, shipping_method, customer_email, customer_telephone, customer_mobile_phone, customer_fax, customer_ip, shipping_data, payment_data, products, totals, comment, invoice,  text_project_label, order_total',0),
(11,1,'admin_order_status_notify',1,'','{{ store_name }} - Order Update {{ order_id }}','Order:  {{ order_id }} &lt;br/&gt;\r\nDate added: {{ order_date_added }} &lt;br/&gt;\r\nOrder status: {{ order_status }} &lt;br/&gt;\r\nInvoice: {{ invoice }}&lt;br/&gt;\r\n&lt;br/&gt;\r\n\r\nComment:&lt;br/&gt;\r\n{{{ comment }}}&lt;br/&gt;\r\n\r\n&lt;br/&gt;\r\n\r\nPlease reply to this email if you have any questions.\r\n','Order:  {{ order_id }} \r\nDate added: {{ order_date_added }} \r\nOrder status: {{ order_status }} \r\nInvoice: {{ invoice }}\r\n\r\nComment:\r\n{{{ comment }}}\r\n\r\nPlease reply to this email if you have any questions.\r\n','store_name, order_id, order_date_added, order_status, invoice, comment',0),
(12,1,'admin_new_transaction_notify',1,'','New transaction has been posted to your {{store_name}} account','New transaction has been posted to your {{ store_name }} account in the amount of {{ amount }}. For more details, login to {{ store_name }} account','New transaction has been posted to your {{ store_name }} account in the amount of {{ amount }}. For more details, login to {{ store_name }} account','store_name, amount, transactions_url',0),
(13,1,'admin_approval_email',1,'','{{ store_name}} - Your Account has been activated!','&lt;a href=\"{{ store_url }}\" title=\"{{ store_name }}\"&gt;\r\n						{{# logo_uri}}\r\n				&lt;img src=\"{{ logo_uri }}\" alt=\"{{store_name}}\" style=\"border: none;\"&gt;\r\n                                                 {{/ logo_uri}}\r\n                                                 {{^ logo_uri}}\r\n                                                       {{# logo_html}}\r\n                                                        {{logo_html}}\r\n                                                       {{/ logo_html}}\r\n                                                 {{/ logo_uri}}\r\n					&lt;/a&gt;\r\n\r\nWelcome and thank you for registering at {{ store_name }} &lt;br/&gt;\r\nYour account has now been created and you can log in by using your email address and password by visiting our website or at the following URL: &lt;br/&gt;\r\n{{ store_url }}&lt;br/&gt;\r\n&lt;br/&gt;\r\n\r\nOnce you logging in, you will be able to access, your wishlist, order history, printing invoices and editing your account information.&lt;br/&gt;\r\n&lt;br/&gt;\r\nThank you,&lt;br/&gt;\r\n {{ store_name}} &lt;br/&gt;\r\n\r\n{{ text_project_label }}','Welcome and thank you for registering at {{ store_name }} \r\nYour account has now been created and you can log in by using your email address and password by visiting our website or at the following URL: \r\n{{ store_url }}\r\n\r\nOnce you logging in, you will be able to access, your wishlist, order history, printing invoices and editing your account information.\r\n\r\nThank you,\r\n {{ store_name}} \r\n\r\n{{text_project_label}}','store_name, store_url, text_project_label, logo_uri, logo_html',0),
(14,1,'storefront_password_reset_notify',1,'','{{store_name}} Notification','Your password has been updated! If you did not do any changes, please contact site owner&lt;br/&gt;','Your password has been updated! If you did not do any changes, please contact site owner','store_name, loginname, customer_id, firstname, lastname',0),
(15,1,'storefront_customer_account_update',1,'','{{store_name}} Account update notification','Your account has been updated! If you did not do any changes, please contact site owner ',' Your account has been updated! If you did not do any changes, please contact site owner ','store_name, firstname, lastname, telephone, fax, email, loginname, customer_id, old_loginname, old_email',0),
(16,1,'storefront_contact_us_mail',1,'','Enquiry from {{ first_name }}','&lt;html&gt;\r\n&lt;head&gt;\r\n	&lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=utf-8&quot;&gt;\r\n	&lt;title&gt;{{ title }}&lt;/title&gt;\r\n&lt;/head&gt;\r\n&lt;body&gt;\r\n&lt;table style=&quot;font-family: Verdana,sans-serif; font-size: 11px; color: #374953; width: 600px;&quot;&gt;\r\n	&lt;tr&gt;\r\n		&lt;td class=&quot;align_left&quot;&gt;\r\n			&lt;a href=&quot;{{ store_url }}&quot; title=&quot;{{ store_name }}&quot;&gt;\r\n				{{# logo_uri }}\r\n					&lt;img src=&quot;{{ logo_uri }}&quot; alt=&quot;{{ store_name }}&quot; style=&quot;border: none;&quot;&gt;\r\n				{{/ logo_uri }}\r\n				{{# logo_html }}\r\n					{{ logo_html }}\r\n				{{/ logo_html }}				 \r\n			&lt;/a&gt;\r\n		&lt;/td&gt;\r\n	&lt;/tr&gt;\r\n	&lt;tr&gt;\r\n		&lt;td&gt;&amp;nbsp;&lt;/td&gt;\r\n	&lt;/tr&gt;\r\n	&lt;tr&gt;\r&lt;td&gt;&amp;nbsp;&lt;/td&gt;\r\n	&lt;/tr&gt;\r\n	&lt;tr&gt;\r\n		&lt;td class=&quot;align_left&quot;\r\n		    style=&quot;background-color: #069; color:#FFF; font-size: 12px; font-weight: bold; padding: 0.5em 1em;&quot;&gt;{{ entry_enquiry }}&lt;/td&gt;\r\n	&lt;/tr&gt;\r\n	&lt;tr&gt;\r\n		&lt;td class=&quot;align_left&quot;\r\n		    style=&quot; font-size: 12px; padding: 0.5em 1em;&quot;&gt;{{{ enquiry }}}&lt;/td&gt;\r\n	&lt;/tr&gt;\r\n	&lt;tr&gt;\r\n		&lt;td&gt;&amp;nbsp;&lt;/td&gt;\r\n	&lt;/tr&gt;\r\n	&lt;tr&gt;\r\n		&lt;td&gt;\r\n			&lt;table style=&quot;width: 100%; font-family: Verdana,sans-serif; font-size: 11px; color: #FFFFFF;&quot;&gt;\r\n				{{# tpl_form_fields }}\r\n				&lt;tr&gt;\r\n				&lt;td style=&quot;padding: 0.3em; background-color: #EEEEEE; color: #000;&quot;&gt;{{ name }}&lt;/td&gt;\r\n					&lt;td style=&quot;padding: 0.3em; background-color: #EEEEEE; color: #000;&quot;&gt;{{ value }}&lt;/td&gt;\r\n				&lt;/tr&gt;\r\n				{{/ tpl_form_fields }}\r\n			&lt;/table&gt;\r\n		&lt;/td&gt;\r\n	&lt;/tr&gt;\r\n	&lt;tr&gt;\r\n		&lt;td&gt;&amp;nbsp;&lt;/td&gt;\r\n	&lt;/tr&gt;\r\n	&lt;tr&gt;\r\n		&lt;td class=&quot;align_center&quot;\r\n		    style=&quot;font-size: 10px; border-top: 1px solid #069; text-decoration: none; color: #374953;&quot;&gt;\r\n			&lt;a href=&quot;{{ store_url }}&quot;\r\n			   style=&quot;color: #069; font-weight: bold; text-decoration: none;&quot;&gt;{{ store_name }}&lt;/a&gt;&lt;br&gt;\r\n{{{ text_project_label }}}\r\n		&lt;/td&gt;\r\n	&lt;/tr&gt;\r\n&lt;/table&gt;\r\n&lt;/body&gt;\r\n&lt;/html&gt;\r\n','{{ store_name }}\r\n\r\n{{ entry_enquiry }}\r\n{{{ enquiry }}}\r\n\r\n\r\n{{# tpl_form_fields }}\r\n{{ name }}  {{ value }}\r\n{{/ tpl_form_fields }}\r\n\r\n{{{ text_project_label }}}','first_name, title, store_url, store_name, logo_uri, logo_html, entry_enquiry, enquiry, tpl_form_fields, form_fields, text_project_label',0),
(17,1,'storefront_contact_us_mail_admin_notify',1,'','New enquiry from customer',' You have got new enquiry from customer ({{first_name}}, {{email}})!',' You have got new enquiry from customer ({{first_name}}, {{email}})! ','first_name, email',0),
(18,1,'storefront_new_customer_admin_notify',1,'',' New Customer {{ firstname }} {{ lastname }} has been registered!',' New Customer {{ firstname }} {{ lastname }}  has been registered!',' New Customer {{ firstname }} {{ lastname }}  has been registered!','firstname, lastname',0),
(19,1,'storefront_new_subscriber_admin_notify',1,'',' New Subscriber {{ firstname }} {{ lastname }} has been registered!',' New Subscriber {{ firstname }} {{ lastname }} has been registered!',' New Subscriber {{ firstname }} {{ lastname }} has been registered!','firstname, lastname',0),
(21,1,'storefront_product_out_of_stock_admin_notify',1,'','Product with ID #{{ product_id }} is out of Stock. ',' Product with ID #{{ product_id }} is out of Stock. \r\n&lt;br/&gt;&lt;br/&gt;\r\n{{{ text_project_label }}}',' Product with ID #{{ product_id }} is out of Stock. \r\n\r\n{{{ text_project_label }}}','product_id, text_project_label',0),
(22,1,'storefront_product_review_admin_notify',1,'',' New product review has been added.',' New product review has been added. See details {{ product_url }}\r\n&lt;br/&gt;&lt;br/&gt;\r\n{{{ text_project_label }}}',' New product review has been added. See details {{ product_url }}\r\n\r\n{{{ text_project_label }}}','product_url, product_id, text_project_label',0),
(23,1,'storefront_welcome_email_approved',1,'','Welcome, {{store_name}} ','&lt;html&gt;\r\n	&lt;head&gt;\r\n		&lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=utf-8&quot;&gt;\r\n	&lt;/head&gt;\r\n	&lt;body&gt;\r\n		&lt;table style=&quot;font-family: Verdana,sans-serif; font-size: 11px; color: #374953; width: 600px;&quot;&gt;\r\n			&lt;tr&gt;\r\n				&lt;td class=&quot;align_left&quot;&gt;\r\n				&lt;a href=&quot;{{ store_url }}&quot; title=&quot;{{ store_name }}&quot;&gt;\r\n						{{# logo_uri}}\r\n				&lt;img src=&quot;{{ logo_uri }}&quot; alt=&quot;{{store_name}}&quot; style=&quot;border: none;&quot;&gt;\r\n                                                 {{/ logo_uri}}\r\n                                                 {{^ logo_uri}}\r\n                                                       {{# logo_html}}\r\n                                                        {{logo_html}}\r\n                                                       {{/ logo_html}}\r\n                                                 {{/ logo_uri}}\r\n					&lt;/a&gt;\r\n				&lt;/td&gt;\r\n			&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n				&lt;td&gt;&amp;nbsp;&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n		&lt;td&gt;Welcome and thank you for registering at {{ store_name }}&lt;/td&gt;\r\n		&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n				&lt;td&gt;&amp;nbsp;&lt;/td&gt;\r\n		&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n				&lt;td&gt;\r\n                          Your account has now been created and you can log in by using your email address and password by visiting our website or at the following URL:&lt;br/&gt;\r\n&lt;a href=&quot;{{ login_url }}&quot;&gt;{{ login_url }}&lt;/a&gt;&lt;br/&gt;\r\nOnce you logging in, you will be able to access, your wishlist, order history, printing invoices and editing your account information.\r\n	&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n				&lt;td&gt;&amp;nbsp;&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n				&lt;td&gt;\r\n					Thank you.&lt;br/&gt;\r\n                                        {{ store_name }}\r\n&lt;br/&gt;&lt;br/&gt;\r\n{{{ text_project_label }}}\r\n		&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n		&lt;/table&gt;\r\n	&lt;/body&gt;\r\n&lt;/html&gt;','Welcome and thank you for registering at {{ store_name }}\r\n\r\nYour account has now been created and you can log in by using your email address and password by visiting our website or at the following URL:\r\n{{ login_url }}\r\n\r\nOnce you logging in, you will be able to access, your wishlist, order history, printing invoices and editing your account information.\r\n\r\nThank you.\r\n{{ store_name }}\r\n{{{ text_project_label }}}','store_name, login_url, store_url, logo_html, logo_uri, text_project_label',0),
(24, 1,'fast_checkout_welcome_email_guest_registration',1,'','Welcome, {{store_name}}','&lt;html&gt;\r\n	&lt;head&gt;\r\n		&lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=utf-8&quot;&gt;\r\n	&lt;/head&gt;\r\n	&lt;body&gt;\r\n		&lt;table style=&quot;font-family: Verdana,sans-serif; font-size: 11px; color: #374953; width: 600px;&quot;&gt;\r\n			&lt;tr&gt;\r\n				&lt;td class=&quot;align_left&quot;&gt;\r\n				&lt;a href=&quot;{{ store_url }}&quot; title=&quot;{{ store_name }}&quot;&gt;\r\n						{{# logo_uri}}\r\n				&lt;img src=&quot;{{ logo_uri }}&quot; alt=&quot;{{store_name}}&quot; style=&quot;border: none;&quot;&gt;\r\n                                                 {{/ logo_uri}}\r\n                                                 {{^ logo_uri}}\r\n                                                       {{# logo_html}}\r\n                                                        {{logo_html}}\r\n                                                       {{/ logo_html}}\r\n                                                 {{/ logo_uri}}\r\n					&lt;/a&gt;\r\n				&lt;/td&gt;\r\n			&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n				&lt;td&gt;&amp;nbsp;&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n		&lt;td&gt;Welcome and thank you for registering at {{ store_name }}&lt;/td&gt;\r\n		&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n				&lt;td&gt;&amp;nbsp;&lt;/td&gt;\r\n		&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n				&lt;td&gt;\r\n                          Your account has now been created and you can log in by using your email address and password by visiting our website or at the following URL:&lt;br/&gt;\r\n&lt;a href=&quot;{{ login_url }}&quot;&gt;{{ login_url }}&lt;/a&gt;&lt;br/&gt;\r\n&lt;br/&gt;\r\nYour Login Name: {{login}}  &lt;br/&gt;\r\nYour Password: {{password}}  &lt;br/&gt;\r\n	&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n				&lt;td&gt;&amp;nbsp;&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n				&lt;td&gt;\r\n					Thank you.&lt;br/&gt;\r\n                                        {{ store_name }}\r\n&lt;br/&gt;&lt;br/&gt;\r\n{{{ text_project_label }}}\r\n		&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n		&lt;/table&gt;\r\n	&lt;/body&gt;\r\n&lt;/html&gt;','Welcome and thank you for registering at {{ store_name }}\r\n\r\nYour account has now been created and you can log in by using your email address and password by visiting our website or at the following URL:\r\n{{ login_url }}\r\n\r\nYour Login Name: {{login}}\r\nYour Password: {{password}}\r\n\r\n\r\nThank you.\r\n{{ store_name }}\r\n{{{ text_project_label }}}','store_name, login_url, store_url, logo_html, logo_uri, text_project_label, login, password',0),
(25,1,'admin_reset_password_link',1,'','{{store_name}} - Password reset','A password reset was requested from {{store_name}}&lt;br /&gt;\r\nTo reset your password click link below:&lt;br /&gt;\r\n&lt;a href="{{ reset_link }}"&gt;{{ reset_link }}&lt;/a &gt;\r\n&lt;br /&gt;&lt;br /&gt;\r\n{{{ text_project_label }}}','A password reset was requested from {{store_name}} \r\nTo reset your password click link below:\r\n{{ reset_link }}\r\n\r\n\r\n{{{ text_project_label }}}','store_name, reset_link, text_project_label',0)
;

DROP TABLE IF EXISTS `ac_collections`;
CREATE TABLE `ac_collections` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `status` tinyint(4) NOT NULL DEFAULT '0',
  `name` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `description` text COLLATE utf8_bin,
  `conditions` text COLLATE utf8_bin,
  `store_id` int(11) NOT NULL DEFAULT '0',
  `date_added` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

DROP TABLE IF EXISTS `ac_collection_descriptions`;
CREATE TABLE `ac_collection_descriptions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `collection_id` int(11) NOT NULL,
  `language_id` int(11) NOT NULL,
  `title` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `meta_keywords` text COLLATE utf8_bin,
  `meta_description` text COLLATE utf8_bin,
  PRIMARY KEY (`id`),
  UNIQUE KEY `collection_language_idx` (`collection_id`,`language_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;


INSERT INTO `ac_url_aliases` (`query`, `keyword`, `language_id`) VALUES ('check_seo=1', 'check_seo_url', 1);

--
-- Dumping data for table `block_layouts`
--
INSERT INTO `ac_block_layouts`
(`instance_id`,`layout_id`,`block_id`,`custom_block_id`,`parent_instance_id`, `position`,`status`)
VALUES
(2122, 23, 21, 0, 0, 80, 1),
(2101, 23, 27, 0, 0, 30, 1),
(2100, 23, 3, 0, 0, 30, 0),
(2099, 23, 31, 0, 0, 20, 1),
(2098, 23, 28, 0, 0, 20, 1),
(2097, 23, 28, 0, 2095, 20, 1),
(2095, 23, 2, 0, 0, 20, 1),
(2094, 23, 9, 0, 0, 10, 1),
(2093, 23, 17, 17, 2086, 70, 1),
(2092, 23, 14, 0, 2086, 60, 1),
(2091, 23, 13, 0, 2086, 50, 1),
(2090, 23, 26, 0, 2086, 40, 1),
(2089, 23, 27, 0, 2086, 30, 1),
(2088, 23, 31, 0, 2086, 20, 1),
(2087, 23, 15, 0, 2086, 10, 1),
(2102, 23, 25, 0, 0, 40, 1),
(2103, 23, 26, 0, 0, 40, 1),
(2104, 23, 4, 0, 0, 40, 1),
(2121, 23, 21, 0, 2113, 80, 1),
(2120, 23, 24, 0, 2113, 70, 1),
(2118, 23, 11, 0, 2113, 50, 1),
(2117, 23, 25, 0, 2113, 40, 1),
(2115, 23, 17, 19, 2113, 20, 1),
(2114, 23, 17, 18, 2113, 10, 1),
(2113, 23, 8, 0, 0, 80, 1),
(2112, 23, 24, 0, 0, 70, 1),
(2111, 23, 15, 0, 0, 70, 1),
(2110, 23, 7, 0, 0, 70, 1),
(2109, 23, 14, 0, 0, 60, 1),
(2108, 23, 6, 0, 0, 60, 1),
(2107, 23, 11, 0, 0, 50, 1),
(2106, 23, 5, 0, 0, 50, 1),
(2086, 23, 1, 0, 0, 10, 1),
(2116, 23, 17, 20, 2113, 30, 1),
(2105, 23, 13, 0, 0, 50, 1),
(2119, 23, 17, 17, 2113, 60, 1),
(2096, 23, 9, 0, 2095, 10, 1),
(2165, 24, 17, 20, 2162, 30, 1),
(2164, 24, 17, 19, 2162, 20, 1),
(2163, 24, 17, 18, 2162, 10, 1),
(2127, 24, 26, 0, 2123, 40, 1),
(2161, 24, 24, 0, 0, 70, 1),
(2160, 24, 20, 24, 2158, 20, 1),
(2159, 24, 23, 23, 2158, 10, 1),
(2158, 24, 7, 0, 0, 70, 1),
(2132, 24, 9, 0, 0, 10, 1),
(2166, 24, 25, 0, 2162, 40, 1),
(2167, 24, 11, 0, 2162, 50, 1),
(2128, 24, 13, 0, 2123, 50, 1),
(2129, 24, 14, 0, 2123, 60, 1),
(2130, 24, 17, 17, 2123, 70, 1),
(2171, 24, 21, 0, 0, 80, 1),
(2170, 24, 21, 0, 2162, 80, 1),
(2131, 24, 19, 0, 0, 10, 1),
(2169, 24, 24, 0, 2162, 70, 1),
(2168, 24, 17, 17, 2162, 60, 1),
(2162, 24, 8, 0, 0, 80, 1),
(2157, 24, 15, 0, 0, 70, 1),
(2156, 24, 12, 0, 2155, 10, 1),
(2155, 24, 6, 0, 0, 60, 0),
(2143, 24, 4, 0, 0, 40, 0),
(2141, 24, 3, 0, 0, 30, 0),
(2133, 24, 31, 0, 0, 20, 1),
(2134, 24, 2, 0, 0, 20, 1),
(2135, 24, 9, 0, 2134, 10, 1),
(2136, 24, 17, 21, 2134, 20, 1),
(2137, 24, 17, 22, 2134, 30, 1),
(2138, 24, 12, 0, 0, 20, 1),
(2139, 24, 27, 0, 0, 30, 1),
(2144, 24, 26, 0, 0, 40, 1),
(2145, 24, 22, 0, 0, 40, 1),
(2146, 24, 25, 0, 0, 40, 1),
(2154, 24, 14, 0, 0, 60, 1),
(2153, 24, 22, 0, 2149, 40, 1),
(2152, 24, 18, 0, 2149, 30, 1),
(2151, 24, 12, 0, 2149, 20, 1),
(2150, 24, 19, 0, 2149, 10, 1),
(2142, 24, 12, 0, 2141, 10, 1),
(2149, 24, 5, 0, 0, 50, 1),
(2148, 24, 13, 0, 0, 50, 1),
(2147, 24, 11, 0, 0, 50, 1),
(2140, 24, 18, 0, 0, 30, 1),
(2126, 24, 27, 0, 2123, 30, 1),
(2125, 24, 31, 0, 2123, 20, 1),
(2124, 24, 15, 0, 2123, 10, 1),
(2123, 24, 1, 0, 0, 10, 1),
(2177, 25, 13, 0, 2172, 50, 1),
(2178, 25, 14, 0, 2172, 60, 1),
(2179, 25, 17, 17, 2172, 70, 1),
(2180, 25, 9, 0, 0, 10, 1),
(2181, 25, 2, 0, 0, 20, 1),
(2182, 25, 9, 0, 2181, 10, 1),
(2176, 25, 26, 0, 2172, 40, 1),
(2175, 25, 27, 0, 2172, 30, 1),
(2174, 25, 31, 0, 2172, 20, 1),
(2172, 25, 1, 0, 0, 10, 1),
(2199, 25, 8, 0, 0, 80, 1),
(2204, 25, 11, 0, 2199, 50, 1),
(2205, 25, 17, 17, 2199, 60, 1),
(2206, 25, 24, 0, 2199, 70, 1),
(2207, 25, 21, 0, 2199, 80, 1),
(2183, 25, 28, 0, 2181, 20, 1),
(2184, 25, 28, 0, 0, 20, 1),
(2200, 25, 17, 18, 2199, 10, 1),
(2201, 25, 17, 19, 2199, 20, 1),
(2198, 25, 24, 0, 0, 70, 1),
(2197, 25, 15, 0, 0, 70, 1),
(2196, 25, 7, 0, 0, 70, 1),
(2195, 25, 14, 0, 0, 60, 1),
(2202, 25, 17, 20, 2199, 30, 1),
(2193, 25, 11, 0, 0, 50, 1),
(2192, 25, 5, 0, 0, 50, 1),
(2190, 25, 4, 0, 0, 40, 1),
(2189, 25, 26, 0, 0, 40, 1),
(2188, 25, 25, 0, 0, 40, 1),
(2187, 25, 27, 0, 0, 30, 1),
(2186, 25, 3, 0, 0, 30, 0),
(2203, 25, 25, 0, 2199, 40, 1),
(2208, 25, 21, 0, 0, 80, 1),
(2191, 25, 13, 0, 0, 50, 1),
(2194, 25, 6, 0, 0, 60, 0),
(2185, 25, 31, 0, 0, 20, 1),
(2173, 25, 15, 0, 2172, 10, 1),
(2243, 26, 11, 0, 2238, 50, 1),
(2230, 26, 13, 0, 0, 50, 1),
(2231, 26, 5, 0, 0, 50, 1),
(2232, 26, 11, 0, 0, 50, 1),
(2233, 26, 6, 0, 0, 60, 0),
(2234, 26, 14, 0, 0, 60, 1),
(2210, 26, 15, 0, 2209, 10, 1),
(2235, 26, 15, 0, 0, 70, 1),
(2236, 26, 7, 0, 0, 70, 0),
(2237, 26, 24, 0, 0, 70, 1),
(2238, 26, 8, 0, 0, 80, 1),
(2239, 26, 17, 18, 2238, 10, 1),
(2240, 26, 17, 19, 2238, 20, 1),
(2241, 26, 17, 20, 2238, 30, 1),
(2229, 26, 4, 0, 0, 40, 1),
(2227, 26, 25, 0, 0, 40, 1),
(2226, 26, 27, 0, 0, 30, 1),
(2211, 26, 31, 0, 2209, 20, 1),
(2212, 26, 27, 0, 2209, 30, 1),
(2213, 26, 26, 0, 2209, 40, 1),
(2214, 26, 13, 0, 2209, 50, 1),
(2215, 26, 14, 0, 2209, 60, 1),
(2216, 26, 17, 17, 2209, 70, 1),
(2217, 26, 9, 0, 0, 10, 1),
(2219, 26, 31, 0, 0, 20, 1),
(2218, 26, 12, 0, 0, 10, 1),
(2220, 26, 28, 0, 0, 20, 1),
(2221, 26, 2, 0, 0, 20, 1),
(2222, 26, 9, 0, 2221, 10, 1),
(2223, 26, 28, 0, 2221, 20, 1),
(2224, 26, 3, 0, 0, 30, 1),
(2225, 26, 12, 0, 2224, 10, 1),
(2242, 26, 25, 0, 2238, 40, 1),
(2245, 26, 24, 0, 2238, 70, 1),
(2244, 26, 17, 17, 2238, 60, 1),
(2228, 26, 26, 0, 0, 40, 1),
(2246, 26, 21, 0, 2238, 80, 1),
(2247, 26, 21, 0, 0, 80, 1),
(2209, 26, 1, 0, 0, 10, 1),
(2273, 27, 15, 0, 0, 70, 1),
(2272, 27, 7, 0, 0, 70, 1),
(2271, 27, 14, 0, 0, 60, 1),
(2269, 27, 11, 0, 0, 50, 1),
(2275, 27, 8, 0, 0, 80, 1),
(2259, 27, 28, 0, 2257, 20, 1),
(2268, 27, 5, 0, 0, 50, 1),
(2274, 27, 24, 0, 0, 70, 1),
(2276, 27, 17, 18, 2275, 10, 1),
(2284, 27, 21, 0, 0, 80, 1),
(2283, 27, 21, 0, 2275, 80, 1),
(2282, 27, 24, 0, 2275, 70, 1),
(2281, 27, 17, 17, 2275, 60, 1),
(2280, 27, 11, 0, 2275, 50, 1),
(2279, 27, 25, 0, 2275, 40, 1),
(2278, 27, 17, 20, 2275, 30, 1),
(2277, 27, 17, 19, 2275, 20, 1),
(2267, 27, 13, 0, 0, 50, 1),
(2266, 27, 4, 0, 0, 40, 1),
(2249, 27, 15, 0, 2248, 10, 1),
(2250, 27, 31, 0, 2248, 20, 1),
(2251, 27, 27, 0, 2248, 30, 1),
(2252, 27, 26, 0, 2248, 40, 1),
(2253, 27, 13, 0, 2248, 50, 1),
(2254, 27, 14, 0, 2248, 60, 1),
(2255, 27, 17, 17, 2248, 70, 1),
(2256, 27, 9, 0, 0, 10, 1),
(2257, 27, 2, 0, 0, 20, 1),
(2258, 27, 9, 0, 2257, 10, 1),
(2260, 27, 28, 0, 0, 20, 1),
(2261, 27, 31, 0, 0, 20, 1),
(2262, 27, 3, 0, 0, 30, 1),
(2263, 27, 27, 0, 0, 30, 1),
(2264, 27, 25, 0, 0, 40, 1),
(2265, 27, 26, 0, 0, 40, 1),
(2248, 27, 1, 0, 0, 10, 1),
(2270, 27, 6, 0, 0, 60, 1),
(2290, 28, 5, 0, 0, 50, 1),
(2293, 28, 8, 0, 0, 80, 1),
(2285, 28, 1, 0, 0, 10, 1),
(2286, 28, 2, 0, 0, 20, 1),
(2292, 28, 7, 0, 0, 70, 1),
(2287, 28, 28, 0, 0, 20, 1),
(2288, 28, 3, 0, 0, 30, 1),
(2289, 28, 4, 0, 0, 40, 1),
(2291, 28, 6, 0, 0, 60, 1),
(2300, 29, 14, 0, 2294, 60, 1),
(2301, 29, 17, 17, 2294, 70, 1),
(2303, 29, 29, 0, 0, 10, 1),
(2308, 29, 28, 0, 2306, 20, 1),
(2304, 29, 31, 0, 0, 20, 1),
(2305, 29, 28, 0, 0, 20, 1),
(2299, 29, 13, 0, 2294, 50, 1),
(2298, 29, 26, 0, 2294, 40, 1),
(2296, 29, 31, 0, 2294, 20, 1),
(2295, 29, 15, 0, 2294, 10, 1),
(2294, 29, 1, 0, 0, 10, 1),
(2302, 29, 9, 0, 0, 10, 1),
(2328, 29, 11, 0, 2323, 50, 1),
(2297, 29, 27, 0, 2294, 30, 1),
(2307, 29, 9, 0, 2306, 10, 1),
(2309, 29, 3, 0, 0, 30, 0),
(2310, 29, 27, 0, 0, 30, 1),
(2322, 29, 24, 0, 0, 70, 1),
(2323, 29, 8, 0, 0, 80, 1),
(2324, 29, 17, 18, 2323, 10, 1),
(2325, 29, 17, 19, 2323, 20, 1),
(2326, 29, 17, 20, 2323, 30, 1),
(2327, 29, 25, 0, 2323, 40, 1),
(2329, 29, 17, 17, 2323, 60, 1),
(2330, 29, 24, 0, 2323, 70, 1),
(2331, 29, 21, 0, 2323, 80, 1),
(2321, 29, 7, 0, 0, 70, 1),
(2320, 29, 15, 0, 0, 70, 1),
(2311, 29, 25, 0, 0, 40, 1),
(2312, 29, 26, 0, 0, 40, 1),
(2313, 29, 4, 0, 0, 40, 1),
(2314, 29, 13, 0, 0, 50, 1),
(2315, 29, 5, 0, 0, 50, 1),
(2316, 29, 11, 0, 0, 50, 1),
(2317, 29, 6, 0, 0, 60, 1),
(2318, 29, 29, 0, 2317, 10, 1),
(2319, 29, 14, 0, 0, 60, 1),
(2332, 29, 21, 0, 0, 80, 1),
(2306, 29, 2, 0, 0, 20, 1),
(2382, 30, 13, 0, 0, 50, 1),
(2383, 30, 14, 0, 0, 60, 1),
(2385, 30, 28, 0, 0, 20, 1),
(2386, 30, 3, 0, 0, 30, 0),
(2387, 30, 25, 0, 0, 40, 1),
(2388, 30, 4, 0, 0, 40, 1),
(2390, 30, 11, 0, 0, 50, 1),
(2391, 30, 6, 0, 0, 60, 1),
(2392, 30, 7, 0, 0, 70, 1),
(2393, 30, 24, 0, 0, 70, 1),
(2394, 30, 8, 0, 0, 80, 1),
(2381, 30, 26, 0, 0, 40, 1),
(2380, 30, 27, 0, 0, 30, 1),
(2343, 30, 9, 0, 2342, 10, 1),
(2342, 30, 2, 0, 0, 20, 1),
(2341, 30, 9, 0, 0, 10, 1),
(2340, 30, 17, 17, 2333, 70, 1),
(2339, 30, 14, 0, 2333, 60, 1),
(2338, 30, 13, 0, 2333, 50, 1),
(2336, 30, 27, 0, 2333, 30, 1),
(2335, 30, 31, 0, 2333, 20, 1),
(2334, 30, 15, 0, 2333, 10, 1),
(2333, 30, 1, 0, 0, 10, 1),
(2379, 30, 31, 0, 0, 20, 1),
(2398, 30, 25, 0, 2394, 40, 1),
(2399, 30, 11, 0, 2394, 50, 1),
(2378, 30, 15, 0, 0, 10, 1),
(2389, 30, 5, 0, 0, 50, 1),
(2337, 30, 26, 0, 2333, 40, 1),
(2403, 30, 21, 0, 0, 80, 1),
(2402, 30, 21, 0, 2394, 80, 1),
(2401, 30, 24, 0, 2394, 70, 1),
(2415, 31, 8, 0, 0, 80, 1),
(2414, 31, 7, 0, 0, 70, 0),
(2413, 31, 33, 0, 2412, 10, 1),
(2411, 31, 5, 0, 0, 50, 0),
(2412, 31, 6, 0, 0, 60, 1),
(2410, 31, 32, 0, 0, 40, 1),
(2409, 31, 4, 0, 0, 40, 0),
(2404, 31, 1, 0, 0, 10, 1),
(2405, 31, 32, 0, 2404, 40, 1),
(2406, 31, 33, 0, 0, 10, 1),
(2407, 31, 2, 0, 0, 20, 0),
(2408, 31, 3, 0, 0, 30, 0),
(2423, 32, 8, 0, 0, 80, 1),
(2422, 32, 7, 0, 0, 70, 0),
(2421, 32, 6, 0, 0, 60, 1),
(2419, 32, 4, 0, 0, 40, 0),
(2418, 32, 3, 0, 0, 30, 0),
(2417, 32, 2, 0, 0, 20, 0),
(2416, 32, 1, 0, 0, 10, 1),
(2420, 32, 5, 0, 0, 50, 0);


--
-- Dumping data for table `custom_blocks`
--
INSERT INTO `ac_custom_blocks`
(`custom_block_id`,
`block_id`,
`date_added`,
`date_modified`)
VALUES
(17,17,NOW(),NOW()),
(18,17,NOW(),NOW()),
(19,17,NOW(),NOW()),
(20,17,NOW(),NOW()),
(21,17,NOW(),NOW()),
(22,17,NOW(),NOW()),
(23,23,NOW(),NOW()),
(24,20,NOW(),NOW())
;

--
-- Dumping data for table `block_descriptions`
--
INSERT INTO `ac_block_descriptions`
(`block_description_id`, `custom_block_id`, `language_id`, `block_wrapper`, `block_framed`, `name`, `title`, `description`,
`content`)
VALUES
(38, 24, 1, 'blocks/listing_block/popular_brands_content_bottom.tpl', 0, 'Brands Scrolling List', 'Brands Scrolling List', '', 'a:1:{s:18:""listing_datasource"";s:20:""custom_manufacturers"";}'),
(32, 18, 1, 'blocks/html_block_footer.tpl', 1, 'About Us', 'About Us', '', '&lt;p class=&quot;small lh-lg&quot;&gt;AbanteCart is a free eCommerce solution for merchants to provide ability creating online business and sell products or services online. AbanteCart application is built and supported by experienced enthusiasts that are passionate about their work and contribution to rapidly evolving eCommerce industry. AbanteCart is more than just a shopping cart, it is rapidly growing eCommerce platform with many benefits.&lt;/p&gt;'),
(33, 19, 1, 'blocks/html_block_footer.tpl', 1, 'Contact us', 'Contact Us', '', '&lt;ul class=&quot;list-unstyled contact small&quot;&gt;   &lt;li class=&quot;mb-2&quot;&gt;&lt;i class=&quot;fa-solid fa-phone&quot;&gt;&lt;/i&gt;&lt;/i&gt; 123 456 7890,  123 456 7890&lt;/li&gt;    &lt;li class=&quot;mb-2&quot;&gt;&lt;i class=&quot;fa-solid fa-mobile-screen&quot;&gt;&lt;/i&gt;&lt;a class=&quot;text-decoration-none&quot;  href=&quot;tel:123 456 7890&quot;&gt; 123 456 7890&lt;/a&gt;,  123 456 78900&lt;/li&gt;    &lt;li class=&quot;mb-2&quot;&gt;&lt;i class=&quot;fa-solid fa-at&quot;&gt;&lt;/i&gt; help at abantecart.com&lt;/li&gt;&lt;/ul&gt;'),
(35, 21, 1, '0', 0, 'Main Page Carousel', 'Main Page Carousel', '', '&lt;div id=&quot;mainPageSliderIndicators&quot; class=&quot;carousel carousel-dark slide bg-light&quot; data-bs-ride=&quot;carousel&quot;&gt;  &lt;div class=&quot;carousel-indicators&quot;&gt;  &lt;button type=&quot;button&quot; data-bs-target=&quot;#mainPageSliderIndicators&quot; data-bs-slide-to=&quot;0&quot; class=&quot;active&quot;  aria-current=&quot;true&quot; aria-label=&quot;Slide 1&quot;&gt;&lt;/button&gt;  &lt;button type=&quot;button&quot; data-bs-target=&quot;#mainPageSliderIndicators&quot; data-bs-slide-to=&quot;1&quot;  aria-label=&quot;Slide 2&quot;&gt;&lt;/button&gt;  &lt;button type=&quot;button&quot; data-bs-target=&quot;#mainPageSliderIndicators&quot; data-bs-slide-to=&quot;2&quot;  aria-label=&quot;Slide 3&quot;&gt;&lt;/button&gt;  &lt;button type=&quot;button&quot; data-bs-target=&quot;#mainPageSliderIndicators&quot; data-bs-slide-to=&quot;3&quot;  aria-label=&quot;Slide 4&quot;&gt;&lt;/button&gt;  &lt;/div&gt;  &lt;div class=&quot;carousel-inner&quot;&gt;  &lt;div class=&quot;carousel-item banner active&quot;&gt;  &lt;div class=&quot;d-flex flex-wrap flex-sm-nowrap justify-content-center align-items-center&quot;&gt;  &lt;div class=&quot;flex-item &quot;&gt;  &lt;img class=&quot;my-auto w-100&quot; src=&quot;image/Slide_600x300.jpeg&quot;&gt;  &lt;/div&gt;  &lt;div class=&quot;flex-item col-9 col-sm-3 m-5&quot;&gt;  &lt;h5&gt;HTML5 Responsive Storefront to look great on&lt;/h5&gt;  &lt;h5&gt;ALL Screen Sizes&lt;/h5&gt;  &lt;p&gt;Natively responsive template implemented with bootstrap library and HTML5. Will look good on most  mobile devices and tablets.&lt;/p&gt;  &lt;h3&gt;&lt;a href=&quot;#&quot; class=&quot;&quot;&gt; Try on your device!&lt;/a&gt;&lt;/h3&gt;  &lt;/div&gt;  &lt;/div&gt;  &lt;/div&gt;  &lt;div class=&quot;carousel-item banner&quot;&gt;  &lt;div class=&quot;d-flex flex-wrap flex-sm-nowrap justify-content-center align-items-center&quot;&gt;  &lt;div class=&quot;flex-item &quot;&gt;  &lt;img class=&quot;my-auto w-100&quot; src=&quot;image/Slide_600x300.jpeg&quot;&gt;  &lt;/div&gt;  &lt;div class=&quot;flex-item col-9 col-sm-3  m-5&quot;&gt;  &lt;h5&gt;Highly flexible layout on any page&lt;/h5&gt;  &lt;h5&gt;SEO Friendly&lt;/h5&gt;  &lt;p&gt;Fast Loading&lt;/p&gt;  &lt;h3&gt;&lt;a href=&quot;#&quot; class=&quot;&quot;&gt; Try Now!&lt;/a&gt;&lt;/h3&gt;  &lt;/div&gt;  &lt;/div&gt;  &lt;/div&gt;  &lt;div class=&quot;carousel-item banner&quot;&gt;  &lt;div class=&quot;d-flex flex-wrap flex-sm-nowrap justify-content-center align-items-center&quot;&gt;  &lt;div class=&quot;flex-item &quot;&gt;  &lt;img class=&quot;my-auto w-100&quot; src=&quot;image/Slide_600x300.jpeg&quot;&gt;  &lt;/div&gt;  &lt;div class=&quot;flex-item col-9 col-sm-3  m-5&quot;&gt;  &lt;h5&gt;Feature rich with smart UI&lt;/h5&gt;  &lt;h5&gt;Easy &amp;amp; fun to manage&lt;/h5&gt;  &lt;p&gt;Feature reach shopping cart application right out of the box. Standard features allow to set up  complete eCommerce site with all the tools needed to sell products online.&lt;/p&gt;  &lt;h3&gt;&lt;a href=&quot;#&quot; class=&quot;&quot;&gt;Install Now!&lt;/a&gt;&lt;/h3&gt;  &lt;/div&gt;  &lt;/div&gt;  &lt;/div&gt;  &lt;div class=&quot;carousel-item banner&quot;&gt;  &lt;div class=&quot;d-flex flex-wrap flex-sm-nowrap justify-content-center align-items-center&quot;&gt;  &lt;div class=&quot;flex-item &quot;&gt;  &lt;img class=&quot;my-auto w-100&quot; src=&quot;image/Slide_600x300.jpeg&quot;&gt;  &lt;/div&gt;  &lt;div class=&quot;flex-item col-9 col-sm-3  m-5&quot;&gt;  &lt;h5&gt;Stay in control&lt;/h5&gt;  &lt;h5&gt;Easy updates&lt;/h5&gt;  &lt;p&gt;Upgrade right from admin. Backward supportability in upgrades and automatic backups. Easy  extension download with one step installation.&lt;/p&gt;  &lt;h3&gt;&lt;a href=&quot;#&quot; class=&quot;&quot;&gt;Get Yours!&lt;/a&gt;&lt;/h3&gt;  &lt;/div&gt;  &lt;/div&gt;  &lt;/div&gt;  &lt;/div&gt;  &lt;button class=&quot;carousel-control-prev&quot; type=&quot;button&quot; data-bs-target=&quot;#mainPageSliderIndicators&quot; data-bs-slide=&quot;prev&quot;&gt;  &lt;span class=&quot;carousel-control-prev-icon&quot; aria-hidden=&quot;true&quot;&gt;&lt;/span&gt;  &lt;span class=&quot;visually-hidden&quot;&gt;Previous&lt;/span&gt;  &lt;/button&gt;  &lt;button class=&quot;carousel-control-next&quot; type=&quot;button&quot; data-bs-target=&quot;#mainPageSliderIndicators&quot; data-bs-slide=&quot;next&quot;&gt;  &lt;span class=&quot;carousel-control-next-icon&quot; aria-hidden=&quot;true&quot;&gt;&lt;/span&gt;  &lt;span class=&quot;visually-hidden&quot;&gt;Next&lt;/span&gt; &lt;/button&gt; &lt;/div&gt;'),
(36, 22, 1, '0', 0, 'Main Page Promo', 'Promo', '', '&lt;section class=&quot;d-flex flex-wrap justify-content-evenly border m-3&quot;&gt;	&lt;div class=&quot;d-flex flex-item align-items-center&quot;&gt;		&lt;div class=&quot;promo_icon fs-1 m-3&quot;&gt;&lt;i class=&quot;fa-solid fa-2xl fa-truck fs-1&quot;&gt;&lt;/i&gt;&lt;/div&gt;&lt;div class=&quot;promo_text&quot;&gt;&lt;h2&gt;Free shipping&lt;/h2&gt;All over in world over $200&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;d-flex flex-item align-items-center&quot;&gt;&lt;div class=&quot;promo_icon fs-1 m-3&quot;&gt;&lt;i class=&quot;fa-solid fa-2xl fa-money-bill-1 fs-1&quot;&gt;&lt;/i&gt;&lt;/div&gt;		&lt;div class=&quot;promo_text&quot;&gt;&lt;h2&gt;Easy Payment&lt;/h2&gt;Payment Gateway support&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;d-flex flex-item align-items-center&quot;&gt;		&lt;div class=&quot;promo_icon fs-1 m-3&quot;&gt;&lt;i class=&quot;fa-solid fa-2xl fa-clock fs-1&quot;&gt;&lt;/i&gt;&lt;/div&gt;&lt;div class=&quot;promo_text&quot;&gt;&lt;h2&gt;24hrs Shipping&lt;/h2&gt;For All US States&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;d-flex flex-item align-items-center&quot;&gt;&lt;div class=&quot;promo_icon fs-1 m-3&quot;&gt;&lt;i class=&quot;fa-solid fa-2xl fa-tags fs-1&quot;&gt;&lt;/i&gt;&lt;/div&gt;		&lt;div class=&quot;promo_text&quot;&gt;&lt;h2&gt;Large Variety&lt;/h2&gt;50,000  Products&lt;/div&gt;&lt;/div&gt;&lt;/section&gt;'),
(31, 17, 1, '0', 0, 'Social Icons', 'social_icons', '', '&lt;div class=&quot;social_icons nav navbar&quot;&gt; &lt;a class=&quot;nav-link m-3&quot; href=&quot;http://www.facebook.com/AbanteCart&quot; target=&quot;_blank&quot; title=&quot;Facebook&quot; &gt;&lt;i class=&quot; fa-brands fa-facebook fa-xl&quot; &gt;&lt;/i&gt;&lt;/a&gt;        &lt;a class=&quot;nav-link m-3&quot; href=&quot;https://twitter.com/abantecart&quot; target=&quot;_blank&quot; title=&quot;Twitter&quot;&gt;&lt;i class=&quot; fa-brands fa-twitter fa-xl&quot; &gt;&lt;/i&gt;&lt;/a&gt;        &lt;a class=&quot;nav-link m-3&quot;  href=&quot;#&quot; title=&quot;Linkedin&quot; &gt;&lt;i class=&quot;fa-brands fa-linkedin fa-xl&quot;&gt;&lt;/i&gt;&lt;/a&gt;        &lt;a class=&quot;nav-link m-3&quot;  href=&quot;#&quot; title=&quot;rss&quot; &gt;&lt;i class=&quot;fa-solid fa-square-rss fa-xl&quot;&gt;&lt;/i&gt;&lt;/a&gt;        &lt;a class=&quot;nav-link m-3&quot;  href=&quot;#&quot; target=&quot;_blank&quot; title=&quot;Skype&quot; &gt;&lt;i class=&quot;fa-brands fa-skype fa-xl&quot;&gt;&lt;/i&gt;&lt;/a&gt;        &lt;a class=&quot;nav-link m-3&quot;  href=&quot;#&quot; target=&quot;_blank&quot; title=&quot;Flickr&quot;&gt;&lt;i class=&quot;fa-brands fa-flickr fa-xl&quot;&gt;&lt;/i&gt;&lt;/a&gt;      &lt;/div&gt;'),
(34, 20, 1, '0', 1, 'Testimonials', 'Testimonials', '', '&lt;div id=&quot;testimonial_sidebar&quot; class=&quot;carousel carousel-dark slide&quot; data-bs-ride=&quot;carousel&quot;&gt; &lt;div class=&quot;carousel-inner&quot;&gt;                   &lt;div class=&quot;carousel-item active&quot;&gt;                        &lt;div class=&quot;align-self-stretch small lh-lg&quot;&gt;                        &quot; I was working with many shopping carts, free and hosted for my clients. There is always something missing. In AbanteCart I find this gap to be much less. Interface is very easy to use and support is very responsive. This is considering its is free. Go AbanteCart go!&quot;&lt;br /&gt;                                    &lt;span class=&quot;pull-left orange&quot;&gt;By : TopShop on reviewcentre.com&lt;/span&gt;                        &lt;/div&gt;                    &lt;/div&gt;                    &lt;div class=&quot;carousel-item&quot;&gt;                        &lt;div class=&quot;align-self-stretch small lh-lg&quot;&gt;                        &quot; Without a doubt the best cart I have used. The title says it all - AbanteCart is undoubtedly the best I have used. I\'m not an expert in site setup, so something this great looking and easy to use is absolutely perfect ... &quot;&lt;br /&gt;                                    &lt;span class=&quot;pull-left orange&quot;&gt;By : johnstenson80 on venturebeat.com&lt;/span&gt;                        &lt;/div&gt;                    &lt;/div&gt;                    &lt;div class=&quot;carousel-item&quot;&gt;                        &lt;div class=&quot;align-self-stretch small lh-lg&quot;&gt;                        &quot; Will not regret using this cart. All good is already mentioned, I want to add my experience with support. My problems with some configuration were resolved quick. Faster than paid shopping cart we had before.&quot;&lt;br /&gt;                                    &lt;span class=&quot;pull-left orange&quot;&gt;By : shopper23 at bestshoppingcartreviews.com&lt;/span&gt;                        &lt;/div&gt;                    &lt;/div&gt;                    &lt;div class=&quot;carousel-item&quot;&gt;                        &lt;div class=&quot;align-self-stretch small lh-lg&quot;&gt;                        &quot; Love the cart. I installed it a while back and use it since when. Some features a hidden, but fun to discover them.&quot;&lt;br /&gt;                                    &lt;span class=&quot;pull-left orange&quot;&gt;By : Liz Wattkins at shopping-cart-reviews.com&lt;/span&gt;                        &lt;/div&gt;                    &lt;/div&gt;                &lt;/div&gt;            &lt;/div&gt;'),
(3, 3, 1, '0', 1, 'Custom Listing block', 'Popular', '', 'a:2:{s:18:"listing_datasource";s:34:"catalog_product_getPopularProducts";s:5:"limit";s:2:"12";}'),
(1, 1, 1, '0', 0, 'home page static banner', 'home page banner', '', '&lt;div style=&quot;text-align: center;&quot;&gt;&lt;a href=&quot;index.php?rt=product/special&quot;&gt; &lt;img alt=&quot;banner&quot; src=&quot;storefront/view/default/image/banner1.jpg&quot; /&gt; &lt;/a&gt;&lt;/div&gt;'),
(37, 23, 1, '0', 0, 'Main Page Banner Bottom', 'Bottom Banners', '', 'a:1:{s:17:""banner_group_name"";s:19:""Main bottom banners"";}'),
(16, 9, 1, 'blocks/banner_block/one_by_one_slider_banner_block.tpl', 0, 'Main Page Banner Slider', 'Main Page Banner Slider', '', 'a:1:{s:17:"banner_group_name";s:17:"Main Page Banners";}'),
(18, 10, 1, '0', 0, 'Main Page Promo', 'Promo', '', '	&lt;section class=&quot;row promo_section&quot;&gt;	&lt;div class=&quot;col-md-3 col-xs-6 promo_block&quot;&gt;		&lt;div class=&quot;promo_icon&quot;&gt;&lt;i class=&quot;fa fa-truck fa-fw&quot;&gt;&lt;/i&gt;&lt;/div&gt;		&lt;div class=&quot;promo_text&quot;&gt;			&lt;h2&gt;				Free shipping&lt;/h2&gt;			All over in world over $200		&lt;/div&gt;	&lt;/div&gt;	&lt;div class=&quot;col-md-3 col-xs-6 promo_block&quot;&gt;		&lt;div class=&quot;promo_icon&quot;&gt;&lt;i class=&quot;fa fa-money fa-fw&quot;&gt;&lt;/i&gt;&lt;/div&gt;		&lt;div class=&quot;promo_text&quot;&gt;			&lt;h2&gt;				Easy Payment&lt;/h2&gt;			Payment Gateway support&lt;/div&gt;	&lt;/div&gt;	&lt;div class=&quot;col-md-3 col-xs-6 promo_block&quot;&gt;		&lt;div class=&quot;promo_icon&quot;&gt;&lt;i class=&quot;fa fa-clock-o fa-fw&quot;&gt;&lt;/i&gt;&lt;/div&gt;		&lt;div class=&quot;promo_text&quot;&gt;			&lt;h2&gt;				24hrs Shipping&lt;/h2&gt;			For All US States&lt;/div&gt;	&lt;/div&gt;	&lt;div class=&quot;col-md-3 col-xs-6 promo_block&quot;&gt;		&lt;div class=&quot;promo_icon&quot;&gt;&lt;i class=&quot;fa fa-tags fa-fw&quot;&gt;&lt;/i&gt;&lt;/div&gt;		&lt;div class=&quot;promo_text&quot;&gt;			&lt;h2&gt;				Large Variety&lt;/h2&gt;			50,000+ Products&lt;/div&gt;	&lt;/div&gt;	&lt;/section&gt;'),
(2, 2, 1, '0', 0, 'Video block', 'Video', '', 'a:3:{s:18:"listing_datasource";s:5:"media";s:13:"resource_type";s:5:"video";s:5:"limit";s:1:"1";}')
;