<?php
/**
 * PushToImageRepositoryRequest
 *
 * PHP version 5
 *
 * @category Class
 * @package  UPS\Paperless
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Paperless Document
 *
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * 
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 3.0.50
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace UPS\Paperless\Paperless;

use \ArrayAccess;
use \UPS\Paperless\ObjectSerializer;

/**
 * PushToImageRepositoryRequest Class Doc Comment
 *
 * @category Class
 * @description Paperless Document API request container for push to Image Repository.
 * @package  UPS\Paperless
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class PushToImageRepositoryRequest implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'PushToImageRepositoryRequest';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'request' => '\UPS\Paperless\Paperless\PushToImageRepositoryRequestRequest',
        'shipper_number' => 'string',
        'forms_history_document_id' => '\UPS\Paperless\Paperless\PushToImageRepositoryRequestFormsHistoryDocumentID',
        'forms_group_id' => 'string',
        'shipment_identifier' => 'string',
        'shipment_date_and_time' => 'string',
        'shipment_type' => 'string',
        'prq_confirmation_number' => 'string',
        'tracking_number' => 'string[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'request' => null,
        'shipper_number' => null,
        'forms_history_document_id' => null,
        'forms_group_id' => null,
        'shipment_identifier' => null,
        'shipment_date_and_time' => null,
        'shipment_type' => null,
        'prq_confirmation_number' => null,
        'tracking_number' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'request' => 'Request',
        'shipper_number' => 'ShipperNumber',
        'forms_history_document_id' => 'FormsHistoryDocumentID',
        'forms_group_id' => 'FormsGroupID',
        'shipment_identifier' => 'ShipmentIdentifier',
        'shipment_date_and_time' => 'ShipmentDateAndTime',
        'shipment_type' => 'ShipmentType',
        'prq_confirmation_number' => 'PRQConfirmationNumber',
        'tracking_number' => 'TrackingNumber'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'request' => 'setRequest',
        'shipper_number' => 'setShipperNumber',
        'forms_history_document_id' => 'setFormsHistoryDocumentId',
        'forms_group_id' => 'setFormsGroupId',
        'shipment_identifier' => 'setShipmentIdentifier',
        'shipment_date_and_time' => 'setShipmentDateAndTime',
        'shipment_type' => 'setShipmentType',
        'prq_confirmation_number' => 'setPrqConfirmationNumber',
        'tracking_number' => 'setTrackingNumber'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'request' => 'getRequest',
        'shipper_number' => 'getShipperNumber',
        'forms_history_document_id' => 'getFormsHistoryDocumentId',
        'forms_group_id' => 'getFormsGroupId',
        'shipment_identifier' => 'getShipmentIdentifier',
        'shipment_date_and_time' => 'getShipmentDateAndTime',
        'shipment_type' => 'getShipmentType',
        'prq_confirmation_number' => 'getPrqConfirmationNumber',
        'tracking_number' => 'getTrackingNumber'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }



    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['request'] = isset($data['request']) ? $data['request'] : null;
        $this->container['shipper_number'] = isset($data['shipper_number']) ? $data['shipper_number'] : null;
        $this->container['forms_history_document_id'] = isset($data['forms_history_document_id']) ? $data['forms_history_document_id'] : null;
        $this->container['forms_group_id'] = isset($data['forms_group_id']) ? $data['forms_group_id'] : null;
        $this->container['shipment_identifier'] = isset($data['shipment_identifier']) ? $data['shipment_identifier'] : null;
        $this->container['shipment_date_and_time'] = isset($data['shipment_date_and_time']) ? $data['shipment_date_and_time'] : null;
        $this->container['shipment_type'] = isset($data['shipment_type']) ? $data['shipment_type'] : null;
        $this->container['prq_confirmation_number'] = isset($data['prq_confirmation_number']) ? $data['prq_confirmation_number'] : null;
        $this->container['tracking_number'] = isset($data['tracking_number']) ? $data['tracking_number'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['request'] === null) {
            $invalidProperties[] = "'request' can't be null";
        }
        if ($this->container['shipper_number'] === null) {
            $invalidProperties[] = "'shipper_number' can't be null";
        }
        if ($this->container['forms_history_document_id'] === null) {
            $invalidProperties[] = "'forms_history_document_id' can't be null";
        }
        if ($this->container['shipment_identifier'] === null) {
            $invalidProperties[] = "'shipment_identifier' can't be null";
        }
        if ($this->container['shipment_type'] === null) {
            $invalidProperties[] = "'shipment_type' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets request
     *
     * @return \UPS\Paperless\Paperless\PushToImageRepositoryRequestRequest
     */
    public function getRequest()
    {
        return $this->container['request'];
    }

    /**
     * Sets request
     *
     * @param \UPS\Paperless\Paperless\PushToImageRepositoryRequestRequest $request request
     *
     * @return $this
     */
    public function setRequest($request)
    {
        $this->container['request'] = $request;

        return $this;
    }

    /**
     * Gets shipper_number
     *
     * @return string
     */
    public function getShipperNumber()
    {
        return $this->container['shipper_number'];
    }

    /**
     * Sets shipper_number
     *
     * @param string $shipper_number The Shipper's UPS Account Number.  Your UPS Account Number must have 'Upload Forms Created Offline' enabled to use this webservice.
     *
     * @return $this
     */
    public function setShipperNumber($shipper_number)
    {
        $this->container['shipper_number'] = $shipper_number;

        return $this;
    }

    /**
     * Gets forms_history_document_id
     *
     * @return \UPS\Paperless\Paperless\PushToImageRepositoryRequestFormsHistoryDocumentID
     */
    public function getFormsHistoryDocumentId()
    {
        return $this->container['forms_history_document_id'];
    }

    /**
     * Sets forms_history_document_id
     *
     * @param \UPS\Paperless\Paperless\PushToImageRepositoryRequestFormsHistoryDocumentID $forms_history_document_id forms_history_document_id
     *
     * @return $this
     */
    public function setFormsHistoryDocumentId($forms_history_document_id)
    {
        $this->container['forms_history_document_id'] = $forms_history_document_id;

        return $this;
    }

    /**
     * Gets forms_group_id
     *
     * @return string
     */
    public function getFormsGroupId()
    {
        return $this->container['forms_group_id'];
    }

    /**
     * Sets forms_group_id
     *
     * @param string $forms_group_id FormsGroupID would be required in Push Request if user needs to update uploaded DocumentID(s) in Forms History.
     *
     * @return $this
     */
    public function setFormsGroupId($forms_group_id)
    {
        $this->container['forms_group_id'] = $forms_group_id;

        return $this;
    }

    /**
     * Gets shipment_identifier
     *
     * @return string
     */
    public function getShipmentIdentifier()
    {
        return $this->container['shipment_identifier'];
    }

    /**
     * Sets shipment_identifier
     *
     * @param string $shipment_identifier Shipment Identifier is required for this request.
     *
     * @return $this
     */
    public function setShipmentIdentifier($shipment_identifier)
    {
        $this->container['shipment_identifier'] = $shipment_identifier;

        return $this;
    }

    /**
     * Gets shipment_date_and_time
     *
     * @return string
     */
    public function getShipmentDateAndTime()
    {
        return $this->container['shipment_date_and_time'];
    }

    /**
     * Sets shipment_date_and_time
     *
     * @param string $shipment_date_and_time The date and time of the processed shipment. Required only for small package shipments. The valid format is yyyy-MM-dd-HH.mm.ss
     *
     * @return $this
     */
    public function setShipmentDateAndTime($shipment_date_and_time)
    {
        $this->container['shipment_date_and_time'] = $shipment_date_and_time;

        return $this;
    }

    /**
     * Gets shipment_type
     *
     * @return string
     */
    public function getShipmentType()
    {
        return $this->container['shipment_type'];
    }

    /**
     * Sets shipment_type
     *
     * @param string $shipment_type Valid values are: 1 = small package, 2 = freight.
     *
     * @return $this
     */
    public function setShipmentType($shipment_type)
    {
        $this->container['shipment_type'] = $shipment_type;

        return $this;
    }

    /**
     * Gets prq_confirmation_number
     *
     * @return string
     */
    public function getPrqConfirmationNumber()
    {
        return $this->container['prq_confirmation_number'];
    }

    /**
     * Sets prq_confirmation_number
     *
     * @param string $prq_confirmation_number PRQ Confirmation being specified by client. Required for freight shipments.
     *
     * @return $this
     */
    public function setPrqConfirmationNumber($prq_confirmation_number)
    {
        $this->container['prq_confirmation_number'] = $prq_confirmation_number;

        return $this;
    }

    /**
     * Gets tracking_number
     *
     * @return string[]
     */
    public function getTrackingNumber()
    {
        return $this->container['tracking_number'];
    }

    /**
     * Sets tracking_number
     *
     * @param string[] $tracking_number UPS Tracking Number associated with this shipment. Required only for small package shipment.
     *
     * @return $this
     */
    public function setTrackingNumber($tracking_number)
    {
        $this->container['tracking_number'] = $tracking_number;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}
