# AddressValidation
No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)

This PHP package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 
- Package version: 1.0.8
- Build package: io.swagger.codegen.v3.generators.php.PhpClientCodegen

## Requirements

PHP 5.5 and later

## Installation & Usage
### Composer

To install the bindings via [Composer](http://getcomposer.org/), add the following to `composer.json`:

```
{
  "repositories": [
    {
      "type": "git",
      "url": "https://github.com/abantecart/ups-address-validation.git"
    }
  ],
  "require": {
    "abantecart/ups-address-validation": "*@dev"
  }
}
```

Then run `composer install`

### Manual Installation

Download the files and include `autoload.php`:

```php
    require_once('/path/to/AddressValidation/vendor/autoload.php');
```

## Tests

To run the unit tests:

```
composer install
./vendor/bin/phpunit
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2
$config = UPS\AddressValidation\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$apiInstance = new UPS\AddressValidation\Request\DefaultApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$body = new \UPS\AddressValidation\AddressValidation\XAVRequestWrapper(); // \UPS\AddressValidation\AddressValidation\XAVRequestWrapper | Generate sample code for popular API requests by selecting an example below. To view a full sample request and response, first click "Authorize" and enter your application credentials, then populate the required parameters above and click "Try it out".
$requestoption = 56; // int | Identifies the optional processing to be performed. If not present or invalid value then an error will be sent back.  Valid values: - 1 - Address Validation - 2 - Address Classification - 3 - Address Validation and Address Classification.  For a list of valid values, refer to Address Validation API Supported Countries or Territories in the Appendix.
$version = "version_example"; // string | Identifies the version of the API.  Valid  values: - v2
$regionalrequestindicator = "regionalrequestindicator_example"; // string | Valid values: True or False.  If True, either the region element or any  combination of Political Division 1,  Political Division 2, PostcodePrimaryLow and the PostcodeExtendedLow fields will  be recognized for validation in addition to  the urbanization element. If False or no  indicator, street level address validation  is provided
$maximumcandidatelistsize = 56; // int | Valid values: 0 – 50 The maximum number of Candidates to  return for this request. If not provided,  the default size of 15 is returned.

try {
    $result = $apiInstance->addressValidation($body, $requestoption, $version, $regionalrequestindicator, $maximumcandidatelistsize);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling DefaultApi->addressValidation: ', $e->getMessage(), PHP_EOL;
}

// Configure OAuth2 access token for authorization: oauth2
$config = UPS\AddressValidation\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$apiInstance = new UPS\AddressValidation\Request\DefaultApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$body = new \UPS\AddressValidation\AddressValidation\XAVRequestWrapper(); // \UPS\AddressValidation\AddressValidation\XAVRequestWrapper | Generate sample code for popular API requests by selecting an example below. To view a full sample request and response, first click "Authorize" and enter your application credentials, then populate the required parameters above and click "Try it out".
$requestoption = 56; // int | Identifies the optional processing to be performed. If not present or invalid value then an error will be sent back.  Valid values:  - 1 - Address Validation - 2 - Address Classification - 3 - Address Validation and Address Classification.  For a list of valid values, refer to Address Validation API Supported Countries or Territories in the Appendix.
$deprecated_version = "deprecated_version_example"; // string | Identifies the version of the API.  Valid  values: - v1
$regionalrequestindicator = "regionalrequestindicator_example"; // string | Valid values: True or False.  If True, either the region element or any  combination of Political Division 1,  Political Division 2, PostcodePrimaryLow and the PostcodeExtendedLow fields will  be recognized for validation in addition to  the urbanization element. If False or no  indicator, street level address validation  is provided
$maximumcandidatelistsize = 56; // int | Valid values: 0 – 50 The maximum number of Candidates to  return for this request. If not provided,  the default size of 15 is returned.

try {
    $result = $apiInstance->deprecatedAddressValidation($body, $requestoption, $deprecated_version, $regionalrequestindicator, $maximumcandidatelistsize);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling DefaultApi->deprecatedAddressValidation: ', $e->getMessage(), PHP_EOL;
}
?>
```

## Documentation for API Endpoints

All URIs are relative to *https://wwwcie.ups.com/api*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DefaultApi* | [**addressValidation**](docs/Api/DefaultApi.md#addressvalidation) | **POST** /addressvalidation/{version}/{requestoption} | Address Validation
*DefaultApi* | [**deprecatedAddressValidation**](docs/Api/DefaultApi.md#deprecatedaddressvalidation) | **POST** /addressvalidation/{deprecatedVersion}/{requestoption} | Address Validation

## Documentation For Models

 - [CandidateAddressClassification](docs/Model/CandidateAddressClassification.md)
 - [CandidateAddressKeyFormat](docs/Model/CandidateAddressKeyFormat.md)
 - [CommonErrorResponse](docs/Model/CommonErrorResponse.md)
 - [ErrorMessage](docs/Model/ErrorMessage.md)
 - [ErrorResponse](docs/Model/ErrorResponse.md)
 - [RequestTransactionReference](docs/Model/RequestTransactionReference.md)
 - [ResponseAlert](docs/Model/ResponseAlert.md)
 - [ResponseResponseStatus](docs/Model/ResponseResponseStatus.md)
 - [ResponseTransactionReference](docs/Model/ResponseTransactionReference.md)
 - [XAVRequest](docs/Model/XAVRequest.md)
 - [XAVRequestAddressKeyFormat](docs/Model/XAVRequestAddressKeyFormat.md)
 - [XAVRequestRequest](docs/Model/XAVRequestRequest.md)
 - [XAVRequestWrapper](docs/Model/XAVRequestWrapper.md)
 - [XAVResponse](docs/Model/XAVResponse.md)
 - [XAVResponseAddressClassification](docs/Model/XAVResponseAddressClassification.md)
 - [XAVResponseCandidate](docs/Model/XAVResponseCandidate.md)
 - [XAVResponseResponse](docs/Model/XAVResponseResponse.md)
 - [XAVResponseWrapper](docs/Model/XAVResponseWrapper.md)

## Documentation For Authorization


## oauth2

- **Type**: OAuth
- **Flow**: application
- **Authorization URL**: 
- **Scopes**: 


## Author



