<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2022 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

$this->db->query("Create table if not exists `".DB_PREFIX."sales_state_report_tmp` ( `id` int(2) , `title` VARCHAR(100) )ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;");

$rm = new AResourceManager();
$rm->setType('image');

$language_id = $this->language->getLanguageID();
$data = array();
$data['resource_code'] = '<i class="fa fa-bar-chart-o"></i>&nbsp;';
$data['name'] = array($language_id => 'Menu Icon Sales By State Report');
$data['title'] = array($language_id => '');
$data['description'] = array($language_id => '');
$resource_id = $rm->addResource($data);

$menu = new AMenu ( "admin" );
$menu->insertMenuItem ( array (  "item_id" => "sales_state_report",
        "parent_id" => "",
        "item_text" => "Sales By State Report",
        "item_url" => "sales_state_report/sale_state",
        "item_type" => "core",
        "sort_order" => "15",
        "item_icon_rl_id" => $resource_id
    )
);

$sql1 = "CREATE TABLE IF NOT EXISTS ".$this->db->table("sales_state_report_updater_notification") ."(
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `msg_id` int(11) NOT NULL,
  `cart_version` VARCHAR(10),
  `extension_version` VARCHAR(10),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci";

$this->db->query($sql1);

if (HTTPS===true) {
	$domain = HTTPS_SERVER;
} else {
	$domain = HTTP_SERVER;
}

$message = "This is an email notification to let you know that Sale By State Report extension v 1.3.2 is installed in ".$domain;
$mail = new AMail($this->config);
$mail->setTo('installs@wehearyou2.net');
$mail->setFrom('installs@wehearyou2.net');
$mail->setSubject('Extension installation information');
$mail->setSender('Information');
$mail->setHtml(html_entity_decode($message, ENT_QUOTES, 'UTF-8'));
$mail->send();