<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8" />
<title><?php echo $title; ?></title>
<base href="<?php echo $base; ?>" />
<script type="text/javascript" src="<?php echo $template_dir; ?>javascript/jquery/jquery-1.12.4.min.js"></script>
<script type="text/javascript" src="<?php echo $template_dir; ?>javascript/jquery/jquery-migrate-1.2.1.min.js"></script>
<script type="text/javascript" src="<?php echo $template_dir; ?>javascript/jquery/jquery-ui/jquery-ui-1.10.4.custom.min.js"></script>
<script type="text/javascript" src="<?php echo $template_dir; ?>javascript/bootstrap.min.js"></script>
<script type="text/javascript" src="extensions/editor/admin/view/default/javascript/jquery/dropzone.min.js"></script>
<link rel="stylesheet" type="text/css" href="<?php echo $template_dir; ?>stylesheet/stylesheet.css" />
<link rel="stylesheet" type="text/css" href="extensions/editor/admin/view/default/styles/style.css" />
<link rel="stylesheet" type="text/css" href="extensions/editor/admin/view/default/styles/dropzone.min.css" />
<style>
	body {
		background: none repeat scroll 0 0;
	}
</style>

</head>
<body id="manager">
<div class="panel panel-default">
	<div class="panel-heading">
		<div class="col-sm-5">
		<a href="<?php echo $parent; ?>" data-placement="bottom" data-toggle="tooltip" title="<?php echo $button_parent; ?>" id="button-parent" class="btn btn-default"><i class="fa fa-level-up"></i></a>
		<a href="<?php echo $refresh; ?>" data-toggle="tooltip" data-placement="bottom" title="<?php echo $button_refresh; ?>" id="button-refresh" class="btn btn-default"><i class="fa fa-refresh"></i></a>
		<button type="button" data-toggle="tooltip" data-placement="bottom" title="<?php echo $button_upload; ?>" id="button-upload" class="btn btn-primary"><i class="fa fa-upload"></i></button>
		<button type="button" data-toggle="tooltip" data-placement="bottom" title="<?php echo $button_folder; ?>" id="button-folder" class="btn btn-default"><i class="fa fa-folder"></i></button>
		<button type="button" data-toggle="tooltip" data-placement="bottom" title="<?php echo $button_delete; ?>" id="button-delete" class="btn btn-danger"><i class="fa fa-trash-o"></i></button>
	</div>
		<div class="col-sm-7">
			<div class="input-group">
				<input type="text" name="search" value="<?php echo $filter_name; ?>" placeholder="<?php echo $entry_search; ?>" class="form-control">
            <span class="input-group-btn">
            <button type="button" data-toggle="tooltip" data-placement="bottom" title="<?php echo $button_search; ?>" id="button-search" class="btn btn-primary"><i class="fa fa-search"></i></button>
            </span></div>
		</div>
	</div>
	<div class="panel-body panel-body-nopadding" id="panelBody">
		<div id="main">
		<?php if ($images) { ?>
		<?php foreach (array_chunk($images, 4) as $image) { ?>
		<div class="row">
			<?php foreach ($image as $image) { ?>
			<div class="col-sm-3 text-center">
				<?php if ($image['type'] == 'directory') { ?>
				<div class="text-center"><a href="<?php echo $image['href']; ?>" class="directory" style="vertical-align: middle;"><i class="fa fa-folder fa-5x"></i></a></div>
				<label>
					<input type="checkbox" name="path[]" value="<?php echo $image['path']; ?>" title="Check this if you want to delete this file" data-toggle="tooltip" data-placement="bottom"/>
					<?php echo $image['name']; ?></label>
				<?php } ?>
				<?php if ($image['type'] == 'image') { ?>
				<a href="<?php echo $image['href']; ?>" class="thumbnail"><img src="<?php echo $image['thumb']; ?>" alt="<?php echo $image['name']; ?>" title="<?php echo $image['name']; ?>" /></a>
				<label>
					<input type="checkbox" name="path[]" value="<?php echo $image['path']; ?>"  title="Check this if you want to delete this file" data-toggle="tooltip" data-placement="bottom" />
					<?php echo $image['name']; ?></label>
				<?php } ?>
			</div>
			<?php } ?>
		</div>
		<br />
		<?php } } else { ?>
		<div class="row none">
			There are no files to be shown<br>
			<i class="fa fa-frown-o fa-5x"></i>
		</div>
		<?php } ?>
		</div>
		</div>
        <div class="panel-footer center form-inline pull-right" id="foot">
        <?php echo $pagination; ?>
        </div>
		<div class="panel-body panel-body-nopadding" id="uploader" style="text-align: center;">
			<form id="myDropzone" enctype="multipart/form-data" action="" class="dropzone"></form>
			<br>
			<button type="button" id="cancel" class="btn" ><i class="icon-backward icon-white"></i>Return to files list</button>
		</div>
	</div>
</body>
<script type="text/javascript">
	$('[data-toggle=\'tooltip\']').tooltip({container: 'body', html: true});
	// Makes tooltips work on ajax generated content
	$(document).ajaxStop(function() {
		$('[data-toggle=\'tooltip\']').tooltip({container: 'body'});
	});
	$(document).ready(function(){
		Dropzone.autoDiscover = false;
		$("#myDropzone").dropzone({
			acceptedFiles: ".jpeg,.jpg,.png,.gif,.JPEG,.JPG,.PNG,.GIF",
			url: 'index.php?rt=r/extension/filemanager/upload&token=<?php echo $token;?>&s=<?php echo ADMIN_PATH;?>&directory=<?php echo $directory; ?>',
			maxFilesize: 2.5,
            init: function() {
                this.on("error", function(file,message){
                    alert(message);
                    this.removeFile(file);
                });
            }
		});
	});
</script>
<script type="text/javascript"><!--
	$('a.thumbnail').on('click', function(e) {
		e.preventDefault();
		var windowManager = top != undefined && top.tinymceWindowManager != undefined ? top.tinymceWindowManager : '';
		if (windowManager != '') {
			if (top.tinymceCallBackURL != undefined)
				top.tinymceCallBackURL = $(this).attr('href');
			windowManager.close();
		}
	    //top.tinymce.activeEditor.windowManager.getParams().oninsert($(this).attr('href'));
		//top.tinymce.activeEditor.windowManager.close();
	});

	$('a.directory').on('click', function(e) {
		e.preventDefault();
		$('#manager').load($(this).attr('href'));
	});

	$('.pagination a').on('click', function(e) {
		e.preventDefault();
		$('#manager').load($(this).attr('href'));
	});

	$('#button-parent').on('click', function(e) {
		e.preventDefault();
		$('#manager').load($(this).attr('href'));
	});

	$('#button-refresh').on('click', function(e) {
		e.preventDefault();
		$('#manager').load($(this).attr('href'));
	});

	$('#button-search').on('click', function() {
		var url = 'index.php?rt=r/extension/filemanager&token=<?php echo $token;?>&s=<?php echo ADMIN_PATH;?>&directory=<?php echo $directory; ?>';

		var filter_name = $('input[name=\'search\']').val();

		if (filter_name) {
			url += '&filter_name=' + encodeURIComponent(filter_name);
		}

		$('#manager').load(url);

	});

    $('input[name=\'search\']').keypress(function(event){
        var keycode = (event.keyCode ? event.keyCode : event.which);
        if(keycode == '13'){
            var url = 'index.php?rt=r/extension/filemanager&token=<?php echo $token;?>&s=<?php echo ADMIN_PATH;?>&directory=<?php echo $directory; ?>';

            var filter_name = $('input[name=\'search\']').val();

            if (filter_name) {
                url += '&filter_name=' + encodeURIComponent(filter_name);
            }

            $('#manager').load(url);
        }
    });


	//--></script>
<script type="text/javascript"><!--
$('#cancel').on('click',function(e){
		e.preventDefault();
		$('#uploader').fadeOut("normal", function () {
			$('#panelBody').fadeIn("normal");
            $('#foot').show();
		});
	$('#button-refresh').trigger('click');
	});

	$('#button-upload').on('click', function(e) {
		e.preventDefault();
		$('#panelBody').fadeOut("normal", function () {
			$('#uploader').fadeIn("normal");
            $('#foot').hide();
		});
	});


	$('#button-folder').popover({
		html: true,
		placement: 'bottom',
		trigger: 'click',
		title: '<?php echo $entry_folder; ?>',
		content: function() {
			html  = '<div class="input-group">';
			html += '  <input type="text" name="folder" value="" placeholder="<?php echo $entry_folder; ?>" class="form-control">';
			html += '  <span class="input-group-btn"><button type="button" title="<?php echo $button_folder; ?>" id="button-create" class="btn btn-primary"><i class="fa fa-plus-circle"></i></button></span>';
			html += '</div>';

			return html;
		}
	});

	$('#button-folder').on('shown.bs.popover', function() {
		$('#button-create').on('click', function() {
			$.ajax({
				url: 'index.php?rt=r/extension/filemanager/folder&token=<?php echo $token;?>&s=<?php echo ADMIN_PATH;?>&directory=<?php echo $directory; ?>',
				type: 'post',
				dataType: 'json',
				data: 'folder=' + encodeURIComponent($('input[name=\'folder\']').val()),
				beforeSend: function() {
					$('#button-create').prop('disabled', true);
				},
				complete: function() {
					$('#button-create').prop('disabled', false);
				},
				success: function(json) {
					if (json['error']) {
						alert(json['error']);
					}

					if (json['success']) {
						alert(json['success']);

						$('#button-refresh').trigger('click');
					}
				},
				error: function(xhr, ajaxOptions, thrownError) {
					alert(thrownError + "\r\n" + xhr.statusText + "\r\n" + xhr.responseText);
				}
			});
		});
	});

	$('#manager #button-delete').on('click', function(e) {
		if (!$('input[name^=\'path\']').is(':checked')) {
         alert('<?php echo $error_not_checked; ?>');
		}
		else{
			if (confirm('<?php echo $text_confirm; ?>')) {
				$.ajax({
					url: 'index.php?rt=r/extension/filemanager/delete&token=<?php echo $token;?>&s=<?php echo ADMIN_PATH;?>',
					type: 'post',
					dataType: 'json',
					data: $('input[name^=\'path\']:checked'),
					beforeSend: function() {
						$('#button-delete').prop('disabled', true);
					},
					complete: function() {
						$('#button-delete').prop('disabled', false);
					},
					success: function(json) {
						if (json['error']) {
							alert(json['error']);
						}

						if (json['success']) {
							alert(json['success']);

							$('#button-refresh').trigger('click');
						}
					},
					error: function(xhr, ajaxOptions, thrownError) {
						alert(thrownError + "\r\n" + xhr.statusText + "\r\n" + xhr.responseText);
					}
				});
			}
		}
	});
	//--></script>
</html>