<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2021 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/
if (!defined('DIR_CORE') || !IS_ADMIN) {
	header('Location: static_pages/');
}
include_once DIR_EXT.'editor'.DIR_EXT_CORE.'utf8.php';

class ControllerResponsesExtensionFilemanager extends AController {
	private $error = array();
	public $data = array ();

	public function main() {

		$this->language->load('editor/editor');
		$this->data['title'] = $this->language->get('fileman_heading_title');

		if (isset($this->request->server['HTTPS']) && (($this->request->server['HTTPS'] == 'on') || ($this->request->server['HTTPS'] == '1'))) {
			$this->data['base'] = HTTPS_SERVER;
		} else {
			$this->data['base'] = HTTP_SERVER;
		}

		if (isset($this->request->get['filter_name'])) {
			$filter_name = rtrim(str_replace(array('../', '..\\', '..', '*'), '', $this->request->get['filter_name']), '/');
		} else {
			$filter_name = null;
		}

		// Make sure we have the correct directory
		if (isset($this->request->get['directory'])) {
			$directory = rtrim(DIR_IMAGE . 'data/' . str_replace(array('../', '..\\', '..'), '', $this->request->get['directory']), '/');
		} else {
			$directory = DIR_IMAGE . 'data';
		}

		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

		$this->data['images'] = array();

		$this->load->model('tool/image');

		// Get directories
		$directories = glob($directory . '/*' . $filter_name . '*', GLOB_ONLYDIR);

		if (!$directories) {
			$directories = array();
		}

		// Get files
		$files = glob($directory . '/*' . $filter_name . '*.{jpg,jpeg,png,gif,JPG,JPEG,PNG,GIF}', GLOB_BRACE);

		if (!$files) {
			$files = array();
		}

		// Merge directories and files
		$images = array_merge($directories, $files);
		// Get total number of files and directories
		$image_total = count($files);

		// Split the array based on current page number and max number of items per page of 16
		$images = array_splice($images, ($page - 1) * 16, 16);

		foreach ($images as $image) {
			$name = str_split(basename($image), 30);
			if (is_dir($image)) {
				$url = '';

				$this->data['images'][] = array(
					'thumb' => '',
					'name'  => implode(' ', $name),
					'type'  => 'directory',
					'path'  => utf8_substr($image, utf8_strlen(DIR_IMAGE)),
					'href'  => 'index.php?rt=r/extension/filemanager&token='. $this->session->data["token"].'&s='.ADMIN_PATH.'&directory=' . urlencode(utf8_substr($image, utf8_strlen(DIR_IMAGE . 'data/')))
				);
		} elseif (is_file($image)) {
				// Find which protocol to use to pass the full image link back
				if ($this->request->server['HTTPS']) {
					$server = HTTPS_CATALOG;
				} else {
					$server = HTTP_CATALOG;
				}
				$this->data['images'][] = array(
					'thumb' => $this->model_tool_image->resize(utf8_substr($image, utf8_strlen(DIR_IMAGE)), 100, 100),
					'name'  => implode(' ', $name),
					'type'  => 'image',
					'path'  => utf8_substr($image, utf8_strlen(DIR_IMAGE)),
					'href'  => $server . 'image/' . utf8_substr($image, utf8_strlen(DIR_IMAGE))
				);
			}
		}

		$this->data['text_no_results'] = $this->language->get('text_no_results');
		$this->data['text_confirm'] = $this->language->get('text_confirm');

		$this->data['entry_search'] = $this->language->get('entry_search');
		$this->data['entry_folder'] = $this->language->get('entry_folder');

		$this->data['button_parent'] = $this->language->get('button_parent');
		$this->data['button_refresh'] = $this->language->get('button_refresh');
		$this->data['button_upload'] = $this->language->get('button_upload');
		$this->data['button_folder'] = $this->language->get('button_folder');
		$this->data['button_delete'] = $this->language->get('button_delete');
		$this->data['button_search'] = $this->language->get('button_search');

		$this->data['error_select'] = $this->language->get('error_select');
		$this->data['error_directory'] = $this->language->get('error_directory');
		$this->data['error_not_checked'] = $this->language->get('error_not_checked');

		$this->data['token'] = $this->session->data['token'];

		if (isset($this->request->get['directory'])) {
			$this->data['directory'] = urlencode($this->request->get['directory']);
		} else {
			$this->data['directory'] = '';
		}

		if (isset($this->request->get['filter_name'])) {
			$this->data['filter_name'] = $this->request->get['filter_name'];
		} else {
			$this->data['filter_name'] = '';
		}

		// Parent
		$url = '';

		if (isset($this->request->get['directory'])) {
			$pos = strrpos($this->request->get['directory'], '/');

			if ($pos) {
				$url .= '&directory=' . urlencode(substr($this->request->get['directory'], 0, $pos));
			}
		}

		$this->data['parent'] = 'index.php?rt=r/extension/filemanager&token='. $this->session->data["token"].'&s='.ADMIN_PATH.$url;

		// Refresh
		$url = '';

		if (isset($this->request->get['directory'])) {
			$url .= '&directory=' . urlencode($this->request->get['directory']);
		}

		$this->data['refresh'] = 'index.php?rt=r/extension/filemanager&token='. $this->session->data["token"].'&s='.ADMIN_PATH.$url;

		$url = '';

		if (isset($this->request->get['directory'])) {
			$url .= '&directory=' . urlencode(html_entity_decode($this->request->get['directory'], ENT_QUOTES, 'UTF-8'));
		}

		if (isset($this->request->get['filter_name'])) {
			$url .= '&filter_name=' . urlencode(html_entity_decode($this->request->get['filter_name'], ENT_QUOTES, 'UTF-8'));
		}

		$this->data['pagination'] = HtmlElementFactory::create(array(
			'type' => 'Pagination',
			'name' => 'pagination',
			'text' => $this->language->get('text_pagination'),
			'text_limit' => $this->language->get('text_per_page'),
			'total' => $image_total,
			'page' => $page,
			'limit' => 16,
			'url' => 'index.php?rt=r/extension/filemanager&token='. $this->session->data["token"].'&s='.ADMIN_PATH.$url.'&page={page}',
			'size_class' => 'sm',
			'no_perpage' => true,
			'style' => 'pagination'));

		if (isset($this->request->get['field'])) {
			$this->data['field'] = $this->request->get['field'];
		} else {
			$this->data['field'] = '';
		}

		if (isset($this->request->get['CKEditorFuncNum'])) {
			$this->data['fckeditor'] = $this->request->get['CKEditorFuncNum'];
		} else {
			$this->data['fckeditor'] = false;
		}
		$this->view->batchAssign($this->data);
		$this->processTemplate('responses/extension/filemanager.tpl');
	}

	public function upload() {
		$this->language->load('editor/editor');

		$json = array();

		// Check user has permission
		if (!$this->user->hasPermission('modify', 'extension/editor')) {
			$json['error'] = $this->language->get('error_permission');
		}

		// Make sure we have the correct directory
		if (isset($this->request->get['directory'])) {
			$directory = rtrim(DIR_IMAGE . 'data/' . str_replace(array('../', '..\\', '..'), '', $this->request->get['directory']), '/');
		} else {
			$directory = DIR_IMAGE . 'data';
		}

		// Check its a directory
		if (!is_dir($directory)) {
			$json['error'] = $this->language->get('error_directory');
		}

		if (!$json) {

			if (!empty($this->request->files['file']['name']) && is_file($this->request->files['file']['tmp_name'])) {
				// Sanitize the filename
				$filename = basename(html_entity_decode($this->request->files['file']['name'], ENT_QUOTES, 'UTF-8'));
                $extension = utf8_strtolower(pathinfo($filename,PATHINFO_EXTENSION));
                $newFilename=strstr($filename, '.',true);
                $new=$newFilename.'.'.$extension;

				// Validate the filename length
				if ((utf8_strlen($new) < 3) || (utf8_strlen($new) > 255)) {
					$json['error'] = $this->language->get('error_filename');
				}

				// Allowed file extension types
				$allowed = array(
					'jpg',
					'jpeg',
					'gif',
					'png'
				);

				if (!in_array(utf8_strtolower(utf8_substr(strrchr($new, '.'), 1)), $allowed)) {
					$json['error'] = $this->language->get('error_filetype');
				}

				// Allowed file mime types
				$allowed = array(
					'image/jpeg',
					'image/pjpeg',
					'image/png',
					'image/x-png',
					'image/gif'
				);

				if (!in_array($this->request->files['file']['type'], $allowed)) {
					$json['error'] = $this->language->get('error_filetype');
				}

				// Check to see if any PHP files are trying to be uploaded
				$content = file_get_contents($this->request->files['file']['tmp_name']);

				if (preg_match('/\<\?php/i', $content)) {
					$json['error'] = $this->language->get('error_filetype');
				}

				// Return any upload error
				if ($this->request->files['file']['error'] != UPLOAD_ERR_OK) {
					$json['error'] = $this->language->get('error_upload_' . $this->request->files['file']['error']);
				}
			} else {
				$json['error'] = $this->language->get('error_upload');
			}
		}

		if (!$json) {
			move_uploaded_file($this->request->files['file']['tmp_name'], $directory . '/' . $new);

			$json['success'] = $this->language->get('text_uploaded');
		}

		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
	}

	public function folder() {

		$this->load->language('editor/editor');
		$json = array();

		// Check user has permission
		if (!$this->user->hasPermission('modify', 'extension/editor')) {
			$json['error'] = $this->language->get('error_permission');
		}

		// Make sure we have the correct directory
		if (isset($this->request->get['directory'])) {
			$directory = rtrim(DIR_IMAGE . 'data/' . str_replace(array('../', '..\\', '..'), '', $this->request->get['directory']), '/');
		} else {
			$directory = DIR_IMAGE . 'data';
		}

		// Check its a directory
		if (!is_dir($directory)) {
			$json['error'] = $this->language->get('error_directory');
		}

		if (!$json) {
			// Sanitize the folder name
			$folder = str_replace(array('../', '..\\', '..'), '', basename(html_entity_decode($this->request->post['folder'], ENT_QUOTES, 'UTF-8')));

			// Validate the filename length
			if ((utf8_strlen($folder) < 3) || (utf8_strlen($folder) > 128)) {
				$json['error'] = $this->language->get('error_folder');
			}

			// Check if directory already exists or not
			if (is_dir($directory . '/' . $folder)) {
				$json['error'] = $this->language->get('error_exists');
			}
		}

		if (!$json) {
			mkdir($directory . '/' . $folder, 0777);

			$json['success'] = $this->language->get('text_directory');
		}

		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
	}

	public function delete() {
		$this->language->load('editor/editor');

		$json = array();

		// Check user has permission
		if (!$this->user->hasPermission('modify', 'extension/editor')) {
			$json['error'] = $this->language->get('error_permission');
		}

		if (isset($this->request->post['path'])) {
			$paths = $this->request->post['path'];
		} else {
			$paths = array();
		}

		// Loop through each path to run validations
		foreach ($paths as $path) {
			$path = rtrim(DIR_IMAGE . str_replace(array('../', '..\\', '..'), '', $path), '/');

			// Check path exsists
			if ($path == DIR_IMAGE . 'data') {
				$json['error'] = $this->language->get('error_delete');
				break;
			}
		}

		foreach ($paths as $thumbPath) {
			$path = rtrim(DIR_IMAGE . 'thumbnails/' . str_replace(array('../', '..\\', '..'), '', $thumbPath), '/');

			// Check path exsists
			if ($path == DIR_IMAGE . 'thumbnails') {
				$json['error'] = $this->language->get('error_delete');
				break;
			}
		}

		if (!$json) {
			// Loop through each path
			foreach ($paths as $path) {
				$path = rtrim(DIR_IMAGE . str_replace(array('../', '..\\', '..'), '', $path), '/');

				// If path is just a file delete it
				if (is_file($path)) {
					unlink($path);

					// If path is a directory beging deleting each file and sub folder
				} elseif (is_dir($path)) {
					$files = array();

					// Make path into an array
					$path = array($path . '*');

					// While the path array is still populated keep looping through
					while (count($path) != 0) {
						$next = array_shift($path);

						foreach (glob($next) as $file) {
							// If directory add to path array
							if (is_dir($file)) {
								$path[] = $file . '/*';
							}

							// Add the file to the files to be deleted array
							$files[] = $file;
						}
					}

					// Reverse sort the file array
					rsort($files);

					foreach ($files as $file) {
						// If file just delete
						if (is_file($file)) {
							unlink($file);

							// If directory use the remove directory function
						} elseif (is_dir($file)) {
							rmdir($file);
						}
					}
				}
			}

			foreach ($paths as $thumbPath) {
				$getPath= strstr($thumbPath,'.',true);
				$ext=strrchr($thumbPath,'.');
				$thumbName=$getPath.'-100x100'.$ext;
				$thumbsFile = rtrim(DIR_IMAGE . 'thumbnails/' . str_replace(array('../', '..\\', '..'), '', $thumbName), '/');
				$thumbsFolder = rtrim(DIR_IMAGE . 'thumbnails/' . str_replace(array('../', '..\\', '..'), '', $thumbPath), '/');
				// If path is just a file delete it
				if (is_file($thumbsFile)) {
					unlink($thumbsFile);

					// If path is a directory beging deleting each file and sub folder
				} elseif (is_dir($thumbsFolder)) {

					$files = array();

					// Make path into an array
					$thumbsFolder = array($thumbsFolder . '*');

					// While the path array is still populated keep looping through
					while (count($thumbsFolder) != 0) {
						$next = array_shift($thumbsFolder);

						foreach (glob($next) as $file) {
							// If directory add to path array
							if (is_dir($file)) {
								$thumbsFolder[] = $file . '/*';
							}

							// Add the file to the files to be deleted array
							$files[] = $file;
						}
					}

					// Reverse sort the file array
					rsort($files);

					foreach ($files as $file) {
						// If file just delete
						if (is_file($file)) {
							unlink($file);

							// If directory use the remove directory function
						} elseif (is_dir($file)) {
							rmdir($file);
						}
					}
				}
			}

			$json['success'] = $this->language->get('text_delete');
		}

		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
	}

}
?>