<?php
/*------------------------------------------------------------------------------
  
  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2021 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (! defined ( 'DIR_CORE' )) {
    header ( 'Location: static_pages/' );
}

/**
 * Class ExtensionConstantContactIntegration
 * @property ModelExtensionConstantContactIntegration $model_extension_constantcontact_integration
 */

require_once DIR_EXT. "constantcontact_integration" . DIR_EXT_CORE ."helpers.php";
require_once DIR_EXT. "constantcontact_integration" . DIR_EXT_CORE ."updater.php";

class ExtensionConstantContactIntegration extends Extension {
    private $errors = '';

    public $data = array();

    private function _is_enabled() {
        return $this->baseObject->config->get('constantcontact_integration_status') ? $this->verify()  : false;
    }

	public function verify() {
    	$that =& $this->baseObject;
		$exist = $that->db->query("SHOW TABLES LIKE '".$that->db->table('ctct_license')."'");
		if ($exist->num_rows === 1) {
			$validation = ctctVerifyLicense();
			if ( $validation['notification_case'] === 'notification_license_ok' ) {
				return true;
			} elseif ( $validation['notification_case'] === 'notification_license_corrupted' ) {
				return false;
			}
		} else {
			return false;
		}
	}

	public function onControllerPagesExtensionExtensions_InitData() {
		$that =& $this->baseObject;
		if ( $this->baseObject_method === 'edit' ) {
			$extension=$that->request->get['extension'];
			if ($extension==='constantcontact_integration') {
				if ( $that->request->is_POST() ) {
					$exist = $that->db->query("SHOW TABLES LIKE '".$that->db->table('ctct_license')."'");
					if ($exist->num_rows === 1) {
						if ($this->verify()===true) {
							ctctUninstallLicense();
						} else {
							$that->db->query("DROP TABLE IF EXISTS ".$that->db->table('ctct_license'));
						}
						ctctInstallLicense( $that->request->post['constantcontact_integration_license_code'] );
					} else {
						$license = ctctInstallLicense( $that->request->post['constantcontact_integration_license_code'] );
						if ( $license['notification_case'] !== 'notification_license_ok' ) {
							$that->session->data['error'] = $license['notification_text'];
						} else {
							$that->session->data['success'] = "The license key is valid";
						}
					}
				}
			}
		}
	}

	public function onControllerResponsesListingGridExtension_UpdateData() {
		$that =& $this->baseObject;
		if ($this->baseObject_method==='update') {
			if ($that->request->post['constantcontact_integration_license_code']) {
				$exist = $that->db->query("SHOW TABLES LIKE '".$that->db->table('ctct_license')."'");
				if ($exist->num_rows === 1) {
					if ($this->verify()===true) {
						ctctUninstallLicense();
					} else {
						$that->db->query("DROP TABLE IF EXISTS ".$that->db->table('ctct_license'));
					}
					ctctInstallLicense( $that->request->post['constantcontact_integration_license_code'] );
				} else {
					$license = ctctInstallLicense( $that->request->post['constantcontact_integration_license_code'] );
					if ( $license['notification_case'] !== 'notification_license_ok' ) {
						$that->session->data['error'] = $license['notification_text'];
					} else {
						$that->session->data['success'] = "The license key is valid";
					}
				}
			}
		}
	}

    public function onControllerPagesExtensionExtensions_UpdateData() {
        $that =& $this->baseObject;
	    if ($this->baseObject_method=='edit') {
		    $that->view->assign('list_url', $that->html->getSecureURL('r/extension/constantcontact_integration/getList'));
		    if ($that->request->get['extension']==='constantcontact_integration') {
			    $that->processTemplate('pages/extension/cc_integration_extensions_edit.tpl');
		    }
	    }
    }

    public function onControllerPagesAccountCreate_InitData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
		if ($this->baseObject_method === 'main') {
				$that->load->model( 'extension/ctct' );
				$that->loadModel( 'account/customer' );
				$email     = $that->request->post['email'];
				$firstname = $that->request->post['firstname'];
				$lastname  = $that->request->post['lastname'];
				if ( $that->request->is_POST() ) {
					if ( isset( $email ) && $that->request->post['newsletter'] == 1 ) {
						$exist = $that->model_extension_ctct->getContact( $email );
						$error = $that->model_account_customer->validateRegistrationData( $this->baseObject->request->post );
						if ( ! $error ) {
							$custId = $exist[0]->id;
							if ( empty( $exist ) ) {
								$that->model_extension_ctct->Subscribe( $email, $firstname, $lastname, 0 );
							} else {
								$that->model_extension_ctct->Subscribe( $email, $firstname, $lastname, 1, $custId, 'ACTION_BY_VISITOR' );
							}
						}
					}
				}
		}
    }

    public function onControllerPagesAccountNotification_InitData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        $that->loadModel('account/customer');
        $that->load->model('extension/ctct');
		if ($this->baseObject_method === 'main') {
				$firstname = $that->customer->getFirstName();
				$lastname  = $that->customer->getLastName();
				$email     = $that->customer->getEmail();
				if ( $that->request->is_POST() ) {
					$subscribe = $that->request->post['settings']['newsletter']['email'];
					$exist     = $that->model_extension_ctct->getContact( $email );
					$custId    = $exist[0]->id;
					if ( $subscribe === '1' ) {
						if ( empty( $exist ) ) {
							$that->model_extension_ctct->Subscribe( $email, $firstname, $lastname, 0 );
						} else {
							$that->model_extension_ctct->Subscribe( $email, $firstname, $lastname, 1, $custId, 'ACTION_BY_VISITOR' );
						}
					} else {
						$that->model_extension_ctct->Unsubscribe( $email );
					}
				}
		}
    }

    public function onControllerPagesAccountNewsletter_InitData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        $that->loadModel('account/customer');
        $that->load->model('extension/ctct');
				$firstname = $that->customer->getFirstName();
				$lastname  = $that->customer->getLastName();
				$email     = $that->customer->getEmail();
				if ( $that->request->is_POST() ) {
					$subscribe = $that->request->post['newsletter'];
					$exist     = $that->model_extension_ctct->getContact( $email );
					$custId    = $exist[0]->id;
					if ( $subscribe === '1' ) {
						if ( empty( $exist ) ) {
							$that->model_extension_ctct->Subscribe( $email, $firstname, $lastname, 0 );
						} else {
							$that->model_extension_ctct->Subscribe( $email, $firstname, $lastname, 1, $custId, 'ACTION_BY_VISITOR' );
						}
					} else {
						$that->model_extension_ctct->Unsubscribe( $email );
					}
				}
    }

    public function onControllerPagesSaleCustomer_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        $that->load->model('extension/constantcontact_integration');
        $that->load->model('sale/customer');
        if ($this->baseObject_method === 'main') {
	        $customer = $that->model_sale_customer->getCustomer( (int) $that->request->get['customer_id'] );
	        if ( $that->request->is_POST() ) {
		        if ( $this->baseObject_method === 'insert' ) {
			        if ( $that->request->post['newsletter'] == 1 ) {
				        $firstname = $that->request->post['firstname'];
				        $lastname  = $that->request->post['lastname'];
				        $email     = $that->request->post['email'];
				        $exist     = $that->model_extension_constantcontact_integration->getContact( $email );
				        if ( empty( $exist ) ) {
					        $that->model_extension_constantcontact_integration->Subscribe( $email, $firstname, $lastname, 0 );
				        }
			        }
		        } elseif ( $this->baseObject_method == 'update' ) {
			        if ( $that->request->post['newsletter'] == 0 ) {
				        $that->model_extension_constantcontact_integration->Unsubscribe( $customer['email'] );
			        }
		        } elseif ( $this->baseObject_method == 'update_field' ) {
			        if ( $that->request->post['newsletter'] == 0 ) {
				        $that->model_extension_constantcontact_integration->Unsubscribe( $customer['email'] );
			        }
		        }
	        }
        }
    }

    public function onControllerResponsesListingGridTelephone_UpdateData(){
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'update_field') {
	            $this->baseObject->loadModel( 'sale/customer' );
		        $that->load->model( 'extension/constantcontact_integration' );
		        $customer = $that->model_sale_customer->getCustomer( (int) $that->request->get['id'] );
		        if ( $that->request->is_POST() ) {
			        if ( $that->request->post['newsletter'] == 0 ) {
				        $that->model_extension_constantcontact_integration->Unsubscribe( $customer['email'] );
			        }
		        }
        }
    }

    public function onControllerResponsesListingGridTaxid_UpdateData() {
		    if ( ! $this->_is_enabled() ) {
			    return null;
		    }
		    $that =& $this->baseObject;
		    if ( $this->baseObject_method === 'update_field' ) {
			    $that->loadModel( 'sale/customer' );
			    $that->load->model( 'extension/constantcontact_integration' );
			    $customer = $that->model_sale_customer->getCustomer( (int) $that->request->get['id'] );
			    if ( $that->request->is_POST() ) {
				    if ( $that->request->post['newsletter'] == 0 ) {
					    $that->model_extension_constantcontact_integration->Unsubscribe( $customer['email'] );
				    }
			    }
		    }
    }

    public function onControllerResponsesListingGridCustomer_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'update_field') {
	            $this->baseObject->loadModel( 'sale/customer' );
		        $that->load->model( 'extension/constantcontact_integration' );

		        $customer = $that->model_sale_customer->getCustomer( (int) $that->request->get['id'] );
		        if ( $that->request->is_POST() ) {
			        if ( $that->request->post['newsletter'] == 0 ) {
				        $that->model_extension_constantcontact_integration->Unsubscribe( $customer['email'] );
			        }
		        }
        }
    }

    public function onControllerResponsesQuickCheckoutRegister_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'validate') {
        	    $that->load->model( 'extension/ctct' );
		        $email     = $that->request->post['email'];
		        $firstname = $that->request->post['firstname'];
		        $lastname  = $that->request->post['lastname'];
		        if ( $that->request->is_POST() ) {
			        if ( isset( $email ) && $that->request->post['newsletter'] == 1 ) {
				        $exist  = $that->model_extension_ctct->getContact( $email );
				        $custId = $exist[0]->id;
				        if ( empty( $exist ) ) {
					        $that->model_extension_ctct->Subscribe( $email, $firstname, $lastname, 0 );
				        } else {
					        $that->model_extension_ctct->Subscribe( $email, $firstname, $lastname, 1, $custId, 'ACTION_BY_VISITOR' );
				        }
			        }
		        }
        }
    }

    public function onControllerCommonHead_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'main') {
            if (IS_ADMIN) {
                $support = ctctVerifySupport();
                if ($support['notification_case'] === 'notification_license_ok') {
                    $that->load->language('constantcontact_integration/constantcontact_integration');
                    $getVersions = ctctUpdaterGetAllVersions();
                    $that->load->model('extension/constantcontact_integration_updater');
                    $current_version = $that->model_extension_constantcontact_integration_updater->getCurrentVersion();
                    if ($getVersions['notification_case'] !== 'notification_product_no_versions') {
                        $versions = $getVersions['notification_data']['product_versions'];
                        $total = $that->model_extension_constantcontact_integration_updater->getTotalMsgIds();
                        if ($total > '0') {
                            $msg_ids = $that->model_extension_constantcontact_integration_updater->getMsgIdsByCartVersions();
                            foreach ($msg_ids as $msg_id) {
                                $that->messages->deleteMessage($msg_id['msg_id']);
                                $that->model_extension_constantcontact_integration_updater->deleteMsgID($msg_id['msg_id']);
                            }
                        }
                        foreach ($versions as $version) {
                            if (version_compare($current_version, $version['version_number'], '<') === true &&
                                version_compare(VERSION, '1.2.17', '<') === true && version_compare($version['version_number'], '1.2.17', '<') === true
                                || version_compare($current_version, $version['version_number'], '<') === true && version_compare(VERSION, '1.2.17', '=') === true
                                && version_compare($version['version_number'], '1.2.17', '>=') === true) {
                                $msg_title = str_replace('[new_version]', $version['version_number'], $that->language->get('text_new_ctct_version_title'));
                                $that->messages->saveNotice($msg_title, $that->language->get('text_new_ctct_version_description'));
                                $msg_info = $that->messages->getLikeMessage($msg_title);
                                $that->model_extension_constantcontact_integration_updater->saveMessageId($msg_info['msg_id'], $version['version_number']);
                            }
                        }
                    }
                }
            }
        }
    }
}