<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2022 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

require_once DIR_SYSTEM . "lib/vendor/autoload.php";
require_once DIR_SYSTEM . "lib/license.php";
require_once DIR_EXT. "email_editor" . DIR_EXT_CORE ."updater.php";

class ExtensionEmailEditor extends Extension {

    public $data=[];
    public $errors=[];
    public $error=[];
    private $mc_server_url = "https://abantecartplus.com/clientarea/plugin/license_manager/validate/";
    private $diy_server_url = "https://wehearyou2.com/clientarea/plugin/license_manager/validate/";
    private $shared_secret = "email_editor";

    public function __construct() {
        $this->registry = Registry::getInstance();
    }

	private function _is_enabled() {
    	return $this->baseObject->config->get('email_editor_status') && $this->verify();
	}

    public function verify() {
        $that =& $this->baseObject;
        $that->load->model('extension/email_editor_license_info');
        $license_key = $that->config->get('email_editor_license_code');
        if ($license_key) {
            $exist = $that->db->query("SHOW TABLES LIKE '" . $that->db->table('email_editor_license_info') . "'");
            if ($exist->num_rows === 1) {
                $store_id = $that->model_extension_email_editor_license_info->getStoreId();
                $license_key = $that->model_extension_email_editor_license_info->getLicenseCode($store_id);
                $license_info = $that->model_extension_email_editor_license_info->getLicenseData($store_id);
                $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                $license = new License($path_to_phpseclib);
                $license_manager = $license->getManager();
                $license_manager->setKeys($license_key, $license_info['public_key'], $this->shared_secret);
                $ttl = 1209600;
                $validate = $license_manager->validate($license_info['license_data'], $ttl);
                $store_status = $that->model_extension_email_editor_license_info->getLicensedStoreStatus();
                if ($validate['status']==='expired') {
                    $that->load->model('extension/email_editor_license_info');
                    $store_id = $that->model_extension_email_editor_license_info->getStoreId();
                    $public_key = "";
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license_key = $that->model_extension_email_editor_license_info->getLicenseCode($store_id);
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    if (stripos($license_key,'mc-')!==false) {
                        $server_url = $this->mc_server_url;
                    } else {
                        $server_url = $this->diy_server_url;
                    }

                    $license_manager->setLicenseServerUrl($server_url);
                    $license_manager->setKeys($license_key, "", $this->shared_secret);
                    $public_key = $license_manager->requestKey();
                    $license_manager->setKeys($license_key, $public_key, $this->shared_secret);
                    $that->load->model('extension/email_editor_license_info');
                    $current_version = $that->model_extension_email_editor_license_info->getCurrentVersion();
                    $custom_data = ['version' => $current_version];
                    $license_data = $license_manager->requestData($custom_data);
                    if (!is_null($license_data)) {
                        $data['public_key'] = $public_key;
                        $data['license_data'] = $license_data;
                        $ttl = 1209600;
                        $validate = $license_manager->validate($license_data, $ttl);
                        if ($validate['status'] !== 'unknown' && $validate['status'] !== 'invalid_location') {
                            $data['public_key'] = $public_key;
                            $data['license_data'] = $license_data;
                            $data['store_id'] = $store_id;
                            $data['last_check'] = time();
                            $that->load->model('extension/email_editor_license_info');
                            $that->model_extension_email_editor_license_info->saveLicenseData($data);
                        } elseif ($validate['status'] === 'valid' && $store_status == 1) {
                            return true;
                        } else {
                            return false;
                        }
                    }
                } else {
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                }
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    public function verifyOptionLink() {
        $that =& $this->baseObject;
        if ($that->config->get('option_price_link_pro_status')==='1') {
            $that->load->model('extension/option_price_link_pro_license_info');
            $license_key = $that->config->get('option_price_link_pro_license_code');
            $shared_secret = 'option_price_link_pro';
            if ($license_key) {
                $exist = $that->db->query("SHOW TABLES LIKE '" . $that->db->table('option_price_link_pro_license_info') . "'");
                if ($exist->num_rows === 1) {
                    $store_id = $that->model_extension_option_price_link_pro_license_info->getStoreId();
                    $license_key = $that->model_extension_option_price_link_pro_license_info->getLicenseCode($store_id);
                    $license_info = $that->model_extension_option_price_link_pro_license_info->getLicenseData($store_id);
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    $license_manager->setKeys($license_key, $license_info['public_key'], $shared_secret);
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_info['license_data'], $ttl);
                    $store_status = $that->model_extension_option_price_link_pro_license_info->getLicensedStoreStatus();
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                }
            }
        } else {
            return false;
        }
    }

    public function verifyTaxId() {
        $that =& $this->baseObject;
        if ( $that->config->get( 'taxid_option_status' ) ) {
            $that->load->model('extension/taxid_option_license_info');
            $license_key = $that->config->get('taxid_option_license_code');
            $shared_secret = 'taxid_option';
            if ($license_key) {
                $exist = $that->db->query("SHOW TABLES LIKE '" . $that->db->table('taxid_option_license_info') . "'");
                if ($exist->num_rows === 1) {
                    $store_id = $that->model_extension_taxid_option_license_info->getStoreId();
                    $license_key = $that->model_extension_taxid_option_license_info->getLicenseCode($store_id);
                    $license_info = $that->model_extension_taxid_option_license_info->getLicenseData($store_id);
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    $license_manager->setKeys($license_key, $license_info['public_key'], $shared_secret);
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_info['license_data'], $ttl);
                    $store_status = $that->model_extension_taxid_option_license_info->getLicensedStoreStatus();
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                }
            }
        } else {
            return false;
        }
    }

    public function verifyTelephone() {
        $that =& $this->baseObject;
        if ( $that->config->get( 'telephone_option_status' ) ) {
            $that->load->model('extension/telephone_option_license_info');
            $license_key = $that->config->get('telephone_option_license_code');
            $shared_secret = 'telephone_option';
            if ($license_key) {
                $exist = $that->db->query("SHOW TABLES LIKE '" . $that->db->table('telephone_option_license_info') . "'");
                if ($exist->num_rows === 1) {
                    $store_id = $that->model_extension_telephone_option_license_info->getStoreId();
                    $license_key = $that->model_extension_telephone_option_license_info->getLicenseCode($store_id);
                    $license_info = $that->model_extension_telephone_option_license_info->getLicenseData($store_id);
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    $license_manager->setKeys($license_key, $license_info['public_key'], $shared_secret);
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_info['license_data'], $ttl);
                    $store_status = $that->model_extension_telephone_option_license_info->getLicensedStoreStatus();
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                }
            }
        } else {
            return false;
        }
    }

    public function verifyBuildAGift() {
        $that =& $this->baseObject;
        if ($that->config->get('build_a_gift_status')==='1') {
            $that->load->model('extension/build_a_gift_license_info');
            $license_key = $that->config->get('build_a_gift_license_code');
            $shared_secret = 'build_a_gift';
            if ($license_key) {
                $exist = $that->db->query("SHOW TABLES LIKE '" . $that->db->table('build_a_gift_license_info') . "'");
                if ($exist->num_rows === 1) {
                    $store_id = $that->model_extension_build_a_gift_license_info->getStoreId();
                    $license_key = $that->model_extension_build_a_gift_license_info->getLicenseCode($store_id);
                    $license_info = $that->model_extension_build_a_gift_license_info->getLicenseData($store_id);
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    $license_manager->setKeys($license_key, $license_info['public_key'], $shared_secret);
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_info['license_data'], $ttl);
                    $store_status = $that->model_extension_build_a_gift_license_info->getLicensedStoreStatus();
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                }
            }
        } else {
            return false;
        }
    }

    public function verifyUpsPlus() {
        $that =& $this->baseObject;
        if ($that->config->get('ups_integration_plus_status')==='1') {
            $that->load->model('extension/ups_integration_license_info');
            $license_key = $that->config->get('ups_integration_license_code');
            $shared_secret = 'ups_integration_plus';
            if ($license_key) {
                $exist = $that->db->query("SHOW TABLES LIKE '" . $that->db->table('ups_integration_license_info') . "'");
                if ($exist->num_rows === 1) {
                    $store_id = $that->model_extension_ups_integration_license_info->getStoreId();
                    $license_key = $that->model_extension_ups_integration_license_info->getLicenseCode($store_id);
                    $license_info = $that->model_extension_ups_integration_license_info->getLicenseData($store_id);
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    $license_manager->setKeys($license_key, $license_info['public_key'], $shared_secret);
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_info['license_data'], $ttl);
                    $store_status = $that->model_extension_ups_integration_license_info->getLicensedStoreStatus();
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                }
            }
        } else {
            return false;
        }
    }

    public function verifyDeliveryScheduler() {
        $that =& $this->baseObject;
        if ($that->config->get('delivery_scheduler_plus_status')==='1') {
            $that->load->model('extension/delivery_scheduler_license_info');
            $license_key = $that->config->get('delivery_scheduler_license_code');
            $shared_secret = 'delivery_scheduler';
            if ($license_key) {
                $exist = $that->db->query("SHOW TABLES LIKE '" . $that->db->table('delivery_scheduler_license_info') . "'");
                if ($exist->num_rows === 1) {
                    $store_id = $that->model_extension_delivery_scheduler_license_info->getStoreId();
                    $license_key = $that->model_extension_delivery_scheduler_license_info->getLicenseCode($store_id);
                    $license_info = $that->model_extension_delivery_scheduler_license_info->getLicenseData($store_id);
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    $license_manager->setKeys($license_key, $license_info['public_key'], $shared_secret);
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_info['license_data'], $ttl);
                    $store_status = $that->model_extension_delivery_scheduler_license_info->getLicensedStoreStatus();
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                }
            }
        } else {
            return false;
        }
    }

    public function verifyCustGroup() {
        $that =& $this->baseObject;
        if ( $that->config->get( 'customer_group_auto_assigned_status' ) ) {
            $that->load->model('extension/customer_group_auto_assigned_license_info');
            $license_key = $that->config->get('customer_group_auto_assigned_license_code');
            $shared_secret = 'customer_group_auto_assigned';
            if ($license_key) {
                $exist = $that->db->query("SHOW TABLES LIKE '" . $that->db->table('customer_group_auto_assigned_license_info') . "'");
                if ($exist->num_rows === 1) {
                    $store_id = $that->model_extension_customer_group_auto_assigned_license_info->getStoreId();
                    $license_key = $that->model_extension_customer_group_auto_assigned_license_info->getLicenseCode($store_id);
                    $license_info = $that->model_extension_customer_group_auto_assigned_license_info->getLicenseData($store_id);
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    $license_manager->setKeys($license_key, $license_info['public_key'], $shared_secret);
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_info['license_data'], $ttl);
                    $store_status = $that->model_extension_customer_group_auto_assigned_license_info->getLicensedStoreStatus();
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                }
            }
        } else {
            return false;
        }
    }

    public function onControllerPagesIndexLogin_InitData() {
        $that =& $this->baseObject;
        if ($that->request->is_POST()) {
            $logged_in = $that->session->data['LAST_ACTIVITY'];
            $exist = $that->db->query("SHOW TABLES LIKE '" . $that->db->table('email_editor_license_info') . "'");
            if ($exist->num_rows === 1) {
                if (isset($logged_in)) {
                    $that->load->model('extension/email_editor_license_info');
                    $store_id = $that->model_extension_email_editor_license_info->getStoreId();

                    $license_info = $that->model_extension_email_editor_license_info->getLicenseData($store_id);
                    $last_check = $license_info['last_check'];
                    $daily_check = 86400;
                    if (time() > $daily_check + $last_check) {
                        $public_key = "";
                        $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                        $license_key = $that->model_extension_email_editor_license_info->getLicenseCode($store_id);
                        $license = new License($path_to_phpseclib);
                        $license_manager = $license->getManager();
                        if (stripos($license_key,'mc-')!==false) {
                            $server_url = $this->mc_server_url;
                        } else {
                            $server_url = $this->diy_server_url;
                        }

                        $license_manager->setLicenseServerUrl($server_url);
                        $license_manager->setKeys($license_key, "", $this->shared_secret);
                        $public_key = $license_manager->requestKey();
                        $license_manager->setKeys($license_key, $public_key, $this->shared_secret);
                        $that->load->model('extension/email_editor_updater');
                        $current_version = $that->model_extension_email_editor_updater->getCurrentVersion();
                        $custom_data = ['version' => $current_version];
                        $license_data = $license_manager->requestData($custom_data);
                        if (!is_null($license_data)) {
                            $data['public_key'] = $public_key;
                            $data['license_data'] = $license_data;
                            $ttl = 1209600;
                            $validate = $license_manager->validate($license_data, $ttl);
                            if ($validate['status'] !== 'unknown' && $validate['status'] !== 'invalid_location') {
                                $data['public_key'] = $public_key;
                                $data['license_data'] = $license_data;
                                $data['store_id'] = $store_id;
                                $data['last_check'] = time();
                                $that->load->model('extension/email_editor_license_info');
                                $that->model_extension_email_editor_license_info->saveLicenseData($data);
                            }
                        }
                    }
                }
            }
        }
    }

    public function onControllerPagesExtensionExtensions_InitData() {
        $that =& $this->baseObject;
        if ( $this->baseObject_method === 'edit' ) {
            $extension = $that->request->get['extension'];
            if ( $extension === 'email_editor' ) {
                if ( $that->request->is_POST()) {
                    $public_key = "";
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license_key = trim($that->request->post['email_editor_license_code']);
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    if (stripos($license_key,'mc-')!==false) {
                        $server_url = $this->mc_server_url;
                    } else {
                        $server_url = $this->diy_server_url;
                    }
                    $license_manager->setLicenseServerUrl($server_url);
                    $license_manager->setKeys($license_key, "", $this->shared_secret);
                    $public_key = $license_manager->requestKey();
                    $that->load->model('extension/email_editor_license_info');

                    $store_id = (int) $that->config->get('config_store_id');
                    if (has_value($that->request->get_or_post('store_id'))) {
                        $store_id = (int) $that->request->get_or_post('store_id');
                    } else {
                        if ($that->session->data['current_store_id']) {
                            $store_id = (int) $that->session->data['current_store_id'];
                        }
                    }

                    $installed_store_id = $that->model_extension_email_editor_license_info->getInstalledLicense($license_key);

                    if ($installed_store_id!=='' && !is_null($installed_store_id)) {
                        $that->model_extension_email_editor_license_info->deleteLicenseInfo($installed_store_id);
                    }
                    $existing_license_key = $that->model_extension_email_editor_license_info->getLicenseCode($store_id);
                    $data['multi']=false;
                    $split_existing_license_key = explode('-',$existing_license_key);
                    $split_license_key = explode('-',$license_key);
                    if ($existing_license_key && $split_existing_license_key[0] !== $split_license_key[0]) {
                        $data['multi']=true;
                    }

                    $license_manager->setKeys($license_key, $public_key, $this->shared_secret);
                    $that->load->model('extension/email_editor_updater');
                    $current_version = $that->model_extension_email_editor_updater->getCurrentVersion();
                    $custom_data = ['version' => $current_version];
                    $license_data = $license_manager->requestData($custom_data);
                    if (!is_null($license_data)) {
                        $ttl = 1209600;
                        $validate = $license_manager->validate($license_data, $ttl);

                        $that->load->model('setting/setting');
                        $that->load->model('extension/email_editor_license_info');
                        $data['email_editor_licensed_store_id_'.$store_id] = 1;

                        $that->model_setting_setting->editSetting('email_editor', $data);
                        if ($validate['status'] !== 'unknown' && $validate['status'] !== 'invalid_location') {
                            if (file_exists(DIR_EXT.'email_editor/core/helpers.php')) {
                                unlink(DIR_EXT.'email_editor/core/helpers.php');
                            }
                            $data['public_key'] = $public_key;
                            $data['license_data'] = $license_data;
                            $data['license_key'] = $license_key;
                            $data['store_id'] = $store_id;
                            $data['last_check'] = time();
                            $that->load->model('extension/email_editor_license_info');
                            $that->model_extension_email_editor_license_info->saveLicenseData($data);
                        }
                    } else {
                        $that->session->data['error'] = "We are unable to install the license key. Please make sure you are using the correct license key!";
                    }
                }
            }
        }
    }

    public function onControllerPagesExtensionExtensions_UpdateData() {
        $that =& $this->baseObject;
        if ( $this->baseObject_method === 'edit' ) {
            $extension = $that->request->get['extension'];
            $that->load->language('email_editor/email_editor');
            if ( $extension === 'email_editor' ) {
                $latestVersion = $this->getVersion();
                $that->loadLanguage('extension/extensions');
                if (!is_null($latestVersion) && $latestVersion!=='') {
                    $info = sprintf(
                        $that->language->get('text_update_email_editor_available'),
                        $latestVersion,
                        $that->html->getSecureURL('extension/email_editor_updater','&version='.str_replace('.', '-', $latestVersion))
                    );
                    $that->view->assign('info',$info);
                } else {
                    $that->view->assign('info','');
                }
                $view = new AView($this->registry, 0);
                $data['manual_url'] = 'https://why2central.net/v1/email-editor';
                $data['manual_title'] = $that->language->get('email_editor_name').' Manual';
                $view->batchAssign($data);
                $that->view->addHookVar('extension_toolbar_buttons', $view->fetch('pages/extension/email_editor_manual.tpl'));
                $that->load->model('extension/email_editor_license_info');
                $license_key = $that->config->get('email_editor_license_code');
                if ($license_key) {
                    $exist = $that->db->query("SHOW TABLES LIKE '" . $that->db->table('email_editor_license_info') . "'");
                    if ($exist->num_rows === 1) {
                        $store_id = $that->model_extension_email_editor_license_info->getStoreId();
                        $license_key = $that->model_extension_email_editor_license_info->getLicenseCode($store_id);
                        $license_info = $that->model_extension_email_editor_license_info->getLicenseData($store_id);
                        $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                        $license = new License($path_to_phpseclib);
                        $license_manager = $license->getManager();
                        $license_manager->setKeys($license_key, $license_info['public_key'], $this->shared_secret);
                        $ttl = 1209600;
                        $validate = $license_manager->validate($license_info['license_data'], $ttl);
                        $message = '';
                        if ($validate['status']==='expired') {
                            $message = $that->language->get('email_editor_license_expired');
                        }
                        $that->view->assign('message',$message);
                    }
                }
                $that->processTemplate();
            }
        }
    }

    public function onControllerResponsesListingGridExtension_InitData() {
        if ($this->baseObject_method != 'update') {
            return false;
        }
        $that =& $this->baseObject;
        if ($that->request->get['id'] != 'email_editor') {
            return false;
        }
        if (isset($that->request->post['email_editor_license_code'])) {
            $that->request->post['email_editor_license_code'] = trim($that->request->post['email_editor_license_code']);
        }
    }

    public function onControllerResponsesListingGridExtension_UpdateData() {
        $that =& $this->baseObject;
        if ($this->baseObject_method==='main') {
            $store_id = (int)$that->config->get('current_store_id');
            if ($that->request->get_or_post('store_id')) {
                $store_id = $that->request->get_or_post('store_id');
            }
            $that->load->language('email_editor/email_editor');
            $response = json_decode(json_encode($that->data['response']), true);
            $extension_rows = $response['rows'];
            $ext_name = $that->language->get('email_editor_name');
            foreach ($extension_rows as $k => $extensions) {
                if ($extensions['id'] === 'email_editor_' . $store_id) {
                    $cells = $extensions['cell'];
                    foreach ($cells as $key => $cell) {
                        if ($cell===$ext_name || strpos($cell,'<p class="alert-info">'.$ext_name)!==false) {
                            $latestVersion = $this->getVersion();
                            if (!is_null($latestVersion) && $latestVersion !== '') {
                                $update_now_url = $that->html->getSecureURL('extension/email_editor_updater', '&version=' . str_replace('.', '-', $latestVersion));
                                $cells[$key] = '<p class="alert-info">'
                                    .$ext_name.' (WHY2)'
                                    . '<br>'
                                    . sprintf(
                                        $that->language->get('text_update_email_editor_available'),
                                        $latestVersion,
                                        $update_now_url
                                    )
                                    . '</p>';
                                $that->data['response']->rows[$k]['cell'][$key] = $cells[$key];
                            } else {
                                $that->data['response']->rows[$k]['cell'][$key] = $ext_name;
                            }
                        }
                    }
                }
            }
        } elseif ($this->baseObject_method==='update') {
            if ($that->request->post['email_editor_license_code']) {
                $public_key = "";
                $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";

                $license_key = trim($that->request->post['email_editor_license_code']);
                if (stripos($license_key,'mc-')!==false) {
                    $server_url = $this->mc_server_url;
                } else {
                    $server_url = $this->diy_server_url;
                }
                $license = new License($path_to_phpseclib);
                $license_manager = $license->getManager();
                $license_manager->setLicenseServerUrl($server_url);
                $license_manager->setKeys($license_key, "", $this->shared_secret);
                $public_key = $license_manager->requestKey();

                $store_id = (int) $that->config->get('config_store_id');
                if ($that->request->get_or_post('store_id')) {
                    $store_id = $that->request->get_or_post('store_id');
                }

                $that->load->model('extension/email_editor_license_info');

                $installed_store_id = $that->model_extension_email_editor_license_info->getInstalledLicense($license_key);

                if ($installed_store_id!=='' && !is_null($installed_store_id)) {
                    $that->model_extension_email_editor_license_info->deleteLicenseInfo($installed_store_id);
                }

                $license_manager->setKeys($license_key, $public_key, $this->shared_secret);
                $that->load->model('extension/email_editor_updater');
                $current_version = $that->model_extension_email_editor_updater->getCurrentVersion();
                $custom_data = ['version' => $current_version];
                $license_data = $license_manager->requestData($custom_data);
                if (!is_null($license_data)) {
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_data, $ttl);

                    $that->load->model('setting/setting');
                    $that->load->model('extension/email_editor_license_info');

                    if ($validate['status'] !== 'unknown' && $validate['status'] !== 'invalid_location') {
                        $data['public_key'] = $public_key;
                        $data['license_data'] = $license_data;
                        $data['license_key'] = $license_key;
                        $data['store_id'] = $store_id;
                        $data['last_check'] = time();
                        $that->load->model('extension/email_editor_license_info');
                        $that->model_extension_email_editor_license_info->saveLicenseData($data);
                    }
                } else {
                    $that->session->data['error'] = "We are unable to install the license key. Please make sure you are using the correct license key!";
                }
            }
        }
    }

    public function onControllerPagesExtensionExtensionSummary_UpdateData() {
        $that =& $this->baseObject;
        if ($this->baseObject_method==='main') {
            $extension = $that->request->get['extension'];
            if ($extension==='email_editor') {
                $that->load->language('email_editor/email_editor');
                $extension_info = $that->extensions->getExtensionInfo($extension);
                $support_expiration_int =  strtotime($extension_info['support_expiration']);
                if ($extension_info['support_expiration'] && $support_expiration_int !== 0) {
                    if ($support_expiration_int < time()) {
                        if ($that->data['text_support_expiration']) {
                            $that->view->assign('text_support_expired', $that->language->get('text_support_by_why2'));
                        } else {
                            $data['text_support_expired'] = $that->language->get('text_support_by_why2');
                        }
                    }
                } else {
                    $data['text_support_expired'] = $that->language->get('text_support_by_why2');
                }
                $that->view->assign('get_support_button', '');
                $data['get_diy_support_button'] = $that->html->buildElement(
                    [
                        'type'   => 'button',
                        'name'   => 'btn_get_diy_support',
                        'id'     => 'diy_support',
                        'target' => "_new",
                        'href'   => 'https://wehearyou2.com/clientarea/client/login/',
                        'text'   => $that->language->get('button_diy_support_by_why2'),
                    ]
                );
                $data['get_mc_support_button'] = $that->html->buildElement(
                    [
                        'type'   => 'button',
                        'name'   => 'btn_get_diy_support',
                        'id'     => 'mc_support',
                        'target' => "_new",
                        'href'   => 'https://abantecartplus.com/clientarea/client/login/',
                        'text'   => $that->language->get('button_mc_support_by_why2'),
                    ]
                );
                $view = new AView(Registry::getInstance(), 0);
                $view->batchAssign($data);
                $that->view->addHookVar('extension_summary_item', $view->fetch('pages/extension/extension_summary_buttons.tpl'));
                $that->view->batchAssign($this->data);
                $that->processTemplate();
            }
        }
    }

    public function onControllerPagesSaleContact_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method='main') {
            $that->load->language('sale/contact');
            $that->load->language('email_editor/email_editor');
            if (!has_value($this->data['protocol'])) {
                $this->data['protocol'] = 'email';
            }

            $that->load->model('catalog/product');
            $that->load->model('sale/customer');
            $this->data['customers'] = $this->data['products'] = [];
            $customer_ids = $that->request->get_or_post('to');
            if (!$customer_ids && isset($that->session->data['sale_contact_presave']['to'])) {
                $customer_ids = (array)$that->session->data['sale_contact_presave']['to'];
            }
            $product_ids = $that->request->get_or_post('products');
            if (!$product_ids && isset($that->session->data['sale_contact_presave']['products'])) {
                $product_ids = $that->session->data['sale_contact_presave']['products'];
            }

            //process list of customer or product IDs to be notified
            if (isset($customer_ids) && is_array($customer_ids)) {
                foreach ($customer_ids as $customer_id) {
                    $customer_info = $that->model_sale_customer->getCustomer($customer_id);
                    if ($customer_info) {
                        $this->data['customers'][$customer_info['customer_id']] = $customer_info['firstname'].' '.$customer_info['lastname'].' ('.$customer_info['email'].')';
                    }
                }
            }

            if ($product_ids) {
                //get thumbnails by one pass
                $resource   = new AResource( 'image' );
                $thumbnails = $resource->getMainThumbList(
                    'products',
                    $product_ids,
                    $that->config->get( 'config_image_grid_width' ),
                    $that->config->get( 'config_image_grid_height' )
                );

                foreach ( $product_ids as $product_id ) {
                    $product_info = $that->model_catalog_product->getProduct( $product_id );
                    if ( $product_info ) {
                        $thumbnail                             = $thumbnails[ $product_id ];
                        $this->data['products'][ $product_id ] = [
                            'name'  => $product_info['name'],
                            'image' => $thumbnail['thumb_html'],
                        ];
                    }
                }
            }

            foreach (['recipient', 'subject', 'message'] as $n) {
                $this->data[$n] = $that->request->post_or_get($n);
                if (!$this->data[$n] && isset($that->session->data['sale_contact_presave'][$n])) {
                    $this->data[$n] = $that->session->data['sale_contact_presave'][$n];
                }
            }

            $form = new AForm('ST');
            $form->setForm([
                'form_name' => 'sendFrm',
                'update'    => $this->data['update'],
            ]);

            $this->data['form']['form_open'] = $form->getFieldHtml(
                [
                    'type'   => 'form',
                    'name'   => 'sendFrm',
                    'action' => '',
                    'attr'   => 'data-confirm-exit="true" class="form-horizontal"',
                ]);

            $this->data['form']['submit'] = $form->getFieldHtml([
                'type'  => 'button',
                'name'  => 'submit',
                'text'  => $that->language->get('button_send'),
                'style' => 'button1',
            ]);

            $this->data['form']['preview'] = $form->getFieldHtml(
                ['type' => 'button',
                    'name' => 'preview',
                    'text' => $that->language->get('button_preview'),
                    'style' => 'button1'
                ]);

            $this->data['form']['cancel'] = $form->getFieldHtml([
                'type'  => 'button',
                'name'  => 'cancel',
                'text'  => $that->language->get('button_cancel'),
                'style' => 'button2',
            ]);

            $this->data['form']['fields']['protocol'] = $form->getFieldHtml([
                'type'  => 'hidden',
                'name'  => 'protocol',
                'value' => $this->data['protocol'],
            ]);

            //build recipient filter
            $options = ['' => $that->language->get('text_manually_send')];

            $db_filter = ['status' => 1, 'approved' => 1];
            if ($this->data['protocol'] == 'sms') {
                $db_filter['filter']['only_with_mobile_phones'] = 1;
            }

            $newsletterDbFilter = $db_filter;
            $newsletterDbFilter['filter']['newsletter_protocol'] = $this->data['protocol'];

            $all_subscribers_count = $that->model_sale_customer->getTotalAllSubscribers($newsletterDbFilter);
            if ($all_subscribers_count) {
                $options['all_subscribers'] = $that->language->get('text_all_subscribers').' '.sprintf($that->language->get('text_total_to_be_sent'), $all_subscribers_count);
            }

            $only_subscribers_count = $that->model_sale_customer->getTotalOnlyNewsletterSubscribers($newsletterDbFilter);
            if ($only_subscribers_count) {
                $options['only_subscribers'] = $that->language->get('text_subscribers_only').' '.sprintf($that->language->get('text_total_to_be_sent'), $only_subscribers_count);
            }

            $only_customers_count = $that->model_sale_customer->getTotalOnlyCustomers($db_filter);
            if ($only_customers_count) {
                $options['only_customers'] = $that->language->get('text_customers_only').' '.sprintf($that->language->get('text_total_to_be_sent'), $only_customers_count);
            }

            $options['ordered'] = $that->language->get('text_customers_who_ordered');

            $this->data['form']['fields']['notify_admin'] = $form->getFieldHtml([
                'type' => 'checkbox',
                'name' => 'notify_admin',
                'value' => $this->data['notify_admin'],
                'style'  => 'btn_switch',
            ]);

            $this->data['entry_notify_admin'] = $that->language->get('text_notify_admin');

            $this->data['form']['fields']['sender_name'] = $form->getFieldHtml([
                'type' => 'input',
                'name' => 'sender_name',
                'value' => $this->data['sender_name'],
            ]);

            $this->data['entry_sender_name'] = $that->language->get('text_sender_name');

            $this->data['form']['fields']['sender_email'] = $form->getFieldHtml([
                'type' => 'input',
                'name' => 'sender_email',
                'value' => $this->data['sender_email'],
            ]);

            $this->data['entry_sender_email'] = $that->language->get('text_sender_email');

            $this->data['form']['fields']['to'] = $form->getFieldHtml([
                'type'     => 'selectbox',
                'name'     => 'recipient',
                'value'    => $this->data['recipient'],
                'options'  => $options,
                'required' => true,
            ]);

            $this->data['recipients_count_url'] = $that->html->getSecureURL('r/sale/contact/getRecipientsCount');

            $this->data['form']['fields']['customers'] = $form->getFieldHtml([
                'type'        => 'multiselectbox',
                'name'        => 'to[]',
                'value'       => $customer_ids,
                'options'     => $this->data['customers'],
                'style'       => 'chosen',
                'ajax_url'    => $that->html->getSecureURL('r/listing_grid/customer/customers'),
                'placeholder' => $that->language->get('text_customers_from_lookup'),
            ]);

            $this->data['form']['fields']['product'] = $form->getFieldHtml([
                'type'        => 'multiselectbox',
                'name'        => 'products[]',
                'value'       => $product_ids,
                'options'     => $this->data['products'],
                'style'       => 'chosen',
                'ajax_url'    => $that->html->getSecureURL('r/product/product/products'),
                'placeholder' => $that->language->get('text_products_from_lookup'),
            ]);

            if ($this->data['protocol'] == 'email') {
                $this->data['form']['fields']['subject'] = $form->getFieldHtml([
                    'type'     => 'input',
                    'name'     => 'subject',
                    'value'    => $this->data['subject'],
                    'required' => true,
                ]);
            }

            $this->data['form']['fields']['message'] = $form->getFieldHtml([
                'type'     => ($this->data['protocol'] == 'email' ? 'texteditor' : 'textarea'),
                'name'     => 'message',
                'value'    => $this->data['message'] ? $this->data['message'] : '{customer_firstname} {customer_lastname}',
                'style'    => 'ml_ckeditor',
                'required' => true,
                'base_url' => $that->model_setting_store->getStoreURL($this->data['store_id']),
            ]);
            $that->load->language('email_editor/email_editor');
            $that->load->model('extension/email_signatures');
            $email_sigs=$that->model_extension_email_signatures->getAvailableSignatures();

            $signatures['0']="NONE";
            foreach ($email_sigs as $sigs) {
                $signatures[$sigs['email_signature_id']] = $sigs['title'];
            }
            $this->data['form']['build_task_url'] = $that->html->getSecureURL('r/extension/contact/buildTask');
            $this->data['form']['complete_task_url'] = $that->html->getSecureURL('r/extension/contact/complete');
            $this->data['form']['abort_task_url'] = $that->html->getSecureURL('r/extension/contact/abort');

            $this->data['form']['fields']['email_signature'] = $form->getFieldHtml([
                'type' => 'selectbox',
                'name' => 'email_signature',
                'options' => $signatures,
                'value' => $this->data['email_signature_id'],
                'required' => true]);
            $this->data['entry_email_signature'] = $that->language->get('text_select_email_signatures');

            $this->data['getSignature']=$that->html->getSecureURL('r/extension/email_editor/getSignatureById');

            $logo = $this->dispatch('pages/extension/preview_email_logo',[]);
            $this->data['logo']=html_entity_decode($logo->dispatchGetOutput());

            $this->data['base'] = (HTTPS_SERVER) ? HTTPS_SERVER : HTTP_SERVER;

            $this->data['text_contact_customer_name']  =$that->language->get('text_contact_customer_name');
            $that->view->batchAssign($this->data);
            $that->processTemplate('pages/extension/contact.tpl');
        }
    }

    public function onControllerPagesAccountCreate_InitData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;

        $request_data = $that->request->post;

        if (isset($that->request->get['group_id'])) {
            $customer_group_id = (int)$that->request->get['group_id'];
            $that->data['action'] = $that->html->getSecureURL('account/create','&group_id='.$customer_group_id);
            $request_data['customer_group_id'] = $customer_group_id;
        } else {
            $customer_group_id = (int)$that->config->get('config_customer_group_id');
            $request_data['customer_group_id'] = $customer_group_id;
        }

        $that->load->model('extension/email_editor','storefront');
        $that->load->model('account/customer');
        if ($this->verifyCustGroup()) {
            $that->load->model('extension/customer_group_auto_assigned');
        }
        if ($this->baseObject_method==='main') {
            if ($that->request->is_POST()) {
                $that->errors = [];
                if ($this->verifyTaxId()) {
                    $that->loadModel('account/taxid_option');
                    $that->errors = array_merge(
                        $this->errors,
                        $that->model_account_taxid_option->validateAdditionalValuesForCreate($request_data)
                    );
                } else {
                    $that->errors = array_merge(
                        $this->errors,
                        $that->model_account_customer->validateRegistrationData($request_data)
                    );
                }
                if (!$that->errors) {
                    //if allow login as email, need to set loginname = email
                    if (!$that->config->get('prevent_email_as_login')) {
                        $request_data['loginname'] = $request_data['email'];
                    }

                    if ($this->verifyCustGroup()) {
                        $customer_group_info = $that->model_extension_customer_group_auto_assigned->getValues($customer_group_id);
                        if ($customer_group_info) {
                            if ($customer_group_info['admin_approval'] === '0') {
                                $request_data['approved'] = '1';
                            }
                        }
                    }

                    if ($this->verifyTaxId()) {
                        $that->data['customer_id'] = $that->model_account_taxid_option->addCustomer( $request_data );
                        $that->model_account_customer->editCustomerNotifications( $request_data, $that->data['customer_id'] );
                        $that->model_account_taxid_option->addCustomerAdditionalValues( $that->data['customer_id'], $request_data );
                    } else {
                        $that->data['customer_id'] = $that->model_account_customer->addCustomer($request_data);
                        $that->model_account_customer->editCustomerNotifications($request_data, $that->data['customer_id']);
                    }
                    unset($that->session->data['guest']);

                    $customer_id = $that->data['customer_id'];
                    if ($this->verifyCustGroup()) {
                        $that->load->model('extension/customer_group_auto_assigned');
                        $customer_group_info = $that->model_extension_customer_group_auto_assigned->getValues($customer_group_id);
                        if ($customer_group_info['upload_tax_exemption'] === '1') {
                            $filename = $_FILES['upload_tax_exemption']['name'];
                            $temp_name = $_FILES['upload_tax_exemption']['tmp_name'];

                            $current_year = date('Y');
                            $current_month = date('m');
                            if ($filename) {
                                if (!file_exists(DIR_EXT . 'customer_group_auto_assigned/files/' . $customer_id)) {
                                    mkdir(DIR_EXT . 'customer_group_auto_assigned/files/' . $customer_id, 0755);
                                }

                                if (!file_exists(DIR_EXT . 'customer_group_auto_assigned/files/' . $customer_id . '/' . $current_year)) {
                                    mkdir(DIR_EXT . 'customer_group_auto_assigned/files/' . $customer_id . '/' . $current_year, 0755);
                                }
                                if (!file_exists(DIR_EXT . 'customer_group_auto_assigned/files/' . $customer_id . '/' . $current_year . '/' . $current_month)) {
                                    mkdir(DIR_EXT . 'customer_group_auto_assigned/files/' . $customer_id . '/' . $current_year . '/' . $current_month, 0755);
                                }

                                $upload_dir = DIR_EXT . 'customer_group_auto_assigned/files/' . $customer_id . '/' . $current_year . '/' . $current_month . '/';

                                // move file
                                $uploaded = move_uploaded_file($temp_name, $upload_dir . $filename);

                                if ($uploaded) {
                                    $data['image_url'] = 'files/' . $customer_id . '/' . $current_year . '/' . $current_month . '/' . $filename;
                                } else {
                                    $that->log->write('unable to upload file');
                                }
                            }

                            $data['customer_id'] = $customer_id;
                            $data['customer_group_id'] = $customer_group_id;
                            $data['expire'] = $request_data['expire'];
                            $data['expiration_date'] = $request_data['expiration_date'];
                            $that->model_extension_customer_group_auto_assigned->addInfo($data);
                        }
                    }

                    if ($this->verifyCustGroup()) {
                        $that->load->model('extension/customer_group_auto_assigned');
                        $customer_group_info = $that->model_extension_customer_group_auto_assigned->getValues($customer_group_id);
                        $search = [" ","'"];
                        $replace = "_";
                        $section = str_replace($search,$replace,$customer_group_info['customer_group_name']);
                        $custom_email = $customer_group_info['custom_email'] === '1' ? true : false;
                        if ($customer_group_info) {
                            if ($customer_group_info['admin_approval'] === '0') {
                                //add and send account activation link if required
                                if ($customer_group_info['email_activation'] === '1') {
                                    //send activation email request and wait for confirmation
                                    $that->model_extension_email_editor->emailActivateLink($customer_id,$section, $custom_email);
                                } else {
                                    //send welcome email
                                    $that->model_extension_email_editor->sendWelcomeEmail($that->request->post['email'], true,$section, $custom_email);
                                    //login customer after create account is approving and email activation are disabled in settings
                                    $that->customer->login($request_data['loginname'], $request_data['password']);
                                }
                            } else {
                                //send welcome email, but need manual approval
                                  $that->model_extension_email_editor->sendWelcomeEmail($that->request->post['email'], false,$section, $custom_email);
                            }
                            //set success text for non-approved customers on login page after redirect
                            if ($customer_group_info['admin_approval'] === '1') {
                                $that->loadLanguage('account/success');
                                $that->session->data['success'] = sprintf(
                                    $that->language->get('text_approval', 'account/success'),
                                    $that->config->get('store_name'),
                                    $that->html->getSecureURL('content/contact')
                                );
                            }

                            if ($customer_group_info['email_activation'] === '1' || !$that->session->data['redirect']) {
                                $redirect_url = $that->html->getSecureURL('account/success');
                            } else {
                                $redirect_url = $that->session->data['redirect'];
                            }

                            $that->session->data['customer_group_auto_assigned_settings'] = $customer_group_info;
                        } else {
                            if (!$that->config->get('config_customer_approval')) {
                                //add and send account activation link if required
                                if (!$that->config->get('config_customer_email_activation')) {
                                    //send welcome email
                                    $that->model_extension_email_editor->sendWelcomeEmail($that->request->post['email'], true);
                                    //login customer after create account is approving and email activation are disabled in settings
                                    $that->customer->login($request_data['loginname'], $request_data['password']);
                                } else {
                                    //send activation email request and wait for confirmation
                                    $that->model_extension_email_editor->emailActivateLink($that->data['customer_id']);
                                }
                            } else {
                                //send welcome email, but need manual approval
                                $that->model_extension_email_editor->sendWelcomeEmail($that->request->post['email'], false);
                            }

                            $that->extensions->hk_UpdateData($that, __FUNCTION__);

                            //set success text for non-approved customers on login page after redirect
                            if ($that->config->get('config_customer_approval')) {
                                $that->loadLanguage('account/success');
                                $that->session->data['success'] = sprintf($that->language->get('text_approval', 'account/success'),
                                    $that->config->get('store_name'),
                                    $that->html->getSecureURL('content/contact'));
                            }

                            if ($that->config->get('config_customer_email_activation') || !$that->session->data['redirect']) {
                                $redirect_url = $that->html->getSecureURL('account/success');
                            } else {
                                $redirect_url = $that->session->data['redirect'];
                            }
                        }
                    } else {
                        if (!$that->config->get('config_customer_approval')) {
                            //add and send account activation link if required
                            if (!$that->config->get('config_customer_email_activation')) {
                                //send welcome email
                                $that->model_extension_email_editor->sendWelcomeEmail($that->request->post['email'], true);
                                //login customer after create account is approving and email activation are disabled in settings
                                $that->customer->login($request_data['loginname'], $request_data['password']);
                            } else {
                                //send activation email request and wait for confirmation
                                $that->model_extension_email_editor->emailActivateLink($that->data['customer_id']);
                            }
                        } else {
                            //send welcome email, but need manual approval
                            $that->model_extension_email_editor->sendWelcomeEmail($that->request->post['email'], false);
                        }

                        $that->extensions->hk_UpdateData($that, __FUNCTION__);

                        //set success text for non-approved customers on login page after redirect
                        if ($that->config->get('config_customer_approval')) {
                            $that->loadLanguage('account/success');
                            $that->session->data['success'] = sprintf($that->language->get('text_approval', 'account/success'),
                                $that->config->get('store_name'),
                                $that->html->getSecureURL('content/contact'));
                        }

                        if ($that->config->get('config_customer_email_activation') || !$that->session->data['redirect']) {
                            $redirect_url = $that->html->getSecureURL('account/success');
                        } else {
                            $redirect_url = $that->session->data['redirect'];
                        }
                    }
                    redirect($redirect_url);
                }
            }
        }
    }

    public function onControllerPagesSaleCustomer_InitData() {
        if (!$this->_is_enabled()) {
            return null;
        }

        $that =& $this->baseObject;

        if ($this->baseObject_method==='update') {
            $customer_id = $that->request->get['customer_id'];
            $that->load->model('sale/customer');
            $that->load->model('extension/email_order');
            if ($that->request->is_POST() && $this->_validateSaleCustomerForm($customer_id)) {
                if ((int)$that->request->post['approved']) {
                    $customer_info = $that->model_sale_customer->getCustomer($customer_id);
                    if (!$customer_info['approved'] && !$that->model_sale_customer->isSubscriber($customer_id)) {
                        $that->model_extension_email_order->sendApproveMail($customer_id);
                    }
                }
                $that->model_sale_customer->editCustomer($that->request->get['customer_id'], $that->request->post);
                $redirect_url = $that->html->getSecureURL('sale/customer/update', '&customer_id='.$customer_id);
                $that->session->data['success'] = $that->language->get('text_success');
                redirect($redirect_url);
            }
        } elseif ($this->baseObject_method==='approve') {
            $that->load->model('sale/customer');
            $that->load->model('extension/email_order');
            $customer_id = $that->request->get['customer_id'];
            $that->model_sale_customer->editCustomerField($customer_id, 'approved', true);
            if (!$that->model_sale_customer->isSubscriber($customer_id)) {
                $that->model_extension_email_order->sendApproveMail($customer_id);
            }
        }
    }

    public function onControllerResponsesListingGridCustomer_InitData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'update_field') {
            $that->load->model('sale/customer');
            $that->load->model('extension/email_order');
            if ($that->request->is_POST()) {
                $customer_id = $that->request->get['id'];
                $address_id = $that->request->get['address_id'];
                $post_data = $that->request->post;
                if (isset($customer_id)) {
                    if ($post_data['password'] || $post_data['password_confirm']) {
                        $error = new AError('');
                        if (mb_strlen($post_data['password']) < 4) {
                            return $error->toJSONResponse('VALIDATION_ERROR_406',
                                [
                                    'error_text'  => $that->language->get('error_password'),
                                    'reset_value' => true,
                                ]);
                        }
                        if ($post_data['password'] != $post_data['password_confirm']) {
                            return $error->toJSONResponse('VALIDATION_ERROR_406',
                                [
                                    'error_text'  => $that->language->get('error_confirm'),
                                    'reset_value' => true,
                                ]);
                        }
                        //passwords do match, save
                        $that->model_sale_customer->editCustomerField($customer_id, 'password', $post_data['password']);
                    } else {
                        foreach ($post_data as $field => $value) {
                            $err = $this->_validateCustomerForm($field, $value, $customer_id);
                            if (!$err) {
                                if ($field === 'approved') {
                                    //send email when customer was not approved
                                    if ($value && !$that->model_sale_customer->isSubscriber($customer_id)) {
                                        $that->model_extension_email_order->sendApproveMail($customer_id);
                                    }
                                }
                                if ($field === 'default' && $address_id) {
                                    $that->model_sale_customer->setDefaultAddress($customer_id, $address_id);
                                } else {
                                    if (has_value($address_id)) {
                                        $that->model_sale_customer->editAddressField($address_id, $field, $value);
                                    } else {
                                        $that->model_sale_customer->editCustomerField($customer_id, $field, $value);
                                    }
                                }
                            } else {
                                $error = new AError('');
                                return $error->toJSONResponse('VALIDATION_ERROR_406',
                                    [
                                        'error_text'  => $err,
                                        'reset_value' => false,
                                    ]);
                            }
                        }
                    }
                    //update controller data
                    $that->extensions->hk_UpdateData($this, __FUNCTION__);
                    return null;
                }

                //request sent from jGrid. ID is key of array
                foreach ($post_data as $field => $value) {
                    if (is_array($value)) {
                        foreach ($value as $k => $v) {
                            $err = $this->_validateCustomerForm($field, $v);
                            if (!$err) {
                                if ($field === 'approved') {
                                    if ($v && !$that->model_sale_customer->isSubscriber($k)) {
                                        //send email when customer was not approved
                                        $that->model_extension_email_order->sendApproveMail($k);
                                    }
                                }
                                $that->model_sale_customer->editCustomerField($k, $field, $v);
                            } else {
                                $error = new AError('');
                                return $error->toJSONResponse('VALIDATION_ERROR_406',
                                    [
                                        'error_text' => $err,
                                        'reset_value' => false,
                                    ]);
                            }
                        }
                    }
                }
            }
        } elseif ($this->baseObject_method==='update') {
            $that->load->model('sale/customer');
            $that->load->model('extension/email_order');
            switch ($that->request->post['oper']) {
                case 'del':
                    $ids = explode(',', $that->request->post['id']);
                    if (!empty($ids)) {
                        foreach ($ids as $id) {
                            $that->model_sale_customer->deleteCustomer($id);
                        }
                    }
                    break;
                case 'save':
                    $ids = explode(',', $that->request->post['id']);
                    if (!empty($ids)) {
                        foreach ($ids as $id) {
                            $err = $this->_validateCustomerForm('status', $that->request->post['status'][$id], $id);
                            if (!$err) {
                                $that->model_sale_customer->editCustomerField($id, 'status', $that->request->post['status'][$id]);
                            } else {
                                $error = new AError('');
                                return $error->toJSONResponse('VALIDATION_ERROR_406',
                                    [
                                        'error_text'  => $err,
                                        'reset_value' => false,
                                    ]);
                            }
                            $do_approve = $that->request->post['approved'][$id];
                            $err = $this->_validateCustomerForm('approved', $do_approve, $id);
                            if (!$err) {
                                //if customer is not subscriber - send email
                                if ($do_approve && !$that->model_sale_customer->isSubscriber($id)) {
                                    //send email when customer was not approved
                                    $that->model_extension_email_order->sendApproveMail($id);
                                }
                                //do not change order of calls here!!!
                                $that->model_sale_customer->editCustomerField($id, 'approved', $do_approve);
                            } else {
                                $error = new AError('');
                                return $error->toJSONResponse('VALIDATION_ERROR_406',
                                    [
                                        'error_text'  => $err,
                                        'reset_value' => false,
                                    ]);
                            }
                        }
                    }
                    break;

                default:
            }
        }
    }
/**
    public function onControllerPagesAccountEdit_InitData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;

        if ($this->baseObject_method='main') {
            $that->load->model('account/customer');
            $that->load->model('extension/email_editor');
            $request_data = $that->request->post;
            if ($that->request->is_POST()) {
                if ($that->csrftoken->isTokenValid()) {
                if ($this->verifyTaxId()) {
                    $that->loadModel( 'account/taxid_option' );
                    $that->loadModel( 'account/customer' );
                    $that->error = $that->model_account_taxid_option->validateAdditionalValuesForEdit( $that->request->post );
                } else {
                    $that->error = $that->model_account_customer->validateEditData($request_data);
                }
                    //if no update for loginname do not allow edit of username/loginname
                    if (!$that->customer->isLoginnameAsEmail()) {
                        $request_data['loginname'] = null;
                    } else {
                        //if allow login as email, need to set loginname = email in case email changed
                        if (!$that->config->get('prevent_email_as_login')) {
                            $request_data['loginname'] = $request_data['email'];
                        }
                    }
                } else {
                    $that->error['warning'] = $that->language->get('error_unknown');
                }

                if (!$that->error) {
                    if ($this->verifyCustGroup()) {
                        $that->load->model('extension/customer_group_auto_assigned');
                        $customer_id = $that->customer->getId();
                        $customer_group_id = $that->customer->getCustomerGroupId();
                        $customer_group_info = $that->model_extension_customer_group_auto_assigned->getValues($customer_group_id);
                        if ($customer_group_info['upload_tax_exemption']==='1') {
                            $filename = $_FILES['upload_tax_exemption']['name'];
                            $temp_name = $_FILES['upload_tax_exemption']['tmp_name'];

                            $current_year = date('Y');
                            $current_month = date('m');
                            if ($filename) {
                                if (!file_exists(DIR_EXT . 'customer_group_auto_assigned/files/' . $customer_id)) {
                                    mkdir(DIR_EXT . 'customer_group_auto_assigned/files/' . $customer_id, 0755);
                                }

                                if (!file_exists(DIR_EXT . 'customer_group_auto_assigned/files/' . $customer_id . '/' . $current_year)) {
                                    mkdir(DIR_EXT . 'customer_group_auto_assigned/files/' . $customer_id . '/' . $current_year, 0755);
                                }
                                if (!file_exists(DIR_EXT . 'customer_group_auto_assigned/files/' . $customer_id . '/' . $current_year . '/' . $current_month)) {
                                    mkdir(DIR_EXT . 'customer_group_auto_assigned/files/' . $customer_id . '/' . $current_year . '/' . $current_month, 0755);
                                }

                                $upload_dir = DIR_EXT . 'customer_group_auto_assigned/files/' . $customer_id . '/' . $current_year . '/' . $current_month . '/';

                                // move file
                                $uploaded = move_uploaded_file($temp_name, $upload_dir . $filename);

                                if ($uploaded && $filename) {
                                    $data['image_url'] = 'files/' . $customer_id . '/' . $current_year . '/' . $current_month . '/' . $filename;
                                } else {
                                    //$that->log->write('Unable to upload file');
                                }
                            }
                            $data['customer_id'] = $customer_id;
                            $data['customer_group_id'] = $customer_group_id;
                            $data['expire'] = $that->request->post['expire'];
                            $data['expiration_date'] = $that->request->post['expiration_date'];
                            $that->model_extension_customer_group_auto_assigned->addInfo($data);
                        }
                    }

                    $that->model_account_customer->editCustomer($request_data);
                    $that->model_account_customer->editCustomerNotifications($request_data);
                    $that->session->data['success'] = $that->language->get('text_success');
                    $that->extensions->hk_ProcessData($this);
                    redirect($that->html->getSecureURL('account/account'));
                }
            }
        }
    }
**/
    public function onControllerPagesAccountLogin_InitData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;

        if ($this->baseObject_method='main') {
            if (has_value($that->request->get['ac'])) {
                //activation of account via email-code.
                $enc = new AEncryption($that->config->get('encryption_key'));
                list($customer_id, $activation_code) = explode("::", $enc->decrypt($that->request->get['ac']));
                if ($customer_id && $activation_code) {
                    //get customer
                    $that->loadModel('account/customer');
                    $that->load->model('extension/email_editor');
                    $customer_info = $that->model_account_customer->getCustomer((int)$customer_id);
                    if ($customer_info) {
                        //if activation code presents in data and matching
                        if ($activation_code == $customer_info['data']['email_activation']) {
                            unset($customer_info['data']['email_activation']);
                            if (!$customer_info['status']) {
                                //activate now!
                                $that->model_account_customer->editStatus($customer_id, 1);
                                //update data and remove email_activation code
                                $that->model_account_customer->updateOtherData($customer_id, $customer_info['data']);
                                //send welcome email
                                $that->model_extension_email_editor->sendWelcomeEmail($customer_info['email'], true);
                                $that->session->data['success'] = $that->language->get('text_success_activated');
                            } else {
                                //update data and remove email_activation code
                                $that->model_account_customer->updateOtherData($customer_id, $customer_info['data']);
                                $that->session->data['success'] = $that->language->get('text_already_activated');
                            }
                        } elseif (!$customer_info['data']['email_activation'] && $customer_info['status']) {
                            $that->session->data['success'] = $that->language->get('text_already_activated');
                        }
                    }
                }
            }
        }
    }

    public function onControllerPagesAccountForgotten_InitData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method==='password') {
            $customer_details = [];
            if ($that->request->is_POST() && $this->_find_customer('password', $customer_details)) {
                //extra check that we have customer details
                if (!empty($customer_details['email'])) {
                    $that->loadLanguage('mail/account_forgotten');
                    $that->load->model('extension/email_editor');
                    $customer_id = $customer_details['customer_id'];
                    $code = genToken(32);
                    //save password reset code
                    $that->model_account_customer->updateOtherData($customer_id, ['password_reset' => $code]);
                    //build reset link
                    $enc = new AEncryption($that->config->get('encryption_key'));
                    $rtoken = $enc->encrypt($customer_id.'::'.$code);

                    //do the trick for correct url
                    $embed_mode = $this->registry->get('config')->get('embed_mode');
                    $this->registry->get('config')->set('embed_mode', false);
                    $link = $that->html->getSecureURL('account/forgotten/reset', '&rtoken=' . $rtoken);
                    $link = '<a href="'.$link .'" target="_BLANK">'.$link.'</a>';
                    $this->registry->get('config')->set('embed_mode', $embed_mode);

                    $details= $that->model_extension_email_editor->getDetails('account_reset_password');
                    $sender_name=$details['sender_name'] ? $details['sender_name']:$that->config->get('store_name');
                    $sender_email=$details['sender_email'] ? $details['sender_email']:$that->config->get('store_main_email');
                    $signature=html_entity_decode($details['signature']);

                    $subject = str_replace('{store_name}', $that->config->get('store_name'),$details['subject']);
                    $search=['{store_name}','{reset_password}'];
                    $replace=[$that->config->get('store_name'),$link];

                    $logos = $this->dispatch('pages/extension/email_logo',array());
                    $this->data['mail_template_data']['logo']=$logos->dispatchGetOutput();

                    $content = html_entity_decode(str_replace($search,$replace,$details['content']));

                    $this->data['mail_template_data']['content']=$content;
                    $this->data['mail_template_data']['signature']=$signature;
                    $this->data['mail_template'] = DIR_EXT.'email_editor'.DIR_EXT_CORE.'lib/account_forgotten.tpl';


                    $notify_admin=$details['notify_admin'];
                    $view = new AView($this->registry, 0);
                    $view->batchAssign($this->data['mail_template_data']);
                    $html_body = $view->fetch($this->data['mail_template']);

                    $this->_send_email($customer_details['email'],
                        [
                            'subject'          => $subject,
                            'sender_email'     => $sender_email,
                            'sender_name'      => $sender_name,
                            'txt_body'         => $this->data['mail_plain_text'],
                            'html_body'        => $html_body,
                            'notify_admin'     => $notify_admin
                        ]
                    );

                    $that->session->data['success'] = $that->language->get('text_success');
                    redirect($that->html->getSecureURL('account/login'));
                }
            }
        } elseif ($this->baseObject_method==='reset') {
            $that->loadModel('account/customer');
            $that->load->model('extension/email_editor');
            //validate token
            $rtoken = $that->request->get['rtoken'];
            $enc = new AEncryption($that->config->get('encryption_key'));
            list($customer_id, $code) = explode("::", $enc->decrypt($rtoken));
            $customer_details = $that->model_account_customer->getCustomer($customer_id);
            if ($that->request->is_POST() && $this->_validatePassword()) {
                //extra check that we have customer details
                if (!empty($customer_details['email'])) {
                    $that->loadLanguage('mail/account_forgotten');

                    $that->model_account_customer->editPassword($customer_details['loginname'], $that->request->post['password']);

                    $details= $that->model_extension_email_editor->getDetails('account_reset_password_success');

                    $sender_name=$details['sender_name'] ? $details['sender_name']:$that->config->get('store_name');
                    $sender_email=$details['sender_email'] ? $details['sender_email']:$that->config->get('store_main_email');
                    $signature=html_entity_decode($details['signature']);

                    $subject = str_replace('{store_name}', $that->config->get('store_name'),$details['subject']);

                    $logos = $this->dispatch('pages/extension/email_logo',array());
                    $this->data['mail_template_data']['logo']=$logos->dispatchGetOutput();

                    $content = html_entity_decode(str_replace('{store_name}', $that->config->get('store_name'),$details['content']));
                    $this->data['mail_template_data']['content']=$content;
                    $this->data['mail_template_data']['signature']=$signature;
                    $this->data['mail_template'] = DIR_EXT.'email_editor'.DIR_EXT_CORE.'lib/account_forgotten.tpl';
                    $notify_admin=$details['notify_admin'];
                    $view = new AView($this->registry, 0);
                    $view->batchAssign($this->data['mail_template_data']);
                    $html_body = $view->fetch($this->data['mail_template']);

                    $this->_send_email($customer_details['email'],
                        [
                            'subject'          => $subject,
                            'sender_email'     => $sender_email,
                            'sender_name'      => $sender_name,
                            'txt_body'         => $this->data['mail_plain_text'],
                            'html_body'        => $html_body,
                            'notify_admin'     => $notify_admin
                        ]
                    );

                    //update data and remove password_reset code
                    unset($customer_details['data']['password_reset']);
                    $that->model_account_customer->updateOtherData($customer_id, $customer_details['data']);

                    $that->session->data['success'] = $that->language->get('text_success');
                    redirect($that->html->getSecureURL('account/login'));
                }
            }
        } elseif ($this->baseObject_method==='loginname') {
            $that->loadModel('account/customer');
            $that->load->model('extension/email_editor');
            $customer_details = [];
            if ($that->request->is_POST() && $this->_find_customer('loginname', $customer_details)) {
                //extra check that we have customer details
                if (!empty($customer_details['email'])) {
                    $that->loadLanguage('mail/account_forgotten_login');

                    $details= $that->model_extension_email_editor->getDetails('account_loginname_reminder');

                    $sender_name=$details['sender_name'] ? $details['sender_name']:$that->config->get('store_name');
                    $sender_email=$details['sender_email'] ? $details['sender_email']:$that->config->get('store_main_email');
                    $signature=html_entity_decode($details['signature']);

                    $subject = str_replace('{store_name}', $that->config->get('store_name'),$details['subject']);

                    $logos = $this->dispatch('pages/extension/email_logo',array());
                    $this->data['mail_template_data']['logo']=$logos->dispatchGetOutput();

                    $search=['{store_name}','{loginname}'];
                    $replace=[$that->config->get('store_name'),$customer_details['loginname']];
                    $content = html_entity_decode(str_replace($search, $replace,$details['content']));

                    $this->data['mail_template_data']['content']=$content;
                    $this->data['mail_template_data']['signature']=$signature;
                    $this->data['mail_template'] = DIR_EXT.'email_editor'.DIR_EXT_CORE.'lib/account_forgotten.tpl';

                    $notify_admin=$details['notify_admin'];
                    $view = new AView($this->registry, 0);
                    $view->batchAssign($this->data['mail_template_data']);
                    $html_body = $view->fetch($this->data['mail_template']);
                    $this->_send_email($customer_details['email'],
                        [
                            'subject'          => $subject,
                            'sender_email'     => $sender_email,
                            'sender_name'      => $sender_name,
                            'txt_body'         => $this->data['mail_plain_text'],
                            'html_body'        => $html_body,
                            'notify_admin'     => $notify_admin
                        ]
                    );

                    $that->session->data['success'] = $that->language->get('text_success_loginname');
                    redirect($that->html->getSecureURL('account/login'));
                }
            }
        }
    }

    public function beforeModelCheckoutOrder_confirm($order_id, $order_status_id, $comment = '') {
        if (!$this->_is_enabled()) {
            return null;
        }

        $that =& $this->baseObject;
        $that->load->model('extension/email_editor');

        $order_query = $that->db->query("SELECT *,
                                                l.filename AS filename,
                                                l.directory AS directory
                                         FROM `".$that->db->table("orders")."` o
                                         LEFT JOIN ".$that->db->table("languages")." l
                                            ON (o.language_id = l.language_id)
                                         WHERE o.order_id = '".(int)$order_id."'
                                                AND o.order_status_id = '0'");
        if (!$order_query->num_rows) {
            return false;
        }
        $order_row = $that->dcrypt->decrypt_data($order_query->row, 'orders');
        $update = [];

        //update order status
        $update[] = "order_status_id = '".(int)$order_status_id."'";
        $sql = "UPDATE `".$that->db->table("orders")."`
                SET ".implode(", ", $update)."
                WHERE order_id = '".(int)$order_id."'";
        $that->db->query($sql);

        //record history
        $that->db->query("INSERT INTO ".$that->db->table("order_history")."
                           SET order_id = '".(int)$order_id."',
                                order_status_id = '".(int)$order_status_id."',
                                notify = '1',
                                comment = '".$that->db->escape($comment)."',
                                date_added = NOW()");
        $order_row['comment'] = $order_row['comment'].' '.$comment;

        $order_product_query = $that->db->query("SELECT *
                                                 FROM ".$that->db->table("order_products")."
                                                 WHERE order_id = '".(int)$order_id."'");
        // load language for IM
        $language = new ALanguage($this->registry);
        $language->load($language->language_details['directory']);
        $language->load('common/im');
        //update products inventory
        foreach ($order_product_query->rows as $product) {
            $order_option_query = $that->db->query("SELECT op.*, pov.subtract
                                                    FROM ".$that->db->table("order_options")." op
                                                    LEFT JOIN ".$that->db->table("product_option_values")." pov
                                                        ON pov.product_option_value_id = op.product_option_value_id
                                                    WHERE op.order_id = '".(int)$order_id."'
                                                       AND op.order_product_id = '".(int)$product['order_product_id']."'");
            //update options stock
            $stock_updated = false;

            foreach ($order_option_query->rows as $option) {
                $that->db->query("UPDATE ".$that->db->table("product_option_values")."
                                  SET quantity = (quantity - ".(int)$product['quantity'].")
                                  WHERE product_option_value_id = '".(int)$option['product_option_value_id']."'
                                        AND subtract = 1");
                if($option['subtract']) {
                    $this->saveOrderProductStocks(
                        $that,
                        $product['order_product_id'],
                        $product['product_id'],
                        $option['product_option_value_id'],
                        $product['quantity']
                    );
                    $stock_updated = true;
                }

                $sql = "SELECT quantity
                        FROM ".$that->db->table("product_option_values")."
                        WHERE product_option_value_id = '".(int)$option['product_option_value_id']."'
                            AND subtract = 1";
                $res = $that->db->query($sql);
                if ($res->num_rows && $res->row['quantity'] <= 0) {
                    //notify admin with out of stock for option based product
                    $message_arr = [
                        1 => [
                            'message' => sprintf($language->get('im_product_out_of_stock_admin_text'),
                                $product['product_id']),
                        ],
                    ];
                    $that->load->model('catalog/product');
                    $stock = $that->model_catalog_product->hasAnyStock((int)$product['product_id']);
                    if ($stock <= 0 && $that->config->get('config_nostock_autodisable') && (int)$product['product_id']) {
                        $that->db->query('UPDATE '.$that->db->table('products').' SET status=0 WHERE product_id='.(int)$product['product_id']);
                    }
                    $that->im->send('product_out_of_stock', $message_arr, 'storefront_product_out_of_stock_admin_notify', $product);
                }
            }

            if (!$stock_updated) {
                $that->db->query("UPDATE ".$that->db->table("products")."
                                  SET quantity = (quantity - ".(int)$product['quantity'].")
                                  WHERE product_id = '".(int)$product['product_id']."' AND subtract = 1");
                $this->saveOrderProductStocks($that,
                    $product['order_product_id'],
                    $product['product_id'],
                    null,
                    $product['quantity']
                );

                //check quantity and send notification when 0 or less
                $sql = "SELECT quantity
                        FROM ".$that->db->table("products")."
                        WHERE product_id = '".(int)$product['product_id']."' AND subtract = 1";
                $res = $that->db->query($sql);
                if ($res->num_rows && $res->row['quantity'] <= 0) {
                    //notify admin with out of stock
                    $message_arr = [
                        1 => [
                            'message' => sprintf($language->get('im_product_out_of_stock_admin_text'),
                                $product['product_id']),
                        ],
                    ];
                    $that->load->model('catalog/product');
                    $stock = $that->model_catalog_product->hasAnyStock((int)$product['product_id']);
                    if ($stock <= 0 && $that->config->get('config_nostock_autodisable') && (int)$product['product_id']) {
                        $that->db->query('UPDATE '.$that->db->table('products').' SET status=0 WHERE product_id='.(int)$product['product_id']);
                    }
                    $that->im->send('product_out_of_stock', $message_arr,  'storefront_product_out_of_stock_admin_notify', $product);
                }
            }
        }

        //clean product cache as stock might have changed.
        $that->cache->remove('product');

        //build confirmation email
        $language = new ALanguage($this->registry, $order_row['code']);
        $language->load($order_row['filename']);
        $language->setCurrentLanguage();
        $language->load('mail/order_confirm');
        $languageId = $language->getLanguageID();

        $that->load->model('localisation/currency');
        $order_product_query = $that->db->query("SELECT *
                                                FROM ".$that->db->table("order_products")."
                                                WHERE order_id = '".(int)$order_id."'");
        $order_total_query = $that->db->query("SELECT *
                                                FROM ".$that->db->table("order_totals")."
                                                WHERE order_id = '".(int)$order_id."'
                                                ORDER BY sort_order ASC");

        // HTML Mail
        $this->data['mail_template_data']['title'] = sprintf(
            $language->get('text_subject'),
            html_entity_decode($order_row['store_name'], ENT_QUOTES, 'UTF-8'),
            $order_id
        );
        $this->data['mail_template_data']['text_greeting'] = sprintf(
            $language->get('text_greeting'),
            html_entity_decode($order_row['store_name'], ENT_QUOTES, 'UTF-8')
        );
        $this->data['mail_template_data']['text_order_detail'] = $language->get('text_order_detail');
        $this->data['mail_template_data']['text_order_id'] = $language->get('text_order_id');
        $this->data['mail_template_data']['text_invoice'] = $language->get('text_invoice');
        $this->data['mail_template_data']['text_date_added'] = $language->get('text_date_added');
        $this->data['mail_template_data']['text_telephone'] = $language->get('text_telephone');
        $this->data['mail_template_data']['text_mobile_phone'] = $language->get('text_mobile_phone');

        $this->data['mail_template_data']['text_email'] = $language->get('text_email');
        $this->data['mail_template_data']['text_ip'] = $language->get('text_ip');
        $this->data['mail_template_data']['text_fax'] = $language->get('text_fax');
        $this->data['mail_template_data']['text_shipping_address'] = $language->get('text_shipping_address');
        $this->data['mail_template_data']['text_payment_address'] = $language->get('text_payment_address');
        $this->data['mail_template_data']['text_shipping_method'] = $language->get('text_shipping_method');
        $this->data['mail_template_data']['text_payment_method'] = $language->get('text_payment_method');
        $this->data['mail_template_data']['text_comment'] = $language->get('text_comment');
        $this->data['mail_template_data']['text_powered_by'] = $language->get('text_powered_by');
        $this->data['mail_template_data']['text_project_label'] = $language->get('text_powered_by').' '.project_base();

        $this->data['mail_template_data']['text_total'] = $language->get('text_total');
        $this->data['mail_template_data']['text_footer'] = $language->get('text_footer');

        $this->data['mail_template_data']['column_product'] = $language->get('column_product');
        $this->data['mail_template_data']['column_model'] = $language->get('column_model');
        $this->data['mail_template_data']['column_quantity'] = $language->get('column_quantity');
        $this->data['mail_template_data']['column_price'] = $language->get('column_price');
        $this->data['mail_template_data']['column_total'] = $language->get('column_total');

        $this->data['mail_template_data']['order_id'] = $order_id;
        $this->data['mail_template_data']['customer_id'] = $order_row['customer_id'];
        $this->data['mail_template_data']['date_added'] =
            dateISO2Display($order_row['date_added'], $language->get('date_format_short'));

        $logos = $this->dispatch('pages/extension/email_logo',array());
        $this->data['mail_template_data']['logo']=$logos->dispatchGetOutput();
        $this->data['mail_template_data']['store_name'] = $order_row['store_name'];
        $this->data['mail_template_data']['address'] = nl2br($that->config->get('config_address'));
        $this->data['mail_template_data']['telephone'] = $that->config->get('config_telephone');
        $this->data['mail_template_data']['fax'] = $that->config->get('config_fax');
        $this->data['mail_template_data']['email'] = $that->config->get('store_main_email');
        $this->data['mail_template_data']['store_url'] = $order_row['store_url'];

        //give link on order page for quest
        if ($that->config->get('config_guest_checkout') && $order_row['email']) {
            $enc = new AEncryption($that->config->get('encryption_key'));
            $order_token = $enc->encrypt($order_id.'::'.$order_row['email']);
            $this->data['mail_template_data']['invoice'] = $order_row['store_url']
                .'index.php?rt=account/invoice&ot='.$order_token."\n\n";
        }//give link on order for registered customers
        elseif ($order_row['customer_id']) {
            $this->data['mail_template_data']['invoice'] = $order_row['store_url']
                .'index.php?rt=account/invoice&order_id='.$order_id;
        }

        $invoice_url = "<a href='".$this->data['mail_template_data']['invoice']."' target='_blank'>".$this->data['mail_template_data']['invoice']."</a>";
        $this->data['mail_template_data']['firstname'] = $order_row['firstname'];
        $this->data['mail_template_data']['lastname'] = $order_row['lastname'];
        $this->data['mail_template_data']['shipping_method'] = $order_row['shipping_method'];
        $this->data['mail_template_data']['payment_method'] = $order_row['payment_method'];
        $this->data['mail_template_data']['customer_email'] = $order_row['email'];
        $this->data['mail_template_data']['customer_telephone'] = $order_row['telephone'];
        $this->data['mail_template_data']['customer_mobile_phone'] = $that->im->getCustomerURI(
            'sms',
            (int)$order_row['customer_id'], $order_id
        );
        if ( $this->verifyTaxID()) {
            $this->data['mail_template_data']['customer_fax'] = $order_row['fax'] === 'na' || $order_row['fax'] === 'none' ? '' : $order_row['fax'];
        } else {
            $this->data['mail_template_data']['customer_fax'] = $order_row['fax'];
        }
        $this->data['mail_template_data']['customer_ip'] = $order_row['ip'];
        $this->data['mail_template_data']['comment'] = trim(nl2br(html_entity_decode($order_row['comment'], ENT_QUOTES,'UTF-8')));

        //override with the data from the before hooks
        if ($this->data) {
            $this->data['mail_template_data'] = array_merge($this->data['mail_template_data'], $this->data);
        }

        $that->load->model('localisation/zone');
        $zone_row = $that->model_localisation_zone->getZone($order_row['shipping_zone_id']);
        if ($zone_row) {
            $zone_code = $zone_row['code'];
        } else {
            $zone_code = '';
        }

        $payment_zone_row = $that->model_localisation_zone->getZone($order_row['payment_zone_id']);

        if ($payment_zone_row) {
            $payment_zone_code = $payment_zone_row['code'];
        } else {
            $payment_zone_code = '';
        }

        if ($this->verifyTelephone()) {
            $shipping_data = [
                'firstname' => $order_row['shipping_firstname'],
                'lastname'  => $order_row['shipping_lastname'],
                'company'   => strtolower($order_row['shipping_company']) === 'na' || strtolower($order_row['shipping_company']) === 'none' ? "" : $order_row['shipping_company'],
                'address_1' => $order_row['shipping_address_1'],
                'address_2' => $order_row['shipping_address_2'],
                'city'      => $order_row['shipping_city'],
                'postcode'  => $order_row['shipping_postcode'],
                'zone'      => $order_row['shipping_zone'],
                'zone_code' => $zone_code,
                'country'   => $order_row['shipping_country'],
            ];
            $shipping_address = $this->getFormattedAddress($shipping_data,'');
        } else {
            $shipping_data = [
                'firstname' => $order_row['shipping_firstname'],
                'lastname'  => $order_row['shipping_lastname'],
                'company'   => $order_row['shipping_company'],
                'address_1' => $order_row['shipping_address_1'],
                'address_2' => $order_row['shipping_address_2'],
                'city'      => $order_row['shipping_city'],
                'postcode'  => $order_row['shipping_postcode'],
                'zone'      => $order_row['shipping_zone'],
                'zone_code' => $zone_code,
                'country'   => $order_row['shipping_country'],
            ];
            $shipping_address = $that->customer->getFormattedAddress($shipping_data, $order_row['shipping_address_format']);
        }

        $this->data['mail_template_data']['shipping_data'] = $shipping_data;
        $this->data['mail_template_data']['shipping_address'] = $shipping_address;
        if ($this->verifyTaxId()) {
            $this->data['mail_template_data']['taxid_status'] = true;
            if ($that->config->get('taxid_show_seller_info')==='1') {
                $that->load->language('account/taxid_option');
                $this->data['mail_template_data']['seller_show_info'] = '1';
                $this->data['mail_template_data']['text_ordered'] = $that->language->get('text_ordered');
                $this->data['mail_template_data']['seller_info'] = html_entity_decode(nl2br($that->config->get('taxid_seller_info')));
            }

            $payment_data = [
                'firstname' => $order_row['payment_firstname'],
                'lastname' => $order_row['payment_lastname'],
                'company' => $order_row['payment_company'],
                'taxid' => $order_row['taxid'],
                'address_1' => $order_row['payment_address_1'],
                'address_2' => $order_row['payment_address_2'],
                'city' => $order_row['payment_city'],
                'postcode' => $order_row['payment_postcode'],
                'zone' => $order_row['payment_zone'],
                'zone_code' => $order_row['payment_zone_code'],
                'country' => $order_row['payment_country'],
                'registration' => $order_row['registration'],
                'bank_name' => $order_row['bank_name'],
                'bank_address' => $order_row['bank_address'],
                'iban' => $order_row['iban'],
                'swift' => $order_row['swift']
            ];
            $payment_address = $this->getFormattedAddress($payment_data,'payment');
        } elseif ($this->verifyTelephone()) {
            $payment_data = [
                'firstname' => $order_row['payment_firstname'],
                'lastname'  => $order_row['payment_lastname'],
                'company'   => strtolower($order_row['payment_company']) === 'na' || strtolower($order_row['payment_company']) === 'none' ? "" : $order_row['payment_company'],
                'address_1' => $order_row['payment_address_1'],
                'address_2' => $order_row['payment_address_2'],
                'city'      => $order_row['payment_city'],
                'postcode'  => $order_row['payment_postcode'],
                'zone'      => $order_row['payment_zone'],
                'zone_code' => $payment_zone_code,
                'country'   => $order_row['payment_country'],
            ];
            $payment_address = $this->getFormattedAddress($payment_data,'payment');
        } else {
            $payment_data = [
                'firstname' => $order_row['payment_firstname'],
                'lastname'  => $order_row['payment_lastname'],
                'company'   => $order_row['payment_company'],
                'address_1' => $order_row['payment_address_1'],
                'address_2' => $order_row['payment_address_2'],
                'city'      => $order_row['payment_city'],
                'postcode'  => $order_row['payment_postcode'],
                'zone'      => $order_row['payment_zone'],
                'zone_code' => $payment_zone_code,
                'country'   => $order_row['payment_country'],
            ];
            $payment_address = $that->customer->getFormattedAddress($payment_data,$order_row['payment_address_format']);
        }

        $this->data['mail_template_data']['payment_data'] = $payment_data;
        $this->data['mail_template_data']['payment_address'] = $payment_address;
        if (!has_value($this->data['products'])) {
            $this->data['products'] = [];
        }

        foreach ($order_product_query->rows as $product) {
            $option_data = [];

            $order_option_query = $that->db->query(
                "SELECT oo.*, po.element_type, p.sku, p.product_id
                    FROM ".$that->db->table("order_options")." oo
                    LEFT JOIN ".$that->db->table("product_option_values")." pov
                        ON pov.product_option_value_id = oo.product_option_value_id
                    LEFT JOIN ".$that->db->table("product_options")." po
                        ON po.product_option_id = pov.product_option_id
                    LEFT JOIN ".$that->db->table("products")." p
                        ON p.product_id = po.product_id
                    WHERE oo.order_id = '".(int)$order_id."' AND oo.order_product_id = '"
                .(int)$product['order_product_id']."'");

            foreach ($order_option_query->rows as $option) {
                if ($option['element_type'] == 'H') {
                    continue;
                } //skip hidden options
                elseif ($option['element_type'] == 'C' && in_array($option['value'], [0, 1, ''])) {
                    $option['value'] = '';
                }
                if ($this->verifyOptionLink()) {
                    $that->load->model('option_price_link_pro/util');
                    if ($option['link']) {
                        $option_data[] = [
                            'name' => $option['name'],
                            'value' => $option['value'],
                            'link' => $that->model_option_price_link_pro_util->autolink($option['link'], ["target" => "_blank"])
                        ];
                    } else {
                        $option_data[] = [
                            'name' => $option['name'],
                            'value' => $option['value']
                        ];
                    }
                } else {
                    $option_data[] = [
                        'name' => $option['name'],
                        'value' => $option['value'],
                    ];
                }
            }

            if ($this->verifyBuildAGift()) {
                $that->load->language('build_a_gift/build_a_gift');
                $that->load->model('build_a_gift/build_a_gift');
                $data['order_id'] = $order_id;
                $data['product_id'] = $product['product_id'];
                $child_products     = $that->model_build_a_gift_build_a_gift->getOrderProductsBag( $data );
                if ($child_products) {
                    foreach ( $child_products as $key => $child ) {
                        foreach ( $child as $k => $child_product ) {
                            if ( $child_product['prod_id'] && $child_product['prod_id'] !== '' ) {
                                foreach ( $child_product['prod_id'] as $key_pid => $p_qty ) {
                                    $pricing_type    = $child_product['pricing_type'];
                                    $child_prod_info = $that->model_build_a_gift_build_a_gift->getViewCartChildProducts( $key_pid, $p_qty, $pricing_type );
                                    $child_price     = 0;
                                    if ( $child_prod_info['price'] ) {
                                        $child_price = $child_prod_info['price'];
                                    }
                                    $thumb =$child_prod_info['image'];
                                    if (isset($child_products[ $key ][ $k ]['options']) && $child_products[ $key ][ $k ]['options']!=='') {
                                        foreach ( $child_products[ $key ][ $k ]['options'] as $options ) {
                                            if ( $options['image'] !== '' ) {
                                                $thumb = $options['image'];
                                                continue;
                                            }
                                        }
                                    }
                                    $child_products_data[ $product['product_id'] ][] = [
                                        'product_id'   => $key_pid,
                                        'pricing_type' => $pricing_type,
                                        'thumb'        => $thumb,
                                        'name'         => $child_prod_info['name'],
                                        'model'        => $child_prod_info['model'],
                                        'price'        => $child_price,
                                        'quantity'     => $p_qty * $product['quantity'],
                                        'message'      => $child_product[0][0]['message'],
                                        'href'         => $that->html->getURL( 'product/product', '&product_id=' . $key_pid ),
                                        'options'      => $child_products[ $key ][ $k ]['options']
                                    ];
                                }
                            }
                        }
                    }
                }

                $this->data['products'][] = [
                    'name'       => $product['name'],
                    'product_id' => $product['product_id'],
                    'sku'        => $product['sku'],
                    'model'      => $product['model'],
                    'option'     => $option_data,
                    'quantity'   => $product['quantity'],
                    'price'      => $that->currency->format($product['price'], $order_row['currency'], $order_row['value']),
                    'total'      => $that->currency->format_total($product['price'], $product['quantity'],
                        $order_row['currency'], $order_row['value']),
                    'message'          => $child_products[0][0]['message'],
                    'child_products'   => $child_products_data
                ];
                $this->data['mail_template_data']['text_included_with'] = $that->language->get('text_included_with');
                $this->data['mail_template_data']['text_message'] = $that->language->get('text_message');
            } else {
                $this->data['products'][] = [
                    'name'       => $product['name'],
                    'product_id' => $product['product_id'],
                    'sku'        => $product['sku'],
                    'model'      => $product['model'],
                    'option'     => $option_data,
                    'quantity'   => $product['quantity'],
                    'price'      => $that->currency->format($product['price'], $order_row['currency'], $order_row['value']),
                    'total'      => $that->currency->format_total($product['price'], $product['quantity'],
                        $order_row['currency'], $order_row['value']),
                ];
            }
        }
        $this->data['mail_template_data']['products'] = $this->data['products'];
        $this->data['mail_template_data']['totals'] = $order_total_query->rows;
        $order_products = $this->dispatch('pages/extension/order_products/order_products',[$this->data['mail_template_data']]);
        $order_details=$order_products->dispatchGetOutput();
        $details=$that->model_extension_email_editor->getDetails('order_confirmation');
        $notify_admin=$details['notify_admin'];

        $sender_name=$details['sender_name'] ? $details['sender_name']:$that->config->get('store_name');
        $sender_email=$details['sender_email'] ? $details['sender_email']:$that->config->get('store_main_email');
        $this->data['mail_template_data']['signature']=html_entity_decode($details['signature']);

        $searchSubject=['{store_name}','{order_id}'];
        $replaceSubject=[$that->config->get('store_name'),$order_id];
        $subject = str_replace($searchSubject, $replaceSubject,$details['subject']);

        $content=html_entity_decode($details['content']);
        preg_match_all("^\[(.*?)\]^",html_entity_decode($content),$fields);

        if (!empty(trim($order_row['comment']))) {
            $searchComment=[$fields[0][0],'{order_comment}'];
            $replaceComment=[
                '<div style="background-color: #069; color:#FFF; font-size: 12px; font-weight: bold; padding: 0.5em 1em;">'.$fields[1][0].'</div>',
                $order_row['comment']];
            $content=str_replace($searchComment,$replaceComment,$content);
        } else {
            $searchComment=[$fields[0][0],'{order_comment}'];
            $replaceComment=['',''];
            $content=str_replace($searchComment,$replaceComment,$content);
            $content=str_replace($this->getBetween($content,'{order_details}',$fields[0][1]),'',$content);
        }

        if (!empty(trim($invoice_url))) {
            $searchInvoice=[$fields[0][1],'{invoice_url}'];
            $replaceInvoice=['<div style="background-color: #069; color:#FFF; font-size: 12px; font-weight: bold; padding: 0.5em 1em;">'.$fields[1][1].'</div>',$invoice_url];
            $content=str_replace($searchInvoice,$replaceInvoice,$content);
        } else {
            $searchInvoice=[$fields[1][0],'{invoice_url}'];
            $replaceInvoice=['',''];
            $content=str_replace($searchInvoice,$replaceInvoice,$content);
        }

        $search=['{store_name}','{order_details}','{invoice_url}'];
        $replace=[$that->config->get('store_name'),$order_details,$invoice_url];
        $this->data['mail_template_data']['content'] = html_entity_decode(str_replace($search, $replace,$content));
        $this->data['mail_template'] = DIR_EXT.'email_editor'.DIR_EXT_CORE.'lib/order_confirm.tpl';

        $mailLogo = $that->config->get('config_mail_logo_'.$languageId)
            ?: $that->config->get('config_mail_logo');
        $mailLogo = $mailLogo ?: $that->config->get('config_logo_'.$languageId);
        $mailLogo = $mailLogo ?: $that->config->get('config_logo');
        $attachment = [];
        if (is_file(DIR_RESOURCE.$mailLogo)) {
            $attachment = [
                'file' => DIR_RESOURCE.$mailLogo,
                'name' => md5(pathinfo($mailLogo, PATHINFO_FILENAME))
                    .'.'
                    .pathinfo($mailLogo, PATHINFO_EXTENSION)
            ];

        }
        //allow to change email data from extensions
        $that->extensions->hk_ProcessData($this, 'sf_order_confirm_mail');

        $view = new AView($this->registry, 0);
        $view->batchAssign($this->data['mail_template_data']);
        $html_body = $view->fetch($this->data['mail_template']);

        //text email
        $this->data['mail_template'] = 'mail/order_confirm_text.tpl';

        //allow to change email data from extensions
        $that->extensions->hk_ProcessData($this, 'sf_order_confirm_mail_text');
        $this->data['mail_plain_text'] = $view->fetch($this->data['mail_template']);
        $this->data['mail_plain_text'] = html_entity_decode($this->data['mail_plain_text'], ENT_QUOTES, 'UTF-8');
        //remove html-tags
        $breaks = ["<br />", "<br>", "<br/>"];
        $this->data['mail_plain_text'] = str_ireplace($breaks, "\r\n", $this->data['mail_plain_text']);
        $languageId = $that->language->getContentLanguageID() ?? $that->language->getLanguageID();
        $this->_send_email($order_row['email'],
            [
                'subject'          => $subject,
                'sender_email'     => $sender_email,
                'sender_name'      => $sender_name,
                'txt_body'         => $this->data['mail_plain_text'],
                'html_body'        => $html_body,
            ]
        );

        //send alert email for merchant
        if ($that->config->get('config_alert_mail') || $notify_admin==='1') {
            $order_total = '';
            foreach ($order_total_query->rows as $row) {
                if ($row['key'] === 'total') {
                    $order_total = $row['text'];
                    break;
                }
            }

            $this->_send_email($that->config->get('store_main_email'),
                [
                    'subject'          => '(Copy) '.$subject.' ('.$order_total.')',
                    'sender_email'     => $sender_email,
                    'sender_name'      => $sender_name,
                    'txt_body'         => $this->data['mail_plain_text'],
                    'html_body'        => $html_body,
                ]
            );

            $emails = explode(',', $that->config->get('config_alert_emails'));
            foreach ($emails as $email) {
                if (trim($email)) {
                    $this->_send_email($email,
                        [
                            'subject'          => '(Copy) '.$subject.' ('.$order_total.')',
                            'sender_email'     => $sender_email,
                            'sender_name'      => $sender_name,
                            'txt_body'         => $this->data['mail_plain_text'],
                            'html_body'        => $html_body,
                        ]
                    );
                }
            }
        }

        $msg_text = sprintf($language->get('text_new_order_text'), $order_row['firstname'].' '.$order_row['lastname']);
        $msg_text .= "<br/><br/>";
        foreach ($this->data['mail_template_data']['totals'] as $total) {
            $msg_text .= $total['title'].' - '.$total['text']."<br/>";
        }
        $msg = new AMessage();
        $msg->saveNotice($language->get('text_new_order').$order_id, $msg_text);

        $language = new ALanguage($this->registry);
        $language->load($language->language_details['directory']);
        $language->load('common/im');
        $message_arr = [
            1 => ['message' => sprintf($language->get('im_new_order_text_to_admin'), $order_id)],
        ];
        $that->im->send(
            'new_order',
            $message_arr,
            'storefront_order_confirm_admin_notify',
            $this->data['mail_template_data'],
            $attachment ? [$attachment] : []
        );

        if ( $this->verifyTaxID() ) {
            $that->load->model( 'account/taxid_option' );
            $that->model_account_taxid_option->deleteAdditionalValuesById( 0 );
        }
    }

    //public function

    /**
	 * @param $that
	 * @param $order_product_id
	 * @param $product_id
	 * @param $product_option_value_id
	 * @param $order_quantity
	 *
	 * @return bool
	 */
	private function saveOrderProductStocks($that,$order_product_id, $product_id, $product_option_value_id, $order_quantity) {
		if(!$order_quantity){
			return false;
		}
		$stock_locations  = $this->getProductStockLocations($that,$product_id, $product_option_value_id);
		if(!$stock_locations){
			return false;
		}
		$remains = $order_quantity;
		$available_quantity = array_sum(array_column($stock_locations,'quantity'));

		//do not save when zero stock on all locations
		if(!$available_quantity){
			return false;
		}

		foreach($stock_locations as $row){
			//skip zero stock locations or non-trackable
			if(
				($available_quantity && !$row['quantity'])
				|| (!$product_option_value_id && !$row['product_subtract'])
				|| ($product_option_value_id && !$row['product_option_value_subtract'])
			){
				continue;
			}

			if($row['quantity']>=$remains){
				$new_qnty = $row['quantity'] - $remains;
				$quantity = $remains;
				$remains = 0;
			}else{
				$new_qnty = 0;
				$quantity = $row['quantity'];
				$remains -= $row['quantity'];
			}
			//update stocks
			$sql = "UPDATE ".$that->db->table("product_stock_locations")." 
                    SET quantity = ".(int)$new_qnty."
                    WHERE location_id= ".(int)$row['location_id']."
                     AND product_id = ".(int)$product_id
			       .((int)$product_option_value_id
					? " AND product_option_value_id='".(int)$product_option_value_id."' "
					: " AND product_option_value_id IS NULL");
			$that->db->query($sql);
			//save stocks into order details
			$that->db->query(
				"INSERT INTO ".$that->db->table("order_product_stock_locations")."
                    (order_product_id, product_id, product_option_value_id, location_id, location_name, quantity, sort_order)
                VALUES( 
                    ".(int)$order_product_id.",
                    ".(int)$product_id.", 
                    ".( (int)$product_option_value_id
					? (int)$product_option_value_id
					: 'NULL' ).", 
                    ".(int)$row['location_id'].", 
                    '".$that->db->escape($row['location_name'])."',
                    ".(int)$quantity.", 
                    ".(int)$row['sort_order']."
                );"
			);

			if(!$remains){
				break;
			}
		}
		return true;
	}

	/**
	 * @param $that
	 * @param $product_id
	 * @param int $product_option_value_id
	 *
	 * @return mixed
	 *
	 */
	private function getProductStockLocations($that,$product_id, $product_option_value_id = 0)	{

		$sql = "SELECT psl.*,
                        CONCAT(l.name,' ', l.description) as location_name, 
                        p.subtract as product_subtract";

		if($product_option_value_id) {
			$sql .= ", pov.subtract as product_option_value_subtract";
		}
		$sql .= " FROM ".$that->db->table('product_stock_locations')." psl
                LEFT JOIN ".$that->db->table('products')." p
                                    ON p.product_id = psl.product_id ";

		if($product_option_value_id) {
			$sql .= " LEFT JOIN ".$that->db->table('product_option_values')." pov
                          ON pov.product_option_value_id = psl.product_option_value_id";
		}
		$sql .= " LEFT JOIN ".$that->db->table('locations')." l
                    ON l.location_id = psl.location_id
                WHERE psl.product_id=".(int)$product_id;
		if($product_option_value_id){
			$sql .= " AND psl.product_option_value_id = ".(int)$product_option_value_id;
		}else{
			$sql .= " AND psl.product_option_value_id IS NULL";
		}
		$sql .= " ORDER BY psl.sort_order ASC";

		$result = $that->db->query($sql);
		return $result->rows;
	}

	private function getBetween($content,$start,$end){
		$r = explode($start, $content);
		if (isset($r[1])){
			$r = explode($end, $r[1]);
			return $r[0];
		}
		return '';
	}

    public function onControllerPagesSaleOrder_InitData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method==='history') {
            $that->load->model('extension/email_order');
            $taxjar_status = $that->config->get('taxjar_integration_status');

            if ($that->request->is_POST() && $this->_validateForm()) {
            	if ($taxjar_status==='1') {
		            $taxjarExtension = new ExtensiontaxjarIntegration();
		            $order_id  = $that->request->get['order_id'];
		            $status_id = $that->request->post['order_status_id'];

		            $enable_calculation = $that->config->get( 'taxjar_integration_sales_tax_calculation' );
		            $enable_export      = $that->config->get( 'taxjar_integration_sales_tax_report' );
		            $order              = $that->model_sale_order->getOrder( $order_id );
		            $products           = $that->model_sale_order->getOrderProducts( $order_id );
		            $order_totals       = $that->model_sale_order->getOrderTotals( $order_id );
		            if ( isset( $order_id )
		                 && isset( $status_id )
		                 && $status_id == $that->config->get( 'taxjar_integration_status_success_settled' ) ) {

			            $cust_data                = [];
			            $cust_data['customer_id'] = $order['customer_id'];
			            $cust_data['order_id']    = $order_id;
			            $cust_data['email']       = $order['email'];
			            if ( $enable_calculation ) {
				            $taxjarExtension->calculateTax( $that, $cust_data, true, $order_totals );
			            }
			            if ( $enable_export ) {
				            $taxjarExtension->createOrder($that,$order_id, $products, $order_totals );
			            }
		            }

		            if ( isset( $order_id )
		                 && isset( $status_id )
		                 && $status_id == $that->config->get( 'taxjar_integration_status_delete_settled' ) ) {
			            $that->load->model( 'sale/order' );
			            $customer_id              = $order['customer_id'];
			            $cust_data                = [];
			            $cust_data['customer_id'] = $customer_id;
			            $cust_data['order_id']    = $order_id;
			            //Cancel Tax
			            if ( $enable_export ) {
				            $taxjarExtension->cancelOrder($that,$cust_data );
			            }
		            }

		            if (isset( $order_id )
		                && isset( $status_id )
		                && $status_id === $that->config->get( 'taxjar_integration_status_refund_settled' ) ) {
			            $that->load->model( 'sale/order' );
			            $customer_id              = $order['customer_id'];
			            $cust_data                = [];
			            $cust_data['customer_id'] = $customer_id;
			            $cust_data['order_id']    = $order_id;
			            //Cancel Tax
			            if ( $enable_export ) {
				            $taxjarExtension->refundOrder($that,$order, $order_totals );
			            }
		            }
	            }

                $that->model_extension_email_order->addOrderHistory($that->request->get['order_id'], $that->request->post);
                $that->session->data['success'] = $that->language->get('text_success');
                redirect($that->html->getSecureURL('sale/order/history',
                    '&order_id='.$that->request->get['order_id']));
            }
        }
    }

	public function onControllerPagesSaleOrder_UpdateData() {
		if (!$this->_is_enabled()) {
			return null;
		}
		$that =& $this->baseObject;
		if ($this->baseObject_method==='details') {
			$that->loadLanguage('email_editor/email_editor');
			$that->loadModel('extension/tracking');
			$data['shippers'] = $that->model_extension_tracking->getShippers();

			$tracks = $that->model_extension_tracking->getTrack($that->request->get['order_id']);
			list($trackShipperId , $trackCode, $trackUrl, $deliveryDate,$additionalInfo,$orderStatus) = explode("|", $tracks['data']);

			$data['trackShipperId'] = $trackShipperId;
			$data['trackCode'] = $trackCode;
			$data['trackUrl'] = $trackUrl;
			$data['deliveryDate'] = $deliveryDate;
			$data['additional'] = $additionalInfo;

			$data['addTracking'] = $that->html->getSecureURL(
				'r/extension/tracking/addTracking'
			);
			$data['getTrackingUrl'] = $that->html->getSecureURL(
				'r/extension/tracking/getTrackingUrl'
			);
			$data['tracking_number'] = $that->language->get('tracking_number');
			$data['shipping_company'] = $that->language->get('shipping_company');
			$data['url_shipping_company'] = $that->language->get('url_shipping_company');
			$data['text_tracking'] = $that->language->get('text_tracking');
			$data['text_tracking_save'] = $that->language->get('text_tracking_save');
			$data['text_tracking_head'] = $that->language->get('text_tracking_head');
			$data['text_get_tracking'] = $that->language->get('text_get_tracking');
			$data['text_local_tracking'] = $that->language->get('text_local_tracking');
			$data['text_pickup_tracking'] = $that->language->get('text_pickup_tracking');
			$data['text_delivery_date'] = $that->language->get('text_delivery_date');
			$data['text_available_date'] = $that->language->get('text_available_date');
			$data['text_additional_local_delivery_info'] = $that->language->get('text_additional_local_delivery_info');
			$data['text_additional_store_pickup_info'] = $that->language->get('text_additional_store_pickup_info');

			$that->loadModel('localisation/order_status');
			$results = $that->model_localisation_order_status->getOrderStatuses();
			$statuses = ['' => $that->language->get('text_select_status'),];
			foreach ($results as $item) {
				$statuses[$item['order_status_id']] = $item['name'];
			}

			$data['order_status'] = $statuses;
			$data['orderStatus'] = $orderStatus;
			$data['text_order_status'] = $that->language->get('text_order_status');

			/* */
			$view = new AView($this->registry, 0);
			$view->batchAssign($data);
			$that->view->addHookVar('order_details', $view->fetch('pages/extension/tracking.tpl'));
		}
    }

    public function onControllerPagesAccountInvoice_UpdateData() {
	    if (!$this->_is_enabled()) {
		    return null;
	    }
	    $that =& $this->baseObject;
	    if ($this->baseObject_method==='main') {
		    $that->loadLanguage('email_editor/email_editor');
		    $that->loadModel('extension/tracking');

		    $data = $that->model_extension_tracking->getTrack($that->request->get['order_id']);
		    if ($data['data']!==null) {
			    list($trackShipperId , $trackCode, $trackUrl, $deliveryDate,$additional) = explode("|", $data['data']);
			    $shipperInfo                       = $that->model_extension_tracking->getShipperNameById( $trackShipperId );
			    $data['shipperId']                 = $trackShipperId;
			    $data['trackCode']                 = $trackCode;
			    $data['trackCompany']              = $shipperInfo;
			    $data['trackUrl']                  = $trackUrl;
			    $data['deliveryDate']              = $deliveryDate;
			    $data['additional']                = $additional;
			    $data['text_tracking_number']      = $that->language->get( 'text_tracking_number' );
			    $data['text_shipping_company']     = $that->language->get( 'text_shipping_company' );
			    $data['text_url_shipping_company'] = $that->language->get( 'text_url_shipping_company' );
			    $data['text_tracking']             = $that->language->get( 'text_tracking' );
			    $data['text_tracking_head']        = $that->language->get( 'text_tracking_head' );
			    $data['text_delivery_date'] = $that->language->get('text_delivery_date');
			    $data['text_available_date'] = $that->language->get('text_available_date');
			    $view = new AView( $this->registry, 0 );
			    $view->batchAssign( $data );
			    $that->view->addHookVar( 'order_attributes', $view->fetch( 'pages/extension/tracking_invoice.tpl' ) );
		    }
	    }
    }

    public function onControllerResponsesListingGridCustomerTransaction_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method==='transaction') {
            $transaction_id = (int)$that->request->get['customer_transaction_id'];
            $this->data['customer_transaction_id'] = $transaction_id;

            if ($transaction_id) {
                $info = $that->model_sale_customer_transaction->getCustomerTransaction($that->request->get['customer_transaction_id']);
                $this->data['text_title'] = $that->language->get('popup_title_info');
                $readonly = true;
            } else {
                $this->data['text_title'] = $that->language->get('popup_title_insert');
                $readonly = false;
                $info = [];
            }
            $form = new AForm();
            $form->setForm([
                'form_name' => 'transaction_form',
            ]);

	        $that->data['form']['form_open'] = $form->getFieldHtml( [
		        'type'   => 'form',
		        'name'   => 'tFrm',
		        'action' => $that->html->getSecureURL(
			        'listing_grid/customer_transactions/addtransaction',
			        '&customer_id=' . $that->request->get['customer_id'] ),
		        'attr'   => 'data-confirm-exit="true" class="form-horizontal"',
		        'csrf'   => true,
	        ] );

            $that->data['form']['submit'] = $form->getFieldHtml([
                'type' => 'button',
                'name' => 'submit',
                'text' => $that->language->get('button_save'),
            ]);

            $that->data['form']['cancel'] = $form->getFieldHtml([
                'type' => 'button',
                'name' => 'cancel',
                'text' => $that->language->get('button_cancel'),
            ]);

            $that->data['form']['fields']['credit'] = $form->getFieldHtml([
                'type'  => 'input',
                'name'  => 'credit',
                'value' => $info['credit'],
                'attr'  => ($readonly ? 'disabled="disabled"' : '').' maxlength="16"',
            ]);

            $that->data['form']['fields']['debit'] = $form->getFieldHtml([
                'type'  => 'input',
                'name'  => 'debit',
                'value' => $info['debit'],
                'attr'  => ($readonly ? 'disabled="disabled"' : '').' maxlength="16"',
            ]);

            $types = $that->model_sale_customer_transaction->getTransactionTypes();
            $types[''] = $that->language->get('text_option_other_type');
            reset($types);

            $that->data['form']['fields']['transaction_type'] = $form->getFieldHtml([
                'type'    => 'selectbox',
                'name'    => 'transaction_type[0]',
                'options' => $types,
                'value'   => $info['transaction_type'] == '' ? current($types) : $info['transaction_type'],
                'attr'    => ($readonly ? 'disabled="disabled"' : ''),
            ]);

            $that->data['form']['fields']['other_type'] = $form->getFieldHtml([
                'type'        => 'input',
                'name'        => 'transaction_type[1]',
                'placeholder' => $that->language->get('text_other_type_placeholder'),
                'value'       => (!in_array($info['transaction_type'], $types) ? $info['transaction_type'] : ''),
                'attr'        => ($readonly ? 'disabled="disabled"' : ''),
            ]);

            if (!$readonly) {
                $that->data['form']['fields']['notify'] = $form->getFieldHtml(
                    [
                        'type'    => 'checkbox',
                        'name'    => 'notify',
                        'value'   => 1,
                        'checked' => false,
                    ]);
            }

            $that->data['form']['fields']['transaction_comment'] = $form->getFieldHtml([
                'type'  => 'textarea',
                'name'  => 'comment',
                'value' => $info['comment'],
                'attr'  => ($readonly ? 'disabled="disabled"' : ''),
            ]);

            $that->data['form']['fields']['transaction_description'] = $form->getFieldHtml([
                'type'  => 'textarea',
                'name'  => 'description',
                'value' => $info['description'],
                'attr'  => ($readonly ? 'disabled="disabled"' : ''),
            ]);

            if ($readonly) {
                $that->data['form']['fields']['date_added'] = $form->getFieldHtml([
                    'type'  => 'input',
                    'name'  => 'date_added',
                    'value' => dateISO2Display($info['date_added'],
                        $that->language->get('date_format_short')
                        .' '.$that->language->get('time_format')
                    ),
                    'attr'  => 'disabled="disabled"',
                ]);
                $that->data['form']['fields']['date_modified'] = $form->getFieldHtml([
                    'type'  => 'input',
                    'name'  => 'date_modified',
                    'value' => dateISO2Display($info['date_modified'],
                        $that->language->get('date_format_short')
                        .' '.$that->language->get('time_format')
                    ),
                    'attr'  => 'disabled="disabled"',
                ]);
            }
        }
    }

    private function _find_customer($mode, &$customer_details ) {
        $that =& $this->baseObject;
        $email = $that->request->post['email'];
        $loginname = $that->request->post['loginname'];
        $lastname = $that->request->post['lastname'];
        $that->load->model('account/customer');
        //email is always required
        if (!isset($email) || empty($email) ) {
            $this->error['message'] = $that->language->get('error_email');
            return FALSE;
        }

        //locate customer based on login name
        if( $that->config->get('prevent_email_as_login') || $that->dcrypt->active ){
            if ( $mode == 'password'){
                if (!empty($loginname)) {
                    $customer_details = $that->model_account_customer->getCustomerByLoginnameAndEmail($loginname, $email);
                } else {
                    $this->error['message'] = $that->language->get('error_loginname');
                    return FALSE;
                }
            } else if ( $mode == 'loginname') {
                if (!empty($lastname)) {
                    $customer_details = $that->model_account_customer->getCustomerByLastnameAndEmail($lastname, $email);
                } else {
                    $this->error['message'] = $that->language->get('error_lastname');
                    return FALSE;
                }
            }
        } else {
            //get customer by email
            $customer_details = $that->model_account_customer->getCustomerByEmail($email);
        }
        if ( !count($customer_details) ) {
            $this->error['message'] = $that->language->get('error_not_found');
            return FALSE;
        } else {
            return TRUE;
        }
    }

    private function _validatePassword() {
        $that =& $this->baseObject;
        $that->loadLanguage('account/password');
        $post = $that->request->post;

        //check password length considering html entities (special case for characters " > < & )
        $pass_len = mb_strlen(htmlspecialchars_decode($post['password']));
        if ($pass_len < 4 || $pass_len > 20){
            $this->error['password'] = $that->language->get('error_password');
        }

        if ($post['confirm'] != $post['password']){
            $this->error['confirm'] = $that->language->get('error_confirm');
        }

        if (!$this->error){
            return true;
        } else{
            $this->error['warning'] = $that->language->get('gen_data_entry_error');
            return false;
        }
    }

    protected function dispatch($dispatch_rt, $args = ['']) {
        return new ADispatcher($dispatch_rt, $args);
    }

    private function _validateForm() {
        $that =& $this->baseObject;
        if (!$that->user->canModify('sale/order')) {
            $this->error['warning'] = $that->language->get('error_permission');
        }

        $that->extensions->hk_ValidateData($this);

        if (!$this->error) {
            return true;
        } else {
            return false;
        }
    }

    private function _send_email($email, $data) {
        $that =& $this->baseObject;
        $mail = new AMail($that->config);
        $mail->setTo($email);
        $mail->setFrom($data['sender_email']);
        $mail->setSender($data['sender_name']);
        $mail->setSubject($data['subject']);

        $languageId = $that->language->getContentLanguageID() ?? $that->language->getLanguageID();
        $mailLogo = $that->config->get('config_mail_logo_'.$languageId)
            ? : $that->config->get('config_mail_logo');
        $mailLogo = $mailLogo ? : $that->config->get('config_logo_'.$languageId);
        $mailLogo = $mailLogo ? : $that->config->get('config_logo');

        $attachment = [];
        if (is_file(DIR_RESOURCE.$mailLogo)) {
            $attachment = [
                'file' => DIR_RESOURCE.$mailLogo,
                'name' => md5(pathinfo($mailLogo, PATHINFO_FILENAME))
                    .'.'
                    .pathinfo($mailLogo, PATHINFO_EXTENSION)
            ];

            $mail->addAttachment(
                $attachment['file'],
                $attachment['name']
            );
        }
        $mail->setHtml($data['html_body']);
        $mail->send();

        if ($data['notify_admin']==='1') {
            $mail = new AMail($that->config);
            $mail->setTo($that->config->get('store_main_email'));
            $mail->setFrom($data['sender_email']);
            $mail->setSender($data['sender_name']);
            $mail->setSubject('(Copy) '.$data['subject']);
            $mail->setText(html_entity_decode($data['txt_body'], ENT_QUOTES, 'UTF-8'));

            $attachment = [];
            if (is_file(DIR_RESOURCE.$mailLogo)) {
                $attachment = [
                    'file' => DIR_RESOURCE.$mailLogo,
                    'name' => md5(pathinfo($mailLogo, PATHINFO_FILENAME))
                        .'.'
                        .pathinfo($mailLogo, PATHINFO_EXTENSION)
                ];

                $mail->addAttachment(
                    $attachment['file'],
                    $attachment['name']
                );
            }
            $mail->setHtml($data['html_body']);
            $mail->send();
        }
    }

    private function _validateCustomerForm($field, $value, $customer_id = '') {
        $that =& $this->baseObject;
        switch ($field) {
            case 'loginname' :
                $login_name_pattern = '/^[\w._-]+$/i';
                $value = preg_replace('/\s+/', '', $value);
                if (mb_strlen($value) < 5 || mb_strlen($value) > 64
                    || (!preg_match($login_name_pattern, $value) && $that->config->get('prevent_email_as_login'))
                ) {
                    $this->error = $that->language->get('error_loginname');
                    //check uniqueness of loginname
                } else {
                    if (!$that->model_sale_customer->is_unique_loginname($value, $customer_id)) {
                        $this->error = $that->language->get('error_loginname_notunique');
                    }
                }
                break;
            case 'firstname' :
                if (mb_strlen($value) < 1 || mb_strlen($value) > 32) {
                    $this->error = $that->language->get('error_firstname');
                }
                break;
            case 'lastname':
                if (mb_strlen($value) < 1 || mb_strlen($value) > 32) {
                    $this->error = $that->language->get('error_lastname');
                }
                break;
            case 'email':
                if (mb_strlen($value) > 96 || !preg_match(EMAIL_REGEX_PATTERN, $value)) {
                    $this->error = $that->language->get('error_email');
                }
                break;
            case 'telephone':
                if (mb_strlen($value) > 32) {
                    $this->error = $that->language->get('error_telephone');
                }
                break;
            case 'address_1':
                if (mb_strlen($value) < 1) {
                    $this->error = $that->language->get('error_address_1');
                }
                break;
            case 'city':
                if (mb_strlen($value) < 1) {
                    $this->error = $that->language->get('error_city');
                }
                break;
            case 'country_id':
                if (empty($value) || $value == 'FALSE') {
                    $this->error = $that->language->get('error_country');
                }
                break;
            case 'zone_id':
                if (empty($value) || $value == 'FALSE') {
                    $this->error = $that->language->get('error_zone');
                }
                break;
        }

        $that->extensions->hk_ValidateData($this);

        return $this->error;
    }

    /**
     * @param null $customer_id
     *
     * @return bool
     */
    private function _validateSaleCustomerForm($customer_id = null) {
        $that =& $this->baseObject;
        if (!$that->user->canModify('sale/customer')) {
            $this->error['warning'] = $that->language->get('error_permission');
            return false;
        }

        $data = $that->request->post;

        $login_name_pattern = '/^[\w._-]+$/i';
        if ((mb_strlen($data['loginname']) < 5 || mb_strlen($data['loginname']) > 64)
            || (!preg_match($login_name_pattern, $data['loginname']) && $that->config->get('prevent_email_as_login'))
        ) {
            $this->error['loginname'] = $that->language->get('error_loginname');
            //check uniqueness of login name
        } else {
            if (!$that->model_sale_customer->is_unique_loginname($data['loginname'], $customer_id)) {
                $this->error['loginname'] = $that->language->get('error_loginname_notunique');
            }
        }

        if (mb_strlen($data['email']) > 96 || !preg_match(EMAIL_REGEX_PATTERN, $data['email'])) {
            $this->error['email'] = $that->language->get('error_email');
        }

        if (mb_strlen($data['telephone']) > 32) {
            $this->error['telephone'] = $that->language->get('error_telephone');
        }

        if (($data['password']) || (!isset($that->request->get['customer_id']))) {
            if (mb_strlen($data['password']) < 4) {
                $this->error['password'] = $that->language->get('error_password');
            }

            if (!$this->error['password'] && $data['password'] != $data['password_confirm']) {
                $this->error['password'] = $that->language->get('error_confirm');
            }
        }

        if (mb_strlen($data['firstname']) < 1 || mb_strlen($data['firstname']) > 32) {
            $this->error['firstname'] = $that->language->get('error_firstname');
        }

        if (mb_strlen($data['lastname']) < 1 || mb_strlen($data['lastname']) > 32) {
            $this->error['lastname'] = $that->language->get('error_lastname');
        }

        //validate IM URIs
        //get only active IM drivers
        $im_drivers = $that->im->getIMDriverObjects();
        if ($im_drivers) {
            foreach ($im_drivers as $protocol => $driver_obj) {
                /**
                 * @var AMailIM $driver_obj
                 */
                if (!is_object($driver_obj) || $protocol == 'email') {
                    continue;
                }
                $result = $driver_obj->validateURI($data[$protocol]);
                if (!$result) {
                    $this->error[$protocol] = implode('<br>', $driver_obj->errors);
                }

            }
        }

        $that->extensions->hk_ValidateData($this);
        if (!$this->error) {
            return true;
        } else {
            $this->error['warning'] = implode('<br>', $this->error);
            return false;
        }
    }

    /**
     * @param $data_array
     * @param string $type
     * @param array $locate
     * @return mixed
     */
    private function getFormattedAddress($data_array, $type = '', $locate = []) {
        $that =& $this->baseObject;
        $format = '';
        $data_array = (array)$data_array;
        $ups_plus_status=$this->verifyUpsPlus();
        $vat=$registration=$bankName=$bankAddress=$iban=$swift='';
        if ($ups_plus_status) {
            $that->load->language('ups_integration_plus/ups_integration_plus');
        }

        if (strtolower($data_array['company']) != 'none' && strtolower($data_array['company']) != 'na' && $data_array['company'] != '') {
            $company = ' {company} ';
        }
        $taxShow = $that->config->get('taxid_show_order_confirm');
        if ($taxShow === '1' && strtolower($data_array['taxid']) !== 'none' && strtolower($data_array['taxid']) !== 'na' && $data_array['taxid'] !== '') {
            $vat = $that->config->get('taxid_order_confirm') . ' {taxid}'. "\n";
        }

        $registrationShow = $that->config->get('registration_show_order_confirm');
        if ($registrationShow === '1' && isset($data_array['registration']) && strtolower($data_array['registration']) !== 'none' && strtolower($data_array['registration']) !== 'na' && $data_array['registration'] !== '') {
            $registration = $that->config->get('registration_order_confirm') . ' {registration}'. "\n";
        }
        $bankNameShow = $that->config->get('bank_name_show_order_confirm');
        if ($bankNameShow === '1' && isset($data_array['bank_name']) && strtolower($data_array['bank_name']) !== 'none' && strtolower($data_array['bank_name']) !== 'na' && $data_array['bank_name'] !== '') {
            $bankName = $that->config->get('bank_name_order_confirm') . ' {bank_name}'. "\n";
        }
        $bankAddressShow = $that->config->get('bank_address_show_order_confirm');
        if ($bankAddressShow === '1' && isset($data_array['bank_address']) && strtolower($data_array['bank_address']) !== 'none' && strtolower($data_array['bank_address']) !== 'na' && $data_array['bank_address'] !== '') {
            $bankAddress = $that->config->get('bank_address_order_confirm') . ' {bank_address}'. "\n";
        }
        $ibanShow = $that->config->get('iban_show_order_confirm');
        if ($ibanShow === '1' && isset($data_array['iban']) && strtolower($data_array['iban']) !== 'none' && strtolower($data_array['iban']) !== 'na' && $data_array['iban'] !== '') {
            $iban = $that->config->get('iban_order_confirm') . ' {iban}'. "\n";
        }
        $swiftShow = $that->config->get('swift_show_order_confirm');
        if ($swiftShow === '1' && isset($data_array['swift']) && strtolower($data_array['swift']) !== 'none' && strtolower($data_array['swift']) !== 'na' && $data_array['swift'] !== '') {
            $swift = $that->config->get('swift_order_confirm') . ' {swift}';
        }
        // Set default format
        if ($type == 'payment') {
            $format = '{firstname} {lastname}' . "\n" . $company . "\n" . $vat  . '{address_1}' . "\n" . '{address_2}' . "\n"
                . '{city} {postcode}' . "\n" . '{zone}' . "\n" . '{country}' . "\n" . $registration  . $bankName . $bankAddress . $iban . $swift;
        } else {
            if ($data_array['location_phone'] !== '' && !empty($data_array['location_phone']) && $type !== 'payment') {
                $location_phone="\n" .$that->language->get('text_ups_plus_telephone') . ' {location_phone}';
            } else {
                $location_phone="";
            }
            $format = '{firstname} {lastname}' . "\n" . $company . "\n" . '{address_1}' . "\n" . '{address_2}' . "\n" . '{city} {postcode}' . "\n" . '{zone}' . "\n" . '{country}'.$location_phone;
        }
        //Set default variable to be set for address based on the data
        $locate = [];
        foreach ($data_array as $key => $value) {
            $locate[] = "{" . $key . "}";
        }

        return str_replace(["\r\n", "\r", "\n"], '<br />', preg_replace(["/\s\s+/", "/\r\r+/", "/\n\n+/"], '<br />', trim(str_replace($locate, $data_array, $format))));
    }

    public function onControllerCommonHead_UpdateData() {
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'main') {
            if (IS_ADMIN) {
                $latestVersion = $this->getVersion();
                if ($latestVersion) {
                    $that->load->language('email_editor/email_editor');
                    $that->load->model('extension/email_editor_updater');
                    $total = $that->model_extension_email_editor_updater->getTotalMsgIds();
                    if ($total > '0') {
                        $msg_ids = $that->model_extension_email_editor_updater->getMsgIdsByCartVersions();
                        foreach ($msg_ids as $msg_id) {
                            $that->messages->deleteMessage($msg_id['msg_id']);
                            $that->model_extension_email_editor_updater->deleteMsgID($msg_id['msg_id']);
                        }
                    }
                    $msg_title = str_replace('[new_version]', $latestVersion, $that->language->get('text_new_email_editor_version_title'));
                    $msg = str_replace('[version_number]', str_replace('.', '-', $latestVersion), $that->language->get('text_new_email_editor_version_description'));
                    $that->messages->saveNotice($msg_title, $msg);
                    $msg_info = $that->messages->getLikeMessage($msg_title);
                    $that->model_extension_email_editor_updater->saveMessageId($msg_info['msg_id'], $latestVersion);
                }
            }
        }
    }

    private function getVersion() {
        $that =& $this->baseObject;
        $latestVersion = '';
        $license_key = $that->config->get('email_editor_license_code');
        if ($license_key) {
            $valid = false;
            $exist = $that->db->query("SHOW TABLES LIKE '" . $that->db->table('email_editor_license_info') . "'");
            if ($exist->num_rows === 1) {
                $that->load->model('extension/email_editor_license_info');
                $store_id = $that->model_extension_email_editor_license_info->getStoreId();

                $license_key = $that->model_extension_email_editor_license_info->getLicenseCode($store_id);
                $license_info = $that->model_extension_email_editor_license_info->getLicenseData($store_id);
                $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                $license = new License($path_to_phpseclib);
                $license_manager = $license->getManager();
                $license_manager->setKeys($license_key, $license_info['public_key'], $this->shared_secret);
                $ttl = 1209600;
                $validate = $license_manager->validate($license_info['license_data'], $ttl);

                if ($validate['status'] === 'valid') {
                    if (stripos($license_key, 'rent-') !== false || stripos($license_key, 'mc-') !== false) {
                        $valid = true;
                    } elseif (stripos($license_key, 'own-') !== false) {
                        $today = date("Y-m-d H:i:s");
                        $support_date = date('Y-m-d H:i:s', strtotime($validate['updates']));
                        if ($today <= $support_date) {
                            $valid = true;
                        }
                    }
                }
            }
            if ($valid) {
                $that->load->language('email_editor/email_editor');
                $getVersions = emailEditorUpdaterGetAllVersions();
                $that->load->model('extension/email_editor_updater');
                $current_version = $that->model_extension_email_editor_updater->getCurrentVersion();
                if ($getVersions['notification_case'] !== 'notification_product_no_versions') {
                    $versions = $getVersions['notification_data']['product_versions'];
                    if ($versions) {
                        $latestVersions = [];
                        foreach ($versions as $version) {
                            if (strpos($version['version_number'], VERSION) !== false) {
                                $latestVersions[] = $version['version_number'];
                            }
                        }
                        usort($latestVersions, 'version_compare');
                        $latestVersion = end($latestVersions);
                        if (version_compare($current_version, $latestVersion, '<') === true) {
                            $msg_ids = $that->model_extension_email_editor_updater->getMsgIdsByCurrentCartVersion();
                            foreach ($msg_ids as $msg_id) {
                                $that->messages->deleteMessage($msg_id['msg_id']);
                                $that->model_extension_email_editor_updater->deleteMsgID($msg_id['msg_id']);
                            }
                            return $latestVersion;
                        }
                    }
                } else {
                    return '';
                }
            } else {
                return '';
            }
        }
    }
    
}