<?php

if ($error) { ?>
    <div class="alert alert-error alert-danger">
        <button type="button" class="close" data-dismiss="alert">&times;</button>
        <?php
        echo $error; ?>
    </div>
    <?php
} ?>
<div class="spinner-overlay">
    <div class="spinner"></div>
</div>
<div id="fast_checkout_cart"></div>

<script type="application/javascript">

    function readCookie(name) {
        var nameEQ = name + "=";
        var ca = document.cookie.split(';');
        for (var i = 0; i < ca.length; i++) {
            var c = ca[i];
            while (c.charAt(0) == ' ') c = c.substring(1, c.length);
            if (c.indexOf(nameEQ) == 0) return c.substring(nameEQ.length, c.length);
        }
        return null;
    }

    function checkCartKey() {
        if ($('body').data('cart_key') && $('body').data('cart_key') !== readCookie('fc_cart_key')) {
            var pKey = $('body').data('product_key');
            if (pKey) {
                location = '<?php echo $this->html->getSecureUrl('product/product')?>' + '&key=' + pKey;
            }
        }
    }
    document.addEventListener('DOMContentLoaded', function load() {
        //waiting for jquery loaded!
        if (!window.jQuery) return setTimeout(load, 50);
        //jQuery-depended code
    if ($('#fast_checkout_cart').html() === '') {
        $('.spinner-overlay').fadeIn(100);
    }
    <?php if ($cart_url) { ?>
    loadPage = function () {
        $.ajax({
            url: '<?php echo $cart_url; ?>',
            type: 'GET',
            dataType: 'html',
            beforeSend: function(){
                $('.spinner-overlay').fadeIn(100);
            },
            success: function (data) {
                $('#fast_checkout_summary_block').trigger('reload');
                $('#fast_checkout_cart').hide().html(data).fadeIn(1000);
                $('.spinner-overlay').fadeOut(500);
            },
            error: function () {
                $('.spinner-overlay').fadeOut(500);
            }
        });
    };

    $(document).ready(loadPage);
    <?php }
    // set cart key into scratch data
    ?>
    $(document).ready( function(){
        if(!$('body').data('cart_key')){
            <?php
            if($single_checkout){
                //we use this key to open product page when cart-key changed (another simple-checkout process)
                ?>
                $('body').data('product_key', '<?php echo $product_key; ?>');
            <?php } ?>
            $('body').data('cart_key', '<?php echo $cart_key; ?>');
        }
        checkCartKey();
    });

    <?php echo $this->getHookVar('fc_js_page'); ?>
    }, false);
</script>

<div id="pay_modal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="pay_modal_label" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                <h4 id="pay_modal_label">
                    <span class="secure_connection"></span>
                    <?php echo $fast_checkout_text_fast_checkout_title; ?>
                </h4>
            </div>
            <div class="modal-body">
                <iframe id="pay_modal_frame" name="pay_modal_frame" width="100%" height="580px" frameBorder="0"
                        scrolling="yes" src=""></iframe>
                <div class="modal_loader">
                    <div style="display: inline-block;">
                        <i class="fa fa-spinner fa-pulse fa-4x fa-fw"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script type="text/javascript" src="<?php echo $this->templateResource('/js/iframeResizer.min.js'); ?>"></script>
<script type="text/javascript" src="<?php echo $this->templateResource('/js/credit_card_validation.js'); ?>"></script>
<script type="text/javascript">
    iFrameResize({
        minHeight: 500,
        resizeFrom: 'child',
        checkOrigin: false,
        log: false,
        messageCallback: function (messageData) {
            //message from frame with loaded content
            if (messageData.message === 'loaded') {
                $('.modal_loader').hide();
            }
            //reload embed from parent iframe
            if (messageData.message.reload === true) {
                $('#pay_modal').modal('hide');
                window.location = messageData.message.url;
            }
            return false;
        }
    });

    jQuery(document).ready(function () {

        //check ssl connection.
        <?php if(HTTPS === true || $this->config->get('config_ssl')) { ?>
            $('.secure_connection').html('<i class="fa fa-lock fa-fw"></i>');
            <?php } else { ?>
            $('.secure_connection').html('<i class="fa fa-unlock fa-fw"></i>');
            <?php } ?>

        $("#pay_modal").on("show.bs.modal", function (e) {
            var action = '<?php echo $this->html->getSecureUrl('r/checkout/pay', ''); ?>';
            var link = $(e.relatedTarget);
            var formname = link.parents('form').attr('id');

            if (formname) {
                //open with form submit with options
                var original_action = $('#' + formname).attr('action');
                $('#' + formname).attr('target', 'pay_modal_frame').attr('action', action).submit();
                //put original action back
                $('#' + formname).attr('action', original_action).removeAttr('target');

            } else {
                //from product list page, build form on a fly
                var href = link.attr('href');
                var product_id = link.attr('data-id');
                link.wrap('<form id="product_' + product_id + '" enctype="multipart/form-data" method="post"></form>');
                link.parents('form').append('<input type="hidden" name="product_id" value="' + product_id + '">');
                link.parents('form').append('<input type="hidden" name="quantity" value="1">');
                $('#product_' + product_id).attr('target', 'pay_modal_frame').attr('action', action).submit();
                //clean up.
                link.parents('form').find('input').remove();
                link.unwrap('form');
            }
        });

        $("#pay_modal").on("hidden.bs.modal", function (e) {
            //empty iframe content wiht remove and reload
            //need to send message to iframe to reset content
        });

        $("#pay_modal_frame").on('load',function () {
            content_start_loading();
        });
    });

    var content_start_loading = function () {
        $('.modal_loader').show().delay(3000).fadeOut();
    };
</script>

