<style>
.Table
    {
    border: medium solid #000000;
    border-radius: 10px 10px 10px 10px;
    display: table;
    padding: 20px;
    color: #000000;
    }
    .Title
    {
        display: table-caption;
        text-align: center;
        font-weight: bold;
        font-size: larger;
    }
    .Row
    {
        display: table-row;
    }
    .Cell
    {
        display: table-cell;
        padding-left: 5px;
        padding-right: 5px;
        vertical-align: middle;
    }



/* #### Dark Matter #### */
.track {
    margin-left: auto;
    margin-right: auto;
    max-width: 98%;
    padding: 20px 30px 20px 30px;
    font: 12px "Helvetica Neue", Helvetica, Arial, sans-serif;
    color: #D3D3D3;
    /*text-shadow: 1px 1px 1px #444;*/
    border: none;
    border-radius: 5px;
    -webkit-border-radius: 5px;
    -moz-border-radius: 5px;
}
.track h1 {
    padding: 0px 0px 10px 40px;
    display: block;
    border-bottom: 1px solid #444;
    margin: -10px -30px 30px -30px;
}
.track h1>span {
    display: block;
    font-size: 11px;
}
.track label {
    display: block;
    margin: 0px 0px 5px;
}
.track label>span {
    float: left;
    width: 20%;
    text-align: right;
    padding-right: 10px;
    margin-top: 10px;
    font-weight: bold;
}
.track input[type="text"], .track input[type="email"], .track textarea, .track select {
    border: none;
    color: #525252;
    height: 25px;
    line-height:15px;
    margin-bottom: 16px;
    margin-right: 6px;
    margin-top: 2px;
    outline: 0 none;
    padding: 5px 0px 5px 5px;
    width: 70%;
    border-radius: 2px;
    -webkit-border-radius: 2px;
    -moz-border-radius: 2px;
    -moz-box-shadow: inset 0 1px 1px rgba(0, 0, 0, 0.075);
    background: #efefef;
}

.track textarea{
    height:100px;
    padding: 5px 0px 0px 5px;
    width: 70%;
}
.track .button {
    background: #FFCC02;
    border: none;
    padding: 10px 25px 10px 25px;
    color: #585858;
    border-radius: 4px;
    -moz-border-radius: 4px;
    -webkit-border-radius: 4px;
    text-shadow: 1px 1px 1px #FFE477;
    font-weight: bold;
    box-shadow: 1px 1px 1px #3D3D3D;
    -webkit-box-shadow:1px 1px 1px #3D3D3D;
    -moz-box-shadow:1px 1px 1px #3D3D3D;
}

.track .button:hover {
    color: #333;
    background-color: #EBEBEB;
}

</style>
<tr>
<div id="tracking" class="track">
<div class="Table">
    <div class="Title">
        <p><?php echo $text_tracking_head; ?></p>
    </div>
    <div class="Row">
        <div class="Cell">
           <?php echo $shipping_company.':'; ?>
        </div>
        <div class="Cell">
            <select name="shipper" id="shipper">
                <?php foreach($shippers as $shipper) { ?>
                <option value="<?php echo $shipper['id']; ?>" <?php echo ($shipper['id']===$trackShipperId) ? 'selected="selected"' : ''; ?>>
                    <?php echo $shipper['shipper'] ?>
                </option>
                <?php } ?>
            </select>
        </div>
    </div>
    <div class="Row" id="shipping" >
        <div class="Cell">
            <?php echo $tracking_number.':'; ?>
        </div>
        <div class="Cell">
            <input type="text" class="form-control atext" name="number" id="number" value="<?php echo $trackCode; ?>" size="30">
        </div>
    </div>
    <div class="Row" id="local" style="display: none">
        <div class="Cell" id="text">
            <?php echo $text_delivery_date; ?>
        </div>
        <div class="Cell">
            <input type="text" class="form-control atext" name="deliveryDate" id="deliveryDate" value="<?php echo $deliveryDate; ?>" size="30">
        </div>
    </div>
    <div class="Row" id="track">
        <div class="Cell">
            <?php echo $url_shipping_company.':'; ?>
        </div>
        <div class="Cell">
            <input type="text" name="url" id="url" value="<?php echo urldecode($trackUrl);?>" disabled size="120">
        </div>
    </div>
    <div class="Row" id="additionalInfo" style="display: none">
        <div class="Cell" id="additionalText">
        </div>
        <div class="Cell">
            <input type="text" name="additional" id="additional" value="<?php echo $additional;?>" size="120">
        </div>
    </div>
    <div class="Row" id="orderStatus" style="display: none">
        <div class="Cell">
            <?php echo $text_order_status; ?>
        </div>
        <div class="Cell">
            <select name="odrStatus" id="odrStatus">
                <?php foreach($order_status as $id => $status) { ?>
                    <option value="<?php echo $id; ?>" <?php echo ((int)$id===(int)$orderStatus && !empty($orderStatus)) ? 'selected="selected"' : ''; ?>>
                <?php echo $status; ?>
                </option>
                <?php } ?>
            </select>
        </div>
    </div>
	<div class="Row" id="process">
        <div class="Cell" id="parameter">
           <?php echo $text_tracking.'  '; ?>
        </div>
        <div class="Cell">
            <span style="display: inline-block;" class="abuttons_grp">

            <a data-original-title="<?php echo $text_tracking_head; ?>" class="add btn btn-success tooltips" id="getTracking"><i class="fa fa-plus-circle fa-lg"></i><?php echo ' '.$text_get_tracking; ?></a>

			<a data-original-title="<?php echo $text_tracking_head; ?>" class="add btn btn-success tooltips" id="track_ship_submit"><i class="fa fa-plus-circle fa-lg"></i><?php echo ' '.$text_tracking_save; ?></a>

			<div style="display: none;" id="track_ship_loading">
			<button class="btn btn-primary lock-on-click disabled" data-loading-text="&lt;i class='fa fa-refresh fa-spin fa-fw'&gt;&lt;/i&gt;" disabled="disabled"><i class="fa fa-refresh fa-spin fa-fw"></i></button>
			</div>
			<div style="display: none;" id="track_ship_message">
			<div role="alert" class="alert alert-success growl-animated animated fadeInDown" data-growl="container" data-growl-position="top-right" style="position: fixed; margin: 0px; z-index: 99999; display: inline-block; top: 83px; right: 20px;"><button data-growl="dismiss" class="close" type="button" style="display: inline-block; position: absolute; top: 5px; right: 10px; z-index: 99998;"><span aria-hidden="true">×</span><span class="sr-only">Close</span></button><span data-growl="icon" class="fa fa-check"></span><span data-growl="title"></span><span data-growl="message">&nbsp;&nbsp;Saved Successfully&nbsp;&nbsp;&nbsp;</span><a data-growl="url" href="#"></a></div>
			</div>
		</span>
        </div>
    </div>
</div>
</div>
</tr>
<script>

$(document).ready(function() {
    $('#deliveryDate').datepicker();
    <?php if ($deliveryDate!=='none' && !empty($deliveryDate)) { ?>
        <?php if ($trackCode) { ?>
        $('#shipping').show();
        $('#local').hide();
        $('#additionalInfo').hide();
        $('#track').show();
        <?php } else { ?>
        $('#shipping').hide();
        $('#local').show();
        $('#additionalInfo').show();
        $('#track').hide();
        <?php } ?>
        $('#odrStatus').attr('disabled',true);
        $('#shipper').attr('disabled',true);
        $('#process').hide();
        $('#getTracking').hide();
        $('#orderStatus').show();
        $('#parameter').html('<?php echo $text_local_tracking;?>');
        var shipperId = $('#shipper option:selected').val();
        if (shipperId==='9') {
            $('#additionalText').html('<?php echo $text_additional_store_pickup_info;?>');
            $('#text').html('<?php echo $text_available_date;?>');
        } else if (shipperId==='10') {
            $('#additionalText').html('<?php echo $text_additional_local_delivery_info;?>');
            $('#text').html('<?php echo $text_delivery_date;?>');
        }
    <?php } else { ?>
        $('#shipping').show();
        $('#local').hide();
        $('#additionalInfo').hide();
        $('#track').show();
        $('#getTracking').show();
        $('#orderStatus').hide();
        $('#parameter').html('<?php echo $text_tracking;?>');
        <?php } ?>
});

$('#shipper').change(function(e){
  var shipperId = this.value;
  if (shipperId === '9' || shipperId === '10') {
        $('#url').val('');
        $('#number').val('');
        $('#shipping').hide();
        $('#local').show();
        $('#additionalInfo').show();
        $('#track').hide();
        $('#getTracking').hide();
        $('#orderStatus').show();
        if (shipperId==='9') {
            $('#additionalText').html('<?php echo $text_additional_store_pickup_info;?>');
            $('#text').html('<?php echo $text_available_date;?>');
            $('#parameter').html('<?php echo $text_pickup_tracking;?>');
        } else {
            $('#additionalText').html('<?php echo $text_additional_local_delivery_info;?>');
            $('#text').html('<?php echo $text_delivery_date;?>');
            $('#parameter').html('<?php echo $text_local_tracking;?>');
        }
  } else {
      $('#shipping').show();
      $('#local').hide();
      $('#track').show();
      $('#additionalInfo').hide();
      $('#getTracking').show();
      $('#orderStatus').hide();
      $('#parameter').html('<?php echo $text_tracking;?>');
  }
});

$('#track_ship_submit').click(function() {
       $('#track_ship_message_td').hide();
		var order_id = '<?php echo $_GET["order_id"];?>';
		var trnumber = document.getElementById("number").value;
		var deliveryDate = document.getElementById("deliveryDate").value;
		var additionalInfo = document.getElementById("additional").value;
		var trcmp = document.getElementById("shipper").text;
		var trcmpcode = document.getElementById("shipper").value;
		var trcmpurl = document.getElementById("url").value;
        var orderStatus = document.getElementById("odrStatus").value;

		if ( order_id > 0 ) {
			$('#track_ship_submit').hide();
			$('#track_ship_loading').show();
			$.ajax({
				url: '<?php echo $addTracking; ?>' + '&order_id=' + order_id,
				data: { trackcode: trnumber, name: trcmp, shipperId:trcmpcode , deliveryDate: deliveryDate, additional : additionalInfo, url: trcmpurl, orderStatus:orderStatus },
				type: 'POST',
				dataType: 'json',
				success: function(result) {
					if ( result ) {
						$('#track_ship_message').show();
						window.location.href = result.href;
					} else {
						$('#track_ship_loading').hide();
						$('#track_ship_submit').show();
						$('#track_ship_message').html('<?php echo $error_service_unavailable; ?>');
						$('#track_ship_message').removeAttr('class').addClass('warning');
						$('#track_ship_message_td').show();
					}
				}
			});
		} else {
			$('#track_ship_message').html('<?php echo $error_wrong_data; ?>');
			$('#track_ship_message').removeAttr('class').addClass('warning');
			$('#track_ship_message_td').show();
		}
	});

$('#getTracking').click(function (e) {
    e.preventDefault();
    var number = document.getElementById('number').value;
    var id = $('#shipper option:selected').val();
    $.ajax({
      url: '<?php echo $getTrackingUrl;?>',
      type: 'post',
      data: { code: number, id: id },
      dataType: 'json',
      cache: false,
      success: function(json) {
        $('#url').val(json.url);
      }
    });
});

</script>