<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2021 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

/**
 * Class ControllerPagesExtensionEmailSignatures
 * @property ModelExtensionEmailSignatures $model_extension_email_signatures
 */

require_once DIR_EXT. "email_editor" . DIR_EXT_CORE ."helpers.php";

class ControllerPagesExtensionEmailSignatures extends AController {
    public $data=array();
    public $error=array();

    public function verify() {
    	$validation = emailEditorVerifyLicense();
    	if ($validation['notification_case']==='notification_license_ok') {
    		return true;
    	} elseif($validation['notification_case']==='notification_license_corrupted') {
    		return false;
    	}
    }

    public function main() {
        //init controller data
        $this->extensions->hk_InitData($this, __FUNCTION__);
        $this->load->language('email_editor/email_editor');

        $this->document->setTitle( $this->language->get('heading_email_signature_list') );

        $this->document->initBreadcrumb( array (
            'href'      => $this->html->getSecureURL('index/home'),
            'text'      => $this->language->get('text_home'),
            'separator' => FALSE
        ));
        $this->document->addBreadcrumb( array (
            'href'      => $this->html->getSecureURL('extension/email_signatures'),
            'text'      => $this->language->get('heading_email_signature_list'),
            'separator' => ' :: ',
            'current' => true,
        ));

        $grid_settings = array('table_id' => 'email_signatures_grid',
            'url' => $this->html->getSecureURL('listing_grid/email_signatures_list'),
            'editurl' => $this->html->getSecureURL('listing_grid/email_signatures_list/edit'),
            'update_field' => $this->html->getSecureURL('listing_grid/email_signatures_list/update_field'),
            'sortname' => 'date_modified',
            'sortorder' => 'desc',
            'columns_search' => false,
            'actions' => array(
                'edit' => array(
                    'text' => $this->language->get('text_edit'),
                    'href' => $this->html->getSecureURL('extension/email_signatures/edit', '&id=%ID%')
                ),
                'delete' => array(
                    'text' => $this->language->get('text_delete'),
                    'href' => $this->html->getSecureURL('extension/email_signatures/delete', '&id=%ID%')
                ),
            ),
        );

        $form = new AForm ();
        $form->setForm(array('form_name' => 'email_signatures_grid_grid_search'));
        $grid_settings['multiaction_options']=array(
            'delete' => $this->language->get('text_delete_selected')
        );
        $grid_settings['colNames'] = array($this->language->get('column_email_signature_id'),
            $this->language->get('column_email_signature_title'));

        $grid_settings['colModel'] = array(array('name' => 'id',
            'index' => 'id',
            'width' => 20,
            'align' => 'center',
            'search' => false),
            array('name' => 'signature_title',
                'index' => 'title',
                'width' => 110,
                'align' => 'center',
            ));

        $grid = $this->dispatch('common/listing_grid', array($grid_settings));
        $this->data['listing_grid'] = $grid->dispatchGetOutput();

        if (isset ($this->session->data['warning'])) {
            $this->data['error_warning'] = $this->session->data['warning'];
            $this->session->data['warning'] = '';
        } else {
            $this->data ['error_warning'] = '';
        }

        if (isset ($this->session->data['success'])) {
            $this->data['success'] = $this->session->data['success'];
            $this->session->data['success'] = '';
        } else {
            $this->data ['success'] = '';
        }
        $this->data['insert'] = $this->html->getSecureURL('extension/email_signatures/insert');
		$this->data['license_status'] = $this->verify();
		$this->data['text_unauthorized'] = $this->language->get('text_email_editor_unauthorized');
        $this->view->batchAssign($this->language->getASet());
        $this->view->batchAssign($this->data);
        //update controller data
        $this->extensions->hk_UpdateData($this, __FUNCTION__);
        $this->processTemplate('pages/extension/email_signatures.tpl');
    }

    public function insert() {
        //init controller data
        $this->extensions->hk_InitData($this, __FUNCTION__);
        $this->loadLanguage('email_editor/email_editor');
        $this->document->setTitle($this->language->get('heading_insert_signature_name'));
        $this->data['heading_title'] = $this->language->get('heading_insert_signature_name');
        if ($this->request->is_POST() && $this->_validateInsertForm()) {
            $this->loadModel('extension/email_signatures');
            $rss_id = $this->model_extension_email_signatures->addSignature($this->request->post);
            $this->session->data ['success'] = $this->language->get('text_email_signature_insert_success');
            $this->redirect($this->html->getSecureURL('extension/email_signatures/edit', '&id=' . $rss_id));
        }

        foreach ($this->request->post as $k => $v) {
            $this->data[$k] = $v;

        }
        $this->_getForm();
        //update controller data
        $this->extensions->hk_UpdateData($this, __FUNCTION__);
    }

    public function edit() {
        //init controller data
        $this->extensions->hk_InitData($this, __FUNCTION__);
        $this->loadModel('extension/email_signatures');
        $this->loadLanguage('email_editor/email_editor');
        $this->document->setTitle($this->language->get('heading_edit_signature_name'));
        $this->data['heading_title'] = $this->language->get('heading_edit_signature_name');
        $email_id = (int)$this->request->get['id'];

        if ($this->request->is_POST() && $this->_validateEditForm() && $email_id) {
            $this->loadModel('extension/email_signatures');
            $this->model_extension_email_signatures->updateSignature($email_id, $this->request->post);
            $this->session->data ['success'] = $this->language->get('text_email_signature_update_success');
            $this->redirect($this->html->getSecureURL('extension/email_signatures/edit', '&id=' . $email_id));
        }
        $this->data['error'] = $this->error;
        $info = $this->model_extension_email_signatures->getSignature($email_id);
        foreach ($info as $k => $v) {
            $this->data[$k] = $v;
        }
        $this->_getForm();
        //update controller data
        $this->extensions->hk_UpdateData($this, __FUNCTION__);
    }

    public function delete() {
    //init controller data
        $this->extensions->hk_InitData($this, __FUNCTION__);
        $signature_id = (int)$this->request->get['id'];
        $this->loadModel('extension/email_signatures');
        $this->model_extension_email_signatures->deleteSignature($signature_id);
        //update controller data
        $this->extensions->hk_UpdateData($this, __FUNCTION__);
        $this->redirect($this->html->getSecureURL('extension/email_signatures'));
    }

    public function _getForm() {
        if (isset ($this->session->data['warning'])) {
            $this->data ['error_warning'] = $this->session->data['warning'];
            $this->session->data['warning'] = '';
        } else {
            $this->data ['error_warning'] = '';
        }
        $this->view->assign('success', $this->session->data['success']);

        if (isset($this->session->data['success'])) {
            unset($this->session->data['success']);
        }

        $this->document->initBreadcrumb(array('href' => $this->html->getSecureURL('index/home'),
            'text' => $this->language->get('text_home'),
            'separator' => FALSE));

        $this->document->addBreadcrumb(array('href' => $this->html->getSecureURL('extension/email_signatures'),
            'text' => $this->language->get('email_editor_name'),
            'separator' => ' :: '));

        $this->data ['cancel'] = $this->html->getSecureURL('extension/email_signatures');
        $this->data ['reset'] = $this->html->getSecureURL('extension/email_signatures/edit', '&id=' . $this->request->get ['id'].'&reset=true');
        if (!isset($this->request->get['id'])) {
            $this->data ['action'] = $this->html->getSecureURL('extension/email_signatures/insert');
            $this->data ['form_title'] = $this->language->get('text_create_email_signature');
            $this->data ['update'] = '';
            $form = new AForm ('ST');
        } else {
            $this->data ['action'] = $this->html->getSecureURL('extension/email_signatures/edit', '&id=' . $this->request->get ['id']);
            $this->data ['form_title'] = $this->language->get('text_edit_email_signature') . ' ' . $this->data['title'];
            $this->data ['update'] = $this->html->getSecureURL('listing_grid/email_signatures_list/update_field', '&id=' . $this->request->get ['id']);
            $form = new AForm ('HS');
        }

        $this->document->addBreadcrumb(
            array('href' => $this->data['action'],
                'text' => $this->data ['form_title'],
                'separator' => ' :: ',
                'current' => true
            ));

        $form->setForm(array('form_name' => 'EmailSignatureFrm', 'update' => $this->data ['update']));

        $this->data['form']['form_open'] = $form->getFieldHtml(
            array('type' => 'form',
                'name' => 'EmailSignatureFrm',
                'attr' => 'data-confirm-exit="true" class="aform form-horizontal"',
                'action' => $this->data ['action']));

        $this->data['form']['submit'] = $form->getFieldHtml(
            array('type' => 'button',
                'name' => 'submit',
                'text' => $this->language->get('button_save')));

        $this->data['form']['cancel'] = $form->getFieldHtml(
            array('type' => 'button',
                'name' => 'cancel',
                'text' => $this->language->get('button_cancel')));

        $this->data['form']['fields']['title'] = $form->getFieldHtml(array(
            'type' => 'input',
            'name' => 'title',
            'value' => $this->data['title'],
            'required' => true));
        $this->data['form']['text']['title'] = $this->language->get('text_signature_title');


        $this->data['form']['fields']['content'] = $form->getFieldHtml(array(
            'type' => 'texteditor',
            'name' => 'content',
            'value' => $this->data['content'],
            'required' => true));
        $this->data['form']['text']['content'] = $this->language->get('text_signature_content');
        $this->addChild('responses/common/resource_library/get_resources_html', 'resources_html',
            'responses/common/resource_library_scripts.tpl');
        $resources_scripts = $this->dispatch(
            'responses/common/resource_library/get_resources_scripts',
            array(
                'object_name' => '',
                'object_id'   => '',
                'types'       => array('image'),
            )
        );
        $this->data['resources_scripts'] = $resources_scripts->dispatchGetOutput();
        $this->data['rl'] = $this->html->getSecureURL('common/resource_library',
            '&action=list_library&object_name=&object_id&type=image&mode=single');
        $this->view->batchAssign($this->language->getASet());
        $this->view->batchAssign($this->data);
        $this->view->assign('form_language_switch', $this->html->getContentLanguageSwitcher());
        $this->view->assign('language_code', $this->session->data['language']);
        $this->processTemplate('pages/extension/email_signatures_form.tpl');
    }

    private function _validateEditForm() {
        if (!$this->user->canModify('extension/email_signatures')) {
            $this->session->data['warning'] = $this->error ['warning'] = $this->language->get('error_permission');
        }

        if ($this->request->post) {
            $required = array('title', 'content');
            foreach ($this->request->post as $name => $value) {
                if (in_array($name, $required) && empty($value)) {
                    $this->error ['warning'] = $this->language->get('error_empty');
                    $this->session->data['warning'] = $this->language->get('error_empty');
                    break;
                }
            }
        }
        $this->extensions->hk_ValidateData($this);
        if (!$this->error) {
            return TRUE;
        } else {
            return FALSE;
        }
    }

    private function _validateInsertForm() {
        $this->loadModel('extension/email_signatures');
        if (!$this->user->canModify('extension/email_signatures')) {
            $this->session->data['warning'] = $this->error ['warning'] = $this->language->get('error_permission');
        }

        $titleExist=$this->model_extension_email_signatures->getTitle($this->request->post['title']);
        if ($titleExist) {
            $this->error ['warning'] = $this->language->get('error_title');
            $this->session->data['warning'] = $this->language->get('error_title');
        } elseif ($this->request->post) {
            $required = array('title', 'content');
            foreach ($this->request->post as $name => $value) {
                if (in_array($name, $required) && empty($value)) {
                    $this->error ['warning'] = $this->language->get('error_empty');
                    $this->session->data['warning'] = $this->language->get('error_empty');
                    break;
                }
            }
        }
        $this->extensions->hk_ValidateData($this);
        if (!$this->error) {
            return TRUE;
        } else {
            return FALSE;
        }
    }
}