<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2021 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}
require_once DIR_EXT. "email_editor" . DIR_EXT_CORE ."updater.php";

/**
 * Class ControllerPagesExtensionEmailEditorUpdater
 * @property ModelExtensionEmailEditorUpdater $model_extension_email_editor_updater
 */

class ControllerPagesExtensionEmailEditorUpdater extends AController {
    public $data=array();
    public $error=array();

    public function main() {
        $this->load->language('email_editor/email_editor');
        $this->request->get['extension'] = 'email_editor';
        $this->document->setTitle( $this->language->get( 'text_email_editor_updater_heading_title' ) );
        $this->load->model('extension/email_editor_updater');
        if ($this->request->is_POST() && $this->_validate()) {
            $support = emailEditorVerifySupport();
            if ($support['notification_case'] === 'notification_license_ok') {
                $getVersions = emailEditorUpdaterGetAllVersions();
                $current_version = $this->model_extension_email_editor_updater->getCurrentVersion();
                if ($getVersions['notification_case'] !== 'notification_product_no_versions') {
                    $versions = $getVersions['notification_data']['product_versions'];
                    foreach ($versions as $version) {
                        if (version_compare($current_version, $version['version_number'], '<') === true && version_compare(VERSION, '1.2.17', '<') === true &&
                            version_compare($version['version_number'], '1.2.17', '<') === true
                            || version_compare($current_version, $version['version_number'], '<') && version_compare(VERSION, '1.2.17', '=') === true &&
                            version_compare($version['version_number'], '1.2.17', '>=') === true) {
                            $update_query = emailEditorUpdaterDownloadFile("version_upgrade_query", $version['version_number']);
                            if ($update_query['notification_case'] === 'notification_operation_ok') {
                                $this->runQuery($update_query['extract_location']);
                                if (sizeof((array)$this->error['error_query']) === 0) {
                                    $this->remove($update_query['extract_location']);
                                } else {
                                    $this->log->write(var_export($this->error['error_query'], true));
                                }
                            }
                            $update_files = emailEditorUpdaterDownloadFile("version_upgrade_file", $version['version_number']);
                            if ($update_files['notification_case'] === 'notification_operation_ok') {
                                $this->cache->remove("*");
                                $this->custom_copy($update_files['extract_location'], dirname(__DIR__, 5));
                                if (sizeof((array)$this->error['error_copy']) === 0) {
                                    $this->remove($update_files['extract_location']);
                                } else {
                                    $this->log->write(var_export($this->error['error_copy'], true));
                                }
                            }
                            if (sizeof($this->error) > 0) {
                                $this->session->data['warning'] = $this->language->get('text_update_failed');
                            } else {
                                $this->session->data['success'] = $this->language->get('text_update_success');
                            }
                            $this->model_extension_email_editor_updater->updateVersion($version['version_number']);
                            $msg_id = $this->model_extension_email_editor_updater->getMsgIdByExtVersion($version['version_number']);
                            $this->messages->markAsRead($msg_id);

                            $install_upgrade_history = new ADataset('install_upgrade_history', 'admin');
                            $install_upgrade_history->addRows(array(
                                'date_added' => date("Y-m-d H:i:s", time()),
                                'name' => 'Upgrade ' . $this->language->get('email_editor_name'),
                                'version' => $version['version_number'],
                                'backup_file' => '',
                                'backup_date' => '',
                                'type' => 'upgrade',
                                'user' => $this->user->getUsername(),
                            ));

                            redirect($this->html->getSecureURL('extension/extensions/edit', '&extension=email_editor'));
                        }
                    }
                }
            }
        }

        if ( isset( $this->error['warning'] ) ) {
            $this->data['error_warning'] = $this->error['warning'];
        } else {
            $this->data['error_warning'] = '';
        }
        $this->data['success'] = $this->session->data['success'];
        if ( isset( $this->session->data['success'] ) ) {
            unset( $this->session->data['success'] );
        }

        $this->document->initBreadcrumb( array(
            'href'      => $this->html->getSecureURL( 'index/home' ),
            'text'      => $this->language->get( 'text_home' ),
            'separator' => false
        ) );

        $this->document->addBreadcrumb( array(
            'href'      => $this->html->getSecureURL( 'extension/email_editor_updater' ),
            'text'      => $this->language->get( 'text_email_editor_updater_heading_title' ),
            'separator' => ' :: ',
            'current'   => true
        ) );

        $this->data ['action']        = $this->html->getSecureURL( 'extension/email_editor_updater', '&extension=email_editor_updater' );
        $this->data['cancel']         = $this->html->getSecureURL( 'extension/extensions' );
        $this->data ['heading_title'] = $this->language->get( 'text_email_editor_updater_heading_title' );
        $this->data ['form_title']    = $this->language->get( 'text_email_editor_updater_heading_title' );
        $this->data ['update']        = $this->html->getSecureURL( 'extension/email_editor_updater' );

        $form = new AForm ( 'HS' );
        $form->setForm( array(
            'form_name' => 'editFrm',
            'update'    => $this->data ['update']
        ) );

        $this->data['form']['form_open']                  = $form->getFieldHtml( array(
            'type'   => 'form',
            'name'   => 'editFrm',
            'action' => $this->data ['action'],
            'attr'   => 'data-confirm-exit="true" class="aform form-horizontal"'
        ) );
        $this->data['form']['submit']                     = $form->getFieldHtml( array(
            'type' => 'button',
            'name' => 'submit',
            'text' => $this->language->get( 'button_start_update' )
        ) );
        $this->data['form']['cancel']                     = $form->getFieldHtml( array(
            'type' => 'button',
            'name' => 'cancel',
            'text' => $this->language->get( 'button_cancel_update' )
        ) );

        $support = emailEditorVerifySupport();
        if ($support['notification_case'] === 'notification_license_ok') {
            $getVersions = emailEditorUpdaterGetAllVersions();
            $current_version = $this->model_extension_email_editor_updater->getCurrentVersion();

            $productVersion = '';
            if ($getVersions['notification_case'] !== 'notification_product_no_versions') {
                $versions = $getVersions['notification_data']['product_versions'];
                foreach ($versions as $version) {
                    if (version_compare($current_version, $version['version_number'], '<') === true && version_compare(VERSION, '1.2.17', '<') === true && version_compare($version['version_number'], '1.2.17', '<') === true
                        || version_compare($current_version, $version['version_number'], '<') && version_compare(VERSION, '1.2.17', '=') === true && version_compare($version['version_number'], '1.2.17', '>=') === true) {
                        $productVersion = $version['version_number'];
                    }
                }
            }

            if ($productVersion !== '') {
                $getLatestVersion = emailEditorUpdaterGetVersion($productVersion);
                if ($getVersions['notification_case'] !== 'notification_product_no_versions') {
                    $current_version = $this->model_extension_email_editor_updater->getCurrentVersion();
                    $version = $getLatestVersion['notification_data']['version_number'];
                    if (version_compare($current_version, $version) === -1) {
                        $this->data['changelog'] = $getLatestVersion['notification_data']['version_changelog'];
                        $this->data['text_changelog'] = $this->language->get('text_changelog');
                        $this->data['text_update_note'] = $this->language->get('text_update_email_editor_note');
                    }
                }
                $this->data['update'] = '1';
                $this->data['form']['cancel'] = $form->getFieldHtml(array(
                    'type' => 'button',
                    'name' => 'cancel',
                    'text' => $this->language->get('button_cancel_update')
                ));
            } else {
                $this->data['update'] = '0';
                $this->data['text_update_note'] = $this->language->get('text_no_updates');
                $this->data['form']['cancel'] = $form->getFieldHtml(array(
                    'type' => 'button',
                    'name' => 'cancel',
                    'text' => $this->language->get('button_go_back')
                ));
            }
        } else {
            $this->data['update'] = '0';
            $this->data['text_update_note'] = $this->language->get('text_no_updates');
            $this->data['form']['cancel'] = $form->getFieldHtml(array(
                'type' => 'button',
                'name' => 'cancel',
                'text' => $this->language->get('button_go_back')
            ));
        }

        $this->view->batchAssign($this->data);
        $this->processTemplate('pages/extension/email_editor_updater.tpl');
    }

    /**
     * Function to Copy folders and files
     * @param $src
     * @param $dst
     * @return bool
     */
    public function custom_copy($src, $dst) {
        // open the source directory
        $dir = opendir($src);
        if (!is_dir($dst)) {
            @mkdir($dst);
        }
        // Loop through the files in source directory
        foreach (scandir($src) as $file) {
            if (( $file != '.' ) && ( $file != '..' )) {
                if ($file==='upgrade.php') {
                    /** @noinspection PhpIncludeInspection */
                    include($src . '/' . $file);
                } elseif ($file==='upgrade.sql') {
                    $this->runUpdateQuery($src . '/' . $file);
                } else {
                    if (is_dir($src . '/' . $file)) {
                        // Recursively calling custom copy function
                        // for sub directory
                        $this->custom_copy($src . '/' . $file, $dst . '/' . $file);
                    } else {
                        if (!copy($src . '/' . $file, $dst . '/' . $file)) {
                            $this->error['error_copy'][] = "Failed to copy $file";
                        }
                    }
                }
            }
        }
        closedir($dir);
        if ($this->error) {
            return false;
        } else {
            return true;
        }
    }

    /**
     * Function to delete extracted folder and files
     * @param $src
     * @return bool
     */
    public function remove($src) {
        $files = array_diff(scandir($src), array('.', '..'));
        foreach ($files as $file) {
            (is_dir("$src/$file")) ? $this->remove("$src/$file") : unlink("$src/$file");
        }
        return rmdir($src);
    }

    /**
     * Function to execute sql files
     * @param $src
     * @return bool
     */
    public function runQuery($src) {
        $dir = opendir($src);

        // Loop through the files in source directory
        foreach (scandir($src) as $file) {
            if (file_exists($src."/".$file)) {
                if( ! $this->db->performSql($src."/".$file) ) {
                    $error= 'SQL-ERROR: "'.$this->db->error.'"';
                    $err = new AError($error);
                    $err->toLog()->toDebug();
                    $this->error['error_query'][] = "Failed to run query in $file";
                }
            }
        }
        closedir($dir);
        if ($this->error) {
            return false;
        } else {
            return true;
        }
    }

    /**
     * @param $file
     * @return bool
     */
    public function runUpdateQuery($file) {
        if (file_exists($file)) {
            if( ! $this->db->performSql($file) ) {
                $error= 'SQL-ERROR: "'.$this->db->error.'"';
                $err = new AError($error);
                $err->toLog()->toDebug();
                $this->error['error_query'][] = "Failed to run query in $file";
            }
        }
        if ($this->error) {
            return false;
        } else {
            return true;
        }
    }

    public function _validate() {
        if (!$this->user->canModify('extension/email_editor_updater')) {
            $this->response->setOutput( sprintf($this->language->get('error_permission_modify'), 'extension/email_editor_updater') );
            return null;
        } else {
            return true;
        }
    }
}