<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2022 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

class ModelExtensionEditorLicenseInfo extends Model {

    /**
     * @return mixed
     */
    public function getCurrentVersion() {
        $query = $this->db->query("SELECT version FROM ".$this->db->table("extensions")." WHERE `key`='editor'");
        return $query->row['version'];
    }
    
    /**
     * @param $data
     * @return void
     * @throws AException
     */
    public function saveLicenseData($data) {
        $this->deleteLicenseInfo($data['store_id']);
        $fields = ['public_key', 'license_data','license_key','store_id','last_check'];
        $insert = [];
        foreach ($fields as $f) {
            if (isset($data[$f])) {
                $insert[] = $f . " = '" . $data[$f] . "'";
            }
        }

        $this->db->query("INSERT INTO " . $this->db->table("editor_license_info") . " SET ".implode(',', $insert));
    }

    public function deleteLicenseInfo($store_id) {
        $this->db->query("DELETE FROM " . $this->db->table("editor_license_info"). " WHERE `store_id`='".$store_id."'");
    }

    /**
     * @return mixed
     * @throws AException
     */
    public function getLicenseData($store_id) {
        $query = $this->db->query("SELECT * FROM ".$this->db->table("editor_license_info")." WHERE `store_id`='".$store_id."'");
        return $query->row;
    }

    /**
     * @param $license_key
     * @return mixed
     * @throws AException
     */
    public function getInstalledLicense($license_key) {
        $query = $this->db->query("SELECT `store_id` FROM ".$this->db->table("editor_license_info")." WHERE `license_key`='".$license_key."'");
        return $query->row['store_id'];
    }

    /**
     * @param $group
     * @param $key
     * @return void
     * @throws AException
     */
    public function deleteSetting($group,$key) {
        $sql = "DELETE FROM ".$this->db->table("settings")." 
                    WHERE `group` = '".$this->db->escape($group)."'
                            AND `key` LIKE '%".$this->db->escape($key)."%'";
        $this->db->query($sql);
    }

    /**
     * @param $store_id
     * @return mixed
     * @throws AException
     */
    public function getLicenseCode($store_id) {
        $sql = "SELECT `value` FROM ".$this->db->table("settings")." 
                    WHERE `key` = 'editor_license_code'
                            AND `store_id` = '".$this->db->escape($store_id)."'";
        $query = $this->db->query($sql);
        return trim($query->row['value']);
    }

    /**
     * @return mixed|null
     */
    public function getStoreId() {
        $store_id = $this->config->get('config_store_id');
        return $store_id;
    }

    /**
     * @return mixed
     * @throws AException
     */
    public function getLicensedStoreStatus() {
        $store_id = $this->getStoreId();
        $query = $this->db->query("SELECT `value` FROM ".$this->db->table("settings")." WHERE `key`='editor_licensed_store_id_".$store_id."'");
        return $query->row['value'];
    }
}