<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2017 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

/**
 * Class ControllerResponsesListingGridEnhancedAdmin
 * @property ModelExtensionEnhancedAdmin $model_extension_enhanced_admin
 */
class ControllerResponsesListingGridEnhancedAdmin extends AController {
    private $error = array();
    public $data = array();

    public function main() {
        //init controller data
        $this->extensions->hk_InitData($this, __FUNCTION__);

        $this->loadLanguage('enhanced_admin/enhanced_admin');
        if (!$this->user->canAccess('extension/feed_viewer')) {
            $response = new stdClass ();
            $response->userdata->error = sprintf($this->language->get('error_permission_access'), 'extension/feed_viewer');
            $this->load->library('json');
            $this->response->setOutput(AJson::encode($response));
            return null;
        }

        $this->loadModel('extension/enhanced_admin');

        //Prepare filter config
        $grid_filter_params = array('title', 'date_created');
        $filter = new AFilter(array('method' => 'post', 'grid_filter_params' => $grid_filter_params));

        $total = $this->model_extension_enhanced_admin->getTotalFeeds();
        $response = new stdClass();
        $response->page = $filter->getParam('page');
        $response->total = $filter->calcTotalPages($total);
        $response->records = $total;
        $response->userdata = new stdClass();

        $sort_array = $filter->getFilterData();
        if ($sort_array['sort'] == 'sort_order') {
            $sort_array['sort'] = 'viewed';
        }
        $results = $this->model_extension_enhanced_admin->getFeeds($sort_array);

        $i = 0;
        foreach ($results as $result) {
            $response->rows [$i] ['id'] = $result ['id'];

            $response->userdata->classes[$result ['id']] .= !$result['viewed'] ? ' new_message' : '';

            $response->rows [$i] ['cell'] = array(
                $result ['title'],
                dateISO2Display($result ['date_created'], $this->language->get('date_format_short') . ' H:s'),
            );

            $i++;
        }

        //update controller data
        $this->extensions->hk_UpdateData($this, __FUNCTION__);

        $this->load->library('json');
        $this->response->setOutput(AJson::encode($response));

    }

    /**
     * @return mixed
     */
    public function update() {
        if (!$this->user->canModify('listing_grid/enhanced_admin')) {
            $error = new AError('');
            return $error->toJSONResponse('NO_PERMISSIONS_402',
                array('error_text' => sprintf($this->language->get('error_permission_modify'), 'listing_grid/message_grid'),
                    'reset_value' => true
                ));
        }

        //init controller data
        $this->extensions->hk_InitData($this, __FUNCTION__);

        $this->loadModel('extension/enhanced_admin');

       if ($this->request->get ['oper'] === 'show') {
            $id = $this->request->get ['id'];
            if ($id) {
                $this->data['feed'] = $this->model_extension_enhanced_admin->getFeed($id);

                if ($this->data['feed']) {
                    $this->loadLanguage('enhanced_admin/enhanced_admin');
                    $this->data['feed'] ['date_formatted'] = dateISO2Display($this->data['feed'] ['date_modified'], $this->language->get('date_format_short').' '.$this->language->get('time_format'));
                } else {
                    $this->data['feed'] ["description"] = $this->language->get('text_not_found');
                }
                $this->model_extension_enhanced_admin->markAsRead($id);
            }

            $this->view->assign('delete_url', $this->html->getSecureURL('listing_grid/enhanced_admin/update'));
            $this->view->assign('id', $id);
            $this->view->assign('readonly', $this->request->get['readonly']);
            $this->view->batchAssign($this->language->getASet('enhanced_admin/enhanced_admin'));
            $this->view->batchAssign($this->data);

            //update controller data
            $this->extensions->hk_UpdateData($this, __FUNCTION__);
            $this->processTemplate('responses/extension/feed_info.tpl');
        }
    }

    public function edit() {
        //init controller data
        $this->extensions->hk_InitData($this, __FUNCTION__);

        if (!$this->user->canModify('listing_grid/enhanced_admin')) {
            $error = new AError('');
            return $error->toJSONResponse('NO_PERMISSIONS_402',
                array( 'error_text' => sprintf($this->language->get('error_permission_modify'), 'listing_grid/enhanced_admin'),
                    'reset_value' => true
                ));
        }

        $this->loadModel('extension/enhanced_admin');
        $this->loadLanguage('extension/enhanced_admin');

        switch ($this->request->post[ 'oper' ]) {
            case 'del':
                $ids = explode(',', $this->request->post[ 'id' ]);
                if (!empty($ids))
                    foreach ($ids as $id) {
                        $this->model_extension_enhanced_admin->deleteFeed($id);
                    }
                break;
            default:
                //print_r($this->request->post);
        }

        //update controller data
        $this->extensions->hk_UpdateData($this, __FUNCTION__);
    }

    public function getNotifies() {

        //init controller data
        $this->extensions->hk_InitData($this, __FUNCTION__);
        $this->loadModel('extension/enhanced_admin');
        $this->loadLanguage('enhanced_admin/enhanced_admin');
        $this->data['shortlist'] = $this->model_extension_enhanced_admin->getRssFeed();
        $this->data['shortlist']['total_title'] = sprintf($this->language->get('text_notifies'),$this->data['shortlist']['total']);
        foreach($this->data['shortlist']['shortlist'] as &$m){
            $m['description'] = mb_substr($m['description'],0, 30).'...';
            $m['href']	= $this->html->getSecureURL ( 'listing_grid/enhanced_admin/update','&oper=show&readonly=1&id='.$m['id']);
        }

        //update controller data
        $this->extensions->hk_UpdateData($this, __FUNCTION__);

        $this->load->library('json');
        $this->response->addJSONHeader();
        $this->response->setOutput(AJson::encode($this->data['shortlist']));
    }
}